/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QaQuestionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_QA_SCORECARD_REVISION_QA_QUESTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String qaScorecard;
    private final String revision;
    private final String qaQuestion;

    @Deprecated
    protected QaQuestionName() {
        this.project = null;
        this.location = null;
        this.qaScorecard = null;
        this.revision = null;
        this.qaQuestion = null;
    }

    private QaQuestionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.qaScorecard = (String)Preconditions.checkNotNull((Object)builder.getQaScorecard());
        this.revision = (String)Preconditions.checkNotNull((Object)builder.getRevision());
        this.qaQuestion = (String)Preconditions.checkNotNull((Object)builder.getQaQuestion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQaScorecard() {
        return this.qaScorecard;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getQaQuestion() {
        return this.qaQuestion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QaQuestionName of(String project, String location, String qaScorecard, String revision, String qaQuestion) {
        return QaQuestionName.newBuilder().setProject(project).setLocation(location).setQaScorecard(qaScorecard).setRevision(revision).setQaQuestion(qaQuestion).build();
    }

    public static String format(String project, String location, String qaScorecard, String revision, String qaQuestion) {
        return QaQuestionName.newBuilder().setProject(project).setLocation(location).setQaScorecard(qaScorecard).setRevision(revision).setQaQuestion(qaQuestion).build().toString();
    }

    public static QaQuestionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_QA_SCORECARD_REVISION_QA_QUESTION.validatedMatch(formattedString, "QaQuestionName.parse: formattedString not in valid format");
        return QaQuestionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("qa_scorecard"), (String)matchMap.get("revision"), (String)matchMap.get("qa_question"));
    }

    public static List<QaQuestionName> parseList(List<String> formattedStrings) {
        ArrayList<QaQuestionName> list = new ArrayList<QaQuestionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QaQuestionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QaQuestionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QaQuestionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_QA_SCORECARD_REVISION_QA_QUESTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QaQuestionName qaQuestionName = this;
            synchronized (qaQuestionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.qaScorecard != null) {
                        fieldMapBuilder.put((Object)"qa_scorecard", (Object)this.qaScorecard);
                    }
                    if (this.revision != null) {
                        fieldMapBuilder.put((Object)"revision", (Object)this.revision);
                    }
                    if (this.qaQuestion != null) {
                        fieldMapBuilder.put((Object)"qa_question", (Object)this.qaQuestion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_QA_SCORECARD_REVISION_QA_QUESTION.instantiate(new String[]{"project", this.project, "location", this.location, "qa_scorecard", this.qaScorecard, "revision", this.revision, "qa_question", this.qaQuestion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QaQuestionName that = (QaQuestionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.qaScorecard, that.qaScorecard) && Objects.equals(this.revision, that.revision) && Objects.equals(this.qaQuestion, that.qaQuestion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.qaScorecard);
        h *= 1000003;
        h ^= Objects.hashCode(this.revision);
        h *= 1000003;
        return h ^= Objects.hashCode(this.qaQuestion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String qaScorecard;
        private String revision;
        private String qaQuestion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQaScorecard() {
            return this.qaScorecard;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getQaQuestion() {
            return this.qaQuestion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQaScorecard(String qaScorecard) {
            this.qaScorecard = qaScorecard;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public Builder setQaQuestion(String qaQuestion) {
            this.qaQuestion = qaQuestion;
            return this;
        }

        private Builder(QaQuestionName qaQuestionName) {
            this.project = qaQuestionName.project;
            this.location = qaQuestionName.location;
            this.qaScorecard = qaQuestionName.qaScorecard;
            this.revision = qaQuestionName.revision;
            this.qaQuestion = qaQuestionName.qaQuestion;
        }

        public QaQuestionName build() {
            return new QaQuestionName(this);
        }
    }
}

