/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnalysisName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_ANALYSIS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}");
    private static final PathTemplate PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_ANALYSIS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_set}/authorizedViews/{authorized_view}/conversations/{conversation}/analyses/{analysis}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String conversation;
    private final String analysis;
    private final String authorizedViewSet;
    private final String authorizedView;

    @Deprecated
    protected AnalysisName() {
        this.project = null;
        this.location = null;
        this.conversation = null;
        this.analysis = null;
        this.authorizedViewSet = null;
        this.authorizedView = null;
    }

    private AnalysisName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.analysis = (String)Preconditions.checkNotNull((Object)builder.getAnalysis());
        this.authorizedViewSet = null;
        this.authorizedView = null;
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_ANALYSIS;
    }

    private AnalysisName(ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.authorizedViewSet = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedViewSet());
        this.authorizedView = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedView());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.analysis = (String)Preconditions.checkNotNull((Object)builder.getAnalysis());
        this.pathTemplate = PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_ANALYSIS;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getAnalysis() {
        return this.analysis;
    }

    public String getAuthorizedViewSet() {
        return this.authorizedViewSet;
    }

    public String getAuthorizedView() {
        return this.authorizedView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationConversationAnalysisBuilder() {
        return new Builder();
    }

    public static ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder newProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder() {
        return new ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnalysisName of(String project, String location, String conversation, String analysis) {
        return AnalysisName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setAnalysis(analysis).build();
    }

    public static AnalysisName ofProjectLocationConversationAnalysisName(String project, String location, String conversation, String analysis) {
        return AnalysisName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setAnalysis(analysis).build();
    }

    public static AnalysisName ofProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisName(String project, String location, String authorizedViewSet, String authorizedView, String conversation, String analysis) {
        return AnalysisName.newProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder().setProject(project).setLocation(location).setAuthorizedViewSet(authorizedViewSet).setAuthorizedView(authorizedView).setConversation(conversation).setAnalysis(analysis).build();
    }

    public static String format(String project, String location, String conversation, String analysis) {
        return AnalysisName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setAnalysis(analysis).build().toString();
    }

    public static String formatProjectLocationConversationAnalysisName(String project, String location, String conversation, String analysis) {
        return AnalysisName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setAnalysis(analysis).build().toString();
    }

    public static String formatProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisName(String project, String location, String authorizedViewSet, String authorizedView, String conversation, String analysis) {
        return AnalysisName.newProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder().setProject(project).setLocation(location).setAuthorizedViewSet(authorizedViewSet).setAuthorizedView(authorizedView).setConversation(conversation).setAnalysis(analysis).build().toString();
    }

    public static AnalysisName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_CONVERSATION_ANALYSIS.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_ANALYSIS.match(formattedString);
            return AnalysisName.ofProjectLocationConversationAnalysisName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"), (String)matchMap.get("analysis"));
        }
        if (PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_ANALYSIS.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_ANALYSIS.match(formattedString);
            return AnalysisName.ofProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("authorized_view_set"), (String)matchMap.get("authorized_view"), (String)matchMap.get("conversation"), (String)matchMap.get("analysis"));
        }
        throw new ValidationException("AnalysisName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AnalysisName> parseList(List<String> formattedStrings) {
        ArrayList<AnalysisName> list = new ArrayList<AnalysisName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnalysisName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnalysisName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnalysisName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION_ANALYSIS.matches(formattedString) || PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_ANALYSIS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnalysisName analysisName = this;
            synchronized (analysisName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.analysis != null) {
                        fieldMapBuilder.put((Object)"analysis", (Object)this.analysis);
                    }
                    if (this.authorizedViewSet != null) {
                        fieldMapBuilder.put((Object)"authorized_view_set", (Object)this.authorizedViewSet);
                    }
                    if (this.authorizedView != null) {
                        fieldMapBuilder.put((Object)"authorized_view", (Object)this.authorizedView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnalysisName that = (AnalysisName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.analysis, that.analysis) && Objects.equals(this.authorizedViewSet, that.authorizedViewSet) && Objects.equals(this.authorizedView, that.authorizedView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        h ^= Objects.hashCode(this.analysis);
        h *= 1000003;
        h ^= Objects.hashCode(this.authorizedViewSet);
        h *= 1000003;
        return h ^= Objects.hashCode(this.authorizedView);
    }

    public static class ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder {
        private String project;
        private String location;
        private String authorizedViewSet;
        private String authorizedView;
        private String conversation;
        private String analysis;

        protected ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAuthorizedViewSet() {
            return this.authorizedViewSet;
        }

        public String getAuthorizedView() {
            return this.authorizedView;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getAnalysis() {
            return this.analysis;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder setAuthorizedViewSet(String authorizedViewSet) {
            this.authorizedViewSet = authorizedViewSet;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder setAuthorizedView(String authorizedView) {
            this.authorizedView = authorizedView;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationAnalysisBuilder setAnalysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        public AnalysisName build() {
            return new AnalysisName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversation;
        private String analysis;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getAnalysis() {
            return this.analysis;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public Builder setAnalysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        private Builder(AnalysisName analysisName) {
            Preconditions.checkArgument((boolean)Objects.equals(analysisName.pathTemplate, PROJECT_LOCATION_CONVERSATION_ANALYSIS), (Object)"toBuilder is only supported when AnalysisName has the pattern of projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}");
            this.project = analysisName.project;
            this.location = analysisName.location;
            this.conversation = analysisName.conversation;
            this.analysis = analysisName.analysis;
        }

        public AnalysisName build() {
            return new AnalysisName(this);
        }
    }
}

