/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}");
    private static final PathTemplate PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_set}/authorizedViews/{authorized_view}/conversations/{conversation}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String conversation;
    private final String authorizedViewSet;
    private final String authorizedView;

    @Deprecated
    protected ConversationName() {
        this.project = null;
        this.location = null;
        this.conversation = null;
        this.authorizedViewSet = null;
        this.authorizedView = null;
    }

    private ConversationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.authorizedViewSet = null;
        this.authorizedView = null;
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION;
    }

    private ConversationName(ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.authorizedViewSet = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedViewSet());
        this.authorizedView = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedView());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.pathTemplate = PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getAuthorizedViewSet() {
        return this.authorizedViewSet;
    }

    public String getAuthorizedView() {
        return this.authorizedView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationConversationBuilder() {
        return new Builder();
    }

    public static ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder newProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder() {
        return new ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationName of(String project, String location, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).build();
    }

    public static ConversationName ofProjectLocationConversationName(String project, String location, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).build();
    }

    public static ConversationName ofProjectLocationAuthorizedViewSetAuthorizedViewConversationName(String project, String location, String authorizedViewSet, String authorizedView, String conversation) {
        return ConversationName.newProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder().setProject(project).setLocation(location).setAuthorizedViewSet(authorizedViewSet).setAuthorizedView(authorizedView).setConversation(conversation).build();
    }

    public static String format(String project, String location, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).build().toString();
    }

    public static String formatProjectLocationConversationName(String project, String location, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).build().toString();
    }

    public static String formatProjectLocationAuthorizedViewSetAuthorizedViewConversationName(String project, String location, String authorizedViewSet, String authorizedView, String conversation) {
        return ConversationName.newProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder().setProject(project).setLocation(location).setAuthorizedViewSet(authorizedViewSet).setAuthorizedView(authorizedView).setConversation(conversation).build().toString();
    }

    public static ConversationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_CONVERSATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION.match(formattedString);
            return ConversationName.ofProjectLocationConversationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"));
        }
        if (PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION.match(formattedString);
            return ConversationName.ofProjectLocationAuthorizedViewSetAuthorizedViewConversationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("authorized_view_set"), (String)matchMap.get("authorized_view"), (String)matchMap.get("conversation"));
        }
        throw new ValidationException("ConversationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConversationName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationName> list = new ArrayList<ConversationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION.matches(formattedString) || PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationName conversationName = this;
            synchronized (conversationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.authorizedViewSet != null) {
                        fieldMapBuilder.put((Object)"authorized_view_set", (Object)this.authorizedViewSet);
                    }
                    if (this.authorizedView != null) {
                        fieldMapBuilder.put((Object)"authorized_view", (Object)this.authorizedView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversationName that = (ConversationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.authorizedViewSet, that.authorizedViewSet) && Objects.equals(this.authorizedView, that.authorizedView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        h ^= Objects.hashCode(this.authorizedViewSet);
        h *= 1000003;
        return h ^= Objects.hashCode(this.authorizedView);
    }

    public static class ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder {
        private String project;
        private String location;
        private String authorizedViewSet;
        private String authorizedView;
        private String conversation;

        protected ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAuthorizedViewSet() {
            return this.authorizedViewSet;
        }

        public String getAuthorizedView() {
            return this.authorizedView;
        }

        public String getConversation() {
            return this.conversation;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder setAuthorizedViewSet(String authorizedViewSet) {
            this.authorizedViewSet = authorizedViewSet;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder setAuthorizedView(String authorizedView) {
            this.authorizedView = authorizedView;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        private Builder(ConversationName conversationName) {
            Preconditions.checkArgument((boolean)Objects.equals(conversationName.pathTemplate, PROJECT_LOCATION_CONVERSATION), (Object)"toBuilder is only supported when ConversationName has the pattern of projects/{project}/locations/{location}/conversations/{conversation}");
            this.project = conversationName.project;
            this.location = conversationName.location;
            this.conversation = conversationName.conversation;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }
}

