/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * Configuration of etcd encryption.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.DatabaseEncryption}
 */
public final class DatabaseEncryption extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.DatabaseEncryption)
    DatabaseEncryptionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DatabaseEncryption.newBuilder() to construct.
  private DatabaseEncryption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DatabaseEncryption() {
    keyName_ = "";
    state_ = 0;
    currentState_ = 0;
    decryptionKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    lastOperationErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DatabaseEncryption();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_DatabaseEncryption_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_DatabaseEncryption_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.DatabaseEncryption.class,
            com.google.container.v1.DatabaseEncryption.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of etcd encryption.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.DatabaseEncryption.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should never be set
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Secrets in etcd are encrypted.
     * </pre>
     *
     * <code>ENCRYPTED = 1;</code>
     */
    ENCRYPTED(1),
    /**
     *
     *
     * <pre>
     * Secrets in etcd are stored in plain text (at etcd level) - this is
     * unrelated to Compute Engine level full disk encryption.
     * </pre>
     *
     * <code>DECRYPTED = 2;</code>
     */
    DECRYPTED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should never be set
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Secrets in etcd are encrypted.
     * </pre>
     *
     * <code>ENCRYPTED = 1;</code>
     */
    public static final int ENCRYPTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Secrets in etcd are stored in plain text (at etcd level) - this is
     * unrelated to Compute Engine level full disk encryption.
     * </pre>
     *
     * <code>DECRYPTED = 2;</code>
     */
    public static final int DECRYPTED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return ENCRYPTED;
        case 2:
          return DECRYPTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.DatabaseEncryption.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.DatabaseEncryption.State)
  }

  /**
   *
   *
   * <pre>
   * Current State of etcd encryption.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.DatabaseEncryption.CurrentState}
   */
  public enum CurrentState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should never be set
     * </pre>
     *
     * <code>CURRENT_STATE_UNSPECIFIED = 0;</code>
     */
    CURRENT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Secrets in etcd are encrypted.
     * </pre>
     *
     * <code>CURRENT_STATE_ENCRYPTED = 7;</code>
     */
    CURRENT_STATE_ENCRYPTED(7),
    /**
     *
     *
     * <pre>
     * Secrets in etcd are stored in plain text (at etcd level) - this is
     * unrelated to Compute Engine level full disk encryption.
     * </pre>
     *
     * <code>CURRENT_STATE_DECRYPTED = 2;</code>
     */
    CURRENT_STATE_DECRYPTED(2),
    /**
     *
     *
     * <pre>
     * Encryption (or re-encryption with a different CloudKMS key)
     * of Secrets is in progress.
     * </pre>
     *
     * <code>CURRENT_STATE_ENCRYPTION_PENDING = 3;</code>
     */
    CURRENT_STATE_ENCRYPTION_PENDING(3),
    /**
     *
     *
     * <pre>
     * Encryption (or re-encryption with a different CloudKMS key) of Secrets in
     * etcd encountered an error.
     * </pre>
     *
     * <code>CURRENT_STATE_ENCRYPTION_ERROR = 4;</code>
     */
    CURRENT_STATE_ENCRYPTION_ERROR(4),
    /**
     *
     *
     * <pre>
     * De-crypting Secrets to plain text in etcd is in progress.
     * </pre>
     *
     * <code>CURRENT_STATE_DECRYPTION_PENDING = 5;</code>
     */
    CURRENT_STATE_DECRYPTION_PENDING(5),
    /**
     *
     *
     * <pre>
     * De-crypting Secrets to plain text in etcd encountered an error.
     * </pre>
     *
     * <code>CURRENT_STATE_DECRYPTION_ERROR = 6;</code>
     */
    CURRENT_STATE_DECRYPTION_ERROR(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should never be set
     * </pre>
     *
     * <code>CURRENT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int CURRENT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Secrets in etcd are encrypted.
     * </pre>
     *
     * <code>CURRENT_STATE_ENCRYPTED = 7;</code>
     */
    public static final int CURRENT_STATE_ENCRYPTED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Secrets in etcd are stored in plain text (at etcd level) - this is
     * unrelated to Compute Engine level full disk encryption.
     * </pre>
     *
     * <code>CURRENT_STATE_DECRYPTED = 2;</code>
     */
    public static final int CURRENT_STATE_DECRYPTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Encryption (or re-encryption with a different CloudKMS key)
     * of Secrets is in progress.
     * </pre>
     *
     * <code>CURRENT_STATE_ENCRYPTION_PENDING = 3;</code>
     */
    public static final int CURRENT_STATE_ENCRYPTION_PENDING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Encryption (or re-encryption with a different CloudKMS key) of Secrets in
     * etcd encountered an error.
     * </pre>
     *
     * <code>CURRENT_STATE_ENCRYPTION_ERROR = 4;</code>
     */
    public static final int CURRENT_STATE_ENCRYPTION_ERROR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * De-crypting Secrets to plain text in etcd is in progress.
     * </pre>
     *
     * <code>CURRENT_STATE_DECRYPTION_PENDING = 5;</code>
     */
    public static final int CURRENT_STATE_DECRYPTION_PENDING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * De-crypting Secrets to plain text in etcd encountered an error.
     * </pre>
     *
     * <code>CURRENT_STATE_DECRYPTION_ERROR = 6;</code>
     */
    public static final int CURRENT_STATE_DECRYPTION_ERROR_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CurrentState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CurrentState forNumber(int value) {
      switch (value) {
        case 0:
          return CURRENT_STATE_UNSPECIFIED;
        case 7:
          return CURRENT_STATE_ENCRYPTED;
        case 2:
          return CURRENT_STATE_DECRYPTED;
        case 3:
          return CURRENT_STATE_ENCRYPTION_PENDING;
        case 4:
          return CURRENT_STATE_ENCRYPTION_ERROR;
        case 5:
          return CURRENT_STATE_DECRYPTION_PENDING;
        case 6:
          return CURRENT_STATE_DECRYPTION_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CurrentState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CurrentState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CurrentState>() {
          public CurrentState findValueByNumber(int number) {
            return CurrentState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.DatabaseEncryption.getDescriptor().getEnumTypes().get(1);
    }

    private static final CurrentState[] VALUES = values();

    public static CurrentState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CurrentState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.DatabaseEncryption.CurrentState)
  }

  public interface OperationErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.DatabaseEncryption.OperationError)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * CloudKMS key resource that had the error.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The keyName.
     */
    java.lang.String getKeyName();
    /**
     *
     *
     * <pre>
     * CloudKMS key resource that had the error.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The bytes for keyName.
     */
    com.google.protobuf.ByteString getKeyNameBytes();

    /**
     *
     *
     * <pre>
     * Description of the error seen during the operation.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     *
     *
     * <pre>
     * Description of the error seen during the operation.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString getErrorMessageBytes();

    /**
     *
     *
     * <pre>
     * Time when the CloudKMS error was seen.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 3;</code>
     *
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();
    /**
     *
     *
     * <pre>
     * Time when the CloudKMS error was seen.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 3;</code>
     *
     * @return The timestamp.
     */
    com.google.protobuf.Timestamp getTimestamp();
    /**
     *
     *
     * <pre>
     * Time when the CloudKMS error was seen.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 3;</code>
     */
    com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * OperationError records errors seen from CloudKMS keys
   * encountered during updates to DatabaseEncryption configuration.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.DatabaseEncryption.OperationError}
   */
  public static final class OperationError extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.DatabaseEncryption.OperationError)
      OperationErrorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OperationError.newBuilder() to construct.
    private OperationError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OperationError() {
      keyName_ = "";
      errorMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OperationError();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_DatabaseEncryption_OperationError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_DatabaseEncryption_OperationError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.DatabaseEncryption.OperationError.class,
              com.google.container.v1.DatabaseEncryption.OperationError.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object keyName_ = "";
    /**
     *
     *
     * <pre>
     * CloudKMS key resource that had the error.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The keyName.
     */
    @java.lang.Override
    public java.lang.String getKeyName() {
      java.lang.Object ref = keyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * CloudKMS key resource that had the error.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The bytes for keyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyNameBytes() {
      java.lang.Object ref = keyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Description of the error seen during the operation.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the error seen during the operation.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp timestamp_;
    /**
     *
     *
     * <pre>
     * Time when the CloudKMS error was seen.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 3;</code>
     *
     * @return Whether the timestamp field is set.
     */
    @java.lang.Override
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the CloudKMS error was seen.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 3;</code>
     *
     * @return The timestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTimestamp() {
      return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
    }
    /**
     *
     *
     * <pre>
     * Time when the CloudKMS error was seen.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, keyName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getTimestamp());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, keyName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimestamp());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.DatabaseEncryption.OperationError)) {
        return super.equals(obj);
      }
      com.google.container.v1.DatabaseEncryption.OperationError other =
          (com.google.container.v1.DatabaseEncryption.OperationError) obj;

      if (!getKeyName().equals(other.getKeyName())) return false;
      if (!getErrorMessage().equals(other.getErrorMessage())) return false;
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (!getTimestamp().equals(other.getTimestamp())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getKeyName().hashCode();
      hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorMessage().hashCode();
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getTimestamp().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.DatabaseEncryption.OperationError prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * OperationError records errors seen from CloudKMS keys
     * encountered during updates to DatabaseEncryption configuration.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.DatabaseEncryption.OperationError}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.DatabaseEncryption.OperationError)
        com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_DatabaseEncryption_OperationError_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_DatabaseEncryption_OperationError_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.DatabaseEncryption.OperationError.class,
                com.google.container.v1.DatabaseEncryption.OperationError.Builder.class);
      }

      // Construct using com.google.container.v1.DatabaseEncryption.OperationError.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTimestampFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keyName_ = "";
        errorMessage_ = "";
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_DatabaseEncryption_OperationError_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.DatabaseEncryption.OperationError getDefaultInstanceForType() {
        return com.google.container.v1.DatabaseEncryption.OperationError.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.DatabaseEncryption.OperationError build() {
        com.google.container.v1.DatabaseEncryption.OperationError result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.DatabaseEncryption.OperationError buildPartial() {
        com.google.container.v1.DatabaseEncryption.OperationError result =
            new com.google.container.v1.DatabaseEncryption.OperationError(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1.DatabaseEncryption.OperationError result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keyName_ = keyName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.errorMessage_ = errorMessage_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timestamp_ = timestampBuilder_ == null ? timestamp_ : timestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.DatabaseEncryption.OperationError) {
          return mergeFrom((com.google.container.v1.DatabaseEncryption.OperationError) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1.DatabaseEncryption.OperationError other) {
        if (other == com.google.container.v1.DatabaseEncryption.OperationError.getDefaultInstance())
          return this;
        if (!other.getKeyName().isEmpty()) {
          keyName_ = other.keyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getErrorMessage().isEmpty()) {
          errorMessage_ = other.errorMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasTimestamp()) {
          mergeTimestamp(other.getTimestamp());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  keyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  errorMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object keyName_ = "";
      /**
       *
       *
       * <pre>
       * CloudKMS key resource that had the error.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @return The keyName.
       */
      public java.lang.String getKeyName() {
        java.lang.Object ref = keyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          keyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * CloudKMS key resource that had the error.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @return The bytes for keyName.
       */
      public com.google.protobuf.ByteString getKeyNameBytes() {
        java.lang.Object ref = keyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          keyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * CloudKMS key resource that had the error.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @param value The keyName to set.
       * @return This builder for chaining.
       */
      public Builder setKeyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        keyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CloudKMS key resource that had the error.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKeyName() {
        keyName_ = getDefaultInstance().getKeyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CloudKMS key resource that had the error.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @param value The bytes for keyName to set.
       * @return This builder for chaining.
       */
      public Builder setKeyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        keyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       *
       *
       * <pre>
       * Description of the error seen during the operation.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the error seen during the operation.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the error seen during the operation.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the error seen during the operation.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        errorMessage_ = getDefaultInstance().getErrorMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description of the error seen during the operation.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp timestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          timestampBuilder_;
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       *
       * @return Whether the timestamp field is set.
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       *
       * @return The timestamp.
       */
      public com.google.protobuf.Timestamp getTimestamp() {
        if (timestampBuilder_ == null) {
          return timestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : timestamp_;
        } else {
          return timestampBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      public Builder setTimestamp(com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestamp_ = value;
        } else {
          timestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      public Builder setTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (timestampBuilder_ == null) {
          timestamp_ = builderForValue.build();
        } else {
          timestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      public Builder mergeTimestamp(com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timestamp_ != null
              && timestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getTimestampBuilder().mergeFrom(value);
          } else {
            timestamp_ = value;
          }
        } else {
          timestampBuilder_.mergeFrom(value);
        }
        if (timestamp_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      public com.google.protobuf.Timestamp.Builder getTimestampBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimestampFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
        if (timestampBuilder_ != null) {
          return timestampBuilder_.getMessageOrBuilder();
        } else {
          return timestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : timestamp_;
        }
      }
      /**
       *
       *
       * <pre>
       * Time when the CloudKMS error was seen.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTimestampFieldBuilder() {
        if (timestampBuilder_ == null) {
          timestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTimestamp(), getParentForChildren(), isClean());
          timestamp_ = null;
        }
        return timestampBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.DatabaseEncryption.OperationError)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.DatabaseEncryption.OperationError)
    private static final com.google.container.v1.DatabaseEncryption.OperationError DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.DatabaseEncryption.OperationError();
    }

    public static com.google.container.v1.DatabaseEncryption.OperationError getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OperationError> PARSER =
        new com.google.protobuf.AbstractParser<OperationError>() {
          @java.lang.Override
          public OperationError parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OperationError> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OperationError> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.DatabaseEncryption.OperationError getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int KEY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyName_ = "";
  /**
   *
   *
   * <pre>
   * Name of CloudKMS key to use for the encryption of secrets in etcd.
   * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
   * </pre>
   *
   * <code>string key_name = 1;</code>
   *
   * @return The keyName.
   */
  @java.lang.Override
  public java.lang.String getKeyName() {
    java.lang.Object ref = keyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of CloudKMS key to use for the encryption of secrets in etcd.
   * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
   * </pre>
   *
   * <code>string key_name = 1;</code>
   *
   * @return The bytes for keyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyNameBytes() {
    java.lang.Object ref = keyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The desired state of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The desired state of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.container.v1.DatabaseEncryption.State getState() {
    com.google.container.v1.DatabaseEncryption.State result =
        com.google.container.v1.DatabaseEncryption.State.forNumber(state_);
    return result == null ? com.google.container.v1.DatabaseEncryption.State.UNRECOGNIZED : result;
  }

  public static final int CURRENT_STATE_FIELD_NUMBER = 3;
  private int currentState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of etcd encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the currentState field is set.
   */
  @java.lang.Override
  public boolean hasCurrentState() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of etcd encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for currentState.
   */
  @java.lang.Override
  public int getCurrentStateValue() {
    return currentState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of etcd encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The currentState.
   */
  @java.lang.Override
  public com.google.container.v1.DatabaseEncryption.CurrentState getCurrentState() {
    com.google.container.v1.DatabaseEncryption.CurrentState result =
        com.google.container.v1.DatabaseEncryption.CurrentState.forNumber(currentState_);
    return result == null
        ? com.google.container.v1.DatabaseEncryption.CurrentState.UNRECOGNIZED
        : result;
  }

  public static final int DECRYPTION_KEYS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList decryptionKeys_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Keys in use by the cluster for decrypting
   * existing objects, in addition to the key in `key_name`.
   *
   * Each item is a CloudKMS key resource.
   * </pre>
   *
   * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the decryptionKeys.
   */
  public com.google.protobuf.ProtocolStringList getDecryptionKeysList() {
    return decryptionKeys_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Keys in use by the cluster for decrypting
   * existing objects, in addition to the key in `key_name`.
   *
   * Each item is a CloudKMS key resource.
   * </pre>
   *
   * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of decryptionKeys.
   */
  public int getDecryptionKeysCount() {
    return decryptionKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Keys in use by the cluster for decrypting
   * existing objects, in addition to the key in `key_name`.
   *
   * Each item is a CloudKMS key resource.
   * </pre>
   *
   * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The decryptionKeys at the given index.
   */
  public java.lang.String getDecryptionKeys(int index) {
    return decryptionKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Keys in use by the cluster for decrypting
   * existing objects, in addition to the key in `key_name`.
   *
   * Each item is a CloudKMS key resource.
   * </pre>
   *
   * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the decryptionKeys at the given index.
   */
  public com.google.protobuf.ByteString getDecryptionKeysBytes(int index) {
    return decryptionKeys_.getByteString(index);
  }

  public static final int LAST_OPERATION_ERRORS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.DatabaseEncryption.OperationError>
      lastOperationErrors_;
  /**
   *
   *
   * <pre>
   * Output only. Records errors seen during DatabaseEncryption update
   * operations.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.DatabaseEncryption.OperationError>
      getLastOperationErrorsList() {
    return lastOperationErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Records errors seen during DatabaseEncryption update
   * operations.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder>
      getLastOperationErrorsOrBuilderList() {
    return lastOperationErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Records errors seen during DatabaseEncryption update
   * operations.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getLastOperationErrorsCount() {
    return lastOperationErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Records errors seen during DatabaseEncryption update
   * operations.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.DatabaseEncryption.OperationError getLastOperationErrors(
      int index) {
    return lastOperationErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Records errors seen during DatabaseEncryption update
   * operations.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder
      getLastOperationErrorsOrBuilder(int index) {
    return lastOperationErrors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, keyName_);
    }
    if (state_ != com.google.container.v1.DatabaseEncryption.State.UNKNOWN.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(3, currentState_);
    }
    for (int i = 0; i < decryptionKeys_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, decryptionKeys_.getRaw(i));
    }
    for (int i = 0; i < lastOperationErrors_.size(); i++) {
      output.writeMessage(5, lastOperationErrors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, keyName_);
    }
    if (state_ != com.google.container.v1.DatabaseEncryption.State.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, currentState_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < decryptionKeys_.size(); i++) {
        dataSize += computeStringSizeNoTag(decryptionKeys_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDecryptionKeysList().size();
    }
    for (int i = 0; i < lastOperationErrors_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, lastOperationErrors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.DatabaseEncryption)) {
      return super.equals(obj);
    }
    com.google.container.v1.DatabaseEncryption other =
        (com.google.container.v1.DatabaseEncryption) obj;

    if (!getKeyName().equals(other.getKeyName())) return false;
    if (state_ != other.state_) return false;
    if (hasCurrentState() != other.hasCurrentState()) return false;
    if (hasCurrentState()) {
      if (currentState_ != other.currentState_) return false;
    }
    if (!getDecryptionKeysList().equals(other.getDecryptionKeysList())) return false;
    if (!getLastOperationErrorsList().equals(other.getLastOperationErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKeyName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCurrentState()) {
      hash = (37 * hash) + CURRENT_STATE_FIELD_NUMBER;
      hash = (53 * hash) + currentState_;
    }
    if (getDecryptionKeysCount() > 0) {
      hash = (37 * hash) + DECRYPTION_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getDecryptionKeysList().hashCode();
    }
    if (getLastOperationErrorsCount() > 0) {
      hash = (37 * hash) + LAST_OPERATION_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getLastOperationErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.DatabaseEncryption parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.DatabaseEncryption parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.DatabaseEncryption parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.DatabaseEncryption prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.DatabaseEncryption}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.DatabaseEncryption)
      com.google.container.v1.DatabaseEncryptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_DatabaseEncryption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_DatabaseEncryption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.DatabaseEncryption.class,
              com.google.container.v1.DatabaseEncryption.Builder.class);
    }

    // Construct using com.google.container.v1.DatabaseEncryption.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      keyName_ = "";
      state_ = 0;
      currentState_ = 0;
      decryptionKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (lastOperationErrorsBuilder_ == null) {
        lastOperationErrors_ = java.util.Collections.emptyList();
      } else {
        lastOperationErrors_ = null;
        lastOperationErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_DatabaseEncryption_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.DatabaseEncryption getDefaultInstanceForType() {
      return com.google.container.v1.DatabaseEncryption.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.DatabaseEncryption build() {
      com.google.container.v1.DatabaseEncryption result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.DatabaseEncryption buildPartial() {
      com.google.container.v1.DatabaseEncryption result =
          new com.google.container.v1.DatabaseEncryption(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.DatabaseEncryption result) {
      if (lastOperationErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          lastOperationErrors_ = java.util.Collections.unmodifiableList(lastOperationErrors_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.lastOperationErrors_ = lastOperationErrors_;
      } else {
        result.lastOperationErrors_ = lastOperationErrorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.DatabaseEncryption result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.keyName_ = keyName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.currentState_ = currentState_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        decryptionKeys_.makeImmutable();
        result.decryptionKeys_ = decryptionKeys_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.DatabaseEncryption) {
        return mergeFrom((com.google.container.v1.DatabaseEncryption) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.DatabaseEncryption other) {
      if (other == com.google.container.v1.DatabaseEncryption.getDefaultInstance()) return this;
      if (!other.getKeyName().isEmpty()) {
        keyName_ = other.keyName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCurrentState()) {
        setCurrentState(other.getCurrentState());
      }
      if (!other.decryptionKeys_.isEmpty()) {
        if (decryptionKeys_.isEmpty()) {
          decryptionKeys_ = other.decryptionKeys_;
          bitField0_ |= 0x00000008;
        } else {
          ensureDecryptionKeysIsMutable();
          decryptionKeys_.addAll(other.decryptionKeys_);
        }
        onChanged();
      }
      if (lastOperationErrorsBuilder_ == null) {
        if (!other.lastOperationErrors_.isEmpty()) {
          if (lastOperationErrors_.isEmpty()) {
            lastOperationErrors_ = other.lastOperationErrors_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureLastOperationErrorsIsMutable();
            lastOperationErrors_.addAll(other.lastOperationErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.lastOperationErrors_.isEmpty()) {
          if (lastOperationErrorsBuilder_.isEmpty()) {
            lastOperationErrorsBuilder_.dispose();
            lastOperationErrorsBuilder_ = null;
            lastOperationErrors_ = other.lastOperationErrors_;
            bitField0_ = (bitField0_ & ~0x00000010);
            lastOperationErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLastOperationErrorsFieldBuilder()
                    : null;
          } else {
            lastOperationErrorsBuilder_.addAllMessages(other.lastOperationErrors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                keyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                currentState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDecryptionKeysIsMutable();
                decryptionKeys_.add(s);
                break;
              } // case 34
            case 42:
              {
                com.google.container.v1.DatabaseEncryption.OperationError m =
                    input.readMessage(
                        com.google.container.v1.DatabaseEncryption.OperationError.parser(),
                        extensionRegistry);
                if (lastOperationErrorsBuilder_ == null) {
                  ensureLastOperationErrorsIsMutable();
                  lastOperationErrors_.add(m);
                } else {
                  lastOperationErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object keyName_ = "";
    /**
     *
     *
     * <pre>
     * Name of CloudKMS key to use for the encryption of secrets in etcd.
     * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The keyName.
     */
    public java.lang.String getKeyName() {
      java.lang.Object ref = keyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of CloudKMS key to use for the encryption of secrets in etcd.
     * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The bytes for keyName.
     */
    public com.google.protobuf.ByteString getKeyNameBytes() {
      java.lang.Object ref = keyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of CloudKMS key to use for the encryption of secrets in etcd.
     * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @param value The keyName to set.
     * @return This builder for chaining.
     */
    public Builder setKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of CloudKMS key to use for the encryption of secrets in etcd.
     * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyName() {
      keyName_ = getDefaultInstance().getKeyName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of CloudKMS key to use for the encryption of secrets in etcd.
     * Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @param value The bytes for keyName to set.
     * @return This builder for chaining.
     */
    public Builder setKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The desired state of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The desired state of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.container.v1.DatabaseEncryption.State getState() {
      com.google.container.v1.DatabaseEncryption.State result =
          com.google.container.v1.DatabaseEncryption.State.forNumber(state_);
      return result == null
          ? com.google.container.v1.DatabaseEncryption.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The desired state of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.container.v1.DatabaseEncryption.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private int currentState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of etcd encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the currentState field is set.
     */
    @java.lang.Override
    public boolean hasCurrentState() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of etcd encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for currentState.
     */
    @java.lang.Override
    public int getCurrentStateValue() {
      return currentState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of etcd encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for currentState to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentStateValue(int value) {
      currentState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of etcd encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The currentState.
     */
    @java.lang.Override
    public com.google.container.v1.DatabaseEncryption.CurrentState getCurrentState() {
      com.google.container.v1.DatabaseEncryption.CurrentState result =
          com.google.container.v1.DatabaseEncryption.CurrentState.forNumber(currentState_);
      return result == null
          ? com.google.container.v1.DatabaseEncryption.CurrentState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of etcd encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The currentState to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentState(com.google.container.v1.DatabaseEncryption.CurrentState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      currentState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of etcd encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.DatabaseEncryption.CurrentState current_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      currentState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList decryptionKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDecryptionKeysIsMutable() {
      if (!decryptionKeys_.isModifiable()) {
        decryptionKeys_ = new com.google.protobuf.LazyStringArrayList(decryptionKeys_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the decryptionKeys.
     */
    public com.google.protobuf.ProtocolStringList getDecryptionKeysList() {
      decryptionKeys_.makeImmutable();
      return decryptionKeys_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of decryptionKeys.
     */
    public int getDecryptionKeysCount() {
      return decryptionKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The decryptionKeys at the given index.
     */
    public java.lang.String getDecryptionKeys(int index) {
      return decryptionKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the decryptionKeys at the given index.
     */
    public com.google.protobuf.ByteString getDecryptionKeysBytes(int index) {
      return decryptionKeys_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The decryptionKeys to set.
     * @return This builder for chaining.
     */
    public Builder setDecryptionKeys(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDecryptionKeysIsMutable();
      decryptionKeys_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The decryptionKeys to add.
     * @return This builder for chaining.
     */
    public Builder addDecryptionKeys(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDecryptionKeysIsMutable();
      decryptionKeys_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The decryptionKeys to add.
     * @return This builder for chaining.
     */
    public Builder addAllDecryptionKeys(java.lang.Iterable<java.lang.String> values) {
      ensureDecryptionKeysIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, decryptionKeys_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDecryptionKeys() {
      decryptionKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Keys in use by the cluster for decrypting
     * existing objects, in addition to the key in `key_name`.
     *
     * Each item is a CloudKMS key resource.
     * </pre>
     *
     * <code>repeated string decryption_keys = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the decryptionKeys to add.
     * @return This builder for chaining.
     */
    public Builder addDecryptionKeysBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDecryptionKeysIsMutable();
      decryptionKeys_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.DatabaseEncryption.OperationError>
        lastOperationErrors_ = java.util.Collections.emptyList();

    private void ensureLastOperationErrorsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        lastOperationErrors_ =
            new java.util.ArrayList<com.google.container.v1.DatabaseEncryption.OperationError>(
                lastOperationErrors_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.DatabaseEncryption.OperationError,
            com.google.container.v1.DatabaseEncryption.OperationError.Builder,
            com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder>
        lastOperationErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.container.v1.DatabaseEncryption.OperationError>
        getLastOperationErrorsList() {
      if (lastOperationErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(lastOperationErrors_);
      } else {
        return lastOperationErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getLastOperationErrorsCount() {
      if (lastOperationErrorsBuilder_ == null) {
        return lastOperationErrors_.size();
      } else {
        return lastOperationErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.DatabaseEncryption.OperationError getLastOperationErrors(
        int index) {
      if (lastOperationErrorsBuilder_ == null) {
        return lastOperationErrors_.get(index);
      } else {
        return lastOperationErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastOperationErrors(
        int index, com.google.container.v1.DatabaseEncryption.OperationError value) {
      if (lastOperationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.set(index, value);
        onChanged();
      } else {
        lastOperationErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastOperationErrors(
        int index,
        com.google.container.v1.DatabaseEncryption.OperationError.Builder builderForValue) {
      if (lastOperationErrorsBuilder_ == null) {
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        lastOperationErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLastOperationErrors(
        com.google.container.v1.DatabaseEncryption.OperationError value) {
      if (lastOperationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.add(value);
        onChanged();
      } else {
        lastOperationErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLastOperationErrors(
        int index, com.google.container.v1.DatabaseEncryption.OperationError value) {
      if (lastOperationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.add(index, value);
        onChanged();
      } else {
        lastOperationErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLastOperationErrors(
        com.google.container.v1.DatabaseEncryption.OperationError.Builder builderForValue) {
      if (lastOperationErrorsBuilder_ == null) {
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.add(builderForValue.build());
        onChanged();
      } else {
        lastOperationErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addLastOperationErrors(
        int index,
        com.google.container.v1.DatabaseEncryption.OperationError.Builder builderForValue) {
      if (lastOperationErrorsBuilder_ == null) {
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        lastOperationErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllLastOperationErrors(
        java.lang.Iterable<? extends com.google.container.v1.DatabaseEncryption.OperationError>
            values) {
      if (lastOperationErrorsBuilder_ == null) {
        ensureLastOperationErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, lastOperationErrors_);
        onChanged();
      } else {
        lastOperationErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastOperationErrors() {
      if (lastOperationErrorsBuilder_ == null) {
        lastOperationErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        lastOperationErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLastOperationErrors(int index) {
      if (lastOperationErrorsBuilder_ == null) {
        ensureLastOperationErrorsIsMutable();
        lastOperationErrors_.remove(index);
        onChanged();
      } else {
        lastOperationErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.DatabaseEncryption.OperationError.Builder
        getLastOperationErrorsBuilder(int index) {
      return getLastOperationErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder
        getLastOperationErrorsOrBuilder(int index) {
      if (lastOperationErrorsBuilder_ == null) {
        return lastOperationErrors_.get(index);
      } else {
        return lastOperationErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder>
        getLastOperationErrorsOrBuilderList() {
      if (lastOperationErrorsBuilder_ != null) {
        return lastOperationErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(lastOperationErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.DatabaseEncryption.OperationError.Builder
        addLastOperationErrorsBuilder() {
      return getLastOperationErrorsFieldBuilder()
          .addBuilder(
              com.google.container.v1.DatabaseEncryption.OperationError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.DatabaseEncryption.OperationError.Builder
        addLastOperationErrorsBuilder(int index) {
      return getLastOperationErrorsFieldBuilder()
          .addBuilder(
              index,
              com.google.container.v1.DatabaseEncryption.OperationError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Records errors seen during DatabaseEncryption update
     * operations.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.DatabaseEncryption.OperationError last_operation_errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.container.v1.DatabaseEncryption.OperationError.Builder>
        getLastOperationErrorsBuilderList() {
      return getLastOperationErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.DatabaseEncryption.OperationError,
            com.google.container.v1.DatabaseEncryption.OperationError.Builder,
            com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder>
        getLastOperationErrorsFieldBuilder() {
      if (lastOperationErrorsBuilder_ == null) {
        lastOperationErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.DatabaseEncryption.OperationError,
                com.google.container.v1.DatabaseEncryption.OperationError.Builder,
                com.google.container.v1.DatabaseEncryption.OperationErrorOrBuilder>(
                lastOperationErrors_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        lastOperationErrors_ = null;
      }
      return lastOperationErrorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.DatabaseEncryption)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.DatabaseEncryption)
  private static final com.google.container.v1.DatabaseEncryption DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.DatabaseEncryption();
  }

  public static com.google.container.v1.DatabaseEncryption getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DatabaseEncryption> PARSER =
      new com.google.protobuf.AbstractParser<DatabaseEncryption>() {
        @java.lang.Override
        public DatabaseEncryption parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DatabaseEncryption> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DatabaseEncryption> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.DatabaseEncryption getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
