/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * GetOpenIDConfigResponse is an OIDC discovery document for the cluster.
 * See the OpenID Connect Discovery 1.0 specification for details.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.GetOpenIDConfigResponse}
 */
public final class GetOpenIDConfigResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.GetOpenIDConfigResponse)
    GetOpenIDConfigResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GetOpenIDConfigResponse.newBuilder() to construct.
  private GetOpenIDConfigResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GetOpenIDConfigResponse() {
    issuer_ = "";
    jwksUri_ = "";
    responseTypesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
    subjectTypesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
    idTokenSigningAlgValuesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
    claimsSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
    grantTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GetOpenIDConfigResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_GetOpenIDConfigResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_GetOpenIDConfigResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.GetOpenIDConfigResponse.class,
            com.google.container.v1.GetOpenIDConfigResponse.Builder.class);
  }

  public static final int ISSUER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object issuer_ = "";
  /**
   *
   *
   * <pre>
   * OIDC Issuer.
   * </pre>
   *
   * <code>string issuer = 1;</code>
   *
   * @return The issuer.
   */
  @java.lang.Override
  public java.lang.String getIssuer() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issuer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * OIDC Issuer.
   * </pre>
   *
   * <code>string issuer = 1;</code>
   *
   * @return The bytes for issuer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIssuerBytes() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      issuer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JWKS_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jwksUri_ = "";
  /**
   *
   *
   * <pre>
   * JSON Web Key uri.
   * </pre>
   *
   * <code>string jwks_uri = 2;</code>
   *
   * @return The jwksUri.
   */
  @java.lang.Override
  public java.lang.String getJwksUri() {
    java.lang.Object ref = jwksUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jwksUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * JSON Web Key uri.
   * </pre>
   *
   * <code>string jwks_uri = 2;</code>
   *
   * @return The bytes for jwksUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJwksUriBytes() {
    java.lang.Object ref = jwksUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jwksUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESPONSE_TYPES_SUPPORTED_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList responseTypesSupported_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Supported response types.
   * </pre>
   *
   * <code>repeated string response_types_supported = 3;</code>
   *
   * @return A list containing the responseTypesSupported.
   */
  public com.google.protobuf.ProtocolStringList getResponseTypesSupportedList() {
    return responseTypesSupported_;
  }
  /**
   *
   *
   * <pre>
   * Supported response types.
   * </pre>
   *
   * <code>repeated string response_types_supported = 3;</code>
   *
   * @return The count of responseTypesSupported.
   */
  public int getResponseTypesSupportedCount() {
    return responseTypesSupported_.size();
  }
  /**
   *
   *
   * <pre>
   * Supported response types.
   * </pre>
   *
   * <code>repeated string response_types_supported = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The responseTypesSupported at the given index.
   */
  public java.lang.String getResponseTypesSupported(int index) {
    return responseTypesSupported_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Supported response types.
   * </pre>
   *
   * <code>repeated string response_types_supported = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the responseTypesSupported at the given index.
   */
  public com.google.protobuf.ByteString getResponseTypesSupportedBytes(int index) {
    return responseTypesSupported_.getByteString(index);
  }

  public static final int SUBJECT_TYPES_SUPPORTED_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subjectTypesSupported_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Supported subject types.
   * </pre>
   *
   * <code>repeated string subject_types_supported = 4;</code>
   *
   * @return A list containing the subjectTypesSupported.
   */
  public com.google.protobuf.ProtocolStringList getSubjectTypesSupportedList() {
    return subjectTypesSupported_;
  }
  /**
   *
   *
   * <pre>
   * Supported subject types.
   * </pre>
   *
   * <code>repeated string subject_types_supported = 4;</code>
   *
   * @return The count of subjectTypesSupported.
   */
  public int getSubjectTypesSupportedCount() {
    return subjectTypesSupported_.size();
  }
  /**
   *
   *
   * <pre>
   * Supported subject types.
   * </pre>
   *
   * <code>repeated string subject_types_supported = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The subjectTypesSupported at the given index.
   */
  public java.lang.String getSubjectTypesSupported(int index) {
    return subjectTypesSupported_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Supported subject types.
   * </pre>
   *
   * <code>repeated string subject_types_supported = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subjectTypesSupported at the given index.
   */
  public com.google.protobuf.ByteString getSubjectTypesSupportedBytes(int index) {
    return subjectTypesSupported_.getByteString(index);
  }

  public static final int ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList idTokenSigningAlgValuesSupported_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * supported ID Token signing Algorithms.
   * </pre>
   *
   * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
   *
   * @return A list containing the idTokenSigningAlgValuesSupported.
   */
  public com.google.protobuf.ProtocolStringList getIdTokenSigningAlgValuesSupportedList() {
    return idTokenSigningAlgValuesSupported_;
  }
  /**
   *
   *
   * <pre>
   * supported ID Token signing Algorithms.
   * </pre>
   *
   * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
   *
   * @return The count of idTokenSigningAlgValuesSupported.
   */
  public int getIdTokenSigningAlgValuesSupportedCount() {
    return idTokenSigningAlgValuesSupported_.size();
  }
  /**
   *
   *
   * <pre>
   * supported ID Token signing Algorithms.
   * </pre>
   *
   * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The idTokenSigningAlgValuesSupported at the given index.
   */
  public java.lang.String getIdTokenSigningAlgValuesSupported(int index) {
    return idTokenSigningAlgValuesSupported_.get(index);
  }
  /**
   *
   *
   * <pre>
   * supported ID Token signing Algorithms.
   * </pre>
   *
   * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the idTokenSigningAlgValuesSupported at the given index.
   */
  public com.google.protobuf.ByteString getIdTokenSigningAlgValuesSupportedBytes(int index) {
    return idTokenSigningAlgValuesSupported_.getByteString(index);
  }

  public static final int CLAIMS_SUPPORTED_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList claimsSupported_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Supported claims.
   * </pre>
   *
   * <code>repeated string claims_supported = 6;</code>
   *
   * @return A list containing the claimsSupported.
   */
  public com.google.protobuf.ProtocolStringList getClaimsSupportedList() {
    return claimsSupported_;
  }
  /**
   *
   *
   * <pre>
   * Supported claims.
   * </pre>
   *
   * <code>repeated string claims_supported = 6;</code>
   *
   * @return The count of claimsSupported.
   */
  public int getClaimsSupportedCount() {
    return claimsSupported_.size();
  }
  /**
   *
   *
   * <pre>
   * Supported claims.
   * </pre>
   *
   * <code>repeated string claims_supported = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The claimsSupported at the given index.
   */
  public java.lang.String getClaimsSupported(int index) {
    return claimsSupported_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Supported claims.
   * </pre>
   *
   * <code>repeated string claims_supported = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the claimsSupported at the given index.
   */
  public com.google.protobuf.ByteString getClaimsSupportedBytes(int index) {
    return claimsSupported_.getByteString(index);
  }

  public static final int GRANT_TYPES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList grantTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Supported grant types.
   * </pre>
   *
   * <code>repeated string grant_types = 7;</code>
   *
   * @return A list containing the grantTypes.
   */
  public com.google.protobuf.ProtocolStringList getGrantTypesList() {
    return grantTypes_;
  }
  /**
   *
   *
   * <pre>
   * Supported grant types.
   * </pre>
   *
   * <code>repeated string grant_types = 7;</code>
   *
   * @return The count of grantTypes.
   */
  public int getGrantTypesCount() {
    return grantTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Supported grant types.
   * </pre>
   *
   * <code>repeated string grant_types = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The grantTypes at the given index.
   */
  public java.lang.String getGrantTypes(int index) {
    return grantTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Supported grant types.
   * </pre>
   *
   * <code>repeated string grant_types = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the grantTypes at the given index.
   */
  public com.google.protobuf.ByteString getGrantTypesBytes(int index) {
    return grantTypes_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jwksUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, jwksUri_);
    }
    for (int i = 0; i < responseTypesSupported_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, responseTypesSupported_.getRaw(i));
    }
    for (int i = 0; i < subjectTypesSupported_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, subjectTypesSupported_.getRaw(i));
    }
    for (int i = 0; i < idTokenSigningAlgValuesSupported_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, idTokenSigningAlgValuesSupported_.getRaw(i));
    }
    for (int i = 0; i < claimsSupported_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, claimsSupported_.getRaw(i));
    }
    for (int i = 0; i < grantTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, grantTypes_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jwksUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, jwksUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < responseTypesSupported_.size(); i++) {
        dataSize += computeStringSizeNoTag(responseTypesSupported_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResponseTypesSupportedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subjectTypesSupported_.size(); i++) {
        dataSize += computeStringSizeNoTag(subjectTypesSupported_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSubjectTypesSupportedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < idTokenSigningAlgValuesSupported_.size(); i++) {
        dataSize += computeStringSizeNoTag(idTokenSigningAlgValuesSupported_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIdTokenSigningAlgValuesSupportedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < claimsSupported_.size(); i++) {
        dataSize += computeStringSizeNoTag(claimsSupported_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getClaimsSupportedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < grantTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(grantTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getGrantTypesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.GetOpenIDConfigResponse)) {
      return super.equals(obj);
    }
    com.google.container.v1.GetOpenIDConfigResponse other =
        (com.google.container.v1.GetOpenIDConfigResponse) obj;

    if (!getIssuer().equals(other.getIssuer())) return false;
    if (!getJwksUri().equals(other.getJwksUri())) return false;
    if (!getResponseTypesSupportedList().equals(other.getResponseTypesSupportedList()))
      return false;
    if (!getSubjectTypesSupportedList().equals(other.getSubjectTypesSupportedList())) return false;
    if (!getIdTokenSigningAlgValuesSupportedList()
        .equals(other.getIdTokenSigningAlgValuesSupportedList())) return false;
    if (!getClaimsSupportedList().equals(other.getClaimsSupportedList())) return false;
    if (!getGrantTypesList().equals(other.getGrantTypesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ISSUER_FIELD_NUMBER;
    hash = (53 * hash) + getIssuer().hashCode();
    hash = (37 * hash) + JWKS_URI_FIELD_NUMBER;
    hash = (53 * hash) + getJwksUri().hashCode();
    if (getResponseTypesSupportedCount() > 0) {
      hash = (37 * hash) + RESPONSE_TYPES_SUPPORTED_FIELD_NUMBER;
      hash = (53 * hash) + getResponseTypesSupportedList().hashCode();
    }
    if (getSubjectTypesSupportedCount() > 0) {
      hash = (37 * hash) + SUBJECT_TYPES_SUPPORTED_FIELD_NUMBER;
      hash = (53 * hash) + getSubjectTypesSupportedList().hashCode();
    }
    if (getIdTokenSigningAlgValuesSupportedCount() > 0) {
      hash = (37 * hash) + ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED_FIELD_NUMBER;
      hash = (53 * hash) + getIdTokenSigningAlgValuesSupportedList().hashCode();
    }
    if (getClaimsSupportedCount() > 0) {
      hash = (37 * hash) + CLAIMS_SUPPORTED_FIELD_NUMBER;
      hash = (53 * hash) + getClaimsSupportedList().hashCode();
    }
    if (getGrantTypesCount() > 0) {
      hash = (37 * hash) + GRANT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getGrantTypesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.GetOpenIDConfigResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.GetOpenIDConfigResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * GetOpenIDConfigResponse is an OIDC discovery document for the cluster.
   * See the OpenID Connect Discovery 1.0 specification for details.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.GetOpenIDConfigResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.GetOpenIDConfigResponse)
      com.google.container.v1.GetOpenIDConfigResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_GetOpenIDConfigResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_GetOpenIDConfigResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.GetOpenIDConfigResponse.class,
              com.google.container.v1.GetOpenIDConfigResponse.Builder.class);
    }

    // Construct using com.google.container.v1.GetOpenIDConfigResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      issuer_ = "";
      jwksUri_ = "";
      responseTypesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      subjectTypesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      idTokenSigningAlgValuesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      claimsSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      grantTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_GetOpenIDConfigResponse_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.GetOpenIDConfigResponse getDefaultInstanceForType() {
      return com.google.container.v1.GetOpenIDConfigResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.GetOpenIDConfigResponse build() {
      com.google.container.v1.GetOpenIDConfigResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.GetOpenIDConfigResponse buildPartial() {
      com.google.container.v1.GetOpenIDConfigResponse result =
          new com.google.container.v1.GetOpenIDConfigResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.GetOpenIDConfigResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.issuer_ = issuer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.jwksUri_ = jwksUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        responseTypesSupported_.makeImmutable();
        result.responseTypesSupported_ = responseTypesSupported_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        subjectTypesSupported_.makeImmutable();
        result.subjectTypesSupported_ = subjectTypesSupported_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        idTokenSigningAlgValuesSupported_.makeImmutable();
        result.idTokenSigningAlgValuesSupported_ = idTokenSigningAlgValuesSupported_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        claimsSupported_.makeImmutable();
        result.claimsSupported_ = claimsSupported_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        grantTypes_.makeImmutable();
        result.grantTypes_ = grantTypes_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.GetOpenIDConfigResponse) {
        return mergeFrom((com.google.container.v1.GetOpenIDConfigResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.GetOpenIDConfigResponse other) {
      if (other == com.google.container.v1.GetOpenIDConfigResponse.getDefaultInstance())
        return this;
      if (!other.getIssuer().isEmpty()) {
        issuer_ = other.issuer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getJwksUri().isEmpty()) {
        jwksUri_ = other.jwksUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.responseTypesSupported_.isEmpty()) {
        if (responseTypesSupported_.isEmpty()) {
          responseTypesSupported_ = other.responseTypesSupported_;
          bitField0_ |= 0x00000004;
        } else {
          ensureResponseTypesSupportedIsMutable();
          responseTypesSupported_.addAll(other.responseTypesSupported_);
        }
        onChanged();
      }
      if (!other.subjectTypesSupported_.isEmpty()) {
        if (subjectTypesSupported_.isEmpty()) {
          subjectTypesSupported_ = other.subjectTypesSupported_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSubjectTypesSupportedIsMutable();
          subjectTypesSupported_.addAll(other.subjectTypesSupported_);
        }
        onChanged();
      }
      if (!other.idTokenSigningAlgValuesSupported_.isEmpty()) {
        if (idTokenSigningAlgValuesSupported_.isEmpty()) {
          idTokenSigningAlgValuesSupported_ = other.idTokenSigningAlgValuesSupported_;
          bitField0_ |= 0x00000010;
        } else {
          ensureIdTokenSigningAlgValuesSupportedIsMutable();
          idTokenSigningAlgValuesSupported_.addAll(other.idTokenSigningAlgValuesSupported_);
        }
        onChanged();
      }
      if (!other.claimsSupported_.isEmpty()) {
        if (claimsSupported_.isEmpty()) {
          claimsSupported_ = other.claimsSupported_;
          bitField0_ |= 0x00000020;
        } else {
          ensureClaimsSupportedIsMutable();
          claimsSupported_.addAll(other.claimsSupported_);
        }
        onChanged();
      }
      if (!other.grantTypes_.isEmpty()) {
        if (grantTypes_.isEmpty()) {
          grantTypes_ = other.grantTypes_;
          bitField0_ |= 0x00000040;
        } else {
          ensureGrantTypesIsMutable();
          grantTypes_.addAll(other.grantTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                issuer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                jwksUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResponseTypesSupportedIsMutable();
                responseTypesSupported_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSubjectTypesSupportedIsMutable();
                subjectTypesSupported_.add(s);
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIdTokenSigningAlgValuesSupportedIsMutable();
                idTokenSigningAlgValuesSupported_.add(s);
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureClaimsSupportedIsMutable();
                claimsSupported_.add(s);
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureGrantTypesIsMutable();
                grantTypes_.add(s);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object issuer_ = "";
    /**
     *
     *
     * <pre>
     * OIDC Issuer.
     * </pre>
     *
     * <code>string issuer = 1;</code>
     *
     * @return The issuer.
     */
    public java.lang.String getIssuer() {
      java.lang.Object ref = issuer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * OIDC Issuer.
     * </pre>
     *
     * <code>string issuer = 1;</code>
     *
     * @return The bytes for issuer.
     */
    public com.google.protobuf.ByteString getIssuerBytes() {
      java.lang.Object ref = issuer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issuer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * OIDC Issuer.
     * </pre>
     *
     * <code>string issuer = 1;</code>
     *
     * @param value The issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      issuer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OIDC Issuer.
     * </pre>
     *
     * <code>string issuer = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssuer() {
      issuer_ = getDefaultInstance().getIssuer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OIDC Issuer.
     * </pre>
     *
     * <code>string issuer = 1;</code>
     *
     * @param value The bytes for issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      issuer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object jwksUri_ = "";
    /**
     *
     *
     * <pre>
     * JSON Web Key uri.
     * </pre>
     *
     * <code>string jwks_uri = 2;</code>
     *
     * @return The jwksUri.
     */
    public java.lang.String getJwksUri() {
      java.lang.Object ref = jwksUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jwksUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * JSON Web Key uri.
     * </pre>
     *
     * <code>string jwks_uri = 2;</code>
     *
     * @return The bytes for jwksUri.
     */
    public com.google.protobuf.ByteString getJwksUriBytes() {
      java.lang.Object ref = jwksUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jwksUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * JSON Web Key uri.
     * </pre>
     *
     * <code>string jwks_uri = 2;</code>
     *
     * @param value The jwksUri to set.
     * @return This builder for chaining.
     */
    public Builder setJwksUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jwksUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * JSON Web Key uri.
     * </pre>
     *
     * <code>string jwks_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJwksUri() {
      jwksUri_ = getDefaultInstance().getJwksUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * JSON Web Key uri.
     * </pre>
     *
     * <code>string jwks_uri = 2;</code>
     *
     * @param value The bytes for jwksUri to set.
     * @return This builder for chaining.
     */
    public Builder setJwksUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jwksUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList responseTypesSupported_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResponseTypesSupportedIsMutable() {
      if (!responseTypesSupported_.isModifiable()) {
        responseTypesSupported_ =
            new com.google.protobuf.LazyStringArrayList(responseTypesSupported_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @return A list containing the responseTypesSupported.
     */
    public com.google.protobuf.ProtocolStringList getResponseTypesSupportedList() {
      responseTypesSupported_.makeImmutable();
      return responseTypesSupported_;
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @return The count of responseTypesSupported.
     */
    public int getResponseTypesSupportedCount() {
      return responseTypesSupported_.size();
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The responseTypesSupported at the given index.
     */
    public java.lang.String getResponseTypesSupported(int index) {
      return responseTypesSupported_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseTypesSupported at the given index.
     */
    public com.google.protobuf.ByteString getResponseTypesSupportedBytes(int index) {
      return responseTypesSupported_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The responseTypesSupported to set.
     * @return This builder for chaining.
     */
    public Builder setResponseTypesSupported(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResponseTypesSupportedIsMutable();
      responseTypesSupported_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @param value The responseTypesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addResponseTypesSupported(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResponseTypesSupportedIsMutable();
      responseTypesSupported_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @param values The responseTypesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addAllResponseTypesSupported(java.lang.Iterable<java.lang.String> values) {
      ensureResponseTypesSupportedIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseTypesSupported_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseTypesSupported() {
      responseTypesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported response types.
     * </pre>
     *
     * <code>repeated string response_types_supported = 3;</code>
     *
     * @param value The bytes of the responseTypesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addResponseTypesSupportedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResponseTypesSupportedIsMutable();
      responseTypesSupported_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList subjectTypesSupported_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSubjectTypesSupportedIsMutable() {
      if (!subjectTypesSupported_.isModifiable()) {
        subjectTypesSupported_ =
            new com.google.protobuf.LazyStringArrayList(subjectTypesSupported_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @return A list containing the subjectTypesSupported.
     */
    public com.google.protobuf.ProtocolStringList getSubjectTypesSupportedList() {
      subjectTypesSupported_.makeImmutable();
      return subjectTypesSupported_;
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @return The count of subjectTypesSupported.
     */
    public int getSubjectTypesSupportedCount() {
      return subjectTypesSupported_.size();
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The subjectTypesSupported at the given index.
     */
    public java.lang.String getSubjectTypesSupported(int index) {
      return subjectTypesSupported_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the subjectTypesSupported at the given index.
     */
    public com.google.protobuf.ByteString getSubjectTypesSupportedBytes(int index) {
      return subjectTypesSupported_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The subjectTypesSupported to set.
     * @return This builder for chaining.
     */
    public Builder setSubjectTypesSupported(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectTypesSupportedIsMutable();
      subjectTypesSupported_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @param value The subjectTypesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectTypesSupported(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectTypesSupportedIsMutable();
      subjectTypesSupported_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @param values The subjectTypesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubjectTypesSupported(java.lang.Iterable<java.lang.String> values) {
      ensureSubjectTypesSupportedIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subjectTypesSupported_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubjectTypesSupported() {
      subjectTypesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported subject types.
     * </pre>
     *
     * <code>repeated string subject_types_supported = 4;</code>
     *
     * @param value The bytes of the subjectTypesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectTypesSupportedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSubjectTypesSupportedIsMutable();
      subjectTypesSupported_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList idTokenSigningAlgValuesSupported_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIdTokenSigningAlgValuesSupportedIsMutable() {
      if (!idTokenSigningAlgValuesSupported_.isModifiable()) {
        idTokenSigningAlgValuesSupported_ =
            new com.google.protobuf.LazyStringArrayList(idTokenSigningAlgValuesSupported_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @return A list containing the idTokenSigningAlgValuesSupported.
     */
    public com.google.protobuf.ProtocolStringList getIdTokenSigningAlgValuesSupportedList() {
      idTokenSigningAlgValuesSupported_.makeImmutable();
      return idTokenSigningAlgValuesSupported_;
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @return The count of idTokenSigningAlgValuesSupported.
     */
    public int getIdTokenSigningAlgValuesSupportedCount() {
      return idTokenSigningAlgValuesSupported_.size();
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The idTokenSigningAlgValuesSupported at the given index.
     */
    public java.lang.String getIdTokenSigningAlgValuesSupported(int index) {
      return idTokenSigningAlgValuesSupported_.get(index);
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the idTokenSigningAlgValuesSupported at the given index.
     */
    public com.google.protobuf.ByteString getIdTokenSigningAlgValuesSupportedBytes(int index) {
      return idTokenSigningAlgValuesSupported_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The idTokenSigningAlgValuesSupported to set.
     * @return This builder for chaining.
     */
    public Builder setIdTokenSigningAlgValuesSupported(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIdTokenSigningAlgValuesSupportedIsMutable();
      idTokenSigningAlgValuesSupported_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @param value The idTokenSigningAlgValuesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addIdTokenSigningAlgValuesSupported(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIdTokenSigningAlgValuesSupportedIsMutable();
      idTokenSigningAlgValuesSupported_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @param values The idTokenSigningAlgValuesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addAllIdTokenSigningAlgValuesSupported(
        java.lang.Iterable<java.lang.String> values) {
      ensureIdTokenSigningAlgValuesSupportedIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, idTokenSigningAlgValuesSupported_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdTokenSigningAlgValuesSupported() {
      idTokenSigningAlgValuesSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * supported ID Token signing Algorithms.
     * </pre>
     *
     * <code>repeated string id_token_signing_alg_values_supported = 5;</code>
     *
     * @param value The bytes of the idTokenSigningAlgValuesSupported to add.
     * @return This builder for chaining.
     */
    public Builder addIdTokenSigningAlgValuesSupportedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIdTokenSigningAlgValuesSupportedIsMutable();
      idTokenSigningAlgValuesSupported_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList claimsSupported_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureClaimsSupportedIsMutable() {
      if (!claimsSupported_.isModifiable()) {
        claimsSupported_ = new com.google.protobuf.LazyStringArrayList(claimsSupported_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @return A list containing the claimsSupported.
     */
    public com.google.protobuf.ProtocolStringList getClaimsSupportedList() {
      claimsSupported_.makeImmutable();
      return claimsSupported_;
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @return The count of claimsSupported.
     */
    public int getClaimsSupportedCount() {
      return claimsSupported_.size();
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The claimsSupported at the given index.
     */
    public java.lang.String getClaimsSupported(int index) {
      return claimsSupported_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the claimsSupported at the given index.
     */
    public com.google.protobuf.ByteString getClaimsSupportedBytes(int index) {
      return claimsSupported_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The claimsSupported to set.
     * @return This builder for chaining.
     */
    public Builder setClaimsSupported(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureClaimsSupportedIsMutable();
      claimsSupported_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @param value The claimsSupported to add.
     * @return This builder for chaining.
     */
    public Builder addClaimsSupported(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureClaimsSupportedIsMutable();
      claimsSupported_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @param values The claimsSupported to add.
     * @return This builder for chaining.
     */
    public Builder addAllClaimsSupported(java.lang.Iterable<java.lang.String> values) {
      ensureClaimsSupportedIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, claimsSupported_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClaimsSupported() {
      claimsSupported_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported claims.
     * </pre>
     *
     * <code>repeated string claims_supported = 6;</code>
     *
     * @param value The bytes of the claimsSupported to add.
     * @return This builder for chaining.
     */
    public Builder addClaimsSupportedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureClaimsSupportedIsMutable();
      claimsSupported_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList grantTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureGrantTypesIsMutable() {
      if (!grantTypes_.isModifiable()) {
        grantTypes_ = new com.google.protobuf.LazyStringArrayList(grantTypes_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @return A list containing the grantTypes.
     */
    public com.google.protobuf.ProtocolStringList getGrantTypesList() {
      grantTypes_.makeImmutable();
      return grantTypes_;
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @return The count of grantTypes.
     */
    public int getGrantTypesCount() {
      return grantTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The grantTypes at the given index.
     */
    public java.lang.String getGrantTypes(int index) {
      return grantTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the grantTypes at the given index.
     */
    public com.google.protobuf.ByteString getGrantTypesBytes(int index) {
      return grantTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The grantTypes to set.
     * @return This builder for chaining.
     */
    public Builder setGrantTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGrantTypesIsMutable();
      grantTypes_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @param value The grantTypes to add.
     * @return This builder for chaining.
     */
    public Builder addGrantTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGrantTypesIsMutable();
      grantTypes_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @param values The grantTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllGrantTypes(java.lang.Iterable<java.lang.String> values) {
      ensureGrantTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, grantTypes_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGrantTypes() {
      grantTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Supported grant types.
     * </pre>
     *
     * <code>repeated string grant_types = 7;</code>
     *
     * @param value The bytes of the grantTypes to add.
     * @return This builder for chaining.
     */
    public Builder addGrantTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureGrantTypesIsMutable();
      grantTypes_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.GetOpenIDConfigResponse)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.GetOpenIDConfigResponse)
  private static final com.google.container.v1.GetOpenIDConfigResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.GetOpenIDConfigResponse();
  }

  public static com.google.container.v1.GetOpenIDConfigResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetOpenIDConfigResponse> PARSER =
      new com.google.protobuf.AbstractParser<GetOpenIDConfigResponse>() {
        @java.lang.Override
        public GetOpenIDConfigResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GetOpenIDConfigResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetOpenIDConfigResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.GetOpenIDConfigResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
