/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * Configuration for controlling how IPs are allocated in the cluster.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.IPAllocationPolicy}
 */
public final class IPAllocationPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.IPAllocationPolicy)
    IPAllocationPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IPAllocationPolicy.newBuilder() to construct.
  private IPAllocationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IPAllocationPolicy() {
    subnetworkName_ = "";
    clusterIpv4Cidr_ = "";
    nodeIpv4Cidr_ = "";
    servicesIpv4Cidr_ = "";
    clusterSecondaryRangeName_ = "";
    servicesSecondaryRangeName_ = "";
    clusterIpv4CidrBlock_ = "";
    nodeIpv4CidrBlock_ = "";
    servicesIpv4CidrBlock_ = "";
    tpuIpv4CidrBlock_ = "";
    stackType_ = 0;
    ipv6AccessType_ = 0;
    subnetIpv6CidrBlock_ = "";
    servicesIpv6CidrBlock_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IPAllocationPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_IPAllocationPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_IPAllocationPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.IPAllocationPolicy.class,
            com.google.container.v1.IPAllocationPolicy.Builder.class);
  }

  private int bitField0_;
  public static final int USE_IP_ALIASES_FIELD_NUMBER = 1;
  private boolean useIpAliases_ = false;
  /**
   *
   *
   * <pre>
   * Whether alias IPs will be used for pod IPs in the cluster.
   * This is used in conjunction with use_routes. It cannot
   * be true if use_routes is true. If both use_ip_aliases and use_routes are
   * false, then the server picks the default IP allocation mode
   * </pre>
   *
   * <code>bool use_ip_aliases = 1;</code>
   *
   * @return The useIpAliases.
   */
  @java.lang.Override
  public boolean getUseIpAliases() {
    return useIpAliases_;
  }

  public static final int CREATE_SUBNETWORK_FIELD_NUMBER = 2;
  private boolean createSubnetwork_ = false;
  /**
   *
   *
   * <pre>
   * Whether a new subnetwork will be created automatically for the cluster.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   * </pre>
   *
   * <code>bool create_subnetwork = 2;</code>
   *
   * @return The createSubnetwork.
   */
  @java.lang.Override
  public boolean getCreateSubnetwork() {
    return createSubnetwork_;
  }

  public static final int SUBNETWORK_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetworkName_ = "";
  /**
   *
   *
   * <pre>
   * A custom subnetwork name to be used if `create_subnetwork` is true.  If
   * this field is empty, then an automatic name will be chosen for the new
   * subnetwork.
   * </pre>
   *
   * <code>string subnetwork_name = 3;</code>
   *
   * @return The subnetworkName.
   */
  @java.lang.Override
  public java.lang.String getSubnetworkName() {
    java.lang.Object ref = subnetworkName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetworkName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A custom subnetwork name to be used if `create_subnetwork` is true.  If
   * this field is empty, then an automatic name will be chosen for the new
   * subnetwork.
   * </pre>
   *
   * <code>string subnetwork_name = 3;</code>
   *
   * @return The bytes for subnetworkName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkNameBytes() {
    java.lang.Object ref = subnetworkName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetworkName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_IPV4_CIDR_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterIpv4Cidr_ = "";
  /**
   *
   *
   * <pre>
   * This field is deprecated, use cluster_ipv4_cidr_block.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1581
   * @return The clusterIpv4Cidr.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getClusterIpv4Cidr() {
    java.lang.Object ref = clusterIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterIpv4Cidr_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is deprecated, use cluster_ipv4_cidr_block.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1581
   * @return The bytes for clusterIpv4Cidr.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getClusterIpv4CidrBytes() {
    java.lang.Object ref = clusterIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterIpv4Cidr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_IPV4_CIDR_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeIpv4Cidr_ = "";
  /**
   *
   *
   * <pre>
   * This field is deprecated, use node_ipv4_cidr_block.
   * </pre>
   *
   * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1584
   * @return The nodeIpv4Cidr.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getNodeIpv4Cidr() {
    java.lang.Object ref = nodeIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeIpv4Cidr_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is deprecated, use node_ipv4_cidr_block.
   * </pre>
   *
   * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1584
   * @return The bytes for nodeIpv4Cidr.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getNodeIpv4CidrBytes() {
    java.lang.Object ref = nodeIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeIpv4Cidr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICES_IPV4_CIDR_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesIpv4Cidr_ = "";
  /**
   *
   *
   * <pre>
   * This field is deprecated, use services_ipv4_cidr_block.
   * </pre>
   *
   * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1587
   * @return The servicesIpv4Cidr.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getServicesIpv4Cidr() {
    java.lang.Object ref = servicesIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesIpv4Cidr_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is deprecated, use services_ipv4_cidr_block.
   * </pre>
   *
   * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1587
   * @return The bytes for servicesIpv4Cidr.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getServicesIpv4CidrBytes() {
    java.lang.Object ref = servicesIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesIpv4Cidr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_SECONDARY_RANGE_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterSecondaryRangeName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the secondary range to be used for the cluster CIDR
   * block.  The secondary range will be used for pod IP
   * addresses. This must be an existing secondary range associated
   * with the cluster subnetwork.
   *
   * This field is only applicable with use_ip_aliases is true and
   * create_subnetwork is false.
   * </pre>
   *
   * <code>string cluster_secondary_range_name = 7;</code>
   *
   * @return The clusterSecondaryRangeName.
   */
  @java.lang.Override
  public java.lang.String getClusterSecondaryRangeName() {
    java.lang.Object ref = clusterSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterSecondaryRangeName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the secondary range to be used for the cluster CIDR
   * block.  The secondary range will be used for pod IP
   * addresses. This must be an existing secondary range associated
   * with the cluster subnetwork.
   *
   * This field is only applicable with use_ip_aliases is true and
   * create_subnetwork is false.
   * </pre>
   *
   * <code>string cluster_secondary_range_name = 7;</code>
   *
   * @return The bytes for clusterSecondaryRangeName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterSecondaryRangeNameBytes() {
    java.lang.Object ref = clusterSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterSecondaryRangeName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICES_SECONDARY_RANGE_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesSecondaryRangeName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the secondary range to be used as for the services
   * CIDR block.  The secondary range will be used for service
   * ClusterIPs. This must be an existing secondary range associated
   * with the cluster subnetwork.
   *
   * This field is only applicable with use_ip_aliases is true and
   * create_subnetwork is false.
   * </pre>
   *
   * <code>string services_secondary_range_name = 8;</code>
   *
   * @return The servicesSecondaryRangeName.
   */
  @java.lang.Override
  public java.lang.String getServicesSecondaryRangeName() {
    java.lang.Object ref = servicesSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesSecondaryRangeName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the secondary range to be used as for the services
   * CIDR block.  The secondary range will be used for service
   * ClusterIPs. This must be an existing secondary range associated
   * with the cluster subnetwork.
   *
   * This field is only applicable with use_ip_aliases is true and
   * create_subnetwork is false.
   * </pre>
   *
   * <code>string services_secondary_range_name = 8;</code>
   *
   * @return The bytes for servicesSecondaryRangeName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServicesSecondaryRangeNameBytes() {
    java.lang.Object ref = servicesSecondaryRangeName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesSecondaryRangeName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_IPV4_CIDR_BLOCK_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range for the cluster pod IPs. If this field is set, then
   * `cluster.cluster_ipv4_cidr` must be left blank.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr_block = 9;</code>
   *
   * @return The clusterIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getClusterIpv4CidrBlock() {
    java.lang.Object ref = clusterIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range for the cluster pod IPs. If this field is set, then
   * `cluster.cluster_ipv4_cidr` must be left blank.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr_block = 9;</code>
   *
   * @return The bytes for clusterIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterIpv4CidrBlockBytes() {
    java.lang.Object ref = clusterIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_IPV4_CIDR_BLOCK_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range of the instance IPs in this cluster.
   *
   * This is applicable only if `create_subnetwork` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string node_ipv4_cidr_block = 10;</code>
   *
   * @return The nodeIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getNodeIpv4CidrBlock() {
    java.lang.Object ref = nodeIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range of the instance IPs in this cluster.
   *
   * This is applicable only if `create_subnetwork` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string node_ipv4_cidr_block = 10;</code>
   *
   * @return The bytes for nodeIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeIpv4CidrBlockBytes() {
    java.lang.Object ref = nodeIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICES_IPV4_CIDR_BLOCK_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range of the services IPs in this cluster. If blank, a range
   * will be automatically chosen with the default size.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string services_ipv4_cidr_block = 11;</code>
   *
   * @return The servicesIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getServicesIpv4CidrBlock() {
    java.lang.Object ref = servicesIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range of the services IPs in this cluster. If blank, a range
   * will be automatically chosen with the default size.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string services_ipv4_cidr_block = 11;</code>
   *
   * @return The bytes for servicesIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServicesIpv4CidrBlockBytes() {
    java.lang.Object ref = servicesIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TPU_IPV4_CIDR_BLOCK_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tpuIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
   * range will be automatically chosen with the default size.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   *
   * If unspecified, the range will use the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string tpu_ipv4_cidr_block = 13;</code>
   *
   * @return The tpuIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getTpuIpv4CidrBlock() {
    java.lang.Object ref = tpuIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tpuIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
   * range will be automatically chosen with the default size.
   *
   * This field is only applicable when `use_ip_aliases` is true.
   *
   * If unspecified, the range will use the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
   * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
   * to use.
   * </pre>
   *
   * <code>string tpu_ipv4_cidr_block = 13;</code>
   *
   * @return The bytes for tpuIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTpuIpv4CidrBlockBytes() {
    java.lang.Object ref = tpuIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tpuIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USE_ROUTES_FIELD_NUMBER = 15;
  private boolean useRoutes_ = false;
  /**
   *
   *
   * <pre>
   * Whether routes will be used for pod IPs in the cluster.
   * This is used in conjunction with use_ip_aliases. It cannot be true if
   * use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
   * then the server picks the default IP allocation mode
   * </pre>
   *
   * <code>bool use_routes = 15;</code>
   *
   * @return The useRoutes.
   */
  @java.lang.Override
  public boolean getUseRoutes() {
    return useRoutes_;
  }

  public static final int STACK_TYPE_FIELD_NUMBER = 16;
  private int stackType_ = 0;
  /**
   *
   *
   * <pre>
   * The IP stack type of the cluster
   * </pre>
   *
   * <code>.google.container.v1.StackType stack_type = 16;</code>
   *
   * @return The enum numeric value on the wire for stackType.
   */
  @java.lang.Override
  public int getStackTypeValue() {
    return stackType_;
  }
  /**
   *
   *
   * <pre>
   * The IP stack type of the cluster
   * </pre>
   *
   * <code>.google.container.v1.StackType stack_type = 16;</code>
   *
   * @return The stackType.
   */
  @java.lang.Override
  public com.google.container.v1.StackType getStackType() {
    com.google.container.v1.StackType result =
        com.google.container.v1.StackType.forNumber(stackType_);
    return result == null ? com.google.container.v1.StackType.UNRECOGNIZED : result;
  }

  public static final int IPV6_ACCESS_TYPE_FIELD_NUMBER = 17;
  private int ipv6AccessType_ = 0;
  /**
   *
   *
   * <pre>
   * The ipv6 access type (internal or external) when create_subnetwork is true
   * </pre>
   *
   * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
   *
   * @return The enum numeric value on the wire for ipv6AccessType.
   */
  @java.lang.Override
  public int getIpv6AccessTypeValue() {
    return ipv6AccessType_;
  }
  /**
   *
   *
   * <pre>
   * The ipv6 access type (internal or external) when create_subnetwork is true
   * </pre>
   *
   * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
   *
   * @return The ipv6AccessType.
   */
  @java.lang.Override
  public com.google.container.v1.IPv6AccessType getIpv6AccessType() {
    com.google.container.v1.IPv6AccessType result =
        com.google.container.v1.IPv6AccessType.forNumber(ipv6AccessType_);
    return result == null ? com.google.container.v1.IPv6AccessType.UNRECOGNIZED : result;
  }

  public static final int POD_CIDR_OVERPROVISION_CONFIG_FIELD_NUMBER = 21;
  private com.google.container.v1.PodCIDROverprovisionConfig podCidrOverprovisionConfig_;
  /**
   *
   *
   * <pre>
   * [PRIVATE FIELD]
   * Pod CIDR size overprovisioning config for the cluster.
   *
   * Pod CIDR size per node depends on max_pods_per_node. By default, the value
   * of max_pods_per_node is doubled and then rounded off to next power of 2 to
   * get the size of pod CIDR block per node.
   * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
   *
   * This config can disable the doubling of IPs (we still round off to next
   * power of 2)
   * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
   * overprovisioning is disabled.
   * </pre>
   *
   * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
   * </code>
   *
   * @return Whether the podCidrOverprovisionConfig field is set.
   */
  @java.lang.Override
  public boolean hasPodCidrOverprovisionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [PRIVATE FIELD]
   * Pod CIDR size overprovisioning config for the cluster.
   *
   * Pod CIDR size per node depends on max_pods_per_node. By default, the value
   * of max_pods_per_node is doubled and then rounded off to next power of 2 to
   * get the size of pod CIDR block per node.
   * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
   *
   * This config can disable the doubling of IPs (we still round off to next
   * power of 2)
   * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
   * overprovisioning is disabled.
   * </pre>
   *
   * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
   * </code>
   *
   * @return The podCidrOverprovisionConfig.
   */
  @java.lang.Override
  public com.google.container.v1.PodCIDROverprovisionConfig getPodCidrOverprovisionConfig() {
    return podCidrOverprovisionConfig_ == null
        ? com.google.container.v1.PodCIDROverprovisionConfig.getDefaultInstance()
        : podCidrOverprovisionConfig_;
  }
  /**
   *
   *
   * <pre>
   * [PRIVATE FIELD]
   * Pod CIDR size overprovisioning config for the cluster.
   *
   * Pod CIDR size per node depends on max_pods_per_node. By default, the value
   * of max_pods_per_node is doubled and then rounded off to next power of 2 to
   * get the size of pod CIDR block per node.
   * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
   *
   * This config can disable the doubling of IPs (we still round off to next
   * power of 2)
   * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
   * overprovisioning is disabled.
   * </pre>
   *
   * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.PodCIDROverprovisionConfigOrBuilder
      getPodCidrOverprovisionConfigOrBuilder() {
    return podCidrOverprovisionConfig_ == null
        ? com.google.container.v1.PodCIDROverprovisionConfig.getDefaultInstance()
        : podCidrOverprovisionConfig_;
  }

  public static final int SUBNET_IPV6_CIDR_BLOCK_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetIpv6CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
   * </pre>
   *
   * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The subnetIpv6CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getSubnetIpv6CidrBlock() {
    java.lang.Object ref = subnetIpv6CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetIpv6CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
   * </pre>
   *
   * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for subnetIpv6CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetIpv6CidrBlockBytes() {
    java.lang.Object ref = subnetIpv6CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetIpv6CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICES_IPV6_CIDR_BLOCK_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesIpv6CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The services IPv6 CIDR block for the cluster.
   * </pre>
   *
   * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The servicesIpv6CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getServicesIpv6CidrBlock() {
    java.lang.Object ref = servicesIpv6CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesIpv6CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The services IPv6 CIDR block for the cluster.
   * </pre>
   *
   * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for servicesIpv6CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServicesIpv6CidrBlockBytes() {
    java.lang.Object ref = servicesIpv6CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesIpv6CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDITIONAL_POD_RANGES_CONFIG_FIELD_NUMBER = 24;
  private com.google.container.v1.AdditionalPodRangesConfig additionalPodRangesConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The additional pod ranges that are added to the cluster.
   * These pod ranges can be used by new node pools to allocate pod IPs
   * automatically. Once the range is removed it will not show up in
   * IPAllocationPolicy.
   * </pre>
   *
   * <code>
   * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the additionalPodRangesConfig field is set.
   */
  @java.lang.Override
  public boolean hasAdditionalPodRangesConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The additional pod ranges that are added to the cluster.
   * These pod ranges can be used by new node pools to allocate pod IPs
   * automatically. Once the range is removed it will not show up in
   * IPAllocationPolicy.
   * </pre>
   *
   * <code>
   * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The additionalPodRangesConfig.
   */
  @java.lang.Override
  public com.google.container.v1.AdditionalPodRangesConfig getAdditionalPodRangesConfig() {
    return additionalPodRangesConfig_ == null
        ? com.google.container.v1.AdditionalPodRangesConfig.getDefaultInstance()
        : additionalPodRangesConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The additional pod ranges that are added to the cluster.
   * These pod ranges can be used by new node pools to allocate pod IPs
   * automatically. Once the range is removed it will not show up in
   * IPAllocationPolicy.
   * </pre>
   *
   * <code>
   * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.AdditionalPodRangesConfigOrBuilder
      getAdditionalPodRangesConfigOrBuilder() {
    return additionalPodRangesConfig_ == null
        ? com.google.container.v1.AdditionalPodRangesConfig.getDefaultInstance()
        : additionalPodRangesConfig_;
  }

  public static final int DEFAULT_POD_IPV4_RANGE_UTILIZATION_FIELD_NUMBER = 25;
  private double defaultPodIpv4RangeUtilization_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The utilization of the cluster default IPv4 range for the
   * pod. The ratio is Usage/[Total number of IPs in the secondary range],
   * Usage=numNodes*numZones*podIPsPerNode.
   * </pre>
   *
   * <code>
   * double default_pod_ipv4_range_utilization = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The defaultPodIpv4RangeUtilization.
   */
  @java.lang.Override
  public double getDefaultPodIpv4RangeUtilization() {
    return defaultPodIpv4RangeUtilization_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (useIpAliases_ != false) {
      output.writeBool(1, useIpAliases_);
    }
    if (createSubnetwork_ != false) {
      output.writeBool(2, createSubnetwork_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetworkName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, subnetworkName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4Cidr_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, clusterIpv4Cidr_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeIpv4Cidr_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, nodeIpv4Cidr_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4Cidr_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, servicesIpv4Cidr_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterSecondaryRangeName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, clusterSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesSecondaryRangeName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, servicesSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, clusterIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, nodeIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, servicesIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tpuIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, tpuIpv4CidrBlock_);
    }
    if (useRoutes_ != false) {
      output.writeBool(15, useRoutes_);
    }
    if (stackType_ != com.google.container.v1.StackType.STACK_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(16, stackType_);
    }
    if (ipv6AccessType_
        != com.google.container.v1.IPv6AccessType.IPV6_ACCESS_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(17, ipv6AccessType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(21, getPodCidrOverprovisionConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetIpv6CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, subnetIpv6CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv6CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, servicesIpv6CidrBlock_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(24, getAdditionalPodRangesConfig());
    }
    if (java.lang.Double.doubleToRawLongBits(defaultPodIpv4RangeUtilization_) != 0) {
      output.writeDouble(25, defaultPodIpv4RangeUtilization_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (useIpAliases_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useIpAliases_);
    }
    if (createSubnetwork_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, createSubnetwork_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetworkName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, subnetworkName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4Cidr_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, clusterIpv4Cidr_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeIpv4Cidr_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, nodeIpv4Cidr_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4Cidr_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, servicesIpv4Cidr_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterSecondaryRangeName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(7, clusterSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesSecondaryRangeName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(8, servicesSecondaryRangeName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, clusterIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, nodeIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, servicesIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tpuIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, tpuIpv4CidrBlock_);
    }
    if (useRoutes_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, useRoutes_);
    }
    if (stackType_ != com.google.container.v1.StackType.STACK_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, stackType_);
    }
    if (ipv6AccessType_
        != com.google.container.v1.IPv6AccessType.IPV6_ACCESS_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, ipv6AccessType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, getPodCidrOverprovisionConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetIpv6CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, subnetIpv6CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv6CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(23, servicesIpv6CidrBlock_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, getAdditionalPodRangesConfig());
    }
    if (java.lang.Double.doubleToRawLongBits(defaultPodIpv4RangeUtilization_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              25, defaultPodIpv4RangeUtilization_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.IPAllocationPolicy)) {
      return super.equals(obj);
    }
    com.google.container.v1.IPAllocationPolicy other =
        (com.google.container.v1.IPAllocationPolicy) obj;

    if (getUseIpAliases() != other.getUseIpAliases()) return false;
    if (getCreateSubnetwork() != other.getCreateSubnetwork()) return false;
    if (!getSubnetworkName().equals(other.getSubnetworkName())) return false;
    if (!getClusterIpv4Cidr().equals(other.getClusterIpv4Cidr())) return false;
    if (!getNodeIpv4Cidr().equals(other.getNodeIpv4Cidr())) return false;
    if (!getServicesIpv4Cidr().equals(other.getServicesIpv4Cidr())) return false;
    if (!getClusterSecondaryRangeName().equals(other.getClusterSecondaryRangeName())) return false;
    if (!getServicesSecondaryRangeName().equals(other.getServicesSecondaryRangeName()))
      return false;
    if (!getClusterIpv4CidrBlock().equals(other.getClusterIpv4CidrBlock())) return false;
    if (!getNodeIpv4CidrBlock().equals(other.getNodeIpv4CidrBlock())) return false;
    if (!getServicesIpv4CidrBlock().equals(other.getServicesIpv4CidrBlock())) return false;
    if (!getTpuIpv4CidrBlock().equals(other.getTpuIpv4CidrBlock())) return false;
    if (getUseRoutes() != other.getUseRoutes()) return false;
    if (stackType_ != other.stackType_) return false;
    if (ipv6AccessType_ != other.ipv6AccessType_) return false;
    if (hasPodCidrOverprovisionConfig() != other.hasPodCidrOverprovisionConfig()) return false;
    if (hasPodCidrOverprovisionConfig()) {
      if (!getPodCidrOverprovisionConfig().equals(other.getPodCidrOverprovisionConfig()))
        return false;
    }
    if (!getSubnetIpv6CidrBlock().equals(other.getSubnetIpv6CidrBlock())) return false;
    if (!getServicesIpv6CidrBlock().equals(other.getServicesIpv6CidrBlock())) return false;
    if (hasAdditionalPodRangesConfig() != other.hasAdditionalPodRangesConfig()) return false;
    if (hasAdditionalPodRangesConfig()) {
      if (!getAdditionalPodRangesConfig().equals(other.getAdditionalPodRangesConfig()))
        return false;
    }
    if (java.lang.Double.doubleToLongBits(getDefaultPodIpv4RangeUtilization())
        != java.lang.Double.doubleToLongBits(other.getDefaultPodIpv4RangeUtilization()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USE_IP_ALIASES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseIpAliases());
    hash = (37 * hash) + CREATE_SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCreateSubnetwork());
    hash = (37 * hash) + SUBNETWORK_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetworkName().hashCode();
    hash = (37 * hash) + CLUSTER_IPV4_CIDR_FIELD_NUMBER;
    hash = (53 * hash) + getClusterIpv4Cidr().hashCode();
    hash = (37 * hash) + NODE_IPV4_CIDR_FIELD_NUMBER;
    hash = (53 * hash) + getNodeIpv4Cidr().hashCode();
    hash = (37 * hash) + SERVICES_IPV4_CIDR_FIELD_NUMBER;
    hash = (53 * hash) + getServicesIpv4Cidr().hashCode();
    hash = (37 * hash) + CLUSTER_SECONDARY_RANGE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getClusterSecondaryRangeName().hashCode();
    hash = (37 * hash) + SERVICES_SECONDARY_RANGE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServicesSecondaryRangeName().hashCode();
    hash = (37 * hash) + CLUSTER_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getClusterIpv4CidrBlock().hashCode();
    hash = (37 * hash) + NODE_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getNodeIpv4CidrBlock().hashCode();
    hash = (37 * hash) + SERVICES_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getServicesIpv4CidrBlock().hashCode();
    hash = (37 * hash) + TPU_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getTpuIpv4CidrBlock().hashCode();
    hash = (37 * hash) + USE_ROUTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseRoutes());
    hash = (37 * hash) + STACK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + stackType_;
    hash = (37 * hash) + IPV6_ACCESS_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + ipv6AccessType_;
    if (hasPodCidrOverprovisionConfig()) {
      hash = (37 * hash) + POD_CIDR_OVERPROVISION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPodCidrOverprovisionConfig().hashCode();
    }
    hash = (37 * hash) + SUBNET_IPV6_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetIpv6CidrBlock().hashCode();
    hash = (37 * hash) + SERVICES_IPV6_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getServicesIpv6CidrBlock().hashCode();
    if (hasAdditionalPodRangesConfig()) {
      hash = (37 * hash) + ADDITIONAL_POD_RANGES_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalPodRangesConfig().hashCode();
    }
    hash = (37 * hash) + DEFAULT_POD_IPV4_RANGE_UTILIZATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDefaultPodIpv4RangeUtilization()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.IPAllocationPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.IPAllocationPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.IPAllocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.IPAllocationPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for controlling how IPs are allocated in the cluster.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.IPAllocationPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.IPAllocationPolicy)
      com.google.container.v1.IPAllocationPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_IPAllocationPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_IPAllocationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.IPAllocationPolicy.class,
              com.google.container.v1.IPAllocationPolicy.Builder.class);
    }

    // Construct using com.google.container.v1.IPAllocationPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPodCidrOverprovisionConfigFieldBuilder();
        getAdditionalPodRangesConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      useIpAliases_ = false;
      createSubnetwork_ = false;
      subnetworkName_ = "";
      clusterIpv4Cidr_ = "";
      nodeIpv4Cidr_ = "";
      servicesIpv4Cidr_ = "";
      clusterSecondaryRangeName_ = "";
      servicesSecondaryRangeName_ = "";
      clusterIpv4CidrBlock_ = "";
      nodeIpv4CidrBlock_ = "";
      servicesIpv4CidrBlock_ = "";
      tpuIpv4CidrBlock_ = "";
      useRoutes_ = false;
      stackType_ = 0;
      ipv6AccessType_ = 0;
      podCidrOverprovisionConfig_ = null;
      if (podCidrOverprovisionConfigBuilder_ != null) {
        podCidrOverprovisionConfigBuilder_.dispose();
        podCidrOverprovisionConfigBuilder_ = null;
      }
      subnetIpv6CidrBlock_ = "";
      servicesIpv6CidrBlock_ = "";
      additionalPodRangesConfig_ = null;
      if (additionalPodRangesConfigBuilder_ != null) {
        additionalPodRangesConfigBuilder_.dispose();
        additionalPodRangesConfigBuilder_ = null;
      }
      defaultPodIpv4RangeUtilization_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_IPAllocationPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.IPAllocationPolicy getDefaultInstanceForType() {
      return com.google.container.v1.IPAllocationPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.IPAllocationPolicy build() {
      com.google.container.v1.IPAllocationPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.IPAllocationPolicy buildPartial() {
      com.google.container.v1.IPAllocationPolicy result =
          new com.google.container.v1.IPAllocationPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.IPAllocationPolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.useIpAliases_ = useIpAliases_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createSubnetwork_ = createSubnetwork_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.subnetworkName_ = subnetworkName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.clusterIpv4Cidr_ = clusterIpv4Cidr_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nodeIpv4Cidr_ = nodeIpv4Cidr_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.servicesIpv4Cidr_ = servicesIpv4Cidr_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.clusterSecondaryRangeName_ = clusterSecondaryRangeName_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.servicesSecondaryRangeName_ = servicesSecondaryRangeName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.clusterIpv4CidrBlock_ = clusterIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.nodeIpv4CidrBlock_ = nodeIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.servicesIpv4CidrBlock_ = servicesIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.tpuIpv4CidrBlock_ = tpuIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.useRoutes_ = useRoutes_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.stackType_ = stackType_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.ipv6AccessType_ = ipv6AccessType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.podCidrOverprovisionConfig_ =
            podCidrOverprovisionConfigBuilder_ == null
                ? podCidrOverprovisionConfig_
                : podCidrOverprovisionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.subnetIpv6CidrBlock_ = subnetIpv6CidrBlock_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.servicesIpv6CidrBlock_ = servicesIpv6CidrBlock_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.additionalPodRangesConfig_ =
            additionalPodRangesConfigBuilder_ == null
                ? additionalPodRangesConfig_
                : additionalPodRangesConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.defaultPodIpv4RangeUtilization_ = defaultPodIpv4RangeUtilization_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.IPAllocationPolicy) {
        return mergeFrom((com.google.container.v1.IPAllocationPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.IPAllocationPolicy other) {
      if (other == com.google.container.v1.IPAllocationPolicy.getDefaultInstance()) return this;
      if (other.getUseIpAliases() != false) {
        setUseIpAliases(other.getUseIpAliases());
      }
      if (other.getCreateSubnetwork() != false) {
        setCreateSubnetwork(other.getCreateSubnetwork());
      }
      if (!other.getSubnetworkName().isEmpty()) {
        subnetworkName_ = other.subnetworkName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getClusterIpv4Cidr().isEmpty()) {
        clusterIpv4Cidr_ = other.clusterIpv4Cidr_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getNodeIpv4Cidr().isEmpty()) {
        nodeIpv4Cidr_ = other.nodeIpv4Cidr_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getServicesIpv4Cidr().isEmpty()) {
        servicesIpv4Cidr_ = other.servicesIpv4Cidr_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getClusterSecondaryRangeName().isEmpty()) {
        clusterSecondaryRangeName_ = other.clusterSecondaryRangeName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getServicesSecondaryRangeName().isEmpty()) {
        servicesSecondaryRangeName_ = other.servicesSecondaryRangeName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getClusterIpv4CidrBlock().isEmpty()) {
        clusterIpv4CidrBlock_ = other.clusterIpv4CidrBlock_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getNodeIpv4CidrBlock().isEmpty()) {
        nodeIpv4CidrBlock_ = other.nodeIpv4CidrBlock_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getServicesIpv4CidrBlock().isEmpty()) {
        servicesIpv4CidrBlock_ = other.servicesIpv4CidrBlock_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getTpuIpv4CidrBlock().isEmpty()) {
        tpuIpv4CidrBlock_ = other.tpuIpv4CidrBlock_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.getUseRoutes() != false) {
        setUseRoutes(other.getUseRoutes());
      }
      if (other.stackType_ != 0) {
        setStackTypeValue(other.getStackTypeValue());
      }
      if (other.ipv6AccessType_ != 0) {
        setIpv6AccessTypeValue(other.getIpv6AccessTypeValue());
      }
      if (other.hasPodCidrOverprovisionConfig()) {
        mergePodCidrOverprovisionConfig(other.getPodCidrOverprovisionConfig());
      }
      if (!other.getSubnetIpv6CidrBlock().isEmpty()) {
        subnetIpv6CidrBlock_ = other.subnetIpv6CidrBlock_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (!other.getServicesIpv6CidrBlock().isEmpty()) {
        servicesIpv6CidrBlock_ = other.servicesIpv6CidrBlock_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasAdditionalPodRangesConfig()) {
        mergeAdditionalPodRangesConfig(other.getAdditionalPodRangesConfig());
      }
      if (other.getDefaultPodIpv4RangeUtilization() != 0D) {
        setDefaultPodIpv4RangeUtilization(other.getDefaultPodIpv4RangeUtilization());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                useIpAliases_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                createSubnetwork_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                subnetworkName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                clusterIpv4Cidr_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                nodeIpv4Cidr_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                servicesIpv4Cidr_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                clusterSecondaryRangeName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                servicesSecondaryRangeName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                clusterIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                nodeIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                servicesIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 106:
              {
                tpuIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 120:
              {
                useRoutes_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 120
            case 128:
              {
                stackType_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 128
            case 136:
              {
                ipv6AccessType_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 136
            case 170:
              {
                input.readMessage(
                    getPodCidrOverprovisionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 170
            case 178:
              {
                subnetIpv6CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 178
            case 186:
              {
                servicesIpv6CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getAdditionalPodRangesConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 194
            case 201:
              {
                defaultPodIpv4RangeUtilization_ = input.readDouble();
                bitField0_ |= 0x00080000;
                break;
              } // case 201
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean useIpAliases_;
    /**
     *
     *
     * <pre>
     * Whether alias IPs will be used for pod IPs in the cluster.
     * This is used in conjunction with use_routes. It cannot
     * be true if use_routes is true. If both use_ip_aliases and use_routes are
     * false, then the server picks the default IP allocation mode
     * </pre>
     *
     * <code>bool use_ip_aliases = 1;</code>
     *
     * @return The useIpAliases.
     */
    @java.lang.Override
    public boolean getUseIpAliases() {
      return useIpAliases_;
    }
    /**
     *
     *
     * <pre>
     * Whether alias IPs will be used for pod IPs in the cluster.
     * This is used in conjunction with use_routes. It cannot
     * be true if use_routes is true. If both use_ip_aliases and use_routes are
     * false, then the server picks the default IP allocation mode
     * </pre>
     *
     * <code>bool use_ip_aliases = 1;</code>
     *
     * @param value The useIpAliases to set.
     * @return This builder for chaining.
     */
    public Builder setUseIpAliases(boolean value) {

      useIpAliases_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether alias IPs will be used for pod IPs in the cluster.
     * This is used in conjunction with use_routes. It cannot
     * be true if use_routes is true. If both use_ip_aliases and use_routes are
     * false, then the server picks the default IP allocation mode
     * </pre>
     *
     * <code>bool use_ip_aliases = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseIpAliases() {
      bitField0_ = (bitField0_ & ~0x00000001);
      useIpAliases_ = false;
      onChanged();
      return this;
    }

    private boolean createSubnetwork_;
    /**
     *
     *
     * <pre>
     * Whether a new subnetwork will be created automatically for the cluster.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>bool create_subnetwork = 2;</code>
     *
     * @return The createSubnetwork.
     */
    @java.lang.Override
    public boolean getCreateSubnetwork() {
      return createSubnetwork_;
    }
    /**
     *
     *
     * <pre>
     * Whether a new subnetwork will be created automatically for the cluster.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>bool create_subnetwork = 2;</code>
     *
     * @param value The createSubnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setCreateSubnetwork(boolean value) {

      createSubnetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether a new subnetwork will be created automatically for the cluster.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     * </pre>
     *
     * <code>bool create_subnetwork = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreateSubnetwork() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createSubnetwork_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object subnetworkName_ = "";
    /**
     *
     *
     * <pre>
     * A custom subnetwork name to be used if `create_subnetwork` is true.  If
     * this field is empty, then an automatic name will be chosen for the new
     * subnetwork.
     * </pre>
     *
     * <code>string subnetwork_name = 3;</code>
     *
     * @return The subnetworkName.
     */
    public java.lang.String getSubnetworkName() {
      java.lang.Object ref = subnetworkName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetworkName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A custom subnetwork name to be used if `create_subnetwork` is true.  If
     * this field is empty, then an automatic name will be chosen for the new
     * subnetwork.
     * </pre>
     *
     * <code>string subnetwork_name = 3;</code>
     *
     * @return The bytes for subnetworkName.
     */
    public com.google.protobuf.ByteString getSubnetworkNameBytes() {
      java.lang.Object ref = subnetworkName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetworkName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A custom subnetwork name to be used if `create_subnetwork` is true.  If
     * this field is empty, then an automatic name will be chosen for the new
     * subnetwork.
     * </pre>
     *
     * <code>string subnetwork_name = 3;</code>
     *
     * @param value The subnetworkName to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetworkName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A custom subnetwork name to be used if `create_subnetwork` is true.  If
     * this field is empty, then an automatic name will be chosen for the new
     * subnetwork.
     * </pre>
     *
     * <code>string subnetwork_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetworkName() {
      subnetworkName_ = getDefaultInstance().getSubnetworkName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A custom subnetwork name to be used if `create_subnetwork` is true.  If
     * this field is empty, then an automatic name will be chosen for the new
     * subnetwork.
     * </pre>
     *
     * <code>string subnetwork_name = 3;</code>
     *
     * @param value The bytes for subnetworkName to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetworkName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object clusterIpv4Cidr_ = "";
    /**
     *
     *
     * <pre>
     * This field is deprecated, use cluster_ipv4_cidr_block.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1581
     * @return The clusterIpv4Cidr.
     */
    @java.lang.Deprecated
    public java.lang.String getClusterIpv4Cidr() {
      java.lang.Object ref = clusterIpv4Cidr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterIpv4Cidr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use cluster_ipv4_cidr_block.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1581
     * @return The bytes for clusterIpv4Cidr.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getClusterIpv4CidrBytes() {
      java.lang.Object ref = clusterIpv4Cidr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterIpv4Cidr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use cluster_ipv4_cidr_block.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1581
     * @param value The clusterIpv4Cidr to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterIpv4Cidr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterIpv4Cidr_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use cluster_ipv4_cidr_block.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1581
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearClusterIpv4Cidr() {
      clusterIpv4Cidr_ = getDefaultInstance().getClusterIpv4Cidr();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use cluster_ipv4_cidr_block.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.cluster_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1581
     * @param value The bytes for clusterIpv4Cidr to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterIpv4CidrBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterIpv4Cidr_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object nodeIpv4Cidr_ = "";
    /**
     *
     *
     * <pre>
     * This field is deprecated, use node_ipv4_cidr_block.
     * </pre>
     *
     * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1584
     * @return The nodeIpv4Cidr.
     */
    @java.lang.Deprecated
    public java.lang.String getNodeIpv4Cidr() {
      java.lang.Object ref = nodeIpv4Cidr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeIpv4Cidr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use node_ipv4_cidr_block.
     * </pre>
     *
     * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1584
     * @return The bytes for nodeIpv4Cidr.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getNodeIpv4CidrBytes() {
      java.lang.Object ref = nodeIpv4Cidr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeIpv4Cidr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use node_ipv4_cidr_block.
     * </pre>
     *
     * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1584
     * @param value The nodeIpv4Cidr to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNodeIpv4Cidr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeIpv4Cidr_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use node_ipv4_cidr_block.
     * </pre>
     *
     * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1584
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearNodeIpv4Cidr() {
      nodeIpv4Cidr_ = getDefaultInstance().getNodeIpv4Cidr();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use node_ipv4_cidr_block.
     * </pre>
     *
     * <code>string node_ipv4_cidr = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.node_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1584
     * @param value The bytes for nodeIpv4Cidr to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNodeIpv4CidrBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeIpv4Cidr_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object servicesIpv4Cidr_ = "";
    /**
     *
     *
     * <pre>
     * This field is deprecated, use services_ipv4_cidr_block.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1587
     * @return The servicesIpv4Cidr.
     */
    @java.lang.Deprecated
    public java.lang.String getServicesIpv4Cidr() {
      java.lang.Object ref = servicesIpv4Cidr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesIpv4Cidr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use services_ipv4_cidr_block.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1587
     * @return The bytes for servicesIpv4Cidr.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getServicesIpv4CidrBytes() {
      java.lang.Object ref = servicesIpv4Cidr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesIpv4Cidr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use services_ipv4_cidr_block.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1587
     * @param value The servicesIpv4Cidr to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServicesIpv4Cidr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesIpv4Cidr_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use services_ipv4_cidr_block.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1587
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearServicesIpv4Cidr() {
      servicesIpv4Cidr_ = getDefaultInstance().getServicesIpv4Cidr();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated, use services_ipv4_cidr_block.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 6 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.IPAllocationPolicy.services_ipv4_cidr is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1587
     * @param value The bytes for servicesIpv4Cidr to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServicesIpv4CidrBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesIpv4Cidr_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object clusterSecondaryRangeName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used for the cluster CIDR
     * block.  The secondary range will be used for pod IP
     * addresses. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 7;</code>
     *
     * @return The clusterSecondaryRangeName.
     */
    public java.lang.String getClusterSecondaryRangeName() {
      java.lang.Object ref = clusterSecondaryRangeName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterSecondaryRangeName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used for the cluster CIDR
     * block.  The secondary range will be used for pod IP
     * addresses. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 7;</code>
     *
     * @return The bytes for clusterSecondaryRangeName.
     */
    public com.google.protobuf.ByteString getClusterSecondaryRangeNameBytes() {
      java.lang.Object ref = clusterSecondaryRangeName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterSecondaryRangeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used for the cluster CIDR
     * block.  The secondary range will be used for pod IP
     * addresses. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 7;</code>
     *
     * @param value The clusterSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterSecondaryRangeName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterSecondaryRangeName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used for the cluster CIDR
     * block.  The secondary range will be used for pod IP
     * addresses. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterSecondaryRangeName() {
      clusterSecondaryRangeName_ = getDefaultInstance().getClusterSecondaryRangeName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used for the cluster CIDR
     * block.  The secondary range will be used for pod IP
     * addresses. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string cluster_secondary_range_name = 7;</code>
     *
     * @param value The bytes for clusterSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setClusterSecondaryRangeNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterSecondaryRangeName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object servicesSecondaryRangeName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used as for the services
     * CIDR block.  The secondary range will be used for service
     * ClusterIPs. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string services_secondary_range_name = 8;</code>
     *
     * @return The servicesSecondaryRangeName.
     */
    public java.lang.String getServicesSecondaryRangeName() {
      java.lang.Object ref = servicesSecondaryRangeName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesSecondaryRangeName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used as for the services
     * CIDR block.  The secondary range will be used for service
     * ClusterIPs. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string services_secondary_range_name = 8;</code>
     *
     * @return The bytes for servicesSecondaryRangeName.
     */
    public com.google.protobuf.ByteString getServicesSecondaryRangeNameBytes() {
      java.lang.Object ref = servicesSecondaryRangeName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesSecondaryRangeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used as for the services
     * CIDR block.  The secondary range will be used for service
     * ClusterIPs. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string services_secondary_range_name = 8;</code>
     *
     * @param value The servicesSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setServicesSecondaryRangeName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesSecondaryRangeName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used as for the services
     * CIDR block.  The secondary range will be used for service
     * ClusterIPs. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string services_secondary_range_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesSecondaryRangeName() {
      servicesSecondaryRangeName_ = getDefaultInstance().getServicesSecondaryRangeName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the secondary range to be used as for the services
     * CIDR block.  The secondary range will be used for service
     * ClusterIPs. This must be an existing secondary range associated
     * with the cluster subnetwork.
     *
     * This field is only applicable with use_ip_aliases is true and
     * create_subnetwork is false.
     * </pre>
     *
     * <code>string services_secondary_range_name = 8;</code>
     *
     * @param value The bytes for servicesSecondaryRangeName to set.
     * @return This builder for chaining.
     */
    public Builder setServicesSecondaryRangeNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesSecondaryRangeName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object clusterIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range for the cluster pod IPs. If this field is set, then
     * `cluster.cluster_ipv4_cidr` must be left blank.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 9;</code>
     *
     * @return The clusterIpv4CidrBlock.
     */
    public java.lang.String getClusterIpv4CidrBlock() {
      java.lang.Object ref = clusterIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range for the cluster pod IPs. If this field is set, then
     * `cluster.cluster_ipv4_cidr` must be left blank.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 9;</code>
     *
     * @return The bytes for clusterIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getClusterIpv4CidrBlockBytes() {
      java.lang.Object ref = clusterIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range for the cluster pod IPs. If this field is set, then
     * `cluster.cluster_ipv4_cidr` must be left blank.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 9;</code>
     *
     * @param value The clusterIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range for the cluster pod IPs. If this field is set, then
     * `cluster.cluster_ipv4_cidr` must be left blank.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterIpv4CidrBlock() {
      clusterIpv4CidrBlock_ = getDefaultInstance().getClusterIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range for the cluster pod IPs. If this field is set, then
     * `cluster.cluster_ipv4_cidr` must be left blank.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr_block = 9;</code>
     *
     * @param value The bytes for clusterIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object nodeIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range of the instance IPs in this cluster.
     *
     * This is applicable only if `create_subnetwork` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string node_ipv4_cidr_block = 10;</code>
     *
     * @return The nodeIpv4CidrBlock.
     */
    public java.lang.String getNodeIpv4CidrBlock() {
      java.lang.Object ref = nodeIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the instance IPs in this cluster.
     *
     * This is applicable only if `create_subnetwork` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string node_ipv4_cidr_block = 10;</code>
     *
     * @return The bytes for nodeIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getNodeIpv4CidrBlockBytes() {
      java.lang.Object ref = nodeIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the instance IPs in this cluster.
     *
     * This is applicable only if `create_subnetwork` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string node_ipv4_cidr_block = 10;</code>
     *
     * @param value The nodeIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setNodeIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the instance IPs in this cluster.
     *
     * This is applicable only if `create_subnetwork` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string node_ipv4_cidr_block = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeIpv4CidrBlock() {
      nodeIpv4CidrBlock_ = getDefaultInstance().getNodeIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the instance IPs in this cluster.
     *
     * This is applicable only if `create_subnetwork` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string node_ipv4_cidr_block = 10;</code>
     *
     * @param value The bytes for nodeIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setNodeIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object servicesIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range of the services IPs in this cluster. If blank, a range
     * will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 11;</code>
     *
     * @return The servicesIpv4CidrBlock.
     */
    public java.lang.String getServicesIpv4CidrBlock() {
      java.lang.Object ref = servicesIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the services IPs in this cluster. If blank, a range
     * will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 11;</code>
     *
     * @return The bytes for servicesIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getServicesIpv4CidrBlockBytes() {
      java.lang.Object ref = servicesIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the services IPs in this cluster. If blank, a range
     * will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 11;</code>
     *
     * @param value The servicesIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the services IPs in this cluster. If blank, a range
     * will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesIpv4CidrBlock() {
      servicesIpv4CidrBlock_ = getDefaultInstance().getServicesIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the services IPs in this cluster. If blank, a range
     * will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string services_ipv4_cidr_block = 11;</code>
     *
     * @param value The bytes for servicesIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object tpuIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
     * range will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * If unspecified, the range will use the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 13;</code>
     *
     * @return The tpuIpv4CidrBlock.
     */
    public java.lang.String getTpuIpv4CidrBlock() {
      java.lang.Object ref = tpuIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tpuIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
     * range will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * If unspecified, the range will use the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 13;</code>
     *
     * @return The bytes for tpuIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getTpuIpv4CidrBlockBytes() {
      java.lang.Object ref = tpuIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tpuIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
     * range will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * If unspecified, the range will use the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 13;</code>
     *
     * @param value The tpuIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setTpuIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tpuIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
     * range will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * If unspecified, the range will use the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTpuIpv4CidrBlock() {
      tpuIpv4CidrBlock_ = getDefaultInstance().getTpuIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the Cloud TPUs in this cluster. If unspecified, a
     * range will be automatically chosen with the default size.
     *
     * This field is only applicable when `use_ip_aliases` is true.
     *
     * If unspecified, the range will use the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
     * `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
     * to use.
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 13;</code>
     *
     * @param value The bytes for tpuIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setTpuIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tpuIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private boolean useRoutes_;
    /**
     *
     *
     * <pre>
     * Whether routes will be used for pod IPs in the cluster.
     * This is used in conjunction with use_ip_aliases. It cannot be true if
     * use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
     * then the server picks the default IP allocation mode
     * </pre>
     *
     * <code>bool use_routes = 15;</code>
     *
     * @return The useRoutes.
     */
    @java.lang.Override
    public boolean getUseRoutes() {
      return useRoutes_;
    }
    /**
     *
     *
     * <pre>
     * Whether routes will be used for pod IPs in the cluster.
     * This is used in conjunction with use_ip_aliases. It cannot be true if
     * use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
     * then the server picks the default IP allocation mode
     * </pre>
     *
     * <code>bool use_routes = 15;</code>
     *
     * @param value The useRoutes to set.
     * @return This builder for chaining.
     */
    public Builder setUseRoutes(boolean value) {

      useRoutes_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether routes will be used for pod IPs in the cluster.
     * This is used in conjunction with use_ip_aliases. It cannot be true if
     * use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
     * then the server picks the default IP allocation mode
     * </pre>
     *
     * <code>bool use_routes = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseRoutes() {
      bitField0_ = (bitField0_ & ~0x00001000);
      useRoutes_ = false;
      onChanged();
      return this;
    }

    private int stackType_ = 0;
    /**
     *
     *
     * <pre>
     * The IP stack type of the cluster
     * </pre>
     *
     * <code>.google.container.v1.StackType stack_type = 16;</code>
     *
     * @return The enum numeric value on the wire for stackType.
     */
    @java.lang.Override
    public int getStackTypeValue() {
      return stackType_;
    }
    /**
     *
     *
     * <pre>
     * The IP stack type of the cluster
     * </pre>
     *
     * <code>.google.container.v1.StackType stack_type = 16;</code>
     *
     * @param value The enum numeric value on the wire for stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackTypeValue(int value) {
      stackType_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP stack type of the cluster
     * </pre>
     *
     * <code>.google.container.v1.StackType stack_type = 16;</code>
     *
     * @return The stackType.
     */
    @java.lang.Override
    public com.google.container.v1.StackType getStackType() {
      com.google.container.v1.StackType result =
          com.google.container.v1.StackType.forNumber(stackType_);
      return result == null ? com.google.container.v1.StackType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The IP stack type of the cluster
     * </pre>
     *
     * <code>.google.container.v1.StackType stack_type = 16;</code>
     *
     * @param value The stackType to set.
     * @return This builder for chaining.
     */
    public Builder setStackType(com.google.container.v1.StackType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      stackType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP stack type of the cluster
     * </pre>
     *
     * <code>.google.container.v1.StackType stack_type = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStackType() {
      bitField0_ = (bitField0_ & ~0x00002000);
      stackType_ = 0;
      onChanged();
      return this;
    }

    private int ipv6AccessType_ = 0;
    /**
     *
     *
     * <pre>
     * The ipv6 access type (internal or external) when create_subnetwork is true
     * </pre>
     *
     * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
     *
     * @return The enum numeric value on the wire for ipv6AccessType.
     */
    @java.lang.Override
    public int getIpv6AccessTypeValue() {
      return ipv6AccessType_;
    }
    /**
     *
     *
     * <pre>
     * The ipv6 access type (internal or external) when create_subnetwork is true
     * </pre>
     *
     * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
     *
     * @param value The enum numeric value on the wire for ipv6AccessType to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6AccessTypeValue(int value) {
      ipv6AccessType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ipv6 access type (internal or external) when create_subnetwork is true
     * </pre>
     *
     * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
     *
     * @return The ipv6AccessType.
     */
    @java.lang.Override
    public com.google.container.v1.IPv6AccessType getIpv6AccessType() {
      com.google.container.v1.IPv6AccessType result =
          com.google.container.v1.IPv6AccessType.forNumber(ipv6AccessType_);
      return result == null ? com.google.container.v1.IPv6AccessType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The ipv6 access type (internal or external) when create_subnetwork is true
     * </pre>
     *
     * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
     *
     * @param value The ipv6AccessType to set.
     * @return This builder for chaining.
     */
    public Builder setIpv6AccessType(com.google.container.v1.IPv6AccessType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      ipv6AccessType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ipv6 access type (internal or external) when create_subnetwork is true
     * </pre>
     *
     * <code>.google.container.v1.IPv6AccessType ipv6_access_type = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpv6AccessType() {
      bitField0_ = (bitField0_ & ~0x00004000);
      ipv6AccessType_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1.PodCIDROverprovisionConfig podCidrOverprovisionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.PodCIDROverprovisionConfig,
            com.google.container.v1.PodCIDROverprovisionConfig.Builder,
            com.google.container.v1.PodCIDROverprovisionConfigOrBuilder>
        podCidrOverprovisionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     *
     * @return Whether the podCidrOverprovisionConfig field is set.
     */
    public boolean hasPodCidrOverprovisionConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     *
     * @return The podCidrOverprovisionConfig.
     */
    public com.google.container.v1.PodCIDROverprovisionConfig getPodCidrOverprovisionConfig() {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        return podCidrOverprovisionConfig_ == null
            ? com.google.container.v1.PodCIDROverprovisionConfig.getDefaultInstance()
            : podCidrOverprovisionConfig_;
      } else {
        return podCidrOverprovisionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    public Builder setPodCidrOverprovisionConfig(
        com.google.container.v1.PodCIDROverprovisionConfig value) {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        podCidrOverprovisionConfig_ = value;
      } else {
        podCidrOverprovisionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    public Builder setPodCidrOverprovisionConfig(
        com.google.container.v1.PodCIDROverprovisionConfig.Builder builderForValue) {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        podCidrOverprovisionConfig_ = builderForValue.build();
      } else {
        podCidrOverprovisionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    public Builder mergePodCidrOverprovisionConfig(
        com.google.container.v1.PodCIDROverprovisionConfig value) {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && podCidrOverprovisionConfig_ != null
            && podCidrOverprovisionConfig_
                != com.google.container.v1.PodCIDROverprovisionConfig.getDefaultInstance()) {
          getPodCidrOverprovisionConfigBuilder().mergeFrom(value);
        } else {
          podCidrOverprovisionConfig_ = value;
        }
      } else {
        podCidrOverprovisionConfigBuilder_.mergeFrom(value);
      }
      if (podCidrOverprovisionConfig_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    public Builder clearPodCidrOverprovisionConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      podCidrOverprovisionConfig_ = null;
      if (podCidrOverprovisionConfigBuilder_ != null) {
        podCidrOverprovisionConfigBuilder_.dispose();
        podCidrOverprovisionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    public com.google.container.v1.PodCIDROverprovisionConfig.Builder
        getPodCidrOverprovisionConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getPodCidrOverprovisionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    public com.google.container.v1.PodCIDROverprovisionConfigOrBuilder
        getPodCidrOverprovisionConfigOrBuilder() {
      if (podCidrOverprovisionConfigBuilder_ != null) {
        return podCidrOverprovisionConfigBuilder_.getMessageOrBuilder();
      } else {
        return podCidrOverprovisionConfig_ == null
            ? com.google.container.v1.PodCIDROverprovisionConfig.getDefaultInstance()
            : podCidrOverprovisionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the cluster.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is doubled and then rounded off to next power of 2 to
     * get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.PodCIDROverprovisionConfig,
            com.google.container.v1.PodCIDROverprovisionConfig.Builder,
            com.google.container.v1.PodCIDROverprovisionConfigOrBuilder>
        getPodCidrOverprovisionConfigFieldBuilder() {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        podCidrOverprovisionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.PodCIDROverprovisionConfig,
                com.google.container.v1.PodCIDROverprovisionConfig.Builder,
                com.google.container.v1.PodCIDROverprovisionConfigOrBuilder>(
                getPodCidrOverprovisionConfig(), getParentForChildren(), isClean());
        podCidrOverprovisionConfig_ = null;
      }
      return podCidrOverprovisionConfigBuilder_;
    }

    private java.lang.Object subnetIpv6CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
     * </pre>
     *
     * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The subnetIpv6CidrBlock.
     */
    public java.lang.String getSubnetIpv6CidrBlock() {
      java.lang.Object ref = subnetIpv6CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetIpv6CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
     * </pre>
     *
     * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for subnetIpv6CidrBlock.
     */
    public com.google.protobuf.ByteString getSubnetIpv6CidrBlockBytes() {
      java.lang.Object ref = subnetIpv6CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetIpv6CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
     * </pre>
     *
     * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The subnetIpv6CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetIpv6CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetIpv6CidrBlock_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
     * </pre>
     *
     * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetIpv6CidrBlock() {
      subnetIpv6CidrBlock_ = getDefaultInstance().getSubnetIpv6CidrBlock();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The subnet's IPv6 CIDR block used by nodes and pods.
     * </pre>
     *
     * <code>string subnet_ipv6_cidr_block = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for subnetIpv6CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetIpv6CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetIpv6CidrBlock_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object servicesIpv6CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The services IPv6 CIDR block for the cluster.
     * </pre>
     *
     * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The servicesIpv6CidrBlock.
     */
    public java.lang.String getServicesIpv6CidrBlock() {
      java.lang.Object ref = servicesIpv6CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesIpv6CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The services IPv6 CIDR block for the cluster.
     * </pre>
     *
     * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for servicesIpv6CidrBlock.
     */
    public com.google.protobuf.ByteString getServicesIpv6CidrBlockBytes() {
      java.lang.Object ref = servicesIpv6CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesIpv6CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The services IPv6 CIDR block for the cluster.
     * </pre>
     *
     * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The servicesIpv6CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv6CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesIpv6CidrBlock_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The services IPv6 CIDR block for the cluster.
     * </pre>
     *
     * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesIpv6CidrBlock() {
      servicesIpv6CidrBlock_ = getDefaultInstance().getServicesIpv6CidrBlock();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The services IPv6 CIDR block for the cluster.
     * </pre>
     *
     * <code>string services_ipv6_cidr_block = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for servicesIpv6CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv6CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesIpv6CidrBlock_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.container.v1.AdditionalPodRangesConfig additionalPodRangesConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AdditionalPodRangesConfig,
            com.google.container.v1.AdditionalPodRangesConfig.Builder,
            com.google.container.v1.AdditionalPodRangesConfigOrBuilder>
        additionalPodRangesConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the additionalPodRangesConfig field is set.
     */
    public boolean hasAdditionalPodRangesConfig() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The additionalPodRangesConfig.
     */
    public com.google.container.v1.AdditionalPodRangesConfig getAdditionalPodRangesConfig() {
      if (additionalPodRangesConfigBuilder_ == null) {
        return additionalPodRangesConfig_ == null
            ? com.google.container.v1.AdditionalPodRangesConfig.getDefaultInstance()
            : additionalPodRangesConfig_;
      } else {
        return additionalPodRangesConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdditionalPodRangesConfig(
        com.google.container.v1.AdditionalPodRangesConfig value) {
      if (additionalPodRangesConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        additionalPodRangesConfig_ = value;
      } else {
        additionalPodRangesConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdditionalPodRangesConfig(
        com.google.container.v1.AdditionalPodRangesConfig.Builder builderForValue) {
      if (additionalPodRangesConfigBuilder_ == null) {
        additionalPodRangesConfig_ = builderForValue.build();
      } else {
        additionalPodRangesConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAdditionalPodRangesConfig(
        com.google.container.v1.AdditionalPodRangesConfig value) {
      if (additionalPodRangesConfigBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && additionalPodRangesConfig_ != null
            && additionalPodRangesConfig_
                != com.google.container.v1.AdditionalPodRangesConfig.getDefaultInstance()) {
          getAdditionalPodRangesConfigBuilder().mergeFrom(value);
        } else {
          additionalPodRangesConfig_ = value;
        }
      } else {
        additionalPodRangesConfigBuilder_.mergeFrom(value);
      }
      if (additionalPodRangesConfig_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAdditionalPodRangesConfig() {
      bitField0_ = (bitField0_ & ~0x00040000);
      additionalPodRangesConfig_ = null;
      if (additionalPodRangesConfigBuilder_ != null) {
        additionalPodRangesConfigBuilder_.dispose();
        additionalPodRangesConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.AdditionalPodRangesConfig.Builder
        getAdditionalPodRangesConfigBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getAdditionalPodRangesConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.AdditionalPodRangesConfigOrBuilder
        getAdditionalPodRangesConfigOrBuilder() {
      if (additionalPodRangesConfigBuilder_ != null) {
        return additionalPodRangesConfigBuilder_.getMessageOrBuilder();
      } else {
        return additionalPodRangesConfig_ == null
            ? com.google.container.v1.AdditionalPodRangesConfig.getDefaultInstance()
            : additionalPodRangesConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The additional pod ranges that are added to the cluster.
     * These pod ranges can be used by new node pools to allocate pod IPs
     * automatically. Once the range is removed it will not show up in
     * IPAllocationPolicy.
     * </pre>
     *
     * <code>
     * .google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AdditionalPodRangesConfig,
            com.google.container.v1.AdditionalPodRangesConfig.Builder,
            com.google.container.v1.AdditionalPodRangesConfigOrBuilder>
        getAdditionalPodRangesConfigFieldBuilder() {
      if (additionalPodRangesConfigBuilder_ == null) {
        additionalPodRangesConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.AdditionalPodRangesConfig,
                com.google.container.v1.AdditionalPodRangesConfig.Builder,
                com.google.container.v1.AdditionalPodRangesConfigOrBuilder>(
                getAdditionalPodRangesConfig(), getParentForChildren(), isClean());
        additionalPodRangesConfig_ = null;
      }
      return additionalPodRangesConfigBuilder_;
    }

    private double defaultPodIpv4RangeUtilization_;
    /**
     *
     *
     * <pre>
     * Output only. The utilization of the cluster default IPv4 range for the
     * pod. The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     * </pre>
     *
     * <code>
     * double default_pod_ipv4_range_utilization = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The defaultPodIpv4RangeUtilization.
     */
    @java.lang.Override
    public double getDefaultPodIpv4RangeUtilization() {
      return defaultPodIpv4RangeUtilization_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The utilization of the cluster default IPv4 range for the
     * pod. The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     * </pre>
     *
     * <code>
     * double default_pod_ipv4_range_utilization = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The defaultPodIpv4RangeUtilization to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultPodIpv4RangeUtilization(double value) {

      defaultPodIpv4RangeUtilization_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The utilization of the cluster default IPv4 range for the
     * pod. The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     * </pre>
     *
     * <code>
     * double default_pod_ipv4_range_utilization = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultPodIpv4RangeUtilization() {
      bitField0_ = (bitField0_ & ~0x00080000);
      defaultPodIpv4RangeUtilization_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.IPAllocationPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.IPAllocationPolicy)
  private static final com.google.container.v1.IPAllocationPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.IPAllocationPolicy();
  }

  public static com.google.container.v1.IPAllocationPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IPAllocationPolicy> PARSER =
      new com.google.protobuf.AbstractParser<IPAllocationPolicy>() {
        @java.lang.Override
        public IPAllocationPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IPAllocationPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IPAllocationPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.IPAllocationPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
