/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

public interface LinuxNodeConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.container.v1.LinuxNodeConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The Linux kernel parameters to be applied to the nodes and all pods running
   * on the nodes.
   *
   * The following parameters are supported.
   *
   * net.core.busy_poll
   * net.core.busy_read
   * net.core.netdev_max_backlog
   * net.core.rmem_max
   * net.core.wmem_default
   * net.core.wmem_max
   * net.core.optmem_max
   * net.core.somaxconn
   * net.ipv4.tcp_rmem
   * net.ipv4.tcp_wmem
   * net.ipv4.tcp_tw_reuse
   * </pre>
   *
   * <code>map&lt;string, string&gt; sysctls = 1;</code>
   */
  int getSysctlsCount();
  /**
   *
   *
   * <pre>
   * The Linux kernel parameters to be applied to the nodes and all pods running
   * on the nodes.
   *
   * The following parameters are supported.
   *
   * net.core.busy_poll
   * net.core.busy_read
   * net.core.netdev_max_backlog
   * net.core.rmem_max
   * net.core.wmem_default
   * net.core.wmem_max
   * net.core.optmem_max
   * net.core.somaxconn
   * net.ipv4.tcp_rmem
   * net.ipv4.tcp_wmem
   * net.ipv4.tcp_tw_reuse
   * </pre>
   *
   * <code>map&lt;string, string&gt; sysctls = 1;</code>
   */
  boolean containsSysctls(java.lang.String key);
  /** Use {@link #getSysctlsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getSysctls();
  /**
   *
   *
   * <pre>
   * The Linux kernel parameters to be applied to the nodes and all pods running
   * on the nodes.
   *
   * The following parameters are supported.
   *
   * net.core.busy_poll
   * net.core.busy_read
   * net.core.netdev_max_backlog
   * net.core.rmem_max
   * net.core.wmem_default
   * net.core.wmem_max
   * net.core.optmem_max
   * net.core.somaxconn
   * net.ipv4.tcp_rmem
   * net.ipv4.tcp_wmem
   * net.ipv4.tcp_tw_reuse
   * </pre>
   *
   * <code>map&lt;string, string&gt; sysctls = 1;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getSysctlsMap();
  /**
   *
   *
   * <pre>
   * The Linux kernel parameters to be applied to the nodes and all pods running
   * on the nodes.
   *
   * The following parameters are supported.
   *
   * net.core.busy_poll
   * net.core.busy_read
   * net.core.netdev_max_backlog
   * net.core.rmem_max
   * net.core.wmem_default
   * net.core.wmem_max
   * net.core.optmem_max
   * net.core.somaxconn
   * net.ipv4.tcp_rmem
   * net.ipv4.tcp_wmem
   * net.ipv4.tcp_tw_reuse
   * </pre>
   *
   * <code>map&lt;string, string&gt; sysctls = 1;</code>
   */
  /* nullable */
  java.lang.String getSysctlsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * The Linux kernel parameters to be applied to the nodes and all pods running
   * on the nodes.
   *
   * The following parameters are supported.
   *
   * net.core.busy_poll
   * net.core.busy_read
   * net.core.netdev_max_backlog
   * net.core.rmem_max
   * net.core.wmem_default
   * net.core.wmem_max
   * net.core.optmem_max
   * net.core.somaxconn
   * net.ipv4.tcp_rmem
   * net.ipv4.tcp_wmem
   * net.ipv4.tcp_tw_reuse
   * </pre>
   *
   * <code>map&lt;string, string&gt; sysctls = 1;</code>
   */
  java.lang.String getSysctlsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * cgroup_mode specifies the cgroup mode to be used on the node.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig.CgroupMode cgroup_mode = 2;</code>
   *
   * @return The enum numeric value on the wire for cgroupMode.
   */
  int getCgroupModeValue();
  /**
   *
   *
   * <pre>
   * cgroup_mode specifies the cgroup mode to be used on the node.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig.CgroupMode cgroup_mode = 2;</code>
   *
   * @return The cgroupMode.
   */
  com.google.container.v1.LinuxNodeConfig.CgroupMode getCgroupMode();

  /**
   *
   *
   * <pre>
   * Optional. Amounts for 2M and 1G hugepages
   * </pre>
   *
   * <code>
   * optional .google.container.v1.LinuxNodeConfig.HugepagesConfig hugepages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hugepages field is set.
   */
  boolean hasHugepages();
  /**
   *
   *
   * <pre>
   * Optional. Amounts for 2M and 1G hugepages
   * </pre>
   *
   * <code>
   * optional .google.container.v1.LinuxNodeConfig.HugepagesConfig hugepages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hugepages.
   */
  com.google.container.v1.LinuxNodeConfig.HugepagesConfig getHugepages();
  /**
   *
   *
   * <pre>
   * Optional. Amounts for 2M and 1G hugepages
   * </pre>
   *
   * <code>
   * optional .google.container.v1.LinuxNodeConfig.HugepagesConfig hugepages = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.container.v1.LinuxNodeConfig.HugepagesConfigOrBuilder getHugepagesOrBuilder();
}
