/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * The authentication information for accessing the master endpoint.
 * Authentication can be done using HTTP basic auth or using client
 * certificates.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.MasterAuth}
 */
public final class MasterAuth extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.MasterAuth)
    MasterAuthOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MasterAuth.newBuilder() to construct.
  private MasterAuth(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MasterAuth() {
    username_ = "";
    password_ = "";
    clusterCaCertificate_ = "";
    clientCertificate_ = "";
    clientKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MasterAuth();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_MasterAuth_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_MasterAuth_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.MasterAuth.class,
            com.google.container.v1.MasterAuth.Builder.class);
  }

  private int bitField0_;
  public static final int USERNAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object username_ = "";
  /**
   *
   *
   * <pre>
   * The username to use for HTTP basic authentication to the master endpoint.
   * For clusters v1.6.0 and later, basic authentication can be disabled by
   * leaving username unspecified (or setting it to the empty string).
   *
   * Warning: basic authentication is deprecated, and will be removed in GKE
   * control plane versions 1.19 and newer. For a list of recommended
   * authentication methods, see:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
   * </pre>
   *
   * <code>string username = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.MasterAuth.username is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1220
   * @return The username.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getUsername() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      username_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The username to use for HTTP basic authentication to the master endpoint.
   * For clusters v1.6.0 and later, basic authentication can be disabled by
   * leaving username unspecified (or setting it to the empty string).
   *
   * Warning: basic authentication is deprecated, and will be removed in GKE
   * control plane versions 1.19 and newer. For a list of recommended
   * authentication methods, see:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
   * </pre>
   *
   * <code>string username = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.MasterAuth.username is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1220
   * @return The bytes for username.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getUsernameBytes() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      username_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PASSWORD_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object password_ = "";
  /**
   *
   *
   * <pre>
   * The password to use for HTTP basic authentication to the master endpoint.
   * Because the master endpoint is open to the Internet, you should create a
   * strong password.  If a password is provided for cluster creation, username
   * must be non-empty.
   *
   * Warning: basic authentication is deprecated, and will be removed in GKE
   * control plane versions 1.19 and newer. For a list of recommended
   * authentication methods, see:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
   * </pre>
   *
   * <code>string password = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.MasterAuth.password is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1231
   * @return The password.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getPassword() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      password_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The password to use for HTTP basic authentication to the master endpoint.
   * Because the master endpoint is open to the Internet, you should create a
   * strong password.  If a password is provided for cluster creation, username
   * must be non-empty.
   *
   * Warning: basic authentication is deprecated, and will be removed in GKE
   * control plane versions 1.19 and newer. For a list of recommended
   * authentication methods, see:
   * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
   * </pre>
   *
   * <code>string password = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.MasterAuth.password is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1231
   * @return The bytes for password.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getPasswordBytes() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      password_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_CERTIFICATE_CONFIG_FIELD_NUMBER = 3;
  private com.google.container.v1.ClientCertificateConfig clientCertificateConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for client certificate authentication on the cluster. For
   * clusters before v1.12, if no configuration is specified, a client
   * certificate is issued.
   * </pre>
   *
   * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
   *
   * @return Whether the clientCertificateConfig field is set.
   */
  @java.lang.Override
  public boolean hasClientCertificateConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for client certificate authentication on the cluster. For
   * clusters before v1.12, if no configuration is specified, a client
   * certificate is issued.
   * </pre>
   *
   * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
   *
   * @return The clientCertificateConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ClientCertificateConfig getClientCertificateConfig() {
    return clientCertificateConfig_ == null
        ? com.google.container.v1.ClientCertificateConfig.getDefaultInstance()
        : clientCertificateConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for client certificate authentication on the cluster. For
   * clusters before v1.12, if no configuration is specified, a client
   * certificate is issued.
   * </pre>
   *
   * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ClientCertificateConfigOrBuilder
      getClientCertificateConfigOrBuilder() {
    return clientCertificateConfig_ == null
        ? com.google.container.v1.ClientCertificateConfig.getDefaultInstance()
        : clientCertificateConfig_;
  }

  public static final int CLUSTER_CA_CERTIFICATE_FIELD_NUMBER = 100;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterCaCertificate_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Base64-encoded public certificate that is the root of
   * trust for the cluster.
   * </pre>
   *
   * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clusterCaCertificate.
   */
  @java.lang.Override
  public java.lang.String getClusterCaCertificate() {
    java.lang.Object ref = clusterCaCertificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterCaCertificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Base64-encoded public certificate that is the root of
   * trust for the cluster.
   * </pre>
   *
   * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clusterCaCertificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterCaCertificateBytes() {
    java.lang.Object ref = clusterCaCertificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterCaCertificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_CERTIFICATE_FIELD_NUMBER = 101;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientCertificate_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Base64-encoded public certificate used by clients to
   * authenticate to the cluster endpoint.
   * </pre>
   *
   * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clientCertificate.
   */
  @java.lang.Override
  public java.lang.String getClientCertificate() {
    java.lang.Object ref = clientCertificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientCertificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Base64-encoded public certificate used by clients to
   * authenticate to the cluster endpoint.
   * </pre>
   *
   * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clientCertificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientCertificateBytes() {
    java.lang.Object ref = clientCertificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientCertificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_KEY_FIELD_NUMBER = 102;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientKey_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Base64-encoded private key used by clients to authenticate
   * to the cluster endpoint.
   * </pre>
   *
   * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The clientKey.
   */
  @java.lang.Override
  public java.lang.String getClientKey() {
    java.lang.Object ref = clientKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Base64-encoded private key used by clients to authenticate
   * to the cluster endpoint.
   * </pre>
   *
   * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for clientKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientKeyBytes() {
    java.lang.Object ref = clientKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getClientCertificateConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterCaCertificate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, clusterCaCertificate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientCertificate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, clientCertificate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 102, clientKey_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getClientCertificateConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterCaCertificate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, clusterCaCertificate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientCertificate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, clientCertificate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(102, clientKey_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.MasterAuth)) {
      return super.equals(obj);
    }
    com.google.container.v1.MasterAuth other = (com.google.container.v1.MasterAuth) obj;

    if (!getUsername().equals(other.getUsername())) return false;
    if (!getPassword().equals(other.getPassword())) return false;
    if (hasClientCertificateConfig() != other.hasClientCertificateConfig()) return false;
    if (hasClientCertificateConfig()) {
      if (!getClientCertificateConfig().equals(other.getClientCertificateConfig())) return false;
    }
    if (!getClusterCaCertificate().equals(other.getClusterCaCertificate())) return false;
    if (!getClientCertificate().equals(other.getClientCertificate())) return false;
    if (!getClientKey().equals(other.getClientKey())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USERNAME_FIELD_NUMBER;
    hash = (53 * hash) + getUsername().hashCode();
    hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
    hash = (53 * hash) + getPassword().hashCode();
    if (hasClientCertificateConfig()) {
      hash = (37 * hash) + CLIENT_CERTIFICATE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getClientCertificateConfig().hashCode();
    }
    hash = (37 * hash) + CLUSTER_CA_CERTIFICATE_FIELD_NUMBER;
    hash = (53 * hash) + getClusterCaCertificate().hashCode();
    hash = (37 * hash) + CLIENT_CERTIFICATE_FIELD_NUMBER;
    hash = (53 * hash) + getClientCertificate().hashCode();
    hash = (37 * hash) + CLIENT_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getClientKey().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.MasterAuth parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MasterAuth parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuth parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MasterAuth parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuth parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MasterAuth parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuth parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MasterAuth parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuth parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MasterAuth parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuth parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MasterAuth parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.MasterAuth prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * Authentication can be done using HTTP basic auth or using client
   * certificates.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.MasterAuth}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.MasterAuth)
      com.google.container.v1.MasterAuthOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuth_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuth_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.MasterAuth.class,
              com.google.container.v1.MasterAuth.Builder.class);
    }

    // Construct using com.google.container.v1.MasterAuth.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getClientCertificateConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      username_ = "";
      password_ = "";
      clientCertificateConfig_ = null;
      if (clientCertificateConfigBuilder_ != null) {
        clientCertificateConfigBuilder_.dispose();
        clientCertificateConfigBuilder_ = null;
      }
      clusterCaCertificate_ = "";
      clientCertificate_ = "";
      clientKey_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuth_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuth getDefaultInstanceForType() {
      return com.google.container.v1.MasterAuth.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuth build() {
      com.google.container.v1.MasterAuth result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuth buildPartial() {
      com.google.container.v1.MasterAuth result = new com.google.container.v1.MasterAuth(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.MasterAuth result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.username_ = username_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.password_ = password_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clientCertificateConfig_ =
            clientCertificateConfigBuilder_ == null
                ? clientCertificateConfig_
                : clientCertificateConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.clusterCaCertificate_ = clusterCaCertificate_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.clientCertificate_ = clientCertificate_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.clientKey_ = clientKey_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.MasterAuth) {
        return mergeFrom((com.google.container.v1.MasterAuth) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.MasterAuth other) {
      if (other == com.google.container.v1.MasterAuth.getDefaultInstance()) return this;
      if (!other.getUsername().isEmpty()) {
        username_ = other.username_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPassword().isEmpty()) {
        password_ = other.password_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasClientCertificateConfig()) {
        mergeClientCertificateConfig(other.getClientCertificateConfig());
      }
      if (!other.getClusterCaCertificate().isEmpty()) {
        clusterCaCertificate_ = other.clusterCaCertificate_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getClientCertificate().isEmpty()) {
        clientCertificate_ = other.clientCertificate_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getClientKey().isEmpty()) {
        clientKey_ = other.clientKey_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                username_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                password_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getClientCertificateConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 802:
              {
                clusterCaCertificate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 802
            case 810:
              {
                clientCertificate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 810
            case 818:
              {
                clientKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 818
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * The username to use for HTTP basic authentication to the master endpoint.
     * For clusters v1.6.0 and later, basic authentication can be disabled by
     * leaving username unspecified (or setting it to the empty string).
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string username = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.username is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1220
     * @return The username.
     */
    @java.lang.Deprecated
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The username to use for HTTP basic authentication to the master endpoint.
     * For clusters v1.6.0 and later, basic authentication can be disabled by
     * leaving username unspecified (or setting it to the empty string).
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string username = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.username is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1220
     * @return The bytes for username.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The username to use for HTTP basic authentication to the master endpoint.
     * For clusters v1.6.0 and later, basic authentication can be disabled by
     * leaving username unspecified (or setting it to the empty string).
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string username = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.username is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1220
     * @param value The username to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setUsername(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      username_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The username to use for HTTP basic authentication to the master endpoint.
     * For clusters v1.6.0 and later, basic authentication can be disabled by
     * leaving username unspecified (or setting it to the empty string).
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string username = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.username is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1220
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearUsername() {
      username_ = getDefaultInstance().getUsername();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The username to use for HTTP basic authentication to the master endpoint.
     * For clusters v1.6.0 and later, basic authentication can be disabled by
     * leaving username unspecified (or setting it to the empty string).
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string username = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.username is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1220
     * @param value The bytes for username to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      username_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * The password to use for HTTP basic authentication to the master endpoint.
     * Because the master endpoint is open to the Internet, you should create a
     * strong password.  If a password is provided for cluster creation, username
     * must be non-empty.
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string password = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.password is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1231
     * @return The password.
     */
    @java.lang.Deprecated
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The password to use for HTTP basic authentication to the master endpoint.
     * Because the master endpoint is open to the Internet, you should create a
     * strong password.  If a password is provided for cluster creation, username
     * must be non-empty.
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string password = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.password is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1231
     * @return The bytes for password.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The password to use for HTTP basic authentication to the master endpoint.
     * Because the master endpoint is open to the Internet, you should create a
     * strong password.  If a password is provided for cluster creation, username
     * must be non-empty.
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string password = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.password is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1231
     * @param value The password to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      password_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The password to use for HTTP basic authentication to the master endpoint.
     * Because the master endpoint is open to the Internet, you should create a
     * strong password.  If a password is provided for cluster creation, username
     * must be non-empty.
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string password = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.password is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1231
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearPassword() {
      password_ = getDefaultInstance().getPassword();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The password to use for HTTP basic authentication to the master endpoint.
     * Because the master endpoint is open to the Internet, you should create a
     * strong password.  If a password is provided for cluster creation, username
     * must be non-empty.
     *
     * Warning: basic authentication is deprecated, and will be removed in GKE
     * control plane versions 1.19 and newer. For a list of recommended
     * authentication methods, see:
     * https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
     * </pre>
     *
     * <code>string password = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.MasterAuth.password is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1231
     * @param value The bytes for password to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      password_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.container.v1.ClientCertificateConfig clientCertificateConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ClientCertificateConfig,
            com.google.container.v1.ClientCertificateConfig.Builder,
            com.google.container.v1.ClientCertificateConfigOrBuilder>
        clientCertificateConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     *
     * @return Whether the clientCertificateConfig field is set.
     */
    public boolean hasClientCertificateConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     *
     * @return The clientCertificateConfig.
     */
    public com.google.container.v1.ClientCertificateConfig getClientCertificateConfig() {
      if (clientCertificateConfigBuilder_ == null) {
        return clientCertificateConfig_ == null
            ? com.google.container.v1.ClientCertificateConfig.getDefaultInstance()
            : clientCertificateConfig_;
      } else {
        return clientCertificateConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    public Builder setClientCertificateConfig(
        com.google.container.v1.ClientCertificateConfig value) {
      if (clientCertificateConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientCertificateConfig_ = value;
      } else {
        clientCertificateConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    public Builder setClientCertificateConfig(
        com.google.container.v1.ClientCertificateConfig.Builder builderForValue) {
      if (clientCertificateConfigBuilder_ == null) {
        clientCertificateConfig_ = builderForValue.build();
      } else {
        clientCertificateConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    public Builder mergeClientCertificateConfig(
        com.google.container.v1.ClientCertificateConfig value) {
      if (clientCertificateConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && clientCertificateConfig_ != null
            && clientCertificateConfig_
                != com.google.container.v1.ClientCertificateConfig.getDefaultInstance()) {
          getClientCertificateConfigBuilder().mergeFrom(value);
        } else {
          clientCertificateConfig_ = value;
        }
      } else {
        clientCertificateConfigBuilder_.mergeFrom(value);
      }
      if (clientCertificateConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    public Builder clearClientCertificateConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      clientCertificateConfig_ = null;
      if (clientCertificateConfigBuilder_ != null) {
        clientCertificateConfigBuilder_.dispose();
        clientCertificateConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    public com.google.container.v1.ClientCertificateConfig.Builder
        getClientCertificateConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getClientCertificateConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    public com.google.container.v1.ClientCertificateConfigOrBuilder
        getClientCertificateConfigOrBuilder() {
      if (clientCertificateConfigBuilder_ != null) {
        return clientCertificateConfigBuilder_.getMessageOrBuilder();
      } else {
        return clientCertificateConfig_ == null
            ? com.google.container.v1.ClientCertificateConfig.getDefaultInstance()
            : clientCertificateConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for client certificate authentication on the cluster. For
     * clusters before v1.12, if no configuration is specified, a client
     * certificate is issued.
     * </pre>
     *
     * <code>.google.container.v1.ClientCertificateConfig client_certificate_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ClientCertificateConfig,
            com.google.container.v1.ClientCertificateConfig.Builder,
            com.google.container.v1.ClientCertificateConfigOrBuilder>
        getClientCertificateConfigFieldBuilder() {
      if (clientCertificateConfigBuilder_ == null) {
        clientCertificateConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ClientCertificateConfig,
                com.google.container.v1.ClientCertificateConfig.Builder,
                com.google.container.v1.ClientCertificateConfigOrBuilder>(
                getClientCertificateConfig(), getParentForChildren(), isClean());
        clientCertificateConfig_ = null;
      }
      return clientCertificateConfigBuilder_;
    }

    private java.lang.Object clusterCaCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate that is the root of
     * trust for the cluster.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The clusterCaCertificate.
     */
    public java.lang.String getClusterCaCertificate() {
      java.lang.Object ref = clusterCaCertificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterCaCertificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate that is the root of
     * trust for the cluster.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for clusterCaCertificate.
     */
    public com.google.protobuf.ByteString getClusterCaCertificateBytes() {
      java.lang.Object ref = clusterCaCertificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterCaCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate that is the root of
     * trust for the cluster.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The clusterCaCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClusterCaCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterCaCertificate_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate that is the root of
     * trust for the cluster.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterCaCertificate() {
      clusterCaCertificate_ = getDefaultInstance().getClusterCaCertificate();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate that is the root of
     * trust for the cluster.
     * </pre>
     *
     * <code>string cluster_ca_certificate = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for clusterCaCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClusterCaCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterCaCertificate_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object clientCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate used by clients to
     * authenticate to the cluster endpoint.
     * </pre>
     *
     * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clientCertificate.
     */
    public java.lang.String getClientCertificate() {
      java.lang.Object ref = clientCertificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientCertificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate used by clients to
     * authenticate to the cluster endpoint.
     * </pre>
     *
     * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clientCertificate.
     */
    public com.google.protobuf.ByteString getClientCertificateBytes() {
      java.lang.Object ref = clientCertificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate used by clients to
     * authenticate to the cluster endpoint.
     * </pre>
     *
     * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clientCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClientCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientCertificate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate used by clients to
     * authenticate to the cluster endpoint.
     * </pre>
     *
     * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientCertificate() {
      clientCertificate_ = getDefaultInstance().getClientCertificate();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded public certificate used by clients to
     * authenticate to the cluster endpoint.
     * </pre>
     *
     * <code>string client_certificate = 101 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clientCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClientCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientCertificate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object clientKey_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded private key used by clients to authenticate
     * to the cluster endpoint.
     * </pre>
     *
     * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clientKey.
     */
    public java.lang.String getClientKey() {
      java.lang.Object ref = clientKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded private key used by clients to authenticate
     * to the cluster endpoint.
     * </pre>
     *
     * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clientKey.
     */
    public com.google.protobuf.ByteString getClientKeyBytes() {
      java.lang.Object ref = clientKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded private key used by clients to authenticate
     * to the cluster endpoint.
     * </pre>
     *
     * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The clientKey to set.
     * @return This builder for chaining.
     */
    public Builder setClientKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientKey_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded private key used by clients to authenticate
     * to the cluster endpoint.
     * </pre>
     *
     * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientKey() {
      clientKey_ = getDefaultInstance().getClientKey();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Base64-encoded private key used by clients to authenticate
     * to the cluster endpoint.
     * </pre>
     *
     * <code>string client_key = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for clientKey to set.
     * @return This builder for chaining.
     */
    public Builder setClientKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientKey_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.MasterAuth)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.MasterAuth)
  private static final com.google.container.v1.MasterAuth DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.MasterAuth();
  }

  public static com.google.container.v1.MasterAuth getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MasterAuth> PARSER =
      new com.google.protobuf.AbstractParser<MasterAuth>() {
        @java.lang.Override
        public MasterAuth parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MasterAuth> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MasterAuth> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.MasterAuth getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
