/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * Parameters that describe the nodes in a cluster.
 *
 * GKE Autopilot clusters do not
 * recognize parameters in `NodeConfig`. Use
 * [AutoprovisioningNodePoolDefaults][google.container.v1.AutoprovisioningNodePoolDefaults]
 * instead.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.NodeConfig}
 */
public final class NodeConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.NodeConfig)
    NodeConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeConfig.newBuilder() to construct.
  private NodeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeConfig() {
    machineType_ = "";
    oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccount_ = "";
    imageType_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    accelerators_ = java.util.Collections.emptyList();
    diskType_ = "";
    minCpuPlatform_ = "";
    taints_ = java.util.Collections.emptyList();
    nodeGroup_ = "";
    bootDiskKmsKey_ = "";
    secondaryBootDisks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_NodeConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetMetadata();
      case 6:
        return internalGetLabels();
      case 37:
        return internalGetResourceLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_NodeConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.NodeConfig.class,
            com.google.container.v1.NodeConfig.Builder.class);
  }

  private int bitField0_;
  public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * The name of a Google Compute Engine [machine
   * type](https://cloud.google.com/compute/docs/machine-types)
   *
   * If unspecified, the default machine type is `e2-medium`.
   * </pre>
   *
   * <code>string machine_type = 1;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of a Google Compute Engine [machine
   * type](https://cloud.google.com/compute/docs/machine-types)
   *
   * If unspecified, the default machine type is `e2-medium`.
   * </pre>
   *
   * <code>string machine_type = 1;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 2;
  private int diskSizeGb_ = 0;
  /**
   *
   *
   * <pre>
   * Size of the disk attached to each node, specified in GB.
   * The smallest allowed disk size is 10GB.
   *
   * If unspecified, the default disk size is 100GB.
   * </pre>
   *
   * <code>int32 disk_size_gb = 2;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public int getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int OAUTH_SCOPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList oauthScopes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 3;</code>
   *
   * @return A list containing the oauthScopes.
   */
  public com.google.protobuf.ProtocolStringList getOauthScopesList() {
    return oauthScopes_;
  }
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 3;</code>
   *
   * @return The count of oauthScopes.
   */
  public int getOauthScopesCount() {
    return oauthScopes_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The oauthScopes at the given index.
   */
  public java.lang.String getOauthScopes(int index) {
    return oauthScopes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the oauthScopes at the given index.
   */
  public com.google.protobuf.ByteString getOauthScopesBytes(int index) {
    return oauthScopes_.getByteString(index);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The Google Cloud Platform Service Account to be used by the node VMs.
   * Specify the email address of the Service Account; otherwise, if no Service
   * Account is specified, the "default" service account is used.
   * </pre>
   *
   * <code>string service_account = 9;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Platform Service Account to be used by the node VMs.
   * Specify the email address of the Service Account; otherwise, if no Service
   * Account is specified, the "default" service account is used.
   * </pre>
   *
   * <code>string service_account = 9;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 4;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_NodeConfig_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to instances in the cluster.
   *
   * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
   * in length. These are reflected as part of a URL in the metadata server.
   * Additionally, to avoid ambiguity, keys must not conflict with any other
   * metadata keys for the project or be one of the reserved keys:
   *
   *  - "cluster-location"
   *  - "cluster-name"
   *  - "cluster-uid"
   *  - "configure-sh"
   *  - "containerd-configure-sh"
   *  - "enable-os-login"
   *  - "gci-ensure-gke-docker"
   *  - "gci-metrics-enabled"
   *  - "gci-update-strategy"
   *  - "instance-template"
   *  - "kube-env"
   *  - "startup-script"
   *  - "user-data"
   *  - "disable-address-manager"
   *  - "windows-startup-script-ps1"
   *  - "common-psm1"
   *  - "k8s-node-setup-psm1"
   *  - "install-ssh-psm1"
   *  - "user-profile-psm1"
   *
   * Values are free-form strings, and only have meaning as interpreted by
   * the image running in the instance. The only restriction placed on them is
   * that each value's size must be less than or equal to 32 KB.
   *
   * The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to instances in the cluster.
   *
   * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
   * in length. These are reflected as part of a URL in the metadata server.
   * Additionally, to avoid ambiguity, keys must not conflict with any other
   * metadata keys for the project or be one of the reserved keys:
   *
   *  - "cluster-location"
   *  - "cluster-name"
   *  - "cluster-uid"
   *  - "configure-sh"
   *  - "containerd-configure-sh"
   *  - "enable-os-login"
   *  - "gci-ensure-gke-docker"
   *  - "gci-metrics-enabled"
   *  - "gci-update-strategy"
   *  - "instance-template"
   *  - "kube-env"
   *  - "startup-script"
   *  - "user-data"
   *  - "disable-address-manager"
   *  - "windows-startup-script-ps1"
   *  - "common-psm1"
   *  - "k8s-node-setup-psm1"
   *  - "install-ssh-psm1"
   *  - "user-profile-psm1"
   *
   * Values are free-form strings, and only have meaning as interpreted by
   * the image running in the instance. The only restriction placed on them is
   * that each value's size must be less than or equal to 32 KB.
   *
   * The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to instances in the cluster.
   *
   * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
   * in length. These are reflected as part of a URL in the metadata server.
   * Additionally, to avoid ambiguity, keys must not conflict with any other
   * metadata keys for the project or be one of the reserved keys:
   *
   *  - "cluster-location"
   *  - "cluster-name"
   *  - "cluster-uid"
   *  - "configure-sh"
   *  - "containerd-configure-sh"
   *  - "enable-os-login"
   *  - "gci-ensure-gke-docker"
   *  - "gci-metrics-enabled"
   *  - "gci-update-strategy"
   *  - "instance-template"
   *  - "kube-env"
   *  - "startup-script"
   *  - "user-data"
   *  - "disable-address-manager"
   *  - "windows-startup-script-ps1"
   *  - "common-psm1"
   *  - "k8s-node-setup-psm1"
   *  - "install-ssh-psm1"
   *  - "user-profile-psm1"
   *
   * Values are free-form strings, and only have meaning as interpreted by
   * the image running in the instance. The only restriction placed on them is
   * that each value's size must be less than or equal to 32 KB.
   *
   * The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs assigned to instances in the cluster.
   *
   * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
   * in length. These are reflected as part of a URL in the metadata server.
   * Additionally, to avoid ambiguity, keys must not conflict with any other
   * metadata keys for the project or be one of the reserved keys:
   *
   *  - "cluster-location"
   *  - "cluster-name"
   *  - "cluster-uid"
   *  - "configure-sh"
   *  - "containerd-configure-sh"
   *  - "enable-os-login"
   *  - "gci-ensure-gke-docker"
   *  - "gci-metrics-enabled"
   *  - "gci-update-strategy"
   *  - "instance-template"
   *  - "kube-env"
   *  - "startup-script"
   *  - "user-data"
   *  - "disable-address-manager"
   *  - "windows-startup-script-ps1"
   *  - "common-psm1"
   *  - "k8s-node-setup-psm1"
   *  - "install-ssh-psm1"
   *  - "user-profile-psm1"
   *
   * Values are free-form strings, and only have meaning as interpreted by
   * the image running in the instance. The only restriction placed on them is
   * that each value's size must be less than or equal to 32 KB.
   *
   * The total size of all keys and values must be less than 512 KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IMAGE_TYPE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageType_ = "";
  /**
   *
   *
   * <pre>
   * The image type to use for this node. Note that for a given image type,
   * the latest version of it will be used. Please see
   * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
   * available image types.
   * </pre>
   *
   * <code>string image_type = 5;</code>
   *
   * @return The imageType.
   */
  @java.lang.Override
  public java.lang.String getImageType() {
    java.lang.Object ref = imageType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The image type to use for this node. Note that for a given image type,
   * the latest version of it will be used. Please see
   * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
   * available image types.
   * </pre>
   *
   * <code>string image_type = 5;</code>
   *
   * @return The bytes for imageType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageTypeBytes() {
    java.lang.Object ref = imageType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_NodeConfig_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The map of Kubernetes labels (key/value pairs) to be applied to each node.
   * These will added in addition to any default label(s) that
   * Kubernetes may apply to the node.
   * In case of conflict in label keys, the applied set may differ depending on
   * the Kubernetes version -- it's best to assume the behavior is undefined
   * and conflicts should be avoided.
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The map of Kubernetes labels (key/value pairs) to be applied to each node.
   * These will added in addition to any default label(s) that
   * Kubernetes may apply to the node.
   * In case of conflict in label keys, the applied set may differ depending on
   * the Kubernetes version -- it's best to assume the behavior is undefined
   * and conflicts should be avoided.
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The map of Kubernetes labels (key/value pairs) to be applied to each node.
   * These will added in addition to any default label(s) that
   * Kubernetes may apply to the node.
   * In case of conflict in label keys, the applied set may differ depending on
   * the Kubernetes version -- it's best to assume the behavior is undefined
   * and conflicts should be avoided.
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The map of Kubernetes labels (key/value pairs) to be applied to each node.
   * These will added in addition to any default label(s) that
   * Kubernetes may apply to the node.
   * In case of conflict in label keys, the applied set may differ depending on
   * the Kubernetes version -- it's best to assume the behavior is undefined
   * and conflicts should be avoided.
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOCAL_SSD_COUNT_FIELD_NUMBER = 7;
  private int localSsdCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of local SSD disks to be attached to the node.
   *
   * The limit for this value is dependent upon the maximum number of
   * disks available on a machine per zone. See:
   * https://cloud.google.com/compute/docs/disks/local-ssd
   * for more information.
   * </pre>
   *
   * <code>int32 local_ssd_count = 7;</code>
   *
   * @return The localSsdCount.
   */
  @java.lang.Override
  public int getLocalSsdCount() {
    return localSsdCount_;
  }

  public static final int TAGS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of instance tags applied to all nodes. Tags are used to identify
   * valid sources or targets for network firewalls and are specified by
   * the client during cluster or node pool creation. Each tag within the list
   * must comply with RFC1035.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * The list of instance tags applied to all nodes. Tags are used to identify
   * valid sources or targets for network firewalls and are specified by
   * the client during cluster or node pool creation. Each tag within the list
   * must comply with RFC1035.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of instance tags applied to all nodes. Tags are used to identify
   * valid sources or targets for network firewalls and are specified by
   * the client during cluster or node pool creation. Each tag within the list
   * must comply with RFC1035.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of instance tags applied to all nodes. Tags are used to identify
   * valid sources or targets for network firewalls and are specified by
   * the client during cluster or node pool creation. Each tag within the list
   * must comply with RFC1035.
   * </pre>
   *
   * <code>repeated string tags = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int PREEMPTIBLE_FIELD_NUMBER = 10;
  private boolean preemptible_ = false;
  /**
   *
   *
   * <pre>
   * Whether the nodes are created as preemptible VM instances. See:
   * https://cloud.google.com/compute/docs/instances/preemptible for more
   * information about preemptible VM instances.
   * </pre>
   *
   * <code>bool preemptible = 10;</code>
   *
   * @return The preemptible.
   */
  @java.lang.Override
  public boolean getPreemptible() {
    return preemptible_;
  }

  public static final int ACCELERATORS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.AcceleratorConfig> accelerators_;
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.AcceleratorConfig> getAcceleratorsList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.AcceleratorConfigOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
   */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AcceleratorConfig getAccelerators(int index) {
    return accelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
    return accelerators_.get(index);
  }

  public static final int DISK_TYPE_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskType_ = "";
  /**
   *
   *
   * <pre>
   * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
   * 'pd-balanced')
   *
   * If unspecified, the default disk type is 'pd-standard'
   * </pre>
   *
   * <code>string disk_type = 12;</code>
   *
   * @return The diskType.
   */
  @java.lang.Override
  public java.lang.String getDiskType() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
   * 'pd-balanced')
   *
   * If unspecified, the default disk type is 'pd-standard'
   * </pre>
   *
   * <code>string disk_type = 12;</code>
   *
   * @return The bytes for diskType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskTypeBytes() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minCpuPlatform_ = "";
  /**
   *
   *
   * <pre>
   * Minimum CPU platform to be used by this instance. The instance may be
   * scheduled on the specified or newer CPU platform. Applicable values are the
   * friendly names of CPU platforms, such as
   * `minCpuPlatform: "Intel Haswell"` or
   * `minCpuPlatform: "Intel Sandy Bridge"`. For more
   * information, read [how to specify min CPU
   * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
   * </pre>
   *
   * <code>string min_cpu_platform = 13;</code>
   *
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Minimum CPU platform to be used by this instance. The instance may be
   * scheduled on the specified or newer CPU platform. Applicable values are the
   * friendly names of CPU platforms, such as
   * `minCpuPlatform: "Intel Haswell"` or
   * `minCpuPlatform: "Intel Sandy Bridge"`. For more
   * information, read [how to specify min CPU
   * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
   * </pre>
   *
   * <code>string min_cpu_platform = 13;</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKLOAD_METADATA_CONFIG_FIELD_NUMBER = 14;
  private com.google.container.v1.WorkloadMetadataConfig workloadMetadataConfig_;
  /**
   *
   *
   * <pre>
   * The workload metadata configuration for this node.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
   *
   * @return Whether the workloadMetadataConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkloadMetadataConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The workload metadata configuration for this node.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
   *
   * @return The workloadMetadataConfig.
   */
  @java.lang.Override
  public com.google.container.v1.WorkloadMetadataConfig getWorkloadMetadataConfig() {
    return workloadMetadataConfig_ == null
        ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
        : workloadMetadataConfig_;
  }
  /**
   *
   *
   * <pre>
   * The workload metadata configuration for this node.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
   */
  @java.lang.Override
  public com.google.container.v1.WorkloadMetadataConfigOrBuilder
      getWorkloadMetadataConfigOrBuilder() {
    return workloadMetadataConfig_ == null
        ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
        : workloadMetadataConfig_;
  }

  public static final int TAINTS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.NodeTaint> taints_;
  /**
   *
   *
   * <pre>
   * List of kubernetes taints to be applied to each node.
   *
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
   * </pre>
   *
   * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.NodeTaint> getTaintsList() {
    return taints_;
  }
  /**
   *
   *
   * <pre>
   * List of kubernetes taints to be applied to each node.
   *
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
   * </pre>
   *
   * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.NodeTaintOrBuilder>
      getTaintsOrBuilderList() {
    return taints_;
  }
  /**
   *
   *
   * <pre>
   * List of kubernetes taints to be applied to each node.
   *
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
   * </pre>
   *
   * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
   */
  @java.lang.Override
  public int getTaintsCount() {
    return taints_.size();
  }
  /**
   *
   *
   * <pre>
   * List of kubernetes taints to be applied to each node.
   *
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
   * </pre>
   *
   * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeTaint getTaints(int index) {
    return taints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of kubernetes taints to be applied to each node.
   *
   * For more information, including usage and the valid values, see:
   * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
   * </pre>
   *
   * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeTaintOrBuilder getTaintsOrBuilder(int index) {
    return taints_.get(index);
  }

  public static final int SANDBOX_CONFIG_FIELD_NUMBER = 17;
  private com.google.container.v1.SandboxConfig sandboxConfig_;
  /**
   *
   *
   * <pre>
   * Sandbox configuration for this node.
   * </pre>
   *
   * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
   *
   * @return Whether the sandboxConfig field is set.
   */
  @java.lang.Override
  public boolean hasSandboxConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Sandbox configuration for this node.
   * </pre>
   *
   * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
   *
   * @return The sandboxConfig.
   */
  @java.lang.Override
  public com.google.container.v1.SandboxConfig getSandboxConfig() {
    return sandboxConfig_ == null
        ? com.google.container.v1.SandboxConfig.getDefaultInstance()
        : sandboxConfig_;
  }
  /**
   *
   *
   * <pre>
   * Sandbox configuration for this node.
   * </pre>
   *
   * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SandboxConfigOrBuilder getSandboxConfigOrBuilder() {
    return sandboxConfig_ == null
        ? com.google.container.v1.SandboxConfig.getDefaultInstance()
        : sandboxConfig_;
  }

  public static final int NODE_GROUP_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeGroup_ = "";
  /**
   *
   *
   * <pre>
   * Setting this field will assign instances of this
   * pool to run on the specified node group. This is useful for running
   * workloads on [sole tenant
   * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
   * </pre>
   *
   * <code>string node_group = 18;</code>
   *
   * @return The nodeGroup.
   */
  @java.lang.Override
  public java.lang.String getNodeGroup() {
    java.lang.Object ref = nodeGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeGroup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Setting this field will assign instances of this
   * pool to run on the specified node group. This is useful for running
   * workloads on [sole tenant
   * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
   * </pre>
   *
   * <code>string node_group = 18;</code>
   *
   * @return The bytes for nodeGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeGroupBytes() {
    java.lang.Object ref = nodeGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATION_AFFINITY_FIELD_NUMBER = 19;
  private com.google.container.v1.ReservationAffinity reservationAffinity_;
  /**
   *
   *
   * <pre>
   * The optional reservation affinity. Setting this field will apply
   * the specified [Zonal Compute
   * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
   * to this node pool.
   * </pre>
   *
   * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
   *
   * @return Whether the reservationAffinity field is set.
   */
  @java.lang.Override
  public boolean hasReservationAffinity() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The optional reservation affinity. Setting this field will apply
   * the specified [Zonal Compute
   * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
   * to this node pool.
   * </pre>
   *
   * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
   *
   * @return The reservationAffinity.
   */
  @java.lang.Override
  public com.google.container.v1.ReservationAffinity getReservationAffinity() {
    return reservationAffinity_ == null
        ? com.google.container.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }
  /**
   *
   *
   * <pre>
   * The optional reservation affinity. Setting this field will apply
   * the specified [Zonal Compute
   * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
   * to this node pool.
   * </pre>
   *
   * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ReservationAffinityOrBuilder getReservationAffinityOrBuilder() {
    return reservationAffinity_ == null
        ? com.google.container.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }

  public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 20;
  private com.google.container.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Shielded Instance options.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Shielded Instance options.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
   *
   * @return The shieldedInstanceConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig_ == null
        ? com.google.container.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Shielded Instance options.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder() {
    return shieldedInstanceConfig_ == null
        ? com.google.container.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  public static final int LINUX_NODE_CONFIG_FIELD_NUMBER = 21;
  private com.google.container.v1.LinuxNodeConfig linuxNodeConfig_;
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Linux nodes.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
   *
   * @return Whether the linuxNodeConfig field is set.
   */
  @java.lang.Override
  public boolean hasLinuxNodeConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Linux nodes.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
   *
   * @return The linuxNodeConfig.
   */
  @java.lang.Override
  public com.google.container.v1.LinuxNodeConfig getLinuxNodeConfig() {
    return linuxNodeConfig_ == null
        ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
        : linuxNodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Linux nodes.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
   */
  @java.lang.Override
  public com.google.container.v1.LinuxNodeConfigOrBuilder getLinuxNodeConfigOrBuilder() {
    return linuxNodeConfig_ == null
        ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
        : linuxNodeConfig_;
  }

  public static final int KUBELET_CONFIG_FIELD_NUMBER = 22;
  private com.google.container.v1.NodeKubeletConfig kubeletConfig_;
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
   *
   * @return Whether the kubeletConfig field is set.
   */
  @java.lang.Override
  public boolean hasKubeletConfig() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
   *
   * @return The kubeletConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodeKubeletConfig getKubeletConfig() {
    return kubeletConfig_ == null
        ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
        : kubeletConfig_;
  }
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeKubeletConfigOrBuilder getKubeletConfigOrBuilder() {
    return kubeletConfig_ == null
        ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
        : kubeletConfig_;
  }

  public static final int BOOT_DISK_KMS_KEY_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bootDiskKmsKey_ = "";
  /**
   *
   *
   * <pre>
   *
   * The Customer Managed Encryption Key used to encrypt the boot disk attached
   * to each node in the node pool. This should be of the form
   * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
   * For more information about protecting resources with Cloud KMS Keys please
   * see:
   * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
   * </pre>
   *
   * <code>string boot_disk_kms_key = 23;</code>
   *
   * @return The bootDiskKmsKey.
   */
  @java.lang.Override
  public java.lang.String getBootDiskKmsKey() {
    java.lang.Object ref = bootDiskKmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bootDiskKmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   *
   * The Customer Managed Encryption Key used to encrypt the boot disk attached
   * to each node in the node pool. This should be of the form
   * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
   * For more information about protecting resources with Cloud KMS Keys please
   * see:
   * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
   * </pre>
   *
   * <code>string boot_disk_kms_key = 23;</code>
   *
   * @return The bytes for bootDiskKmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBootDiskKmsKeyBytes() {
    java.lang.Object ref = bootDiskKmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bootDiskKmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCFS_CONFIG_FIELD_NUMBER = 25;
  private com.google.container.v1.GcfsConfig gcfsConfig_;
  /**
   *
   *
   * <pre>
   * Google Container File System (image streaming) configs.
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
   *
   * @return Whether the gcfsConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcfsConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Google Container File System (image streaming) configs.
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
   *
   * @return The gcfsConfig.
   */
  @java.lang.Override
  public com.google.container.v1.GcfsConfig getGcfsConfig() {
    return gcfsConfig_ == null
        ? com.google.container.v1.GcfsConfig.getDefaultInstance()
        : gcfsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Google Container File System (image streaming) configs.
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
   */
  @java.lang.Override
  public com.google.container.v1.GcfsConfigOrBuilder getGcfsConfigOrBuilder() {
    return gcfsConfig_ == null
        ? com.google.container.v1.GcfsConfig.getDefaultInstance()
        : gcfsConfig_;
  }

  public static final int ADVANCED_MACHINE_FEATURES_FIELD_NUMBER = 26;
  private com.google.container.v1.AdvancedMachineFeatures advancedMachineFeatures_;
  /**
   *
   *
   * <pre>
   * Advanced features for the Compute Engine VM.
   * </pre>
   *
   * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
   *
   * @return Whether the advancedMachineFeatures field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedMachineFeatures() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Advanced features for the Compute Engine VM.
   * </pre>
   *
   * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
   *
   * @return The advancedMachineFeatures.
   */
  @java.lang.Override
  public com.google.container.v1.AdvancedMachineFeatures getAdvancedMachineFeatures() {
    return advancedMachineFeatures_ == null
        ? com.google.container.v1.AdvancedMachineFeatures.getDefaultInstance()
        : advancedMachineFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Advanced features for the Compute Engine VM.
   * </pre>
   *
   * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AdvancedMachineFeaturesOrBuilder
      getAdvancedMachineFeaturesOrBuilder() {
    return advancedMachineFeatures_ == null
        ? com.google.container.v1.AdvancedMachineFeatures.getDefaultInstance()
        : advancedMachineFeatures_;
  }

  public static final int GVNIC_FIELD_NUMBER = 29;
  private com.google.container.v1.VirtualNIC gvnic_;
  /**
   *
   *
   * <pre>
   * Enable or disable gvnic in the node pool.
   * </pre>
   *
   * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
   *
   * @return Whether the gvnic field is set.
   */
  @java.lang.Override
  public boolean hasGvnic() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable or disable gvnic in the node pool.
   * </pre>
   *
   * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
   *
   * @return The gvnic.
   */
  @java.lang.Override
  public com.google.container.v1.VirtualNIC getGvnic() {
    return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
  }
  /**
   *
   *
   * <pre>
   * Enable or disable gvnic in the node pool.
   * </pre>
   *
   * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
   */
  @java.lang.Override
  public com.google.container.v1.VirtualNICOrBuilder getGvnicOrBuilder() {
    return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
  }

  public static final int SPOT_FIELD_NUMBER = 32;
  private boolean spot_ = false;
  /**
   *
   *
   * <pre>
   * Spot flag for enabling Spot VM, which is a rebrand of
   * the existing preemptible flag.
   * </pre>
   *
   * <code>bool spot = 32;</code>
   *
   * @return The spot.
   */
  @java.lang.Override
  public boolean getSpot() {
    return spot_;
  }

  public static final int CONFIDENTIAL_NODES_FIELD_NUMBER = 35;
  private com.google.container.v1.ConfidentialNodes confidentialNodes_;
  /**
   *
   *
   * <pre>
   * Confidential nodes config.
   * All the nodes in the node pool will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
   *
   * @return Whether the confidentialNodes field is set.
   */
  @java.lang.Override
  public boolean hasConfidentialNodes() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Confidential nodes config.
   * All the nodes in the node pool will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
   *
   * @return The confidentialNodes.
   */
  @java.lang.Override
  public com.google.container.v1.ConfidentialNodes getConfidentialNodes() {
    return confidentialNodes_ == null
        ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
        : confidentialNodes_;
  }
  /**
   *
   *
   * <pre>
   * Confidential nodes config.
   * All the nodes in the node pool will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder() {
    return confidentialNodes_ == null
        ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
        : confidentialNodes_;
  }

  public static final int FAST_SOCKET_FIELD_NUMBER = 36;
  private com.google.container.v1.FastSocket fastSocket_;
  /**
   *
   *
   * <pre>
   * Enable or disable NCCL fast socket for the node pool.
   * </pre>
   *
   * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
   *
   * @return Whether the fastSocket field is set.
   */
  @java.lang.Override
  public boolean hasFastSocket() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable or disable NCCL fast socket for the node pool.
   * </pre>
   *
   * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
   *
   * @return The fastSocket.
   */
  @java.lang.Override
  public com.google.container.v1.FastSocket getFastSocket() {
    return fastSocket_ == null
        ? com.google.container.v1.FastSocket.getDefaultInstance()
        : fastSocket_;
  }
  /**
   *
   *
   * <pre>
   * Enable or disable NCCL fast socket for the node pool.
   * </pre>
   *
   * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
   */
  @java.lang.Override
  public com.google.container.v1.FastSocketOrBuilder getFastSocketOrBuilder() {
    return fastSocket_ == null
        ? com.google.container.v1.FastSocket.getDefaultInstance()
        : fastSocket_;
  }

  public static final int RESOURCE_LABELS_FIELD_NUMBER = 37;

  private static final class ResourceLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_NodeConfig_ResourceLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourceLabels() {
    if (resourceLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourceLabelsDefaultEntryHolder.defaultEntry);
    }
    return resourceLabels_;
  }

  public int getResourceLabelsCount() {
    return internalGetResourceLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 37;</code>
   */
  @java.lang.Override
  public boolean containsResourceLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourceLabels().getMap().containsKey(key);
  }
  /** Use {@link #getResourceLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourceLabels() {
    return getResourceLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 37;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap() {
    return internalGetResourceLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 37;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourceLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 37;</code>
   */
  @java.lang.Override
  public java.lang.String getResourceLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOGGING_CONFIG_FIELD_NUMBER = 38;
  private com.google.container.v1.NodePoolLoggingConfig loggingConfig_;
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
   *
   * @return Whether the loggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasLoggingConfig() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
   *
   * @return The loggingConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolLoggingConfig getLoggingConfig() {
    return loggingConfig_ == null
        ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolLoggingConfigOrBuilder getLoggingConfigOrBuilder() {
    return loggingConfig_ == null
        ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }

  public static final int WINDOWS_NODE_CONFIG_FIELD_NUMBER = 39;
  private com.google.container.v1.WindowsNodeConfig windowsNodeConfig_;
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Windows nodes.
   * </pre>
   *
   * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
   *
   * @return Whether the windowsNodeConfig field is set.
   */
  @java.lang.Override
  public boolean hasWindowsNodeConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Windows nodes.
   * </pre>
   *
   * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
   *
   * @return The windowsNodeConfig.
   */
  @java.lang.Override
  public com.google.container.v1.WindowsNodeConfig getWindowsNodeConfig() {
    return windowsNodeConfig_ == null
        ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
        : windowsNodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Windows nodes.
   * </pre>
   *
   * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
   */
  @java.lang.Override
  public com.google.container.v1.WindowsNodeConfigOrBuilder getWindowsNodeConfigOrBuilder() {
    return windowsNodeConfig_ == null
        ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
        : windowsNodeConfig_;
  }

  public static final int LOCAL_NVME_SSD_BLOCK_CONFIG_FIELD_NUMBER = 40;
  private com.google.container.v1.LocalNvmeSsdBlockConfig localNvmeSsdBlockConfig_;
  /**
   *
   *
   * <pre>
   * Parameters for using raw-block Local NVMe SSDs.
   * </pre>
   *
   * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
   *
   * @return Whether the localNvmeSsdBlockConfig field is set.
   */
  @java.lang.Override
  public boolean hasLocalNvmeSsdBlockConfig() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters for using raw-block Local NVMe SSDs.
   * </pre>
   *
   * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
   *
   * @return The localNvmeSsdBlockConfig.
   */
  @java.lang.Override
  public com.google.container.v1.LocalNvmeSsdBlockConfig getLocalNvmeSsdBlockConfig() {
    return localNvmeSsdBlockConfig_ == null
        ? com.google.container.v1.LocalNvmeSsdBlockConfig.getDefaultInstance()
        : localNvmeSsdBlockConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for using raw-block Local NVMe SSDs.
   * </pre>
   *
   * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
   */
  @java.lang.Override
  public com.google.container.v1.LocalNvmeSsdBlockConfigOrBuilder
      getLocalNvmeSsdBlockConfigOrBuilder() {
    return localNvmeSsdBlockConfig_ == null
        ? com.google.container.v1.LocalNvmeSsdBlockConfig.getDefaultInstance()
        : localNvmeSsdBlockConfig_;
  }

  public static final int EPHEMERAL_STORAGE_LOCAL_SSD_CONFIG_FIELD_NUMBER = 41;
  private com.google.container.v1.EphemeralStorageLocalSsdConfig ephemeralStorageLocalSsdConfig_;
  /**
   *
   *
   * <pre>
   * Parameters for the node ephemeral storage using Local SSDs.
   * If unspecified, ephemeral storage is backed by the boot disk.
   * </pre>
   *
   * <code>
   * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
   * </code>
   *
   * @return Whether the ephemeralStorageLocalSsdConfig field is set.
   */
  @java.lang.Override
  public boolean hasEphemeralStorageLocalSsdConfig() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters for the node ephemeral storage using Local SSDs.
   * If unspecified, ephemeral storage is backed by the boot disk.
   * </pre>
   *
   * <code>
   * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
   * </code>
   *
   * @return The ephemeralStorageLocalSsdConfig.
   */
  @java.lang.Override
  public com.google.container.v1.EphemeralStorageLocalSsdConfig
      getEphemeralStorageLocalSsdConfig() {
    return ephemeralStorageLocalSsdConfig_ == null
        ? com.google.container.v1.EphemeralStorageLocalSsdConfig.getDefaultInstance()
        : ephemeralStorageLocalSsdConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for the node ephemeral storage using Local SSDs.
   * If unspecified, ephemeral storage is backed by the boot disk.
   * </pre>
   *
   * <code>
   * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.EphemeralStorageLocalSsdConfigOrBuilder
      getEphemeralStorageLocalSsdConfigOrBuilder() {
    return ephemeralStorageLocalSsdConfig_ == null
        ? com.google.container.v1.EphemeralStorageLocalSsdConfig.getDefaultInstance()
        : ephemeralStorageLocalSsdConfig_;
  }

  public static final int SOLE_TENANT_CONFIG_FIELD_NUMBER = 42;
  private com.google.container.v1.SoleTenantConfig soleTenantConfig_;
  /**
   *
   *
   * <pre>
   * Parameters for node pools to be backed by shared sole tenant node groups.
   * </pre>
   *
   * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
   *
   * @return Whether the soleTenantConfig field is set.
   */
  @java.lang.Override
  public boolean hasSoleTenantConfig() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters for node pools to be backed by shared sole tenant node groups.
   * </pre>
   *
   * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
   *
   * @return The soleTenantConfig.
   */
  @java.lang.Override
  public com.google.container.v1.SoleTenantConfig getSoleTenantConfig() {
    return soleTenantConfig_ == null
        ? com.google.container.v1.SoleTenantConfig.getDefaultInstance()
        : soleTenantConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for node pools to be backed by shared sole tenant node groups.
   * </pre>
   *
   * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SoleTenantConfigOrBuilder getSoleTenantConfigOrBuilder() {
    return soleTenantConfig_ == null
        ? com.google.container.v1.SoleTenantConfig.getDefaultInstance()
        : soleTenantConfig_;
  }

  public static final int CONTAINERD_CONFIG_FIELD_NUMBER = 43;
  private com.google.container.v1.ContainerdConfig containerdConfig_;
  /**
   *
   *
   * <pre>
   * Parameters for containerd customization.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
   *
   * @return Whether the containerdConfig field is set.
   */
  @java.lang.Override
  public boolean hasContainerdConfig() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters for containerd customization.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
   *
   * @return The containerdConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ContainerdConfig getContainerdConfig() {
    return containerdConfig_ == null
        ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
        : containerdConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for containerd customization.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ContainerdConfigOrBuilder getContainerdConfigOrBuilder() {
    return containerdConfig_ == null
        ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
        : containerdConfig_;
  }

  public static final int RESOURCE_MANAGER_TAGS_FIELD_NUMBER = 45;
  private com.google.container.v1.ResourceManagerTags resourceManagerTags_;
  /**
   *
   *
   * <pre>
   * A map of resource manager tag keys and values to be attached to the nodes.
   * </pre>
   *
   * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
   *
   * @return Whether the resourceManagerTags field is set.
   */
  @java.lang.Override
  public boolean hasResourceManagerTags() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * A map of resource manager tag keys and values to be attached to the nodes.
   * </pre>
   *
   * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
   *
   * @return The resourceManagerTags.
   */
  @java.lang.Override
  public com.google.container.v1.ResourceManagerTags getResourceManagerTags() {
    return resourceManagerTags_ == null
        ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
        : resourceManagerTags_;
  }
  /**
   *
   *
   * <pre>
   * A map of resource manager tag keys and values to be attached to the nodes.
   * </pre>
   *
   * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ResourceManagerTagsOrBuilder getResourceManagerTagsOrBuilder() {
    return resourceManagerTags_ == null
        ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
        : resourceManagerTags_;
  }

  public static final int ENABLE_CONFIDENTIAL_STORAGE_FIELD_NUMBER = 46;
  private boolean enableConfidentialStorage_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use.
   * </pre>
   *
   * <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableConfidentialStorage.
   */
  @java.lang.Override
  public boolean getEnableConfidentialStorage() {
    return enableConfidentialStorage_;
  }

  public static final int SECONDARY_BOOT_DISKS_FIELD_NUMBER = 48;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.SecondaryBootDisk> secondaryBootDisks_;
  /**
   *
   *
   * <pre>
   * List of secondary boot disks attached to the nodes.
   * </pre>
   *
   * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.SecondaryBootDisk> getSecondaryBootDisksList() {
    return secondaryBootDisks_;
  }
  /**
   *
   *
   * <pre>
   * List of secondary boot disks attached to the nodes.
   * </pre>
   *
   * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.SecondaryBootDiskOrBuilder>
      getSecondaryBootDisksOrBuilderList() {
    return secondaryBootDisks_;
  }
  /**
   *
   *
   * <pre>
   * List of secondary boot disks attached to the nodes.
   * </pre>
   *
   * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
   */
  @java.lang.Override
  public int getSecondaryBootDisksCount() {
    return secondaryBootDisks_.size();
  }
  /**
   *
   *
   * <pre>
   * List of secondary boot disks attached to the nodes.
   * </pre>
   *
   * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SecondaryBootDisk getSecondaryBootDisks(int index) {
    return secondaryBootDisks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of secondary boot disks attached to the nodes.
   * </pre>
   *
   * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SecondaryBootDiskOrBuilder getSecondaryBootDisksOrBuilder(
      int index) {
    return secondaryBootDisks_.get(index);
  }

  public static final int SECONDARY_BOOT_DISK_UPDATE_STRATEGY_FIELD_NUMBER = 50;
  private com.google.container.v1.SecondaryBootDiskUpdateStrategy secondaryBootDiskUpdateStrategy_;
  /**
   *
   *
   * <pre>
   * Secondary boot disk update strategy.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
   * </code>
   *
   * @return Whether the secondaryBootDiskUpdateStrategy field is set.
   */
  @java.lang.Override
  public boolean hasSecondaryBootDiskUpdateStrategy() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Secondary boot disk update strategy.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
   * </code>
   *
   * @return The secondaryBootDiskUpdateStrategy.
   */
  @java.lang.Override
  public com.google.container.v1.SecondaryBootDiskUpdateStrategy
      getSecondaryBootDiskUpdateStrategy() {
    return secondaryBootDiskUpdateStrategy_ == null
        ? com.google.container.v1.SecondaryBootDiskUpdateStrategy.getDefaultInstance()
        : secondaryBootDiskUpdateStrategy_;
  }
  /**
   *
   *
   * <pre>
   * Secondary boot disk update strategy.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.SecondaryBootDiskUpdateStrategyOrBuilder
      getSecondaryBootDiskUpdateStrategyOrBuilder() {
    return secondaryBootDiskUpdateStrategy_ == null
        ? com.google.container.v1.SecondaryBootDiskUpdateStrategy.getDefaultInstance()
        : secondaryBootDiskUpdateStrategy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
    }
    if (diskSizeGb_ != 0) {
      output.writeInt32(2, diskSizeGb_);
    }
    for (int i = 0; i < oauthScopes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, oauthScopes_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, imageType_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (localSsdCount_ != 0) {
      output.writeInt32(7, localSsdCount_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, tags_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, serviceAccount_);
    }
    if (preemptible_ != false) {
      output.writeBool(10, preemptible_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(11, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, diskType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, minCpuPlatform_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(14, getWorkloadMetadataConfig());
    }
    for (int i = 0; i < taints_.size(); i++) {
      output.writeMessage(15, taints_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(17, getSandboxConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeGroup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, nodeGroup_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(19, getReservationAffinity());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(20, getShieldedInstanceConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(21, getLinuxNodeConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(22, getKubeletConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootDiskKmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, bootDiskKmsKey_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(25, getGcfsConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(26, getAdvancedMachineFeatures());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(29, getGvnic());
    }
    if (spot_ != false) {
      output.writeBool(32, spot_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(35, getConfidentialNodes());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(36, getFastSocket());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetResourceLabels(), ResourceLabelsDefaultEntryHolder.defaultEntry, 37);
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(38, getLoggingConfig());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(39, getWindowsNodeConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(40, getLocalNvmeSsdBlockConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(41, getEphemeralStorageLocalSsdConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(42, getSoleTenantConfig());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeMessage(43, getContainerdConfig());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(45, getResourceManagerTags());
    }
    if (enableConfidentialStorage_ != false) {
      output.writeBool(46, enableConfidentialStorage_);
    }
    for (int i = 0; i < secondaryBootDisks_.size(); i++) {
      output.writeMessage(48, secondaryBootDisks_.get(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(50, getSecondaryBootDiskUpdateStrategy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
    }
    if (diskSizeGb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, diskSizeGb_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < oauthScopes_.size(); i++) {
        dataSize += computeStringSizeNoTag(oauthScopes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOauthScopesList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, metadata__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, imageType_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (localSsdCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, localSsdCount_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, serviceAccount_);
    }
    if (preemptible_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, preemptible_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, diskType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, minCpuPlatform_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getWorkloadMetadataConfig());
    }
    for (int i = 0; i < taints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, taints_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getSandboxConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeGroup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, nodeGroup_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, getReservationAffinity());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(20, getShieldedInstanceConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getLinuxNodeConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getKubeletConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootDiskKmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(23, bootDiskKmsKey_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getGcfsConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26, getAdvancedMachineFeatures());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getGvnic());
    }
    if (spot_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(32, spot_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(35, getConfidentialNodes());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(36, getFastSocket());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourceLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLabels__ =
          ResourceLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(37, resourceLabels__);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getLoggingConfig());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(39, getWindowsNodeConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              40, getLocalNvmeSsdBlockConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              41, getEphemeralStorageLocalSsdConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(42, getSoleTenantConfig());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(43, getContainerdConfig());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(45, getResourceManagerTags());
    }
    if (enableConfidentialStorage_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(46, enableConfidentialStorage_);
    }
    for (int i = 0; i < secondaryBootDisks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(48, secondaryBootDisks_.get(i));
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              50, getSecondaryBootDiskUpdateStrategy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.NodeConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.NodeConfig other = (com.google.container.v1.NodeConfig) obj;

    if (!getMachineType().equals(other.getMachineType())) return false;
    if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    if (!getOauthScopesList().equals(other.getOauthScopesList())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (!getImageType().equals(other.getImageType())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getLocalSsdCount() != other.getLocalSsdCount()) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (getPreemptible() != other.getPreemptible()) return false;
    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (!getDiskType().equals(other.getDiskType())) return false;
    if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    if (hasWorkloadMetadataConfig() != other.hasWorkloadMetadataConfig()) return false;
    if (hasWorkloadMetadataConfig()) {
      if (!getWorkloadMetadataConfig().equals(other.getWorkloadMetadataConfig())) return false;
    }
    if (!getTaintsList().equals(other.getTaintsList())) return false;
    if (hasSandboxConfig() != other.hasSandboxConfig()) return false;
    if (hasSandboxConfig()) {
      if (!getSandboxConfig().equals(other.getSandboxConfig())) return false;
    }
    if (!getNodeGroup().equals(other.getNodeGroup())) return false;
    if (hasReservationAffinity() != other.hasReservationAffinity()) return false;
    if (hasReservationAffinity()) {
      if (!getReservationAffinity().equals(other.getReservationAffinity())) return false;
    }
    if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
    if (hasShieldedInstanceConfig()) {
      if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
    }
    if (hasLinuxNodeConfig() != other.hasLinuxNodeConfig()) return false;
    if (hasLinuxNodeConfig()) {
      if (!getLinuxNodeConfig().equals(other.getLinuxNodeConfig())) return false;
    }
    if (hasKubeletConfig() != other.hasKubeletConfig()) return false;
    if (hasKubeletConfig()) {
      if (!getKubeletConfig().equals(other.getKubeletConfig())) return false;
    }
    if (!getBootDiskKmsKey().equals(other.getBootDiskKmsKey())) return false;
    if (hasGcfsConfig() != other.hasGcfsConfig()) return false;
    if (hasGcfsConfig()) {
      if (!getGcfsConfig().equals(other.getGcfsConfig())) return false;
    }
    if (hasAdvancedMachineFeatures() != other.hasAdvancedMachineFeatures()) return false;
    if (hasAdvancedMachineFeatures()) {
      if (!getAdvancedMachineFeatures().equals(other.getAdvancedMachineFeatures())) return false;
    }
    if (hasGvnic() != other.hasGvnic()) return false;
    if (hasGvnic()) {
      if (!getGvnic().equals(other.getGvnic())) return false;
    }
    if (getSpot() != other.getSpot()) return false;
    if (hasConfidentialNodes() != other.hasConfidentialNodes()) return false;
    if (hasConfidentialNodes()) {
      if (!getConfidentialNodes().equals(other.getConfidentialNodes())) return false;
    }
    if (hasFastSocket() != other.hasFastSocket()) return false;
    if (hasFastSocket()) {
      if (!getFastSocket().equals(other.getFastSocket())) return false;
    }
    if (!internalGetResourceLabels().equals(other.internalGetResourceLabels())) return false;
    if (hasLoggingConfig() != other.hasLoggingConfig()) return false;
    if (hasLoggingConfig()) {
      if (!getLoggingConfig().equals(other.getLoggingConfig())) return false;
    }
    if (hasWindowsNodeConfig() != other.hasWindowsNodeConfig()) return false;
    if (hasWindowsNodeConfig()) {
      if (!getWindowsNodeConfig().equals(other.getWindowsNodeConfig())) return false;
    }
    if (hasLocalNvmeSsdBlockConfig() != other.hasLocalNvmeSsdBlockConfig()) return false;
    if (hasLocalNvmeSsdBlockConfig()) {
      if (!getLocalNvmeSsdBlockConfig().equals(other.getLocalNvmeSsdBlockConfig())) return false;
    }
    if (hasEphemeralStorageLocalSsdConfig() != other.hasEphemeralStorageLocalSsdConfig())
      return false;
    if (hasEphemeralStorageLocalSsdConfig()) {
      if (!getEphemeralStorageLocalSsdConfig().equals(other.getEphemeralStorageLocalSsdConfig()))
        return false;
    }
    if (hasSoleTenantConfig() != other.hasSoleTenantConfig()) return false;
    if (hasSoleTenantConfig()) {
      if (!getSoleTenantConfig().equals(other.getSoleTenantConfig())) return false;
    }
    if (hasContainerdConfig() != other.hasContainerdConfig()) return false;
    if (hasContainerdConfig()) {
      if (!getContainerdConfig().equals(other.getContainerdConfig())) return false;
    }
    if (hasResourceManagerTags() != other.hasResourceManagerTags()) return false;
    if (hasResourceManagerTags()) {
      if (!getResourceManagerTags().equals(other.getResourceManagerTags())) return false;
    }
    if (getEnableConfidentialStorage() != other.getEnableConfidentialStorage()) return false;
    if (!getSecondaryBootDisksList().equals(other.getSecondaryBootDisksList())) return false;
    if (hasSecondaryBootDiskUpdateStrategy() != other.hasSecondaryBootDiskUpdateStrategy())
      return false;
    if (hasSecondaryBootDiskUpdateStrategy()) {
      if (!getSecondaryBootDiskUpdateStrategy().equals(other.getSecondaryBootDiskUpdateStrategy()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + getDiskSizeGb();
    if (getOauthScopesCount() > 0) {
      hash = (37 * hash) + OAUTH_SCOPES_FIELD_NUMBER;
      hash = (53 * hash) + getOauthScopesList().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    hash = (37 * hash) + IMAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getImageType().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + LOCAL_SSD_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getLocalSsdCount();
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    hash = (37 * hash) + PREEMPTIBLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreemptible());
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    hash = (37 * hash) + DISK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDiskType().hashCode();
    hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
    hash = (53 * hash) + getMinCpuPlatform().hashCode();
    if (hasWorkloadMetadataConfig()) {
      hash = (37 * hash) + WORKLOAD_METADATA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkloadMetadataConfig().hashCode();
    }
    if (getTaintsCount() > 0) {
      hash = (37 * hash) + TAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getTaintsList().hashCode();
    }
    if (hasSandboxConfig()) {
      hash = (37 * hash) + SANDBOX_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSandboxConfig().hashCode();
    }
    hash = (37 * hash) + NODE_GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getNodeGroup().hashCode();
    if (hasReservationAffinity()) {
      hash = (37 * hash) + RESERVATION_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getReservationAffinity().hashCode();
    }
    if (hasShieldedInstanceConfig()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
    }
    if (hasLinuxNodeConfig()) {
      hash = (37 * hash) + LINUX_NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLinuxNodeConfig().hashCode();
    }
    if (hasKubeletConfig()) {
      hash = (37 * hash) + KUBELET_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getKubeletConfig().hashCode();
    }
    hash = (37 * hash) + BOOT_DISK_KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getBootDiskKmsKey().hashCode();
    if (hasGcfsConfig()) {
      hash = (37 * hash) + GCFS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGcfsConfig().hashCode();
    }
    if (hasAdvancedMachineFeatures()) {
      hash = (37 * hash) + ADVANCED_MACHINE_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedMachineFeatures().hashCode();
    }
    if (hasGvnic()) {
      hash = (37 * hash) + GVNIC_FIELD_NUMBER;
      hash = (53 * hash) + getGvnic().hashCode();
    }
    hash = (37 * hash) + SPOT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSpot());
    if (hasConfidentialNodes()) {
      hash = (37 * hash) + CONFIDENTIAL_NODES_FIELD_NUMBER;
      hash = (53 * hash) + getConfidentialNodes().hashCode();
    }
    if (hasFastSocket()) {
      hash = (37 * hash) + FAST_SOCKET_FIELD_NUMBER;
      hash = (53 * hash) + getFastSocket().hashCode();
    }
    if (!internalGetResourceLabels().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceLabels().hashCode();
    }
    if (hasLoggingConfig()) {
      hash = (37 * hash) + LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingConfig().hashCode();
    }
    if (hasWindowsNodeConfig()) {
      hash = (37 * hash) + WINDOWS_NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWindowsNodeConfig().hashCode();
    }
    if (hasLocalNvmeSsdBlockConfig()) {
      hash = (37 * hash) + LOCAL_NVME_SSD_BLOCK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLocalNvmeSsdBlockConfig().hashCode();
    }
    if (hasEphemeralStorageLocalSsdConfig()) {
      hash = (37 * hash) + EPHEMERAL_STORAGE_LOCAL_SSD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEphemeralStorageLocalSsdConfig().hashCode();
    }
    if (hasSoleTenantConfig()) {
      hash = (37 * hash) + SOLE_TENANT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSoleTenantConfig().hashCode();
    }
    if (hasContainerdConfig()) {
      hash = (37 * hash) + CONTAINERD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getContainerdConfig().hashCode();
    }
    if (hasResourceManagerTags()) {
      hash = (37 * hash) + RESOURCE_MANAGER_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceManagerTags().hashCode();
    }
    hash = (37 * hash) + ENABLE_CONFIDENTIAL_STORAGE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableConfidentialStorage());
    if (getSecondaryBootDisksCount() > 0) {
      hash = (37 * hash) + SECONDARY_BOOT_DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryBootDisksList().hashCode();
    }
    if (hasSecondaryBootDiskUpdateStrategy()) {
      hash = (37 * hash) + SECONDARY_BOOT_DISK_UPDATE_STRATEGY_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryBootDiskUpdateStrategy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.NodeConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.NodeConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.NodeConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.NodeConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.NodeConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.NodeConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.NodeConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.NodeConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.NodeConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.NodeConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.NodeConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.NodeConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.NodeConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters that describe the nodes in a cluster.
   *
   * GKE Autopilot clusters do not
   * recognize parameters in `NodeConfig`. Use
   * [AutoprovisioningNodePoolDefaults][google.container.v1.AutoprovisioningNodePoolDefaults]
   * instead.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodeConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.NodeConfig)
      com.google.container.v1.NodeConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodeConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMetadata();
        case 6:
          return internalGetLabels();
        case 37:
          return internalGetResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableMetadata();
        case 6:
          return internalGetMutableLabels();
        case 37:
          return internalGetMutableResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodeConfig.class,
              com.google.container.v1.NodeConfig.Builder.class);
    }

    // Construct using com.google.container.v1.NodeConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAcceleratorsFieldBuilder();
        getWorkloadMetadataConfigFieldBuilder();
        getTaintsFieldBuilder();
        getSandboxConfigFieldBuilder();
        getReservationAffinityFieldBuilder();
        getShieldedInstanceConfigFieldBuilder();
        getLinuxNodeConfigFieldBuilder();
        getKubeletConfigFieldBuilder();
        getGcfsConfigFieldBuilder();
        getAdvancedMachineFeaturesFieldBuilder();
        getGvnicFieldBuilder();
        getConfidentialNodesFieldBuilder();
        getFastSocketFieldBuilder();
        getLoggingConfigFieldBuilder();
        getWindowsNodeConfigFieldBuilder();
        getLocalNvmeSsdBlockConfigFieldBuilder();
        getEphemeralStorageLocalSsdConfigFieldBuilder();
        getSoleTenantConfigFieldBuilder();
        getContainerdConfigFieldBuilder();
        getResourceManagerTagsFieldBuilder();
        getSecondaryBootDisksFieldBuilder();
        getSecondaryBootDiskUpdateStrategyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      machineType_ = "";
      diskSizeGb_ = 0;
      oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceAccount_ = "";
      internalGetMutableMetadata().clear();
      imageType_ = "";
      internalGetMutableLabels().clear();
      localSsdCount_ = 0;
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      preemptible_ = false;
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      diskType_ = "";
      minCpuPlatform_ = "";
      workloadMetadataConfig_ = null;
      if (workloadMetadataConfigBuilder_ != null) {
        workloadMetadataConfigBuilder_.dispose();
        workloadMetadataConfigBuilder_ = null;
      }
      if (taintsBuilder_ == null) {
        taints_ = java.util.Collections.emptyList();
      } else {
        taints_ = null;
        taintsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      sandboxConfig_ = null;
      if (sandboxConfigBuilder_ != null) {
        sandboxConfigBuilder_.dispose();
        sandboxConfigBuilder_ = null;
      }
      nodeGroup_ = "";
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      linuxNodeConfig_ = null;
      if (linuxNodeConfigBuilder_ != null) {
        linuxNodeConfigBuilder_.dispose();
        linuxNodeConfigBuilder_ = null;
      }
      kubeletConfig_ = null;
      if (kubeletConfigBuilder_ != null) {
        kubeletConfigBuilder_.dispose();
        kubeletConfigBuilder_ = null;
      }
      bootDiskKmsKey_ = "";
      gcfsConfig_ = null;
      if (gcfsConfigBuilder_ != null) {
        gcfsConfigBuilder_.dispose();
        gcfsConfigBuilder_ = null;
      }
      advancedMachineFeatures_ = null;
      if (advancedMachineFeaturesBuilder_ != null) {
        advancedMachineFeaturesBuilder_.dispose();
        advancedMachineFeaturesBuilder_ = null;
      }
      gvnic_ = null;
      if (gvnicBuilder_ != null) {
        gvnicBuilder_.dispose();
        gvnicBuilder_ = null;
      }
      spot_ = false;
      confidentialNodes_ = null;
      if (confidentialNodesBuilder_ != null) {
        confidentialNodesBuilder_.dispose();
        confidentialNodesBuilder_ = null;
      }
      fastSocket_ = null;
      if (fastSocketBuilder_ != null) {
        fastSocketBuilder_.dispose();
        fastSocketBuilder_ = null;
      }
      internalGetMutableResourceLabels().clear();
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      windowsNodeConfig_ = null;
      if (windowsNodeConfigBuilder_ != null) {
        windowsNodeConfigBuilder_.dispose();
        windowsNodeConfigBuilder_ = null;
      }
      localNvmeSsdBlockConfig_ = null;
      if (localNvmeSsdBlockConfigBuilder_ != null) {
        localNvmeSsdBlockConfigBuilder_.dispose();
        localNvmeSsdBlockConfigBuilder_ = null;
      }
      ephemeralStorageLocalSsdConfig_ = null;
      if (ephemeralStorageLocalSsdConfigBuilder_ != null) {
        ephemeralStorageLocalSsdConfigBuilder_.dispose();
        ephemeralStorageLocalSsdConfigBuilder_ = null;
      }
      soleTenantConfig_ = null;
      if (soleTenantConfigBuilder_ != null) {
        soleTenantConfigBuilder_.dispose();
        soleTenantConfigBuilder_ = null;
      }
      containerdConfig_ = null;
      if (containerdConfigBuilder_ != null) {
        containerdConfigBuilder_.dispose();
        containerdConfigBuilder_ = null;
      }
      resourceManagerTags_ = null;
      if (resourceManagerTagsBuilder_ != null) {
        resourceManagerTagsBuilder_.dispose();
        resourceManagerTagsBuilder_ = null;
      }
      enableConfidentialStorage_ = false;
      if (secondaryBootDisksBuilder_ == null) {
        secondaryBootDisks_ = java.util.Collections.emptyList();
      } else {
        secondaryBootDisks_ = null;
        secondaryBootDisksBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00000020);
      secondaryBootDiskUpdateStrategy_ = null;
      if (secondaryBootDiskUpdateStrategyBuilder_ != null) {
        secondaryBootDiskUpdateStrategyBuilder_.dispose();
        secondaryBootDiskUpdateStrategyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodeConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.NodeConfig getDefaultInstanceForType() {
      return com.google.container.v1.NodeConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.NodeConfig build() {
      com.google.container.v1.NodeConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.NodeConfig buildPartial() {
      com.google.container.v1.NodeConfig result = new com.google.container.v1.NodeConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.NodeConfig result) {
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
      if (taintsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          taints_ = java.util.Collections.unmodifiableList(taints_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.taints_ = taints_;
      } else {
        result.taints_ = taintsBuilder_.build();
      }
      if (secondaryBootDisksBuilder_ == null) {
        if (((bitField1_ & 0x00000020) != 0)) {
          secondaryBootDisks_ = java.util.Collections.unmodifiableList(secondaryBootDisks_);
          bitField1_ = (bitField1_ & ~0x00000020);
        }
        result.secondaryBootDisks_ = secondaryBootDisks_;
      } else {
        result.secondaryBootDisks_ = secondaryBootDisksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.NodeConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.machineType_ = machineType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        oauthScopes_.makeImmutable();
        result.oauthScopes_ = oauthScopes_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.imageType_ = imageType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.localSsdCount_ = localSsdCount_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.preemptible_ = preemptible_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.diskType_ = diskType_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.minCpuPlatform_ = minCpuPlatform_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.workloadMetadataConfig_ =
            workloadMetadataConfigBuilder_ == null
                ? workloadMetadataConfig_
                : workloadMetadataConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sandboxConfig_ =
            sandboxConfigBuilder_ == null ? sandboxConfig_ : sandboxConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.nodeGroup_ = nodeGroup_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.reservationAffinity_ =
            reservationAffinityBuilder_ == null
                ? reservationAffinity_
                : reservationAffinityBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.shieldedInstanceConfig_ =
            shieldedInstanceConfigBuilder_ == null
                ? shieldedInstanceConfig_
                : shieldedInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.linuxNodeConfig_ =
            linuxNodeConfigBuilder_ == null ? linuxNodeConfig_ : linuxNodeConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.kubeletConfig_ =
            kubeletConfigBuilder_ == null ? kubeletConfig_ : kubeletConfigBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.bootDiskKmsKey_ = bootDiskKmsKey_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.gcfsConfig_ = gcfsConfigBuilder_ == null ? gcfsConfig_ : gcfsConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.advancedMachineFeatures_ =
            advancedMachineFeaturesBuilder_ == null
                ? advancedMachineFeatures_
                : advancedMachineFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.gvnic_ = gvnicBuilder_ == null ? gvnic_ : gvnicBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.spot_ = spot_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.confidentialNodes_ =
            confidentialNodesBuilder_ == null
                ? confidentialNodes_
                : confidentialNodesBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.fastSocket_ = fastSocketBuilder_ == null ? fastSocket_ : fastSocketBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.resourceLabels_ = internalGetResourceLabels();
        result.resourceLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.loggingConfig_ =
            loggingConfigBuilder_ == null ? loggingConfig_ : loggingConfigBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.windowsNodeConfig_ =
            windowsNodeConfigBuilder_ == null
                ? windowsNodeConfig_
                : windowsNodeConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.localNvmeSsdBlockConfig_ =
            localNvmeSsdBlockConfigBuilder_ == null
                ? localNvmeSsdBlockConfig_
                : localNvmeSsdBlockConfigBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.container.v1.NodeConfig result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.ephemeralStorageLocalSsdConfig_ =
            ephemeralStorageLocalSsdConfigBuilder_ == null
                ? ephemeralStorageLocalSsdConfig_
                : ephemeralStorageLocalSsdConfigBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.soleTenantConfig_ =
            soleTenantConfigBuilder_ == null ? soleTenantConfig_ : soleTenantConfigBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.containerdConfig_ =
            containerdConfigBuilder_ == null ? containerdConfig_ : containerdConfigBuilder_.build();
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.resourceManagerTags_ =
            resourceManagerTagsBuilder_ == null
                ? resourceManagerTags_
                : resourceManagerTagsBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.enableConfidentialStorage_ = enableConfidentialStorage_;
      }
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.secondaryBootDiskUpdateStrategy_ =
            secondaryBootDiskUpdateStrategyBuilder_ == null
                ? secondaryBootDiskUpdateStrategy_
                : secondaryBootDiskUpdateStrategyBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.NodeConfig) {
        return mergeFrom((com.google.container.v1.NodeConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.NodeConfig other) {
      if (other == com.google.container.v1.NodeConfig.getDefaultInstance()) return this;
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getDiskSizeGb() != 0) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (!other.oauthScopes_.isEmpty()) {
        if (oauthScopes_.isEmpty()) {
          oauthScopes_ = other.oauthScopes_;
          bitField0_ |= 0x00000004;
        } else {
          ensureOauthScopesIsMutable();
          oauthScopes_.addAll(other.oauthScopes_);
        }
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x00000010;
      if (!other.getImageType().isEmpty()) {
        imageType_ = other.imageType_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.getLocalSsdCount() != 0) {
        setLocalSsdCount(other.getLocalSsdCount());
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000100;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (other.getPreemptible() != false) {
        setPreemptible(other.getPreemptible());
      }
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000400);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (!other.getDiskType().isEmpty()) {
        diskType_ = other.diskType_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getMinCpuPlatform().isEmpty()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasWorkloadMetadataConfig()) {
        mergeWorkloadMetadataConfig(other.getWorkloadMetadataConfig());
      }
      if (taintsBuilder_ == null) {
        if (!other.taints_.isEmpty()) {
          if (taints_.isEmpty()) {
            taints_ = other.taints_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureTaintsIsMutable();
            taints_.addAll(other.taints_);
          }
          onChanged();
        }
      } else {
        if (!other.taints_.isEmpty()) {
          if (taintsBuilder_.isEmpty()) {
            taintsBuilder_.dispose();
            taintsBuilder_ = null;
            taints_ = other.taints_;
            bitField0_ = (bitField0_ & ~0x00004000);
            taintsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTaintsFieldBuilder()
                    : null;
          } else {
            taintsBuilder_.addAllMessages(other.taints_);
          }
        }
      }
      if (other.hasSandboxConfig()) {
        mergeSandboxConfig(other.getSandboxConfig());
      }
      if (!other.getNodeGroup().isEmpty()) {
        nodeGroup_ = other.nodeGroup_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasReservationAffinity()) {
        mergeReservationAffinity(other.getReservationAffinity());
      }
      if (other.hasShieldedInstanceConfig()) {
        mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
      }
      if (other.hasLinuxNodeConfig()) {
        mergeLinuxNodeConfig(other.getLinuxNodeConfig());
      }
      if (other.hasKubeletConfig()) {
        mergeKubeletConfig(other.getKubeletConfig());
      }
      if (!other.getBootDiskKmsKey().isEmpty()) {
        bootDiskKmsKey_ = other.bootDiskKmsKey_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasGcfsConfig()) {
        mergeGcfsConfig(other.getGcfsConfig());
      }
      if (other.hasAdvancedMachineFeatures()) {
        mergeAdvancedMachineFeatures(other.getAdvancedMachineFeatures());
      }
      if (other.hasGvnic()) {
        mergeGvnic(other.getGvnic());
      }
      if (other.getSpot() != false) {
        setSpot(other.getSpot());
      }
      if (other.hasConfidentialNodes()) {
        mergeConfidentialNodes(other.getConfidentialNodes());
      }
      if (other.hasFastSocket()) {
        mergeFastSocket(other.getFastSocket());
      }
      internalGetMutableResourceLabels().mergeFrom(other.internalGetResourceLabels());
      bitField0_ |= 0x10000000;
      if (other.hasLoggingConfig()) {
        mergeLoggingConfig(other.getLoggingConfig());
      }
      if (other.hasWindowsNodeConfig()) {
        mergeWindowsNodeConfig(other.getWindowsNodeConfig());
      }
      if (other.hasLocalNvmeSsdBlockConfig()) {
        mergeLocalNvmeSsdBlockConfig(other.getLocalNvmeSsdBlockConfig());
      }
      if (other.hasEphemeralStorageLocalSsdConfig()) {
        mergeEphemeralStorageLocalSsdConfig(other.getEphemeralStorageLocalSsdConfig());
      }
      if (other.hasSoleTenantConfig()) {
        mergeSoleTenantConfig(other.getSoleTenantConfig());
      }
      if (other.hasContainerdConfig()) {
        mergeContainerdConfig(other.getContainerdConfig());
      }
      if (other.hasResourceManagerTags()) {
        mergeResourceManagerTags(other.getResourceManagerTags());
      }
      if (other.getEnableConfidentialStorage() != false) {
        setEnableConfidentialStorage(other.getEnableConfidentialStorage());
      }
      if (secondaryBootDisksBuilder_ == null) {
        if (!other.secondaryBootDisks_.isEmpty()) {
          if (secondaryBootDisks_.isEmpty()) {
            secondaryBootDisks_ = other.secondaryBootDisks_;
            bitField1_ = (bitField1_ & ~0x00000020);
          } else {
            ensureSecondaryBootDisksIsMutable();
            secondaryBootDisks_.addAll(other.secondaryBootDisks_);
          }
          onChanged();
        }
      } else {
        if (!other.secondaryBootDisks_.isEmpty()) {
          if (secondaryBootDisksBuilder_.isEmpty()) {
            secondaryBootDisksBuilder_.dispose();
            secondaryBootDisksBuilder_ = null;
            secondaryBootDisks_ = other.secondaryBootDisks_;
            bitField1_ = (bitField1_ & ~0x00000020);
            secondaryBootDisksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecondaryBootDisksFieldBuilder()
                    : null;
          } else {
            secondaryBootDisksBuilder_.addAllMessages(other.secondaryBootDisks_);
          }
        }
      }
      if (other.hasSecondaryBootDiskUpdateStrategy()) {
        mergeSecondaryBootDiskUpdateStrategy(other.getSecondaryBootDiskUpdateStrategy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                diskSizeGb_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureOauthScopesIsMutable();
                oauthScopes_.add(s);
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                imageType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                localSsdCount_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 66
            case 74:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 74
            case 80:
              {
                preemptible_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 90:
              {
                com.google.container.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.container.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                diskType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getWorkloadMetadataConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                com.google.container.v1.NodeTaint m =
                    input.readMessage(
                        com.google.container.v1.NodeTaint.parser(), extensionRegistry);
                if (taintsBuilder_ == null) {
                  ensureTaintsIsMutable();
                  taints_.add(m);
                } else {
                  taintsBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 138:
              {
                input.readMessage(getSandboxConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            case 146:
              {
                nodeGroup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getReservationAffinityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getLinuxNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getKubeletConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 178
            case 186:
              {
                bootDiskKmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 186
            case 202:
              {
                input.readMessage(getGcfsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(
                    getAdvancedMachineFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 210
            case 234:
              {
                input.readMessage(getGvnicFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 234
            case 256:
              {
                spot_ = input.readBool();
                bitField0_ |= 0x02000000;
                break;
              } // case 256
            case 282:
              {
                input.readMessage(
                    getConfidentialNodesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 282
            case 290:
              {
                input.readMessage(getFastSocketFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 290
            case 298:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLabels__ =
                    input.readMessage(
                        ResourceLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableResourceLabels()
                    .getMutableMap()
                    .put(resourceLabels__.getKey(), resourceLabels__.getValue());
                bitField0_ |= 0x10000000;
                break;
              } // case 298
            case 306:
              {
                input.readMessage(getLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 306
            case 314:
              {
                input.readMessage(
                    getWindowsNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 314
            case 322:
              {
                input.readMessage(
                    getLocalNvmeSsdBlockConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 322
            case 330:
              {
                input.readMessage(
                    getEphemeralStorageLocalSsdConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000001;
                break;
              } // case 330
            case 338:
              {
                input.readMessage(
                    getSoleTenantConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000002;
                break;
              } // case 338
            case 346:
              {
                input.readMessage(
                    getContainerdConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000004;
                break;
              } // case 346
            case 362:
              {
                input.readMessage(
                    getResourceManagerTagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000008;
                break;
              } // case 362
            case 368:
              {
                enableConfidentialStorage_ = input.readBool();
                bitField1_ |= 0x00000010;
                break;
              } // case 368
            case 386:
              {
                com.google.container.v1.SecondaryBootDisk m =
                    input.readMessage(
                        com.google.container.v1.SecondaryBootDisk.parser(), extensionRegistry);
                if (secondaryBootDisksBuilder_ == null) {
                  ensureSecondaryBootDisksIsMutable();
                  secondaryBootDisks_.add(m);
                } else {
                  secondaryBootDisksBuilder_.addMessage(m);
                }
                break;
              } // case 386
            case 402:
              {
                input.readMessage(
                    getSecondaryBootDiskUpdateStrategyFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000040;
                break;
              } // case 402
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     *
     * If unspecified, the default machine type is `e2-medium`.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     *
     * If unspecified, the default machine type is `e2-medium`.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     *
     * If unspecified, the default machine type is `e2-medium`.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     *
     * If unspecified, the default machine type is `e2-medium`.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Google Compute Engine [machine
     * type](https://cloud.google.com/compute/docs/machine-types)
     *
     * If unspecified, the default machine type is `e2-medium`.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     *
     * If unspecified, the default disk size is 100GB.
     * </pre>
     *
     * <code>int32 disk_size_gb = 2;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public int getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     *
     * If unspecified, the default disk size is 100GB.
     * </pre>
     *
     * <code>int32 disk_size_gb = 2;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(int value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     *
     * If unspecified, the default disk size is 100GB.
     * </pre>
     *
     * <code>int32 disk_size_gb = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000002);
      diskSizeGb_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList oauthScopes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureOauthScopesIsMutable() {
      if (!oauthScopes_.isModifiable()) {
        oauthScopes_ = new com.google.protobuf.LazyStringArrayList(oauthScopes_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @return A list containing the oauthScopes.
     */
    public com.google.protobuf.ProtocolStringList getOauthScopesList() {
      oauthScopes_.makeImmutable();
      return oauthScopes_;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @return The count of oauthScopes.
     */
    public int getOauthScopesCount() {
      return oauthScopes_.size();
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The oauthScopes at the given index.
     */
    public java.lang.String getOauthScopes(int index) {
      return oauthScopes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the oauthScopes at the given index.
     */
    public com.google.protobuf.ByteString getOauthScopesBytes(int index) {
      return oauthScopes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The oauthScopes to set.
     * @return This builder for chaining.
     */
    public Builder setOauthScopes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOauthScopesIsMutable();
      oauthScopes_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @param value The oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addOauthScopes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOauthScopesIsMutable();
      oauthScopes_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @param values The oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addAllOauthScopes(java.lang.Iterable<java.lang.String> values) {
      ensureOauthScopesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, oauthScopes_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOauthScopes() {
      oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 3;</code>
     *
     * @param value The bytes of the oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addOauthScopesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureOauthScopesIsMutable();
      oauthScopes_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 9;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 9;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 9;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 9;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x00000010;
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
     * in length. These are reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other
     * metadata keys for the project or be one of the reserved keys:
     *
     *  - "cluster-location"
     *  - "cluster-name"
     *  - "cluster-uid"
     *  - "configure-sh"
     *  - "containerd-configure-sh"
     *  - "enable-os-login"
     *  - "gci-ensure-gke-docker"
     *  - "gci-metrics-enabled"
     *  - "gci-update-strategy"
     *  - "instance-template"
     *  - "kube-env"
     *  - "startup-script"
     *  - "user-data"
     *  - "disable-address-manager"
     *  - "windows-startup-script-ps1"
     *  - "common-psm1"
     *  - "k8s-node-setup-psm1"
     *  - "install-ssh-psm1"
     *  - "user-profile-psm1"
     *
     * Values are free-form strings, and only have meaning as interpreted by
     * the image running in the instance. The only restriction placed on them is
     * that each value's size must be less than or equal to 32 KB.
     *
     * The total size of all keys and values must be less than 512 KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.lang.Object imageType_ = "";
    /**
     *
     *
     * <pre>
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 5;</code>
     *
     * @return The imageType.
     */
    public java.lang.String getImageType() {
      java.lang.Object ref = imageType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 5;</code>
     *
     * @return The bytes for imageType.
     */
    public com.google.protobuf.ByteString getImageTypeBytes() {
      java.lang.Object ref = imageType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 5;</code>
     *
     * @param value The imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageType() {
      imageType_ = getDefaultInstance().getImageType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image type to use for this node. Note that for a given image type,
     * the latest version of it will be used. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 5;</code>
     *
     * @param value The bytes for imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     * These will added in addition to any default label(s) that
     * Kubernetes may apply to the node.
     * In case of conflict in label keys, the applied set may differ depending on
     * the Kubernetes version -- it's best to assume the behavior is undefined
     * and conflicts should be avoided.
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private int localSsdCount_;
    /**
     *
     *
     * <pre>
     * The number of local SSD disks to be attached to the node.
     *
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     * </pre>
     *
     * <code>int32 local_ssd_count = 7;</code>
     *
     * @return The localSsdCount.
     */
    @java.lang.Override
    public int getLocalSsdCount() {
      return localSsdCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of local SSD disks to be attached to the node.
     *
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     * </pre>
     *
     * <code>int32 local_ssd_count = 7;</code>
     *
     * @param value The localSsdCount to set.
     * @return This builder for chaining.
     */
    public Builder setLocalSsdCount(int value) {

      localSsdCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of local SSD disks to be attached to the node.
     *
     * The limit for this value is dependent upon the maximum number of
     * disks available on a machine per zone. See:
     * https://cloud.google.com/compute/docs/disks/local-ssd
     * for more information.
     * </pre>
     *
     * <code>int32 local_ssd_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalSsdCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      localSsdCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of instance tags applied to all nodes. Tags are used to identify
     * valid sources or targets for network firewalls and are specified by
     * the client during cluster or node pool creation. Each tag within the list
     * must comply with RFC1035.
     * </pre>
     *
     * <code>repeated string tags = 8;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private boolean preemptible_;
    /**
     *
     *
     * <pre>
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     * </pre>
     *
     * <code>bool preemptible = 10;</code>
     *
     * @return The preemptible.
     */
    @java.lang.Override
    public boolean getPreemptible() {
      return preemptible_;
    }
    /**
     *
     *
     * <pre>
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     * </pre>
     *
     * <code>bool preemptible = 10;</code>
     *
     * @param value The preemptible to set.
     * @return This builder for chaining.
     */
    public Builder setPreemptible(boolean value) {

      preemptible_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the nodes are created as preemptible VM instances. See:
     * https://cloud.google.com/compute/docs/instances/preemptible for more
     * information about preemptible VM instances.
     * </pre>
     *
     * <code>bool preemptible = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreemptible() {
      bitField0_ = (bitField0_ & ~0x00000200);
      preemptible_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.AcceleratorConfig> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.container.v1.AcceleratorConfig>(accelerators_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.AcceleratorConfig,
            com.google.container.v1.AcceleratorConfig.Builder,
            com.google.container.v1.AcceleratorConfigOrBuilder>
        acceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public java.util.List<com.google.container.v1.AcceleratorConfig> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public com.google.container.v1.AcceleratorConfig getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder setAccelerators(int index, com.google.container.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder setAccelerators(
        int index, com.google.container.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder addAccelerators(com.google.container.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder addAccelerators(int index, com.google.container.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder addAccelerators(
        com.google.container.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder addAccelerators(
        int index, com.google.container.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.container.v1.AcceleratorConfig> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public com.google.container.v1.AcceleratorConfig.Builder getAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public com.google.container.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public java.util.List<? extends com.google.container.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public com.google.container.v1.AcceleratorConfig.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.container.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public com.google.container.v1.AcceleratorConfig.Builder addAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.container.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 11;</code>
     */
    public java.util.List<com.google.container.v1.AcceleratorConfig.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.AcceleratorConfig,
            com.google.container.v1.AcceleratorConfig.Builder,
            com.google.container.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.AcceleratorConfig,
                com.google.container.v1.AcceleratorConfig.Builder,
                com.google.container.v1.AcceleratorConfigOrBuilder>(
                accelerators_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private java.lang.Object diskType_ = "";
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 12;</code>
     *
     * @return The diskType.
     */
    public java.lang.String getDiskType() {
      java.lang.Object ref = diskType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 12;</code>
     *
     * @return The bytes for diskType.
     */
    public com.google.protobuf.ByteString getDiskTypeBytes() {
      java.lang.Object ref = diskType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 12;</code>
     *
     * @param value The diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskType() {
      diskType_ = getDefaultInstance().getDiskType();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 12;</code>
     *
     * @param value The bytes for diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * </pre>
     *
     * <code>string min_cpu_platform = 13;</code>
     *
     * @return The minCpuPlatform.
     */
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * </pre>
     *
     * <code>string min_cpu_platform = 13;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * </pre>
     *
     * <code>string min_cpu_platform = 13;</code>
     *
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minCpuPlatform_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * </pre>
     *
     * <code>string min_cpu_platform = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCpuPlatform() {
      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum CPU platform to be used by this instance. The instance may be
     * scheduled on the specified or newer CPU platform. Applicable values are the
     * friendly names of CPU platforms, such as
     * `minCpuPlatform: "Intel Haswell"` or
     * `minCpuPlatform: "Intel Sandy Bridge"`. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
     * </pre>
     *
     * <code>string min_cpu_platform = 13;</code>
     *
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minCpuPlatform_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.container.v1.WorkloadMetadataConfig workloadMetadataConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WorkloadMetadataConfig,
            com.google.container.v1.WorkloadMetadataConfig.Builder,
            com.google.container.v1.WorkloadMetadataConfigOrBuilder>
        workloadMetadataConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     *
     * @return Whether the workloadMetadataConfig field is set.
     */
    public boolean hasWorkloadMetadataConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     *
     * @return The workloadMetadataConfig.
     */
    public com.google.container.v1.WorkloadMetadataConfig getWorkloadMetadataConfig() {
      if (workloadMetadataConfigBuilder_ == null) {
        return workloadMetadataConfig_ == null
            ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
            : workloadMetadataConfig_;
      } else {
        return workloadMetadataConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder setWorkloadMetadataConfig(com.google.container.v1.WorkloadMetadataConfig value) {
      if (workloadMetadataConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workloadMetadataConfig_ = value;
      } else {
        workloadMetadataConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder setWorkloadMetadataConfig(
        com.google.container.v1.WorkloadMetadataConfig.Builder builderForValue) {
      if (workloadMetadataConfigBuilder_ == null) {
        workloadMetadataConfig_ = builderForValue.build();
      } else {
        workloadMetadataConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder mergeWorkloadMetadataConfig(
        com.google.container.v1.WorkloadMetadataConfig value) {
      if (workloadMetadataConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && workloadMetadataConfig_ != null
            && workloadMetadataConfig_
                != com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()) {
          getWorkloadMetadataConfigBuilder().mergeFrom(value);
        } else {
          workloadMetadataConfig_ = value;
        }
      } else {
        workloadMetadataConfigBuilder_.mergeFrom(value);
      }
      if (workloadMetadataConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder clearWorkloadMetadataConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      workloadMetadataConfig_ = null;
      if (workloadMetadataConfigBuilder_ != null) {
        workloadMetadataConfigBuilder_.dispose();
        workloadMetadataConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public com.google.container.v1.WorkloadMetadataConfig.Builder
        getWorkloadMetadataConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getWorkloadMetadataConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public com.google.container.v1.WorkloadMetadataConfigOrBuilder
        getWorkloadMetadataConfigOrBuilder() {
      if (workloadMetadataConfigBuilder_ != null) {
        return workloadMetadataConfigBuilder_.getMessageOrBuilder();
      } else {
        return workloadMetadataConfig_ == null
            ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
            : workloadMetadataConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The workload metadata configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WorkloadMetadataConfig,
            com.google.container.v1.WorkloadMetadataConfig.Builder,
            com.google.container.v1.WorkloadMetadataConfigOrBuilder>
        getWorkloadMetadataConfigFieldBuilder() {
      if (workloadMetadataConfigBuilder_ == null) {
        workloadMetadataConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.WorkloadMetadataConfig,
                com.google.container.v1.WorkloadMetadataConfig.Builder,
                com.google.container.v1.WorkloadMetadataConfigOrBuilder>(
                getWorkloadMetadataConfig(), getParentForChildren(), isClean());
        workloadMetadataConfig_ = null;
      }
      return workloadMetadataConfigBuilder_;
    }

    private java.util.List<com.google.container.v1.NodeTaint> taints_ =
        java.util.Collections.emptyList();

    private void ensureTaintsIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        taints_ = new java.util.ArrayList<com.google.container.v1.NodeTaint>(taints_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.NodeTaint,
            com.google.container.v1.NodeTaint.Builder,
            com.google.container.v1.NodeTaintOrBuilder>
        taintsBuilder_;

    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public java.util.List<com.google.container.v1.NodeTaint> getTaintsList() {
      if (taintsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(taints_);
      } else {
        return taintsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public int getTaintsCount() {
      if (taintsBuilder_ == null) {
        return taints_.size();
      } else {
        return taintsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public com.google.container.v1.NodeTaint getTaints(int index) {
      if (taintsBuilder_ == null) {
        return taints_.get(index);
      } else {
        return taintsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder setTaints(int index, com.google.container.v1.NodeTaint value) {
      if (taintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaintsIsMutable();
        taints_.set(index, value);
        onChanged();
      } else {
        taintsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder setTaints(int index, com.google.container.v1.NodeTaint.Builder builderForValue) {
      if (taintsBuilder_ == null) {
        ensureTaintsIsMutable();
        taints_.set(index, builderForValue.build());
        onChanged();
      } else {
        taintsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder addTaints(com.google.container.v1.NodeTaint value) {
      if (taintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaintsIsMutable();
        taints_.add(value);
        onChanged();
      } else {
        taintsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder addTaints(int index, com.google.container.v1.NodeTaint value) {
      if (taintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaintsIsMutable();
        taints_.add(index, value);
        onChanged();
      } else {
        taintsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder addTaints(com.google.container.v1.NodeTaint.Builder builderForValue) {
      if (taintsBuilder_ == null) {
        ensureTaintsIsMutable();
        taints_.add(builderForValue.build());
        onChanged();
      } else {
        taintsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder addTaints(int index, com.google.container.v1.NodeTaint.Builder builderForValue) {
      if (taintsBuilder_ == null) {
        ensureTaintsIsMutable();
        taints_.add(index, builderForValue.build());
        onChanged();
      } else {
        taintsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder addAllTaints(
        java.lang.Iterable<? extends com.google.container.v1.NodeTaint> values) {
      if (taintsBuilder_ == null) {
        ensureTaintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, taints_);
        onChanged();
      } else {
        taintsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder clearTaints() {
      if (taintsBuilder_ == null) {
        taints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        taintsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public Builder removeTaints(int index) {
      if (taintsBuilder_ == null) {
        ensureTaintsIsMutable();
        taints_.remove(index);
        onChanged();
      } else {
        taintsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public com.google.container.v1.NodeTaint.Builder getTaintsBuilder(int index) {
      return getTaintsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public com.google.container.v1.NodeTaintOrBuilder getTaintsOrBuilder(int index) {
      if (taintsBuilder_ == null) {
        return taints_.get(index);
      } else {
        return taintsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public java.util.List<? extends com.google.container.v1.NodeTaintOrBuilder>
        getTaintsOrBuilderList() {
      if (taintsBuilder_ != null) {
        return taintsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(taints_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public com.google.container.v1.NodeTaint.Builder addTaintsBuilder() {
      return getTaintsFieldBuilder()
          .addBuilder(com.google.container.v1.NodeTaint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public com.google.container.v1.NodeTaint.Builder addTaintsBuilder(int index) {
      return getTaintsFieldBuilder()
          .addBuilder(index, com.google.container.v1.NodeTaint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of kubernetes taints to be applied to each node.
     *
     * For more information, including usage and the valid values, see:
     * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
     * </pre>
     *
     * <code>repeated .google.container.v1.NodeTaint taints = 15;</code>
     */
    public java.util.List<com.google.container.v1.NodeTaint.Builder> getTaintsBuilderList() {
      return getTaintsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.NodeTaint,
            com.google.container.v1.NodeTaint.Builder,
            com.google.container.v1.NodeTaintOrBuilder>
        getTaintsFieldBuilder() {
      if (taintsBuilder_ == null) {
        taintsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.NodeTaint,
                com.google.container.v1.NodeTaint.Builder,
                com.google.container.v1.NodeTaintOrBuilder>(
                taints_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        taints_ = null;
      }
      return taintsBuilder_;
    }

    private com.google.container.v1.SandboxConfig sandboxConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SandboxConfig,
            com.google.container.v1.SandboxConfig.Builder,
            com.google.container.v1.SandboxConfigOrBuilder>
        sandboxConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     *
     * @return Whether the sandboxConfig field is set.
     */
    public boolean hasSandboxConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     *
     * @return The sandboxConfig.
     */
    public com.google.container.v1.SandboxConfig getSandboxConfig() {
      if (sandboxConfigBuilder_ == null) {
        return sandboxConfig_ == null
            ? com.google.container.v1.SandboxConfig.getDefaultInstance()
            : sandboxConfig_;
      } else {
        return sandboxConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    public Builder setSandboxConfig(com.google.container.v1.SandboxConfig value) {
      if (sandboxConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sandboxConfig_ = value;
      } else {
        sandboxConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    public Builder setSandboxConfig(com.google.container.v1.SandboxConfig.Builder builderForValue) {
      if (sandboxConfigBuilder_ == null) {
        sandboxConfig_ = builderForValue.build();
      } else {
        sandboxConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    public Builder mergeSandboxConfig(com.google.container.v1.SandboxConfig value) {
      if (sandboxConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && sandboxConfig_ != null
            && sandboxConfig_ != com.google.container.v1.SandboxConfig.getDefaultInstance()) {
          getSandboxConfigBuilder().mergeFrom(value);
        } else {
          sandboxConfig_ = value;
        }
      } else {
        sandboxConfigBuilder_.mergeFrom(value);
      }
      if (sandboxConfig_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    public Builder clearSandboxConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      sandboxConfig_ = null;
      if (sandboxConfigBuilder_ != null) {
        sandboxConfigBuilder_.dispose();
        sandboxConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    public com.google.container.v1.SandboxConfig.Builder getSandboxConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getSandboxConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    public com.google.container.v1.SandboxConfigOrBuilder getSandboxConfigOrBuilder() {
      if (sandboxConfigBuilder_ != null) {
        return sandboxConfigBuilder_.getMessageOrBuilder();
      } else {
        return sandboxConfig_ == null
            ? com.google.container.v1.SandboxConfig.getDefaultInstance()
            : sandboxConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Sandbox configuration for this node.
     * </pre>
     *
     * <code>.google.container.v1.SandboxConfig sandbox_config = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SandboxConfig,
            com.google.container.v1.SandboxConfig.Builder,
            com.google.container.v1.SandboxConfigOrBuilder>
        getSandboxConfigFieldBuilder() {
      if (sandboxConfigBuilder_ == null) {
        sandboxConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.SandboxConfig,
                com.google.container.v1.SandboxConfig.Builder,
                com.google.container.v1.SandboxConfigOrBuilder>(
                getSandboxConfig(), getParentForChildren(), isClean());
        sandboxConfig_ = null;
      }
      return sandboxConfigBuilder_;
    }

    private java.lang.Object nodeGroup_ = "";
    /**
     *
     *
     * <pre>
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     * </pre>
     *
     * <code>string node_group = 18;</code>
     *
     * @return The nodeGroup.
     */
    public java.lang.String getNodeGroup() {
      java.lang.Object ref = nodeGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     * </pre>
     *
     * <code>string node_group = 18;</code>
     *
     * @return The bytes for nodeGroup.
     */
    public com.google.protobuf.ByteString getNodeGroupBytes() {
      java.lang.Object ref = nodeGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     * </pre>
     *
     * <code>string node_group = 18;</code>
     *
     * @param value The nodeGroup to set.
     * @return This builder for chaining.
     */
    public Builder setNodeGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeGroup_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     * </pre>
     *
     * <code>string node_group = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeGroup() {
      nodeGroup_ = getDefaultInstance().getNodeGroup();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Setting this field will assign instances of this
     * pool to run on the specified node group. This is useful for running
     * workloads on [sole tenant
     * nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
     * </pre>
     *
     * <code>string node_group = 18;</code>
     *
     * @param value The bytes for nodeGroup to set.
     * @return This builder for chaining.
     */
    public Builder setNodeGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeGroup_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.container.v1.ReservationAffinity reservationAffinity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ReservationAffinity,
            com.google.container.v1.ReservationAffinity.Builder,
            com.google.container.v1.ReservationAffinityOrBuilder>
        reservationAffinityBuilder_;
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     *
     * @return Whether the reservationAffinity field is set.
     */
    public boolean hasReservationAffinity() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     *
     * @return The reservationAffinity.
     */
    public com.google.container.v1.ReservationAffinity getReservationAffinity() {
      if (reservationAffinityBuilder_ == null) {
        return reservationAffinity_ == null
            ? com.google.container.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      } else {
        return reservationAffinityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    public Builder setReservationAffinity(com.google.container.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationAffinity_ = value;
      } else {
        reservationAffinityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    public Builder setReservationAffinity(
        com.google.container.v1.ReservationAffinity.Builder builderForValue) {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinity_ = builderForValue.build();
      } else {
        reservationAffinityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    public Builder mergeReservationAffinity(com.google.container.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && reservationAffinity_ != null
            && reservationAffinity_
                != com.google.container.v1.ReservationAffinity.getDefaultInstance()) {
          getReservationAffinityBuilder().mergeFrom(value);
        } else {
          reservationAffinity_ = value;
        }
      } else {
        reservationAffinityBuilder_.mergeFrom(value);
      }
      if (reservationAffinity_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    public Builder clearReservationAffinity() {
      bitField0_ = (bitField0_ & ~0x00020000);
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    public com.google.container.v1.ReservationAffinity.Builder getReservationAffinityBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getReservationAffinityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    public com.google.container.v1.ReservationAffinityOrBuilder getReservationAffinityOrBuilder() {
      if (reservationAffinityBuilder_ != null) {
        return reservationAffinityBuilder_.getMessageOrBuilder();
      } else {
        return reservationAffinity_ == null
            ? com.google.container.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      }
    }
    /**
     *
     *
     * <pre>
     * The optional reservation affinity. Setting this field will apply
     * the specified [Zonal Compute
     * Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
     * to this node pool.
     * </pre>
     *
     * <code>.google.container.v1.ReservationAffinity reservation_affinity = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ReservationAffinity,
            com.google.container.v1.ReservationAffinity.Builder,
            com.google.container.v1.ReservationAffinityOrBuilder>
        getReservationAffinityFieldBuilder() {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ReservationAffinity,
                com.google.container.v1.ReservationAffinity.Builder,
                com.google.container.v1.ReservationAffinityOrBuilder>(
                getReservationAffinity(), getParentForChildren(), isClean());
        reservationAffinity_ = null;
      }
      return reservationAffinityBuilder_;
    }

    private com.google.container.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ShieldedInstanceConfig,
            com.google.container.v1.ShieldedInstanceConfig.Builder,
            com.google.container.v1.ShieldedInstanceConfigOrBuilder>
        shieldedInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     *
     * @return Whether the shieldedInstanceConfig field is set.
     */
    public boolean hasShieldedInstanceConfig() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     *
     * @return The shieldedInstanceConfig.
     */
    public com.google.container.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
      if (shieldedInstanceConfigBuilder_ == null) {
        return shieldedInstanceConfig_ == null
            ? com.google.container.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      } else {
        return shieldedInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    public Builder setShieldedInstanceConfig(com.google.container.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceConfig_ = value;
      } else {
        shieldedInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.container.v1.ShieldedInstanceConfig.Builder builderForValue) {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfig_ = builderForValue.build();
      } else {
        shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    public Builder mergeShieldedInstanceConfig(
        com.google.container.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && shieldedInstanceConfig_ != null
            && shieldedInstanceConfig_
                != com.google.container.v1.ShieldedInstanceConfig.getDefaultInstance()) {
          getShieldedInstanceConfigBuilder().mergeFrom(value);
        } else {
          shieldedInstanceConfig_ = value;
        }
      } else {
        shieldedInstanceConfigBuilder_.mergeFrom(value);
      }
      if (shieldedInstanceConfig_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    public Builder clearShieldedInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00040000);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    public com.google.container.v1.ShieldedInstanceConfig.Builder
        getShieldedInstanceConfigBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getShieldedInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    public com.google.container.v1.ShieldedInstanceConfigOrBuilder
        getShieldedInstanceConfigOrBuilder() {
      if (shieldedInstanceConfigBuilder_ != null) {
        return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceConfig_ == null
            ? com.google.container.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedInstanceConfig shielded_instance_config = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ShieldedInstanceConfig,
            com.google.container.v1.ShieldedInstanceConfig.Builder,
            com.google.container.v1.ShieldedInstanceConfigOrBuilder>
        getShieldedInstanceConfigFieldBuilder() {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ShieldedInstanceConfig,
                com.google.container.v1.ShieldedInstanceConfig.Builder,
                com.google.container.v1.ShieldedInstanceConfigOrBuilder>(
                getShieldedInstanceConfig(), getParentForChildren(), isClean());
        shieldedInstanceConfig_ = null;
      }
      return shieldedInstanceConfigBuilder_;
    }

    private com.google.container.v1.LinuxNodeConfig linuxNodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LinuxNodeConfig,
            com.google.container.v1.LinuxNodeConfig.Builder,
            com.google.container.v1.LinuxNodeConfigOrBuilder>
        linuxNodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     *
     * @return Whether the linuxNodeConfig field is set.
     */
    public boolean hasLinuxNodeConfig() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     *
     * @return The linuxNodeConfig.
     */
    public com.google.container.v1.LinuxNodeConfig getLinuxNodeConfig() {
      if (linuxNodeConfigBuilder_ == null) {
        return linuxNodeConfig_ == null
            ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
            : linuxNodeConfig_;
      } else {
        return linuxNodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    public Builder setLinuxNodeConfig(com.google.container.v1.LinuxNodeConfig value) {
      if (linuxNodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linuxNodeConfig_ = value;
      } else {
        linuxNodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    public Builder setLinuxNodeConfig(
        com.google.container.v1.LinuxNodeConfig.Builder builderForValue) {
      if (linuxNodeConfigBuilder_ == null) {
        linuxNodeConfig_ = builderForValue.build();
      } else {
        linuxNodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    public Builder mergeLinuxNodeConfig(com.google.container.v1.LinuxNodeConfig value) {
      if (linuxNodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && linuxNodeConfig_ != null
            && linuxNodeConfig_ != com.google.container.v1.LinuxNodeConfig.getDefaultInstance()) {
          getLinuxNodeConfigBuilder().mergeFrom(value);
        } else {
          linuxNodeConfig_ = value;
        }
      } else {
        linuxNodeConfigBuilder_.mergeFrom(value);
      }
      if (linuxNodeConfig_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    public Builder clearLinuxNodeConfig() {
      bitField0_ = (bitField0_ & ~0x00080000);
      linuxNodeConfig_ = null;
      if (linuxNodeConfigBuilder_ != null) {
        linuxNodeConfigBuilder_.dispose();
        linuxNodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    public com.google.container.v1.LinuxNodeConfig.Builder getLinuxNodeConfigBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getLinuxNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    public com.google.container.v1.LinuxNodeConfigOrBuilder getLinuxNodeConfigOrBuilder() {
      if (linuxNodeConfigBuilder_ != null) {
        return linuxNodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return linuxNodeConfig_ == null
            ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
            : linuxNodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LinuxNodeConfig,
            com.google.container.v1.LinuxNodeConfig.Builder,
            com.google.container.v1.LinuxNodeConfigOrBuilder>
        getLinuxNodeConfigFieldBuilder() {
      if (linuxNodeConfigBuilder_ == null) {
        linuxNodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.LinuxNodeConfig,
                com.google.container.v1.LinuxNodeConfig.Builder,
                com.google.container.v1.LinuxNodeConfigOrBuilder>(
                getLinuxNodeConfig(), getParentForChildren(), isClean());
        linuxNodeConfig_ = null;
      }
      return linuxNodeConfigBuilder_;
    }

    private com.google.container.v1.NodeKubeletConfig kubeletConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeKubeletConfig,
            com.google.container.v1.NodeKubeletConfig.Builder,
            com.google.container.v1.NodeKubeletConfigOrBuilder>
        kubeletConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     *
     * @return Whether the kubeletConfig field is set.
     */
    public boolean hasKubeletConfig() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     *
     * @return The kubeletConfig.
     */
    public com.google.container.v1.NodeKubeletConfig getKubeletConfig() {
      if (kubeletConfigBuilder_ == null) {
        return kubeletConfig_ == null
            ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
            : kubeletConfig_;
      } else {
        return kubeletConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    public Builder setKubeletConfig(com.google.container.v1.NodeKubeletConfig value) {
      if (kubeletConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubeletConfig_ = value;
      } else {
        kubeletConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    public Builder setKubeletConfig(
        com.google.container.v1.NodeKubeletConfig.Builder builderForValue) {
      if (kubeletConfigBuilder_ == null) {
        kubeletConfig_ = builderForValue.build();
      } else {
        kubeletConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    public Builder mergeKubeletConfig(com.google.container.v1.NodeKubeletConfig value) {
      if (kubeletConfigBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && kubeletConfig_ != null
            && kubeletConfig_ != com.google.container.v1.NodeKubeletConfig.getDefaultInstance()) {
          getKubeletConfigBuilder().mergeFrom(value);
        } else {
          kubeletConfig_ = value;
        }
      } else {
        kubeletConfigBuilder_.mergeFrom(value);
      }
      if (kubeletConfig_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    public Builder clearKubeletConfig() {
      bitField0_ = (bitField0_ & ~0x00100000);
      kubeletConfig_ = null;
      if (kubeletConfigBuilder_ != null) {
        kubeletConfigBuilder_.dispose();
        kubeletConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    public com.google.container.v1.NodeKubeletConfig.Builder getKubeletConfigBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getKubeletConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    public com.google.container.v1.NodeKubeletConfigOrBuilder getKubeletConfigOrBuilder() {
      if (kubeletConfigBuilder_ != null) {
        return kubeletConfigBuilder_.getMessageOrBuilder();
      } else {
        return kubeletConfig_ == null
            ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
            : kubeletConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeKubeletConfig,
            com.google.container.v1.NodeKubeletConfig.Builder,
            com.google.container.v1.NodeKubeletConfigOrBuilder>
        getKubeletConfigFieldBuilder() {
      if (kubeletConfigBuilder_ == null) {
        kubeletConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeKubeletConfig,
                com.google.container.v1.NodeKubeletConfig.Builder,
                com.google.container.v1.NodeKubeletConfigOrBuilder>(
                getKubeletConfig(), getParentForChildren(), isClean());
        kubeletConfig_ = null;
      }
      return kubeletConfigBuilder_;
    }

    private java.lang.Object bootDiskKmsKey_ = "";
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23;</code>
     *
     * @return The bootDiskKmsKey.
     */
    public java.lang.String getBootDiskKmsKey() {
      java.lang.Object ref = bootDiskKmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bootDiskKmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23;</code>
     *
     * @return The bytes for bootDiskKmsKey.
     */
    public com.google.protobuf.ByteString getBootDiskKmsKeyBytes() {
      java.lang.Object ref = bootDiskKmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bootDiskKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23;</code>
     *
     * @param value The bootDiskKmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bootDiskKmsKey_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBootDiskKmsKey() {
      bootDiskKmsKey_ = getDefaultInstance().getBootDiskKmsKey();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 23;</code>
     *
     * @param value The bytes for bootDiskKmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bootDiskKmsKey_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private com.google.container.v1.GcfsConfig gcfsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.GcfsConfig,
            com.google.container.v1.GcfsConfig.Builder,
            com.google.container.v1.GcfsConfigOrBuilder>
        gcfsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     *
     * @return Whether the gcfsConfig field is set.
     */
    public boolean hasGcfsConfig() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     *
     * @return The gcfsConfig.
     */
    public com.google.container.v1.GcfsConfig getGcfsConfig() {
      if (gcfsConfigBuilder_ == null) {
        return gcfsConfig_ == null
            ? com.google.container.v1.GcfsConfig.getDefaultInstance()
            : gcfsConfig_;
      } else {
        return gcfsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    public Builder setGcfsConfig(com.google.container.v1.GcfsConfig value) {
      if (gcfsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcfsConfig_ = value;
      } else {
        gcfsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    public Builder setGcfsConfig(com.google.container.v1.GcfsConfig.Builder builderForValue) {
      if (gcfsConfigBuilder_ == null) {
        gcfsConfig_ = builderForValue.build();
      } else {
        gcfsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    public Builder mergeGcfsConfig(com.google.container.v1.GcfsConfig value) {
      if (gcfsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && gcfsConfig_ != null
            && gcfsConfig_ != com.google.container.v1.GcfsConfig.getDefaultInstance()) {
          getGcfsConfigBuilder().mergeFrom(value);
        } else {
          gcfsConfig_ = value;
        }
      } else {
        gcfsConfigBuilder_.mergeFrom(value);
      }
      if (gcfsConfig_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    public Builder clearGcfsConfig() {
      bitField0_ = (bitField0_ & ~0x00400000);
      gcfsConfig_ = null;
      if (gcfsConfigBuilder_ != null) {
        gcfsConfigBuilder_.dispose();
        gcfsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    public com.google.container.v1.GcfsConfig.Builder getGcfsConfigBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getGcfsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    public com.google.container.v1.GcfsConfigOrBuilder getGcfsConfigOrBuilder() {
      if (gcfsConfigBuilder_ != null) {
        return gcfsConfigBuilder_.getMessageOrBuilder();
      } else {
        return gcfsConfig_ == null
            ? com.google.container.v1.GcfsConfig.getDefaultInstance()
            : gcfsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Google Container File System (image streaming) configs.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.GcfsConfig,
            com.google.container.v1.GcfsConfig.Builder,
            com.google.container.v1.GcfsConfigOrBuilder>
        getGcfsConfigFieldBuilder() {
      if (gcfsConfigBuilder_ == null) {
        gcfsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.GcfsConfig,
                com.google.container.v1.GcfsConfig.Builder,
                com.google.container.v1.GcfsConfigOrBuilder>(
                getGcfsConfig(), getParentForChildren(), isClean());
        gcfsConfig_ = null;
      }
      return gcfsConfigBuilder_;
    }

    private com.google.container.v1.AdvancedMachineFeatures advancedMachineFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AdvancedMachineFeatures,
            com.google.container.v1.AdvancedMachineFeatures.Builder,
            com.google.container.v1.AdvancedMachineFeaturesOrBuilder>
        advancedMachineFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     *
     * @return Whether the advancedMachineFeatures field is set.
     */
    public boolean hasAdvancedMachineFeatures() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     *
     * @return The advancedMachineFeatures.
     */
    public com.google.container.v1.AdvancedMachineFeatures getAdvancedMachineFeatures() {
      if (advancedMachineFeaturesBuilder_ == null) {
        return advancedMachineFeatures_ == null
            ? com.google.container.v1.AdvancedMachineFeatures.getDefaultInstance()
            : advancedMachineFeatures_;
      } else {
        return advancedMachineFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    public Builder setAdvancedMachineFeatures(
        com.google.container.v1.AdvancedMachineFeatures value) {
      if (advancedMachineFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedMachineFeatures_ = value;
      } else {
        advancedMachineFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    public Builder setAdvancedMachineFeatures(
        com.google.container.v1.AdvancedMachineFeatures.Builder builderForValue) {
      if (advancedMachineFeaturesBuilder_ == null) {
        advancedMachineFeatures_ = builderForValue.build();
      } else {
        advancedMachineFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    public Builder mergeAdvancedMachineFeatures(
        com.google.container.v1.AdvancedMachineFeatures value) {
      if (advancedMachineFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && advancedMachineFeatures_ != null
            && advancedMachineFeatures_
                != com.google.container.v1.AdvancedMachineFeatures.getDefaultInstance()) {
          getAdvancedMachineFeaturesBuilder().mergeFrom(value);
        } else {
          advancedMachineFeatures_ = value;
        }
      } else {
        advancedMachineFeaturesBuilder_.mergeFrom(value);
      }
      if (advancedMachineFeatures_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    public Builder clearAdvancedMachineFeatures() {
      bitField0_ = (bitField0_ & ~0x00800000);
      advancedMachineFeatures_ = null;
      if (advancedMachineFeaturesBuilder_ != null) {
        advancedMachineFeaturesBuilder_.dispose();
        advancedMachineFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    public com.google.container.v1.AdvancedMachineFeatures.Builder
        getAdvancedMachineFeaturesBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getAdvancedMachineFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    public com.google.container.v1.AdvancedMachineFeaturesOrBuilder
        getAdvancedMachineFeaturesOrBuilder() {
      if (advancedMachineFeaturesBuilder_ != null) {
        return advancedMachineFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return advancedMachineFeatures_ == null
            ? com.google.container.v1.AdvancedMachineFeatures.getDefaultInstance()
            : advancedMachineFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Advanced features for the Compute Engine VM.
     * </pre>
     *
     * <code>.google.container.v1.AdvancedMachineFeatures advanced_machine_features = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AdvancedMachineFeatures,
            com.google.container.v1.AdvancedMachineFeatures.Builder,
            com.google.container.v1.AdvancedMachineFeaturesOrBuilder>
        getAdvancedMachineFeaturesFieldBuilder() {
      if (advancedMachineFeaturesBuilder_ == null) {
        advancedMachineFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.AdvancedMachineFeatures,
                com.google.container.v1.AdvancedMachineFeatures.Builder,
                com.google.container.v1.AdvancedMachineFeaturesOrBuilder>(
                getAdvancedMachineFeatures(), getParentForChildren(), isClean());
        advancedMachineFeatures_ = null;
      }
      return advancedMachineFeaturesBuilder_;
    }

    private com.google.container.v1.VirtualNIC gvnic_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.VirtualNIC,
            com.google.container.v1.VirtualNIC.Builder,
            com.google.container.v1.VirtualNICOrBuilder>
        gvnicBuilder_;
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     *
     * @return Whether the gvnic field is set.
     */
    public boolean hasGvnic() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     *
     * @return The gvnic.
     */
    public com.google.container.v1.VirtualNIC getGvnic() {
      if (gvnicBuilder_ == null) {
        return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
      } else {
        return gvnicBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder setGvnic(com.google.container.v1.VirtualNIC value) {
      if (gvnicBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gvnic_ = value;
      } else {
        gvnicBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder setGvnic(com.google.container.v1.VirtualNIC.Builder builderForValue) {
      if (gvnicBuilder_ == null) {
        gvnic_ = builderForValue.build();
      } else {
        gvnicBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder mergeGvnic(com.google.container.v1.VirtualNIC value) {
      if (gvnicBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && gvnic_ != null
            && gvnic_ != com.google.container.v1.VirtualNIC.getDefaultInstance()) {
          getGvnicBuilder().mergeFrom(value);
        } else {
          gvnic_ = value;
        }
      } else {
        gvnicBuilder_.mergeFrom(value);
      }
      if (gvnic_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder clearGvnic() {
      bitField0_ = (bitField0_ & ~0x01000000);
      gvnic_ = null;
      if (gvnicBuilder_ != null) {
        gvnicBuilder_.dispose();
        gvnicBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public com.google.container.v1.VirtualNIC.Builder getGvnicBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getGvnicFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public com.google.container.v1.VirtualNICOrBuilder getGvnicOrBuilder() {
      if (gvnicBuilder_ != null) {
        return gvnicBuilder_.getMessageOrBuilder();
      } else {
        return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.VirtualNIC,
            com.google.container.v1.VirtualNIC.Builder,
            com.google.container.v1.VirtualNICOrBuilder>
        getGvnicFieldBuilder() {
      if (gvnicBuilder_ == null) {
        gvnicBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.VirtualNIC,
                com.google.container.v1.VirtualNIC.Builder,
                com.google.container.v1.VirtualNICOrBuilder>(
                getGvnic(), getParentForChildren(), isClean());
        gvnic_ = null;
      }
      return gvnicBuilder_;
    }

    private boolean spot_;
    /**
     *
     *
     * <pre>
     * Spot flag for enabling Spot VM, which is a rebrand of
     * the existing preemptible flag.
     * </pre>
     *
     * <code>bool spot = 32;</code>
     *
     * @return The spot.
     */
    @java.lang.Override
    public boolean getSpot() {
      return spot_;
    }
    /**
     *
     *
     * <pre>
     * Spot flag for enabling Spot VM, which is a rebrand of
     * the existing preemptible flag.
     * </pre>
     *
     * <code>bool spot = 32;</code>
     *
     * @param value The spot to set.
     * @return This builder for chaining.
     */
    public Builder setSpot(boolean value) {

      spot_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spot flag for enabling Spot VM, which is a rebrand of
     * the existing preemptible flag.
     * </pre>
     *
     * <code>bool spot = 32;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpot() {
      bitField0_ = (bitField0_ & ~0x02000000);
      spot_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1.ConfidentialNodes confidentialNodes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ConfidentialNodes,
            com.google.container.v1.ConfidentialNodes.Builder,
            com.google.container.v1.ConfidentialNodesOrBuilder>
        confidentialNodesBuilder_;
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     *
     * @return Whether the confidentialNodes field is set.
     */
    public boolean hasConfidentialNodes() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     *
     * @return The confidentialNodes.
     */
    public com.google.container.v1.ConfidentialNodes getConfidentialNodes() {
      if (confidentialNodesBuilder_ == null) {
        return confidentialNodes_ == null
            ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
            : confidentialNodes_;
      } else {
        return confidentialNodesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    public Builder setConfidentialNodes(com.google.container.v1.ConfidentialNodes value) {
      if (confidentialNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidentialNodes_ = value;
      } else {
        confidentialNodesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    public Builder setConfidentialNodes(
        com.google.container.v1.ConfidentialNodes.Builder builderForValue) {
      if (confidentialNodesBuilder_ == null) {
        confidentialNodes_ = builderForValue.build();
      } else {
        confidentialNodesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    public Builder mergeConfidentialNodes(com.google.container.v1.ConfidentialNodes value) {
      if (confidentialNodesBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && confidentialNodes_ != null
            && confidentialNodes_
                != com.google.container.v1.ConfidentialNodes.getDefaultInstance()) {
          getConfidentialNodesBuilder().mergeFrom(value);
        } else {
          confidentialNodes_ = value;
        }
      } else {
        confidentialNodesBuilder_.mergeFrom(value);
      }
      if (confidentialNodes_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    public Builder clearConfidentialNodes() {
      bitField0_ = (bitField0_ & ~0x04000000);
      confidentialNodes_ = null;
      if (confidentialNodesBuilder_ != null) {
        confidentialNodesBuilder_.dispose();
        confidentialNodesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    public com.google.container.v1.ConfidentialNodes.Builder getConfidentialNodesBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getConfidentialNodesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    public com.google.container.v1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder() {
      if (confidentialNodesBuilder_ != null) {
        return confidentialNodesBuilder_.getMessageOrBuilder();
      } else {
        return confidentialNodes_ == null
            ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
            : confidentialNodes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 35;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ConfidentialNodes,
            com.google.container.v1.ConfidentialNodes.Builder,
            com.google.container.v1.ConfidentialNodesOrBuilder>
        getConfidentialNodesFieldBuilder() {
      if (confidentialNodesBuilder_ == null) {
        confidentialNodesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ConfidentialNodes,
                com.google.container.v1.ConfidentialNodes.Builder,
                com.google.container.v1.ConfidentialNodesOrBuilder>(
                getConfidentialNodes(), getParentForChildren(), isClean());
        confidentialNodes_ = null;
      }
      return confidentialNodesBuilder_;
    }

    private com.google.container.v1.FastSocket fastSocket_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.FastSocket,
            com.google.container.v1.FastSocket.Builder,
            com.google.container.v1.FastSocketOrBuilder>
        fastSocketBuilder_;
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     *
     * @return Whether the fastSocket field is set.
     */
    public boolean hasFastSocket() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     *
     * @return The fastSocket.
     */
    public com.google.container.v1.FastSocket getFastSocket() {
      if (fastSocketBuilder_ == null) {
        return fastSocket_ == null
            ? com.google.container.v1.FastSocket.getDefaultInstance()
            : fastSocket_;
      } else {
        return fastSocketBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    public Builder setFastSocket(com.google.container.v1.FastSocket value) {
      if (fastSocketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fastSocket_ = value;
      } else {
        fastSocketBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    public Builder setFastSocket(com.google.container.v1.FastSocket.Builder builderForValue) {
      if (fastSocketBuilder_ == null) {
        fastSocket_ = builderForValue.build();
      } else {
        fastSocketBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    public Builder mergeFastSocket(com.google.container.v1.FastSocket value) {
      if (fastSocketBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && fastSocket_ != null
            && fastSocket_ != com.google.container.v1.FastSocket.getDefaultInstance()) {
          getFastSocketBuilder().mergeFrom(value);
        } else {
          fastSocket_ = value;
        }
      } else {
        fastSocketBuilder_.mergeFrom(value);
      }
      if (fastSocket_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    public Builder clearFastSocket() {
      bitField0_ = (bitField0_ & ~0x08000000);
      fastSocket_ = null;
      if (fastSocketBuilder_ != null) {
        fastSocketBuilder_.dispose();
        fastSocketBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    public com.google.container.v1.FastSocket.Builder getFastSocketBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getFastSocketFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    public com.google.container.v1.FastSocketOrBuilder getFastSocketOrBuilder() {
      if (fastSocketBuilder_ != null) {
        return fastSocketBuilder_.getMessageOrBuilder();
      } else {
        return fastSocket_ == null
            ? com.google.container.v1.FastSocket.getDefaultInstance()
            : fastSocket_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.FastSocket fast_socket = 36;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.FastSocket,
            com.google.container.v1.FastSocket.Builder,
            com.google.container.v1.FastSocketOrBuilder>
        getFastSocketFieldBuilder() {
      if (fastSocketBuilder_ == null) {
        fastSocketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.FastSocket,
                com.google.container.v1.FastSocket.Builder,
                com.google.container.v1.FastSocketOrBuilder>(
                getFastSocket(), getParentForChildren(), isClean());
        fastSocket_ = null;
      }
      return fastSocketBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourceLabels() {
      if (resourceLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      return resourceLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourceLabels() {
      if (resourceLabels_ == null) {
        resourceLabels_ =
            com.google.protobuf.MapField.newMapField(ResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!resourceLabels_.isMutable()) {
        resourceLabels_ = resourceLabels_.copy();
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return resourceLabels_;
    }

    public int getResourceLabelsCount() {
      return internalGetResourceLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    @java.lang.Override
    public boolean containsResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceLabels().getMap().containsKey(key);
    }
    /** Use {@link #getResourceLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourceLabels() {
      return getResourceLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap() {
      return internalGetResourceLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    @java.lang.Override
    public java.lang.String getResourceLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourceLabels() {
      bitField0_ = (bitField0_ & ~0x10000000);
      internalGetMutableResourceLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    public Builder removeResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourceLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourceLabels() {
      bitField0_ |= 0x10000000;
      return internalGetMutableResourceLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    public Builder putResourceLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourceLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x10000000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 37;</code>
     */
    public Builder putAllResourceLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourceLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x10000000;
      return this;
    }

    private com.google.container.v1.NodePoolLoggingConfig loggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolLoggingConfig,
            com.google.container.v1.NodePoolLoggingConfig.Builder,
            com.google.container.v1.NodePoolLoggingConfigOrBuilder>
        loggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     *
     * @return Whether the loggingConfig field is set.
     */
    public boolean hasLoggingConfig() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     *
     * @return The loggingConfig.
     */
    public com.google.container.v1.NodePoolLoggingConfig getLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        return loggingConfig_ == null
            ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
            : loggingConfig_;
      } else {
        return loggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    public Builder setLoggingConfig(com.google.container.v1.NodePoolLoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingConfig_ = value;
      } else {
        loggingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    public Builder setLoggingConfig(
        com.google.container.v1.NodePoolLoggingConfig.Builder builderForValue) {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = builderForValue.build();
      } else {
        loggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    public Builder mergeLoggingConfig(com.google.container.v1.NodePoolLoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && loggingConfig_ != null
            && loggingConfig_
                != com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()) {
          getLoggingConfigBuilder().mergeFrom(value);
        } else {
          loggingConfig_ = value;
        }
      } else {
        loggingConfigBuilder_.mergeFrom(value);
      }
      if (loggingConfig_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    public Builder clearLoggingConfig() {
      bitField0_ = (bitField0_ & ~0x20000000);
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    public com.google.container.v1.NodePoolLoggingConfig.Builder getLoggingConfigBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    public com.google.container.v1.NodePoolLoggingConfigOrBuilder getLoggingConfigOrBuilder() {
      if (loggingConfigBuilder_ != null) {
        return loggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return loggingConfig_ == null
            ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
            : loggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 38;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolLoggingConfig,
            com.google.container.v1.NodePoolLoggingConfig.Builder,
            com.google.container.v1.NodePoolLoggingConfigOrBuilder>
        getLoggingConfigFieldBuilder() {
      if (loggingConfigBuilder_ == null) {
        loggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePoolLoggingConfig,
                com.google.container.v1.NodePoolLoggingConfig.Builder,
                com.google.container.v1.NodePoolLoggingConfigOrBuilder>(
                getLoggingConfig(), getParentForChildren(), isClean());
        loggingConfig_ = null;
      }
      return loggingConfigBuilder_;
    }

    private com.google.container.v1.WindowsNodeConfig windowsNodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WindowsNodeConfig,
            com.google.container.v1.WindowsNodeConfig.Builder,
            com.google.container.v1.WindowsNodeConfigOrBuilder>
        windowsNodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     *
     * @return Whether the windowsNodeConfig field is set.
     */
    public boolean hasWindowsNodeConfig() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     *
     * @return The windowsNodeConfig.
     */
    public com.google.container.v1.WindowsNodeConfig getWindowsNodeConfig() {
      if (windowsNodeConfigBuilder_ == null) {
        return windowsNodeConfig_ == null
            ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
            : windowsNodeConfig_;
      } else {
        return windowsNodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    public Builder setWindowsNodeConfig(com.google.container.v1.WindowsNodeConfig value) {
      if (windowsNodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        windowsNodeConfig_ = value;
      } else {
        windowsNodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    public Builder setWindowsNodeConfig(
        com.google.container.v1.WindowsNodeConfig.Builder builderForValue) {
      if (windowsNodeConfigBuilder_ == null) {
        windowsNodeConfig_ = builderForValue.build();
      } else {
        windowsNodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    public Builder mergeWindowsNodeConfig(com.google.container.v1.WindowsNodeConfig value) {
      if (windowsNodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && windowsNodeConfig_ != null
            && windowsNodeConfig_
                != com.google.container.v1.WindowsNodeConfig.getDefaultInstance()) {
          getWindowsNodeConfigBuilder().mergeFrom(value);
        } else {
          windowsNodeConfig_ = value;
        }
      } else {
        windowsNodeConfigBuilder_.mergeFrom(value);
      }
      if (windowsNodeConfig_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    public Builder clearWindowsNodeConfig() {
      bitField0_ = (bitField0_ & ~0x40000000);
      windowsNodeConfig_ = null;
      if (windowsNodeConfigBuilder_ != null) {
        windowsNodeConfigBuilder_.dispose();
        windowsNodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    public com.google.container.v1.WindowsNodeConfig.Builder getWindowsNodeConfigBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getWindowsNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    public com.google.container.v1.WindowsNodeConfigOrBuilder getWindowsNodeConfigOrBuilder() {
      if (windowsNodeConfigBuilder_ != null) {
        return windowsNodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return windowsNodeConfig_ == null
            ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
            : windowsNodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 39;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WindowsNodeConfig,
            com.google.container.v1.WindowsNodeConfig.Builder,
            com.google.container.v1.WindowsNodeConfigOrBuilder>
        getWindowsNodeConfigFieldBuilder() {
      if (windowsNodeConfigBuilder_ == null) {
        windowsNodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.WindowsNodeConfig,
                com.google.container.v1.WindowsNodeConfig.Builder,
                com.google.container.v1.WindowsNodeConfigOrBuilder>(
                getWindowsNodeConfig(), getParentForChildren(), isClean());
        windowsNodeConfig_ = null;
      }
      return windowsNodeConfigBuilder_;
    }

    private com.google.container.v1.LocalNvmeSsdBlockConfig localNvmeSsdBlockConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LocalNvmeSsdBlockConfig,
            com.google.container.v1.LocalNvmeSsdBlockConfig.Builder,
            com.google.container.v1.LocalNvmeSsdBlockConfigOrBuilder>
        localNvmeSsdBlockConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     *
     * @return Whether the localNvmeSsdBlockConfig field is set.
     */
    public boolean hasLocalNvmeSsdBlockConfig() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     *
     * @return The localNvmeSsdBlockConfig.
     */
    public com.google.container.v1.LocalNvmeSsdBlockConfig getLocalNvmeSsdBlockConfig() {
      if (localNvmeSsdBlockConfigBuilder_ == null) {
        return localNvmeSsdBlockConfig_ == null
            ? com.google.container.v1.LocalNvmeSsdBlockConfig.getDefaultInstance()
            : localNvmeSsdBlockConfig_;
      } else {
        return localNvmeSsdBlockConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    public Builder setLocalNvmeSsdBlockConfig(
        com.google.container.v1.LocalNvmeSsdBlockConfig value) {
      if (localNvmeSsdBlockConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        localNvmeSsdBlockConfig_ = value;
      } else {
        localNvmeSsdBlockConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    public Builder setLocalNvmeSsdBlockConfig(
        com.google.container.v1.LocalNvmeSsdBlockConfig.Builder builderForValue) {
      if (localNvmeSsdBlockConfigBuilder_ == null) {
        localNvmeSsdBlockConfig_ = builderForValue.build();
      } else {
        localNvmeSsdBlockConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    public Builder mergeLocalNvmeSsdBlockConfig(
        com.google.container.v1.LocalNvmeSsdBlockConfig value) {
      if (localNvmeSsdBlockConfigBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && localNvmeSsdBlockConfig_ != null
            && localNvmeSsdBlockConfig_
                != com.google.container.v1.LocalNvmeSsdBlockConfig.getDefaultInstance()) {
          getLocalNvmeSsdBlockConfigBuilder().mergeFrom(value);
        } else {
          localNvmeSsdBlockConfig_ = value;
        }
      } else {
        localNvmeSsdBlockConfigBuilder_.mergeFrom(value);
      }
      if (localNvmeSsdBlockConfig_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    public Builder clearLocalNvmeSsdBlockConfig() {
      bitField0_ = (bitField0_ & ~0x80000000);
      localNvmeSsdBlockConfig_ = null;
      if (localNvmeSsdBlockConfigBuilder_ != null) {
        localNvmeSsdBlockConfigBuilder_.dispose();
        localNvmeSsdBlockConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    public com.google.container.v1.LocalNvmeSsdBlockConfig.Builder
        getLocalNvmeSsdBlockConfigBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getLocalNvmeSsdBlockConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    public com.google.container.v1.LocalNvmeSsdBlockConfigOrBuilder
        getLocalNvmeSsdBlockConfigOrBuilder() {
      if (localNvmeSsdBlockConfigBuilder_ != null) {
        return localNvmeSsdBlockConfigBuilder_.getMessageOrBuilder();
      } else {
        return localNvmeSsdBlockConfig_ == null
            ? com.google.container.v1.LocalNvmeSsdBlockConfig.getDefaultInstance()
            : localNvmeSsdBlockConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for using raw-block Local NVMe SSDs.
     * </pre>
     *
     * <code>.google.container.v1.LocalNvmeSsdBlockConfig local_nvme_ssd_block_config = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LocalNvmeSsdBlockConfig,
            com.google.container.v1.LocalNvmeSsdBlockConfig.Builder,
            com.google.container.v1.LocalNvmeSsdBlockConfigOrBuilder>
        getLocalNvmeSsdBlockConfigFieldBuilder() {
      if (localNvmeSsdBlockConfigBuilder_ == null) {
        localNvmeSsdBlockConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.LocalNvmeSsdBlockConfig,
                com.google.container.v1.LocalNvmeSsdBlockConfig.Builder,
                com.google.container.v1.LocalNvmeSsdBlockConfigOrBuilder>(
                getLocalNvmeSsdBlockConfig(), getParentForChildren(), isClean());
        localNvmeSsdBlockConfig_ = null;
      }
      return localNvmeSsdBlockConfigBuilder_;
    }

    private com.google.container.v1.EphemeralStorageLocalSsdConfig ephemeralStorageLocalSsdConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.EphemeralStorageLocalSsdConfig,
            com.google.container.v1.EphemeralStorageLocalSsdConfig.Builder,
            com.google.container.v1.EphemeralStorageLocalSsdConfigOrBuilder>
        ephemeralStorageLocalSsdConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     *
     * @return Whether the ephemeralStorageLocalSsdConfig field is set.
     */
    public boolean hasEphemeralStorageLocalSsdConfig() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     *
     * @return The ephemeralStorageLocalSsdConfig.
     */
    public com.google.container.v1.EphemeralStorageLocalSsdConfig
        getEphemeralStorageLocalSsdConfig() {
      if (ephemeralStorageLocalSsdConfigBuilder_ == null) {
        return ephemeralStorageLocalSsdConfig_ == null
            ? com.google.container.v1.EphemeralStorageLocalSsdConfig.getDefaultInstance()
            : ephemeralStorageLocalSsdConfig_;
      } else {
        return ephemeralStorageLocalSsdConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    public Builder setEphemeralStorageLocalSsdConfig(
        com.google.container.v1.EphemeralStorageLocalSsdConfig value) {
      if (ephemeralStorageLocalSsdConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ephemeralStorageLocalSsdConfig_ = value;
      } else {
        ephemeralStorageLocalSsdConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    public Builder setEphemeralStorageLocalSsdConfig(
        com.google.container.v1.EphemeralStorageLocalSsdConfig.Builder builderForValue) {
      if (ephemeralStorageLocalSsdConfigBuilder_ == null) {
        ephemeralStorageLocalSsdConfig_ = builderForValue.build();
      } else {
        ephemeralStorageLocalSsdConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    public Builder mergeEphemeralStorageLocalSsdConfig(
        com.google.container.v1.EphemeralStorageLocalSsdConfig value) {
      if (ephemeralStorageLocalSsdConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)
            && ephemeralStorageLocalSsdConfig_ != null
            && ephemeralStorageLocalSsdConfig_
                != com.google.container.v1.EphemeralStorageLocalSsdConfig.getDefaultInstance()) {
          getEphemeralStorageLocalSsdConfigBuilder().mergeFrom(value);
        } else {
          ephemeralStorageLocalSsdConfig_ = value;
        }
      } else {
        ephemeralStorageLocalSsdConfigBuilder_.mergeFrom(value);
      }
      if (ephemeralStorageLocalSsdConfig_ != null) {
        bitField1_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    public Builder clearEphemeralStorageLocalSsdConfig() {
      bitField1_ = (bitField1_ & ~0x00000001);
      ephemeralStorageLocalSsdConfig_ = null;
      if (ephemeralStorageLocalSsdConfigBuilder_ != null) {
        ephemeralStorageLocalSsdConfigBuilder_.dispose();
        ephemeralStorageLocalSsdConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    public com.google.container.v1.EphemeralStorageLocalSsdConfig.Builder
        getEphemeralStorageLocalSsdConfigBuilder() {
      bitField1_ |= 0x00000001;
      onChanged();
      return getEphemeralStorageLocalSsdConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    public com.google.container.v1.EphemeralStorageLocalSsdConfigOrBuilder
        getEphemeralStorageLocalSsdConfigOrBuilder() {
      if (ephemeralStorageLocalSsdConfigBuilder_ != null) {
        return ephemeralStorageLocalSsdConfigBuilder_.getMessageOrBuilder();
      } else {
        return ephemeralStorageLocalSsdConfig_ == null
            ? com.google.container.v1.EphemeralStorageLocalSsdConfig.getDefaultInstance()
            : ephemeralStorageLocalSsdConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for the node ephemeral storage using Local SSDs.
     * If unspecified, ephemeral storage is backed by the boot disk.
     * </pre>
     *
     * <code>
     * .google.container.v1.EphemeralStorageLocalSsdConfig ephemeral_storage_local_ssd_config = 41;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.EphemeralStorageLocalSsdConfig,
            com.google.container.v1.EphemeralStorageLocalSsdConfig.Builder,
            com.google.container.v1.EphemeralStorageLocalSsdConfigOrBuilder>
        getEphemeralStorageLocalSsdConfigFieldBuilder() {
      if (ephemeralStorageLocalSsdConfigBuilder_ == null) {
        ephemeralStorageLocalSsdConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.EphemeralStorageLocalSsdConfig,
                com.google.container.v1.EphemeralStorageLocalSsdConfig.Builder,
                com.google.container.v1.EphemeralStorageLocalSsdConfigOrBuilder>(
                getEphemeralStorageLocalSsdConfig(), getParentForChildren(), isClean());
        ephemeralStorageLocalSsdConfig_ = null;
      }
      return ephemeralStorageLocalSsdConfigBuilder_;
    }

    private com.google.container.v1.SoleTenantConfig soleTenantConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SoleTenantConfig,
            com.google.container.v1.SoleTenantConfig.Builder,
            com.google.container.v1.SoleTenantConfigOrBuilder>
        soleTenantConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     *
     * @return Whether the soleTenantConfig field is set.
     */
    public boolean hasSoleTenantConfig() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     *
     * @return The soleTenantConfig.
     */
    public com.google.container.v1.SoleTenantConfig getSoleTenantConfig() {
      if (soleTenantConfigBuilder_ == null) {
        return soleTenantConfig_ == null
            ? com.google.container.v1.SoleTenantConfig.getDefaultInstance()
            : soleTenantConfig_;
      } else {
        return soleTenantConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    public Builder setSoleTenantConfig(com.google.container.v1.SoleTenantConfig value) {
      if (soleTenantConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        soleTenantConfig_ = value;
      } else {
        soleTenantConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    public Builder setSoleTenantConfig(
        com.google.container.v1.SoleTenantConfig.Builder builderForValue) {
      if (soleTenantConfigBuilder_ == null) {
        soleTenantConfig_ = builderForValue.build();
      } else {
        soleTenantConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    public Builder mergeSoleTenantConfig(com.google.container.v1.SoleTenantConfig value) {
      if (soleTenantConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000002) != 0)
            && soleTenantConfig_ != null
            && soleTenantConfig_ != com.google.container.v1.SoleTenantConfig.getDefaultInstance()) {
          getSoleTenantConfigBuilder().mergeFrom(value);
        } else {
          soleTenantConfig_ = value;
        }
      } else {
        soleTenantConfigBuilder_.mergeFrom(value);
      }
      if (soleTenantConfig_ != null) {
        bitField1_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    public Builder clearSoleTenantConfig() {
      bitField1_ = (bitField1_ & ~0x00000002);
      soleTenantConfig_ = null;
      if (soleTenantConfigBuilder_ != null) {
        soleTenantConfigBuilder_.dispose();
        soleTenantConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    public com.google.container.v1.SoleTenantConfig.Builder getSoleTenantConfigBuilder() {
      bitField1_ |= 0x00000002;
      onChanged();
      return getSoleTenantConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    public com.google.container.v1.SoleTenantConfigOrBuilder getSoleTenantConfigOrBuilder() {
      if (soleTenantConfigBuilder_ != null) {
        return soleTenantConfigBuilder_.getMessageOrBuilder();
      } else {
        return soleTenantConfig_ == null
            ? com.google.container.v1.SoleTenantConfig.getDefaultInstance()
            : soleTenantConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for node pools to be backed by shared sole tenant node groups.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig sole_tenant_config = 42;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SoleTenantConfig,
            com.google.container.v1.SoleTenantConfig.Builder,
            com.google.container.v1.SoleTenantConfigOrBuilder>
        getSoleTenantConfigFieldBuilder() {
      if (soleTenantConfigBuilder_ == null) {
        soleTenantConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.SoleTenantConfig,
                com.google.container.v1.SoleTenantConfig.Builder,
                com.google.container.v1.SoleTenantConfigOrBuilder>(
                getSoleTenantConfig(), getParentForChildren(), isClean());
        soleTenantConfig_ = null;
      }
      return soleTenantConfigBuilder_;
    }

    private com.google.container.v1.ContainerdConfig containerdConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ContainerdConfig,
            com.google.container.v1.ContainerdConfig.Builder,
            com.google.container.v1.ContainerdConfigOrBuilder>
        containerdConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     *
     * @return Whether the containerdConfig field is set.
     */
    public boolean hasContainerdConfig() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     *
     * @return The containerdConfig.
     */
    public com.google.container.v1.ContainerdConfig getContainerdConfig() {
      if (containerdConfigBuilder_ == null) {
        return containerdConfig_ == null
            ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
            : containerdConfig_;
      } else {
        return containerdConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    public Builder setContainerdConfig(com.google.container.v1.ContainerdConfig value) {
      if (containerdConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        containerdConfig_ = value;
      } else {
        containerdConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    public Builder setContainerdConfig(
        com.google.container.v1.ContainerdConfig.Builder builderForValue) {
      if (containerdConfigBuilder_ == null) {
        containerdConfig_ = builderForValue.build();
      } else {
        containerdConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    public Builder mergeContainerdConfig(com.google.container.v1.ContainerdConfig value) {
      if (containerdConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000004) != 0)
            && containerdConfig_ != null
            && containerdConfig_ != com.google.container.v1.ContainerdConfig.getDefaultInstance()) {
          getContainerdConfigBuilder().mergeFrom(value);
        } else {
          containerdConfig_ = value;
        }
      } else {
        containerdConfigBuilder_.mergeFrom(value);
      }
      if (containerdConfig_ != null) {
        bitField1_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    public Builder clearContainerdConfig() {
      bitField1_ = (bitField1_ & ~0x00000004);
      containerdConfig_ = null;
      if (containerdConfigBuilder_ != null) {
        containerdConfigBuilder_.dispose();
        containerdConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    public com.google.container.v1.ContainerdConfig.Builder getContainerdConfigBuilder() {
      bitField1_ |= 0x00000004;
      onChanged();
      return getContainerdConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    public com.google.container.v1.ContainerdConfigOrBuilder getContainerdConfigOrBuilder() {
      if (containerdConfigBuilder_ != null) {
        return containerdConfigBuilder_.getMessageOrBuilder();
      } else {
        return containerdConfig_ == null
            ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
            : containerdConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for containerd customization.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 43;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ContainerdConfig,
            com.google.container.v1.ContainerdConfig.Builder,
            com.google.container.v1.ContainerdConfigOrBuilder>
        getContainerdConfigFieldBuilder() {
      if (containerdConfigBuilder_ == null) {
        containerdConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ContainerdConfig,
                com.google.container.v1.ContainerdConfig.Builder,
                com.google.container.v1.ContainerdConfigOrBuilder>(
                getContainerdConfig(), getParentForChildren(), isClean());
        containerdConfig_ = null;
      }
      return containerdConfigBuilder_;
    }

    private com.google.container.v1.ResourceManagerTags resourceManagerTags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceManagerTags,
            com.google.container.v1.ResourceManagerTags.Builder,
            com.google.container.v1.ResourceManagerTagsOrBuilder>
        resourceManagerTagsBuilder_;
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     *
     * @return Whether the resourceManagerTags field is set.
     */
    public boolean hasResourceManagerTags() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     *
     * @return The resourceManagerTags.
     */
    public com.google.container.v1.ResourceManagerTags getResourceManagerTags() {
      if (resourceManagerTagsBuilder_ == null) {
        return resourceManagerTags_ == null
            ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
            : resourceManagerTags_;
      } else {
        return resourceManagerTagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    public Builder setResourceManagerTags(com.google.container.v1.ResourceManagerTags value) {
      if (resourceManagerTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceManagerTags_ = value;
      } else {
        resourceManagerTagsBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    public Builder setResourceManagerTags(
        com.google.container.v1.ResourceManagerTags.Builder builderForValue) {
      if (resourceManagerTagsBuilder_ == null) {
        resourceManagerTags_ = builderForValue.build();
      } else {
        resourceManagerTagsBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    public Builder mergeResourceManagerTags(com.google.container.v1.ResourceManagerTags value) {
      if (resourceManagerTagsBuilder_ == null) {
        if (((bitField1_ & 0x00000008) != 0)
            && resourceManagerTags_ != null
            && resourceManagerTags_
                != com.google.container.v1.ResourceManagerTags.getDefaultInstance()) {
          getResourceManagerTagsBuilder().mergeFrom(value);
        } else {
          resourceManagerTags_ = value;
        }
      } else {
        resourceManagerTagsBuilder_.mergeFrom(value);
      }
      if (resourceManagerTags_ != null) {
        bitField1_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    public Builder clearResourceManagerTags() {
      bitField1_ = (bitField1_ & ~0x00000008);
      resourceManagerTags_ = null;
      if (resourceManagerTagsBuilder_ != null) {
        resourceManagerTagsBuilder_.dispose();
        resourceManagerTagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    public com.google.container.v1.ResourceManagerTags.Builder getResourceManagerTagsBuilder() {
      bitField1_ |= 0x00000008;
      onChanged();
      return getResourceManagerTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    public com.google.container.v1.ResourceManagerTagsOrBuilder getResourceManagerTagsOrBuilder() {
      if (resourceManagerTagsBuilder_ != null) {
        return resourceManagerTagsBuilder_.getMessageOrBuilder();
      } else {
        return resourceManagerTags_ == null
            ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
            : resourceManagerTags_;
      }
    }
    /**
     *
     *
     * <pre>
     * A map of resource manager tag keys and values to be attached to the nodes.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 45;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceManagerTags,
            com.google.container.v1.ResourceManagerTags.Builder,
            com.google.container.v1.ResourceManagerTagsOrBuilder>
        getResourceManagerTagsFieldBuilder() {
      if (resourceManagerTagsBuilder_ == null) {
        resourceManagerTagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ResourceManagerTags,
                com.google.container.v1.ResourceManagerTags.Builder,
                com.google.container.v1.ResourceManagerTagsOrBuilder>(
                getResourceManagerTags(), getParentForChildren(), isClean());
        resourceManagerTags_ = null;
      }
      return resourceManagerTagsBuilder_;
    }

    private boolean enableConfidentialStorage_;
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableConfidentialStorage.
     */
    @java.lang.Override
    public boolean getEnableConfidentialStorage() {
      return enableConfidentialStorage_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableConfidentialStorage to set.
     * @return This builder for chaining.
     */
    public Builder setEnableConfidentialStorage(boolean value) {

      enableConfidentialStorage_ = value;
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>bool enable_confidential_storage = 46 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableConfidentialStorage() {
      bitField1_ = (bitField1_ & ~0x00000010);
      enableConfidentialStorage_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.SecondaryBootDisk> secondaryBootDisks_ =
        java.util.Collections.emptyList();

    private void ensureSecondaryBootDisksIsMutable() {
      if (!((bitField1_ & 0x00000020) != 0)) {
        secondaryBootDisks_ =
            new java.util.ArrayList<com.google.container.v1.SecondaryBootDisk>(secondaryBootDisks_);
        bitField1_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.SecondaryBootDisk,
            com.google.container.v1.SecondaryBootDisk.Builder,
            com.google.container.v1.SecondaryBootDiskOrBuilder>
        secondaryBootDisksBuilder_;

    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public java.util.List<com.google.container.v1.SecondaryBootDisk> getSecondaryBootDisksList() {
      if (secondaryBootDisksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secondaryBootDisks_);
      } else {
        return secondaryBootDisksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public int getSecondaryBootDisksCount() {
      if (secondaryBootDisksBuilder_ == null) {
        return secondaryBootDisks_.size();
      } else {
        return secondaryBootDisksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public com.google.container.v1.SecondaryBootDisk getSecondaryBootDisks(int index) {
      if (secondaryBootDisksBuilder_ == null) {
        return secondaryBootDisks_.get(index);
      } else {
        return secondaryBootDisksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder setSecondaryBootDisks(
        int index, com.google.container.v1.SecondaryBootDisk value) {
      if (secondaryBootDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.set(index, value);
        onChanged();
      } else {
        secondaryBootDisksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder setSecondaryBootDisks(
        int index, com.google.container.v1.SecondaryBootDisk.Builder builderForValue) {
      if (secondaryBootDisksBuilder_ == null) {
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.set(index, builderForValue.build());
        onChanged();
      } else {
        secondaryBootDisksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder addSecondaryBootDisks(com.google.container.v1.SecondaryBootDisk value) {
      if (secondaryBootDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.add(value);
        onChanged();
      } else {
        secondaryBootDisksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder addSecondaryBootDisks(
        int index, com.google.container.v1.SecondaryBootDisk value) {
      if (secondaryBootDisksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.add(index, value);
        onChanged();
      } else {
        secondaryBootDisksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder addSecondaryBootDisks(
        com.google.container.v1.SecondaryBootDisk.Builder builderForValue) {
      if (secondaryBootDisksBuilder_ == null) {
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.add(builderForValue.build());
        onChanged();
      } else {
        secondaryBootDisksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder addSecondaryBootDisks(
        int index, com.google.container.v1.SecondaryBootDisk.Builder builderForValue) {
      if (secondaryBootDisksBuilder_ == null) {
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.add(index, builderForValue.build());
        onChanged();
      } else {
        secondaryBootDisksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder addAllSecondaryBootDisks(
        java.lang.Iterable<? extends com.google.container.v1.SecondaryBootDisk> values) {
      if (secondaryBootDisksBuilder_ == null) {
        ensureSecondaryBootDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secondaryBootDisks_);
        onChanged();
      } else {
        secondaryBootDisksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder clearSecondaryBootDisks() {
      if (secondaryBootDisksBuilder_ == null) {
        secondaryBootDisks_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00000020);
        onChanged();
      } else {
        secondaryBootDisksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public Builder removeSecondaryBootDisks(int index) {
      if (secondaryBootDisksBuilder_ == null) {
        ensureSecondaryBootDisksIsMutable();
        secondaryBootDisks_.remove(index);
        onChanged();
      } else {
        secondaryBootDisksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public com.google.container.v1.SecondaryBootDisk.Builder getSecondaryBootDisksBuilder(
        int index) {
      return getSecondaryBootDisksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public com.google.container.v1.SecondaryBootDiskOrBuilder getSecondaryBootDisksOrBuilder(
        int index) {
      if (secondaryBootDisksBuilder_ == null) {
        return secondaryBootDisks_.get(index);
      } else {
        return secondaryBootDisksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public java.util.List<? extends com.google.container.v1.SecondaryBootDiskOrBuilder>
        getSecondaryBootDisksOrBuilderList() {
      if (secondaryBootDisksBuilder_ != null) {
        return secondaryBootDisksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secondaryBootDisks_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public com.google.container.v1.SecondaryBootDisk.Builder addSecondaryBootDisksBuilder() {
      return getSecondaryBootDisksFieldBuilder()
          .addBuilder(com.google.container.v1.SecondaryBootDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public com.google.container.v1.SecondaryBootDisk.Builder addSecondaryBootDisksBuilder(
        int index) {
      return getSecondaryBootDisksFieldBuilder()
          .addBuilder(index, com.google.container.v1.SecondaryBootDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of secondary boot disks attached to the nodes.
     * </pre>
     *
     * <code>repeated .google.container.v1.SecondaryBootDisk secondary_boot_disks = 48;</code>
     */
    public java.util.List<com.google.container.v1.SecondaryBootDisk.Builder>
        getSecondaryBootDisksBuilderList() {
      return getSecondaryBootDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.SecondaryBootDisk,
            com.google.container.v1.SecondaryBootDisk.Builder,
            com.google.container.v1.SecondaryBootDiskOrBuilder>
        getSecondaryBootDisksFieldBuilder() {
      if (secondaryBootDisksBuilder_ == null) {
        secondaryBootDisksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.SecondaryBootDisk,
                com.google.container.v1.SecondaryBootDisk.Builder,
                com.google.container.v1.SecondaryBootDiskOrBuilder>(
                secondaryBootDisks_,
                ((bitField1_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        secondaryBootDisks_ = null;
      }
      return secondaryBootDisksBuilder_;
    }

    private com.google.container.v1.SecondaryBootDiskUpdateStrategy
        secondaryBootDiskUpdateStrategy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SecondaryBootDiskUpdateStrategy,
            com.google.container.v1.SecondaryBootDiskUpdateStrategy.Builder,
            com.google.container.v1.SecondaryBootDiskUpdateStrategyOrBuilder>
        secondaryBootDiskUpdateStrategyBuilder_;
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     *
     * @return Whether the secondaryBootDiskUpdateStrategy field is set.
     */
    public boolean hasSecondaryBootDiskUpdateStrategy() {
      return ((bitField1_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     *
     * @return The secondaryBootDiskUpdateStrategy.
     */
    public com.google.container.v1.SecondaryBootDiskUpdateStrategy
        getSecondaryBootDiskUpdateStrategy() {
      if (secondaryBootDiskUpdateStrategyBuilder_ == null) {
        return secondaryBootDiskUpdateStrategy_ == null
            ? com.google.container.v1.SecondaryBootDiskUpdateStrategy.getDefaultInstance()
            : secondaryBootDiskUpdateStrategy_;
      } else {
        return secondaryBootDiskUpdateStrategyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    public Builder setSecondaryBootDiskUpdateStrategy(
        com.google.container.v1.SecondaryBootDiskUpdateStrategy value) {
      if (secondaryBootDiskUpdateStrategyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        secondaryBootDiskUpdateStrategy_ = value;
      } else {
        secondaryBootDiskUpdateStrategyBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    public Builder setSecondaryBootDiskUpdateStrategy(
        com.google.container.v1.SecondaryBootDiskUpdateStrategy.Builder builderForValue) {
      if (secondaryBootDiskUpdateStrategyBuilder_ == null) {
        secondaryBootDiskUpdateStrategy_ = builderForValue.build();
      } else {
        secondaryBootDiskUpdateStrategyBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    public Builder mergeSecondaryBootDiskUpdateStrategy(
        com.google.container.v1.SecondaryBootDiskUpdateStrategy value) {
      if (secondaryBootDiskUpdateStrategyBuilder_ == null) {
        if (((bitField1_ & 0x00000040) != 0)
            && secondaryBootDiskUpdateStrategy_ != null
            && secondaryBootDiskUpdateStrategy_
                != com.google.container.v1.SecondaryBootDiskUpdateStrategy.getDefaultInstance()) {
          getSecondaryBootDiskUpdateStrategyBuilder().mergeFrom(value);
        } else {
          secondaryBootDiskUpdateStrategy_ = value;
        }
      } else {
        secondaryBootDiskUpdateStrategyBuilder_.mergeFrom(value);
      }
      if (secondaryBootDiskUpdateStrategy_ != null) {
        bitField1_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    public Builder clearSecondaryBootDiskUpdateStrategy() {
      bitField1_ = (bitField1_ & ~0x00000040);
      secondaryBootDiskUpdateStrategy_ = null;
      if (secondaryBootDiskUpdateStrategyBuilder_ != null) {
        secondaryBootDiskUpdateStrategyBuilder_.dispose();
        secondaryBootDiskUpdateStrategyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    public com.google.container.v1.SecondaryBootDiskUpdateStrategy.Builder
        getSecondaryBootDiskUpdateStrategyBuilder() {
      bitField1_ |= 0x00000040;
      onChanged();
      return getSecondaryBootDiskUpdateStrategyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    public com.google.container.v1.SecondaryBootDiskUpdateStrategyOrBuilder
        getSecondaryBootDiskUpdateStrategyOrBuilder() {
      if (secondaryBootDiskUpdateStrategyBuilder_ != null) {
        return secondaryBootDiskUpdateStrategyBuilder_.getMessageOrBuilder();
      } else {
        return secondaryBootDiskUpdateStrategy_ == null
            ? com.google.container.v1.SecondaryBootDiskUpdateStrategy.getDefaultInstance()
            : secondaryBootDiskUpdateStrategy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary boot disk update strategy.
     * </pre>
     *
     * <code>
     * optional .google.container.v1.SecondaryBootDiskUpdateStrategy secondary_boot_disk_update_strategy = 50;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SecondaryBootDiskUpdateStrategy,
            com.google.container.v1.SecondaryBootDiskUpdateStrategy.Builder,
            com.google.container.v1.SecondaryBootDiskUpdateStrategyOrBuilder>
        getSecondaryBootDiskUpdateStrategyFieldBuilder() {
      if (secondaryBootDiskUpdateStrategyBuilder_ == null) {
        secondaryBootDiskUpdateStrategyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.SecondaryBootDiskUpdateStrategy,
                com.google.container.v1.SecondaryBootDiskUpdateStrategy.Builder,
                com.google.container.v1.SecondaryBootDiskUpdateStrategyOrBuilder>(
                getSecondaryBootDiskUpdateStrategy(), getParentForChildren(), isClean());
        secondaryBootDiskUpdateStrategy_ = null;
      }
      return secondaryBootDiskUpdateStrategyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.NodeConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.NodeConfig)
  private static final com.google.container.v1.NodeConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.NodeConfig();
  }

  public static com.google.container.v1.NodeConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeConfig> PARSER =
      new com.google.protobuf.AbstractParser<NodeConfig>() {
        @java.lang.Override
        public NodeConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.NodeConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
