/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * NodePool contains the name and configuration for a cluster's node pool.
 * Node pools are a set of nodes (i.e. VM's), with a common configuration and
 * specification, under the control of the cluster master. They may have a set
 * of Kubernetes labels applied to them, which may be used to reference them
 * during pod scheduling. They may also be resized up or down, to accommodate
 * the workload.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.NodePool}
 */
public final class NodePool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.NodePool)
    NodePoolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodePool.newBuilder() to construct.
  private NodePool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodePool() {
    name_ = "";
    locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    selfLink_ = "";
    version_ = "";
    instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
    status_ = 0;
    statusMessage_ = "";
    conditions_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodePool();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_NodePool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_NodePool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.NodePool.class, com.google.container.v1.NodePool.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current status of the node pool instance.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.NodePool.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The PROVISIONING state indicates the node pool is being created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    PROVISIONING(1),
    /**
     *
     *
     * <pre>
     * The RUNNING state indicates the node pool has been created
     * and is fully usable.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The RUNNING_WITH_ERROR state indicates the node pool has been created
     * and is partially usable. Some error state has occurred and some
     * functionality may be impaired. Customer may need to reissue a request
     * or trigger a new update.
     * </pre>
     *
     * <code>RUNNING_WITH_ERROR = 3;</code>
     */
    RUNNING_WITH_ERROR(3),
    /**
     *
     *
     * <pre>
     * The RECONCILING state indicates that some work is actively being done on
     * the node pool, such as upgrading node software. Details can
     * be found in the `statusMessage` field.
     * </pre>
     *
     * <code>RECONCILING = 4;</code>
     */
    RECONCILING(4),
    /**
     *
     *
     * <pre>
     * The STOPPING state indicates the node pool is being deleted.
     * </pre>
     *
     * <code>STOPPING = 5;</code>
     */
    STOPPING(5),
    /**
     *
     *
     * <pre>
     * The ERROR state indicates the node pool may be unusable. Details
     * can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>ERROR = 6;</code>
     */
    ERROR(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The PROVISIONING state indicates the node pool is being created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    public static final int PROVISIONING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The RUNNING state indicates the node pool has been created
     * and is fully usable.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The RUNNING_WITH_ERROR state indicates the node pool has been created
     * and is partially usable. Some error state has occurred and some
     * functionality may be impaired. Customer may need to reissue a request
     * or trigger a new update.
     * </pre>
     *
     * <code>RUNNING_WITH_ERROR = 3;</code>
     */
    public static final int RUNNING_WITH_ERROR_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The RECONCILING state indicates that some work is actively being done on
     * the node pool, such as upgrading node software. Details can
     * be found in the `statusMessage` field.
     * </pre>
     *
     * <code>RECONCILING = 4;</code>
     */
    public static final int RECONCILING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The STOPPING state indicates the node pool is being deleted.
     * </pre>
     *
     * <code>STOPPING = 5;</code>
     */
    public static final int STOPPING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The ERROR state indicates the node pool may be unusable. Details
     * can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>ERROR = 6;</code>
     */
    public static final int ERROR_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return PROVISIONING;
        case 2:
          return RUNNING;
        case 3:
          return RUNNING_WITH_ERROR;
        case 4:
          return RECONCILING;
        case 5:
          return STOPPING;
        case 6:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.NodePool.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.NodePool.Status)
  }

  public interface UpgradeSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.NodePool.UpgradeSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The maximum number of nodes that can be created beyond the current size
     * of the node pool during the upgrade process.
     * </pre>
     *
     * <code>int32 max_surge = 1;</code>
     *
     * @return The maxSurge.
     */
    int getMaxSurge();

    /**
     *
     *
     * <pre>
     * The maximum number of nodes that can be simultaneously unavailable during
     * the upgrade process. A node is considered available if its status is
     * Ready.
     * </pre>
     *
     * <code>int32 max_unavailable = 2;</code>
     *
     * @return The maxUnavailable.
     */
    int getMaxUnavailable();

    /**
     *
     *
     * <pre>
     * Update strategy of the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
     *
     * @return Whether the strategy field is set.
     */
    boolean hasStrategy();
    /**
     *
     *
     * <pre>
     * Update strategy of the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
     *
     * @return The enum numeric value on the wire for strategy.
     */
    int getStrategyValue();
    /**
     *
     *
     * <pre>
     * Update strategy of the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
     *
     * @return The strategy.
     */
    com.google.container.v1.NodePoolUpdateStrategy getStrategy();

    /**
     *
     *
     * <pre>
     * Settings for blue-green upgrade strategy.
     * </pre>
     *
     * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
     *
     * @return Whether the blueGreenSettings field is set.
     */
    boolean hasBlueGreenSettings();
    /**
     *
     *
     * <pre>
     * Settings for blue-green upgrade strategy.
     * </pre>
     *
     * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
     *
     * @return The blueGreenSettings.
     */
    com.google.container.v1.BlueGreenSettings getBlueGreenSettings();
    /**
     *
     *
     * <pre>
     * Settings for blue-green upgrade strategy.
     * </pre>
     *
     * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
     */
    com.google.container.v1.BlueGreenSettingsOrBuilder getBlueGreenSettingsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * These upgrade settings control the level of parallelism and the level of
   * disruption caused by an upgrade.
   *
   * maxUnavailable controls the number of nodes that can be simultaneously
   * unavailable.
   *
   * maxSurge controls the number of additional nodes that can be added to the
   * node pool temporarily for the time of the upgrade to increase the number of
   * available nodes.
   *
   * (maxUnavailable + maxSurge) determines the level of parallelism (how many
   * nodes are being upgraded at the same time).
   *
   * Note: upgrades inevitably introduce some disruption since workloads need to
   * be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0,
   * this holds true. (Disruption stays within the limits of
   * PodDisruptionBudget, if it is configured.)
   *
   * Consider a hypothetical node pool with 5 nodes having maxSurge=2,
   * maxUnavailable=1. This means the upgrade process upgrades 3 nodes
   * simultaneously. It creates 2 additional (upgraded) nodes, then it brings
   * down 3 old (not yet upgraded) nodes at the same time. This ensures that
   * there are always at least 4 nodes available.
   *
   * These upgrade settings configure the upgrade strategy for the node pool.
   * Use strategy to switch between the strategies applied to the node pool.
   *
   * If the strategy is ROLLING, use max_surge and max_unavailable to control
   * the level of parallelism and the level of disruption caused by upgrade.
   * 1. maxSurge controls the number of additional nodes that can be added to
   * the node pool temporarily for the time of the upgrade to increase the
   * number of available nodes.
   * 2. maxUnavailable controls the number of nodes that can be simultaneously
   * unavailable.
   * 3. (maxUnavailable + maxSurge) determines the level of parallelism (how
   * many nodes are being upgraded at the same time).
   *
   * If the strategy is BLUE_GREEN, use blue_green_settings to configure the
   * blue-green upgrade related settings.
   * 1. standard_rollout_policy is the default policy. The policy is used to
   * control the way blue pool gets drained. The draining is executed in the
   * batch mode. The batch size could be specified as either percentage of the
   * node pool size or the number of nodes. batch_soak_duration is the soak
   * time after each batch gets drained.
   * 2. node_pool_soak_duration is the soak time after all blue nodes are
   * drained. After this period, the blue pool nodes will be deleted.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodePool.UpgradeSettings}
   */
  public static final class UpgradeSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.NodePool.UpgradeSettings)
      UpgradeSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpgradeSettings.newBuilder() to construct.
    private UpgradeSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpgradeSettings() {
      strategy_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpgradeSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_UpgradeSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_UpgradeSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodePool.UpgradeSettings.class,
              com.google.container.v1.NodePool.UpgradeSettings.Builder.class);
    }

    private int bitField0_;
    public static final int MAX_SURGE_FIELD_NUMBER = 1;
    private int maxSurge_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of nodes that can be created beyond the current size
     * of the node pool during the upgrade process.
     * </pre>
     *
     * <code>int32 max_surge = 1;</code>
     *
     * @return The maxSurge.
     */
    @java.lang.Override
    public int getMaxSurge() {
      return maxSurge_;
    }

    public static final int MAX_UNAVAILABLE_FIELD_NUMBER = 2;
    private int maxUnavailable_ = 0;
    /**
     *
     *
     * <pre>
     * The maximum number of nodes that can be simultaneously unavailable during
     * the upgrade process. A node is considered available if its status is
     * Ready.
     * </pre>
     *
     * <code>int32 max_unavailable = 2;</code>
     *
     * @return The maxUnavailable.
     */
    @java.lang.Override
    public int getMaxUnavailable() {
      return maxUnavailable_;
    }

    public static final int STRATEGY_FIELD_NUMBER = 3;
    private int strategy_ = 0;
    /**
     *
     *
     * <pre>
     * Update strategy of the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
     *
     * @return Whether the strategy field is set.
     */
    @java.lang.Override
    public boolean hasStrategy() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Update strategy of the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
     *
     * @return The enum numeric value on the wire for strategy.
     */
    @java.lang.Override
    public int getStrategyValue() {
      return strategy_;
    }
    /**
     *
     *
     * <pre>
     * Update strategy of the node pool.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
     *
     * @return The strategy.
     */
    @java.lang.Override
    public com.google.container.v1.NodePoolUpdateStrategy getStrategy() {
      com.google.container.v1.NodePoolUpdateStrategy result =
          com.google.container.v1.NodePoolUpdateStrategy.forNumber(strategy_);
      return result == null ? com.google.container.v1.NodePoolUpdateStrategy.UNRECOGNIZED : result;
    }

    public static final int BLUE_GREEN_SETTINGS_FIELD_NUMBER = 4;
    private com.google.container.v1.BlueGreenSettings blueGreenSettings_;
    /**
     *
     *
     * <pre>
     * Settings for blue-green upgrade strategy.
     * </pre>
     *
     * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
     *
     * @return Whether the blueGreenSettings field is set.
     */
    @java.lang.Override
    public boolean hasBlueGreenSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for blue-green upgrade strategy.
     * </pre>
     *
     * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
     *
     * @return The blueGreenSettings.
     */
    @java.lang.Override
    public com.google.container.v1.BlueGreenSettings getBlueGreenSettings() {
      return blueGreenSettings_ == null
          ? com.google.container.v1.BlueGreenSettings.getDefaultInstance()
          : blueGreenSettings_;
    }
    /**
     *
     *
     * <pre>
     * Settings for blue-green upgrade strategy.
     * </pre>
     *
     * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
     */
    @java.lang.Override
    public com.google.container.v1.BlueGreenSettingsOrBuilder getBlueGreenSettingsOrBuilder() {
      return blueGreenSettings_ == null
          ? com.google.container.v1.BlueGreenSettings.getDefaultInstance()
          : blueGreenSettings_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (maxSurge_ != 0) {
        output.writeInt32(1, maxSurge_);
      }
      if (maxUnavailable_ != 0) {
        output.writeInt32(2, maxUnavailable_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(3, strategy_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getBlueGreenSettings());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxSurge_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxSurge_);
      }
      if (maxUnavailable_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxUnavailable_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, strategy_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBlueGreenSettings());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.NodePool.UpgradeSettings)) {
        return super.equals(obj);
      }
      com.google.container.v1.NodePool.UpgradeSettings other =
          (com.google.container.v1.NodePool.UpgradeSettings) obj;

      if (getMaxSurge() != other.getMaxSurge()) return false;
      if (getMaxUnavailable() != other.getMaxUnavailable()) return false;
      if (hasStrategy() != other.hasStrategy()) return false;
      if (hasStrategy()) {
        if (strategy_ != other.strategy_) return false;
      }
      if (hasBlueGreenSettings() != other.hasBlueGreenSettings()) return false;
      if (hasBlueGreenSettings()) {
        if (!getBlueGreenSettings().equals(other.getBlueGreenSettings())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_SURGE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxSurge();
      hash = (37 * hash) + MAX_UNAVAILABLE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxUnavailable();
      if (hasStrategy()) {
        hash = (37 * hash) + STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + strategy_;
      }
      if (hasBlueGreenSettings()) {
        hash = (37 * hash) + BLUE_GREEN_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getBlueGreenSettings().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.UpgradeSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.container.v1.NodePool.UpgradeSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * These upgrade settings control the level of parallelism and the level of
     * disruption caused by an upgrade.
     *
     * maxUnavailable controls the number of nodes that can be simultaneously
     * unavailable.
     *
     * maxSurge controls the number of additional nodes that can be added to the
     * node pool temporarily for the time of the upgrade to increase the number of
     * available nodes.
     *
     * (maxUnavailable + maxSurge) determines the level of parallelism (how many
     * nodes are being upgraded at the same time).
     *
     * Note: upgrades inevitably introduce some disruption since workloads need to
     * be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0,
     * this holds true. (Disruption stays within the limits of
     * PodDisruptionBudget, if it is configured.)
     *
     * Consider a hypothetical node pool with 5 nodes having maxSurge=2,
     * maxUnavailable=1. This means the upgrade process upgrades 3 nodes
     * simultaneously. It creates 2 additional (upgraded) nodes, then it brings
     * down 3 old (not yet upgraded) nodes at the same time. This ensures that
     * there are always at least 4 nodes available.
     *
     * These upgrade settings configure the upgrade strategy for the node pool.
     * Use strategy to switch between the strategies applied to the node pool.
     *
     * If the strategy is ROLLING, use max_surge and max_unavailable to control
     * the level of parallelism and the level of disruption caused by upgrade.
     * 1. maxSurge controls the number of additional nodes that can be added to
     * the node pool temporarily for the time of the upgrade to increase the
     * number of available nodes.
     * 2. maxUnavailable controls the number of nodes that can be simultaneously
     * unavailable.
     * 3. (maxUnavailable + maxSurge) determines the level of parallelism (how
     * many nodes are being upgraded at the same time).
     *
     * If the strategy is BLUE_GREEN, use blue_green_settings to configure the
     * blue-green upgrade related settings.
     * 1. standard_rollout_policy is the default policy. The policy is used to
     * control the way blue pool gets drained. The draining is executed in the
     * batch mode. The batch size could be specified as either percentage of the
     * node pool size or the number of nodes. batch_soak_duration is the soak
     * time after each batch gets drained.
     * 2. node_pool_soak_duration is the soak time after all blue nodes are
     * drained. After this period, the blue pool nodes will be deleted.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.NodePool.UpgradeSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool.UpgradeSettings)
        com.google.container.v1.NodePool.UpgradeSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpgradeSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpgradeSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.NodePool.UpgradeSettings.class,
                com.google.container.v1.NodePool.UpgradeSettings.Builder.class);
      }

      // Construct using com.google.container.v1.NodePool.UpgradeSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBlueGreenSettingsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        maxSurge_ = 0;
        maxUnavailable_ = 0;
        strategy_ = 0;
        blueGreenSettings_ = null;
        if (blueGreenSettingsBuilder_ != null) {
          blueGreenSettingsBuilder_.dispose();
          blueGreenSettingsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpgradeSettings_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpgradeSettings getDefaultInstanceForType() {
        return com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpgradeSettings build() {
        com.google.container.v1.NodePool.UpgradeSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpgradeSettings buildPartial() {
        com.google.container.v1.NodePool.UpgradeSettings result =
            new com.google.container.v1.NodePool.UpgradeSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1.NodePool.UpgradeSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.maxSurge_ = maxSurge_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxUnavailable_ = maxUnavailable_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.strategy_ = strategy_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.blueGreenSettings_ =
              blueGreenSettingsBuilder_ == null
                  ? blueGreenSettings_
                  : blueGreenSettingsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.NodePool.UpgradeSettings) {
          return mergeFrom((com.google.container.v1.NodePool.UpgradeSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1.NodePool.UpgradeSettings other) {
        if (other == com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance())
          return this;
        if (other.getMaxSurge() != 0) {
          setMaxSurge(other.getMaxSurge());
        }
        if (other.getMaxUnavailable() != 0) {
          setMaxUnavailable(other.getMaxUnavailable());
        }
        if (other.hasStrategy()) {
          setStrategy(other.getStrategy());
        }
        if (other.hasBlueGreenSettings()) {
          mergeBlueGreenSettings(other.getBlueGreenSettings());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  maxSurge_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  maxUnavailable_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  strategy_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(
                      getBlueGreenSettingsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int maxSurge_;
      /**
       *
       *
       * <pre>
       * The maximum number of nodes that can be created beyond the current size
       * of the node pool during the upgrade process.
       * </pre>
       *
       * <code>int32 max_surge = 1;</code>
       *
       * @return The maxSurge.
       */
      @java.lang.Override
      public int getMaxSurge() {
        return maxSurge_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes that can be created beyond the current size
       * of the node pool during the upgrade process.
       * </pre>
       *
       * <code>int32 max_surge = 1;</code>
       *
       * @param value The maxSurge to set.
       * @return This builder for chaining.
       */
      public Builder setMaxSurge(int value) {

        maxSurge_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes that can be created beyond the current size
       * of the node pool during the upgrade process.
       * </pre>
       *
       * <code>int32 max_surge = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxSurge() {
        bitField0_ = (bitField0_ & ~0x00000001);
        maxSurge_ = 0;
        onChanged();
        return this;
      }

      private int maxUnavailable_;
      /**
       *
       *
       * <pre>
       * The maximum number of nodes that can be simultaneously unavailable during
       * the upgrade process. A node is considered available if its status is
       * Ready.
       * </pre>
       *
       * <code>int32 max_unavailable = 2;</code>
       *
       * @return The maxUnavailable.
       */
      @java.lang.Override
      public int getMaxUnavailable() {
        return maxUnavailable_;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes that can be simultaneously unavailable during
       * the upgrade process. A node is considered available if its status is
       * Ready.
       * </pre>
       *
       * <code>int32 max_unavailable = 2;</code>
       *
       * @param value The maxUnavailable to set.
       * @return This builder for chaining.
       */
      public Builder setMaxUnavailable(int value) {

        maxUnavailable_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of nodes that can be simultaneously unavailable during
       * the upgrade process. A node is considered available if its status is
       * Ready.
       * </pre>
       *
       * <code>int32 max_unavailable = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxUnavailable() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxUnavailable_ = 0;
        onChanged();
        return this;
      }

      private int strategy_ = 0;
      /**
       *
       *
       * <pre>
       * Update strategy of the node pool.
       * </pre>
       *
       * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
       *
       * @return Whether the strategy field is set.
       */
      @java.lang.Override
      public boolean hasStrategy() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Update strategy of the node pool.
       * </pre>
       *
       * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
       *
       * @return The enum numeric value on the wire for strategy.
       */
      @java.lang.Override
      public int getStrategyValue() {
        return strategy_;
      }
      /**
       *
       *
       * <pre>
       * Update strategy of the node pool.
       * </pre>
       *
       * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
       *
       * @param value The enum numeric value on the wire for strategy to set.
       * @return This builder for chaining.
       */
      public Builder setStrategyValue(int value) {
        strategy_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Update strategy of the node pool.
       * </pre>
       *
       * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
       *
       * @return The strategy.
       */
      @java.lang.Override
      public com.google.container.v1.NodePoolUpdateStrategy getStrategy() {
        com.google.container.v1.NodePoolUpdateStrategy result =
            com.google.container.v1.NodePoolUpdateStrategy.forNumber(strategy_);
        return result == null
            ? com.google.container.v1.NodePoolUpdateStrategy.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Update strategy of the node pool.
       * </pre>
       *
       * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
       *
       * @param value The strategy to set.
       * @return This builder for chaining.
       */
      public Builder setStrategy(com.google.container.v1.NodePoolUpdateStrategy value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        strategy_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Update strategy of the node pool.
       * </pre>
       *
       * <code>optional .google.container.v1.NodePoolUpdateStrategy strategy = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrategy() {
        bitField0_ = (bitField0_ & ~0x00000004);
        strategy_ = 0;
        onChanged();
        return this;
      }

      private com.google.container.v1.BlueGreenSettings blueGreenSettings_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1.BlueGreenSettings,
              com.google.container.v1.BlueGreenSettings.Builder,
              com.google.container.v1.BlueGreenSettingsOrBuilder>
          blueGreenSettingsBuilder_;
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       *
       * @return Whether the blueGreenSettings field is set.
       */
      public boolean hasBlueGreenSettings() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       *
       * @return The blueGreenSettings.
       */
      public com.google.container.v1.BlueGreenSettings getBlueGreenSettings() {
        if (blueGreenSettingsBuilder_ == null) {
          return blueGreenSettings_ == null
              ? com.google.container.v1.BlueGreenSettings.getDefaultInstance()
              : blueGreenSettings_;
        } else {
          return blueGreenSettingsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      public Builder setBlueGreenSettings(com.google.container.v1.BlueGreenSettings value) {
        if (blueGreenSettingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          blueGreenSettings_ = value;
        } else {
          blueGreenSettingsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      public Builder setBlueGreenSettings(
          com.google.container.v1.BlueGreenSettings.Builder builderForValue) {
        if (blueGreenSettingsBuilder_ == null) {
          blueGreenSettings_ = builderForValue.build();
        } else {
          blueGreenSettingsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      public Builder mergeBlueGreenSettings(com.google.container.v1.BlueGreenSettings value) {
        if (blueGreenSettingsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && blueGreenSettings_ != null
              && blueGreenSettings_
                  != com.google.container.v1.BlueGreenSettings.getDefaultInstance()) {
            getBlueGreenSettingsBuilder().mergeFrom(value);
          } else {
            blueGreenSettings_ = value;
          }
        } else {
          blueGreenSettingsBuilder_.mergeFrom(value);
        }
        if (blueGreenSettings_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      public Builder clearBlueGreenSettings() {
        bitField0_ = (bitField0_ & ~0x00000008);
        blueGreenSettings_ = null;
        if (blueGreenSettingsBuilder_ != null) {
          blueGreenSettingsBuilder_.dispose();
          blueGreenSettingsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      public com.google.container.v1.BlueGreenSettings.Builder getBlueGreenSettingsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getBlueGreenSettingsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      public com.google.container.v1.BlueGreenSettingsOrBuilder getBlueGreenSettingsOrBuilder() {
        if (blueGreenSettingsBuilder_ != null) {
          return blueGreenSettingsBuilder_.getMessageOrBuilder();
        } else {
          return blueGreenSettings_ == null
              ? com.google.container.v1.BlueGreenSettings.getDefaultInstance()
              : blueGreenSettings_;
        }
      }
      /**
       *
       *
       * <pre>
       * Settings for blue-green upgrade strategy.
       * </pre>
       *
       * <code>optional .google.container.v1.BlueGreenSettings blue_green_settings = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1.BlueGreenSettings,
              com.google.container.v1.BlueGreenSettings.Builder,
              com.google.container.v1.BlueGreenSettingsOrBuilder>
          getBlueGreenSettingsFieldBuilder() {
        if (blueGreenSettingsBuilder_ == null) {
          blueGreenSettingsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.container.v1.BlueGreenSettings,
                  com.google.container.v1.BlueGreenSettings.Builder,
                  com.google.container.v1.BlueGreenSettingsOrBuilder>(
                  getBlueGreenSettings(), getParentForChildren(), isClean());
          blueGreenSettings_ = null;
        }
        return blueGreenSettingsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool.UpgradeSettings)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.NodePool.UpgradeSettings)
    private static final com.google.container.v1.NodePool.UpgradeSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.NodePool.UpgradeSettings();
    }

    public static com.google.container.v1.NodePool.UpgradeSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpgradeSettings> PARSER =
        new com.google.protobuf.AbstractParser<UpgradeSettings>() {
          @java.lang.Override
          public UpgradeSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpgradeSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpgradeSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.NodePool.UpgradeSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdateInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.NodePool.UpdateInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Information of a blue-green upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
     *
     * @return Whether the blueGreenInfo field is set.
     */
    boolean hasBlueGreenInfo();
    /**
     *
     *
     * <pre>
     * Information of a blue-green upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
     *
     * @return The blueGreenInfo.
     */
    com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo getBlueGreenInfo();
    /**
     *
     *
     * <pre>
     * Information of a blue-green upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
     */
    com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder getBlueGreenInfoOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * UpdateInfo contains resource (instance groups, etc), status and other
   * intermediate information relevant to a node pool upgrade.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodePool.UpdateInfo}
   */
  public static final class UpdateInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.NodePool.UpdateInfo)
      UpdateInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdateInfo.newBuilder() to construct.
    private UpdateInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdateInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdateInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_UpdateInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_UpdateInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodePool.UpdateInfo.class,
              com.google.container.v1.NodePool.UpdateInfo.Builder.class);
    }

    public interface BlueGreenInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.container.v1.NodePool.UpdateInfo.BlueGreenInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Current blue-green upgrade phase.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
       *
       * @return The enum numeric value on the wire for phase.
       */
      int getPhaseValue();
      /**
       *
       *
       * <pre>
       * Current blue-green upgrade phase.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
       *
       * @return The phase.
       */
      com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase getPhase();

      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @return A list containing the blueInstanceGroupUrls.
       */
      java.util.List<java.lang.String> getBlueInstanceGroupUrlsList();
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @return The count of blueInstanceGroupUrls.
       */
      int getBlueInstanceGroupUrlsCount();
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The blueInstanceGroupUrls at the given index.
       */
      java.lang.String getBlueInstanceGroupUrls(int index);
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the blueInstanceGroupUrls at the given index.
       */
      com.google.protobuf.ByteString getBlueInstanceGroupUrlsBytes(int index);

      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @return A list containing the greenInstanceGroupUrls.
       */
      java.util.List<java.lang.String> getGreenInstanceGroupUrlsList();
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @return The count of greenInstanceGroupUrls.
       */
      int getGreenInstanceGroupUrlsCount();
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The greenInstanceGroupUrls at the given index.
       */
      java.lang.String getGreenInstanceGroupUrls(int index);
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the greenInstanceGroupUrls at the given index.
       */
      com.google.protobuf.ByteString getGreenInstanceGroupUrlsBytes(int index);

      /**
       *
       *
       * <pre>
       * Time to start deleting blue pool to complete blue-green upgrade,
       * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>string blue_pool_deletion_start_time = 4;</code>
       *
       * @return The bluePoolDeletionStartTime.
       */
      java.lang.String getBluePoolDeletionStartTime();
      /**
       *
       *
       * <pre>
       * Time to start deleting blue pool to complete blue-green upgrade,
       * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>string blue_pool_deletion_start_time = 4;</code>
       *
       * @return The bytes for bluePoolDeletionStartTime.
       */
      com.google.protobuf.ByteString getBluePoolDeletionStartTimeBytes();

      /**
       *
       *
       * <pre>
       * Version of green pool.
       * </pre>
       *
       * <code>string green_pool_version = 5;</code>
       *
       * @return The greenPoolVersion.
       */
      java.lang.String getGreenPoolVersion();
      /**
       *
       *
       * <pre>
       * Version of green pool.
       * </pre>
       *
       * <code>string green_pool_version = 5;</code>
       *
       * @return The bytes for greenPoolVersion.
       */
      com.google.protobuf.ByteString getGreenPoolVersionBytes();
    }
    /**
     *
     *
     * <pre>
     * Information relevant to blue-green upgrade.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.NodePool.UpdateInfo.BlueGreenInfo}
     */
    public static final class BlueGreenInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.container.v1.NodePool.UpdateInfo.BlueGreenInfo)
        BlueGreenInfoOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BlueGreenInfo.newBuilder() to construct.
      private BlueGreenInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BlueGreenInfo() {
        phase_ = 0;
        blueInstanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
        greenInstanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bluePoolDeletionStartTime_ = "";
        greenPoolVersion_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BlueGreenInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpdateInfo_BlueGreenInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpdateInfo_BlueGreenInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.class,
                com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Phase represents the different stages blue-green upgrade is running in.
       * </pre>
       *
       * Protobuf enum {@code google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase}
       */
      public enum Phase implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified phase.
         * </pre>
         *
         * <code>PHASE_UNSPECIFIED = 0;</code>
         */
        PHASE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * blue-green upgrade has been initiated.
         * </pre>
         *
         * <code>UPDATE_STARTED = 1;</code>
         */
        UPDATE_STARTED(1),
        /**
         *
         *
         * <pre>
         * Start creating green pool nodes.
         * </pre>
         *
         * <code>CREATING_GREEN_POOL = 2;</code>
         */
        CREATING_GREEN_POOL(2),
        /**
         *
         *
         * <pre>
         * Start cordoning blue pool nodes.
         * </pre>
         *
         * <code>CORDONING_BLUE_POOL = 3;</code>
         */
        CORDONING_BLUE_POOL(3),
        /**
         *
         *
         * <pre>
         * Start draining blue pool nodes.
         * </pre>
         *
         * <code>DRAINING_BLUE_POOL = 4;</code>
         */
        DRAINING_BLUE_POOL(4),
        /**
         *
         *
         * <pre>
         * Start soaking time after draining entire blue pool.
         * </pre>
         *
         * <code>NODE_POOL_SOAKING = 5;</code>
         */
        NODE_POOL_SOAKING(5),
        /**
         *
         *
         * <pre>
         * Start deleting blue nodes.
         * </pre>
         *
         * <code>DELETING_BLUE_POOL = 6;</code>
         */
        DELETING_BLUE_POOL(6),
        /**
         *
         *
         * <pre>
         * Rollback has been initiated.
         * </pre>
         *
         * <code>ROLLBACK_STARTED = 7;</code>
         */
        ROLLBACK_STARTED(7),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified phase.
         * </pre>
         *
         * <code>PHASE_UNSPECIFIED = 0;</code>
         */
        public static final int PHASE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * blue-green upgrade has been initiated.
         * </pre>
         *
         * <code>UPDATE_STARTED = 1;</code>
         */
        public static final int UPDATE_STARTED_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Start creating green pool nodes.
         * </pre>
         *
         * <code>CREATING_GREEN_POOL = 2;</code>
         */
        public static final int CREATING_GREEN_POOL_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Start cordoning blue pool nodes.
         * </pre>
         *
         * <code>CORDONING_BLUE_POOL = 3;</code>
         */
        public static final int CORDONING_BLUE_POOL_VALUE = 3;
        /**
         *
         *
         * <pre>
         * Start draining blue pool nodes.
         * </pre>
         *
         * <code>DRAINING_BLUE_POOL = 4;</code>
         */
        public static final int DRAINING_BLUE_POOL_VALUE = 4;
        /**
         *
         *
         * <pre>
         * Start soaking time after draining entire blue pool.
         * </pre>
         *
         * <code>NODE_POOL_SOAKING = 5;</code>
         */
        public static final int NODE_POOL_SOAKING_VALUE = 5;
        /**
         *
         *
         * <pre>
         * Start deleting blue nodes.
         * </pre>
         *
         * <code>DELETING_BLUE_POOL = 6;</code>
         */
        public static final int DELETING_BLUE_POOL_VALUE = 6;
        /**
         *
         *
         * <pre>
         * Rollback has been initiated.
         * </pre>
         *
         * <code>ROLLBACK_STARTED = 7;</code>
         */
        public static final int ROLLBACK_STARTED_VALUE = 7;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Phase valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Phase forNumber(int value) {
          switch (value) {
            case 0:
              return PHASE_UNSPECIFIED;
            case 1:
              return UPDATE_STARTED;
            case 2:
              return CREATING_GREEN_POOL;
            case 3:
              return CORDONING_BLUE_POOL;
            case 4:
              return DRAINING_BLUE_POOL;
            case 5:
              return NODE_POOL_SOAKING;
            case 6:
              return DELETING_BLUE_POOL;
            case 7:
              return ROLLBACK_STARTED;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Phase> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Phase> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Phase>() {
              public Phase findValueByNumber(int number) {
                return Phase.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Phase[] VALUES = values();

        public static Phase valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Phase(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase)
      }

      public static final int PHASE_FIELD_NUMBER = 1;
      private int phase_ = 0;
      /**
       *
       *
       * <pre>
       * Current blue-green upgrade phase.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
       *
       * @return The enum numeric value on the wire for phase.
       */
      @java.lang.Override
      public int getPhaseValue() {
        return phase_;
      }
      /**
       *
       *
       * <pre>
       * Current blue-green upgrade phase.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
       *
       * @return The phase.
       */
      @java.lang.Override
      public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase getPhase() {
        com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase result =
            com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase.forNumber(phase_);
        return result == null
            ? com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase.UNRECOGNIZED
            : result;
      }

      public static final int BLUE_INSTANCE_GROUP_URLS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList blueInstanceGroupUrls_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @return A list containing the blueInstanceGroupUrls.
       */
      public com.google.protobuf.ProtocolStringList getBlueInstanceGroupUrlsList() {
        return blueInstanceGroupUrls_;
      }
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @return The count of blueInstanceGroupUrls.
       */
      public int getBlueInstanceGroupUrlsCount() {
        return blueInstanceGroupUrls_.size();
      }
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The blueInstanceGroupUrls at the given index.
       */
      public java.lang.String getBlueInstanceGroupUrls(int index) {
        return blueInstanceGroupUrls_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with blue pool.
       * </pre>
       *
       * <code>repeated string blue_instance_group_urls = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the blueInstanceGroupUrls at the given index.
       */
      public com.google.protobuf.ByteString getBlueInstanceGroupUrlsBytes(int index) {
        return blueInstanceGroupUrls_.getByteString(index);
      }

      public static final int GREEN_INSTANCE_GROUP_URLS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList greenInstanceGroupUrls_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @return A list containing the greenInstanceGroupUrls.
       */
      public com.google.protobuf.ProtocolStringList getGreenInstanceGroupUrlsList() {
        return greenInstanceGroupUrls_;
      }
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @return The count of greenInstanceGroupUrls.
       */
      public int getGreenInstanceGroupUrlsCount() {
        return greenInstanceGroupUrls_.size();
      }
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The greenInstanceGroupUrls at the given index.
       */
      public java.lang.String getGreenInstanceGroupUrls(int index) {
        return greenInstanceGroupUrls_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The resource URLs of the [managed instance groups]
       * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
       * associated with green pool.
       * </pre>
       *
       * <code>repeated string green_instance_group_urls = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the greenInstanceGroupUrls at the given index.
       */
      public com.google.protobuf.ByteString getGreenInstanceGroupUrlsBytes(int index) {
        return greenInstanceGroupUrls_.getByteString(index);
      }

      public static final int BLUE_POOL_DELETION_START_TIME_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object bluePoolDeletionStartTime_ = "";
      /**
       *
       *
       * <pre>
       * Time to start deleting blue pool to complete blue-green upgrade,
       * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>string blue_pool_deletion_start_time = 4;</code>
       *
       * @return The bluePoolDeletionStartTime.
       */
      @java.lang.Override
      public java.lang.String getBluePoolDeletionStartTime() {
        java.lang.Object ref = bluePoolDeletionStartTime_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bluePoolDeletionStartTime_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Time to start deleting blue pool to complete blue-green upgrade,
       * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
       * </pre>
       *
       * <code>string blue_pool_deletion_start_time = 4;</code>
       *
       * @return The bytes for bluePoolDeletionStartTime.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBluePoolDeletionStartTimeBytes() {
        java.lang.Object ref = bluePoolDeletionStartTime_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bluePoolDeletionStartTime_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int GREEN_POOL_VERSION_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object greenPoolVersion_ = "";
      /**
       *
       *
       * <pre>
       * Version of green pool.
       * </pre>
       *
       * <code>string green_pool_version = 5;</code>
       *
       * @return The greenPoolVersion.
       */
      @java.lang.Override
      public java.lang.String getGreenPoolVersion() {
        java.lang.Object ref = greenPoolVersion_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          greenPoolVersion_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Version of green pool.
       * </pre>
       *
       * <code>string green_pool_version = 5;</code>
       *
       * @return The bytes for greenPoolVersion.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getGreenPoolVersionBytes() {
        java.lang.Object ref = greenPoolVersion_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          greenPoolVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (phase_
            != com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase.PHASE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, phase_);
        }
        for (int i = 0; i < blueInstanceGroupUrls_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 2, blueInstanceGroupUrls_.getRaw(i));
        }
        for (int i = 0; i < greenInstanceGroupUrls_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 3, greenInstanceGroupUrls_.getRaw(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bluePoolDeletionStartTime_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, bluePoolDeletionStartTime_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(greenPoolVersion_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, greenPoolVersion_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (phase_
            != com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase.PHASE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, phase_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < blueInstanceGroupUrls_.size(); i++) {
            dataSize += computeStringSizeNoTag(blueInstanceGroupUrls_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getBlueInstanceGroupUrlsList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < greenInstanceGroupUrls_.size(); i++) {
            dataSize += computeStringSizeNoTag(greenInstanceGroupUrls_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getGreenInstanceGroupUrlsList().size();
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bluePoolDeletionStartTime_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(
                  4, bluePoolDeletionStartTime_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(greenPoolVersion_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, greenPoolVersion_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo)) {
          return super.equals(obj);
        }
        com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo other =
            (com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo) obj;

        if (phase_ != other.phase_) return false;
        if (!getBlueInstanceGroupUrlsList().equals(other.getBlueInstanceGroupUrlsList()))
          return false;
        if (!getGreenInstanceGroupUrlsList().equals(other.getGreenInstanceGroupUrlsList()))
          return false;
        if (!getBluePoolDeletionStartTime().equals(other.getBluePoolDeletionStartTime()))
          return false;
        if (!getGreenPoolVersion().equals(other.getGreenPoolVersion())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PHASE_FIELD_NUMBER;
        hash = (53 * hash) + phase_;
        if (getBlueInstanceGroupUrlsCount() > 0) {
          hash = (37 * hash) + BLUE_INSTANCE_GROUP_URLS_FIELD_NUMBER;
          hash = (53 * hash) + getBlueInstanceGroupUrlsList().hashCode();
        }
        if (getGreenInstanceGroupUrlsCount() > 0) {
          hash = (37 * hash) + GREEN_INSTANCE_GROUP_URLS_FIELD_NUMBER;
          hash = (53 * hash) + getGreenInstanceGroupUrlsList().hashCode();
        }
        hash = (37 * hash) + BLUE_POOL_DELETION_START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getBluePoolDeletionStartTime().hashCode();
        hash = (37 * hash) + GREEN_POOL_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getGreenPoolVersion().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Information relevant to blue-green upgrade.
       * </pre>
       *
       * Protobuf type {@code google.container.v1.NodePool.UpdateInfo.BlueGreenInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool.UpdateInfo.BlueGreenInfo)
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_NodePool_UpdateInfo_BlueGreenInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_NodePool_UpdateInfo_BlueGreenInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.class,
                  com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder.class);
        }

        // Construct using com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          phase_ = 0;
          blueInstanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
          greenInstanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bluePoolDeletionStartTime_ = "";
          greenPoolVersion_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_NodePool_UpdateInfo_BlueGreenInfo_descriptor;
        }

        @java.lang.Override
        public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo
            getDefaultInstanceForType() {
          return com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo build() {
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo buildPartial() {
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo result =
              new com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.phase_ = phase_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            blueInstanceGroupUrls_.makeImmutable();
            result.blueInstanceGroupUrls_ = blueInstanceGroupUrls_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            greenInstanceGroupUrls_.makeImmutable();
            result.greenInstanceGroupUrls_ = greenInstanceGroupUrls_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.bluePoolDeletionStartTime_ = bluePoolDeletionStartTime_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.greenPoolVersion_ = greenPoolVersion_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo) {
            return mergeFrom((com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo other) {
          if (other
              == com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDefaultInstance())
            return this;
          if (other.phase_ != 0) {
            setPhaseValue(other.getPhaseValue());
          }
          if (!other.blueInstanceGroupUrls_.isEmpty()) {
            if (blueInstanceGroupUrls_.isEmpty()) {
              blueInstanceGroupUrls_ = other.blueInstanceGroupUrls_;
              bitField0_ |= 0x00000002;
            } else {
              ensureBlueInstanceGroupUrlsIsMutable();
              blueInstanceGroupUrls_.addAll(other.blueInstanceGroupUrls_);
            }
            onChanged();
          }
          if (!other.greenInstanceGroupUrls_.isEmpty()) {
            if (greenInstanceGroupUrls_.isEmpty()) {
              greenInstanceGroupUrls_ = other.greenInstanceGroupUrls_;
              bitField0_ |= 0x00000004;
            } else {
              ensureGreenInstanceGroupUrlsIsMutable();
              greenInstanceGroupUrls_.addAll(other.greenInstanceGroupUrls_);
            }
            onChanged();
          }
          if (!other.getBluePoolDeletionStartTime().isEmpty()) {
            bluePoolDeletionStartTime_ = other.bluePoolDeletionStartTime_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (!other.getGreenPoolVersion().isEmpty()) {
            greenPoolVersion_ = other.greenPoolVersion_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    phase_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureBlueInstanceGroupUrlsIsMutable();
                    blueInstanceGroupUrls_.add(s);
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureGreenInstanceGroupUrlsIsMutable();
                    greenInstanceGroupUrls_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    bluePoolDeletionStartTime_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    greenPoolVersion_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int phase_ = 0;
        /**
         *
         *
         * <pre>
         * Current blue-green upgrade phase.
         * </pre>
         *
         * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
         *
         * @return The enum numeric value on the wire for phase.
         */
        @java.lang.Override
        public int getPhaseValue() {
          return phase_;
        }
        /**
         *
         *
         * <pre>
         * Current blue-green upgrade phase.
         * </pre>
         *
         * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
         *
         * @param value The enum numeric value on the wire for phase to set.
         * @return This builder for chaining.
         */
        public Builder setPhaseValue(int value) {
          phase_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Current blue-green upgrade phase.
         * </pre>
         *
         * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
         *
         * @return The phase.
         */
        @java.lang.Override
        public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase getPhase() {
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase result =
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase.forNumber(phase_);
          return result == null
              ? com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Current blue-green upgrade phase.
         * </pre>
         *
         * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
         *
         * @param value The phase to set.
         * @return This builder for chaining.
         */
        public Builder setPhase(
            com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          phase_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Current blue-green upgrade phase.
         * </pre>
         *
         * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Phase phase = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPhase() {
          bitField0_ = (bitField0_ & ~0x00000001);
          phase_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList blueInstanceGroupUrls_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureBlueInstanceGroupUrlsIsMutable() {
          if (!blueInstanceGroupUrls_.isModifiable()) {
            blueInstanceGroupUrls_ =
                new com.google.protobuf.LazyStringArrayList(blueInstanceGroupUrls_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @return A list containing the blueInstanceGroupUrls.
         */
        public com.google.protobuf.ProtocolStringList getBlueInstanceGroupUrlsList() {
          blueInstanceGroupUrls_.makeImmutable();
          return blueInstanceGroupUrls_;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @return The count of blueInstanceGroupUrls.
         */
        public int getBlueInstanceGroupUrlsCount() {
          return blueInstanceGroupUrls_.size();
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The blueInstanceGroupUrls at the given index.
         */
        public java.lang.String getBlueInstanceGroupUrls(int index) {
          return blueInstanceGroupUrls_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the blueInstanceGroupUrls at the given index.
         */
        public com.google.protobuf.ByteString getBlueInstanceGroupUrlsBytes(int index) {
          return blueInstanceGroupUrls_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The blueInstanceGroupUrls to set.
         * @return This builder for chaining.
         */
        public Builder setBlueInstanceGroupUrls(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlueInstanceGroupUrlsIsMutable();
          blueInstanceGroupUrls_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @param value The blueInstanceGroupUrls to add.
         * @return This builder for chaining.
         */
        public Builder addBlueInstanceGroupUrls(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlueInstanceGroupUrlsIsMutable();
          blueInstanceGroupUrls_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @param values The blueInstanceGroupUrls to add.
         * @return This builder for chaining.
         */
        public Builder addAllBlueInstanceGroupUrls(java.lang.Iterable<java.lang.String> values) {
          ensureBlueInstanceGroupUrlsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blueInstanceGroupUrls_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBlueInstanceGroupUrls() {
          blueInstanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with blue pool.
         * </pre>
         *
         * <code>repeated string blue_instance_group_urls = 2;</code>
         *
         * @param value The bytes of the blueInstanceGroupUrls to add.
         * @return This builder for chaining.
         */
        public Builder addBlueInstanceGroupUrlsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureBlueInstanceGroupUrlsIsMutable();
          blueInstanceGroupUrls_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList greenInstanceGroupUrls_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureGreenInstanceGroupUrlsIsMutable() {
          if (!greenInstanceGroupUrls_.isModifiable()) {
            greenInstanceGroupUrls_ =
                new com.google.protobuf.LazyStringArrayList(greenInstanceGroupUrls_);
          }
          bitField0_ |= 0x00000004;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @return A list containing the greenInstanceGroupUrls.
         */
        public com.google.protobuf.ProtocolStringList getGreenInstanceGroupUrlsList() {
          greenInstanceGroupUrls_.makeImmutable();
          return greenInstanceGroupUrls_;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @return The count of greenInstanceGroupUrls.
         */
        public int getGreenInstanceGroupUrlsCount() {
          return greenInstanceGroupUrls_.size();
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The greenInstanceGroupUrls at the given index.
         */
        public java.lang.String getGreenInstanceGroupUrls(int index) {
          return greenInstanceGroupUrls_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the greenInstanceGroupUrls at the given index.
         */
        public com.google.protobuf.ByteString getGreenInstanceGroupUrlsBytes(int index) {
          return greenInstanceGroupUrls_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @param index The index to set the value at.
         * @param value The greenInstanceGroupUrls to set.
         * @return This builder for chaining.
         */
        public Builder setGreenInstanceGroupUrls(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGreenInstanceGroupUrlsIsMutable();
          greenInstanceGroupUrls_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @param value The greenInstanceGroupUrls to add.
         * @return This builder for chaining.
         */
        public Builder addGreenInstanceGroupUrls(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGreenInstanceGroupUrlsIsMutable();
          greenInstanceGroupUrls_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @param values The greenInstanceGroupUrls to add.
         * @return This builder for chaining.
         */
        public Builder addAllGreenInstanceGroupUrls(java.lang.Iterable<java.lang.String> values) {
          ensureGreenInstanceGroupUrlsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, greenInstanceGroupUrls_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGreenInstanceGroupUrls() {
          greenInstanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The resource URLs of the [managed instance groups]
         * (/compute/docs/instance-groups/creating-groups-of-managed-instances)
         * associated with green pool.
         * </pre>
         *
         * <code>repeated string green_instance_group_urls = 3;</code>
         *
         * @param value The bytes of the greenInstanceGroupUrls to add.
         * @return This builder for chaining.
         */
        public Builder addGreenInstanceGroupUrlsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureGreenInstanceGroupUrlsIsMutable();
          greenInstanceGroupUrls_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object bluePoolDeletionStartTime_ = "";
        /**
         *
         *
         * <pre>
         * Time to start deleting blue pool to complete blue-green upgrade,
         * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
         * </pre>
         *
         * <code>string blue_pool_deletion_start_time = 4;</code>
         *
         * @return The bluePoolDeletionStartTime.
         */
        public java.lang.String getBluePoolDeletionStartTime() {
          java.lang.Object ref = bluePoolDeletionStartTime_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            bluePoolDeletionStartTime_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Time to start deleting blue pool to complete blue-green upgrade,
         * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
         * </pre>
         *
         * <code>string blue_pool_deletion_start_time = 4;</code>
         *
         * @return The bytes for bluePoolDeletionStartTime.
         */
        public com.google.protobuf.ByteString getBluePoolDeletionStartTimeBytes() {
          java.lang.Object ref = bluePoolDeletionStartTime_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            bluePoolDeletionStartTime_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Time to start deleting blue pool to complete blue-green upgrade,
         * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
         * </pre>
         *
         * <code>string blue_pool_deletion_start_time = 4;</code>
         *
         * @param value The bluePoolDeletionStartTime to set.
         * @return This builder for chaining.
         */
        public Builder setBluePoolDeletionStartTime(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bluePoolDeletionStartTime_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Time to start deleting blue pool to complete blue-green upgrade,
         * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
         * </pre>
         *
         * <code>string blue_pool_deletion_start_time = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBluePoolDeletionStartTime() {
          bluePoolDeletionStartTime_ = getDefaultInstance().getBluePoolDeletionStartTime();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Time to start deleting blue pool to complete blue-green upgrade,
         * in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
         * </pre>
         *
         * <code>string blue_pool_deletion_start_time = 4;</code>
         *
         * @param value The bytes for bluePoolDeletionStartTime to set.
         * @return This builder for chaining.
         */
        public Builder setBluePoolDeletionStartTimeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          bluePoolDeletionStartTime_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private java.lang.Object greenPoolVersion_ = "";
        /**
         *
         *
         * <pre>
         * Version of green pool.
         * </pre>
         *
         * <code>string green_pool_version = 5;</code>
         *
         * @return The greenPoolVersion.
         */
        public java.lang.String getGreenPoolVersion() {
          java.lang.Object ref = greenPoolVersion_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            greenPoolVersion_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Version of green pool.
         * </pre>
         *
         * <code>string green_pool_version = 5;</code>
         *
         * @return The bytes for greenPoolVersion.
         */
        public com.google.protobuf.ByteString getGreenPoolVersionBytes() {
          java.lang.Object ref = greenPoolVersion_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            greenPoolVersion_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Version of green pool.
         * </pre>
         *
         * <code>string green_pool_version = 5;</code>
         *
         * @param value The greenPoolVersion to set.
         * @return This builder for chaining.
         */
        public Builder setGreenPoolVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          greenPoolVersion_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Version of green pool.
         * </pre>
         *
         * <code>string green_pool_version = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearGreenPoolVersion() {
          greenPoolVersion_ = getDefaultInstance().getGreenPoolVersion();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Version of green pool.
         * </pre>
         *
         * <code>string green_pool_version = 5;</code>
         *
         * @param value The bytes for greenPoolVersion to set.
         * @return This builder for chaining.
         */
        public Builder setGreenPoolVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          greenPoolVersion_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool.UpdateInfo.BlueGreenInfo)
      }

      // @@protoc_insertion_point(class_scope:google.container.v1.NodePool.UpdateInfo.BlueGreenInfo)
      private static final com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo();
      }

      public static com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BlueGreenInfo> PARSER =
          new com.google.protobuf.AbstractParser<BlueGreenInfo>() {
            @java.lang.Override
            public BlueGreenInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BlueGreenInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BlueGreenInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int BLUE_GREEN_INFO_FIELD_NUMBER = 1;
    private com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blueGreenInfo_;
    /**
     *
     *
     * <pre>
     * Information of a blue-green upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
     *
     * @return Whether the blueGreenInfo field is set.
     */
    @java.lang.Override
    public boolean hasBlueGreenInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Information of a blue-green upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
     *
     * @return The blueGreenInfo.
     */
    @java.lang.Override
    public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo getBlueGreenInfo() {
      return blueGreenInfo_ == null
          ? com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDefaultInstance()
          : blueGreenInfo_;
    }
    /**
     *
     *
     * <pre>
     * Information of a blue-green upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
     */
    @java.lang.Override
    public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder
        getBlueGreenInfoOrBuilder() {
      return blueGreenInfo_ == null
          ? com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDefaultInstance()
          : blueGreenInfo_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getBlueGreenInfo());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBlueGreenInfo());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.NodePool.UpdateInfo)) {
        return super.equals(obj);
      }
      com.google.container.v1.NodePool.UpdateInfo other =
          (com.google.container.v1.NodePool.UpdateInfo) obj;

      if (hasBlueGreenInfo() != other.hasBlueGreenInfo()) return false;
      if (hasBlueGreenInfo()) {
        if (!getBlueGreenInfo().equals(other.getBlueGreenInfo())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBlueGreenInfo()) {
        hash = (37 * hash) + BLUE_GREEN_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getBlueGreenInfo().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.UpdateInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.container.v1.NodePool.UpdateInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * UpdateInfo contains resource (instance groups, etc), status and other
     * intermediate information relevant to a node pool upgrade.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.NodePool.UpdateInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool.UpdateInfo)
        com.google.container.v1.NodePool.UpdateInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpdateInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpdateInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.NodePool.UpdateInfo.class,
                com.google.container.v1.NodePool.UpdateInfo.Builder.class);
      }

      // Construct using com.google.container.v1.NodePool.UpdateInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBlueGreenInfoFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        blueGreenInfo_ = null;
        if (blueGreenInfoBuilder_ != null) {
          blueGreenInfoBuilder_.dispose();
          blueGreenInfoBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_UpdateInfo_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpdateInfo getDefaultInstanceForType() {
        return com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpdateInfo build() {
        com.google.container.v1.NodePool.UpdateInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.UpdateInfo buildPartial() {
        com.google.container.v1.NodePool.UpdateInfo result =
            new com.google.container.v1.NodePool.UpdateInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1.NodePool.UpdateInfo result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.blueGreenInfo_ =
              blueGreenInfoBuilder_ == null ? blueGreenInfo_ : blueGreenInfoBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.NodePool.UpdateInfo) {
          return mergeFrom((com.google.container.v1.NodePool.UpdateInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1.NodePool.UpdateInfo other) {
        if (other == com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance()) return this;
        if (other.hasBlueGreenInfo()) {
          mergeBlueGreenInfo(other.getBlueGreenInfo());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getBlueGreenInfoFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blueGreenInfo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo,
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder,
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder>
          blueGreenInfoBuilder_;
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       *
       * @return Whether the blueGreenInfo field is set.
       */
      public boolean hasBlueGreenInfo() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       *
       * @return The blueGreenInfo.
       */
      public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo getBlueGreenInfo() {
        if (blueGreenInfoBuilder_ == null) {
          return blueGreenInfo_ == null
              ? com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDefaultInstance()
              : blueGreenInfo_;
        } else {
          return blueGreenInfoBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      public Builder setBlueGreenInfo(
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo value) {
        if (blueGreenInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          blueGreenInfo_ = value;
        } else {
          blueGreenInfoBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      public Builder setBlueGreenInfo(
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder builderForValue) {
        if (blueGreenInfoBuilder_ == null) {
          blueGreenInfo_ = builderForValue.build();
        } else {
          blueGreenInfoBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      public Builder mergeBlueGreenInfo(
          com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo value) {
        if (blueGreenInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && blueGreenInfo_ != null
              && blueGreenInfo_
                  != com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo
                      .getDefaultInstance()) {
            getBlueGreenInfoBuilder().mergeFrom(value);
          } else {
            blueGreenInfo_ = value;
          }
        } else {
          blueGreenInfoBuilder_.mergeFrom(value);
        }
        if (blueGreenInfo_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      public Builder clearBlueGreenInfo() {
        bitField0_ = (bitField0_ & ~0x00000001);
        blueGreenInfo_ = null;
        if (blueGreenInfoBuilder_ != null) {
          blueGreenInfoBuilder_.dispose();
          blueGreenInfoBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder
          getBlueGreenInfoBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getBlueGreenInfoFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      public com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder
          getBlueGreenInfoOrBuilder() {
        if (blueGreenInfoBuilder_ != null) {
          return blueGreenInfoBuilder_.getMessageOrBuilder();
        } else {
          return blueGreenInfo_ == null
              ? com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.getDefaultInstance()
              : blueGreenInfo_;
        }
      }
      /**
       *
       *
       * <pre>
       * Information of a blue-green upgrade.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo blue_green_info = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo,
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder,
              com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder>
          getBlueGreenInfoFieldBuilder() {
        if (blueGreenInfoBuilder_ == null) {
          blueGreenInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo,
                  com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfo.Builder,
                  com.google.container.v1.NodePool.UpdateInfo.BlueGreenInfoOrBuilder>(
                  getBlueGreenInfo(), getParentForChildren(), isClean());
          blueGreenInfo_ = null;
        }
        return blueGreenInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool.UpdateInfo)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.NodePool.UpdateInfo)
    private static final com.google.container.v1.NodePool.UpdateInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.NodePool.UpdateInfo();
    }

    public static com.google.container.v1.NodePool.UpdateInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdateInfo> PARSER =
        new com.google.protobuf.AbstractParser<UpdateInfo>() {
          @java.lang.Override
          public UpdateInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdateInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.NodePool.UpdateInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PlacementPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.NodePool.PlacementPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The type of placement.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The type of placement.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
     *
     * @return The type.
     */
    com.google.container.v1.NodePool.PlacementPolicy.Type getType();

    /**
     *
     *
     * <pre>
     * Optional. TPU placement topology for pod slice node pool.
     * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
     * </pre>
     *
     * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tpuTopology.
     */
    java.lang.String getTpuTopology();
    /**
     *
     *
     * <pre>
     * Optional. TPU placement topology for pod slice node pool.
     * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
     * </pre>
     *
     * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tpuTopology.
     */
    com.google.protobuf.ByteString getTpuTopologyBytes();

    /**
     *
     *
     * <pre>
     * If set, refers to the name of a custom resource policy supplied by the
     * user. The resource policy must be in the same project and region as the
     * node pool. If not found, InvalidArgument error is returned.
     * </pre>
     *
     * <code>string policy_name = 3;</code>
     *
     * @return The policyName.
     */
    java.lang.String getPolicyName();
    /**
     *
     *
     * <pre>
     * If set, refers to the name of a custom resource policy supplied by the
     * user. The resource policy must be in the same project and region as the
     * node pool. If not found, InvalidArgument error is returned.
     * </pre>
     *
     * <code>string policy_name = 3;</code>
     *
     * @return The bytes for policyName.
     */
    com.google.protobuf.ByteString getPolicyNameBytes();
  }
  /**
   *
   *
   * <pre>
   * PlacementPolicy defines the placement policy used by the node pool.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodePool.PlacementPolicy}
   */
  public static final class PlacementPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.NodePool.PlacementPolicy)
      PlacementPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PlacementPolicy.newBuilder() to construct.
    private PlacementPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PlacementPolicy() {
      type_ = 0;
      tpuTopology_ = "";
      policyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PlacementPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_PlacementPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_PlacementPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodePool.PlacementPolicy.class,
              com.google.container.v1.NodePool.PlacementPolicy.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Type defines the type of placement policy.
     * </pre>
     *
     * Protobuf enum {@code google.container.v1.NodePool.PlacementPolicy.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * TYPE_UNSPECIFIED specifies no requirements on nodes
       * placement.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * COMPACT specifies node placement in the same availability domain to
       * ensure low communication latency.
       * </pre>
       *
       * <code>COMPACT = 1;</code>
       */
      COMPACT(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * TYPE_UNSPECIFIED specifies no requirements on nodes
       * placement.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * COMPACT specifies node placement in the same availability domain to
       * ensure low communication latency.
       * </pre>
       *
       * <code>COMPACT = 1;</code>
       */
      public static final int COMPACT_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return COMPACT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.container.v1.NodePool.PlacementPolicy.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.container.v1.NodePool.PlacementPolicy.Type)
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of placement.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of placement.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.container.v1.NodePool.PlacementPolicy.Type getType() {
      com.google.container.v1.NodePool.PlacementPolicy.Type result =
          com.google.container.v1.NodePool.PlacementPolicy.Type.forNumber(type_);
      return result == null
          ? com.google.container.v1.NodePool.PlacementPolicy.Type.UNRECOGNIZED
          : result;
    }

    public static final int TPU_TOPOLOGY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tpuTopology_ = "";
    /**
     *
     *
     * <pre>
     * Optional. TPU placement topology for pod slice node pool.
     * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
     * </pre>
     *
     * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tpuTopology.
     */
    @java.lang.Override
    public java.lang.String getTpuTopology() {
      java.lang.Object ref = tpuTopology_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tpuTopology_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. TPU placement topology for pod slice node pool.
     * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
     * </pre>
     *
     * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tpuTopology.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTpuTopologyBytes() {
      java.lang.Object ref = tpuTopology_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tpuTopology_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int POLICY_NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object policyName_ = "";
    /**
     *
     *
     * <pre>
     * If set, refers to the name of a custom resource policy supplied by the
     * user. The resource policy must be in the same project and region as the
     * node pool. If not found, InvalidArgument error is returned.
     * </pre>
     *
     * <code>string policy_name = 3;</code>
     *
     * @return The policyName.
     */
    @java.lang.Override
    public java.lang.String getPolicyName() {
      java.lang.Object ref = policyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policyName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, refers to the name of a custom resource policy supplied by the
     * user. The resource policy must be in the same project and region as the
     * node pool. If not found, InvalidArgument error is returned.
     * </pre>
     *
     * <code>string policy_name = 3;</code>
     *
     * @return The bytes for policyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPolicyNameBytes() {
      java.lang.Object ref = policyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.container.v1.NodePool.PlacementPolicy.Type.TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tpuTopology_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tpuTopology_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, policyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.container.v1.NodePool.PlacementPolicy.Type.TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tpuTopology_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, tpuTopology_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, policyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.NodePool.PlacementPolicy)) {
        return super.equals(obj);
      }
      com.google.container.v1.NodePool.PlacementPolicy other =
          (com.google.container.v1.NodePool.PlacementPolicy) obj;

      if (type_ != other.type_) return false;
      if (!getTpuTopology().equals(other.getTpuTopology())) return false;
      if (!getPolicyName().equals(other.getPolicyName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + TPU_TOPOLOGY_FIELD_NUMBER;
      hash = (53 * hash) + getTpuTopology().hashCode();
      hash = (37 * hash) + POLICY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.PlacementPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.container.v1.NodePool.PlacementPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * PlacementPolicy defines the placement policy used by the node pool.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.NodePool.PlacementPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool.PlacementPolicy)
        com.google.container.v1.NodePool.PlacementPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_PlacementPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_PlacementPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.NodePool.PlacementPolicy.class,
                com.google.container.v1.NodePool.PlacementPolicy.Builder.class);
      }

      // Construct using com.google.container.v1.NodePool.PlacementPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        tpuTopology_ = "";
        policyName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_PlacementPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.PlacementPolicy getDefaultInstanceForType() {
        return com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.PlacementPolicy build() {
        com.google.container.v1.NodePool.PlacementPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.PlacementPolicy buildPartial() {
        com.google.container.v1.NodePool.PlacementPolicy result =
            new com.google.container.v1.NodePool.PlacementPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1.NodePool.PlacementPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.tpuTopology_ = tpuTopology_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.policyName_ = policyName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.NodePool.PlacementPolicy) {
          return mergeFrom((com.google.container.v1.NodePool.PlacementPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1.NodePool.PlacementPolicy other) {
        if (other == com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.getTpuTopology().isEmpty()) {
          tpuTopology_ = other.tpuTopology_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPolicyName().isEmpty()) {
          policyName_ = other.policyName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  tpuTopology_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  policyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The type of placement.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The type of placement.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of placement.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.container.v1.NodePool.PlacementPolicy.Type getType() {
        com.google.container.v1.NodePool.PlacementPolicy.Type result =
            com.google.container.v1.NodePool.PlacementPolicy.Type.forNumber(type_);
        return result == null
            ? com.google.container.v1.NodePool.PlacementPolicy.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of placement.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.container.v1.NodePool.PlacementPolicy.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of placement.
       * </pre>
       *
       * <code>.google.container.v1.NodePool.PlacementPolicy.Type type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object tpuTopology_ = "";
      /**
       *
       *
       * <pre>
       * Optional. TPU placement topology for pod slice node pool.
       * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
       * </pre>
       *
       * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The tpuTopology.
       */
      public java.lang.String getTpuTopology() {
        java.lang.Object ref = tpuTopology_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tpuTopology_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. TPU placement topology for pod slice node pool.
       * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
       * </pre>
       *
       * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for tpuTopology.
       */
      public com.google.protobuf.ByteString getTpuTopologyBytes() {
        java.lang.Object ref = tpuTopology_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tpuTopology_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. TPU placement topology for pod slice node pool.
       * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
       * </pre>
       *
       * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The tpuTopology to set.
       * @return This builder for chaining.
       */
      public Builder setTpuTopology(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tpuTopology_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. TPU placement topology for pod slice node pool.
       * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
       * </pre>
       *
       * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTpuTopology() {
        tpuTopology_ = getDefaultInstance().getTpuTopology();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. TPU placement topology for pod slice node pool.
       * https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
       * </pre>
       *
       * <code>string tpu_topology = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for tpuTopology to set.
       * @return This builder for chaining.
       */
      public Builder setTpuTopologyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tpuTopology_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object policyName_ = "";
      /**
       *
       *
       * <pre>
       * If set, refers to the name of a custom resource policy supplied by the
       * user. The resource policy must be in the same project and region as the
       * node pool. If not found, InvalidArgument error is returned.
       * </pre>
       *
       * <code>string policy_name = 3;</code>
       *
       * @return The policyName.
       */
      public java.lang.String getPolicyName() {
        java.lang.Object ref = policyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          policyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If set, refers to the name of a custom resource policy supplied by the
       * user. The resource policy must be in the same project and region as the
       * node pool. If not found, InvalidArgument error is returned.
       * </pre>
       *
       * <code>string policy_name = 3;</code>
       *
       * @return The bytes for policyName.
       */
      public com.google.protobuf.ByteString getPolicyNameBytes() {
        java.lang.Object ref = policyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          policyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If set, refers to the name of a custom resource policy supplied by the
       * user. The resource policy must be in the same project and region as the
       * node pool. If not found, InvalidArgument error is returned.
       * </pre>
       *
       * <code>string policy_name = 3;</code>
       *
       * @param value The policyName to set.
       * @return This builder for chaining.
       */
      public Builder setPolicyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, refers to the name of a custom resource policy supplied by the
       * user. The resource policy must be in the same project and region as the
       * node pool. If not found, InvalidArgument error is returned.
       * </pre>
       *
       * <code>string policy_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPolicyName() {
        policyName_ = getDefaultInstance().getPolicyName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, refers to the name of a custom resource policy supplied by the
       * user. The resource policy must be in the same project and region as the
       * node pool. If not found, InvalidArgument error is returned.
       * </pre>
       *
       * <code>string policy_name = 3;</code>
       *
       * @param value The bytes for policyName to set.
       * @return This builder for chaining.
       */
      public Builder setPolicyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        policyName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool.PlacementPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.NodePool.PlacementPolicy)
    private static final com.google.container.v1.NodePool.PlacementPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.NodePool.PlacementPolicy();
    }

    public static com.google.container.v1.NodePool.PlacementPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PlacementPolicy> PARSER =
        new com.google.protobuf.AbstractParser<PlacementPolicy>() {
          @java.lang.Override
          public PlacementPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PlacementPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PlacementPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.NodePool.PlacementPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueuedProvisioningOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.NodePool.QueuedProvisioning)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Denotes that this nodepool is QRM specific, meaning nodes can be only
     * obtained through queuing via the Cluster Autoscaler ProvisioningRequest
     * API.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * QueuedProvisioning defines the queued provisioning used by the node pool.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodePool.QueuedProvisioning}
   */
  public static final class QueuedProvisioning extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.NodePool.QueuedProvisioning)
      QueuedProvisioningOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueuedProvisioning.newBuilder() to construct.
    private QueuedProvisioning(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueuedProvisioning() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueuedProvisioning();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_QueuedProvisioning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_QueuedProvisioning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodePool.QueuedProvisioning.class,
              com.google.container.v1.NodePool.QueuedProvisioning.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Denotes that this nodepool is QRM specific, meaning nodes can be only
     * obtained through queuing via the Cluster Autoscaler ProvisioningRequest
     * API.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.NodePool.QueuedProvisioning)) {
        return super.equals(obj);
      }
      com.google.container.v1.NodePool.QueuedProvisioning other =
          (com.google.container.v1.NodePool.QueuedProvisioning) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.NodePool.QueuedProvisioning prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * QueuedProvisioning defines the queued provisioning used by the node pool.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.NodePool.QueuedProvisioning}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool.QueuedProvisioning)
        com.google.container.v1.NodePool.QueuedProvisioningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_QueuedProvisioning_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_QueuedProvisioning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.NodePool.QueuedProvisioning.class,
                com.google.container.v1.NodePool.QueuedProvisioning.Builder.class);
      }

      // Construct using com.google.container.v1.NodePool.QueuedProvisioning.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_NodePool_QueuedProvisioning_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.QueuedProvisioning getDefaultInstanceForType() {
        return com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.QueuedProvisioning build() {
        com.google.container.v1.NodePool.QueuedProvisioning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.NodePool.QueuedProvisioning buildPartial() {
        com.google.container.v1.NodePool.QueuedProvisioning result =
            new com.google.container.v1.NodePool.QueuedProvisioning(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1.NodePool.QueuedProvisioning result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.NodePool.QueuedProvisioning) {
          return mergeFrom((com.google.container.v1.NodePool.QueuedProvisioning) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1.NodePool.QueuedProvisioning other) {
        if (other == com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance())
          return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Denotes that this nodepool is QRM specific, meaning nodes can be only
       * obtained through queuing via the Cluster Autoscaler ProvisioningRequest
       * API.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Denotes that this nodepool is QRM specific, meaning nodes can be only
       * obtained through queuing via the Cluster Autoscaler ProvisioningRequest
       * API.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Denotes that this nodepool is QRM specific, meaning nodes can be only
       * obtained through queuing via the Cluster Autoscaler ProvisioningRequest
       * API.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool.QueuedProvisioning)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.NodePool.QueuedProvisioning)
    private static final com.google.container.v1.NodePool.QueuedProvisioning DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.NodePool.QueuedProvisioning();
    }

    public static com.google.container.v1.NodePool.QueuedProvisioning getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueuedProvisioning> PARSER =
        new com.google.protobuf.AbstractParser<QueuedProvisioning>() {
          @java.lang.Override
          public QueuedProvisioning parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueuedProvisioning> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueuedProvisioning> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.NodePool.QueuedProvisioning getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the node pool.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the node pool.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;
  private com.google.container.v1.NodeConfig config_;
  /**
   *
   *
   * <pre>
   * The node configuration of the pool.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig config = 2;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The node configuration of the pool.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig config = 2;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.container.v1.NodeConfig getConfig() {
    return config_ == null ? com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
  }
  /**
   *
   *
   * <pre>
   * The node configuration of the pool.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig config = 2;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeConfigOrBuilder getConfigOrBuilder() {
    return config_ == null ? com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
  }

  public static final int INITIAL_NODE_COUNT_FIELD_NUMBER = 3;
  private int initialNodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * The initial node count for the pool. You must ensure that your
   * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
   * is sufficient for this number of instances. You must also have available
   * firewall and routes quota.
   * </pre>
   *
   * <code>int32 initial_node_count = 3;</code>
   *
   * @return The initialNodeCount.
   */
  @java.lang.Override
  public int getInitialNodeCount() {
    return initialNodeCount_;
  }

  public static final int LOCATIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList locations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes should be located.
   *
   * If this value is unspecified during node pool creation, the
   * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
   * value will be used, instead.
   *
   * Warning: changing node pool locations will result in nodes being added
   * and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return A list containing the locations.
   */
  public com.google.protobuf.ProtocolStringList getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes should be located.
   *
   * If this value is unspecified during node pool creation, the
   * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
   * value will be used, instead.
   *
   * Warning: changing node pool locations will result in nodes being added
   * and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return The count of locations.
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes should be located.
   *
   * If this value is unspecified during node pool creation, the
   * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
   * value will be used, instead.
   *
   * Warning: changing node pool locations will result in nodes being added
   * and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  public java.lang.String getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes should be located.
   *
   * If this value is unspecified during node pool creation, the
   * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
   * value will be used, instead.
   *
   * Warning: changing node pool locations will result in nodes being added
   * and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  public com.google.protobuf.ByteString getLocationsBytes(int index) {
    return locations_.getByteString(index);
  }

  public static final int NETWORK_CONFIG_FIELD_NUMBER = 14;
  private com.google.container.v1.NodeNetworkConfig networkConfig_;
  /**
   *
   *
   * <pre>
   * Networking configuration for this NodePool. If specified, it overrides the
   * cluster-level defaults.
   * </pre>
   *
   * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
   *
   * @return Whether the networkConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Networking configuration for this NodePool. If specified, it overrides the
   * cluster-level defaults.
   * </pre>
   *
   * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
   *
   * @return The networkConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodeNetworkConfig getNetworkConfig() {
    return networkConfig_ == null
        ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
        : networkConfig_;
  }
  /**
   *
   *
   * <pre>
   * Networking configuration for this NodePool. If specified, it overrides the
   * cluster-level defaults.
   * </pre>
   *
   * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeNetworkConfigOrBuilder getNetworkConfigOrBuilder() {
    return networkConfig_ == null
        ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
        : networkConfig_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 100;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 101;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * The version of Kubernetes running on this NodePool's nodes. If unspecified,
   * it defaults as described
   * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
   * </pre>
   *
   * <code>string version = 101;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The version of Kubernetes running on this NodePool's nodes. If unspecified,
   * it defaults as described
   * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
   * </pre>
   *
   * <code>string version = 101;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_GROUP_URLS_FIELD_NUMBER = 102;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instanceGroupUrls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The resource URLs of the [managed instance
   * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * During the node pool blue-green upgrade operation, the URLs contain both
   * blue and green resources.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the instanceGroupUrls.
   */
  public com.google.protobuf.ProtocolStringList getInstanceGroupUrlsList() {
    return instanceGroupUrls_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource URLs of the [managed instance
   * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * During the node pool blue-green upgrade operation, the URLs contain both
   * blue and green resources.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of instanceGroupUrls.
   */
  public int getInstanceGroupUrlsCount() {
    return instanceGroupUrls_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource URLs of the [managed instance
   * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * During the node pool blue-green upgrade operation, the URLs contain both
   * blue and green resources.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The instanceGroupUrls at the given index.
   */
  public java.lang.String getInstanceGroupUrls(int index) {
    return instanceGroupUrls_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource URLs of the [managed instance
   * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
   * associated with this node pool.
   * During the node pool blue-green upgrade operation, the URLs contain both
   * blue and green resources.
   * </pre>
   *
   * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instanceGroupUrls at the given index.
   */
  public com.google.protobuf.ByteString getInstanceGroupUrlsBytes(int index) {
    return instanceGroupUrls_.getByteString(index);
  }

  public static final int STATUS_FIELD_NUMBER = 103;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The status of the nodes in this pool instance.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of the nodes in this pool instance.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.Status getStatus() {
    com.google.container.v1.NodePool.Status result =
        com.google.container.v1.NodePool.Status.forNumber(status_);
    return result == null ? com.google.container.v1.NodePool.Status.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 104;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use conditions instead.
   * Additional information about the current status of this
   * node pool instance, if available.
   * </pre>
   *
   * <code>
   * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.NodePool.status_message is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3712
   * @return The statusMessage.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use conditions instead.
   * Additional information about the current status of this
   * node pool instance, if available.
   * </pre>
   *
   * <code>
   * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.NodePool.status_message is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3712
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTOSCALING_FIELD_NUMBER = 4;
  private com.google.container.v1.NodePoolAutoscaling autoscaling_;
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for this NodePool. Autoscaler is enabled
   * only if a valid configuration is present.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
   *
   * @return Whether the autoscaling field is set.
   */
  @java.lang.Override
  public boolean hasAutoscaling() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for this NodePool. Autoscaler is enabled
   * only if a valid configuration is present.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
   *
   * @return The autoscaling.
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolAutoscaling getAutoscaling() {
    return autoscaling_ == null
        ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
        : autoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for this NodePool. Autoscaler is enabled
   * only if a valid configuration is present.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolAutoscalingOrBuilder getAutoscalingOrBuilder() {
    return autoscaling_ == null
        ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
        : autoscaling_;
  }

  public static final int MANAGEMENT_FIELD_NUMBER = 5;
  private com.google.container.v1.NodeManagement management_;
  /**
   *
   *
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1.NodeManagement management = 5;</code>
   *
   * @return Whether the management field is set.
   */
  @java.lang.Override
  public boolean hasManagement() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1.NodeManagement management = 5;</code>
   *
   * @return The management.
   */
  @java.lang.Override
  public com.google.container.v1.NodeManagement getManagement() {
    return management_ == null
        ? com.google.container.v1.NodeManagement.getDefaultInstance()
        : management_;
  }
  /**
   *
   *
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1.NodeManagement management = 5;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeManagementOrBuilder getManagementOrBuilder() {
    return management_ == null
        ? com.google.container.v1.NodeManagement.getDefaultInstance()
        : management_;
  }

  public static final int MAX_PODS_CONSTRAINT_FIELD_NUMBER = 6;
  private com.google.container.v1.MaxPodsConstraint maxPodsConstraint_;
  /**
   *
   *
   * <pre>
   * The constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool.
   * </pre>
   *
   * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
   *
   * @return Whether the maxPodsConstraint field is set.
   */
  @java.lang.Override
  public boolean hasMaxPodsConstraint() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool.
   * </pre>
   *
   * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
   *
   * @return The maxPodsConstraint.
   */
  @java.lang.Override
  public com.google.container.v1.MaxPodsConstraint getMaxPodsConstraint() {
    return maxPodsConstraint_ == null
        ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
        : maxPodsConstraint_;
  }
  /**
   *
   *
   * <pre>
   * The constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool.
   * </pre>
   *
   * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
   */
  @java.lang.Override
  public com.google.container.v1.MaxPodsConstraintOrBuilder getMaxPodsConstraintOrBuilder() {
    return maxPodsConstraint_ == null
        ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
        : maxPodsConstraint_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 105;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.StatusCondition> conditions_;
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.StatusCondition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
   */
  @java.lang.Override
  public com.google.container.v1.StatusCondition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
   */
  @java.lang.Override
  public com.google.container.v1.StatusConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int POD_IPV4_CIDR_SIZE_FIELD_NUMBER = 7;
  private int podIpv4CidrSize_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The pod CIDR block size per node in this node pool.
   * </pre>
   *
   * <code>int32 pod_ipv4_cidr_size = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The podIpv4CidrSize.
   */
  @java.lang.Override
  public int getPodIpv4CidrSize() {
    return podIpv4CidrSize_;
  }

  public static final int UPGRADE_SETTINGS_FIELD_NUMBER = 107;
  private com.google.container.v1.NodePool.UpgradeSettings upgradeSettings_;
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
   *
   * @return Whether the upgradeSettings field is set.
   */
  @java.lang.Override
  public boolean hasUpgradeSettings() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
   *
   * @return The upgradeSettings.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.UpgradeSettings getUpgradeSettings() {
    return upgradeSettings_ == null
        ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
        : upgradeSettings_;
  }
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.UpgradeSettingsOrBuilder getUpgradeSettingsOrBuilder() {
    return upgradeSettings_ == null
        ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
        : upgradeSettings_;
  }

  public static final int PLACEMENT_POLICY_FIELD_NUMBER = 108;
  private com.google.container.v1.NodePool.PlacementPolicy placementPolicy_;
  /**
   *
   *
   * <pre>
   * Specifies the node placement policy.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
   *
   * @return Whether the placementPolicy field is set.
   */
  @java.lang.Override
  public boolean hasPlacementPolicy() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the node placement policy.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
   *
   * @return The placementPolicy.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.PlacementPolicy getPlacementPolicy() {
    return placementPolicy_ == null
        ? com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance()
        : placementPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the node placement policy.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.PlacementPolicyOrBuilder getPlacementPolicyOrBuilder() {
    return placementPolicy_ == null
        ? com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance()
        : placementPolicy_;
  }

  public static final int UPDATE_INFO_FIELD_NUMBER = 109;
  private com.google.container.v1.NodePool.UpdateInfo updateInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Update info contains relevant information during a node
   * pool update.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateInfo field is set.
   */
  @java.lang.Override
  public boolean hasUpdateInfo() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update info contains relevant information during a node
   * pool update.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateInfo.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.UpdateInfo getUpdateInfo() {
    return updateInfo_ == null
        ? com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance()
        : updateInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update info contains relevant information during a node
   * pool update.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.UpdateInfoOrBuilder getUpdateInfoOrBuilder() {
    return updateInfo_ == null
        ? com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance()
        : updateInfo_;
  }

  public static final int ETAG_FIELD_NUMBER = 110;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of node pool
   * fields, and may be sent on update requests to ensure the client has an
   * up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 110;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of node pool
   * fields, and may be sent on update requests to ensure the client has an
   * up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 110;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUEUED_PROVISIONING_FIELD_NUMBER = 112;
  private com.google.container.v1.NodePool.QueuedProvisioning queuedProvisioning_;
  /**
   *
   *
   * <pre>
   * Specifies the configuration of queued provisioning.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
   *
   * @return Whether the queuedProvisioning field is set.
   */
  @java.lang.Override
  public boolean hasQueuedProvisioning() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the configuration of queued provisioning.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
   *
   * @return The queuedProvisioning.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.QueuedProvisioning getQueuedProvisioning() {
    return queuedProvisioning_ == null
        ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
        : queuedProvisioning_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the configuration of queued provisioning.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.QueuedProvisioningOrBuilder
      getQueuedProvisioningOrBuilder() {
    return queuedProvisioning_ == null
        ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
        : queuedProvisioning_;
  }

  public static final int BEST_EFFORT_PROVISIONING_FIELD_NUMBER = 113;
  private com.google.container.v1.BestEffortProvisioning bestEffortProvisioning_;
  /**
   *
   *
   * <pre>
   * Enable best effort provisioning for nodes
   * </pre>
   *
   * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
   *
   * @return Whether the bestEffortProvisioning field is set.
   */
  @java.lang.Override
  public boolean hasBestEffortProvisioning() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable best effort provisioning for nodes
   * </pre>
   *
   * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
   *
   * @return The bestEffortProvisioning.
   */
  @java.lang.Override
  public com.google.container.v1.BestEffortProvisioning getBestEffortProvisioning() {
    return bestEffortProvisioning_ == null
        ? com.google.container.v1.BestEffortProvisioning.getDefaultInstance()
        : bestEffortProvisioning_;
  }
  /**
   *
   *
   * <pre>
   * Enable best effort provisioning for nodes
   * </pre>
   *
   * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
   */
  @java.lang.Override
  public com.google.container.v1.BestEffortProvisioningOrBuilder
      getBestEffortProvisioningOrBuilder() {
    return bestEffortProvisioning_ == null
        ? com.google.container.v1.BestEffortProvisioning.getDefaultInstance()
        : bestEffortProvisioning_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getConfig());
    }
    if (initialNodeCount_ != 0) {
      output.writeInt32(3, initialNodeCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getAutoscaling());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getManagement());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(6, getMaxPodsConstraint());
    }
    if (podIpv4CidrSize_ != 0) {
      output.writeInt32(7, podIpv4CidrSize_);
    }
    for (int i = 0; i < locations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, locations_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(14, getNetworkConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, version_);
    }
    for (int i = 0; i < instanceGroupUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 102, instanceGroupUrls_.getRaw(i));
    }
    if (status_ != com.google.container.v1.NodePool.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(103, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 104, statusMessage_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(105, conditions_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(107, getUpgradeSettings());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(108, getPlacementPolicy());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(109, getUpdateInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 110, etag_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(112, getQueuedProvisioning());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(113, getBestEffortProvisioning());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConfig());
    }
    if (initialNodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, initialNodeCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAutoscaling());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getManagement());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMaxPodsConstraint());
    }
    if (podIpv4CidrSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, podIpv4CidrSize_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < locations_.size(); i++) {
        dataSize += computeStringSizeNoTag(locations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationsList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getNetworkConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, version_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceGroupUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceGroupUrls_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getInstanceGroupUrlsList().size();
    }
    if (status_ != com.google.container.v1.NodePool.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(103, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(104, statusMessage_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(105, conditions_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(107, getUpgradeSettings());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(108, getPlacementPolicy());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(109, getUpdateInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(110, etag_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(112, getQueuedProvisioning());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              113, getBestEffortProvisioning());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.NodePool)) {
      return super.equals(obj);
    }
    com.google.container.v1.NodePool other = (com.google.container.v1.NodePool) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (getInitialNodeCount() != other.getInitialNodeCount()) return false;
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (hasNetworkConfig() != other.hasNetworkConfig()) return false;
    if (hasNetworkConfig()) {
      if (!getNetworkConfig().equals(other.getNetworkConfig())) return false;
    }
    if (!getSelfLink().equals(other.getSelfLink())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!getInstanceGroupUrlsList().equals(other.getInstanceGroupUrlsList())) return false;
    if (status_ != other.status_) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (hasAutoscaling() != other.hasAutoscaling()) return false;
    if (hasAutoscaling()) {
      if (!getAutoscaling().equals(other.getAutoscaling())) return false;
    }
    if (hasManagement() != other.hasManagement()) return false;
    if (hasManagement()) {
      if (!getManagement().equals(other.getManagement())) return false;
    }
    if (hasMaxPodsConstraint() != other.hasMaxPodsConstraint()) return false;
    if (hasMaxPodsConstraint()) {
      if (!getMaxPodsConstraint().equals(other.getMaxPodsConstraint())) return false;
    }
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (getPodIpv4CidrSize() != other.getPodIpv4CidrSize()) return false;
    if (hasUpgradeSettings() != other.hasUpgradeSettings()) return false;
    if (hasUpgradeSettings()) {
      if (!getUpgradeSettings().equals(other.getUpgradeSettings())) return false;
    }
    if (hasPlacementPolicy() != other.hasPlacementPolicy()) return false;
    if (hasPlacementPolicy()) {
      if (!getPlacementPolicy().equals(other.getPlacementPolicy())) return false;
    }
    if (hasUpdateInfo() != other.hasUpdateInfo()) return false;
    if (hasUpdateInfo()) {
      if (!getUpdateInfo().equals(other.getUpdateInfo())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasQueuedProvisioning() != other.hasQueuedProvisioning()) return false;
    if (hasQueuedProvisioning()) {
      if (!getQueuedProvisioning().equals(other.getQueuedProvisioning())) return false;
    }
    if (hasBestEffortProvisioning() != other.hasBestEffortProvisioning()) return false;
    if (hasBestEffortProvisioning()) {
      if (!getBestEffortProvisioning().equals(other.getBestEffortProvisioning())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    hash = (37 * hash) + INITIAL_NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getInitialNodeCount();
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    if (hasNetworkConfig()) {
      hash = (37 * hash) + NETWORK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkConfig().hashCode();
    }
    hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getSelfLink().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    if (getInstanceGroupUrlsCount() > 0) {
      hash = (37 * hash) + INSTANCE_GROUP_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceGroupUrlsList().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    if (hasAutoscaling()) {
      hash = (37 * hash) + AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaling().hashCode();
    }
    if (hasManagement()) {
      hash = (37 * hash) + MANAGEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getManagement().hashCode();
    }
    if (hasMaxPodsConstraint()) {
      hash = (37 * hash) + MAX_PODS_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxPodsConstraint().hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (37 * hash) + POD_IPV4_CIDR_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPodIpv4CidrSize();
    if (hasUpgradeSettings()) {
      hash = (37 * hash) + UPGRADE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getUpgradeSettings().hashCode();
    }
    if (hasPlacementPolicy()) {
      hash = (37 * hash) + PLACEMENT_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getPlacementPolicy().hashCode();
    }
    if (hasUpdateInfo()) {
      hash = (37 * hash) + UPDATE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateInfo().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasQueuedProvisioning()) {
      hash = (37 * hash) + QUEUED_PROVISIONING_FIELD_NUMBER;
      hash = (53 * hash) + getQueuedProvisioning().hashCode();
    }
    if (hasBestEffortProvisioning()) {
      hash = (37 * hash) + BEST_EFFORT_PROVISIONING_FIELD_NUMBER;
      hash = (53 * hash) + getBestEffortProvisioning().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.NodePool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.NodePool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.NodePool parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.NodePool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.NodePool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.NodePool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.NodePool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.NodePool parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.NodePool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.NodePool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.NodePool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * NodePool contains the name and configuration for a cluster's node pool.
   * Node pools are a set of nodes (i.e. VM's), with a common configuration and
   * specification, under the control of the cluster master. They may have a set
   * of Kubernetes labels applied to them, which may be used to reference them
   * during pod scheduling. They may also be resized up or down, to accommodate
   * the workload.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.NodePool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.NodePool)
      com.google.container.v1.NodePoolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.NodePool.class,
              com.google.container.v1.NodePool.Builder.class);
    }

    // Construct using com.google.container.v1.NodePool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
        getNetworkConfigFieldBuilder();
        getAutoscalingFieldBuilder();
        getManagementFieldBuilder();
        getMaxPodsConstraintFieldBuilder();
        getConditionsFieldBuilder();
        getUpgradeSettingsFieldBuilder();
        getPlacementPolicyFieldBuilder();
        getUpdateInfoFieldBuilder();
        getQueuedProvisioningFieldBuilder();
        getBestEffortProvisioningFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      initialNodeCount_ = 0;
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      selfLink_ = "";
      version_ = "";
      instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      status_ = 0;
      statusMessage_ = "";
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      management_ = null;
      if (managementBuilder_ != null) {
        managementBuilder_.dispose();
        managementBuilder_ = null;
      }
      maxPodsConstraint_ = null;
      if (maxPodsConstraintBuilder_ != null) {
        maxPodsConstraintBuilder_.dispose();
        maxPodsConstraintBuilder_ = null;
      }
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      podIpv4CidrSize_ = 0;
      upgradeSettings_ = null;
      if (upgradeSettingsBuilder_ != null) {
        upgradeSettingsBuilder_.dispose();
        upgradeSettingsBuilder_ = null;
      }
      placementPolicy_ = null;
      if (placementPolicyBuilder_ != null) {
        placementPolicyBuilder_.dispose();
        placementPolicyBuilder_ = null;
      }
      updateInfo_ = null;
      if (updateInfoBuilder_ != null) {
        updateInfoBuilder_.dispose();
        updateInfoBuilder_ = null;
      }
      etag_ = "";
      queuedProvisioning_ = null;
      if (queuedProvisioningBuilder_ != null) {
        queuedProvisioningBuilder_.dispose();
        queuedProvisioningBuilder_ = null;
      }
      bestEffortProvisioning_ = null;
      if (bestEffortProvisioningBuilder_ != null) {
        bestEffortProvisioningBuilder_.dispose();
        bestEffortProvisioningBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_NodePool_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.NodePool getDefaultInstanceForType() {
      return com.google.container.v1.NodePool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.NodePool build() {
      com.google.container.v1.NodePool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.NodePool buildPartial() {
      com.google.container.v1.NodePool result = new com.google.container.v1.NodePool(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.NodePool result) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.NodePool result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.initialNodeCount_ = initialNodeCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        locations_.makeImmutable();
        result.locations_ = locations_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.networkConfig_ =
            networkConfigBuilder_ == null ? networkConfig_ : networkConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.selfLink_ = selfLink_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        instanceGroupUrls_.makeImmutable();
        result.instanceGroupUrls_ = instanceGroupUrls_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.autoscaling_ =
            autoscalingBuilder_ == null ? autoscaling_ : autoscalingBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.management_ = managementBuilder_ == null ? management_ : managementBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.maxPodsConstraint_ =
            maxPodsConstraintBuilder_ == null
                ? maxPodsConstraint_
                : maxPodsConstraintBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.podIpv4CidrSize_ = podIpv4CidrSize_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.upgradeSettings_ =
            upgradeSettingsBuilder_ == null ? upgradeSettings_ : upgradeSettingsBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.placementPolicy_ =
            placementPolicyBuilder_ == null ? placementPolicy_ : placementPolicyBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.updateInfo_ = updateInfoBuilder_ == null ? updateInfo_ : updateInfoBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.queuedProvisioning_ =
            queuedProvisioningBuilder_ == null
                ? queuedProvisioning_
                : queuedProvisioningBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.bestEffortProvisioning_ =
            bestEffortProvisioningBuilder_ == null
                ? bestEffortProvisioning_
                : bestEffortProvisioningBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.NodePool) {
        return mergeFrom((com.google.container.v1.NodePool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.NodePool other) {
      if (other == com.google.container.v1.NodePool.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.getInitialNodeCount() != 0) {
        setInitialNodeCount(other.getInitialNodeCount());
      }
      if (!other.locations_.isEmpty()) {
        if (locations_.isEmpty()) {
          locations_ = other.locations_;
          bitField0_ |= 0x00000008;
        } else {
          ensureLocationsIsMutable();
          locations_.addAll(other.locations_);
        }
        onChanged();
      }
      if (other.hasNetworkConfig()) {
        mergeNetworkConfig(other.getNetworkConfig());
      }
      if (!other.getSelfLink().isEmpty()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.instanceGroupUrls_.isEmpty()) {
        if (instanceGroupUrls_.isEmpty()) {
          instanceGroupUrls_ = other.instanceGroupUrls_;
          bitField0_ |= 0x00000080;
        } else {
          ensureInstanceGroupUrlsIsMutable();
          instanceGroupUrls_.addAll(other.instanceGroupUrls_);
        }
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasAutoscaling()) {
        mergeAutoscaling(other.getAutoscaling());
      }
      if (other.hasManagement()) {
        mergeManagement(other.getManagement());
      }
      if (other.hasMaxPodsConstraint()) {
        mergeMaxPodsConstraint(other.getMaxPodsConstraint());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00002000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (other.getPodIpv4CidrSize() != 0) {
        setPodIpv4CidrSize(other.getPodIpv4CidrSize());
      }
      if (other.hasUpgradeSettings()) {
        mergeUpgradeSettings(other.getUpgradeSettings());
      }
      if (other.hasPlacementPolicy()) {
        mergePlacementPolicy(other.getPlacementPolicy());
      }
      if (other.hasUpdateInfo()) {
        mergeUpdateInfo(other.getUpdateInfo());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasQueuedProvisioning()) {
        mergeQueuedProvisioning(other.getQueuedProvisioning());
      }
      if (other.hasBestEffortProvisioning()) {
        mergeBestEffortProvisioning(other.getBestEffortProvisioning());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                initialNodeCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getManagementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getMaxPodsConstraintFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 50
            case 56:
              {
                podIpv4CidrSize_ = input.readInt32();
                bitField0_ |= 0x00004000;
                break;
              } // case 56
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationsIsMutable();
                locations_.add(s);
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getNetworkConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 114
            case 802:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 802
            case 810:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 810
            case 818:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceGroupUrlsIsMutable();
                instanceGroupUrls_.add(s);
                break;
              } // case 818
            case 824:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 824
            case 834:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 834
            case 842:
              {
                com.google.container.v1.StatusCondition m =
                    input.readMessage(
                        com.google.container.v1.StatusCondition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 842
            case 858:
              {
                input.readMessage(getUpgradeSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 858
            case 866:
              {
                input.readMessage(getPlacementPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 866
            case 874:
              {
                input.readMessage(getUpdateInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 874
            case 882:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 882
            case 898:
              {
                input.readMessage(
                    getQueuedProvisioningFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 898
            case 906:
              {
                input.readMessage(
                    getBestEffortProvisioningFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 906
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the node pool.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodeConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeConfig,
            com.google.container.v1.NodeConfig.Builder,
            com.google.container.v1.NodeConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     *
     * @return The config.
     */
    public com.google.container.v1.NodeConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null ? com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder setConfig(com.google.container.v1.NodeConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder setConfig(com.google.container.v1.NodeConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder mergeConfig(com.google.container.v1.NodeConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && config_ != null
            && config_ != com.google.container.v1.NodeConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public com.google.container.v1.NodeConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    public com.google.container.v1.NodeConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null ? com.google.container.v1.NodeConfig.getDefaultInstance() : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * The node configuration of the pool.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeConfig,
            com.google.container.v1.NodeConfig.Builder,
            com.google.container.v1.NodeConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeConfig,
                com.google.container.v1.NodeConfig.Builder,
                com.google.container.v1.NodeConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private int initialNodeCount_;
    /**
     *
     *
     * <pre>
     * The initial node count for the pool. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * </pre>
     *
     * <code>int32 initial_node_count = 3;</code>
     *
     * @return The initialNodeCount.
     */
    @java.lang.Override
    public int getInitialNodeCount() {
      return initialNodeCount_;
    }
    /**
     *
     *
     * <pre>
     * The initial node count for the pool. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * </pre>
     *
     * <code>int32 initial_node_count = 3;</code>
     *
     * @param value The initialNodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setInitialNodeCount(int value) {

      initialNodeCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial node count for the pool. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * </pre>
     *
     * <code>int32 initial_node_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInitialNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      initialNodeCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList locations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLocationsIsMutable() {
      if (!locations_.isModifiable()) {
        locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return A list containing the locations.
     */
    public com.google.protobuf.ProtocolStringList getLocationsList() {
      locations_.makeImmutable();
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return The count of locations.
     */
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The locations at the given index.
     */
    public java.lang.String getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the locations at the given index.
     */
    public com.google.protobuf.ByteString getLocationsBytes(int index) {
      return locations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The locations to set.
     * @return This builder for chaining.
     */
    public Builder setLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param value The locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param values The locations to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
      ensureLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocations() {
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes should be located.
     *
     * If this value is unspecified during node pool creation, the
     * [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
     * value will be used, instead.
     *
     * Warning: changing node pool locations will result in nodes being added
     * and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param value The bytes of the locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodeNetworkConfig networkConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeNetworkConfig,
            com.google.container.v1.NodeNetworkConfig.Builder,
            com.google.container.v1.NodeNetworkConfigOrBuilder>
        networkConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     *
     * @return Whether the networkConfig field is set.
     */
    public boolean hasNetworkConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     *
     * @return The networkConfig.
     */
    public com.google.container.v1.NodeNetworkConfig getNetworkConfig() {
      if (networkConfigBuilder_ == null) {
        return networkConfig_ == null
            ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
            : networkConfig_;
      } else {
        return networkConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    public Builder setNetworkConfig(com.google.container.v1.NodeNetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkConfig_ = value;
      } else {
        networkConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    public Builder setNetworkConfig(
        com.google.container.v1.NodeNetworkConfig.Builder builderForValue) {
      if (networkConfigBuilder_ == null) {
        networkConfig_ = builderForValue.build();
      } else {
        networkConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    public Builder mergeNetworkConfig(com.google.container.v1.NodeNetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && networkConfig_ != null
            && networkConfig_ != com.google.container.v1.NodeNetworkConfig.getDefaultInstance()) {
          getNetworkConfigBuilder().mergeFrom(value);
        } else {
          networkConfig_ = value;
        }
      } else {
        networkConfigBuilder_.mergeFrom(value);
      }
      if (networkConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    public Builder clearNetworkConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    public com.google.container.v1.NodeNetworkConfig.Builder getNetworkConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getNetworkConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    public com.google.container.v1.NodeNetworkConfigOrBuilder getNetworkConfigOrBuilder() {
      if (networkConfigBuilder_ != null) {
        return networkConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkConfig_ == null
            ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
            : networkConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Networking configuration for this NodePool. If specified, it overrides the
     * cluster-level defaults.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig network_config = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeNetworkConfig,
            com.google.container.v1.NodeNetworkConfig.Builder,
            com.google.container.v1.NodeNetworkConfigOrBuilder>
        getNetworkConfigFieldBuilder() {
      if (networkConfigBuilder_ == null) {
        networkConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeNetworkConfig,
                com.google.container.v1.NodeNetworkConfig.Builder,
                com.google.container.v1.NodeNetworkConfigOrBuilder>(
                getNetworkConfig(), getParentForChildren(), isClean());
        networkConfig_ = null;
      }
      return networkConfigBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The version of Kubernetes running on this NodePool's nodes. If unspecified,
     * it defaults as described
     * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
     * </pre>
     *
     * <code>string version = 101;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of Kubernetes running on this NodePool's nodes. If unspecified,
     * it defaults as described
     * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
     * </pre>
     *
     * <code>string version = 101;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of Kubernetes running on this NodePool's nodes. If unspecified,
     * it defaults as described
     * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
     * </pre>
     *
     * <code>string version = 101;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of Kubernetes running on this NodePool's nodes. If unspecified,
     * it defaults as described
     * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
     * </pre>
     *
     * <code>string version = 101;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of Kubernetes running on this NodePool's nodes. If unspecified,
     * it defaults as described
     * [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
     * </pre>
     *
     * <code>string version = 101;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList instanceGroupUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstanceGroupUrlsIsMutable() {
      if (!instanceGroupUrls_.isModifiable()) {
        instanceGroupUrls_ = new com.google.protobuf.LazyStringArrayList(instanceGroupUrls_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the instanceGroupUrls.
     */
    public com.google.protobuf.ProtocolStringList getInstanceGroupUrlsList() {
      instanceGroupUrls_.makeImmutable();
      return instanceGroupUrls_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of instanceGroupUrls.
     */
    public int getInstanceGroupUrlsCount() {
      return instanceGroupUrls_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The instanceGroupUrls at the given index.
     */
    public java.lang.String getInstanceGroupUrls(int index) {
      return instanceGroupUrls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instanceGroupUrls at the given index.
     */
    public com.google.protobuf.ByteString getInstanceGroupUrlsBytes(int index) {
      return instanceGroupUrls_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The instanceGroupUrls to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupUrls(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The instanceGroupUrls to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceGroupUrls(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The instanceGroupUrls to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstanceGroupUrls(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceGroupUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceGroupUrls_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceGroupUrls() {
      instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource URLs of the [managed instance
     * groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
     * associated with this node pool.
     * During the node pool blue-green upgrade operation, the URLs contain both
     * blue and green resources.
     * </pre>
     *
     * <code>repeated string instance_group_urls = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the instanceGroupUrls to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceGroupUrlsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.container.v1.NodePool.Status getStatus() {
      com.google.container.v1.NodePool.Status result =
          com.google.container.v1.NodePool.Status.forNumber(status_);
      return result == null ? com.google.container.v1.NodePool.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.container.v1.NodePool.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the nodes in this pool instance.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.Status status = 103 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000100);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>
     * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.NodePool.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3712
     * @return The statusMessage.
     */
    @java.lang.Deprecated
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>
     * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.NodePool.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3712
     * @return The bytes for statusMessage.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>
     * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.NodePool.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3712
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>
     * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.NodePool.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3712
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * node pool instance, if available.
     * </pre>
     *
     * <code>
     * string status_message = 104 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.NodePool.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3712
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodePoolAutoscaling autoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoscaling,
            com.google.container.v1.NodePoolAutoscaling.Builder,
            com.google.container.v1.NodePoolAutoscalingOrBuilder>
        autoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     *
     * @return Whether the autoscaling field is set.
     */
    public boolean hasAutoscaling() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     *
     * @return The autoscaling.
     */
    public com.google.container.v1.NodePoolAutoscaling getAutoscaling() {
      if (autoscalingBuilder_ == null) {
        return autoscaling_ == null
            ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
            : autoscaling_;
      } else {
        return autoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder setAutoscaling(com.google.container.v1.NodePoolAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaling_ = value;
      } else {
        autoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder setAutoscaling(
        com.google.container.v1.NodePoolAutoscaling.Builder builderForValue) {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = builderForValue.build();
      } else {
        autoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder mergeAutoscaling(com.google.container.v1.NodePoolAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && autoscaling_ != null
            && autoscaling_ != com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()) {
          getAutoscalingBuilder().mergeFrom(value);
        } else {
          autoscaling_ = value;
        }
      } else {
        autoscalingBuilder_.mergeFrom(value);
      }
      if (autoscaling_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public Builder clearAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00000400);
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public com.google.container.v1.NodePoolAutoscaling.Builder getAutoscalingBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    public com.google.container.v1.NodePoolAutoscalingOrBuilder getAutoscalingOrBuilder() {
      if (autoscalingBuilder_ != null) {
        return autoscalingBuilder_.getMessageOrBuilder();
      } else {
        return autoscaling_ == null
            ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
            : autoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for this NodePool. Autoscaler is enabled
     * only if a valid configuration is present.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoscaling autoscaling = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoscaling,
            com.google.container.v1.NodePoolAutoscaling.Builder,
            com.google.container.v1.NodePoolAutoscalingOrBuilder>
        getAutoscalingFieldBuilder() {
      if (autoscalingBuilder_ == null) {
        autoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePoolAutoscaling,
                com.google.container.v1.NodePoolAutoscaling.Builder,
                com.google.container.v1.NodePoolAutoscalingOrBuilder>(
                getAutoscaling(), getParentForChildren(), isClean());
        autoscaling_ = null;
      }
      return autoscalingBuilder_;
    }

    private com.google.container.v1.NodeManagement management_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeManagement,
            com.google.container.v1.NodeManagement.Builder,
            com.google.container.v1.NodeManagementOrBuilder>
        managementBuilder_;
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     *
     * @return Whether the management field is set.
     */
    public boolean hasManagement() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     *
     * @return The management.
     */
    public com.google.container.v1.NodeManagement getManagement() {
      if (managementBuilder_ == null) {
        return management_ == null
            ? com.google.container.v1.NodeManagement.getDefaultInstance()
            : management_;
      } else {
        return managementBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder setManagement(com.google.container.v1.NodeManagement value) {
      if (managementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        management_ = value;
      } else {
        managementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder setManagement(com.google.container.v1.NodeManagement.Builder builderForValue) {
      if (managementBuilder_ == null) {
        management_ = builderForValue.build();
      } else {
        managementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder mergeManagement(com.google.container.v1.NodeManagement value) {
      if (managementBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && management_ != null
            && management_ != com.google.container.v1.NodeManagement.getDefaultInstance()) {
          getManagementBuilder().mergeFrom(value);
        } else {
          management_ = value;
        }
      } else {
        managementBuilder_.mergeFrom(value);
      }
      if (management_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public Builder clearManagement() {
      bitField0_ = (bitField0_ & ~0x00000800);
      management_ = null;
      if (managementBuilder_ != null) {
        managementBuilder_.dispose();
        managementBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public com.google.container.v1.NodeManagement.Builder getManagementBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getManagementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    public com.google.container.v1.NodeManagementOrBuilder getManagementOrBuilder() {
      if (managementBuilder_ != null) {
        return managementBuilder_.getMessageOrBuilder();
      } else {
        return management_ == null
            ? com.google.container.v1.NodeManagement.getDefaultInstance()
            : management_;
      }
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1.NodeManagement management = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeManagement,
            com.google.container.v1.NodeManagement.Builder,
            com.google.container.v1.NodeManagementOrBuilder>
        getManagementFieldBuilder() {
      if (managementBuilder_ == null) {
        managementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeManagement,
                com.google.container.v1.NodeManagement.Builder,
                com.google.container.v1.NodeManagementOrBuilder>(
                getManagement(), getParentForChildren(), isClean());
        management_ = null;
      }
      return managementBuilder_;
    }

    private com.google.container.v1.MaxPodsConstraint maxPodsConstraint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MaxPodsConstraint,
            com.google.container.v1.MaxPodsConstraint.Builder,
            com.google.container.v1.MaxPodsConstraintOrBuilder>
        maxPodsConstraintBuilder_;
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     *
     * @return Whether the maxPodsConstraint field is set.
     */
    public boolean hasMaxPodsConstraint() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     *
     * @return The maxPodsConstraint.
     */
    public com.google.container.v1.MaxPodsConstraint getMaxPodsConstraint() {
      if (maxPodsConstraintBuilder_ == null) {
        return maxPodsConstraint_ == null
            ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
            : maxPodsConstraint_;
      } else {
        return maxPodsConstraintBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    public Builder setMaxPodsConstraint(com.google.container.v1.MaxPodsConstraint value) {
      if (maxPodsConstraintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxPodsConstraint_ = value;
      } else {
        maxPodsConstraintBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    public Builder setMaxPodsConstraint(
        com.google.container.v1.MaxPodsConstraint.Builder builderForValue) {
      if (maxPodsConstraintBuilder_ == null) {
        maxPodsConstraint_ = builderForValue.build();
      } else {
        maxPodsConstraintBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    public Builder mergeMaxPodsConstraint(com.google.container.v1.MaxPodsConstraint value) {
      if (maxPodsConstraintBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && maxPodsConstraint_ != null
            && maxPodsConstraint_
                != com.google.container.v1.MaxPodsConstraint.getDefaultInstance()) {
          getMaxPodsConstraintBuilder().mergeFrom(value);
        } else {
          maxPodsConstraint_ = value;
        }
      } else {
        maxPodsConstraintBuilder_.mergeFrom(value);
      }
      if (maxPodsConstraint_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    public Builder clearMaxPodsConstraint() {
      bitField0_ = (bitField0_ & ~0x00001000);
      maxPodsConstraint_ = null;
      if (maxPodsConstraintBuilder_ != null) {
        maxPodsConstraintBuilder_.dispose();
        maxPodsConstraintBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    public com.google.container.v1.MaxPodsConstraint.Builder getMaxPodsConstraintBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getMaxPodsConstraintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    public com.google.container.v1.MaxPodsConstraintOrBuilder getMaxPodsConstraintOrBuilder() {
      if (maxPodsConstraintBuilder_ != null) {
        return maxPodsConstraintBuilder_.getMessageOrBuilder();
      } else {
        return maxPodsConstraint_ == null
            ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
            : maxPodsConstraint_;
      }
    }
    /**
     *
     *
     * <pre>
     * The constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint max_pods_constraint = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MaxPodsConstraint,
            com.google.container.v1.MaxPodsConstraint.Builder,
            com.google.container.v1.MaxPodsConstraintOrBuilder>
        getMaxPodsConstraintFieldBuilder() {
      if (maxPodsConstraintBuilder_ == null) {
        maxPodsConstraintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MaxPodsConstraint,
                com.google.container.v1.MaxPodsConstraint.Builder,
                com.google.container.v1.MaxPodsConstraintOrBuilder>(
                getMaxPodsConstraint(), getParentForChildren(), isClean());
        maxPodsConstraint_ = null;
      }
      return maxPodsConstraintBuilder_;
    }

    private java.util.List<com.google.container.v1.StatusCondition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.container.v1.StatusCondition>(conditions_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public java.util.List<com.google.container.v1.StatusCondition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public com.google.container.v1.StatusCondition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder setConditions(int index, com.google.container.v1.StatusCondition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder setConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder addConditions(com.google.container.v1.StatusCondition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder addConditions(int index, com.google.container.v1.StatusCondition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder addConditions(com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder addConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.container.v1.StatusCondition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public com.google.container.v1.StatusCondition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public com.google.container.v1.StatusConditionOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public com.google.container.v1.StatusCondition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public com.google.container.v1.StatusCondition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 105;</code>
     */
    public java.util.List<com.google.container.v1.StatusCondition.Builder>
        getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.StatusCondition,
                com.google.container.v1.StatusCondition.Builder,
                com.google.container.v1.StatusConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private int podIpv4CidrSize_;
    /**
     *
     *
     * <pre>
     * Output only. The pod CIDR block size per node in this node pool.
     * </pre>
     *
     * <code>int32 pod_ipv4_cidr_size = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The podIpv4CidrSize.
     */
    @java.lang.Override
    public int getPodIpv4CidrSize() {
      return podIpv4CidrSize_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pod CIDR block size per node in this node pool.
     * </pre>
     *
     * <code>int32 pod_ipv4_cidr_size = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The podIpv4CidrSize to set.
     * @return This builder for chaining.
     */
    public Builder setPodIpv4CidrSize(int value) {

      podIpv4CidrSize_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The pod CIDR block size per node in this node pool.
     * </pre>
     *
     * <code>int32 pod_ipv4_cidr_size = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPodIpv4CidrSize() {
      bitField0_ = (bitField0_ & ~0x00004000);
      podIpv4CidrSize_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodePool.UpgradeSettings upgradeSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.UpgradeSettings,
            com.google.container.v1.NodePool.UpgradeSettings.Builder,
            com.google.container.v1.NodePool.UpgradeSettingsOrBuilder>
        upgradeSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     *
     * @return Whether the upgradeSettings field is set.
     */
    public boolean hasUpgradeSettings() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     *
     * @return The upgradeSettings.
     */
    public com.google.container.v1.NodePool.UpgradeSettings getUpgradeSettings() {
      if (upgradeSettingsBuilder_ == null) {
        return upgradeSettings_ == null
            ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
            : upgradeSettings_;
      } else {
        return upgradeSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    public Builder setUpgradeSettings(com.google.container.v1.NodePool.UpgradeSettings value) {
      if (upgradeSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upgradeSettings_ = value;
      } else {
        upgradeSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    public Builder setUpgradeSettings(
        com.google.container.v1.NodePool.UpgradeSettings.Builder builderForValue) {
      if (upgradeSettingsBuilder_ == null) {
        upgradeSettings_ = builderForValue.build();
      } else {
        upgradeSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    public Builder mergeUpgradeSettings(com.google.container.v1.NodePool.UpgradeSettings value) {
      if (upgradeSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && upgradeSettings_ != null
            && upgradeSettings_
                != com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()) {
          getUpgradeSettingsBuilder().mergeFrom(value);
        } else {
          upgradeSettings_ = value;
        }
      } else {
        upgradeSettingsBuilder_.mergeFrom(value);
      }
      if (upgradeSettings_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    public Builder clearUpgradeSettings() {
      bitField0_ = (bitField0_ & ~0x00008000);
      upgradeSettings_ = null;
      if (upgradeSettingsBuilder_ != null) {
        upgradeSettingsBuilder_.dispose();
        upgradeSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    public com.google.container.v1.NodePool.UpgradeSettings.Builder getUpgradeSettingsBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getUpgradeSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    public com.google.container.v1.NodePool.UpgradeSettingsOrBuilder getUpgradeSettingsOrBuilder() {
      if (upgradeSettingsBuilder_ != null) {
        return upgradeSettingsBuilder_.getMessageOrBuilder();
      } else {
        return upgradeSettings_ == null
            ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
            : upgradeSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 107;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.UpgradeSettings,
            com.google.container.v1.NodePool.UpgradeSettings.Builder,
            com.google.container.v1.NodePool.UpgradeSettingsOrBuilder>
        getUpgradeSettingsFieldBuilder() {
      if (upgradeSettingsBuilder_ == null) {
        upgradeSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePool.UpgradeSettings,
                com.google.container.v1.NodePool.UpgradeSettings.Builder,
                com.google.container.v1.NodePool.UpgradeSettingsOrBuilder>(
                getUpgradeSettings(), getParentForChildren(), isClean());
        upgradeSettings_ = null;
      }
      return upgradeSettingsBuilder_;
    }

    private com.google.container.v1.NodePool.PlacementPolicy placementPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.PlacementPolicy,
            com.google.container.v1.NodePool.PlacementPolicy.Builder,
            com.google.container.v1.NodePool.PlacementPolicyOrBuilder>
        placementPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     *
     * @return Whether the placementPolicy field is set.
     */
    public boolean hasPlacementPolicy() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     *
     * @return The placementPolicy.
     */
    public com.google.container.v1.NodePool.PlacementPolicy getPlacementPolicy() {
      if (placementPolicyBuilder_ == null) {
        return placementPolicy_ == null
            ? com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance()
            : placementPolicy_;
      } else {
        return placementPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    public Builder setPlacementPolicy(com.google.container.v1.NodePool.PlacementPolicy value) {
      if (placementPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        placementPolicy_ = value;
      } else {
        placementPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    public Builder setPlacementPolicy(
        com.google.container.v1.NodePool.PlacementPolicy.Builder builderForValue) {
      if (placementPolicyBuilder_ == null) {
        placementPolicy_ = builderForValue.build();
      } else {
        placementPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    public Builder mergePlacementPolicy(com.google.container.v1.NodePool.PlacementPolicy value) {
      if (placementPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && placementPolicy_ != null
            && placementPolicy_
                != com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance()) {
          getPlacementPolicyBuilder().mergeFrom(value);
        } else {
          placementPolicy_ = value;
        }
      } else {
        placementPolicyBuilder_.mergeFrom(value);
      }
      if (placementPolicy_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    public Builder clearPlacementPolicy() {
      bitField0_ = (bitField0_ & ~0x00010000);
      placementPolicy_ = null;
      if (placementPolicyBuilder_ != null) {
        placementPolicyBuilder_.dispose();
        placementPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    public com.google.container.v1.NodePool.PlacementPolicy.Builder getPlacementPolicyBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getPlacementPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    public com.google.container.v1.NodePool.PlacementPolicyOrBuilder getPlacementPolicyOrBuilder() {
      if (placementPolicyBuilder_ != null) {
        return placementPolicyBuilder_.getMessageOrBuilder();
      } else {
        return placementPolicy_ == null
            ? com.google.container.v1.NodePool.PlacementPolicy.getDefaultInstance()
            : placementPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the node placement policy.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.PlacementPolicy placement_policy = 108;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.PlacementPolicy,
            com.google.container.v1.NodePool.PlacementPolicy.Builder,
            com.google.container.v1.NodePool.PlacementPolicyOrBuilder>
        getPlacementPolicyFieldBuilder() {
      if (placementPolicyBuilder_ == null) {
        placementPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePool.PlacementPolicy,
                com.google.container.v1.NodePool.PlacementPolicy.Builder,
                com.google.container.v1.NodePool.PlacementPolicyOrBuilder>(
                getPlacementPolicy(), getParentForChildren(), isClean());
        placementPolicy_ = null;
      }
      return placementPolicyBuilder_;
    }

    private com.google.container.v1.NodePool.UpdateInfo updateInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.UpdateInfo,
            com.google.container.v1.NodePool.UpdateInfo.Builder,
            com.google.container.v1.NodePool.UpdateInfoOrBuilder>
        updateInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateInfo field is set.
     */
    public boolean hasUpdateInfo() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateInfo.
     */
    public com.google.container.v1.NodePool.UpdateInfo getUpdateInfo() {
      if (updateInfoBuilder_ == null) {
        return updateInfo_ == null
            ? com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance()
            : updateInfo_;
      } else {
        return updateInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateInfo(com.google.container.v1.NodePool.UpdateInfo value) {
      if (updateInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateInfo_ = value;
      } else {
        updateInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateInfo(
        com.google.container.v1.NodePool.UpdateInfo.Builder builderForValue) {
      if (updateInfoBuilder_ == null) {
        updateInfo_ = builderForValue.build();
      } else {
        updateInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateInfo(com.google.container.v1.NodePool.UpdateInfo value) {
      if (updateInfoBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && updateInfo_ != null
            && updateInfo_ != com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance()) {
          getUpdateInfoBuilder().mergeFrom(value);
        } else {
          updateInfo_ = value;
        }
      } else {
        updateInfoBuilder_.mergeFrom(value);
      }
      if (updateInfo_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateInfo() {
      bitField0_ = (bitField0_ & ~0x00020000);
      updateInfo_ = null;
      if (updateInfoBuilder_ != null) {
        updateInfoBuilder_.dispose();
        updateInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.NodePool.UpdateInfo.Builder getUpdateInfoBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getUpdateInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.NodePool.UpdateInfoOrBuilder getUpdateInfoOrBuilder() {
      if (updateInfoBuilder_ != null) {
        return updateInfoBuilder_.getMessageOrBuilder();
      } else {
        return updateInfo_ == null
            ? com.google.container.v1.NodePool.UpdateInfo.getDefaultInstance()
            : updateInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update info contains relevant information during a node
     * pool update.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePool.UpdateInfo update_info = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.UpdateInfo,
            com.google.container.v1.NodePool.UpdateInfo.Builder,
            com.google.container.v1.NodePool.UpdateInfoOrBuilder>
        getUpdateInfoFieldBuilder() {
      if (updateInfoBuilder_ == null) {
        updateInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePool.UpdateInfo,
                com.google.container.v1.NodePool.UpdateInfo.Builder,
                com.google.container.v1.NodePool.UpdateInfoOrBuilder>(
                getUpdateInfo(), getParentForChildren(), isClean());
        updateInfo_ = null;
      }
      return updateInfoBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of node pool
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 110;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of node pool
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 110;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of node pool
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 110;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of node pool
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 110;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of node pool
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 110;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodePool.QueuedProvisioning queuedProvisioning_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.QueuedProvisioning,
            com.google.container.v1.NodePool.QueuedProvisioning.Builder,
            com.google.container.v1.NodePool.QueuedProvisioningOrBuilder>
        queuedProvisioningBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     *
     * @return Whether the queuedProvisioning field is set.
     */
    public boolean hasQueuedProvisioning() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     *
     * @return The queuedProvisioning.
     */
    public com.google.container.v1.NodePool.QueuedProvisioning getQueuedProvisioning() {
      if (queuedProvisioningBuilder_ == null) {
        return queuedProvisioning_ == null
            ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
            : queuedProvisioning_;
      } else {
        return queuedProvisioningBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    public Builder setQueuedProvisioning(
        com.google.container.v1.NodePool.QueuedProvisioning value) {
      if (queuedProvisioningBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queuedProvisioning_ = value;
      } else {
        queuedProvisioningBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    public Builder setQueuedProvisioning(
        com.google.container.v1.NodePool.QueuedProvisioning.Builder builderForValue) {
      if (queuedProvisioningBuilder_ == null) {
        queuedProvisioning_ = builderForValue.build();
      } else {
        queuedProvisioningBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    public Builder mergeQueuedProvisioning(
        com.google.container.v1.NodePool.QueuedProvisioning value) {
      if (queuedProvisioningBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && queuedProvisioning_ != null
            && queuedProvisioning_
                != com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()) {
          getQueuedProvisioningBuilder().mergeFrom(value);
        } else {
          queuedProvisioning_ = value;
        }
      } else {
        queuedProvisioningBuilder_.mergeFrom(value);
      }
      if (queuedProvisioning_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    public Builder clearQueuedProvisioning() {
      bitField0_ = (bitField0_ & ~0x00080000);
      queuedProvisioning_ = null;
      if (queuedProvisioningBuilder_ != null) {
        queuedProvisioningBuilder_.dispose();
        queuedProvisioningBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    public com.google.container.v1.NodePool.QueuedProvisioning.Builder
        getQueuedProvisioningBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getQueuedProvisioningFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    public com.google.container.v1.NodePool.QueuedProvisioningOrBuilder
        getQueuedProvisioningOrBuilder() {
      if (queuedProvisioningBuilder_ != null) {
        return queuedProvisioningBuilder_.getMessageOrBuilder();
      } else {
        return queuedProvisioning_ == null
            ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
            : queuedProvisioning_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 112;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.QueuedProvisioning,
            com.google.container.v1.NodePool.QueuedProvisioning.Builder,
            com.google.container.v1.NodePool.QueuedProvisioningOrBuilder>
        getQueuedProvisioningFieldBuilder() {
      if (queuedProvisioningBuilder_ == null) {
        queuedProvisioningBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePool.QueuedProvisioning,
                com.google.container.v1.NodePool.QueuedProvisioning.Builder,
                com.google.container.v1.NodePool.QueuedProvisioningOrBuilder>(
                getQueuedProvisioning(), getParentForChildren(), isClean());
        queuedProvisioning_ = null;
      }
      return queuedProvisioningBuilder_;
    }

    private com.google.container.v1.BestEffortProvisioning bestEffortProvisioning_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.BestEffortProvisioning,
            com.google.container.v1.BestEffortProvisioning.Builder,
            com.google.container.v1.BestEffortProvisioningOrBuilder>
        bestEffortProvisioningBuilder_;
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     *
     * @return Whether the bestEffortProvisioning field is set.
     */
    public boolean hasBestEffortProvisioning() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     *
     * @return The bestEffortProvisioning.
     */
    public com.google.container.v1.BestEffortProvisioning getBestEffortProvisioning() {
      if (bestEffortProvisioningBuilder_ == null) {
        return bestEffortProvisioning_ == null
            ? com.google.container.v1.BestEffortProvisioning.getDefaultInstance()
            : bestEffortProvisioning_;
      } else {
        return bestEffortProvisioningBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    public Builder setBestEffortProvisioning(com.google.container.v1.BestEffortProvisioning value) {
      if (bestEffortProvisioningBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bestEffortProvisioning_ = value;
      } else {
        bestEffortProvisioningBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    public Builder setBestEffortProvisioning(
        com.google.container.v1.BestEffortProvisioning.Builder builderForValue) {
      if (bestEffortProvisioningBuilder_ == null) {
        bestEffortProvisioning_ = builderForValue.build();
      } else {
        bestEffortProvisioningBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    public Builder mergeBestEffortProvisioning(
        com.google.container.v1.BestEffortProvisioning value) {
      if (bestEffortProvisioningBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && bestEffortProvisioning_ != null
            && bestEffortProvisioning_
                != com.google.container.v1.BestEffortProvisioning.getDefaultInstance()) {
          getBestEffortProvisioningBuilder().mergeFrom(value);
        } else {
          bestEffortProvisioning_ = value;
        }
      } else {
        bestEffortProvisioningBuilder_.mergeFrom(value);
      }
      if (bestEffortProvisioning_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    public Builder clearBestEffortProvisioning() {
      bitField0_ = (bitField0_ & ~0x00100000);
      bestEffortProvisioning_ = null;
      if (bestEffortProvisioningBuilder_ != null) {
        bestEffortProvisioningBuilder_.dispose();
        bestEffortProvisioningBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    public com.google.container.v1.BestEffortProvisioning.Builder
        getBestEffortProvisioningBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getBestEffortProvisioningFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    public com.google.container.v1.BestEffortProvisioningOrBuilder
        getBestEffortProvisioningOrBuilder() {
      if (bestEffortProvisioningBuilder_ != null) {
        return bestEffortProvisioningBuilder_.getMessageOrBuilder();
      } else {
        return bestEffortProvisioning_ == null
            ? com.google.container.v1.BestEffortProvisioning.getDefaultInstance()
            : bestEffortProvisioning_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable best effort provisioning for nodes
     * </pre>
     *
     * <code>.google.container.v1.BestEffortProvisioning best_effort_provisioning = 113;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.BestEffortProvisioning,
            com.google.container.v1.BestEffortProvisioning.Builder,
            com.google.container.v1.BestEffortProvisioningOrBuilder>
        getBestEffortProvisioningFieldBuilder() {
      if (bestEffortProvisioningBuilder_ == null) {
        bestEffortProvisioningBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.BestEffortProvisioning,
                com.google.container.v1.BestEffortProvisioning.Builder,
                com.google.container.v1.BestEffortProvisioningOrBuilder>(
                getBestEffortProvisioning(), getParentForChildren(), isClean());
        bestEffortProvisioning_ = null;
      }
      return bestEffortProvisioningBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.NodePool)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.NodePool)
  private static final com.google.container.v1.NodePool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.NodePool();
  }

  public static com.google.container.v1.NodePool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodePool> PARSER =
      new com.google.protobuf.AbstractParser<NodePool>() {
        @java.lang.Override
        public NodePool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodePool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodePool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.NodePool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
