/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * This operation resource represents operations that may have happened or are
 * happening on the cluster. All fields are output only.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.Operation}
 */
public final class Operation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.Operation)
    OperationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Operation.newBuilder() to construct.
  private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Operation() {
    name_ = "";
    zone_ = "";
    operationType_ = 0;
    status_ = 0;
    detail_ = "";
    statusMessage_ = "";
    selfLink_ = "";
    targetLink_ = "";
    location_ = "";
    startTime_ = "";
    endTime_ = "";
    clusterConditions_ = java.util.Collections.emptyList();
    nodepoolConditions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Operation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_Operation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_Operation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.Operation.class,
            com.google.container.v1.Operation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Current status of the operation.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.Operation.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The operation has been created.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The operation is currently running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The operation is done, either cancelled or completed.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    DONE(3),
    /**
     *
     *
     * <pre>
     * The operation is aborting.
     * </pre>
     *
     * <code>ABORTING = 4;</code>
     */
    ABORTING(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The operation has been created.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The operation is currently running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The operation is done, either cancelled or completed.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    public static final int DONE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The operation is aborting.
     * </pre>
     *
     * <code>ABORTING = 4;</code>
     */
    public static final int ABORTING_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return DONE;
        case 4:
          return ABORTING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.Operation.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.Operation.Status)
  }

  /**
   *
   *
   * <pre>
   * Operation type categorizes the operation.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.Operation.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The cluster is being created. The cluster should be assumed to be
     * unusable until the operation finishes.
     *
     * In the event of the operation failing, the cluster will enter the [ERROR
     * state][Cluster.Status.ERROR] and eventually be deleted.
     * </pre>
     *
     * <code>CREATE_CLUSTER = 1;</code>
     */
    CREATE_CLUSTER(1),
    /**
     *
     *
     * <pre>
     * The cluster is being deleted. The cluster should be assumed to be
     * unusable as soon as this operation starts.
     *
     * In the event of the operation failing, the cluster will enter the [ERROR
     * state][Cluster.Status.ERROR] and the deletion will be automatically
     * retried until completed.
     * </pre>
     *
     * <code>DELETE_CLUSTER = 2;</code>
     */
    DELETE_CLUSTER(2),
    /**
     *
     *
     * <pre>
     * The [cluster
     * version][google.container.v1.ClusterUpdate.desired_master_version] is
     * being updated. Note that this includes "upgrades" to the same version,
     * which are simply a recreation. This also includes
     * [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#upgrading_automatically).
     * For more details, see [documentation on cluster
     * upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#cluster_upgrades).
     * </pre>
     *
     * <code>UPGRADE_MASTER = 3;</code>
     */
    UPGRADE_MASTER(3),
    /**
     *
     *
     * <pre>
     * A node pool is being updated. Despite calling this an "upgrade", this
     * includes most forms of updates to node pools. This also includes
     * [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-upgrades).
     *
     * This operation sets the
     * [progress][google.container.v1.Operation.progress] field and may be
     * [canceled][google.container.v1.ClusterManager.CancelOperation].
     *
     * The upgrade strategy depends on [node pool
     * configuration](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pool-upgrade-strategies).
     * The nodes are generally still usable during this operation.
     * </pre>
     *
     * <code>UPGRADE_NODES = 4;</code>
     */
    UPGRADE_NODES(4),
    /**
     *
     *
     * <pre>
     * A problem has been detected with the control plane and is being repaired.
     * This operation type is initiated by GKE. For more details, see
     * [documentation on
     * repairs](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
     * </pre>
     *
     * <code>REPAIR_CLUSTER = 5;</code>
     */
    REPAIR_CLUSTER(5),
    /**
     *
     *
     * <pre>
     * The cluster is being updated. This is a broad category of operations and
     * includes operations that only change metadata as well as those that must
     * recreate the entire cluster. If the control plane must be recreated, this
     * will cause temporary downtime for zonal clusters.
     *
     * Some features require recreating the nodes as well. Those will be
     * recreated as separate operations and the update may not be completely
     * functional until the node pools recreations finish. Node recreations will
     * generally follow [maintenance
     * policies](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions).
     *
     * Some GKE-initiated operations use this type. This includes certain types
     * of auto-upgrades and incident mitigations.
     * </pre>
     *
     * <code>UPDATE_CLUSTER = 6;</code>
     */
    UPDATE_CLUSTER(6),
    /**
     *
     *
     * <pre>
     * A node pool is being created. The node pool should be assumed to be
     * unusable until this operation finishes. In the event of an error, the
     * node pool may be partially created.
     *
     * If enabled, [node
     * autoprovisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
     * may have automatically initiated such operations.
     * </pre>
     *
     * <code>CREATE_NODE_POOL = 7;</code>
     */
    CREATE_NODE_POOL(7),
    /**
     *
     *
     * <pre>
     * The node pool is being deleted. The node pool should be assumed to be
     * unusable as soon as this operation starts.
     * </pre>
     *
     * <code>DELETE_NODE_POOL = 8;</code>
     */
    DELETE_NODE_POOL(8),
    /**
     *
     *
     * <pre>
     * The node pool's [manamagent][google.container.v1.NodePool.management]
     * field is being updated. These operations only update metadata and may be
     * concurrent with most other operations.
     * </pre>
     *
     * <code>SET_NODE_POOL_MANAGEMENT = 9;</code>
     */
    SET_NODE_POOL_MANAGEMENT(9),
    /**
     *
     *
     * <pre>
     * A problem has been detected with nodes and [they are being
     * repaired](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-repair).
     * This operation type is initiated by GKE, typically automatically. This
     * operation may be concurrent with other operations and there may be
     * multiple repairs occurring on the same node pool.
     * </pre>
     *
     * <code>AUTO_REPAIR_NODES = 10;</code>
     */
    AUTO_REPAIR_NODES(10),
    /**
     *
     *
     * <pre>
     * Unused. Automatic node upgrade uses
     * [UPGRADE_NODES][google.container.v1.Operation.Type.UPGRADE_NODES].
     * </pre>
     *
     * <code>AUTO_UPGRADE_NODES = 11 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    AUTO_UPGRADE_NODES(11),
    /**
     *
     *
     * <pre>
     * Unused. Updating labels uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_LABELS = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    SET_LABELS(12),
    /**
     *
     *
     * <pre>
     * Unused. Updating master auth uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_MASTER_AUTH = 13 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    SET_MASTER_AUTH(13),
    /**
     *
     *
     * <pre>
     * The node pool is being resized. With the exception of resizing to or from
     * size zero, the node pool is generally usable during this operation.
     * </pre>
     *
     * <code>SET_NODE_POOL_SIZE = 14;</code>
     */
    SET_NODE_POOL_SIZE(14),
    /**
     *
     *
     * <pre>
     * Unused. Updating network policy uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_NETWORK_POLICY = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    SET_NETWORK_POLICY(15),
    /**
     *
     *
     * <pre>
     * Unused. Updating maintenance policy uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_MAINTENANCE_POLICY = 16 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    SET_MAINTENANCE_POLICY(16),
    /**
     *
     *
     * <pre>
     * The control plane is being resized. This operation type is initiated by
     * GKE. These operations are often performed preemptively to ensure that the
     * control plane has sufficient resources and is not typically an indication
     * of issues. For more details, see
     * [documentation on
     * resizes](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
     * </pre>
     *
     * <code>RESIZE_CLUSTER = 18;</code>
     */
    RESIZE_CLUSTER(18),
    /**
     *
     *
     * <pre>
     * Fleet features of GKE Enterprise are being upgraded. The cluster should
     * be assumed to be blocked for other upgrades until the operation finishes.
     * </pre>
     *
     * <code>FLEET_FEATURE_UPGRADE = 19;</code>
     */
    FLEET_FEATURE_UPGRADE(19),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The cluster is being created. The cluster should be assumed to be
     * unusable until the operation finishes.
     *
     * In the event of the operation failing, the cluster will enter the [ERROR
     * state][Cluster.Status.ERROR] and eventually be deleted.
     * </pre>
     *
     * <code>CREATE_CLUSTER = 1;</code>
     */
    public static final int CREATE_CLUSTER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The cluster is being deleted. The cluster should be assumed to be
     * unusable as soon as this operation starts.
     *
     * In the event of the operation failing, the cluster will enter the [ERROR
     * state][Cluster.Status.ERROR] and the deletion will be automatically
     * retried until completed.
     * </pre>
     *
     * <code>DELETE_CLUSTER = 2;</code>
     */
    public static final int DELETE_CLUSTER_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The [cluster
     * version][google.container.v1.ClusterUpdate.desired_master_version] is
     * being updated. Note that this includes "upgrades" to the same version,
     * which are simply a recreation. This also includes
     * [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#upgrading_automatically).
     * For more details, see [documentation on cluster
     * upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#cluster_upgrades).
     * </pre>
     *
     * <code>UPGRADE_MASTER = 3;</code>
     */
    public static final int UPGRADE_MASTER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A node pool is being updated. Despite calling this an "upgrade", this
     * includes most forms of updates to node pools. This also includes
     * [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-upgrades).
     *
     * This operation sets the
     * [progress][google.container.v1.Operation.progress] field and may be
     * [canceled][google.container.v1.ClusterManager.CancelOperation].
     *
     * The upgrade strategy depends on [node pool
     * configuration](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pool-upgrade-strategies).
     * The nodes are generally still usable during this operation.
     * </pre>
     *
     * <code>UPGRADE_NODES = 4;</code>
     */
    public static final int UPGRADE_NODES_VALUE = 4;
    /**
     *
     *
     * <pre>
     * A problem has been detected with the control plane and is being repaired.
     * This operation type is initiated by GKE. For more details, see
     * [documentation on
     * repairs](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
     * </pre>
     *
     * <code>REPAIR_CLUSTER = 5;</code>
     */
    public static final int REPAIR_CLUSTER_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The cluster is being updated. This is a broad category of operations and
     * includes operations that only change metadata as well as those that must
     * recreate the entire cluster. If the control plane must be recreated, this
     * will cause temporary downtime for zonal clusters.
     *
     * Some features require recreating the nodes as well. Those will be
     * recreated as separate operations and the update may not be completely
     * functional until the node pools recreations finish. Node recreations will
     * generally follow [maintenance
     * policies](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions).
     *
     * Some GKE-initiated operations use this type. This includes certain types
     * of auto-upgrades and incident mitigations.
     * </pre>
     *
     * <code>UPDATE_CLUSTER = 6;</code>
     */
    public static final int UPDATE_CLUSTER_VALUE = 6;
    /**
     *
     *
     * <pre>
     * A node pool is being created. The node pool should be assumed to be
     * unusable until this operation finishes. In the event of an error, the
     * node pool may be partially created.
     *
     * If enabled, [node
     * autoprovisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
     * may have automatically initiated such operations.
     * </pre>
     *
     * <code>CREATE_NODE_POOL = 7;</code>
     */
    public static final int CREATE_NODE_POOL_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The node pool is being deleted. The node pool should be assumed to be
     * unusable as soon as this operation starts.
     * </pre>
     *
     * <code>DELETE_NODE_POOL = 8;</code>
     */
    public static final int DELETE_NODE_POOL_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The node pool's [manamagent][google.container.v1.NodePool.management]
     * field is being updated. These operations only update metadata and may be
     * concurrent with most other operations.
     * </pre>
     *
     * <code>SET_NODE_POOL_MANAGEMENT = 9;</code>
     */
    public static final int SET_NODE_POOL_MANAGEMENT_VALUE = 9;
    /**
     *
     *
     * <pre>
     * A problem has been detected with nodes and [they are being
     * repaired](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-repair).
     * This operation type is initiated by GKE, typically automatically. This
     * operation may be concurrent with other operations and there may be
     * multiple repairs occurring on the same node pool.
     * </pre>
     *
     * <code>AUTO_REPAIR_NODES = 10;</code>
     */
    public static final int AUTO_REPAIR_NODES_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Unused. Automatic node upgrade uses
     * [UPGRADE_NODES][google.container.v1.Operation.Type.UPGRADE_NODES].
     * </pre>
     *
     * <code>AUTO_UPGRADE_NODES = 11 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int AUTO_UPGRADE_NODES_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Unused. Updating labels uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_LABELS = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int SET_LABELS_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Unused. Updating master auth uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_MASTER_AUTH = 13 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int SET_MASTER_AUTH_VALUE = 13;
    /**
     *
     *
     * <pre>
     * The node pool is being resized. With the exception of resizing to or from
     * size zero, the node pool is generally usable during this operation.
     * </pre>
     *
     * <code>SET_NODE_POOL_SIZE = 14;</code>
     */
    public static final int SET_NODE_POOL_SIZE_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Unused. Updating network policy uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_NETWORK_POLICY = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int SET_NETWORK_POLICY_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Unused. Updating maintenance policy uses
     * [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
     * </pre>
     *
     * <code>SET_MAINTENANCE_POLICY = 16 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int SET_MAINTENANCE_POLICY_VALUE = 16;
    /**
     *
     *
     * <pre>
     * The control plane is being resized. This operation type is initiated by
     * GKE. These operations are often performed preemptively to ensure that the
     * control plane has sufficient resources and is not typically an indication
     * of issues. For more details, see
     * [documentation on
     * resizes](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
     * </pre>
     *
     * <code>RESIZE_CLUSTER = 18;</code>
     */
    public static final int RESIZE_CLUSTER_VALUE = 18;
    /**
     *
     *
     * <pre>
     * Fleet features of GKE Enterprise are being upgraded. The cluster should
     * be assumed to be blocked for other upgrades until the operation finishes.
     * </pre>
     *
     * <code>FLEET_FEATURE_UPGRADE = 19;</code>
     */
    public static final int FLEET_FEATURE_UPGRADE_VALUE = 19;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return CREATE_CLUSTER;
        case 2:
          return DELETE_CLUSTER;
        case 3:
          return UPGRADE_MASTER;
        case 4:
          return UPGRADE_NODES;
        case 5:
          return REPAIR_CLUSTER;
        case 6:
          return UPDATE_CLUSTER;
        case 7:
          return CREATE_NODE_POOL;
        case 8:
          return DELETE_NODE_POOL;
        case 9:
          return SET_NODE_POOL_MANAGEMENT;
        case 10:
          return AUTO_REPAIR_NODES;
        case 11:
          return AUTO_UPGRADE_NODES;
        case 12:
          return SET_LABELS;
        case 13:
          return SET_MASTER_AUTH;
        case 14:
          return SET_NODE_POOL_SIZE;
        case 15:
          return SET_NETWORK_POLICY;
        case 16:
          return SET_MAINTENANCE_POLICY;
        case 18:
          return RESIZE_CLUSTER;
        case 19:
          return FLEET_FEATURE_UPGRADE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.Operation.getDescriptor().getEnumTypes().get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.Operation.Type)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The server-assigned ID for the operation.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The server-assigned ID for the operation.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * operation is taking place. This field is deprecated, use location instead.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.container.v1.Operation.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2603
   * @return The zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * operation is taking place. This field is deprecated, use location instead.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.container.v1.Operation.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2603
   * @return The bytes for zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 3;
  private int operationType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The operation type.
   * </pre>
   *
   * <code>
   * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for operationType.
   */
  @java.lang.Override
  public int getOperationTypeValue() {
    return operationType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The operation type.
   * </pre>
   *
   * <code>
   * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The operationType.
   */
  @java.lang.Override
  public com.google.container.v1.Operation.Type getOperationType() {
    com.google.container.v1.Operation.Type result =
        com.google.container.v1.Operation.Type.forNumber(operationType_);
    return result == null ? com.google.container.v1.Operation.Type.UNRECOGNIZED : result;
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current status of the operation.
   * </pre>
   *
   * <code>
   * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current status of the operation.
   * </pre>
   *
   * <code>
   * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.container.v1.Operation.Status getStatus() {
    com.google.container.v1.Operation.Status result =
        com.google.container.v1.Operation.Status.forNumber(status_);
    return result == null ? com.google.container.v1.Operation.Status.UNRECOGNIZED : result;
  }

  public static final int DETAIL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object detail_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Detailed operation progress, if available.
   * </pre>
   *
   * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The detail.
   */
  @java.lang.Override
  public java.lang.String getDetail() {
    java.lang.Object ref = detail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Detailed operation progress, if available.
   * </pre>
   *
   * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for detail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetailBytes() {
    java.lang.Object ref = detail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. If an error has occurred, a textual description of the error.
   * Deprecated. Use the field error instead.
   * </pre>
   *
   * <code>
   * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Operation.status_message is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2617
   * @return The statusMessage.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. If an error has occurred, a textual description of the error.
   * Deprecated. Use the field error instead.
   * </pre>
   *
   * <code>
   * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Operation.status_message is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2617
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URI for the operation. Example:
   * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
   * </pre>
   *
   * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URI for the operation. Example:
   * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
   * </pre>
   *
   * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_LINK_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetLink_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URI for the target of the operation. The format
   * of this is a URI to the resource being modified (such as a cluster, node
   * pool, or node). For node pool repairs, there may be multiple nodes being
   * repaired, but only one will be the target.
   *
   * Examples:
   *
   * -
   * ##
   * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
   *
   * ##
   * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
   *
   * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
   * </pre>
   *
   * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The targetLink.
   */
  @java.lang.Override
  public java.lang.String getTargetLink() {
    java.lang.Object ref = targetLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URI for the target of the operation. The format
   * of this is a URI to the resource being modified (such as a cluster, node
   * pool, or node). For node pool repairs, there may be multiple nodes being
   * repaired, but only one will be the target.
   *
   * Examples:
   *
   * -
   * ##
   * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
   *
   * ##
   * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
   *
   * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
   * </pre>
   *
   * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for targetLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetLinkBytes() {
    java.lang.Object ref = targetLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * or
   * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * in which the cluster resides.
   * </pre>
   *
   * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * or
   * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * in which the cluster resides.
   * </pre>
   *
   * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object startTime_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The time the operation started, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public java.lang.String getStartTime() {
    java.lang.Object ref = startTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation started, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for startTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartTimeBytes() {
    java.lang.Object ref = startTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_TIME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endTime_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The time the operation completed, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public java.lang.String getEndTime() {
    java.lang.Object ref = endTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation completed, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for endTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndTimeBytes() {
    java.lang.Object ref = endTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROGRESS_FIELD_NUMBER = 12;
  private com.google.container.v1.OperationProgress progress_;
  /**
   *
   *
   * <pre>
   * Output only. Progress information for an operation.
   * </pre>
   *
   * <code>
   * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the progress field is set.
   */
  @java.lang.Override
  public boolean hasProgress() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Progress information for an operation.
   * </pre>
   *
   * <code>
   * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public com.google.container.v1.OperationProgress getProgress() {
    return progress_ == null
        ? com.google.container.v1.OperationProgress.getDefaultInstance()
        : progress_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Progress information for an operation.
   * </pre>
   *
   * <code>
   * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.OperationProgressOrBuilder getProgressOrBuilder() {
    return progress_ == null
        ? com.google.container.v1.OperationProgress.getDefaultInstance()
        : progress_;
  }

  public static final int CLUSTER_CONDITIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.StatusCondition> clusterConditions_;
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.container.v1.StatusCondition> getClusterConditionsList() {
    return clusterConditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
      getClusterConditionsOrBuilderList() {
    return clusterConditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getClusterConditionsCount() {
    return clusterConditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.StatusCondition getClusterConditions(int index) {
    return clusterConditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.StatusConditionOrBuilder getClusterConditionsOrBuilder(int index) {
    return clusterConditions_.get(index);
  }

  public static final int NODEPOOL_CONDITIONS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.StatusCondition> nodepoolConditions_;
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.container.v1.StatusCondition> getNodepoolConditionsList() {
    return nodepoolConditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
      getNodepoolConditionsOrBuilderList() {
    return nodepoolConditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getNodepoolConditionsCount() {
    return nodepoolConditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.StatusCondition getNodepoolConditions(int index) {
    return nodepoolConditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current node pool state.
   * Deprecated. Use field error instead.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.StatusConditionOrBuilder getNodepoolConditionsOrBuilder(
      int index) {
    return nodepoolConditions_.get(index);
  }

  public static final int ERROR_FIELD_NUMBER = 15;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * The error result of the operation in case of failure.
   * </pre>
   *
   * <code>.google.rpc.Status error = 15;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The error result of the operation in case of failure.
   * </pre>
   *
   * <code>.google.rpc.Status error = 15;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * The error result of the operation in case of failure.
   * </pre>
   *
   * <code>.google.rpc.Status error = 15;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, zone_);
    }
    if (operationType_ != com.google.container.v1.Operation.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, operationType_);
    }
    if (status_ != com.google.container.v1.Operation.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, statusMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLink_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, targetLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, detail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, startTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, endTime_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(12, getProgress());
    }
    for (int i = 0; i < clusterConditions_.size(); i++) {
      output.writeMessage(13, clusterConditions_.get(i));
    }
    for (int i = 0; i < nodepoolConditions_.size(); i++) {
      output.writeMessage(14, nodepoolConditions_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(15, getError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, zone_);
    }
    if (operationType_ != com.google.container.v1.Operation.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, operationType_);
    }
    if (status_ != com.google.container.v1.Operation.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, statusMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLink_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, targetLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, detail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, startTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, endTime_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getProgress());
    }
    for (int i = 0; i < clusterConditions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, clusterConditions_.get(i));
    }
    for (int i = 0; i < nodepoolConditions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, nodepoolConditions_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.Operation)) {
      return super.equals(obj);
    }
    com.google.container.v1.Operation other = (com.google.container.v1.Operation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (operationType_ != other.operationType_) return false;
    if (status_ != other.status_) return false;
    if (!getDetail().equals(other.getDetail())) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (!getSelfLink().equals(other.getSelfLink())) return false;
    if (!getTargetLink().equals(other.getTargetLink())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getStartTime().equals(other.getStartTime())) return false;
    if (!getEndTime().equals(other.getEndTime())) return false;
    if (hasProgress() != other.hasProgress()) return false;
    if (hasProgress()) {
      if (!getProgress().equals(other.getProgress())) return false;
    }
    if (!getClusterConditionsList().equals(other.getClusterConditionsList())) return false;
    if (!getNodepoolConditionsList().equals(other.getNodepoolConditionsList())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + operationType_;
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getDetail().hashCode();
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getSelfLink().hashCode();
    hash = (37 * hash) + TARGET_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getTargetLink().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + START_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getStartTime().hashCode();
    hash = (37 * hash) + END_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getEndTime().hashCode();
    if (hasProgress()) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgress().hashCode();
    }
    if (getClusterConditionsCount() > 0) {
      hash = (37 * hash) + CLUSTER_CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getClusterConditionsList().hashCode();
    }
    if (getNodepoolConditionsCount() > 0) {
      hash = (37 * hash) + NODEPOOL_CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getNodepoolConditionsList().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.Operation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.Operation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.Operation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.Operation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.Operation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.Operation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.Operation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.Operation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.Operation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.Operation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.Operation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.Operation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.Operation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * This operation resource represents operations that may have happened or are
   * happening on the cluster. All fields are output only.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.Operation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.Operation)
      com.google.container.v1.OperationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_Operation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.Operation.class,
              com.google.container.v1.Operation.Builder.class);
    }

    // Construct using com.google.container.v1.Operation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProgressFieldBuilder();
        getClusterConditionsFieldBuilder();
        getNodepoolConditionsFieldBuilder();
        getErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      zone_ = "";
      operationType_ = 0;
      status_ = 0;
      detail_ = "";
      statusMessage_ = "";
      selfLink_ = "";
      targetLink_ = "";
      location_ = "";
      startTime_ = "";
      endTime_ = "";
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      if (clusterConditionsBuilder_ == null) {
        clusterConditions_ = java.util.Collections.emptyList();
      } else {
        clusterConditions_ = null;
        clusterConditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      if (nodepoolConditionsBuilder_ == null) {
        nodepoolConditions_ = java.util.Collections.emptyList();
      } else {
        nodepoolConditions_ = null;
        nodepoolConditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_Operation_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.Operation getDefaultInstanceForType() {
      return com.google.container.v1.Operation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.Operation build() {
      com.google.container.v1.Operation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.Operation buildPartial() {
      com.google.container.v1.Operation result = new com.google.container.v1.Operation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.Operation result) {
      if (clusterConditionsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          clusterConditions_ = java.util.Collections.unmodifiableList(clusterConditions_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.clusterConditions_ = clusterConditions_;
      } else {
        result.clusterConditions_ = clusterConditionsBuilder_.build();
      }
      if (nodepoolConditionsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          nodepoolConditions_ = java.util.Collections.unmodifiableList(nodepoolConditions_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.nodepoolConditions_ = nodepoolConditions_;
      } else {
        result.nodepoolConditions_ = nodepoolConditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.Operation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationType_ = operationType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.detail_ = detail_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.selfLink_ = selfLink_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.targetLink_ = targetLink_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.startTime_ = startTime_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.endTime_ = endTime_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.progress_ = progressBuilder_ == null ? progress_ : progressBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.Operation) {
        return mergeFrom((com.google.container.v1.Operation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.Operation other) {
      if (other == com.google.container.v1.Operation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.operationType_ != 0) {
        setOperationTypeValue(other.getOperationTypeValue());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getDetail().isEmpty()) {
        detail_ = other.detail_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getSelfLink().isEmpty()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getTargetLink().isEmpty()) {
        targetLink_ = other.targetLink_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getStartTime().isEmpty()) {
        startTime_ = other.startTime_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getEndTime().isEmpty()) {
        endTime_ = other.endTime_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasProgress()) {
        mergeProgress(other.getProgress());
      }
      if (clusterConditionsBuilder_ == null) {
        if (!other.clusterConditions_.isEmpty()) {
          if (clusterConditions_.isEmpty()) {
            clusterConditions_ = other.clusterConditions_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureClusterConditionsIsMutable();
            clusterConditions_.addAll(other.clusterConditions_);
          }
          onChanged();
        }
      } else {
        if (!other.clusterConditions_.isEmpty()) {
          if (clusterConditionsBuilder_.isEmpty()) {
            clusterConditionsBuilder_.dispose();
            clusterConditionsBuilder_ = null;
            clusterConditions_ = other.clusterConditions_;
            bitField0_ = (bitField0_ & ~0x00001000);
            clusterConditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getClusterConditionsFieldBuilder()
                    : null;
          } else {
            clusterConditionsBuilder_.addAllMessages(other.clusterConditions_);
          }
        }
      }
      if (nodepoolConditionsBuilder_ == null) {
        if (!other.nodepoolConditions_.isEmpty()) {
          if (nodepoolConditions_.isEmpty()) {
            nodepoolConditions_ = other.nodepoolConditions_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureNodepoolConditionsIsMutable();
            nodepoolConditions_.addAll(other.nodepoolConditions_);
          }
          onChanged();
        }
      } else {
        if (!other.nodepoolConditions_.isEmpty()) {
          if (nodepoolConditionsBuilder_.isEmpty()) {
            nodepoolConditionsBuilder_.dispose();
            nodepoolConditionsBuilder_ = null;
            nodepoolConditions_ = other.nodepoolConditions_;
            bitField0_ = (bitField0_ & ~0x00002000);
            nodepoolConditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodepoolConditionsFieldBuilder()
                    : null;
          } else {
            nodepoolConditionsBuilder_.addAllMessages(other.nodepoolConditions_);
          }
        }
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                operationType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                targetLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                detail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                startTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                endTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getProgressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                com.google.container.v1.StatusCondition m =
                    input.readMessage(
                        com.google.container.v1.StatusCondition.parser(), extensionRegistry);
                if (clusterConditionsBuilder_ == null) {
                  ensureClusterConditionsIsMutable();
                  clusterConditions_.add(m);
                } else {
                  clusterConditionsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.container.v1.StatusCondition m =
                    input.readMessage(
                        com.google.container.v1.StatusCondition.parser(), extensionRegistry);
                if (nodepoolConditionsBuilder_ == null) {
                  ensureNodepoolConditionsIsMutable();
                  nodepoolConditions_.add(m);
                } else {
                  nodepoolConditionsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The server-assigned ID for the operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The server-assigned ID for the operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The server-assigned ID for the operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The server-assigned ID for the operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The server-assigned ID for the operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * operation is taking place. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @deprecated google.container.v1.Operation.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2603
     * @return The zone.
     */
    @java.lang.Deprecated
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * operation is taking place. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @deprecated google.container.v1.Operation.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2603
     * @return The bytes for zone.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * operation is taking place. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @deprecated google.container.v1.Operation.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2603
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * operation is taking place. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @deprecated google.container.v1.Operation.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2603
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * operation is taking place. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @deprecated google.container.v1.Operation.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2603
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int operationType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for operationType.
     */
    @java.lang.Override
    public int getOperationTypeValue() {
      return operationType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeValue(int value) {
      operationType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The operationType.
     */
    @java.lang.Override
    public com.google.container.v1.Operation.Type getOperationType() {
      com.google.container.v1.Operation.Type result =
          com.google.container.v1.Operation.Type.forNumber(operationType_);
      return result == null ? com.google.container.v1.Operation.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(com.google.container.v1.Operation.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      operationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The operation type.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Type operation_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operationType_ = 0;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current status of the operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of the operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of the operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.container.v1.Operation.Status getStatus() {
      com.google.container.v1.Operation.Status result =
          com.google.container.v1.Operation.Status.forNumber(status_);
      return result == null ? com.google.container.v1.Operation.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of the operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.container.v1.Operation.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of the operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.Operation.Status status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object detail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Detailed operation progress, if available.
     * </pre>
     *
     * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The detail.
     */
    public java.lang.String getDetail() {
      java.lang.Object ref = detail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed operation progress, if available.
     * </pre>
     *
     * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for detail.
     */
    public com.google.protobuf.ByteString getDetailBytes() {
      java.lang.Object ref = detail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed operation progress, if available.
     * </pre>
     *
     * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The detail to set.
     * @return This builder for chaining.
     */
    public Builder setDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      detail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed operation progress, if available.
     * </pre>
     *
     * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetail() {
      detail_ = getDefaultInstance().getDetail();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed operation progress, if available.
     * </pre>
     *
     * <code>string detail = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for detail to set.
     * @return This builder for chaining.
     */
    public Builder setDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      detail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. If an error has occurred, a textual description of the error.
     * Deprecated. Use the field error instead.
     * </pre>
     *
     * <code>
     * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Operation.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2617
     * @return The statusMessage.
     */
    @java.lang.Deprecated
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If an error has occurred, a textual description of the error.
     * Deprecated. Use the field error instead.
     * </pre>
     *
     * <code>
     * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Operation.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2617
     * @return The bytes for statusMessage.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If an error has occurred, a textual description of the error.
     * Deprecated. Use the field error instead.
     * </pre>
     *
     * <code>
     * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Operation.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2617
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If an error has occurred, a textual description of the error.
     * Deprecated. Use the field error instead.
     * </pre>
     *
     * <code>
     * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Operation.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2617
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If an error has occurred, a textual description of the error.
     * Deprecated. Use the field error instead.
     * </pre>
     *
     * <code>
     * string status_message = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Operation.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2617
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the operation. Example:
     * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
     * </pre>
     *
     * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the operation. Example:
     * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
     * </pre>
     *
     * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the operation. Example:
     * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
     * </pre>
     *
     * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the operation. Example:
     * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
     * </pre>
     *
     * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the operation. Example:
     * `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
     * </pre>
     *
     * <code>string self_link = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object targetLink_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the target of the operation. The format
     * of this is a URI to the resource being modified (such as a cluster, node
     * pool, or node). For node pool repairs, there may be multiple nodes being
     * repaired, but only one will be the target.
     *
     * Examples:
     *
     * -
     * ##
     * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
     *
     * ##
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
     *
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
     * </pre>
     *
     * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetLink.
     */
    public java.lang.String getTargetLink() {
      java.lang.Object ref = targetLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the target of the operation. The format
     * of this is a URI to the resource being modified (such as a cluster, node
     * pool, or node). For node pool repairs, there may be multiple nodes being
     * repaired, but only one will be the target.
     *
     * Examples:
     *
     * -
     * ##
     * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
     *
     * ##
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
     *
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
     * </pre>
     *
     * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetLink.
     */
    public com.google.protobuf.ByteString getTargetLinkBytes() {
      java.lang.Object ref = targetLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the target of the operation. The format
     * of this is a URI to the resource being modified (such as a cluster, node
     * pool, or node). For node pool repairs, there may be multiple nodes being
     * repaired, but only one will be the target.
     *
     * Examples:
     *
     * -
     * ##
     * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
     *
     * ##
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
     *
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
     * </pre>
     *
     * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The targetLink to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetLink_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the target of the operation. The format
     * of this is a URI to the resource being modified (such as a cluster, node
     * pool, or node). For node pool repairs, there may be multiple nodes being
     * repaired, but only one will be the target.
     *
     * Examples:
     *
     * -
     * ##
     * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
     *
     * ##
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
     *
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
     * </pre>
     *
     * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetLink() {
      targetLink_ = getDefaultInstance().getTargetLink();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URI for the target of the operation. The format
     * of this is a URI to the resource being modified (such as a cluster, node
     * pool, or node). For node pool repairs, there may be multiple nodes being
     * repaired, but only one will be the target.
     *
     * Examples:
     *
     * -
     * ##
     * `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
     *
     * ##
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
     *
     * `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
     * </pre>
     *
     * <code>string target_link = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for targetLink to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetLink_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object startTime_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The time the operation started, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The startTime.
     */
    public java.lang.String getStartTime() {
      java.lang.Object ref = startTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation started, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for startTime.
     */
    public com.google.protobuf.ByteString getStartTimeBytes() {
      java.lang.Object ref = startTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation started, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startTime_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation started, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartTime() {
      startTime_ = getDefaultInstance().getStartTime();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation started, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string start_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      startTime_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object endTime_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The time the operation completed, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endTime.
     */
    public java.lang.String getEndTime() {
      java.lang.Object ref = endTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation completed, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endTime.
     */
    public com.google.protobuf.ByteString getEndTimeBytes() {
      java.lang.Object ref = endTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation completed, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The endTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endTime_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation completed, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndTime() {
      endTime_ = getDefaultInstance().getEndTime();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation completed, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string end_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for endTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endTime_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.container.v1.OperationProgress progress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.OperationProgress,
            com.google.container.v1.OperationProgress.Builder,
            com.google.container.v1.OperationProgressOrBuilder>
        progressBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the progress field is set.
     */
    public boolean hasProgress() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The progress.
     */
    public com.google.container.v1.OperationProgress getProgress() {
      if (progressBuilder_ == null) {
        return progress_ == null
            ? com.google.container.v1.OperationProgress.getDefaultInstance()
            : progress_;
      } else {
        return progressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProgress(com.google.container.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progress_ = value;
      } else {
        progressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProgress(com.google.container.v1.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        progress_ = builderForValue.build();
      } else {
        progressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeProgress(com.google.container.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && progress_ != null
            && progress_ != com.google.container.v1.OperationProgress.getDefaultInstance()) {
          getProgressBuilder().mergeFrom(value);
        } else {
          progress_ = value;
        }
      } else {
        progressBuilder_.mergeFrom(value);
      }
      if (progress_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProgress() {
      bitField0_ = (bitField0_ & ~0x00000800);
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.OperationProgress.Builder getProgressBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getProgressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.container.v1.OperationProgressOrBuilder getProgressOrBuilder() {
      if (progressBuilder_ != null) {
        return progressBuilder_.getMessageOrBuilder();
      } else {
        return progress_ == null
            ? com.google.container.v1.OperationProgress.getDefaultInstance()
            : progress_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress information for an operation.
     * </pre>
     *
     * <code>
     * .google.container.v1.OperationProgress progress = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.OperationProgress,
            com.google.container.v1.OperationProgress.Builder,
            com.google.container.v1.OperationProgressOrBuilder>
        getProgressFieldBuilder() {
      if (progressBuilder_ == null) {
        progressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.OperationProgress,
                com.google.container.v1.OperationProgress.Builder,
                com.google.container.v1.OperationProgressOrBuilder>(
                getProgress(), getParentForChildren(), isClean());
        progress_ = null;
      }
      return progressBuilder_;
    }

    private java.util.List<com.google.container.v1.StatusCondition> clusterConditions_ =
        java.util.Collections.emptyList();

    private void ensureClusterConditionsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        clusterConditions_ =
            new java.util.ArrayList<com.google.container.v1.StatusCondition>(clusterConditions_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        clusterConditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.container.v1.StatusCondition> getClusterConditionsList() {
      if (clusterConditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(clusterConditions_);
      } else {
        return clusterConditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getClusterConditionsCount() {
      if (clusterConditionsBuilder_ == null) {
        return clusterConditions_.size();
      } else {
        return clusterConditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition getClusterConditions(int index) {
      if (clusterConditionsBuilder_ == null) {
        return clusterConditions_.get(index);
      } else {
        return clusterConditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setClusterConditions(int index, com.google.container.v1.StatusCondition value) {
      if (clusterConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterConditionsIsMutable();
        clusterConditions_.set(index, value);
        onChanged();
      } else {
        clusterConditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setClusterConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (clusterConditionsBuilder_ == null) {
        ensureClusterConditionsIsMutable();
        clusterConditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        clusterConditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addClusterConditions(com.google.container.v1.StatusCondition value) {
      if (clusterConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterConditionsIsMutable();
        clusterConditions_.add(value);
        onChanged();
      } else {
        clusterConditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addClusterConditions(int index, com.google.container.v1.StatusCondition value) {
      if (clusterConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterConditionsIsMutable();
        clusterConditions_.add(index, value);
        onChanged();
      } else {
        clusterConditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addClusterConditions(
        com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (clusterConditionsBuilder_ == null) {
        ensureClusterConditionsIsMutable();
        clusterConditions_.add(builderForValue.build());
        onChanged();
      } else {
        clusterConditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addClusterConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (clusterConditionsBuilder_ == null) {
        ensureClusterConditionsIsMutable();
        clusterConditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        clusterConditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllClusterConditions(
        java.lang.Iterable<? extends com.google.container.v1.StatusCondition> values) {
      if (clusterConditionsBuilder_ == null) {
        ensureClusterConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clusterConditions_);
        onChanged();
      } else {
        clusterConditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearClusterConditions() {
      if (clusterConditionsBuilder_ == null) {
        clusterConditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        clusterConditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeClusterConditions(int index) {
      if (clusterConditionsBuilder_ == null) {
        ensureClusterConditionsIsMutable();
        clusterConditions_.remove(index);
        onChanged();
      } else {
        clusterConditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition.Builder getClusterConditionsBuilder(int index) {
      return getClusterConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusConditionOrBuilder getClusterConditionsOrBuilder(
        int index) {
      if (clusterConditionsBuilder_ == null) {
        return clusterConditions_.get(index);
      } else {
        return clusterConditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
        getClusterConditionsOrBuilderList() {
      if (clusterConditionsBuilder_ != null) {
        return clusterConditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(clusterConditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition.Builder addClusterConditionsBuilder() {
      return getClusterConditionsFieldBuilder()
          .addBuilder(com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition.Builder addClusterConditionsBuilder(int index) {
      return getClusterConditionsFieldBuilder()
          .addBuilder(index, com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition cluster_conditions = 13 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.container.v1.StatusCondition.Builder>
        getClusterConditionsBuilderList() {
      return getClusterConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        getClusterConditionsFieldBuilder() {
      if (clusterConditionsBuilder_ == null) {
        clusterConditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.StatusCondition,
                com.google.container.v1.StatusCondition.Builder,
                com.google.container.v1.StatusConditionOrBuilder>(
                clusterConditions_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        clusterConditions_ = null;
      }
      return clusterConditionsBuilder_;
    }

    private java.util.List<com.google.container.v1.StatusCondition> nodepoolConditions_ =
        java.util.Collections.emptyList();

    private void ensureNodepoolConditionsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        nodepoolConditions_ =
            new java.util.ArrayList<com.google.container.v1.StatusCondition>(nodepoolConditions_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        nodepoolConditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.container.v1.StatusCondition> getNodepoolConditionsList() {
      if (nodepoolConditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodepoolConditions_);
      } else {
        return nodepoolConditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getNodepoolConditionsCount() {
      if (nodepoolConditionsBuilder_ == null) {
        return nodepoolConditions_.size();
      } else {
        return nodepoolConditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition getNodepoolConditions(int index) {
      if (nodepoolConditionsBuilder_ == null) {
        return nodepoolConditions_.get(index);
      } else {
        return nodepoolConditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setNodepoolConditions(int index, com.google.container.v1.StatusCondition value) {
      if (nodepoolConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.set(index, value);
        onChanged();
      } else {
        nodepoolConditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setNodepoolConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (nodepoolConditionsBuilder_ == null) {
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodepoolConditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addNodepoolConditions(com.google.container.v1.StatusCondition value) {
      if (nodepoolConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.add(value);
        onChanged();
      } else {
        nodepoolConditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addNodepoolConditions(int index, com.google.container.v1.StatusCondition value) {
      if (nodepoolConditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.add(index, value);
        onChanged();
      } else {
        nodepoolConditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addNodepoolConditions(
        com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (nodepoolConditionsBuilder_ == null) {
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.add(builderForValue.build());
        onChanged();
      } else {
        nodepoolConditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addNodepoolConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (nodepoolConditionsBuilder_ == null) {
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodepoolConditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllNodepoolConditions(
        java.lang.Iterable<? extends com.google.container.v1.StatusCondition> values) {
      if (nodepoolConditionsBuilder_ == null) {
        ensureNodepoolConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodepoolConditions_);
        onChanged();
      } else {
        nodepoolConditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearNodepoolConditions() {
      if (nodepoolConditionsBuilder_ == null) {
        nodepoolConditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        nodepoolConditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeNodepoolConditions(int index) {
      if (nodepoolConditionsBuilder_ == null) {
        ensureNodepoolConditionsIsMutable();
        nodepoolConditions_.remove(index);
        onChanged();
      } else {
        nodepoolConditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition.Builder getNodepoolConditionsBuilder(int index) {
      return getNodepoolConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusConditionOrBuilder getNodepoolConditionsOrBuilder(
        int index) {
      if (nodepoolConditionsBuilder_ == null) {
        return nodepoolConditions_.get(index);
      } else {
        return nodepoolConditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
        getNodepoolConditionsOrBuilderList() {
      if (nodepoolConditionsBuilder_ != null) {
        return nodepoolConditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodepoolConditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition.Builder addNodepoolConditionsBuilder() {
      return getNodepoolConditionsFieldBuilder()
          .addBuilder(com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.StatusCondition.Builder addNodepoolConditionsBuilder(int index) {
      return getNodepoolConditionsFieldBuilder()
          .addBuilder(index, com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current node pool state.
     * Deprecated. Use field error instead.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.StatusCondition nodepool_conditions = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.container.v1.StatusCondition.Builder>
        getNodepoolConditionsBuilderList() {
      return getNodepoolConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        getNodepoolConditionsFieldBuilder() {
      if (nodepoolConditionsBuilder_ == null) {
        nodepoolConditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.StatusCondition,
                com.google.container.v1.StatusCondition.Builder,
                com.google.container.v1.StatusConditionOrBuilder>(
                nodepoolConditions_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        nodepoolConditions_ = null;
      }
      return nodepoolConditionsBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00004000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * The error result of the operation in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.Operation)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.Operation)
  private static final com.google.container.v1.Operation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.Operation();
  }

  public static com.google.container.v1.Operation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Operation> PARSER =
      new com.google.protobuf.AbstractParser<Operation>() {
        @java.lang.Override
        public Operation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Operation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Operation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.Operation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
