/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * A map of resource manager tag keys and values to be attached to the nodes
 * for managing Compute Engine firewalls using Network Firewall Policies.
 * Tags must be according to specifications in
 * https://cloud.google.com/vpc/docs/tags-firewalls-overview#specifications.
 * A maximum of 5 tag key-value pairs can be specified.
 * Existing tags will be replaced with new values.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.ResourceManagerTags}
 */
public final class ResourceManagerTags extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.ResourceManagerTags)
    ResourceManagerTagsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourceManagerTags.newBuilder() to construct.
  private ResourceManagerTags(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourceManagerTags() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourceManagerTags();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ResourceManagerTags_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 1:
        return internalGetTags();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ResourceManagerTags_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.ResourceManagerTags.class,
            com.google.container.v1.ResourceManagerTags.Builder.class);
  }

  public static final int TAGS_FIELD_NUMBER = 1;

  private static final class TagsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_ResourceManagerTags_TagsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> tags_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetTags() {
    if (tags_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TagsDefaultEntryHolder.defaultEntry);
    }
    return tags_;
  }

  public int getTagsCount() {
    return internalGetTags().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
   * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
   * 2. `{org_id}/{tag_key_name}={tag_value_name}`
   * 3. `{project_id}/{tag_key_name}={tag_value_name}`
   * </pre>
   *
   * <code>map&lt;string, string&gt; tags = 1;</code>
   */
  @java.lang.Override
  public boolean containsTags(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTags().getMap().containsKey(key);
  }
  /** Use {@link #getTagsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getTags() {
    return getTagsMap();
  }
  /**
   *
   *
   * <pre>
   * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
   * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
   * 2. `{org_id}/{tag_key_name}={tag_value_name}`
   * 3. `{project_id}/{tag_key_name}={tag_value_name}`
   * </pre>
   *
   * <code>map&lt;string, string&gt; tags = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getTagsMap() {
    return internalGetTags().getMap();
  }
  /**
   *
   *
   * <pre>
   * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
   * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
   * 2. `{org_id}/{tag_key_name}={tag_value_name}`
   * 3. `{project_id}/{tag_key_name}={tag_value_name}`
   * </pre>
   *
   * <code>map&lt;string, string&gt; tags = 1;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getTagsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
   * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
   * 2. `{org_id}/{tag_key_name}={tag_value_name}`
   * 3. `{project_id}/{tag_key_name}={tag_value_name}`
   * </pre>
   *
   * <code>map&lt;string, string&gt; tags = 1;</code>
   */
  @java.lang.Override
  public java.lang.String getTagsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTags(), TagsDefaultEntryHolder.defaultEntry, 1);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetTags().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> tags__ =
          TagsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, tags__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.ResourceManagerTags)) {
      return super.equals(obj);
    }
    com.google.container.v1.ResourceManagerTags other =
        (com.google.container.v1.ResourceManagerTags) obj;

    if (!internalGetTags().equals(other.internalGetTags())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetTags().getMap().isEmpty()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTags().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ResourceManagerTags parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ResourceManagerTags parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ResourceManagerTags parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.ResourceManagerTags prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A map of resource manager tag keys and values to be attached to the nodes
   * for managing Compute Engine firewalls using Network Firewall Policies.
   * Tags must be according to specifications in
   * https://cloud.google.com/vpc/docs/tags-firewalls-overview#specifications.
   * A maximum of 5 tag key-value pairs can be specified.
   * Existing tags will be replaced with new values.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ResourceManagerTags}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.ResourceManagerTags)
      com.google.container.v1.ResourceManagerTagsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceManagerTags_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceManagerTags_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ResourceManagerTags.class,
              com.google.container.v1.ResourceManagerTags.Builder.class);
    }

    // Construct using com.google.container.v1.ResourceManagerTags.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableTags().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceManagerTags_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.ResourceManagerTags getDefaultInstanceForType() {
      return com.google.container.v1.ResourceManagerTags.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.ResourceManagerTags build() {
      com.google.container.v1.ResourceManagerTags result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.ResourceManagerTags buildPartial() {
      com.google.container.v1.ResourceManagerTags result =
          new com.google.container.v1.ResourceManagerTags(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.ResourceManagerTags result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tags_ = internalGetTags();
        result.tags_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.ResourceManagerTags) {
        return mergeFrom((com.google.container.v1.ResourceManagerTags) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.ResourceManagerTags other) {
      if (other == com.google.container.v1.ResourceManagerTags.getDefaultInstance()) return this;
      internalGetMutableTags().mergeFrom(other.internalGetTags());
      bitField0_ |= 0x00000001;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> tags__ =
                    input.readMessage(
                        TagsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableTags().getMutableMap().put(tags__.getKey(), tags__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> tags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetTags() {
      if (tags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(TagsDefaultEntryHolder.defaultEntry);
      }
      return tags_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableTags() {
      if (tags_ == null) {
        tags_ = com.google.protobuf.MapField.newMapField(TagsDefaultEntryHolder.defaultEntry);
      }
      if (!tags_.isMutable()) {
        tags_ = tags_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return tags_;
    }

    public int getTagsCount() {
      return internalGetTags().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    @java.lang.Override
    public boolean containsTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTags().getMap().containsKey(key);
    }
    /** Use {@link #getTagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getTags() {
      return getTagsMap();
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getTagsMap() {
      return internalGetTags().getMap();
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getTagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    @java.lang.Override
    public java.lang.String getTagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTags() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableTags().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    public Builder removeTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTags().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableTags() {
      bitField0_ |= 0x00000001;
      return internalGetMutableTags().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    public Builder putTags(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTags().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
     * 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
     * 2. `{org_id}/{tag_key_name}={tag_value_name}`
     * 3. `{project_id}/{tag_key_name}={tag_value_name}`
     * </pre>
     *
     * <code>map&lt;string, string&gt; tags = 1;</code>
     */
    public Builder putAllTags(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableTags().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.ResourceManagerTags)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.ResourceManagerTags)
  private static final com.google.container.v1.ResourceManagerTags DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.ResourceManagerTags();
  }

  public static com.google.container.v1.ResourceManagerTags getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceManagerTags> PARSER =
      new com.google.protobuf.AbstractParser<ResourceManagerTags>() {
        @java.lang.Override
        public ResourceManagerTags parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourceManagerTags> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceManagerTags> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.ResourceManagerTags getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
