/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * Configuration for exporting cluster resource usages.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.ResourceUsageExportConfig}
 */
public final class ResourceUsageExportConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.ResourceUsageExportConfig)
    ResourceUsageExportConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResourceUsageExportConfig.newBuilder() to construct.
  private ResourceUsageExportConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourceUsageExportConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourceUsageExportConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ResourceUsageExportConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ResourceUsageExportConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.ResourceUsageExportConfig.class,
            com.google.container.v1.ResourceUsageExportConfig.Builder.class);
  }

  public interface BigQueryDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.ResourceUsageExportConfig.BigQueryDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1;</code>
     *
     * @return The datasetId.
     */
    java.lang.String getDatasetId();
    /**
     *
     *
     * <pre>
     * The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1;</code>
     *
     * @return The bytes for datasetId.
     */
    com.google.protobuf.ByteString getDatasetIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Parameters for using BigQuery as the destination of resource usage export.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ResourceUsageExportConfig.BigQueryDestination}
   */
  public static final class BigQueryDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.ResourceUsageExportConfig.BigQueryDestination)
      BigQueryDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BigQueryDestination.newBuilder() to construct.
    private BigQueryDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQueryDestination() {
      datasetId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQueryDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_BigQueryDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_BigQueryDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.class,
              com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder.class);
    }

    public static final int DATASET_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object datasetId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1;</code>
     *
     * @return The datasetId.
     */
    @java.lang.Override
    public java.lang.String getDatasetId() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of a BigQuery Dataset.
     * </pre>
     *
     * <code>string dataset_id = 1;</code>
     *
     * @return The bytes for datasetId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetIdBytes() {
      java.lang.Object ref = datasetId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, datasetId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, datasetId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination)) {
        return super.equals(obj);
      }
      com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination other =
          (com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination) obj;

      if (!getDatasetId().equals(other.getDatasetId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Parameters for using BigQuery as the destination of resource usage export.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.ResourceUsageExportConfig.BigQueryDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.ResourceUsageExportConfig.BigQueryDestination)
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ResourceUsageExportConfig_BigQueryDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ResourceUsageExportConfig_BigQueryDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.class,
                com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        datasetId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ResourceUsageExportConfig_BigQueryDestination_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
          getDefaultInstanceForType() {
        return com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination build() {
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination buildPartial() {
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination result =
            new com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.datasetId_ = datasetId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination) {
          return mergeFrom(
              (com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination other) {
        if (other
            == com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
                .getDefaultInstance()) return this;
        if (!other.getDatasetId().isEmpty()) {
          datasetId_ = other.datasetId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  datasetId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object datasetId_ = "";
      /**
       *
       *
       * <pre>
       * The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1;</code>
       *
       * @return The datasetId.
       */
      public java.lang.String getDatasetId() {
        java.lang.Object ref = datasetId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1;</code>
       *
       * @return The bytes for datasetId.
       */
      public com.google.protobuf.ByteString getDatasetIdBytes() {
        java.lang.Object ref = datasetId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1;</code>
       *
       * @param value The datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetId() {
        datasetId_ = getDefaultInstance().getDatasetId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of a BigQuery Dataset.
       * </pre>
       *
       * <code>string dataset_id = 1;</code>
       *
       * @param value The bytes for datasetId to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        datasetId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.ResourceUsageExportConfig.BigQueryDestination)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.ResourceUsageExportConfig.BigQueryDestination)
    private static final com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination();
    }

    public static com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQueryDestination> PARSER =
        new com.google.protobuf.AbstractParser<BigQueryDestination>() {
          @java.lang.Override
          public BigQueryDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQueryDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQueryDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConsumptionMeteringConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Whether to enable consumption metering for this cluster. If enabled, a
     * second BigQuery table will be created to hold resource consumption
     * records.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * Parameters for controlling consumption metering.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig}
   */
  public static final class ConsumptionMeteringConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig)
      ConsumptionMeteringConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConsumptionMeteringConfig.newBuilder() to construct.
    private ConsumptionMeteringConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConsumptionMeteringConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConsumptionMeteringConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_ConsumptionMeteringConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_ConsumptionMeteringConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.class,
              com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder
                  .class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Whether to enable consumption metering for this cluster. If enabled, a
     * second BigQuery table will be created to hold resource consumption
     * records.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig other =
          (com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Parameters for controlling consumption metering.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig)
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ResourceUsageExportConfig_ConsumptionMeteringConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ResourceUsageExportConfig_ConsumptionMeteringConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.class,
                com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ResourceUsageExportConfig_ConsumptionMeteringConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
          getDefaultInstanceForType() {
        return com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig build() {
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
          buildPartial() {
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig result =
            new com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig) {
          return mergeFrom(
              (com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig other) {
        if (other
            == com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Whether to enable consumption metering for this cluster. If enabled, a
       * second BigQuery table will be created to hold resource consumption
       * records.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Whether to enable consumption metering for this cluster. If enabled, a
       * second BigQuery table will be created to hold resource consumption
       * records.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to enable consumption metering for this cluster. If enabled, a
       * second BigQuery table will be created to hold resource consumption
       * records.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig)
    private static final com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig();
    }

    public static com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConsumptionMeteringConfig> PARSER =
        new com.google.protobuf.AbstractParser<ConsumptionMeteringConfig>() {
          @java.lang.Override
          public ConsumptionMeteringConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConsumptionMeteringConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConsumptionMeteringConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int BIGQUERY_DESTINATION_FIELD_NUMBER = 1;
  private com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
      bigqueryDestination_;
  /**
   *
   *
   * <pre>
   * Configuration to use BigQuery as usage export destination.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
   * </code>
   *
   * @return Whether the bigqueryDestination field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDestination() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration to use BigQuery as usage export destination.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
   * </code>
   *
   * @return The bigqueryDestination.
   */
  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
      getBigqueryDestination() {
    return bigqueryDestination_ == null
        ? com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.getDefaultInstance()
        : bigqueryDestination_;
  }
  /**
   *
   *
   * <pre>
   * Configuration to use BigQuery as usage export destination.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestinationOrBuilder
      getBigqueryDestinationOrBuilder() {
    return bigqueryDestination_ == null
        ? com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.getDefaultInstance()
        : bigqueryDestination_;
  }

  public static final int ENABLE_NETWORK_EGRESS_METERING_FIELD_NUMBER = 2;
  private boolean enableNetworkEgressMetering_ = false;
  /**
   *
   *
   * <pre>
   * Whether to enable network egress metering for this cluster. If enabled, a
   * daemonset will be created in the cluster to meter network egress traffic.
   * </pre>
   *
   * <code>bool enable_network_egress_metering = 2;</code>
   *
   * @return The enableNetworkEgressMetering.
   */
  @java.lang.Override
  public boolean getEnableNetworkEgressMetering() {
    return enableNetworkEgressMetering_;
  }

  public static final int CONSUMPTION_METERING_CONFIG_FIELD_NUMBER = 3;
  private com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
      consumptionMeteringConfig_;
  /**
   *
   *
   * <pre>
   * Configuration to enable resource consumption metering.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
   * </code>
   *
   * @return Whether the consumptionMeteringConfig field is set.
   */
  @java.lang.Override
  public boolean hasConsumptionMeteringConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration to enable resource consumption metering.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
   * </code>
   *
   * @return The consumptionMeteringConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
      getConsumptionMeteringConfig() {
    return consumptionMeteringConfig_ == null
        ? com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
            .getDefaultInstance()
        : consumptionMeteringConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration to enable resource consumption metering.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfigOrBuilder
      getConsumptionMeteringConfigOrBuilder() {
    return consumptionMeteringConfig_ == null
        ? com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
            .getDefaultInstance()
        : consumptionMeteringConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getBigqueryDestination());
    }
    if (enableNetworkEgressMetering_ != false) {
      output.writeBool(2, enableNetworkEgressMetering_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getConsumptionMeteringConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBigqueryDestination());
    }
    if (enableNetworkEgressMetering_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableNetworkEgressMetering_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getConsumptionMeteringConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.ResourceUsageExportConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.ResourceUsageExportConfig other =
        (com.google.container.v1.ResourceUsageExportConfig) obj;

    if (hasBigqueryDestination() != other.hasBigqueryDestination()) return false;
    if (hasBigqueryDestination()) {
      if (!getBigqueryDestination().equals(other.getBigqueryDestination())) return false;
    }
    if (getEnableNetworkEgressMetering() != other.getEnableNetworkEgressMetering()) return false;
    if (hasConsumptionMeteringConfig() != other.hasConsumptionMeteringConfig()) return false;
    if (hasConsumptionMeteringConfig()) {
      if (!getConsumptionMeteringConfig().equals(other.getConsumptionMeteringConfig()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBigqueryDestination()) {
      hash = (37 * hash) + BIGQUERY_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryDestination().hashCode();
    }
    hash = (37 * hash) + ENABLE_NETWORK_EGRESS_METERING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableNetworkEgressMetering());
    if (hasConsumptionMeteringConfig()) {
      hash = (37 * hash) + CONSUMPTION_METERING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConsumptionMeteringConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ResourceUsageExportConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.ResourceUsageExportConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for exporting cluster resource usages.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ResourceUsageExportConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.ResourceUsageExportConfig)
      com.google.container.v1.ResourceUsageExportConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ResourceUsageExportConfig.class,
              com.google.container.v1.ResourceUsageExportConfig.Builder.class);
    }

    // Construct using com.google.container.v1.ResourceUsageExportConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBigqueryDestinationFieldBuilder();
        getConsumptionMeteringConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bigqueryDestination_ = null;
      if (bigqueryDestinationBuilder_ != null) {
        bigqueryDestinationBuilder_.dispose();
        bigqueryDestinationBuilder_ = null;
      }
      enableNetworkEgressMetering_ = false;
      consumptionMeteringConfig_ = null;
      if (consumptionMeteringConfigBuilder_ != null) {
        consumptionMeteringConfigBuilder_.dispose();
        consumptionMeteringConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ResourceUsageExportConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.ResourceUsageExportConfig getDefaultInstanceForType() {
      return com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.ResourceUsageExportConfig build() {
      com.google.container.v1.ResourceUsageExportConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.ResourceUsageExportConfig buildPartial() {
      com.google.container.v1.ResourceUsageExportConfig result =
          new com.google.container.v1.ResourceUsageExportConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.ResourceUsageExportConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bigqueryDestination_ =
            bigqueryDestinationBuilder_ == null
                ? bigqueryDestination_
                : bigqueryDestinationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enableNetworkEgressMetering_ = enableNetworkEgressMetering_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.consumptionMeteringConfig_ =
            consumptionMeteringConfigBuilder_ == null
                ? consumptionMeteringConfig_
                : consumptionMeteringConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.ResourceUsageExportConfig) {
        return mergeFrom((com.google.container.v1.ResourceUsageExportConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.ResourceUsageExportConfig other) {
      if (other == com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance())
        return this;
      if (other.hasBigqueryDestination()) {
        mergeBigqueryDestination(other.getBigqueryDestination());
      }
      if (other.getEnableNetworkEgressMetering() != false) {
        setEnableNetworkEgressMetering(other.getEnableNetworkEgressMetering());
      }
      if (other.hasConsumptionMeteringConfig()) {
        mergeConsumptionMeteringConfig(other.getConsumptionMeteringConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getBigqueryDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                enableNetworkEgressMetering_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getConsumptionMeteringConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        bigqueryDestination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination,
            com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder,
            com.google.container.v1.ResourceUsageExportConfig.BigQueryDestinationOrBuilder>
        bigqueryDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     *
     * @return Whether the bigqueryDestination field is set.
     */
    public boolean hasBigqueryDestination() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     *
     * @return The bigqueryDestination.
     */
    public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
        getBigqueryDestination() {
      if (bigqueryDestinationBuilder_ == null) {
        return bigqueryDestination_ == null
            ? com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
                .getDefaultInstance()
            : bigqueryDestination_;
      } else {
        return bigqueryDestinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    public Builder setBigqueryDestination(
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bigqueryDestination_ = value;
      } else {
        bigqueryDestinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    public Builder setBigqueryDestination(
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder
            builderForValue) {
      if (bigqueryDestinationBuilder_ == null) {
        bigqueryDestination_ = builderForValue.build();
      } else {
        bigqueryDestinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    public Builder mergeBigqueryDestination(
        com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination value) {
      if (bigqueryDestinationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && bigqueryDestination_ != null
            && bigqueryDestination_
                != com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
                    .getDefaultInstance()) {
          getBigqueryDestinationBuilder().mergeFrom(value);
        } else {
          bigqueryDestination_ = value;
        }
      } else {
        bigqueryDestinationBuilder_.mergeFrom(value);
      }
      if (bigqueryDestination_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    public Builder clearBigqueryDestination() {
      bitField0_ = (bitField0_ & ~0x00000001);
      bigqueryDestination_ = null;
      if (bigqueryDestinationBuilder_ != null) {
        bigqueryDestinationBuilder_.dispose();
        bigqueryDestinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder
        getBigqueryDestinationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBigqueryDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    public com.google.container.v1.ResourceUsageExportConfig.BigQueryDestinationOrBuilder
        getBigqueryDestinationOrBuilder() {
      if (bigqueryDestinationBuilder_ != null) {
        return bigqueryDestinationBuilder_.getMessageOrBuilder();
      } else {
        return bigqueryDestination_ == null
            ? com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination
                .getDefaultInstance()
            : bigqueryDestination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to use BigQuery as usage export destination.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.BigQueryDestination bigquery_destination = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination,
            com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder,
            com.google.container.v1.ResourceUsageExportConfig.BigQueryDestinationOrBuilder>
        getBigqueryDestinationFieldBuilder() {
      if (bigqueryDestinationBuilder_ == null) {
        bigqueryDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination,
                com.google.container.v1.ResourceUsageExportConfig.BigQueryDestination.Builder,
                com.google.container.v1.ResourceUsageExportConfig.BigQueryDestinationOrBuilder>(
                getBigqueryDestination(), getParentForChildren(), isClean());
        bigqueryDestination_ = null;
      }
      return bigqueryDestinationBuilder_;
    }

    private boolean enableNetworkEgressMetering_;
    /**
     *
     *
     * <pre>
     * Whether to enable network egress metering for this cluster. If enabled, a
     * daemonset will be created in the cluster to meter network egress traffic.
     * </pre>
     *
     * <code>bool enable_network_egress_metering = 2;</code>
     *
     * @return The enableNetworkEgressMetering.
     */
    @java.lang.Override
    public boolean getEnableNetworkEgressMetering() {
      return enableNetworkEgressMetering_;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable network egress metering for this cluster. If enabled, a
     * daemonset will be created in the cluster to meter network egress traffic.
     * </pre>
     *
     * <code>bool enable_network_egress_metering = 2;</code>
     *
     * @param value The enableNetworkEgressMetering to set.
     * @return This builder for chaining.
     */
    public Builder setEnableNetworkEgressMetering(boolean value) {

      enableNetworkEgressMetering_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable network egress metering for this cluster. If enabled, a
     * daemonset will be created in the cluster to meter network egress traffic.
     * </pre>
     *
     * <code>bool enable_network_egress_metering = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableNetworkEgressMetering() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enableNetworkEgressMetering_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        consumptionMeteringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig,
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder,
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfigOrBuilder>
        consumptionMeteringConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     *
     * @return Whether the consumptionMeteringConfig field is set.
     */
    public boolean hasConsumptionMeteringConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     *
     * @return The consumptionMeteringConfig.
     */
    public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
        getConsumptionMeteringConfig() {
      if (consumptionMeteringConfigBuilder_ == null) {
        return consumptionMeteringConfig_ == null
            ? com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
                .getDefaultInstance()
            : consumptionMeteringConfig_;
      } else {
        return consumptionMeteringConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    public Builder setConsumptionMeteringConfig(
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig value) {
      if (consumptionMeteringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consumptionMeteringConfig_ = value;
      } else {
        consumptionMeteringConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    public Builder setConsumptionMeteringConfig(
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder
            builderForValue) {
      if (consumptionMeteringConfigBuilder_ == null) {
        consumptionMeteringConfig_ = builderForValue.build();
      } else {
        consumptionMeteringConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    public Builder mergeConsumptionMeteringConfig(
        com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig value) {
      if (consumptionMeteringConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && consumptionMeteringConfig_ != null
            && consumptionMeteringConfig_
                != com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
                    .getDefaultInstance()) {
          getConsumptionMeteringConfigBuilder().mergeFrom(value);
        } else {
          consumptionMeteringConfig_ = value;
        }
      } else {
        consumptionMeteringConfigBuilder_.mergeFrom(value);
      }
      if (consumptionMeteringConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    public Builder clearConsumptionMeteringConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      consumptionMeteringConfig_ = null;
      if (consumptionMeteringConfigBuilder_ != null) {
        consumptionMeteringConfigBuilder_.dispose();
        consumptionMeteringConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder
        getConsumptionMeteringConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConsumptionMeteringConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    public com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfigOrBuilder
        getConsumptionMeteringConfigOrBuilder() {
      if (consumptionMeteringConfigBuilder_ != null) {
        return consumptionMeteringConfigBuilder_.getMessageOrBuilder();
      } else {
        return consumptionMeteringConfig_ == null
            ? com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig
                .getDefaultInstance()
            : consumptionMeteringConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to enable resource consumption metering.
     * </pre>
     *
     * <code>
     * .google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig consumption_metering_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig,
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder,
            com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfigOrBuilder>
        getConsumptionMeteringConfigFieldBuilder() {
      if (consumptionMeteringConfigBuilder_ == null) {
        consumptionMeteringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig,
                com.google.container.v1.ResourceUsageExportConfig.ConsumptionMeteringConfig.Builder,
                com.google.container.v1.ResourceUsageExportConfig
                    .ConsumptionMeteringConfigOrBuilder>(
                getConsumptionMeteringConfig(), getParentForChildren(), isClean());
        consumptionMeteringConfig_ = null;
      }
      return consumptionMeteringConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.ResourceUsageExportConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.ResourceUsageExportConfig)
  private static final com.google.container.v1.ResourceUsageExportConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.ResourceUsageExportConfig();
  }

  public static com.google.container.v1.ResourceUsageExportConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceUsageExportConfig> PARSER =
      new com.google.protobuf.AbstractParser<ResourceUsageExportConfig>() {
        @java.lang.Override
        public ResourceUsageExportConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourceUsageExportConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceUsageExportConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
