/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * SecurityBulletinEvent is a notification sent to customers when a security
 * bulletin has been posted that they are vulnerable to.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.SecurityBulletinEvent}
 */
public final class SecurityBulletinEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.SecurityBulletinEvent)
    SecurityBulletinEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityBulletinEvent.newBuilder() to construct.
  private SecurityBulletinEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityBulletinEvent() {
    resourceTypeAffected_ = "";
    bulletinId_ = "";
    cveIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    severity_ = "";
    bulletinUri_ = "";
    briefDescription_ = "";
    affectedSupportedMinors_ = com.google.protobuf.LazyStringArrayList.emptyList();
    patchedVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    suggestedUpgradeTarget_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityBulletinEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SecurityBulletinEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SecurityBulletinEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.SecurityBulletinEvent.class,
            com.google.container.v1.SecurityBulletinEvent.Builder.class);
  }

  public static final int RESOURCE_TYPE_AFFECTED_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceTypeAffected_ = "";
  /**
   *
   *
   * <pre>
   * The resource type (node/control plane) that has the vulnerability. Multiple
   * notifications (1 notification per resource type) will be sent for a
   * vulnerability that affects &gt; 1 resource type.
   * </pre>
   *
   * <code>string resource_type_affected = 1;</code>
   *
   * @return The resourceTypeAffected.
   */
  @java.lang.Override
  public java.lang.String getResourceTypeAffected() {
    java.lang.Object ref = resourceTypeAffected_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceTypeAffected_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource type (node/control plane) that has the vulnerability. Multiple
   * notifications (1 notification per resource type) will be sent for a
   * vulnerability that affects &gt; 1 resource type.
   * </pre>
   *
   * <code>string resource_type_affected = 1;</code>
   *
   * @return The bytes for resourceTypeAffected.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceTypeAffectedBytes() {
    java.lang.Object ref = resourceTypeAffected_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceTypeAffected_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BULLETIN_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bulletinId_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the bulletin corresponding to the vulnerability.
   * </pre>
   *
   * <code>string bulletin_id = 2;</code>
   *
   * @return The bulletinId.
   */
  @java.lang.Override
  public java.lang.String getBulletinId() {
    java.lang.Object ref = bulletinId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bulletinId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the bulletin corresponding to the vulnerability.
   * </pre>
   *
   * <code>string bulletin_id = 2;</code>
   *
   * @return The bytes for bulletinId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBulletinIdBytes() {
    java.lang.Object ref = bulletinId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bulletinId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CVE_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList cveIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The CVEs associated with this bulletin.
   * </pre>
   *
   * <code>repeated string cve_ids = 3;</code>
   *
   * @return A list containing the cveIds.
   */
  public com.google.protobuf.ProtocolStringList getCveIdsList() {
    return cveIds_;
  }
  /**
   *
   *
   * <pre>
   * The CVEs associated with this bulletin.
   * </pre>
   *
   * <code>repeated string cve_ids = 3;</code>
   *
   * @return The count of cveIds.
   */
  public int getCveIdsCount() {
    return cveIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The CVEs associated with this bulletin.
   * </pre>
   *
   * <code>repeated string cve_ids = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The cveIds at the given index.
   */
  public java.lang.String getCveIds(int index) {
    return cveIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The CVEs associated with this bulletin.
   * </pre>
   *
   * <code>repeated string cve_ids = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the cveIds at the given index.
   */
  public com.google.protobuf.ByteString getCveIdsBytes(int index) {
    return cveIds_.getByteString(index);
  }

  public static final int SEVERITY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object severity_ = "";
  /**
   *
   *
   * <pre>
   * The severity of this bulletin as it relates to GKE.
   * </pre>
   *
   * <code>string severity = 4;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public java.lang.String getSeverity() {
    java.lang.Object ref = severity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      severity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The severity of this bulletin as it relates to GKE.
   * </pre>
   *
   * <code>string severity = 4;</code>
   *
   * @return The bytes for severity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSeverityBytes() {
    java.lang.Object ref = severity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      severity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BULLETIN_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bulletinUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI link to the bulletin on the website for more information.
   * </pre>
   *
   * <code>string bulletin_uri = 5;</code>
   *
   * @return The bulletinUri.
   */
  @java.lang.Override
  public java.lang.String getBulletinUri() {
    java.lang.Object ref = bulletinUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bulletinUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI link to the bulletin on the website for more information.
   * </pre>
   *
   * <code>string bulletin_uri = 5;</code>
   *
   * @return The bytes for bulletinUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBulletinUriBytes() {
    java.lang.Object ref = bulletinUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bulletinUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BRIEF_DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object briefDescription_ = "";
  /**
   *
   *
   * <pre>
   * A brief description of the bulletin. See the bulletin pointed to by the
   * bulletin_uri field for an expanded description.
   * </pre>
   *
   * <code>string brief_description = 6;</code>
   *
   * @return The briefDescription.
   */
  @java.lang.Override
  public java.lang.String getBriefDescription() {
    java.lang.Object ref = briefDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      briefDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A brief description of the bulletin. See the bulletin pointed to by the
   * bulletin_uri field for an expanded description.
   * </pre>
   *
   * <code>string brief_description = 6;</code>
   *
   * @return The bytes for briefDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBriefDescriptionBytes() {
    java.lang.Object ref = briefDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      briefDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AFFECTED_SUPPORTED_MINORS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList affectedSupportedMinors_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The GKE minor versions affected by this vulnerability.
   * </pre>
   *
   * <code>repeated string affected_supported_minors = 7;</code>
   *
   * @return A list containing the affectedSupportedMinors.
   */
  public com.google.protobuf.ProtocolStringList getAffectedSupportedMinorsList() {
    return affectedSupportedMinors_;
  }
  /**
   *
   *
   * <pre>
   * The GKE minor versions affected by this vulnerability.
   * </pre>
   *
   * <code>repeated string affected_supported_minors = 7;</code>
   *
   * @return The count of affectedSupportedMinors.
   */
  public int getAffectedSupportedMinorsCount() {
    return affectedSupportedMinors_.size();
  }
  /**
   *
   *
   * <pre>
   * The GKE minor versions affected by this vulnerability.
   * </pre>
   *
   * <code>repeated string affected_supported_minors = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The affectedSupportedMinors at the given index.
   */
  public java.lang.String getAffectedSupportedMinors(int index) {
    return affectedSupportedMinors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The GKE minor versions affected by this vulnerability.
   * </pre>
   *
   * <code>repeated string affected_supported_minors = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the affectedSupportedMinors at the given index.
   */
  public com.google.protobuf.ByteString getAffectedSupportedMinorsBytes(int index) {
    return affectedSupportedMinors_.getByteString(index);
  }

  public static final int PATCHED_VERSIONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList patchedVersions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The GKE versions where this vulnerability is patched.
   * </pre>
   *
   * <code>repeated string patched_versions = 8;</code>
   *
   * @return A list containing the patchedVersions.
   */
  public com.google.protobuf.ProtocolStringList getPatchedVersionsList() {
    return patchedVersions_;
  }
  /**
   *
   *
   * <pre>
   * The GKE versions where this vulnerability is patched.
   * </pre>
   *
   * <code>repeated string patched_versions = 8;</code>
   *
   * @return The count of patchedVersions.
   */
  public int getPatchedVersionsCount() {
    return patchedVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * The GKE versions where this vulnerability is patched.
   * </pre>
   *
   * <code>repeated string patched_versions = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The patchedVersions at the given index.
   */
  public java.lang.String getPatchedVersions(int index) {
    return patchedVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The GKE versions where this vulnerability is patched.
   * </pre>
   *
   * <code>repeated string patched_versions = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the patchedVersions at the given index.
   */
  public com.google.protobuf.ByteString getPatchedVersionsBytes(int index) {
    return patchedVersions_.getByteString(index);
  }

  public static final int SUGGESTED_UPGRADE_TARGET_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object suggestedUpgradeTarget_ = "";
  /**
   *
   *
   * <pre>
   * This represents a version selected from the patched_versions field that
   * the cluster receiving this notification should most likely want to upgrade
   * to based on its current version. Note that if this notification is being
   * received by a given cluster, it means that this version is currently
   * available as an upgrade target in that cluster's location.
   * </pre>
   *
   * <code>string suggested_upgrade_target = 9;</code>
   *
   * @return The suggestedUpgradeTarget.
   */
  @java.lang.Override
  public java.lang.String getSuggestedUpgradeTarget() {
    java.lang.Object ref = suggestedUpgradeTarget_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      suggestedUpgradeTarget_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This represents a version selected from the patched_versions field that
   * the cluster receiving this notification should most likely want to upgrade
   * to based on its current version. Note that if this notification is being
   * received by a given cluster, it means that this version is currently
   * available as an upgrade target in that cluster's location.
   * </pre>
   *
   * <code>string suggested_upgrade_target = 9;</code>
   *
   * @return The bytes for suggestedUpgradeTarget.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSuggestedUpgradeTargetBytes() {
    java.lang.Object ref = suggestedUpgradeTarget_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      suggestedUpgradeTarget_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MANUAL_STEPS_REQUIRED_FIELD_NUMBER = 10;
  private boolean manualStepsRequired_ = false;
  /**
   *
   *
   * <pre>
   * If this field is specified, it means there are manual steps that the user
   * must take to make their clusters safe.
   * </pre>
   *
   * <code>bool manual_steps_required = 10;</code>
   *
   * @return The manualStepsRequired.
   */
  @java.lang.Override
  public boolean getManualStepsRequired() {
    return manualStepsRequired_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceTypeAffected_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceTypeAffected_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bulletinId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bulletinId_);
    }
    for (int i = 0; i < cveIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, cveIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(severity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bulletinUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, bulletinUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(briefDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, briefDescription_);
    }
    for (int i = 0; i < affectedSupportedMinors_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 7, affectedSupportedMinors_.getRaw(i));
    }
    for (int i = 0; i < patchedVersions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, patchedVersions_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestedUpgradeTarget_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, suggestedUpgradeTarget_);
    }
    if (manualStepsRequired_ != false) {
      output.writeBool(10, manualStepsRequired_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceTypeAffected_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceTypeAffected_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bulletinId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bulletinId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < cveIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(cveIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCveIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(severity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bulletinUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, bulletinUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(briefDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, briefDescription_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < affectedSupportedMinors_.size(); i++) {
        dataSize += computeStringSizeNoTag(affectedSupportedMinors_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAffectedSupportedMinorsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < patchedVersions_.size(); i++) {
        dataSize += computeStringSizeNoTag(patchedVersions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPatchedVersionsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestedUpgradeTarget_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, suggestedUpgradeTarget_);
    }
    if (manualStepsRequired_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, manualStepsRequired_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.SecurityBulletinEvent)) {
      return super.equals(obj);
    }
    com.google.container.v1.SecurityBulletinEvent other =
        (com.google.container.v1.SecurityBulletinEvent) obj;

    if (!getResourceTypeAffected().equals(other.getResourceTypeAffected())) return false;
    if (!getBulletinId().equals(other.getBulletinId())) return false;
    if (!getCveIdsList().equals(other.getCveIdsList())) return false;
    if (!getSeverity().equals(other.getSeverity())) return false;
    if (!getBulletinUri().equals(other.getBulletinUri())) return false;
    if (!getBriefDescription().equals(other.getBriefDescription())) return false;
    if (!getAffectedSupportedMinorsList().equals(other.getAffectedSupportedMinorsList()))
      return false;
    if (!getPatchedVersionsList().equals(other.getPatchedVersionsList())) return false;
    if (!getSuggestedUpgradeTarget().equals(other.getSuggestedUpgradeTarget())) return false;
    if (getManualStepsRequired() != other.getManualStepsRequired()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_AFFECTED_FIELD_NUMBER;
    hash = (53 * hash) + getResourceTypeAffected().hashCode();
    hash = (37 * hash) + BULLETIN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBulletinId().hashCode();
    if (getCveIdsCount() > 0) {
      hash = (37 * hash) + CVE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getCveIdsList().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + getSeverity().hashCode();
    hash = (37 * hash) + BULLETIN_URI_FIELD_NUMBER;
    hash = (53 * hash) + getBulletinUri().hashCode();
    hash = (37 * hash) + BRIEF_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getBriefDescription().hashCode();
    if (getAffectedSupportedMinorsCount() > 0) {
      hash = (37 * hash) + AFFECTED_SUPPORTED_MINORS_FIELD_NUMBER;
      hash = (53 * hash) + getAffectedSupportedMinorsList().hashCode();
    }
    if (getPatchedVersionsCount() > 0) {
      hash = (37 * hash) + PATCHED_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPatchedVersionsList().hashCode();
    }
    hash = (37 * hash) + SUGGESTED_UPGRADE_TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getSuggestedUpgradeTarget().hashCode();
    hash = (37 * hash) + MANUAL_STEPS_REQUIRED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getManualStepsRequired());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SecurityBulletinEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.SecurityBulletinEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SecurityBulletinEvent is a notification sent to customers when a security
   * bulletin has been posted that they are vulnerable to.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.SecurityBulletinEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.SecurityBulletinEvent)
      com.google.container.v1.SecurityBulletinEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SecurityBulletinEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SecurityBulletinEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.SecurityBulletinEvent.class,
              com.google.container.v1.SecurityBulletinEvent.Builder.class);
    }

    // Construct using com.google.container.v1.SecurityBulletinEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceTypeAffected_ = "";
      bulletinId_ = "";
      cveIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      severity_ = "";
      bulletinUri_ = "";
      briefDescription_ = "";
      affectedSupportedMinors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      patchedVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      suggestedUpgradeTarget_ = "";
      manualStepsRequired_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SecurityBulletinEvent_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.SecurityBulletinEvent getDefaultInstanceForType() {
      return com.google.container.v1.SecurityBulletinEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.SecurityBulletinEvent build() {
      com.google.container.v1.SecurityBulletinEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.SecurityBulletinEvent buildPartial() {
      com.google.container.v1.SecurityBulletinEvent result =
          new com.google.container.v1.SecurityBulletinEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.SecurityBulletinEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceTypeAffected_ = resourceTypeAffected_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bulletinId_ = bulletinId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        cveIds_.makeImmutable();
        result.cveIds_ = cveIds_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.bulletinUri_ = bulletinUri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.briefDescription_ = briefDescription_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        affectedSupportedMinors_.makeImmutable();
        result.affectedSupportedMinors_ = affectedSupportedMinors_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        patchedVersions_.makeImmutable();
        result.patchedVersions_ = patchedVersions_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.suggestedUpgradeTarget_ = suggestedUpgradeTarget_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.manualStepsRequired_ = manualStepsRequired_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.SecurityBulletinEvent) {
        return mergeFrom((com.google.container.v1.SecurityBulletinEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.SecurityBulletinEvent other) {
      if (other == com.google.container.v1.SecurityBulletinEvent.getDefaultInstance()) return this;
      if (!other.getResourceTypeAffected().isEmpty()) {
        resourceTypeAffected_ = other.resourceTypeAffected_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBulletinId().isEmpty()) {
        bulletinId_ = other.bulletinId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.cveIds_.isEmpty()) {
        if (cveIds_.isEmpty()) {
          cveIds_ = other.cveIds_;
          bitField0_ |= 0x00000004;
        } else {
          ensureCveIdsIsMutable();
          cveIds_.addAll(other.cveIds_);
        }
        onChanged();
      }
      if (!other.getSeverity().isEmpty()) {
        severity_ = other.severity_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getBulletinUri().isEmpty()) {
        bulletinUri_ = other.bulletinUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getBriefDescription().isEmpty()) {
        briefDescription_ = other.briefDescription_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.affectedSupportedMinors_.isEmpty()) {
        if (affectedSupportedMinors_.isEmpty()) {
          affectedSupportedMinors_ = other.affectedSupportedMinors_;
          bitField0_ |= 0x00000040;
        } else {
          ensureAffectedSupportedMinorsIsMutable();
          affectedSupportedMinors_.addAll(other.affectedSupportedMinors_);
        }
        onChanged();
      }
      if (!other.patchedVersions_.isEmpty()) {
        if (patchedVersions_.isEmpty()) {
          patchedVersions_ = other.patchedVersions_;
          bitField0_ |= 0x00000080;
        } else {
          ensurePatchedVersionsIsMutable();
          patchedVersions_.addAll(other.patchedVersions_);
        }
        onChanged();
      }
      if (!other.getSuggestedUpgradeTarget().isEmpty()) {
        suggestedUpgradeTarget_ = other.suggestedUpgradeTarget_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.getManualStepsRequired() != false) {
        setManualStepsRequired(other.getManualStepsRequired());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                resourceTypeAffected_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                bulletinId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCveIdsIsMutable();
                cveIds_.add(s);
                break;
              } // case 26
            case 34:
              {
                severity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                bulletinUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                briefDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAffectedSupportedMinorsIsMutable();
                affectedSupportedMinors_.add(s);
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePatchedVersionsIsMutable();
                patchedVersions_.add(s);
                break;
              } // case 66
            case 74:
              {
                suggestedUpgradeTarget_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                manualStepsRequired_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceTypeAffected_ = "";
    /**
     *
     *
     * <pre>
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects &gt; 1 resource type.
     * </pre>
     *
     * <code>string resource_type_affected = 1;</code>
     *
     * @return The resourceTypeAffected.
     */
    public java.lang.String getResourceTypeAffected() {
      java.lang.Object ref = resourceTypeAffected_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceTypeAffected_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects &gt; 1 resource type.
     * </pre>
     *
     * <code>string resource_type_affected = 1;</code>
     *
     * @return The bytes for resourceTypeAffected.
     */
    public com.google.protobuf.ByteString getResourceTypeAffectedBytes() {
      java.lang.Object ref = resourceTypeAffected_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceTypeAffected_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects &gt; 1 resource type.
     * </pre>
     *
     * <code>string resource_type_affected = 1;</code>
     *
     * @param value The resourceTypeAffected to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeAffected(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceTypeAffected_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects &gt; 1 resource type.
     * </pre>
     *
     * <code>string resource_type_affected = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceTypeAffected() {
      resourceTypeAffected_ = getDefaultInstance().getResourceTypeAffected();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects &gt; 1 resource type.
     * </pre>
     *
     * <code>string resource_type_affected = 1;</code>
     *
     * @param value The bytes for resourceTypeAffected to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeAffectedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceTypeAffected_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object bulletinId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the bulletin corresponding to the vulnerability.
     * </pre>
     *
     * <code>string bulletin_id = 2;</code>
     *
     * @return The bulletinId.
     */
    public java.lang.String getBulletinId() {
      java.lang.Object ref = bulletinId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bulletinId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the bulletin corresponding to the vulnerability.
     * </pre>
     *
     * <code>string bulletin_id = 2;</code>
     *
     * @return The bytes for bulletinId.
     */
    public com.google.protobuf.ByteString getBulletinIdBytes() {
      java.lang.Object ref = bulletinId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bulletinId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the bulletin corresponding to the vulnerability.
     * </pre>
     *
     * <code>string bulletin_id = 2;</code>
     *
     * @param value The bulletinId to set.
     * @return This builder for chaining.
     */
    public Builder setBulletinId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bulletinId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the bulletin corresponding to the vulnerability.
     * </pre>
     *
     * <code>string bulletin_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBulletinId() {
      bulletinId_ = getDefaultInstance().getBulletinId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the bulletin corresponding to the vulnerability.
     * </pre>
     *
     * <code>string bulletin_id = 2;</code>
     *
     * @param value The bytes for bulletinId to set.
     * @return This builder for chaining.
     */
    public Builder setBulletinIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bulletinId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList cveIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCveIdsIsMutable() {
      if (!cveIds_.isModifiable()) {
        cveIds_ = new com.google.protobuf.LazyStringArrayList(cveIds_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @return A list containing the cveIds.
     */
    public com.google.protobuf.ProtocolStringList getCveIdsList() {
      cveIds_.makeImmutable();
      return cveIds_;
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @return The count of cveIds.
     */
    public int getCveIdsCount() {
      return cveIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The cveIds at the given index.
     */
    public java.lang.String getCveIds(int index) {
      return cveIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the cveIds at the given index.
     */
    public com.google.protobuf.ByteString getCveIdsBytes(int index) {
      return cveIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The cveIds to set.
     * @return This builder for chaining.
     */
    public Builder setCveIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCveIdsIsMutable();
      cveIds_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @param value The cveIds to add.
     * @return This builder for chaining.
     */
    public Builder addCveIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCveIdsIsMutable();
      cveIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @param values The cveIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllCveIds(java.lang.Iterable<java.lang.String> values) {
      ensureCveIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cveIds_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCveIds() {
      cveIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CVEs associated with this bulletin.
     * </pre>
     *
     * <code>repeated string cve_ids = 3;</code>
     *
     * @param value The bytes of the cveIds to add.
     * @return This builder for chaining.
     */
    public Builder addCveIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCveIdsIsMutable();
      cveIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object severity_ = "";
    /**
     *
     *
     * <pre>
     * The severity of this bulletin as it relates to GKE.
     * </pre>
     *
     * <code>string severity = 4;</code>
     *
     * @return The severity.
     */
    public java.lang.String getSeverity() {
      java.lang.Object ref = severity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        severity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The severity of this bulletin as it relates to GKE.
     * </pre>
     *
     * <code>string severity = 4;</code>
     *
     * @return The bytes for severity.
     */
    public com.google.protobuf.ByteString getSeverityBytes() {
      java.lang.Object ref = severity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        severity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The severity of this bulletin as it relates to GKE.
     * </pre>
     *
     * <code>string severity = 4;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      severity_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity of this bulletin as it relates to GKE.
     * </pre>
     *
     * <code>string severity = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      severity_ = getDefaultInstance().getSeverity();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The severity of this bulletin as it relates to GKE.
     * </pre>
     *
     * <code>string severity = 4;</code>
     *
     * @param value The bytes for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      severity_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object bulletinUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI link to the bulletin on the website for more information.
     * </pre>
     *
     * <code>string bulletin_uri = 5;</code>
     *
     * @return The bulletinUri.
     */
    public java.lang.String getBulletinUri() {
      java.lang.Object ref = bulletinUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bulletinUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI link to the bulletin on the website for more information.
     * </pre>
     *
     * <code>string bulletin_uri = 5;</code>
     *
     * @return The bytes for bulletinUri.
     */
    public com.google.protobuf.ByteString getBulletinUriBytes() {
      java.lang.Object ref = bulletinUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bulletinUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI link to the bulletin on the website for more information.
     * </pre>
     *
     * <code>string bulletin_uri = 5;</code>
     *
     * @param value The bulletinUri to set.
     * @return This builder for chaining.
     */
    public Builder setBulletinUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bulletinUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI link to the bulletin on the website for more information.
     * </pre>
     *
     * <code>string bulletin_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBulletinUri() {
      bulletinUri_ = getDefaultInstance().getBulletinUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI link to the bulletin on the website for more information.
     * </pre>
     *
     * <code>string bulletin_uri = 5;</code>
     *
     * @param value The bytes for bulletinUri to set.
     * @return This builder for chaining.
     */
    public Builder setBulletinUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bulletinUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object briefDescription_ = "";
    /**
     *
     *
     * <pre>
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     * </pre>
     *
     * <code>string brief_description = 6;</code>
     *
     * @return The briefDescription.
     */
    public java.lang.String getBriefDescription() {
      java.lang.Object ref = briefDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        briefDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     * </pre>
     *
     * <code>string brief_description = 6;</code>
     *
     * @return The bytes for briefDescription.
     */
    public com.google.protobuf.ByteString getBriefDescriptionBytes() {
      java.lang.Object ref = briefDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        briefDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     * </pre>
     *
     * <code>string brief_description = 6;</code>
     *
     * @param value The briefDescription to set.
     * @return This builder for chaining.
     */
    public Builder setBriefDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      briefDescription_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     * </pre>
     *
     * <code>string brief_description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBriefDescription() {
      briefDescription_ = getDefaultInstance().getBriefDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     * </pre>
     *
     * <code>string brief_description = 6;</code>
     *
     * @param value The bytes for briefDescription to set.
     * @return This builder for chaining.
     */
    public Builder setBriefDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      briefDescription_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList affectedSupportedMinors_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAffectedSupportedMinorsIsMutable() {
      if (!affectedSupportedMinors_.isModifiable()) {
        affectedSupportedMinors_ =
            new com.google.protobuf.LazyStringArrayList(affectedSupportedMinors_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @return A list containing the affectedSupportedMinors.
     */
    public com.google.protobuf.ProtocolStringList getAffectedSupportedMinorsList() {
      affectedSupportedMinors_.makeImmutable();
      return affectedSupportedMinors_;
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @return The count of affectedSupportedMinors.
     */
    public int getAffectedSupportedMinorsCount() {
      return affectedSupportedMinors_.size();
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The affectedSupportedMinors at the given index.
     */
    public java.lang.String getAffectedSupportedMinors(int index) {
      return affectedSupportedMinors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the affectedSupportedMinors at the given index.
     */
    public com.google.protobuf.ByteString getAffectedSupportedMinorsBytes(int index) {
      return affectedSupportedMinors_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The affectedSupportedMinors to set.
     * @return This builder for chaining.
     */
    public Builder setAffectedSupportedMinors(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAffectedSupportedMinorsIsMutable();
      affectedSupportedMinors_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @param value The affectedSupportedMinors to add.
     * @return This builder for chaining.
     */
    public Builder addAffectedSupportedMinors(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAffectedSupportedMinorsIsMutable();
      affectedSupportedMinors_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @param values The affectedSupportedMinors to add.
     * @return This builder for chaining.
     */
    public Builder addAllAffectedSupportedMinors(java.lang.Iterable<java.lang.String> values) {
      ensureAffectedSupportedMinorsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, affectedSupportedMinors_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAffectedSupportedMinors() {
      affectedSupportedMinors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE minor versions affected by this vulnerability.
     * </pre>
     *
     * <code>repeated string affected_supported_minors = 7;</code>
     *
     * @param value The bytes of the affectedSupportedMinors to add.
     * @return This builder for chaining.
     */
    public Builder addAffectedSupportedMinorsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAffectedSupportedMinorsIsMutable();
      affectedSupportedMinors_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList patchedVersions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePatchedVersionsIsMutable() {
      if (!patchedVersions_.isModifiable()) {
        patchedVersions_ = new com.google.protobuf.LazyStringArrayList(patchedVersions_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @return A list containing the patchedVersions.
     */
    public com.google.protobuf.ProtocolStringList getPatchedVersionsList() {
      patchedVersions_.makeImmutable();
      return patchedVersions_;
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @return The count of patchedVersions.
     */
    public int getPatchedVersionsCount() {
      return patchedVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The patchedVersions at the given index.
     */
    public java.lang.String getPatchedVersions(int index) {
      return patchedVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the patchedVersions at the given index.
     */
    public com.google.protobuf.ByteString getPatchedVersionsBytes(int index) {
      return patchedVersions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The patchedVersions to set.
     * @return This builder for chaining.
     */
    public Builder setPatchedVersions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePatchedVersionsIsMutable();
      patchedVersions_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @param value The patchedVersions to add.
     * @return This builder for chaining.
     */
    public Builder addPatchedVersions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePatchedVersionsIsMutable();
      patchedVersions_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @param values The patchedVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAllPatchedVersions(java.lang.Iterable<java.lang.String> values) {
      ensurePatchedVersionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, patchedVersions_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPatchedVersions() {
      patchedVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GKE versions where this vulnerability is patched.
     * </pre>
     *
     * <code>repeated string patched_versions = 8;</code>
     *
     * @param value The bytes of the patchedVersions to add.
     * @return This builder for chaining.
     */
    public Builder addPatchedVersionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePatchedVersionsIsMutable();
      patchedVersions_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object suggestedUpgradeTarget_ = "";
    /**
     *
     *
     * <pre>
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     * </pre>
     *
     * <code>string suggested_upgrade_target = 9;</code>
     *
     * @return The suggestedUpgradeTarget.
     */
    public java.lang.String getSuggestedUpgradeTarget() {
      java.lang.Object ref = suggestedUpgradeTarget_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestedUpgradeTarget_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     * </pre>
     *
     * <code>string suggested_upgrade_target = 9;</code>
     *
     * @return The bytes for suggestedUpgradeTarget.
     */
    public com.google.protobuf.ByteString getSuggestedUpgradeTargetBytes() {
      java.lang.Object ref = suggestedUpgradeTarget_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestedUpgradeTarget_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     * </pre>
     *
     * <code>string suggested_upgrade_target = 9;</code>
     *
     * @param value The suggestedUpgradeTarget to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestedUpgradeTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      suggestedUpgradeTarget_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     * </pre>
     *
     * <code>string suggested_upgrade_target = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuggestedUpgradeTarget() {
      suggestedUpgradeTarget_ = getDefaultInstance().getSuggestedUpgradeTarget();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     * </pre>
     *
     * <code>string suggested_upgrade_target = 9;</code>
     *
     * @param value The bytes for suggestedUpgradeTarget to set.
     * @return This builder for chaining.
     */
    public Builder setSuggestedUpgradeTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      suggestedUpgradeTarget_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private boolean manualStepsRequired_;
    /**
     *
     *
     * <pre>
     * If this field is specified, it means there are manual steps that the user
     * must take to make their clusters safe.
     * </pre>
     *
     * <code>bool manual_steps_required = 10;</code>
     *
     * @return The manualStepsRequired.
     */
    @java.lang.Override
    public boolean getManualStepsRequired() {
      return manualStepsRequired_;
    }
    /**
     *
     *
     * <pre>
     * If this field is specified, it means there are manual steps that the user
     * must take to make their clusters safe.
     * </pre>
     *
     * <code>bool manual_steps_required = 10;</code>
     *
     * @param value The manualStepsRequired to set.
     * @return This builder for chaining.
     */
    public Builder setManualStepsRequired(boolean value) {

      manualStepsRequired_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is specified, it means there are manual steps that the user
     * must take to make their clusters safe.
     * </pre>
     *
     * <code>bool manual_steps_required = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearManualStepsRequired() {
      bitField0_ = (bitField0_ & ~0x00000200);
      manualStepsRequired_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.SecurityBulletinEvent)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.SecurityBulletinEvent)
  private static final com.google.container.v1.SecurityBulletinEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.SecurityBulletinEvent();
  }

  public static com.google.container.v1.SecurityBulletinEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityBulletinEvent> PARSER =
      new com.google.protobuf.AbstractParser<SecurityBulletinEvent>() {
        @java.lang.Override
        public SecurityBulletinEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityBulletinEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityBulletinEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.SecurityBulletinEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
