/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * SoleTenantConfig contains the NodeAffinities to specify what shared sole
 * tenant node groups should back the node pool.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.SoleTenantConfig}
 */
public final class SoleTenantConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.SoleTenantConfig)
    SoleTenantConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SoleTenantConfig.newBuilder() to construct.
  private SoleTenantConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SoleTenantConfig() {
    nodeAffinities_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SoleTenantConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SoleTenantConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SoleTenantConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.SoleTenantConfig.class,
            com.google.container.v1.SoleTenantConfig.Builder.class);
  }

  public interface NodeAffinityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.SoleTenantConfig.NodeAffinity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Key for NodeAffinity.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * Key for NodeAffinity.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * Operator for NodeAffinity.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
     *
     * @return The enum numeric value on the wire for operator.
     */
    int getOperatorValue();
    /**
     *
     *
     * <pre>
     * Operator for NodeAffinity.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
     *
     * @return The operator.
     */
    com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator getOperator();

    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @return A list containing the values.
     */
    java.util.List<java.lang.String> getValuesList();
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @return The count of values.
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    java.lang.String getValues(int index);
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the values at the given index.
     */
    com.google.protobuf.ByteString getValuesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Specifies the NodeAffinity key, values, and affinity operator according to
   * [shared sole tenant node group
   * affinities](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes#node_affinity_and_anti-affinity).
   * </pre>
   *
   * Protobuf type {@code google.container.v1.SoleTenantConfig.NodeAffinity}
   */
  public static final class NodeAffinity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.SoleTenantConfig.NodeAffinity)
      NodeAffinityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NodeAffinity.newBuilder() to construct.
    private NodeAffinity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NodeAffinity() {
      key_ = "";
      operator_ = 0;
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NodeAffinity();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SoleTenantConfig_NodeAffinity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SoleTenantConfig_NodeAffinity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.SoleTenantConfig.NodeAffinity.class,
              com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Operator allows user to specify affinity or anti-affinity for the
     * given key values.
     * </pre>
     *
     * Protobuf enum {@code google.container.v1.SoleTenantConfig.NodeAffinity.Operator}
     */
    public enum Operator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Invalid or unspecified affinity operator.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Affinity operator.
       * </pre>
       *
       * <code>IN = 1;</code>
       */
      IN(1),
      /**
       *
       *
       * <pre>
       * Anti-affinity operator.
       * </pre>
       *
       * <code>NOT_IN = 2;</code>
       */
      NOT_IN(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Invalid or unspecified affinity operator.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Affinity operator.
       * </pre>
       *
       * <code>IN = 1;</code>
       */
      public static final int IN_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Anti-affinity operator.
       * </pre>
       *
       * <code>NOT_IN = 2;</code>
       */
      public static final int NOT_IN_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operator forNumber(int value) {
        switch (value) {
          case 0:
            return OPERATOR_UNSPECIFIED;
          case 1:
            return IN;
          case 2:
            return NOT_IN;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operator> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Operator> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Operator>() {
            public Operator findValueByNumber(int number) {
              return Operator.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.container.v1.SoleTenantConfig.NodeAffinity.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Operator[] VALUES = values();

      public static Operator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.container.v1.SoleTenantConfig.NodeAffinity.Operator)
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * Key for NodeAffinity.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Key for NodeAffinity.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OPERATOR_FIELD_NUMBER = 2;
    private int operator_ = 0;
    /**
     *
     *
     * <pre>
     * Operator for NodeAffinity.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
     *
     * @return The enum numeric value on the wire for operator.
     */
    @java.lang.Override
    public int getOperatorValue() {
      return operator_;
    }
    /**
     *
     *
     * <pre>
     * Operator for NodeAffinity.
     * </pre>
     *
     * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
     *
     * @return The operator.
     */
    @java.lang.Override
    public com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator getOperator() {
      com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator result =
          com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator.forNumber(operator_);
      return result == null
          ? com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator.UNRECOGNIZED
          : result;
    }

    public static final int VALUES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList values_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @return A list containing the values.
     */
    public com.google.protobuf.ProtocolStringList getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @return The count of values.
     */
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    public java.lang.String getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Values for NodeAffinity.
     * </pre>
     *
     * <code>repeated string values = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the values at the given index.
     */
    public com.google.protobuf.ByteString getValuesBytes(int index) {
      return values_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (operator_
          != com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator.OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, operator_);
      }
      for (int i = 0; i < values_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, values_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (operator_
          != com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator.OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, operator_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < values_.size(); i++) {
          dataSize += computeStringSizeNoTag(values_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getValuesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.SoleTenantConfig.NodeAffinity)) {
        return super.equals(obj);
      }
      com.google.container.v1.SoleTenantConfig.NodeAffinity other =
          (com.google.container.v1.SoleTenantConfig.NodeAffinity) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (operator_ != other.operator_) return false;
      if (!getValuesList().equals(other.getValuesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + OPERATOR_FIELD_NUMBER;
      hash = (53 * hash) + operator_;
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.SoleTenantConfig.NodeAffinity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the NodeAffinity key, values, and affinity operator according to
     * [shared sole tenant node group
     * affinities](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes#node_affinity_and_anti-affinity).
     * </pre>
     *
     * Protobuf type {@code google.container.v1.SoleTenantConfig.NodeAffinity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.SoleTenantConfig.NodeAffinity)
        com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_SoleTenantConfig_NodeAffinity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_SoleTenantConfig_NodeAffinity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.SoleTenantConfig.NodeAffinity.class,
                com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder.class);
      }

      // Construct using com.google.container.v1.SoleTenantConfig.NodeAffinity.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        operator_ = 0;
        values_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_SoleTenantConfig_NodeAffinity_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.SoleTenantConfig.NodeAffinity getDefaultInstanceForType() {
        return com.google.container.v1.SoleTenantConfig.NodeAffinity.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.SoleTenantConfig.NodeAffinity build() {
        com.google.container.v1.SoleTenantConfig.NodeAffinity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.SoleTenantConfig.NodeAffinity buildPartial() {
        com.google.container.v1.SoleTenantConfig.NodeAffinity result =
            new com.google.container.v1.SoleTenantConfig.NodeAffinity(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1.SoleTenantConfig.NodeAffinity result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.key_ = key_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.operator_ = operator_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          values_.makeImmutable();
          result.values_ = values_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.SoleTenantConfig.NodeAffinity) {
          return mergeFrom((com.google.container.v1.SoleTenantConfig.NodeAffinity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1.SoleTenantConfig.NodeAffinity other) {
        if (other == com.google.container.v1.SoleTenantConfig.NodeAffinity.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.operator_ != 0) {
          setOperatorValue(other.getOperatorValue());
        }
        if (!other.values_.isEmpty()) {
          if (values_.isEmpty()) {
            values_ = other.values_;
            bitField0_ |= 0x00000004;
          } else {
            ensureValuesIsMutable();
            values_.addAll(other.values_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  operator_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureValuesIsMutable();
                  values_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * Key for NodeAffinity.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Key for NodeAffinity.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Key for NodeAffinity.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key for NodeAffinity.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Key for NodeAffinity.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int operator_ = 0;
      /**
       *
       *
       * <pre>
       * Operator for NodeAffinity.
       * </pre>
       *
       * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
       *
       * @return The enum numeric value on the wire for operator.
       */
      @java.lang.Override
      public int getOperatorValue() {
        return operator_;
      }
      /**
       *
       *
       * <pre>
       * Operator for NodeAffinity.
       * </pre>
       *
       * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
       *
       * @param value The enum numeric value on the wire for operator to set.
       * @return This builder for chaining.
       */
      public Builder setOperatorValue(int value) {
        operator_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Operator for NodeAffinity.
       * </pre>
       *
       * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
       *
       * @return The operator.
       */
      @java.lang.Override
      public com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator getOperator() {
        com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator result =
            com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator.forNumber(operator_);
        return result == null
            ? com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Operator for NodeAffinity.
       * </pre>
       *
       * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
       *
       * @param value The operator to set.
       * @return This builder for chaining.
       */
      public Builder setOperator(
          com.google.container.v1.SoleTenantConfig.NodeAffinity.Operator value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        operator_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Operator for NodeAffinity.
       * </pre>
       *
       * <code>.google.container.v1.SoleTenantConfig.NodeAffinity.Operator operator = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOperator() {
        bitField0_ = (bitField0_ & ~0x00000002);
        operator_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList values_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureValuesIsMutable() {
        if (!values_.isModifiable()) {
          values_ = new com.google.protobuf.LazyStringArrayList(values_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @return A list containing the values.
       */
      public com.google.protobuf.ProtocolStringList getValuesList() {
        values_.makeImmutable();
        return values_;
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public java.lang.String getValues(int index) {
        return values_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      public com.google.protobuf.ByteString getValuesBytes(int index) {
        return values_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The values to set.
       * @return This builder for chaining.
       */
      public Builder setValues(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @param value The values to add.
       * @return This builder for chaining.
       */
      public Builder addValues(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValuesIsMutable();
        values_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @param values The values to add.
       * @return This builder for chaining.
       */
      public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
        ensureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValues() {
        values_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Values for NodeAffinity.
       * </pre>
       *
       * <code>repeated string values = 3;</code>
       *
       * @param value The bytes of the values to add.
       * @return This builder for chaining.
       */
      public Builder addValuesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureValuesIsMutable();
        values_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.SoleTenantConfig.NodeAffinity)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.SoleTenantConfig.NodeAffinity)
    private static final com.google.container.v1.SoleTenantConfig.NodeAffinity DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.SoleTenantConfig.NodeAffinity();
    }

    public static com.google.container.v1.SoleTenantConfig.NodeAffinity getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NodeAffinity> PARSER =
        new com.google.protobuf.AbstractParser<NodeAffinity>() {
          @java.lang.Override
          public NodeAffinity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NodeAffinity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NodeAffinity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.SoleTenantConfig.NodeAffinity getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NODE_AFFINITIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.SoleTenantConfig.NodeAffinity> nodeAffinities_;
  /**
   *
   *
   * <pre>
   * NodeAffinities used to match to a shared sole tenant node group.
   * </pre>
   *
   * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.SoleTenantConfig.NodeAffinity>
      getNodeAffinitiesList() {
    return nodeAffinities_;
  }
  /**
   *
   *
   * <pre>
   * NodeAffinities used to match to a shared sole tenant node group.
   * </pre>
   *
   * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder>
      getNodeAffinitiesOrBuilderList() {
    return nodeAffinities_;
  }
  /**
   *
   *
   * <pre>
   * NodeAffinities used to match to a shared sole tenant node group.
   * </pre>
   *
   * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
   */
  @java.lang.Override
  public int getNodeAffinitiesCount() {
    return nodeAffinities_.size();
  }
  /**
   *
   *
   * <pre>
   * NodeAffinities used to match to a shared sole tenant node group.
   * </pre>
   *
   * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SoleTenantConfig.NodeAffinity getNodeAffinities(int index) {
    return nodeAffinities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * NodeAffinities used to match to a shared sole tenant node group.
   * </pre>
   *
   * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder getNodeAffinitiesOrBuilder(
      int index) {
    return nodeAffinities_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < nodeAffinities_.size(); i++) {
      output.writeMessage(1, nodeAffinities_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < nodeAffinities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, nodeAffinities_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.SoleTenantConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.SoleTenantConfig other = (com.google.container.v1.SoleTenantConfig) obj;

    if (!getNodeAffinitiesList().equals(other.getNodeAffinitiesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getNodeAffinitiesCount() > 0) {
      hash = (37 * hash) + NODE_AFFINITIES_FIELD_NUMBER;
      hash = (53 * hash) + getNodeAffinitiesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SoleTenantConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SoleTenantConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SoleTenantConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.SoleTenantConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SoleTenantConfig contains the NodeAffinities to specify what shared sole
   * tenant node groups should back the node pool.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.SoleTenantConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.SoleTenantConfig)
      com.google.container.v1.SoleTenantConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SoleTenantConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SoleTenantConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.SoleTenantConfig.class,
              com.google.container.v1.SoleTenantConfig.Builder.class);
    }

    // Construct using com.google.container.v1.SoleTenantConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (nodeAffinitiesBuilder_ == null) {
        nodeAffinities_ = java.util.Collections.emptyList();
      } else {
        nodeAffinities_ = null;
        nodeAffinitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SoleTenantConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.SoleTenantConfig getDefaultInstanceForType() {
      return com.google.container.v1.SoleTenantConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.SoleTenantConfig build() {
      com.google.container.v1.SoleTenantConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.SoleTenantConfig buildPartial() {
      com.google.container.v1.SoleTenantConfig result =
          new com.google.container.v1.SoleTenantConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.SoleTenantConfig result) {
      if (nodeAffinitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          nodeAffinities_ = java.util.Collections.unmodifiableList(nodeAffinities_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.nodeAffinities_ = nodeAffinities_;
      } else {
        result.nodeAffinities_ = nodeAffinitiesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.SoleTenantConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.SoleTenantConfig) {
        return mergeFrom((com.google.container.v1.SoleTenantConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.SoleTenantConfig other) {
      if (other == com.google.container.v1.SoleTenantConfig.getDefaultInstance()) return this;
      if (nodeAffinitiesBuilder_ == null) {
        if (!other.nodeAffinities_.isEmpty()) {
          if (nodeAffinities_.isEmpty()) {
            nodeAffinities_ = other.nodeAffinities_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureNodeAffinitiesIsMutable();
            nodeAffinities_.addAll(other.nodeAffinities_);
          }
          onChanged();
        }
      } else {
        if (!other.nodeAffinities_.isEmpty()) {
          if (nodeAffinitiesBuilder_.isEmpty()) {
            nodeAffinitiesBuilder_.dispose();
            nodeAffinitiesBuilder_ = null;
            nodeAffinities_ = other.nodeAffinities_;
            bitField0_ = (bitField0_ & ~0x00000001);
            nodeAffinitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodeAffinitiesFieldBuilder()
                    : null;
          } else {
            nodeAffinitiesBuilder_.addAllMessages(other.nodeAffinities_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.container.v1.SoleTenantConfig.NodeAffinity m =
                    input.readMessage(
                        com.google.container.v1.SoleTenantConfig.NodeAffinity.parser(),
                        extensionRegistry);
                if (nodeAffinitiesBuilder_ == null) {
                  ensureNodeAffinitiesIsMutable();
                  nodeAffinities_.add(m);
                } else {
                  nodeAffinitiesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.container.v1.SoleTenantConfig.NodeAffinity> nodeAffinities_ =
        java.util.Collections.emptyList();

    private void ensureNodeAffinitiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        nodeAffinities_ =
            new java.util.ArrayList<com.google.container.v1.SoleTenantConfig.NodeAffinity>(
                nodeAffinities_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.SoleTenantConfig.NodeAffinity,
            com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder,
            com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder>
        nodeAffinitiesBuilder_;

    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public java.util.List<com.google.container.v1.SoleTenantConfig.NodeAffinity>
        getNodeAffinitiesList() {
      if (nodeAffinitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodeAffinities_);
      } else {
        return nodeAffinitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public int getNodeAffinitiesCount() {
      if (nodeAffinitiesBuilder_ == null) {
        return nodeAffinities_.size();
      } else {
        return nodeAffinitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public com.google.container.v1.SoleTenantConfig.NodeAffinity getNodeAffinities(int index) {
      if (nodeAffinitiesBuilder_ == null) {
        return nodeAffinities_.get(index);
      } else {
        return nodeAffinitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder setNodeAffinities(
        int index, com.google.container.v1.SoleTenantConfig.NodeAffinity value) {
      if (nodeAffinitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.set(index, value);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder setNodeAffinities(
        int index, com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder builderForValue) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodeAffinitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder addNodeAffinities(com.google.container.v1.SoleTenantConfig.NodeAffinity value) {
      if (nodeAffinitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(value);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder addNodeAffinities(
        int index, com.google.container.v1.SoleTenantConfig.NodeAffinity value) {
      if (nodeAffinitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(index, value);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder addNodeAffinities(
        com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder builderForValue) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(builderForValue.build());
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder addNodeAffinities(
        int index, com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder builderForValue) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder addAllNodeAffinities(
        java.lang.Iterable<? extends com.google.container.v1.SoleTenantConfig.NodeAffinity>
            values) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodeAffinities_);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder clearNodeAffinities() {
      if (nodeAffinitiesBuilder_ == null) {
        nodeAffinities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public Builder removeNodeAffinities(int index) {
      if (nodeAffinitiesBuilder_ == null) {
        ensureNodeAffinitiesIsMutable();
        nodeAffinities_.remove(index);
        onChanged();
      } else {
        nodeAffinitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder getNodeAffinitiesBuilder(
        int index) {
      return getNodeAffinitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder
        getNodeAffinitiesOrBuilder(int index) {
      if (nodeAffinitiesBuilder_ == null) {
        return nodeAffinities_.get(index);
      } else {
        return nodeAffinitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public java.util.List<? extends com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder>
        getNodeAffinitiesOrBuilderList() {
      if (nodeAffinitiesBuilder_ != null) {
        return nodeAffinitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodeAffinities_);
      }
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder
        addNodeAffinitiesBuilder() {
      return getNodeAffinitiesFieldBuilder()
          .addBuilder(com.google.container.v1.SoleTenantConfig.NodeAffinity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder addNodeAffinitiesBuilder(
        int index) {
      return getNodeAffinitiesFieldBuilder()
          .addBuilder(
              index, com.google.container.v1.SoleTenantConfig.NodeAffinity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * NodeAffinities used to match to a shared sole tenant node group.
     * </pre>
     *
     * <code>repeated .google.container.v1.SoleTenantConfig.NodeAffinity node_affinities = 1;</code>
     */
    public java.util.List<com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder>
        getNodeAffinitiesBuilderList() {
      return getNodeAffinitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.SoleTenantConfig.NodeAffinity,
            com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder,
            com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder>
        getNodeAffinitiesFieldBuilder() {
      if (nodeAffinitiesBuilder_ == null) {
        nodeAffinitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.SoleTenantConfig.NodeAffinity,
                com.google.container.v1.SoleTenantConfig.NodeAffinity.Builder,
                com.google.container.v1.SoleTenantConfig.NodeAffinityOrBuilder>(
                nodeAffinities_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        nodeAffinities_ = null;
      }
      return nodeAffinitiesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.SoleTenantConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.SoleTenantConfig)
  private static final com.google.container.v1.SoleTenantConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.SoleTenantConfig();
  }

  public static com.google.container.v1.SoleTenantConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SoleTenantConfig> PARSER =
      new com.google.protobuf.AbstractParser<SoleTenantConfig>() {
        @java.lang.Override
        public SoleTenantConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SoleTenantConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SoleTenantConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.SoleTenantConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
