/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * UpdateNodePoolRequests update a node pool's image and/or version.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.UpdateNodePoolRequest}
 */
public final class UpdateNodePoolRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.UpdateNodePoolRequest)
    UpdateNodePoolRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateNodePoolRequest.newBuilder() to construct.
  private UpdateNodePoolRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateNodePoolRequest() {
    projectId_ = "";
    zone_ = "";
    clusterId_ = "";
    nodePoolId_ = "";
    nodeVersion_ = "";
    imageType_ = "";
    name_ = "";
    locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    etag_ = "";
    accelerators_ = java.util.Collections.emptyList();
    machineType_ = "";
    diskType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateNodePoolRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UpdateNodePoolRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UpdateNodePoolRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.UpdateNodePoolRequest.class,
            com.google.container.v1.UpdateNodePoolRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2785
   * @return The projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2785
   * @return The bytes for projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2791
   * @return The zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2791
   * @return The bytes for zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the cluster to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2795
   * @return The clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getClusterId() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the cluster to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2795
   * @return The bytes for clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getClusterIdBytes() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_POOL_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodePoolId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the node pool to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string node_pool_id = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2799
   * @return The nodePoolId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getNodePoolId() {
    java.lang.Object ref = nodePoolId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodePoolId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the node pool to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string node_pool_id = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2799
   * @return The bytes for nodePoolId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getNodePoolIdBytes() {
    java.lang.Object ref = nodePoolId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodePoolId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodeVersion_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Kubernetes version to change the nodes to (typically an
   * upgrade).
   *
   * Users may specify either explicit versions offered by Kubernetes Engine or
   * version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the Kubernetes master version
   * </pre>
   *
   * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The nodeVersion.
   */
  @java.lang.Override
  public java.lang.String getNodeVersion() {
    java.lang.Object ref = nodeVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodeVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Kubernetes version to change the nodes to (typically an
   * upgrade).
   *
   * Users may specify either explicit versions offered by Kubernetes Engine or
   * version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the Kubernetes master version
   * </pre>
   *
   * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for nodeVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNodeVersionBytes() {
    java.lang.Object ref = nodeVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodeVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_TYPE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageType_ = "";
  /**
   *
   *
   * <pre>
   * Required. The desired image type for the node pool. Please see
   * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
   * available image types.
   * </pre>
   *
   * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The imageType.
   */
  @java.lang.Override
  public java.lang.String getImageType() {
    java.lang.Object ref = imageType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The desired image type for the node pool. Please see
   * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
   * available image types.
   * </pre>
   *
   * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for imageType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageTypeBytes() {
    java.lang.Object ref = imageType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster, node pool) of the node pool to
   * update. Specified in the format
   * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
   * </pre>
   *
   * <code>string name = 8;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster, node pool) of the node pool to
   * update. Specified in the format
   * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
   * </pre>
   *
   * <code>string name = 8;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList locations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * node pool's nodes should be located. Changing the locations for a node pool
   * will result in nodes being either created or removed from the node pool,
   * depending on whether locations are being added or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return A list containing the locations.
   */
  public com.google.protobuf.ProtocolStringList getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * node pool's nodes should be located. Changing the locations for a node pool
   * will result in nodes being either created or removed from the node pool,
   * depending on whether locations are being added or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return The count of locations.
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * node pool's nodes should be located. Changing the locations for a node pool
   * will result in nodes being either created or removed from the node pool,
   * depending on whether locations are being added or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  public java.lang.String getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * node pool's nodes should be located. Changing the locations for a node pool
   * will result in nodes being either created or removed from the node pool,
   * depending on whether locations are being added or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  public com.google.protobuf.ByteString getLocationsBytes(int index) {
    return locations_.getByteString(index);
  }

  public static final int WORKLOAD_METADATA_CONFIG_FIELD_NUMBER = 14;
  private com.google.container.v1.WorkloadMetadataConfig workloadMetadataConfig_;
  /**
   *
   *
   * <pre>
   * The desired workload metadata config for the node pool.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
   *
   * @return Whether the workloadMetadataConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkloadMetadataConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired workload metadata config for the node pool.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
   *
   * @return The workloadMetadataConfig.
   */
  @java.lang.Override
  public com.google.container.v1.WorkloadMetadataConfig getWorkloadMetadataConfig() {
    return workloadMetadataConfig_ == null
        ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
        : workloadMetadataConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired workload metadata config for the node pool.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
   */
  @java.lang.Override
  public com.google.container.v1.WorkloadMetadataConfigOrBuilder
      getWorkloadMetadataConfigOrBuilder() {
    return workloadMetadataConfig_ == null
        ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
        : workloadMetadataConfig_;
  }

  public static final int UPGRADE_SETTINGS_FIELD_NUMBER = 15;
  private com.google.container.v1.NodePool.UpgradeSettings upgradeSettings_;
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
   *
   * @return Whether the upgradeSettings field is set.
   */
  @java.lang.Override
  public boolean hasUpgradeSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
   *
   * @return The upgradeSettings.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.UpgradeSettings getUpgradeSettings() {
    return upgradeSettings_ == null
        ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
        : upgradeSettings_;
  }
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.UpgradeSettingsOrBuilder getUpgradeSettingsOrBuilder() {
    return upgradeSettings_ == null
        ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
        : upgradeSettings_;
  }

  public static final int TAGS_FIELD_NUMBER = 16;
  private com.google.container.v1.NetworkTags tags_;
  /**
   *
   *
   * <pre>
   * The desired network tags to be applied to all nodes in the node pool.
   * If this field is not present, the tags will not be changed. Otherwise,
   * the existing network tags will be *replaced* with the provided tags.
   * </pre>
   *
   * <code>.google.container.v1.NetworkTags tags = 16;</code>
   *
   * @return Whether the tags field is set.
   */
  @java.lang.Override
  public boolean hasTags() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired network tags to be applied to all nodes in the node pool.
   * If this field is not present, the tags will not be changed. Otherwise,
   * the existing network tags will be *replaced* with the provided tags.
   * </pre>
   *
   * <code>.google.container.v1.NetworkTags tags = 16;</code>
   *
   * @return The tags.
   */
  @java.lang.Override
  public com.google.container.v1.NetworkTags getTags() {
    return tags_ == null ? com.google.container.v1.NetworkTags.getDefaultInstance() : tags_;
  }
  /**
   *
   *
   * <pre>
   * The desired network tags to be applied to all nodes in the node pool.
   * If this field is not present, the tags will not be changed. Otherwise,
   * the existing network tags will be *replaced* with the provided tags.
   * </pre>
   *
   * <code>.google.container.v1.NetworkTags tags = 16;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NetworkTagsOrBuilder getTagsOrBuilder() {
    return tags_ == null ? com.google.container.v1.NetworkTags.getDefaultInstance() : tags_;
  }

  public static final int TAINTS_FIELD_NUMBER = 17;
  private com.google.container.v1.NodeTaints taints_;
  /**
   *
   *
   * <pre>
   * The desired node taints to be applied to all nodes in the node pool.
   * If this field is not present, the taints will not be changed. Otherwise,
   * the existing node taints will be *replaced* with the provided taints.
   * </pre>
   *
   * <code>.google.container.v1.NodeTaints taints = 17;</code>
   *
   * @return Whether the taints field is set.
   */
  @java.lang.Override
  public boolean hasTaints() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired node taints to be applied to all nodes in the node pool.
   * If this field is not present, the taints will not be changed. Otherwise,
   * the existing node taints will be *replaced* with the provided taints.
   * </pre>
   *
   * <code>.google.container.v1.NodeTaints taints = 17;</code>
   *
   * @return The taints.
   */
  @java.lang.Override
  public com.google.container.v1.NodeTaints getTaints() {
    return taints_ == null ? com.google.container.v1.NodeTaints.getDefaultInstance() : taints_;
  }
  /**
   *
   *
   * <pre>
   * The desired node taints to be applied to all nodes in the node pool.
   * If this field is not present, the taints will not be changed. Otherwise,
   * the existing node taints will be *replaced* with the provided taints.
   * </pre>
   *
   * <code>.google.container.v1.NodeTaints taints = 17;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeTaintsOrBuilder getTaintsOrBuilder() {
    return taints_ == null ? com.google.container.v1.NodeTaints.getDefaultInstance() : taints_;
  }

  public static final int LABELS_FIELD_NUMBER = 18;
  private com.google.container.v1.NodeLabels labels_;
  /**
   *
   *
   * <pre>
   * The desired node labels to be applied to all nodes in the node pool.
   * If this field is not present, the labels will not be changed. Otherwise,
   * the existing node labels will be *replaced* with the provided labels.
   * </pre>
   *
   * <code>.google.container.v1.NodeLabels labels = 18;</code>
   *
   * @return Whether the labels field is set.
   */
  @java.lang.Override
  public boolean hasLabels() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired node labels to be applied to all nodes in the node pool.
   * If this field is not present, the labels will not be changed. Otherwise,
   * the existing node labels will be *replaced* with the provided labels.
   * </pre>
   *
   * <code>.google.container.v1.NodeLabels labels = 18;</code>
   *
   * @return The labels.
   */
  @java.lang.Override
  public com.google.container.v1.NodeLabels getLabels() {
    return labels_ == null ? com.google.container.v1.NodeLabels.getDefaultInstance() : labels_;
  }
  /**
   *
   *
   * <pre>
   * The desired node labels to be applied to all nodes in the node pool.
   * If this field is not present, the labels will not be changed. Otherwise,
   * the existing node labels will be *replaced* with the provided labels.
   * </pre>
   *
   * <code>.google.container.v1.NodeLabels labels = 18;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeLabelsOrBuilder getLabelsOrBuilder() {
    return labels_ == null ? com.google.container.v1.NodeLabels.getDefaultInstance() : labels_;
  }

  public static final int LINUX_NODE_CONFIG_FIELD_NUMBER = 19;
  private com.google.container.v1.LinuxNodeConfig linuxNodeConfig_;
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Linux nodes.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
   *
   * @return Whether the linuxNodeConfig field is set.
   */
  @java.lang.Override
  public boolean hasLinuxNodeConfig() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Linux nodes.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
   *
   * @return The linuxNodeConfig.
   */
  @java.lang.Override
  public com.google.container.v1.LinuxNodeConfig getLinuxNodeConfig() {
    return linuxNodeConfig_ == null
        ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
        : linuxNodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Linux nodes.
   * </pre>
   *
   * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
   */
  @java.lang.Override
  public com.google.container.v1.LinuxNodeConfigOrBuilder getLinuxNodeConfigOrBuilder() {
    return linuxNodeConfig_ == null
        ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
        : linuxNodeConfig_;
  }

  public static final int KUBELET_CONFIG_FIELD_NUMBER = 20;
  private com.google.container.v1.NodeKubeletConfig kubeletConfig_;
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
   *
   * @return Whether the kubeletConfig field is set.
   */
  @java.lang.Override
  public boolean hasKubeletConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
   *
   * @return The kubeletConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodeKubeletConfig getKubeletConfig() {
    return kubeletConfig_ == null
        ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
        : kubeletConfig_;
  }
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeKubeletConfigOrBuilder getKubeletConfigOrBuilder() {
    return kubeletConfig_ == null
        ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
        : kubeletConfig_;
  }

  public static final int NODE_NETWORK_CONFIG_FIELD_NUMBER = 21;
  private com.google.container.v1.NodeNetworkConfig nodeNetworkConfig_;
  /**
   *
   *
   * <pre>
   * Node network config.
   * </pre>
   *
   * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
   *
   * @return Whether the nodeNetworkConfig field is set.
   */
  @java.lang.Override
  public boolean hasNodeNetworkConfig() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Node network config.
   * </pre>
   *
   * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
   *
   * @return The nodeNetworkConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodeNetworkConfig getNodeNetworkConfig() {
    return nodeNetworkConfig_ == null
        ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
        : nodeNetworkConfig_;
  }
  /**
   *
   *
   * <pre>
   * Node network config.
   * </pre>
   *
   * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodeNetworkConfigOrBuilder getNodeNetworkConfigOrBuilder() {
    return nodeNetworkConfig_ == null
        ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
        : nodeNetworkConfig_;
  }

  public static final int GCFS_CONFIG_FIELD_NUMBER = 22;
  private com.google.container.v1.GcfsConfig gcfsConfig_;
  /**
   *
   *
   * <pre>
   * GCFS config.
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
   *
   * @return Whether the gcfsConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcfsConfig() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * GCFS config.
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
   *
   * @return The gcfsConfig.
   */
  @java.lang.Override
  public com.google.container.v1.GcfsConfig getGcfsConfig() {
    return gcfsConfig_ == null
        ? com.google.container.v1.GcfsConfig.getDefaultInstance()
        : gcfsConfig_;
  }
  /**
   *
   *
   * <pre>
   * GCFS config.
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
   */
  @java.lang.Override
  public com.google.container.v1.GcfsConfigOrBuilder getGcfsConfigOrBuilder() {
    return gcfsConfig_ == null
        ? com.google.container.v1.GcfsConfig.getDefaultInstance()
        : gcfsConfig_;
  }

  public static final int CONFIDENTIAL_NODES_FIELD_NUMBER = 23;
  private com.google.container.v1.ConfidentialNodes confidentialNodes_;
  /**
   *
   *
   * <pre>
   * Confidential nodes config.
   * All the nodes in the node pool will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
   *
   * @return Whether the confidentialNodes field is set.
   */
  @java.lang.Override
  public boolean hasConfidentialNodes() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Confidential nodes config.
   * All the nodes in the node pool will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
   *
   * @return The confidentialNodes.
   */
  @java.lang.Override
  public com.google.container.v1.ConfidentialNodes getConfidentialNodes() {
    return confidentialNodes_ == null
        ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
        : confidentialNodes_;
  }
  /**
   *
   *
   * <pre>
   * Confidential nodes config.
   * All the nodes in the node pool will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder() {
    return confidentialNodes_ == null
        ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
        : confidentialNodes_;
  }

  public static final int GVNIC_FIELD_NUMBER = 29;
  private com.google.container.v1.VirtualNIC gvnic_;
  /**
   *
   *
   * <pre>
   * Enable or disable gvnic on the node pool.
   * </pre>
   *
   * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
   *
   * @return Whether the gvnic field is set.
   */
  @java.lang.Override
  public boolean hasGvnic() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable or disable gvnic on the node pool.
   * </pre>
   *
   * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
   *
   * @return The gvnic.
   */
  @java.lang.Override
  public com.google.container.v1.VirtualNIC getGvnic() {
    return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
  }
  /**
   *
   *
   * <pre>
   * Enable or disable gvnic on the node pool.
   * </pre>
   *
   * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
   */
  @java.lang.Override
  public com.google.container.v1.VirtualNICOrBuilder getGvnicOrBuilder() {
    return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
  }

  public static final int ETAG_FIELD_NUMBER = 30;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The current etag of the node pool.
   * If an etag is provided and does not match the current etag of the node
   * pool, update will be blocked and an ABORTED error will be returned.
   * </pre>
   *
   * <code>string etag = 30;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current etag of the node pool.
   * If an etag is provided and does not match the current etag of the node
   * pool, update will be blocked and an ABORTED error will be returned.
   * </pre>
   *
   * <code>string etag = 30;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAST_SOCKET_FIELD_NUMBER = 31;
  private com.google.container.v1.FastSocket fastSocket_;
  /**
   *
   *
   * <pre>
   * Enable or disable NCCL fast socket for the node pool.
   * </pre>
   *
   * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
   *
   * @return Whether the fastSocket field is set.
   */
  @java.lang.Override
  public boolean hasFastSocket() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable or disable NCCL fast socket for the node pool.
   * </pre>
   *
   * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
   *
   * @return The fastSocket.
   */
  @java.lang.Override
  public com.google.container.v1.FastSocket getFastSocket() {
    return fastSocket_ == null
        ? com.google.container.v1.FastSocket.getDefaultInstance()
        : fastSocket_;
  }
  /**
   *
   *
   * <pre>
   * Enable or disable NCCL fast socket for the node pool.
   * </pre>
   *
   * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
   */
  @java.lang.Override
  public com.google.container.v1.FastSocketOrBuilder getFastSocketOrBuilder() {
    return fastSocket_ == null
        ? com.google.container.v1.FastSocket.getDefaultInstance()
        : fastSocket_;
  }

  public static final int LOGGING_CONFIG_FIELD_NUMBER = 32;
  private com.google.container.v1.NodePoolLoggingConfig loggingConfig_;
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
   *
   * @return Whether the loggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasLoggingConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
   *
   * @return The loggingConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolLoggingConfig getLoggingConfig() {
    return loggingConfig_ == null
        ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolLoggingConfigOrBuilder getLoggingConfigOrBuilder() {
    return loggingConfig_ == null
        ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }

  public static final int RESOURCE_LABELS_FIELD_NUMBER = 33;
  private com.google.container.v1.ResourceLabels resourceLabels_;
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
   *
   * @return Whether the resourceLabels field is set.
   */
  @java.lang.Override
  public boolean hasResourceLabels() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
   *
   * @return The resourceLabels.
   */
  @java.lang.Override
  public com.google.container.v1.ResourceLabels getResourceLabels() {
    return resourceLabels_ == null
        ? com.google.container.v1.ResourceLabels.getDefaultInstance()
        : resourceLabels_;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the node pool to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ResourceLabelsOrBuilder getResourceLabelsOrBuilder() {
    return resourceLabels_ == null
        ? com.google.container.v1.ResourceLabels.getDefaultInstance()
        : resourceLabels_;
  }

  public static final int WINDOWS_NODE_CONFIG_FIELD_NUMBER = 34;
  private com.google.container.v1.WindowsNodeConfig windowsNodeConfig_;
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Windows nodes.
   * </pre>
   *
   * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
   *
   * @return Whether the windowsNodeConfig field is set.
   */
  @java.lang.Override
  public boolean hasWindowsNodeConfig() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Windows nodes.
   * </pre>
   *
   * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
   *
   * @return The windowsNodeConfig.
   */
  @java.lang.Override
  public com.google.container.v1.WindowsNodeConfig getWindowsNodeConfig() {
    return windowsNodeConfig_ == null
        ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
        : windowsNodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters that can be configured on Windows nodes.
   * </pre>
   *
   * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
   */
  @java.lang.Override
  public com.google.container.v1.WindowsNodeConfigOrBuilder getWindowsNodeConfigOrBuilder() {
    return windowsNodeConfig_ == null
        ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
        : windowsNodeConfig_;
  }

  public static final int ACCELERATORS_FIELD_NUMBER = 35;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.AcceleratorConfig> accelerators_;
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.AcceleratorConfig> getAcceleratorsList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.AcceleratorConfigOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
   */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AcceleratorConfig getAccelerators(int index) {
    return accelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of hardware accelerators to be attached to each node.
   * See https://cloud.google.com/compute/docs/gpus for more information about
   * support for GPUs.
   * </pre>
   *
   * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
    return accelerators_.get(index);
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 36;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The desired [Google Compute Engine machine
   * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
   * node pool. Initiates an upgrade operation that migrates the nodes in the
   * node pool to the specified machine type.
   * </pre>
   *
   * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The desired [Google Compute Engine machine
   * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
   * node pool. Initiates an upgrade operation that migrates the nodes in the
   * node pool to the specified machine type.
   * </pre>
   *
   * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_TYPE_FIELD_NUMBER = 37;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
   * 'pd-balanced') for nodes in the node pool.
   * Initiates an upgrade operation that migrates the nodes in the
   * node pool to the specified disk type.
   * </pre>
   *
   * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The diskType.
   */
  @java.lang.Override
  public java.lang.String getDiskType() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
   * 'pd-balanced') for nodes in the node pool.
   * Initiates an upgrade operation that migrates the nodes in the
   * node pool to the specified disk type.
   * </pre>
   *
   * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for diskType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskTypeBytes() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 38;
  private long diskSizeGb_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. The desired disk size for nodes in the node pool specified in GB.
   * The smallest allowed disk size is 10GB.
   * Initiates an upgrade operation that migrates the nodes in the
   * node pool to the specified disk size.
   * </pre>
   *
   * <code>int64 disk_size_gb = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public long getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int RESOURCE_MANAGER_TAGS_FIELD_NUMBER = 39;
  private com.google.container.v1.ResourceManagerTags resourceManagerTags_;
  /**
   *
   *
   * <pre>
   * Desired resource manager tag keys and values to be attached to the nodes
   * for managing Compute Engine firewalls using Network Firewall Policies.
   * Existing tags will be replaced with new values.
   * </pre>
   *
   * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
   *
   * @return Whether the resourceManagerTags field is set.
   */
  @java.lang.Override
  public boolean hasResourceManagerTags() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Desired resource manager tag keys and values to be attached to the nodes
   * for managing Compute Engine firewalls using Network Firewall Policies.
   * Existing tags will be replaced with new values.
   * </pre>
   *
   * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
   *
   * @return The resourceManagerTags.
   */
  @java.lang.Override
  public com.google.container.v1.ResourceManagerTags getResourceManagerTags() {
    return resourceManagerTags_ == null
        ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
        : resourceManagerTags_;
  }
  /**
   *
   *
   * <pre>
   * Desired resource manager tag keys and values to be attached to the nodes
   * for managing Compute Engine firewalls using Network Firewall Policies.
   * Existing tags will be replaced with new values.
   * </pre>
   *
   * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ResourceManagerTagsOrBuilder getResourceManagerTagsOrBuilder() {
    return resourceManagerTags_ == null
        ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
        : resourceManagerTags_;
  }

  public static final int CONTAINERD_CONFIG_FIELD_NUMBER = 40;
  private com.google.container.v1.ContainerdConfig containerdConfig_;
  /**
   *
   *
   * <pre>
   * The desired containerd config for nodes in the node pool.
   * Initiates an upgrade operation that recreates the nodes with the new
   * config.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
   *
   * @return Whether the containerdConfig field is set.
   */
  @java.lang.Override
  public boolean hasContainerdConfig() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired containerd config for nodes in the node pool.
   * Initiates an upgrade operation that recreates the nodes with the new
   * config.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
   *
   * @return The containerdConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ContainerdConfig getContainerdConfig() {
    return containerdConfig_ == null
        ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
        : containerdConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired containerd config for nodes in the node pool.
   * Initiates an upgrade operation that recreates the nodes with the new
   * config.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ContainerdConfigOrBuilder getContainerdConfigOrBuilder() {
    return containerdConfig_ == null
        ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
        : containerdConfig_;
  }

  public static final int QUEUED_PROVISIONING_FIELD_NUMBER = 42;
  private com.google.container.v1.NodePool.QueuedProvisioning queuedProvisioning_;
  /**
   *
   *
   * <pre>
   * Specifies the configuration of queued provisioning.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
   *
   * @return Whether the queuedProvisioning field is set.
   */
  @java.lang.Override
  public boolean hasQueuedProvisioning() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the configuration of queued provisioning.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
   *
   * @return The queuedProvisioning.
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.QueuedProvisioning getQueuedProvisioning() {
    return queuedProvisioning_ == null
        ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
        : queuedProvisioning_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the configuration of queued provisioning.
   * </pre>
   *
   * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool.QueuedProvisioningOrBuilder
      getQueuedProvisioningOrBuilder() {
    return queuedProvisioning_ == null
        ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
        : queuedProvisioning_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clusterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodePoolId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, nodePoolId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, nodeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, imageType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, name_);
    }
    for (int i = 0; i < locations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, locations_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(14, getWorkloadMetadataConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(15, getUpgradeSettings());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(16, getTags());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(17, getTaints());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(18, getLabels());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(19, getLinuxNodeConfig());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(20, getKubeletConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(21, getNodeNetworkConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(22, getGcfsConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(23, getConfidentialNodes());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(29, getGvnic());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30, etag_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(31, getFastSocket());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(32, getLoggingConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(33, getResourceLabels());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(34, getWindowsNodeConfig());
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(35, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 36, machineType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37, diskType_);
    }
    if (diskSizeGb_ != 0L) {
      output.writeInt64(38, diskSizeGb_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(39, getResourceManagerTags());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeMessage(40, getContainerdConfig());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(42, getQueuedProvisioning());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clusterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodePoolId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, nodePoolId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, nodeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, imageType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < locations_.size(); i++) {
        dataSize += computeStringSizeNoTag(locations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getWorkloadMetadataConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getUpgradeSettings());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getTags());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getTaints());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getLabels());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getLinuxNodeConfig());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getKubeletConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getNodeNetworkConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getGcfsConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getConfidentialNodes());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getGvnic());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, etag_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getFastSocket());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, getLoggingConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(33, getResourceLabels());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(34, getWindowsNodeConfig());
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(35, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(36, machineType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37, diskType_);
    }
    if (diskSizeGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(38, diskSizeGb_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(39, getResourceManagerTags());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(40, getContainerdConfig());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(42, getQueuedProvisioning());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.UpdateNodePoolRequest)) {
      return super.equals(obj);
    }
    com.google.container.v1.UpdateNodePoolRequest other =
        (com.google.container.v1.UpdateNodePoolRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (!getClusterId().equals(other.getClusterId())) return false;
    if (!getNodePoolId().equals(other.getNodePoolId())) return false;
    if (!getNodeVersion().equals(other.getNodeVersion())) return false;
    if (!getImageType().equals(other.getImageType())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (hasWorkloadMetadataConfig() != other.hasWorkloadMetadataConfig()) return false;
    if (hasWorkloadMetadataConfig()) {
      if (!getWorkloadMetadataConfig().equals(other.getWorkloadMetadataConfig())) return false;
    }
    if (hasUpgradeSettings() != other.hasUpgradeSettings()) return false;
    if (hasUpgradeSettings()) {
      if (!getUpgradeSettings().equals(other.getUpgradeSettings())) return false;
    }
    if (hasTags() != other.hasTags()) return false;
    if (hasTags()) {
      if (!getTags().equals(other.getTags())) return false;
    }
    if (hasTaints() != other.hasTaints()) return false;
    if (hasTaints()) {
      if (!getTaints().equals(other.getTaints())) return false;
    }
    if (hasLabels() != other.hasLabels()) return false;
    if (hasLabels()) {
      if (!getLabels().equals(other.getLabels())) return false;
    }
    if (hasLinuxNodeConfig() != other.hasLinuxNodeConfig()) return false;
    if (hasLinuxNodeConfig()) {
      if (!getLinuxNodeConfig().equals(other.getLinuxNodeConfig())) return false;
    }
    if (hasKubeletConfig() != other.hasKubeletConfig()) return false;
    if (hasKubeletConfig()) {
      if (!getKubeletConfig().equals(other.getKubeletConfig())) return false;
    }
    if (hasNodeNetworkConfig() != other.hasNodeNetworkConfig()) return false;
    if (hasNodeNetworkConfig()) {
      if (!getNodeNetworkConfig().equals(other.getNodeNetworkConfig())) return false;
    }
    if (hasGcfsConfig() != other.hasGcfsConfig()) return false;
    if (hasGcfsConfig()) {
      if (!getGcfsConfig().equals(other.getGcfsConfig())) return false;
    }
    if (hasConfidentialNodes() != other.hasConfidentialNodes()) return false;
    if (hasConfidentialNodes()) {
      if (!getConfidentialNodes().equals(other.getConfidentialNodes())) return false;
    }
    if (hasGvnic() != other.hasGvnic()) return false;
    if (hasGvnic()) {
      if (!getGvnic().equals(other.getGvnic())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasFastSocket() != other.hasFastSocket()) return false;
    if (hasFastSocket()) {
      if (!getFastSocket().equals(other.getFastSocket())) return false;
    }
    if (hasLoggingConfig() != other.hasLoggingConfig()) return false;
    if (hasLoggingConfig()) {
      if (!getLoggingConfig().equals(other.getLoggingConfig())) return false;
    }
    if (hasResourceLabels() != other.hasResourceLabels()) return false;
    if (hasResourceLabels()) {
      if (!getResourceLabels().equals(other.getResourceLabels())) return false;
    }
    if (hasWindowsNodeConfig() != other.hasWindowsNodeConfig()) return false;
    if (hasWindowsNodeConfig()) {
      if (!getWindowsNodeConfig().equals(other.getWindowsNodeConfig())) return false;
    }
    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (!getMachineType().equals(other.getMachineType())) return false;
    if (!getDiskType().equals(other.getDiskType())) return false;
    if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    if (hasResourceManagerTags() != other.hasResourceManagerTags()) return false;
    if (hasResourceManagerTags()) {
      if (!getResourceManagerTags().equals(other.getResourceManagerTags())) return false;
    }
    if (hasContainerdConfig() != other.hasContainerdConfig()) return false;
    if (hasContainerdConfig()) {
      if (!getContainerdConfig().equals(other.getContainerdConfig())) return false;
    }
    if (hasQueuedProvisioning() != other.hasQueuedProvisioning()) return false;
    if (hasQueuedProvisioning()) {
      if (!getQueuedProvisioning().equals(other.getQueuedProvisioning())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterId().hashCode();
    hash = (37 * hash) + NODE_POOL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getNodePoolId().hashCode();
    hash = (37 * hash) + NODE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getNodeVersion().hashCode();
    hash = (37 * hash) + IMAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getImageType().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    if (hasWorkloadMetadataConfig()) {
      hash = (37 * hash) + WORKLOAD_METADATA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkloadMetadataConfig().hashCode();
    }
    if (hasUpgradeSettings()) {
      hash = (37 * hash) + UPGRADE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getUpgradeSettings().hashCode();
    }
    if (hasTags()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTags().hashCode();
    }
    if (hasTaints()) {
      hash = (37 * hash) + TAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getTaints().hashCode();
    }
    if (hasLabels()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabels().hashCode();
    }
    if (hasLinuxNodeConfig()) {
      hash = (37 * hash) + LINUX_NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLinuxNodeConfig().hashCode();
    }
    if (hasKubeletConfig()) {
      hash = (37 * hash) + KUBELET_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getKubeletConfig().hashCode();
    }
    if (hasNodeNetworkConfig()) {
      hash = (37 * hash) + NODE_NETWORK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodeNetworkConfig().hashCode();
    }
    if (hasGcfsConfig()) {
      hash = (37 * hash) + GCFS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGcfsConfig().hashCode();
    }
    if (hasConfidentialNodes()) {
      hash = (37 * hash) + CONFIDENTIAL_NODES_FIELD_NUMBER;
      hash = (53 * hash) + getConfidentialNodes().hashCode();
    }
    if (hasGvnic()) {
      hash = (37 * hash) + GVNIC_FIELD_NUMBER;
      hash = (53 * hash) + getGvnic().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasFastSocket()) {
      hash = (37 * hash) + FAST_SOCKET_FIELD_NUMBER;
      hash = (53 * hash) + getFastSocket().hashCode();
    }
    if (hasLoggingConfig()) {
      hash = (37 * hash) + LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingConfig().hashCode();
    }
    if (hasResourceLabels()) {
      hash = (37 * hash) + RESOURCE_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceLabels().hashCode();
    }
    if (hasWindowsNodeConfig()) {
      hash = (37 * hash) + WINDOWS_NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWindowsNodeConfig().hashCode();
    }
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    hash = (37 * hash) + DISK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDiskType().hashCode();
    hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
    if (hasResourceManagerTags()) {
      hash = (37 * hash) + RESOURCE_MANAGER_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceManagerTags().hashCode();
    }
    if (hasContainerdConfig()) {
      hash = (37 * hash) + CONTAINERD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getContainerdConfig().hashCode();
    }
    if (hasQueuedProvisioning()) {
      hash = (37 * hash) + QUEUED_PROVISIONING_FIELD_NUMBER;
      hash = (53 * hash) + getQueuedProvisioning().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UpdateNodePoolRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.UpdateNodePoolRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * UpdateNodePoolRequests update a node pool's image and/or version.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.UpdateNodePoolRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.UpdateNodePoolRequest)
      com.google.container.v1.UpdateNodePoolRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UpdateNodePoolRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UpdateNodePoolRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.UpdateNodePoolRequest.class,
              com.google.container.v1.UpdateNodePoolRequest.Builder.class);
    }

    // Construct using com.google.container.v1.UpdateNodePoolRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWorkloadMetadataConfigFieldBuilder();
        getUpgradeSettingsFieldBuilder();
        getTagsFieldBuilder();
        getTaintsFieldBuilder();
        getLabelsFieldBuilder();
        getLinuxNodeConfigFieldBuilder();
        getKubeletConfigFieldBuilder();
        getNodeNetworkConfigFieldBuilder();
        getGcfsConfigFieldBuilder();
        getConfidentialNodesFieldBuilder();
        getGvnicFieldBuilder();
        getFastSocketFieldBuilder();
        getLoggingConfigFieldBuilder();
        getResourceLabelsFieldBuilder();
        getWindowsNodeConfigFieldBuilder();
        getAcceleratorsFieldBuilder();
        getResourceManagerTagsFieldBuilder();
        getContainerdConfigFieldBuilder();
        getQueuedProvisioningFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      zone_ = "";
      clusterId_ = "";
      nodePoolId_ = "";
      nodeVersion_ = "";
      imageType_ = "";
      name_ = "";
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      workloadMetadataConfig_ = null;
      if (workloadMetadataConfigBuilder_ != null) {
        workloadMetadataConfigBuilder_.dispose();
        workloadMetadataConfigBuilder_ = null;
      }
      upgradeSettings_ = null;
      if (upgradeSettingsBuilder_ != null) {
        upgradeSettingsBuilder_.dispose();
        upgradeSettingsBuilder_ = null;
      }
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      taints_ = null;
      if (taintsBuilder_ != null) {
        taintsBuilder_.dispose();
        taintsBuilder_ = null;
      }
      labels_ = null;
      if (labelsBuilder_ != null) {
        labelsBuilder_.dispose();
        labelsBuilder_ = null;
      }
      linuxNodeConfig_ = null;
      if (linuxNodeConfigBuilder_ != null) {
        linuxNodeConfigBuilder_.dispose();
        linuxNodeConfigBuilder_ = null;
      }
      kubeletConfig_ = null;
      if (kubeletConfigBuilder_ != null) {
        kubeletConfigBuilder_.dispose();
        kubeletConfigBuilder_ = null;
      }
      nodeNetworkConfig_ = null;
      if (nodeNetworkConfigBuilder_ != null) {
        nodeNetworkConfigBuilder_.dispose();
        nodeNetworkConfigBuilder_ = null;
      }
      gcfsConfig_ = null;
      if (gcfsConfigBuilder_ != null) {
        gcfsConfigBuilder_.dispose();
        gcfsConfigBuilder_ = null;
      }
      confidentialNodes_ = null;
      if (confidentialNodesBuilder_ != null) {
        confidentialNodesBuilder_.dispose();
        confidentialNodesBuilder_ = null;
      }
      gvnic_ = null;
      if (gvnicBuilder_ != null) {
        gvnicBuilder_.dispose();
        gvnicBuilder_ = null;
      }
      etag_ = "";
      fastSocket_ = null;
      if (fastSocketBuilder_ != null) {
        fastSocketBuilder_.dispose();
        fastSocketBuilder_ = null;
      }
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      resourceLabels_ = null;
      if (resourceLabelsBuilder_ != null) {
        resourceLabelsBuilder_.dispose();
        resourceLabelsBuilder_ = null;
      }
      windowsNodeConfig_ = null;
      if (windowsNodeConfigBuilder_ != null) {
        windowsNodeConfigBuilder_.dispose();
        windowsNodeConfigBuilder_ = null;
      }
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x01000000);
      machineType_ = "";
      diskType_ = "";
      diskSizeGb_ = 0L;
      resourceManagerTags_ = null;
      if (resourceManagerTagsBuilder_ != null) {
        resourceManagerTagsBuilder_.dispose();
        resourceManagerTagsBuilder_ = null;
      }
      containerdConfig_ = null;
      if (containerdConfigBuilder_ != null) {
        containerdConfigBuilder_.dispose();
        containerdConfigBuilder_ = null;
      }
      queuedProvisioning_ = null;
      if (queuedProvisioningBuilder_ != null) {
        queuedProvisioningBuilder_.dispose();
        queuedProvisioningBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UpdateNodePoolRequest_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.UpdateNodePoolRequest getDefaultInstanceForType() {
      return com.google.container.v1.UpdateNodePoolRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.UpdateNodePoolRequest build() {
      com.google.container.v1.UpdateNodePoolRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.UpdateNodePoolRequest buildPartial() {
      com.google.container.v1.UpdateNodePoolRequest result =
          new com.google.container.v1.UpdateNodePoolRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.UpdateNodePoolRequest result) {
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x01000000);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.UpdateNodePoolRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clusterId_ = clusterId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nodePoolId_ = nodePoolId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nodeVersion_ = nodeVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.imageType_ = imageType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        locations_.makeImmutable();
        result.locations_ = locations_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.workloadMetadataConfig_ =
            workloadMetadataConfigBuilder_ == null
                ? workloadMetadataConfig_
                : workloadMetadataConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.upgradeSettings_ =
            upgradeSettingsBuilder_ == null ? upgradeSettings_ : upgradeSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.tags_ = tagsBuilder_ == null ? tags_ : tagsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.taints_ = taintsBuilder_ == null ? taints_ : taintsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.labels_ = labelsBuilder_ == null ? labels_ : labelsBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.linuxNodeConfig_ =
            linuxNodeConfigBuilder_ == null ? linuxNodeConfig_ : linuxNodeConfigBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.kubeletConfig_ =
            kubeletConfigBuilder_ == null ? kubeletConfig_ : kubeletConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.nodeNetworkConfig_ =
            nodeNetworkConfigBuilder_ == null
                ? nodeNetworkConfig_
                : nodeNetworkConfigBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.gcfsConfig_ = gcfsConfigBuilder_ == null ? gcfsConfig_ : gcfsConfigBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.confidentialNodes_ =
            confidentialNodesBuilder_ == null
                ? confidentialNodes_
                : confidentialNodesBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.gvnic_ = gvnicBuilder_ == null ? gvnic_ : gvnicBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.fastSocket_ = fastSocketBuilder_ == null ? fastSocket_ : fastSocketBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.loggingConfig_ =
            loggingConfigBuilder_ == null ? loggingConfig_ : loggingConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.resourceLabels_ =
            resourceLabelsBuilder_ == null ? resourceLabels_ : resourceLabelsBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.windowsNodeConfig_ =
            windowsNodeConfigBuilder_ == null
                ? windowsNodeConfig_
                : windowsNodeConfigBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.machineType_ = machineType_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.diskType_ = diskType_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.resourceManagerTags_ =
            resourceManagerTagsBuilder_ == null
                ? resourceManagerTags_
                : resourceManagerTagsBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.containerdConfig_ =
            containerdConfigBuilder_ == null ? containerdConfig_ : containerdConfigBuilder_.build();
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.queuedProvisioning_ =
            queuedProvisioningBuilder_ == null
                ? queuedProvisioning_
                : queuedProvisioningBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.UpdateNodePoolRequest) {
        return mergeFrom((com.google.container.v1.UpdateNodePoolRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.UpdateNodePoolRequest other) {
      if (other == com.google.container.v1.UpdateNodePoolRequest.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClusterId().isEmpty()) {
        clusterId_ = other.clusterId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getNodePoolId().isEmpty()) {
        nodePoolId_ = other.nodePoolId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getNodeVersion().isEmpty()) {
        nodeVersion_ = other.nodeVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getImageType().isEmpty()) {
        imageType_ = other.imageType_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.locations_.isEmpty()) {
        if (locations_.isEmpty()) {
          locations_ = other.locations_;
          bitField0_ |= 0x00000080;
        } else {
          ensureLocationsIsMutable();
          locations_.addAll(other.locations_);
        }
        onChanged();
      }
      if (other.hasWorkloadMetadataConfig()) {
        mergeWorkloadMetadataConfig(other.getWorkloadMetadataConfig());
      }
      if (other.hasUpgradeSettings()) {
        mergeUpgradeSettings(other.getUpgradeSettings());
      }
      if (other.hasTags()) {
        mergeTags(other.getTags());
      }
      if (other.hasTaints()) {
        mergeTaints(other.getTaints());
      }
      if (other.hasLabels()) {
        mergeLabels(other.getLabels());
      }
      if (other.hasLinuxNodeConfig()) {
        mergeLinuxNodeConfig(other.getLinuxNodeConfig());
      }
      if (other.hasKubeletConfig()) {
        mergeKubeletConfig(other.getKubeletConfig());
      }
      if (other.hasNodeNetworkConfig()) {
        mergeNodeNetworkConfig(other.getNodeNetworkConfig());
      }
      if (other.hasGcfsConfig()) {
        mergeGcfsConfig(other.getGcfsConfig());
      }
      if (other.hasConfidentialNodes()) {
        mergeConfidentialNodes(other.getConfidentialNodes());
      }
      if (other.hasGvnic()) {
        mergeGvnic(other.getGvnic());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasFastSocket()) {
        mergeFastSocket(other.getFastSocket());
      }
      if (other.hasLoggingConfig()) {
        mergeLoggingConfig(other.getLoggingConfig());
      }
      if (other.hasResourceLabels()) {
        mergeResourceLabels(other.getResourceLabels());
      }
      if (other.hasWindowsNodeConfig()) {
        mergeWindowsNodeConfig(other.getWindowsNodeConfig());
      }
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x01000000);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x01000000);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (!other.getDiskType().isEmpty()) {
        diskType_ = other.diskType_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.getDiskSizeGb() != 0L) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (other.hasResourceManagerTags()) {
        mergeResourceManagerTags(other.getResourceManagerTags());
      }
      if (other.hasContainerdConfig()) {
        mergeContainerdConfig(other.getContainerdConfig());
      }
      if (other.hasQueuedProvisioning()) {
        mergeQueuedProvisioning(other.getQueuedProvisioning());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                clusterId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                nodePoolId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                nodeVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                imageType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationsIsMutable();
                locations_.add(s);
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getWorkloadMetadataConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getUpgradeSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getTagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getTaintsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getLabelsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getLinuxNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getKubeletConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getNodeNetworkConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getGcfsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getConfidentialNodesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 186
            case 234:
              {
                input.readMessage(getGvnicFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 234
            case 242:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(getFastSocketFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 250
            case 258:
              {
                input.readMessage(getLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 258
            case 266:
              {
                input.readMessage(getResourceLabelsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 266
            case 274:
              {
                input.readMessage(
                    getWindowsNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 274
            case 282:
              {
                com.google.container.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.container.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case 282
            case 290:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 290
            case 298:
              {
                diskType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 298
            case 304:
              {
                diskSizeGb_ = input.readInt64();
                bitField0_ |= 0x08000000;
                break;
              } // case 304
            case 314:
              {
                input.readMessage(
                    getResourceManagerTagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 314
            case 322:
              {
                input.readMessage(
                    getContainerdConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 322
            case 338:
              {
                input.readMessage(
                    getQueuedProvisioningFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 338
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2785
     * @return The projectId.
     */
    @java.lang.Deprecated
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2785
     * @return The bytes for projectId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2785
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2785
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2785
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2791
     * @return The zone.
     */
    @java.lang.Deprecated
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2791
     * @return The bytes for zone.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2791
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2791
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2791
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clusterId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2795
     * @return The clusterId.
     */
    @java.lang.Deprecated
    public java.lang.String getClusterId() {
      java.lang.Object ref = clusterId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2795
     * @return The bytes for clusterId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getClusterIdBytes() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2795
     * @param value The clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2795
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearClusterId() {
      clusterId_ = getDefaultInstance().getClusterId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2795
     * @param value The bytes for clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object nodePoolId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2799
     * @return The nodePoolId.
     */
    @java.lang.Deprecated
    public java.lang.String getNodePoolId() {
      java.lang.Object ref = nodePoolId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodePoolId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2799
     * @return The bytes for nodePoolId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getNodePoolIdBytes() {
      java.lang.Object ref = nodePoolId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodePoolId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2799
     * @param value The nodePoolId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNodePoolId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodePoolId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2799
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearNodePoolId() {
      nodePoolId_ = getDefaultInstance().getNodePoolId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.UpdateNodePoolRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2799
     * @param value The bytes for nodePoolId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNodePoolIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodePoolId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object nodeVersion_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by Kubernetes Engine or
     * version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The nodeVersion.
     */
    public java.lang.String getNodeVersion() {
      java.lang.Object ref = nodeVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by Kubernetes Engine or
     * version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for nodeVersion.
     */
    public com.google.protobuf.ByteString getNodeVersionBytes() {
      java.lang.Object ref = nodeVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by Kubernetes Engine or
     * version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The nodeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setNodeVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodeVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by Kubernetes Engine or
     * version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeVersion() {
      nodeVersion_ = getDefaultInstance().getNodeVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by Kubernetes Engine or
     * version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string node_version = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for nodeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setNodeVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodeVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object imageType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The desired image type for the node pool. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The imageType.
     */
    public java.lang.String getImageType() {
      java.lang.Object ref = imageType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired image type for the node pool. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for imageType.
     */
    public com.google.protobuf.ByteString getImageTypeBytes() {
      java.lang.Object ref = imageType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired image type for the node pool. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired image type for the node pool. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageType() {
      imageType_ = getDefaultInstance().getImageType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired image type for the node pool. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to
     * update. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to
     * update. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to
     * update. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to
     * update. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to
     * update. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 8;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList locations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLocationsIsMutable() {
      if (!locations_.isModifiable()) {
        locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return A list containing the locations.
     */
    public com.google.protobuf.ProtocolStringList getLocationsList() {
      locations_.makeImmutable();
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return The count of locations.
     */
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The locations at the given index.
     */
    public java.lang.String getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the locations at the given index.
     */
    public com.google.protobuf.ByteString getLocationsBytes(int index) {
      return locations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The locations to set.
     * @return This builder for chaining.
     */
    public Builder setLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param value The locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param values The locations to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
      ensureLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocations() {
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * node pool's nodes should be located. Changing the locations for a node pool
     * will result in nodes being either created or removed from the node pool,
     * depending on whether locations are being added or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param value The bytes of the locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.container.v1.WorkloadMetadataConfig workloadMetadataConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WorkloadMetadataConfig,
            com.google.container.v1.WorkloadMetadataConfig.Builder,
            com.google.container.v1.WorkloadMetadataConfigOrBuilder>
        workloadMetadataConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     *
     * @return Whether the workloadMetadataConfig field is set.
     */
    public boolean hasWorkloadMetadataConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     *
     * @return The workloadMetadataConfig.
     */
    public com.google.container.v1.WorkloadMetadataConfig getWorkloadMetadataConfig() {
      if (workloadMetadataConfigBuilder_ == null) {
        return workloadMetadataConfig_ == null
            ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
            : workloadMetadataConfig_;
      } else {
        return workloadMetadataConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder setWorkloadMetadataConfig(com.google.container.v1.WorkloadMetadataConfig value) {
      if (workloadMetadataConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workloadMetadataConfig_ = value;
      } else {
        workloadMetadataConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder setWorkloadMetadataConfig(
        com.google.container.v1.WorkloadMetadataConfig.Builder builderForValue) {
      if (workloadMetadataConfigBuilder_ == null) {
        workloadMetadataConfig_ = builderForValue.build();
      } else {
        workloadMetadataConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder mergeWorkloadMetadataConfig(
        com.google.container.v1.WorkloadMetadataConfig value) {
      if (workloadMetadataConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && workloadMetadataConfig_ != null
            && workloadMetadataConfig_
                != com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()) {
          getWorkloadMetadataConfigBuilder().mergeFrom(value);
        } else {
          workloadMetadataConfig_ = value;
        }
      } else {
        workloadMetadataConfigBuilder_.mergeFrom(value);
      }
      if (workloadMetadataConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public Builder clearWorkloadMetadataConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      workloadMetadataConfig_ = null;
      if (workloadMetadataConfigBuilder_ != null) {
        workloadMetadataConfigBuilder_.dispose();
        workloadMetadataConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public com.google.container.v1.WorkloadMetadataConfig.Builder
        getWorkloadMetadataConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getWorkloadMetadataConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    public com.google.container.v1.WorkloadMetadataConfigOrBuilder
        getWorkloadMetadataConfigOrBuilder() {
      if (workloadMetadataConfigBuilder_ != null) {
        return workloadMetadataConfigBuilder_.getMessageOrBuilder();
      } else {
        return workloadMetadataConfig_ == null
            ? com.google.container.v1.WorkloadMetadataConfig.getDefaultInstance()
            : workloadMetadataConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired workload metadata config for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadMetadataConfig workload_metadata_config = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WorkloadMetadataConfig,
            com.google.container.v1.WorkloadMetadataConfig.Builder,
            com.google.container.v1.WorkloadMetadataConfigOrBuilder>
        getWorkloadMetadataConfigFieldBuilder() {
      if (workloadMetadataConfigBuilder_ == null) {
        workloadMetadataConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.WorkloadMetadataConfig,
                com.google.container.v1.WorkloadMetadataConfig.Builder,
                com.google.container.v1.WorkloadMetadataConfigOrBuilder>(
                getWorkloadMetadataConfig(), getParentForChildren(), isClean());
        workloadMetadataConfig_ = null;
      }
      return workloadMetadataConfigBuilder_;
    }

    private com.google.container.v1.NodePool.UpgradeSettings upgradeSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.UpgradeSettings,
            com.google.container.v1.NodePool.UpgradeSettings.Builder,
            com.google.container.v1.NodePool.UpgradeSettingsOrBuilder>
        upgradeSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     *
     * @return Whether the upgradeSettings field is set.
     */
    public boolean hasUpgradeSettings() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     *
     * @return The upgradeSettings.
     */
    public com.google.container.v1.NodePool.UpgradeSettings getUpgradeSettings() {
      if (upgradeSettingsBuilder_ == null) {
        return upgradeSettings_ == null
            ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
            : upgradeSettings_;
      } else {
        return upgradeSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    public Builder setUpgradeSettings(com.google.container.v1.NodePool.UpgradeSettings value) {
      if (upgradeSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upgradeSettings_ = value;
      } else {
        upgradeSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    public Builder setUpgradeSettings(
        com.google.container.v1.NodePool.UpgradeSettings.Builder builderForValue) {
      if (upgradeSettingsBuilder_ == null) {
        upgradeSettings_ = builderForValue.build();
      } else {
        upgradeSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    public Builder mergeUpgradeSettings(com.google.container.v1.NodePool.UpgradeSettings value) {
      if (upgradeSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && upgradeSettings_ != null
            && upgradeSettings_
                != com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()) {
          getUpgradeSettingsBuilder().mergeFrom(value);
        } else {
          upgradeSettings_ = value;
        }
      } else {
        upgradeSettingsBuilder_.mergeFrom(value);
      }
      if (upgradeSettings_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    public Builder clearUpgradeSettings() {
      bitField0_ = (bitField0_ & ~0x00000200);
      upgradeSettings_ = null;
      if (upgradeSettingsBuilder_ != null) {
        upgradeSettingsBuilder_.dispose();
        upgradeSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    public com.google.container.v1.NodePool.UpgradeSettings.Builder getUpgradeSettingsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpgradeSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    public com.google.container.v1.NodePool.UpgradeSettingsOrBuilder getUpgradeSettingsOrBuilder() {
      if (upgradeSettingsBuilder_ != null) {
        return upgradeSettingsBuilder_.getMessageOrBuilder();
      } else {
        return upgradeSettings_ == null
            ? com.google.container.v1.NodePool.UpgradeSettings.getDefaultInstance()
            : upgradeSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.UpgradeSettings upgrade_settings = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.UpgradeSettings,
            com.google.container.v1.NodePool.UpgradeSettings.Builder,
            com.google.container.v1.NodePool.UpgradeSettingsOrBuilder>
        getUpgradeSettingsFieldBuilder() {
      if (upgradeSettingsBuilder_ == null) {
        upgradeSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePool.UpgradeSettings,
                com.google.container.v1.NodePool.UpgradeSettings.Builder,
                com.google.container.v1.NodePool.UpgradeSettingsOrBuilder>(
                getUpgradeSettings(), getParentForChildren(), isClean());
        upgradeSettings_ = null;
      }
      return upgradeSettingsBuilder_;
    }

    private com.google.container.v1.NetworkTags tags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NetworkTags,
            com.google.container.v1.NetworkTags.Builder,
            com.google.container.v1.NetworkTagsOrBuilder>
        tagsBuilder_;
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     *
     * @return Whether the tags field is set.
     */
    public boolean hasTags() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     *
     * @return The tags.
     */
    public com.google.container.v1.NetworkTags getTags() {
      if (tagsBuilder_ == null) {
        return tags_ == null ? com.google.container.v1.NetworkTags.getDefaultInstance() : tags_;
      } else {
        return tagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    public Builder setTags(com.google.container.v1.NetworkTags value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tags_ = value;
      } else {
        tagsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    public Builder setTags(com.google.container.v1.NetworkTags.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        tags_ = builderForValue.build();
      } else {
        tagsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    public Builder mergeTags(com.google.container.v1.NetworkTags value) {
      if (tagsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && tags_ != null
            && tags_ != com.google.container.v1.NetworkTags.getDefaultInstance()) {
          getTagsBuilder().mergeFrom(value);
        } else {
          tags_ = value;
        }
      } else {
        tagsBuilder_.mergeFrom(value);
      }
      if (tags_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    public Builder clearTags() {
      bitField0_ = (bitField0_ & ~0x00000400);
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    public com.google.container.v1.NetworkTags.Builder getTagsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    public com.google.container.v1.NetworkTagsOrBuilder getTagsOrBuilder() {
      if (tagsBuilder_ != null) {
        return tagsBuilder_.getMessageOrBuilder();
      } else {
        return tags_ == null ? com.google.container.v1.NetworkTags.getDefaultInstance() : tags_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired network tags to be applied to all nodes in the node pool.
     * If this field is not present, the tags will not be changed. Otherwise,
     * the existing network tags will be *replaced* with the provided tags.
     * </pre>
     *
     * <code>.google.container.v1.NetworkTags tags = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NetworkTags,
            com.google.container.v1.NetworkTags.Builder,
            com.google.container.v1.NetworkTagsOrBuilder>
        getTagsFieldBuilder() {
      if (tagsBuilder_ == null) {
        tagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NetworkTags,
                com.google.container.v1.NetworkTags.Builder,
                com.google.container.v1.NetworkTagsOrBuilder>(
                getTags(), getParentForChildren(), isClean());
        tags_ = null;
      }
      return tagsBuilder_;
    }

    private com.google.container.v1.NodeTaints taints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeTaints,
            com.google.container.v1.NodeTaints.Builder,
            com.google.container.v1.NodeTaintsOrBuilder>
        taintsBuilder_;
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     *
     * @return Whether the taints field is set.
     */
    public boolean hasTaints() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     *
     * @return The taints.
     */
    public com.google.container.v1.NodeTaints getTaints() {
      if (taintsBuilder_ == null) {
        return taints_ == null ? com.google.container.v1.NodeTaints.getDefaultInstance() : taints_;
      } else {
        return taintsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    public Builder setTaints(com.google.container.v1.NodeTaints value) {
      if (taintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taints_ = value;
      } else {
        taintsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    public Builder setTaints(com.google.container.v1.NodeTaints.Builder builderForValue) {
      if (taintsBuilder_ == null) {
        taints_ = builderForValue.build();
      } else {
        taintsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    public Builder mergeTaints(com.google.container.v1.NodeTaints value) {
      if (taintsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && taints_ != null
            && taints_ != com.google.container.v1.NodeTaints.getDefaultInstance()) {
          getTaintsBuilder().mergeFrom(value);
        } else {
          taints_ = value;
        }
      } else {
        taintsBuilder_.mergeFrom(value);
      }
      if (taints_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    public Builder clearTaints() {
      bitField0_ = (bitField0_ & ~0x00000800);
      taints_ = null;
      if (taintsBuilder_ != null) {
        taintsBuilder_.dispose();
        taintsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    public com.google.container.v1.NodeTaints.Builder getTaintsBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getTaintsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    public com.google.container.v1.NodeTaintsOrBuilder getTaintsOrBuilder() {
      if (taintsBuilder_ != null) {
        return taintsBuilder_.getMessageOrBuilder();
      } else {
        return taints_ == null ? com.google.container.v1.NodeTaints.getDefaultInstance() : taints_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node taints to be applied to all nodes in the node pool.
     * If this field is not present, the taints will not be changed. Otherwise,
     * the existing node taints will be *replaced* with the provided taints.
     * </pre>
     *
     * <code>.google.container.v1.NodeTaints taints = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeTaints,
            com.google.container.v1.NodeTaints.Builder,
            com.google.container.v1.NodeTaintsOrBuilder>
        getTaintsFieldBuilder() {
      if (taintsBuilder_ == null) {
        taintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeTaints,
                com.google.container.v1.NodeTaints.Builder,
                com.google.container.v1.NodeTaintsOrBuilder>(
                getTaints(), getParentForChildren(), isClean());
        taints_ = null;
      }
      return taintsBuilder_;
    }

    private com.google.container.v1.NodeLabels labels_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeLabels,
            com.google.container.v1.NodeLabels.Builder,
            com.google.container.v1.NodeLabelsOrBuilder>
        labelsBuilder_;
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     *
     * @return Whether the labels field is set.
     */
    public boolean hasLabels() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     *
     * @return The labels.
     */
    public com.google.container.v1.NodeLabels getLabels() {
      if (labelsBuilder_ == null) {
        return labels_ == null ? com.google.container.v1.NodeLabels.getDefaultInstance() : labels_;
      } else {
        return labelsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    public Builder setLabels(com.google.container.v1.NodeLabels value) {
      if (labelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labels_ = value;
      } else {
        labelsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    public Builder setLabels(com.google.container.v1.NodeLabels.Builder builderForValue) {
      if (labelsBuilder_ == null) {
        labels_ = builderForValue.build();
      } else {
        labelsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    public Builder mergeLabels(com.google.container.v1.NodeLabels value) {
      if (labelsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && labels_ != null
            && labels_ != com.google.container.v1.NodeLabels.getDefaultInstance()) {
          getLabelsBuilder().mergeFrom(value);
        } else {
          labels_ = value;
        }
      } else {
        labelsBuilder_.mergeFrom(value);
      }
      if (labels_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00001000);
      labels_ = null;
      if (labelsBuilder_ != null) {
        labelsBuilder_.dispose();
        labelsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    public com.google.container.v1.NodeLabels.Builder getLabelsBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getLabelsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    public com.google.container.v1.NodeLabelsOrBuilder getLabelsOrBuilder() {
      if (labelsBuilder_ != null) {
        return labelsBuilder_.getMessageOrBuilder();
      } else {
        return labels_ == null ? com.google.container.v1.NodeLabels.getDefaultInstance() : labels_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node labels to be applied to all nodes in the node pool.
     * If this field is not present, the labels will not be changed. Otherwise,
     * the existing node labels will be *replaced* with the provided labels.
     * </pre>
     *
     * <code>.google.container.v1.NodeLabels labels = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeLabels,
            com.google.container.v1.NodeLabels.Builder,
            com.google.container.v1.NodeLabelsOrBuilder>
        getLabelsFieldBuilder() {
      if (labelsBuilder_ == null) {
        labelsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeLabels,
                com.google.container.v1.NodeLabels.Builder,
                com.google.container.v1.NodeLabelsOrBuilder>(
                getLabels(), getParentForChildren(), isClean());
        labels_ = null;
      }
      return labelsBuilder_;
    }

    private com.google.container.v1.LinuxNodeConfig linuxNodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LinuxNodeConfig,
            com.google.container.v1.LinuxNodeConfig.Builder,
            com.google.container.v1.LinuxNodeConfigOrBuilder>
        linuxNodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     *
     * @return Whether the linuxNodeConfig field is set.
     */
    public boolean hasLinuxNodeConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     *
     * @return The linuxNodeConfig.
     */
    public com.google.container.v1.LinuxNodeConfig getLinuxNodeConfig() {
      if (linuxNodeConfigBuilder_ == null) {
        return linuxNodeConfig_ == null
            ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
            : linuxNodeConfig_;
      } else {
        return linuxNodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    public Builder setLinuxNodeConfig(com.google.container.v1.LinuxNodeConfig value) {
      if (linuxNodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linuxNodeConfig_ = value;
      } else {
        linuxNodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    public Builder setLinuxNodeConfig(
        com.google.container.v1.LinuxNodeConfig.Builder builderForValue) {
      if (linuxNodeConfigBuilder_ == null) {
        linuxNodeConfig_ = builderForValue.build();
      } else {
        linuxNodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    public Builder mergeLinuxNodeConfig(com.google.container.v1.LinuxNodeConfig value) {
      if (linuxNodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && linuxNodeConfig_ != null
            && linuxNodeConfig_ != com.google.container.v1.LinuxNodeConfig.getDefaultInstance()) {
          getLinuxNodeConfigBuilder().mergeFrom(value);
        } else {
          linuxNodeConfig_ = value;
        }
      } else {
        linuxNodeConfigBuilder_.mergeFrom(value);
      }
      if (linuxNodeConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    public Builder clearLinuxNodeConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      linuxNodeConfig_ = null;
      if (linuxNodeConfigBuilder_ != null) {
        linuxNodeConfigBuilder_.dispose();
        linuxNodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    public com.google.container.v1.LinuxNodeConfig.Builder getLinuxNodeConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getLinuxNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    public com.google.container.v1.LinuxNodeConfigOrBuilder getLinuxNodeConfigOrBuilder() {
      if (linuxNodeConfigBuilder_ != null) {
        return linuxNodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return linuxNodeConfig_ == null
            ? com.google.container.v1.LinuxNodeConfig.getDefaultInstance()
            : linuxNodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Linux nodes.
     * </pre>
     *
     * <code>.google.container.v1.LinuxNodeConfig linux_node_config = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LinuxNodeConfig,
            com.google.container.v1.LinuxNodeConfig.Builder,
            com.google.container.v1.LinuxNodeConfigOrBuilder>
        getLinuxNodeConfigFieldBuilder() {
      if (linuxNodeConfigBuilder_ == null) {
        linuxNodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.LinuxNodeConfig,
                com.google.container.v1.LinuxNodeConfig.Builder,
                com.google.container.v1.LinuxNodeConfigOrBuilder>(
                getLinuxNodeConfig(), getParentForChildren(), isClean());
        linuxNodeConfig_ = null;
      }
      return linuxNodeConfigBuilder_;
    }

    private com.google.container.v1.NodeKubeletConfig kubeletConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeKubeletConfig,
            com.google.container.v1.NodeKubeletConfig.Builder,
            com.google.container.v1.NodeKubeletConfigOrBuilder>
        kubeletConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     *
     * @return Whether the kubeletConfig field is set.
     */
    public boolean hasKubeletConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     *
     * @return The kubeletConfig.
     */
    public com.google.container.v1.NodeKubeletConfig getKubeletConfig() {
      if (kubeletConfigBuilder_ == null) {
        return kubeletConfig_ == null
            ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
            : kubeletConfig_;
      } else {
        return kubeletConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    public Builder setKubeletConfig(com.google.container.v1.NodeKubeletConfig value) {
      if (kubeletConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubeletConfig_ = value;
      } else {
        kubeletConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    public Builder setKubeletConfig(
        com.google.container.v1.NodeKubeletConfig.Builder builderForValue) {
      if (kubeletConfigBuilder_ == null) {
        kubeletConfig_ = builderForValue.build();
      } else {
        kubeletConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    public Builder mergeKubeletConfig(com.google.container.v1.NodeKubeletConfig value) {
      if (kubeletConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && kubeletConfig_ != null
            && kubeletConfig_ != com.google.container.v1.NodeKubeletConfig.getDefaultInstance()) {
          getKubeletConfigBuilder().mergeFrom(value);
        } else {
          kubeletConfig_ = value;
        }
      } else {
        kubeletConfigBuilder_.mergeFrom(value);
      }
      if (kubeletConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    public Builder clearKubeletConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      kubeletConfig_ = null;
      if (kubeletConfigBuilder_ != null) {
        kubeletConfigBuilder_.dispose();
        kubeletConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    public com.google.container.v1.NodeKubeletConfig.Builder getKubeletConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getKubeletConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    public com.google.container.v1.NodeKubeletConfigOrBuilder getKubeletConfigOrBuilder() {
      if (kubeletConfigBuilder_ != null) {
        return kubeletConfigBuilder_.getMessageOrBuilder();
      } else {
        return kubeletConfig_ == null
            ? com.google.container.v1.NodeKubeletConfig.getDefaultInstance()
            : kubeletConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Node kubelet configs.
     * </pre>
     *
     * <code>.google.container.v1.NodeKubeletConfig kubelet_config = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeKubeletConfig,
            com.google.container.v1.NodeKubeletConfig.Builder,
            com.google.container.v1.NodeKubeletConfigOrBuilder>
        getKubeletConfigFieldBuilder() {
      if (kubeletConfigBuilder_ == null) {
        kubeletConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeKubeletConfig,
                com.google.container.v1.NodeKubeletConfig.Builder,
                com.google.container.v1.NodeKubeletConfigOrBuilder>(
                getKubeletConfig(), getParentForChildren(), isClean());
        kubeletConfig_ = null;
      }
      return kubeletConfigBuilder_;
    }

    private com.google.container.v1.NodeNetworkConfig nodeNetworkConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeNetworkConfig,
            com.google.container.v1.NodeNetworkConfig.Builder,
            com.google.container.v1.NodeNetworkConfigOrBuilder>
        nodeNetworkConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     *
     * @return Whether the nodeNetworkConfig field is set.
     */
    public boolean hasNodeNetworkConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     *
     * @return The nodeNetworkConfig.
     */
    public com.google.container.v1.NodeNetworkConfig getNodeNetworkConfig() {
      if (nodeNetworkConfigBuilder_ == null) {
        return nodeNetworkConfig_ == null
            ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
            : nodeNetworkConfig_;
      } else {
        return nodeNetworkConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    public Builder setNodeNetworkConfig(com.google.container.v1.NodeNetworkConfig value) {
      if (nodeNetworkConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeNetworkConfig_ = value;
      } else {
        nodeNetworkConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    public Builder setNodeNetworkConfig(
        com.google.container.v1.NodeNetworkConfig.Builder builderForValue) {
      if (nodeNetworkConfigBuilder_ == null) {
        nodeNetworkConfig_ = builderForValue.build();
      } else {
        nodeNetworkConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    public Builder mergeNodeNetworkConfig(com.google.container.v1.NodeNetworkConfig value) {
      if (nodeNetworkConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && nodeNetworkConfig_ != null
            && nodeNetworkConfig_
                != com.google.container.v1.NodeNetworkConfig.getDefaultInstance()) {
          getNodeNetworkConfigBuilder().mergeFrom(value);
        } else {
          nodeNetworkConfig_ = value;
        }
      } else {
        nodeNetworkConfigBuilder_.mergeFrom(value);
      }
      if (nodeNetworkConfig_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    public Builder clearNodeNetworkConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      nodeNetworkConfig_ = null;
      if (nodeNetworkConfigBuilder_ != null) {
        nodeNetworkConfigBuilder_.dispose();
        nodeNetworkConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    public com.google.container.v1.NodeNetworkConfig.Builder getNodeNetworkConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getNodeNetworkConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    public com.google.container.v1.NodeNetworkConfigOrBuilder getNodeNetworkConfigOrBuilder() {
      if (nodeNetworkConfigBuilder_ != null) {
        return nodeNetworkConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodeNetworkConfig_ == null
            ? com.google.container.v1.NodeNetworkConfig.getDefaultInstance()
            : nodeNetworkConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Node network config.
     * </pre>
     *
     * <code>.google.container.v1.NodeNetworkConfig node_network_config = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeNetworkConfig,
            com.google.container.v1.NodeNetworkConfig.Builder,
            com.google.container.v1.NodeNetworkConfigOrBuilder>
        getNodeNetworkConfigFieldBuilder() {
      if (nodeNetworkConfigBuilder_ == null) {
        nodeNetworkConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeNetworkConfig,
                com.google.container.v1.NodeNetworkConfig.Builder,
                com.google.container.v1.NodeNetworkConfigOrBuilder>(
                getNodeNetworkConfig(), getParentForChildren(), isClean());
        nodeNetworkConfig_ = null;
      }
      return nodeNetworkConfigBuilder_;
    }

    private com.google.container.v1.GcfsConfig gcfsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.GcfsConfig,
            com.google.container.v1.GcfsConfig.Builder,
            com.google.container.v1.GcfsConfigOrBuilder>
        gcfsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     *
     * @return Whether the gcfsConfig field is set.
     */
    public boolean hasGcfsConfig() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     *
     * @return The gcfsConfig.
     */
    public com.google.container.v1.GcfsConfig getGcfsConfig() {
      if (gcfsConfigBuilder_ == null) {
        return gcfsConfig_ == null
            ? com.google.container.v1.GcfsConfig.getDefaultInstance()
            : gcfsConfig_;
      } else {
        return gcfsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    public Builder setGcfsConfig(com.google.container.v1.GcfsConfig value) {
      if (gcfsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcfsConfig_ = value;
      } else {
        gcfsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    public Builder setGcfsConfig(com.google.container.v1.GcfsConfig.Builder builderForValue) {
      if (gcfsConfigBuilder_ == null) {
        gcfsConfig_ = builderForValue.build();
      } else {
        gcfsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    public Builder mergeGcfsConfig(com.google.container.v1.GcfsConfig value) {
      if (gcfsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && gcfsConfig_ != null
            && gcfsConfig_ != com.google.container.v1.GcfsConfig.getDefaultInstance()) {
          getGcfsConfigBuilder().mergeFrom(value);
        } else {
          gcfsConfig_ = value;
        }
      } else {
        gcfsConfigBuilder_.mergeFrom(value);
      }
      if (gcfsConfig_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    public Builder clearGcfsConfig() {
      bitField0_ = (bitField0_ & ~0x00010000);
      gcfsConfig_ = null;
      if (gcfsConfigBuilder_ != null) {
        gcfsConfigBuilder_.dispose();
        gcfsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    public com.google.container.v1.GcfsConfig.Builder getGcfsConfigBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getGcfsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    public com.google.container.v1.GcfsConfigOrBuilder getGcfsConfigOrBuilder() {
      if (gcfsConfigBuilder_ != null) {
        return gcfsConfigBuilder_.getMessageOrBuilder();
      } else {
        return gcfsConfig_ == null
            ? com.google.container.v1.GcfsConfig.getDefaultInstance()
            : gcfsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * GCFS config.
     * </pre>
     *
     * <code>.google.container.v1.GcfsConfig gcfs_config = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.GcfsConfig,
            com.google.container.v1.GcfsConfig.Builder,
            com.google.container.v1.GcfsConfigOrBuilder>
        getGcfsConfigFieldBuilder() {
      if (gcfsConfigBuilder_ == null) {
        gcfsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.GcfsConfig,
                com.google.container.v1.GcfsConfig.Builder,
                com.google.container.v1.GcfsConfigOrBuilder>(
                getGcfsConfig(), getParentForChildren(), isClean());
        gcfsConfig_ = null;
      }
      return gcfsConfigBuilder_;
    }

    private com.google.container.v1.ConfidentialNodes confidentialNodes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ConfidentialNodes,
            com.google.container.v1.ConfidentialNodes.Builder,
            com.google.container.v1.ConfidentialNodesOrBuilder>
        confidentialNodesBuilder_;
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     *
     * @return Whether the confidentialNodes field is set.
     */
    public boolean hasConfidentialNodes() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     *
     * @return The confidentialNodes.
     */
    public com.google.container.v1.ConfidentialNodes getConfidentialNodes() {
      if (confidentialNodesBuilder_ == null) {
        return confidentialNodes_ == null
            ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
            : confidentialNodes_;
      } else {
        return confidentialNodesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    public Builder setConfidentialNodes(com.google.container.v1.ConfidentialNodes value) {
      if (confidentialNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidentialNodes_ = value;
      } else {
        confidentialNodesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    public Builder setConfidentialNodes(
        com.google.container.v1.ConfidentialNodes.Builder builderForValue) {
      if (confidentialNodesBuilder_ == null) {
        confidentialNodes_ = builderForValue.build();
      } else {
        confidentialNodesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    public Builder mergeConfidentialNodes(com.google.container.v1.ConfidentialNodes value) {
      if (confidentialNodesBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && confidentialNodes_ != null
            && confidentialNodes_
                != com.google.container.v1.ConfidentialNodes.getDefaultInstance()) {
          getConfidentialNodesBuilder().mergeFrom(value);
        } else {
          confidentialNodes_ = value;
        }
      } else {
        confidentialNodesBuilder_.mergeFrom(value);
      }
      if (confidentialNodes_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    public Builder clearConfidentialNodes() {
      bitField0_ = (bitField0_ & ~0x00020000);
      confidentialNodes_ = null;
      if (confidentialNodesBuilder_ != null) {
        confidentialNodesBuilder_.dispose();
        confidentialNodesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    public com.google.container.v1.ConfidentialNodes.Builder getConfidentialNodesBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getConfidentialNodesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    public com.google.container.v1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder() {
      if (confidentialNodesBuilder_ != null) {
        return confidentialNodesBuilder_.getMessageOrBuilder();
      } else {
        return confidentialNodes_ == null
            ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
            : confidentialNodes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Confidential nodes config.
     * All the nodes in the node pool will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ConfidentialNodes,
            com.google.container.v1.ConfidentialNodes.Builder,
            com.google.container.v1.ConfidentialNodesOrBuilder>
        getConfidentialNodesFieldBuilder() {
      if (confidentialNodesBuilder_ == null) {
        confidentialNodesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ConfidentialNodes,
                com.google.container.v1.ConfidentialNodes.Builder,
                com.google.container.v1.ConfidentialNodesOrBuilder>(
                getConfidentialNodes(), getParentForChildren(), isClean());
        confidentialNodes_ = null;
      }
      return confidentialNodesBuilder_;
    }

    private com.google.container.v1.VirtualNIC gvnic_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.VirtualNIC,
            com.google.container.v1.VirtualNIC.Builder,
            com.google.container.v1.VirtualNICOrBuilder>
        gvnicBuilder_;
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     *
     * @return Whether the gvnic field is set.
     */
    public boolean hasGvnic() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     *
     * @return The gvnic.
     */
    public com.google.container.v1.VirtualNIC getGvnic() {
      if (gvnicBuilder_ == null) {
        return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
      } else {
        return gvnicBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder setGvnic(com.google.container.v1.VirtualNIC value) {
      if (gvnicBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gvnic_ = value;
      } else {
        gvnicBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder setGvnic(com.google.container.v1.VirtualNIC.Builder builderForValue) {
      if (gvnicBuilder_ == null) {
        gvnic_ = builderForValue.build();
      } else {
        gvnicBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder mergeGvnic(com.google.container.v1.VirtualNIC value) {
      if (gvnicBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && gvnic_ != null
            && gvnic_ != com.google.container.v1.VirtualNIC.getDefaultInstance()) {
          getGvnicBuilder().mergeFrom(value);
        } else {
          gvnic_ = value;
        }
      } else {
        gvnicBuilder_.mergeFrom(value);
      }
      if (gvnic_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public Builder clearGvnic() {
      bitField0_ = (bitField0_ & ~0x00040000);
      gvnic_ = null;
      if (gvnicBuilder_ != null) {
        gvnicBuilder_.dispose();
        gvnicBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public com.google.container.v1.VirtualNIC.Builder getGvnicBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getGvnicFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    public com.google.container.v1.VirtualNICOrBuilder getGvnicOrBuilder() {
      if (gvnicBuilder_ != null) {
        return gvnicBuilder_.getMessageOrBuilder();
      } else {
        return gvnic_ == null ? com.google.container.v1.VirtualNIC.getDefaultInstance() : gvnic_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable gvnic on the node pool.
     * </pre>
     *
     * <code>.google.container.v1.VirtualNIC gvnic = 29;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.VirtualNIC,
            com.google.container.v1.VirtualNIC.Builder,
            com.google.container.v1.VirtualNICOrBuilder>
        getGvnicFieldBuilder() {
      if (gvnicBuilder_ == null) {
        gvnicBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.VirtualNIC,
                com.google.container.v1.VirtualNIC.Builder,
                com.google.container.v1.VirtualNICOrBuilder>(
                getGvnic(), getParentForChildren(), isClean());
        gvnic_ = null;
      }
      return gvnicBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The current etag of the node pool.
     * If an etag is provided and does not match the current etag of the node
     * pool, update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 30;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current etag of the node pool.
     * If an etag is provided and does not match the current etag of the node
     * pool, update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 30;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current etag of the node pool.
     * If an etag is provided and does not match the current etag of the node
     * pool, update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 30;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current etag of the node pool.
     * If an etag is provided and does not match the current etag of the node
     * pool, update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 30;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current etag of the node pool.
     * If an etag is provided and does not match the current etag of the node
     * pool, update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 30;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private com.google.container.v1.FastSocket fastSocket_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.FastSocket,
            com.google.container.v1.FastSocket.Builder,
            com.google.container.v1.FastSocketOrBuilder>
        fastSocketBuilder_;
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     *
     * @return Whether the fastSocket field is set.
     */
    public boolean hasFastSocket() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     *
     * @return The fastSocket.
     */
    public com.google.container.v1.FastSocket getFastSocket() {
      if (fastSocketBuilder_ == null) {
        return fastSocket_ == null
            ? com.google.container.v1.FastSocket.getDefaultInstance()
            : fastSocket_;
      } else {
        return fastSocketBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    public Builder setFastSocket(com.google.container.v1.FastSocket value) {
      if (fastSocketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fastSocket_ = value;
      } else {
        fastSocketBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    public Builder setFastSocket(com.google.container.v1.FastSocket.Builder builderForValue) {
      if (fastSocketBuilder_ == null) {
        fastSocket_ = builderForValue.build();
      } else {
        fastSocketBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    public Builder mergeFastSocket(com.google.container.v1.FastSocket value) {
      if (fastSocketBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && fastSocket_ != null
            && fastSocket_ != com.google.container.v1.FastSocket.getDefaultInstance()) {
          getFastSocketBuilder().mergeFrom(value);
        } else {
          fastSocket_ = value;
        }
      } else {
        fastSocketBuilder_.mergeFrom(value);
      }
      if (fastSocket_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    public Builder clearFastSocket() {
      bitField0_ = (bitField0_ & ~0x00100000);
      fastSocket_ = null;
      if (fastSocketBuilder_ != null) {
        fastSocketBuilder_.dispose();
        fastSocketBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    public com.google.container.v1.FastSocket.Builder getFastSocketBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getFastSocketFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    public com.google.container.v1.FastSocketOrBuilder getFastSocketOrBuilder() {
      if (fastSocketBuilder_ != null) {
        return fastSocketBuilder_.getMessageOrBuilder();
      } else {
        return fastSocket_ == null
            ? com.google.container.v1.FastSocket.getDefaultInstance()
            : fastSocket_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable or disable NCCL fast socket for the node pool.
     * </pre>
     *
     * <code>.google.container.v1.FastSocket fast_socket = 31;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.FastSocket,
            com.google.container.v1.FastSocket.Builder,
            com.google.container.v1.FastSocketOrBuilder>
        getFastSocketFieldBuilder() {
      if (fastSocketBuilder_ == null) {
        fastSocketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.FastSocket,
                com.google.container.v1.FastSocket.Builder,
                com.google.container.v1.FastSocketOrBuilder>(
                getFastSocket(), getParentForChildren(), isClean());
        fastSocket_ = null;
      }
      return fastSocketBuilder_;
    }

    private com.google.container.v1.NodePoolLoggingConfig loggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolLoggingConfig,
            com.google.container.v1.NodePoolLoggingConfig.Builder,
            com.google.container.v1.NodePoolLoggingConfigOrBuilder>
        loggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     *
     * @return Whether the loggingConfig field is set.
     */
    public boolean hasLoggingConfig() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     *
     * @return The loggingConfig.
     */
    public com.google.container.v1.NodePoolLoggingConfig getLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        return loggingConfig_ == null
            ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
            : loggingConfig_;
      } else {
        return loggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    public Builder setLoggingConfig(com.google.container.v1.NodePoolLoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingConfig_ = value;
      } else {
        loggingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    public Builder setLoggingConfig(
        com.google.container.v1.NodePoolLoggingConfig.Builder builderForValue) {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = builderForValue.build();
      } else {
        loggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    public Builder mergeLoggingConfig(com.google.container.v1.NodePoolLoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && loggingConfig_ != null
            && loggingConfig_
                != com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()) {
          getLoggingConfigBuilder().mergeFrom(value);
        } else {
          loggingConfig_ = value;
        }
      } else {
        loggingConfigBuilder_.mergeFrom(value);
      }
      if (loggingConfig_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    public Builder clearLoggingConfig() {
      bitField0_ = (bitField0_ & ~0x00200000);
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    public com.google.container.v1.NodePoolLoggingConfig.Builder getLoggingConfigBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    public com.google.container.v1.NodePoolLoggingConfigOrBuilder getLoggingConfigOrBuilder() {
      if (loggingConfigBuilder_ != null) {
        return loggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return loggingConfig_ == null
            ? com.google.container.v1.NodePoolLoggingConfig.getDefaultInstance()
            : loggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolLoggingConfig logging_config = 32;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolLoggingConfig,
            com.google.container.v1.NodePoolLoggingConfig.Builder,
            com.google.container.v1.NodePoolLoggingConfigOrBuilder>
        getLoggingConfigFieldBuilder() {
      if (loggingConfigBuilder_ == null) {
        loggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePoolLoggingConfig,
                com.google.container.v1.NodePoolLoggingConfig.Builder,
                com.google.container.v1.NodePoolLoggingConfigOrBuilder>(
                getLoggingConfig(), getParentForChildren(), isClean());
        loggingConfig_ = null;
      }
      return loggingConfigBuilder_;
    }

    private com.google.container.v1.ResourceLabels resourceLabels_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceLabels,
            com.google.container.v1.ResourceLabels.Builder,
            com.google.container.v1.ResourceLabelsOrBuilder>
        resourceLabelsBuilder_;
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     *
     * @return Whether the resourceLabels field is set.
     */
    public boolean hasResourceLabels() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     *
     * @return The resourceLabels.
     */
    public com.google.container.v1.ResourceLabels getResourceLabels() {
      if (resourceLabelsBuilder_ == null) {
        return resourceLabels_ == null
            ? com.google.container.v1.ResourceLabels.getDefaultInstance()
            : resourceLabels_;
      } else {
        return resourceLabelsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    public Builder setResourceLabels(com.google.container.v1.ResourceLabels value) {
      if (resourceLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceLabels_ = value;
      } else {
        resourceLabelsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    public Builder setResourceLabels(
        com.google.container.v1.ResourceLabels.Builder builderForValue) {
      if (resourceLabelsBuilder_ == null) {
        resourceLabels_ = builderForValue.build();
      } else {
        resourceLabelsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    public Builder mergeResourceLabels(com.google.container.v1.ResourceLabels value) {
      if (resourceLabelsBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && resourceLabels_ != null
            && resourceLabels_ != com.google.container.v1.ResourceLabels.getDefaultInstance()) {
          getResourceLabelsBuilder().mergeFrom(value);
        } else {
          resourceLabels_ = value;
        }
      } else {
        resourceLabelsBuilder_.mergeFrom(value);
      }
      if (resourceLabels_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    public Builder clearResourceLabels() {
      bitField0_ = (bitField0_ & ~0x00400000);
      resourceLabels_ = null;
      if (resourceLabelsBuilder_ != null) {
        resourceLabelsBuilder_.dispose();
        resourceLabelsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    public com.google.container.v1.ResourceLabels.Builder getResourceLabelsBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getResourceLabelsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    public com.google.container.v1.ResourceLabelsOrBuilder getResourceLabelsOrBuilder() {
      if (resourceLabelsBuilder_ != null) {
        return resourceLabelsBuilder_.getMessageOrBuilder();
      } else {
        return resourceLabels_ == null
            ? com.google.container.v1.ResourceLabels.getDefaultInstance()
            : resourceLabels_;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the node pool to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>.google.container.v1.ResourceLabels resource_labels = 33;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceLabels,
            com.google.container.v1.ResourceLabels.Builder,
            com.google.container.v1.ResourceLabelsOrBuilder>
        getResourceLabelsFieldBuilder() {
      if (resourceLabelsBuilder_ == null) {
        resourceLabelsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ResourceLabels,
                com.google.container.v1.ResourceLabels.Builder,
                com.google.container.v1.ResourceLabelsOrBuilder>(
                getResourceLabels(), getParentForChildren(), isClean());
        resourceLabels_ = null;
      }
      return resourceLabelsBuilder_;
    }

    private com.google.container.v1.WindowsNodeConfig windowsNodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WindowsNodeConfig,
            com.google.container.v1.WindowsNodeConfig.Builder,
            com.google.container.v1.WindowsNodeConfigOrBuilder>
        windowsNodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     *
     * @return Whether the windowsNodeConfig field is set.
     */
    public boolean hasWindowsNodeConfig() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     *
     * @return The windowsNodeConfig.
     */
    public com.google.container.v1.WindowsNodeConfig getWindowsNodeConfig() {
      if (windowsNodeConfigBuilder_ == null) {
        return windowsNodeConfig_ == null
            ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
            : windowsNodeConfig_;
      } else {
        return windowsNodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    public Builder setWindowsNodeConfig(com.google.container.v1.WindowsNodeConfig value) {
      if (windowsNodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        windowsNodeConfig_ = value;
      } else {
        windowsNodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    public Builder setWindowsNodeConfig(
        com.google.container.v1.WindowsNodeConfig.Builder builderForValue) {
      if (windowsNodeConfigBuilder_ == null) {
        windowsNodeConfig_ = builderForValue.build();
      } else {
        windowsNodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    public Builder mergeWindowsNodeConfig(com.google.container.v1.WindowsNodeConfig value) {
      if (windowsNodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && windowsNodeConfig_ != null
            && windowsNodeConfig_
                != com.google.container.v1.WindowsNodeConfig.getDefaultInstance()) {
          getWindowsNodeConfigBuilder().mergeFrom(value);
        } else {
          windowsNodeConfig_ = value;
        }
      } else {
        windowsNodeConfigBuilder_.mergeFrom(value);
      }
      if (windowsNodeConfig_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    public Builder clearWindowsNodeConfig() {
      bitField0_ = (bitField0_ & ~0x00800000);
      windowsNodeConfig_ = null;
      if (windowsNodeConfigBuilder_ != null) {
        windowsNodeConfigBuilder_.dispose();
        windowsNodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    public com.google.container.v1.WindowsNodeConfig.Builder getWindowsNodeConfigBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getWindowsNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    public com.google.container.v1.WindowsNodeConfigOrBuilder getWindowsNodeConfigOrBuilder() {
      if (windowsNodeConfigBuilder_ != null) {
        return windowsNodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return windowsNodeConfig_ == null
            ? com.google.container.v1.WindowsNodeConfig.getDefaultInstance()
            : windowsNodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters that can be configured on Windows nodes.
     * </pre>
     *
     * <code>.google.container.v1.WindowsNodeConfig windows_node_config = 34;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WindowsNodeConfig,
            com.google.container.v1.WindowsNodeConfig.Builder,
            com.google.container.v1.WindowsNodeConfigOrBuilder>
        getWindowsNodeConfigFieldBuilder() {
      if (windowsNodeConfigBuilder_ == null) {
        windowsNodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.WindowsNodeConfig,
                com.google.container.v1.WindowsNodeConfig.Builder,
                com.google.container.v1.WindowsNodeConfigOrBuilder>(
                getWindowsNodeConfig(), getParentForChildren(), isClean());
        windowsNodeConfig_ = null;
      }
      return windowsNodeConfigBuilder_;
    }

    private java.util.List<com.google.container.v1.AcceleratorConfig> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x01000000) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.container.v1.AcceleratorConfig>(accelerators_);
        bitField0_ |= 0x01000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.AcceleratorConfig,
            com.google.container.v1.AcceleratorConfig.Builder,
            com.google.container.v1.AcceleratorConfigOrBuilder>
        acceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public java.util.List<com.google.container.v1.AcceleratorConfig> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public com.google.container.v1.AcceleratorConfig getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder setAccelerators(int index, com.google.container.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder setAccelerators(
        int index, com.google.container.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder addAccelerators(com.google.container.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder addAccelerators(int index, com.google.container.v1.AcceleratorConfig value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder addAccelerators(
        com.google.container.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder addAccelerators(
        int index, com.google.container.v1.AcceleratorConfig.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.container.v1.AcceleratorConfig> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x01000000);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public com.google.container.v1.AcceleratorConfig.Builder getAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public com.google.container.v1.AcceleratorConfigOrBuilder getAcceleratorsOrBuilder(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public java.util.List<? extends com.google.container.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public com.google.container.v1.AcceleratorConfig.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.container.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public com.google.container.v1.AcceleratorConfig.Builder addAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.container.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of hardware accelerators to be attached to each node.
     * See https://cloud.google.com/compute/docs/gpus for more information about
     * support for GPUs.
     * </pre>
     *
     * <code>repeated .google.container.v1.AcceleratorConfig accelerators = 35;</code>
     */
    public java.util.List<com.google.container.v1.AcceleratorConfig.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.AcceleratorConfig,
            com.google.container.v1.AcceleratorConfig.Builder,
            com.google.container.v1.AcceleratorConfigOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.AcceleratorConfig,
                com.google.container.v1.AcceleratorConfig.Builder,
                com.google.container.v1.AcceleratorConfigOrBuilder>(
                accelerators_, ((bitField0_ & 0x01000000) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The desired [Google Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
     * node pool. Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified machine type.
     * </pre>
     *
     * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired [Google Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
     * node pool. Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified machine type.
     * </pre>
     *
     * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired [Google Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
     * node pool. Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified machine type.
     * </pre>
     *
     * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired [Google Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
     * node pool. Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified machine type.
     * </pre>
     *
     * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired [Google Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
     * node pool. Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified machine type.
     * </pre>
     *
     * <code>string machine_type = 36 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.lang.Object diskType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced') for nodes in the node pool.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk type.
     * </pre>
     *
     * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The diskType.
     */
    public java.lang.String getDiskType() {
      java.lang.Object ref = diskType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced') for nodes in the node pool.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk type.
     * </pre>
     *
     * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for diskType.
     */
    public com.google.protobuf.ByteString getDiskTypeBytes() {
      java.lang.Object ref = diskType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced') for nodes in the node pool.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk type.
     * </pre>
     *
     * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskType_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced') for nodes in the node pool.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk type.
     * </pre>
     *
     * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskType() {
      diskType_ = getDefaultInstance().getDiskType();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced') for nodes in the node pool.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk type.
     * </pre>
     *
     * <code>string disk_type = 37 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskType_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private long diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Optional. The desired disk size for nodes in the node pool specified in GB.
     * The smallest allowed disk size is 10GB.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk size.
     * </pre>
     *
     * <code>int64 disk_size_gb = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired disk size for nodes in the node pool specified in GB.
     * The smallest allowed disk size is 10GB.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk size.
     * </pre>
     *
     * <code>int64 disk_size_gb = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(long value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The desired disk size for nodes in the node pool specified in GB.
     * The smallest allowed disk size is 10GB.
     * Initiates an upgrade operation that migrates the nodes in the
     * node pool to the specified disk size.
     * </pre>
     *
     * <code>int64 disk_size_gb = 38 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x08000000);
      diskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private com.google.container.v1.ResourceManagerTags resourceManagerTags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceManagerTags,
            com.google.container.v1.ResourceManagerTags.Builder,
            com.google.container.v1.ResourceManagerTagsOrBuilder>
        resourceManagerTagsBuilder_;
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     *
     * @return Whether the resourceManagerTags field is set.
     */
    public boolean hasResourceManagerTags() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     *
     * @return The resourceManagerTags.
     */
    public com.google.container.v1.ResourceManagerTags getResourceManagerTags() {
      if (resourceManagerTagsBuilder_ == null) {
        return resourceManagerTags_ == null
            ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
            : resourceManagerTags_;
      } else {
        return resourceManagerTagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    public Builder setResourceManagerTags(com.google.container.v1.ResourceManagerTags value) {
      if (resourceManagerTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceManagerTags_ = value;
      } else {
        resourceManagerTagsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    public Builder setResourceManagerTags(
        com.google.container.v1.ResourceManagerTags.Builder builderForValue) {
      if (resourceManagerTagsBuilder_ == null) {
        resourceManagerTags_ = builderForValue.build();
      } else {
        resourceManagerTagsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    public Builder mergeResourceManagerTags(com.google.container.v1.ResourceManagerTags value) {
      if (resourceManagerTagsBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && resourceManagerTags_ != null
            && resourceManagerTags_
                != com.google.container.v1.ResourceManagerTags.getDefaultInstance()) {
          getResourceManagerTagsBuilder().mergeFrom(value);
        } else {
          resourceManagerTags_ = value;
        }
      } else {
        resourceManagerTagsBuilder_.mergeFrom(value);
      }
      if (resourceManagerTags_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    public Builder clearResourceManagerTags() {
      bitField0_ = (bitField0_ & ~0x10000000);
      resourceManagerTags_ = null;
      if (resourceManagerTagsBuilder_ != null) {
        resourceManagerTagsBuilder_.dispose();
        resourceManagerTagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    public com.google.container.v1.ResourceManagerTags.Builder getResourceManagerTagsBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getResourceManagerTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    public com.google.container.v1.ResourceManagerTagsOrBuilder getResourceManagerTagsOrBuilder() {
      if (resourceManagerTagsBuilder_ != null) {
        return resourceManagerTagsBuilder_.getMessageOrBuilder();
      } else {
        return resourceManagerTags_ == null
            ? com.google.container.v1.ResourceManagerTags.getDefaultInstance()
            : resourceManagerTags_;
      }
    }
    /**
     *
     *
     * <pre>
     * Desired resource manager tag keys and values to be attached to the nodes
     * for managing Compute Engine firewalls using Network Firewall Policies.
     * Existing tags will be replaced with new values.
     * </pre>
     *
     * <code>.google.container.v1.ResourceManagerTags resource_manager_tags = 39;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceManagerTags,
            com.google.container.v1.ResourceManagerTags.Builder,
            com.google.container.v1.ResourceManagerTagsOrBuilder>
        getResourceManagerTagsFieldBuilder() {
      if (resourceManagerTagsBuilder_ == null) {
        resourceManagerTagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ResourceManagerTags,
                com.google.container.v1.ResourceManagerTags.Builder,
                com.google.container.v1.ResourceManagerTagsOrBuilder>(
                getResourceManagerTags(), getParentForChildren(), isClean());
        resourceManagerTags_ = null;
      }
      return resourceManagerTagsBuilder_;
    }

    private com.google.container.v1.ContainerdConfig containerdConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ContainerdConfig,
            com.google.container.v1.ContainerdConfig.Builder,
            com.google.container.v1.ContainerdConfigOrBuilder>
        containerdConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     *
     * @return Whether the containerdConfig field is set.
     */
    public boolean hasContainerdConfig() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     *
     * @return The containerdConfig.
     */
    public com.google.container.v1.ContainerdConfig getContainerdConfig() {
      if (containerdConfigBuilder_ == null) {
        return containerdConfig_ == null
            ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
            : containerdConfig_;
      } else {
        return containerdConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    public Builder setContainerdConfig(com.google.container.v1.ContainerdConfig value) {
      if (containerdConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        containerdConfig_ = value;
      } else {
        containerdConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    public Builder setContainerdConfig(
        com.google.container.v1.ContainerdConfig.Builder builderForValue) {
      if (containerdConfigBuilder_ == null) {
        containerdConfig_ = builderForValue.build();
      } else {
        containerdConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    public Builder mergeContainerdConfig(com.google.container.v1.ContainerdConfig value) {
      if (containerdConfigBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && containerdConfig_ != null
            && containerdConfig_ != com.google.container.v1.ContainerdConfig.getDefaultInstance()) {
          getContainerdConfigBuilder().mergeFrom(value);
        } else {
          containerdConfig_ = value;
        }
      } else {
        containerdConfigBuilder_.mergeFrom(value);
      }
      if (containerdConfig_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    public Builder clearContainerdConfig() {
      bitField0_ = (bitField0_ & ~0x20000000);
      containerdConfig_ = null;
      if (containerdConfigBuilder_ != null) {
        containerdConfigBuilder_.dispose();
        containerdConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    public com.google.container.v1.ContainerdConfig.Builder getContainerdConfigBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getContainerdConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    public com.google.container.v1.ContainerdConfigOrBuilder getContainerdConfigOrBuilder() {
      if (containerdConfigBuilder_ != null) {
        return containerdConfigBuilder_.getMessageOrBuilder();
      } else {
        return containerdConfig_ == null
            ? com.google.container.v1.ContainerdConfig.getDefaultInstance()
            : containerdConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for nodes in the node pool.
     * Initiates an upgrade operation that recreates the nodes with the new
     * config.
     * </pre>
     *
     * <code>.google.container.v1.ContainerdConfig containerd_config = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ContainerdConfig,
            com.google.container.v1.ContainerdConfig.Builder,
            com.google.container.v1.ContainerdConfigOrBuilder>
        getContainerdConfigFieldBuilder() {
      if (containerdConfigBuilder_ == null) {
        containerdConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ContainerdConfig,
                com.google.container.v1.ContainerdConfig.Builder,
                com.google.container.v1.ContainerdConfigOrBuilder>(
                getContainerdConfig(), getParentForChildren(), isClean());
        containerdConfig_ = null;
      }
      return containerdConfigBuilder_;
    }

    private com.google.container.v1.NodePool.QueuedProvisioning queuedProvisioning_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.QueuedProvisioning,
            com.google.container.v1.NodePool.QueuedProvisioning.Builder,
            com.google.container.v1.NodePool.QueuedProvisioningOrBuilder>
        queuedProvisioningBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     *
     * @return Whether the queuedProvisioning field is set.
     */
    public boolean hasQueuedProvisioning() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     *
     * @return The queuedProvisioning.
     */
    public com.google.container.v1.NodePool.QueuedProvisioning getQueuedProvisioning() {
      if (queuedProvisioningBuilder_ == null) {
        return queuedProvisioning_ == null
            ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
            : queuedProvisioning_;
      } else {
        return queuedProvisioningBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    public Builder setQueuedProvisioning(
        com.google.container.v1.NodePool.QueuedProvisioning value) {
      if (queuedProvisioningBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queuedProvisioning_ = value;
      } else {
        queuedProvisioningBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    public Builder setQueuedProvisioning(
        com.google.container.v1.NodePool.QueuedProvisioning.Builder builderForValue) {
      if (queuedProvisioningBuilder_ == null) {
        queuedProvisioning_ = builderForValue.build();
      } else {
        queuedProvisioningBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    public Builder mergeQueuedProvisioning(
        com.google.container.v1.NodePool.QueuedProvisioning value) {
      if (queuedProvisioningBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && queuedProvisioning_ != null
            && queuedProvisioning_
                != com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()) {
          getQueuedProvisioningBuilder().mergeFrom(value);
        } else {
          queuedProvisioning_ = value;
        }
      } else {
        queuedProvisioningBuilder_.mergeFrom(value);
      }
      if (queuedProvisioning_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    public Builder clearQueuedProvisioning() {
      bitField0_ = (bitField0_ & ~0x40000000);
      queuedProvisioning_ = null;
      if (queuedProvisioningBuilder_ != null) {
        queuedProvisioningBuilder_.dispose();
        queuedProvisioningBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    public com.google.container.v1.NodePool.QueuedProvisioning.Builder
        getQueuedProvisioningBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getQueuedProvisioningFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    public com.google.container.v1.NodePool.QueuedProvisioningOrBuilder
        getQueuedProvisioningOrBuilder() {
      if (queuedProvisioningBuilder_ != null) {
        return queuedProvisioningBuilder_.getMessageOrBuilder();
      } else {
        return queuedProvisioning_ == null
            ? com.google.container.v1.NodePool.QueuedProvisioning.getDefaultInstance()
            : queuedProvisioning_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the configuration of queued provisioning.
     * </pre>
     *
     * <code>.google.container.v1.NodePool.QueuedProvisioning queued_provisioning = 42;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePool.QueuedProvisioning,
            com.google.container.v1.NodePool.QueuedProvisioning.Builder,
            com.google.container.v1.NodePool.QueuedProvisioningOrBuilder>
        getQueuedProvisioningFieldBuilder() {
      if (queuedProvisioningBuilder_ == null) {
        queuedProvisioningBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePool.QueuedProvisioning,
                com.google.container.v1.NodePool.QueuedProvisioning.Builder,
                com.google.container.v1.NodePool.QueuedProvisioningOrBuilder>(
                getQueuedProvisioning(), getParentForChildren(), isClean());
        queuedProvisioning_ = null;
      }
      return queuedProvisioningBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.UpdateNodePoolRequest)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.UpdateNodePoolRequest)
  private static final com.google.container.v1.UpdateNodePoolRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.UpdateNodePoolRequest();
  }

  public static com.google.container.v1.UpdateNodePoolRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateNodePoolRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateNodePoolRequest>() {
        @java.lang.Override
        public UpdateNodePoolRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateNodePoolRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateNodePoolRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.UpdateNodePoolRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
