/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * AutopilotCompatibilityIssue contains information about a specific
 * compatibility issue with Autopilot mode.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.AutopilotCompatibilityIssue}
 */
public final class AutopilotCompatibilityIssue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.AutopilotCompatibilityIssue)
    AutopilotCompatibilityIssueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutopilotCompatibilityIssue.newBuilder() to construct.
  private AutopilotCompatibilityIssue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutopilotCompatibilityIssue() {
    constraintType_ = "";
    incompatibilityType_ = 0;
    subjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
    documentationUrl_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutopilotCompatibilityIssue();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_AutopilotCompatibilityIssue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_AutopilotCompatibilityIssue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.AutopilotCompatibilityIssue.class,
            com.google.container.v1.AutopilotCompatibilityIssue.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the reported issue.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.AutopilotCompatibilityIssue.IssueType}
   */
  public enum IssueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value, should not be used.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that the issue is a known incompatibility between the
     * cluster and Autopilot mode.
     * </pre>
     *
     * <code>INCOMPATIBILITY = 1;</code>
     */
    INCOMPATIBILITY(1),
    /**
     *
     *
     * <pre>
     * Indicates the issue is an incompatibility if customers take no further
     * action to resolve.
     * </pre>
     *
     * <code>ADDITIONAL_CONFIG_REQUIRED = 2;</code>
     */
    ADDITIONAL_CONFIG_REQUIRED(2),
    /**
     *
     *
     * <pre>
     * Indicates the issue is not an incompatibility, but depending on the
     * workloads business logic, there is a potential that they won't work on
     * Autopilot.
     * </pre>
     *
     * <code>PASSED_WITH_OPTIONAL_CONFIG = 3;</code>
     */
    PASSED_WITH_OPTIONAL_CONFIG(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value, should not be used.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that the issue is a known incompatibility between the
     * cluster and Autopilot mode.
     * </pre>
     *
     * <code>INCOMPATIBILITY = 1;</code>
     */
    public static final int INCOMPATIBILITY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicates the issue is an incompatibility if customers take no further
     * action to resolve.
     * </pre>
     *
     * <code>ADDITIONAL_CONFIG_REQUIRED = 2;</code>
     */
    public static final int ADDITIONAL_CONFIG_REQUIRED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Indicates the issue is not an incompatibility, but depending on the
     * workloads business logic, there is a potential that they won't work on
     * Autopilot.
     * </pre>
     *
     * <code>PASSED_WITH_OPTIONAL_CONFIG = 3;</code>
     */
    public static final int PASSED_WITH_OPTIONAL_CONFIG_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IssueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IssueType forNumber(int value) {
      switch (value) {
        case 0:
          return UNSPECIFIED;
        case 1:
          return INCOMPATIBILITY;
        case 2:
          return ADDITIONAL_CONFIG_REQUIRED;
        case 3:
          return PASSED_WITH_OPTIONAL_CONFIG;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IssueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IssueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IssueType>() {
          public IssueType findValueByNumber(int number) {
            return IssueType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.AutopilotCompatibilityIssue.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IssueType[] VALUES = values();

    public static IssueType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IssueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.AutopilotCompatibilityIssue.IssueType)
  }

  private int bitField0_;
  public static final int LAST_OBSERVATION_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp lastObservation_;
  /**
   *
   *
   * <pre>
   * The last time when this issue was observed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_observation = 1;</code>
   *
   * @return Whether the lastObservation field is set.
   */
  @java.lang.Override
  public boolean hasLastObservation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The last time when this issue was observed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_observation = 1;</code>
   *
   * @return The lastObservation.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastObservation() {
    return lastObservation_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastObservation_;
  }
  /**
   *
   *
   * <pre>
   * The last time when this issue was observed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_observation = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastObservationOrBuilder() {
    return lastObservation_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastObservation_;
  }

  public static final int CONSTRAINT_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object constraintType_ = "";
  /**
   *
   *
   * <pre>
   * The constraint type of the issue.
   * </pre>
   *
   * <code>string constraint_type = 2;</code>
   *
   * @return The constraintType.
   */
  @java.lang.Override
  public java.lang.String getConstraintType() {
    java.lang.Object ref = constraintType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      constraintType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The constraint type of the issue.
   * </pre>
   *
   * <code>string constraint_type = 2;</code>
   *
   * @return The bytes for constraintType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConstraintTypeBytes() {
    java.lang.Object ref = constraintType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      constraintType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCOMPATIBILITY_TYPE_FIELD_NUMBER = 3;
  private int incompatibilityType_ = 0;
  /**
   *
   *
   * <pre>
   * The incompatibility type of this issue.
   * </pre>
   *
   * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for incompatibilityType.
   */
  @java.lang.Override
  public int getIncompatibilityTypeValue() {
    return incompatibilityType_;
  }
  /**
   *
   *
   * <pre>
   * The incompatibility type of this issue.
   * </pre>
   *
   * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
   * </code>
   *
   * @return The incompatibilityType.
   */
  @java.lang.Override
  public com.google.container.v1.AutopilotCompatibilityIssue.IssueType getIncompatibilityType() {
    com.google.container.v1.AutopilotCompatibilityIssue.IssueType result =
        com.google.container.v1.AutopilotCompatibilityIssue.IssueType.forNumber(
            incompatibilityType_);
    return result == null
        ? com.google.container.v1.AutopilotCompatibilityIssue.IssueType.UNRECOGNIZED
        : result;
  }

  public static final int SUBJECTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subjects_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The name of the resources which are subject to this issue.
   * </pre>
   *
   * <code>repeated string subjects = 4;</code>
   *
   * @return A list containing the subjects.
   */
  public com.google.protobuf.ProtocolStringList getSubjectsList() {
    return subjects_;
  }
  /**
   *
   *
   * <pre>
   * The name of the resources which are subject to this issue.
   * </pre>
   *
   * <code>repeated string subjects = 4;</code>
   *
   * @return The count of subjects.
   */
  public int getSubjectsCount() {
    return subjects_.size();
  }
  /**
   *
   *
   * <pre>
   * The name of the resources which are subject to this issue.
   * </pre>
   *
   * <code>repeated string subjects = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The subjects at the given index.
   */
  public java.lang.String getSubjects(int index) {
    return subjects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The name of the resources which are subject to this issue.
   * </pre>
   *
   * <code>repeated string subjects = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subjects at the given index.
   */
  public com.google.protobuf.ByteString getSubjectsBytes(int index) {
    return subjects_.getByteString(index);
  }

  public static final int DOCUMENTATION_URL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentationUrl_ = "";
  /**
   *
   *
   * <pre>
   * A URL to a public documnetation, which addresses resolving this issue.
   * </pre>
   *
   * <code>string documentation_url = 5;</code>
   *
   * @return The documentationUrl.
   */
  @java.lang.Override
  public java.lang.String getDocumentationUrl() {
    java.lang.Object ref = documentationUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentationUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A URL to a public documnetation, which addresses resolving this issue.
   * </pre>
   *
   * <code>string documentation_url = 5;</code>
   *
   * @return The bytes for documentationUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentationUrlBytes() {
    java.lang.Object ref = documentationUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentationUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the issue.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the issue.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getLastObservation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(constraintType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, constraintType_);
    }
    if (incompatibilityType_
        != com.google.container.v1.AutopilotCompatibilityIssue.IssueType.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, incompatibilityType_);
    }
    for (int i = 0; i < subjects_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, subjects_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentationUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, documentationUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLastObservation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(constraintType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, constraintType_);
    }
    if (incompatibilityType_
        != com.google.container.v1.AutopilotCompatibilityIssue.IssueType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, incompatibilityType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subjects_.size(); i++) {
        dataSize += computeStringSizeNoTag(subjects_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSubjectsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentationUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, documentationUrl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.AutopilotCompatibilityIssue)) {
      return super.equals(obj);
    }
    com.google.container.v1.AutopilotCompatibilityIssue other =
        (com.google.container.v1.AutopilotCompatibilityIssue) obj;

    if (hasLastObservation() != other.hasLastObservation()) return false;
    if (hasLastObservation()) {
      if (!getLastObservation().equals(other.getLastObservation())) return false;
    }
    if (!getConstraintType().equals(other.getConstraintType())) return false;
    if (incompatibilityType_ != other.incompatibilityType_) return false;
    if (!getSubjectsList().equals(other.getSubjectsList())) return false;
    if (!getDocumentationUrl().equals(other.getDocumentationUrl())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLastObservation()) {
      hash = (37 * hash) + LAST_OBSERVATION_FIELD_NUMBER;
      hash = (53 * hash) + getLastObservation().hashCode();
    }
    hash = (37 * hash) + CONSTRAINT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getConstraintType().hashCode();
    hash = (37 * hash) + INCOMPATIBILITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + incompatibilityType_;
    if (getSubjectsCount() > 0) {
      hash = (37 * hash) + SUBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getSubjectsList().hashCode();
    }
    hash = (37 * hash) + DOCUMENTATION_URL_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentationUrl().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.AutopilotCompatibilityIssue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AutopilotCompatibilityIssue contains information about a specific
   * compatibility issue with Autopilot mode.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.AutopilotCompatibilityIssue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.AutopilotCompatibilityIssue)
      com.google.container.v1.AutopilotCompatibilityIssueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_AutopilotCompatibilityIssue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_AutopilotCompatibilityIssue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.AutopilotCompatibilityIssue.class,
              com.google.container.v1.AutopilotCompatibilityIssue.Builder.class);
    }

    // Construct using com.google.container.v1.AutopilotCompatibilityIssue.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLastObservationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      lastObservation_ = null;
      if (lastObservationBuilder_ != null) {
        lastObservationBuilder_.dispose();
        lastObservationBuilder_ = null;
      }
      constraintType_ = "";
      incompatibilityType_ = 0;
      subjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      documentationUrl_ = "";
      description_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_AutopilotCompatibilityIssue_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.AutopilotCompatibilityIssue getDefaultInstanceForType() {
      return com.google.container.v1.AutopilotCompatibilityIssue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.AutopilotCompatibilityIssue build() {
      com.google.container.v1.AutopilotCompatibilityIssue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.AutopilotCompatibilityIssue buildPartial() {
      com.google.container.v1.AutopilotCompatibilityIssue result =
          new com.google.container.v1.AutopilotCompatibilityIssue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.AutopilotCompatibilityIssue result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.lastObservation_ =
            lastObservationBuilder_ == null ? lastObservation_ : lastObservationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.constraintType_ = constraintType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.incompatibilityType_ = incompatibilityType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        subjects_.makeImmutable();
        result.subjects_ = subjects_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.documentationUrl_ = documentationUrl_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.AutopilotCompatibilityIssue) {
        return mergeFrom((com.google.container.v1.AutopilotCompatibilityIssue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.AutopilotCompatibilityIssue other) {
      if (other == com.google.container.v1.AutopilotCompatibilityIssue.getDefaultInstance())
        return this;
      if (other.hasLastObservation()) {
        mergeLastObservation(other.getLastObservation());
      }
      if (!other.getConstraintType().isEmpty()) {
        constraintType_ = other.constraintType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.incompatibilityType_ != 0) {
        setIncompatibilityTypeValue(other.getIncompatibilityTypeValue());
      }
      if (!other.subjects_.isEmpty()) {
        if (subjects_.isEmpty()) {
          subjects_ = other.subjects_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSubjectsIsMutable();
          subjects_.addAll(other.subjects_);
        }
        onChanged();
      }
      if (!other.getDocumentationUrl().isEmpty()) {
        documentationUrl_ = other.documentationUrl_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getLastObservationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                constraintType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                incompatibilityType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSubjectsIsMutable();
                subjects_.add(s);
                break;
              } // case 34
            case 42:
              {
                documentationUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp lastObservation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastObservationBuilder_;
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     *
     * @return Whether the lastObservation field is set.
     */
    public boolean hasLastObservation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     *
     * @return The lastObservation.
     */
    public com.google.protobuf.Timestamp getLastObservation() {
      if (lastObservationBuilder_ == null) {
        return lastObservation_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastObservation_;
      } else {
        return lastObservationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    public Builder setLastObservation(com.google.protobuf.Timestamp value) {
      if (lastObservationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastObservation_ = value;
      } else {
        lastObservationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    public Builder setLastObservation(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastObservationBuilder_ == null) {
        lastObservation_ = builderForValue.build();
      } else {
        lastObservationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    public Builder mergeLastObservation(com.google.protobuf.Timestamp value) {
      if (lastObservationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && lastObservation_ != null
            && lastObservation_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastObservationBuilder().mergeFrom(value);
        } else {
          lastObservation_ = value;
        }
      } else {
        lastObservationBuilder_.mergeFrom(value);
      }
      if (lastObservation_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    public Builder clearLastObservation() {
      bitField0_ = (bitField0_ & ~0x00000001);
      lastObservation_ = null;
      if (lastObservationBuilder_ != null) {
        lastObservationBuilder_.dispose();
        lastObservationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastObservationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getLastObservationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastObservationOrBuilder() {
      if (lastObservationBuilder_ != null) {
        return lastObservationBuilder_.getMessageOrBuilder();
      } else {
        return lastObservation_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastObservation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The last time when this issue was observed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_observation = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastObservationFieldBuilder() {
      if (lastObservationBuilder_ == null) {
        lastObservationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastObservation(), getParentForChildren(), isClean());
        lastObservation_ = null;
      }
      return lastObservationBuilder_;
    }

    private java.lang.Object constraintType_ = "";
    /**
     *
     *
     * <pre>
     * The constraint type of the issue.
     * </pre>
     *
     * <code>string constraint_type = 2;</code>
     *
     * @return The constraintType.
     */
    public java.lang.String getConstraintType() {
      java.lang.Object ref = constraintType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        constraintType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The constraint type of the issue.
     * </pre>
     *
     * <code>string constraint_type = 2;</code>
     *
     * @return The bytes for constraintType.
     */
    public com.google.protobuf.ByteString getConstraintTypeBytes() {
      java.lang.Object ref = constraintType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        constraintType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The constraint type of the issue.
     * </pre>
     *
     * <code>string constraint_type = 2;</code>
     *
     * @param value The constraintType to set.
     * @return This builder for chaining.
     */
    public Builder setConstraintType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      constraintType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The constraint type of the issue.
     * </pre>
     *
     * <code>string constraint_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConstraintType() {
      constraintType_ = getDefaultInstance().getConstraintType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The constraint type of the issue.
     * </pre>
     *
     * <code>string constraint_type = 2;</code>
     *
     * @param value The bytes for constraintType to set.
     * @return This builder for chaining.
     */
    public Builder setConstraintTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      constraintType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int incompatibilityType_ = 0;
    /**
     *
     *
     * <pre>
     * The incompatibility type of this issue.
     * </pre>
     *
     * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for incompatibilityType.
     */
    @java.lang.Override
    public int getIncompatibilityTypeValue() {
      return incompatibilityType_;
    }
    /**
     *
     *
     * <pre>
     * The incompatibility type of this issue.
     * </pre>
     *
     * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for incompatibilityType to set.
     * @return This builder for chaining.
     */
    public Builder setIncompatibilityTypeValue(int value) {
      incompatibilityType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The incompatibility type of this issue.
     * </pre>
     *
     * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
     * </code>
     *
     * @return The incompatibilityType.
     */
    @java.lang.Override
    public com.google.container.v1.AutopilotCompatibilityIssue.IssueType getIncompatibilityType() {
      com.google.container.v1.AutopilotCompatibilityIssue.IssueType result =
          com.google.container.v1.AutopilotCompatibilityIssue.IssueType.forNumber(
              incompatibilityType_);
      return result == null
          ? com.google.container.v1.AutopilotCompatibilityIssue.IssueType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The incompatibility type of this issue.
     * </pre>
     *
     * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
     * </code>
     *
     * @param value The incompatibilityType to set.
     * @return This builder for chaining.
     */
    public Builder setIncompatibilityType(
        com.google.container.v1.AutopilotCompatibilityIssue.IssueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      incompatibilityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The incompatibility type of this issue.
     * </pre>
     *
     * <code>.google.container.v1.AutopilotCompatibilityIssue.IssueType incompatibility_type = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncompatibilityType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      incompatibilityType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList subjects_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSubjectsIsMutable() {
      if (!subjects_.isModifiable()) {
        subjects_ = new com.google.protobuf.LazyStringArrayList(subjects_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @return A list containing the subjects.
     */
    public com.google.protobuf.ProtocolStringList getSubjectsList() {
      subjects_.makeImmutable();
      return subjects_;
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @return The count of subjects.
     */
    public int getSubjectsCount() {
      return subjects_.size();
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The subjects at the given index.
     */
    public java.lang.String getSubjects(int index) {
      return subjects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the subjects at the given index.
     */
    public com.google.protobuf.ByteString getSubjectsBytes(int index) {
      return subjects_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The subjects to set.
     * @return This builder for chaining.
     */
    public Builder setSubjects(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectsIsMutable();
      subjects_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @param value The subjects to add.
     * @return This builder for chaining.
     */
    public Builder addSubjects(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubjectsIsMutable();
      subjects_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @param values The subjects to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubjects(java.lang.Iterable<java.lang.String> values) {
      ensureSubjectsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subjects_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubjects() {
      subjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the resources which are subject to this issue.
     * </pre>
     *
     * <code>repeated string subjects = 4;</code>
     *
     * @param value The bytes of the subjects to add.
     * @return This builder for chaining.
     */
    public Builder addSubjectsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSubjectsIsMutable();
      subjects_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object documentationUrl_ = "";
    /**
     *
     *
     * <pre>
     * A URL to a public documnetation, which addresses resolving this issue.
     * </pre>
     *
     * <code>string documentation_url = 5;</code>
     *
     * @return The documentationUrl.
     */
    public java.lang.String getDocumentationUrl() {
      java.lang.Object ref = documentationUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentationUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A URL to a public documnetation, which addresses resolving this issue.
     * </pre>
     *
     * <code>string documentation_url = 5;</code>
     *
     * @return The bytes for documentationUrl.
     */
    public com.google.protobuf.ByteString getDocumentationUrlBytes() {
      java.lang.Object ref = documentationUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentationUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A URL to a public documnetation, which addresses resolving this issue.
     * </pre>
     *
     * <code>string documentation_url = 5;</code>
     *
     * @param value The documentationUrl to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentationUrl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A URL to a public documnetation, which addresses resolving this issue.
     * </pre>
     *
     * <code>string documentation_url = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentationUrl() {
      documentationUrl_ = getDefaultInstance().getDocumentationUrl();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A URL to a public documnetation, which addresses resolving this issue.
     * </pre>
     *
     * <code>string documentation_url = 5;</code>
     *
     * @param value The bytes for documentationUrl to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentationUrl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the issue.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the issue.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the issue.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the issue.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the issue.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.AutopilotCompatibilityIssue)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.AutopilotCompatibilityIssue)
  private static final com.google.container.v1.AutopilotCompatibilityIssue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.AutopilotCompatibilityIssue();
  }

  public static com.google.container.v1.AutopilotCompatibilityIssue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutopilotCompatibilityIssue> PARSER =
      new com.google.protobuf.AbstractParser<AutopilotCompatibilityIssue>() {
        @java.lang.Override
        public AutopilotCompatibilityIssue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutopilotCompatibilityIssue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutopilotCompatibilityIssue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.AutopilotCompatibilityIssue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
