/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * A Google Kubernetes Engine cluster.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.Cluster}
 */
public final class Cluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.Cluster)
    ClusterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cluster.newBuilder() to construct.
  private Cluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cluster() {
    name_ = "";
    description_ = "";
    loggingService_ = "";
    monitoringService_ = "";
    network_ = "";
    clusterIpv4Cidr_ = "";
    subnetwork_ = "";
    nodePools_ = java.util.Collections.emptyList();
    locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    labelFingerprint_ = "";
    selfLink_ = "";
    zone_ = "";
    endpoint_ = "";
    initialClusterVersion_ = "";
    currentMasterVersion_ = "";
    currentNodeVersion_ = "";
    createTime_ = "";
    status_ = 0;
    statusMessage_ = "";
    servicesIpv4Cidr_ = "";
    instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
    expireTime_ = "";
    location_ = "";
    tpuIpv4CidrBlock_ = "";
    conditions_ = java.util.Collections.emptyList();
    id_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cluster();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_Cluster_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 15:
        return internalGetResourceLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_Cluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.Cluster.class, com.google.container.v1.Cluster.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current status of the cluster.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.Cluster.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The PROVISIONING state indicates the cluster is being created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    PROVISIONING(1),
    /**
     *
     *
     * <pre>
     * The RUNNING state indicates the cluster has been created and is fully
     * usable.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The RECONCILING state indicates that some work is actively being done on
     * the cluster, such as upgrading the master or node software. Details can
     * be found in the `statusMessage` field.
     * </pre>
     *
     * <code>RECONCILING = 3;</code>
     */
    RECONCILING(3),
    /**
     *
     *
     * <pre>
     * The STOPPING state indicates the cluster is being deleted.
     * </pre>
     *
     * <code>STOPPING = 4;</code>
     */
    STOPPING(4),
    /**
     *
     *
     * <pre>
     * The ERROR state indicates the cluster is unusable. It will be
     * automatically deleted. Details can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>ERROR = 5;</code>
     */
    ERROR(5),
    /**
     *
     *
     * <pre>
     * The DEGRADED state indicates the cluster requires user action to restore
     * full functionality. Details can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>DEGRADED = 6;</code>
     */
    DEGRADED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The PROVISIONING state indicates the cluster is being created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    public static final int PROVISIONING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The RUNNING state indicates the cluster has been created and is fully
     * usable.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The RECONCILING state indicates that some work is actively being done on
     * the cluster, such as upgrading the master or node software. Details can
     * be found in the `statusMessage` field.
     * </pre>
     *
     * <code>RECONCILING = 3;</code>
     */
    public static final int RECONCILING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The STOPPING state indicates the cluster is being deleted.
     * </pre>
     *
     * <code>STOPPING = 4;</code>
     */
    public static final int STOPPING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The ERROR state indicates the cluster is unusable. It will be
     * automatically deleted. Details can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>ERROR = 5;</code>
     */
    public static final int ERROR_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The DEGRADED state indicates the cluster requires user action to restore
     * full functionality. Details can be found in the `statusMessage` field.
     * </pre>
     *
     * <code>DEGRADED = 6;</code>
     */
    public static final int DEGRADED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return PROVISIONING;
        case 2:
          return RUNNING;
        case 3:
          return RECONCILING;
        case 4:
          return STOPPING;
        case 5:
          return ERROR;
        case 6:
          return DEGRADED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.Cluster.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.Cluster.Status)
  }

  private int bitField0_;
  private int bitField1_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of this cluster. The name must be unique within this project
   * and location (e.g. zone or region), and can be up to 40 characters with
   * the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only.
   * * Must start with a letter.
   * * Must end with a number or a letter.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of this cluster. The name must be unique within this project
   * and location (e.g. zone or region), and can be up to 40 characters with
   * the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only.
   * * Must start with a letter.
   * * Must end with a number or a letter.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this cluster.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this cluster.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INITIAL_NODE_COUNT_FIELD_NUMBER = 3;
  private int initialNodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of nodes to create in this cluster. You must ensure that your
   * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
   * is sufficient for this number of instances. You must also have available
   * firewall and routes quota.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "node_config") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   *
   * This field is deprecated, use node_pool.initial_node_count instead.
   * </pre>
   *
   * <code>int32 initial_node_count = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.Cluster.initial_node_count is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1877
   * @return The initialNodeCount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getInitialNodeCount() {
    return initialNodeCount_;
  }

  public static final int NODE_CONFIG_FIELD_NUMBER = 4;
  private com.google.container.v1.NodeConfig nodeConfig_;
  /**
   *
   *
   * <pre>
   * Parameters used in creating the cluster's nodes.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "initial_node_count") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   * For responses, this field will be populated with the node configuration of
   * the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used.
   * This field is deprecated, use node_pool.config instead.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.Cluster.node_config is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1890
   * @return Whether the nodeConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasNodeConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters used in creating the cluster's nodes.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "initial_node_count") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   * For responses, this field will be populated with the node configuration of
   * the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used.
   * This field is deprecated, use node_pool.config instead.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.Cluster.node_config is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1890
   * @return The nodeConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.NodeConfig getNodeConfig() {
    return nodeConfig_ == null
        ? com.google.container.v1.NodeConfig.getDefaultInstance()
        : nodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Parameters used in creating the cluster's nodes.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "initial_node_count") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   * For responses, this field will be populated with the node configuration of
   * the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used.
   * This field is deprecated, use node_pool.config instead.
   * </pre>
   *
   * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.NodeConfigOrBuilder getNodeConfigOrBuilder() {
    return nodeConfig_ == null
        ? com.google.container.v1.NodeConfig.getDefaultInstance()
        : nodeConfig_;
  }

  public static final int MASTER_AUTH_FIELD_NUMBER = 5;
  private com.google.container.v1.MasterAuth masterAuth_;
  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * If unspecified, the defaults are used:
   * For clusters before v1.12, if master_auth is unspecified, `username` will
   * be set to "admin", a random password will be generated, and a client
   * certificate will be issued.
   * </pre>
   *
   * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
   *
   * @return Whether the masterAuth field is set.
   */
  @java.lang.Override
  public boolean hasMasterAuth() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * If unspecified, the defaults are used:
   * For clusters before v1.12, if master_auth is unspecified, `username` will
   * be set to "admin", a random password will be generated, and a client
   * certificate will be issued.
   * </pre>
   *
   * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
   *
   * @return The masterAuth.
   */
  @java.lang.Override
  public com.google.container.v1.MasterAuth getMasterAuth() {
    return masterAuth_ == null
        ? com.google.container.v1.MasterAuth.getDefaultInstance()
        : masterAuth_;
  }
  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * If unspecified, the defaults are used:
   * For clusters before v1.12, if master_auth is unspecified, `username` will
   * be set to "admin", a random password will be generated, and a client
   * certificate will be issued.
   * </pre>
   *
   * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
   */
  @java.lang.Override
  public com.google.container.v1.MasterAuthOrBuilder getMasterAuthOrBuilder() {
    return masterAuth_ == null
        ? com.google.container.v1.MasterAuth.getDefaultInstance()
        : masterAuth_;
  }

  public static final int LOGGING_SERVICE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object loggingService_ = "";
  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string logging_service = 6;</code>
   *
   * @return The loggingService.
   */
  @java.lang.Override
  public java.lang.String getLoggingService() {
    java.lang.Object ref = loggingService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      loggingService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string logging_service = 6;</code>
   *
   * @return The bytes for loggingService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLoggingServiceBytes() {
    java.lang.Object ref = loggingService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      loggingService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MONITORING_SERVICE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object monitoringService_ = "";
  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string monitoring_service = 7;</code>
   *
   * @return The monitoringService.
   */
  @java.lang.Override
  public java.lang.String getMonitoringService() {
    java.lang.Object ref = monitoringService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      monitoringService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string monitoring_service = 7;</code>
   *
   * @return The bytes for monitoringService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMonitoringServiceBytes() {
    java.lang.Object ref = monitoringService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      monitoringService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default`
   * network will be used.
   * </pre>
   *
   * <code>string network = 8;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default`
   * network will be used.
   * </pre>
   *
   * <code>string network = 8;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_IPV4_CIDR_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterIpv4Cidr_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`). Leave blank to have
   * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr = 9;</code>
   *
   * @return The clusterIpv4Cidr.
   */
  @java.lang.Override
  public java.lang.String getClusterIpv4Cidr() {
    java.lang.Object ref = clusterIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterIpv4Cidr_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`). Leave blank to have
   * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr = 9;</code>
   *
   * @return The bytes for clusterIpv4Cidr.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterIpv4CidrBytes() {
    java.lang.Object ref = clusterIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterIpv4Cidr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDONS_CONFIG_FIELD_NUMBER = 10;
  private com.google.container.v1.AddonsConfig addonsConfig_;
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
   *
   * @return Whether the addonsConfig field is set.
   */
  @java.lang.Override
  public boolean hasAddonsConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
   *
   * @return The addonsConfig.
   */
  @java.lang.Override
  public com.google.container.v1.AddonsConfig getAddonsConfig() {
    return addonsConfig_ == null
        ? com.google.container.v1.AddonsConfig.getDefaultInstance()
        : addonsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AddonsConfigOrBuilder getAddonsConfigOrBuilder() {
    return addonsConfig_ == null
        ? com.google.container.v1.AddonsConfig.getDefaultInstance()
        : addonsConfig_;
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
   * the cluster is connected.
   * </pre>
   *
   * <code>string subnetwork = 11;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
   * the cluster is connected.
   * </pre>
   *
   * <code>string subnetwork = 11;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_POOLS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.NodePool> nodePools_;
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.NodePool> getNodePoolsList() {
    return nodePools_;
  }
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.NodePoolOrBuilder>
      getNodePoolsOrBuilderList() {
    return nodePools_;
  }
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
   */
  @java.lang.Override
  public int getNodePoolsCount() {
    return nodePools_.size();
  }
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePool getNodePools(int index) {
    return nodePools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolOrBuilder getNodePoolsOrBuilder(int index) {
    return nodePools_.get(index);
  }

  public static final int LOCATIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList locations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return A list containing the locations.
   */
  public com.google.protobuf.ProtocolStringList getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return The count of locations.
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  public java.lang.String getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  public com.google.protobuf.ByteString getLocationsBytes(int index) {
    return locations_.getByteString(index);
  }

  public static final int ENABLE_KUBERNETES_ALPHA_FIELD_NUMBER = 14;
  private boolean enableKubernetesAlpha_ = false;
  /**
   *
   *
   * <pre>
   * Kubernetes alpha features are enabled on this cluster. This includes alpha
   * API groups (e.g. v1alpha1) and features that may not be production ready in
   * the kubernetes version of the master and nodes.
   * The cluster has no SLA for uptime and master/node upgrades are disabled.
   * Alpha enabled clusters are automatically deleted thirty days after
   * creation.
   * </pre>
   *
   * <code>bool enable_kubernetes_alpha = 14;</code>
   *
   * @return The enableKubernetesAlpha.
   */
  @java.lang.Override
  public boolean getEnableKubernetesAlpha() {
    return enableKubernetesAlpha_;
  }

  public static final int RESOURCE_LABELS_FIELD_NUMBER = 15;

  private static final class ResourceLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_Cluster_ResourceLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourceLabels() {
    if (resourceLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourceLabelsDefaultEntryHolder.defaultEntry);
    }
    return resourceLabels_;
  }

  public int getResourceLabelsCount() {
    return internalGetResourceLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsResourceLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourceLabels().getMap().containsKey(key);
  }
  /** Use {@link #getResourceLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourceLabels() {
    return getResourceLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap() {
    return internalGetResourceLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourceLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getResourceLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";
  /**
   *
   *
   * <pre>
   * The fingerprint of the set of labels for this cluster.
   * </pre>
   *
   * <code>string label_fingerprint = 16;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The fingerprint of the set of labels for this cluster.
   * </pre>
   *
   * <code>string label_fingerprint = 16;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LEGACY_ABAC_FIELD_NUMBER = 18;
  private com.google.container.v1.LegacyAbac legacyAbac_;
  /**
   *
   *
   * <pre>
   * Configuration for the legacy ABAC authorization mode.
   * </pre>
   *
   * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
   *
   * @return Whether the legacyAbac field is set.
   */
  @java.lang.Override
  public boolean hasLegacyAbac() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the legacy ABAC authorization mode.
   * </pre>
   *
   * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
   *
   * @return The legacyAbac.
   */
  @java.lang.Override
  public com.google.container.v1.LegacyAbac getLegacyAbac() {
    return legacyAbac_ == null
        ? com.google.container.v1.LegacyAbac.getDefaultInstance()
        : legacyAbac_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the legacy ABAC authorization mode.
   * </pre>
   *
   * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
   */
  @java.lang.Override
  public com.google.container.v1.LegacyAbacOrBuilder getLegacyAbacOrBuilder() {
    return legacyAbac_ == null
        ? com.google.container.v1.LegacyAbac.getDefaultInstance()
        : legacyAbac_;
  }

  public static final int NETWORK_POLICY_FIELD_NUMBER = 19;
  private com.google.container.v1.NetworkPolicy networkPolicy_;
  /**
   *
   *
   * <pre>
   * Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
   *
   * @return Whether the networkPolicy field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
   *
   * @return The networkPolicy.
   */
  @java.lang.Override
  public com.google.container.v1.NetworkPolicy getNetworkPolicy() {
    return networkPolicy_ == null
        ? com.google.container.v1.NetworkPolicy.getDefaultInstance()
        : networkPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NetworkPolicyOrBuilder getNetworkPolicyOrBuilder() {
    return networkPolicy_ == null
        ? com.google.container.v1.NetworkPolicy.getDefaultInstance()
        : networkPolicy_;
  }

  public static final int IP_ALLOCATION_POLICY_FIELD_NUMBER = 20;
  private com.google.container.v1.IPAllocationPolicy ipAllocationPolicy_;
  /**
   *
   *
   * <pre>
   * Configuration for cluster IP allocation.
   * </pre>
   *
   * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
   *
   * @return Whether the ipAllocationPolicy field is set.
   */
  @java.lang.Override
  public boolean hasIpAllocationPolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for cluster IP allocation.
   * </pre>
   *
   * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
   *
   * @return The ipAllocationPolicy.
   */
  @java.lang.Override
  public com.google.container.v1.IPAllocationPolicy getIpAllocationPolicy() {
    return ipAllocationPolicy_ == null
        ? com.google.container.v1.IPAllocationPolicy.getDefaultInstance()
        : ipAllocationPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for cluster IP allocation.
   * </pre>
   *
   * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
   */
  @java.lang.Override
  public com.google.container.v1.IPAllocationPolicyOrBuilder getIpAllocationPolicyOrBuilder() {
    return ipAllocationPolicy_ == null
        ? com.google.container.v1.IPAllocationPolicy.getDefaultInstance()
        : ipAllocationPolicy_;
  }

  public static final int MASTER_AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER = 22;
  private com.google.container.v1.MasterAuthorizedNetworksConfig masterAuthorizedNetworksConfig_;
  /**
   *
   *
   * <pre>
   * The configuration options for master authorized networks feature.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.master_authorized_networks_config is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1992
   * @return Whether the masterAuthorizedNetworksConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasMasterAuthorizedNetworksConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The configuration options for master authorized networks feature.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.master_authorized_networks_config is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1992
   * @return The masterAuthorizedNetworksConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.MasterAuthorizedNetworksConfig
      getMasterAuthorizedNetworksConfig() {
    return masterAuthorizedNetworksConfig_ == null
        ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
        : masterAuthorizedNetworksConfig_;
  }
  /**
   *
   *
   * <pre>
   * The configuration options for master authorized networks feature.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder
      getMasterAuthorizedNetworksConfigOrBuilder() {
    return masterAuthorizedNetworksConfig_ == null
        ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
        : masterAuthorizedNetworksConfig_;
  }

  public static final int MAINTENANCE_POLICY_FIELD_NUMBER = 23;
  private com.google.container.v1.MaintenancePolicy maintenancePolicy_;
  /**
   *
   *
   * <pre>
   * Configure the maintenance policy for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
   *
   * @return Whether the maintenancePolicy field is set.
   */
  @java.lang.Override
  public boolean hasMaintenancePolicy() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configure the maintenance policy for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
   *
   * @return The maintenancePolicy.
   */
  @java.lang.Override
  public com.google.container.v1.MaintenancePolicy getMaintenancePolicy() {
    return maintenancePolicy_ == null
        ? com.google.container.v1.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Configure the maintenance policy for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
   */
  @java.lang.Override
  public com.google.container.v1.MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder() {
    return maintenancePolicy_ == null
        ? com.google.container.v1.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }

  public static final int BINARY_AUTHORIZATION_FIELD_NUMBER = 24;
  private com.google.container.v1.BinaryAuthorization binaryAuthorization_;
  /**
   *
   *
   * <pre>
   * Configuration for Binary Authorization.
   * </pre>
   *
   * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
   *
   * @return Whether the binaryAuthorization field is set.
   */
  @java.lang.Override
  public boolean hasBinaryAuthorization() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Binary Authorization.
   * </pre>
   *
   * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
   *
   * @return The binaryAuthorization.
   */
  @java.lang.Override
  public com.google.container.v1.BinaryAuthorization getBinaryAuthorization() {
    return binaryAuthorization_ == null
        ? com.google.container.v1.BinaryAuthorization.getDefaultInstance()
        : binaryAuthorization_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for Binary Authorization.
   * </pre>
   *
   * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
   */
  @java.lang.Override
  public com.google.container.v1.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder() {
    return binaryAuthorization_ == null
        ? com.google.container.v1.BinaryAuthorization.getDefaultInstance()
        : binaryAuthorization_;
  }

  public static final int AUTOSCALING_FIELD_NUMBER = 26;
  private com.google.container.v1.ClusterAutoscaling autoscaling_;
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
   *
   * @return Whether the autoscaling field is set.
   */
  @java.lang.Override
  public boolean hasAutoscaling() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
   *
   * @return The autoscaling.
   */
  @java.lang.Override
  public com.google.container.v1.ClusterAutoscaling getAutoscaling() {
    return autoscaling_ == null
        ? com.google.container.v1.ClusterAutoscaling.getDefaultInstance()
        : autoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ClusterAutoscalingOrBuilder getAutoscalingOrBuilder() {
    return autoscaling_ == null
        ? com.google.container.v1.ClusterAutoscaling.getDefaultInstance()
        : autoscaling_;
  }

  public static final int NETWORK_CONFIG_FIELD_NUMBER = 27;
  private com.google.container.v1.NetworkConfig networkConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for cluster networking.
   * </pre>
   *
   * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
   *
   * @return Whether the networkConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkConfig() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for cluster networking.
   * </pre>
   *
   * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
   *
   * @return The networkConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NetworkConfig getNetworkConfig() {
    return networkConfig_ == null
        ? com.google.container.v1.NetworkConfig.getDefaultInstance()
        : networkConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for cluster networking.
   * </pre>
   *
   * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NetworkConfigOrBuilder getNetworkConfigOrBuilder() {
    return networkConfig_ == null
        ? com.google.container.v1.NetworkConfig.getDefaultInstance()
        : networkConfig_;
  }

  public static final int DEFAULT_MAX_PODS_CONSTRAINT_FIELD_NUMBER = 30;
  private com.google.container.v1.MaxPodsConstraint defaultMaxPodsConstraint_;
  /**
   *
   *
   * <pre>
   * The default constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool of this cluster. Only honored
   * if cluster created with IP Alias support.
   * </pre>
   *
   * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
   *
   * @return Whether the defaultMaxPodsConstraint field is set.
   */
  @java.lang.Override
  public boolean hasDefaultMaxPodsConstraint() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The default constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool of this cluster. Only honored
   * if cluster created with IP Alias support.
   * </pre>
   *
   * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
   *
   * @return The defaultMaxPodsConstraint.
   */
  @java.lang.Override
  public com.google.container.v1.MaxPodsConstraint getDefaultMaxPodsConstraint() {
    return defaultMaxPodsConstraint_ == null
        ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
        : defaultMaxPodsConstraint_;
  }
  /**
   *
   *
   * <pre>
   * The default constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool of this cluster. Only honored
   * if cluster created with IP Alias support.
   * </pre>
   *
   * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
   */
  @java.lang.Override
  public com.google.container.v1.MaxPodsConstraintOrBuilder getDefaultMaxPodsConstraintOrBuilder() {
    return defaultMaxPodsConstraint_ == null
        ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
        : defaultMaxPodsConstraint_;
  }

  public static final int RESOURCE_USAGE_EXPORT_CONFIG_FIELD_NUMBER = 33;
  private com.google.container.v1.ResourceUsageExportConfig resourceUsageExportConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for exporting resource usages. Resource usage export is
   * disabled when this config is unspecified.
   * </pre>
   *
   * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;</code>
   *
   * @return Whether the resourceUsageExportConfig field is set.
   */
  @java.lang.Override
  public boolean hasResourceUsageExportConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for exporting resource usages. Resource usage export is
   * disabled when this config is unspecified.
   * </pre>
   *
   * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;</code>
   *
   * @return The resourceUsageExportConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfig getResourceUsageExportConfig() {
    return resourceUsageExportConfig_ == null
        ? com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance()
        : resourceUsageExportConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for exporting resource usages. Resource usage export is
   * disabled when this config is unspecified.
   * </pre>
   *
   * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ResourceUsageExportConfigOrBuilder
      getResourceUsageExportConfigOrBuilder() {
    return resourceUsageExportConfig_ == null
        ? com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance()
        : resourceUsageExportConfig_;
  }

  public static final int AUTHENTICATOR_GROUPS_CONFIG_FIELD_NUMBER = 34;
  private com.google.container.v1.AuthenticatorGroupsConfig authenticatorGroupsConfig_;
  /**
   *
   *
   * <pre>
   * Configuration controlling RBAC group membership information.
   * </pre>
   *
   * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
   *
   * @return Whether the authenticatorGroupsConfig field is set.
   */
  @java.lang.Override
  public boolean hasAuthenticatorGroupsConfig() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration controlling RBAC group membership information.
   * </pre>
   *
   * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
   *
   * @return The authenticatorGroupsConfig.
   */
  @java.lang.Override
  public com.google.container.v1.AuthenticatorGroupsConfig getAuthenticatorGroupsConfig() {
    return authenticatorGroupsConfig_ == null
        ? com.google.container.v1.AuthenticatorGroupsConfig.getDefaultInstance()
        : authenticatorGroupsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration controlling RBAC group membership information.
   * </pre>
   *
   * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AuthenticatorGroupsConfigOrBuilder
      getAuthenticatorGroupsConfigOrBuilder() {
    return authenticatorGroupsConfig_ == null
        ? com.google.container.v1.AuthenticatorGroupsConfig.getDefaultInstance()
        : authenticatorGroupsConfig_;
  }

  public static final int PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER = 37;
  private com.google.container.v1.PrivateClusterConfig privateClusterConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for private cluster.
   * </pre>
   *
   * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
   *
   * @return Whether the privateClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateClusterConfig() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for private cluster.
   * </pre>
   *
   * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
   *
   * @return The privateClusterConfig.
   */
  @java.lang.Override
  public com.google.container.v1.PrivateClusterConfig getPrivateClusterConfig() {
    return privateClusterConfig_ == null
        ? com.google.container.v1.PrivateClusterConfig.getDefaultInstance()
        : privateClusterConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for private cluster.
   * </pre>
   *
   * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
   */
  @java.lang.Override
  public com.google.container.v1.PrivateClusterConfigOrBuilder getPrivateClusterConfigOrBuilder() {
    return privateClusterConfig_ == null
        ? com.google.container.v1.PrivateClusterConfig.getDefaultInstance()
        : privateClusterConfig_;
  }

  public static final int DATABASE_ENCRYPTION_FIELD_NUMBER = 38;
  private com.google.container.v1.DatabaseEncryption databaseEncryption_;
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
   *
   * @return Whether the databaseEncryption field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseEncryption() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
   *
   * @return The databaseEncryption.
   */
  @java.lang.Override
  public com.google.container.v1.DatabaseEncryption getDatabaseEncryption() {
    return databaseEncryption_ == null
        ? com.google.container.v1.DatabaseEncryption.getDefaultInstance()
        : databaseEncryption_;
  }
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
   */
  @java.lang.Override
  public com.google.container.v1.DatabaseEncryptionOrBuilder getDatabaseEncryptionOrBuilder() {
    return databaseEncryption_ == null
        ? com.google.container.v1.DatabaseEncryption.getDefaultInstance()
        : databaseEncryption_;
  }

  public static final int VERTICAL_POD_AUTOSCALING_FIELD_NUMBER = 39;
  private com.google.container.v1.VerticalPodAutoscaling verticalPodAutoscaling_;
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
   *
   * @return Whether the verticalPodAutoscaling field is set.
   */
  @java.lang.Override
  public boolean hasVerticalPodAutoscaling() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
   *
   * @return The verticalPodAutoscaling.
   */
  @java.lang.Override
  public com.google.container.v1.VerticalPodAutoscaling getVerticalPodAutoscaling() {
    return verticalPodAutoscaling_ == null
        ? com.google.container.v1.VerticalPodAutoscaling.getDefaultInstance()
        : verticalPodAutoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
   */
  @java.lang.Override
  public com.google.container.v1.VerticalPodAutoscalingOrBuilder
      getVerticalPodAutoscalingOrBuilder() {
    return verticalPodAutoscaling_ == null
        ? com.google.container.v1.VerticalPodAutoscaling.getDefaultInstance()
        : verticalPodAutoscaling_;
  }

  public static final int SHIELDED_NODES_FIELD_NUMBER = 40;
  private com.google.container.v1.ShieldedNodes shieldedNodes_;
  /**
   *
   *
   * <pre>
   * Shielded Nodes configuration.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
   *
   * @return Whether the shieldedNodes field is set.
   */
  @java.lang.Override
  public boolean hasShieldedNodes() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Shielded Nodes configuration.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
   *
   * @return The shieldedNodes.
   */
  @java.lang.Override
  public com.google.container.v1.ShieldedNodes getShieldedNodes() {
    return shieldedNodes_ == null
        ? com.google.container.v1.ShieldedNodes.getDefaultInstance()
        : shieldedNodes_;
  }
  /**
   *
   *
   * <pre>
   * Shielded Nodes configuration.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ShieldedNodesOrBuilder getShieldedNodesOrBuilder() {
    return shieldedNodes_ == null
        ? com.google.container.v1.ShieldedNodes.getDefaultInstance()
        : shieldedNodes_;
  }

  public static final int RELEASE_CHANNEL_FIELD_NUMBER = 41;
  private com.google.container.v1.ReleaseChannel releaseChannel_;
  /**
   *
   *
   * <pre>
   * Release channel configuration. If left unspecified on cluster creation and
   * a version is specified, the cluster is enrolled in the most mature release
   * channel where the version is available (first checking STABLE, then
   * REGULAR, and finally RAPID). Otherwise, if no release channel
   * configuration and no version is specified, the cluster is enrolled in the
   * REGULAR channel with its default version.
   * </pre>
   *
   * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
   *
   * @return Whether the releaseChannel field is set.
   */
  @java.lang.Override
  public boolean hasReleaseChannel() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Release channel configuration. If left unspecified on cluster creation and
   * a version is specified, the cluster is enrolled in the most mature release
   * channel where the version is available (first checking STABLE, then
   * REGULAR, and finally RAPID). Otherwise, if no release channel
   * configuration and no version is specified, the cluster is enrolled in the
   * REGULAR channel with its default version.
   * </pre>
   *
   * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
   *
   * @return The releaseChannel.
   */
  @java.lang.Override
  public com.google.container.v1.ReleaseChannel getReleaseChannel() {
    return releaseChannel_ == null
        ? com.google.container.v1.ReleaseChannel.getDefaultInstance()
        : releaseChannel_;
  }
  /**
   *
   *
   * <pre>
   * Release channel configuration. If left unspecified on cluster creation and
   * a version is specified, the cluster is enrolled in the most mature release
   * channel where the version is available (first checking STABLE, then
   * REGULAR, and finally RAPID). Otherwise, if no release channel
   * configuration and no version is specified, the cluster is enrolled in the
   * REGULAR channel with its default version.
   * </pre>
   *
   * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ReleaseChannelOrBuilder getReleaseChannelOrBuilder() {
    return releaseChannel_ == null
        ? com.google.container.v1.ReleaseChannel.getDefaultInstance()
        : releaseChannel_;
  }

  public static final int WORKLOAD_IDENTITY_CONFIG_FIELD_NUMBER = 43;
  private com.google.container.v1.WorkloadIdentityConfig workloadIdentityConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM
   * policies.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
   *
   * @return Whether the workloadIdentityConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkloadIdentityConfig() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM
   * policies.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
   *
   * @return The workloadIdentityConfig.
   */
  @java.lang.Override
  public com.google.container.v1.WorkloadIdentityConfig getWorkloadIdentityConfig() {
    return workloadIdentityConfig_ == null
        ? com.google.container.v1.WorkloadIdentityConfig.getDefaultInstance()
        : workloadIdentityConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM
   * policies.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
   */
  @java.lang.Override
  public com.google.container.v1.WorkloadIdentityConfigOrBuilder
      getWorkloadIdentityConfigOrBuilder() {
    return workloadIdentityConfig_ == null
        ? com.google.container.v1.WorkloadIdentityConfig.getDefaultInstance()
        : workloadIdentityConfig_;
  }

  public static final int MESH_CERTIFICATES_FIELD_NUMBER = 67;
  private com.google.container.v1.MeshCertificates meshCertificates_;
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
   *
   * @return Whether the meshCertificates field is set.
   */
  @java.lang.Override
  public boolean hasMeshCertificates() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
   *
   * @return The meshCertificates.
   */
  @java.lang.Override
  public com.google.container.v1.MeshCertificates getMeshCertificates() {
    return meshCertificates_ == null
        ? com.google.container.v1.MeshCertificates.getDefaultInstance()
        : meshCertificates_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
   */
  @java.lang.Override
  public com.google.container.v1.MeshCertificatesOrBuilder getMeshCertificatesOrBuilder() {
    return meshCertificates_ == null
        ? com.google.container.v1.MeshCertificates.getDefaultInstance()
        : meshCertificates_;
  }

  public static final int COST_MANAGEMENT_CONFIG_FIELD_NUMBER = 45;
  private com.google.container.v1.CostManagementConfig costManagementConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
   *
   * @return Whether the costManagementConfig field is set.
   */
  @java.lang.Override
  public boolean hasCostManagementConfig() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
   *
   * @return The costManagementConfig.
   */
  @java.lang.Override
  public com.google.container.v1.CostManagementConfig getCostManagementConfig() {
    return costManagementConfig_ == null
        ? com.google.container.v1.CostManagementConfig.getDefaultInstance()
        : costManagementConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
   */
  @java.lang.Override
  public com.google.container.v1.CostManagementConfigOrBuilder getCostManagementConfigOrBuilder() {
    return costManagementConfig_ == null
        ? com.google.container.v1.CostManagementConfig.getDefaultInstance()
        : costManagementConfig_;
  }

  public static final int NOTIFICATION_CONFIG_FIELD_NUMBER = 49;
  private com.google.container.v1.NotificationConfig notificationConfig_;
  /**
   *
   *
   * <pre>
   * Notification configuration of the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
   *
   * @return Whether the notificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasNotificationConfig() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Notification configuration of the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
   *
   * @return The notificationConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NotificationConfig getNotificationConfig() {
    return notificationConfig_ == null
        ? com.google.container.v1.NotificationConfig.getDefaultInstance()
        : notificationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Notification configuration of the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NotificationConfigOrBuilder getNotificationConfigOrBuilder() {
    return notificationConfig_ == null
        ? com.google.container.v1.NotificationConfig.getDefaultInstance()
        : notificationConfig_;
  }

  public static final int CONFIDENTIAL_NODES_FIELD_NUMBER = 50;
  private com.google.container.v1.ConfidentialNodes confidentialNodes_;
  /**
   *
   *
   * <pre>
   * Configuration of Confidential Nodes.
   * All the nodes in the cluster will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
   *
   * @return Whether the confidentialNodes field is set.
   */
  @java.lang.Override
  public boolean hasConfidentialNodes() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration of Confidential Nodes.
   * All the nodes in the cluster will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
   *
   * @return The confidentialNodes.
   */
  @java.lang.Override
  public com.google.container.v1.ConfidentialNodes getConfidentialNodes() {
    return confidentialNodes_ == null
        ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
        : confidentialNodes_;
  }
  /**
   *
   *
   * <pre>
   * Configuration of Confidential Nodes.
   * All the nodes in the cluster will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
   */
  @java.lang.Override
  public com.google.container.v1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder() {
    return confidentialNodes_ == null
        ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
        : confidentialNodes_;
  }

  public static final int IDENTITY_SERVICE_CONFIG_FIELD_NUMBER = 54;
  private com.google.container.v1.IdentityServiceConfig identityServiceConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for Identity Service component.
   * </pre>
   *
   * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
   *
   * @return Whether the identityServiceConfig field is set.
   */
  @java.lang.Override
  public boolean hasIdentityServiceConfig() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Identity Service component.
   * </pre>
   *
   * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
   *
   * @return The identityServiceConfig.
   */
  @java.lang.Override
  public com.google.container.v1.IdentityServiceConfig getIdentityServiceConfig() {
    return identityServiceConfig_ == null
        ? com.google.container.v1.IdentityServiceConfig.getDefaultInstance()
        : identityServiceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for Identity Service component.
   * </pre>
   *
   * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
   */
  @java.lang.Override
  public com.google.container.v1.IdentityServiceConfigOrBuilder
      getIdentityServiceConfigOrBuilder() {
    return identityServiceConfig_ == null
        ? com.google.container.v1.IdentityServiceConfig.getDefaultInstance()
        : identityServiceConfig_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 100;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 101;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field is deprecated, use location instead.
   * </pre>
   *
   * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.container.v1.Cluster.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2066
   * @return The zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field is deprecated, use location instead.
   * </pre>
   *
   * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.container.v1.Cluster.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2066
   * @return The bytes for zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENDPOINT_FIELD_NUMBER = 102;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The IP address of this cluster's master endpoint.
   * The endpoint can be accessed from the internet at
   * `https://username:password&#64;endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and
   * password information.
   * </pre>
   *
   * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The IP address of this cluster's master endpoint.
   * The endpoint can be accessed from the internet at
   * `https://username:password&#64;endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and
   * password information.
   * </pre>
   *
   * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INITIAL_CLUSTER_VERSION_FIELD_NUMBER = 103;

  @SuppressWarnings("serial")
  private volatile java.lang.Object initialClusterVersion_ = "";
  /**
   *
   *
   * <pre>
   * The initial Kubernetes version for this cluster.  Valid versions are those
   * found in validMasterVersions returned by getServerConfig.  The version can
   * be upgraded over time; such upgrades are reflected in
   * currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "","-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string initial_cluster_version = 103;</code>
   *
   * @return The initialClusterVersion.
   */
  @java.lang.Override
  public java.lang.String getInitialClusterVersion() {
    java.lang.Object ref = initialClusterVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      initialClusterVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The initial Kubernetes version for this cluster.  Valid versions are those
   * found in validMasterVersions returned by getServerConfig.  The version can
   * be upgraded over time; such upgrades are reflected in
   * currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "","-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string initial_cluster_version = 103;</code>
   *
   * @return The bytes for initialClusterVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInitialClusterVersionBytes() {
    java.lang.Object ref = initialClusterVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      initialClusterVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENT_MASTER_VERSION_FIELD_NUMBER = 104;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentMasterVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The current software version of the master endpoint.
   * </pre>
   *
   * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The currentMasterVersion.
   */
  @java.lang.Override
  public java.lang.String getCurrentMasterVersion() {
    java.lang.Object ref = currentMasterVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentMasterVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The current software version of the master endpoint.
   * </pre>
   *
   * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for currentMasterVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentMasterVersionBytes() {
    java.lang.Object ref = currentMasterVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentMasterVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENT_NODE_VERSION_FIELD_NUMBER = 105;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentNodeVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Deprecated, use
   * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
   * instead. The current version of the node software components. If they are
   * currently at multiple versions because they're in the process of being
   * upgraded, this reflects the minimum version of all nodes.
   * </pre>
   *
   * <code>
   * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2101
   * @return The currentNodeVersion.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getCurrentNodeVersion() {
    java.lang.Object ref = currentNodeVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentNodeVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated, use
   * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
   * instead. The current version of the node software components. If they are
   * currently at multiple versions because they're in the process of being
   * upgraded, this reflects the minimum version of all nodes.
   * </pre>
   *
   * <code>
   * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2101
   * @return The bytes for currentNodeVersion.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getCurrentNodeVersionBytes() {
    java.lang.Object ref = currentNodeVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentNodeVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 106;

  @SuppressWarnings("serial")
  private volatile java.lang.Object createTime_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public java.lang.String getCreateTime() {
    java.lang.Object ref = createTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      createTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for createTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreateTimeBytes() {
    java.lang.Object ref = createTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      createTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 107;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current status of this cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current status of this cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.container.v1.Cluster.Status getStatus() {
    com.google.container.v1.Cluster.Status result =
        com.google.container.v1.Cluster.Status.forNumber(status_);
    return result == null ? com.google.container.v1.Cluster.Status.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 108;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use conditions instead.
   * Additional information about the current status of this
   * cluster, if available.
   * </pre>
   *
   * <code>
   * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.status_message is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2114
   * @return The statusMessage.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use conditions instead.
   * Additional information about the current status of this
   * cluster, if available.
   * </pre>
   *
   * <code>
   * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.status_message is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2114
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_IPV4_CIDR_SIZE_FIELD_NUMBER = 109;
  private int nodeIpv4CidrSize_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The size of the address space on each node for hosting
   * containers. This is provisioned from within the `container_ipv4_cidr`
   * range. This field will only be set when cluster is in route-based network
   * mode.
   * </pre>
   *
   * <code>int32 node_ipv4_cidr_size = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The nodeIpv4CidrSize.
   */
  @java.lang.Override
  public int getNodeIpv4CidrSize() {
    return nodeIpv4CidrSize_;
  }

  public static final int SERVICES_IPV4_CIDR_FIELD_NUMBER = 110;

  @SuppressWarnings("serial")
  private volatile java.lang.Object servicesIpv4Cidr_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Kubernetes services in
   * this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`). Service addresses are
   * typically put in the last `/16` from the container CIDR.
   * </pre>
   *
   * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The servicesIpv4Cidr.
   */
  @java.lang.Override
  public java.lang.String getServicesIpv4Cidr() {
    java.lang.Object ref = servicesIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      servicesIpv4Cidr_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Kubernetes services in
   * this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`). Service addresses are
   * typically put in the last `/16` from the container CIDR.
   * </pre>
   *
   * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for servicesIpv4Cidr.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServicesIpv4CidrBytes() {
    java.lang.Object ref = servicesIpv4Cidr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      servicesIpv4Cidr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_GROUP_URLS_FIELD_NUMBER = 111;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instanceGroupUrls_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2131
   * @return A list containing the instanceGroupUrls.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getInstanceGroupUrlsList() {
    return instanceGroupUrls_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2131
   * @return The count of instanceGroupUrls.
   */
  @java.lang.Deprecated
  public int getInstanceGroupUrlsCount() {
    return instanceGroupUrls_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2131
   * @param index The index of the element to return.
   * @return The instanceGroupUrls at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getInstanceGroupUrls(int index) {
    return instanceGroupUrls_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2131
   * @param index The index of the value to return.
   * @return The bytes of the instanceGroupUrls at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getInstanceGroupUrlsBytes(int index) {
    return instanceGroupUrls_.getByteString(index);
  }

  public static final int CURRENT_NODE_COUNT_FIELD_NUMBER = 112;
  private int currentNodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of nodes currently in the cluster. Deprecated.
   * Call Kubernetes API directly to retrieve node information.
   * </pre>
   *
   * <code>
   * int32 current_node_count = 112 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.Cluster.current_node_count is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2136
   * @return The currentNodeCount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getCurrentNodeCount() {
    return currentNodeCount_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 113;

  @SuppressWarnings("serial")
  private volatile java.lang.Object expireTime_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The time the cluster will be automatically
   * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public java.lang.String getExpireTime() {
    java.lang.Object ref = expireTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      expireTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the cluster will be automatically
   * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExpireTimeBytes() {
    java.lang.Object ref = expireTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      expireTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 114;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * or
   * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * in which the cluster resides.
   * </pre>
   *
   * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * or
   * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * in which the cluster resides.
   * </pre>
   *
   * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_TPU_FIELD_NUMBER = 115;
  private boolean enableTpu_ = false;
  /**
   *
   *
   * <pre>
   * Enable the ability to use Cloud TPUs in this cluster.
   * </pre>
   *
   * <code>bool enable_tpu = 115;</code>
   *
   * @return The enableTpu.
   */
  @java.lang.Override
  public boolean getEnableTpu() {
    return enableTpu_;
  }

  public static final int TPU_IPV4_CIDR_BLOCK_FIELD_NUMBER = 116;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tpuIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`).
   * </pre>
   *
   * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tpuIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getTpuIpv4CidrBlock() {
    java.lang.Object ref = tpuIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tpuIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`).
   * </pre>
   *
   * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for tpuIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTpuIpv4CidrBlockBytes() {
    java.lang.Object ref = tpuIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tpuIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONDITIONS_FIELD_NUMBER = 118;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.StatusCondition> conditions_;
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.StatusCondition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
   */
  @java.lang.Override
  public com.google.container.v1.StatusCondition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
   */
  @java.lang.Override
  public com.google.container.v1.StatusConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int AUTOPILOT_FIELD_NUMBER = 128;
  private com.google.container.v1.Autopilot autopilot_;
  /**
   *
   *
   * <pre>
   * Autopilot configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Autopilot autopilot = 128;</code>
   *
   * @return Whether the autopilot field is set.
   */
  @java.lang.Override
  public boolean hasAutopilot() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Autopilot configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Autopilot autopilot = 128;</code>
   *
   * @return The autopilot.
   */
  @java.lang.Override
  public com.google.container.v1.Autopilot getAutopilot() {
    return autopilot_ == null ? com.google.container.v1.Autopilot.getDefaultInstance() : autopilot_;
  }
  /**
   *
   *
   * <pre>
   * Autopilot configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Autopilot autopilot = 128;</code>
   */
  @java.lang.Override
  public com.google.container.v1.AutopilotOrBuilder getAutopilotOrBuilder() {
    return autopilot_ == null ? com.google.container.v1.Autopilot.getDefaultInstance() : autopilot_;
  }

  public static final int ID_FIELD_NUMBER = 129;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique id for the cluster.
   * </pre>
   *
   * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique id for the cluster.
   * </pre>
   *
   * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_POOL_DEFAULTS_FIELD_NUMBER = 131;
  private com.google.container.v1.NodePoolDefaults nodePoolDefaults_;
  /**
   *
   *
   * <pre>
   * Default NodePool settings for the entire cluster. These settings are
   * overridden if specified on the specific NodePool object.
   * </pre>
   *
   * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
   *
   * @return Whether the nodePoolDefaults field is set.
   */
  @java.lang.Override
  public boolean hasNodePoolDefaults() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Default NodePool settings for the entire cluster. These settings are
   * overridden if specified on the specific NodePool object.
   * </pre>
   *
   * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
   *
   * @return The nodePoolDefaults.
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolDefaults getNodePoolDefaults() {
    return nodePoolDefaults_ == null
        ? com.google.container.v1.NodePoolDefaults.getDefaultInstance()
        : nodePoolDefaults_;
  }
  /**
   *
   *
   * <pre>
   * Default NodePool settings for the entire cluster. These settings are
   * overridden if specified on the specific NodePool object.
   * </pre>
   *
   * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolDefaultsOrBuilder getNodePoolDefaultsOrBuilder() {
    return nodePoolDefaults_ == null
        ? com.google.container.v1.NodePoolDefaults.getDefaultInstance()
        : nodePoolDefaults_;
  }

  public static final int LOGGING_CONFIG_FIELD_NUMBER = 132;
  private com.google.container.v1.LoggingConfig loggingConfig_;
  /**
   *
   *
   * <pre>
   * Logging configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
   *
   * @return Whether the loggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasLoggingConfig() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Logging configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
   *
   * @return The loggingConfig.
   */
  @java.lang.Override
  public com.google.container.v1.LoggingConfig getLoggingConfig() {
    return loggingConfig_ == null
        ? com.google.container.v1.LoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Logging configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
   */
  @java.lang.Override
  public com.google.container.v1.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
    return loggingConfig_ == null
        ? com.google.container.v1.LoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }

  public static final int MONITORING_CONFIG_FIELD_NUMBER = 133;
  private com.google.container.v1.MonitoringConfig monitoringConfig_;
  /**
   *
   *
   * <pre>
   * Monitoring configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
   *
   * @return Whether the monitoringConfig field is set.
   */
  @java.lang.Override
  public boolean hasMonitoringConfig() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
   *
   * @return The monitoringConfig.
   */
  @java.lang.Override
  public com.google.container.v1.MonitoringConfig getMonitoringConfig() {
    return monitoringConfig_ == null
        ? com.google.container.v1.MonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
   */
  @java.lang.Override
  public com.google.container.v1.MonitoringConfigOrBuilder getMonitoringConfigOrBuilder() {
    return monitoringConfig_ == null
        ? com.google.container.v1.MonitoringConfig.getDefaultInstance()
        : monitoringConfig_;
  }

  public static final int NODE_POOL_AUTO_CONFIG_FIELD_NUMBER = 136;
  private com.google.container.v1.NodePoolAutoConfig nodePoolAutoConfig_;
  /**
   *
   *
   * <pre>
   * Node pool configs that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
   *
   * @return Whether the nodePoolAutoConfig field is set.
   */
  @java.lang.Override
  public boolean hasNodePoolAutoConfig() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Node pool configs that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
   *
   * @return The nodePoolAutoConfig.
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolAutoConfig getNodePoolAutoConfig() {
    return nodePoolAutoConfig_ == null
        ? com.google.container.v1.NodePoolAutoConfig.getDefaultInstance()
        : nodePoolAutoConfig_;
  }
  /**
   *
   *
   * <pre>
   * Node pool configs that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolAutoConfigOrBuilder getNodePoolAutoConfigOrBuilder() {
    return nodePoolAutoConfig_ == null
        ? com.google.container.v1.NodePoolAutoConfig.getDefaultInstance()
        : nodePoolAutoConfig_;
  }

  public static final int ETAG_FIELD_NUMBER = 139;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of cluster
   * fields, and may be sent on update requests to ensure the client has an
   * up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 139;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of cluster
   * fields, and may be sent on update requests to ensure the client has an
   * up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 139;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLEET_FIELD_NUMBER = 140;
  private com.google.container.v1.Fleet fleet_;
  /**
   *
   *
   * <pre>
   * Fleet information for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Fleet fleet = 140;</code>
   *
   * @return Whether the fleet field is set.
   */
  @java.lang.Override
  public boolean hasFleet() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fleet information for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Fleet fleet = 140;</code>
   *
   * @return The fleet.
   */
  @java.lang.Override
  public com.google.container.v1.Fleet getFleet() {
    return fleet_ == null ? com.google.container.v1.Fleet.getDefaultInstance() : fleet_;
  }
  /**
   *
   *
   * <pre>
   * Fleet information for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Fleet fleet = 140;</code>
   */
  @java.lang.Override
  public com.google.container.v1.FleetOrBuilder getFleetOrBuilder() {
    return fleet_ == null ? com.google.container.v1.Fleet.getDefaultInstance() : fleet_;
  }

  public static final int SECURITY_POSTURE_CONFIG_FIELD_NUMBER = 145;
  private com.google.container.v1.SecurityPostureConfig securityPostureConfig_;
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
   *
   * @return Whether the securityPostureConfig field is set.
   */
  @java.lang.Override
  public boolean hasSecurityPostureConfig() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
   *
   * @return The securityPostureConfig.
   */
  @java.lang.Override
  public com.google.container.v1.SecurityPostureConfig getSecurityPostureConfig() {
    return securityPostureConfig_ == null
        ? com.google.container.v1.SecurityPostureConfig.getDefaultInstance()
        : securityPostureConfig_;
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SecurityPostureConfigOrBuilder
      getSecurityPostureConfigOrBuilder() {
    return securityPostureConfig_ == null
        ? com.google.container.v1.SecurityPostureConfig.getDefaultInstance()
        : securityPostureConfig_;
  }

  public static final int CONTROL_PLANE_ENDPOINTS_CONFIG_FIELD_NUMBER = 146;
  private com.google.container.v1.ControlPlaneEndpointsConfig controlPlaneEndpointsConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for all cluster's control plane endpoints.
   * </pre>
   *
   * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
   * </code>
   *
   * @return Whether the controlPlaneEndpointsConfig field is set.
   */
  @java.lang.Override
  public boolean hasControlPlaneEndpointsConfig() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for all cluster's control plane endpoints.
   * </pre>
   *
   * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
   * </code>
   *
   * @return The controlPlaneEndpointsConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfig getControlPlaneEndpointsConfig() {
    return controlPlaneEndpointsConfig_ == null
        ? com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance()
        : controlPlaneEndpointsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for all cluster's control plane endpoints.
   * </pre>
   *
   * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder
      getControlPlaneEndpointsConfigOrBuilder() {
    return controlPlaneEndpointsConfig_ == null
        ? com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance()
        : controlPlaneEndpointsConfig_;
  }

  public static final int ENABLE_K8S_BETA_APIS_FIELD_NUMBER = 143;
  private com.google.container.v1.K8sBetaAPIConfig enableK8SBetaApis_;
  /**
   *
   *
   * <pre>
   * Beta APIs Config
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
   *
   * @return Whether the enableK8sBetaApis field is set.
   */
  @java.lang.Override
  public boolean hasEnableK8SBetaApis() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Beta APIs Config
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
   *
   * @return The enableK8sBetaApis.
   */
  @java.lang.Override
  public com.google.container.v1.K8sBetaAPIConfig getEnableK8SBetaApis() {
    return enableK8SBetaApis_ == null
        ? com.google.container.v1.K8sBetaAPIConfig.getDefaultInstance()
        : enableK8SBetaApis_;
  }
  /**
   *
   *
   * <pre>
   * Beta APIs Config
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
   */
  @java.lang.Override
  public com.google.container.v1.K8sBetaAPIConfigOrBuilder getEnableK8SBetaApisOrBuilder() {
    return enableK8SBetaApis_ == null
        ? com.google.container.v1.K8sBetaAPIConfig.getDefaultInstance()
        : enableK8SBetaApis_;
  }

  public static final int ENTERPRISE_CONFIG_FIELD_NUMBER = 149;
  private com.google.container.v1.EnterpriseConfig enterpriseConfig_;
  /**
   *
   *
   * <pre>
   * GKE Enterprise Configuration.
   * </pre>
   *
   * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
   *
   * @return Whether the enterpriseConfig field is set.
   */
  @java.lang.Override
  public boolean hasEnterpriseConfig() {
    return ((bitField1_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * GKE Enterprise Configuration.
   * </pre>
   *
   * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
   *
   * @return The enterpriseConfig.
   */
  @java.lang.Override
  public com.google.container.v1.EnterpriseConfig getEnterpriseConfig() {
    return enterpriseConfig_ == null
        ? com.google.container.v1.EnterpriseConfig.getDefaultInstance()
        : enterpriseConfig_;
  }
  /**
   *
   *
   * <pre>
   * GKE Enterprise Configuration.
   * </pre>
   *
   * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
   */
  @java.lang.Override
  public com.google.container.v1.EnterpriseConfigOrBuilder getEnterpriseConfigOrBuilder() {
    return enterpriseConfig_ == null
        ? com.google.container.v1.EnterpriseConfig.getDefaultInstance()
        : enterpriseConfig_;
  }

  public static final int SECRET_MANAGER_CONFIG_FIELD_NUMBER = 150;
  private com.google.container.v1.SecretManagerConfig secretManagerConfig_;
  /**
   *
   *
   * <pre>
   * Secret CSI driver configuration.
   * </pre>
   *
   * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
   *
   * @return Whether the secretManagerConfig field is set.
   */
  @java.lang.Override
  public boolean hasSecretManagerConfig() {
    return ((bitField1_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Secret CSI driver configuration.
   * </pre>
   *
   * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
   *
   * @return The secretManagerConfig.
   */
  @java.lang.Override
  public com.google.container.v1.SecretManagerConfig getSecretManagerConfig() {
    return secretManagerConfig_ == null
        ? com.google.container.v1.SecretManagerConfig.getDefaultInstance()
        : secretManagerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Secret CSI driver configuration.
   * </pre>
   *
   * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
   */
  @java.lang.Override
  public com.google.container.v1.SecretManagerConfigOrBuilder getSecretManagerConfigOrBuilder() {
    return secretManagerConfig_ == null
        ? com.google.container.v1.SecretManagerConfig.getDefaultInstance()
        : secretManagerConfig_;
  }

  public static final int COMPLIANCE_POSTURE_CONFIG_FIELD_NUMBER = 151;
  private com.google.container.v1.CompliancePostureConfig compliancePostureConfig_;
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
   *
   * @return Whether the compliancePostureConfig field is set.
   */
  @java.lang.Override
  public boolean hasCompliancePostureConfig() {
    return ((bitField1_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
   *
   * @return The compliancePostureConfig.
   */
  @java.lang.Override
  public com.google.container.v1.CompliancePostureConfig getCompliancePostureConfig() {
    return compliancePostureConfig_ == null
        ? com.google.container.v1.CompliancePostureConfig.getDefaultInstance()
        : compliancePostureConfig_;
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
   */
  @java.lang.Override
  public com.google.container.v1.CompliancePostureConfigOrBuilder
      getCompliancePostureConfigOrBuilder() {
    return compliancePostureConfig_ == null
        ? com.google.container.v1.CompliancePostureConfig.getDefaultInstance()
        : compliancePostureConfig_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 152;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField1_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 153;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzi() {
    return ((bitField1_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int USER_MANAGED_KEYS_CONFIG_FIELD_NUMBER = 154;
  private com.google.container.v1.UserManagedKeysConfig userManagedKeysConfig_;
  /**
   *
   *
   * <pre>
   * The Custom keys configuration for the cluster.
   * </pre>
   *
   * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
   * </code>
   *
   * @return Whether the userManagedKeysConfig field is set.
   */
  @java.lang.Override
  public boolean hasUserManagedKeysConfig() {
    return ((bitField1_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The Custom keys configuration for the cluster.
   * </pre>
   *
   * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
   * </code>
   *
   * @return The userManagedKeysConfig.
   */
  @java.lang.Override
  public com.google.container.v1.UserManagedKeysConfig getUserManagedKeysConfig() {
    return userManagedKeysConfig_ == null
        ? com.google.container.v1.UserManagedKeysConfig.getDefaultInstance()
        : userManagedKeysConfig_;
  }
  /**
   *
   *
   * <pre>
   * The Custom keys configuration for the cluster.
   * </pre>
   *
   * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.UserManagedKeysConfigOrBuilder
      getUserManagedKeysConfigOrBuilder() {
    return userManagedKeysConfig_ == null
        ? com.google.container.v1.UserManagedKeysConfig.getDefaultInstance()
        : userManagedKeysConfig_;
  }

  public static final int RBAC_BINDING_CONFIG_FIELD_NUMBER = 156;
  private com.google.container.v1.RBACBindingConfig rbacBindingConfig_;
  /**
   *
   *
   * <pre>
   * RBACBindingConfig allows user to restrict ClusterRoleBindings an
   * RoleBindings that can be created.
   * </pre>
   *
   * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
   *
   * @return Whether the rbacBindingConfig field is set.
   */
  @java.lang.Override
  public boolean hasRbacBindingConfig() {
    return ((bitField1_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * RBACBindingConfig allows user to restrict ClusterRoleBindings an
   * RoleBindings that can be created.
   * </pre>
   *
   * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
   *
   * @return The rbacBindingConfig.
   */
  @java.lang.Override
  public com.google.container.v1.RBACBindingConfig getRbacBindingConfig() {
    return rbacBindingConfig_ == null
        ? com.google.container.v1.RBACBindingConfig.getDefaultInstance()
        : rbacBindingConfig_;
  }
  /**
   *
   *
   * <pre>
   * RBACBindingConfig allows user to restrict ClusterRoleBindings an
   * RoleBindings that can be created.
   * </pre>
   *
   * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
   */
  @java.lang.Override
  public com.google.container.v1.RBACBindingConfigOrBuilder getRbacBindingConfigOrBuilder() {
    return rbacBindingConfig_ == null
        ? com.google.container.v1.RBACBindingConfig.getDefaultInstance()
        : rbacBindingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (initialNodeCount_ != 0) {
      output.writeInt32(3, initialNodeCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getNodeConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getMasterAuth());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(loggingService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, loggingService_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoringService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, monitoringService_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4Cidr_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, clusterIpv4Cidr_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getAddonsConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, subnetwork_);
    }
    for (int i = 0; i < nodePools_.size(); i++) {
      output.writeMessage(12, nodePools_.get(i));
    }
    for (int i = 0; i < locations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, locations_.getRaw(i));
    }
    if (enableKubernetesAlpha_ != false) {
      output.writeBool(14, enableKubernetesAlpha_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetResourceLabels(), ResourceLabelsDefaultEntryHolder.defaultEntry, 15);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(labelFingerprint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(18, getLegacyAbac());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(19, getNetworkPolicy());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(20, getIpAllocationPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(22, getMasterAuthorizedNetworksConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(23, getMaintenancePolicy());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(24, getBinaryAuthorization());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(26, getAutoscaling());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(27, getNetworkConfig());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(30, getDefaultMaxPodsConstraint());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(33, getResourceUsageExportConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(34, getAuthenticatorGroupsConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(37, getPrivateClusterConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(38, getDatabaseEncryption());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeMessage(39, getVerticalPodAutoscaling());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(40, getShieldedNodes());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(41, getReleaseChannel());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeMessage(43, getWorkloadIdentityConfig());
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeMessage(45, getCostManagementConfig());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeMessage(49, getNotificationConfig());
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeMessage(50, getConfidentialNodes());
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeMessage(54, getIdentityServiceConfig());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      output.writeMessage(67, getMeshCertificates());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 102, endpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(initialClusterVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 103, initialClusterVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentMasterVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 104, currentMasterVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentNodeVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 105, currentNodeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 106, createTime_);
    }
    if (status_ != com.google.container.v1.Cluster.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(107, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 108, statusMessage_);
    }
    if (nodeIpv4CidrSize_ != 0) {
      output.writeInt32(109, nodeIpv4CidrSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4Cidr_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 110, servicesIpv4Cidr_);
    }
    for (int i = 0; i < instanceGroupUrls_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 111, instanceGroupUrls_.getRaw(i));
    }
    if (currentNodeCount_ != 0) {
      output.writeInt32(112, currentNodeCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expireTime_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 113, expireTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 114, location_);
    }
    if (enableTpu_ != false) {
      output.writeBool(115, enableTpu_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tpuIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 116, tpuIpv4CidrBlock_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(118, conditions_.get(i));
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeMessage(128, getAutopilot());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 129, id_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      output.writeMessage(131, getNodePoolDefaults());
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      output.writeMessage(132, getLoggingConfig());
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      output.writeMessage(133, getMonitoringConfig());
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      output.writeMessage(136, getNodePoolAutoConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 139, etag_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      output.writeMessage(140, getFleet());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeMessage(143, getEnableK8SBetaApis());
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      output.writeMessage(145, getSecurityPostureConfig());
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeMessage(146, getControlPlaneEndpointsConfig());
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      output.writeMessage(149, getEnterpriseConfig());
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeMessage(150, getSecretManagerConfig());
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      output.writeMessage(151, getCompliancePostureConfig());
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      output.writeBool(152, satisfiesPzs_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      output.writeBool(153, satisfiesPzi_);
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      output.writeMessage(154, getUserManagedKeysConfig());
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      output.writeMessage(156, getRbacBindingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (initialNodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, initialNodeCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNodeConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMasterAuth());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(loggingService_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, loggingService_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoringService_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, monitoringService_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterIpv4Cidr_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, clusterIpv4Cidr_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getAddonsConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, subnetwork_);
    }
    for (int i = 0; i < nodePools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, nodePools_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < locations_.size(); i++) {
        dataSize += computeStringSizeNoTag(locations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationsList().size();
    }
    if (enableKubernetesAlpha_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, enableKubernetesAlpha_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourceLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLabels__ =
          ResourceLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, resourceLabels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(labelFingerprint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, labelFingerprint_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getLegacyAbac());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getNetworkPolicy());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getIpAllocationPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, getMasterAuthorizedNetworksConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getMaintenancePolicy());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(24, getBinaryAuthorization());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getAutoscaling());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getNetworkConfig());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              30, getDefaultMaxPodsConstraint());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              33, getResourceUsageExportConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              34, getAuthenticatorGroupsConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(37, getPrivateClusterConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getDatabaseEncryption());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(39, getVerticalPodAutoscaling());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(40, getShieldedNodes());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(41, getReleaseChannel());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(43, getWorkloadIdentityConfig());
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(45, getCostManagementConfig());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(49, getNotificationConfig());
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(50, getConfidentialNodes());
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(54, getIdentityServiceConfig());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(67, getMeshCertificates());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(102, endpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(initialClusterVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(103, initialClusterVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentMasterVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(104, currentMasterVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentNodeVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(105, currentNodeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(106, createTime_);
    }
    if (status_ != com.google.container.v1.Cluster.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(107, status_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(108, statusMessage_);
    }
    if (nodeIpv4CidrSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(109, nodeIpv4CidrSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(servicesIpv4Cidr_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(110, servicesIpv4Cidr_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceGroupUrls_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceGroupUrls_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getInstanceGroupUrlsList().size();
    }
    if (currentNodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(112, currentNodeCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(expireTime_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(113, expireTime_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(114, location_);
    }
    if (enableTpu_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(115, enableTpu_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tpuIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(116, tpuIpv4CidrBlock_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(118, conditions_.get(i));
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(128, getAutopilot());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(129, id_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(131, getNodePoolDefaults());
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(132, getLoggingConfig());
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(133, getMonitoringConfig());
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(136, getNodePoolAutoConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(139, etag_);
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(140, getFleet());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(143, getEnableK8SBetaApis());
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(145, getSecurityPostureConfig());
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              146, getControlPlaneEndpointsConfig());
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(149, getEnterpriseConfig());
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(150, getSecretManagerConfig());
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              151, getCompliancePostureConfig());
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(152, satisfiesPzs_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(153, satisfiesPzi_);
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(154, getUserManagedKeysConfig());
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(156, getRbacBindingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.Cluster)) {
      return super.equals(obj);
    }
    com.google.container.v1.Cluster other = (com.google.container.v1.Cluster) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getInitialNodeCount() != other.getInitialNodeCount()) return false;
    if (hasNodeConfig() != other.hasNodeConfig()) return false;
    if (hasNodeConfig()) {
      if (!getNodeConfig().equals(other.getNodeConfig())) return false;
    }
    if (hasMasterAuth() != other.hasMasterAuth()) return false;
    if (hasMasterAuth()) {
      if (!getMasterAuth().equals(other.getMasterAuth())) return false;
    }
    if (!getLoggingService().equals(other.getLoggingService())) return false;
    if (!getMonitoringService().equals(other.getMonitoringService())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getClusterIpv4Cidr().equals(other.getClusterIpv4Cidr())) return false;
    if (hasAddonsConfig() != other.hasAddonsConfig()) return false;
    if (hasAddonsConfig()) {
      if (!getAddonsConfig().equals(other.getAddonsConfig())) return false;
    }
    if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    if (!getNodePoolsList().equals(other.getNodePoolsList())) return false;
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (getEnableKubernetesAlpha() != other.getEnableKubernetesAlpha()) return false;
    if (!internalGetResourceLabels().equals(other.internalGetResourceLabels())) return false;
    if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    if (hasLegacyAbac() != other.hasLegacyAbac()) return false;
    if (hasLegacyAbac()) {
      if (!getLegacyAbac().equals(other.getLegacyAbac())) return false;
    }
    if (hasNetworkPolicy() != other.hasNetworkPolicy()) return false;
    if (hasNetworkPolicy()) {
      if (!getNetworkPolicy().equals(other.getNetworkPolicy())) return false;
    }
    if (hasIpAllocationPolicy() != other.hasIpAllocationPolicy()) return false;
    if (hasIpAllocationPolicy()) {
      if (!getIpAllocationPolicy().equals(other.getIpAllocationPolicy())) return false;
    }
    if (hasMasterAuthorizedNetworksConfig() != other.hasMasterAuthorizedNetworksConfig())
      return false;
    if (hasMasterAuthorizedNetworksConfig()) {
      if (!getMasterAuthorizedNetworksConfig().equals(other.getMasterAuthorizedNetworksConfig()))
        return false;
    }
    if (hasMaintenancePolicy() != other.hasMaintenancePolicy()) return false;
    if (hasMaintenancePolicy()) {
      if (!getMaintenancePolicy().equals(other.getMaintenancePolicy())) return false;
    }
    if (hasBinaryAuthorization() != other.hasBinaryAuthorization()) return false;
    if (hasBinaryAuthorization()) {
      if (!getBinaryAuthorization().equals(other.getBinaryAuthorization())) return false;
    }
    if (hasAutoscaling() != other.hasAutoscaling()) return false;
    if (hasAutoscaling()) {
      if (!getAutoscaling().equals(other.getAutoscaling())) return false;
    }
    if (hasNetworkConfig() != other.hasNetworkConfig()) return false;
    if (hasNetworkConfig()) {
      if (!getNetworkConfig().equals(other.getNetworkConfig())) return false;
    }
    if (hasDefaultMaxPodsConstraint() != other.hasDefaultMaxPodsConstraint()) return false;
    if (hasDefaultMaxPodsConstraint()) {
      if (!getDefaultMaxPodsConstraint().equals(other.getDefaultMaxPodsConstraint())) return false;
    }
    if (hasResourceUsageExportConfig() != other.hasResourceUsageExportConfig()) return false;
    if (hasResourceUsageExportConfig()) {
      if (!getResourceUsageExportConfig().equals(other.getResourceUsageExportConfig()))
        return false;
    }
    if (hasAuthenticatorGroupsConfig() != other.hasAuthenticatorGroupsConfig()) return false;
    if (hasAuthenticatorGroupsConfig()) {
      if (!getAuthenticatorGroupsConfig().equals(other.getAuthenticatorGroupsConfig()))
        return false;
    }
    if (hasPrivateClusterConfig() != other.hasPrivateClusterConfig()) return false;
    if (hasPrivateClusterConfig()) {
      if (!getPrivateClusterConfig().equals(other.getPrivateClusterConfig())) return false;
    }
    if (hasDatabaseEncryption() != other.hasDatabaseEncryption()) return false;
    if (hasDatabaseEncryption()) {
      if (!getDatabaseEncryption().equals(other.getDatabaseEncryption())) return false;
    }
    if (hasVerticalPodAutoscaling() != other.hasVerticalPodAutoscaling()) return false;
    if (hasVerticalPodAutoscaling()) {
      if (!getVerticalPodAutoscaling().equals(other.getVerticalPodAutoscaling())) return false;
    }
    if (hasShieldedNodes() != other.hasShieldedNodes()) return false;
    if (hasShieldedNodes()) {
      if (!getShieldedNodes().equals(other.getShieldedNodes())) return false;
    }
    if (hasReleaseChannel() != other.hasReleaseChannel()) return false;
    if (hasReleaseChannel()) {
      if (!getReleaseChannel().equals(other.getReleaseChannel())) return false;
    }
    if (hasWorkloadIdentityConfig() != other.hasWorkloadIdentityConfig()) return false;
    if (hasWorkloadIdentityConfig()) {
      if (!getWorkloadIdentityConfig().equals(other.getWorkloadIdentityConfig())) return false;
    }
    if (hasMeshCertificates() != other.hasMeshCertificates()) return false;
    if (hasMeshCertificates()) {
      if (!getMeshCertificates().equals(other.getMeshCertificates())) return false;
    }
    if (hasCostManagementConfig() != other.hasCostManagementConfig()) return false;
    if (hasCostManagementConfig()) {
      if (!getCostManagementConfig().equals(other.getCostManagementConfig())) return false;
    }
    if (hasNotificationConfig() != other.hasNotificationConfig()) return false;
    if (hasNotificationConfig()) {
      if (!getNotificationConfig().equals(other.getNotificationConfig())) return false;
    }
    if (hasConfidentialNodes() != other.hasConfidentialNodes()) return false;
    if (hasConfidentialNodes()) {
      if (!getConfidentialNodes().equals(other.getConfidentialNodes())) return false;
    }
    if (hasIdentityServiceConfig() != other.hasIdentityServiceConfig()) return false;
    if (hasIdentityServiceConfig()) {
      if (!getIdentityServiceConfig().equals(other.getIdentityServiceConfig())) return false;
    }
    if (!getSelfLink().equals(other.getSelfLink())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (!getInitialClusterVersion().equals(other.getInitialClusterVersion())) return false;
    if (!getCurrentMasterVersion().equals(other.getCurrentMasterVersion())) return false;
    if (!getCurrentNodeVersion().equals(other.getCurrentNodeVersion())) return false;
    if (!getCreateTime().equals(other.getCreateTime())) return false;
    if (status_ != other.status_) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (getNodeIpv4CidrSize() != other.getNodeIpv4CidrSize()) return false;
    if (!getServicesIpv4Cidr().equals(other.getServicesIpv4Cidr())) return false;
    if (!getInstanceGroupUrlsList().equals(other.getInstanceGroupUrlsList())) return false;
    if (getCurrentNodeCount() != other.getCurrentNodeCount()) return false;
    if (!getExpireTime().equals(other.getExpireTime())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (getEnableTpu() != other.getEnableTpu()) return false;
    if (!getTpuIpv4CidrBlock().equals(other.getTpuIpv4CidrBlock())) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (hasAutopilot() != other.hasAutopilot()) return false;
    if (hasAutopilot()) {
      if (!getAutopilot().equals(other.getAutopilot())) return false;
    }
    if (!getId().equals(other.getId())) return false;
    if (hasNodePoolDefaults() != other.hasNodePoolDefaults()) return false;
    if (hasNodePoolDefaults()) {
      if (!getNodePoolDefaults().equals(other.getNodePoolDefaults())) return false;
    }
    if (hasLoggingConfig() != other.hasLoggingConfig()) return false;
    if (hasLoggingConfig()) {
      if (!getLoggingConfig().equals(other.getLoggingConfig())) return false;
    }
    if (hasMonitoringConfig() != other.hasMonitoringConfig()) return false;
    if (hasMonitoringConfig()) {
      if (!getMonitoringConfig().equals(other.getMonitoringConfig())) return false;
    }
    if (hasNodePoolAutoConfig() != other.hasNodePoolAutoConfig()) return false;
    if (hasNodePoolAutoConfig()) {
      if (!getNodePoolAutoConfig().equals(other.getNodePoolAutoConfig())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasFleet() != other.hasFleet()) return false;
    if (hasFleet()) {
      if (!getFleet().equals(other.getFleet())) return false;
    }
    if (hasSecurityPostureConfig() != other.hasSecurityPostureConfig()) return false;
    if (hasSecurityPostureConfig()) {
      if (!getSecurityPostureConfig().equals(other.getSecurityPostureConfig())) return false;
    }
    if (hasControlPlaneEndpointsConfig() != other.hasControlPlaneEndpointsConfig()) return false;
    if (hasControlPlaneEndpointsConfig()) {
      if (!getControlPlaneEndpointsConfig().equals(other.getControlPlaneEndpointsConfig()))
        return false;
    }
    if (hasEnableK8SBetaApis() != other.hasEnableK8SBetaApis()) return false;
    if (hasEnableK8SBetaApis()) {
      if (!getEnableK8SBetaApis().equals(other.getEnableK8SBetaApis())) return false;
    }
    if (hasEnterpriseConfig() != other.hasEnterpriseConfig()) return false;
    if (hasEnterpriseConfig()) {
      if (!getEnterpriseConfig().equals(other.getEnterpriseConfig())) return false;
    }
    if (hasSecretManagerConfig() != other.hasSecretManagerConfig()) return false;
    if (hasSecretManagerConfig()) {
      if (!getSecretManagerConfig().equals(other.getSecretManagerConfig())) return false;
    }
    if (hasCompliancePostureConfig() != other.hasCompliancePostureConfig()) return false;
    if (hasCompliancePostureConfig()) {
      if (!getCompliancePostureConfig().equals(other.getCompliancePostureConfig())) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasSatisfiesPzi() != other.hasSatisfiesPzi()) return false;
    if (hasSatisfiesPzi()) {
      if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    }
    if (hasUserManagedKeysConfig() != other.hasUserManagedKeysConfig()) return false;
    if (hasUserManagedKeysConfig()) {
      if (!getUserManagedKeysConfig().equals(other.getUserManagedKeysConfig())) return false;
    }
    if (hasRbacBindingConfig() != other.hasRbacBindingConfig()) return false;
    if (hasRbacBindingConfig()) {
      if (!getRbacBindingConfig().equals(other.getRbacBindingConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + INITIAL_NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getInitialNodeCount();
    if (hasNodeConfig()) {
      hash = (37 * hash) + NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodeConfig().hashCode();
    }
    if (hasMasterAuth()) {
      hash = (37 * hash) + MASTER_AUTH_FIELD_NUMBER;
      hash = (53 * hash) + getMasterAuth().hashCode();
    }
    hash = (37 * hash) + LOGGING_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getLoggingService().hashCode();
    hash = (37 * hash) + MONITORING_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getMonitoringService().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + CLUSTER_IPV4_CIDR_FIELD_NUMBER;
    hash = (53 * hash) + getClusterIpv4Cidr().hashCode();
    if (hasAddonsConfig()) {
      hash = (37 * hash) + ADDONS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAddonsConfig().hashCode();
    }
    hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetwork().hashCode();
    if (getNodePoolsCount() > 0) {
      hash = (37 * hash) + NODE_POOLS_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolsList().hashCode();
    }
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    hash = (37 * hash) + ENABLE_KUBERNETES_ALPHA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableKubernetesAlpha());
    if (!internalGetResourceLabels().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceLabels().hashCode();
    }
    hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
    hash = (53 * hash) + getLabelFingerprint().hashCode();
    if (hasLegacyAbac()) {
      hash = (37 * hash) + LEGACY_ABAC_FIELD_NUMBER;
      hash = (53 * hash) + getLegacyAbac().hashCode();
    }
    if (hasNetworkPolicy()) {
      hash = (37 * hash) + NETWORK_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPolicy().hashCode();
    }
    if (hasIpAllocationPolicy()) {
      hash = (37 * hash) + IP_ALLOCATION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getIpAllocationPolicy().hashCode();
    }
    if (hasMasterAuthorizedNetworksConfig()) {
      hash = (37 * hash) + MASTER_AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMasterAuthorizedNetworksConfig().hashCode();
    }
    if (hasMaintenancePolicy()) {
      hash = (37 * hash) + MAINTENANCE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenancePolicy().hashCode();
    }
    if (hasBinaryAuthorization()) {
      hash = (37 * hash) + BINARY_AUTHORIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getBinaryAuthorization().hashCode();
    }
    if (hasAutoscaling()) {
      hash = (37 * hash) + AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaling().hashCode();
    }
    if (hasNetworkConfig()) {
      hash = (37 * hash) + NETWORK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkConfig().hashCode();
    }
    if (hasDefaultMaxPodsConstraint()) {
      hash = (37 * hash) + DEFAULT_MAX_PODS_CONSTRAINT_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultMaxPodsConstraint().hashCode();
    }
    if (hasResourceUsageExportConfig()) {
      hash = (37 * hash) + RESOURCE_USAGE_EXPORT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getResourceUsageExportConfig().hashCode();
    }
    if (hasAuthenticatorGroupsConfig()) {
      hash = (37 * hash) + AUTHENTICATOR_GROUPS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAuthenticatorGroupsConfig().hashCode();
    }
    if (hasPrivateClusterConfig()) {
      hash = (37 * hash) + PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateClusterConfig().hashCode();
    }
    if (hasDatabaseEncryption()) {
      hash = (37 * hash) + DATABASE_ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDatabaseEncryption().hashCode();
    }
    if (hasVerticalPodAutoscaling()) {
      hash = (37 * hash) + VERTICAL_POD_AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getVerticalPodAutoscaling().hashCode();
    }
    if (hasShieldedNodes()) {
      hash = (37 * hash) + SHIELDED_NODES_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedNodes().hashCode();
    }
    if (hasReleaseChannel()) {
      hash = (37 * hash) + RELEASE_CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getReleaseChannel().hashCode();
    }
    if (hasWorkloadIdentityConfig()) {
      hash = (37 * hash) + WORKLOAD_IDENTITY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkloadIdentityConfig().hashCode();
    }
    if (hasMeshCertificates()) {
      hash = (37 * hash) + MESH_CERTIFICATES_FIELD_NUMBER;
      hash = (53 * hash) + getMeshCertificates().hashCode();
    }
    if (hasCostManagementConfig()) {
      hash = (37 * hash) + COST_MANAGEMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCostManagementConfig().hashCode();
    }
    if (hasNotificationConfig()) {
      hash = (37 * hash) + NOTIFICATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationConfig().hashCode();
    }
    if (hasConfidentialNodes()) {
      hash = (37 * hash) + CONFIDENTIAL_NODES_FIELD_NUMBER;
      hash = (53 * hash) + getConfidentialNodes().hashCode();
    }
    if (hasIdentityServiceConfig()) {
      hash = (37 * hash) + IDENTITY_SERVICE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIdentityServiceConfig().hashCode();
    }
    hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getSelfLink().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    hash = (37 * hash) + INITIAL_CLUSTER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getInitialClusterVersion().hashCode();
    hash = (37 * hash) + CURRENT_MASTER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentMasterVersion().hashCode();
    hash = (37 * hash) + CURRENT_NODE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentNodeVersion().hashCode();
    hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getCreateTime().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    hash = (37 * hash) + NODE_IPV4_CIDR_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getNodeIpv4CidrSize();
    hash = (37 * hash) + SERVICES_IPV4_CIDR_FIELD_NUMBER;
    hash = (53 * hash) + getServicesIpv4Cidr().hashCode();
    if (getInstanceGroupUrlsCount() > 0) {
      hash = (37 * hash) + INSTANCE_GROUP_URLS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceGroupUrlsList().hashCode();
    }
    hash = (37 * hash) + CURRENT_NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentNodeCount();
    hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
    hash = (53 * hash) + getExpireTime().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + ENABLE_TPU_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableTpu());
    hash = (37 * hash) + TPU_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getTpuIpv4CidrBlock().hashCode();
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    if (hasAutopilot()) {
      hash = (37 * hash) + AUTOPILOT_FIELD_NUMBER;
      hash = (53 * hash) + getAutopilot().hashCode();
    }
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (hasNodePoolDefaults()) {
      hash = (37 * hash) + NODE_POOL_DEFAULTS_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolDefaults().hashCode();
    }
    if (hasLoggingConfig()) {
      hash = (37 * hash) + LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingConfig().hashCode();
    }
    if (hasMonitoringConfig()) {
      hash = (37 * hash) + MONITORING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringConfig().hashCode();
    }
    if (hasNodePoolAutoConfig()) {
      hash = (37 * hash) + NODE_POOL_AUTO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolAutoConfig().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasFleet()) {
      hash = (37 * hash) + FLEET_FIELD_NUMBER;
      hash = (53 * hash) + getFleet().hashCode();
    }
    if (hasSecurityPostureConfig()) {
      hash = (37 * hash) + SECURITY_POSTURE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityPostureConfig().hashCode();
    }
    if (hasControlPlaneEndpointsConfig()) {
      hash = (37 * hash) + CONTROL_PLANE_ENDPOINTS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getControlPlaneEndpointsConfig().hashCode();
    }
    if (hasEnableK8SBetaApis()) {
      hash = (37 * hash) + ENABLE_K8S_BETA_APIS_FIELD_NUMBER;
      hash = (53 * hash) + getEnableK8SBetaApis().hashCode();
    }
    if (hasEnterpriseConfig()) {
      hash = (37 * hash) + ENTERPRISE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEnterpriseConfig().hashCode();
    }
    if (hasSecretManagerConfig()) {
      hash = (37 * hash) + SECRET_MANAGER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSecretManagerConfig().hashCode();
    }
    if (hasCompliancePostureConfig()) {
      hash = (37 * hash) + COMPLIANCE_POSTURE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCompliancePostureConfig().hashCode();
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasSatisfiesPzi()) {
      hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    }
    if (hasUserManagedKeysConfig()) {
      hash = (37 * hash) + USER_MANAGED_KEYS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getUserManagedKeysConfig().hashCode();
    }
    if (hasRbacBindingConfig()) {
      hash = (37 * hash) + RBAC_BINDING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRbacBindingConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.Cluster parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.Cluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.Cluster parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.Cluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.Cluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.Cluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.Cluster parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.Cluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.Cluster parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.Cluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.Cluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Google Kubernetes Engine cluster.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.Cluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.Cluster)
      com.google.container.v1.ClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_Cluster_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 15:
          return internalGetMutableResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_Cluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.Cluster.class, com.google.container.v1.Cluster.Builder.class);
    }

    // Construct using com.google.container.v1.Cluster.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNodeConfigFieldBuilder();
        getMasterAuthFieldBuilder();
        getAddonsConfigFieldBuilder();
        getNodePoolsFieldBuilder();
        getLegacyAbacFieldBuilder();
        getNetworkPolicyFieldBuilder();
        getIpAllocationPolicyFieldBuilder();
        getMasterAuthorizedNetworksConfigFieldBuilder();
        getMaintenancePolicyFieldBuilder();
        getBinaryAuthorizationFieldBuilder();
        getAutoscalingFieldBuilder();
        getNetworkConfigFieldBuilder();
        getDefaultMaxPodsConstraintFieldBuilder();
        getResourceUsageExportConfigFieldBuilder();
        getAuthenticatorGroupsConfigFieldBuilder();
        getPrivateClusterConfigFieldBuilder();
        getDatabaseEncryptionFieldBuilder();
        getVerticalPodAutoscalingFieldBuilder();
        getShieldedNodesFieldBuilder();
        getReleaseChannelFieldBuilder();
        getWorkloadIdentityConfigFieldBuilder();
        getMeshCertificatesFieldBuilder();
        getCostManagementConfigFieldBuilder();
        getNotificationConfigFieldBuilder();
        getConfidentialNodesFieldBuilder();
        getIdentityServiceConfigFieldBuilder();
        getConditionsFieldBuilder();
        getAutopilotFieldBuilder();
        getNodePoolDefaultsFieldBuilder();
        getLoggingConfigFieldBuilder();
        getMonitoringConfigFieldBuilder();
        getNodePoolAutoConfigFieldBuilder();
        getFleetFieldBuilder();
        getSecurityPostureConfigFieldBuilder();
        getControlPlaneEndpointsConfigFieldBuilder();
        getEnableK8SBetaApisFieldBuilder();
        getEnterpriseConfigFieldBuilder();
        getSecretManagerConfigFieldBuilder();
        getCompliancePostureConfigFieldBuilder();
        getUserManagedKeysConfigFieldBuilder();
        getRbacBindingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      bitField2_ = 0;
      name_ = "";
      description_ = "";
      initialNodeCount_ = 0;
      nodeConfig_ = null;
      if (nodeConfigBuilder_ != null) {
        nodeConfigBuilder_.dispose();
        nodeConfigBuilder_ = null;
      }
      masterAuth_ = null;
      if (masterAuthBuilder_ != null) {
        masterAuthBuilder_.dispose();
        masterAuthBuilder_ = null;
      }
      loggingService_ = "";
      monitoringService_ = "";
      network_ = "";
      clusterIpv4Cidr_ = "";
      addonsConfig_ = null;
      if (addonsConfigBuilder_ != null) {
        addonsConfigBuilder_.dispose();
        addonsConfigBuilder_ = null;
      }
      subnetwork_ = "";
      if (nodePoolsBuilder_ == null) {
        nodePools_ = java.util.Collections.emptyList();
      } else {
        nodePools_ = null;
        nodePoolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      enableKubernetesAlpha_ = false;
      internalGetMutableResourceLabels().clear();
      labelFingerprint_ = "";
      legacyAbac_ = null;
      if (legacyAbacBuilder_ != null) {
        legacyAbacBuilder_.dispose();
        legacyAbacBuilder_ = null;
      }
      networkPolicy_ = null;
      if (networkPolicyBuilder_ != null) {
        networkPolicyBuilder_.dispose();
        networkPolicyBuilder_ = null;
      }
      ipAllocationPolicy_ = null;
      if (ipAllocationPolicyBuilder_ != null) {
        ipAllocationPolicyBuilder_.dispose();
        ipAllocationPolicyBuilder_ = null;
      }
      masterAuthorizedNetworksConfig_ = null;
      if (masterAuthorizedNetworksConfigBuilder_ != null) {
        masterAuthorizedNetworksConfigBuilder_.dispose();
        masterAuthorizedNetworksConfigBuilder_ = null;
      }
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      binaryAuthorization_ = null;
      if (binaryAuthorizationBuilder_ != null) {
        binaryAuthorizationBuilder_.dispose();
        binaryAuthorizationBuilder_ = null;
      }
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      defaultMaxPodsConstraint_ = null;
      if (defaultMaxPodsConstraintBuilder_ != null) {
        defaultMaxPodsConstraintBuilder_.dispose();
        defaultMaxPodsConstraintBuilder_ = null;
      }
      resourceUsageExportConfig_ = null;
      if (resourceUsageExportConfigBuilder_ != null) {
        resourceUsageExportConfigBuilder_.dispose();
        resourceUsageExportConfigBuilder_ = null;
      }
      authenticatorGroupsConfig_ = null;
      if (authenticatorGroupsConfigBuilder_ != null) {
        authenticatorGroupsConfigBuilder_.dispose();
        authenticatorGroupsConfigBuilder_ = null;
      }
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      databaseEncryption_ = null;
      if (databaseEncryptionBuilder_ != null) {
        databaseEncryptionBuilder_.dispose();
        databaseEncryptionBuilder_ = null;
      }
      verticalPodAutoscaling_ = null;
      if (verticalPodAutoscalingBuilder_ != null) {
        verticalPodAutoscalingBuilder_.dispose();
        verticalPodAutoscalingBuilder_ = null;
      }
      shieldedNodes_ = null;
      if (shieldedNodesBuilder_ != null) {
        shieldedNodesBuilder_.dispose();
        shieldedNodesBuilder_ = null;
      }
      releaseChannel_ = null;
      if (releaseChannelBuilder_ != null) {
        releaseChannelBuilder_.dispose();
        releaseChannelBuilder_ = null;
      }
      workloadIdentityConfig_ = null;
      if (workloadIdentityConfigBuilder_ != null) {
        workloadIdentityConfigBuilder_.dispose();
        workloadIdentityConfigBuilder_ = null;
      }
      meshCertificates_ = null;
      if (meshCertificatesBuilder_ != null) {
        meshCertificatesBuilder_.dispose();
        meshCertificatesBuilder_ = null;
      }
      costManagementConfig_ = null;
      if (costManagementConfigBuilder_ != null) {
        costManagementConfigBuilder_.dispose();
        costManagementConfigBuilder_ = null;
      }
      notificationConfig_ = null;
      if (notificationConfigBuilder_ != null) {
        notificationConfigBuilder_.dispose();
        notificationConfigBuilder_ = null;
      }
      confidentialNodes_ = null;
      if (confidentialNodesBuilder_ != null) {
        confidentialNodesBuilder_.dispose();
        confidentialNodesBuilder_ = null;
      }
      identityServiceConfig_ = null;
      if (identityServiceConfigBuilder_ != null) {
        identityServiceConfigBuilder_.dispose();
        identityServiceConfigBuilder_ = null;
      }
      selfLink_ = "";
      zone_ = "";
      endpoint_ = "";
      initialClusterVersion_ = "";
      currentMasterVersion_ = "";
      currentNodeVersion_ = "";
      createTime_ = "";
      status_ = 0;
      statusMessage_ = "";
      nodeIpv4CidrSize_ = 0;
      servicesIpv4Cidr_ = "";
      instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      currentNodeCount_ = 0;
      expireTime_ = "";
      location_ = "";
      enableTpu_ = false;
      tpuIpv4CidrBlock_ = "";
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField1_ = (bitField1_ & ~0x00800000);
      autopilot_ = null;
      if (autopilotBuilder_ != null) {
        autopilotBuilder_.dispose();
        autopilotBuilder_ = null;
      }
      id_ = "";
      nodePoolDefaults_ = null;
      if (nodePoolDefaultsBuilder_ != null) {
        nodePoolDefaultsBuilder_.dispose();
        nodePoolDefaultsBuilder_ = null;
      }
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      monitoringConfig_ = null;
      if (monitoringConfigBuilder_ != null) {
        monitoringConfigBuilder_.dispose();
        monitoringConfigBuilder_ = null;
      }
      nodePoolAutoConfig_ = null;
      if (nodePoolAutoConfigBuilder_ != null) {
        nodePoolAutoConfigBuilder_.dispose();
        nodePoolAutoConfigBuilder_ = null;
      }
      etag_ = "";
      fleet_ = null;
      if (fleetBuilder_ != null) {
        fleetBuilder_.dispose();
        fleetBuilder_ = null;
      }
      securityPostureConfig_ = null;
      if (securityPostureConfigBuilder_ != null) {
        securityPostureConfigBuilder_.dispose();
        securityPostureConfigBuilder_ = null;
      }
      controlPlaneEndpointsConfig_ = null;
      if (controlPlaneEndpointsConfigBuilder_ != null) {
        controlPlaneEndpointsConfigBuilder_.dispose();
        controlPlaneEndpointsConfigBuilder_ = null;
      }
      enableK8SBetaApis_ = null;
      if (enableK8SBetaApisBuilder_ != null) {
        enableK8SBetaApisBuilder_.dispose();
        enableK8SBetaApisBuilder_ = null;
      }
      enterpriseConfig_ = null;
      if (enterpriseConfigBuilder_ != null) {
        enterpriseConfigBuilder_.dispose();
        enterpriseConfigBuilder_ = null;
      }
      secretManagerConfig_ = null;
      if (secretManagerConfigBuilder_ != null) {
        secretManagerConfigBuilder_.dispose();
        secretManagerConfigBuilder_ = null;
      }
      compliancePostureConfig_ = null;
      if (compliancePostureConfigBuilder_ != null) {
        compliancePostureConfigBuilder_.dispose();
        compliancePostureConfigBuilder_ = null;
      }
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      userManagedKeysConfig_ = null;
      if (userManagedKeysConfigBuilder_ != null) {
        userManagedKeysConfigBuilder_.dispose();
        userManagedKeysConfigBuilder_ = null;
      }
      rbacBindingConfig_ = null;
      if (rbacBindingConfigBuilder_ != null) {
        rbacBindingConfigBuilder_.dispose();
        rbacBindingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_Cluster_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.Cluster getDefaultInstanceForType() {
      return com.google.container.v1.Cluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.Cluster build() {
      com.google.container.v1.Cluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.Cluster buildPartial() {
      com.google.container.v1.Cluster result = new com.google.container.v1.Cluster(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      if (bitField2_ != 0) {
        buildPartial2(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.Cluster result) {
      if (nodePoolsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          nodePools_ = java.util.Collections.unmodifiableList(nodePools_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.nodePools_ = nodePools_;
      } else {
        result.nodePools_ = nodePoolsBuilder_.build();
      }
      if (conditionsBuilder_ == null) {
        if (((bitField1_ & 0x00800000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField1_ = (bitField1_ & ~0x00800000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.Cluster result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.initialNodeCount_ = initialNodeCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nodeConfig_ = nodeConfigBuilder_ == null ? nodeConfig_ : nodeConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.masterAuth_ = masterAuthBuilder_ == null ? masterAuth_ : masterAuthBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.loggingService_ = loggingService_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.monitoringService_ = monitoringService_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.clusterIpv4Cidr_ = clusterIpv4Cidr_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.addonsConfig_ =
            addonsConfigBuilder_ == null ? addonsConfig_ : addonsConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.subnetwork_ = subnetwork_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        locations_.makeImmutable();
        result.locations_ = locations_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.enableKubernetesAlpha_ = enableKubernetesAlpha_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.resourceLabels_ = internalGetResourceLabels();
        result.resourceLabels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.legacyAbac_ = legacyAbacBuilder_ == null ? legacyAbac_ : legacyAbacBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.networkPolicy_ =
            networkPolicyBuilder_ == null ? networkPolicy_ : networkPolicyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.ipAllocationPolicy_ =
            ipAllocationPolicyBuilder_ == null
                ? ipAllocationPolicy_
                : ipAllocationPolicyBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.masterAuthorizedNetworksConfig_ =
            masterAuthorizedNetworksConfigBuilder_ == null
                ? masterAuthorizedNetworksConfig_
                : masterAuthorizedNetworksConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.maintenancePolicy_ =
            maintenancePolicyBuilder_ == null
                ? maintenancePolicy_
                : maintenancePolicyBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.binaryAuthorization_ =
            binaryAuthorizationBuilder_ == null
                ? binaryAuthorization_
                : binaryAuthorizationBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.autoscaling_ =
            autoscalingBuilder_ == null ? autoscaling_ : autoscalingBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.networkConfig_ =
            networkConfigBuilder_ == null ? networkConfig_ : networkConfigBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.defaultMaxPodsConstraint_ =
            defaultMaxPodsConstraintBuilder_ == null
                ? defaultMaxPodsConstraint_
                : defaultMaxPodsConstraintBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.resourceUsageExportConfig_ =
            resourceUsageExportConfigBuilder_ == null
                ? resourceUsageExportConfig_
                : resourceUsageExportConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.authenticatorGroupsConfig_ =
            authenticatorGroupsConfigBuilder_ == null
                ? authenticatorGroupsConfig_
                : authenticatorGroupsConfigBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.privateClusterConfig_ =
            privateClusterConfigBuilder_ == null
                ? privateClusterConfig_
                : privateClusterConfigBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.databaseEncryption_ =
            databaseEncryptionBuilder_ == null
                ? databaseEncryption_
                : databaseEncryptionBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.verticalPodAutoscaling_ =
            verticalPodAutoscalingBuilder_ == null
                ? verticalPodAutoscaling_
                : verticalPodAutoscalingBuilder_.build();
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.shieldedNodes_ =
            shieldedNodesBuilder_ == null ? shieldedNodes_ : shieldedNodesBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.releaseChannel_ =
            releaseChannelBuilder_ == null ? releaseChannel_ : releaseChannelBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.container.v1.Cluster result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.workloadIdentityConfig_ =
            workloadIdentityConfigBuilder_ == null
                ? workloadIdentityConfig_
                : workloadIdentityConfigBuilder_.build();
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.meshCertificates_ =
            meshCertificatesBuilder_ == null ? meshCertificates_ : meshCertificatesBuilder_.build();
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.costManagementConfig_ =
            costManagementConfigBuilder_ == null
                ? costManagementConfig_
                : costManagementConfigBuilder_.build();
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.notificationConfig_ =
            notificationConfigBuilder_ == null
                ? notificationConfig_
                : notificationConfigBuilder_.build();
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.confidentialNodes_ =
            confidentialNodesBuilder_ == null
                ? confidentialNodes_
                : confidentialNodesBuilder_.build();
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.identityServiceConfig_ =
            identityServiceConfigBuilder_ == null
                ? identityServiceConfig_
                : identityServiceConfigBuilder_.build();
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.selfLink_ = selfLink_;
      }
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField1_ & 0x00000100) != 0)) {
        result.endpoint_ = endpoint_;
      }
      if (((from_bitField1_ & 0x00000200) != 0)) {
        result.initialClusterVersion_ = initialClusterVersion_;
      }
      if (((from_bitField1_ & 0x00000400) != 0)) {
        result.currentMasterVersion_ = currentMasterVersion_;
      }
      if (((from_bitField1_ & 0x00000800) != 0)) {
        result.currentNodeVersion_ = currentNodeVersion_;
      }
      if (((from_bitField1_ & 0x00001000) != 0)) {
        result.createTime_ = createTime_;
      }
      if (((from_bitField1_ & 0x00002000) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField1_ & 0x00004000) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
      if (((from_bitField1_ & 0x00008000) != 0)) {
        result.nodeIpv4CidrSize_ = nodeIpv4CidrSize_;
      }
      if (((from_bitField1_ & 0x00010000) != 0)) {
        result.servicesIpv4Cidr_ = servicesIpv4Cidr_;
      }
      if (((from_bitField1_ & 0x00020000) != 0)) {
        instanceGroupUrls_.makeImmutable();
        result.instanceGroupUrls_ = instanceGroupUrls_;
      }
      if (((from_bitField1_ & 0x00040000) != 0)) {
        result.currentNodeCount_ = currentNodeCount_;
      }
      if (((from_bitField1_ & 0x00080000) != 0)) {
        result.expireTime_ = expireTime_;
      }
      if (((from_bitField1_ & 0x00100000) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField1_ & 0x00200000) != 0)) {
        result.enableTpu_ = enableTpu_;
      }
      if (((from_bitField1_ & 0x00400000) != 0)) {
        result.tpuIpv4CidrBlock_ = tpuIpv4CidrBlock_;
      }
      if (((from_bitField1_ & 0x01000000) != 0)) {
        result.autopilot_ = autopilotBuilder_ == null ? autopilot_ : autopilotBuilder_.build();
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField1_ & 0x02000000) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField1_ & 0x04000000) != 0)) {
        result.nodePoolDefaults_ =
            nodePoolDefaultsBuilder_ == null ? nodePoolDefaults_ : nodePoolDefaultsBuilder_.build();
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField1_ & 0x08000000) != 0)) {
        result.loggingConfig_ =
            loggingConfigBuilder_ == null ? loggingConfig_ : loggingConfigBuilder_.build();
        to_bitField0_ |= 0x08000000;
      }
      if (((from_bitField1_ & 0x10000000) != 0)) {
        result.monitoringConfig_ =
            monitoringConfigBuilder_ == null ? monitoringConfig_ : monitoringConfigBuilder_.build();
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x20000000) != 0)) {
        result.nodePoolAutoConfig_ =
            nodePoolAutoConfigBuilder_ == null
                ? nodePoolAutoConfig_
                : nodePoolAutoConfigBuilder_.build();
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x40000000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField1_ & 0x80000000) != 0)) {
        result.fleet_ = fleetBuilder_ == null ? fleet_ : fleetBuilder_.build();
        to_bitField0_ |= 0x40000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial2(com.google.container.v1.Cluster result) {
      int from_bitField2_ = bitField2_;
      int to_bitField0_ = 0;
      if (((from_bitField2_ & 0x00000001) != 0)) {
        result.securityPostureConfig_ =
            securityPostureConfigBuilder_ == null
                ? securityPostureConfig_
                : securityPostureConfigBuilder_.build();
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField2_ & 0x00000002) != 0)) {
        result.controlPlaneEndpointsConfig_ =
            controlPlaneEndpointsConfigBuilder_ == null
                ? controlPlaneEndpointsConfig_
                : controlPlaneEndpointsConfigBuilder_.build();
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField2_ & 0x00000004) != 0)) {
        result.enableK8SBetaApis_ =
            enableK8SBetaApisBuilder_ == null
                ? enableK8SBetaApis_
                : enableK8SBetaApisBuilder_.build();
        to_bitField1_ |= 0x00000002;
      }
      if (((from_bitField2_ & 0x00000008) != 0)) {
        result.enterpriseConfig_ =
            enterpriseConfigBuilder_ == null ? enterpriseConfig_ : enterpriseConfigBuilder_.build();
        to_bitField1_ |= 0x00000004;
      }
      if (((from_bitField2_ & 0x00000010) != 0)) {
        result.secretManagerConfig_ =
            secretManagerConfigBuilder_ == null
                ? secretManagerConfig_
                : secretManagerConfigBuilder_.build();
        to_bitField1_ |= 0x00000008;
      }
      if (((from_bitField2_ & 0x00000020) != 0)) {
        result.compliancePostureConfig_ =
            compliancePostureConfigBuilder_ == null
                ? compliancePostureConfig_
                : compliancePostureConfigBuilder_.build();
        to_bitField1_ |= 0x00000010;
      }
      if (((from_bitField2_ & 0x00000040) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField1_ |= 0x00000020;
      }
      if (((from_bitField2_ & 0x00000080) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
        to_bitField1_ |= 0x00000040;
      }
      if (((from_bitField2_ & 0x00000100) != 0)) {
        result.userManagedKeysConfig_ =
            userManagedKeysConfigBuilder_ == null
                ? userManagedKeysConfig_
                : userManagedKeysConfigBuilder_.build();
        to_bitField1_ |= 0x00000080;
      }
      if (((from_bitField2_ & 0x00000200) != 0)) {
        result.rbacBindingConfig_ =
            rbacBindingConfigBuilder_ == null
                ? rbacBindingConfig_
                : rbacBindingConfigBuilder_.build();
        to_bitField1_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.Cluster) {
        return mergeFrom((com.google.container.v1.Cluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.Cluster other) {
      if (other == com.google.container.v1.Cluster.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getInitialNodeCount() != 0) {
        setInitialNodeCount(other.getInitialNodeCount());
      }
      if (other.hasNodeConfig()) {
        mergeNodeConfig(other.getNodeConfig());
      }
      if (other.hasMasterAuth()) {
        mergeMasterAuth(other.getMasterAuth());
      }
      if (!other.getLoggingService().isEmpty()) {
        loggingService_ = other.loggingService_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getMonitoringService().isEmpty()) {
        monitoringService_ = other.monitoringService_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getClusterIpv4Cidr().isEmpty()) {
        clusterIpv4Cidr_ = other.clusterIpv4Cidr_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasAddonsConfig()) {
        mergeAddonsConfig(other.getAddonsConfig());
      }
      if (!other.getSubnetwork().isEmpty()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (nodePoolsBuilder_ == null) {
        if (!other.nodePools_.isEmpty()) {
          if (nodePools_.isEmpty()) {
            nodePools_ = other.nodePools_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureNodePoolsIsMutable();
            nodePools_.addAll(other.nodePools_);
          }
          onChanged();
        }
      } else {
        if (!other.nodePools_.isEmpty()) {
          if (nodePoolsBuilder_.isEmpty()) {
            nodePoolsBuilder_.dispose();
            nodePoolsBuilder_ = null;
            nodePools_ = other.nodePools_;
            bitField0_ = (bitField0_ & ~0x00000800);
            nodePoolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodePoolsFieldBuilder()
                    : null;
          } else {
            nodePoolsBuilder_.addAllMessages(other.nodePools_);
          }
        }
      }
      if (!other.locations_.isEmpty()) {
        if (locations_.isEmpty()) {
          locations_ = other.locations_;
          bitField0_ |= 0x00001000;
        } else {
          ensureLocationsIsMutable();
          locations_.addAll(other.locations_);
        }
        onChanged();
      }
      if (other.getEnableKubernetesAlpha() != false) {
        setEnableKubernetesAlpha(other.getEnableKubernetesAlpha());
      }
      internalGetMutableResourceLabels().mergeFrom(other.internalGetResourceLabels());
      bitField0_ |= 0x00004000;
      if (!other.getLabelFingerprint().isEmpty()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasLegacyAbac()) {
        mergeLegacyAbac(other.getLegacyAbac());
      }
      if (other.hasNetworkPolicy()) {
        mergeNetworkPolicy(other.getNetworkPolicy());
      }
      if (other.hasIpAllocationPolicy()) {
        mergeIpAllocationPolicy(other.getIpAllocationPolicy());
      }
      if (other.hasMasterAuthorizedNetworksConfig()) {
        mergeMasterAuthorizedNetworksConfig(other.getMasterAuthorizedNetworksConfig());
      }
      if (other.hasMaintenancePolicy()) {
        mergeMaintenancePolicy(other.getMaintenancePolicy());
      }
      if (other.hasBinaryAuthorization()) {
        mergeBinaryAuthorization(other.getBinaryAuthorization());
      }
      if (other.hasAutoscaling()) {
        mergeAutoscaling(other.getAutoscaling());
      }
      if (other.hasNetworkConfig()) {
        mergeNetworkConfig(other.getNetworkConfig());
      }
      if (other.hasDefaultMaxPodsConstraint()) {
        mergeDefaultMaxPodsConstraint(other.getDefaultMaxPodsConstraint());
      }
      if (other.hasResourceUsageExportConfig()) {
        mergeResourceUsageExportConfig(other.getResourceUsageExportConfig());
      }
      if (other.hasAuthenticatorGroupsConfig()) {
        mergeAuthenticatorGroupsConfig(other.getAuthenticatorGroupsConfig());
      }
      if (other.hasPrivateClusterConfig()) {
        mergePrivateClusterConfig(other.getPrivateClusterConfig());
      }
      if (other.hasDatabaseEncryption()) {
        mergeDatabaseEncryption(other.getDatabaseEncryption());
      }
      if (other.hasVerticalPodAutoscaling()) {
        mergeVerticalPodAutoscaling(other.getVerticalPodAutoscaling());
      }
      if (other.hasShieldedNodes()) {
        mergeShieldedNodes(other.getShieldedNodes());
      }
      if (other.hasReleaseChannel()) {
        mergeReleaseChannel(other.getReleaseChannel());
      }
      if (other.hasWorkloadIdentityConfig()) {
        mergeWorkloadIdentityConfig(other.getWorkloadIdentityConfig());
      }
      if (other.hasMeshCertificates()) {
        mergeMeshCertificates(other.getMeshCertificates());
      }
      if (other.hasCostManagementConfig()) {
        mergeCostManagementConfig(other.getCostManagementConfig());
      }
      if (other.hasNotificationConfig()) {
        mergeNotificationConfig(other.getNotificationConfig());
      }
      if (other.hasConfidentialNodes()) {
        mergeConfidentialNodes(other.getConfidentialNodes());
      }
      if (other.hasIdentityServiceConfig()) {
        mergeIdentityServiceConfig(other.getIdentityServiceConfig());
      }
      if (!other.getSelfLink().isEmpty()) {
        selfLink_ = other.selfLink_;
        bitField1_ |= 0x00000040;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField1_ |= 0x00000080;
        onChanged();
      }
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        bitField1_ |= 0x00000100;
        onChanged();
      }
      if (!other.getInitialClusterVersion().isEmpty()) {
        initialClusterVersion_ = other.initialClusterVersion_;
        bitField1_ |= 0x00000200;
        onChanged();
      }
      if (!other.getCurrentMasterVersion().isEmpty()) {
        currentMasterVersion_ = other.currentMasterVersion_;
        bitField1_ |= 0x00000400;
        onChanged();
      }
      if (!other.getCurrentNodeVersion().isEmpty()) {
        currentNodeVersion_ = other.currentNodeVersion_;
        bitField1_ |= 0x00000800;
        onChanged();
      }
      if (!other.getCreateTime().isEmpty()) {
        createTime_ = other.createTime_;
        bitField1_ |= 0x00001000;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField1_ |= 0x00004000;
        onChanged();
      }
      if (other.getNodeIpv4CidrSize() != 0) {
        setNodeIpv4CidrSize(other.getNodeIpv4CidrSize());
      }
      if (!other.getServicesIpv4Cidr().isEmpty()) {
        servicesIpv4Cidr_ = other.servicesIpv4Cidr_;
        bitField1_ |= 0x00010000;
        onChanged();
      }
      if (!other.instanceGroupUrls_.isEmpty()) {
        if (instanceGroupUrls_.isEmpty()) {
          instanceGroupUrls_ = other.instanceGroupUrls_;
          bitField1_ |= 0x00020000;
        } else {
          ensureInstanceGroupUrlsIsMutable();
          instanceGroupUrls_.addAll(other.instanceGroupUrls_);
        }
        onChanged();
      }
      if (other.getCurrentNodeCount() != 0) {
        setCurrentNodeCount(other.getCurrentNodeCount());
      }
      if (!other.getExpireTime().isEmpty()) {
        expireTime_ = other.expireTime_;
        bitField1_ |= 0x00080000;
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField1_ |= 0x00100000;
        onChanged();
      }
      if (other.getEnableTpu() != false) {
        setEnableTpu(other.getEnableTpu());
      }
      if (!other.getTpuIpv4CidrBlock().isEmpty()) {
        tpuIpv4CidrBlock_ = other.tpuIpv4CidrBlock_;
        bitField1_ |= 0x00400000;
        onChanged();
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField1_ = (bitField1_ & ~0x00800000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField1_ = (bitField1_ & ~0x00800000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (other.hasAutopilot()) {
        mergeAutopilot(other.getAutopilot());
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField1_ |= 0x02000000;
        onChanged();
      }
      if (other.hasNodePoolDefaults()) {
        mergeNodePoolDefaults(other.getNodePoolDefaults());
      }
      if (other.hasLoggingConfig()) {
        mergeLoggingConfig(other.getLoggingConfig());
      }
      if (other.hasMonitoringConfig()) {
        mergeMonitoringConfig(other.getMonitoringConfig());
      }
      if (other.hasNodePoolAutoConfig()) {
        mergeNodePoolAutoConfig(other.getNodePoolAutoConfig());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField1_ |= 0x40000000;
        onChanged();
      }
      if (other.hasFleet()) {
        mergeFleet(other.getFleet());
      }
      if (other.hasSecurityPostureConfig()) {
        mergeSecurityPostureConfig(other.getSecurityPostureConfig());
      }
      if (other.hasControlPlaneEndpointsConfig()) {
        mergeControlPlaneEndpointsConfig(other.getControlPlaneEndpointsConfig());
      }
      if (other.hasEnableK8SBetaApis()) {
        mergeEnableK8SBetaApis(other.getEnableK8SBetaApis());
      }
      if (other.hasEnterpriseConfig()) {
        mergeEnterpriseConfig(other.getEnterpriseConfig());
      }
      if (other.hasSecretManagerConfig()) {
        mergeSecretManagerConfig(other.getSecretManagerConfig());
      }
      if (other.hasCompliancePostureConfig()) {
        mergeCompliancePostureConfig(other.getCompliancePostureConfig());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasSatisfiesPzi()) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (other.hasUserManagedKeysConfig()) {
        mergeUserManagedKeysConfig(other.getUserManagedKeysConfig());
      }
      if (other.hasRbacBindingConfig()) {
        mergeRbacBindingConfig(other.getRbacBindingConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                initialNodeCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getMasterAuthFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                loggingService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                monitoringService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                clusterIpv4Cidr_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getAddonsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.container.v1.NodePool m =
                    input.readMessage(com.google.container.v1.NodePool.parser(), extensionRegistry);
                if (nodePoolsBuilder_ == null) {
                  ensureNodePoolsIsMutable();
                  nodePools_.add(m);
                } else {
                  nodePoolsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationsIsMutable();
                locations_.add(s);
                break;
              } // case 106
            case 112:
              {
                enableKubernetesAlpha_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 122:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLabels__ =
                    input.readMessage(
                        ResourceLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableResourceLabels()
                    .getMutableMap()
                    .put(resourceLabels__.getKey(), resourceLabels__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 146:
              {
                input.readMessage(getLegacyAbacFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getNetworkPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getIpAllocationPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 162
            case 178:
              {
                input.readMessage(
                    getMasterAuthorizedNetworksConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getMaintenancePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getBinaryAuthorizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 194
            case 210:
              {
                input.readMessage(getAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(getNetworkConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 218
            case 242:
              {
                input.readMessage(
                    getDefaultMaxPodsConstraintFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 242
            case 266:
              {
                input.readMessage(
                    getResourceUsageExportConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 266
            case 274:
              {
                input.readMessage(
                    getAuthenticatorGroupsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 274
            case 298:
              {
                input.readMessage(
                    getPrivateClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 298
            case 306:
              {
                input.readMessage(
                    getDatabaseEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 306
            case 314:
              {
                input.readMessage(
                    getVerticalPodAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 314
            case 322:
              {
                input.readMessage(getShieldedNodesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 322
            case 330:
              {
                input.readMessage(getReleaseChannelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 330
            case 346:
              {
                input.readMessage(
                    getWorkloadIdentityConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000001;
                break;
              } // case 346
            case 362:
              {
                input.readMessage(
                    getCostManagementConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000004;
                break;
              } // case 362
            case 394:
              {
                input.readMessage(
                    getNotificationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000008;
                break;
              } // case 394
            case 402:
              {
                input.readMessage(
                    getConfidentialNodesFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000010;
                break;
              } // case 402
            case 434:
              {
                input.readMessage(
                    getIdentityServiceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000020;
                break;
              } // case 434
            case 538:
              {
                input.readMessage(
                    getMeshCertificatesFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000002;
                break;
              } // case 538
            case 802:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000040;
                break;
              } // case 802
            case 810:
              {
                zone_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000080;
                break;
              } // case 810
            case 818:
              {
                endpoint_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000100;
                break;
              } // case 818
            case 826:
              {
                initialClusterVersion_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000200;
                break;
              } // case 826
            case 834:
              {
                currentMasterVersion_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000400;
                break;
              } // case 834
            case 842:
              {
                currentNodeVersion_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00000800;
                break;
              } // case 842
            case 850:
              {
                createTime_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00001000;
                break;
              } // case 850
            case 856:
              {
                status_ = input.readEnum();
                bitField1_ |= 0x00002000;
                break;
              } // case 856
            case 866:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00004000;
                break;
              } // case 866
            case 872:
              {
                nodeIpv4CidrSize_ = input.readInt32();
                bitField1_ |= 0x00008000;
                break;
              } // case 872
            case 882:
              {
                servicesIpv4Cidr_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00010000;
                break;
              } // case 882
            case 890:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceGroupUrlsIsMutable();
                instanceGroupUrls_.add(s);
                break;
              } // case 890
            case 896:
              {
                currentNodeCount_ = input.readInt32();
                bitField1_ |= 0x00040000;
                break;
              } // case 896
            case 906:
              {
                expireTime_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00080000;
                break;
              } // case 906
            case 914:
              {
                location_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00100000;
                break;
              } // case 914
            case 920:
              {
                enableTpu_ = input.readBool();
                bitField1_ |= 0x00200000;
                break;
              } // case 920
            case 930:
              {
                tpuIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00400000;
                break;
              } // case 930
            case 946:
              {
                com.google.container.v1.StatusCondition m =
                    input.readMessage(
                        com.google.container.v1.StatusCondition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 946
            case 1026:
              {
                input.readMessage(getAutopilotFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x01000000;
                break;
              } // case 1026
            case 1034:
              {
                id_ = input.readStringRequireUtf8();
                bitField1_ |= 0x02000000;
                break;
              } // case 1034
            case 1050:
              {
                input.readMessage(
                    getNodePoolDefaultsFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x04000000;
                break;
              } // case 1050
            case 1058:
              {
                input.readMessage(getLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x08000000;
                break;
              } // case 1058
            case 1066:
              {
                input.readMessage(
                    getMonitoringConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x10000000;
                break;
              } // case 1066
            case 1090:
              {
                input.readMessage(
                    getNodePoolAutoConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x20000000;
                break;
              } // case 1090
            case 1114:
              {
                etag_ = input.readStringRequireUtf8();
                bitField1_ |= 0x40000000;
                break;
              } // case 1114
            case 1122:
              {
                input.readMessage(getFleetFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x80000000;
                break;
              } // case 1122
            case 1146:
              {
                input.readMessage(
                    getEnableK8SBetaApisFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000004;
                break;
              } // case 1146
            case 1162:
              {
                input.readMessage(
                    getSecurityPostureConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000001;
                break;
              } // case 1162
            case 1170:
              {
                input.readMessage(
                    getControlPlaneEndpointsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000002;
                break;
              } // case 1170
            case 1194:
              {
                input.readMessage(
                    getEnterpriseConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000008;
                break;
              } // case 1194
            case 1202:
              {
                input.readMessage(
                    getSecretManagerConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000010;
                break;
              } // case 1202
            case 1210:
              {
                input.readMessage(
                    getCompliancePostureConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000020;
                break;
              } // case 1210
            case 1216:
              {
                satisfiesPzs_ = input.readBool();
                bitField2_ |= 0x00000040;
                break;
              } // case 1216
            case 1224:
              {
                satisfiesPzi_ = input.readBool();
                bitField2_ |= 0x00000080;
                break;
              } // case 1224
            case 1234:
              {
                input.readMessage(
                    getUserManagedKeysConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000100;
                break;
              } // case 1234
            case 1250:
              {
                input.readMessage(
                    getRbacBindingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000200;
                break;
              } // case 1250
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;
    private int bitField2_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     *
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     *
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     *
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     *
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of this cluster. The name must be unique within this project
     * and location (e.g. zone or region), and can be up to 40 characters with
     * the following restrictions:
     *
     * * Lowercase letters, numbers, and hyphens only.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this cluster.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this cluster.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this cluster.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this cluster.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this cluster.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int initialNodeCount_;
    /**
     *
     *
     * <pre>
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     *
     * This field is deprecated, use node_pool.initial_node_count instead.
     * </pre>
     *
     * <code>int32 initial_node_count = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.Cluster.initial_node_count is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1877
     * @return The initialNodeCount.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getInitialNodeCount() {
      return initialNodeCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     *
     * This field is deprecated, use node_pool.initial_node_count instead.
     * </pre>
     *
     * <code>int32 initial_node_count = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.Cluster.initial_node_count is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1877
     * @param value The initialNodeCount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setInitialNodeCount(int value) {

      initialNodeCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes to create in this cluster. You must ensure that your
     * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
     * is sufficient for this number of instances. You must also have available
     * firewall and routes quota.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "node_config") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     *
     * This field is deprecated, use node_pool.initial_node_count instead.
     * </pre>
     *
     * <code>int32 initial_node_count = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.Cluster.initial_node_count is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1877
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearInitialNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      initialNodeCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodeConfig nodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeConfig,
            com.google.container.v1.NodeConfig.Builder,
            com.google.container.v1.NodeConfigOrBuilder>
        nodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.Cluster.node_config is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1890
     * @return Whether the nodeConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasNodeConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.Cluster.node_config is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1890
     * @return The nodeConfig.
     */
    @java.lang.Deprecated
    public com.google.container.v1.NodeConfig getNodeConfig() {
      if (nodeConfigBuilder_ == null) {
        return nodeConfig_ == null
            ? com.google.container.v1.NodeConfig.getDefaultInstance()
            : nodeConfig_;
      } else {
        return nodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setNodeConfig(com.google.container.v1.NodeConfig value) {
      if (nodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeConfig_ = value;
      } else {
        nodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setNodeConfig(com.google.container.v1.NodeConfig.Builder builderForValue) {
      if (nodeConfigBuilder_ == null) {
        nodeConfig_ = builderForValue.build();
      } else {
        nodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeNodeConfig(com.google.container.v1.NodeConfig value) {
      if (nodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && nodeConfig_ != null
            && nodeConfig_ != com.google.container.v1.NodeConfig.getDefaultInstance()) {
          getNodeConfigBuilder().mergeFrom(value);
        } else {
          nodeConfig_ = value;
        }
      } else {
        nodeConfigBuilder_.mergeFrom(value);
      }
      if (nodeConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearNodeConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nodeConfig_ = null;
      if (nodeConfigBuilder_ != null) {
        nodeConfigBuilder_.dispose();
        nodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.NodeConfig.Builder getNodeConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.NodeConfigOrBuilder getNodeConfigOrBuilder() {
      if (nodeConfigBuilder_ != null) {
        return nodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodeConfig_ == null
            ? com.google.container.v1.NodeConfig.getDefaultInstance()
            : nodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters used in creating the cluster's nodes.
     * For requests, this field should only be used in lieu of a
     * "node_pool" object, since this configuration (along with the
     * "initial_node_count") will be used to create a "NodePool" object with an
     * auto-generated name. Do not use this and a node_pool at the same time.
     * For responses, this field will be populated with the node configuration of
     * the first node pool. (For configuration of each node pool, see
     * `node_pool.config`)
     *
     * If unspecified, the defaults are used.
     * This field is deprecated, use node_pool.config instead.
     * </pre>
     *
     * <code>.google.container.v1.NodeConfig node_config = 4 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodeConfig,
            com.google.container.v1.NodeConfig.Builder,
            com.google.container.v1.NodeConfigOrBuilder>
        getNodeConfigFieldBuilder() {
      if (nodeConfigBuilder_ == null) {
        nodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodeConfig,
                com.google.container.v1.NodeConfig.Builder,
                com.google.container.v1.NodeConfigOrBuilder>(
                getNodeConfig(), getParentForChildren(), isClean());
        nodeConfig_ = null;
      }
      return nodeConfigBuilder_;
    }

    private com.google.container.v1.MasterAuth masterAuth_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MasterAuth,
            com.google.container.v1.MasterAuth.Builder,
            com.google.container.v1.MasterAuthOrBuilder>
        masterAuthBuilder_;
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     *
     * @return Whether the masterAuth field is set.
     */
    public boolean hasMasterAuth() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     *
     * @return The masterAuth.
     */
    public com.google.container.v1.MasterAuth getMasterAuth() {
      if (masterAuthBuilder_ == null) {
        return masterAuth_ == null
            ? com.google.container.v1.MasterAuth.getDefaultInstance()
            : masterAuth_;
      } else {
        return masterAuthBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    public Builder setMasterAuth(com.google.container.v1.MasterAuth value) {
      if (masterAuthBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        masterAuth_ = value;
      } else {
        masterAuthBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    public Builder setMasterAuth(com.google.container.v1.MasterAuth.Builder builderForValue) {
      if (masterAuthBuilder_ == null) {
        masterAuth_ = builderForValue.build();
      } else {
        masterAuthBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    public Builder mergeMasterAuth(com.google.container.v1.MasterAuth value) {
      if (masterAuthBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && masterAuth_ != null
            && masterAuth_ != com.google.container.v1.MasterAuth.getDefaultInstance()) {
          getMasterAuthBuilder().mergeFrom(value);
        } else {
          masterAuth_ = value;
        }
      } else {
        masterAuthBuilder_.mergeFrom(value);
      }
      if (masterAuth_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    public Builder clearMasterAuth() {
      bitField0_ = (bitField0_ & ~0x00000010);
      masterAuth_ = null;
      if (masterAuthBuilder_ != null) {
        masterAuthBuilder_.dispose();
        masterAuthBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    public com.google.container.v1.MasterAuth.Builder getMasterAuthBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMasterAuthFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    public com.google.container.v1.MasterAuthOrBuilder getMasterAuthOrBuilder() {
      if (masterAuthBuilder_ != null) {
        return masterAuthBuilder_.getMessageOrBuilder();
      } else {
        return masterAuth_ == null
            ? com.google.container.v1.MasterAuth.getDefaultInstance()
            : masterAuth_;
      }
    }
    /**
     *
     *
     * <pre>
     * The authentication information for accessing the master endpoint.
     * If unspecified, the defaults are used:
     * For clusters before v1.12, if master_auth is unspecified, `username` will
     * be set to "admin", a random password will be generated, and a client
     * certificate will be issued.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuth master_auth = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MasterAuth,
            com.google.container.v1.MasterAuth.Builder,
            com.google.container.v1.MasterAuthOrBuilder>
        getMasterAuthFieldBuilder() {
      if (masterAuthBuilder_ == null) {
        masterAuthBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MasterAuth,
                com.google.container.v1.MasterAuth.Builder,
                com.google.container.v1.MasterAuthOrBuilder>(
                getMasterAuth(), getParentForChildren(), isClean());
        masterAuth_ = null;
      }
      return masterAuthBuilder_;
    }

    private java.lang.Object loggingService_ = "";
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 6;</code>
     *
     * @return The loggingService.
     */
    public java.lang.String getLoggingService() {
      java.lang.Object ref = loggingService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        loggingService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 6;</code>
     *
     * @return The bytes for loggingService.
     */
    public com.google.protobuf.ByteString getLoggingServiceBytes() {
      java.lang.Object ref = loggingService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        loggingService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 6;</code>
     *
     * @param value The loggingService to set.
     * @return This builder for chaining.
     */
    public Builder setLoggingService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      loggingService_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoggingService() {
      loggingService_ = getDefaultInstance().getLoggingService();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 6;</code>
     *
     * @param value The bytes for loggingService to set.
     * @return This builder for chaining.
     */
    public Builder setLoggingServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      loggingService_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object monitoringService_ = "";
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string monitoring_service = 7;</code>
     *
     * @return The monitoringService.
     */
    public java.lang.String getMonitoringService() {
      java.lang.Object ref = monitoringService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        monitoringService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string monitoring_service = 7;</code>
     *
     * @return The bytes for monitoringService.
     */
    public com.google.protobuf.ByteString getMonitoringServiceBytes() {
      java.lang.Object ref = monitoringService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        monitoringService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string monitoring_service = 7;</code>
     *
     * @param value The monitoringService to set.
     * @return This builder for chaining.
     */
    public Builder setMonitoringService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      monitoringService_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string monitoring_service = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMonitoringService() {
      monitoringService_ = getDefaultInstance().getMonitoringService();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string monitoring_service = 7;</code>
     *
     * @param value The bytes for monitoringService to set.
     * @return This builder for chaining.
     */
    public Builder setMonitoringServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      monitoringService_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     * </pre>
     *
     * <code>string network = 8;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     * </pre>
     *
     * <code>string network = 8;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     * </pre>
     *
     * <code>string network = 8;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     * </pre>
     *
     * <code>string network = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. If left unspecified, the `default`
     * network will be used.
     * </pre>
     *
     * <code>string network = 8;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object clusterIpv4Cidr_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 9;</code>
     *
     * @return The clusterIpv4Cidr.
     */
    public java.lang.String getClusterIpv4Cidr() {
      java.lang.Object ref = clusterIpv4Cidr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterIpv4Cidr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 9;</code>
     *
     * @return The bytes for clusterIpv4Cidr.
     */
    public com.google.protobuf.ByteString getClusterIpv4CidrBytes() {
      java.lang.Object ref = clusterIpv4Cidr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterIpv4Cidr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 9;</code>
     *
     * @param value The clusterIpv4Cidr to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4Cidr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterIpv4Cidr_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterIpv4Cidr() {
      clusterIpv4Cidr_ = getDefaultInstance().getClusterIpv4Cidr();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range of the container pods in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`). Leave blank to have
     * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
     * </pre>
     *
     * <code>string cluster_ipv4_cidr = 9;</code>
     *
     * @param value The bytes for clusterIpv4Cidr to set.
     * @return This builder for chaining.
     */
    public Builder setClusterIpv4CidrBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterIpv4Cidr_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.container.v1.AddonsConfig addonsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AddonsConfig,
            com.google.container.v1.AddonsConfig.Builder,
            com.google.container.v1.AddonsConfigOrBuilder>
        addonsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     *
     * @return Whether the addonsConfig field is set.
     */
    public boolean hasAddonsConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     *
     * @return The addonsConfig.
     */
    public com.google.container.v1.AddonsConfig getAddonsConfig() {
      if (addonsConfigBuilder_ == null) {
        return addonsConfig_ == null
            ? com.google.container.v1.AddonsConfig.getDefaultInstance()
            : addonsConfig_;
      } else {
        return addonsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    public Builder setAddonsConfig(com.google.container.v1.AddonsConfig value) {
      if (addonsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        addonsConfig_ = value;
      } else {
        addonsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    public Builder setAddonsConfig(com.google.container.v1.AddonsConfig.Builder builderForValue) {
      if (addonsConfigBuilder_ == null) {
        addonsConfig_ = builderForValue.build();
      } else {
        addonsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    public Builder mergeAddonsConfig(com.google.container.v1.AddonsConfig value) {
      if (addonsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && addonsConfig_ != null
            && addonsConfig_ != com.google.container.v1.AddonsConfig.getDefaultInstance()) {
          getAddonsConfigBuilder().mergeFrom(value);
        } else {
          addonsConfig_ = value;
        }
      } else {
        addonsConfigBuilder_.mergeFrom(value);
      }
      if (addonsConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    public Builder clearAddonsConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      addonsConfig_ = null;
      if (addonsConfigBuilder_ != null) {
        addonsConfigBuilder_.dispose();
        addonsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    public com.google.container.v1.AddonsConfig.Builder getAddonsConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getAddonsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    public com.google.container.v1.AddonsConfigOrBuilder getAddonsConfigOrBuilder() {
      if (addonsConfigBuilder_ != null) {
        return addonsConfigBuilder_.getMessageOrBuilder();
      } else {
        return addonsConfig_ == null
            ? com.google.container.v1.AddonsConfig.getDefaultInstance()
            : addonsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1.AddonsConfig addons_config = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AddonsConfig,
            com.google.container.v1.AddonsConfig.Builder,
            com.google.container.v1.AddonsConfigOrBuilder>
        getAddonsConfigFieldBuilder() {
      if (addonsConfigBuilder_ == null) {
        addonsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.AddonsConfig,
                com.google.container.v1.AddonsConfig.Builder,
                com.google.container.v1.AddonsConfigOrBuilder>(
                getAddonsConfig(), getParentForChildren(), isClean());
        addonsConfig_ = null;
      }
      return addonsConfigBuilder_;
    }

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     * </pre>
     *
     * <code>string subnetwork = 11;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     * </pre>
     *
     * <code>string subnetwork = 11;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     * </pre>
     *
     * <code>string subnetwork = 11;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     * </pre>
     *
     * <code>string subnetwork = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
     * the cluster is connected.
     * </pre>
     *
     * <code>string subnetwork = 11;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.NodePool> nodePools_ =
        java.util.Collections.emptyList();

    private void ensureNodePoolsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        nodePools_ = new java.util.ArrayList<com.google.container.v1.NodePool>(nodePools_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.NodePool,
            com.google.container.v1.NodePool.Builder,
            com.google.container.v1.NodePoolOrBuilder>
        nodePoolsBuilder_;

    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public java.util.List<com.google.container.v1.NodePool> getNodePoolsList() {
      if (nodePoolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodePools_);
      } else {
        return nodePoolsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public int getNodePoolsCount() {
      if (nodePoolsBuilder_ == null) {
        return nodePools_.size();
      } else {
        return nodePoolsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public com.google.container.v1.NodePool getNodePools(int index) {
      if (nodePoolsBuilder_ == null) {
        return nodePools_.get(index);
      } else {
        return nodePoolsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder setNodePools(int index, com.google.container.v1.NodePool value) {
      if (nodePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolsIsMutable();
        nodePools_.set(index, value);
        onChanged();
      } else {
        nodePoolsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder setNodePools(
        int index, com.google.container.v1.NodePool.Builder builderForValue) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodePoolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder addNodePools(com.google.container.v1.NodePool value) {
      if (nodePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolsIsMutable();
        nodePools_.add(value);
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder addNodePools(int index, com.google.container.v1.NodePool value) {
      if (nodePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolsIsMutable();
        nodePools_.add(index, value);
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder addNodePools(com.google.container.v1.NodePool.Builder builderForValue) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.add(builderForValue.build());
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder addNodePools(
        int index, com.google.container.v1.NodePool.Builder builderForValue) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodePoolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder addAllNodePools(
        java.lang.Iterable<? extends com.google.container.v1.NodePool> values) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodePools_);
        onChanged();
      } else {
        nodePoolsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder clearNodePools() {
      if (nodePoolsBuilder_ == null) {
        nodePools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        nodePoolsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public Builder removeNodePools(int index) {
      if (nodePoolsBuilder_ == null) {
        ensureNodePoolsIsMutable();
        nodePools_.remove(index);
        onChanged();
      } else {
        nodePoolsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public com.google.container.v1.NodePool.Builder getNodePoolsBuilder(int index) {
      return getNodePoolsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public com.google.container.v1.NodePoolOrBuilder getNodePoolsOrBuilder(int index) {
      if (nodePoolsBuilder_ == null) {
        return nodePools_.get(index);
      } else {
        return nodePoolsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public java.util.List<? extends com.google.container.v1.NodePoolOrBuilder>
        getNodePoolsOrBuilderList() {
      if (nodePoolsBuilder_ != null) {
        return nodePoolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodePools_);
      }
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public com.google.container.v1.NodePool.Builder addNodePoolsBuilder() {
      return getNodePoolsFieldBuilder()
          .addBuilder(com.google.container.v1.NodePool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public com.google.container.v1.NodePool.Builder addNodePoolsBuilder(int index) {
      return getNodePoolsFieldBuilder()
          .addBuilder(index, com.google.container.v1.NodePool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The node pools associated with this cluster.
     * This field should not be set if "node_config" or "initial_node_count" are
     * specified.
     * </pre>
     *
     * <code>repeated .google.container.v1.NodePool node_pools = 12;</code>
     */
    public java.util.List<com.google.container.v1.NodePool.Builder> getNodePoolsBuilderList() {
      return getNodePoolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.NodePool,
            com.google.container.v1.NodePool.Builder,
            com.google.container.v1.NodePoolOrBuilder>
        getNodePoolsFieldBuilder() {
      if (nodePoolsBuilder_ == null) {
        nodePoolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.NodePool,
                com.google.container.v1.NodePool.Builder,
                com.google.container.v1.NodePoolOrBuilder>(
                nodePools_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        nodePools_ = null;
      }
      return nodePoolsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList locations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLocationsIsMutable() {
      if (!locations_.isModifiable()) {
        locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return A list containing the locations.
     */
    public com.google.protobuf.ProtocolStringList getLocationsList() {
      locations_.makeImmutable();
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return The count of locations.
     */
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The locations at the given index.
     */
    public java.lang.String getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the locations at the given index.
     */
    public com.google.protobuf.ByteString getLocationsBytes(int index) {
      return locations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The locations to set.
     * @return This builder for chaining.
     */
    public Builder setLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param value The locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param values The locations to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
      ensureLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocations() {
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This field provides a default value if
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * are not specified during node pool creation.
     *
     * Warning: changing cluster locations will update the
     * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
     * of all node pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string locations = 13;</code>
     *
     * @param value The bytes of the locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private boolean enableKubernetesAlpha_;
    /**
     *
     *
     * <pre>
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1alpha1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     * </pre>
     *
     * <code>bool enable_kubernetes_alpha = 14;</code>
     *
     * @return The enableKubernetesAlpha.
     */
    @java.lang.Override
    public boolean getEnableKubernetesAlpha() {
      return enableKubernetesAlpha_;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1alpha1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     * </pre>
     *
     * <code>bool enable_kubernetes_alpha = 14;</code>
     *
     * @param value The enableKubernetesAlpha to set.
     * @return This builder for chaining.
     */
    public Builder setEnableKubernetesAlpha(boolean value) {

      enableKubernetesAlpha_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes alpha features are enabled on this cluster. This includes alpha
     * API groups (e.g. v1alpha1) and features that may not be production ready in
     * the kubernetes version of the master and nodes.
     * The cluster has no SLA for uptime and master/node upgrades are disabled.
     * Alpha enabled clusters are automatically deleted thirty days after
     * creation.
     * </pre>
     *
     * <code>bool enable_kubernetes_alpha = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableKubernetesAlpha() {
      bitField0_ = (bitField0_ & ~0x00002000);
      enableKubernetesAlpha_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourceLabels() {
      if (resourceLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      return resourceLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourceLabels() {
      if (resourceLabels_ == null) {
        resourceLabels_ =
            com.google.protobuf.MapField.newMapField(ResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!resourceLabels_.isMutable()) {
        resourceLabels_ = resourceLabels_.copy();
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return resourceLabels_;
    }

    public int getResourceLabelsCount() {
      return internalGetResourceLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceLabels().getMap().containsKey(key);
    }
    /** Use {@link #getResourceLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourceLabels() {
      return getResourceLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap() {
      return internalGetResourceLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getResourceLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourceLabels() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableResourceLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    public Builder removeResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourceLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourceLabels() {
      bitField0_ |= 0x00004000;
      return internalGetMutableResourceLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    public Builder putResourceLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourceLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for the cluster to use to annotate any related
     * Google Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_labels = 15;</code>
     */
    public Builder putAllResourceLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourceLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";
    /**
     *
     *
     * <pre>
     * The fingerprint of the set of labels for this cluster.
     * </pre>
     *
     * <code>string label_fingerprint = 16;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fingerprint of the set of labels for this cluster.
     * </pre>
     *
     * <code>string label_fingerprint = 16;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fingerprint of the set of labels for this cluster.
     * </pre>
     *
     * <code>string label_fingerprint = 16;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fingerprint of the set of labels for this cluster.
     * </pre>
     *
     * <code>string label_fingerprint = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fingerprint of the set of labels for this cluster.
     * </pre>
     *
     * <code>string label_fingerprint = 16;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.container.v1.LegacyAbac legacyAbac_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LegacyAbac,
            com.google.container.v1.LegacyAbac.Builder,
            com.google.container.v1.LegacyAbacOrBuilder>
        legacyAbacBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     *
     * @return Whether the legacyAbac field is set.
     */
    public boolean hasLegacyAbac() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     *
     * @return The legacyAbac.
     */
    public com.google.container.v1.LegacyAbac getLegacyAbac() {
      if (legacyAbacBuilder_ == null) {
        return legacyAbac_ == null
            ? com.google.container.v1.LegacyAbac.getDefaultInstance()
            : legacyAbac_;
      } else {
        return legacyAbacBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    public Builder setLegacyAbac(com.google.container.v1.LegacyAbac value) {
      if (legacyAbacBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        legacyAbac_ = value;
      } else {
        legacyAbacBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    public Builder setLegacyAbac(com.google.container.v1.LegacyAbac.Builder builderForValue) {
      if (legacyAbacBuilder_ == null) {
        legacyAbac_ = builderForValue.build();
      } else {
        legacyAbacBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    public Builder mergeLegacyAbac(com.google.container.v1.LegacyAbac value) {
      if (legacyAbacBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && legacyAbac_ != null
            && legacyAbac_ != com.google.container.v1.LegacyAbac.getDefaultInstance()) {
          getLegacyAbacBuilder().mergeFrom(value);
        } else {
          legacyAbac_ = value;
        }
      } else {
        legacyAbacBuilder_.mergeFrom(value);
      }
      if (legacyAbac_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    public Builder clearLegacyAbac() {
      bitField0_ = (bitField0_ & ~0x00010000);
      legacyAbac_ = null;
      if (legacyAbacBuilder_ != null) {
        legacyAbacBuilder_.dispose();
        legacyAbacBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    public com.google.container.v1.LegacyAbac.Builder getLegacyAbacBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getLegacyAbacFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    public com.google.container.v1.LegacyAbacOrBuilder getLegacyAbacOrBuilder() {
      if (legacyAbacBuilder_ != null) {
        return legacyAbacBuilder_.getMessageOrBuilder();
      } else {
        return legacyAbac_ == null
            ? com.google.container.v1.LegacyAbac.getDefaultInstance()
            : legacyAbac_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the legacy ABAC authorization mode.
     * </pre>
     *
     * <code>.google.container.v1.LegacyAbac legacy_abac = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LegacyAbac,
            com.google.container.v1.LegacyAbac.Builder,
            com.google.container.v1.LegacyAbacOrBuilder>
        getLegacyAbacFieldBuilder() {
      if (legacyAbacBuilder_ == null) {
        legacyAbacBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.LegacyAbac,
                com.google.container.v1.LegacyAbac.Builder,
                com.google.container.v1.LegacyAbacOrBuilder>(
                getLegacyAbac(), getParentForChildren(), isClean());
        legacyAbac_ = null;
      }
      return legacyAbacBuilder_;
    }

    private com.google.container.v1.NetworkPolicy networkPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NetworkPolicy,
            com.google.container.v1.NetworkPolicy.Builder,
            com.google.container.v1.NetworkPolicyOrBuilder>
        networkPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     *
     * @return Whether the networkPolicy field is set.
     */
    public boolean hasNetworkPolicy() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     *
     * @return The networkPolicy.
     */
    public com.google.container.v1.NetworkPolicy getNetworkPolicy() {
      if (networkPolicyBuilder_ == null) {
        return networkPolicy_ == null
            ? com.google.container.v1.NetworkPolicy.getDefaultInstance()
            : networkPolicy_;
      } else {
        return networkPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    public Builder setNetworkPolicy(com.google.container.v1.NetworkPolicy value) {
      if (networkPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPolicy_ = value;
      } else {
        networkPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    public Builder setNetworkPolicy(com.google.container.v1.NetworkPolicy.Builder builderForValue) {
      if (networkPolicyBuilder_ == null) {
        networkPolicy_ = builderForValue.build();
      } else {
        networkPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    public Builder mergeNetworkPolicy(com.google.container.v1.NetworkPolicy value) {
      if (networkPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && networkPolicy_ != null
            && networkPolicy_ != com.google.container.v1.NetworkPolicy.getDefaultInstance()) {
          getNetworkPolicyBuilder().mergeFrom(value);
        } else {
          networkPolicy_ = value;
        }
      } else {
        networkPolicyBuilder_.mergeFrom(value);
      }
      if (networkPolicy_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    public Builder clearNetworkPolicy() {
      bitField0_ = (bitField0_ & ~0x00020000);
      networkPolicy_ = null;
      if (networkPolicyBuilder_ != null) {
        networkPolicyBuilder_.dispose();
        networkPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    public com.google.container.v1.NetworkPolicy.Builder getNetworkPolicyBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getNetworkPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    public com.google.container.v1.NetworkPolicyOrBuilder getNetworkPolicyOrBuilder() {
      if (networkPolicyBuilder_ != null) {
        return networkPolicyBuilder_.getMessageOrBuilder();
      } else {
        return networkPolicy_ == null
            ? com.google.container.v1.NetworkPolicy.getDefaultInstance()
            : networkPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>.google.container.v1.NetworkPolicy network_policy = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NetworkPolicy,
            com.google.container.v1.NetworkPolicy.Builder,
            com.google.container.v1.NetworkPolicyOrBuilder>
        getNetworkPolicyFieldBuilder() {
      if (networkPolicyBuilder_ == null) {
        networkPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NetworkPolicy,
                com.google.container.v1.NetworkPolicy.Builder,
                com.google.container.v1.NetworkPolicyOrBuilder>(
                getNetworkPolicy(), getParentForChildren(), isClean());
        networkPolicy_ = null;
      }
      return networkPolicyBuilder_;
    }

    private com.google.container.v1.IPAllocationPolicy ipAllocationPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.IPAllocationPolicy,
            com.google.container.v1.IPAllocationPolicy.Builder,
            com.google.container.v1.IPAllocationPolicyOrBuilder>
        ipAllocationPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     *
     * @return Whether the ipAllocationPolicy field is set.
     */
    public boolean hasIpAllocationPolicy() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     *
     * @return The ipAllocationPolicy.
     */
    public com.google.container.v1.IPAllocationPolicy getIpAllocationPolicy() {
      if (ipAllocationPolicyBuilder_ == null) {
        return ipAllocationPolicy_ == null
            ? com.google.container.v1.IPAllocationPolicy.getDefaultInstance()
            : ipAllocationPolicy_;
      } else {
        return ipAllocationPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    public Builder setIpAllocationPolicy(com.google.container.v1.IPAllocationPolicy value) {
      if (ipAllocationPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ipAllocationPolicy_ = value;
      } else {
        ipAllocationPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    public Builder setIpAllocationPolicy(
        com.google.container.v1.IPAllocationPolicy.Builder builderForValue) {
      if (ipAllocationPolicyBuilder_ == null) {
        ipAllocationPolicy_ = builderForValue.build();
      } else {
        ipAllocationPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    public Builder mergeIpAllocationPolicy(com.google.container.v1.IPAllocationPolicy value) {
      if (ipAllocationPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && ipAllocationPolicy_ != null
            && ipAllocationPolicy_
                != com.google.container.v1.IPAllocationPolicy.getDefaultInstance()) {
          getIpAllocationPolicyBuilder().mergeFrom(value);
        } else {
          ipAllocationPolicy_ = value;
        }
      } else {
        ipAllocationPolicyBuilder_.mergeFrom(value);
      }
      if (ipAllocationPolicy_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    public Builder clearIpAllocationPolicy() {
      bitField0_ = (bitField0_ & ~0x00040000);
      ipAllocationPolicy_ = null;
      if (ipAllocationPolicyBuilder_ != null) {
        ipAllocationPolicyBuilder_.dispose();
        ipAllocationPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    public com.google.container.v1.IPAllocationPolicy.Builder getIpAllocationPolicyBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getIpAllocationPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    public com.google.container.v1.IPAllocationPolicyOrBuilder getIpAllocationPolicyOrBuilder() {
      if (ipAllocationPolicyBuilder_ != null) {
        return ipAllocationPolicyBuilder_.getMessageOrBuilder();
      } else {
        return ipAllocationPolicy_ == null
            ? com.google.container.v1.IPAllocationPolicy.getDefaultInstance()
            : ipAllocationPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster IP allocation.
     * </pre>
     *
     * <code>.google.container.v1.IPAllocationPolicy ip_allocation_policy = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.IPAllocationPolicy,
            com.google.container.v1.IPAllocationPolicy.Builder,
            com.google.container.v1.IPAllocationPolicyOrBuilder>
        getIpAllocationPolicyFieldBuilder() {
      if (ipAllocationPolicyBuilder_ == null) {
        ipAllocationPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.IPAllocationPolicy,
                com.google.container.v1.IPAllocationPolicy.Builder,
                com.google.container.v1.IPAllocationPolicyOrBuilder>(
                getIpAllocationPolicy(), getParentForChildren(), isClean());
        ipAllocationPolicy_ = null;
      }
      return ipAllocationPolicyBuilder_;
    }

    private com.google.container.v1.MasterAuthorizedNetworksConfig masterAuthorizedNetworksConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MasterAuthorizedNetworksConfig,
            com.google.container.v1.MasterAuthorizedNetworksConfig.Builder,
            com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder>
        masterAuthorizedNetworksConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.master_authorized_networks_config is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1992
     * @return Whether the masterAuthorizedNetworksConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasMasterAuthorizedNetworksConfig() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.master_authorized_networks_config is deprecated. See
     *     google/container/v1/cluster_service.proto;l=1992
     * @return The masterAuthorizedNetworksConfig.
     */
    @java.lang.Deprecated
    public com.google.container.v1.MasterAuthorizedNetworksConfig
        getMasterAuthorizedNetworksConfig() {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        return masterAuthorizedNetworksConfig_ == null
            ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
            : masterAuthorizedNetworksConfig_;
      } else {
        return masterAuthorizedNetworksConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setMasterAuthorizedNetworksConfig(
        com.google.container.v1.MasterAuthorizedNetworksConfig value) {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        masterAuthorizedNetworksConfig_ = value;
      } else {
        masterAuthorizedNetworksConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setMasterAuthorizedNetworksConfig(
        com.google.container.v1.MasterAuthorizedNetworksConfig.Builder builderForValue) {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        masterAuthorizedNetworksConfig_ = builderForValue.build();
      } else {
        masterAuthorizedNetworksConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeMasterAuthorizedNetworksConfig(
        com.google.container.v1.MasterAuthorizedNetworksConfig value) {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && masterAuthorizedNetworksConfig_ != null
            && masterAuthorizedNetworksConfig_
                != com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()) {
          getMasterAuthorizedNetworksConfigBuilder().mergeFrom(value);
        } else {
          masterAuthorizedNetworksConfig_ = value;
        }
      } else {
        masterAuthorizedNetworksConfigBuilder_.mergeFrom(value);
      }
      if (masterAuthorizedNetworksConfig_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearMasterAuthorizedNetworksConfig() {
      bitField0_ = (bitField0_ & ~0x00080000);
      masterAuthorizedNetworksConfig_ = null;
      if (masterAuthorizedNetworksConfigBuilder_ != null) {
        masterAuthorizedNetworksConfigBuilder_.dispose();
        masterAuthorizedNetworksConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.MasterAuthorizedNetworksConfig.Builder
        getMasterAuthorizedNetworksConfigBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getMasterAuthorizedNetworksConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder
        getMasterAuthorizedNetworksConfigOrBuilder() {
      if (masterAuthorizedNetworksConfigBuilder_ != null) {
        return masterAuthorizedNetworksConfigBuilder_.getMessageOrBuilder();
      } else {
        return masterAuthorizedNetworksConfig_ == null
            ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
            : masterAuthorizedNetworksConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration options for master authorized networks feature.
     *
     * Deprecated: Use
     * [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MasterAuthorizedNetworksConfig,
            com.google.container.v1.MasterAuthorizedNetworksConfig.Builder,
            com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder>
        getMasterAuthorizedNetworksConfigFieldBuilder() {
      if (masterAuthorizedNetworksConfigBuilder_ == null) {
        masterAuthorizedNetworksConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MasterAuthorizedNetworksConfig,
                com.google.container.v1.MasterAuthorizedNetworksConfig.Builder,
                com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder>(
                getMasterAuthorizedNetworksConfig(), getParentForChildren(), isClean());
        masterAuthorizedNetworksConfig_ = null;
      }
      return masterAuthorizedNetworksConfigBuilder_;
    }

    private com.google.container.v1.MaintenancePolicy maintenancePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MaintenancePolicy,
            com.google.container.v1.MaintenancePolicy.Builder,
            com.google.container.v1.MaintenancePolicyOrBuilder>
        maintenancePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     *
     * @return Whether the maintenancePolicy field is set.
     */
    public boolean hasMaintenancePolicy() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     *
     * @return The maintenancePolicy.
     */
    public com.google.container.v1.MaintenancePolicy getMaintenancePolicy() {
      if (maintenancePolicyBuilder_ == null) {
        return maintenancePolicy_ == null
            ? com.google.container.v1.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      } else {
        return maintenancePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    public Builder setMaintenancePolicy(com.google.container.v1.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenancePolicy_ = value;
      } else {
        maintenancePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    public Builder setMaintenancePolicy(
        com.google.container.v1.MaintenancePolicy.Builder builderForValue) {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicy_ = builderForValue.build();
      } else {
        maintenancePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    public Builder mergeMaintenancePolicy(com.google.container.v1.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && maintenancePolicy_ != null
            && maintenancePolicy_
                != com.google.container.v1.MaintenancePolicy.getDefaultInstance()) {
          getMaintenancePolicyBuilder().mergeFrom(value);
        } else {
          maintenancePolicy_ = value;
        }
      } else {
        maintenancePolicyBuilder_.mergeFrom(value);
      }
      if (maintenancePolicy_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    public Builder clearMaintenancePolicy() {
      bitField0_ = (bitField0_ & ~0x00100000);
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    public com.google.container.v1.MaintenancePolicy.Builder getMaintenancePolicyBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getMaintenancePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    public com.google.container.v1.MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder() {
      if (maintenancePolicyBuilder_ != null) {
        return maintenancePolicyBuilder_.getMessageOrBuilder();
      } else {
        return maintenancePolicy_ == null
            ? com.google.container.v1.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configure the maintenance policy for this cluster.
     * </pre>
     *
     * <code>.google.container.v1.MaintenancePolicy maintenance_policy = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MaintenancePolicy,
            com.google.container.v1.MaintenancePolicy.Builder,
            com.google.container.v1.MaintenancePolicyOrBuilder>
        getMaintenancePolicyFieldBuilder() {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MaintenancePolicy,
                com.google.container.v1.MaintenancePolicy.Builder,
                com.google.container.v1.MaintenancePolicyOrBuilder>(
                getMaintenancePolicy(), getParentForChildren(), isClean());
        maintenancePolicy_ = null;
      }
      return maintenancePolicyBuilder_;
    }

    private com.google.container.v1.BinaryAuthorization binaryAuthorization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.BinaryAuthorization,
            com.google.container.v1.BinaryAuthorization.Builder,
            com.google.container.v1.BinaryAuthorizationOrBuilder>
        binaryAuthorizationBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     *
     * @return Whether the binaryAuthorization field is set.
     */
    public boolean hasBinaryAuthorization() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     *
     * @return The binaryAuthorization.
     */
    public com.google.container.v1.BinaryAuthorization getBinaryAuthorization() {
      if (binaryAuthorizationBuilder_ == null) {
        return binaryAuthorization_ == null
            ? com.google.container.v1.BinaryAuthorization.getDefaultInstance()
            : binaryAuthorization_;
      } else {
        return binaryAuthorizationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    public Builder setBinaryAuthorization(com.google.container.v1.BinaryAuthorization value) {
      if (binaryAuthorizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        binaryAuthorization_ = value;
      } else {
        binaryAuthorizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    public Builder setBinaryAuthorization(
        com.google.container.v1.BinaryAuthorization.Builder builderForValue) {
      if (binaryAuthorizationBuilder_ == null) {
        binaryAuthorization_ = builderForValue.build();
      } else {
        binaryAuthorizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    public Builder mergeBinaryAuthorization(com.google.container.v1.BinaryAuthorization value) {
      if (binaryAuthorizationBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && binaryAuthorization_ != null
            && binaryAuthorization_
                != com.google.container.v1.BinaryAuthorization.getDefaultInstance()) {
          getBinaryAuthorizationBuilder().mergeFrom(value);
        } else {
          binaryAuthorization_ = value;
        }
      } else {
        binaryAuthorizationBuilder_.mergeFrom(value);
      }
      if (binaryAuthorization_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    public Builder clearBinaryAuthorization() {
      bitField0_ = (bitField0_ & ~0x00200000);
      binaryAuthorization_ = null;
      if (binaryAuthorizationBuilder_ != null) {
        binaryAuthorizationBuilder_.dispose();
        binaryAuthorizationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    public com.google.container.v1.BinaryAuthorization.Builder getBinaryAuthorizationBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getBinaryAuthorizationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    public com.google.container.v1.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder() {
      if (binaryAuthorizationBuilder_ != null) {
        return binaryAuthorizationBuilder_.getMessageOrBuilder();
      } else {
        return binaryAuthorization_ == null
            ? com.google.container.v1.BinaryAuthorization.getDefaultInstance()
            : binaryAuthorization_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Binary Authorization.
     * </pre>
     *
     * <code>.google.container.v1.BinaryAuthorization binary_authorization = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.BinaryAuthorization,
            com.google.container.v1.BinaryAuthorization.Builder,
            com.google.container.v1.BinaryAuthorizationOrBuilder>
        getBinaryAuthorizationFieldBuilder() {
      if (binaryAuthorizationBuilder_ == null) {
        binaryAuthorizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.BinaryAuthorization,
                com.google.container.v1.BinaryAuthorization.Builder,
                com.google.container.v1.BinaryAuthorizationOrBuilder>(
                getBinaryAuthorization(), getParentForChildren(), isClean());
        binaryAuthorization_ = null;
      }
      return binaryAuthorizationBuilder_;
    }

    private com.google.container.v1.ClusterAutoscaling autoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ClusterAutoscaling,
            com.google.container.v1.ClusterAutoscaling.Builder,
            com.google.container.v1.ClusterAutoscalingOrBuilder>
        autoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     *
     * @return Whether the autoscaling field is set.
     */
    public boolean hasAutoscaling() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     *
     * @return The autoscaling.
     */
    public com.google.container.v1.ClusterAutoscaling getAutoscaling() {
      if (autoscalingBuilder_ == null) {
        return autoscaling_ == null
            ? com.google.container.v1.ClusterAutoscaling.getDefaultInstance()
            : autoscaling_;
      } else {
        return autoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    public Builder setAutoscaling(com.google.container.v1.ClusterAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaling_ = value;
      } else {
        autoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    public Builder setAutoscaling(
        com.google.container.v1.ClusterAutoscaling.Builder builderForValue) {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = builderForValue.build();
      } else {
        autoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    public Builder mergeAutoscaling(com.google.container.v1.ClusterAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && autoscaling_ != null
            && autoscaling_ != com.google.container.v1.ClusterAutoscaling.getDefaultInstance()) {
          getAutoscalingBuilder().mergeFrom(value);
        } else {
          autoscaling_ = value;
        }
      } else {
        autoscalingBuilder_.mergeFrom(value);
      }
      if (autoscaling_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    public Builder clearAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00400000);
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    public com.google.container.v1.ClusterAutoscaling.Builder getAutoscalingBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    public com.google.container.v1.ClusterAutoscalingOrBuilder getAutoscalingOrBuilder() {
      if (autoscalingBuilder_ != null) {
        return autoscalingBuilder_.getMessageOrBuilder();
      } else {
        return autoscaling_ == null
            ? com.google.container.v1.ClusterAutoscaling.getDefaultInstance()
            : autoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.ClusterAutoscaling autoscaling = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ClusterAutoscaling,
            com.google.container.v1.ClusterAutoscaling.Builder,
            com.google.container.v1.ClusterAutoscalingOrBuilder>
        getAutoscalingFieldBuilder() {
      if (autoscalingBuilder_ == null) {
        autoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ClusterAutoscaling,
                com.google.container.v1.ClusterAutoscaling.Builder,
                com.google.container.v1.ClusterAutoscalingOrBuilder>(
                getAutoscaling(), getParentForChildren(), isClean());
        autoscaling_ = null;
      }
      return autoscalingBuilder_;
    }

    private com.google.container.v1.NetworkConfig networkConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NetworkConfig,
            com.google.container.v1.NetworkConfig.Builder,
            com.google.container.v1.NetworkConfigOrBuilder>
        networkConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     *
     * @return Whether the networkConfig field is set.
     */
    public boolean hasNetworkConfig() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     *
     * @return The networkConfig.
     */
    public com.google.container.v1.NetworkConfig getNetworkConfig() {
      if (networkConfigBuilder_ == null) {
        return networkConfig_ == null
            ? com.google.container.v1.NetworkConfig.getDefaultInstance()
            : networkConfig_;
      } else {
        return networkConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    public Builder setNetworkConfig(com.google.container.v1.NetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkConfig_ = value;
      } else {
        networkConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    public Builder setNetworkConfig(com.google.container.v1.NetworkConfig.Builder builderForValue) {
      if (networkConfigBuilder_ == null) {
        networkConfig_ = builderForValue.build();
      } else {
        networkConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    public Builder mergeNetworkConfig(com.google.container.v1.NetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && networkConfig_ != null
            && networkConfig_ != com.google.container.v1.NetworkConfig.getDefaultInstance()) {
          getNetworkConfigBuilder().mergeFrom(value);
        } else {
          networkConfig_ = value;
        }
      } else {
        networkConfigBuilder_.mergeFrom(value);
      }
      if (networkConfig_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    public Builder clearNetworkConfig() {
      bitField0_ = (bitField0_ & ~0x00800000);
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    public com.google.container.v1.NetworkConfig.Builder getNetworkConfigBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getNetworkConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    public com.google.container.v1.NetworkConfigOrBuilder getNetworkConfigOrBuilder() {
      if (networkConfigBuilder_ != null) {
        return networkConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkConfig_ == null
            ? com.google.container.v1.NetworkConfig.getDefaultInstance()
            : networkConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for cluster networking.
     * </pre>
     *
     * <code>.google.container.v1.NetworkConfig network_config = 27;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NetworkConfig,
            com.google.container.v1.NetworkConfig.Builder,
            com.google.container.v1.NetworkConfigOrBuilder>
        getNetworkConfigFieldBuilder() {
      if (networkConfigBuilder_ == null) {
        networkConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NetworkConfig,
                com.google.container.v1.NetworkConfig.Builder,
                com.google.container.v1.NetworkConfigOrBuilder>(
                getNetworkConfig(), getParentForChildren(), isClean());
        networkConfig_ = null;
      }
      return networkConfigBuilder_;
    }

    private com.google.container.v1.MaxPodsConstraint defaultMaxPodsConstraint_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MaxPodsConstraint,
            com.google.container.v1.MaxPodsConstraint.Builder,
            com.google.container.v1.MaxPodsConstraintOrBuilder>
        defaultMaxPodsConstraintBuilder_;
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     *
     * @return Whether the defaultMaxPodsConstraint field is set.
     */
    public boolean hasDefaultMaxPodsConstraint() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     *
     * @return The defaultMaxPodsConstraint.
     */
    public com.google.container.v1.MaxPodsConstraint getDefaultMaxPodsConstraint() {
      if (defaultMaxPodsConstraintBuilder_ == null) {
        return defaultMaxPodsConstraint_ == null
            ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
            : defaultMaxPodsConstraint_;
      } else {
        return defaultMaxPodsConstraintBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    public Builder setDefaultMaxPodsConstraint(com.google.container.v1.MaxPodsConstraint value) {
      if (defaultMaxPodsConstraintBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultMaxPodsConstraint_ = value;
      } else {
        defaultMaxPodsConstraintBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    public Builder setDefaultMaxPodsConstraint(
        com.google.container.v1.MaxPodsConstraint.Builder builderForValue) {
      if (defaultMaxPodsConstraintBuilder_ == null) {
        defaultMaxPodsConstraint_ = builderForValue.build();
      } else {
        defaultMaxPodsConstraintBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    public Builder mergeDefaultMaxPodsConstraint(com.google.container.v1.MaxPodsConstraint value) {
      if (defaultMaxPodsConstraintBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && defaultMaxPodsConstraint_ != null
            && defaultMaxPodsConstraint_
                != com.google.container.v1.MaxPodsConstraint.getDefaultInstance()) {
          getDefaultMaxPodsConstraintBuilder().mergeFrom(value);
        } else {
          defaultMaxPodsConstraint_ = value;
        }
      } else {
        defaultMaxPodsConstraintBuilder_.mergeFrom(value);
      }
      if (defaultMaxPodsConstraint_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    public Builder clearDefaultMaxPodsConstraint() {
      bitField0_ = (bitField0_ & ~0x01000000);
      defaultMaxPodsConstraint_ = null;
      if (defaultMaxPodsConstraintBuilder_ != null) {
        defaultMaxPodsConstraintBuilder_.dispose();
        defaultMaxPodsConstraintBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    public com.google.container.v1.MaxPodsConstraint.Builder getDefaultMaxPodsConstraintBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getDefaultMaxPodsConstraintFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    public com.google.container.v1.MaxPodsConstraintOrBuilder
        getDefaultMaxPodsConstraintOrBuilder() {
      if (defaultMaxPodsConstraintBuilder_ != null) {
        return defaultMaxPodsConstraintBuilder_.getMessageOrBuilder();
      } else {
        return defaultMaxPodsConstraint_ == null
            ? com.google.container.v1.MaxPodsConstraint.getDefaultInstance()
            : defaultMaxPodsConstraint_;
      }
    }
    /**
     *
     *
     * <pre>
     * The default constraint on the maximum number of pods that can be run
     * simultaneously on a node in the node pool of this cluster. Only honored
     * if cluster created with IP Alias support.
     * </pre>
     *
     * <code>.google.container.v1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MaxPodsConstraint,
            com.google.container.v1.MaxPodsConstraint.Builder,
            com.google.container.v1.MaxPodsConstraintOrBuilder>
        getDefaultMaxPodsConstraintFieldBuilder() {
      if (defaultMaxPodsConstraintBuilder_ == null) {
        defaultMaxPodsConstraintBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MaxPodsConstraint,
                com.google.container.v1.MaxPodsConstraint.Builder,
                com.google.container.v1.MaxPodsConstraintOrBuilder>(
                getDefaultMaxPodsConstraint(), getParentForChildren(), isClean());
        defaultMaxPodsConstraint_ = null;
      }
      return defaultMaxPodsConstraintBuilder_;
    }

    private com.google.container.v1.ResourceUsageExportConfig resourceUsageExportConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceUsageExportConfig,
            com.google.container.v1.ResourceUsageExportConfig.Builder,
            com.google.container.v1.ResourceUsageExportConfigOrBuilder>
        resourceUsageExportConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     *
     * @return Whether the resourceUsageExportConfig field is set.
     */
    public boolean hasResourceUsageExportConfig() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     *
     * @return The resourceUsageExportConfig.
     */
    public com.google.container.v1.ResourceUsageExportConfig getResourceUsageExportConfig() {
      if (resourceUsageExportConfigBuilder_ == null) {
        return resourceUsageExportConfig_ == null
            ? com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance()
            : resourceUsageExportConfig_;
      } else {
        return resourceUsageExportConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    public Builder setResourceUsageExportConfig(
        com.google.container.v1.ResourceUsageExportConfig value) {
      if (resourceUsageExportConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceUsageExportConfig_ = value;
      } else {
        resourceUsageExportConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    public Builder setResourceUsageExportConfig(
        com.google.container.v1.ResourceUsageExportConfig.Builder builderForValue) {
      if (resourceUsageExportConfigBuilder_ == null) {
        resourceUsageExportConfig_ = builderForValue.build();
      } else {
        resourceUsageExportConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    public Builder mergeResourceUsageExportConfig(
        com.google.container.v1.ResourceUsageExportConfig value) {
      if (resourceUsageExportConfigBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && resourceUsageExportConfig_ != null
            && resourceUsageExportConfig_
                != com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance()) {
          getResourceUsageExportConfigBuilder().mergeFrom(value);
        } else {
          resourceUsageExportConfig_ = value;
        }
      } else {
        resourceUsageExportConfigBuilder_.mergeFrom(value);
      }
      if (resourceUsageExportConfig_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    public Builder clearResourceUsageExportConfig() {
      bitField0_ = (bitField0_ & ~0x02000000);
      resourceUsageExportConfig_ = null;
      if (resourceUsageExportConfigBuilder_ != null) {
        resourceUsageExportConfigBuilder_.dispose();
        resourceUsageExportConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    public com.google.container.v1.ResourceUsageExportConfig.Builder
        getResourceUsageExportConfigBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getResourceUsageExportConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    public com.google.container.v1.ResourceUsageExportConfigOrBuilder
        getResourceUsageExportConfigOrBuilder() {
      if (resourceUsageExportConfigBuilder_ != null) {
        return resourceUsageExportConfigBuilder_.getMessageOrBuilder();
      } else {
        return resourceUsageExportConfig_ == null
            ? com.google.container.v1.ResourceUsageExportConfig.getDefaultInstance()
            : resourceUsageExportConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for exporting resource usages. Resource usage export is
     * disabled when this config is unspecified.
     * </pre>
     *
     * <code>.google.container.v1.ResourceUsageExportConfig resource_usage_export_config = 33;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ResourceUsageExportConfig,
            com.google.container.v1.ResourceUsageExportConfig.Builder,
            com.google.container.v1.ResourceUsageExportConfigOrBuilder>
        getResourceUsageExportConfigFieldBuilder() {
      if (resourceUsageExportConfigBuilder_ == null) {
        resourceUsageExportConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ResourceUsageExportConfig,
                com.google.container.v1.ResourceUsageExportConfig.Builder,
                com.google.container.v1.ResourceUsageExportConfigOrBuilder>(
                getResourceUsageExportConfig(), getParentForChildren(), isClean());
        resourceUsageExportConfig_ = null;
      }
      return resourceUsageExportConfigBuilder_;
    }

    private com.google.container.v1.AuthenticatorGroupsConfig authenticatorGroupsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AuthenticatorGroupsConfig,
            com.google.container.v1.AuthenticatorGroupsConfig.Builder,
            com.google.container.v1.AuthenticatorGroupsConfigOrBuilder>
        authenticatorGroupsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     *
     * @return Whether the authenticatorGroupsConfig field is set.
     */
    public boolean hasAuthenticatorGroupsConfig() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     *
     * @return The authenticatorGroupsConfig.
     */
    public com.google.container.v1.AuthenticatorGroupsConfig getAuthenticatorGroupsConfig() {
      if (authenticatorGroupsConfigBuilder_ == null) {
        return authenticatorGroupsConfig_ == null
            ? com.google.container.v1.AuthenticatorGroupsConfig.getDefaultInstance()
            : authenticatorGroupsConfig_;
      } else {
        return authenticatorGroupsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    public Builder setAuthenticatorGroupsConfig(
        com.google.container.v1.AuthenticatorGroupsConfig value) {
      if (authenticatorGroupsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authenticatorGroupsConfig_ = value;
      } else {
        authenticatorGroupsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    public Builder setAuthenticatorGroupsConfig(
        com.google.container.v1.AuthenticatorGroupsConfig.Builder builderForValue) {
      if (authenticatorGroupsConfigBuilder_ == null) {
        authenticatorGroupsConfig_ = builderForValue.build();
      } else {
        authenticatorGroupsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    public Builder mergeAuthenticatorGroupsConfig(
        com.google.container.v1.AuthenticatorGroupsConfig value) {
      if (authenticatorGroupsConfigBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && authenticatorGroupsConfig_ != null
            && authenticatorGroupsConfig_
                != com.google.container.v1.AuthenticatorGroupsConfig.getDefaultInstance()) {
          getAuthenticatorGroupsConfigBuilder().mergeFrom(value);
        } else {
          authenticatorGroupsConfig_ = value;
        }
      } else {
        authenticatorGroupsConfigBuilder_.mergeFrom(value);
      }
      if (authenticatorGroupsConfig_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    public Builder clearAuthenticatorGroupsConfig() {
      bitField0_ = (bitField0_ & ~0x04000000);
      authenticatorGroupsConfig_ = null;
      if (authenticatorGroupsConfigBuilder_ != null) {
        authenticatorGroupsConfigBuilder_.dispose();
        authenticatorGroupsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    public com.google.container.v1.AuthenticatorGroupsConfig.Builder
        getAuthenticatorGroupsConfigBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getAuthenticatorGroupsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    public com.google.container.v1.AuthenticatorGroupsConfigOrBuilder
        getAuthenticatorGroupsConfigOrBuilder() {
      if (authenticatorGroupsConfigBuilder_ != null) {
        return authenticatorGroupsConfigBuilder_.getMessageOrBuilder();
      } else {
        return authenticatorGroupsConfig_ == null
            ? com.google.container.v1.AuthenticatorGroupsConfig.getDefaultInstance()
            : authenticatorGroupsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling RBAC group membership information.
     * </pre>
     *
     * <code>.google.container.v1.AuthenticatorGroupsConfig authenticator_groups_config = 34;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.AuthenticatorGroupsConfig,
            com.google.container.v1.AuthenticatorGroupsConfig.Builder,
            com.google.container.v1.AuthenticatorGroupsConfigOrBuilder>
        getAuthenticatorGroupsConfigFieldBuilder() {
      if (authenticatorGroupsConfigBuilder_ == null) {
        authenticatorGroupsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.AuthenticatorGroupsConfig,
                com.google.container.v1.AuthenticatorGroupsConfig.Builder,
                com.google.container.v1.AuthenticatorGroupsConfigOrBuilder>(
                getAuthenticatorGroupsConfig(), getParentForChildren(), isClean());
        authenticatorGroupsConfig_ = null;
      }
      return authenticatorGroupsConfigBuilder_;
    }

    private com.google.container.v1.PrivateClusterConfig privateClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.PrivateClusterConfig,
            com.google.container.v1.PrivateClusterConfig.Builder,
            com.google.container.v1.PrivateClusterConfigOrBuilder>
        privateClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     *
     * @return Whether the privateClusterConfig field is set.
     */
    public boolean hasPrivateClusterConfig() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     *
     * @return The privateClusterConfig.
     */
    public com.google.container.v1.PrivateClusterConfig getPrivateClusterConfig() {
      if (privateClusterConfigBuilder_ == null) {
        return privateClusterConfig_ == null
            ? com.google.container.v1.PrivateClusterConfig.getDefaultInstance()
            : privateClusterConfig_;
      } else {
        return privateClusterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    public Builder setPrivateClusterConfig(com.google.container.v1.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateClusterConfig_ = value;
      } else {
        privateClusterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    public Builder setPrivateClusterConfig(
        com.google.container.v1.PrivateClusterConfig.Builder builderForValue) {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfig_ = builderForValue.build();
      } else {
        privateClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    public Builder mergePrivateClusterConfig(com.google.container.v1.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && privateClusterConfig_ != null
            && privateClusterConfig_
                != com.google.container.v1.PrivateClusterConfig.getDefaultInstance()) {
          getPrivateClusterConfigBuilder().mergeFrom(value);
        } else {
          privateClusterConfig_ = value;
        }
      } else {
        privateClusterConfigBuilder_.mergeFrom(value);
      }
      if (privateClusterConfig_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    public Builder clearPrivateClusterConfig() {
      bitField0_ = (bitField0_ & ~0x08000000);
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    public com.google.container.v1.PrivateClusterConfig.Builder getPrivateClusterConfigBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getPrivateClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    public com.google.container.v1.PrivateClusterConfigOrBuilder
        getPrivateClusterConfigOrBuilder() {
      if (privateClusterConfigBuilder_ != null) {
        return privateClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateClusterConfig_ == null
            ? com.google.container.v1.PrivateClusterConfig.getDefaultInstance()
            : privateClusterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for private cluster.
     * </pre>
     *
     * <code>.google.container.v1.PrivateClusterConfig private_cluster_config = 37;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.PrivateClusterConfig,
            com.google.container.v1.PrivateClusterConfig.Builder,
            com.google.container.v1.PrivateClusterConfigOrBuilder>
        getPrivateClusterConfigFieldBuilder() {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.PrivateClusterConfig,
                com.google.container.v1.PrivateClusterConfig.Builder,
                com.google.container.v1.PrivateClusterConfigOrBuilder>(
                getPrivateClusterConfig(), getParentForChildren(), isClean());
        privateClusterConfig_ = null;
      }
      return privateClusterConfigBuilder_;
    }

    private com.google.container.v1.DatabaseEncryption databaseEncryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.DatabaseEncryption,
            com.google.container.v1.DatabaseEncryption.Builder,
            com.google.container.v1.DatabaseEncryptionOrBuilder>
        databaseEncryptionBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     *
     * @return Whether the databaseEncryption field is set.
     */
    public boolean hasDatabaseEncryption() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     *
     * @return The databaseEncryption.
     */
    public com.google.container.v1.DatabaseEncryption getDatabaseEncryption() {
      if (databaseEncryptionBuilder_ == null) {
        return databaseEncryption_ == null
            ? com.google.container.v1.DatabaseEncryption.getDefaultInstance()
            : databaseEncryption_;
      } else {
        return databaseEncryptionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    public Builder setDatabaseEncryption(com.google.container.v1.DatabaseEncryption value) {
      if (databaseEncryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        databaseEncryption_ = value;
      } else {
        databaseEncryptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    public Builder setDatabaseEncryption(
        com.google.container.v1.DatabaseEncryption.Builder builderForValue) {
      if (databaseEncryptionBuilder_ == null) {
        databaseEncryption_ = builderForValue.build();
      } else {
        databaseEncryptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    public Builder mergeDatabaseEncryption(com.google.container.v1.DatabaseEncryption value) {
      if (databaseEncryptionBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && databaseEncryption_ != null
            && databaseEncryption_
                != com.google.container.v1.DatabaseEncryption.getDefaultInstance()) {
          getDatabaseEncryptionBuilder().mergeFrom(value);
        } else {
          databaseEncryption_ = value;
        }
      } else {
        databaseEncryptionBuilder_.mergeFrom(value);
      }
      if (databaseEncryption_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    public Builder clearDatabaseEncryption() {
      bitField0_ = (bitField0_ & ~0x10000000);
      databaseEncryption_ = null;
      if (databaseEncryptionBuilder_ != null) {
        databaseEncryptionBuilder_.dispose();
        databaseEncryptionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    public com.google.container.v1.DatabaseEncryption.Builder getDatabaseEncryptionBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getDatabaseEncryptionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    public com.google.container.v1.DatabaseEncryptionOrBuilder getDatabaseEncryptionOrBuilder() {
      if (databaseEncryptionBuilder_ != null) {
        return databaseEncryptionBuilder_.getMessageOrBuilder();
      } else {
        return databaseEncryption_ == null
            ? com.google.container.v1.DatabaseEncryption.getDefaultInstance()
            : databaseEncryption_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1.DatabaseEncryption database_encryption = 38;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.DatabaseEncryption,
            com.google.container.v1.DatabaseEncryption.Builder,
            com.google.container.v1.DatabaseEncryptionOrBuilder>
        getDatabaseEncryptionFieldBuilder() {
      if (databaseEncryptionBuilder_ == null) {
        databaseEncryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.DatabaseEncryption,
                com.google.container.v1.DatabaseEncryption.Builder,
                com.google.container.v1.DatabaseEncryptionOrBuilder>(
                getDatabaseEncryption(), getParentForChildren(), isClean());
        databaseEncryption_ = null;
      }
      return databaseEncryptionBuilder_;
    }

    private com.google.container.v1.VerticalPodAutoscaling verticalPodAutoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.VerticalPodAutoscaling,
            com.google.container.v1.VerticalPodAutoscaling.Builder,
            com.google.container.v1.VerticalPodAutoscalingOrBuilder>
        verticalPodAutoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     *
     * @return Whether the verticalPodAutoscaling field is set.
     */
    public boolean hasVerticalPodAutoscaling() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     *
     * @return The verticalPodAutoscaling.
     */
    public com.google.container.v1.VerticalPodAutoscaling getVerticalPodAutoscaling() {
      if (verticalPodAutoscalingBuilder_ == null) {
        return verticalPodAutoscaling_ == null
            ? com.google.container.v1.VerticalPodAutoscaling.getDefaultInstance()
            : verticalPodAutoscaling_;
      } else {
        return verticalPodAutoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    public Builder setVerticalPodAutoscaling(com.google.container.v1.VerticalPodAutoscaling value) {
      if (verticalPodAutoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        verticalPodAutoscaling_ = value;
      } else {
        verticalPodAutoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    public Builder setVerticalPodAutoscaling(
        com.google.container.v1.VerticalPodAutoscaling.Builder builderForValue) {
      if (verticalPodAutoscalingBuilder_ == null) {
        verticalPodAutoscaling_ = builderForValue.build();
      } else {
        verticalPodAutoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    public Builder mergeVerticalPodAutoscaling(
        com.google.container.v1.VerticalPodAutoscaling value) {
      if (verticalPodAutoscalingBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && verticalPodAutoscaling_ != null
            && verticalPodAutoscaling_
                != com.google.container.v1.VerticalPodAutoscaling.getDefaultInstance()) {
          getVerticalPodAutoscalingBuilder().mergeFrom(value);
        } else {
          verticalPodAutoscaling_ = value;
        }
      } else {
        verticalPodAutoscalingBuilder_.mergeFrom(value);
      }
      if (verticalPodAutoscaling_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    public Builder clearVerticalPodAutoscaling() {
      bitField0_ = (bitField0_ & ~0x20000000);
      verticalPodAutoscaling_ = null;
      if (verticalPodAutoscalingBuilder_ != null) {
        verticalPodAutoscalingBuilder_.dispose();
        verticalPodAutoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    public com.google.container.v1.VerticalPodAutoscaling.Builder
        getVerticalPodAutoscalingBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getVerticalPodAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    public com.google.container.v1.VerticalPodAutoscalingOrBuilder
        getVerticalPodAutoscalingOrBuilder() {
      if (verticalPodAutoscalingBuilder_ != null) {
        return verticalPodAutoscalingBuilder_.getMessageOrBuilder();
      } else {
        return verticalPodAutoscaling_ == null
            ? com.google.container.v1.VerticalPodAutoscaling.getDefaultInstance()
            : verticalPodAutoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.VerticalPodAutoscaling,
            com.google.container.v1.VerticalPodAutoscaling.Builder,
            com.google.container.v1.VerticalPodAutoscalingOrBuilder>
        getVerticalPodAutoscalingFieldBuilder() {
      if (verticalPodAutoscalingBuilder_ == null) {
        verticalPodAutoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.VerticalPodAutoscaling,
                com.google.container.v1.VerticalPodAutoscaling.Builder,
                com.google.container.v1.VerticalPodAutoscalingOrBuilder>(
                getVerticalPodAutoscaling(), getParentForChildren(), isClean());
        verticalPodAutoscaling_ = null;
      }
      return verticalPodAutoscalingBuilder_;
    }

    private com.google.container.v1.ShieldedNodes shieldedNodes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ShieldedNodes,
            com.google.container.v1.ShieldedNodes.Builder,
            com.google.container.v1.ShieldedNodesOrBuilder>
        shieldedNodesBuilder_;
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     *
     * @return Whether the shieldedNodes field is set.
     */
    public boolean hasShieldedNodes() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     *
     * @return The shieldedNodes.
     */
    public com.google.container.v1.ShieldedNodes getShieldedNodes() {
      if (shieldedNodesBuilder_ == null) {
        return shieldedNodes_ == null
            ? com.google.container.v1.ShieldedNodes.getDefaultInstance()
            : shieldedNodes_;
      } else {
        return shieldedNodesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    public Builder setShieldedNodes(com.google.container.v1.ShieldedNodes value) {
      if (shieldedNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedNodes_ = value;
      } else {
        shieldedNodesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    public Builder setShieldedNodes(com.google.container.v1.ShieldedNodes.Builder builderForValue) {
      if (shieldedNodesBuilder_ == null) {
        shieldedNodes_ = builderForValue.build();
      } else {
        shieldedNodesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    public Builder mergeShieldedNodes(com.google.container.v1.ShieldedNodes value) {
      if (shieldedNodesBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && shieldedNodes_ != null
            && shieldedNodes_ != com.google.container.v1.ShieldedNodes.getDefaultInstance()) {
          getShieldedNodesBuilder().mergeFrom(value);
        } else {
          shieldedNodes_ = value;
        }
      } else {
        shieldedNodesBuilder_.mergeFrom(value);
      }
      if (shieldedNodes_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    public Builder clearShieldedNodes() {
      bitField0_ = (bitField0_ & ~0x40000000);
      shieldedNodes_ = null;
      if (shieldedNodesBuilder_ != null) {
        shieldedNodesBuilder_.dispose();
        shieldedNodesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    public com.google.container.v1.ShieldedNodes.Builder getShieldedNodesBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getShieldedNodesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    public com.google.container.v1.ShieldedNodesOrBuilder getShieldedNodesOrBuilder() {
      if (shieldedNodesBuilder_ != null) {
        return shieldedNodesBuilder_.getMessageOrBuilder();
      } else {
        return shieldedNodes_ == null
            ? com.google.container.v1.ShieldedNodes.getDefaultInstance()
            : shieldedNodes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Shielded Nodes configuration.
     * </pre>
     *
     * <code>.google.container.v1.ShieldedNodes shielded_nodes = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ShieldedNodes,
            com.google.container.v1.ShieldedNodes.Builder,
            com.google.container.v1.ShieldedNodesOrBuilder>
        getShieldedNodesFieldBuilder() {
      if (shieldedNodesBuilder_ == null) {
        shieldedNodesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ShieldedNodes,
                com.google.container.v1.ShieldedNodes.Builder,
                com.google.container.v1.ShieldedNodesOrBuilder>(
                getShieldedNodes(), getParentForChildren(), isClean());
        shieldedNodes_ = null;
      }
      return shieldedNodesBuilder_;
    }

    private com.google.container.v1.ReleaseChannel releaseChannel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ReleaseChannel,
            com.google.container.v1.ReleaseChannel.Builder,
            com.google.container.v1.ReleaseChannelOrBuilder>
        releaseChannelBuilder_;
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     *
     * @return Whether the releaseChannel field is set.
     */
    public boolean hasReleaseChannel() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     *
     * @return The releaseChannel.
     */
    public com.google.container.v1.ReleaseChannel getReleaseChannel() {
      if (releaseChannelBuilder_ == null) {
        return releaseChannel_ == null
            ? com.google.container.v1.ReleaseChannel.getDefaultInstance()
            : releaseChannel_;
      } else {
        return releaseChannelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    public Builder setReleaseChannel(com.google.container.v1.ReleaseChannel value) {
      if (releaseChannelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        releaseChannel_ = value;
      } else {
        releaseChannelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    public Builder setReleaseChannel(
        com.google.container.v1.ReleaseChannel.Builder builderForValue) {
      if (releaseChannelBuilder_ == null) {
        releaseChannel_ = builderForValue.build();
      } else {
        releaseChannelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    public Builder mergeReleaseChannel(com.google.container.v1.ReleaseChannel value) {
      if (releaseChannelBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && releaseChannel_ != null
            && releaseChannel_ != com.google.container.v1.ReleaseChannel.getDefaultInstance()) {
          getReleaseChannelBuilder().mergeFrom(value);
        } else {
          releaseChannel_ = value;
        }
      } else {
        releaseChannelBuilder_.mergeFrom(value);
      }
      if (releaseChannel_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    public Builder clearReleaseChannel() {
      bitField0_ = (bitField0_ & ~0x80000000);
      releaseChannel_ = null;
      if (releaseChannelBuilder_ != null) {
        releaseChannelBuilder_.dispose();
        releaseChannelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    public com.google.container.v1.ReleaseChannel.Builder getReleaseChannelBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getReleaseChannelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    public com.google.container.v1.ReleaseChannelOrBuilder getReleaseChannelOrBuilder() {
      if (releaseChannelBuilder_ != null) {
        return releaseChannelBuilder_.getMessageOrBuilder();
      } else {
        return releaseChannel_ == null
            ? com.google.container.v1.ReleaseChannel.getDefaultInstance()
            : releaseChannel_;
      }
    }
    /**
     *
     *
     * <pre>
     * Release channel configuration. If left unspecified on cluster creation and
     * a version is specified, the cluster is enrolled in the most mature release
     * channel where the version is available (first checking STABLE, then
     * REGULAR, and finally RAPID). Otherwise, if no release channel
     * configuration and no version is specified, the cluster is enrolled in the
     * REGULAR channel with its default version.
     * </pre>
     *
     * <code>.google.container.v1.ReleaseChannel release_channel = 41;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ReleaseChannel,
            com.google.container.v1.ReleaseChannel.Builder,
            com.google.container.v1.ReleaseChannelOrBuilder>
        getReleaseChannelFieldBuilder() {
      if (releaseChannelBuilder_ == null) {
        releaseChannelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ReleaseChannel,
                com.google.container.v1.ReleaseChannel.Builder,
                com.google.container.v1.ReleaseChannelOrBuilder>(
                getReleaseChannel(), getParentForChildren(), isClean());
        releaseChannel_ = null;
      }
      return releaseChannelBuilder_;
    }

    private com.google.container.v1.WorkloadIdentityConfig workloadIdentityConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WorkloadIdentityConfig,
            com.google.container.v1.WorkloadIdentityConfig.Builder,
            com.google.container.v1.WorkloadIdentityConfigOrBuilder>
        workloadIdentityConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     *
     * @return Whether the workloadIdentityConfig field is set.
     */
    public boolean hasWorkloadIdentityConfig() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     *
     * @return The workloadIdentityConfig.
     */
    public com.google.container.v1.WorkloadIdentityConfig getWorkloadIdentityConfig() {
      if (workloadIdentityConfigBuilder_ == null) {
        return workloadIdentityConfig_ == null
            ? com.google.container.v1.WorkloadIdentityConfig.getDefaultInstance()
            : workloadIdentityConfig_;
      } else {
        return workloadIdentityConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    public Builder setWorkloadIdentityConfig(com.google.container.v1.WorkloadIdentityConfig value) {
      if (workloadIdentityConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workloadIdentityConfig_ = value;
      } else {
        workloadIdentityConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    public Builder setWorkloadIdentityConfig(
        com.google.container.v1.WorkloadIdentityConfig.Builder builderForValue) {
      if (workloadIdentityConfigBuilder_ == null) {
        workloadIdentityConfig_ = builderForValue.build();
      } else {
        workloadIdentityConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    public Builder mergeWorkloadIdentityConfig(
        com.google.container.v1.WorkloadIdentityConfig value) {
      if (workloadIdentityConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)
            && workloadIdentityConfig_ != null
            && workloadIdentityConfig_
                != com.google.container.v1.WorkloadIdentityConfig.getDefaultInstance()) {
          getWorkloadIdentityConfigBuilder().mergeFrom(value);
        } else {
          workloadIdentityConfig_ = value;
        }
      } else {
        workloadIdentityConfigBuilder_.mergeFrom(value);
      }
      if (workloadIdentityConfig_ != null) {
        bitField1_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    public Builder clearWorkloadIdentityConfig() {
      bitField1_ = (bitField1_ & ~0x00000001);
      workloadIdentityConfig_ = null;
      if (workloadIdentityConfigBuilder_ != null) {
        workloadIdentityConfigBuilder_.dispose();
        workloadIdentityConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    public com.google.container.v1.WorkloadIdentityConfig.Builder
        getWorkloadIdentityConfigBuilder() {
      bitField1_ |= 0x00000001;
      onChanged();
      return getWorkloadIdentityConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    public com.google.container.v1.WorkloadIdentityConfigOrBuilder
        getWorkloadIdentityConfigOrBuilder() {
      if (workloadIdentityConfigBuilder_ != null) {
        return workloadIdentityConfigBuilder_.getMessageOrBuilder();
      } else {
        return workloadIdentityConfig_ == null
            ? com.google.container.v1.WorkloadIdentityConfig.getDefaultInstance()
            : workloadIdentityConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the use of Kubernetes Service Accounts in GCP IAM
     * policies.
     * </pre>
     *
     * <code>.google.container.v1.WorkloadIdentityConfig workload_identity_config = 43;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.WorkloadIdentityConfig,
            com.google.container.v1.WorkloadIdentityConfig.Builder,
            com.google.container.v1.WorkloadIdentityConfigOrBuilder>
        getWorkloadIdentityConfigFieldBuilder() {
      if (workloadIdentityConfigBuilder_ == null) {
        workloadIdentityConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.WorkloadIdentityConfig,
                com.google.container.v1.WorkloadIdentityConfig.Builder,
                com.google.container.v1.WorkloadIdentityConfigOrBuilder>(
                getWorkloadIdentityConfig(), getParentForChildren(), isClean());
        workloadIdentityConfig_ = null;
      }
      return workloadIdentityConfigBuilder_;
    }

    private com.google.container.v1.MeshCertificates meshCertificates_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MeshCertificates,
            com.google.container.v1.MeshCertificates.Builder,
            com.google.container.v1.MeshCertificatesOrBuilder>
        meshCertificatesBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     *
     * @return Whether the meshCertificates field is set.
     */
    public boolean hasMeshCertificates() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     *
     * @return The meshCertificates.
     */
    public com.google.container.v1.MeshCertificates getMeshCertificates() {
      if (meshCertificatesBuilder_ == null) {
        return meshCertificates_ == null
            ? com.google.container.v1.MeshCertificates.getDefaultInstance()
            : meshCertificates_;
      } else {
        return meshCertificatesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    public Builder setMeshCertificates(com.google.container.v1.MeshCertificates value) {
      if (meshCertificatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        meshCertificates_ = value;
      } else {
        meshCertificatesBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    public Builder setMeshCertificates(
        com.google.container.v1.MeshCertificates.Builder builderForValue) {
      if (meshCertificatesBuilder_ == null) {
        meshCertificates_ = builderForValue.build();
      } else {
        meshCertificatesBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    public Builder mergeMeshCertificates(com.google.container.v1.MeshCertificates value) {
      if (meshCertificatesBuilder_ == null) {
        if (((bitField1_ & 0x00000002) != 0)
            && meshCertificates_ != null
            && meshCertificates_ != com.google.container.v1.MeshCertificates.getDefaultInstance()) {
          getMeshCertificatesBuilder().mergeFrom(value);
        } else {
          meshCertificates_ = value;
        }
      } else {
        meshCertificatesBuilder_.mergeFrom(value);
      }
      if (meshCertificates_ != null) {
        bitField1_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    public Builder clearMeshCertificates() {
      bitField1_ = (bitField1_ & ~0x00000002);
      meshCertificates_ = null;
      if (meshCertificatesBuilder_ != null) {
        meshCertificatesBuilder_.dispose();
        meshCertificatesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    public com.google.container.v1.MeshCertificates.Builder getMeshCertificatesBuilder() {
      bitField1_ |= 0x00000002;
      onChanged();
      return getMeshCertificatesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    public com.google.container.v1.MeshCertificatesOrBuilder getMeshCertificatesOrBuilder() {
      if (meshCertificatesBuilder_ != null) {
        return meshCertificatesBuilder_.getMessageOrBuilder();
      } else {
        return meshCertificates_ == null
            ? com.google.container.v1.MeshCertificates.getDefaultInstance()
            : meshCertificates_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1.MeshCertificates mesh_certificates = 67;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MeshCertificates,
            com.google.container.v1.MeshCertificates.Builder,
            com.google.container.v1.MeshCertificatesOrBuilder>
        getMeshCertificatesFieldBuilder() {
      if (meshCertificatesBuilder_ == null) {
        meshCertificatesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MeshCertificates,
                com.google.container.v1.MeshCertificates.Builder,
                com.google.container.v1.MeshCertificatesOrBuilder>(
                getMeshCertificates(), getParentForChildren(), isClean());
        meshCertificates_ = null;
      }
      return meshCertificatesBuilder_;
    }

    private com.google.container.v1.CostManagementConfig costManagementConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.CostManagementConfig,
            com.google.container.v1.CostManagementConfig.Builder,
            com.google.container.v1.CostManagementConfigOrBuilder>
        costManagementConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     *
     * @return Whether the costManagementConfig field is set.
     */
    public boolean hasCostManagementConfig() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     *
     * @return The costManagementConfig.
     */
    public com.google.container.v1.CostManagementConfig getCostManagementConfig() {
      if (costManagementConfigBuilder_ == null) {
        return costManagementConfig_ == null
            ? com.google.container.v1.CostManagementConfig.getDefaultInstance()
            : costManagementConfig_;
      } else {
        return costManagementConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    public Builder setCostManagementConfig(com.google.container.v1.CostManagementConfig value) {
      if (costManagementConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        costManagementConfig_ = value;
      } else {
        costManagementConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    public Builder setCostManagementConfig(
        com.google.container.v1.CostManagementConfig.Builder builderForValue) {
      if (costManagementConfigBuilder_ == null) {
        costManagementConfig_ = builderForValue.build();
      } else {
        costManagementConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    public Builder mergeCostManagementConfig(com.google.container.v1.CostManagementConfig value) {
      if (costManagementConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000004) != 0)
            && costManagementConfig_ != null
            && costManagementConfig_
                != com.google.container.v1.CostManagementConfig.getDefaultInstance()) {
          getCostManagementConfigBuilder().mergeFrom(value);
        } else {
          costManagementConfig_ = value;
        }
      } else {
        costManagementConfigBuilder_.mergeFrom(value);
      }
      if (costManagementConfig_ != null) {
        bitField1_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    public Builder clearCostManagementConfig() {
      bitField1_ = (bitField1_ & ~0x00000004);
      costManagementConfig_ = null;
      if (costManagementConfigBuilder_ != null) {
        costManagementConfigBuilder_.dispose();
        costManagementConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    public com.google.container.v1.CostManagementConfig.Builder getCostManagementConfigBuilder() {
      bitField1_ |= 0x00000004;
      onChanged();
      return getCostManagementConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    public com.google.container.v1.CostManagementConfigOrBuilder
        getCostManagementConfigOrBuilder() {
      if (costManagementConfigBuilder_ != null) {
        return costManagementConfigBuilder_.getMessageOrBuilder();
      } else {
        return costManagementConfig_ == null
            ? com.google.container.v1.CostManagementConfig.getDefaultInstance()
            : costManagementConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1.CostManagementConfig cost_management_config = 45;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.CostManagementConfig,
            com.google.container.v1.CostManagementConfig.Builder,
            com.google.container.v1.CostManagementConfigOrBuilder>
        getCostManagementConfigFieldBuilder() {
      if (costManagementConfigBuilder_ == null) {
        costManagementConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.CostManagementConfig,
                com.google.container.v1.CostManagementConfig.Builder,
                com.google.container.v1.CostManagementConfigOrBuilder>(
                getCostManagementConfig(), getParentForChildren(), isClean());
        costManagementConfig_ = null;
      }
      return costManagementConfigBuilder_;
    }

    private com.google.container.v1.NotificationConfig notificationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NotificationConfig,
            com.google.container.v1.NotificationConfig.Builder,
            com.google.container.v1.NotificationConfigOrBuilder>
        notificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     *
     * @return Whether the notificationConfig field is set.
     */
    public boolean hasNotificationConfig() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     *
     * @return The notificationConfig.
     */
    public com.google.container.v1.NotificationConfig getNotificationConfig() {
      if (notificationConfigBuilder_ == null) {
        return notificationConfig_ == null
            ? com.google.container.v1.NotificationConfig.getDefaultInstance()
            : notificationConfig_;
      } else {
        return notificationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    public Builder setNotificationConfig(com.google.container.v1.NotificationConfig value) {
      if (notificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notificationConfig_ = value;
      } else {
        notificationConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    public Builder setNotificationConfig(
        com.google.container.v1.NotificationConfig.Builder builderForValue) {
      if (notificationConfigBuilder_ == null) {
        notificationConfig_ = builderForValue.build();
      } else {
        notificationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    public Builder mergeNotificationConfig(com.google.container.v1.NotificationConfig value) {
      if (notificationConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000008) != 0)
            && notificationConfig_ != null
            && notificationConfig_
                != com.google.container.v1.NotificationConfig.getDefaultInstance()) {
          getNotificationConfigBuilder().mergeFrom(value);
        } else {
          notificationConfig_ = value;
        }
      } else {
        notificationConfigBuilder_.mergeFrom(value);
      }
      if (notificationConfig_ != null) {
        bitField1_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    public Builder clearNotificationConfig() {
      bitField1_ = (bitField1_ & ~0x00000008);
      notificationConfig_ = null;
      if (notificationConfigBuilder_ != null) {
        notificationConfigBuilder_.dispose();
        notificationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    public com.google.container.v1.NotificationConfig.Builder getNotificationConfigBuilder() {
      bitField1_ |= 0x00000008;
      onChanged();
      return getNotificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    public com.google.container.v1.NotificationConfigOrBuilder getNotificationConfigOrBuilder() {
      if (notificationConfigBuilder_ != null) {
        return notificationConfigBuilder_.getMessageOrBuilder();
      } else {
        return notificationConfig_ == null
            ? com.google.container.v1.NotificationConfig.getDefaultInstance()
            : notificationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Notification configuration of the cluster.
     * </pre>
     *
     * <code>.google.container.v1.NotificationConfig notification_config = 49;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NotificationConfig,
            com.google.container.v1.NotificationConfig.Builder,
            com.google.container.v1.NotificationConfigOrBuilder>
        getNotificationConfigFieldBuilder() {
      if (notificationConfigBuilder_ == null) {
        notificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NotificationConfig,
                com.google.container.v1.NotificationConfig.Builder,
                com.google.container.v1.NotificationConfigOrBuilder>(
                getNotificationConfig(), getParentForChildren(), isClean());
        notificationConfig_ = null;
      }
      return notificationConfigBuilder_;
    }

    private com.google.container.v1.ConfidentialNodes confidentialNodes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ConfidentialNodes,
            com.google.container.v1.ConfidentialNodes.Builder,
            com.google.container.v1.ConfidentialNodesOrBuilder>
        confidentialNodesBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     *
     * @return Whether the confidentialNodes field is set.
     */
    public boolean hasConfidentialNodes() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     *
     * @return The confidentialNodes.
     */
    public com.google.container.v1.ConfidentialNodes getConfidentialNodes() {
      if (confidentialNodesBuilder_ == null) {
        return confidentialNodes_ == null
            ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
            : confidentialNodes_;
      } else {
        return confidentialNodesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    public Builder setConfidentialNodes(com.google.container.v1.ConfidentialNodes value) {
      if (confidentialNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidentialNodes_ = value;
      } else {
        confidentialNodesBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    public Builder setConfidentialNodes(
        com.google.container.v1.ConfidentialNodes.Builder builderForValue) {
      if (confidentialNodesBuilder_ == null) {
        confidentialNodes_ = builderForValue.build();
      } else {
        confidentialNodesBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    public Builder mergeConfidentialNodes(com.google.container.v1.ConfidentialNodes value) {
      if (confidentialNodesBuilder_ == null) {
        if (((bitField1_ & 0x00000010) != 0)
            && confidentialNodes_ != null
            && confidentialNodes_
                != com.google.container.v1.ConfidentialNodes.getDefaultInstance()) {
          getConfidentialNodesBuilder().mergeFrom(value);
        } else {
          confidentialNodes_ = value;
        }
      } else {
        confidentialNodesBuilder_.mergeFrom(value);
      }
      if (confidentialNodes_ != null) {
        bitField1_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    public Builder clearConfidentialNodes() {
      bitField1_ = (bitField1_ & ~0x00000010);
      confidentialNodes_ = null;
      if (confidentialNodesBuilder_ != null) {
        confidentialNodesBuilder_.dispose();
        confidentialNodesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    public com.google.container.v1.ConfidentialNodes.Builder getConfidentialNodesBuilder() {
      bitField1_ |= 0x00000010;
      onChanged();
      return getConfidentialNodesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    public com.google.container.v1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder() {
      if (confidentialNodesBuilder_ != null) {
        return confidentialNodesBuilder_.getMessageOrBuilder();
      } else {
        return confidentialNodes_ == null
            ? com.google.container.v1.ConfidentialNodes.getDefaultInstance()
            : confidentialNodes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of Confidential Nodes.
     * All the nodes in the cluster will be Confidential VM once enabled.
     * </pre>
     *
     * <code>.google.container.v1.ConfidentialNodes confidential_nodes = 50;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ConfidentialNodes,
            com.google.container.v1.ConfidentialNodes.Builder,
            com.google.container.v1.ConfidentialNodesOrBuilder>
        getConfidentialNodesFieldBuilder() {
      if (confidentialNodesBuilder_ == null) {
        confidentialNodesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ConfidentialNodes,
                com.google.container.v1.ConfidentialNodes.Builder,
                com.google.container.v1.ConfidentialNodesOrBuilder>(
                getConfidentialNodes(), getParentForChildren(), isClean());
        confidentialNodes_ = null;
      }
      return confidentialNodesBuilder_;
    }

    private com.google.container.v1.IdentityServiceConfig identityServiceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.IdentityServiceConfig,
            com.google.container.v1.IdentityServiceConfig.Builder,
            com.google.container.v1.IdentityServiceConfigOrBuilder>
        identityServiceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     *
     * @return Whether the identityServiceConfig field is set.
     */
    public boolean hasIdentityServiceConfig() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     *
     * @return The identityServiceConfig.
     */
    public com.google.container.v1.IdentityServiceConfig getIdentityServiceConfig() {
      if (identityServiceConfigBuilder_ == null) {
        return identityServiceConfig_ == null
            ? com.google.container.v1.IdentityServiceConfig.getDefaultInstance()
            : identityServiceConfig_;
      } else {
        return identityServiceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    public Builder setIdentityServiceConfig(com.google.container.v1.IdentityServiceConfig value) {
      if (identityServiceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identityServiceConfig_ = value;
      } else {
        identityServiceConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    public Builder setIdentityServiceConfig(
        com.google.container.v1.IdentityServiceConfig.Builder builderForValue) {
      if (identityServiceConfigBuilder_ == null) {
        identityServiceConfig_ = builderForValue.build();
      } else {
        identityServiceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    public Builder mergeIdentityServiceConfig(com.google.container.v1.IdentityServiceConfig value) {
      if (identityServiceConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000020) != 0)
            && identityServiceConfig_ != null
            && identityServiceConfig_
                != com.google.container.v1.IdentityServiceConfig.getDefaultInstance()) {
          getIdentityServiceConfigBuilder().mergeFrom(value);
        } else {
          identityServiceConfig_ = value;
        }
      } else {
        identityServiceConfigBuilder_.mergeFrom(value);
      }
      if (identityServiceConfig_ != null) {
        bitField1_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    public Builder clearIdentityServiceConfig() {
      bitField1_ = (bitField1_ & ~0x00000020);
      identityServiceConfig_ = null;
      if (identityServiceConfigBuilder_ != null) {
        identityServiceConfigBuilder_.dispose();
        identityServiceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    public com.google.container.v1.IdentityServiceConfig.Builder getIdentityServiceConfigBuilder() {
      bitField1_ |= 0x00000020;
      onChanged();
      return getIdentityServiceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    public com.google.container.v1.IdentityServiceConfigOrBuilder
        getIdentityServiceConfigOrBuilder() {
      if (identityServiceConfigBuilder_ != null) {
        return identityServiceConfigBuilder_.getMessageOrBuilder();
      } else {
        return identityServiceConfig_ == null
            ? com.google.container.v1.IdentityServiceConfig.getDefaultInstance()
            : identityServiceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Identity Service component.
     * </pre>
     *
     * <code>.google.container.v1.IdentityServiceConfig identity_service_config = 54;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.IdentityServiceConfig,
            com.google.container.v1.IdentityServiceConfig.Builder,
            com.google.container.v1.IdentityServiceConfigOrBuilder>
        getIdentityServiceConfigFieldBuilder() {
      if (identityServiceConfigBuilder_ == null) {
        identityServiceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.IdentityServiceConfig,
                com.google.container.v1.IdentityServiceConfig.Builder,
                com.google.container.v1.IdentityServiceConfigOrBuilder>(
                getIdentityServiceConfig(), getParentForChildren(), isClean());
        identityServiceConfig_ = null;
      }
      return identityServiceConfigBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField1_ = (bitField1_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined URL for the resource.
     * </pre>
     *
     * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2066
     * @return The zone.
     */
    @java.lang.Deprecated
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2066
     * @return The bytes for zone.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2066
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2066
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField1_ = (bitField1_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field is deprecated, use location instead.
     * </pre>
     *
     * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2066
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     *
     * See the `masterAuth` property of this resource for username and
     * password information.
     * </pre>
     *
     * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     *
     * See the `masterAuth` property of this resource for username and
     * password information.
     * </pre>
     *
     * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     *
     * See the `masterAuth` property of this resource for username and
     * password information.
     * </pre>
     *
     * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpoint_ = value;
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     *
     * See the `masterAuth` property of this resource for username and
     * password information.
     * </pre>
     *
     * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {
      endpoint_ = getDefaultInstance().getEndpoint();
      bitField1_ = (bitField1_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address of this cluster's master endpoint.
     * The endpoint can be accessed from the internet at
     * `https://username:password&#64;endpoint/`.
     *
     * See the `masterAuth` property of this resource for username and
     * password information.
     * </pre>
     *
     * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpoint_ = value;
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object initialClusterVersion_ = "";
    /**
     *
     *
     * <pre>
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string initial_cluster_version = 103;</code>
     *
     * @return The initialClusterVersion.
     */
    public java.lang.String getInitialClusterVersion() {
      java.lang.Object ref = initialClusterVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        initialClusterVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string initial_cluster_version = 103;</code>
     *
     * @return The bytes for initialClusterVersion.
     */
    public com.google.protobuf.ByteString getInitialClusterVersionBytes() {
      java.lang.Object ref = initialClusterVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        initialClusterVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string initial_cluster_version = 103;</code>
     *
     * @param value The initialClusterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setInitialClusterVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      initialClusterVersion_ = value;
      bitField1_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string initial_cluster_version = 103;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInitialClusterVersion() {
      initialClusterVersion_ = getDefaultInstance().getInitialClusterVersion();
      bitField1_ = (bitField1_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial Kubernetes version for this cluster.  Valid versions are those
     * found in validMasterVersions returned by getServerConfig.  The version can
     * be upgraded over time; such upgrades are reflected in
     * currentMasterVersion and currentNodeVersion.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "","-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string initial_cluster_version = 103;</code>
     *
     * @param value The bytes for initialClusterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setInitialClusterVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      initialClusterVersion_ = value;
      bitField1_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object currentMasterVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The current software version of the master endpoint.
     * </pre>
     *
     * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The currentMasterVersion.
     */
    public java.lang.String getCurrentMasterVersion() {
      java.lang.Object ref = currentMasterVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentMasterVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current software version of the master endpoint.
     * </pre>
     *
     * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for currentMasterVersion.
     */
    public com.google.protobuf.ByteString getCurrentMasterVersionBytes() {
      java.lang.Object ref = currentMasterVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentMasterVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current software version of the master endpoint.
     * </pre>
     *
     * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The currentMasterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentMasterVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentMasterVersion_ = value;
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current software version of the master endpoint.
     * </pre>
     *
     * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentMasterVersion() {
      currentMasterVersion_ = getDefaultInstance().getCurrentMasterVersion();
      bitField1_ = (bitField1_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current software version of the master endpoint.
     * </pre>
     *
     * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for currentMasterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentMasterVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentMasterVersion_ = value;
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object currentNodeVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     * </pre>
     *
     * <code>
     * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2101
     * @return The currentNodeVersion.
     */
    @java.lang.Deprecated
    public java.lang.String getCurrentNodeVersion() {
      java.lang.Object ref = currentNodeVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentNodeVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     * </pre>
     *
     * <code>
     * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2101
     * @return The bytes for currentNodeVersion.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getCurrentNodeVersionBytes() {
      java.lang.Object ref = currentNodeVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentNodeVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     * </pre>
     *
     * <code>
     * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2101
     * @param value The currentNodeVersion to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setCurrentNodeVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentNodeVersion_ = value;
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     * </pre>
     *
     * <code>
     * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2101
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearCurrentNodeVersion() {
      currentNodeVersion_ = getDefaultInstance().getCurrentNodeVersion();
      bitField1_ = (bitField1_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated, use
     * [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
     * instead. The current version of the node software components. If they are
     * currently at multiple versions because they're in the process of being
     * upgraded, this reflects the minimum version of all nodes.
     * </pre>
     *
     * <code>
     * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_version is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2101
     * @param value The bytes for currentNodeVersion to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setCurrentNodeVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentNodeVersion_ = value;
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object createTime_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The createTime.
     */
    public java.lang.String getCreateTime() {
      java.lang.Object ref = createTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        createTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for createTime.
     */
    public com.google.protobuf.ByteString getCreateTimeBytes() {
      java.lang.Object ref = createTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        createTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The createTime to set.
     * @return This builder for chaining.
     */
    public Builder setCreateTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      createTime_ = value;
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreateTime() {
      createTime_ = getDefaultInstance().getCreateTime();
      bitField1_ = (bitField1_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster was created, in
     * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for createTime to set.
     * @return This builder for chaining.
     */
    public Builder setCreateTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      createTime_ = value;
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current status of this cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of this cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField1_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of this cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.container.v1.Cluster.Status getStatus() {
      com.google.container.v1.Cluster.Status result =
          com.google.container.v1.Cluster.Status.forNumber(status_);
      return result == null ? com.google.container.v1.Cluster.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of this cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.container.v1.Cluster.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField1_ |= 0x00002000;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current status of this cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField1_ = (bitField1_ & ~0x00002000);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     * </pre>
     *
     * <code>
     * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2114
     * @return The statusMessage.
     */
    @java.lang.Deprecated
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     * </pre>
     *
     * <code>
     * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2114
     * @return The bytes for statusMessage.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     * </pre>
     *
     * <code>
     * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2114
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField1_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     * </pre>
     *
     * <code>
     * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2114
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField1_ = (bitField1_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use conditions instead.
     * Additional information about the current status of this
     * cluster, if available.
     * </pre>
     *
     * <code>
     * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.status_message is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2114
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField1_ |= 0x00004000;
      onChanged();
      return this;
    }

    private int nodeIpv4CidrSize_;
    /**
     *
     *
     * <pre>
     * Output only. The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range. This field will only be set when cluster is in route-based network
     * mode.
     * </pre>
     *
     * <code>int32 node_ipv4_cidr_size = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The nodeIpv4CidrSize.
     */
    @java.lang.Override
    public int getNodeIpv4CidrSize() {
      return nodeIpv4CidrSize_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range. This field will only be set when cluster is in route-based network
     * mode.
     * </pre>
     *
     * <code>int32 node_ipv4_cidr_size = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The nodeIpv4CidrSize to set.
     * @return This builder for chaining.
     */
    public Builder setNodeIpv4CidrSize(int value) {

      nodeIpv4CidrSize_ = value;
      bitField1_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the address space on each node for hosting
     * containers. This is provisioned from within the `container_ipv4_cidr`
     * range. This field will only be set when cluster is in route-based network
     * mode.
     * </pre>
     *
     * <code>int32 node_ipv4_cidr_size = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeIpv4CidrSize() {
      bitField1_ = (bitField1_ & ~0x00008000);
      nodeIpv4CidrSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object servicesIpv4Cidr_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The servicesIpv4Cidr.
     */
    public java.lang.String getServicesIpv4Cidr() {
      java.lang.Object ref = servicesIpv4Cidr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        servicesIpv4Cidr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for servicesIpv4Cidr.
     */
    public com.google.protobuf.ByteString getServicesIpv4CidrBytes() {
      java.lang.Object ref = servicesIpv4Cidr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        servicesIpv4Cidr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The servicesIpv4Cidr to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4Cidr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      servicesIpv4Cidr_ = value;
      bitField1_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServicesIpv4Cidr() {
      servicesIpv4Cidr_ = getDefaultInstance().getServicesIpv4Cidr();
      bitField1_ = (bitField1_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Kubernetes services in
     * this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`). Service addresses are
     * typically put in the last `/16` from the container CIDR.
     * </pre>
     *
     * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for servicesIpv4Cidr to set.
     * @return This builder for chaining.
     */
    public Builder setServicesIpv4CidrBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      servicesIpv4Cidr_ = value;
      bitField1_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList instanceGroupUrls_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstanceGroupUrlsIsMutable() {
      if (!instanceGroupUrls_.isModifiable()) {
        instanceGroupUrls_ = new com.google.protobuf.LazyStringArrayList(instanceGroupUrls_);
      }
      bitField1_ |= 0x00020000;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @return A list containing the instanceGroupUrls.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getInstanceGroupUrlsList() {
      instanceGroupUrls_.makeImmutable();
      return instanceGroupUrls_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @return The count of instanceGroupUrls.
     */
    @java.lang.Deprecated
    public int getInstanceGroupUrlsCount() {
      return instanceGroupUrls_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @param index The index of the element to return.
     * @return The instanceGroupUrls at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getInstanceGroupUrls(int index) {
      return instanceGroupUrls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @param index The index of the value to return.
     * @return The bytes of the instanceGroupUrls at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getInstanceGroupUrlsBytes(int index) {
      return instanceGroupUrls_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @param index The index to set the value at.
     * @param value The instanceGroupUrls to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setInstanceGroupUrls(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.set(index, value);
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @param value The instanceGroupUrls to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addInstanceGroupUrls(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.add(value);
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @param values The instanceGroupUrls to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllInstanceGroupUrls(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceGroupUrlsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceGroupUrls_);
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearInstanceGroupUrls() {
      instanceGroupUrls_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField1_ = (bitField1_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use node_pools.instance_group_urls.
     * </pre>
     *
     * <code>
     * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.instance_group_urls is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2131
     * @param value The bytes of the instanceGroupUrls to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addInstanceGroupUrlsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceGroupUrlsIsMutable();
      instanceGroupUrls_.add(value);
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }

    private int currentNodeCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of nodes currently in the cluster. Deprecated.
     * Call Kubernetes API directly to retrieve node information.
     * </pre>
     *
     * <code>
     * int32 current_node_count = 112 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_count is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2136
     * @return The currentNodeCount.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getCurrentNodeCount() {
      return currentNodeCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of nodes currently in the cluster. Deprecated.
     * Call Kubernetes API directly to retrieve node information.
     * </pre>
     *
     * <code>
     * int32 current_node_count = 112 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_count is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2136
     * @param value The currentNodeCount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setCurrentNodeCount(int value) {

      currentNodeCount_ = value;
      bitField1_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of nodes currently in the cluster. Deprecated.
     * Call Kubernetes API directly to retrieve node information.
     * </pre>
     *
     * <code>
     * int32 current_node_count = 112 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.container.v1.Cluster.current_node_count is deprecated. See
     *     google/container/v1/cluster_service.proto;l=2136
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearCurrentNodeCount() {
      bitField1_ = (bitField1_ & ~0x00040000);
      currentNodeCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object expireTime_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The expireTime.
     */
    public java.lang.String getExpireTime() {
      java.lang.Object ref = expireTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        expireTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for expireTime.
     */
    public com.google.protobuf.ByteString getExpireTimeBytes() {
      java.lang.Object ref = expireTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        expireTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The expireTime to set.
     * @return This builder for chaining.
     */
    public Builder setExpireTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      expireTime_ = value;
      bitField1_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpireTime() {
      expireTime_ = getDefaultInstance().getExpireTime();
      bitField1_ = (bitField1_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the cluster will be automatically
     * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
     * </pre>
     *
     * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for expireTime to set.
     * @return This builder for chaining.
     */
    public Builder setExpireTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      expireTime_ = value;
      bitField1_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField1_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField1_ = (bitField1_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * or
     * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
     * in which the cluster resides.
     * </pre>
     *
     * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField1_ |= 0x00100000;
      onChanged();
      return this;
    }

    private boolean enableTpu_;
    /**
     *
     *
     * <pre>
     * Enable the ability to use Cloud TPUs in this cluster.
     * </pre>
     *
     * <code>bool enable_tpu = 115;</code>
     *
     * @return The enableTpu.
     */
    @java.lang.Override
    public boolean getEnableTpu() {
      return enableTpu_;
    }
    /**
     *
     *
     * <pre>
     * Enable the ability to use Cloud TPUs in this cluster.
     * </pre>
     *
     * <code>bool enable_tpu = 115;</code>
     *
     * @param value The enableTpu to set.
     * @return This builder for chaining.
     */
    public Builder setEnableTpu(boolean value) {

      enableTpu_ = value;
      bitField1_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable the ability to use Cloud TPUs in this cluster.
     * </pre>
     *
     * <code>bool enable_tpu = 115;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableTpu() {
      bitField1_ = (bitField1_ & ~0x00200000);
      enableTpu_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object tpuIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tpuIpv4CidrBlock.
     */
    public java.lang.String getTpuIpv4CidrBlock() {
      java.lang.Object ref = tpuIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tpuIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for tpuIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getTpuIpv4CidrBlockBytes() {
      java.lang.Object ref = tpuIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tpuIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tpuIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setTpuIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tpuIpv4CidrBlock_ = value;
      bitField1_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTpuIpv4CidrBlock() {
      tpuIpv4CidrBlock_ = getDefaultInstance().getTpuIpv4CidrBlock();
      bitField1_ = (bitField1_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The IP address range of the Cloud TPUs in this cluster, in
     * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `1.2.3.4/29`).
     * </pre>
     *
     * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for tpuIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setTpuIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tpuIpv4CidrBlock_ = value;
      bitField1_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.StatusCondition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField1_ & 0x00800000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.container.v1.StatusCondition>(conditions_);
        bitField1_ |= 0x00800000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public java.util.List<com.google.container.v1.StatusCondition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public com.google.container.v1.StatusCondition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder setConditions(int index, com.google.container.v1.StatusCondition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder setConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder addConditions(com.google.container.v1.StatusCondition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder addConditions(int index, com.google.container.v1.StatusCondition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder addConditions(com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder addConditions(
        int index, com.google.container.v1.StatusCondition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.container.v1.StatusCondition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField1_ = (bitField1_ & ~0x00800000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public com.google.container.v1.StatusCondition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public com.google.container.v1.StatusConditionOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public java.util.List<? extends com.google.container.v1.StatusConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public com.google.container.v1.StatusCondition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public com.google.container.v1.StatusCondition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.container.v1.StatusCondition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Which conditions caused the current cluster state.
     * </pre>
     *
     * <code>repeated .google.container.v1.StatusCondition conditions = 118;</code>
     */
    public java.util.List<com.google.container.v1.StatusCondition.Builder>
        getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.StatusCondition,
            com.google.container.v1.StatusCondition.Builder,
            com.google.container.v1.StatusConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.StatusCondition,
                com.google.container.v1.StatusCondition.Builder,
                com.google.container.v1.StatusConditionOrBuilder>(
                conditions_, ((bitField1_ & 0x00800000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private com.google.container.v1.Autopilot autopilot_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.Autopilot,
            com.google.container.v1.Autopilot.Builder,
            com.google.container.v1.AutopilotOrBuilder>
        autopilotBuilder_;
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     *
     * @return Whether the autopilot field is set.
     */
    public boolean hasAutopilot() {
      return ((bitField1_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     *
     * @return The autopilot.
     */
    public com.google.container.v1.Autopilot getAutopilot() {
      if (autopilotBuilder_ == null) {
        return autopilot_ == null
            ? com.google.container.v1.Autopilot.getDefaultInstance()
            : autopilot_;
      } else {
        return autopilotBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    public Builder setAutopilot(com.google.container.v1.Autopilot value) {
      if (autopilotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autopilot_ = value;
      } else {
        autopilotBuilder_.setMessage(value);
      }
      bitField1_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    public Builder setAutopilot(com.google.container.v1.Autopilot.Builder builderForValue) {
      if (autopilotBuilder_ == null) {
        autopilot_ = builderForValue.build();
      } else {
        autopilotBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    public Builder mergeAutopilot(com.google.container.v1.Autopilot value) {
      if (autopilotBuilder_ == null) {
        if (((bitField1_ & 0x01000000) != 0)
            && autopilot_ != null
            && autopilot_ != com.google.container.v1.Autopilot.getDefaultInstance()) {
          getAutopilotBuilder().mergeFrom(value);
        } else {
          autopilot_ = value;
        }
      } else {
        autopilotBuilder_.mergeFrom(value);
      }
      if (autopilot_ != null) {
        bitField1_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    public Builder clearAutopilot() {
      bitField1_ = (bitField1_ & ~0x01000000);
      autopilot_ = null;
      if (autopilotBuilder_ != null) {
        autopilotBuilder_.dispose();
        autopilotBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    public com.google.container.v1.Autopilot.Builder getAutopilotBuilder() {
      bitField1_ |= 0x01000000;
      onChanged();
      return getAutopilotFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    public com.google.container.v1.AutopilotOrBuilder getAutopilotOrBuilder() {
      if (autopilotBuilder_ != null) {
        return autopilotBuilder_.getMessageOrBuilder();
      } else {
        return autopilot_ == null
            ? com.google.container.v1.Autopilot.getDefaultInstance()
            : autopilot_;
      }
    }
    /**
     *
     *
     * <pre>
     * Autopilot configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Autopilot autopilot = 128;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.Autopilot,
            com.google.container.v1.Autopilot.Builder,
            com.google.container.v1.AutopilotOrBuilder>
        getAutopilotFieldBuilder() {
      if (autopilotBuilder_ == null) {
        autopilotBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.Autopilot,
                com.google.container.v1.Autopilot.Builder,
                com.google.container.v1.AutopilotOrBuilder>(
                getAutopilot(), getParentForChildren(), isClean());
        autopilot_ = null;
      }
      return autopilotBuilder_;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique id for the cluster.
     * </pre>
     *
     * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique id for the cluster.
     * </pre>
     *
     * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique id for the cluster.
     * </pre>
     *
     * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField1_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique id for the cluster.
     * </pre>
     *
     * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField1_ = (bitField1_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique id for the cluster.
     * </pre>
     *
     * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField1_ |= 0x02000000;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodePoolDefaults nodePoolDefaults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolDefaults,
            com.google.container.v1.NodePoolDefaults.Builder,
            com.google.container.v1.NodePoolDefaultsOrBuilder>
        nodePoolDefaultsBuilder_;
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     *
     * @return Whether the nodePoolDefaults field is set.
     */
    public boolean hasNodePoolDefaults() {
      return ((bitField1_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     *
     * @return The nodePoolDefaults.
     */
    public com.google.container.v1.NodePoolDefaults getNodePoolDefaults() {
      if (nodePoolDefaultsBuilder_ == null) {
        return nodePoolDefaults_ == null
            ? com.google.container.v1.NodePoolDefaults.getDefaultInstance()
            : nodePoolDefaults_;
      } else {
        return nodePoolDefaultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    public Builder setNodePoolDefaults(com.google.container.v1.NodePoolDefaults value) {
      if (nodePoolDefaultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodePoolDefaults_ = value;
      } else {
        nodePoolDefaultsBuilder_.setMessage(value);
      }
      bitField1_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    public Builder setNodePoolDefaults(
        com.google.container.v1.NodePoolDefaults.Builder builderForValue) {
      if (nodePoolDefaultsBuilder_ == null) {
        nodePoolDefaults_ = builderForValue.build();
      } else {
        nodePoolDefaultsBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    public Builder mergeNodePoolDefaults(com.google.container.v1.NodePoolDefaults value) {
      if (nodePoolDefaultsBuilder_ == null) {
        if (((bitField1_ & 0x04000000) != 0)
            && nodePoolDefaults_ != null
            && nodePoolDefaults_ != com.google.container.v1.NodePoolDefaults.getDefaultInstance()) {
          getNodePoolDefaultsBuilder().mergeFrom(value);
        } else {
          nodePoolDefaults_ = value;
        }
      } else {
        nodePoolDefaultsBuilder_.mergeFrom(value);
      }
      if (nodePoolDefaults_ != null) {
        bitField1_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    public Builder clearNodePoolDefaults() {
      bitField1_ = (bitField1_ & ~0x04000000);
      nodePoolDefaults_ = null;
      if (nodePoolDefaultsBuilder_ != null) {
        nodePoolDefaultsBuilder_.dispose();
        nodePoolDefaultsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    public com.google.container.v1.NodePoolDefaults.Builder getNodePoolDefaultsBuilder() {
      bitField1_ |= 0x04000000;
      onChanged();
      return getNodePoolDefaultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    public com.google.container.v1.NodePoolDefaultsOrBuilder getNodePoolDefaultsOrBuilder() {
      if (nodePoolDefaultsBuilder_ != null) {
        return nodePoolDefaultsBuilder_.getMessageOrBuilder();
      } else {
        return nodePoolDefaults_ == null
            ? com.google.container.v1.NodePoolDefaults.getDefaultInstance()
            : nodePoolDefaults_;
      }
    }
    /**
     *
     *
     * <pre>
     * Default NodePool settings for the entire cluster. These settings are
     * overridden if specified on the specific NodePool object.
     * </pre>
     *
     * <code>optional .google.container.v1.NodePoolDefaults node_pool_defaults = 131;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolDefaults,
            com.google.container.v1.NodePoolDefaults.Builder,
            com.google.container.v1.NodePoolDefaultsOrBuilder>
        getNodePoolDefaultsFieldBuilder() {
      if (nodePoolDefaultsBuilder_ == null) {
        nodePoolDefaultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePoolDefaults,
                com.google.container.v1.NodePoolDefaults.Builder,
                com.google.container.v1.NodePoolDefaultsOrBuilder>(
                getNodePoolDefaults(), getParentForChildren(), isClean());
        nodePoolDefaults_ = null;
      }
      return nodePoolDefaultsBuilder_;
    }

    private com.google.container.v1.LoggingConfig loggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LoggingConfig,
            com.google.container.v1.LoggingConfig.Builder,
            com.google.container.v1.LoggingConfigOrBuilder>
        loggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     *
     * @return Whether the loggingConfig field is set.
     */
    public boolean hasLoggingConfig() {
      return ((bitField1_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     *
     * @return The loggingConfig.
     */
    public com.google.container.v1.LoggingConfig getLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        return loggingConfig_ == null
            ? com.google.container.v1.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      } else {
        return loggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    public Builder setLoggingConfig(com.google.container.v1.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingConfig_ = value;
      } else {
        loggingConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    public Builder setLoggingConfig(com.google.container.v1.LoggingConfig.Builder builderForValue) {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = builderForValue.build();
      } else {
        loggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    public Builder mergeLoggingConfig(com.google.container.v1.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (((bitField1_ & 0x08000000) != 0)
            && loggingConfig_ != null
            && loggingConfig_ != com.google.container.v1.LoggingConfig.getDefaultInstance()) {
          getLoggingConfigBuilder().mergeFrom(value);
        } else {
          loggingConfig_ = value;
        }
      } else {
        loggingConfigBuilder_.mergeFrom(value);
      }
      if (loggingConfig_ != null) {
        bitField1_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    public Builder clearLoggingConfig() {
      bitField1_ = (bitField1_ & ~0x08000000);
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    public com.google.container.v1.LoggingConfig.Builder getLoggingConfigBuilder() {
      bitField1_ |= 0x08000000;
      onChanged();
      return getLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    public com.google.container.v1.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
      if (loggingConfigBuilder_ != null) {
        return loggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return loggingConfig_ == null
            ? com.google.container.v1.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.LoggingConfig logging_config = 132;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.LoggingConfig,
            com.google.container.v1.LoggingConfig.Builder,
            com.google.container.v1.LoggingConfigOrBuilder>
        getLoggingConfigFieldBuilder() {
      if (loggingConfigBuilder_ == null) {
        loggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.LoggingConfig,
                com.google.container.v1.LoggingConfig.Builder,
                com.google.container.v1.LoggingConfigOrBuilder>(
                getLoggingConfig(), getParentForChildren(), isClean());
        loggingConfig_ = null;
      }
      return loggingConfigBuilder_;
    }

    private com.google.container.v1.MonitoringConfig monitoringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MonitoringConfig,
            com.google.container.v1.MonitoringConfig.Builder,
            com.google.container.v1.MonitoringConfigOrBuilder>
        monitoringConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     *
     * @return Whether the monitoringConfig field is set.
     */
    public boolean hasMonitoringConfig() {
      return ((bitField1_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     *
     * @return The monitoringConfig.
     */
    public com.google.container.v1.MonitoringConfig getMonitoringConfig() {
      if (monitoringConfigBuilder_ == null) {
        return monitoringConfig_ == null
            ? com.google.container.v1.MonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      } else {
        return monitoringConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    public Builder setMonitoringConfig(com.google.container.v1.MonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoringConfig_ = value;
      } else {
        monitoringConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    public Builder setMonitoringConfig(
        com.google.container.v1.MonitoringConfig.Builder builderForValue) {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfig_ = builderForValue.build();
      } else {
        monitoringConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    public Builder mergeMonitoringConfig(com.google.container.v1.MonitoringConfig value) {
      if (monitoringConfigBuilder_ == null) {
        if (((bitField1_ & 0x10000000) != 0)
            && monitoringConfig_ != null
            && monitoringConfig_ != com.google.container.v1.MonitoringConfig.getDefaultInstance()) {
          getMonitoringConfigBuilder().mergeFrom(value);
        } else {
          monitoringConfig_ = value;
        }
      } else {
        monitoringConfigBuilder_.mergeFrom(value);
      }
      if (monitoringConfig_ != null) {
        bitField1_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    public Builder clearMonitoringConfig() {
      bitField1_ = (bitField1_ & ~0x10000000);
      monitoringConfig_ = null;
      if (monitoringConfigBuilder_ != null) {
        monitoringConfigBuilder_.dispose();
        monitoringConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    public com.google.container.v1.MonitoringConfig.Builder getMonitoringConfigBuilder() {
      bitField1_ |= 0x10000000;
      onChanged();
      return getMonitoringConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    public com.google.container.v1.MonitoringConfigOrBuilder getMonitoringConfigOrBuilder() {
      if (monitoringConfigBuilder_ != null) {
        return monitoringConfigBuilder_.getMessageOrBuilder();
      } else {
        return monitoringConfig_ == null
            ? com.google.container.v1.MonitoringConfig.getDefaultInstance()
            : monitoringConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.MonitoringConfig monitoring_config = 133;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.MonitoringConfig,
            com.google.container.v1.MonitoringConfig.Builder,
            com.google.container.v1.MonitoringConfigOrBuilder>
        getMonitoringConfigFieldBuilder() {
      if (monitoringConfigBuilder_ == null) {
        monitoringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.MonitoringConfig,
                com.google.container.v1.MonitoringConfig.Builder,
                com.google.container.v1.MonitoringConfigOrBuilder>(
                getMonitoringConfig(), getParentForChildren(), isClean());
        monitoringConfig_ = null;
      }
      return monitoringConfigBuilder_;
    }

    private com.google.container.v1.NodePoolAutoConfig nodePoolAutoConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoConfig,
            com.google.container.v1.NodePoolAutoConfig.Builder,
            com.google.container.v1.NodePoolAutoConfigOrBuilder>
        nodePoolAutoConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     *
     * @return Whether the nodePoolAutoConfig field is set.
     */
    public boolean hasNodePoolAutoConfig() {
      return ((bitField1_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     *
     * @return The nodePoolAutoConfig.
     */
    public com.google.container.v1.NodePoolAutoConfig getNodePoolAutoConfig() {
      if (nodePoolAutoConfigBuilder_ == null) {
        return nodePoolAutoConfig_ == null
            ? com.google.container.v1.NodePoolAutoConfig.getDefaultInstance()
            : nodePoolAutoConfig_;
      } else {
        return nodePoolAutoConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    public Builder setNodePoolAutoConfig(com.google.container.v1.NodePoolAutoConfig value) {
      if (nodePoolAutoConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodePoolAutoConfig_ = value;
      } else {
        nodePoolAutoConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    public Builder setNodePoolAutoConfig(
        com.google.container.v1.NodePoolAutoConfig.Builder builderForValue) {
      if (nodePoolAutoConfigBuilder_ == null) {
        nodePoolAutoConfig_ = builderForValue.build();
      } else {
        nodePoolAutoConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    public Builder mergeNodePoolAutoConfig(com.google.container.v1.NodePoolAutoConfig value) {
      if (nodePoolAutoConfigBuilder_ == null) {
        if (((bitField1_ & 0x20000000) != 0)
            && nodePoolAutoConfig_ != null
            && nodePoolAutoConfig_
                != com.google.container.v1.NodePoolAutoConfig.getDefaultInstance()) {
          getNodePoolAutoConfigBuilder().mergeFrom(value);
        } else {
          nodePoolAutoConfig_ = value;
        }
      } else {
        nodePoolAutoConfigBuilder_.mergeFrom(value);
      }
      if (nodePoolAutoConfig_ != null) {
        bitField1_ |= 0x20000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    public Builder clearNodePoolAutoConfig() {
      bitField1_ = (bitField1_ & ~0x20000000);
      nodePoolAutoConfig_ = null;
      if (nodePoolAutoConfigBuilder_ != null) {
        nodePoolAutoConfigBuilder_.dispose();
        nodePoolAutoConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    public com.google.container.v1.NodePoolAutoConfig.Builder getNodePoolAutoConfigBuilder() {
      bitField1_ |= 0x20000000;
      onChanged();
      return getNodePoolAutoConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    public com.google.container.v1.NodePoolAutoConfigOrBuilder getNodePoolAutoConfigOrBuilder() {
      if (nodePoolAutoConfigBuilder_ != null) {
        return nodePoolAutoConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodePoolAutoConfig_ == null
            ? com.google.container.v1.NodePoolAutoConfig.getDefaultInstance()
            : nodePoolAutoConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Node pool configs that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoConfig,
            com.google.container.v1.NodePoolAutoConfig.Builder,
            com.google.container.v1.NodePoolAutoConfigOrBuilder>
        getNodePoolAutoConfigFieldBuilder() {
      if (nodePoolAutoConfigBuilder_ == null) {
        nodePoolAutoConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePoolAutoConfig,
                com.google.container.v1.NodePoolAutoConfig.Builder,
                com.google.container.v1.NodePoolAutoConfigOrBuilder>(
                getNodePoolAutoConfig(), getParentForChildren(), isClean());
        nodePoolAutoConfig_ = null;
      }
      return nodePoolAutoConfigBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 139;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 139;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 139;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField1_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 139;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField1_ = (bitField1_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of cluster
     * fields, and may be sent on update requests to ensure the client has an
     * up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 139;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField1_ |= 0x40000000;
      onChanged();
      return this;
    }

    private com.google.container.v1.Fleet fleet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.Fleet,
            com.google.container.v1.Fleet.Builder,
            com.google.container.v1.FleetOrBuilder>
        fleetBuilder_;
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     *
     * @return Whether the fleet field is set.
     */
    public boolean hasFleet() {
      return ((bitField1_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     *
     * @return The fleet.
     */
    public com.google.container.v1.Fleet getFleet() {
      if (fleetBuilder_ == null) {
        return fleet_ == null ? com.google.container.v1.Fleet.getDefaultInstance() : fleet_;
      } else {
        return fleetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    public Builder setFleet(com.google.container.v1.Fleet value) {
      if (fleetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fleet_ = value;
      } else {
        fleetBuilder_.setMessage(value);
      }
      bitField1_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    public Builder setFleet(com.google.container.v1.Fleet.Builder builderForValue) {
      if (fleetBuilder_ == null) {
        fleet_ = builderForValue.build();
      } else {
        fleetBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    public Builder mergeFleet(com.google.container.v1.Fleet value) {
      if (fleetBuilder_ == null) {
        if (((bitField1_ & 0x80000000) != 0)
            && fleet_ != null
            && fleet_ != com.google.container.v1.Fleet.getDefaultInstance()) {
          getFleetBuilder().mergeFrom(value);
        } else {
          fleet_ = value;
        }
      } else {
        fleetBuilder_.mergeFrom(value);
      }
      if (fleet_ != null) {
        bitField1_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    public Builder clearFleet() {
      bitField1_ = (bitField1_ & ~0x80000000);
      fleet_ = null;
      if (fleetBuilder_ != null) {
        fleetBuilder_.dispose();
        fleetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    public com.google.container.v1.Fleet.Builder getFleetBuilder() {
      bitField1_ |= 0x80000000;
      onChanged();
      return getFleetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    public com.google.container.v1.FleetOrBuilder getFleetOrBuilder() {
      if (fleetBuilder_ != null) {
        return fleetBuilder_.getMessageOrBuilder();
      } else {
        return fleet_ == null ? com.google.container.v1.Fleet.getDefaultInstance() : fleet_;
      }
    }
    /**
     *
     *
     * <pre>
     * Fleet information for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.Fleet fleet = 140;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.Fleet,
            com.google.container.v1.Fleet.Builder,
            com.google.container.v1.FleetOrBuilder>
        getFleetFieldBuilder() {
      if (fleetBuilder_ == null) {
        fleetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.Fleet,
                com.google.container.v1.Fleet.Builder,
                com.google.container.v1.FleetOrBuilder>(
                getFleet(), getParentForChildren(), isClean());
        fleet_ = null;
      }
      return fleetBuilder_;
    }

    private com.google.container.v1.SecurityPostureConfig securityPostureConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SecurityPostureConfig,
            com.google.container.v1.SecurityPostureConfig.Builder,
            com.google.container.v1.SecurityPostureConfigOrBuilder>
        securityPostureConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     *
     * @return Whether the securityPostureConfig field is set.
     */
    public boolean hasSecurityPostureConfig() {
      return ((bitField2_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     *
     * @return The securityPostureConfig.
     */
    public com.google.container.v1.SecurityPostureConfig getSecurityPostureConfig() {
      if (securityPostureConfigBuilder_ == null) {
        return securityPostureConfig_ == null
            ? com.google.container.v1.SecurityPostureConfig.getDefaultInstance()
            : securityPostureConfig_;
      } else {
        return securityPostureConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    public Builder setSecurityPostureConfig(com.google.container.v1.SecurityPostureConfig value) {
      if (securityPostureConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityPostureConfig_ = value;
      } else {
        securityPostureConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    public Builder setSecurityPostureConfig(
        com.google.container.v1.SecurityPostureConfig.Builder builderForValue) {
      if (securityPostureConfigBuilder_ == null) {
        securityPostureConfig_ = builderForValue.build();
      } else {
        securityPostureConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    public Builder mergeSecurityPostureConfig(com.google.container.v1.SecurityPostureConfig value) {
      if (securityPostureConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000001) != 0)
            && securityPostureConfig_ != null
            && securityPostureConfig_
                != com.google.container.v1.SecurityPostureConfig.getDefaultInstance()) {
          getSecurityPostureConfigBuilder().mergeFrom(value);
        } else {
          securityPostureConfig_ = value;
        }
      } else {
        securityPostureConfigBuilder_.mergeFrom(value);
      }
      if (securityPostureConfig_ != null) {
        bitField2_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    public Builder clearSecurityPostureConfig() {
      bitField2_ = (bitField2_ & ~0x00000001);
      securityPostureConfig_ = null;
      if (securityPostureConfigBuilder_ != null) {
        securityPostureConfigBuilder_.dispose();
        securityPostureConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    public com.google.container.v1.SecurityPostureConfig.Builder getSecurityPostureConfigBuilder() {
      bitField2_ |= 0x00000001;
      onChanged();
      return getSecurityPostureConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    public com.google.container.v1.SecurityPostureConfigOrBuilder
        getSecurityPostureConfigOrBuilder() {
      if (securityPostureConfigBuilder_ != null) {
        return securityPostureConfigBuilder_.getMessageOrBuilder();
      } else {
        return securityPostureConfig_ == null
            ? com.google.container.v1.SecurityPostureConfig.getDefaultInstance()
            : securityPostureConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.SecurityPostureConfig security_posture_config = 145;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SecurityPostureConfig,
            com.google.container.v1.SecurityPostureConfig.Builder,
            com.google.container.v1.SecurityPostureConfigOrBuilder>
        getSecurityPostureConfigFieldBuilder() {
      if (securityPostureConfigBuilder_ == null) {
        securityPostureConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.SecurityPostureConfig,
                com.google.container.v1.SecurityPostureConfig.Builder,
                com.google.container.v1.SecurityPostureConfigOrBuilder>(
                getSecurityPostureConfig(), getParentForChildren(), isClean());
        securityPostureConfig_ = null;
      }
      return securityPostureConfigBuilder_;
    }

    private com.google.container.v1.ControlPlaneEndpointsConfig controlPlaneEndpointsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ControlPlaneEndpointsConfig,
            com.google.container.v1.ControlPlaneEndpointsConfig.Builder,
            com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder>
        controlPlaneEndpointsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     *
     * @return Whether the controlPlaneEndpointsConfig field is set.
     */
    public boolean hasControlPlaneEndpointsConfig() {
      return ((bitField2_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     *
     * @return The controlPlaneEndpointsConfig.
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig getControlPlaneEndpointsConfig() {
      if (controlPlaneEndpointsConfigBuilder_ == null) {
        return controlPlaneEndpointsConfig_ == null
            ? com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance()
            : controlPlaneEndpointsConfig_;
      } else {
        return controlPlaneEndpointsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    public Builder setControlPlaneEndpointsConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig value) {
      if (controlPlaneEndpointsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        controlPlaneEndpointsConfig_ = value;
      } else {
        controlPlaneEndpointsConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    public Builder setControlPlaneEndpointsConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.Builder builderForValue) {
      if (controlPlaneEndpointsConfigBuilder_ == null) {
        controlPlaneEndpointsConfig_ = builderForValue.build();
      } else {
        controlPlaneEndpointsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    public Builder mergeControlPlaneEndpointsConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig value) {
      if (controlPlaneEndpointsConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000002) != 0)
            && controlPlaneEndpointsConfig_ != null
            && controlPlaneEndpointsConfig_
                != com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance()) {
          getControlPlaneEndpointsConfigBuilder().mergeFrom(value);
        } else {
          controlPlaneEndpointsConfig_ = value;
        }
      } else {
        controlPlaneEndpointsConfigBuilder_.mergeFrom(value);
      }
      if (controlPlaneEndpointsConfig_ != null) {
        bitField2_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    public Builder clearControlPlaneEndpointsConfig() {
      bitField2_ = (bitField2_ & ~0x00000002);
      controlPlaneEndpointsConfig_ = null;
      if (controlPlaneEndpointsConfigBuilder_ != null) {
        controlPlaneEndpointsConfigBuilder_.dispose();
        controlPlaneEndpointsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.Builder
        getControlPlaneEndpointsConfigBuilder() {
      bitField2_ |= 0x00000002;
      onChanged();
      return getControlPlaneEndpointsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    public com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder
        getControlPlaneEndpointsConfigOrBuilder() {
      if (controlPlaneEndpointsConfigBuilder_ != null) {
        return controlPlaneEndpointsConfigBuilder_.getMessageOrBuilder();
      } else {
        return controlPlaneEndpointsConfig_ == null
            ? com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance()
            : controlPlaneEndpointsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for all cluster's control plane endpoints.
     * </pre>
     *
     * <code>.google.container.v1.ControlPlaneEndpointsConfig control_plane_endpoints_config = 146;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ControlPlaneEndpointsConfig,
            com.google.container.v1.ControlPlaneEndpointsConfig.Builder,
            com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder>
        getControlPlaneEndpointsConfigFieldBuilder() {
      if (controlPlaneEndpointsConfigBuilder_ == null) {
        controlPlaneEndpointsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ControlPlaneEndpointsConfig,
                com.google.container.v1.ControlPlaneEndpointsConfig.Builder,
                com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder>(
                getControlPlaneEndpointsConfig(), getParentForChildren(), isClean());
        controlPlaneEndpointsConfig_ = null;
      }
      return controlPlaneEndpointsConfigBuilder_;
    }

    private com.google.container.v1.K8sBetaAPIConfig enableK8SBetaApis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.K8sBetaAPIConfig,
            com.google.container.v1.K8sBetaAPIConfig.Builder,
            com.google.container.v1.K8sBetaAPIConfigOrBuilder>
        enableK8SBetaApisBuilder_;
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     *
     * @return Whether the enableK8sBetaApis field is set.
     */
    public boolean hasEnableK8SBetaApis() {
      return ((bitField2_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     *
     * @return The enableK8sBetaApis.
     */
    public com.google.container.v1.K8sBetaAPIConfig getEnableK8SBetaApis() {
      if (enableK8SBetaApisBuilder_ == null) {
        return enableK8SBetaApis_ == null
            ? com.google.container.v1.K8sBetaAPIConfig.getDefaultInstance()
            : enableK8SBetaApis_;
      } else {
        return enableK8SBetaApisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    public Builder setEnableK8SBetaApis(com.google.container.v1.K8sBetaAPIConfig value) {
      if (enableK8SBetaApisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enableK8SBetaApis_ = value;
      } else {
        enableK8SBetaApisBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    public Builder setEnableK8SBetaApis(
        com.google.container.v1.K8sBetaAPIConfig.Builder builderForValue) {
      if (enableK8SBetaApisBuilder_ == null) {
        enableK8SBetaApis_ = builderForValue.build();
      } else {
        enableK8SBetaApisBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    public Builder mergeEnableK8SBetaApis(com.google.container.v1.K8sBetaAPIConfig value) {
      if (enableK8SBetaApisBuilder_ == null) {
        if (((bitField2_ & 0x00000004) != 0)
            && enableK8SBetaApis_ != null
            && enableK8SBetaApis_
                != com.google.container.v1.K8sBetaAPIConfig.getDefaultInstance()) {
          getEnableK8SBetaApisBuilder().mergeFrom(value);
        } else {
          enableK8SBetaApis_ = value;
        }
      } else {
        enableK8SBetaApisBuilder_.mergeFrom(value);
      }
      if (enableK8SBetaApis_ != null) {
        bitField2_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    public Builder clearEnableK8SBetaApis() {
      bitField2_ = (bitField2_ & ~0x00000004);
      enableK8SBetaApis_ = null;
      if (enableK8SBetaApisBuilder_ != null) {
        enableK8SBetaApisBuilder_.dispose();
        enableK8SBetaApisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    public com.google.container.v1.K8sBetaAPIConfig.Builder getEnableK8SBetaApisBuilder() {
      bitField2_ |= 0x00000004;
      onChanged();
      return getEnableK8SBetaApisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    public com.google.container.v1.K8sBetaAPIConfigOrBuilder getEnableK8SBetaApisOrBuilder() {
      if (enableK8SBetaApisBuilder_ != null) {
        return enableK8SBetaApisBuilder_.getMessageOrBuilder();
      } else {
        return enableK8SBetaApis_ == null
            ? com.google.container.v1.K8sBetaAPIConfig.getDefaultInstance()
            : enableK8SBetaApis_;
      }
    }
    /**
     *
     *
     * <pre>
     * Beta APIs Config
     * </pre>
     *
     * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.K8sBetaAPIConfig,
            com.google.container.v1.K8sBetaAPIConfig.Builder,
            com.google.container.v1.K8sBetaAPIConfigOrBuilder>
        getEnableK8SBetaApisFieldBuilder() {
      if (enableK8SBetaApisBuilder_ == null) {
        enableK8SBetaApisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.K8sBetaAPIConfig,
                com.google.container.v1.K8sBetaAPIConfig.Builder,
                com.google.container.v1.K8sBetaAPIConfigOrBuilder>(
                getEnableK8SBetaApis(), getParentForChildren(), isClean());
        enableK8SBetaApis_ = null;
      }
      return enableK8SBetaApisBuilder_;
    }

    private com.google.container.v1.EnterpriseConfig enterpriseConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.EnterpriseConfig,
            com.google.container.v1.EnterpriseConfig.Builder,
            com.google.container.v1.EnterpriseConfigOrBuilder>
        enterpriseConfigBuilder_;
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     *
     * @return Whether the enterpriseConfig field is set.
     */
    public boolean hasEnterpriseConfig() {
      return ((bitField2_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     *
     * @return The enterpriseConfig.
     */
    public com.google.container.v1.EnterpriseConfig getEnterpriseConfig() {
      if (enterpriseConfigBuilder_ == null) {
        return enterpriseConfig_ == null
            ? com.google.container.v1.EnterpriseConfig.getDefaultInstance()
            : enterpriseConfig_;
      } else {
        return enterpriseConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    public Builder setEnterpriseConfig(com.google.container.v1.EnterpriseConfig value) {
      if (enterpriseConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enterpriseConfig_ = value;
      } else {
        enterpriseConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    public Builder setEnterpriseConfig(
        com.google.container.v1.EnterpriseConfig.Builder builderForValue) {
      if (enterpriseConfigBuilder_ == null) {
        enterpriseConfig_ = builderForValue.build();
      } else {
        enterpriseConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    public Builder mergeEnterpriseConfig(com.google.container.v1.EnterpriseConfig value) {
      if (enterpriseConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000008) != 0)
            && enterpriseConfig_ != null
            && enterpriseConfig_ != com.google.container.v1.EnterpriseConfig.getDefaultInstance()) {
          getEnterpriseConfigBuilder().mergeFrom(value);
        } else {
          enterpriseConfig_ = value;
        }
      } else {
        enterpriseConfigBuilder_.mergeFrom(value);
      }
      if (enterpriseConfig_ != null) {
        bitField2_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    public Builder clearEnterpriseConfig() {
      bitField2_ = (bitField2_ & ~0x00000008);
      enterpriseConfig_ = null;
      if (enterpriseConfigBuilder_ != null) {
        enterpriseConfigBuilder_.dispose();
        enterpriseConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    public com.google.container.v1.EnterpriseConfig.Builder getEnterpriseConfigBuilder() {
      bitField2_ |= 0x00000008;
      onChanged();
      return getEnterpriseConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    public com.google.container.v1.EnterpriseConfigOrBuilder getEnterpriseConfigOrBuilder() {
      if (enterpriseConfigBuilder_ != null) {
        return enterpriseConfigBuilder_.getMessageOrBuilder();
      } else {
        return enterpriseConfig_ == null
            ? com.google.container.v1.EnterpriseConfig.getDefaultInstance()
            : enterpriseConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * GKE Enterprise Configuration.
     * </pre>
     *
     * <code>.google.container.v1.EnterpriseConfig enterprise_config = 149;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.EnterpriseConfig,
            com.google.container.v1.EnterpriseConfig.Builder,
            com.google.container.v1.EnterpriseConfigOrBuilder>
        getEnterpriseConfigFieldBuilder() {
      if (enterpriseConfigBuilder_ == null) {
        enterpriseConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.EnterpriseConfig,
                com.google.container.v1.EnterpriseConfig.Builder,
                com.google.container.v1.EnterpriseConfigOrBuilder>(
                getEnterpriseConfig(), getParentForChildren(), isClean());
        enterpriseConfig_ = null;
      }
      return enterpriseConfigBuilder_;
    }

    private com.google.container.v1.SecretManagerConfig secretManagerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SecretManagerConfig,
            com.google.container.v1.SecretManagerConfig.Builder,
            com.google.container.v1.SecretManagerConfigOrBuilder>
        secretManagerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     *
     * @return Whether the secretManagerConfig field is set.
     */
    public boolean hasSecretManagerConfig() {
      return ((bitField2_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     *
     * @return The secretManagerConfig.
     */
    public com.google.container.v1.SecretManagerConfig getSecretManagerConfig() {
      if (secretManagerConfigBuilder_ == null) {
        return secretManagerConfig_ == null
            ? com.google.container.v1.SecretManagerConfig.getDefaultInstance()
            : secretManagerConfig_;
      } else {
        return secretManagerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    public Builder setSecretManagerConfig(com.google.container.v1.SecretManagerConfig value) {
      if (secretManagerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        secretManagerConfig_ = value;
      } else {
        secretManagerConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    public Builder setSecretManagerConfig(
        com.google.container.v1.SecretManagerConfig.Builder builderForValue) {
      if (secretManagerConfigBuilder_ == null) {
        secretManagerConfig_ = builderForValue.build();
      } else {
        secretManagerConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    public Builder mergeSecretManagerConfig(com.google.container.v1.SecretManagerConfig value) {
      if (secretManagerConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000010) != 0)
            && secretManagerConfig_ != null
            && secretManagerConfig_
                != com.google.container.v1.SecretManagerConfig.getDefaultInstance()) {
          getSecretManagerConfigBuilder().mergeFrom(value);
        } else {
          secretManagerConfig_ = value;
        }
      } else {
        secretManagerConfigBuilder_.mergeFrom(value);
      }
      if (secretManagerConfig_ != null) {
        bitField2_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    public Builder clearSecretManagerConfig() {
      bitField2_ = (bitField2_ & ~0x00000010);
      secretManagerConfig_ = null;
      if (secretManagerConfigBuilder_ != null) {
        secretManagerConfigBuilder_.dispose();
        secretManagerConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    public com.google.container.v1.SecretManagerConfig.Builder getSecretManagerConfigBuilder() {
      bitField2_ |= 0x00000010;
      onChanged();
      return getSecretManagerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    public com.google.container.v1.SecretManagerConfigOrBuilder getSecretManagerConfigOrBuilder() {
      if (secretManagerConfigBuilder_ != null) {
        return secretManagerConfigBuilder_.getMessageOrBuilder();
      } else {
        return secretManagerConfig_ == null
            ? com.google.container.v1.SecretManagerConfig.getDefaultInstance()
            : secretManagerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Secret CSI driver configuration.
     * </pre>
     *
     * <code>.google.container.v1.SecretManagerConfig secret_manager_config = 150;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.SecretManagerConfig,
            com.google.container.v1.SecretManagerConfig.Builder,
            com.google.container.v1.SecretManagerConfigOrBuilder>
        getSecretManagerConfigFieldBuilder() {
      if (secretManagerConfigBuilder_ == null) {
        secretManagerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.SecretManagerConfig,
                com.google.container.v1.SecretManagerConfig.Builder,
                com.google.container.v1.SecretManagerConfigOrBuilder>(
                getSecretManagerConfig(), getParentForChildren(), isClean());
        secretManagerConfig_ = null;
      }
      return secretManagerConfigBuilder_;
    }

    private com.google.container.v1.CompliancePostureConfig compliancePostureConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.CompliancePostureConfig,
            com.google.container.v1.CompliancePostureConfig.Builder,
            com.google.container.v1.CompliancePostureConfigOrBuilder>
        compliancePostureConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     *
     * @return Whether the compliancePostureConfig field is set.
     */
    public boolean hasCompliancePostureConfig() {
      return ((bitField2_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     *
     * @return The compliancePostureConfig.
     */
    public com.google.container.v1.CompliancePostureConfig getCompliancePostureConfig() {
      if (compliancePostureConfigBuilder_ == null) {
        return compliancePostureConfig_ == null
            ? com.google.container.v1.CompliancePostureConfig.getDefaultInstance()
            : compliancePostureConfig_;
      } else {
        return compliancePostureConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    public Builder setCompliancePostureConfig(
        com.google.container.v1.CompliancePostureConfig value) {
      if (compliancePostureConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compliancePostureConfig_ = value;
      } else {
        compliancePostureConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    public Builder setCompliancePostureConfig(
        com.google.container.v1.CompliancePostureConfig.Builder builderForValue) {
      if (compliancePostureConfigBuilder_ == null) {
        compliancePostureConfig_ = builderForValue.build();
      } else {
        compliancePostureConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    public Builder mergeCompliancePostureConfig(
        com.google.container.v1.CompliancePostureConfig value) {
      if (compliancePostureConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000020) != 0)
            && compliancePostureConfig_ != null
            && compliancePostureConfig_
                != com.google.container.v1.CompliancePostureConfig.getDefaultInstance()) {
          getCompliancePostureConfigBuilder().mergeFrom(value);
        } else {
          compliancePostureConfig_ = value;
        }
      } else {
        compliancePostureConfigBuilder_.mergeFrom(value);
      }
      if (compliancePostureConfig_ != null) {
        bitField2_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    public Builder clearCompliancePostureConfig() {
      bitField2_ = (bitField2_ & ~0x00000020);
      compliancePostureConfig_ = null;
      if (compliancePostureConfigBuilder_ != null) {
        compliancePostureConfigBuilder_.dispose();
        compliancePostureConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    public com.google.container.v1.CompliancePostureConfig.Builder
        getCompliancePostureConfigBuilder() {
      bitField2_ |= 0x00000020;
      onChanged();
      return getCompliancePostureConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    public com.google.container.v1.CompliancePostureConfigOrBuilder
        getCompliancePostureConfigOrBuilder() {
      if (compliancePostureConfigBuilder_ != null) {
        return compliancePostureConfigBuilder_.getMessageOrBuilder();
      } else {
        return compliancePostureConfig_ == null
            ? com.google.container.v1.CompliancePostureConfig.getDefaultInstance()
            : compliancePostureConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Compliance Posture features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1.CompliancePostureConfig compliance_posture_config = 151;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.CompliancePostureConfig,
            com.google.container.v1.CompliancePostureConfig.Builder,
            com.google.container.v1.CompliancePostureConfigOrBuilder>
        getCompliancePostureConfigFieldBuilder() {
      if (compliancePostureConfigBuilder_ == null) {
        compliancePostureConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.CompliancePostureConfig,
                com.google.container.v1.CompliancePostureConfig.Builder,
                com.google.container.v1.CompliancePostureConfigOrBuilder>(
                getCompliancePostureConfig(), getParentForChildren(), isClean());
        compliancePostureConfig_ = null;
      }
      return compliancePostureConfigBuilder_;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField2_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField2_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField2_ = (bitField2_ & ~0x00000040);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the satisfiesPzi field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzi() {
      return ((bitField2_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField2_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField2_ = (bitField2_ & ~0x00000080);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1.UserManagedKeysConfig userManagedKeysConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.UserManagedKeysConfig,
            com.google.container.v1.UserManagedKeysConfig.Builder,
            com.google.container.v1.UserManagedKeysConfigOrBuilder>
        userManagedKeysConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     *
     * @return Whether the userManagedKeysConfig field is set.
     */
    public boolean hasUserManagedKeysConfig() {
      return ((bitField2_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     *
     * @return The userManagedKeysConfig.
     */
    public com.google.container.v1.UserManagedKeysConfig getUserManagedKeysConfig() {
      if (userManagedKeysConfigBuilder_ == null) {
        return userManagedKeysConfig_ == null
            ? com.google.container.v1.UserManagedKeysConfig.getDefaultInstance()
            : userManagedKeysConfig_;
      } else {
        return userManagedKeysConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    public Builder setUserManagedKeysConfig(com.google.container.v1.UserManagedKeysConfig value) {
      if (userManagedKeysConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userManagedKeysConfig_ = value;
      } else {
        userManagedKeysConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    public Builder setUserManagedKeysConfig(
        com.google.container.v1.UserManagedKeysConfig.Builder builderForValue) {
      if (userManagedKeysConfigBuilder_ == null) {
        userManagedKeysConfig_ = builderForValue.build();
      } else {
        userManagedKeysConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    public Builder mergeUserManagedKeysConfig(com.google.container.v1.UserManagedKeysConfig value) {
      if (userManagedKeysConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000100) != 0)
            && userManagedKeysConfig_ != null
            && userManagedKeysConfig_
                != com.google.container.v1.UserManagedKeysConfig.getDefaultInstance()) {
          getUserManagedKeysConfigBuilder().mergeFrom(value);
        } else {
          userManagedKeysConfig_ = value;
        }
      } else {
        userManagedKeysConfigBuilder_.mergeFrom(value);
      }
      if (userManagedKeysConfig_ != null) {
        bitField2_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    public Builder clearUserManagedKeysConfig() {
      bitField2_ = (bitField2_ & ~0x00000100);
      userManagedKeysConfig_ = null;
      if (userManagedKeysConfigBuilder_ != null) {
        userManagedKeysConfigBuilder_.dispose();
        userManagedKeysConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    public com.google.container.v1.UserManagedKeysConfig.Builder getUserManagedKeysConfigBuilder() {
      bitField2_ |= 0x00000100;
      onChanged();
      return getUserManagedKeysConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    public com.google.container.v1.UserManagedKeysConfigOrBuilder
        getUserManagedKeysConfigOrBuilder() {
      if (userManagedKeysConfigBuilder_ != null) {
        return userManagedKeysConfigBuilder_.getMessageOrBuilder();
      } else {
        return userManagedKeysConfig_ == null
            ? com.google.container.v1.UserManagedKeysConfig.getDefaultInstance()
            : userManagedKeysConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The Custom keys configuration for the cluster.
     * </pre>
     *
     * <code>optional .google.container.v1.UserManagedKeysConfig user_managed_keys_config = 154;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.UserManagedKeysConfig,
            com.google.container.v1.UserManagedKeysConfig.Builder,
            com.google.container.v1.UserManagedKeysConfigOrBuilder>
        getUserManagedKeysConfigFieldBuilder() {
      if (userManagedKeysConfigBuilder_ == null) {
        userManagedKeysConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.UserManagedKeysConfig,
                com.google.container.v1.UserManagedKeysConfig.Builder,
                com.google.container.v1.UserManagedKeysConfigOrBuilder>(
                getUserManagedKeysConfig(), getParentForChildren(), isClean());
        userManagedKeysConfig_ = null;
      }
      return userManagedKeysConfigBuilder_;
    }

    private com.google.container.v1.RBACBindingConfig rbacBindingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.RBACBindingConfig,
            com.google.container.v1.RBACBindingConfig.Builder,
            com.google.container.v1.RBACBindingConfigOrBuilder>
        rbacBindingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     *
     * @return Whether the rbacBindingConfig field is set.
     */
    public boolean hasRbacBindingConfig() {
      return ((bitField2_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     *
     * @return The rbacBindingConfig.
     */
    public com.google.container.v1.RBACBindingConfig getRbacBindingConfig() {
      if (rbacBindingConfigBuilder_ == null) {
        return rbacBindingConfig_ == null
            ? com.google.container.v1.RBACBindingConfig.getDefaultInstance()
            : rbacBindingConfig_;
      } else {
        return rbacBindingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    public Builder setRbacBindingConfig(com.google.container.v1.RBACBindingConfig value) {
      if (rbacBindingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rbacBindingConfig_ = value;
      } else {
        rbacBindingConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    public Builder setRbacBindingConfig(
        com.google.container.v1.RBACBindingConfig.Builder builderForValue) {
      if (rbacBindingConfigBuilder_ == null) {
        rbacBindingConfig_ = builderForValue.build();
      } else {
        rbacBindingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    public Builder mergeRbacBindingConfig(com.google.container.v1.RBACBindingConfig value) {
      if (rbacBindingConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000200) != 0)
            && rbacBindingConfig_ != null
            && rbacBindingConfig_
                != com.google.container.v1.RBACBindingConfig.getDefaultInstance()) {
          getRbacBindingConfigBuilder().mergeFrom(value);
        } else {
          rbacBindingConfig_ = value;
        }
      } else {
        rbacBindingConfigBuilder_.mergeFrom(value);
      }
      if (rbacBindingConfig_ != null) {
        bitField2_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    public Builder clearRbacBindingConfig() {
      bitField2_ = (bitField2_ & ~0x00000200);
      rbacBindingConfig_ = null;
      if (rbacBindingConfigBuilder_ != null) {
        rbacBindingConfigBuilder_.dispose();
        rbacBindingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    public com.google.container.v1.RBACBindingConfig.Builder getRbacBindingConfigBuilder() {
      bitField2_ |= 0x00000200;
      onChanged();
      return getRbacBindingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    public com.google.container.v1.RBACBindingConfigOrBuilder getRbacBindingConfigOrBuilder() {
      if (rbacBindingConfigBuilder_ != null) {
        return rbacBindingConfigBuilder_.getMessageOrBuilder();
      } else {
        return rbacBindingConfig_ == null
            ? com.google.container.v1.RBACBindingConfig.getDefaultInstance()
            : rbacBindingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * RBACBindingConfig allows user to restrict ClusterRoleBindings an
     * RoleBindings that can be created.
     * </pre>
     *
     * <code>optional .google.container.v1.RBACBindingConfig rbac_binding_config = 156;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.RBACBindingConfig,
            com.google.container.v1.RBACBindingConfig.Builder,
            com.google.container.v1.RBACBindingConfigOrBuilder>
        getRbacBindingConfigFieldBuilder() {
      if (rbacBindingConfigBuilder_ == null) {
        rbacBindingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.RBACBindingConfig,
                com.google.container.v1.RBACBindingConfig.Builder,
                com.google.container.v1.RBACBindingConfigOrBuilder>(
                getRbacBindingConfig(), getParentForChildren(), isClean());
        rbacBindingConfig_ = null;
      }
      return rbacBindingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.Cluster)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.Cluster)
  private static final com.google.container.v1.Cluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.Cluster();
  }

  public static com.google.container.v1.Cluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cluster> PARSER =
      new com.google.protobuf.AbstractParser<Cluster>() {
        @java.lang.Override
        public Cluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.Cluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
