/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

public interface ClusterUpdateOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.container.v1.ClusterUpdate)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the nodes to (typically an
   * upgrade).
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the Kubernetes master version
   * </pre>
   *
   * <code>string desired_node_version = 4;</code>
   *
   * @return The desiredNodeVersion.
   */
  java.lang.String getDesiredNodeVersion();
  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the nodes to (typically an
   * upgrade).
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the Kubernetes master version
   * </pre>
   *
   * <code>string desired_node_version = 4;</code>
   *
   * @return The bytes for desiredNodeVersion.
   */
  com.google.protobuf.ByteString getDesiredNodeVersionBytes();

  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_monitoring_service = 5;</code>
   *
   * @return The desiredMonitoringService.
   */
  java.lang.String getDesiredMonitoringService();
  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_monitoring_service = 5;</code>
   *
   * @return The bytes for desiredMonitoringService.
   */
  com.google.protobuf.ByteString getDesiredMonitoringServiceBytes();

  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
   *
   * @return Whether the desiredAddonsConfig field is set.
   */
  boolean hasDesiredAddonsConfig();
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
   *
   * @return The desiredAddonsConfig.
   */
  com.google.container.v1.AddonsConfig getDesiredAddonsConfig();
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
   */
  com.google.container.v1.AddonsConfigOrBuilder getDesiredAddonsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The node pool to be upgraded. This field is mandatory if
   * "desired_node_version", "desired_image_family" or
   * "desired_node_pool_autoscaling" is specified and there is more than one
   * node pool on the cluster.
   * </pre>
   *
   * <code>string desired_node_pool_id = 7;</code>
   *
   * @return The desiredNodePoolId.
   */
  java.lang.String getDesiredNodePoolId();
  /**
   *
   *
   * <pre>
   * The node pool to be upgraded. This field is mandatory if
   * "desired_node_version", "desired_image_family" or
   * "desired_node_pool_autoscaling" is specified and there is more than one
   * node pool on the cluster.
   * </pre>
   *
   * <code>string desired_node_pool_id = 7;</code>
   *
   * @return The bytes for desiredNodePoolId.
   */
  com.google.protobuf.ByteString getDesiredNodePoolIdBytes();

  /**
   *
   *
   * <pre>
   * The desired image type for the node pool.
   * NOTE: Set the "desired_node_pool" field as well.
   * </pre>
   *
   * <code>string desired_image_type = 8;</code>
   *
   * @return The desiredImageType.
   */
  java.lang.String getDesiredImageType();
  /**
   *
   *
   * <pre>
   * The desired image type for the node pool.
   * NOTE: Set the "desired_node_pool" field as well.
   * </pre>
   *
   * <code>string desired_image_type = 8;</code>
   *
   * @return The bytes for desiredImageType.
   */
  com.google.protobuf.ByteString getDesiredImageTypeBytes();

  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
   *
   * @return Whether the desiredDatabaseEncryption field is set.
   */
  boolean hasDesiredDatabaseEncryption();
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
   *
   * @return The desiredDatabaseEncryption.
   */
  com.google.container.v1.DatabaseEncryption getDesiredDatabaseEncryption();
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
   */
  com.google.container.v1.DatabaseEncryptionOrBuilder getDesiredDatabaseEncryptionOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for Workload Identity.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
   *
   * @return Whether the desiredWorkloadIdentityConfig field is set.
   */
  boolean hasDesiredWorkloadIdentityConfig();
  /**
   *
   *
   * <pre>
   * Configuration for Workload Identity.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
   *
   * @return The desiredWorkloadIdentityConfig.
   */
  com.google.container.v1.WorkloadIdentityConfig getDesiredWorkloadIdentityConfig();
  /**
   *
   *
   * <pre>
   * Configuration for Workload Identity.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
   */
  com.google.container.v1.WorkloadIdentityConfigOrBuilder
      getDesiredWorkloadIdentityConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1.MeshCertificates desired_mesh_certificates = 67;</code>
   *
   * @return Whether the desiredMeshCertificates field is set.
   */
  boolean hasDesiredMeshCertificates();
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1.MeshCertificates desired_mesh_certificates = 67;</code>
   *
   * @return The desiredMeshCertificates.
   */
  com.google.container.v1.MeshCertificates getDesiredMeshCertificates();
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1.MeshCertificates desired_mesh_certificates = 67;</code>
   */
  com.google.container.v1.MeshCertificatesOrBuilder getDesiredMeshCertificatesOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for Shielded Nodes.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
   *
   * @return Whether the desiredShieldedNodes field is set.
   */
  boolean hasDesiredShieldedNodes();
  /**
   *
   *
   * <pre>
   * Configuration for Shielded Nodes.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
   *
   * @return The desiredShieldedNodes.
   */
  com.google.container.v1.ShieldedNodes getDesiredShieldedNodes();
  /**
   *
   *
   * <pre>
   * Configuration for Shielded Nodes.
   * </pre>
   *
   * <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
   */
  com.google.container.v1.ShieldedNodesOrBuilder getDesiredShieldedNodesOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1.CostManagementConfig desired_cost_management_config = 49;</code>
   *
   * @return Whether the desiredCostManagementConfig field is set.
   */
  boolean hasDesiredCostManagementConfig();
  /**
   *
   *
   * <pre>
   * The desired configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1.CostManagementConfig desired_cost_management_config = 49;</code>
   *
   * @return The desiredCostManagementConfig.
   */
  com.google.container.v1.CostManagementConfig getDesiredCostManagementConfig();
  /**
   *
   *
   * <pre>
   * The desired configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1.CostManagementConfig desired_cost_management_config = 49;</code>
   */
  com.google.container.v1.CostManagementConfigOrBuilder getDesiredCostManagementConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.DNSConfig desired_dns_config = 53;</code>
   *
   * @return Whether the desiredDnsConfig field is set.
   */
  boolean hasDesiredDnsConfig();
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.DNSConfig desired_dns_config = 53;</code>
   *
   * @return The desiredDnsConfig.
   */
  com.google.container.v1.DNSConfig getDesiredDnsConfig();
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.DNSConfig desired_dns_config = 53;</code>
   */
  com.google.container.v1.DNSConfigOrBuilder getDesiredDnsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Autoscaler configuration for the node pool specified in
   * desired_node_pool_id. If there is only one pool in the
   * cluster and desired_node_pool_id is not provided then
   * the change applies to that single node pool.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
   *
   * @return Whether the desiredNodePoolAutoscaling field is set.
   */
  boolean hasDesiredNodePoolAutoscaling();
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for the node pool specified in
   * desired_node_pool_id. If there is only one pool in the
   * cluster and desired_node_pool_id is not provided then
   * the change applies to that single node pool.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
   *
   * @return The desiredNodePoolAutoscaling.
   */
  com.google.container.v1.NodePoolAutoscaling getDesiredNodePoolAutoscaling();
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for the node pool specified in
   * desired_node_pool_id. If there is only one pool in the
   * cluster and desired_node_pool_id is not provided then
   * the change applies to that single node pool.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
   */
  com.google.container.v1.NodePoolAutoscalingOrBuilder getDesiredNodePoolAutoscalingOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @return A list containing the desiredLocations.
   */
  java.util.List<java.lang.String> getDesiredLocationsList();
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @return The count of desiredLocations.
   */
  int getDesiredLocationsCount();
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The desiredLocations at the given index.
   */
  java.lang.String getDesiredLocations(int index);
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the desiredLocations at the given index.
   */
  com.google.protobuf.ByteString getDesiredLocationsBytes(int index);

  /**
   *
   *
   * <pre>
   * The desired configuration options for master authorized networks feature.
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.authorized_networks_config
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.ClusterUpdate.desired_master_authorized_networks_config is
   *     deprecated. See google/container/v1/cluster_service.proto;l=2499
   * @return Whether the desiredMasterAuthorizedNetworksConfig field is set.
   */
  @java.lang.Deprecated
  boolean hasDesiredMasterAuthorizedNetworksConfig();
  /**
   *
   *
   * <pre>
   * The desired configuration options for master authorized networks feature.
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.authorized_networks_config
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.ClusterUpdate.desired_master_authorized_networks_config is
   *     deprecated. See google/container/v1/cluster_service.proto;l=2499
   * @return The desiredMasterAuthorizedNetworksConfig.
   */
  @java.lang.Deprecated
  com.google.container.v1.MasterAuthorizedNetworksConfig getDesiredMasterAuthorizedNetworksConfig();
  /**
   *
   *
   * <pre>
   * The desired configuration options for master authorized networks feature.
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.authorized_networks_config
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder
      getDesiredMasterAuthorizedNetworksConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
   *
   * @return Whether the desiredClusterAutoscaling field is set.
   */
  boolean hasDesiredClusterAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
   *
   * @return The desiredClusterAutoscaling.
   */
  com.google.container.v1.ClusterAutoscaling getDesiredClusterAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
   */
  com.google.container.v1.ClusterAutoscalingOrBuilder getDesiredClusterAutoscalingOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired configuration options for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
   *
   * @return Whether the desiredBinaryAuthorization field is set.
   */
  boolean hasDesiredBinaryAuthorization();
  /**
   *
   *
   * <pre>
   * The desired configuration options for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
   *
   * @return The desiredBinaryAuthorization.
   */
  com.google.container.v1.BinaryAuthorization getDesiredBinaryAuthorization();
  /**
   *
   *
   * <pre>
   * The desired configuration options for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
   */
  com.google.container.v1.BinaryAuthorizationOrBuilder getDesiredBinaryAuthorizationOrBuilder();

  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_logging_service = 19;</code>
   *
   * @return The desiredLoggingService.
   */
  java.lang.String getDesiredLoggingService();
  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_logging_service = 19;</code>
   *
   * @return The bytes for desiredLoggingService.
   */
  com.google.protobuf.ByteString getDesiredLoggingServiceBytes();

  /**
   *
   *
   * <pre>
   * The desired configuration for exporting resource usage.
   * </pre>
   *
   * <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
   * </code>
   *
   * @return Whether the desiredResourceUsageExportConfig field is set.
   */
  boolean hasDesiredResourceUsageExportConfig();
  /**
   *
   *
   * <pre>
   * The desired configuration for exporting resource usage.
   * </pre>
   *
   * <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
   * </code>
   *
   * @return The desiredResourceUsageExportConfig.
   */
  com.google.container.v1.ResourceUsageExportConfig getDesiredResourceUsageExportConfig();
  /**
   *
   *
   * <pre>
   * The desired configuration for exporting resource usage.
   * </pre>
   *
   * <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
   * </code>
   */
  com.google.container.v1.ResourceUsageExportConfigOrBuilder
      getDesiredResourceUsageExportConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
   *
   * @return Whether the desiredVerticalPodAutoscaling field is set.
   */
  boolean hasDesiredVerticalPodAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
   *
   * @return The desiredVerticalPodAutoscaling.
   */
  com.google.container.v1.VerticalPodAutoscaling getDesiredVerticalPodAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
   */
  com.google.container.v1.VerticalPodAutoscalingOrBuilder
      getDesiredVerticalPodAutoscalingOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. master_global_access_config is
   * the only field that can be changed via this field.
   * See also
   * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
   * for modifying other fields within
   * [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.global_access
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.ClusterUpdate.desired_private_cluster_config is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2537
   * @return Whether the desiredPrivateClusterConfig field is set.
   */
  @java.lang.Deprecated
  boolean hasDesiredPrivateClusterConfig();
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. master_global_access_config is
   * the only field that can be changed via this field.
   * See also
   * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
   * for modifying other fields within
   * [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.global_access
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.ClusterUpdate.desired_private_cluster_config is deprecated. See
   *     google/container/v1/cluster_service.proto;l=2537
   * @return The desiredPrivateClusterConfig.
   */
  @java.lang.Deprecated
  com.google.container.v1.PrivateClusterConfig getDesiredPrivateClusterConfig();
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. master_global_access_config is
   * the only field that can be changed via this field.
   * See also
   * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
   * for modifying other fields within
   * [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.global_access
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.container.v1.PrivateClusterConfigOrBuilder getDesiredPrivateClusterConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired config of Intra-node visibility.
   * </pre>
   *
   * <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
   * </code>
   *
   * @return Whether the desiredIntraNodeVisibilityConfig field is set.
   */
  boolean hasDesiredIntraNodeVisibilityConfig();
  /**
   *
   *
   * <pre>
   * The desired config of Intra-node visibility.
   * </pre>
   *
   * <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
   * </code>
   *
   * @return The desiredIntraNodeVisibilityConfig.
   */
  com.google.container.v1.IntraNodeVisibilityConfig getDesiredIntraNodeVisibilityConfig();
  /**
   *
   *
   * <pre>
   * The desired config of Intra-node visibility.
   * </pre>
   *
   * <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
   * </code>
   */
  com.google.container.v1.IntraNodeVisibilityConfigOrBuilder
      getDesiredIntraNodeVisibilityConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired status of whether to disable default sNAT for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
   *
   * @return Whether the desiredDefaultSnatStatus field is set.
   */
  boolean hasDesiredDefaultSnatStatus();
  /**
   *
   *
   * <pre>
   * The desired status of whether to disable default sNAT for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
   *
   * @return The desiredDefaultSnatStatus.
   */
  com.google.container.v1.DefaultSnatStatus getDesiredDefaultSnatStatus();
  /**
   *
   *
   * <pre>
   * The desired status of whether to disable default sNAT for this cluster.
   * </pre>
   *
   * <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
   */
  com.google.container.v1.DefaultSnatStatusOrBuilder getDesiredDefaultSnatStatusOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired release channel configuration.
   * </pre>
   *
   * <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
   *
   * @return Whether the desiredReleaseChannel field is set.
   */
  boolean hasDesiredReleaseChannel();
  /**
   *
   *
   * <pre>
   * The desired release channel configuration.
   * </pre>
   *
   * <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
   *
   * @return The desiredReleaseChannel.
   */
  com.google.container.v1.ReleaseChannel getDesiredReleaseChannel();
  /**
   *
   *
   * <pre>
   * The desired release channel configuration.
   * </pre>
   *
   * <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
   */
  com.google.container.v1.ReleaseChannelOrBuilder getDesiredReleaseChannelOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired L4 Internal Load Balancer Subsetting configuration.
   * </pre>
   *
   * <code>.google.container.v1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;</code>
   *
   * @return Whether the desiredL4ilbSubsettingConfig field is set.
   */
  boolean hasDesiredL4IlbSubsettingConfig();
  /**
   *
   *
   * <pre>
   * The desired L4 Internal Load Balancer Subsetting configuration.
   * </pre>
   *
   * <code>.google.container.v1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;</code>
   *
   * @return The desiredL4ilbSubsettingConfig.
   */
  com.google.container.v1.ILBSubsettingConfig getDesiredL4IlbSubsettingConfig();
  /**
   *
   *
   * <pre>
   * The desired L4 Internal Load Balancer Subsetting configuration.
   * </pre>
   *
   * <code>.google.container.v1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;</code>
   */
  com.google.container.v1.ILBSubsettingConfigOrBuilder getDesiredL4IlbSubsettingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired datapath provider for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.DatapathProvider desired_datapath_provider = 50;</code>
   *
   * @return The enum numeric value on the wire for desiredDatapathProvider.
   */
  int getDesiredDatapathProviderValue();
  /**
   *
   *
   * <pre>
   * The desired datapath provider for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.DatapathProvider desired_datapath_provider = 50;</code>
   *
   * @return The desiredDatapathProvider.
   */
  com.google.container.v1.DatapathProvider getDesiredDatapathProvider();

  /**
   *
   *
   * <pre>
   * The desired state of IPv6 connectivity to Google Services.
   * </pre>
   *
   * <code>.google.container.v1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
   * </code>
   *
   * @return The enum numeric value on the wire for desiredPrivateIpv6GoogleAccess.
   */
  int getDesiredPrivateIpv6GoogleAccessValue();
  /**
   *
   *
   * <pre>
   * The desired state of IPv6 connectivity to Google Services.
   * </pre>
   *
   * <code>.google.container.v1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
   * </code>
   *
   * @return The desiredPrivateIpv6GoogleAccess.
   */
  com.google.container.v1.PrivateIPv6GoogleAccess getDesiredPrivateIpv6GoogleAccess();

  /**
   *
   *
   * <pre>
   * The desired notification configuration.
   * </pre>
   *
   * <code>.google.container.v1.NotificationConfig desired_notification_config = 55;</code>
   *
   * @return Whether the desiredNotificationConfig field is set.
   */
  boolean hasDesiredNotificationConfig();
  /**
   *
   *
   * <pre>
   * The desired notification configuration.
   * </pre>
   *
   * <code>.google.container.v1.NotificationConfig desired_notification_config = 55;</code>
   *
   * @return The desiredNotificationConfig.
   */
  com.google.container.v1.NotificationConfig getDesiredNotificationConfig();
  /**
   *
   *
   * <pre>
   * The desired notification configuration.
   * </pre>
   *
   * <code>.google.container.v1.NotificationConfig desired_notification_config = 55;</code>
   */
  com.google.container.v1.NotificationConfigOrBuilder getDesiredNotificationConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired authenticator groups config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
   * </code>
   *
   * @return Whether the desiredAuthenticatorGroupsConfig field is set.
   */
  boolean hasDesiredAuthenticatorGroupsConfig();
  /**
   *
   *
   * <pre>
   * The desired authenticator groups config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
   * </code>
   *
   * @return The desiredAuthenticatorGroupsConfig.
   */
  com.google.container.v1.AuthenticatorGroupsConfig getDesiredAuthenticatorGroupsConfig();
  /**
   *
   *
   * <pre>
   * The desired authenticator groups config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
   * </code>
   */
  com.google.container.v1.AuthenticatorGroupsConfigOrBuilder
      getDesiredAuthenticatorGroupsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.LoggingConfig desired_logging_config = 64;</code>
   *
   * @return Whether the desiredLoggingConfig field is set.
   */
  boolean hasDesiredLoggingConfig();
  /**
   *
   *
   * <pre>
   * The desired logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.LoggingConfig desired_logging_config = 64;</code>
   *
   * @return The desiredLoggingConfig.
   */
  com.google.container.v1.LoggingConfig getDesiredLoggingConfig();
  /**
   *
   *
   * <pre>
   * The desired logging configuration.
   * </pre>
   *
   * <code>.google.container.v1.LoggingConfig desired_logging_config = 64;</code>
   */
  com.google.container.v1.LoggingConfigOrBuilder getDesiredLoggingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired monitoring configuration.
   * </pre>
   *
   * <code>.google.container.v1.MonitoringConfig desired_monitoring_config = 65;</code>
   *
   * @return Whether the desiredMonitoringConfig field is set.
   */
  boolean hasDesiredMonitoringConfig();
  /**
   *
   *
   * <pre>
   * The desired monitoring configuration.
   * </pre>
   *
   * <code>.google.container.v1.MonitoringConfig desired_monitoring_config = 65;</code>
   *
   * @return The desiredMonitoringConfig.
   */
  com.google.container.v1.MonitoringConfig getDesiredMonitoringConfig();
  /**
   *
   *
   * <pre>
   * The desired monitoring configuration.
   * </pre>
   *
   * <code>.google.container.v1.MonitoringConfig desired_monitoring_config = 65;</code>
   */
  com.google.container.v1.MonitoringConfigOrBuilder getDesiredMonitoringConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired Identity Service component configuration.
   * </pre>
   *
   * <code>.google.container.v1.IdentityServiceConfig desired_identity_service_config = 66;</code>
   *
   * @return Whether the desiredIdentityServiceConfig field is set.
   */
  boolean hasDesiredIdentityServiceConfig();
  /**
   *
   *
   * <pre>
   * The desired Identity Service component configuration.
   * </pre>
   *
   * <code>.google.container.v1.IdentityServiceConfig desired_identity_service_config = 66;</code>
   *
   * @return The desiredIdentityServiceConfig.
   */
  com.google.container.v1.IdentityServiceConfig getDesiredIdentityServiceConfig();
  /**
   *
   *
   * <pre>
   * The desired Identity Service component configuration.
   * </pre>
   *
   * <code>.google.container.v1.IdentityServiceConfig desired_identity_service_config = 66;</code>
   */
  com.google.container.v1.IdentityServiceConfigOrBuilder getDesiredIdentityServiceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies the config for the use of Services with
   * ExternalIPs field.
   * </pre>
   *
   * <code>.google.container.v1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
   * </code>
   *
   * @return Whether the desiredServiceExternalIpsConfig field is set.
   */
  boolean hasDesiredServiceExternalIpsConfig();
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies the config for the use of Services with
   * ExternalIPs field.
   * </pre>
   *
   * <code>.google.container.v1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
   * </code>
   *
   * @return The desiredServiceExternalIpsConfig.
   */
  com.google.container.v1.ServiceExternalIPsConfig getDesiredServiceExternalIpsConfig();
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies the config for the use of Services with
   * ExternalIPs field.
   * </pre>
   *
   * <code>.google.container.v1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
   * </code>
   */
  com.google.container.v1.ServiceExternalIPsConfigOrBuilder
      getDesiredServiceExternalIpsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable private endpoint for the cluster's master.
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.enable_public_endpoint
   * instead. Note that the value of enable_public_endpoint is reversed: if
   * enable_private_endpoint is false, then enable_public_endpoint will be true.
   * </pre>
   *
   * <code>optional bool desired_enable_private_endpoint = 71 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.ClusterUpdate.desired_enable_private_endpoint is deprecated.
   *     See google/container/v1/cluster_service.proto;l=2582
   * @return Whether the desiredEnablePrivateEndpoint field is set.
   */
  @java.lang.Deprecated
  boolean hasDesiredEnablePrivateEndpoint();
  /**
   *
   *
   * <pre>
   * Enable/Disable private endpoint for the cluster's master.
   *
   * Deprecated: Use
   * desired_control_plane_endpoints_config.ip_endpoints_config.enable_public_endpoint
   * instead. Note that the value of enable_public_endpoint is reversed: if
   * enable_private_endpoint is false, then enable_public_endpoint will be true.
   * </pre>
   *
   * <code>optional bool desired_enable_private_endpoint = 71 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.ClusterUpdate.desired_enable_private_endpoint is deprecated.
   *     See google/container/v1/cluster_service.proto;l=2582
   * @return The desiredEnablePrivateEndpoint.
   */
  @java.lang.Deprecated
  boolean getDesiredEnablePrivateEndpoint();

  /**
   *
   *
   * <pre>
   * Override the default setting of whether future created
   * nodes have private IP addresses only, namely
   * [NetworkConfig.default_enable_private_nodes][google.container.v1.NetworkConfig.default_enable_private_nodes]
   * </pre>
   *
   * <code>optional bool desired_default_enable_private_nodes = 72;</code>
   *
   * @return Whether the desiredDefaultEnablePrivateNodes field is set.
   */
  boolean hasDesiredDefaultEnablePrivateNodes();
  /**
   *
   *
   * <pre>
   * Override the default setting of whether future created
   * nodes have private IP addresses only, namely
   * [NetworkConfig.default_enable_private_nodes][google.container.v1.NetworkConfig.default_enable_private_nodes]
   * </pre>
   *
   * <code>optional bool desired_default_enable_private_nodes = 72;</code>
   *
   * @return The desiredDefaultEnablePrivateNodes.
   */
  boolean getDesiredDefaultEnablePrivateNodes();

  /**
   *
   *
   * <pre>
   * [Control plane
   * endpoints][google.container.v1.Cluster.control_plane_endpoints_config]
   * configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig desired_control_plane_endpoints_config = 73;
   * </code>
   *
   * @return Whether the desiredControlPlaneEndpointsConfig field is set.
   */
  boolean hasDesiredControlPlaneEndpointsConfig();
  /**
   *
   *
   * <pre>
   * [Control plane
   * endpoints][google.container.v1.Cluster.control_plane_endpoints_config]
   * configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig desired_control_plane_endpoints_config = 73;
   * </code>
   *
   * @return The desiredControlPlaneEndpointsConfig.
   */
  com.google.container.v1.ControlPlaneEndpointsConfig getDesiredControlPlaneEndpointsConfig();
  /**
   *
   *
   * <pre>
   * [Control plane
   * endpoints][google.container.v1.Cluster.control_plane_endpoints_config]
   * configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig desired_control_plane_endpoints_config = 73;
   * </code>
   */
  com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder
      getDesiredControlPlaneEndpointsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the master to.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string desired_master_version = 100;</code>
   *
   * @return The desiredMasterVersion.
   */
  java.lang.String getDesiredMasterVersion();
  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the master to.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string desired_master_version = 100;</code>
   *
   * @return The bytes for desiredMasterVersion.
   */
  com.google.protobuf.ByteString getDesiredMasterVersionBytes();

  /**
   *
   *
   * <pre>
   * The desired GCFS config for the cluster
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig desired_gcfs_config = 109;</code>
   *
   * @return Whether the desiredGcfsConfig field is set.
   */
  boolean hasDesiredGcfsConfig();
  /**
   *
   *
   * <pre>
   * The desired GCFS config for the cluster
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig desired_gcfs_config = 109;</code>
   *
   * @return The desiredGcfsConfig.
   */
  com.google.container.v1.GcfsConfig getDesiredGcfsConfig();
  /**
   *
   *
   * <pre>
   * The desired GCFS config for the cluster
   * </pre>
   *
   * <code>.google.container.v1.GcfsConfig desired_gcfs_config = 109;</code>
   */
  com.google.container.v1.GcfsConfigOrBuilder getDesiredGcfsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired network tags that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1.NetworkTags desired_node_pool_auto_config_network_tags = 110;</code>
   *
   * @return Whether the desiredNodePoolAutoConfigNetworkTags field is set.
   */
  boolean hasDesiredNodePoolAutoConfigNetworkTags();
  /**
   *
   *
   * <pre>
   * The desired network tags that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1.NetworkTags desired_node_pool_auto_config_network_tags = 110;</code>
   *
   * @return The desiredNodePoolAutoConfigNetworkTags.
   */
  com.google.container.v1.NetworkTags getDesiredNodePoolAutoConfigNetworkTags();
  /**
   *
   *
   * <pre>
   * The desired network tags that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1.NetworkTags desired_node_pool_auto_config_network_tags = 110;</code>
   */
  com.google.container.v1.NetworkTagsOrBuilder getDesiredNodePoolAutoConfigNetworkTagsOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired config of Gateway API on this cluster.
   * </pre>
   *
   * <code>.google.container.v1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
   *
   * @return Whether the desiredGatewayApiConfig field is set.
   */
  boolean hasDesiredGatewayApiConfig();
  /**
   *
   *
   * <pre>
   * The desired config of Gateway API on this cluster.
   * </pre>
   *
   * <code>.google.container.v1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
   *
   * @return The desiredGatewayApiConfig.
   */
  com.google.container.v1.GatewayAPIConfig getDesiredGatewayApiConfig();
  /**
   *
   *
   * <pre>
   * The desired config of Gateway API on this cluster.
   * </pre>
   *
   * <code>.google.container.v1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
   */
  com.google.container.v1.GatewayAPIConfigOrBuilder getDesiredGatewayApiConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The current etag of the cluster.
   * If an etag is provided and does not match the current etag of the cluster,
   * update will be blocked and an ABORTED error will be returned.
   * </pre>
   *
   * <code>string etag = 115;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * The current etag of the cluster.
   * If an etag is provided and does not match the current etag of the cluster,
   * update will be blocked and an ABORTED error will be returned.
   * </pre>
   *
   * <code>string etag = 115;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * The desired node pool logging configuration defaults for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;</code>
   *
   * @return Whether the desiredNodePoolLoggingConfig field is set.
   */
  boolean hasDesiredNodePoolLoggingConfig();
  /**
   *
   *
   * <pre>
   * The desired node pool logging configuration defaults for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;</code>
   *
   * @return The desiredNodePoolLoggingConfig.
   */
  com.google.container.v1.NodePoolLoggingConfig getDesiredNodePoolLoggingConfig();
  /**
   *
   *
   * <pre>
   * The desired node pool logging configuration defaults for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;</code>
   */
  com.google.container.v1.NodePoolLoggingConfigOrBuilder getDesiredNodePoolLoggingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired fleet configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Fleet desired_fleet = 117;</code>
   *
   * @return Whether the desiredFleet field is set.
   */
  boolean hasDesiredFleet();
  /**
   *
   *
   * <pre>
   * The desired fleet configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Fleet desired_fleet = 117;</code>
   *
   * @return The desiredFleet.
   */
  com.google.container.v1.Fleet getDesiredFleet();
  /**
   *
   *
   * <pre>
   * The desired fleet configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.Fleet desired_fleet = 117;</code>
   */
  com.google.container.v1.FleetOrBuilder getDesiredFleetOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired stack type of the cluster.
   * If a stack type is provided and does not match the current stack type of
   * the cluster, update will attempt to change the stack type to the new type.
   * </pre>
   *
   * <code>.google.container.v1.StackType desired_stack_type = 119;</code>
   *
   * @return The enum numeric value on the wire for desiredStackType.
   */
  int getDesiredStackTypeValue();
  /**
   *
   *
   * <pre>
   * The desired stack type of the cluster.
   * If a stack type is provided and does not match the current stack type of
   * the cluster, update will attempt to change the stack type to the new type.
   * </pre>
   *
   * <code>.google.container.v1.StackType desired_stack_type = 119;</code>
   *
   * @return The desiredStackType.
   */
  com.google.container.v1.StackType getDesiredStackType();

  /**
   *
   *
   * <pre>
   * The additional pod ranges to be added to the cluster. These pod ranges
   * can be used by node pools to allocate pod IPs.
   * </pre>
   *
   * <code>.google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;</code>
   *
   * @return Whether the additionalPodRangesConfig field is set.
   */
  boolean hasAdditionalPodRangesConfig();
  /**
   *
   *
   * <pre>
   * The additional pod ranges to be added to the cluster. These pod ranges
   * can be used by node pools to allocate pod IPs.
   * </pre>
   *
   * <code>.google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;</code>
   *
   * @return The additionalPodRangesConfig.
   */
  com.google.container.v1.AdditionalPodRangesConfig getAdditionalPodRangesConfig();
  /**
   *
   *
   * <pre>
   * The additional pod ranges to be added to the cluster. These pod ranges
   * can be used by node pools to allocate pod IPs.
   * </pre>
   *
   * <code>.google.container.v1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;</code>
   */
  com.google.container.v1.AdditionalPodRangesConfigOrBuilder
      getAdditionalPodRangesConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The additional pod ranges that are to be removed from the cluster.
   * The pod ranges specified here must have been specified earlier in the
   * 'additional_pod_ranges_config' argument.
   * </pre>
   *
   * <code>
   * .google.container.v1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
   * </code>
   *
   * @return Whether the removedAdditionalPodRangesConfig field is set.
   */
  boolean hasRemovedAdditionalPodRangesConfig();
  /**
   *
   *
   * <pre>
   * The additional pod ranges that are to be removed from the cluster.
   * The pod ranges specified here must have been specified earlier in the
   * 'additional_pod_ranges_config' argument.
   * </pre>
   *
   * <code>
   * .google.container.v1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
   * </code>
   *
   * @return The removedAdditionalPodRangesConfig.
   */
  com.google.container.v1.AdditionalPodRangesConfig getRemovedAdditionalPodRangesConfig();
  /**
   *
   *
   * <pre>
   * The additional pod ranges that are to be removed from the cluster.
   * The pod ranges specified here must have been specified earlier in the
   * 'additional_pod_ranges_config' argument.
   * </pre>
   *
   * <code>
   * .google.container.v1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
   * </code>
   */
  com.google.container.v1.AdditionalPodRangesConfigOrBuilder
      getRemovedAdditionalPodRangesConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
   *
   * @return Whether the enableK8sBetaApis field is set.
   */
  boolean hasEnableK8SBetaApis();
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
   *
   * @return The enableK8sBetaApis.
   */
  com.google.container.v1.K8sBetaAPIConfig getEnableK8SBetaApis();
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
   */
  com.google.container.v1.K8sBetaAPIConfigOrBuilder getEnableK8SBetaApisOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.SecurityPostureConfig desired_security_posture_config = 124;</code>
   *
   * @return Whether the desiredSecurityPostureConfig field is set.
   */
  boolean hasDesiredSecurityPostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.SecurityPostureConfig desired_security_posture_config = 124;</code>
   *
   * @return The desiredSecurityPostureConfig.
   */
  com.google.container.v1.SecurityPostureConfig getDesiredSecurityPostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.SecurityPostureConfig desired_security_posture_config = 124;</code>
   */
  com.google.container.v1.SecurityPostureConfigOrBuilder getDesiredSecurityPostureConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired network performance config.
   * </pre>
   *
   * <code>
   * .google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
   * </code>
   *
   * @return Whether the desiredNetworkPerformanceConfig field is set.
   */
  boolean hasDesiredNetworkPerformanceConfig();
  /**
   *
   *
   * <pre>
   * The desired network performance config.
   * </pre>
   *
   * <code>
   * .google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
   * </code>
   *
   * @return The desiredNetworkPerformanceConfig.
   */
  com.google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig
      getDesiredNetworkPerformanceConfig();
  /**
   *
   *
   * <pre>
   * The desired network performance config.
   * </pre>
   *
   * <code>
   * .google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
   * </code>
   */
  com.google.container.v1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder
      getDesiredNetworkPerformanceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable FQDN Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
   *
   * @return Whether the desiredEnableFqdnNetworkPolicy field is set.
   */
  boolean hasDesiredEnableFqdnNetworkPolicy();
  /**
   *
   *
   * <pre>
   * Enable/Disable FQDN Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
   *
   * @return The desiredEnableFqdnNetworkPolicy.
   */
  boolean getDesiredEnableFqdnNetworkPolicy();

  /**
   *
   *
   * <pre>
   * The desired workload policy configuration for the autopilot cluster.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
   * </code>
   *
   * @return Whether the desiredAutopilotWorkloadPolicyConfig field is set.
   */
  boolean hasDesiredAutopilotWorkloadPolicyConfig();
  /**
   *
   *
   * <pre>
   * The desired workload policy configuration for the autopilot cluster.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
   * </code>
   *
   * @return The desiredAutopilotWorkloadPolicyConfig.
   */
  com.google.container.v1.WorkloadPolicyConfig getDesiredAutopilotWorkloadPolicyConfig();
  /**
   *
   *
   * <pre>
   * The desired workload policy configuration for the autopilot cluster.
   * </pre>
   *
   * <code>.google.container.v1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
   * </code>
   */
  com.google.container.v1.WorkloadPolicyConfigOrBuilder
      getDesiredAutopilotWorkloadPolicyConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Desired Beta APIs to be enabled for cluster.
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
   *
   * @return Whether the desiredK8sBetaApis field is set.
   */
  boolean hasDesiredK8SBetaApis();
  /**
   *
   *
   * <pre>
   * Desired Beta APIs to be enabled for cluster.
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
   *
   * @return The desiredK8sBetaApis.
   */
  com.google.container.v1.K8sBetaAPIConfig getDesiredK8SBetaApis();
  /**
   *
   *
   * <pre>
   * Desired Beta APIs to be enabled for cluster.
   * </pre>
   *
   * <code>.google.container.v1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
   */
  com.google.container.v1.K8sBetaAPIConfigOrBuilder getDesiredK8SBetaApisOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired containerd config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig desired_containerd_config = 134;</code>
   *
   * @return Whether the desiredContainerdConfig field is set.
   */
  boolean hasDesiredContainerdConfig();
  /**
   *
   *
   * <pre>
   * The desired containerd config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig desired_containerd_config = 134;</code>
   *
   * @return The desiredContainerdConfig.
   */
  com.google.container.v1.ContainerdConfig getDesiredContainerdConfig();
  /**
   *
   *
   * <pre>
   * The desired containerd config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.ContainerdConfig desired_containerd_config = 134;</code>
   */
  com.google.container.v1.ContainerdConfigOrBuilder getDesiredContainerdConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable Multi-Networking for the cluster
   * </pre>
   *
   * <code>optional bool desired_enable_multi_networking = 135;</code>
   *
   * @return Whether the desiredEnableMultiNetworking field is set.
   */
  boolean hasDesiredEnableMultiNetworking();
  /**
   *
   *
   * <pre>
   * Enable/Disable Multi-Networking for the cluster
   * </pre>
   *
   * <code>optional bool desired_enable_multi_networking = 135;</code>
   *
   * @return The desiredEnableMultiNetworking.
   */
  boolean getDesiredEnableMultiNetworking();

  /**
   *
   *
   * <pre>
   * The desired resource manager tags that apply to all auto-provisioned node
   * pools in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
   * </code>
   *
   * @return Whether the desiredNodePoolAutoConfigResourceManagerTags field is set.
   */
  boolean hasDesiredNodePoolAutoConfigResourceManagerTags();
  /**
   *
   *
   * <pre>
   * The desired resource manager tags that apply to all auto-provisioned node
   * pools in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
   * </code>
   *
   * @return The desiredNodePoolAutoConfigResourceManagerTags.
   */
  com.google.container.v1.ResourceManagerTags getDesiredNodePoolAutoConfigResourceManagerTags();
  /**
   *
   *
   * <pre>
   * The desired resource manager tags that apply to all auto-provisioned node
   * pools in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
   * </code>
   */
  com.google.container.v1.ResourceManagerTagsOrBuilder
      getDesiredNodePoolAutoConfigResourceManagerTagsOrBuilder();

  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
   * </code>
   *
   * @return Whether the desiredInTransitEncryptionConfig field is set.
   */
  boolean hasDesiredInTransitEncryptionConfig();
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
   * </code>
   *
   * @return The enum numeric value on the wire for desiredInTransitEncryptionConfig.
   */
  int getDesiredInTransitEncryptionConfigValue();
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
   * </code>
   *
   * @return The desiredInTransitEncryptionConfig.
   */
  com.google.container.v1.InTransitEncryptionConfig getDesiredInTransitEncryptionConfig();

  /**
   *
   *
   * <pre>
   * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
   *
   * @return Whether the desiredEnableCiliumClusterwideNetworkPolicy field is set.
   */
  boolean hasDesiredEnableCiliumClusterwideNetworkPolicy();
  /**
   *
   *
   * <pre>
   * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
   *
   * @return The desiredEnableCiliumClusterwideNetworkPolicy.
   */
  boolean getDesiredEnableCiliumClusterwideNetworkPolicy();

  /**
   *
   *
   * <pre>
   * Enable/Disable Secret Manager Config.
   * </pre>
   *
   * <code>optional .google.container.v1.SecretManagerConfig desired_secret_manager_config = 139;
   * </code>
   *
   * @return Whether the desiredSecretManagerConfig field is set.
   */
  boolean hasDesiredSecretManagerConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Secret Manager Config.
   * </pre>
   *
   * <code>optional .google.container.v1.SecretManagerConfig desired_secret_manager_config = 139;
   * </code>
   *
   * @return The desiredSecretManagerConfig.
   */
  com.google.container.v1.SecretManagerConfig getDesiredSecretManagerConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Secret Manager Config.
   * </pre>
   *
   * <code>optional .google.container.v1.SecretManagerConfig desired_secret_manager_config = 139;
   * </code>
   */
  com.google.container.v1.SecretManagerConfigOrBuilder getDesiredSecretManagerConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.CompliancePostureConfig desired_compliance_posture_config = 140;
   * </code>
   *
   * @return Whether the desiredCompliancePostureConfig field is set.
   */
  boolean hasDesiredCompliancePostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.CompliancePostureConfig desired_compliance_posture_config = 140;
   * </code>
   *
   * @return The desiredCompliancePostureConfig.
   */
  com.google.container.v1.CompliancePostureConfig getDesiredCompliancePostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1.CompliancePostureConfig desired_compliance_posture_config = 140;
   * </code>
   */
  com.google.container.v1.CompliancePostureConfigOrBuilder
      getDesiredCompliancePostureConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired node kubelet config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
   *
   * @return Whether the desiredNodeKubeletConfig field is set.
   */
  boolean hasDesiredNodeKubeletConfig();
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
   *
   * @return The desiredNodeKubeletConfig.
   */
  com.google.container.v1.NodeKubeletConfig getDesiredNodeKubeletConfig();
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
   */
  com.google.container.v1.NodeKubeletConfigOrBuilder getDesiredNodeKubeletConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired node kubelet config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
   * </code>
   *
   * @return Whether the desiredNodePoolAutoConfigKubeletConfig field is set.
   */
  boolean hasDesiredNodePoolAutoConfigKubeletConfig();
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
   * </code>
   *
   * @return The desiredNodePoolAutoConfigKubeletConfig.
   */
  com.google.container.v1.NodeKubeletConfig getDesiredNodePoolAutoConfigKubeletConfig();
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
   * </code>
   */
  com.google.container.v1.NodeKubeletConfigOrBuilder
      getDesiredNodePoolAutoConfigKubeletConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The Custom keys configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.UserManagedKeysConfig user_managed_keys_config = 143;</code>
   *
   * @return Whether the userManagedKeysConfig field is set.
   */
  boolean hasUserManagedKeysConfig();
  /**
   *
   *
   * <pre>
   * The Custom keys configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.UserManagedKeysConfig user_managed_keys_config = 143;</code>
   *
   * @return The userManagedKeysConfig.
   */
  com.google.container.v1.UserManagedKeysConfig getUserManagedKeysConfig();
  /**
   *
   *
   * <pre>
   * The Custom keys configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.UserManagedKeysConfig user_managed_keys_config = 143;</code>
   */
  com.google.container.v1.UserManagedKeysConfigOrBuilder getUserManagedKeysConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * RBACBindingConfig allows user to restrict ClusterRoleBindings an
   * RoleBindings that can be created.
   * </pre>
   *
   * <code>optional .google.container.v1.RBACBindingConfig desired_rbac_binding_config = 144;</code>
   *
   * @return Whether the desiredRbacBindingConfig field is set.
   */
  boolean hasDesiredRbacBindingConfig();
  /**
   *
   *
   * <pre>
   * RBACBindingConfig allows user to restrict ClusterRoleBindings an
   * RoleBindings that can be created.
   * </pre>
   *
   * <code>optional .google.container.v1.RBACBindingConfig desired_rbac_binding_config = 144;</code>
   *
   * @return The desiredRbacBindingConfig.
   */
  com.google.container.v1.RBACBindingConfig getDesiredRbacBindingConfig();
  /**
   *
   *
   * <pre>
   * RBACBindingConfig allows user to restrict ClusterRoleBindings an
   * RoleBindings that can be created.
   * </pre>
   *
   * <code>optional .google.container.v1.RBACBindingConfig desired_rbac_binding_config = 144;</code>
   */
  com.google.container.v1.RBACBindingConfigOrBuilder getDesiredRbacBindingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired enterprise configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.DesiredEnterpriseConfig desired_enterprise_config = 147;</code>
   *
   * @return Whether the desiredEnterpriseConfig field is set.
   */
  boolean hasDesiredEnterpriseConfig();
  /**
   *
   *
   * <pre>
   * The desired enterprise configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.DesiredEnterpriseConfig desired_enterprise_config = 147;</code>
   *
   * @return The desiredEnterpriseConfig.
   */
  com.google.container.v1.DesiredEnterpriseConfig getDesiredEnterpriseConfig();
  /**
   *
   *
   * <pre>
   * The desired enterprise configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1.DesiredEnterpriseConfig desired_enterprise_config = 147;</code>
   */
  com.google.container.v1.DesiredEnterpriseConfigOrBuilder getDesiredEnterpriseConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The desired Linux node config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   *
   * Currently only `cgroup_mode` can be set here.
   * </pre>
   *
   * <code>
   * .google.container.v1.LinuxNodeConfig desired_node_pool_auto_config_linux_node_config = 150;
   * </code>
   *
   * @return Whether the desiredNodePoolAutoConfigLinuxNodeConfig field is set.
   */
  boolean hasDesiredNodePoolAutoConfigLinuxNodeConfig();
  /**
   *
   *
   * <pre>
   * The desired Linux node config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   *
   * Currently only `cgroup_mode` can be set here.
   * </pre>
   *
   * <code>
   * .google.container.v1.LinuxNodeConfig desired_node_pool_auto_config_linux_node_config = 150;
   * </code>
   *
   * @return The desiredNodePoolAutoConfigLinuxNodeConfig.
   */
  com.google.container.v1.LinuxNodeConfig getDesiredNodePoolAutoConfigLinuxNodeConfig();
  /**
   *
   *
   * <pre>
   * The desired Linux node config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   *
   * Currently only `cgroup_mode` can be set here.
   * </pre>
   *
   * <code>
   * .google.container.v1.LinuxNodeConfig desired_node_pool_auto_config_linux_node_config = 150;
   * </code>
   */
  com.google.container.v1.LinuxNodeConfigOrBuilder
      getDesiredNodePoolAutoConfigLinuxNodeConfigOrBuilder();
}
