/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * CompliancePostureConfig defines the settings needed to enable/disable
 * features for the Compliance Posture.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.CompliancePostureConfig}
 */
public final class CompliancePostureConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.CompliancePostureConfig)
    CompliancePostureConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompliancePostureConfig.newBuilder() to construct.
  private CompliancePostureConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompliancePostureConfig() {
    mode_ = 0;
    complianceStandards_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompliancePostureConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_CompliancePostureConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_CompliancePostureConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.CompliancePostureConfig.class,
            com.google.container.v1.CompliancePostureConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Mode defines enablement mode for Compliance Posture.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.CompliancePostureConfig.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value not specified.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Disables Compliance Posture features on the cluster.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    DISABLED(1),
    /**
     *
     *
     * <pre>
     * Enables Compliance Posture features on the cluster.
     * </pre>
     *
     * <code>ENABLED = 2;</code>
     */
    ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value not specified.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Disables Compliance Posture features on the cluster.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    public static final int DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Enables Compliance Posture features on the cluster.
     * </pre>
     *
     * <code>ENABLED = 2;</code>
     */
    public static final int ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return DISABLED;
        case 2:
          return ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.CompliancePostureConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.CompliancePostureConfig.Mode)
  }

  public interface ComplianceStandardOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.CompliancePostureConfig.ComplianceStandard)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name of the compliance standard.
     * </pre>
     *
     * <code>optional string standard = 1;</code>
     *
     * @return Whether the standard field is set.
     */
    boolean hasStandard();
    /**
     *
     *
     * <pre>
     * Name of the compliance standard.
     * </pre>
     *
     * <code>optional string standard = 1;</code>
     *
     * @return The standard.
     */
    java.lang.String getStandard();
    /**
     *
     *
     * <pre>
     * Name of the compliance standard.
     * </pre>
     *
     * <code>optional string standard = 1;</code>
     *
     * @return The bytes for standard.
     */
    com.google.protobuf.ByteString getStandardBytes();
  }
  /**
   *
   *
   * <pre>
   * Defines the details of a compliance standard.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.CompliancePostureConfig.ComplianceStandard}
   */
  public static final class ComplianceStandard extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.CompliancePostureConfig.ComplianceStandard)
      ComplianceStandardOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ComplianceStandard.newBuilder() to construct.
    private ComplianceStandard(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ComplianceStandard() {
      standard_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ComplianceStandard();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_CompliancePostureConfig_ComplianceStandard_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_CompliancePostureConfig_ComplianceStandard_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.CompliancePostureConfig.ComplianceStandard.class,
              com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder.class);
    }

    private int bitField0_;
    public static final int STANDARD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object standard_ = "";
    /**
     *
     *
     * <pre>
     * Name of the compliance standard.
     * </pre>
     *
     * <code>optional string standard = 1;</code>
     *
     * @return Whether the standard field is set.
     */
    @java.lang.Override
    public boolean hasStandard() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the compliance standard.
     * </pre>
     *
     * <code>optional string standard = 1;</code>
     *
     * @return The standard.
     */
    @java.lang.Override
    public java.lang.String getStandard() {
      java.lang.Object ref = standard_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        standard_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the compliance standard.
     * </pre>
     *
     * <code>optional string standard = 1;</code>
     *
     * @return The bytes for standard.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStandardBytes() {
      java.lang.Object ref = standard_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        standard_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, standard_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, standard_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.CompliancePostureConfig.ComplianceStandard)) {
        return super.equals(obj);
      }
      com.google.container.v1.CompliancePostureConfig.ComplianceStandard other =
          (com.google.container.v1.CompliancePostureConfig.ComplianceStandard) obj;

      if (hasStandard() != other.hasStandard()) return false;
      if (hasStandard()) {
        if (!getStandard().equals(other.getStandard())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStandard()) {
        hash = (37 * hash) + STANDARD_FIELD_NUMBER;
        hash = (53 * hash) + getStandard().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines the details of a compliance standard.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.CompliancePostureConfig.ComplianceStandard}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.CompliancePostureConfig.ComplianceStandard)
        com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_CompliancePostureConfig_ComplianceStandard_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_CompliancePostureConfig_ComplianceStandard_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.CompliancePostureConfig.ComplianceStandard.class,
                com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder.class);
      }

      // Construct using
      // com.google.container.v1.CompliancePostureConfig.ComplianceStandard.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        standard_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_CompliancePostureConfig_ComplianceStandard_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.CompliancePostureConfig.ComplianceStandard
          getDefaultInstanceForType() {
        return com.google.container.v1.CompliancePostureConfig.ComplianceStandard
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.CompliancePostureConfig.ComplianceStandard build() {
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.CompliancePostureConfig.ComplianceStandard buildPartial() {
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard result =
            new com.google.container.v1.CompliancePostureConfig.ComplianceStandard(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1.CompliancePostureConfig.ComplianceStandard result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.standard_ = standard_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.CompliancePostureConfig.ComplianceStandard) {
          return mergeFrom(
              (com.google.container.v1.CompliancePostureConfig.ComplianceStandard) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.CompliancePostureConfig.ComplianceStandard other) {
        if (other
            == com.google.container.v1.CompliancePostureConfig.ComplianceStandard
                .getDefaultInstance()) return this;
        if (other.hasStandard()) {
          standard_ = other.standard_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  standard_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object standard_ = "";
      /**
       *
       *
       * <pre>
       * Name of the compliance standard.
       * </pre>
       *
       * <code>optional string standard = 1;</code>
       *
       * @return Whether the standard field is set.
       */
      public boolean hasStandard() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Name of the compliance standard.
       * </pre>
       *
       * <code>optional string standard = 1;</code>
       *
       * @return The standard.
       */
      public java.lang.String getStandard() {
        java.lang.Object ref = standard_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          standard_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the compliance standard.
       * </pre>
       *
       * <code>optional string standard = 1;</code>
       *
       * @return The bytes for standard.
       */
      public com.google.protobuf.ByteString getStandardBytes() {
        java.lang.Object ref = standard_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          standard_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the compliance standard.
       * </pre>
       *
       * <code>optional string standard = 1;</code>
       *
       * @param value The standard to set.
       * @return This builder for chaining.
       */
      public Builder setStandard(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        standard_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the compliance standard.
       * </pre>
       *
       * <code>optional string standard = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStandard() {
        standard_ = getDefaultInstance().getStandard();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the compliance standard.
       * </pre>
       *
       * <code>optional string standard = 1;</code>
       *
       * @param value The bytes for standard to set.
       * @return This builder for chaining.
       */
      public Builder setStandardBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        standard_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.CompliancePostureConfig.ComplianceStandard)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.CompliancePostureConfig.ComplianceStandard)
    private static final com.google.container.v1.CompliancePostureConfig.ComplianceStandard
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.CompliancePostureConfig.ComplianceStandard();
    }

    public static com.google.container.v1.CompliancePostureConfig.ComplianceStandard
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ComplianceStandard> PARSER =
        new com.google.protobuf.AbstractParser<ComplianceStandard>() {
          @java.lang.Override
          public ComplianceStandard parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ComplianceStandard> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ComplianceStandard> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.CompliancePostureConfig.ComplianceStandard
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int MODE_FIELD_NUMBER = 1;
  private int mode_ = 0;
  /**
   *
   *
   * <pre>
   * Defines the enablement mode for Compliance Posture.
   * </pre>
   *
   * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
   *
   * @return Whether the mode field is set.
   */
  @java.lang.Override
  public boolean hasMode() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Defines the enablement mode for Compliance Posture.
   * </pre>
   *
   * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override
  public int getModeValue() {
    return mode_;
  }
  /**
   *
   *
   * <pre>
   * Defines the enablement mode for Compliance Posture.
   * </pre>
   *
   * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public com.google.container.v1.CompliancePostureConfig.Mode getMode() {
    com.google.container.v1.CompliancePostureConfig.Mode result =
        com.google.container.v1.CompliancePostureConfig.Mode.forNumber(mode_);
    return result == null
        ? com.google.container.v1.CompliancePostureConfig.Mode.UNRECOGNIZED
        : result;
  }

  public static final int COMPLIANCE_STANDARDS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.CompliancePostureConfig.ComplianceStandard>
      complianceStandards_;
  /**
   *
   *
   * <pre>
   * List of enabled compliance standards.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.CompliancePostureConfig.ComplianceStandard>
      getComplianceStandardsList() {
    return complianceStandards_;
  }
  /**
   *
   *
   * <pre>
   * List of enabled compliance standards.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder>
      getComplianceStandardsOrBuilderList() {
    return complianceStandards_;
  }
  /**
   *
   *
   * <pre>
   * List of enabled compliance standards.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
   * </code>
   */
  @java.lang.Override
  public int getComplianceStandardsCount() {
    return complianceStandards_.size();
  }
  /**
   *
   *
   * <pre>
   * List of enabled compliance standards.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.CompliancePostureConfig.ComplianceStandard getComplianceStandards(
      int index) {
    return complianceStandards_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of enabled compliance standards.
   * </pre>
   *
   * <code>
   * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder
      getComplianceStandardsOrBuilder(int index) {
    return complianceStandards_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(1, mode_);
    }
    for (int i = 0; i < complianceStandards_.size(); i++) {
      output.writeMessage(2, complianceStandards_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
    }
    for (int i = 0; i < complianceStandards_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, complianceStandards_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.CompliancePostureConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.CompliancePostureConfig other =
        (com.google.container.v1.CompliancePostureConfig) obj;

    if (hasMode() != other.hasMode()) return false;
    if (hasMode()) {
      if (mode_ != other.mode_) return false;
    }
    if (!getComplianceStandardsList().equals(other.getComplianceStandardsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMode()) {
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
    }
    if (getComplianceStandardsCount() > 0) {
      hash = (37 * hash) + COMPLIANCE_STANDARDS_FIELD_NUMBER;
      hash = (53 * hash) + getComplianceStandardsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.CompliancePostureConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.CompliancePostureConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.CompliancePostureConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.CompliancePostureConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CompliancePostureConfig defines the settings needed to enable/disable
   * features for the Compliance Posture.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.CompliancePostureConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.CompliancePostureConfig)
      com.google.container.v1.CompliancePostureConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_CompliancePostureConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_CompliancePostureConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.CompliancePostureConfig.class,
              com.google.container.v1.CompliancePostureConfig.Builder.class);
    }

    // Construct using com.google.container.v1.CompliancePostureConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mode_ = 0;
      if (complianceStandardsBuilder_ == null) {
        complianceStandards_ = java.util.Collections.emptyList();
      } else {
        complianceStandards_ = null;
        complianceStandardsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_CompliancePostureConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.CompliancePostureConfig getDefaultInstanceForType() {
      return com.google.container.v1.CompliancePostureConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.CompliancePostureConfig build() {
      com.google.container.v1.CompliancePostureConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.CompliancePostureConfig buildPartial() {
      com.google.container.v1.CompliancePostureConfig result =
          new com.google.container.v1.CompliancePostureConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.container.v1.CompliancePostureConfig result) {
      if (complianceStandardsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          complianceStandards_ = java.util.Collections.unmodifiableList(complianceStandards_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.complianceStandards_ = complianceStandards_;
      } else {
        result.complianceStandards_ = complianceStandardsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.CompliancePostureConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mode_ = mode_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.CompliancePostureConfig) {
        return mergeFrom((com.google.container.v1.CompliancePostureConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.CompliancePostureConfig other) {
      if (other == com.google.container.v1.CompliancePostureConfig.getDefaultInstance())
        return this;
      if (other.hasMode()) {
        setMode(other.getMode());
      }
      if (complianceStandardsBuilder_ == null) {
        if (!other.complianceStandards_.isEmpty()) {
          if (complianceStandards_.isEmpty()) {
            complianceStandards_ = other.complianceStandards_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureComplianceStandardsIsMutable();
            complianceStandards_.addAll(other.complianceStandards_);
          }
          onChanged();
        }
      } else {
        if (!other.complianceStandards_.isEmpty()) {
          if (complianceStandardsBuilder_.isEmpty()) {
            complianceStandardsBuilder_.dispose();
            complianceStandardsBuilder_ = null;
            complianceStandards_ = other.complianceStandards_;
            bitField0_ = (bitField0_ & ~0x00000002);
            complianceStandardsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getComplianceStandardsFieldBuilder()
                    : null;
          } else {
            complianceStandardsBuilder_.addAllMessages(other.complianceStandards_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                mode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.container.v1.CompliancePostureConfig.ComplianceStandard m =
                    input.readMessage(
                        com.google.container.v1.CompliancePostureConfig.ComplianceStandard.parser(),
                        extensionRegistry);
                if (complianceStandardsBuilder_ == null) {
                  ensureComplianceStandardsIsMutable();
                  complianceStandards_.add(m);
                } else {
                  complianceStandardsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Defines the enablement mode for Compliance Posture.
     * </pre>
     *
     * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
     *
     * @return Whether the mode field is set.
     */
    @java.lang.Override
    public boolean hasMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Defines the enablement mode for Compliance Posture.
     * </pre>
     *
     * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Defines the enablement mode for Compliance Posture.
     * </pre>
     *
     * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
     *
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {
      mode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the enablement mode for Compliance Posture.
     * </pre>
     *
     * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.container.v1.CompliancePostureConfig.Mode getMode() {
      com.google.container.v1.CompliancePostureConfig.Mode result =
          com.google.container.v1.CompliancePostureConfig.Mode.forNumber(mode_);
      return result == null
          ? com.google.container.v1.CompliancePostureConfig.Mode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Defines the enablement mode for Compliance Posture.
     * </pre>
     *
     * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.google.container.v1.CompliancePostureConfig.Mode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      mode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the enablement mode for Compliance Posture.
     * </pre>
     *
     * <code>optional .google.container.v1.CompliancePostureConfig.Mode mode = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      mode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.CompliancePostureConfig.ComplianceStandard>
        complianceStandards_ = java.util.Collections.emptyList();

    private void ensureComplianceStandardsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        complianceStandards_ =
            new java.util.ArrayList<
                com.google.container.v1.CompliancePostureConfig.ComplianceStandard>(
                complianceStandards_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.CompliancePostureConfig.ComplianceStandard,
            com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder,
            com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder>
        complianceStandardsBuilder_;

    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public java.util.List<com.google.container.v1.CompliancePostureConfig.ComplianceStandard>
        getComplianceStandardsList() {
      if (complianceStandardsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(complianceStandards_);
      } else {
        return complianceStandardsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public int getComplianceStandardsCount() {
      if (complianceStandardsBuilder_ == null) {
        return complianceStandards_.size();
      } else {
        return complianceStandardsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public com.google.container.v1.CompliancePostureConfig.ComplianceStandard
        getComplianceStandards(int index) {
      if (complianceStandardsBuilder_ == null) {
        return complianceStandards_.get(index);
      } else {
        return complianceStandardsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder setComplianceStandards(
        int index, com.google.container.v1.CompliancePostureConfig.ComplianceStandard value) {
      if (complianceStandardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureComplianceStandardsIsMutable();
        complianceStandards_.set(index, value);
        onChanged();
      } else {
        complianceStandardsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder setComplianceStandards(
        int index,
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder
            builderForValue) {
      if (complianceStandardsBuilder_ == null) {
        ensureComplianceStandardsIsMutable();
        complianceStandards_.set(index, builderForValue.build());
        onChanged();
      } else {
        complianceStandardsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder addComplianceStandards(
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard value) {
      if (complianceStandardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureComplianceStandardsIsMutable();
        complianceStandards_.add(value);
        onChanged();
      } else {
        complianceStandardsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder addComplianceStandards(
        int index, com.google.container.v1.CompliancePostureConfig.ComplianceStandard value) {
      if (complianceStandardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureComplianceStandardsIsMutable();
        complianceStandards_.add(index, value);
        onChanged();
      } else {
        complianceStandardsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder addComplianceStandards(
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder
            builderForValue) {
      if (complianceStandardsBuilder_ == null) {
        ensureComplianceStandardsIsMutable();
        complianceStandards_.add(builderForValue.build());
        onChanged();
      } else {
        complianceStandardsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder addComplianceStandards(
        int index,
        com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder
            builderForValue) {
      if (complianceStandardsBuilder_ == null) {
        ensureComplianceStandardsIsMutable();
        complianceStandards_.add(index, builderForValue.build());
        onChanged();
      } else {
        complianceStandardsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder addAllComplianceStandards(
        java.lang.Iterable<
                ? extends com.google.container.v1.CompliancePostureConfig.ComplianceStandard>
            values) {
      if (complianceStandardsBuilder_ == null) {
        ensureComplianceStandardsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, complianceStandards_);
        onChanged();
      } else {
        complianceStandardsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder clearComplianceStandards() {
      if (complianceStandardsBuilder_ == null) {
        complianceStandards_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        complianceStandardsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public Builder removeComplianceStandards(int index) {
      if (complianceStandardsBuilder_ == null) {
        ensureComplianceStandardsIsMutable();
        complianceStandards_.remove(index);
        onChanged();
      } else {
        complianceStandardsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder
        getComplianceStandardsBuilder(int index) {
      return getComplianceStandardsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder
        getComplianceStandardsOrBuilder(int index) {
      if (complianceStandardsBuilder_ == null) {
        return complianceStandards_.get(index);
      } else {
        return complianceStandardsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder>
        getComplianceStandardsOrBuilderList() {
      if (complianceStandardsBuilder_ != null) {
        return complianceStandardsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(complianceStandards_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder
        addComplianceStandardsBuilder() {
      return getComplianceStandardsFieldBuilder()
          .addBuilder(
              com.google.container.v1.CompliancePostureConfig.ComplianceStandard
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder
        addComplianceStandardsBuilder(int index) {
      return getComplianceStandardsFieldBuilder()
          .addBuilder(
              index,
              com.google.container.v1.CompliancePostureConfig.ComplianceStandard
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of enabled compliance standards.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.CompliancePostureConfig.ComplianceStandard compliance_standards = 2;
     * </code>
     */
    public java.util.List<
            com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder>
        getComplianceStandardsBuilderList() {
      return getComplianceStandardsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.CompliancePostureConfig.ComplianceStandard,
            com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder,
            com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder>
        getComplianceStandardsFieldBuilder() {
      if (complianceStandardsBuilder_ == null) {
        complianceStandardsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.CompliancePostureConfig.ComplianceStandard,
                com.google.container.v1.CompliancePostureConfig.ComplianceStandard.Builder,
                com.google.container.v1.CompliancePostureConfig.ComplianceStandardOrBuilder>(
                complianceStandards_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        complianceStandards_ = null;
      }
      return complianceStandardsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.CompliancePostureConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.CompliancePostureConfig)
  private static final com.google.container.v1.CompliancePostureConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.CompliancePostureConfig();
  }

  public static com.google.container.v1.CompliancePostureConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompliancePostureConfig> PARSER =
      new com.google.protobuf.AbstractParser<CompliancePostureConfig>() {
        @java.lang.Override
        public CompliancePostureConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompliancePostureConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompliancePostureConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.CompliancePostureConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
