/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * ContainerdConfig contains configuration to customize containerd.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.ContainerdConfig}
 */
public final class ContainerdConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.ContainerdConfig)
    ContainerdConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContainerdConfig.newBuilder() to construct.
  private ContainerdConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContainerdConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContainerdConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ContainerdConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ContainerdConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.ContainerdConfig.class,
            com.google.container.v1.ContainerdConfig.Builder.class);
  }

  public interface PrivateRegistryAccessConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Private registry access is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    java.util.List<
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig>
        getCertificateAuthorityDomainConfigList();
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .CertificateAuthorityDomainConfig
        getCertificateAuthorityDomainConfig(int index);
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    int getCertificateAuthorityDomainConfigCount();
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfigOrBuilder>
        getCertificateAuthorityDomainConfigOrBuilderList();
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .CertificateAuthorityDomainConfigOrBuilder
        getCertificateAuthorityDomainConfigOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * PrivateRegistryAccessConfig contains access configuration for
   * private container registries.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig}
   */
  public static final class PrivateRegistryAccessConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig)
      PrivateRegistryAccessConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PrivateRegistryAccessConfig.newBuilder() to construct.
    private PrivateRegistryAccessConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrivateRegistryAccessConfig() {
      certificateAuthorityDomainConfig_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrivateRegistryAccessConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.class,
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder.class);
    }

    public interface CertificateAuthorityDomainConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @return A list containing the fqdns.
       */
      java.util.List<java.lang.String> getFqdnsList();
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @return The count of fqdns.
       */
      int getFqdnsCount();
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The fqdns at the given index.
       */
      java.lang.String getFqdns(int index);
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the fqdns at the given index.
       */
      com.google.protobuf.ByteString getFqdnsBytes(int index);

      /**
       *
       *
       * <pre>
       * Google Secret Manager (GCP) certificate configuration.
       * </pre>
       *
       * <code>
       * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
       * </code>
       *
       * @return Whether the gcpSecretManagerCertificateConfig field is set.
       */
      boolean hasGcpSecretManagerCertificateConfig();
      /**
       *
       *
       * <pre>
       * Google Secret Manager (GCP) certificate configuration.
       * </pre>
       *
       * <code>
       * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
       * </code>
       *
       * @return The gcpSecretManagerCertificateConfig.
       */
      com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
          getGcpSecretManagerCertificateConfig();
      /**
       *
       *
       * <pre>
       * Google Secret Manager (GCP) certificate configuration.
       * </pre>
       *
       * <code>
       * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
       * </code>
       */
      com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfigOrBuilder
          getGcpSecretManagerCertificateConfigOrBuilder();

      com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.CertificateConfigCase
          getCertificateConfigCase();
    }
    /**
     *
     *
     * <pre>
     * CertificateAuthorityDomainConfig configures one or more fully qualified
     * domain names (FQDN) to a specific certificate.
     * </pre>
     *
     * Protobuf type {@code
     * google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig}
     */
    public static final class CertificateAuthorityDomainConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig)
        CertificateAuthorityDomainConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CertificateAuthorityDomainConfig.newBuilder() to construct.
      private CertificateAuthorityDomainConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CertificateAuthorityDomainConfig() {
        fqdns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CertificateAuthorityDomainConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.class,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.Builder.class);
      }

      public interface GCPSecretManagerCertificateConfigOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Secret URI, in the form
         * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
         * Version can be fixed (e.g. "2") or "latest"
         * </pre>
         *
         * <code>string secret_uri = 1;</code>
         *
         * @return The secretUri.
         */
        java.lang.String getSecretUri();
        /**
         *
         *
         * <pre>
         * Secret URI, in the form
         * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
         * Version can be fixed (e.g. "2") or "latest"
         * </pre>
         *
         * <code>string secret_uri = 1;</code>
         *
         * @return The bytes for secretUri.
         */
        com.google.protobuf.ByteString getSecretUriBytes();
      }
      /**
       *
       *
       * <pre>
       * GCPSecretManagerCertificateConfig configures a secret from
       * [Google Secret Manager](https://cloud.google.com/secret-manager).
       * </pre>
       *
       * Protobuf type {@code
       * google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig}
       */
      public static final class GCPSecretManagerCertificateConfig
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
          GCPSecretManagerCertificateConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use GCPSecretManagerCertificateConfig.newBuilder() to construct.
        private GCPSecretManagerCertificateConfig(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GCPSecretManagerCertificateConfig() {
          secretUri_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GCPSecretManagerCertificateConfig();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.class,
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder
                      .class);
        }

        public static final int SECRET_URI_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object secretUri_ = "";
        /**
         *
         *
         * <pre>
         * Secret URI, in the form
         * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
         * Version can be fixed (e.g. "2") or "latest"
         * </pre>
         *
         * <code>string secret_uri = 1;</code>
         *
         * @return The secretUri.
         */
        @java.lang.Override
        public java.lang.String getSecretUri() {
          java.lang.Object ref = secretUri_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            secretUri_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Secret URI, in the form
         * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
         * Version can be fixed (e.g. "2") or "latest"
         * </pre>
         *
         * <code>string secret_uri = 1;</code>
         *
         * @return The bytes for secretUri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSecretUriBytes() {
          java.lang.Object ref = secretUri_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            secretUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secretUri_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, secretUri_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secretUri_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, secretUri_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)) {
            return super.equals(obj);
          }
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
              other =
                  (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                          .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                      obj;

          if (!getSecretUri().equals(other.getSecretUri())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + SECRET_URI_FIELD_NUMBER;
          hash = (53 * hash) + getSecretUri().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * GCPSecretManagerCertificateConfig configures a secret from
         * [Google Secret Manager](https://cloud.google.com/secret-manager).
         * </pre>
         *
         * Protobuf type {@code
         * google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfigOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.class,
                    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder
                        .class);
          }

          // Construct using
          // com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            secretUri_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.container.v1.ClusterServiceProto
                .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig_descriptor;
          }

          @java.lang.Override
          public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
              getDefaultInstanceForType() {
            return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
              build() {
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
              buildPartial() {
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                result =
                    new com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.secretUri_ = secretUri_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig) {
              return mergeFrom(
                  (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                          .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                  other) {
            if (other
                == com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                    .getDefaultInstance()) return this;
            if (!other.getSecretUri().isEmpty()) {
              secretUri_ = other.secretUri_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      secretUri_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object secretUri_ = "";
          /**
           *
           *
           * <pre>
           * Secret URI, in the form
           * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
           * Version can be fixed (e.g. "2") or "latest"
           * </pre>
           *
           * <code>string secret_uri = 1;</code>
           *
           * @return The secretUri.
           */
          public java.lang.String getSecretUri() {
            java.lang.Object ref = secretUri_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              secretUri_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Secret URI, in the form
           * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
           * Version can be fixed (e.g. "2") or "latest"
           * </pre>
           *
           * <code>string secret_uri = 1;</code>
           *
           * @return The bytes for secretUri.
           */
          public com.google.protobuf.ByteString getSecretUriBytes() {
            java.lang.Object ref = secretUri_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              secretUri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Secret URI, in the form
           * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
           * Version can be fixed (e.g. "2") or "latest"
           * </pre>
           *
           * <code>string secret_uri = 1;</code>
           *
           * @param value The secretUri to set.
           * @return This builder for chaining.
           */
          public Builder setSecretUri(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            secretUri_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Secret URI, in the form
           * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
           * Version can be fixed (e.g. "2") or "latest"
           * </pre>
           *
           * <code>string secret_uri = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSecretUri() {
            secretUri_ = getDefaultInstance().getSecretUri();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Secret URI, in the form
           * "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
           * Version can be fixed (e.g. "2") or "latest"
           * </pre>
           *
           * <code>string secret_uri = 1;</code>
           *
           * @param value The bytes for secretUri to set.
           * @return This builder for chaining.
           */
          public Builder setSecretUriBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            secretUri_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
        }

        // @@protoc_insertion_point(class_scope:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
        private static final com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig();
        }

        public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GCPSecretManagerCertificateConfig> PARSER =
            new com.google.protobuf.AbstractParser<GCPSecretManagerCertificateConfig>() {
              @java.lang.Override
              public GCPSecretManagerCertificateConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GCPSecretManagerCertificateConfig> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GCPSecretManagerCertificateConfig> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int certificateConfigCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object certificateConfig_;

      public enum CertificateConfigCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        GCP_SECRET_MANAGER_CERTIFICATE_CONFIG(2),
        CERTIFICATECONFIG_NOT_SET(0);
        private final int value;

        private CertificateConfigCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static CertificateConfigCase valueOf(int value) {
          return forNumber(value);
        }

        public static CertificateConfigCase forNumber(int value) {
          switch (value) {
            case 2:
              return GCP_SECRET_MANAGER_CERTIFICATE_CONFIG;
            case 0:
              return CERTIFICATECONFIG_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public CertificateConfigCase getCertificateConfigCase() {
        return CertificateConfigCase.forNumber(certificateConfigCase_);
      }

      public static final int FQDNS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList fqdns_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @return A list containing the fqdns.
       */
      public com.google.protobuf.ProtocolStringList getFqdnsList() {
        return fqdns_;
      }
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @return The count of fqdns.
       */
      public int getFqdnsCount() {
        return fqdns_.size();
      }
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The fqdns at the given index.
       */
      public java.lang.String getFqdns(int index) {
        return fqdns_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of fully qualified domain names (FQDN).
       * Specifying port is supported.
       * Wilcards are NOT supported.
       * Examples:
       * - my.customdomain.com
       * - 10.0.1.2:5000
       * </pre>
       *
       * <code>repeated string fqdns = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the fqdns at the given index.
       */
      public com.google.protobuf.ByteString getFqdnsBytes(int index) {
        return fqdns_.getByteString(index);
      }

      public static final int GCP_SECRET_MANAGER_CERTIFICATE_CONFIG_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Google Secret Manager (GCP) certificate configuration.
       * </pre>
       *
       * <code>
       * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
       * </code>
       *
       * @return Whether the gcpSecretManagerCertificateConfig field is set.
       */
      @java.lang.Override
      public boolean hasGcpSecretManagerCertificateConfig() {
        return certificateConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Google Secret Manager (GCP) certificate configuration.
       * </pre>
       *
       * <code>
       * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
       * </code>
       *
       * @return The gcpSecretManagerCertificateConfig.
       */
      @java.lang.Override
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
          getGcpSecretManagerCertificateConfig() {
        if (certificateConfigCase_ == 2) {
          return (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
              certificateConfig_;
        }
        return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Google Secret Manager (GCP) certificate configuration.
       * </pre>
       *
       * <code>
       * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfigOrBuilder
          getGcpSecretManagerCertificateConfigOrBuilder() {
        if (certificateConfigCase_ == 2) {
          return (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
              certificateConfig_;
        }
        return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < fqdns_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fqdns_.getRaw(i));
        }
        if (certificateConfigCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                  certificateConfig_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < fqdns_.size(); i++) {
            dataSize += computeStringSizeNoTag(fqdns_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getFqdnsList().size();
        }
        if (certificateConfigCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                          .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                      certificateConfig_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig)) {
          return super.equals(obj);
        }
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig
            other =
                (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig)
                    obj;

        if (!getFqdnsList().equals(other.getFqdnsList())) return false;
        if (!getCertificateConfigCase().equals(other.getCertificateConfigCase())) return false;
        switch (certificateConfigCase_) {
          case 2:
            if (!getGcpSecretManagerCertificateConfig()
                .equals(other.getGcpSecretManagerCertificateConfig())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getFqdnsCount() > 0) {
          hash = (37 * hash) + FQDNS_FIELD_NUMBER;
          hash = (53 * hash) + getFqdnsList().hashCode();
        }
        switch (certificateConfigCase_) {
          case 2:
            hash = (37 * hash) + GCP_SECRET_MANAGER_CERTIFICATE_CONFIG_FIELD_NUMBER;
            hash = (53 * hash) + getGcpSecretManagerCertificateConfig().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * CertificateAuthorityDomainConfig configures one or more fully qualified
       * domain names (FQDN) to a specific certificate.
       * </pre>
       *
       * Protobuf type {@code
       * google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig)
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.class,
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.Builder.class);
        }

        // Construct using
        // com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          fqdns_ = com.google.protobuf.LazyStringArrayList.emptyList();
          if (gcpSecretManagerCertificateConfigBuilder_ != null) {
            gcpSecretManagerCertificateConfigBuilder_.clear();
          }
          certificateConfigCase_ = 0;
          certificateConfig_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.container.v1.ClusterServiceProto
              .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_descriptor;
        }

        @java.lang.Override
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig
            getDefaultInstanceForType() {
          return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig
            build() {
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig
            buildPartial() {
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig
              result =
                  new com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            fqdns_.makeImmutable();
            result.fqdns_ = fqdns_;
          }
        }

        private void buildPartialOneofs(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig
                result) {
          result.certificateConfigCase_ = certificateConfigCase_;
          result.certificateConfig_ = this.certificateConfig_;
          if (certificateConfigCase_ == 2 && gcpSecretManagerCertificateConfigBuilder_ != null) {
            result.certificateConfig_ = gcpSecretManagerCertificateConfigBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig) {
            return mergeFrom(
                (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig
                other) {
          if (other
              == com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.getDefaultInstance()) return this;
          if (!other.fqdns_.isEmpty()) {
            if (fqdns_.isEmpty()) {
              fqdns_ = other.fqdns_;
              bitField0_ |= 0x00000001;
            } else {
              ensureFqdnsIsMutable();
              fqdns_.addAll(other.fqdns_);
            }
            onChanged();
          }
          switch (other.getCertificateConfigCase()) {
            case GCP_SECRET_MANAGER_CERTIFICATE_CONFIG:
              {
                mergeGcpSecretManagerCertificateConfig(
                    other.getGcpSecretManagerCertificateConfig());
                break;
              }
            case CERTIFICATECONFIG_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureFqdnsIsMutable();
                    fqdns_.add(s);
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getGcpSecretManagerCertificateConfigFieldBuilder().getBuilder(),
                        extensionRegistry);
                    certificateConfigCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int certificateConfigCase_ = 0;
        private java.lang.Object certificateConfig_;

        public CertificateConfigCase getCertificateConfigCase() {
          return CertificateConfigCase.forNumber(certificateConfigCase_);
        }

        public Builder clearCertificateConfig() {
          certificateConfigCase_ = 0;
          certificateConfig_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList fqdns_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureFqdnsIsMutable() {
          if (!fqdns_.isModifiable()) {
            fqdns_ = new com.google.protobuf.LazyStringArrayList(fqdns_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @return A list containing the fqdns.
         */
        public com.google.protobuf.ProtocolStringList getFqdnsList() {
          fqdns_.makeImmutable();
          return fqdns_;
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @return The count of fqdns.
         */
        public int getFqdnsCount() {
          return fqdns_.size();
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The fqdns at the given index.
         */
        public java.lang.String getFqdns(int index) {
          return fqdns_.get(index);
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the fqdns at the given index.
         */
        public com.google.protobuf.ByteString getFqdnsBytes(int index) {
          return fqdns_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The fqdns to set.
         * @return This builder for chaining.
         */
        public Builder setFqdns(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFqdnsIsMutable();
          fqdns_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @param value The fqdns to add.
         * @return This builder for chaining.
         */
        public Builder addFqdns(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFqdnsIsMutable();
          fqdns_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @param values The fqdns to add.
         * @return This builder for chaining.
         */
        public Builder addAllFqdns(java.lang.Iterable<java.lang.String> values) {
          ensureFqdnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fqdns_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFqdns() {
          fqdns_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of fully qualified domain names (FQDN).
         * Specifying port is supported.
         * Wilcards are NOT supported.
         * Examples:
         * - my.customdomain.com
         * - 10.0.1.2:5000
         * </pre>
         *
         * <code>repeated string fqdns = 1;</code>
         *
         * @param value The bytes of the fqdns to add.
         * @return This builder for chaining.
         */
        public Builder addFqdnsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureFqdnsIsMutable();
          fqdns_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfigOrBuilder>
            gcpSecretManagerCertificateConfigBuilder_;
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         *
         * @return Whether the gcpSecretManagerCertificateConfig field is set.
         */
        @java.lang.Override
        public boolean hasGcpSecretManagerCertificateConfig() {
          return certificateConfigCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         *
         * @return The gcpSecretManagerCertificateConfig.
         */
        @java.lang.Override
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
            getGcpSecretManagerCertificateConfig() {
          if (gcpSecretManagerCertificateConfigBuilder_ == null) {
            if (certificateConfigCase_ == 2) {
              return (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                  certificateConfig_;
            }
            return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                .getDefaultInstance();
          } else {
            if (certificateConfigCase_ == 2) {
              return gcpSecretManagerCertificateConfigBuilder_.getMessage();
            }
            return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        public Builder setGcpSecretManagerCertificateConfig(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                value) {
          if (gcpSecretManagerCertificateConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            certificateConfig_ = value;
            onChanged();
          } else {
            gcpSecretManagerCertificateConfigBuilder_.setMessage(value);
          }
          certificateConfigCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        public Builder setGcpSecretManagerCertificateConfig(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder
                builderForValue) {
          if (gcpSecretManagerCertificateConfigBuilder_ == null) {
            certificateConfig_ = builderForValue.build();
            onChanged();
          } else {
            gcpSecretManagerCertificateConfigBuilder_.setMessage(builderForValue.build());
          }
          certificateConfigCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        public Builder mergeGcpSecretManagerCertificateConfig(
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                value) {
          if (gcpSecretManagerCertificateConfigBuilder_ == null) {
            if (certificateConfigCase_ == 2
                && certificateConfig_
                    != com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                        .getDefaultInstance()) {
              certificateConfig_ =
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                      .newBuilder(
                          (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                                  .CertificateAuthorityDomainConfig
                                  .GCPSecretManagerCertificateConfig)
                              certificateConfig_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              certificateConfig_ = value;
            }
            onChanged();
          } else {
            if (certificateConfigCase_ == 2) {
              gcpSecretManagerCertificateConfigBuilder_.mergeFrom(value);
            } else {
              gcpSecretManagerCertificateConfigBuilder_.setMessage(value);
            }
          }
          certificateConfigCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        public Builder clearGcpSecretManagerCertificateConfig() {
          if (gcpSecretManagerCertificateConfigBuilder_ == null) {
            if (certificateConfigCase_ == 2) {
              certificateConfigCase_ = 0;
              certificateConfig_ = null;
              onChanged();
            }
          } else {
            if (certificateConfigCase_ == 2) {
              certificateConfigCase_ = 0;
              certificateConfig_ = null;
            }
            gcpSecretManagerCertificateConfigBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder
            getGcpSecretManagerCertificateConfigBuilder() {
          return getGcpSecretManagerCertificateConfigFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfigOrBuilder
            getGcpSecretManagerCertificateConfigOrBuilder() {
          if ((certificateConfigCase_ == 2)
              && (gcpSecretManagerCertificateConfigBuilder_ != null)) {
            return gcpSecretManagerCertificateConfigBuilder_.getMessageOrBuilder();
          } else {
            if (certificateConfigCase_ == 2) {
              return (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                  certificateConfig_;
            }
            return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Google Secret Manager (GCP) certificate configuration.
         * </pre>
         *
         * <code>
         * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig gcp_secret_manager_certificate_config = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfigOrBuilder>
            getGcpSecretManagerCertificateConfigFieldBuilder() {
          if (gcpSecretManagerCertificateConfigBuilder_ == null) {
            if (!(certificateConfigCase_ == 2)) {
              certificateConfig_ =
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig
                      .getDefaultInstance();
            }
            gcpSecretManagerCertificateConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig,
                    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig.Builder,
                    com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                        .CertificateAuthorityDomainConfig
                        .GCPSecretManagerCertificateConfigOrBuilder>(
                    (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                            .CertificateAuthorityDomainConfig.GCPSecretManagerCertificateConfig)
                        certificateConfig_,
                    getParentForChildren(),
                    isClean());
            certificateConfig_ = null;
          }
          certificateConfigCase_ = 2;
          onChanged();
          return gcpSecretManagerCertificateConfigBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig)
      }

      // @@protoc_insertion_point(class_scope:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig)
      private static final com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig();
      }

      public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CertificateAuthorityDomainConfig> PARSER =
          new com.google.protobuf.AbstractParser<CertificateAuthorityDomainConfig>() {
            @java.lang.Override
            public CertificateAuthorityDomainConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CertificateAuthorityDomainConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CertificateAuthorityDomainConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Private registry access is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int CERTIFICATE_AUTHORITY_DOMAIN_CONFIG_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig>
        certificateAuthorityDomainConfig_;
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .CertificateAuthorityDomainConfig>
        getCertificateAuthorityDomainConfigList() {
      return certificateAuthorityDomainConfig_;
    }
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfigOrBuilder>
        getCertificateAuthorityDomainConfigOrBuilderList() {
      return certificateAuthorityDomainConfig_;
    }
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    @java.lang.Override
    public int getCertificateAuthorityDomainConfigCount() {
      return certificateAuthorityDomainConfig_.size();
    }
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .CertificateAuthorityDomainConfig
        getCertificateAuthorityDomainConfig(int index) {
      return certificateAuthorityDomainConfig_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Private registry access configuration.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .CertificateAuthorityDomainConfigOrBuilder
        getCertificateAuthorityDomainConfigOrBuilder(int index) {
      return certificateAuthorityDomainConfig_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      for (int i = 0; i < certificateAuthorityDomainConfig_.size(); i++) {
        output.writeMessage(2, certificateAuthorityDomainConfig_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      for (int i = 0; i < certificateAuthorityDomainConfig_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, certificateAuthorityDomainConfig_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig other =
          (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getCertificateAuthorityDomainConfigList()
          .equals(other.getCertificateAuthorityDomainConfigList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      if (getCertificateAuthorityDomainConfigCount() > 0) {
        hash = (37 * hash) + CERTIFICATE_AUTHORITY_DOMAIN_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCertificateAuthorityDomainConfigList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig contains access configuration for
     * private container registries.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig)
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.class,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder.class);
      }

      // Construct using
      // com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          certificateAuthorityDomainConfig_ = java.util.Collections.emptyList();
        } else {
          certificateAuthorityDomainConfig_ = null;
          certificateAuthorityDomainConfigBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ContainerdConfig_PrivateRegistryAccessConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
          getDefaultInstanceForType() {
        return com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig build() {
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig buildPartial() {
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig result =
            new com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig result) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            certificateAuthorityDomainConfig_ =
                java.util.Collections.unmodifiableList(certificateAuthorityDomainConfig_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.certificateAuthorityDomainConfig_ = certificateAuthorityDomainConfig_;
        } else {
          result.certificateAuthorityDomainConfig_ =
              certificateAuthorityDomainConfigBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig) {
          return mergeFrom(
              (com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig other) {
        if (other
            == com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          if (!other.certificateAuthorityDomainConfig_.isEmpty()) {
            if (certificateAuthorityDomainConfig_.isEmpty()) {
              certificateAuthorityDomainConfig_ = other.certificateAuthorityDomainConfig_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureCertificateAuthorityDomainConfigIsMutable();
              certificateAuthorityDomainConfig_.addAll(other.certificateAuthorityDomainConfig_);
            }
            onChanged();
          }
        } else {
          if (!other.certificateAuthorityDomainConfig_.isEmpty()) {
            if (certificateAuthorityDomainConfigBuilder_.isEmpty()) {
              certificateAuthorityDomainConfigBuilder_.dispose();
              certificateAuthorityDomainConfigBuilder_ = null;
              certificateAuthorityDomainConfig_ = other.certificateAuthorityDomainConfig_;
              bitField0_ = (bitField0_ & ~0x00000002);
              certificateAuthorityDomainConfigBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCertificateAuthorityDomainConfigFieldBuilder()
                      : null;
            } else {
              certificateAuthorityDomainConfigBuilder_.addAllMessages(
                  other.certificateAuthorityDomainConfig_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                          .CertificateAuthorityDomainConfig
                      m =
                          input.readMessage(
                              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                                  .CertificateAuthorityDomainConfig.parser(),
                              extensionRegistry);
                  if (certificateAuthorityDomainConfigBuilder_ == null) {
                    ensureCertificateAuthorityDomainConfigIsMutable();
                    certificateAuthorityDomainConfig_.add(m);
                  } else {
                    certificateAuthorityDomainConfigBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Private registry access is enabled.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Private registry access is enabled.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access is enabled.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig>
          certificateAuthorityDomainConfig_ = java.util.Collections.emptyList();

      private void ensureCertificateAuthorityDomainConfigIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          certificateAuthorityDomainConfig_ =
              new java.util.ArrayList<
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig>(certificateAuthorityDomainConfig_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig,
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.Builder,
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfigOrBuilder>
          certificateAuthorityDomainConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public java.util.List<
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig>
          getCertificateAuthorityDomainConfigList() {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          return java.util.Collections.unmodifiableList(certificateAuthorityDomainConfig_);
        } else {
          return certificateAuthorityDomainConfigBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public int getCertificateAuthorityDomainConfigCount() {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          return certificateAuthorityDomainConfig_.size();
        } else {
          return certificateAuthorityDomainConfigBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig
          getCertificateAuthorityDomainConfig(int index) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          return certificateAuthorityDomainConfig_.get(index);
        } else {
          return certificateAuthorityDomainConfigBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder setCertificateAuthorityDomainConfig(
          int index,
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig
              value) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.set(index, value);
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder setCertificateAuthorityDomainConfig(
          int index,
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.Builder
              builderForValue) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.set(index, builderForValue.build());
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder addCertificateAuthorityDomainConfig(
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig
              value) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.add(value);
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder addCertificateAuthorityDomainConfig(
          int index,
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig
              value) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.add(index, value);
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder addCertificateAuthorityDomainConfig(
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.Builder
              builderForValue) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.add(builderForValue.build());
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder addCertificateAuthorityDomainConfig(
          int index,
          com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.Builder
              builderForValue) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.add(index, builderForValue.build());
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder addAllCertificateAuthorityDomainConfig(
          java.lang.Iterable<
                  ? extends
                      com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                          .CertificateAuthorityDomainConfig>
              values) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          ensureCertificateAuthorityDomainConfigIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, certificateAuthorityDomainConfig_);
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder clearCertificateAuthorityDomainConfig() {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          certificateAuthorityDomainConfig_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public Builder removeCertificateAuthorityDomainConfig(int index) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          ensureCertificateAuthorityDomainConfigIsMutable();
          certificateAuthorityDomainConfig_.remove(index);
          onChanged();
        } else {
          certificateAuthorityDomainConfigBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.Builder
          getCertificateAuthorityDomainConfigBuilder(int index) {
        return getCertificateAuthorityDomainConfigFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfigOrBuilder
          getCertificateAuthorityDomainConfigOrBuilder(int index) {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          return certificateAuthorityDomainConfig_.get(index);
        } else {
          return certificateAuthorityDomainConfigBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfigOrBuilder>
          getCertificateAuthorityDomainConfigOrBuilderList() {
        if (certificateAuthorityDomainConfigBuilder_ != null) {
          return certificateAuthorityDomainConfigBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(certificateAuthorityDomainConfig_);
        }
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.Builder
          addCertificateAuthorityDomainConfigBuilder() {
        return getCertificateAuthorityDomainConfigFieldBuilder()
            .addBuilder(
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
              .CertificateAuthorityDomainConfig.Builder
          addCertificateAuthorityDomainConfigBuilder(int index) {
        return getCertificateAuthorityDomainConfigFieldBuilder()
            .addBuilder(
                index,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .CertificateAuthorityDomainConfig.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Private registry access configuration.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.CertificateAuthorityDomainConfig certificate_authority_domain_config = 2;
       * </code>
       */
      public java.util.List<
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.Builder>
          getCertificateAuthorityDomainConfigBuilderList() {
        return getCertificateAuthorityDomainConfigFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig,
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfig.Builder,
              com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                  .CertificateAuthorityDomainConfigOrBuilder>
          getCertificateAuthorityDomainConfigFieldBuilder() {
        if (certificateAuthorityDomainConfigBuilder_ == null) {
          certificateAuthorityDomainConfigBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig,
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfig.Builder,
                  com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                      .CertificateAuthorityDomainConfigOrBuilder>(
                  certificateAuthorityDomainConfig_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          certificateAuthorityDomainConfig_ = null;
        }
        return certificateAuthorityDomainConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig)
    private static final com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig();
    }

    public static com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrivateRegistryAccessConfig> PARSER =
        new com.google.protobuf.AbstractParser<PrivateRegistryAccessConfig>() {
          @java.lang.Override
          public PrivateRegistryAccessConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrivateRegistryAccessConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrivateRegistryAccessConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PRIVATE_REGISTRY_ACCESS_CONFIG_FIELD_NUMBER = 1;
  private com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
      privateRegistryAccessConfig_;
  /**
   *
   *
   * <pre>
   * PrivateRegistryAccessConfig is used to configure access configuration
   * for private container registries.
   * </pre>
   *
   * <code>
   * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
   * </code>
   *
   * @return Whether the privateRegistryAccessConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateRegistryAccessConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * PrivateRegistryAccessConfig is used to configure access configuration
   * for private container registries.
   * </pre>
   *
   * <code>
   * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
   * </code>
   *
   * @return The privateRegistryAccessConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
      getPrivateRegistryAccessConfig() {
    return privateRegistryAccessConfig_ == null
        ? com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.getDefaultInstance()
        : privateRegistryAccessConfig_;
  }
  /**
   *
   *
   * <pre>
   * PrivateRegistryAccessConfig is used to configure access configuration
   * for private container registries.
   * </pre>
   *
   * <code>
   * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfigOrBuilder
      getPrivateRegistryAccessConfigOrBuilder() {
    return privateRegistryAccessConfig_ == null
        ? com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.getDefaultInstance()
        : privateRegistryAccessConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getPrivateRegistryAccessConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, getPrivateRegistryAccessConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.ContainerdConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.ContainerdConfig other = (com.google.container.v1.ContainerdConfig) obj;

    if (hasPrivateRegistryAccessConfig() != other.hasPrivateRegistryAccessConfig()) return false;
    if (hasPrivateRegistryAccessConfig()) {
      if (!getPrivateRegistryAccessConfig().equals(other.getPrivateRegistryAccessConfig()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPrivateRegistryAccessConfig()) {
      hash = (37 * hash) + PRIVATE_REGISTRY_ACCESS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateRegistryAccessConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ContainerdConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ContainerdConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ContainerdConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.ContainerdConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ContainerdConfig contains configuration to customize containerd.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ContainerdConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.ContainerdConfig)
      com.google.container.v1.ContainerdConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ContainerdConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ContainerdConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ContainerdConfig.class,
              com.google.container.v1.ContainerdConfig.Builder.class);
    }

    // Construct using com.google.container.v1.ContainerdConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPrivateRegistryAccessConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      privateRegistryAccessConfig_ = null;
      if (privateRegistryAccessConfigBuilder_ != null) {
        privateRegistryAccessConfigBuilder_.dispose();
        privateRegistryAccessConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ContainerdConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.ContainerdConfig getDefaultInstanceForType() {
      return com.google.container.v1.ContainerdConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.ContainerdConfig build() {
      com.google.container.v1.ContainerdConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.ContainerdConfig buildPartial() {
      com.google.container.v1.ContainerdConfig result =
          new com.google.container.v1.ContainerdConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.ContainerdConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.privateRegistryAccessConfig_ =
            privateRegistryAccessConfigBuilder_ == null
                ? privateRegistryAccessConfig_
                : privateRegistryAccessConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.ContainerdConfig) {
        return mergeFrom((com.google.container.v1.ContainerdConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.ContainerdConfig other) {
      if (other == com.google.container.v1.ContainerdConfig.getDefaultInstance()) return this;
      if (other.hasPrivateRegistryAccessConfig()) {
        mergePrivateRegistryAccessConfig(other.getPrivateRegistryAccessConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getPrivateRegistryAccessConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        privateRegistryAccessConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig,
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder,
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfigOrBuilder>
        privateRegistryAccessConfigBuilder_;
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     *
     * @return Whether the privateRegistryAccessConfig field is set.
     */
    public boolean hasPrivateRegistryAccessConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     *
     * @return The privateRegistryAccessConfig.
     */
    public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
        getPrivateRegistryAccessConfig() {
      if (privateRegistryAccessConfigBuilder_ == null) {
        return privateRegistryAccessConfig_ == null
            ? com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .getDefaultInstance()
            : privateRegistryAccessConfig_;
      } else {
        return privateRegistryAccessConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    public Builder setPrivateRegistryAccessConfig(
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig value) {
      if (privateRegistryAccessConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateRegistryAccessConfig_ = value;
      } else {
        privateRegistryAccessConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    public Builder setPrivateRegistryAccessConfig(
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder
            builderForValue) {
      if (privateRegistryAccessConfigBuilder_ == null) {
        privateRegistryAccessConfig_ = builderForValue.build();
      } else {
        privateRegistryAccessConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    public Builder mergePrivateRegistryAccessConfig(
        com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig value) {
      if (privateRegistryAccessConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && privateRegistryAccessConfig_ != null
            && privateRegistryAccessConfig_
                != com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                    .getDefaultInstance()) {
          getPrivateRegistryAccessConfigBuilder().mergeFrom(value);
        } else {
          privateRegistryAccessConfig_ = value;
        }
      } else {
        privateRegistryAccessConfigBuilder_.mergeFrom(value);
      }
      if (privateRegistryAccessConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    public Builder clearPrivateRegistryAccessConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      privateRegistryAccessConfig_ = null;
      if (privateRegistryAccessConfigBuilder_ != null) {
        privateRegistryAccessConfigBuilder_.dispose();
        privateRegistryAccessConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder
        getPrivateRegistryAccessConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPrivateRegistryAccessConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    public com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfigOrBuilder
        getPrivateRegistryAccessConfigOrBuilder() {
      if (privateRegistryAccessConfigBuilder_ != null) {
        return privateRegistryAccessConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateRegistryAccessConfig_ == null
            ? com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig
                .getDefaultInstance()
            : privateRegistryAccessConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * PrivateRegistryAccessConfig is used to configure access configuration
     * for private container registries.
     * </pre>
     *
     * <code>
     * .google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig private_registry_access_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig,
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder,
            com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfigOrBuilder>
        getPrivateRegistryAccessConfigFieldBuilder() {
      if (privateRegistryAccessConfigBuilder_ == null) {
        privateRegistryAccessConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfig.Builder,
                com.google.container.v1.ContainerdConfig.PrivateRegistryAccessConfigOrBuilder>(
                getPrivateRegistryAccessConfig(), getParentForChildren(), isClean());
        privateRegistryAccessConfig_ = null;
      }
      return privateRegistryAccessConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.ContainerdConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.ContainerdConfig)
  private static final com.google.container.v1.ContainerdConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.ContainerdConfig();
  }

  public static com.google.container.v1.ContainerdConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContainerdConfig> PARSER =
      new com.google.protobuf.AbstractParser<ContainerdConfig>() {
        @java.lang.Override
        public ContainerdConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContainerdConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContainerdConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.ContainerdConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
