/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * Configuration for all of the cluster's control plane endpoints.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.ControlPlaneEndpointsConfig}
 */
public final class ControlPlaneEndpointsConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.ControlPlaneEndpointsConfig)
    ControlPlaneEndpointsConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ControlPlaneEndpointsConfig.newBuilder() to construct.
  private ControlPlaneEndpointsConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ControlPlaneEndpointsConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ControlPlaneEndpointsConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ControlPlaneEndpointsConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_ControlPlaneEndpointsConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.ControlPlaneEndpointsConfig.class,
            com.google.container.v1.ControlPlaneEndpointsConfig.Builder.class);
  }

  public interface DNSEndpointConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     * </pre>
     *
     * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpoint.
     */
    java.lang.String getEndpoint();
    /**
     *
     *
     * <pre>
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     * </pre>
     *
     * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpoint.
     */
    com.google.protobuf.ByteString getEndpointBytes();

    /**
     *
     *
     * <pre>
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     * </pre>
     *
     * <code>optional bool allow_external_traffic = 3;</code>
     *
     * @return Whether the allowExternalTraffic field is set.
     */
    boolean hasAllowExternalTraffic();
    /**
     *
     *
     * <pre>
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     * </pre>
     *
     * <code>optional bool allow_external_traffic = 3;</code>
     *
     * @return The allowExternalTraffic.
     */
    boolean getAllowExternalTraffic();
  }
  /**
   *
   *
   * <pre>
   * Describes the configuration of a DNS endpoint.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig}
   */
  public static final class DNSEndpointConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig)
      DNSEndpointConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DNSEndpointConfig.newBuilder() to construct.
    private DNSEndpointConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DNSEndpointConfig() {
      endpoint_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DNSEndpointConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_DNSEndpointConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_DNSEndpointConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.class,
              com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder.class);
    }

    private int bitField0_;
    public static final int ENDPOINT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     * </pre>
     *
     * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The cluster's DNS endpoint configuration.
     * A DNS format address. This is accessible from the public internet.
     * Ex: uid.us-central1.gke.goog.
     * Always present, but the behavior may change according to the value of
     * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
     * </pre>
     *
     * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for endpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_EXTERNAL_TRAFFIC_FIELD_NUMBER = 3;
    private boolean allowExternalTraffic_ = false;
    /**
     *
     *
     * <pre>
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     * </pre>
     *
     * <code>optional bool allow_external_traffic = 3;</code>
     *
     * @return Whether the allowExternalTraffic field is set.
     */
    @java.lang.Override
    public boolean hasAllowExternalTraffic() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls whether user traffic is allowed over this endpoint. Note that
     * GCP-managed services may still use the endpoint even if this is false.
     * </pre>
     *
     * <code>optional bool allow_external_traffic = 3;</code>
     *
     * @return The allowExternalTraffic.
     */
    @java.lang.Override
    public boolean getAllowExternalTraffic() {
      return allowExternalTraffic_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, endpoint_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(3, allowExternalTraffic_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, endpoint_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, allowExternalTraffic_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig other =
          (com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig) obj;

      if (!getEndpoint().equals(other.getEndpoint())) return false;
      if (hasAllowExternalTraffic() != other.hasAllowExternalTraffic()) return false;
      if (hasAllowExternalTraffic()) {
        if (getAllowExternalTraffic() != other.getAllowExternalTraffic()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpoint().hashCode();
      if (hasAllowExternalTraffic()) {
        hash = (37 * hash) + ALLOW_EXTERNAL_TRAFFIC_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowExternalTraffic());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes the configuration of a DNS endpoint.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig)
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ControlPlaneEndpointsConfig_DNSEndpointConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ControlPlaneEndpointsConfig_DNSEndpointConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.class,
                com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpoint_ = "";
        allowExternalTraffic_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ControlPlaneEndpointsConfig_DNSEndpointConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
          getDefaultInstanceForType() {
        return com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig build() {
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig buildPartial() {
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig result =
            new com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.endpoint_ = endpoint_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allowExternalTraffic_ = allowExternalTraffic_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig) {
          return mergeFrom(
              (com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig other) {
        if (other
            == com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
                .getDefaultInstance()) return this;
        if (!other.getEndpoint().isEmpty()) {
          endpoint_ = other.endpoint_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasAllowExternalTraffic()) {
          setAllowExternalTraffic(other.getAllowExternalTraffic());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  endpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 24:
                {
                  allowExternalTraffic_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object endpoint_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The cluster's DNS endpoint configuration.
       * A DNS format address. This is accessible from the public internet.
       * Ex: uid.us-central1.gke.goog.
       * Always present, but the behavior may change according to the value of
       * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
       * </pre>
       *
       * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The endpoint.
       */
      public java.lang.String getEndpoint() {
        java.lang.Object ref = endpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The cluster's DNS endpoint configuration.
       * A DNS format address. This is accessible from the public internet.
       * Ex: uid.us-central1.gke.goog.
       * Always present, but the behavior may change according to the value of
       * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
       * </pre>
       *
       * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for endpoint.
       */
      public com.google.protobuf.ByteString getEndpointBytes() {
        java.lang.Object ref = endpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The cluster's DNS endpoint configuration.
       * A DNS format address. This is accessible from the public internet.
       * Ex: uid.us-central1.gke.goog.
       * Always present, but the behavior may change according to the value of
       * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
       * </pre>
       *
       * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The cluster's DNS endpoint configuration.
       * A DNS format address. This is accessible from the public internet.
       * Ex: uid.us-central1.gke.goog.
       * Always present, but the behavior may change according to the value of
       * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
       * </pre>
       *
       * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpoint() {
        endpoint_ = getDefaultInstance().getEndpoint();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The cluster's DNS endpoint configuration.
       * A DNS format address. This is accessible from the public internet.
       * Ex: uid.us-central1.gke.goog.
       * Always present, but the behavior may change according to the value of
       * [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
       * </pre>
       *
       * <code>string endpoint = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean allowExternalTraffic_;
      /**
       *
       *
       * <pre>
       * Controls whether user traffic is allowed over this endpoint. Note that
       * GCP-managed services may still use the endpoint even if this is false.
       * </pre>
       *
       * <code>optional bool allow_external_traffic = 3;</code>
       *
       * @return Whether the allowExternalTraffic field is set.
       */
      @java.lang.Override
      public boolean hasAllowExternalTraffic() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Controls whether user traffic is allowed over this endpoint. Note that
       * GCP-managed services may still use the endpoint even if this is false.
       * </pre>
       *
       * <code>optional bool allow_external_traffic = 3;</code>
       *
       * @return The allowExternalTraffic.
       */
      @java.lang.Override
      public boolean getAllowExternalTraffic() {
        return allowExternalTraffic_;
      }
      /**
       *
       *
       * <pre>
       * Controls whether user traffic is allowed over this endpoint. Note that
       * GCP-managed services may still use the endpoint even if this is false.
       * </pre>
       *
       * <code>optional bool allow_external_traffic = 3;</code>
       *
       * @param value The allowExternalTraffic to set.
       * @return This builder for chaining.
       */
      public Builder setAllowExternalTraffic(boolean value) {

        allowExternalTraffic_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Controls whether user traffic is allowed over this endpoint. Note that
       * GCP-managed services may still use the endpoint even if this is false.
       * </pre>
       *
       * <code>optional bool allow_external_traffic = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowExternalTraffic() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allowExternalTraffic_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig)
    private static final com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig();
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DNSEndpointConfig> PARSER =
        new com.google.protobuf.AbstractParser<DNSEndpointConfig>() {
          @java.lang.Override
          public DNSEndpointConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DNSEndpointConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DNSEndpointConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IPEndpointsConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Controls whether to allow direct IP access.
     * </pre>
     *
     * <code>optional bool enabled = 1;</code>
     *
     * @return Whether the enabled field is set.
     */
    boolean hasEnabled();
    /**
     *
     *
     * <pre>
     * Controls whether to allow direct IP access.
     * </pre>
     *
     * <code>optional bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Controls whether the control plane allows access through a public IP.
     * It is invalid to specify both
     * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
     * time.
     * </pre>
     *
     * <code>optional bool enable_public_endpoint = 2;</code>
     *
     * @return Whether the enablePublicEndpoint field is set.
     */
    boolean hasEnablePublicEndpoint();
    /**
     *
     *
     * <pre>
     * Controls whether the control plane allows access through a public IP.
     * It is invalid to specify both
     * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
     * time.
     * </pre>
     *
     * <code>optional bool enable_public_endpoint = 2;</code>
     *
     * @return The enablePublicEndpoint.
     */
    boolean getEnablePublicEndpoint();

    /**
     *
     *
     * <pre>
     * Controls whether the control plane's private endpoint is accessible from
     * sources in other regions.
     * It is invalid to specify both
     * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
     * and this field at the same time.
     * </pre>
     *
     * <code>optional bool global_access = 3;</code>
     *
     * @return Whether the globalAccess field is set.
     */
    boolean hasGlobalAccess();
    /**
     *
     *
     * <pre>
     * Controls whether the control plane's private endpoint is accessible from
     * sources in other regions.
     * It is invalid to specify both
     * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
     * and this field at the same time.
     * </pre>
     *
     * <code>optional bool global_access = 3;</code>
     *
     * @return The globalAccess.
     */
    boolean getGlobalAccess();

    /**
     *
     *
     * <pre>
     * Configuration of authorized networks. If enabled, restricts access to the
     * control plane based on source IP.
     * It is invalid to specify both
     * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
     * time.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
     * </code>
     *
     * @return Whether the authorizedNetworksConfig field is set.
     */
    boolean hasAuthorizedNetworksConfig();
    /**
     *
     *
     * <pre>
     * Configuration of authorized networks. If enabled, restricts access to the
     * control plane based on source IP.
     * It is invalid to specify both
     * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
     * time.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
     * </code>
     *
     * @return The authorizedNetworksConfig.
     */
    com.google.container.v1.MasterAuthorizedNetworksConfig getAuthorizedNetworksConfig();
    /**
     *
     *
     * <pre>
     * Configuration of authorized networks. If enabled, restricts access to the
     * control plane based on source IP.
     * It is invalid to specify both
     * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
     * time.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
     * </code>
     */
    com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder
        getAuthorizedNetworksConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The publicEndpoint.
     */
    java.lang.String getPublicEndpoint();
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for publicEndpoint.
     */
    com.google.protobuf.ByteString getPublicEndpointBytes();

    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The privateEndpoint.
     */
    java.lang.String getPrivateEndpoint();
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for privateEndpoint.
     */
    com.google.protobuf.ByteString getPrivateEndpointBytes();

    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster
     * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
     * invalid to specify both
     * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
     * same time.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 7;</code>
     *
     * @return The privateEndpointSubnetwork.
     */
    java.lang.String getPrivateEndpointSubnetwork();
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster
     * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
     * invalid to specify both
     * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
     * same time.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 7;</code>
     *
     * @return The bytes for privateEndpointSubnetwork.
     */
    com.google.protobuf.ByteString getPrivateEndpointSubnetworkBytes();
  }
  /**
   *
   *
   * <pre>
   * IP endpoints configuration.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig}
   */
  public static final class IPEndpointsConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig)
      IPEndpointsConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IPEndpointsConfig.newBuilder() to construct.
    private IPEndpointsConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IPEndpointsConfig() {
      publicEndpoint_ = "";
      privateEndpoint_ = "";
      privateEndpointSubnetwork_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IPEndpointsConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_IPEndpointsConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_IPEndpointsConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.class,
              com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder.class);
    }

    private int bitField0_;
    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Controls whether to allow direct IP access.
     * </pre>
     *
     * <code>optional bool enabled = 1;</code>
     *
     * @return Whether the enabled field is set.
     */
    @java.lang.Override
    public boolean hasEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls whether to allow direct IP access.
     * </pre>
     *
     * <code>optional bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int ENABLE_PUBLIC_ENDPOINT_FIELD_NUMBER = 2;
    private boolean enablePublicEndpoint_ = false;
    /**
     *
     *
     * <pre>
     * Controls whether the control plane allows access through a public IP.
     * It is invalid to specify both
     * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
     * time.
     * </pre>
     *
     * <code>optional bool enable_public_endpoint = 2;</code>
     *
     * @return Whether the enablePublicEndpoint field is set.
     */
    @java.lang.Override
    public boolean hasEnablePublicEndpoint() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls whether the control plane allows access through a public IP.
     * It is invalid to specify both
     * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
     * time.
     * </pre>
     *
     * <code>optional bool enable_public_endpoint = 2;</code>
     *
     * @return The enablePublicEndpoint.
     */
    @java.lang.Override
    public boolean getEnablePublicEndpoint() {
      return enablePublicEndpoint_;
    }

    public static final int GLOBAL_ACCESS_FIELD_NUMBER = 3;
    private boolean globalAccess_ = false;
    /**
     *
     *
     * <pre>
     * Controls whether the control plane's private endpoint is accessible from
     * sources in other regions.
     * It is invalid to specify both
     * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
     * and this field at the same time.
     * </pre>
     *
     * <code>optional bool global_access = 3;</code>
     *
     * @return Whether the globalAccess field is set.
     */
    @java.lang.Override
    public boolean hasGlobalAccess() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls whether the control plane's private endpoint is accessible from
     * sources in other regions.
     * It is invalid to specify both
     * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
     * and this field at the same time.
     * </pre>
     *
     * <code>optional bool global_access = 3;</code>
     *
     * @return The globalAccess.
     */
    @java.lang.Override
    public boolean getGlobalAccess() {
      return globalAccess_;
    }

    public static final int AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER = 4;
    private com.google.container.v1.MasterAuthorizedNetworksConfig authorizedNetworksConfig_;
    /**
     *
     *
     * <pre>
     * Configuration of authorized networks. If enabled, restricts access to the
     * control plane based on source IP.
     * It is invalid to specify both
     * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
     * time.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
     * </code>
     *
     * @return Whether the authorizedNetworksConfig field is set.
     */
    @java.lang.Override
    public boolean hasAuthorizedNetworksConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration of authorized networks. If enabled, restricts access to the
     * control plane based on source IP.
     * It is invalid to specify both
     * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
     * time.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
     * </code>
     *
     * @return The authorizedNetworksConfig.
     */
    @java.lang.Override
    public com.google.container.v1.MasterAuthorizedNetworksConfig getAuthorizedNetworksConfig() {
      return authorizedNetworksConfig_ == null
          ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
          : authorizedNetworksConfig_;
    }
    /**
     *
     *
     * <pre>
     * Configuration of authorized networks. If enabled, restricts access to the
     * control plane based on source IP.
     * It is invalid to specify both
     * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
     * time.
     * </pre>
     *
     * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder
        getAuthorizedNetworksConfigOrBuilder() {
      return authorizedNetworksConfig_ == null
          ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
          : authorizedNetworksConfig_;
    }

    public static final int PUBLIC_ENDPOINT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object publicEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The publicEndpoint.
     */
    @java.lang.Override
    public java.lang.String getPublicEndpoint() {
      java.lang.Object ref = publicEndpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicEndpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for publicEndpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublicEndpointBytes() {
      java.lang.Object ref = publicEndpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRIVATE_ENDPOINT_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object privateEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The privateEndpoint.
     */
    @java.lang.Override
    public java.lang.String getPrivateEndpoint() {
      java.lang.Object ref = privateEndpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateEndpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's control plane.
     * Only populated if enabled.
     * </pre>
     *
     * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for privateEndpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrivateEndpointBytes() {
      java.lang.Object ref = privateEndpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRIVATE_ENDPOINT_SUBNETWORK_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object privateEndpointSubnetwork_ = "";
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster
     * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
     * invalid to specify both
     * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
     * same time.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 7;</code>
     *
     * @return The privateEndpointSubnetwork.
     */
    @java.lang.Override
    public java.lang.String getPrivateEndpointSubnetwork() {
      java.lang.Object ref = privateEndpointSubnetwork_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateEndpointSubnetwork_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster
     * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
     * invalid to specify both
     * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
     * same time.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 7;</code>
     *
     * @return The bytes for privateEndpointSubnetwork.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrivateEndpointSubnetworkBytes() {
      java.lang.Object ref = privateEndpointSubnetwork_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateEndpointSubnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(1, enabled_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBool(2, enablePublicEndpoint_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(3, globalAccess_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getAuthorizedNetworksConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicEndpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, publicEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, privateEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpointSubnetwork_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, privateEndpointSubnetwork_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enablePublicEndpoint_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, globalAccess_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getAuthorizedNetworksConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicEndpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, publicEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, privateEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpointSubnetwork_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(7, privateEndpointSubnetwork_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig other =
          (com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig) obj;

      if (hasEnabled() != other.hasEnabled()) return false;
      if (hasEnabled()) {
        if (getEnabled() != other.getEnabled()) return false;
      }
      if (hasEnablePublicEndpoint() != other.hasEnablePublicEndpoint()) return false;
      if (hasEnablePublicEndpoint()) {
        if (getEnablePublicEndpoint() != other.getEnablePublicEndpoint()) return false;
      }
      if (hasGlobalAccess() != other.hasGlobalAccess()) return false;
      if (hasGlobalAccess()) {
        if (getGlobalAccess() != other.getGlobalAccess()) return false;
      }
      if (hasAuthorizedNetworksConfig() != other.hasAuthorizedNetworksConfig()) return false;
      if (hasAuthorizedNetworksConfig()) {
        if (!getAuthorizedNetworksConfig().equals(other.getAuthorizedNetworksConfig()))
          return false;
      }
      if (!getPublicEndpoint().equals(other.getPublicEndpoint())) return false;
      if (!getPrivateEndpoint().equals(other.getPrivateEndpoint())) return false;
      if (!getPrivateEndpointSubnetwork().equals(other.getPrivateEndpointSubnetwork()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEnabled()) {
        hash = (37 * hash) + ENABLED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      }
      if (hasEnablePublicEndpoint()) {
        hash = (37 * hash) + ENABLE_PUBLIC_ENDPOINT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePublicEndpoint());
      }
      if (hasGlobalAccess()) {
        hash = (37 * hash) + GLOBAL_ACCESS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGlobalAccess());
      }
      if (hasAuthorizedNetworksConfig()) {
        hash = (37 * hash) + AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAuthorizedNetworksConfig().hashCode();
      }
      hash = (37 * hash) + PUBLIC_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getPublicEndpoint().hashCode();
      hash = (37 * hash) + PRIVATE_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateEndpoint().hashCode();
      hash = (37 * hash) + PRIVATE_ENDPOINT_SUBNETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateEndpointSubnetwork().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig)
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ControlPlaneEndpointsConfig_IPEndpointsConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ControlPlaneEndpointsConfig_IPEndpointsConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.class,
                com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAuthorizedNetworksConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        enablePublicEndpoint_ = false;
        globalAccess_ = false;
        authorizedNetworksConfig_ = null;
        if (authorizedNetworksConfigBuilder_ != null) {
          authorizedNetworksConfigBuilder_.dispose();
          authorizedNetworksConfigBuilder_ = null;
        }
        publicEndpoint_ = "";
        privateEndpoint_ = "";
        privateEndpointSubnetwork_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_ControlPlaneEndpointsConfig_IPEndpointsConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
          getDefaultInstanceForType() {
        return com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig build() {
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig buildPartial() {
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig result =
            new com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enablePublicEndpoint_ = enablePublicEndpoint_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.globalAccess_ = globalAccess_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.authorizedNetworksConfig_ =
              authorizedNetworksConfigBuilder_ == null
                  ? authorizedNetworksConfig_
                  : authorizedNetworksConfigBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.publicEndpoint_ = publicEndpoint_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.privateEndpoint_ = privateEndpoint_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.privateEndpointSubnetwork_ = privateEndpointSubnetwork_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig) {
          return mergeFrom(
              (com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig other) {
        if (other
            == com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
                .getDefaultInstance()) return this;
        if (other.hasEnabled()) {
          setEnabled(other.getEnabled());
        }
        if (other.hasEnablePublicEndpoint()) {
          setEnablePublicEndpoint(other.getEnablePublicEndpoint());
        }
        if (other.hasGlobalAccess()) {
          setGlobalAccess(other.getGlobalAccess());
        }
        if (other.hasAuthorizedNetworksConfig()) {
          mergeAuthorizedNetworksConfig(other.getAuthorizedNetworksConfig());
        }
        if (!other.getPublicEndpoint().isEmpty()) {
          publicEndpoint_ = other.publicEndpoint_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getPrivateEndpoint().isEmpty()) {
          privateEndpoint_ = other.privateEndpoint_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.getPrivateEndpointSubnetwork().isEmpty()) {
          privateEndpointSubnetwork_ = other.privateEndpointSubnetwork_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  enablePublicEndpoint_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  globalAccess_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(
                      getAuthorizedNetworksConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  publicEndpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  privateEndpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  privateEndpointSubnetwork_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Controls whether to allow direct IP access.
       * </pre>
       *
       * <code>optional bool enabled = 1;</code>
       *
       * @return Whether the enabled field is set.
       */
      @java.lang.Override
      public boolean hasEnabled() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Controls whether to allow direct IP access.
       * </pre>
       *
       * <code>optional bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Controls whether to allow direct IP access.
       * </pre>
       *
       * <code>optional bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Controls whether to allow direct IP access.
       * </pre>
       *
       * <code>optional bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private boolean enablePublicEndpoint_;
      /**
       *
       *
       * <pre>
       * Controls whether the control plane allows access through a public IP.
       * It is invalid to specify both
       * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
       * time.
       * </pre>
       *
       * <code>optional bool enable_public_endpoint = 2;</code>
       *
       * @return Whether the enablePublicEndpoint field is set.
       */
      @java.lang.Override
      public boolean hasEnablePublicEndpoint() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Controls whether the control plane allows access through a public IP.
       * It is invalid to specify both
       * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
       * time.
       * </pre>
       *
       * <code>optional bool enable_public_endpoint = 2;</code>
       *
       * @return The enablePublicEndpoint.
       */
      @java.lang.Override
      public boolean getEnablePublicEndpoint() {
        return enablePublicEndpoint_;
      }
      /**
       *
       *
       * <pre>
       * Controls whether the control plane allows access through a public IP.
       * It is invalid to specify both
       * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
       * time.
       * </pre>
       *
       * <code>optional bool enable_public_endpoint = 2;</code>
       *
       * @param value The enablePublicEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEnablePublicEndpoint(boolean value) {

        enablePublicEndpoint_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Controls whether the control plane allows access through a public IP.
       * It is invalid to specify both
       * [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
       * time.
       * </pre>
       *
       * <code>optional bool enable_public_endpoint = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnablePublicEndpoint() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enablePublicEndpoint_ = false;
        onChanged();
        return this;
      }

      private boolean globalAccess_;
      /**
       *
       *
       * <pre>
       * Controls whether the control plane's private endpoint is accessible from
       * sources in other regions.
       * It is invalid to specify both
       * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
       * and this field at the same time.
       * </pre>
       *
       * <code>optional bool global_access = 3;</code>
       *
       * @return Whether the globalAccess field is set.
       */
      @java.lang.Override
      public boolean hasGlobalAccess() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Controls whether the control plane's private endpoint is accessible from
       * sources in other regions.
       * It is invalid to specify both
       * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
       * and this field at the same time.
       * </pre>
       *
       * <code>optional bool global_access = 3;</code>
       *
       * @return The globalAccess.
       */
      @java.lang.Override
      public boolean getGlobalAccess() {
        return globalAccess_;
      }
      /**
       *
       *
       * <pre>
       * Controls whether the control plane's private endpoint is accessible from
       * sources in other regions.
       * It is invalid to specify both
       * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
       * and this field at the same time.
       * </pre>
       *
       * <code>optional bool global_access = 3;</code>
       *
       * @param value The globalAccess to set.
       * @return This builder for chaining.
       */
      public Builder setGlobalAccess(boolean value) {

        globalAccess_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Controls whether the control plane's private endpoint is accessible from
       * sources in other regions.
       * It is invalid to specify both
       * [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
       * and this field at the same time.
       * </pre>
       *
       * <code>optional bool global_access = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGlobalAccess() {
        bitField0_ = (bitField0_ & ~0x00000004);
        globalAccess_ = false;
        onChanged();
        return this;
      }

      private com.google.container.v1.MasterAuthorizedNetworksConfig authorizedNetworksConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1.MasterAuthorizedNetworksConfig,
              com.google.container.v1.MasterAuthorizedNetworksConfig.Builder,
              com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder>
          authorizedNetworksConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       *
       * @return Whether the authorizedNetworksConfig field is set.
       */
      public boolean hasAuthorizedNetworksConfig() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       *
       * @return The authorizedNetworksConfig.
       */
      public com.google.container.v1.MasterAuthorizedNetworksConfig getAuthorizedNetworksConfig() {
        if (authorizedNetworksConfigBuilder_ == null) {
          return authorizedNetworksConfig_ == null
              ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
              : authorizedNetworksConfig_;
        } else {
          return authorizedNetworksConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      public Builder setAuthorizedNetworksConfig(
          com.google.container.v1.MasterAuthorizedNetworksConfig value) {
        if (authorizedNetworksConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authorizedNetworksConfig_ = value;
        } else {
          authorizedNetworksConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      public Builder setAuthorizedNetworksConfig(
          com.google.container.v1.MasterAuthorizedNetworksConfig.Builder builderForValue) {
        if (authorizedNetworksConfigBuilder_ == null) {
          authorizedNetworksConfig_ = builderForValue.build();
        } else {
          authorizedNetworksConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      public Builder mergeAuthorizedNetworksConfig(
          com.google.container.v1.MasterAuthorizedNetworksConfig value) {
        if (authorizedNetworksConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && authorizedNetworksConfig_ != null
              && authorizedNetworksConfig_
                  != com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()) {
            getAuthorizedNetworksConfigBuilder().mergeFrom(value);
          } else {
            authorizedNetworksConfig_ = value;
          }
        } else {
          authorizedNetworksConfigBuilder_.mergeFrom(value);
        }
        if (authorizedNetworksConfig_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      public Builder clearAuthorizedNetworksConfig() {
        bitField0_ = (bitField0_ & ~0x00000008);
        authorizedNetworksConfig_ = null;
        if (authorizedNetworksConfigBuilder_ != null) {
          authorizedNetworksConfigBuilder_.dispose();
          authorizedNetworksConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      public com.google.container.v1.MasterAuthorizedNetworksConfig.Builder
          getAuthorizedNetworksConfigBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getAuthorizedNetworksConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      public com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder
          getAuthorizedNetworksConfigOrBuilder() {
        if (authorizedNetworksConfigBuilder_ != null) {
          return authorizedNetworksConfigBuilder_.getMessageOrBuilder();
        } else {
          return authorizedNetworksConfig_ == null
              ? com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance()
              : authorizedNetworksConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of authorized networks. If enabled, restricts access to the
       * control plane based on source IP.
       * It is invalid to specify both
       * [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
       * time.
       * </pre>
       *
       * <code>.google.container.v1.MasterAuthorizedNetworksConfig authorized_networks_config = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1.MasterAuthorizedNetworksConfig,
              com.google.container.v1.MasterAuthorizedNetworksConfig.Builder,
              com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder>
          getAuthorizedNetworksConfigFieldBuilder() {
        if (authorizedNetworksConfigBuilder_ == null) {
          authorizedNetworksConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.container.v1.MasterAuthorizedNetworksConfig,
                  com.google.container.v1.MasterAuthorizedNetworksConfig.Builder,
                  com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder>(
                  getAuthorizedNetworksConfig(), getParentForChildren(), isClean());
          authorizedNetworksConfig_ = null;
        }
        return authorizedNetworksConfigBuilder_;
      }

      private java.lang.Object publicEndpoint_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The external IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The publicEndpoint.
       */
      public java.lang.String getPublicEndpoint() {
        java.lang.Object ref = publicEndpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publicEndpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The external IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for publicEndpoint.
       */
      public com.google.protobuf.ByteString getPublicEndpointBytes() {
        java.lang.Object ref = publicEndpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publicEndpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The external IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The publicEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setPublicEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicEndpoint_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The external IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicEndpoint() {
        publicEndpoint_ = getDefaultInstance().getPublicEndpoint();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The external IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for publicEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setPublicEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publicEndpoint_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object privateEndpoint_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The internal IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The privateEndpoint.
       */
      public java.lang.String getPrivateEndpoint() {
        java.lang.Object ref = privateEndpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          privateEndpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The internal IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for privateEndpoint.
       */
      public com.google.protobuf.ByteString getPrivateEndpointBytes() {
        java.lang.Object ref = privateEndpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          privateEndpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The internal IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The privateEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateEndpoint_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The internal IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrivateEndpoint() {
        privateEndpoint_ = getDefaultInstance().getPrivateEndpoint();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The internal IP address of this cluster's control plane.
       * Only populated if enabled.
       * </pre>
       *
       * <code>string private_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for privateEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        privateEndpoint_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private java.lang.Object privateEndpointSubnetwork_ = "";
      /**
       *
       *
       * <pre>
       * Subnet to provision the master's private endpoint during cluster
       * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
       * invalid to specify both
       * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
       * same time.
       * </pre>
       *
       * <code>string private_endpoint_subnetwork = 7;</code>
       *
       * @return The privateEndpointSubnetwork.
       */
      public java.lang.String getPrivateEndpointSubnetwork() {
        java.lang.Object ref = privateEndpointSubnetwork_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          privateEndpointSubnetwork_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Subnet to provision the master's private endpoint during cluster
       * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
       * invalid to specify both
       * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
       * same time.
       * </pre>
       *
       * <code>string private_endpoint_subnetwork = 7;</code>
       *
       * @return The bytes for privateEndpointSubnetwork.
       */
      public com.google.protobuf.ByteString getPrivateEndpointSubnetworkBytes() {
        java.lang.Object ref = privateEndpointSubnetwork_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          privateEndpointSubnetwork_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Subnet to provision the master's private endpoint during cluster
       * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
       * invalid to specify both
       * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
       * same time.
       * </pre>
       *
       * <code>string private_endpoint_subnetwork = 7;</code>
       *
       * @param value The privateEndpointSubnetwork to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateEndpointSubnetwork(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateEndpointSubnetwork_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Subnet to provision the master's private endpoint during cluster
       * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
       * invalid to specify both
       * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
       * same time.
       * </pre>
       *
       * <code>string private_endpoint_subnetwork = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrivateEndpointSubnetwork() {
        privateEndpointSubnetwork_ = getDefaultInstance().getPrivateEndpointSubnetwork();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Subnet to provision the master's private endpoint during cluster
       * creation. Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format. It is
       * invalid to specify both
       * [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
       * same time.
       * </pre>
       *
       * <code>string private_endpoint_subnetwork = 7;</code>
       *
       * @param value The bytes for privateEndpointSubnetwork to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateEndpointSubnetworkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        privateEndpointSubnetwork_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig)
    private static final com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig();
    }

    public static com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IPEndpointsConfig> PARSER =
        new com.google.protobuf.AbstractParser<IPEndpointsConfig>() {
          @java.lang.Override
          public IPEndpointsConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IPEndpointsConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IPEndpointsConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DNS_ENDPOINT_CONFIG_FIELD_NUMBER = 1;
  private com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dnsEndpointConfig_;
  /**
   *
   *
   * <pre>
   * DNS endpoint configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
   * </code>
   *
   * @return Whether the dnsEndpointConfig field is set.
   */
  @java.lang.Override
  public boolean hasDnsEndpointConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * DNS endpoint configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
   * </code>
   *
   * @return The dnsEndpointConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
      getDnsEndpointConfig() {
    return dnsEndpointConfig_ == null
        ? com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.getDefaultInstance()
        : dnsEndpointConfig_;
  }
  /**
   *
   *
   * <pre>
   * DNS endpoint configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfigOrBuilder
      getDnsEndpointConfigOrBuilder() {
    return dnsEndpointConfig_ == null
        ? com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.getDefaultInstance()
        : dnsEndpointConfig_;
  }

  public static final int IP_ENDPOINTS_CONFIG_FIELD_NUMBER = 3;
  private com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ipEndpointsConfig_;
  /**
   *
   *
   * <pre>
   * IP endpoints configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
   * </code>
   *
   * @return Whether the ipEndpointsConfig field is set.
   */
  @java.lang.Override
  public boolean hasIpEndpointsConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * IP endpoints configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
   * </code>
   *
   * @return The ipEndpointsConfig.
   */
  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
      getIpEndpointsConfig() {
    return ipEndpointsConfig_ == null
        ? com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.getDefaultInstance()
        : ipEndpointsConfig_;
  }
  /**
   *
   *
   * <pre>
   * IP endpoints configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfigOrBuilder
      getIpEndpointsConfigOrBuilder() {
    return ipEndpointsConfig_ == null
        ? com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.getDefaultInstance()
        : ipEndpointsConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDnsEndpointConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getIpEndpointsConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDnsEndpointConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIpEndpointsConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.ControlPlaneEndpointsConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.ControlPlaneEndpointsConfig other =
        (com.google.container.v1.ControlPlaneEndpointsConfig) obj;

    if (hasDnsEndpointConfig() != other.hasDnsEndpointConfig()) return false;
    if (hasDnsEndpointConfig()) {
      if (!getDnsEndpointConfig().equals(other.getDnsEndpointConfig())) return false;
    }
    if (hasIpEndpointsConfig() != other.hasIpEndpointsConfig()) return false;
    if (hasIpEndpointsConfig()) {
      if (!getIpEndpointsConfig().equals(other.getIpEndpointsConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDnsEndpointConfig()) {
      hash = (37 * hash) + DNS_ENDPOINT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDnsEndpointConfig().hashCode();
    }
    if (hasIpEndpointsConfig()) {
      hash = (37 * hash) + IP_ENDPOINTS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIpEndpointsConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.ControlPlaneEndpointsConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for all of the cluster's control plane endpoints.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.ControlPlaneEndpointsConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.ControlPlaneEndpointsConfig)
      com.google.container.v1.ControlPlaneEndpointsConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.ControlPlaneEndpointsConfig.class,
              com.google.container.v1.ControlPlaneEndpointsConfig.Builder.class);
    }

    // Construct using com.google.container.v1.ControlPlaneEndpointsConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDnsEndpointConfigFieldBuilder();
        getIpEndpointsConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dnsEndpointConfig_ = null;
      if (dnsEndpointConfigBuilder_ != null) {
        dnsEndpointConfigBuilder_.dispose();
        dnsEndpointConfigBuilder_ = null;
      }
      ipEndpointsConfig_ = null;
      if (ipEndpointsConfigBuilder_ != null) {
        ipEndpointsConfigBuilder_.dispose();
        ipEndpointsConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_ControlPlaneEndpointsConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.ControlPlaneEndpointsConfig getDefaultInstanceForType() {
      return com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.ControlPlaneEndpointsConfig build() {
      com.google.container.v1.ControlPlaneEndpointsConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.ControlPlaneEndpointsConfig buildPartial() {
      com.google.container.v1.ControlPlaneEndpointsConfig result =
          new com.google.container.v1.ControlPlaneEndpointsConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.ControlPlaneEndpointsConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dnsEndpointConfig_ =
            dnsEndpointConfigBuilder_ == null
                ? dnsEndpointConfig_
                : dnsEndpointConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ipEndpointsConfig_ =
            ipEndpointsConfigBuilder_ == null
                ? ipEndpointsConfig_
                : ipEndpointsConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.ControlPlaneEndpointsConfig) {
        return mergeFrom((com.google.container.v1.ControlPlaneEndpointsConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.ControlPlaneEndpointsConfig other) {
      if (other == com.google.container.v1.ControlPlaneEndpointsConfig.getDefaultInstance())
        return this;
      if (other.hasDnsEndpointConfig()) {
        mergeDnsEndpointConfig(other.getDnsEndpointConfig());
      }
      if (other.hasIpEndpointsConfig()) {
        mergeIpEndpointsConfig(other.getIpEndpointsConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getDnsEndpointConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getIpEndpointsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        dnsEndpointConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig,
            com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder,
            com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfigOrBuilder>
        dnsEndpointConfigBuilder_;
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     *
     * @return Whether the dnsEndpointConfig field is set.
     */
    public boolean hasDnsEndpointConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     *
     * @return The dnsEndpointConfig.
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
        getDnsEndpointConfig() {
      if (dnsEndpointConfigBuilder_ == null) {
        return dnsEndpointConfig_ == null
            ? com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
                .getDefaultInstance()
            : dnsEndpointConfig_;
      } else {
        return dnsEndpointConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    public Builder setDnsEndpointConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig value) {
      if (dnsEndpointConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsEndpointConfig_ = value;
      } else {
        dnsEndpointConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    public Builder setDnsEndpointConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder
            builderForValue) {
      if (dnsEndpointConfigBuilder_ == null) {
        dnsEndpointConfig_ = builderForValue.build();
      } else {
        dnsEndpointConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    public Builder mergeDnsEndpointConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig value) {
      if (dnsEndpointConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && dnsEndpointConfig_ != null
            && dnsEndpointConfig_
                != com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
                    .getDefaultInstance()) {
          getDnsEndpointConfigBuilder().mergeFrom(value);
        } else {
          dnsEndpointConfig_ = value;
        }
      } else {
        dnsEndpointConfigBuilder_.mergeFrom(value);
      }
      if (dnsEndpointConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    public Builder clearDnsEndpointConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      dnsEndpointConfig_ = null;
      if (dnsEndpointConfigBuilder_ != null) {
        dnsEndpointConfigBuilder_.dispose();
        dnsEndpointConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder
        getDnsEndpointConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDnsEndpointConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfigOrBuilder
        getDnsEndpointConfigOrBuilder() {
      if (dnsEndpointConfigBuilder_ != null) {
        return dnsEndpointConfigBuilder_.getMessageOrBuilder();
      } else {
        return dnsEndpointConfig_ == null
            ? com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig
                .getDefaultInstance()
            : dnsEndpointConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * DNS endpoint configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig dns_endpoint_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig,
            com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder,
            com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfigOrBuilder>
        getDnsEndpointConfigFieldBuilder() {
      if (dnsEndpointConfigBuilder_ == null) {
        dnsEndpointConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig,
                com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.Builder,
                com.google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfigOrBuilder>(
                getDnsEndpointConfig(), getParentForChildren(), isClean());
        dnsEndpointConfig_ = null;
      }
      return dnsEndpointConfigBuilder_;
    }

    private com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        ipEndpointsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig,
            com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder,
            com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfigOrBuilder>
        ipEndpointsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     *
     * @return Whether the ipEndpointsConfig field is set.
     */
    public boolean hasIpEndpointsConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     *
     * @return The ipEndpointsConfig.
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
        getIpEndpointsConfig() {
      if (ipEndpointsConfigBuilder_ == null) {
        return ipEndpointsConfig_ == null
            ? com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
                .getDefaultInstance()
            : ipEndpointsConfig_;
      } else {
        return ipEndpointsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    public Builder setIpEndpointsConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig value) {
      if (ipEndpointsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ipEndpointsConfig_ = value;
      } else {
        ipEndpointsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    public Builder setIpEndpointsConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder
            builderForValue) {
      if (ipEndpointsConfigBuilder_ == null) {
        ipEndpointsConfig_ = builderForValue.build();
      } else {
        ipEndpointsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    public Builder mergeIpEndpointsConfig(
        com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig value) {
      if (ipEndpointsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && ipEndpointsConfig_ != null
            && ipEndpointsConfig_
                != com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
                    .getDefaultInstance()) {
          getIpEndpointsConfigBuilder().mergeFrom(value);
        } else {
          ipEndpointsConfig_ = value;
        }
      } else {
        ipEndpointsConfigBuilder_.mergeFrom(value);
      }
      if (ipEndpointsConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    public Builder clearIpEndpointsConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      ipEndpointsConfig_ = null;
      if (ipEndpointsConfigBuilder_ != null) {
        ipEndpointsConfigBuilder_.dispose();
        ipEndpointsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder
        getIpEndpointsConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getIpEndpointsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    public com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfigOrBuilder
        getIpEndpointsConfigOrBuilder() {
      if (ipEndpointsConfigBuilder_ != null) {
        return ipEndpointsConfigBuilder_.getMessageOrBuilder();
      } else {
        return ipEndpointsConfig_ == null
            ? com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig
                .getDefaultInstance()
            : ipEndpointsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * IP endpoints configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig ip_endpoints_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig,
            com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder,
            com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfigOrBuilder>
        getIpEndpointsConfigFieldBuilder() {
      if (ipEndpointsConfigBuilder_ == null) {
        ipEndpointsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig,
                com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.Builder,
                com.google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfigOrBuilder>(
                getIpEndpointsConfig(), getParentForChildren(), isClean());
        ipEndpointsConfig_ = null;
      }
      return ipEndpointsConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.ControlPlaneEndpointsConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.ControlPlaneEndpointsConfig)
  private static final com.google.container.v1.ControlPlaneEndpointsConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.ControlPlaneEndpointsConfig();
  }

  public static com.google.container.v1.ControlPlaneEndpointsConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ControlPlaneEndpointsConfig> PARSER =
      new com.google.protobuf.AbstractParser<ControlPlaneEndpointsConfig>() {
        @java.lang.Override
        public ControlPlaneEndpointsConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ControlPlaneEndpointsConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ControlPlaneEndpointsConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.ControlPlaneEndpointsConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
