/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * MaintenanceWindow defines the maintenance window to be used for the cluster.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.MaintenanceWindow}
 */
public final class MaintenanceWindow extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.MaintenanceWindow)
    MaintenanceWindowOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MaintenanceWindow.newBuilder() to construct.
  private MaintenanceWindow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MaintenanceWindow() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MaintenanceWindow();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_MaintenanceWindow_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetMaintenanceExclusions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_MaintenanceWindow_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.MaintenanceWindow.class,
            com.google.container.v1.MaintenanceWindow.Builder.class);
  }

  private int policyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object policy_;

  public enum PolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DAILY_MAINTENANCE_WINDOW(2),
    RECURRING_WINDOW(3),
    POLICY_NOT_SET(0);
    private final int value;

    private PolicyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static PolicyCase forNumber(int value) {
      switch (value) {
        case 2:
          return DAILY_MAINTENANCE_WINDOW;
        case 3:
          return RECURRING_WINDOW;
        case 0:
          return POLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PolicyCase getPolicyCase() {
    return PolicyCase.forNumber(policyCase_);
  }

  public static final int DAILY_MAINTENANCE_WINDOW_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * DailyMaintenanceWindow specifies a daily maintenance operation window.
   * </pre>
   *
   * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
   *
   * @return Whether the dailyMaintenanceWindow field is set.
   */
  @java.lang.Override
  public boolean hasDailyMaintenanceWindow() {
    return policyCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * DailyMaintenanceWindow specifies a daily maintenance operation window.
   * </pre>
   *
   * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
   *
   * @return The dailyMaintenanceWindow.
   */
  @java.lang.Override
  public com.google.container.v1.DailyMaintenanceWindow getDailyMaintenanceWindow() {
    if (policyCase_ == 2) {
      return (com.google.container.v1.DailyMaintenanceWindow) policy_;
    }
    return com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * DailyMaintenanceWindow specifies a daily maintenance operation window.
   * </pre>
   *
   * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
   */
  @java.lang.Override
  public com.google.container.v1.DailyMaintenanceWindowOrBuilder
      getDailyMaintenanceWindowOrBuilder() {
    if (policyCase_ == 2) {
      return (com.google.container.v1.DailyMaintenanceWindow) policy_;
    }
    return com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance();
  }

  public static final int RECURRING_WINDOW_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * RecurringWindow specifies some number of recurring time periods for
   * maintenance to occur. The time windows may be overlapping. If no
   * maintenance windows are set, maintenance can occur at any time.
   * </pre>
   *
   * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
   *
   * @return Whether the recurringWindow field is set.
   */
  @java.lang.Override
  public boolean hasRecurringWindow() {
    return policyCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * RecurringWindow specifies some number of recurring time periods for
   * maintenance to occur. The time windows may be overlapping. If no
   * maintenance windows are set, maintenance can occur at any time.
   * </pre>
   *
   * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
   *
   * @return The recurringWindow.
   */
  @java.lang.Override
  public com.google.container.v1.RecurringTimeWindow getRecurringWindow() {
    if (policyCase_ == 3) {
      return (com.google.container.v1.RecurringTimeWindow) policy_;
    }
    return com.google.container.v1.RecurringTimeWindow.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * RecurringWindow specifies some number of recurring time periods for
   * maintenance to occur. The time windows may be overlapping. If no
   * maintenance windows are set, maintenance can occur at any time.
   * </pre>
   *
   * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
   */
  @java.lang.Override
  public com.google.container.v1.RecurringTimeWindowOrBuilder getRecurringWindowOrBuilder() {
    if (policyCase_ == 3) {
      return (com.google.container.v1.RecurringTimeWindow) policy_;
    }
    return com.google.container.v1.RecurringTimeWindow.getDefaultInstance();
  }

  public static final int MAINTENANCE_EXCLUSIONS_FIELD_NUMBER = 4;

  private static final class MaintenanceExclusionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.container.v1.TimeWindow>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.container.v1.TimeWindow>newDefaultInstance(
                    com.google.container.v1.ClusterServiceProto
                        .internal_static_google_container_v1_MaintenanceWindow_MaintenanceExclusionsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.container.v1.TimeWindow.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.container.v1.TimeWindow>
      maintenanceExclusions_;

  private com.google.protobuf.MapField<java.lang.String, com.google.container.v1.TimeWindow>
      internalGetMaintenanceExclusions() {
    if (maintenanceExclusions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MaintenanceExclusionsDefaultEntryHolder.defaultEntry);
    }
    return maintenanceExclusions_;
  }

  public int getMaintenanceExclusionsCount() {
    return internalGetMaintenanceExclusions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Exceptions to maintenance window. Non-emergency maintenance should not
   * occur in these windows.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
   */
  @java.lang.Override
  public boolean containsMaintenanceExclusions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMaintenanceExclusions().getMap().containsKey(key);
  }
  /** Use {@link #getMaintenanceExclusionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.container.v1.TimeWindow>
      getMaintenanceExclusions() {
    return getMaintenanceExclusionsMap();
  }
  /**
   *
   *
   * <pre>
   * Exceptions to maintenance window. Non-emergency maintenance should not
   * occur in these windows.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.container.v1.TimeWindow>
      getMaintenanceExclusionsMap() {
    return internalGetMaintenanceExclusions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Exceptions to maintenance window. Non-emergency maintenance should not
   * occur in these windows.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.container.v1.TimeWindow getMaintenanceExclusionsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.container.v1.TimeWindow defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.container.v1.TimeWindow> map =
        internalGetMaintenanceExclusions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Exceptions to maintenance window. Non-emergency maintenance should not
   * occur in these windows.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
   */
  @java.lang.Override
  public com.google.container.v1.TimeWindow getMaintenanceExclusionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.container.v1.TimeWindow> map =
        internalGetMaintenanceExclusions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (policyCase_ == 2) {
      output.writeMessage(2, (com.google.container.v1.DailyMaintenanceWindow) policy_);
    }
    if (policyCase_ == 3) {
      output.writeMessage(3, (com.google.container.v1.RecurringTimeWindow) policy_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetMaintenanceExclusions(),
        MaintenanceExclusionsDefaultEntryHolder.defaultEntry,
        4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (policyCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.container.v1.DailyMaintenanceWindow) policy_);
    }
    if (policyCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.container.v1.RecurringTimeWindow) policy_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.container.v1.TimeWindow> entry :
        internalGetMaintenanceExclusions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.container.v1.TimeWindow>
          maintenanceExclusions__ =
              MaintenanceExclusionsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, maintenanceExclusions__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.MaintenanceWindow)) {
      return super.equals(obj);
    }
    com.google.container.v1.MaintenanceWindow other =
        (com.google.container.v1.MaintenanceWindow) obj;

    if (!internalGetMaintenanceExclusions().equals(other.internalGetMaintenanceExclusions()))
      return false;
    if (!getPolicyCase().equals(other.getPolicyCase())) return false;
    switch (policyCase_) {
      case 2:
        if (!getDailyMaintenanceWindow().equals(other.getDailyMaintenanceWindow())) return false;
        break;
      case 3:
        if (!getRecurringWindow().equals(other.getRecurringWindow())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetMaintenanceExclusions().getMap().isEmpty()) {
      hash = (37 * hash) + MAINTENANCE_EXCLUSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMaintenanceExclusions().hashCode();
    }
    switch (policyCase_) {
      case 2:
        hash = (37 * hash) + DAILY_MAINTENANCE_WINDOW_FIELD_NUMBER;
        hash = (53 * hash) + getDailyMaintenanceWindow().hashCode();
        break;
      case 3:
        hash = (37 * hash) + RECURRING_WINDOW_FIELD_NUMBER;
        hash = (53 * hash) + getRecurringWindow().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.MaintenanceWindow parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MaintenanceWindow parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MaintenanceWindow parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.MaintenanceWindow prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * MaintenanceWindow defines the maintenance window to be used for the cluster.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.MaintenanceWindow}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.MaintenanceWindow)
      com.google.container.v1.MaintenanceWindowOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MaintenanceWindow_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMaintenanceExclusions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableMaintenanceExclusions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MaintenanceWindow_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.MaintenanceWindow.class,
              com.google.container.v1.MaintenanceWindow.Builder.class);
    }

    // Construct using com.google.container.v1.MaintenanceWindow.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dailyMaintenanceWindowBuilder_ != null) {
        dailyMaintenanceWindowBuilder_.clear();
      }
      if (recurringWindowBuilder_ != null) {
        recurringWindowBuilder_.clear();
      }
      internalGetMutableMaintenanceExclusions().clear();
      policyCase_ = 0;
      policy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MaintenanceWindow_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.MaintenanceWindow getDefaultInstanceForType() {
      return com.google.container.v1.MaintenanceWindow.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.MaintenanceWindow build() {
      com.google.container.v1.MaintenanceWindow result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.MaintenanceWindow buildPartial() {
      com.google.container.v1.MaintenanceWindow result =
          new com.google.container.v1.MaintenanceWindow(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.MaintenanceWindow result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maintenanceExclusions_ =
            internalGetMaintenanceExclusions()
                .build(MaintenanceExclusionsDefaultEntryHolder.defaultEntry);
      }
    }

    private void buildPartialOneofs(com.google.container.v1.MaintenanceWindow result) {
      result.policyCase_ = policyCase_;
      result.policy_ = this.policy_;
      if (policyCase_ == 2 && dailyMaintenanceWindowBuilder_ != null) {
        result.policy_ = dailyMaintenanceWindowBuilder_.build();
      }
      if (policyCase_ == 3 && recurringWindowBuilder_ != null) {
        result.policy_ = recurringWindowBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.MaintenanceWindow) {
        return mergeFrom((com.google.container.v1.MaintenanceWindow) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.MaintenanceWindow other) {
      if (other == com.google.container.v1.MaintenanceWindow.getDefaultInstance()) return this;
      internalGetMutableMaintenanceExclusions().mergeFrom(other.internalGetMaintenanceExclusions());
      bitField0_ |= 0x00000004;
      switch (other.getPolicyCase()) {
        case DAILY_MAINTENANCE_WINDOW:
          {
            mergeDailyMaintenanceWindow(other.getDailyMaintenanceWindow());
            break;
          }
        case RECURRING_WINDOW:
          {
            mergeRecurringWindow(other.getRecurringWindow());
            break;
          }
        case POLICY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getDailyMaintenanceWindowFieldBuilder().getBuilder(), extensionRegistry);
                policyCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRecurringWindowFieldBuilder().getBuilder(), extensionRegistry);
                policyCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.container.v1.TimeWindow>
                    maintenanceExclusions__ =
                        input.readMessage(
                            MaintenanceExclusionsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableMaintenanceExclusions()
                    .ensureBuilderMap()
                    .put(maintenanceExclusions__.getKey(), maintenanceExclusions__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int policyCase_ = 0;
    private java.lang.Object policy_;

    public PolicyCase getPolicyCase() {
      return PolicyCase.forNumber(policyCase_);
    }

    public Builder clearPolicy() {
      policyCase_ = 0;
      policy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.DailyMaintenanceWindow,
            com.google.container.v1.DailyMaintenanceWindow.Builder,
            com.google.container.v1.DailyMaintenanceWindowOrBuilder>
        dailyMaintenanceWindowBuilder_;
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     *
     * @return Whether the dailyMaintenanceWindow field is set.
     */
    @java.lang.Override
    public boolean hasDailyMaintenanceWindow() {
      return policyCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     *
     * @return The dailyMaintenanceWindow.
     */
    @java.lang.Override
    public com.google.container.v1.DailyMaintenanceWindow getDailyMaintenanceWindow() {
      if (dailyMaintenanceWindowBuilder_ == null) {
        if (policyCase_ == 2) {
          return (com.google.container.v1.DailyMaintenanceWindow) policy_;
        }
        return com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance();
      } else {
        if (policyCase_ == 2) {
          return dailyMaintenanceWindowBuilder_.getMessage();
        }
        return com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    public Builder setDailyMaintenanceWindow(com.google.container.v1.DailyMaintenanceWindow value) {
      if (dailyMaintenanceWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policy_ = value;
        onChanged();
      } else {
        dailyMaintenanceWindowBuilder_.setMessage(value);
      }
      policyCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    public Builder setDailyMaintenanceWindow(
        com.google.container.v1.DailyMaintenanceWindow.Builder builderForValue) {
      if (dailyMaintenanceWindowBuilder_ == null) {
        policy_ = builderForValue.build();
        onChanged();
      } else {
        dailyMaintenanceWindowBuilder_.setMessage(builderForValue.build());
      }
      policyCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    public Builder mergeDailyMaintenanceWindow(
        com.google.container.v1.DailyMaintenanceWindow value) {
      if (dailyMaintenanceWindowBuilder_ == null) {
        if (policyCase_ == 2
            && policy_ != com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance()) {
          policy_ =
              com.google.container.v1.DailyMaintenanceWindow.newBuilder(
                      (com.google.container.v1.DailyMaintenanceWindow) policy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          policy_ = value;
        }
        onChanged();
      } else {
        if (policyCase_ == 2) {
          dailyMaintenanceWindowBuilder_.mergeFrom(value);
        } else {
          dailyMaintenanceWindowBuilder_.setMessage(value);
        }
      }
      policyCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    public Builder clearDailyMaintenanceWindow() {
      if (dailyMaintenanceWindowBuilder_ == null) {
        if (policyCase_ == 2) {
          policyCase_ = 0;
          policy_ = null;
          onChanged();
        }
      } else {
        if (policyCase_ == 2) {
          policyCase_ = 0;
          policy_ = null;
        }
        dailyMaintenanceWindowBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    public com.google.container.v1.DailyMaintenanceWindow.Builder
        getDailyMaintenanceWindowBuilder() {
      return getDailyMaintenanceWindowFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    @java.lang.Override
    public com.google.container.v1.DailyMaintenanceWindowOrBuilder
        getDailyMaintenanceWindowOrBuilder() {
      if ((policyCase_ == 2) && (dailyMaintenanceWindowBuilder_ != null)) {
        return dailyMaintenanceWindowBuilder_.getMessageOrBuilder();
      } else {
        if (policyCase_ == 2) {
          return (com.google.container.v1.DailyMaintenanceWindow) policy_;
        }
        return com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * DailyMaintenanceWindow specifies a daily maintenance operation window.
     * </pre>
     *
     * <code>.google.container.v1.DailyMaintenanceWindow daily_maintenance_window = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.DailyMaintenanceWindow,
            com.google.container.v1.DailyMaintenanceWindow.Builder,
            com.google.container.v1.DailyMaintenanceWindowOrBuilder>
        getDailyMaintenanceWindowFieldBuilder() {
      if (dailyMaintenanceWindowBuilder_ == null) {
        if (!(policyCase_ == 2)) {
          policy_ = com.google.container.v1.DailyMaintenanceWindow.getDefaultInstance();
        }
        dailyMaintenanceWindowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.DailyMaintenanceWindow,
                com.google.container.v1.DailyMaintenanceWindow.Builder,
                com.google.container.v1.DailyMaintenanceWindowOrBuilder>(
                (com.google.container.v1.DailyMaintenanceWindow) policy_,
                getParentForChildren(),
                isClean());
        policy_ = null;
      }
      policyCase_ = 2;
      onChanged();
      return dailyMaintenanceWindowBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.RecurringTimeWindow,
            com.google.container.v1.RecurringTimeWindow.Builder,
            com.google.container.v1.RecurringTimeWindowOrBuilder>
        recurringWindowBuilder_;
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     *
     * @return Whether the recurringWindow field is set.
     */
    @java.lang.Override
    public boolean hasRecurringWindow() {
      return policyCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     *
     * @return The recurringWindow.
     */
    @java.lang.Override
    public com.google.container.v1.RecurringTimeWindow getRecurringWindow() {
      if (recurringWindowBuilder_ == null) {
        if (policyCase_ == 3) {
          return (com.google.container.v1.RecurringTimeWindow) policy_;
        }
        return com.google.container.v1.RecurringTimeWindow.getDefaultInstance();
      } else {
        if (policyCase_ == 3) {
          return recurringWindowBuilder_.getMessage();
        }
        return com.google.container.v1.RecurringTimeWindow.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    public Builder setRecurringWindow(com.google.container.v1.RecurringTimeWindow value) {
      if (recurringWindowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policy_ = value;
        onChanged();
      } else {
        recurringWindowBuilder_.setMessage(value);
      }
      policyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    public Builder setRecurringWindow(
        com.google.container.v1.RecurringTimeWindow.Builder builderForValue) {
      if (recurringWindowBuilder_ == null) {
        policy_ = builderForValue.build();
        onChanged();
      } else {
        recurringWindowBuilder_.setMessage(builderForValue.build());
      }
      policyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    public Builder mergeRecurringWindow(com.google.container.v1.RecurringTimeWindow value) {
      if (recurringWindowBuilder_ == null) {
        if (policyCase_ == 3
            && policy_ != com.google.container.v1.RecurringTimeWindow.getDefaultInstance()) {
          policy_ =
              com.google.container.v1.RecurringTimeWindow.newBuilder(
                      (com.google.container.v1.RecurringTimeWindow) policy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          policy_ = value;
        }
        onChanged();
      } else {
        if (policyCase_ == 3) {
          recurringWindowBuilder_.mergeFrom(value);
        } else {
          recurringWindowBuilder_.setMessage(value);
        }
      }
      policyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    public Builder clearRecurringWindow() {
      if (recurringWindowBuilder_ == null) {
        if (policyCase_ == 3) {
          policyCase_ = 0;
          policy_ = null;
          onChanged();
        }
      } else {
        if (policyCase_ == 3) {
          policyCase_ = 0;
          policy_ = null;
        }
        recurringWindowBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    public com.google.container.v1.RecurringTimeWindow.Builder getRecurringWindowBuilder() {
      return getRecurringWindowFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    @java.lang.Override
    public com.google.container.v1.RecurringTimeWindowOrBuilder getRecurringWindowOrBuilder() {
      if ((policyCase_ == 3) && (recurringWindowBuilder_ != null)) {
        return recurringWindowBuilder_.getMessageOrBuilder();
      } else {
        if (policyCase_ == 3) {
          return (com.google.container.v1.RecurringTimeWindow) policy_;
        }
        return com.google.container.v1.RecurringTimeWindow.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * RecurringWindow specifies some number of recurring time periods for
     * maintenance to occur. The time windows may be overlapping. If no
     * maintenance windows are set, maintenance can occur at any time.
     * </pre>
     *
     * <code>.google.container.v1.RecurringTimeWindow recurring_window = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.RecurringTimeWindow,
            com.google.container.v1.RecurringTimeWindow.Builder,
            com.google.container.v1.RecurringTimeWindowOrBuilder>
        getRecurringWindowFieldBuilder() {
      if (recurringWindowBuilder_ == null) {
        if (!(policyCase_ == 3)) {
          policy_ = com.google.container.v1.RecurringTimeWindow.getDefaultInstance();
        }
        recurringWindowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.RecurringTimeWindow,
                com.google.container.v1.RecurringTimeWindow.Builder,
                com.google.container.v1.RecurringTimeWindowOrBuilder>(
                (com.google.container.v1.RecurringTimeWindow) policy_,
                getParentForChildren(),
                isClean());
        policy_ = null;
      }
      policyCase_ = 3;
      onChanged();
      return recurringWindowBuilder_;
    }

    private static final class MaintenanceExclusionsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.container.v1.TimeWindowOrBuilder,
            com.google.container.v1.TimeWindow> {
      @java.lang.Override
      public com.google.container.v1.TimeWindow build(
          com.google.container.v1.TimeWindowOrBuilder val) {
        if (val instanceof com.google.container.v1.TimeWindow) {
          return (com.google.container.v1.TimeWindow) val;
        }
        return ((com.google.container.v1.TimeWindow.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.container.v1.TimeWindow>
          defaultEntry() {
        return MaintenanceExclusionsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final MaintenanceExclusionsConverter maintenanceExclusionsConverter =
        new MaintenanceExclusionsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.container.v1.TimeWindowOrBuilder,
            com.google.container.v1.TimeWindow,
            com.google.container.v1.TimeWindow.Builder>
        maintenanceExclusions_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.container.v1.TimeWindowOrBuilder,
            com.google.container.v1.TimeWindow,
            com.google.container.v1.TimeWindow.Builder>
        internalGetMaintenanceExclusions() {
      if (maintenanceExclusions_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(maintenanceExclusionsConverter);
      }
      return maintenanceExclusions_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.container.v1.TimeWindowOrBuilder,
            com.google.container.v1.TimeWindow,
            com.google.container.v1.TimeWindow.Builder>
        internalGetMutableMaintenanceExclusions() {
      if (maintenanceExclusions_ == null) {
        maintenanceExclusions_ =
            new com.google.protobuf.MapFieldBuilder<>(maintenanceExclusionsConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return maintenanceExclusions_;
    }

    public int getMaintenanceExclusionsCount() {
      return internalGetMaintenanceExclusions().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    @java.lang.Override
    public boolean containsMaintenanceExclusions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMaintenanceExclusions().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getMaintenanceExclusionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.container.v1.TimeWindow>
        getMaintenanceExclusions() {
      return getMaintenanceExclusionsMap();
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.container.v1.TimeWindow>
        getMaintenanceExclusionsMap() {
      return internalGetMaintenanceExclusions().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.container.v1.TimeWindow getMaintenanceExclusionsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.container.v1.TimeWindow defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.container.v1.TimeWindowOrBuilder> map =
          internalGetMutableMaintenanceExclusions().ensureBuilderMap();
      return map.containsKey(key)
          ? maintenanceExclusionsConverter.build(map.get(key))
          : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    @java.lang.Override
    public com.google.container.v1.TimeWindow getMaintenanceExclusionsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.container.v1.TimeWindowOrBuilder> map =
          internalGetMutableMaintenanceExclusions().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return maintenanceExclusionsConverter.build(map.get(key));
    }

    public Builder clearMaintenanceExclusions() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableMaintenanceExclusions().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    public Builder removeMaintenanceExclusions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMaintenanceExclusions().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.container.v1.TimeWindow>
        getMutableMaintenanceExclusions() {
      bitField0_ |= 0x00000004;
      return internalGetMutableMaintenanceExclusions().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    public Builder putMaintenanceExclusions(
        java.lang.String key, com.google.container.v1.TimeWindow value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMaintenanceExclusions().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    public Builder putAllMaintenanceExclusions(
        java.util.Map<java.lang.String, com.google.container.v1.TimeWindow> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.container.v1.TimeWindow> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableMaintenanceExclusions().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exceptions to maintenance window. Non-emergency maintenance should not
     * occur in these windows.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1.TimeWindow&gt; maintenance_exclusions = 4;</code>
     */
    public com.google.container.v1.TimeWindow.Builder putMaintenanceExclusionsBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.container.v1.TimeWindowOrBuilder> builderMap =
          internalGetMutableMaintenanceExclusions().ensureBuilderMap();
      com.google.container.v1.TimeWindowOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.container.v1.TimeWindow.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.container.v1.TimeWindow) {
        entry = ((com.google.container.v1.TimeWindow) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.container.v1.TimeWindow.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.MaintenanceWindow)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.MaintenanceWindow)
  private static final com.google.container.v1.MaintenanceWindow DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.MaintenanceWindow();
  }

  public static com.google.container.v1.MaintenanceWindow getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MaintenanceWindow> PARSER =
      new com.google.protobuf.AbstractParser<MaintenanceWindow>() {
        @java.lang.Override
        public MaintenanceWindow parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MaintenanceWindow> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MaintenanceWindow> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.MaintenanceWindow getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
