/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * Configuration options for the master authorized networks feature. Enabled
 * master authorized networks will disallow all external traffic to access
 * Kubernetes master through HTTPS except traffic from the given CIDR blocks,
 * Google Compute Engine Public IPs and Google Prod IPs.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.MasterAuthorizedNetworksConfig}
 */
public final class MasterAuthorizedNetworksConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.MasterAuthorizedNetworksConfig)
    MasterAuthorizedNetworksConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MasterAuthorizedNetworksConfig.newBuilder() to construct.
  private MasterAuthorizedNetworksConfig(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MasterAuthorizedNetworksConfig() {
    cidrBlocks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MasterAuthorizedNetworksConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.MasterAuthorizedNetworksConfig.class,
            com.google.container.v1.MasterAuthorizedNetworksConfig.Builder.class);
  }

  public interface CidrBlockOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * display_name is an optional field for users to identify CIDR blocks.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * display_name is an optional field for users to identify CIDR blocks.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * cidr_block must be specified in CIDR notation.
     * </pre>
     *
     * <code>string cidr_block = 2;</code>
     *
     * @return The cidrBlock.
     */
    java.lang.String getCidrBlock();
    /**
     *
     *
     * <pre>
     * cidr_block must be specified in CIDR notation.
     * </pre>
     *
     * <code>string cidr_block = 2;</code>
     *
     * @return The bytes for cidrBlock.
     */
    com.google.protobuf.ByteString getCidrBlockBytes();
  }
  /**
   *
   *
   * <pre>
   * CidrBlock contains an optional name and one CIDR block.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock}
   */
  public static final class CidrBlock extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock)
      CidrBlockOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CidrBlock.newBuilder() to construct.
    private CidrBlock(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CidrBlock() {
      displayName_ = "";
      cidrBlock_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CidrBlock();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_CidrBlock_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_CidrBlock_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.class,
              com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder.class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * display_name is an optional field for users to identify CIDR blocks.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * display_name is an optional field for users to identify CIDR blocks.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CIDR_BLOCK_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * cidr_block must be specified in CIDR notation.
     * </pre>
     *
     * <code>string cidr_block = 2;</code>
     *
     * @return The cidrBlock.
     */
    @java.lang.Override
    public java.lang.String getCidrBlock() {
      java.lang.Object ref = cidrBlock_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cidrBlock_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * cidr_block must be specified in CIDR notation.
     * </pre>
     *
     * <code>string cidr_block = 2;</code>
     *
     * @return The bytes for cidrBlock.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCidrBlockBytes() {
      java.lang.Object ref = cidrBlock_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cidrBlock_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cidrBlock_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cidrBlock_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cidrBlock_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock)) {
        return super.equals(obj);
      }
      com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock other =
          (com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getCidrBlock().equals(other.getCidrBlock())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + CIDR_BLOCK_FIELD_NUMBER;
      hash = (53 * hash) + getCidrBlock().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * CidrBlock contains an optional name and one CIDR block.
     * </pre>
     *
     * Protobuf type {@code google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock)
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_CidrBlock_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_CidrBlock_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.class,
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder.class);
      }

      // Construct using
      // com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        cidrBlock_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1.ClusterServiceProto
            .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_CidrBlock_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
          getDefaultInstanceForType() {
        return com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock build() {
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock buildPartial() {
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock result =
            new com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.cidrBlock_ = cidrBlock_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock) {
          return mergeFrom(
              (com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock other) {
        if (other
            == com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
                .getDefaultInstance()) return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCidrBlock().isEmpty()) {
          cidrBlock_ = other.cidrBlock_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  cidrBlock_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * display_name is an optional field for users to identify CIDR blocks.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * display_name is an optional field for users to identify CIDR blocks.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * display_name is an optional field for users to identify CIDR blocks.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * display_name is an optional field for users to identify CIDR blocks.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * display_name is an optional field for users to identify CIDR blocks.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object cidrBlock_ = "";
      /**
       *
       *
       * <pre>
       * cidr_block must be specified in CIDR notation.
       * </pre>
       *
       * <code>string cidr_block = 2;</code>
       *
       * @return The cidrBlock.
       */
      public java.lang.String getCidrBlock() {
        java.lang.Object ref = cidrBlock_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cidrBlock_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * cidr_block must be specified in CIDR notation.
       * </pre>
       *
       * <code>string cidr_block = 2;</code>
       *
       * @return The bytes for cidrBlock.
       */
      public com.google.protobuf.ByteString getCidrBlockBytes() {
        java.lang.Object ref = cidrBlock_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cidrBlock_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * cidr_block must be specified in CIDR notation.
       * </pre>
       *
       * <code>string cidr_block = 2;</code>
       *
       * @param value The cidrBlock to set.
       * @return This builder for chaining.
       */
      public Builder setCidrBlock(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cidrBlock_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * cidr_block must be specified in CIDR notation.
       * </pre>
       *
       * <code>string cidr_block = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCidrBlock() {
        cidrBlock_ = getDefaultInstance().getCidrBlock();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * cidr_block must be specified in CIDR notation.
       * </pre>
       *
       * <code>string cidr_block = 2;</code>
       *
       * @param value The bytes for cidrBlock to set.
       * @return This builder for chaining.
       */
      public Builder setCidrBlockBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cidrBlock_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock)
    private static final com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock();
    }

    public static com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CidrBlock> PARSER =
        new com.google.protobuf.AbstractParser<CidrBlock>() {
          @java.lang.Override
          public CidrBlock parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CidrBlock> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CidrBlock> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int ENABLED_FIELD_NUMBER = 1;
  private boolean enabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether or not master authorized networks is enabled.
   * </pre>
   *
   * <code>bool enabled = 1;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public boolean getEnabled() {
    return enabled_;
  }

  public static final int CIDR_BLOCKS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock>
      cidrBlocks_;
  /**
   *
   *
   * <pre>
   * cidr_blocks define up to 50 external networks that could access
   * Kubernetes master through HTTPS.
   * </pre>
   *
   * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock>
      getCidrBlocksList() {
    return cidrBlocks_;
  }
  /**
   *
   *
   * <pre>
   * cidr_blocks define up to 50 external networks that could access
   * Kubernetes master through HTTPS.
   * </pre>
   *
   * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder>
      getCidrBlocksOrBuilderList() {
    return cidrBlocks_;
  }
  /**
   *
   *
   * <pre>
   * cidr_blocks define up to 50 external networks that could access
   * Kubernetes master through HTTPS.
   * </pre>
   *
   * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
   * </code>
   */
  @java.lang.Override
  public int getCidrBlocksCount() {
    return cidrBlocks_.size();
  }
  /**
   *
   *
   * <pre>
   * cidr_blocks define up to 50 external networks that could access
   * Kubernetes master through HTTPS.
   * </pre>
   *
   * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock getCidrBlocks(int index) {
    return cidrBlocks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * cidr_blocks define up to 50 external networks that could access
   * Kubernetes master through HTTPS.
   * </pre>
   *
   * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder
      getCidrBlocksOrBuilder(int index) {
    return cidrBlocks_.get(index);
  }

  public static final int GCP_PUBLIC_CIDRS_ACCESS_ENABLED_FIELD_NUMBER = 3;
  private boolean gcpPublicCidrsAccessEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether master is accessbile via Google Compute Engine Public IP addresses.
   * </pre>
   *
   * <code>optional bool gcp_public_cidrs_access_enabled = 3;</code>
   *
   * @return Whether the gcpPublicCidrsAccessEnabled field is set.
   */
  @java.lang.Override
  public boolean hasGcpPublicCidrsAccessEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether master is accessbile via Google Compute Engine Public IP addresses.
   * </pre>
   *
   * <code>optional bool gcp_public_cidrs_access_enabled = 3;</code>
   *
   * @return The gcpPublicCidrsAccessEnabled.
   */
  @java.lang.Override
  public boolean getGcpPublicCidrsAccessEnabled() {
    return gcpPublicCidrsAccessEnabled_;
  }

  public static final int PRIVATE_ENDPOINT_ENFORCEMENT_ENABLED_FIELD_NUMBER = 5;
  private boolean privateEndpointEnforcementEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether master authorized networks is enforced on private endpoint or not.
   * </pre>
   *
   * <code>optional bool private_endpoint_enforcement_enabled = 5;</code>
   *
   * @return Whether the privateEndpointEnforcementEnabled field is set.
   */
  @java.lang.Override
  public boolean hasPrivateEndpointEnforcementEnabled() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether master authorized networks is enforced on private endpoint or not.
   * </pre>
   *
   * <code>optional bool private_endpoint_enforcement_enabled = 5;</code>
   *
   * @return The privateEndpointEnforcementEnabled.
   */
  @java.lang.Override
  public boolean getPrivateEndpointEnforcementEnabled() {
    return privateEndpointEnforcementEnabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enabled_ != false) {
      output.writeBool(1, enabled_);
    }
    for (int i = 0; i < cidrBlocks_.size(); i++) {
      output.writeMessage(2, cidrBlocks_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(3, gcpPublicCidrsAccessEnabled_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(5, privateEndpointEnforcementEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
    }
    for (int i = 0; i < cidrBlocks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, cidrBlocks_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(3, gcpPublicCidrsAccessEnabled_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              5, privateEndpointEnforcementEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.MasterAuthorizedNetworksConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.MasterAuthorizedNetworksConfig other =
        (com.google.container.v1.MasterAuthorizedNetworksConfig) obj;

    if (getEnabled() != other.getEnabled()) return false;
    if (!getCidrBlocksList().equals(other.getCidrBlocksList())) return false;
    if (hasGcpPublicCidrsAccessEnabled() != other.hasGcpPublicCidrsAccessEnabled()) return false;
    if (hasGcpPublicCidrsAccessEnabled()) {
      if (getGcpPublicCidrsAccessEnabled() != other.getGcpPublicCidrsAccessEnabled()) return false;
    }
    if (hasPrivateEndpointEnforcementEnabled() != other.hasPrivateEndpointEnforcementEnabled())
      return false;
    if (hasPrivateEndpointEnforcementEnabled()) {
      if (getPrivateEndpointEnforcementEnabled() != other.getPrivateEndpointEnforcementEnabled())
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
    if (getCidrBlocksCount() > 0) {
      hash = (37 * hash) + CIDR_BLOCKS_FIELD_NUMBER;
      hash = (53 * hash) + getCidrBlocksList().hashCode();
    }
    if (hasGcpPublicCidrsAccessEnabled()) {
      hash = (37 * hash) + GCP_PUBLIC_CIDRS_ACCESS_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGcpPublicCidrsAccessEnabled());
    }
    if (hasPrivateEndpointEnforcementEnabled()) {
      hash = (37 * hash) + PRIVATE_ENDPOINT_ENFORCEMENT_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getPrivateEndpointEnforcementEnabled());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.container.v1.MasterAuthorizedNetworksConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for the master authorized networks feature. Enabled
   * master authorized networks will disallow all external traffic to access
   * Kubernetes master through HTTPS except traffic from the given CIDR blocks,
   * Google Compute Engine Public IPs and Google Prod IPs.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.MasterAuthorizedNetworksConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.MasterAuthorizedNetworksConfig)
      com.google.container.v1.MasterAuthorizedNetworksConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.MasterAuthorizedNetworksConfig.class,
              com.google.container.v1.MasterAuthorizedNetworksConfig.Builder.class);
    }

    // Construct using com.google.container.v1.MasterAuthorizedNetworksConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enabled_ = false;
      if (cidrBlocksBuilder_ == null) {
        cidrBlocks_ = java.util.Collections.emptyList();
      } else {
        cidrBlocks_ = null;
        cidrBlocksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      gcpPublicCidrsAccessEnabled_ = false;
      privateEndpointEnforcementEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_MasterAuthorizedNetworksConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuthorizedNetworksConfig getDefaultInstanceForType() {
      return com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuthorizedNetworksConfig build() {
      com.google.container.v1.MasterAuthorizedNetworksConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.MasterAuthorizedNetworksConfig buildPartial() {
      com.google.container.v1.MasterAuthorizedNetworksConfig result =
          new com.google.container.v1.MasterAuthorizedNetworksConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.container.v1.MasterAuthorizedNetworksConfig result) {
      if (cidrBlocksBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          cidrBlocks_ = java.util.Collections.unmodifiableList(cidrBlocks_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.cidrBlocks_ = cidrBlocks_;
      } else {
        result.cidrBlocks_ = cidrBlocksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.MasterAuthorizedNetworksConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enabled_ = enabled_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.gcpPublicCidrsAccessEnabled_ = gcpPublicCidrsAccessEnabled_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.privateEndpointEnforcementEnabled_ = privateEndpointEnforcementEnabled_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.MasterAuthorizedNetworksConfig) {
        return mergeFrom((com.google.container.v1.MasterAuthorizedNetworksConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.MasterAuthorizedNetworksConfig other) {
      if (other == com.google.container.v1.MasterAuthorizedNetworksConfig.getDefaultInstance())
        return this;
      if (other.getEnabled() != false) {
        setEnabled(other.getEnabled());
      }
      if (cidrBlocksBuilder_ == null) {
        if (!other.cidrBlocks_.isEmpty()) {
          if (cidrBlocks_.isEmpty()) {
            cidrBlocks_ = other.cidrBlocks_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureCidrBlocksIsMutable();
            cidrBlocks_.addAll(other.cidrBlocks_);
          }
          onChanged();
        }
      } else {
        if (!other.cidrBlocks_.isEmpty()) {
          if (cidrBlocksBuilder_.isEmpty()) {
            cidrBlocksBuilder_.dispose();
            cidrBlocksBuilder_ = null;
            cidrBlocks_ = other.cidrBlocks_;
            bitField0_ = (bitField0_ & ~0x00000002);
            cidrBlocksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCidrBlocksFieldBuilder()
                    : null;
          } else {
            cidrBlocksBuilder_.addAllMessages(other.cidrBlocks_);
          }
        }
      }
      if (other.hasGcpPublicCidrsAccessEnabled()) {
        setGcpPublicCidrsAccessEnabled(other.getGcpPublicCidrsAccessEnabled());
      }
      if (other.hasPrivateEndpointEnforcementEnabled()) {
        setPrivateEndpointEnforcementEnabled(other.getPrivateEndpointEnforcementEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock m =
                    input.readMessage(
                        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.parser(),
                        extensionRegistry);
                if (cidrBlocksBuilder_ == null) {
                  ensureCidrBlocksIsMutable();
                  cidrBlocks_.add(m);
                } else {
                  cidrBlocksBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                gcpPublicCidrsAccessEnabled_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 40:
              {
                privateEndpointEnforcementEnabled_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * Whether or not master authorized networks is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether or not master authorized networks is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @param value The enabled to set.
     * @return This builder for chaining.
     */
    public Builder setEnabled(boolean value) {

      enabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether or not master authorized networks is enabled.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock>
        cidrBlocks_ = java.util.Collections.emptyList();

    private void ensureCidrBlocksIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        cidrBlocks_ =
            new java.util.ArrayList<
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock>(cidrBlocks_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock,
            com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder,
            com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder>
        cidrBlocksBuilder_;

    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public java.util.List<com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock>
        getCidrBlocksList() {
      if (cidrBlocksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cidrBlocks_);
      } else {
        return cidrBlocksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public int getCidrBlocksCount() {
      if (cidrBlocksBuilder_ == null) {
        return cidrBlocks_.size();
      } else {
        return cidrBlocksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock getCidrBlocks(
        int index) {
      if (cidrBlocksBuilder_ == null) {
        return cidrBlocks_.get(index);
      } else {
        return cidrBlocksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder setCidrBlocks(
        int index, com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock value) {
      if (cidrBlocksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCidrBlocksIsMutable();
        cidrBlocks_.set(index, value);
        onChanged();
      } else {
        cidrBlocksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder setCidrBlocks(
        int index,
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder builderForValue) {
      if (cidrBlocksBuilder_ == null) {
        ensureCidrBlocksIsMutable();
        cidrBlocks_.set(index, builderForValue.build());
        onChanged();
      } else {
        cidrBlocksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder addCidrBlocks(
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock value) {
      if (cidrBlocksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCidrBlocksIsMutable();
        cidrBlocks_.add(value);
        onChanged();
      } else {
        cidrBlocksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder addCidrBlocks(
        int index, com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock value) {
      if (cidrBlocksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCidrBlocksIsMutable();
        cidrBlocks_.add(index, value);
        onChanged();
      } else {
        cidrBlocksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder addCidrBlocks(
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder builderForValue) {
      if (cidrBlocksBuilder_ == null) {
        ensureCidrBlocksIsMutable();
        cidrBlocks_.add(builderForValue.build());
        onChanged();
      } else {
        cidrBlocksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder addCidrBlocks(
        int index,
        com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder builderForValue) {
      if (cidrBlocksBuilder_ == null) {
        ensureCidrBlocksIsMutable();
        cidrBlocks_.add(index, builderForValue.build());
        onChanged();
      } else {
        cidrBlocksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder addAllCidrBlocks(
        java.lang.Iterable<
                ? extends com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock>
            values) {
      if (cidrBlocksBuilder_ == null) {
        ensureCidrBlocksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cidrBlocks_);
        onChanged();
      } else {
        cidrBlocksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder clearCidrBlocks() {
      if (cidrBlocksBuilder_ == null) {
        cidrBlocks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        cidrBlocksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public Builder removeCidrBlocks(int index) {
      if (cidrBlocksBuilder_ == null) {
        ensureCidrBlocksIsMutable();
        cidrBlocks_.remove(index);
        onChanged();
      } else {
        cidrBlocksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder
        getCidrBlocksBuilder(int index) {
      return getCidrBlocksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder
        getCidrBlocksOrBuilder(int index) {
      if (cidrBlocksBuilder_ == null) {
        return cidrBlocks_.get(index);
      } else {
        return cidrBlocksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder>
        getCidrBlocksOrBuilderList() {
      if (cidrBlocksBuilder_ != null) {
        return cidrBlocksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cidrBlocks_);
      }
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder
        addCidrBlocksBuilder() {
      return getCidrBlocksFieldBuilder()
          .addBuilder(
              com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder
        addCidrBlocksBuilder(int index) {
      return getCidrBlocksFieldBuilder()
          .addBuilder(
              index,
              com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * cidr_blocks define up to 50 external networks that could access
     * Kubernetes master through HTTPS.
     * </pre>
     *
     * <code>repeated .google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock cidr_blocks = 2;
     * </code>
     */
    public java.util.List<com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder>
        getCidrBlocksBuilderList() {
      return getCidrBlocksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock,
            com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder,
            com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder>
        getCidrBlocksFieldBuilder() {
      if (cidrBlocksBuilder_ == null) {
        cidrBlocksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock,
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlock.Builder,
                com.google.container.v1.MasterAuthorizedNetworksConfig.CidrBlockOrBuilder>(
                cidrBlocks_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        cidrBlocks_ = null;
      }
      return cidrBlocksBuilder_;
    }

    private boolean gcpPublicCidrsAccessEnabled_;
    /**
     *
     *
     * <pre>
     * Whether master is accessbile via Google Compute Engine Public IP addresses.
     * </pre>
     *
     * <code>optional bool gcp_public_cidrs_access_enabled = 3;</code>
     *
     * @return Whether the gcpPublicCidrsAccessEnabled field is set.
     */
    @java.lang.Override
    public boolean hasGcpPublicCidrsAccessEnabled() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether master is accessbile via Google Compute Engine Public IP addresses.
     * </pre>
     *
     * <code>optional bool gcp_public_cidrs_access_enabled = 3;</code>
     *
     * @return The gcpPublicCidrsAccessEnabled.
     */
    @java.lang.Override
    public boolean getGcpPublicCidrsAccessEnabled() {
      return gcpPublicCidrsAccessEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether master is accessbile via Google Compute Engine Public IP addresses.
     * </pre>
     *
     * <code>optional bool gcp_public_cidrs_access_enabled = 3;</code>
     *
     * @param value The gcpPublicCidrsAccessEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setGcpPublicCidrsAccessEnabled(boolean value) {

      gcpPublicCidrsAccessEnabled_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether master is accessbile via Google Compute Engine Public IP addresses.
     * </pre>
     *
     * <code>optional bool gcp_public_cidrs_access_enabled = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcpPublicCidrsAccessEnabled() {
      bitField0_ = (bitField0_ & ~0x00000004);
      gcpPublicCidrsAccessEnabled_ = false;
      onChanged();
      return this;
    }

    private boolean privateEndpointEnforcementEnabled_;
    /**
     *
     *
     * <pre>
     * Whether master authorized networks is enforced on private endpoint or not.
     * </pre>
     *
     * <code>optional bool private_endpoint_enforcement_enabled = 5;</code>
     *
     * @return Whether the privateEndpointEnforcementEnabled field is set.
     */
    @java.lang.Override
    public boolean hasPrivateEndpointEnforcementEnabled() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether master authorized networks is enforced on private endpoint or not.
     * </pre>
     *
     * <code>optional bool private_endpoint_enforcement_enabled = 5;</code>
     *
     * @return The privateEndpointEnforcementEnabled.
     */
    @java.lang.Override
    public boolean getPrivateEndpointEnforcementEnabled() {
      return privateEndpointEnforcementEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether master authorized networks is enforced on private endpoint or not.
     * </pre>
     *
     * <code>optional bool private_endpoint_enforcement_enabled = 5;</code>
     *
     * @param value The privateEndpointEnforcementEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateEndpointEnforcementEnabled(boolean value) {

      privateEndpointEnforcementEnabled_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether master authorized networks is enforced on private endpoint or not.
     * </pre>
     *
     * <code>optional bool private_endpoint_enforcement_enabled = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateEndpointEnforcementEnabled() {
      bitField0_ = (bitField0_ & ~0x00000008);
      privateEndpointEnforcementEnabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.MasterAuthorizedNetworksConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.MasterAuthorizedNetworksConfig)
  private static final com.google.container.v1.MasterAuthorizedNetworksConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.MasterAuthorizedNetworksConfig();
  }

  public static com.google.container.v1.MasterAuthorizedNetworksConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MasterAuthorizedNetworksConfig> PARSER =
      new com.google.protobuf.AbstractParser<MasterAuthorizedNetworksConfig>() {
        @java.lang.Override
        public MasterAuthorizedNetworksConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MasterAuthorizedNetworksConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MasterAuthorizedNetworksConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.MasterAuthorizedNetworksConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
