/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

public interface PrivateClusterConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.container.v1.PrivateClusterConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Whether nodes have internal IP addresses only. If enabled, all nodes are
   * given only RFC 1918 private addresses and communicate with the master via
   * private networking.
   *
   * Deprecated: Use
   * [NetworkConfig.default_enable_private_nodes][google.container.v1.NetworkConfig.default_enable_private_nodes]
   * instead.
   * </pre>
   *
   * <code>bool enable_private_nodes = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.enable_private_nodes is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1432
   * @return The enablePrivateNodes.
   */
  @java.lang.Deprecated
  boolean getEnablePrivateNodes();

  /**
   *
   *
   * <pre>
   * Whether the master's internal IP address is used as the cluster endpoint.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_public_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_public_endpoint]
   * instead. Note that the value of enable_public_endpoint is reversed: if
   * enable_private_endpoint is false, then enable_public_endpoint will be true.
   * </pre>
   *
   * <code>bool enable_private_endpoint = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.enable_private_endpoint is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1440
   * @return The enablePrivateEndpoint.
   */
  @java.lang.Deprecated
  boolean getEnablePrivateEndpoint();

  /**
   *
   *
   * <pre>
   * The IP range in CIDR notation to use for the hosted master network. This
   * range will be used for assigning internal IP addresses to the master or
   * set of masters, as well as the ILB VIP. This range must not overlap with
   * any other ranges in use within the cluster's network.
   * </pre>
   *
   * <code>string master_ipv4_cidr_block = 3;</code>
   *
   * @return The masterIpv4CidrBlock.
   */
  java.lang.String getMasterIpv4CidrBlock();
  /**
   *
   *
   * <pre>
   * The IP range in CIDR notation to use for the hosted master network. This
   * range will be used for assigning internal IP addresses to the master or
   * set of masters, as well as the ILB VIP. This range must not overlap with
   * any other ranges in use within the cluster's network.
   * </pre>
   *
   * <code>string master_ipv4_cidr_block = 3;</code>
   *
   * @return The bytes for masterIpv4CidrBlock.
   */
  com.google.protobuf.ByteString getMasterIpv4CidrBlockBytes();

  /**
   *
   *
   * <pre>
   * Output only. The internal IP address of this cluster's master endpoint.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint]
   * instead.
   * </pre>
   *
   * <code>
   * string private_endpoint = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.private_endpoint is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1453
   * @return The privateEndpoint.
   */
  @java.lang.Deprecated
  java.lang.String getPrivateEndpoint();
  /**
   *
   *
   * <pre>
   * Output only. The internal IP address of this cluster's master endpoint.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint]
   * instead.
   * </pre>
   *
   * <code>
   * string private_endpoint = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.private_endpoint is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1453
   * @return The bytes for privateEndpoint.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getPrivateEndpointBytes();

  /**
   *
   *
   * <pre>
   * Output only. The external IP address of this cluster's master endpoint.
   *
   * Deprecated:Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint]
   * instead.
   * </pre>
   *
   * <code>
   * string public_endpoint = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.public_endpoint is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1461
   * @return The publicEndpoint.
   */
  @java.lang.Deprecated
  java.lang.String getPublicEndpoint();
  /**
   *
   *
   * <pre>
   * Output only. The external IP address of this cluster's master endpoint.
   *
   * Deprecated:Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint]
   * instead.
   * </pre>
   *
   * <code>
   * string public_endpoint = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.public_endpoint is deprecated. See
   *     google/container/v1/cluster_service.proto;l=1461
   * @return The bytes for publicEndpoint.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getPublicEndpointBytes();

  /**
   *
   *
   * <pre>
   * Output only. The peering name in the customer VPC used by this cluster.
   * </pre>
   *
   * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The peeringName.
   */
  java.lang.String getPeeringName();
  /**
   *
   *
   * <pre>
   * Output only. The peering name in the customer VPC used by this cluster.
   * </pre>
   *
   * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for peeringName.
   */
  com.google.protobuf.ByteString getPeeringNameBytes();

  /**
   *
   *
   * <pre>
   * Controls master global access settings.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_global_access][]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.master_global_access_config is deprecated.
   *     See google/container/v1/cluster_service.proto;l=1472
   * @return Whether the masterGlobalAccessConfig field is set.
   */
  @java.lang.Deprecated
  boolean hasMasterGlobalAccessConfig();
  /**
   *
   *
   * <pre>
   * Controls master global access settings.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_global_access][]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.master_global_access_config is deprecated.
   *     See google/container/v1/cluster_service.proto;l=1472
   * @return The masterGlobalAccessConfig.
   */
  @java.lang.Deprecated
  com.google.container.v1.PrivateClusterMasterGlobalAccessConfig getMasterGlobalAccessConfig();
  /**
   *
   *
   * <pre>
   * Controls master global access settings.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_global_access][]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.container.v1.PrivateClusterMasterGlobalAccessConfigOrBuilder
      getMasterGlobalAccessConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Subnet to provision the master's private endpoint during cluster creation.
   * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork]
   * instead.
   * </pre>
   *
   * <code>string private_endpoint_subnetwork = 10 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.private_endpoint_subnetwork is deprecated.
   *     See google/container/v1/cluster_service.proto;l=1481
   * @return The privateEndpointSubnetwork.
   */
  @java.lang.Deprecated
  java.lang.String getPrivateEndpointSubnetwork();
  /**
   *
   *
   * <pre>
   * Subnet to provision the master's private endpoint during cluster creation.
   * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
   *
   * Deprecated: Use
   * [ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork]
   * instead.
   * </pre>
   *
   * <code>string private_endpoint_subnetwork = 10 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.PrivateClusterConfig.private_endpoint_subnetwork is deprecated.
   *     See google/container/v1/cluster_service.proto;l=1481
   * @return The bytes for privateEndpointSubnetwork.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getPrivateEndpointSubnetworkBytes();
}
