/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * SetLoggingServiceRequest sets the logging service of a cluster.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.SetLoggingServiceRequest}
 */
public final class SetLoggingServiceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.SetLoggingServiceRequest)
    SetLoggingServiceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetLoggingServiceRequest.newBuilder() to construct.
  private SetLoggingServiceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetLoggingServiceRequest() {
    projectId_ = "";
    zone_ = "";
    clusterId_ = "";
    loggingService_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetLoggingServiceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SetLoggingServiceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SetLoggingServiceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.SetLoggingServiceRequest.class,
            com.google.container.v1.SetLoggingServiceRequest.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3246
   * @return The projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3246
   * @return The bytes for projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3252
   * @return The zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3252
   * @return The bytes for zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the cluster to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3256
   * @return The clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getClusterId() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the cluster to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3256
   * @return The bytes for clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getClusterIdBytes() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOGGING_SERVICE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object loggingService_ = "";
  /**
   *
   *
   * <pre>
   * Required. The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The loggingService.
   */
  @java.lang.Override
  public java.lang.String getLoggingService() {
    java.lang.Object ref = loggingService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      loggingService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for loggingService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLoggingServiceBytes() {
    java.lang.Object ref = loggingService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      loggingService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster) of the cluster to set logging.
   * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
   * </pre>
   *
   * <code>string name = 5;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster) of the cluster to set logging.
   * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
   * </pre>
   *
   * <code>string name = 5;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clusterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(loggingService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, loggingService_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clusterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(loggingService_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, loggingService_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.SetLoggingServiceRequest)) {
      return super.equals(obj);
    }
    com.google.container.v1.SetLoggingServiceRequest other =
        (com.google.container.v1.SetLoggingServiceRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (!getClusterId().equals(other.getClusterId())) return false;
    if (!getLoggingService().equals(other.getLoggingService())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterId().hashCode();
    hash = (37 * hash) + LOGGING_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getLoggingService().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SetLoggingServiceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.SetLoggingServiceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SetLoggingServiceRequest sets the logging service of a cluster.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.SetLoggingServiceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.SetLoggingServiceRequest)
      com.google.container.v1.SetLoggingServiceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SetLoggingServiceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SetLoggingServiceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.SetLoggingServiceRequest.class,
              com.google.container.v1.SetLoggingServiceRequest.Builder.class);
    }

    // Construct using com.google.container.v1.SetLoggingServiceRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      zone_ = "";
      clusterId_ = "";
      loggingService_ = "";
      name_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SetLoggingServiceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.SetLoggingServiceRequest getDefaultInstanceForType() {
      return com.google.container.v1.SetLoggingServiceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.SetLoggingServiceRequest build() {
      com.google.container.v1.SetLoggingServiceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.SetLoggingServiceRequest buildPartial() {
      com.google.container.v1.SetLoggingServiceRequest result =
          new com.google.container.v1.SetLoggingServiceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.SetLoggingServiceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clusterId_ = clusterId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.loggingService_ = loggingService_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.SetLoggingServiceRequest) {
        return mergeFrom((com.google.container.v1.SetLoggingServiceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.SetLoggingServiceRequest other) {
      if (other == com.google.container.v1.SetLoggingServiceRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClusterId().isEmpty()) {
        clusterId_ = other.clusterId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLoggingService().isEmpty()) {
        loggingService_ = other.loggingService_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                clusterId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                loggingService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3246
     * @return The projectId.
     */
    @java.lang.Deprecated
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3246
     * @return The bytes for projectId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3246
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3246
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3246
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3252
     * @return The zone.
     */
    @java.lang.Deprecated
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3252
     * @return The bytes for zone.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3252
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3252
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3252
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clusterId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3256
     * @return The clusterId.
     */
    @java.lang.Deprecated
    public java.lang.String getClusterId() {
      java.lang.Object ref = clusterId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3256
     * @return The bytes for clusterId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getClusterIdBytes() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3256
     * @param value The clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3256
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearClusterId() {
      clusterId_ = getDefaultInstance().getClusterId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetLoggingServiceRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3256
     * @param value The bytes for clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object loggingService_ = "";
    /**
     *
     *
     * <pre>
     * Required. The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The loggingService.
     */
    public java.lang.String getLoggingService() {
      java.lang.Object ref = loggingService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        loggingService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for loggingService.
     */
    public com.google.protobuf.ByteString getLoggingServiceBytes() {
      java.lang.Object ref = loggingService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        loggingService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The loggingService to set.
     * @return This builder for chaining.
     */
    public Builder setLoggingService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      loggingService_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoggingService() {
      loggingService_ = getDefaultInstance().getLoggingService();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string logging_service = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for loggingService to set.
     * @return This builder for chaining.
     */
    public Builder setLoggingServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      loggingService_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster) of the cluster to set logging.
     * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster) of the cluster to set logging.
     * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster) of the cluster to set logging.
     * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster) of the cluster to set logging.
     * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster) of the cluster to set logging.
     * Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 5;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.SetLoggingServiceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.SetLoggingServiceRequest)
  private static final com.google.container.v1.SetLoggingServiceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.SetLoggingServiceRequest();
  }

  public static com.google.container.v1.SetLoggingServiceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetLoggingServiceRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetLoggingServiceRequest>() {
        @java.lang.Override
        public SetLoggingServiceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetLoggingServiceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetLoggingServiceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.SetLoggingServiceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
