/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.SetNodePoolAutoscalingRequest}
 */
public final class SetNodePoolAutoscalingRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.SetNodePoolAutoscalingRequest)
    SetNodePoolAutoscalingRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetNodePoolAutoscalingRequest.newBuilder() to construct.
  private SetNodePoolAutoscalingRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetNodePoolAutoscalingRequest() {
    projectId_ = "";
    zone_ = "";
    clusterId_ = "";
    nodePoolId_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetNodePoolAutoscalingRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SetNodePoolAutoscalingRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_SetNodePoolAutoscalingRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.SetNodePoolAutoscalingRequest.class,
            com.google.container.v1.SetNodePoolAutoscalingRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3216
   * @return The projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3216
   * @return The bytes for projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3222
   * @return The zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3222
   * @return The bytes for zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the cluster to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3226
   * @return The clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getClusterId() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the cluster to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3226
   * @return The bytes for clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getClusterIdBytes() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_POOL_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nodePoolId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the node pool to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string node_pool_id = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3230
   * @return The nodePoolId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getNodePoolId() {
    java.lang.Object ref = nodePoolId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nodePoolId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The name of the node pool to upgrade.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string node_pool_id = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
   *     google/container/v1/cluster_service.proto;l=3230
   * @return The bytes for nodePoolId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getNodePoolIdBytes() {
    java.lang.Object ref = nodePoolId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nodePoolId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTOSCALING_FIELD_NUMBER = 5;
  private com.google.container.v1.NodePoolAutoscaling autoscaling_;
  /**
   *
   *
   * <pre>
   * Required. Autoscaling configuration for the node pool.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the autoscaling field is set.
   */
  @java.lang.Override
  public boolean hasAutoscaling() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Autoscaling configuration for the node pool.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The autoscaling.
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolAutoscaling getAutoscaling() {
    return autoscaling_ == null
        ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
        : autoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Required. Autoscaling configuration for the node pool.
   * </pre>
   *
   * <code>
   * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.NodePoolAutoscalingOrBuilder getAutoscalingOrBuilder() {
    return autoscaling_ == null
        ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
        : autoscaling_;
  }

  public static final int NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster, node pool) of the node pool to set
   * autoscaler settings. Specified in the format
   * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster, node pool) of the node pool to set
   * autoscaler settings. Specified in the format
   * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clusterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodePoolId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, nodePoolId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getAutoscaling());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clusterId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodePoolId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, nodePoolId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAutoscaling());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.SetNodePoolAutoscalingRequest)) {
      return super.equals(obj);
    }
    com.google.container.v1.SetNodePoolAutoscalingRequest other =
        (com.google.container.v1.SetNodePoolAutoscalingRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (!getClusterId().equals(other.getClusterId())) return false;
    if (!getNodePoolId().equals(other.getNodePoolId())) return false;
    if (hasAutoscaling() != other.hasAutoscaling()) return false;
    if (hasAutoscaling()) {
      if (!getAutoscaling().equals(other.getAutoscaling())) return false;
    }
    if (!getName().equals(other.getName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterId().hashCode();
    hash = (37 * hash) + NODE_POOL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getNodePoolId().hashCode();
    if (hasAutoscaling()) {
      hash = (37 * hash) + AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscaling().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.container.v1.SetNodePoolAutoscalingRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.SetNodePoolAutoscalingRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.SetNodePoolAutoscalingRequest)
      com.google.container.v1.SetNodePoolAutoscalingRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SetNodePoolAutoscalingRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SetNodePoolAutoscalingRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.SetNodePoolAutoscalingRequest.class,
              com.google.container.v1.SetNodePoolAutoscalingRequest.Builder.class);
    }

    // Construct using com.google.container.v1.SetNodePoolAutoscalingRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAutoscalingFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      zone_ = "";
      clusterId_ = "";
      nodePoolId_ = "";
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      name_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_SetNodePoolAutoscalingRequest_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.SetNodePoolAutoscalingRequest getDefaultInstanceForType() {
      return com.google.container.v1.SetNodePoolAutoscalingRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.SetNodePoolAutoscalingRequest build() {
      com.google.container.v1.SetNodePoolAutoscalingRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.SetNodePoolAutoscalingRequest buildPartial() {
      com.google.container.v1.SetNodePoolAutoscalingRequest result =
          new com.google.container.v1.SetNodePoolAutoscalingRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.SetNodePoolAutoscalingRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clusterId_ = clusterId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nodePoolId_ = nodePoolId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.autoscaling_ =
            autoscalingBuilder_ == null ? autoscaling_ : autoscalingBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.name_ = name_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.SetNodePoolAutoscalingRequest) {
        return mergeFrom((com.google.container.v1.SetNodePoolAutoscalingRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.SetNodePoolAutoscalingRequest other) {
      if (other == com.google.container.v1.SetNodePoolAutoscalingRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClusterId().isEmpty()) {
        clusterId_ = other.clusterId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getNodePoolId().isEmpty()) {
        nodePoolId_ = other.nodePoolId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasAutoscaling()) {
        mergeAutoscaling(other.getAutoscaling());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                clusterId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                nodePoolId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3216
     * @return The projectId.
     */
    @java.lang.Deprecated
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3216
     * @return The bytes for projectId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3216
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3216
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.project_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3216
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3222
     * @return The zone.
     */
    @java.lang.Deprecated
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3222
     * @return The bytes for zone.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3222
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3222
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.zone is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3222
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clusterId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3226
     * @return The clusterId.
     */
    @java.lang.Deprecated
    public java.lang.String getClusterId() {
      java.lang.Object ref = clusterId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3226
     * @return The bytes for clusterId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getClusterIdBytes() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3226
     * @param value The clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3226
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearClusterId() {
      clusterId_ = getDefaultInstance().getClusterId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the cluster to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.cluster_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3226
     * @param value The bytes for clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object nodePoolId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3230
     * @return The nodePoolId.
     */
    @java.lang.Deprecated
    public java.lang.String getNodePoolId() {
      java.lang.Object ref = nodePoolId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodePoolId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3230
     * @return The bytes for nodePoolId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getNodePoolIdBytes() {
      java.lang.Object ref = nodePoolId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodePoolId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3230
     * @param value The nodePoolId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNodePoolId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nodePoolId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3230
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearNodePoolId() {
      nodePoolId_ = getDefaultInstance().getNodePoolId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The name of the node pool to upgrade.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string node_pool_id = 4 [deprecated = true];</code>
     *
     * @deprecated google.container.v1.SetNodePoolAutoscalingRequest.node_pool_id is deprecated. See
     *     google/container/v1/cluster_service.proto;l=3230
     * @param value The bytes for nodePoolId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNodePoolIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nodePoolId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.container.v1.NodePoolAutoscaling autoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoscaling,
            com.google.container.v1.NodePoolAutoscaling.Builder,
            com.google.container.v1.NodePoolAutoscalingOrBuilder>
        autoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscaling field is set.
     */
    public boolean hasAutoscaling() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscaling.
     */
    public com.google.container.v1.NodePoolAutoscaling getAutoscaling() {
      if (autoscalingBuilder_ == null) {
        return autoscaling_ == null
            ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
            : autoscaling_;
      } else {
        return autoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAutoscaling(com.google.container.v1.NodePoolAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscaling_ = value;
      } else {
        autoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAutoscaling(
        com.google.container.v1.NodePoolAutoscaling.Builder builderForValue) {
      if (autoscalingBuilder_ == null) {
        autoscaling_ = builderForValue.build();
      } else {
        autoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAutoscaling(com.google.container.v1.NodePoolAutoscaling value) {
      if (autoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && autoscaling_ != null
            && autoscaling_ != com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()) {
          getAutoscalingBuilder().mergeFrom(value);
        } else {
          autoscaling_ = value;
        }
      } else {
        autoscalingBuilder_.mergeFrom(value);
      }
      if (autoscaling_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00000010);
      autoscaling_ = null;
      if (autoscalingBuilder_ != null) {
        autoscalingBuilder_.dispose();
        autoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.container.v1.NodePoolAutoscaling.Builder getAutoscalingBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.container.v1.NodePoolAutoscalingOrBuilder getAutoscalingOrBuilder() {
      if (autoscalingBuilder_ != null) {
        return autoscalingBuilder_.getMessageOrBuilder();
      } else {
        return autoscaling_ == null
            ? com.google.container.v1.NodePoolAutoscaling.getDefaultInstance()
            : autoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Autoscaling configuration for the node pool.
     * </pre>
     *
     * <code>
     * .google.container.v1.NodePoolAutoscaling autoscaling = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1.NodePoolAutoscaling,
            com.google.container.v1.NodePoolAutoscaling.Builder,
            com.google.container.v1.NodePoolAutoscalingOrBuilder>
        getAutoscalingFieldBuilder() {
      if (autoscalingBuilder_ == null) {
        autoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1.NodePoolAutoscaling,
                com.google.container.v1.NodePoolAutoscaling.Builder,
                com.google.container.v1.NodePoolAutoscalingOrBuilder>(
                getAutoscaling(), getParentForChildren(), isClean());
        autoscaling_ = null;
      }
      return autoscalingBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to set
     * autoscaler settings. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to set
     * autoscaler settings. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to set
     * autoscaler settings. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to set
     * autoscaler settings. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster, node pool) of the node pool to set
     * autoscaler settings. Specified in the format
     * `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;&#47;nodePools/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.SetNodePoolAutoscalingRequest)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.SetNodePoolAutoscalingRequest)
  private static final com.google.container.v1.SetNodePoolAutoscalingRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.SetNodePoolAutoscalingRequest();
  }

  public static com.google.container.v1.SetNodePoolAutoscalingRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetNodePoolAutoscalingRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetNodePoolAutoscalingRequest>() {
        @java.lang.Override
        public SetNodePoolAutoscalingRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetNodePoolAutoscalingRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetNodePoolAutoscalingRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.SetNodePoolAutoscalingRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
