/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * UpgradeInfoEvent is a notification sent to customers about the upgrade
 * information of a resource.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.UpgradeInfoEvent}
 */
public final class UpgradeInfoEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.UpgradeInfoEvent)
    UpgradeInfoEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpgradeInfoEvent.newBuilder() to construct.
  private UpgradeInfoEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpgradeInfoEvent() {
    resourceType_ = 0;
    operation_ = "";
    currentVersion_ = "";
    targetVersion_ = "";
    resource_ = "";
    state_ = 0;
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpgradeInfoEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UpgradeInfoEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UpgradeInfoEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.UpgradeInfoEvent.class,
            com.google.container.v1.UpgradeInfoEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the upgrade.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1.UpgradeInfoEvent.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * STATE_UNSPECIFIED indicates the state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * STARTED indicates the upgrade has started.
     * </pre>
     *
     * <code>STARTED = 3;</code>
     */
    STARTED(3),
    /**
     *
     *
     * <pre>
     * SUCCEEDED indicates the upgrade has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    /**
     *
     *
     * <pre>
     * FAILED indicates the upgrade has failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * CANCELED indicates the upgrade has canceled.
     * </pre>
     *
     * <code>CANCELED = 6;</code>
     */
    CANCELED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * STATE_UNSPECIFIED indicates the state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * STARTED indicates the upgrade has started.
     * </pre>
     *
     * <code>STARTED = 3;</code>
     */
    public static final int STARTED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * SUCCEEDED indicates the upgrade has completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * FAILED indicates the upgrade has failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * CANCELED indicates the upgrade has canceled.
     * </pre>
     *
     * <code>CANCELED = 6;</code>
     */
    public static final int CANCELED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 3:
          return STARTED;
        case 4:
          return SUCCEEDED;
        case 5:
          return FAILED;
        case 6:
          return CANCELED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1.UpgradeInfoEvent.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1.UpgradeInfoEvent.State)
  }

  private int bitField0_;
  public static final int RESOURCE_TYPE_FIELD_NUMBER = 1;
  private int resourceType_ = 0;
  /**
   *
   *
   * <pre>
   * The resource type associated with the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  @java.lang.Override
  public int getResourceTypeValue() {
    return resourceType_;
  }
  /**
   *
   *
   * <pre>
   * The resource type associated with the upgrade.
   * </pre>
   *
   * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public com.google.container.v1.UpgradeResourceType getResourceType() {
    com.google.container.v1.UpgradeResourceType result =
        com.google.container.v1.UpgradeResourceType.forNumber(resourceType_);
    return result == null ? com.google.container.v1.UpgradeResourceType.UNRECOGNIZED : result;
  }

  public static final int OPERATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operation_ = "";
  /**
   *
   *
   * <pre>
   * The operation associated with this upgrade.
   * </pre>
   *
   * <code>string operation = 2;</code>
   *
   * @return The operation.
   */
  @java.lang.Override
  public java.lang.String getOperation() {
    java.lang.Object ref = operation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The operation associated with this upgrade.
   * </pre>
   *
   * <code>string operation = 2;</code>
   *
   * @return The bytes for operation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationBytes() {
    java.lang.Object ref = operation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the operation ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int CURRENT_VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentVersion_ = "";
  /**
   *
   *
   * <pre>
   * The current version before the upgrade.
   * </pre>
   *
   * <code>string current_version = 5;</code>
   *
   * @return The currentVersion.
   */
  @java.lang.Override
  public java.lang.String getCurrentVersion() {
    java.lang.Object ref = currentVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current version before the upgrade.
   * </pre>
   *
   * <code>string current_version = 5;</code>
   *
   * @return The bytes for currentVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentVersionBytes() {
    java.lang.Object ref = currentVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_VERSION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetVersion_ = "";
  /**
   *
   *
   * <pre>
   * The target version for the upgrade.
   * </pre>
   *
   * <code>string target_version = 6;</code>
   *
   * @return The targetVersion.
   */
  @java.lang.Override
  public java.lang.String getTargetVersion() {
    java.lang.Object ref = targetVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target version for the upgrade.
   * </pre>
   *
   * <code>string target_version = 6;</code>
   *
   * @return The bytes for targetVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetVersionBytes() {
    java.lang.Object ref = targetVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * Optional relative path to the resource. For example in node pool upgrades,
   * the relative path of the node pool.
   * </pre>
   *
   * <code>string resource = 7;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional relative path to the resource. For example in node pool upgrades,
   * the relative path of the node pool.
   * </pre>
   *
   * <code>string resource = 7;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.container.v1.UpgradeInfoEvent.State getState() {
    com.google.container.v1.UpgradeInfoEvent.State result =
        com.google.container.v1.UpgradeInfoEvent.State.forNumber(state_);
    return result == null ? com.google.container.v1.UpgradeInfoEvent.State.UNRECOGNIZED : result;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A brief description of the event.
   * </pre>
   *
   * <code>string description = 11;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A brief description of the event.
   * </pre>
   *
   * <code>string description = 11;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resourceType_
        != com.google.container.v1.UpgradeResourceType.UPGRADE_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, resourceType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, operation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, currentVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, targetVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, resource_);
    }
    if (state_ != com.google.container.v1.UpgradeInfoEvent.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resourceType_
        != com.google.container.v1.UpgradeResourceType.UPGRADE_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, resourceType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, operation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, currentVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, targetVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, resource_);
    }
    if (state_ != com.google.container.v1.UpgradeInfoEvent.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.UpgradeInfoEvent)) {
      return super.equals(obj);
    }
    com.google.container.v1.UpgradeInfoEvent other = (com.google.container.v1.UpgradeInfoEvent) obj;

    if (resourceType_ != other.resourceType_) return false;
    if (!getOperation().equals(other.getOperation())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getCurrentVersion().equals(other.getCurrentVersion())) return false;
    if (!getTargetVersion().equals(other.getTargetVersion())) return false;
    if (!getResource().equals(other.getResource())) return false;
    if (state_ != other.state_) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + resourceType_;
    hash = (37 * hash) + OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getOperation().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + CURRENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentVersion().hashCode();
    hash = (37 * hash) + TARGET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getTargetVersion().hashCode();
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UpgradeInfoEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.UpgradeInfoEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * UpgradeInfoEvent is a notification sent to customers about the upgrade
   * information of a resource.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.UpgradeInfoEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.UpgradeInfoEvent)
      com.google.container.v1.UpgradeInfoEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UpgradeInfoEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UpgradeInfoEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.UpgradeInfoEvent.class,
              com.google.container.v1.UpgradeInfoEvent.Builder.class);
    }

    // Construct using com.google.container.v1.UpgradeInfoEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceType_ = 0;
      operation_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      currentVersion_ = "";
      targetVersion_ = "";
      resource_ = "";
      state_ = 0;
      description_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UpgradeInfoEvent_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.UpgradeInfoEvent getDefaultInstanceForType() {
      return com.google.container.v1.UpgradeInfoEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.UpgradeInfoEvent build() {
      com.google.container.v1.UpgradeInfoEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.UpgradeInfoEvent buildPartial() {
      com.google.container.v1.UpgradeInfoEvent result =
          new com.google.container.v1.UpgradeInfoEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.UpgradeInfoEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceType_ = resourceType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.operation_ = operation_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.currentVersion_ = currentVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.targetVersion_ = targetVersion_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.resource_ = resource_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.description_ = description_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.UpgradeInfoEvent) {
        return mergeFrom((com.google.container.v1.UpgradeInfoEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.UpgradeInfoEvent other) {
      if (other == com.google.container.v1.UpgradeInfoEvent.getDefaultInstance()) return this;
      if (other.resourceType_ != 0) {
        setResourceTypeValue(other.getResourceTypeValue());
      }
      if (!other.getOperation().isEmpty()) {
        operation_ = other.operation_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getCurrentVersion().isEmpty()) {
        currentVersion_ = other.currentVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getTargetVersion().isEmpty()) {
        targetVersion_ = other.targetVersion_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                resourceType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                operation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                currentVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                targetVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 90:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int resourceType_ = 0;
    /**
     *
     *
     * <pre>
     * The resource type associated with the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }
    /**
     *
     *
     * <pre>
     * The resource type associated with the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeValue(int value) {
      resourceType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type associated with the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.container.v1.UpgradeResourceType getResourceType() {
      com.google.container.v1.UpgradeResourceType result =
          com.google.container.v1.UpgradeResourceType.forNumber(resourceType_);
      return result == null ? com.google.container.v1.UpgradeResourceType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The resource type associated with the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(com.google.container.v1.UpgradeResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      resourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type associated with the upgrade.
     * </pre>
     *
     * <code>.google.container.v1.UpgradeResourceType resource_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      resourceType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object operation_ = "";
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The operation.
     */
    public java.lang.String getOperation() {
      java.lang.Object ref = operation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The bytes for operation.
     */
    public com.google.protobuf.ByteString getOperationBytes() {
      java.lang.Object ref = operation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @param value The operation to set.
     * @return This builder for chaining.
     */
    public Builder setOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperation() {
      operation_ = getDefaultInstance().getOperation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @param value The bytes for operation to set.
     * @return This builder for chaining.
     */
    public Builder setOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object currentVersion_ = "";
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 5;</code>
     *
     * @return The currentVersion.
     */
    public java.lang.String getCurrentVersion() {
      java.lang.Object ref = currentVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 5;</code>
     *
     * @return The bytes for currentVersion.
     */
    public com.google.protobuf.ByteString getCurrentVersionBytes() {
      java.lang.Object ref = currentVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 5;</code>
     *
     * @param value The currentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentVersion() {
      currentVersion_ = getDefaultInstance().getCurrentVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 5;</code>
     *
     * @param value The bytes for currentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object targetVersion_ = "";
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 6;</code>
     *
     * @return The targetVersion.
     */
    public java.lang.String getTargetVersion() {
      java.lang.Object ref = targetVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 6;</code>
     *
     * @return The bytes for targetVersion.
     */
    public com.google.protobuf.ByteString getTargetVersionBytes() {
      java.lang.Object ref = targetVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 6;</code>
     *
     * @param value The targetVersion to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetVersion() {
      targetVersion_ = getDefaultInstance().getTargetVersion();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 6;</code>
     *
     * @param value The bytes for targetVersion to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 7;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 7;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 7;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 7;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.container.v1.UpgradeInfoEvent.State getState() {
      com.google.container.v1.UpgradeInfoEvent.State result =
          com.google.container.v1.UpgradeInfoEvent.State.forNumber(state_);
      return result == null ? com.google.container.v1.UpgradeInfoEvent.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.container.v1.UpgradeInfoEvent.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1.UpgradeInfoEvent.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A brief description of the event.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A brief description of the event.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A brief description of the event.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A brief description of the event.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A brief description of the event.
     * </pre>
     *
     * <code>string description = 11;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.UpgradeInfoEvent)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.UpgradeInfoEvent)
  private static final com.google.container.v1.UpgradeInfoEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.UpgradeInfoEvent();
  }

  public static com.google.container.v1.UpgradeInfoEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpgradeInfoEvent> PARSER =
      new com.google.protobuf.AbstractParser<UpgradeInfoEvent>() {
        @java.lang.Override
        public UpgradeInfoEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpgradeInfoEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpgradeInfoEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.UpgradeInfoEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
