/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * UsableSubnetwork resource returns the subnetwork name, its associated network
 * and the primary CIDR range.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.UsableSubnetwork}
 */
public final class UsableSubnetwork extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.UsableSubnetwork)
    UsableSubnetworkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UsableSubnetwork.newBuilder() to construct.
  private UsableSubnetwork(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UsableSubnetwork() {
    subnetwork_ = "";
    network_ = "";
    ipCidrRange_ = "";
    secondaryIpRanges_ = java.util.Collections.emptyList();
    statusMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UsableSubnetwork();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UsableSubnetwork_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UsableSubnetwork_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.UsableSubnetwork.class,
            com.google.container.v1.UsableSubnetwork.Builder.class);
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * Subnetwork Name.
   * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
   * </pre>
   *
   * <code>string subnetwork = 1;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Subnetwork Name.
   * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
   * </pre>
   *
   * <code>string subnetwork = 1;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Network Name.
   * Example: projects/my-project/global/networks/my-network
   * </pre>
   *
   * <code>string network = 2;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Network Name.
   * Example: projects/my-project/global/networks/my-network
   * </pre>
   *
   * <code>string network = 2;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_CIDR_RANGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipCidrRange_ = "";
  /**
   *
   *
   * <pre>
   * The range of internal addresses that are owned by this subnetwork.
   * </pre>
   *
   * <code>string ip_cidr_range = 3;</code>
   *
   * @return The ipCidrRange.
   */
  @java.lang.Override
  public java.lang.String getIpCidrRange() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipCidrRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The range of internal addresses that are owned by this subnetwork.
   * </pre>
   *
   * <code>string ip_cidr_range = 3;</code>
   *
   * @return The bytes for ipCidrRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpCidrRangeBytes() {
    java.lang.Object ref = ipCidrRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipCidrRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECONDARY_IP_RANGES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1.UsableSubnetworkSecondaryRange> secondaryIpRanges_;
  /**
   *
   *
   * <pre>
   * Secondary IP ranges.
   * </pre>
   *
   * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1.UsableSubnetworkSecondaryRange>
      getSecondaryIpRangesList() {
    return secondaryIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Secondary IP ranges.
   * </pre>
   *
   * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder>
      getSecondaryIpRangesOrBuilderList() {
    return secondaryIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * Secondary IP ranges.
   * </pre>
   *
   * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
   * </code>
   */
  @java.lang.Override
  public int getSecondaryIpRangesCount() {
    return secondaryIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * Secondary IP ranges.
   * </pre>
   *
   * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.UsableSubnetworkSecondaryRange getSecondaryIpRanges(int index) {
    return secondaryIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secondary IP ranges.
   * </pre>
   *
   * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder
      getSecondaryIpRangesOrBuilder(int index) {
    return secondaryIpRanges_.get(index);
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * A human readable status message representing the reasons for cases where
   * the caller cannot use the secondary ranges under the subnet. For example if
   * the secondary_ip_ranges is empty due to a permission issue, an insufficient
   * permission message will be given by status_message.
   * </pre>
   *
   * <code>string status_message = 5;</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human readable status message representing the reasons for cases where
   * the caller cannot use the secondary ranges under the subnet. For example if
   * the secondary_ip_ranges is empty due to a permission issue, an insufficient
   * permission message will be given by status_message.
   * </pre>
   *
   * <code>string status_message = 5;</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, subnetwork_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipCidrRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ipCidrRange_);
    }
    for (int i = 0; i < secondaryIpRanges_.size(); i++) {
      output.writeMessage(4, secondaryIpRanges_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, statusMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, subnetwork_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipCidrRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ipCidrRange_);
    }
    for (int i = 0; i < secondaryIpRanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, secondaryIpRanges_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, statusMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.UsableSubnetwork)) {
      return super.equals(obj);
    }
    com.google.container.v1.UsableSubnetwork other = (com.google.container.v1.UsableSubnetwork) obj;

    if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getIpCidrRange().equals(other.getIpCidrRange())) return false;
    if (!getSecondaryIpRangesList().equals(other.getSecondaryIpRangesList())) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetwork().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + IP_CIDR_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getIpCidrRange().hashCode();
    if (getSecondaryIpRangesCount() > 0) {
      hash = (37 * hash) + SECONDARY_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSecondaryIpRangesList().hashCode();
    }
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UsableSubnetwork parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UsableSubnetwork parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UsableSubnetwork parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.UsableSubnetwork prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * UsableSubnetwork resource returns the subnetwork name, its associated network
   * and the primary CIDR range.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.UsableSubnetwork}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.UsableSubnetwork)
      com.google.container.v1.UsableSubnetworkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UsableSubnetwork_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UsableSubnetwork_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.UsableSubnetwork.class,
              com.google.container.v1.UsableSubnetwork.Builder.class);
    }

    // Construct using com.google.container.v1.UsableSubnetwork.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      subnetwork_ = "";
      network_ = "";
      ipCidrRange_ = "";
      if (secondaryIpRangesBuilder_ == null) {
        secondaryIpRanges_ = java.util.Collections.emptyList();
      } else {
        secondaryIpRanges_ = null;
        secondaryIpRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      statusMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UsableSubnetwork_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.UsableSubnetwork getDefaultInstanceForType() {
      return com.google.container.v1.UsableSubnetwork.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.UsableSubnetwork build() {
      com.google.container.v1.UsableSubnetwork result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.UsableSubnetwork buildPartial() {
      com.google.container.v1.UsableSubnetwork result =
          new com.google.container.v1.UsableSubnetwork(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1.UsableSubnetwork result) {
      if (secondaryIpRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          secondaryIpRanges_ = java.util.Collections.unmodifiableList(secondaryIpRanges_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.secondaryIpRanges_ = secondaryIpRanges_;
      } else {
        result.secondaryIpRanges_ = secondaryIpRangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1.UsableSubnetwork result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.subnetwork_ = subnetwork_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ipCidrRange_ = ipCidrRange_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.UsableSubnetwork) {
        return mergeFrom((com.google.container.v1.UsableSubnetwork) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.UsableSubnetwork other) {
      if (other == com.google.container.v1.UsableSubnetwork.getDefaultInstance()) return this;
      if (!other.getSubnetwork().isEmpty()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getIpCidrRange().isEmpty()) {
        ipCidrRange_ = other.ipCidrRange_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (secondaryIpRangesBuilder_ == null) {
        if (!other.secondaryIpRanges_.isEmpty()) {
          if (secondaryIpRanges_.isEmpty()) {
            secondaryIpRanges_ = other.secondaryIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureSecondaryIpRangesIsMutable();
            secondaryIpRanges_.addAll(other.secondaryIpRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.secondaryIpRanges_.isEmpty()) {
          if (secondaryIpRangesBuilder_.isEmpty()) {
            secondaryIpRangesBuilder_.dispose();
            secondaryIpRangesBuilder_ = null;
            secondaryIpRanges_ = other.secondaryIpRanges_;
            bitField0_ = (bitField0_ & ~0x00000008);
            secondaryIpRangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecondaryIpRangesFieldBuilder()
                    : null;
          } else {
            secondaryIpRangesBuilder_.addAllMessages(other.secondaryIpRanges_);
          }
        }
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                ipCidrRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.container.v1.UsableSubnetworkSecondaryRange m =
                    input.readMessage(
                        com.google.container.v1.UsableSubnetworkSecondaryRange.parser(),
                        extensionRegistry);
                if (secondaryIpRangesBuilder_ == null) {
                  ensureSecondaryIpRangesIsMutable();
                  secondaryIpRanges_.add(m);
                } else {
                  secondaryIpRangesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * Subnetwork Name.
     * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 1;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnetwork Name.
     * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 1;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnetwork Name.
     * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 1;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Subnetwork Name.
     * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Subnetwork Name.
     * Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 1;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Network Name.
     * Example: projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Network Name.
     * Example: projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Network Name.
     * Example: projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network Name.
     * Example: projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network Name.
     * Example: projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 2;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object ipCidrRange_ = "";
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @return The ipCidrRange.
     */
    public java.lang.String getIpCidrRange() {
      java.lang.Object ref = ipCidrRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipCidrRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @return The bytes for ipCidrRange.
     */
    public com.google.protobuf.ByteString getIpCidrRangeBytes() {
      java.lang.Object ref = ipCidrRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipCidrRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @param value The ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipCidrRange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpCidrRange() {
      ipCidrRange_ = getDefaultInstance().getIpCidrRange();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The range of internal addresses that are owned by this subnetwork.
     * </pre>
     *
     * <code>string ip_cidr_range = 3;</code>
     *
     * @param value The bytes for ipCidrRange to set.
     * @return This builder for chaining.
     */
    public Builder setIpCidrRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipCidrRange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1.UsableSubnetworkSecondaryRange>
        secondaryIpRanges_ = java.util.Collections.emptyList();

    private void ensureSecondaryIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        secondaryIpRanges_ =
            new java.util.ArrayList<com.google.container.v1.UsableSubnetworkSecondaryRange>(
                secondaryIpRanges_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.UsableSubnetworkSecondaryRange,
            com.google.container.v1.UsableSubnetworkSecondaryRange.Builder,
            com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder>
        secondaryIpRangesBuilder_;

    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public java.util.List<com.google.container.v1.UsableSubnetworkSecondaryRange>
        getSecondaryIpRangesList() {
      if (secondaryIpRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secondaryIpRanges_);
      } else {
        return secondaryIpRangesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public int getSecondaryIpRangesCount() {
      if (secondaryIpRangesBuilder_ == null) {
        return secondaryIpRanges_.size();
      } else {
        return secondaryIpRangesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public com.google.container.v1.UsableSubnetworkSecondaryRange getSecondaryIpRanges(int index) {
      if (secondaryIpRangesBuilder_ == null) {
        return secondaryIpRanges_.get(index);
      } else {
        return secondaryIpRangesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder setSecondaryIpRanges(
        int index, com.google.container.v1.UsableSubnetworkSecondaryRange value) {
      if (secondaryIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.set(index, value);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder setSecondaryIpRanges(
        int index, com.google.container.v1.UsableSubnetworkSecondaryRange.Builder builderForValue) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        secondaryIpRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        com.google.container.v1.UsableSubnetworkSecondaryRange value) {
      if (secondaryIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(value);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        int index, com.google.container.v1.UsableSubnetworkSecondaryRange value) {
      if (secondaryIpRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(index, value);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        com.google.container.v1.UsableSubnetworkSecondaryRange.Builder builderForValue) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(builderForValue.build());
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder addSecondaryIpRanges(
        int index, com.google.container.v1.UsableSubnetworkSecondaryRange.Builder builderForValue) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder addAllSecondaryIpRanges(
        java.lang.Iterable<? extends com.google.container.v1.UsableSubnetworkSecondaryRange>
            values) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secondaryIpRanges_);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder clearSecondaryIpRanges() {
      if (secondaryIpRangesBuilder_ == null) {
        secondaryIpRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public Builder removeSecondaryIpRanges(int index) {
      if (secondaryIpRangesBuilder_ == null) {
        ensureSecondaryIpRangesIsMutable();
        secondaryIpRanges_.remove(index);
        onChanged();
      } else {
        secondaryIpRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public com.google.container.v1.UsableSubnetworkSecondaryRange.Builder
        getSecondaryIpRangesBuilder(int index) {
      return getSecondaryIpRangesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder
        getSecondaryIpRangesOrBuilder(int index) {
      if (secondaryIpRangesBuilder_ == null) {
        return secondaryIpRanges_.get(index);
      } else {
        return secondaryIpRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public java.util.List<? extends com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder>
        getSecondaryIpRangesOrBuilderList() {
      if (secondaryIpRangesBuilder_ != null) {
        return secondaryIpRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secondaryIpRanges_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public com.google.container.v1.UsableSubnetworkSecondaryRange.Builder
        addSecondaryIpRangesBuilder() {
      return getSecondaryIpRangesFieldBuilder()
          .addBuilder(com.google.container.v1.UsableSubnetworkSecondaryRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public com.google.container.v1.UsableSubnetworkSecondaryRange.Builder
        addSecondaryIpRangesBuilder(int index) {
      return getSecondaryIpRangesFieldBuilder()
          .addBuilder(
              index, com.google.container.v1.UsableSubnetworkSecondaryRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secondary IP ranges.
     * </pre>
     *
     * <code>repeated .google.container.v1.UsableSubnetworkSecondaryRange secondary_ip_ranges = 4;
     * </code>
     */
    public java.util.List<com.google.container.v1.UsableSubnetworkSecondaryRange.Builder>
        getSecondaryIpRangesBuilderList() {
      return getSecondaryIpRangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1.UsableSubnetworkSecondaryRange,
            com.google.container.v1.UsableSubnetworkSecondaryRange.Builder,
            com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder>
        getSecondaryIpRangesFieldBuilder() {
      if (secondaryIpRangesBuilder_ == null) {
        secondaryIpRangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1.UsableSubnetworkSecondaryRange,
                com.google.container.v1.UsableSubnetworkSecondaryRange.Builder,
                com.google.container.v1.UsableSubnetworkSecondaryRangeOrBuilder>(
                secondaryIpRanges_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        secondaryIpRanges_ = null;
      }
      return secondaryIpRangesBuilder_;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * A human readable status message representing the reasons for cases where
     * the caller cannot use the secondary ranges under the subnet. For example if
     * the secondary_ip_ranges is empty due to a permission issue, an insufficient
     * permission message will be given by status_message.
     * </pre>
     *
     * <code>string status_message = 5;</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable status message representing the reasons for cases where
     * the caller cannot use the secondary ranges under the subnet. For example if
     * the secondary_ip_ranges is empty due to a permission issue, an insufficient
     * permission message will be given by status_message.
     * </pre>
     *
     * <code>string status_message = 5;</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable status message representing the reasons for cases where
     * the caller cannot use the secondary ranges under the subnet. For example if
     * the secondary_ip_ranges is empty due to a permission issue, an insufficient
     * permission message will be given by status_message.
     * </pre>
     *
     * <code>string status_message = 5;</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human readable status message representing the reasons for cases where
     * the caller cannot use the secondary ranges under the subnet. For example if
     * the secondary_ip_ranges is empty due to a permission issue, an insufficient
     * permission message will be given by status_message.
     * </pre>
     *
     * <code>string status_message = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human readable status message representing the reasons for cases where
     * the caller cannot use the secondary ranges under the subnet. For example if
     * the secondary_ip_ranges is empty due to a permission issue, an insufficient
     * permission message will be given by status_message.
     * </pre>
     *
     * <code>string status_message = 5;</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.UsableSubnetwork)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.UsableSubnetwork)
  private static final com.google.container.v1.UsableSubnetwork DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.UsableSubnetwork();
  }

  public static com.google.container.v1.UsableSubnetwork getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UsableSubnetwork> PARSER =
      new com.google.protobuf.AbstractParser<UsableSubnetwork>() {
        @java.lang.Override
        public UsableSubnetwork parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UsableSubnetwork> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UsableSubnetwork> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.UsableSubnetwork getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
