/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

/**
 *
 *
 * <pre>
 * UserManagedKeysConfig holds the resource address to Keys which are used
 * for signing certs and token that are used for communication within cluster.
 * </pre>
 *
 * Protobuf type {@code google.container.v1.UserManagedKeysConfig}
 */
public final class UserManagedKeysConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1.UserManagedKeysConfig)
    UserManagedKeysConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserManagedKeysConfig.newBuilder() to construct.
  private UserManagedKeysConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserManagedKeysConfig() {
    clusterCa_ = "";
    etcdApiCa_ = "";
    etcdPeerCa_ = "";
    serviceAccountSigningKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccountVerificationKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    aggregationCa_ = "";
    controlPlaneDiskEncryptionKey_ = "";
    gkeopsEtcdBackupEncryptionKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserManagedKeysConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UserManagedKeysConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1.ClusterServiceProto
        .internal_static_google_container_v1_UserManagedKeysConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1.UserManagedKeysConfig.class,
            com.google.container.v1.UserManagedKeysConfig.Builder.class);
  }

  public static final int CLUSTER_CA_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterCa_ = "";
  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the cluster CA in this
   * cluster.
   * </pre>
   *
   * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The clusterCa.
   */
  @java.lang.Override
  public java.lang.String getClusterCa() {
    java.lang.Object ref = clusterCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the cluster CA in this
   * cluster.
   * </pre>
   *
   * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for clusterCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterCaBytes() {
    java.lang.Object ref = clusterCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETCD_API_CA_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etcdApiCa_ = "";
  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd API CA in this cluster.
   * </pre>
   *
   * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The etcdApiCa.
   */
  @java.lang.Override
  public java.lang.String getEtcdApiCa() {
    java.lang.Object ref = etcdApiCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etcdApiCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd API CA in this cluster.
   * </pre>
   *
   * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for etcdApiCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtcdApiCaBytes() {
    java.lang.Object ref = etcdApiCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etcdApiCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETCD_PEER_CA_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etcdPeerCa_ = "";
  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd peer CA in this cluster.
   * </pre>
   *
   * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The etcdPeerCa.
   */
  @java.lang.Override
  public java.lang.String getEtcdPeerCa() {
    java.lang.Object ref = etcdPeerCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etcdPeerCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd peer CA in this cluster.
   * </pre>
   *
   * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for etcdPeerCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtcdPeerCaBytes() {
    java.lang.Object ref = etcdPeerCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etcdPeerCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_SIGNING_KEYS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serviceAccountSigningKeys_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the serviceAccountSigningKeys.
   */
  public com.google.protobuf.ProtocolStringList getServiceAccountSigningKeysList() {
    return serviceAccountSigningKeys_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of serviceAccountSigningKeys.
   */
  public int getServiceAccountSigningKeysCount() {
    return serviceAccountSigningKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The serviceAccountSigningKeys at the given index.
   */
  public java.lang.String getServiceAccountSigningKeys(int index) {
    return serviceAccountSigningKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceAccountSigningKeys at the given index.
   */
  public com.google.protobuf.ByteString getServiceAccountSigningKeysBytes(int index) {
    return serviceAccountSigningKeys_.getByteString(index);
  }

  public static final int SERVICE_ACCOUNT_VERIFICATION_KEYS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serviceAccountVerificationKeys_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the serviceAccountVerificationKeys.
   */
  public com.google.protobuf.ProtocolStringList getServiceAccountVerificationKeysList() {
    return serviceAccountVerificationKeys_;
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of serviceAccountVerificationKeys.
   */
  public int getServiceAccountVerificationKeysCount() {
    return serviceAccountVerificationKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The serviceAccountVerificationKeys at the given index.
   */
  public java.lang.String getServiceAccountVerificationKeys(int index) {
    return serviceAccountVerificationKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceAccountVerificationKeys at the given index.
   */
  public com.google.protobuf.ByteString getServiceAccountVerificationKeysBytes(int index) {
    return serviceAccountVerificationKeys_.getByteString(index);
  }

  public static final int AGGREGATION_CA_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object aggregationCa_ = "";
  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the aggregation CA in
   * this cluster.
   * </pre>
   *
   * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The aggregationCa.
   */
  @java.lang.Override
  public java.lang.String getAggregationCa() {
    java.lang.Object ref = aggregationCa_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      aggregationCa_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the aggregation CA in
   * this cluster.
   * </pre>
   *
   * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for aggregationCa.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAggregationCaBytes() {
    java.lang.Object ref = aggregationCa_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      aggregationCa_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTROL_PLANE_DISK_ENCRYPTION_KEY_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object controlPlaneDiskEncryptionKey_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
   * plane nodes.
   * </pre>
   *
   * <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The controlPlaneDiskEncryptionKey.
   */
  @java.lang.Override
  public java.lang.String getControlPlaneDiskEncryptionKey() {
    java.lang.Object ref = controlPlaneDiskEncryptionKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      controlPlaneDiskEncryptionKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
   * plane nodes.
   * </pre>
   *
   * <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for controlPlaneDiskEncryptionKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getControlPlaneDiskEncryptionKeyBytes() {
    java.lang.Object ref = controlPlaneDiskEncryptionKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      controlPlaneDiskEncryptionKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GKEOPS_ETCD_BACKUP_ENCRYPTION_KEY_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gkeopsEtcdBackupEncryptionKey_ = "";
  /**
   *
   *
   * <pre>
   * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
   * etcd backups.
   * </pre>
   *
   * <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The gkeopsEtcdBackupEncryptionKey.
   */
  @java.lang.Override
  public java.lang.String getGkeopsEtcdBackupEncryptionKey() {
    java.lang.Object ref = gkeopsEtcdBackupEncryptionKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gkeopsEtcdBackupEncryptionKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
   * etcd backups.
   * </pre>
   *
   * <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for gkeopsEtcdBackupEncryptionKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGkeopsEtcdBackupEncryptionKeyBytes() {
    java.lang.Object ref = gkeopsEtcdBackupEncryptionKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gkeopsEtcdBackupEncryptionKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, clusterCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etcdApiCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, etcdApiCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etcdPeerCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, etcdPeerCa_);
    }
    for (int i = 0; i < serviceAccountSigningKeys_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 13, serviceAccountSigningKeys_.getRaw(i));
    }
    for (int i = 0; i < serviceAccountVerificationKeys_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 14, serviceAccountVerificationKeys_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(aggregationCa_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, aggregationCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(controlPlaneDiskEncryptionKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 16, controlPlaneDiskEncryptionKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeopsEtcdBackupEncryptionKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 17, gkeopsEtcdBackupEncryptionKey_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, clusterCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etcdApiCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, etcdApiCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etcdPeerCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, etcdPeerCa_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serviceAccountSigningKeys_.size(); i++) {
        dataSize += computeStringSizeNoTag(serviceAccountSigningKeys_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServiceAccountSigningKeysList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serviceAccountVerificationKeys_.size(); i++) {
        dataSize += computeStringSizeNoTag(serviceAccountVerificationKeys_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServiceAccountVerificationKeysList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(aggregationCa_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, aggregationCa_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(controlPlaneDiskEncryptionKey_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              16, controlPlaneDiskEncryptionKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeopsEtcdBackupEncryptionKey_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              17, gkeopsEtcdBackupEncryptionKey_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1.UserManagedKeysConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1.UserManagedKeysConfig other =
        (com.google.container.v1.UserManagedKeysConfig) obj;

    if (!getClusterCa().equals(other.getClusterCa())) return false;
    if (!getEtcdApiCa().equals(other.getEtcdApiCa())) return false;
    if (!getEtcdPeerCa().equals(other.getEtcdPeerCa())) return false;
    if (!getServiceAccountSigningKeysList().equals(other.getServiceAccountSigningKeysList()))
      return false;
    if (!getServiceAccountVerificationKeysList()
        .equals(other.getServiceAccountVerificationKeysList())) return false;
    if (!getAggregationCa().equals(other.getAggregationCa())) return false;
    if (!getControlPlaneDiskEncryptionKey().equals(other.getControlPlaneDiskEncryptionKey()))
      return false;
    if (!getGkeopsEtcdBackupEncryptionKey().equals(other.getGkeopsEtcdBackupEncryptionKey()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CLUSTER_CA_FIELD_NUMBER;
    hash = (53 * hash) + getClusterCa().hashCode();
    hash = (37 * hash) + ETCD_API_CA_FIELD_NUMBER;
    hash = (53 * hash) + getEtcdApiCa().hashCode();
    hash = (37 * hash) + ETCD_PEER_CA_FIELD_NUMBER;
    hash = (53 * hash) + getEtcdPeerCa().hashCode();
    if (getServiceAccountSigningKeysCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNT_SIGNING_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountSigningKeysList().hashCode();
    }
    if (getServiceAccountVerificationKeysCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNT_VERIFICATION_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountVerificationKeysList().hashCode();
    }
    hash = (37 * hash) + AGGREGATION_CA_FIELD_NUMBER;
    hash = (53 * hash) + getAggregationCa().hashCode();
    hash = (37 * hash) + CONTROL_PLANE_DISK_ENCRYPTION_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getControlPlaneDiskEncryptionKey().hashCode();
    hash = (37 * hash) + GKEOPS_ETCD_BACKUP_ENCRYPTION_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getGkeopsEtcdBackupEncryptionKey().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1.UserManagedKeysConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1.UserManagedKeysConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * UserManagedKeysConfig holds the resource address to Keys which are used
   * for signing certs and token that are used for communication within cluster.
   * </pre>
   *
   * Protobuf type {@code google.container.v1.UserManagedKeysConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1.UserManagedKeysConfig)
      com.google.container.v1.UserManagedKeysConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UserManagedKeysConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UserManagedKeysConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1.UserManagedKeysConfig.class,
              com.google.container.v1.UserManagedKeysConfig.Builder.class);
    }

    // Construct using com.google.container.v1.UserManagedKeysConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      clusterCa_ = "";
      etcdApiCa_ = "";
      etcdPeerCa_ = "";
      serviceAccountSigningKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceAccountVerificationKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      aggregationCa_ = "";
      controlPlaneDiskEncryptionKey_ = "";
      gkeopsEtcdBackupEncryptionKey_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1.ClusterServiceProto
          .internal_static_google_container_v1_UserManagedKeysConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1.UserManagedKeysConfig getDefaultInstanceForType() {
      return com.google.container.v1.UserManagedKeysConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1.UserManagedKeysConfig build() {
      com.google.container.v1.UserManagedKeysConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1.UserManagedKeysConfig buildPartial() {
      com.google.container.v1.UserManagedKeysConfig result =
          new com.google.container.v1.UserManagedKeysConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1.UserManagedKeysConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.clusterCa_ = clusterCa_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.etcdApiCa_ = etcdApiCa_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etcdPeerCa_ = etcdPeerCa_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        serviceAccountSigningKeys_.makeImmutable();
        result.serviceAccountSigningKeys_ = serviceAccountSigningKeys_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        serviceAccountVerificationKeys_.makeImmutable();
        result.serviceAccountVerificationKeys_ = serviceAccountVerificationKeys_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.aggregationCa_ = aggregationCa_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.controlPlaneDiskEncryptionKey_ = controlPlaneDiskEncryptionKey_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.gkeopsEtcdBackupEncryptionKey_ = gkeopsEtcdBackupEncryptionKey_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1.UserManagedKeysConfig) {
        return mergeFrom((com.google.container.v1.UserManagedKeysConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1.UserManagedKeysConfig other) {
      if (other == com.google.container.v1.UserManagedKeysConfig.getDefaultInstance()) return this;
      if (!other.getClusterCa().isEmpty()) {
        clusterCa_ = other.clusterCa_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEtcdApiCa().isEmpty()) {
        etcdApiCa_ = other.etcdApiCa_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEtcdPeerCa().isEmpty()) {
        etcdPeerCa_ = other.etcdPeerCa_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.serviceAccountSigningKeys_.isEmpty()) {
        if (serviceAccountSigningKeys_.isEmpty()) {
          serviceAccountSigningKeys_ = other.serviceAccountSigningKeys_;
          bitField0_ |= 0x00000008;
        } else {
          ensureServiceAccountSigningKeysIsMutable();
          serviceAccountSigningKeys_.addAll(other.serviceAccountSigningKeys_);
        }
        onChanged();
      }
      if (!other.serviceAccountVerificationKeys_.isEmpty()) {
        if (serviceAccountVerificationKeys_.isEmpty()) {
          serviceAccountVerificationKeys_ = other.serviceAccountVerificationKeys_;
          bitField0_ |= 0x00000010;
        } else {
          ensureServiceAccountVerificationKeysIsMutable();
          serviceAccountVerificationKeys_.addAll(other.serviceAccountVerificationKeys_);
        }
        onChanged();
      }
      if (!other.getAggregationCa().isEmpty()) {
        aggregationCa_ = other.aggregationCa_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getControlPlaneDiskEncryptionKey().isEmpty()) {
        controlPlaneDiskEncryptionKey_ = other.controlPlaneDiskEncryptionKey_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getGkeopsEtcdBackupEncryptionKey().isEmpty()) {
        gkeopsEtcdBackupEncryptionKey_ = other.gkeopsEtcdBackupEncryptionKey_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 82:
              {
                clusterCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 82
            case 90:
              {
                etcdApiCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 90
            case 98:
              {
                etcdPeerCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServiceAccountSigningKeysIsMutable();
                serviceAccountSigningKeys_.add(s);
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServiceAccountVerificationKeysIsMutable();
                serviceAccountVerificationKeys_.add(s);
                break;
              } // case 114
            case 122:
              {
                aggregationCa_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 122
            case 130:
              {
                controlPlaneDiskEncryptionKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 130
            case 138:
              {
                gkeopsEtcdBackupEncryptionKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object clusterCa_ = "";
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     * </pre>
     *
     * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The clusterCa.
     */
    public java.lang.String getClusterCa() {
      java.lang.Object ref = clusterCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     * </pre>
     *
     * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for clusterCa.
     */
    public com.google.protobuf.ByteString getClusterCaBytes() {
      java.lang.Object ref = clusterCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     * </pre>
     *
     * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The clusterCa to set.
     * @return This builder for chaining.
     */
    public Builder setClusterCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterCa_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     * </pre>
     *
     * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClusterCa() {
      clusterCa_ = getDefaultInstance().getClusterCa();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the cluster CA in this
     * cluster.
     * </pre>
     *
     * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for clusterCa to set.
     * @return This builder for chaining.
     */
    public Builder setClusterCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterCa_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object etcdApiCa_ = "";
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     * </pre>
     *
     * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The etcdApiCa.
     */
    public java.lang.String getEtcdApiCa() {
      java.lang.Object ref = etcdApiCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etcdApiCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     * </pre>
     *
     * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for etcdApiCa.
     */
    public com.google.protobuf.ByteString getEtcdApiCaBytes() {
      java.lang.Object ref = etcdApiCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etcdApiCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     * </pre>
     *
     * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The etcdApiCa to set.
     * @return This builder for chaining.
     */
    public Builder setEtcdApiCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etcdApiCa_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     * </pre>
     *
     * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtcdApiCa() {
      etcdApiCa_ = getDefaultInstance().getEtcdApiCa();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd API CA in this cluster.
     * </pre>
     *
     * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for etcdApiCa to set.
     * @return This builder for chaining.
     */
    public Builder setEtcdApiCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etcdApiCa_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object etcdPeerCa_ = "";
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     * </pre>
     *
     * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The etcdPeerCa.
     */
    public java.lang.String getEtcdPeerCa() {
      java.lang.Object ref = etcdPeerCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etcdPeerCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     * </pre>
     *
     * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for etcdPeerCa.
     */
    public com.google.protobuf.ByteString getEtcdPeerCaBytes() {
      java.lang.Object ref = etcdPeerCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etcdPeerCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     * </pre>
     *
     * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The etcdPeerCa to set.
     * @return This builder for chaining.
     */
    public Builder setEtcdPeerCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etcdPeerCa_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     * </pre>
     *
     * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtcdPeerCa() {
      etcdPeerCa_ = getDefaultInstance().getEtcdPeerCa();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Certificate Authority Service caPool to use for the
     * etcd peer CA in this cluster.
     * </pre>
     *
     * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for etcdPeerCa to set.
     * @return This builder for chaining.
     */
    public Builder setEtcdPeerCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etcdPeerCa_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList serviceAccountSigningKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServiceAccountSigningKeysIsMutable() {
      if (!serviceAccountSigningKeys_.isModifiable()) {
        serviceAccountSigningKeys_ =
            new com.google.protobuf.LazyStringArrayList(serviceAccountSigningKeys_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the serviceAccountSigningKeys.
     */
    public com.google.protobuf.ProtocolStringList getServiceAccountSigningKeysList() {
      serviceAccountSigningKeys_.makeImmutable();
      return serviceAccountSigningKeys_;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of serviceAccountSigningKeys.
     */
    public int getServiceAccountSigningKeysCount() {
      return serviceAccountSigningKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The serviceAccountSigningKeys at the given index.
     */
    public java.lang.String getServiceAccountSigningKeys(int index) {
      return serviceAccountSigningKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the serviceAccountSigningKeys at the given index.
     */
    public com.google.protobuf.ByteString getServiceAccountSigningKeysBytes(int index) {
      return serviceAccountSigningKeys_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The serviceAccountSigningKeys to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountSigningKeys(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceAccountSigningKeysIsMutable();
      serviceAccountSigningKeys_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The serviceAccountSigningKeys to add.
     * @return This builder for chaining.
     */
    public Builder addServiceAccountSigningKeys(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceAccountSigningKeysIsMutable();
      serviceAccountSigningKeys_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The serviceAccountSigningKeys to add.
     * @return This builder for chaining.
     */
    public Builder addAllServiceAccountSigningKeys(java.lang.Iterable<java.lang.String> values) {
      ensureServiceAccountSigningKeysIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccountSigningKeys_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountSigningKeys() {
      serviceAccountSigningKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the serviceAccountSigningKeys to add.
     * @return This builder for chaining.
     */
    public Builder addServiceAccountSigningKeysBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServiceAccountSigningKeysIsMutable();
      serviceAccountSigningKeys_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList serviceAccountVerificationKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServiceAccountVerificationKeysIsMutable() {
      if (!serviceAccountVerificationKeys_.isModifiable()) {
        serviceAccountVerificationKeys_ =
            new com.google.protobuf.LazyStringArrayList(serviceAccountVerificationKeys_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the serviceAccountVerificationKeys.
     */
    public com.google.protobuf.ProtocolStringList getServiceAccountVerificationKeysList() {
      serviceAccountVerificationKeys_.makeImmutable();
      return serviceAccountVerificationKeys_;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of serviceAccountVerificationKeys.
     */
    public int getServiceAccountVerificationKeysCount() {
      return serviceAccountVerificationKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The serviceAccountVerificationKeys at the given index.
     */
    public java.lang.String getServiceAccountVerificationKeys(int index) {
      return serviceAccountVerificationKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the serviceAccountVerificationKeys at the given index.
     */
    public com.google.protobuf.ByteString getServiceAccountVerificationKeysBytes(int index) {
      return serviceAccountVerificationKeys_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The serviceAccountVerificationKeys to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountVerificationKeys(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceAccountVerificationKeysIsMutable();
      serviceAccountVerificationKeys_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The serviceAccountVerificationKeys to add.
     * @return This builder for chaining.
     */
    public Builder addServiceAccountVerificationKeys(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceAccountVerificationKeysIsMutable();
      serviceAccountVerificationKeys_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The serviceAccountVerificationKeys to add.
     * @return This builder for chaining.
     */
    public Builder addAllServiceAccountVerificationKeys(
        java.lang.Iterable<java.lang.String> values) {
      ensureServiceAccountVerificationKeysIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, serviceAccountVerificationKeys_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountVerificationKeys() {
      serviceAccountVerificationKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
     * issued by this cluster.
     *
     * Format:
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
     * </pre>
     *
     * <code>
     * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the serviceAccountVerificationKeys to add.
     * @return This builder for chaining.
     */
    public Builder addServiceAccountVerificationKeysBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServiceAccountVerificationKeysIsMutable();
      serviceAccountVerificationKeys_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object aggregationCa_ = "";
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     * </pre>
     *
     * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The aggregationCa.
     */
    public java.lang.String getAggregationCa() {
      java.lang.Object ref = aggregationCa_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        aggregationCa_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     * </pre>
     *
     * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for aggregationCa.
     */
    public com.google.protobuf.ByteString getAggregationCaBytes() {
      java.lang.Object ref = aggregationCa_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        aggregationCa_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     * </pre>
     *
     * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The aggregationCa to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationCa(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      aggregationCa_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     * </pre>
     *
     * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAggregationCa() {
      aggregationCa_ = getDefaultInstance().getAggregationCa();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Certificate Authority Service caPool to use for the aggregation CA in
     * this cluster.
     * </pre>
     *
     * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for aggregationCa to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationCaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      aggregationCa_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object controlPlaneDiskEncryptionKey_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     * </pre>
     *
     * <code>
     * string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The controlPlaneDiskEncryptionKey.
     */
    public java.lang.String getControlPlaneDiskEncryptionKey() {
      java.lang.Object ref = controlPlaneDiskEncryptionKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        controlPlaneDiskEncryptionKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     * </pre>
     *
     * <code>
     * string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for controlPlaneDiskEncryptionKey.
     */
    public com.google.protobuf.ByteString getControlPlaneDiskEncryptionKeyBytes() {
      java.lang.Object ref = controlPlaneDiskEncryptionKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        controlPlaneDiskEncryptionKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     * </pre>
     *
     * <code>
     * string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The controlPlaneDiskEncryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setControlPlaneDiskEncryptionKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      controlPlaneDiskEncryptionKey_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     * </pre>
     *
     * <code>
     * string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearControlPlaneDiskEncryptionKey() {
      controlPlaneDiskEncryptionKey_ = getDefaultInstance().getControlPlaneDiskEncryptionKey();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
     * plane nodes.
     * </pre>
     *
     * <code>
     * string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for controlPlaneDiskEncryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setControlPlaneDiskEncryptionKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      controlPlaneDiskEncryptionKey_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object gkeopsEtcdBackupEncryptionKey_ = "";
    /**
     *
     *
     * <pre>
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     * </pre>
     *
     * <code>
     * string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The gkeopsEtcdBackupEncryptionKey.
     */
    public java.lang.String getGkeopsEtcdBackupEncryptionKey() {
      java.lang.Object ref = gkeopsEtcdBackupEncryptionKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gkeopsEtcdBackupEncryptionKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     * </pre>
     *
     * <code>
     * string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for gkeopsEtcdBackupEncryptionKey.
     */
    public com.google.protobuf.ByteString getGkeopsEtcdBackupEncryptionKeyBytes() {
      java.lang.Object ref = gkeopsEtcdBackupEncryptionKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gkeopsEtcdBackupEncryptionKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     * </pre>
     *
     * <code>
     * string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The gkeopsEtcdBackupEncryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setGkeopsEtcdBackupEncryptionKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gkeopsEtcdBackupEncryptionKey_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     * </pre>
     *
     * <code>
     * string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGkeopsEtcdBackupEncryptionKey() {
      gkeopsEtcdBackupEncryptionKey_ = getDefaultInstance().getGkeopsEtcdBackupEncryptionKey();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
     * etcd backups.
     * </pre>
     *
     * <code>
     * string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for gkeopsEtcdBackupEncryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setGkeopsEtcdBackupEncryptionKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gkeopsEtcdBackupEncryptionKey_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1.UserManagedKeysConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1.UserManagedKeysConfig)
  private static final com.google.container.v1.UserManagedKeysConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1.UserManagedKeysConfig();
  }

  public static com.google.container.v1.UserManagedKeysConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserManagedKeysConfig> PARSER =
      new com.google.protobuf.AbstractParser<UserManagedKeysConfig>() {
        @java.lang.Override
        public UserManagedKeysConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserManagedKeysConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserManagedKeysConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1.UserManagedKeysConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
