/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1;

public interface UserManagedKeysConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.container.v1.UserManagedKeysConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the cluster CA in this
   * cluster.
   * </pre>
   *
   * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The clusterCa.
   */
  java.lang.String getClusterCa();
  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the cluster CA in this
   * cluster.
   * </pre>
   *
   * <code>string cluster_ca = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for clusterCa.
   */
  com.google.protobuf.ByteString getClusterCaBytes();

  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd API CA in this cluster.
   * </pre>
   *
   * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The etcdApiCa.
   */
  java.lang.String getEtcdApiCa();
  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd API CA in this cluster.
   * </pre>
   *
   * <code>string etcd_api_ca = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for etcdApiCa.
   */
  com.google.protobuf.ByteString getEtcdApiCaBytes();

  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd peer CA in this cluster.
   * </pre>
   *
   * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The etcdPeerCa.
   */
  java.lang.String getEtcdPeerCa();
  /**
   *
   *
   * <pre>
   * Resource path of the Certificate Authority Service caPool to use for the
   * etcd peer CA in this cluster.
   * </pre>
   *
   * <code>string etcd_peer_ca = 12 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for etcdPeerCa.
   */
  com.google.protobuf.ByteString getEtcdPeerCaBytes();

  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the serviceAccountSigningKeys.
   */
  java.util.List<java.lang.String> getServiceAccountSigningKeysList();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of serviceAccountSigningKeys.
   */
  int getServiceAccountSigningKeysCount();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The serviceAccountSigningKeys at the given index.
   */
  java.lang.String getServiceAccountSigningKeys(int index);
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_signing_keys = 13 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceAccountSigningKeys at the given index.
   */
  com.google.protobuf.ByteString getServiceAccountSigningKeysBytes(int index);

  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the serviceAccountVerificationKeys.
   */
  java.util.List<java.lang.String> getServiceAccountVerificationKeysList();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of serviceAccountVerificationKeys.
   */
  int getServiceAccountVerificationKeysCount();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The serviceAccountVerificationKeys at the given index.
   */
  java.lang.String getServiceAccountVerificationKeys(int index);
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
   * issued by this cluster.
   *
   * Format:
   * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
   * </pre>
   *
   * <code>
   * repeated string service_account_verification_keys = 14 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceAccountVerificationKeys at the given index.
   */
  com.google.protobuf.ByteString getServiceAccountVerificationKeysBytes(int index);

  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the aggregation CA in
   * this cluster.
   * </pre>
   *
   * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The aggregationCa.
   */
  java.lang.String getAggregationCa();
  /**
   *
   *
   * <pre>
   * The Certificate Authority Service caPool to use for the aggregation CA in
   * this cluster.
   * </pre>
   *
   * <code>string aggregation_ca = 15 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for aggregationCa.
   */
  com.google.protobuf.ByteString getAggregationCaBytes();

  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
   * plane nodes.
   * </pre>
   *
   * <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The controlPlaneDiskEncryptionKey.
   */
  java.lang.String getControlPlaneDiskEncryptionKey();
  /**
   *
   *
   * <pre>
   * The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
   * plane nodes.
   * </pre>
   *
   * <code>string control_plane_disk_encryption_key = 16 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for controlPlaneDiskEncryptionKey.
   */
  com.google.protobuf.ByteString getControlPlaneDiskEncryptionKeyBytes();

  /**
   *
   *
   * <pre>
   * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
   * etcd backups.
   * </pre>
   *
   * <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The gkeopsEtcdBackupEncryptionKey.
   */
  java.lang.String getGkeopsEtcdBackupEncryptionKey();
  /**
   *
   *
   * <pre>
   * Resource path of the Cloud KMS cryptoKey to use for encryption of internal
   * etcd backups.
   * </pre>
   *
   * <code>string gkeops_etcd_backup_encryption_key = 17 [(.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for gkeopsEtcdBackupEncryptionKey.
   */
  com.google.protobuf.ByteString getGkeopsEtcdBackupEncryptionKeyBytes();
}
