/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Settings for blue-green upgrade.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.BlueGreenSettings}
 */
public final class BlueGreenSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.BlueGreenSettings)
    BlueGreenSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BlueGreenSettings.newBuilder() to construct.
  private BlueGreenSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BlueGreenSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BlueGreenSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_BlueGreenSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_BlueGreenSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.BlueGreenSettings.class,
            com.google.container.v1beta1.BlueGreenSettings.Builder.class);
  }

  public interface StandardRolloutPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Percentage of the blue pool nodes to drain in a batch.
     * The range of this field should be (0.0, 1.0].
     * </pre>
     *
     * <code>float batch_percentage = 1;</code>
     *
     * @return Whether the batchPercentage field is set.
     */
    boolean hasBatchPercentage();
    /**
     *
     *
     * <pre>
     * Percentage of the blue pool nodes to drain in a batch.
     * The range of this field should be (0.0, 1.0].
     * </pre>
     *
     * <code>float batch_percentage = 1;</code>
     *
     * @return The batchPercentage.
     */
    float getBatchPercentage();

    /**
     *
     *
     * <pre>
     * Number of blue nodes to drain in a batch.
     * </pre>
     *
     * <code>int32 batch_node_count = 2;</code>
     *
     * @return Whether the batchNodeCount field is set.
     */
    boolean hasBatchNodeCount();
    /**
     *
     *
     * <pre>
     * Number of blue nodes to drain in a batch.
     * </pre>
     *
     * <code>int32 batch_node_count = 2;</code>
     *
     * @return The batchNodeCount.
     */
    int getBatchNodeCount();

    /**
     *
     *
     * <pre>
     * Soak time after each batch gets drained. Default to zero.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
     *
     * @return Whether the batchSoakDuration field is set.
     */
    boolean hasBatchSoakDuration();
    /**
     *
     *
     * <pre>
     * Soak time after each batch gets drained. Default to zero.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
     *
     * @return The batchSoakDuration.
     */
    com.google.protobuf.Duration getBatchSoakDuration();
    /**
     *
     *
     * <pre>
     * Soak time after each batch gets drained. Default to zero.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getBatchSoakDurationOrBuilder();

    com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.UpdateBatchSizeCase
        getUpdateBatchSizeCase();
  }
  /**
   *
   *
   * <pre>
   * Standard rollout policy is the default policy for blue-green.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy}
   */
  public static final class StandardRolloutPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
      StandardRolloutPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StandardRolloutPolicy.newBuilder() to construct.
    private StandardRolloutPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StandardRolloutPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StandardRolloutPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_StandardRolloutPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_StandardRolloutPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.class,
              com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder.class);
    }

    private int bitField0_;
    private int updateBatchSizeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object updateBatchSize_;

    public enum UpdateBatchSizeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      BATCH_PERCENTAGE(1),
      BATCH_NODE_COUNT(2),
      UPDATEBATCHSIZE_NOT_SET(0);
      private final int value;

      private UpdateBatchSizeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static UpdateBatchSizeCase valueOf(int value) {
        return forNumber(value);
      }

      public static UpdateBatchSizeCase forNumber(int value) {
        switch (value) {
          case 1:
            return BATCH_PERCENTAGE;
          case 2:
            return BATCH_NODE_COUNT;
          case 0:
            return UPDATEBATCHSIZE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public UpdateBatchSizeCase getUpdateBatchSizeCase() {
      return UpdateBatchSizeCase.forNumber(updateBatchSizeCase_);
    }

    public static final int BATCH_PERCENTAGE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Percentage of the blue pool nodes to drain in a batch.
     * The range of this field should be (0.0, 1.0].
     * </pre>
     *
     * <code>float batch_percentage = 1;</code>
     *
     * @return Whether the batchPercentage field is set.
     */
    @java.lang.Override
    public boolean hasBatchPercentage() {
      return updateBatchSizeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Percentage of the blue pool nodes to drain in a batch.
     * The range of this field should be (0.0, 1.0].
     * </pre>
     *
     * <code>float batch_percentage = 1;</code>
     *
     * @return The batchPercentage.
     */
    @java.lang.Override
    public float getBatchPercentage() {
      if (updateBatchSizeCase_ == 1) {
        return (java.lang.Float) updateBatchSize_;
      }
      return 0F;
    }

    public static final int BATCH_NODE_COUNT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Number of blue nodes to drain in a batch.
     * </pre>
     *
     * <code>int32 batch_node_count = 2;</code>
     *
     * @return Whether the batchNodeCount field is set.
     */
    @java.lang.Override
    public boolean hasBatchNodeCount() {
      return updateBatchSizeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Number of blue nodes to drain in a batch.
     * </pre>
     *
     * <code>int32 batch_node_count = 2;</code>
     *
     * @return The batchNodeCount.
     */
    @java.lang.Override
    public int getBatchNodeCount() {
      if (updateBatchSizeCase_ == 2) {
        return (java.lang.Integer) updateBatchSize_;
      }
      return 0;
    }

    public static final int BATCH_SOAK_DURATION_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration batchSoakDuration_;
    /**
     *
     *
     * <pre>
     * Soak time after each batch gets drained. Default to zero.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
     *
     * @return Whether the batchSoakDuration field is set.
     */
    @java.lang.Override
    public boolean hasBatchSoakDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Soak time after each batch gets drained. Default to zero.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
     *
     * @return The batchSoakDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getBatchSoakDuration() {
      return batchSoakDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : batchSoakDuration_;
    }
    /**
     *
     *
     * <pre>
     * Soak time after each batch gets drained. Default to zero.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getBatchSoakDurationOrBuilder() {
      return batchSoakDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : batchSoakDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (updateBatchSizeCase_ == 1) {
        output.writeFloat(1, (float) ((java.lang.Float) updateBatchSize_));
      }
      if (updateBatchSizeCase_ == 2) {
        output.writeInt32(2, (int) ((java.lang.Integer) updateBatchSize_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getBatchSoakDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (updateBatchSizeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                1, (float) ((java.lang.Float) updateBatchSize_));
      }
      if (updateBatchSizeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                2, (int) ((java.lang.Integer) updateBatchSize_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBatchSoakDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy other =
          (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy) obj;

      if (hasBatchSoakDuration() != other.hasBatchSoakDuration()) return false;
      if (hasBatchSoakDuration()) {
        if (!getBatchSoakDuration().equals(other.getBatchSoakDuration())) return false;
      }
      if (!getUpdateBatchSizeCase().equals(other.getUpdateBatchSizeCase())) return false;
      switch (updateBatchSizeCase_) {
        case 1:
          if (java.lang.Float.floatToIntBits(getBatchPercentage())
              != java.lang.Float.floatToIntBits(other.getBatchPercentage())) return false;
          break;
        case 2:
          if (getBatchNodeCount() != other.getBatchNodeCount()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBatchSoakDuration()) {
        hash = (37 * hash) + BATCH_SOAK_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getBatchSoakDuration().hashCode();
      }
      switch (updateBatchSizeCase_) {
        case 1:
          hash = (37 * hash) + BATCH_PERCENTAGE_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getBatchPercentage());
          break;
        case 2:
          hash = (37 * hash) + BATCH_NODE_COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getBatchNodeCount();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Standard rollout policy is the default policy for blue-green.
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_BlueGreenSettings_StandardRolloutPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_BlueGreenSettings_StandardRolloutPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.class,
                com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder.class);
      }

      // Construct using
      // com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBatchSoakDurationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        batchSoakDuration_ = null;
        if (batchSoakDurationBuilder_ != null) {
          batchSoakDurationBuilder_.dispose();
          batchSoakDurationBuilder_ = null;
        }
        updateBatchSizeCase_ = 0;
        updateBatchSize_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_BlueGreenSettings_StandardRolloutPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
          getDefaultInstanceForType() {
        return com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy build() {
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy buildPartial() {
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy result =
            new com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.batchSoakDuration_ =
              batchSoakDurationBuilder_ == null
                  ? batchSoakDuration_
                  : batchSoakDurationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy result) {
        result.updateBatchSizeCase_ = updateBatchSizeCase_;
        result.updateBatchSize_ = this.updateBatchSize_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy) {
          return mergeFrom(
              (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy other) {
        if (other
            == com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
                .getDefaultInstance()) return this;
        if (other.hasBatchSoakDuration()) {
          mergeBatchSoakDuration(other.getBatchSoakDuration());
        }
        switch (other.getUpdateBatchSizeCase()) {
          case BATCH_PERCENTAGE:
            {
              setBatchPercentage(other.getBatchPercentage());
              break;
            }
          case BATCH_NODE_COUNT:
            {
              setBatchNodeCount(other.getBatchNodeCount());
              break;
            }
          case UPDATEBATCHSIZE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  updateBatchSize_ = input.readFloat();
                  updateBatchSizeCase_ = 1;
                  break;
                } // case 13
              case 16:
                {
                  updateBatchSize_ = input.readInt32();
                  updateBatchSizeCase_ = 2;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getBatchSoakDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int updateBatchSizeCase_ = 0;
      private java.lang.Object updateBatchSize_;

      public UpdateBatchSizeCase getUpdateBatchSizeCase() {
        return UpdateBatchSizeCase.forNumber(updateBatchSizeCase_);
      }

      public Builder clearUpdateBatchSize() {
        updateBatchSizeCase_ = 0;
        updateBatchSize_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Percentage of the blue pool nodes to drain in a batch.
       * The range of this field should be (0.0, 1.0].
       * </pre>
       *
       * <code>float batch_percentage = 1;</code>
       *
       * @return Whether the batchPercentage field is set.
       */
      public boolean hasBatchPercentage() {
        return updateBatchSizeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Percentage of the blue pool nodes to drain in a batch.
       * The range of this field should be (0.0, 1.0].
       * </pre>
       *
       * <code>float batch_percentage = 1;</code>
       *
       * @return The batchPercentage.
       */
      public float getBatchPercentage() {
        if (updateBatchSizeCase_ == 1) {
          return (java.lang.Float) updateBatchSize_;
        }
        return 0F;
      }
      /**
       *
       *
       * <pre>
       * Percentage of the blue pool nodes to drain in a batch.
       * The range of this field should be (0.0, 1.0].
       * </pre>
       *
       * <code>float batch_percentage = 1;</code>
       *
       * @param value The batchPercentage to set.
       * @return This builder for chaining.
       */
      public Builder setBatchPercentage(float value) {

        updateBatchSizeCase_ = 1;
        updateBatchSize_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Percentage of the blue pool nodes to drain in a batch.
       * The range of this field should be (0.0, 1.0].
       * </pre>
       *
       * <code>float batch_percentage = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBatchPercentage() {
        if (updateBatchSizeCase_ == 1) {
          updateBatchSizeCase_ = 0;
          updateBatchSize_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Number of blue nodes to drain in a batch.
       * </pre>
       *
       * <code>int32 batch_node_count = 2;</code>
       *
       * @return Whether the batchNodeCount field is set.
       */
      public boolean hasBatchNodeCount() {
        return updateBatchSizeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Number of blue nodes to drain in a batch.
       * </pre>
       *
       * <code>int32 batch_node_count = 2;</code>
       *
       * @return The batchNodeCount.
       */
      public int getBatchNodeCount() {
        if (updateBatchSizeCase_ == 2) {
          return (java.lang.Integer) updateBatchSize_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Number of blue nodes to drain in a batch.
       * </pre>
       *
       * <code>int32 batch_node_count = 2;</code>
       *
       * @param value The batchNodeCount to set.
       * @return This builder for chaining.
       */
      public Builder setBatchNodeCount(int value) {

        updateBatchSizeCase_ = 2;
        updateBatchSize_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of blue nodes to drain in a batch.
       * </pre>
       *
       * <code>int32 batch_node_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBatchNodeCount() {
        if (updateBatchSizeCase_ == 2) {
          updateBatchSizeCase_ = 0;
          updateBatchSize_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.Duration batchSoakDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          batchSoakDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       *
       * @return Whether the batchSoakDuration field is set.
       */
      public boolean hasBatchSoakDuration() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       *
       * @return The batchSoakDuration.
       */
      public com.google.protobuf.Duration getBatchSoakDuration() {
        if (batchSoakDurationBuilder_ == null) {
          return batchSoakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : batchSoakDuration_;
        } else {
          return batchSoakDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      public Builder setBatchSoakDuration(com.google.protobuf.Duration value) {
        if (batchSoakDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          batchSoakDuration_ = value;
        } else {
          batchSoakDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      public Builder setBatchSoakDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (batchSoakDurationBuilder_ == null) {
          batchSoakDuration_ = builderForValue.build();
        } else {
          batchSoakDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      public Builder mergeBatchSoakDuration(com.google.protobuf.Duration value) {
        if (batchSoakDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && batchSoakDuration_ != null
              && batchSoakDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getBatchSoakDurationBuilder().mergeFrom(value);
          } else {
            batchSoakDuration_ = value;
          }
        } else {
          batchSoakDurationBuilder_.mergeFrom(value);
        }
        if (batchSoakDuration_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      public Builder clearBatchSoakDuration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        batchSoakDuration_ = null;
        if (batchSoakDurationBuilder_ != null) {
          batchSoakDurationBuilder_.dispose();
          batchSoakDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getBatchSoakDurationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getBatchSoakDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      public com.google.protobuf.DurationOrBuilder getBatchSoakDurationOrBuilder() {
        if (batchSoakDurationBuilder_ != null) {
          return batchSoakDurationBuilder_.getMessageOrBuilder();
        } else {
          return batchSoakDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : batchSoakDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Soak time after each batch gets drained. Default to zero.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration batch_soak_duration = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getBatchSoakDurationFieldBuilder() {
        if (batchSoakDurationBuilder_ == null) {
          batchSoakDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getBatchSoakDuration(), getParentForChildren(), isClean());
          batchSoakDuration_ = null;
        }
        return batchSoakDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
    private static final com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy();
    }

    public static com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StandardRolloutPolicy> PARSER =
        new com.google.protobuf.AbstractParser<StandardRolloutPolicy>() {
          @java.lang.Override
          public StandardRolloutPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StandardRolloutPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StandardRolloutPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AutoscaledRolloutPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Autoscaled rollout policy uses cluster autoscaler during
   * blue-green upgrades to scale both the green and blue pools.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy}
   */
  public static final class AutoscaledRolloutPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
      AutoscaledRolloutPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AutoscaledRolloutPolicy.newBuilder() to construct.
    private AutoscaledRolloutPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutoscaledRolloutPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutoscaledRolloutPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_AutoscaledRolloutPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_AutoscaledRolloutPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.class,
              com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy other =
          (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Autoscaled rollout policy uses cluster autoscaler during
     * blue-green upgrades to scale both the green and blue pools.
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_BlueGreenSettings_AutoscaledRolloutPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_BlueGreenSettings_AutoscaledRolloutPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.class,
                com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_BlueGreenSettings_AutoscaledRolloutPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
          getDefaultInstanceForType() {
        return com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy build() {
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy buildPartial() {
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy result =
            new com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy) {
          return mergeFrom(
              (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy other) {
        if (other
            == com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
    private static final com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy();
    }

    public static com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutoscaledRolloutPolicy> PARSER =
        new com.google.protobuf.AbstractParser<AutoscaledRolloutPolicy>() {
          @java.lang.Override
          public AutoscaledRolloutPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutoscaledRolloutPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutoscaledRolloutPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int rolloutPolicyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object rolloutPolicy_;

  public enum RolloutPolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STANDARD_ROLLOUT_POLICY(1),
    AUTOSCALED_ROLLOUT_POLICY(3),
    ROLLOUTPOLICY_NOT_SET(0);
    private final int value;

    private RolloutPolicyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RolloutPolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static RolloutPolicyCase forNumber(int value) {
      switch (value) {
        case 1:
          return STANDARD_ROLLOUT_POLICY;
        case 3:
          return AUTOSCALED_ROLLOUT_POLICY;
        case 0:
          return ROLLOUTPOLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RolloutPolicyCase getRolloutPolicyCase() {
    return RolloutPolicyCase.forNumber(rolloutPolicyCase_);
  }

  public static final int STANDARD_ROLLOUT_POLICY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Standard policy for the blue-green upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
   * </code>
   *
   * @return Whether the standardRolloutPolicy field is set.
   */
  @java.lang.Override
  public boolean hasStandardRolloutPolicy() {
    return rolloutPolicyCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Standard policy for the blue-green upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
   * </code>
   *
   * @return The standardRolloutPolicy.
   */
  @java.lang.Override
  public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
      getStandardRolloutPolicy() {
    if (rolloutPolicyCase_ == 1) {
      return (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy) rolloutPolicy_;
    }
    return com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Standard policy for the blue-green upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicyOrBuilder
      getStandardRolloutPolicyOrBuilder() {
    if (rolloutPolicyCase_ == 1) {
      return (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy) rolloutPolicy_;
    }
    return com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        .getDefaultInstance();
  }

  public static final int AUTOSCALED_ROLLOUT_POLICY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
   * </code>
   *
   * @return Whether the autoscaledRolloutPolicy field is set.
   */
  @java.lang.Override
  public boolean hasAutoscaledRolloutPolicy() {
    return rolloutPolicyCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
   * </code>
   *
   * @return The autoscaledRolloutPolicy.
   */
  @java.lang.Override
  public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
      getAutoscaledRolloutPolicy() {
    if (rolloutPolicyCase_ == 3) {
      return (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
          rolloutPolicy_;
    }
    return com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicyOrBuilder
      getAutoscaledRolloutPolicyOrBuilder() {
    if (rolloutPolicyCase_ == 3) {
      return (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
          rolloutPolicy_;
    }
    return com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        .getDefaultInstance();
  }

  public static final int NODE_POOL_SOAK_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration nodePoolSoakDuration_;
  /**
   *
   *
   * <pre>
   * Time needed after draining entire blue pool. After this period, blue pool
   * will be cleaned up.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
   *
   * @return Whether the nodePoolSoakDuration field is set.
   */
  @java.lang.Override
  public boolean hasNodePoolSoakDuration() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time needed after draining entire blue pool. After this period, blue pool
   * will be cleaned up.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
   *
   * @return The nodePoolSoakDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getNodePoolSoakDuration() {
    return nodePoolSoakDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : nodePoolSoakDuration_;
  }
  /**
   *
   *
   * <pre>
   * Time needed after draining entire blue pool. After this period, blue pool
   * will be cleaned up.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getNodePoolSoakDurationOrBuilder() {
    return nodePoolSoakDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : nodePoolSoakDuration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (rolloutPolicyCase_ == 1) {
      output.writeMessage(
          1, (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy) rolloutPolicy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getNodePoolSoakDuration());
    }
    if (rolloutPolicyCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy) rolloutPolicy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (rolloutPolicyCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
                  rolloutPolicy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getNodePoolSoakDuration());
    }
    if (rolloutPolicyCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
                  rolloutPolicy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.BlueGreenSettings)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.BlueGreenSettings other =
        (com.google.container.v1beta1.BlueGreenSettings) obj;

    if (hasNodePoolSoakDuration() != other.hasNodePoolSoakDuration()) return false;
    if (hasNodePoolSoakDuration()) {
      if (!getNodePoolSoakDuration().equals(other.getNodePoolSoakDuration())) return false;
    }
    if (!getRolloutPolicyCase().equals(other.getRolloutPolicyCase())) return false;
    switch (rolloutPolicyCase_) {
      case 1:
        if (!getStandardRolloutPolicy().equals(other.getStandardRolloutPolicy())) return false;
        break;
      case 3:
        if (!getAutoscaledRolloutPolicy().equals(other.getAutoscaledRolloutPolicy())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNodePoolSoakDuration()) {
      hash = (37 * hash) + NODE_POOL_SOAK_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolSoakDuration().hashCode();
    }
    switch (rolloutPolicyCase_) {
      case 1:
        hash = (37 * hash) + STANDARD_ROLLOUT_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getStandardRolloutPolicy().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AUTOSCALED_ROLLOUT_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getAutoscaledRolloutPolicy().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.BlueGreenSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.BlueGreenSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for blue-green upgrade.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.BlueGreenSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.BlueGreenSettings)
      com.google.container.v1beta1.BlueGreenSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.BlueGreenSettings.class,
              com.google.container.v1beta1.BlueGreenSettings.Builder.class);
    }

    // Construct using com.google.container.v1beta1.BlueGreenSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNodePoolSoakDurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (standardRolloutPolicyBuilder_ != null) {
        standardRolloutPolicyBuilder_.clear();
      }
      if (autoscaledRolloutPolicyBuilder_ != null) {
        autoscaledRolloutPolicyBuilder_.clear();
      }
      nodePoolSoakDuration_ = null;
      if (nodePoolSoakDurationBuilder_ != null) {
        nodePoolSoakDurationBuilder_.dispose();
        nodePoolSoakDurationBuilder_ = null;
      }
      rolloutPolicyCase_ = 0;
      rolloutPolicy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_BlueGreenSettings_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings getDefaultInstanceForType() {
      return com.google.container.v1beta1.BlueGreenSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings build() {
      com.google.container.v1beta1.BlueGreenSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings buildPartial() {
      com.google.container.v1beta1.BlueGreenSettings result =
          new com.google.container.v1beta1.BlueGreenSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.BlueGreenSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nodePoolSoakDuration_ =
            nodePoolSoakDurationBuilder_ == null
                ? nodePoolSoakDuration_
                : nodePoolSoakDurationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.container.v1beta1.BlueGreenSettings result) {
      result.rolloutPolicyCase_ = rolloutPolicyCase_;
      result.rolloutPolicy_ = this.rolloutPolicy_;
      if (rolloutPolicyCase_ == 1 && standardRolloutPolicyBuilder_ != null) {
        result.rolloutPolicy_ = standardRolloutPolicyBuilder_.build();
      }
      if (rolloutPolicyCase_ == 3 && autoscaledRolloutPolicyBuilder_ != null) {
        result.rolloutPolicy_ = autoscaledRolloutPolicyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.BlueGreenSettings) {
        return mergeFrom((com.google.container.v1beta1.BlueGreenSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.BlueGreenSettings other) {
      if (other == com.google.container.v1beta1.BlueGreenSettings.getDefaultInstance()) return this;
      if (other.hasNodePoolSoakDuration()) {
        mergeNodePoolSoakDuration(other.getNodePoolSoakDuration());
      }
      switch (other.getRolloutPolicyCase()) {
        case STANDARD_ROLLOUT_POLICY:
          {
            mergeStandardRolloutPolicy(other.getStandardRolloutPolicy());
            break;
          }
        case AUTOSCALED_ROLLOUT_POLICY:
          {
            mergeAutoscaledRolloutPolicy(other.getAutoscaledRolloutPolicy());
            break;
          }
        case ROLLOUTPOLICY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getStandardRolloutPolicyFieldBuilder().getBuilder(), extensionRegistry);
                rolloutPolicyCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getNodePoolSoakDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAutoscaledRolloutPolicyFieldBuilder().getBuilder(), extensionRegistry);
                rolloutPolicyCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int rolloutPolicyCase_ = 0;
    private java.lang.Object rolloutPolicy_;

    public RolloutPolicyCase getRolloutPolicyCase() {
      return RolloutPolicyCase.forNumber(rolloutPolicyCase_);
    }

    public Builder clearRolloutPolicy() {
      rolloutPolicyCase_ = 0;
      rolloutPolicy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy,
            com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder,
            com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicyOrBuilder>
        standardRolloutPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     *
     * @return Whether the standardRolloutPolicy field is set.
     */
    @java.lang.Override
    public boolean hasStandardRolloutPolicy() {
      return rolloutPolicyCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     *
     * @return The standardRolloutPolicy.
     */
    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
        getStandardRolloutPolicy() {
      if (standardRolloutPolicyBuilder_ == null) {
        if (rolloutPolicyCase_ == 1) {
          return (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
              rolloutPolicy_;
        }
        return com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
            .getDefaultInstance();
      } else {
        if (rolloutPolicyCase_ == 1) {
          return standardRolloutPolicyBuilder_.getMessage();
        }
        return com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    public Builder setStandardRolloutPolicy(
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy value) {
      if (standardRolloutPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rolloutPolicy_ = value;
        onChanged();
      } else {
        standardRolloutPolicyBuilder_.setMessage(value);
      }
      rolloutPolicyCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    public Builder setStandardRolloutPolicy(
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder
            builderForValue) {
      if (standardRolloutPolicyBuilder_ == null) {
        rolloutPolicy_ = builderForValue.build();
        onChanged();
      } else {
        standardRolloutPolicyBuilder_.setMessage(builderForValue.build());
      }
      rolloutPolicyCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    public Builder mergeStandardRolloutPolicy(
        com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy value) {
      if (standardRolloutPolicyBuilder_ == null) {
        if (rolloutPolicyCase_ == 1
            && rolloutPolicy_
                != com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
                    .getDefaultInstance()) {
          rolloutPolicy_ =
              com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.newBuilder(
                      (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
                          rolloutPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rolloutPolicy_ = value;
        }
        onChanged();
      } else {
        if (rolloutPolicyCase_ == 1) {
          standardRolloutPolicyBuilder_.mergeFrom(value);
        } else {
          standardRolloutPolicyBuilder_.setMessage(value);
        }
      }
      rolloutPolicyCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    public Builder clearStandardRolloutPolicy() {
      if (standardRolloutPolicyBuilder_ == null) {
        if (rolloutPolicyCase_ == 1) {
          rolloutPolicyCase_ = 0;
          rolloutPolicy_ = null;
          onChanged();
        }
      } else {
        if (rolloutPolicyCase_ == 1) {
          rolloutPolicyCase_ = 0;
          rolloutPolicy_ = null;
        }
        standardRolloutPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder
        getStandardRolloutPolicyBuilder() {
      return getStandardRolloutPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicyOrBuilder
        getStandardRolloutPolicyOrBuilder() {
      if ((rolloutPolicyCase_ == 1) && (standardRolloutPolicyBuilder_ != null)) {
        return standardRolloutPolicyBuilder_.getMessageOrBuilder();
      } else {
        if (rolloutPolicyCase_ == 1) {
          return (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
              rolloutPolicy_;
        }
        return com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Standard policy for the blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy standard_rollout_policy = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy,
            com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder,
            com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicyOrBuilder>
        getStandardRolloutPolicyFieldBuilder() {
      if (standardRolloutPolicyBuilder_ == null) {
        if (!(rolloutPolicyCase_ == 1)) {
          rolloutPolicy_ =
              com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy
                  .getDefaultInstance();
        }
        standardRolloutPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy,
                com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy.Builder,
                com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicyOrBuilder>(
                (com.google.container.v1beta1.BlueGreenSettings.StandardRolloutPolicy)
                    rolloutPolicy_,
                getParentForChildren(),
                isClean());
        rolloutPolicy_ = null;
      }
      rolloutPolicyCase_ = 1;
      onChanged();
      return standardRolloutPolicyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy,
            com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder,
            com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicyOrBuilder>
        autoscaledRolloutPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     *
     * @return Whether the autoscaledRolloutPolicy field is set.
     */
    @java.lang.Override
    public boolean hasAutoscaledRolloutPolicy() {
      return rolloutPolicyCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     *
     * @return The autoscaledRolloutPolicy.
     */
    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
        getAutoscaledRolloutPolicy() {
      if (autoscaledRolloutPolicyBuilder_ == null) {
        if (rolloutPolicyCase_ == 3) {
          return (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
              rolloutPolicy_;
        }
        return com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
            .getDefaultInstance();
      } else {
        if (rolloutPolicyCase_ == 3) {
          return autoscaledRolloutPolicyBuilder_.getMessage();
        }
        return com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    public Builder setAutoscaledRolloutPolicy(
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy value) {
      if (autoscaledRolloutPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rolloutPolicy_ = value;
        onChanged();
      } else {
        autoscaledRolloutPolicyBuilder_.setMessage(value);
      }
      rolloutPolicyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    public Builder setAutoscaledRolloutPolicy(
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder
            builderForValue) {
      if (autoscaledRolloutPolicyBuilder_ == null) {
        rolloutPolicy_ = builderForValue.build();
        onChanged();
      } else {
        autoscaledRolloutPolicyBuilder_.setMessage(builderForValue.build());
      }
      rolloutPolicyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    public Builder mergeAutoscaledRolloutPolicy(
        com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy value) {
      if (autoscaledRolloutPolicyBuilder_ == null) {
        if (rolloutPolicyCase_ == 3
            && rolloutPolicy_
                != com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
                    .getDefaultInstance()) {
          rolloutPolicy_ =
              com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.newBuilder(
                      (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
                          rolloutPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rolloutPolicy_ = value;
        }
        onChanged();
      } else {
        if (rolloutPolicyCase_ == 3) {
          autoscaledRolloutPolicyBuilder_.mergeFrom(value);
        } else {
          autoscaledRolloutPolicyBuilder_.setMessage(value);
        }
      }
      rolloutPolicyCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    public Builder clearAutoscaledRolloutPolicy() {
      if (autoscaledRolloutPolicyBuilder_ == null) {
        if (rolloutPolicyCase_ == 3) {
          rolloutPolicyCase_ = 0;
          rolloutPolicy_ = null;
          onChanged();
        }
      } else {
        if (rolloutPolicyCase_ == 3) {
          rolloutPolicyCase_ = 0;
          rolloutPolicy_ = null;
        }
        autoscaledRolloutPolicyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder
        getAutoscaledRolloutPolicyBuilder() {
      return getAutoscaledRolloutPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicyOrBuilder
        getAutoscaledRolloutPolicyOrBuilder() {
      if ((rolloutPolicyCase_ == 3) && (autoscaledRolloutPolicyBuilder_ != null)) {
        return autoscaledRolloutPolicyBuilder_.getMessageOrBuilder();
      } else {
        if (rolloutPolicyCase_ == 3) {
          return (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
              rolloutPolicy_;
        }
        return com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Autoscaled policy for cluster autoscaler enabled blue-green upgrade.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy autoscaled_rollout_policy = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy,
            com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder,
            com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicyOrBuilder>
        getAutoscaledRolloutPolicyFieldBuilder() {
      if (autoscaledRolloutPolicyBuilder_ == null) {
        if (!(rolloutPolicyCase_ == 3)) {
          rolloutPolicy_ =
              com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy
                  .getDefaultInstance();
        }
        autoscaledRolloutPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy,
                com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy.Builder,
                com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicyOrBuilder>(
                (com.google.container.v1beta1.BlueGreenSettings.AutoscaledRolloutPolicy)
                    rolloutPolicy_,
                getParentForChildren(),
                isClean());
        rolloutPolicy_ = null;
      }
      rolloutPolicyCase_ = 3;
      onChanged();
      return autoscaledRolloutPolicyBuilder_;
    }

    private com.google.protobuf.Duration nodePoolSoakDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        nodePoolSoakDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     *
     * @return Whether the nodePoolSoakDuration field is set.
     */
    public boolean hasNodePoolSoakDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     *
     * @return The nodePoolSoakDuration.
     */
    public com.google.protobuf.Duration getNodePoolSoakDuration() {
      if (nodePoolSoakDurationBuilder_ == null) {
        return nodePoolSoakDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : nodePoolSoakDuration_;
      } else {
        return nodePoolSoakDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    public Builder setNodePoolSoakDuration(com.google.protobuf.Duration value) {
      if (nodePoolSoakDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodePoolSoakDuration_ = value;
      } else {
        nodePoolSoakDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    public Builder setNodePoolSoakDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (nodePoolSoakDurationBuilder_ == null) {
        nodePoolSoakDuration_ = builderForValue.build();
      } else {
        nodePoolSoakDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    public Builder mergeNodePoolSoakDuration(com.google.protobuf.Duration value) {
      if (nodePoolSoakDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && nodePoolSoakDuration_ != null
            && nodePoolSoakDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getNodePoolSoakDurationBuilder().mergeFrom(value);
        } else {
          nodePoolSoakDuration_ = value;
        }
      } else {
        nodePoolSoakDurationBuilder_.mergeFrom(value);
      }
      if (nodePoolSoakDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    public Builder clearNodePoolSoakDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      nodePoolSoakDuration_ = null;
      if (nodePoolSoakDurationBuilder_ != null) {
        nodePoolSoakDurationBuilder_.dispose();
        nodePoolSoakDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getNodePoolSoakDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getNodePoolSoakDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getNodePoolSoakDurationOrBuilder() {
      if (nodePoolSoakDurationBuilder_ != null) {
        return nodePoolSoakDurationBuilder_.getMessageOrBuilder();
      } else {
        return nodePoolSoakDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : nodePoolSoakDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time needed after draining entire blue pool. After this period, blue pool
     * will be cleaned up.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration node_pool_soak_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getNodePoolSoakDurationFieldBuilder() {
      if (nodePoolSoakDurationBuilder_ == null) {
        nodePoolSoakDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getNodePoolSoakDuration(), getParentForChildren(), isClean());
        nodePoolSoakDuration_ = null;
      }
      return nodePoolSoakDurationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.BlueGreenSettings)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.BlueGreenSettings)
  private static final com.google.container.v1beta1.BlueGreenSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.BlueGreenSettings();
  }

  public static com.google.container.v1beta1.BlueGreenSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BlueGreenSettings> PARSER =
      new com.google.protobuf.AbstractParser<BlueGreenSettings>() {
        @java.lang.Override
        public BlueGreenSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BlueGreenSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BlueGreenSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.BlueGreenSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
