/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * NetworkConfig reports the relative names of network &amp; subnetwork.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.NetworkConfig}
 */
public final class NetworkConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.NetworkConfig)
    NetworkConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkConfig.newBuilder() to construct.
  private NetworkConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkConfig() {
    network_ = "";
    subnetwork_ = "";
    datapathProvider_ = 0;
    privateIpv6GoogleAccess_ = 0;
    inTransitEncryptionConfig_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NetworkConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NetworkConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.NetworkConfig.class,
            com.google.container.v1beta1.NetworkConfig.Builder.class);
  }

  public interface ClusterNetworkPerformanceConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return Whether the totalEgressBandwidthTier field is set.
     */
    boolean hasTotalEgressBandwidthTier();
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for totalEgressBandwidthTier.
     */
    int getTotalEgressBandwidthTierValue();
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The totalEgressBandwidthTier.
     */
    com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier
        getTotalEgressBandwidthTier();
  }
  /**
   *
   *
   * <pre>
   * Configuration of all network bandwidth tiers
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig}
   */
  public static final class ClusterNetworkPerformanceConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig)
      ClusterNetworkPerformanceConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClusterNetworkPerformanceConfig.newBuilder() to construct.
    private ClusterNetworkPerformanceConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterNetworkPerformanceConfig() {
      totalEgressBandwidthTier_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterNetworkPerformanceConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NetworkConfig_ClusterNetworkPerformanceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NetworkConfig_ClusterNetworkPerformanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.class,
              com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Node network tier
     * </pre>
     *
     * Protobuf enum {@code
     * google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier}
     */
    public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value
       * </pre>
       *
       * <code>TIER_UNSPECIFIED = 0;</code>
       */
      TIER_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Higher bandwidth, actual values based on VM size.
       * </pre>
       *
       * <code>TIER_1 = 1;</code>
       */
      TIER_1(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value
       * </pre>
       *
       * <code>TIER_UNSPECIFIED = 0;</code>
       */
      public static final int TIER_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Higher bandwidth, actual values based on VM size.
       * </pre>
       *
       * <code>TIER_1 = 1;</code>
       */
      public static final int TIER_1_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Tier valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Tier forNumber(int value) {
        switch (value) {
          case 0:
            return TIER_UNSPECIFIED;
          case 1:
            return TIER_1;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
            public Tier findValueByNumber(int number) {
              return Tier.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Tier[] VALUES = values();

      public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Tier(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier)
    }

    private int bitField0_;
    public static final int TOTAL_EGRESS_BANDWIDTH_TIER_FIELD_NUMBER = 1;
    private int totalEgressBandwidthTier_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return Whether the totalEgressBandwidthTier field is set.
     */
    @java.lang.Override
    public boolean hasTotalEgressBandwidthTier() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for totalEgressBandwidthTier.
     */
    @java.lang.Override
    public int getTotalEgressBandwidthTierValue() {
      return totalEgressBandwidthTier_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The totalEgressBandwidthTier.
     */
    @java.lang.Override
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier
        getTotalEgressBandwidthTier() {
      com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier result =
          com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier.forNumber(
              totalEgressBandwidthTier_);
      return result == null
          ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, totalEgressBandwidthTier_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, totalEgressBandwidthTier_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig other =
          (com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig) obj;

      if (hasTotalEgressBandwidthTier() != other.hasTotalEgressBandwidthTier()) return false;
      if (hasTotalEgressBandwidthTier()) {
        if (totalEgressBandwidthTier_ != other.totalEgressBandwidthTier_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTotalEgressBandwidthTier()) {
        hash = (37 * hash) + TOTAL_EGRESS_BANDWIDTH_TIER_FIELD_NUMBER;
        hash = (53 * hash) + totalEgressBandwidthTier_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of all network bandwidth tiers
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig)
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NetworkConfig_ClusterNetworkPerformanceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NetworkConfig_ClusterNetworkPerformanceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.class,
                com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        totalEgressBandwidthTier_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NetworkConfig_ClusterNetworkPerformanceConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
          getDefaultInstanceForType() {
        return com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig build() {
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
          buildPartial() {
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig result =
            new com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.totalEgressBandwidthTier_ = totalEgressBandwidthTier_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig) {
          return mergeFrom(
              (com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig other) {
        if (other
            == com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                .getDefaultInstance()) return this;
        if (other.hasTotalEgressBandwidthTier()) {
          setTotalEgressBandwidthTier(other.getTotalEgressBandwidthTier());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  totalEgressBandwidthTier_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int totalEgressBandwidthTier_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return Whether the totalEgressBandwidthTier field is set.
       */
      @java.lang.Override
      public boolean hasTotalEgressBandwidthTier() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for totalEgressBandwidthTier.
       */
      @java.lang.Override
      public int getTotalEgressBandwidthTierValue() {
        return totalEgressBandwidthTier_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for totalEgressBandwidthTier to set.
       * @return This builder for chaining.
       */
      public Builder setTotalEgressBandwidthTierValue(int value) {
        totalEgressBandwidthTier_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return The totalEgressBandwidthTier.
       */
      @java.lang.Override
      public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier
          getTotalEgressBandwidthTier() {
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier result =
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier
                .forNumber(totalEgressBandwidthTier_);
        return result == null
            ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @param value The totalEgressBandwidthTier to set.
       * @return This builder for chaining.
       */
      public Builder setTotalEgressBandwidthTier(
          com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        totalEgressBandwidthTier_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalEgressBandwidthTier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        totalEgressBandwidthTier_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig)
    private static final com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig();
    }

    public static com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterNetworkPerformanceConfig> PARSER =
        new com.google.protobuf.AbstractParser<ClusterNetworkPerformanceConfig>() {
          @java.lang.Override
          public ClusterNetworkPerformanceConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClusterNetworkPerformanceConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterNetworkPerformanceConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NETWORK_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The relative name of the Google Compute Engine
   * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. Example:
   * projects/my-project/global/networks/my-network
   * </pre>
   *
   * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The relative name of the Google Compute Engine
   * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. Example:
   * projects/my-project/global/networks/my-network
   * </pre>
   *
   * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The relative name of the Google Compute Engine
   * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
   * cluster is connected. Example:
   * projects/my-project/regions/us-central1/subnetworks/my-subnet
   * </pre>
   *
   * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The relative name of the Google Compute Engine
   * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
   * cluster is connected. Example:
   * projects/my-project/regions/us-central1/subnetworks/my-subnet
   * </pre>
   *
   * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_INTRA_NODE_VISIBILITY_FIELD_NUMBER = 5;
  private boolean enableIntraNodeVisibility_ = false;
  /**
   *
   *
   * <pre>
   * Whether Intra-node visibility is enabled for this cluster.
   * This makes same node pod to pod traffic visible for VPC network.
   * </pre>
   *
   * <code>bool enable_intra_node_visibility = 5;</code>
   *
   * @return The enableIntraNodeVisibility.
   */
  @java.lang.Override
  public boolean getEnableIntraNodeVisibility() {
    return enableIntraNodeVisibility_;
  }

  public static final int DEFAULT_SNAT_STATUS_FIELD_NUMBER = 7;
  private com.google.container.v1beta1.DefaultSnatStatus defaultSnatStatus_;
  /**
   *
   *
   * <pre>
   * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
   * will be disabled when default_snat_status is disabled. When disabled is set
   * to false, default IP masquerade rules will be applied to the nodes to
   * prevent sNAT on cluster internal traffic.
   * </pre>
   *
   * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
   *
   * @return Whether the defaultSnatStatus field is set.
   */
  @java.lang.Override
  public boolean hasDefaultSnatStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
   * will be disabled when default_snat_status is disabled. When disabled is set
   * to false, default IP masquerade rules will be applied to the nodes to
   * prevent sNAT on cluster internal traffic.
   * </pre>
   *
   * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
   *
   * @return The defaultSnatStatus.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DefaultSnatStatus getDefaultSnatStatus() {
    return defaultSnatStatus_ == null
        ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
        : defaultSnatStatus_;
  }
  /**
   *
   *
   * <pre>
   * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
   * will be disabled when default_snat_status is disabled. When disabled is set
   * to false, default IP masquerade rules will be applied to the nodes to
   * prevent sNAT on cluster internal traffic.
   * </pre>
   *
   * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.DefaultSnatStatusOrBuilder getDefaultSnatStatusOrBuilder() {
    return defaultSnatStatus_ == null
        ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
        : defaultSnatStatus_;
  }

  public static final int ENABLE_L4ILB_SUBSETTING_FIELD_NUMBER = 10;
  private boolean enableL4IlbSubsetting_ = false;
  /**
   *
   *
   * <pre>
   * Whether L4ILB Subsetting is enabled for this cluster.
   * </pre>
   *
   * <code>bool enable_l4ilb_subsetting = 10;</code>
   *
   * @return The enableL4ilbSubsetting.
   */
  @java.lang.Override
  public boolean getEnableL4IlbSubsetting() {
    return enableL4IlbSubsetting_;
  }

  public static final int DATAPATH_PROVIDER_FIELD_NUMBER = 11;
  private int datapathProvider_ = 0;
  /**
   *
   *
   * <pre>
   * The desired datapath provider for this cluster. By default, uses the
   * IPTables-based kube-proxy implementation.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
   *
   * @return The enum numeric value on the wire for datapathProvider.
   */
  @java.lang.Override
  public int getDatapathProviderValue() {
    return datapathProvider_;
  }
  /**
   *
   *
   * <pre>
   * The desired datapath provider for this cluster. By default, uses the
   * IPTables-based kube-proxy implementation.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
   *
   * @return The datapathProvider.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DatapathProvider getDatapathProvider() {
    com.google.container.v1beta1.DatapathProvider result =
        com.google.container.v1beta1.DatapathProvider.forNumber(datapathProvider_);
    return result == null ? com.google.container.v1beta1.DatapathProvider.UNRECOGNIZED : result;
  }

  public static final int PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER = 12;
  private int privateIpv6GoogleAccess_ = 0;
  /**
   *
   *
   * <pre>
   * The desired state of IPv6 connectivity to Google Services.
   * By default, no private IPv6 access to or from Google Services (all access
   * will be via IPv4)
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;</code>
   *
   * @return The enum numeric value on the wire for privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public int getPrivateIpv6GoogleAccessValue() {
    return privateIpv6GoogleAccess_;
  }
  /**
   *
   *
   * <pre>
   * The desired state of IPv6 connectivity to Google Services.
   * By default, no private IPv6 access to or from Google Services (all access
   * will be via IPv4)
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;</code>
   *
   * @return The privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public com.google.container.v1beta1.PrivateIPv6GoogleAccess getPrivateIpv6GoogleAccess() {
    com.google.container.v1beta1.PrivateIPv6GoogleAccess result =
        com.google.container.v1beta1.PrivateIPv6GoogleAccess.forNumber(privateIpv6GoogleAccess_);
    return result == null
        ? com.google.container.v1beta1.PrivateIPv6GoogleAccess.UNRECOGNIZED
        : result;
  }

  public static final int DNS_CONFIG_FIELD_NUMBER = 13;
  private com.google.container.v1beta1.DNSConfig dnsConfig_;
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
   *
   * @return Whether the dnsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDnsConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
   *
   * @return The dnsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DNSConfig getDnsConfig() {
    return dnsConfig_ == null
        ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
        : dnsConfig_;
  }
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.DNSConfigOrBuilder getDnsConfigOrBuilder() {
    return dnsConfig_ == null
        ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
        : dnsConfig_;
  }

  public static final int SERVICE_EXTERNAL_IPS_CONFIG_FIELD_NUMBER = 15;
  private com.google.container.v1beta1.ServiceExternalIPsConfig serviceExternalIpsConfig_;
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies if services with externalIPs field are
   * blocked or not.
   * </pre>
   *
   * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
   * </code>
   *
   * @return Whether the serviceExternalIpsConfig field is set.
   */
  @java.lang.Override
  public boolean hasServiceExternalIpsConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies if services with externalIPs field are
   * blocked or not.
   * </pre>
   *
   * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
   * </code>
   *
   * @return The serviceExternalIpsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ServiceExternalIPsConfig getServiceExternalIpsConfig() {
    return serviceExternalIpsConfig_ == null
        ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
        : serviceExternalIpsConfig_;
  }
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies if services with externalIPs field are
   * blocked or not.
   * </pre>
   *
   * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder
      getServiceExternalIpsConfigOrBuilder() {
    return serviceExternalIpsConfig_ == null
        ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
        : serviceExternalIpsConfig_;
  }

  public static final int GATEWAY_API_CONFIG_FIELD_NUMBER = 16;
  private com.google.container.v1beta1.GatewayAPIConfig gatewayApiConfig_;
  /**
   *
   *
   * <pre>
   * GatewayAPIConfig contains the desired config of Gateway API on this
   * cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
   *
   * @return Whether the gatewayApiConfig field is set.
   */
  @java.lang.Override
  public boolean hasGatewayApiConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * GatewayAPIConfig contains the desired config of Gateway API on this
   * cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
   *
   * @return The gatewayApiConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GatewayAPIConfig getGatewayApiConfig() {
    return gatewayApiConfig_ == null
        ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
        : gatewayApiConfig_;
  }
  /**
   *
   *
   * <pre>
   * GatewayAPIConfig contains the desired config of Gateway API on this
   * cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GatewayAPIConfigOrBuilder getGatewayApiConfigOrBuilder() {
    return gatewayApiConfig_ == null
        ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
        : gatewayApiConfig_;
  }

  public static final int ENABLE_MULTI_NETWORKING_FIELD_NUMBER = 17;
  private boolean enableMultiNetworking_ = false;
  /**
   *
   *
   * <pre>
   * Whether multi-networking is enabled for this cluster.
   * </pre>
   *
   * <code>bool enable_multi_networking = 17;</code>
   *
   * @return The enableMultiNetworking.
   */
  @java.lang.Override
  public boolean getEnableMultiNetworking() {
    return enableMultiNetworking_;
  }

  public static final int NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER = 18;
  private com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
      networkPerformanceConfig_;
  /**
   *
   *
   * <pre>
   * Network bandwidth tier configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
   * </code>
   *
   * @return Whether the networkPerformanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPerformanceConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Network bandwidth tier configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
   * </code>
   *
   * @return The networkPerformanceConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
      getNetworkPerformanceConfig() {
    return networkPerformanceConfig_ == null
        ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
            .getDefaultInstance()
        : networkPerformanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Network bandwidth tier configuration.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder
      getNetworkPerformanceConfigOrBuilder() {
    return networkPerformanceConfig_ == null
        ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
            .getDefaultInstance()
        : networkPerformanceConfig_;
  }

  public static final int ENABLE_FQDN_NETWORK_POLICY_FIELD_NUMBER = 19;
  private boolean enableFqdnNetworkPolicy_ = false;
  /**
   *
   *
   * <pre>
   * Whether FQDN Network Policy is enabled on this cluster.
   * </pre>
   *
   * <code>optional bool enable_fqdn_network_policy = 19;</code>
   *
   * @return Whether the enableFqdnNetworkPolicy field is set.
   */
  @java.lang.Override
  public boolean hasEnableFqdnNetworkPolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether FQDN Network Policy is enabled on this cluster.
   * </pre>
   *
   * <code>optional bool enable_fqdn_network_policy = 19;</code>
   *
   * @return The enableFqdnNetworkPolicy.
   */
  @java.lang.Override
  public boolean getEnableFqdnNetworkPolicy() {
    return enableFqdnNetworkPolicy_;
  }

  public static final int IN_TRANSIT_ENCRYPTION_CONFIG_FIELD_NUMBER = 20;
  private int inTransitEncryptionConfig_ = 0;
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
   * </code>
   *
   * @return Whether the inTransitEncryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasInTransitEncryptionConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
   * </code>
   *
   * @return The enum numeric value on the wire for inTransitEncryptionConfig.
   */
  @java.lang.Override
  public int getInTransitEncryptionConfigValue() {
    return inTransitEncryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
   * </code>
   *
   * @return The inTransitEncryptionConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.InTransitEncryptionConfig getInTransitEncryptionConfig() {
    com.google.container.v1beta1.InTransitEncryptionConfig result =
        com.google.container.v1beta1.InTransitEncryptionConfig.forNumber(
            inTransitEncryptionConfig_);
    return result == null
        ? com.google.container.v1beta1.InTransitEncryptionConfig.UNRECOGNIZED
        : result;
  }

  public static final int ENABLE_CILIUM_CLUSTERWIDE_NETWORK_POLICY_FIELD_NUMBER = 21;
  private boolean enableCiliumClusterwideNetworkPolicy_ = false;
  /**
   *
   *
   * <pre>
   * Whether CiliumClusterWideNetworkPolicy is enabled on this cluster.
   * </pre>
   *
   * <code>optional bool enable_cilium_clusterwide_network_policy = 21;</code>
   *
   * @return Whether the enableCiliumClusterwideNetworkPolicy field is set.
   */
  @java.lang.Override
  public boolean hasEnableCiliumClusterwideNetworkPolicy() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether CiliumClusterWideNetworkPolicy is enabled on this cluster.
   * </pre>
   *
   * <code>optional bool enable_cilium_clusterwide_network_policy = 21;</code>
   *
   * @return The enableCiliumClusterwideNetworkPolicy.
   */
  @java.lang.Override
  public boolean getEnableCiliumClusterwideNetworkPolicy() {
    return enableCiliumClusterwideNetworkPolicy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subnetwork_);
    }
    if (enableIntraNodeVisibility_ != false) {
      output.writeBool(5, enableIntraNodeVisibility_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getDefaultSnatStatus());
    }
    if (enableL4IlbSubsetting_ != false) {
      output.writeBool(10, enableL4IlbSubsetting_);
    }
    if (datapathProvider_
        != com.google.container.v1beta1.DatapathProvider.DATAPATH_PROVIDER_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(11, datapathProvider_);
    }
    if (privateIpv6GoogleAccess_
        != com.google.container.v1beta1.PrivateIPv6GoogleAccess
            .PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, privateIpv6GoogleAccess_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(13, getDnsConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(15, getServiceExternalIpsConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(16, getGatewayApiConfig());
    }
    if (enableMultiNetworking_ != false) {
      output.writeBool(17, enableMultiNetworking_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(18, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(19, enableFqdnNetworkPolicy_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeEnum(20, inTransitEncryptionConfig_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(21, enableCiliumClusterwideNetworkPolicy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subnetwork_);
    }
    if (enableIntraNodeVisibility_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableIntraNodeVisibility_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDefaultSnatStatus());
    }
    if (enableL4IlbSubsetting_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, enableL4IlbSubsetting_);
    }
    if (datapathProvider_
        != com.google.container.v1beta1.DatapathProvider.DATAPATH_PROVIDER_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, datapathProvider_);
    }
    if (privateIpv6GoogleAccess_
        != com.google.container.v1beta1.PrivateIPv6GoogleAccess
            .PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, privateIpv6GoogleAccess_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getDnsConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, getServiceExternalIpsConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getGatewayApiConfig());
    }
    if (enableMultiNetworking_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(17, enableMultiNetworking_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, enableFqdnNetworkPolicy_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(20, inTransitEncryptionConfig_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              21, enableCiliumClusterwideNetworkPolicy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.NetworkConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.NetworkConfig other =
        (com.google.container.v1beta1.NetworkConfig) obj;

    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    if (getEnableIntraNodeVisibility() != other.getEnableIntraNodeVisibility()) return false;
    if (hasDefaultSnatStatus() != other.hasDefaultSnatStatus()) return false;
    if (hasDefaultSnatStatus()) {
      if (!getDefaultSnatStatus().equals(other.getDefaultSnatStatus())) return false;
    }
    if (getEnableL4IlbSubsetting() != other.getEnableL4IlbSubsetting()) return false;
    if (datapathProvider_ != other.datapathProvider_) return false;
    if (privateIpv6GoogleAccess_ != other.privateIpv6GoogleAccess_) return false;
    if (hasDnsConfig() != other.hasDnsConfig()) return false;
    if (hasDnsConfig()) {
      if (!getDnsConfig().equals(other.getDnsConfig())) return false;
    }
    if (hasServiceExternalIpsConfig() != other.hasServiceExternalIpsConfig()) return false;
    if (hasServiceExternalIpsConfig()) {
      if (!getServiceExternalIpsConfig().equals(other.getServiceExternalIpsConfig())) return false;
    }
    if (hasGatewayApiConfig() != other.hasGatewayApiConfig()) return false;
    if (hasGatewayApiConfig()) {
      if (!getGatewayApiConfig().equals(other.getGatewayApiConfig())) return false;
    }
    if (getEnableMultiNetworking() != other.getEnableMultiNetworking()) return false;
    if (hasNetworkPerformanceConfig() != other.hasNetworkPerformanceConfig()) return false;
    if (hasNetworkPerformanceConfig()) {
      if (!getNetworkPerformanceConfig().equals(other.getNetworkPerformanceConfig())) return false;
    }
    if (hasEnableFqdnNetworkPolicy() != other.hasEnableFqdnNetworkPolicy()) return false;
    if (hasEnableFqdnNetworkPolicy()) {
      if (getEnableFqdnNetworkPolicy() != other.getEnableFqdnNetworkPolicy()) return false;
    }
    if (hasInTransitEncryptionConfig() != other.hasInTransitEncryptionConfig()) return false;
    if (hasInTransitEncryptionConfig()) {
      if (inTransitEncryptionConfig_ != other.inTransitEncryptionConfig_) return false;
    }
    if (hasEnableCiliumClusterwideNetworkPolicy()
        != other.hasEnableCiliumClusterwideNetworkPolicy()) return false;
    if (hasEnableCiliumClusterwideNetworkPolicy()) {
      if (getEnableCiliumClusterwideNetworkPolicy()
          != other.getEnableCiliumClusterwideNetworkPolicy()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetwork().hashCode();
    hash = (37 * hash) + ENABLE_INTRA_NODE_VISIBILITY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableIntraNodeVisibility());
    if (hasDefaultSnatStatus()) {
      hash = (37 * hash) + DEFAULT_SNAT_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultSnatStatus().hashCode();
    }
    hash = (37 * hash) + ENABLE_L4ILB_SUBSETTING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableL4IlbSubsetting());
    hash = (37 * hash) + DATAPATH_PROVIDER_FIELD_NUMBER;
    hash = (53 * hash) + datapathProvider_;
    hash = (37 * hash) + PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + privateIpv6GoogleAccess_;
    if (hasDnsConfig()) {
      hash = (37 * hash) + DNS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDnsConfig().hashCode();
    }
    if (hasServiceExternalIpsConfig()) {
      hash = (37 * hash) + SERVICE_EXTERNAL_IPS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getServiceExternalIpsConfig().hashCode();
    }
    if (hasGatewayApiConfig()) {
      hash = (37 * hash) + GATEWAY_API_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGatewayApiConfig().hashCode();
    }
    hash = (37 * hash) + ENABLE_MULTI_NETWORKING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableMultiNetworking());
    if (hasNetworkPerformanceConfig()) {
      hash = (37 * hash) + NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPerformanceConfig().hashCode();
    }
    if (hasEnableFqdnNetworkPolicy()) {
      hash = (37 * hash) + ENABLE_FQDN_NETWORK_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableFqdnNetworkPolicy());
    }
    if (hasInTransitEncryptionConfig()) {
      hash = (37 * hash) + IN_TRANSIT_ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + inTransitEncryptionConfig_;
    }
    if (hasEnableCiliumClusterwideNetworkPolicy()) {
      hash = (37 * hash) + ENABLE_CILIUM_CLUSTERWIDE_NETWORK_POLICY_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getEnableCiliumClusterwideNetworkPolicy());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NetworkConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NetworkConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.NetworkConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * NetworkConfig reports the relative names of network &amp; subnetwork.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NetworkConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NetworkConfig)
      com.google.container.v1beta1.NetworkConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NetworkConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NetworkConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NetworkConfig.class,
              com.google.container.v1beta1.NetworkConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.NetworkConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultSnatStatusFieldBuilder();
        getDnsConfigFieldBuilder();
        getServiceExternalIpsConfigFieldBuilder();
        getGatewayApiConfigFieldBuilder();
        getNetworkPerformanceConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      network_ = "";
      subnetwork_ = "";
      enableIntraNodeVisibility_ = false;
      defaultSnatStatus_ = null;
      if (defaultSnatStatusBuilder_ != null) {
        defaultSnatStatusBuilder_.dispose();
        defaultSnatStatusBuilder_ = null;
      }
      enableL4IlbSubsetting_ = false;
      datapathProvider_ = 0;
      privateIpv6GoogleAccess_ = 0;
      dnsConfig_ = null;
      if (dnsConfigBuilder_ != null) {
        dnsConfigBuilder_.dispose();
        dnsConfigBuilder_ = null;
      }
      serviceExternalIpsConfig_ = null;
      if (serviceExternalIpsConfigBuilder_ != null) {
        serviceExternalIpsConfigBuilder_.dispose();
        serviceExternalIpsConfigBuilder_ = null;
      }
      gatewayApiConfig_ = null;
      if (gatewayApiConfigBuilder_ != null) {
        gatewayApiConfigBuilder_.dispose();
        gatewayApiConfigBuilder_ = null;
      }
      enableMultiNetworking_ = false;
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      enableFqdnNetworkPolicy_ = false;
      inTransitEncryptionConfig_ = 0;
      enableCiliumClusterwideNetworkPolicy_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NetworkConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NetworkConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.NetworkConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.NetworkConfig build() {
      com.google.container.v1beta1.NetworkConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NetworkConfig buildPartial() {
      com.google.container.v1beta1.NetworkConfig result =
          new com.google.container.v1beta1.NetworkConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.NetworkConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.subnetwork_ = subnetwork_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableIntraNodeVisibility_ = enableIntraNodeVisibility_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.defaultSnatStatus_ =
            defaultSnatStatusBuilder_ == null
                ? defaultSnatStatus_
                : defaultSnatStatusBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableL4IlbSubsetting_ = enableL4IlbSubsetting_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.datapathProvider_ = datapathProvider_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.privateIpv6GoogleAccess_ = privateIpv6GoogleAccess_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.dnsConfig_ = dnsConfigBuilder_ == null ? dnsConfig_ : dnsConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.serviceExternalIpsConfig_ =
            serviceExternalIpsConfigBuilder_ == null
                ? serviceExternalIpsConfig_
                : serviceExternalIpsConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.gatewayApiConfig_ =
            gatewayApiConfigBuilder_ == null ? gatewayApiConfig_ : gatewayApiConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.enableMultiNetworking_ = enableMultiNetworking_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.networkPerformanceConfig_ =
            networkPerformanceConfigBuilder_ == null
                ? networkPerformanceConfig_
                : networkPerformanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.enableFqdnNetworkPolicy_ = enableFqdnNetworkPolicy_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.inTransitEncryptionConfig_ = inTransitEncryptionConfig_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.enableCiliumClusterwideNetworkPolicy_ = enableCiliumClusterwideNetworkPolicy_;
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.NetworkConfig) {
        return mergeFrom((com.google.container.v1beta1.NetworkConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.NetworkConfig other) {
      if (other == com.google.container.v1beta1.NetworkConfig.getDefaultInstance()) return this;
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSubnetwork().isEmpty()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getEnableIntraNodeVisibility() != false) {
        setEnableIntraNodeVisibility(other.getEnableIntraNodeVisibility());
      }
      if (other.hasDefaultSnatStatus()) {
        mergeDefaultSnatStatus(other.getDefaultSnatStatus());
      }
      if (other.getEnableL4IlbSubsetting() != false) {
        setEnableL4IlbSubsetting(other.getEnableL4IlbSubsetting());
      }
      if (other.datapathProvider_ != 0) {
        setDatapathProviderValue(other.getDatapathProviderValue());
      }
      if (other.privateIpv6GoogleAccess_ != 0) {
        setPrivateIpv6GoogleAccessValue(other.getPrivateIpv6GoogleAccessValue());
      }
      if (other.hasDnsConfig()) {
        mergeDnsConfig(other.getDnsConfig());
      }
      if (other.hasServiceExternalIpsConfig()) {
        mergeServiceExternalIpsConfig(other.getServiceExternalIpsConfig());
      }
      if (other.hasGatewayApiConfig()) {
        mergeGatewayApiConfig(other.getGatewayApiConfig());
      }
      if (other.getEnableMultiNetworking() != false) {
        setEnableMultiNetworking(other.getEnableMultiNetworking());
      }
      if (other.hasNetworkPerformanceConfig()) {
        mergeNetworkPerformanceConfig(other.getNetworkPerformanceConfig());
      }
      if (other.hasEnableFqdnNetworkPolicy()) {
        setEnableFqdnNetworkPolicy(other.getEnableFqdnNetworkPolicy());
      }
      if (other.hasInTransitEncryptionConfig()) {
        setInTransitEncryptionConfig(other.getInTransitEncryptionConfig());
      }
      if (other.hasEnableCiliumClusterwideNetworkPolicy()) {
        setEnableCiliumClusterwideNetworkPolicy(other.getEnableCiliumClusterwideNetworkPolicy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 40:
              {
                enableIntraNodeVisibility_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 40
            case 58:
              {
                input.readMessage(
                    getDefaultSnatStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 80:
              {
                enableL4IlbSubsetting_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 80
            case 88:
              {
                datapathProvider_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 88
            case 96:
              {
                privateIpv6GoogleAccess_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getDnsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 106
            case 122:
              {
                input.readMessage(
                    getServiceExternalIpsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getGatewayApiConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 130
            case 136:
              {
                enableMultiNetworking_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(
                    getNetworkPerformanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 146
            case 152:
              {
                enableFqdnNetworkPolicy_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 152
            case 160:
              {
                inTransitEncryptionConfig_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 160
            case 168:
              {
                enableCiliumClusterwideNetworkPolicy_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 168
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [network][google.container.v1beta1.NetworkConfig.network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the cluster is connected. Example:
     * projects/my-project/global/networks/my-network
     * </pre>
     *
     * <code>string network = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The relative name of the Google Compute Engine
     * [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
     * cluster is connected. Example:
     * projects/my-project/regions/us-central1/subnetworks/my-subnet
     * </pre>
     *
     * <code>string subnetwork = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean enableIntraNodeVisibility_;
    /**
     *
     *
     * <pre>
     * Whether Intra-node visibility is enabled for this cluster.
     * This makes same node pod to pod traffic visible for VPC network.
     * </pre>
     *
     * <code>bool enable_intra_node_visibility = 5;</code>
     *
     * @return The enableIntraNodeVisibility.
     */
    @java.lang.Override
    public boolean getEnableIntraNodeVisibility() {
      return enableIntraNodeVisibility_;
    }
    /**
     *
     *
     * <pre>
     * Whether Intra-node visibility is enabled for this cluster.
     * This makes same node pod to pod traffic visible for VPC network.
     * </pre>
     *
     * <code>bool enable_intra_node_visibility = 5;</code>
     *
     * @param value The enableIntraNodeVisibility to set.
     * @return This builder for chaining.
     */
    public Builder setEnableIntraNodeVisibility(boolean value) {

      enableIntraNodeVisibility_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Intra-node visibility is enabled for this cluster.
     * This makes same node pod to pod traffic visible for VPC network.
     * </pre>
     *
     * <code>bool enable_intra_node_visibility = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableIntraNodeVisibility() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableIntraNodeVisibility_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.DefaultSnatStatus defaultSnatStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DefaultSnatStatus,
            com.google.container.v1beta1.DefaultSnatStatus.Builder,
            com.google.container.v1beta1.DefaultSnatStatusOrBuilder>
        defaultSnatStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     *
     * @return Whether the defaultSnatStatus field is set.
     */
    public boolean hasDefaultSnatStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     *
     * @return The defaultSnatStatus.
     */
    public com.google.container.v1beta1.DefaultSnatStatus getDefaultSnatStatus() {
      if (defaultSnatStatusBuilder_ == null) {
        return defaultSnatStatus_ == null
            ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
            : defaultSnatStatus_;
      } else {
        return defaultSnatStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    public Builder setDefaultSnatStatus(com.google.container.v1beta1.DefaultSnatStatus value) {
      if (defaultSnatStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultSnatStatus_ = value;
      } else {
        defaultSnatStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    public Builder setDefaultSnatStatus(
        com.google.container.v1beta1.DefaultSnatStatus.Builder builderForValue) {
      if (defaultSnatStatusBuilder_ == null) {
        defaultSnatStatus_ = builderForValue.build();
      } else {
        defaultSnatStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    public Builder mergeDefaultSnatStatus(com.google.container.v1beta1.DefaultSnatStatus value) {
      if (defaultSnatStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && defaultSnatStatus_ != null
            && defaultSnatStatus_
                != com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()) {
          getDefaultSnatStatusBuilder().mergeFrom(value);
        } else {
          defaultSnatStatus_ = value;
        }
      } else {
        defaultSnatStatusBuilder_.mergeFrom(value);
      }
      if (defaultSnatStatus_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    public Builder clearDefaultSnatStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      defaultSnatStatus_ = null;
      if (defaultSnatStatusBuilder_ != null) {
        defaultSnatStatusBuilder_.dispose();
        defaultSnatStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    public com.google.container.v1beta1.DefaultSnatStatus.Builder getDefaultSnatStatusBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDefaultSnatStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    public com.google.container.v1beta1.DefaultSnatStatusOrBuilder getDefaultSnatStatusOrBuilder() {
      if (defaultSnatStatusBuilder_ != null) {
        return defaultSnatStatusBuilder_.getMessageOrBuilder();
      } else {
        return defaultSnatStatus_ == null
            ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
            : defaultSnatStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
     * will be disabled when default_snat_status is disabled. When disabled is set
     * to false, default IP masquerade rules will be applied to the nodes to
     * prevent sNAT on cluster internal traffic.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus default_snat_status = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DefaultSnatStatus,
            com.google.container.v1beta1.DefaultSnatStatus.Builder,
            com.google.container.v1beta1.DefaultSnatStatusOrBuilder>
        getDefaultSnatStatusFieldBuilder() {
      if (defaultSnatStatusBuilder_ == null) {
        defaultSnatStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.DefaultSnatStatus,
                com.google.container.v1beta1.DefaultSnatStatus.Builder,
                com.google.container.v1beta1.DefaultSnatStatusOrBuilder>(
                getDefaultSnatStatus(), getParentForChildren(), isClean());
        defaultSnatStatus_ = null;
      }
      return defaultSnatStatusBuilder_;
    }

    private boolean enableL4IlbSubsetting_;
    /**
     *
     *
     * <pre>
     * Whether L4ILB Subsetting is enabled for this cluster.
     * </pre>
     *
     * <code>bool enable_l4ilb_subsetting = 10;</code>
     *
     * @return The enableL4ilbSubsetting.
     */
    @java.lang.Override
    public boolean getEnableL4IlbSubsetting() {
      return enableL4IlbSubsetting_;
    }
    /**
     *
     *
     * <pre>
     * Whether L4ILB Subsetting is enabled for this cluster.
     * </pre>
     *
     * <code>bool enable_l4ilb_subsetting = 10;</code>
     *
     * @param value The enableL4ilbSubsetting to set.
     * @return This builder for chaining.
     */
    public Builder setEnableL4IlbSubsetting(boolean value) {

      enableL4IlbSubsetting_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether L4ILB Subsetting is enabled for this cluster.
     * </pre>
     *
     * <code>bool enable_l4ilb_subsetting = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableL4IlbSubsetting() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableL4IlbSubsetting_ = false;
      onChanged();
      return this;
    }

    private int datapathProvider_ = 0;
    /**
     *
     *
     * <pre>
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
     *
     * @return The enum numeric value on the wire for datapathProvider.
     */
    @java.lang.Override
    public int getDatapathProviderValue() {
      return datapathProvider_;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
     *
     * @param value The enum numeric value on the wire for datapathProvider to set.
     * @return This builder for chaining.
     */
    public Builder setDatapathProviderValue(int value) {
      datapathProvider_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
     *
     * @return The datapathProvider.
     */
    @java.lang.Override
    public com.google.container.v1beta1.DatapathProvider getDatapathProvider() {
      com.google.container.v1beta1.DatapathProvider result =
          com.google.container.v1beta1.DatapathProvider.forNumber(datapathProvider_);
      return result == null ? com.google.container.v1beta1.DatapathProvider.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
     *
     * @param value The datapathProvider to set.
     * @return This builder for chaining.
     */
    public Builder setDatapathProvider(com.google.container.v1beta1.DatapathProvider value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      datapathProvider_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for this cluster. By default, uses the
     * IPTables-based kube-proxy implementation.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider datapath_provider = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatapathProvider() {
      bitField0_ = (bitField0_ & ~0x00000020);
      datapathProvider_ = 0;
      onChanged();
      return this;
    }

    private int privateIpv6GoogleAccess_ = 0;
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;
     * </code>
     *
     * @return The enum numeric value on the wire for privateIpv6GoogleAccess.
     */
    @java.lang.Override
    public int getPrivateIpv6GoogleAccessValue() {
      return privateIpv6GoogleAccess_;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;
     * </code>
     *
     * @param value The enum numeric value on the wire for privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccessValue(int value) {
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;
     * </code>
     *
     * @return The privateIpv6GoogleAccess.
     */
    @java.lang.Override
    public com.google.container.v1beta1.PrivateIPv6GoogleAccess getPrivateIpv6GoogleAccess() {
      com.google.container.v1beta1.PrivateIPv6GoogleAccess result =
          com.google.container.v1beta1.PrivateIPv6GoogleAccess.forNumber(privateIpv6GoogleAccess_);
      return result == null
          ? com.google.container.v1beta1.PrivateIPv6GoogleAccess.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;
     * </code>
     *
     * @param value The privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccess(
        com.google.container.v1beta1.PrivateIPv6GoogleAccess value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      privateIpv6GoogleAccess_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * By default, no private IPv6 access to or from Google Services (all access
     * will be via IPv4)
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateIPv6GoogleAccess private_ipv6_google_access = 12;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpv6GoogleAccess() {
      bitField0_ = (bitField0_ & ~0x00000040);
      privateIpv6GoogleAccess_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.DNSConfig dnsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DNSConfig,
            com.google.container.v1beta1.DNSConfig.Builder,
            com.google.container.v1beta1.DNSConfigOrBuilder>
        dnsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     *
     * @return Whether the dnsConfig field is set.
     */
    public boolean hasDnsConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     *
     * @return The dnsConfig.
     */
    public com.google.container.v1beta1.DNSConfig getDnsConfig() {
      if (dnsConfigBuilder_ == null) {
        return dnsConfig_ == null
            ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
            : dnsConfig_;
      } else {
        return dnsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    public Builder setDnsConfig(com.google.container.v1beta1.DNSConfig value) {
      if (dnsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsConfig_ = value;
      } else {
        dnsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    public Builder setDnsConfig(com.google.container.v1beta1.DNSConfig.Builder builderForValue) {
      if (dnsConfigBuilder_ == null) {
        dnsConfig_ = builderForValue.build();
      } else {
        dnsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    public Builder mergeDnsConfig(com.google.container.v1beta1.DNSConfig value) {
      if (dnsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && dnsConfig_ != null
            && dnsConfig_ != com.google.container.v1beta1.DNSConfig.getDefaultInstance()) {
          getDnsConfigBuilder().mergeFrom(value);
        } else {
          dnsConfig_ = value;
        }
      } else {
        dnsConfigBuilder_.mergeFrom(value);
      }
      if (dnsConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    public Builder clearDnsConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      dnsConfig_ = null;
      if (dnsConfigBuilder_ != null) {
        dnsConfigBuilder_.dispose();
        dnsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    public com.google.container.v1beta1.DNSConfig.Builder getDnsConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDnsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    public com.google.container.v1beta1.DNSConfigOrBuilder getDnsConfigOrBuilder() {
      if (dnsConfigBuilder_ != null) {
        return dnsConfigBuilder_.getMessageOrBuilder();
      } else {
        return dnsConfig_ == null
            ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
            : dnsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig dns_config = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DNSConfig,
            com.google.container.v1beta1.DNSConfig.Builder,
            com.google.container.v1beta1.DNSConfigOrBuilder>
        getDnsConfigFieldBuilder() {
      if (dnsConfigBuilder_ == null) {
        dnsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.DNSConfig,
                com.google.container.v1beta1.DNSConfig.Builder,
                com.google.container.v1beta1.DNSConfigOrBuilder>(
                getDnsConfig(), getParentForChildren(), isClean());
        dnsConfig_ = null;
      }
      return dnsConfigBuilder_;
    }

    private com.google.container.v1beta1.ServiceExternalIPsConfig serviceExternalIpsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ServiceExternalIPsConfig,
            com.google.container.v1beta1.ServiceExternalIPsConfig.Builder,
            com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder>
        serviceExternalIpsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     *
     * @return Whether the serviceExternalIpsConfig field is set.
     */
    public boolean hasServiceExternalIpsConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     *
     * @return The serviceExternalIpsConfig.
     */
    public com.google.container.v1beta1.ServiceExternalIPsConfig getServiceExternalIpsConfig() {
      if (serviceExternalIpsConfigBuilder_ == null) {
        return serviceExternalIpsConfig_ == null
            ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
            : serviceExternalIpsConfig_;
      } else {
        return serviceExternalIpsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    public Builder setServiceExternalIpsConfig(
        com.google.container.v1beta1.ServiceExternalIPsConfig value) {
      if (serviceExternalIpsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceExternalIpsConfig_ = value;
      } else {
        serviceExternalIpsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    public Builder setServiceExternalIpsConfig(
        com.google.container.v1beta1.ServiceExternalIPsConfig.Builder builderForValue) {
      if (serviceExternalIpsConfigBuilder_ == null) {
        serviceExternalIpsConfig_ = builderForValue.build();
      } else {
        serviceExternalIpsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    public Builder mergeServiceExternalIpsConfig(
        com.google.container.v1beta1.ServiceExternalIPsConfig value) {
      if (serviceExternalIpsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && serviceExternalIpsConfig_ != null
            && serviceExternalIpsConfig_
                != com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()) {
          getServiceExternalIpsConfigBuilder().mergeFrom(value);
        } else {
          serviceExternalIpsConfig_ = value;
        }
      } else {
        serviceExternalIpsConfigBuilder_.mergeFrom(value);
      }
      if (serviceExternalIpsConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    public Builder clearServiceExternalIpsConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      serviceExternalIpsConfig_ = null;
      if (serviceExternalIpsConfigBuilder_ != null) {
        serviceExternalIpsConfigBuilder_.dispose();
        serviceExternalIpsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    public com.google.container.v1beta1.ServiceExternalIPsConfig.Builder
        getServiceExternalIpsConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getServiceExternalIpsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    public com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder
        getServiceExternalIpsConfigOrBuilder() {
      if (serviceExternalIpsConfigBuilder_ != null) {
        return serviceExternalIpsConfigBuilder_.getMessageOrBuilder();
      } else {
        return serviceExternalIpsConfig_ == null
            ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
            : serviceExternalIpsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies if services with externalIPs field are
     * blocked or not.
     * </pre>
     *
     * <code>.google.container.v1beta1.ServiceExternalIPsConfig service_external_ips_config = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ServiceExternalIPsConfig,
            com.google.container.v1beta1.ServiceExternalIPsConfig.Builder,
            com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder>
        getServiceExternalIpsConfigFieldBuilder() {
      if (serviceExternalIpsConfigBuilder_ == null) {
        serviceExternalIpsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ServiceExternalIPsConfig,
                com.google.container.v1beta1.ServiceExternalIPsConfig.Builder,
                com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder>(
                getServiceExternalIpsConfig(), getParentForChildren(), isClean());
        serviceExternalIpsConfig_ = null;
      }
      return serviceExternalIpsConfigBuilder_;
    }

    private com.google.container.v1beta1.GatewayAPIConfig gatewayApiConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GatewayAPIConfig,
            com.google.container.v1beta1.GatewayAPIConfig.Builder,
            com.google.container.v1beta1.GatewayAPIConfigOrBuilder>
        gatewayApiConfigBuilder_;
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     *
     * @return Whether the gatewayApiConfig field is set.
     */
    public boolean hasGatewayApiConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     *
     * @return The gatewayApiConfig.
     */
    public com.google.container.v1beta1.GatewayAPIConfig getGatewayApiConfig() {
      if (gatewayApiConfigBuilder_ == null) {
        return gatewayApiConfig_ == null
            ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
            : gatewayApiConfig_;
      } else {
        return gatewayApiConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    public Builder setGatewayApiConfig(com.google.container.v1beta1.GatewayAPIConfig value) {
      if (gatewayApiConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gatewayApiConfig_ = value;
      } else {
        gatewayApiConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    public Builder setGatewayApiConfig(
        com.google.container.v1beta1.GatewayAPIConfig.Builder builderForValue) {
      if (gatewayApiConfigBuilder_ == null) {
        gatewayApiConfig_ = builderForValue.build();
      } else {
        gatewayApiConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    public Builder mergeGatewayApiConfig(com.google.container.v1beta1.GatewayAPIConfig value) {
      if (gatewayApiConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && gatewayApiConfig_ != null
            && gatewayApiConfig_
                != com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()) {
          getGatewayApiConfigBuilder().mergeFrom(value);
        } else {
          gatewayApiConfig_ = value;
        }
      } else {
        gatewayApiConfigBuilder_.mergeFrom(value);
      }
      if (gatewayApiConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    public Builder clearGatewayApiConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      gatewayApiConfig_ = null;
      if (gatewayApiConfigBuilder_ != null) {
        gatewayApiConfigBuilder_.dispose();
        gatewayApiConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    public com.google.container.v1beta1.GatewayAPIConfig.Builder getGatewayApiConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getGatewayApiConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    public com.google.container.v1beta1.GatewayAPIConfigOrBuilder getGatewayApiConfigOrBuilder() {
      if (gatewayApiConfigBuilder_ != null) {
        return gatewayApiConfigBuilder_.getMessageOrBuilder();
      } else {
        return gatewayApiConfig_ == null
            ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
            : gatewayApiConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * GatewayAPIConfig contains the desired config of Gateway API on this
     * cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig gateway_api_config = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GatewayAPIConfig,
            com.google.container.v1beta1.GatewayAPIConfig.Builder,
            com.google.container.v1beta1.GatewayAPIConfigOrBuilder>
        getGatewayApiConfigFieldBuilder() {
      if (gatewayApiConfigBuilder_ == null) {
        gatewayApiConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GatewayAPIConfig,
                com.google.container.v1beta1.GatewayAPIConfig.Builder,
                com.google.container.v1beta1.GatewayAPIConfigOrBuilder>(
                getGatewayApiConfig(), getParentForChildren(), isClean());
        gatewayApiConfig_ = null;
      }
      return gatewayApiConfigBuilder_;
    }

    private boolean enableMultiNetworking_;
    /**
     *
     *
     * <pre>
     * Whether multi-networking is enabled for this cluster.
     * </pre>
     *
     * <code>bool enable_multi_networking = 17;</code>
     *
     * @return The enableMultiNetworking.
     */
    @java.lang.Override
    public boolean getEnableMultiNetworking() {
      return enableMultiNetworking_;
    }
    /**
     *
     *
     * <pre>
     * Whether multi-networking is enabled for this cluster.
     * </pre>
     *
     * <code>bool enable_multi_networking = 17;</code>
     *
     * @param value The enableMultiNetworking to set.
     * @return This builder for chaining.
     */
    public Builder setEnableMultiNetworking(boolean value) {

      enableMultiNetworking_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether multi-networking is enabled for this cluster.
     * </pre>
     *
     * <code>bool enable_multi_networking = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableMultiNetworking() {
      bitField0_ = (bitField0_ & ~0x00000400);
      enableMultiNetworking_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        networkPerformanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder>
        networkPerformanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     *
     * @return Whether the networkPerformanceConfig field is set.
     */
    public boolean hasNetworkPerformanceConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     *
     * @return The networkPerformanceConfig.
     */
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        getNetworkPerformanceConfig() {
      if (networkPerformanceConfigBuilder_ == null) {
        return networkPerformanceConfig_ == null
            ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                .getDefaultInstance()
            : networkPerformanceConfig_;
      } else {
        return networkPerformanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPerformanceConfig_ = value;
      } else {
        networkPerformanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder
            builderForValue) {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfig_ = builderForValue.build();
      } else {
        networkPerformanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    public Builder mergeNetworkPerformanceConfig(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && networkPerformanceConfig_ != null
            && networkPerformanceConfig_
                != com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                    .getDefaultInstance()) {
          getNetworkPerformanceConfigBuilder().mergeFrom(value);
        } else {
          networkPerformanceConfig_ = value;
        }
      } else {
        networkPerformanceConfigBuilder_.mergeFrom(value);
      }
      if (networkPerformanceConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    public Builder clearNetworkPerformanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder
        getNetworkPerformanceConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getNetworkPerformanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder
        getNetworkPerformanceConfigOrBuilder() {
      if (networkPerformanceConfigBuilder_ != null) {
        return networkPerformanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkPerformanceConfig_ == null
            ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                .getDefaultInstance()
            : networkPerformanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig network_performance_config = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder>
        getNetworkPerformanceConfigFieldBuilder() {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig,
                com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder,
                com.google.container.v1beta1.NetworkConfig
                    .ClusterNetworkPerformanceConfigOrBuilder>(
                getNetworkPerformanceConfig(), getParentForChildren(), isClean());
        networkPerformanceConfig_ = null;
      }
      return networkPerformanceConfigBuilder_;
    }

    private boolean enableFqdnNetworkPolicy_;
    /**
     *
     *
     * <pre>
     * Whether FQDN Network Policy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_fqdn_network_policy = 19;</code>
     *
     * @return Whether the enableFqdnNetworkPolicy field is set.
     */
    @java.lang.Override
    public boolean hasEnableFqdnNetworkPolicy() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether FQDN Network Policy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_fqdn_network_policy = 19;</code>
     *
     * @return The enableFqdnNetworkPolicy.
     */
    @java.lang.Override
    public boolean getEnableFqdnNetworkPolicy() {
      return enableFqdnNetworkPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Whether FQDN Network Policy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_fqdn_network_policy = 19;</code>
     *
     * @param value The enableFqdnNetworkPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setEnableFqdnNetworkPolicy(boolean value) {

      enableFqdnNetworkPolicy_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether FQDN Network Policy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_fqdn_network_policy = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableFqdnNetworkPolicy() {
      bitField0_ = (bitField0_ & ~0x00001000);
      enableFqdnNetworkPolicy_ = false;
      onChanged();
      return this;
    }

    private int inTransitEncryptionConfig_ = 0;
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
     * </code>
     *
     * @return Whether the inTransitEncryptionConfig field is set.
     */
    @java.lang.Override
    public boolean hasInTransitEncryptionConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
     * </code>
     *
     * @return The enum numeric value on the wire for inTransitEncryptionConfig.
     */
    @java.lang.Override
    public int getInTransitEncryptionConfigValue() {
      return inTransitEncryptionConfig_;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
     * </code>
     *
     * @param value The enum numeric value on the wire for inTransitEncryptionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setInTransitEncryptionConfigValue(int value) {
      inTransitEncryptionConfig_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
     * </code>
     *
     * @return The inTransitEncryptionConfig.
     */
    @java.lang.Override
    public com.google.container.v1beta1.InTransitEncryptionConfig getInTransitEncryptionConfig() {
      com.google.container.v1beta1.InTransitEncryptionConfig result =
          com.google.container.v1beta1.InTransitEncryptionConfig.forNumber(
              inTransitEncryptionConfig_);
      return result == null
          ? com.google.container.v1beta1.InTransitEncryptionConfig.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
     * </code>
     *
     * @param value The inTransitEncryptionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setInTransitEncryptionConfig(
        com.google.container.v1beta1.InTransitEncryptionConfig value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      inTransitEncryptionConfig_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig in_transit_encryption_config = 20;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInTransitEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      inTransitEncryptionConfig_ = 0;
      onChanged();
      return this;
    }

    private boolean enableCiliumClusterwideNetworkPolicy_;
    /**
     *
     *
     * <pre>
     * Whether CiliumClusterWideNetworkPolicy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_cilium_clusterwide_network_policy = 21;</code>
     *
     * @return Whether the enableCiliumClusterwideNetworkPolicy field is set.
     */
    @java.lang.Override
    public boolean hasEnableCiliumClusterwideNetworkPolicy() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether CiliumClusterWideNetworkPolicy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_cilium_clusterwide_network_policy = 21;</code>
     *
     * @return The enableCiliumClusterwideNetworkPolicy.
     */
    @java.lang.Override
    public boolean getEnableCiliumClusterwideNetworkPolicy() {
      return enableCiliumClusterwideNetworkPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Whether CiliumClusterWideNetworkPolicy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_cilium_clusterwide_network_policy = 21;</code>
     *
     * @param value The enableCiliumClusterwideNetworkPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setEnableCiliumClusterwideNetworkPolicy(boolean value) {

      enableCiliumClusterwideNetworkPolicy_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether CiliumClusterWideNetworkPolicy is enabled on this cluster.
     * </pre>
     *
     * <code>optional bool enable_cilium_clusterwide_network_policy = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableCiliumClusterwideNetworkPolicy() {
      bitField0_ = (bitField0_ & ~0x00004000);
      enableCiliumClusterwideNetworkPolicy_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NetworkConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.NetworkConfig)
  private static final com.google.container.v1beta1.NetworkConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.NetworkConfig();
  }

  public static com.google.container.v1beta1.NetworkConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkConfig> PARSER =
      new com.google.protobuf.AbstractParser<NetworkConfig>() {
        @java.lang.Override
        public NetworkConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.NetworkConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
