/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration options for private clusters.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.PrivateClusterConfig}
 */
public final class PrivateClusterConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.PrivateClusterConfig)
    PrivateClusterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PrivateClusterConfig.newBuilder() to construct.
  private PrivateClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrivateClusterConfig() {
    masterIpv4CidrBlock_ = "";
    privateEndpoint_ = "";
    publicEndpoint_ = "";
    peeringName_ = "";
    privateEndpointSubnetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrivateClusterConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_PrivateClusterConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_PrivateClusterConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.PrivateClusterConfig.class,
            com.google.container.v1beta1.PrivateClusterConfig.Builder.class);
  }

  private int bitField0_;
  public static final int ENABLE_PRIVATE_NODES_FIELD_NUMBER = 1;
  private boolean enablePrivateNodes_ = false;
  /**
   *
   *
   * <pre>
   * Whether nodes have internal IP addresses only. If enabled, all nodes are
   * given only RFC 1918 private addresses and communicate with the master via
   * private networking.
   * </pre>
   *
   * <code>bool enable_private_nodes = 1;</code>
   *
   * @return The enablePrivateNodes.
   */
  @java.lang.Override
  public boolean getEnablePrivateNodes() {
    return enablePrivateNodes_;
  }

  public static final int ENABLE_PRIVATE_ENDPOINT_FIELD_NUMBER = 2;
  private boolean enablePrivateEndpoint_ = false;
  /**
   *
   *
   * <pre>
   * Whether the master's internal IP address is used as the cluster endpoint.
   * </pre>
   *
   * <code>bool enable_private_endpoint = 2;</code>
   *
   * @return The enablePrivateEndpoint.
   */
  @java.lang.Override
  public boolean getEnablePrivateEndpoint() {
    return enablePrivateEndpoint_;
  }

  public static final int MASTER_IPV4_CIDR_BLOCK_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object masterIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * The IP range in CIDR notation to use for the hosted master network. This
   * range will be used for assigning internal IP addresses to the master or
   * set of masters, as well as the ILB VIP. This range must not overlap with
   * any other ranges in use within the cluster's network.
   * </pre>
   *
   * <code>string master_ipv4_cidr_block = 3;</code>
   *
   * @return The masterIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getMasterIpv4CidrBlock() {
    java.lang.Object ref = masterIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      masterIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP range in CIDR notation to use for the hosted master network. This
   * range will be used for assigning internal IP addresses to the master or
   * set of masters, as well as the ILB VIP. This range must not overlap with
   * any other ranges in use within the cluster's network.
   * </pre>
   *
   * <code>string master_ipv4_cidr_block = 3;</code>
   *
   * @return The bytes for masterIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMasterIpv4CidrBlockBytes() {
    java.lang.Object ref = masterIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      masterIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_ENDPOINT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The internal IP address of this cluster's master endpoint.
   * </pre>
   *
   * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The privateEndpoint.
   */
  @java.lang.Override
  public java.lang.String getPrivateEndpoint() {
    java.lang.Object ref = privateEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The internal IP address of this cluster's master endpoint.
   * </pre>
   *
   * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for privateEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateEndpointBytes() {
    java.lang.Object ref = privateEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLIC_ENDPOINT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object publicEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The external IP address of this cluster's master endpoint.
   * </pre>
   *
   * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The publicEndpoint.
   */
  @java.lang.Override
  public java.lang.String getPublicEndpoint() {
    java.lang.Object ref = publicEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publicEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The external IP address of this cluster's master endpoint.
   * </pre>
   *
   * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for publicEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicEndpointBytes() {
    java.lang.Object ref = publicEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publicEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEERING_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peeringName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The peering name in the customer VPC used by this cluster.
   * </pre>
   *
   * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The peeringName.
   */
  @java.lang.Override
  public java.lang.String getPeeringName() {
    java.lang.Object ref = peeringName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peeringName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The peering name in the customer VPC used by this cluster.
   * </pre>
   *
   * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for peeringName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeeringNameBytes() {
    java.lang.Object ref = peeringName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peeringName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MASTER_GLOBAL_ACCESS_CONFIG_FIELD_NUMBER = 8;
  private com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
      masterGlobalAccessConfig_;
  /**
   *
   *
   * <pre>
   * Controls master global access settings.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
   * </code>
   *
   * @return Whether the masterGlobalAccessConfig field is set.
   */
  @java.lang.Override
  public boolean hasMasterGlobalAccessConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Controls master global access settings.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
   * </code>
   *
   * @return The masterGlobalAccessConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
      getMasterGlobalAccessConfig() {
    return masterGlobalAccessConfig_ == null
        ? com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.getDefaultInstance()
        : masterGlobalAccessConfig_;
  }
  /**
   *
   *
   * <pre>
   * Controls master global access settings.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfigOrBuilder
      getMasterGlobalAccessConfigOrBuilder() {
    return masterGlobalAccessConfig_ == null
        ? com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.getDefaultInstance()
        : masterGlobalAccessConfig_;
  }

  public static final int PRIVATE_ENDPOINT_SUBNETWORK_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateEndpointSubnetwork_ = "";
  /**
   *
   *
   * <pre>
   * Subnet to provision the master's private endpoint during cluster creation.
   * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
   * </pre>
   *
   * <code>string private_endpoint_subnetwork = 10;</code>
   *
   * @return The privateEndpointSubnetwork.
   */
  @java.lang.Override
  public java.lang.String getPrivateEndpointSubnetwork() {
    java.lang.Object ref = privateEndpointSubnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateEndpointSubnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Subnet to provision the master's private endpoint during cluster creation.
   * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
   * </pre>
   *
   * <code>string private_endpoint_subnetwork = 10;</code>
   *
   * @return The bytes for privateEndpointSubnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateEndpointSubnetworkBytes() {
    java.lang.Object ref = privateEndpointSubnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateEndpointSubnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enablePrivateNodes_ != false) {
      output.writeBool(1, enablePrivateNodes_);
    }
    if (enablePrivateEndpoint_ != false) {
      output.writeBool(2, enablePrivateEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(masterIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, masterIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, privateEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, publicEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeringName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, peeringName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getMasterGlobalAccessConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpointSubnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, privateEndpointSubnetwork_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enablePrivateNodes_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enablePrivateNodes_);
    }
    if (enablePrivateEndpoint_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enablePrivateEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(masterIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, masterIpv4CidrBlock_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, privateEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, publicEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(peeringName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, peeringName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getMasterGlobalAccessConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateEndpointSubnetwork_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(10, privateEndpointSubnetwork_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.PrivateClusterConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.PrivateClusterConfig other =
        (com.google.container.v1beta1.PrivateClusterConfig) obj;

    if (getEnablePrivateNodes() != other.getEnablePrivateNodes()) return false;
    if (getEnablePrivateEndpoint() != other.getEnablePrivateEndpoint()) return false;
    if (!getMasterIpv4CidrBlock().equals(other.getMasterIpv4CidrBlock())) return false;
    if (!getPrivateEndpoint().equals(other.getPrivateEndpoint())) return false;
    if (!getPublicEndpoint().equals(other.getPublicEndpoint())) return false;
    if (!getPeeringName().equals(other.getPeeringName())) return false;
    if (hasMasterGlobalAccessConfig() != other.hasMasterGlobalAccessConfig()) return false;
    if (hasMasterGlobalAccessConfig()) {
      if (!getMasterGlobalAccessConfig().equals(other.getMasterGlobalAccessConfig())) return false;
    }
    if (!getPrivateEndpointSubnetwork().equals(other.getPrivateEndpointSubnetwork())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLE_PRIVATE_NODES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateNodes());
    hash = (37 * hash) + ENABLE_PRIVATE_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateEndpoint());
    hash = (37 * hash) + MASTER_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getMasterIpv4CidrBlock().hashCode();
    hash = (37 * hash) + PRIVATE_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateEndpoint().hashCode();
    hash = (37 * hash) + PUBLIC_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getPublicEndpoint().hashCode();
    hash = (37 * hash) + PEERING_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getPeeringName().hashCode();
    if (hasMasterGlobalAccessConfig()) {
      hash = (37 * hash) + MASTER_GLOBAL_ACCESS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMasterGlobalAccessConfig().hashCode();
    }
    hash = (37 * hash) + PRIVATE_ENDPOINT_SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateEndpointSubnetwork().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.PrivateClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.PrivateClusterConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for private clusters.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.PrivateClusterConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.PrivateClusterConfig)
      com.google.container.v1beta1.PrivateClusterConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_PrivateClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_PrivateClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.PrivateClusterConfig.class,
              com.google.container.v1beta1.PrivateClusterConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.PrivateClusterConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMasterGlobalAccessConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enablePrivateNodes_ = false;
      enablePrivateEndpoint_ = false;
      masterIpv4CidrBlock_ = "";
      privateEndpoint_ = "";
      publicEndpoint_ = "";
      peeringName_ = "";
      masterGlobalAccessConfig_ = null;
      if (masterGlobalAccessConfigBuilder_ != null) {
        masterGlobalAccessConfigBuilder_.dispose();
        masterGlobalAccessConfigBuilder_ = null;
      }
      privateEndpointSubnetwork_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_PrivateClusterConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.PrivateClusterConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.PrivateClusterConfig build() {
      com.google.container.v1beta1.PrivateClusterConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.PrivateClusterConfig buildPartial() {
      com.google.container.v1beta1.PrivateClusterConfig result =
          new com.google.container.v1beta1.PrivateClusterConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.PrivateClusterConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enablePrivateNodes_ = enablePrivateNodes_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enablePrivateEndpoint_ = enablePrivateEndpoint_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.masterIpv4CidrBlock_ = masterIpv4CidrBlock_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.privateEndpoint_ = privateEndpoint_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.publicEndpoint_ = publicEndpoint_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.peeringName_ = peeringName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.masterGlobalAccessConfig_ =
            masterGlobalAccessConfigBuilder_ == null
                ? masterGlobalAccessConfig_
                : masterGlobalAccessConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.privateEndpointSubnetwork_ = privateEndpointSubnetwork_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.PrivateClusterConfig) {
        return mergeFrom((com.google.container.v1beta1.PrivateClusterConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.PrivateClusterConfig other) {
      if (other == com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance())
        return this;
      if (other.getEnablePrivateNodes() != false) {
        setEnablePrivateNodes(other.getEnablePrivateNodes());
      }
      if (other.getEnablePrivateEndpoint() != false) {
        setEnablePrivateEndpoint(other.getEnablePrivateEndpoint());
      }
      if (!other.getMasterIpv4CidrBlock().isEmpty()) {
        masterIpv4CidrBlock_ = other.masterIpv4CidrBlock_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPrivateEndpoint().isEmpty()) {
        privateEndpoint_ = other.privateEndpoint_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getPublicEndpoint().isEmpty()) {
        publicEndpoint_ = other.publicEndpoint_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getPeeringName().isEmpty()) {
        peeringName_ = other.peeringName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasMasterGlobalAccessConfig()) {
        mergeMasterGlobalAccessConfig(other.getMasterGlobalAccessConfig());
      }
      if (!other.getPrivateEndpointSubnetwork().isEmpty()) {
        privateEndpointSubnetwork_ = other.privateEndpointSubnetwork_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enablePrivateNodes_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                enablePrivateEndpoint_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                masterIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                privateEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                publicEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                peeringName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getMasterGlobalAccessConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 82:
              {
                privateEndpointSubnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enablePrivateNodes_;
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only. If enabled, all nodes are
     * given only RFC 1918 private addresses and communicate with the master via
     * private networking.
     * </pre>
     *
     * <code>bool enable_private_nodes = 1;</code>
     *
     * @return The enablePrivateNodes.
     */
    @java.lang.Override
    public boolean getEnablePrivateNodes() {
      return enablePrivateNodes_;
    }
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only. If enabled, all nodes are
     * given only RFC 1918 private addresses and communicate with the master via
     * private networking.
     * </pre>
     *
     * <code>bool enable_private_nodes = 1;</code>
     *
     * @param value The enablePrivateNodes to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePrivateNodes(boolean value) {

      enablePrivateNodes_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only. If enabled, all nodes are
     * given only RFC 1918 private addresses and communicate with the master via
     * private networking.
     * </pre>
     *
     * <code>bool enable_private_nodes = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePrivateNodes() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enablePrivateNodes_ = false;
      onChanged();
      return this;
    }

    private boolean enablePrivateEndpoint_;
    /**
     *
     *
     * <pre>
     * Whether the master's internal IP address is used as the cluster endpoint.
     * </pre>
     *
     * <code>bool enable_private_endpoint = 2;</code>
     *
     * @return The enablePrivateEndpoint.
     */
    @java.lang.Override
    public boolean getEnablePrivateEndpoint() {
      return enablePrivateEndpoint_;
    }
    /**
     *
     *
     * <pre>
     * Whether the master's internal IP address is used as the cluster endpoint.
     * </pre>
     *
     * <code>bool enable_private_endpoint = 2;</code>
     *
     * @param value The enablePrivateEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePrivateEndpoint(boolean value) {

      enablePrivateEndpoint_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the master's internal IP address is used as the cluster endpoint.
     * </pre>
     *
     * <code>bool enable_private_endpoint = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePrivateEndpoint() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enablePrivateEndpoint_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object masterIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     * </pre>
     *
     * <code>string master_ipv4_cidr_block = 3;</code>
     *
     * @return The masterIpv4CidrBlock.
     */
    public java.lang.String getMasterIpv4CidrBlock() {
      java.lang.Object ref = masterIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        masterIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     * </pre>
     *
     * <code>string master_ipv4_cidr_block = 3;</code>
     *
     * @return The bytes for masterIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getMasterIpv4CidrBlockBytes() {
      java.lang.Object ref = masterIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        masterIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     * </pre>
     *
     * <code>string master_ipv4_cidr_block = 3;</code>
     *
     * @param value The masterIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setMasterIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      masterIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     * </pre>
     *
     * <code>string master_ipv4_cidr_block = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMasterIpv4CidrBlock() {
      masterIpv4CidrBlock_ = getDefaultInstance().getMasterIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP range in CIDR notation to use for the hosted master network. This
     * range will be used for assigning internal IP addresses to the master or
     * set of masters, as well as the ILB VIP. This range must not overlap with
     * any other ranges in use within the cluster's network.
     * </pre>
     *
     * <code>string master_ipv4_cidr_block = 3;</code>
     *
     * @param value The bytes for masterIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setMasterIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      masterIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object privateEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The privateEndpoint.
     */
    public java.lang.String getPrivateEndpoint() {
      java.lang.Object ref = privateEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for privateEndpoint.
     */
    public com.google.protobuf.ByteString getPrivateEndpointBytes() {
      java.lang.Object ref = privateEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The privateEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateEndpoint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateEndpoint() {
      privateEndpoint_ = getDefaultInstance().getPrivateEndpoint();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The internal IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string private_endpoint = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for privateEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateEndpoint_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object publicEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The publicEndpoint.
     */
    public java.lang.String getPublicEndpoint() {
      java.lang.Object ref = publicEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for publicEndpoint.
     */
    public com.google.protobuf.ByteString getPublicEndpointBytes() {
      java.lang.Object ref = publicEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The publicEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setPublicEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publicEndpoint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicEndpoint() {
      publicEndpoint_ = getDefaultInstance().getPublicEndpoint();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The external IP address of this cluster's master endpoint.
     * </pre>
     *
     * <code>string public_endpoint = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for publicEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setPublicEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publicEndpoint_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object peeringName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The peering name in the customer VPC used by this cluster.
     * </pre>
     *
     * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The peeringName.
     */
    public java.lang.String getPeeringName() {
      java.lang.Object ref = peeringName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peeringName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The peering name in the customer VPC used by this cluster.
     * </pre>
     *
     * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for peeringName.
     */
    public com.google.protobuf.ByteString getPeeringNameBytes() {
      java.lang.Object ref = peeringName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peeringName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The peering name in the customer VPC used by this cluster.
     * </pre>
     *
     * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The peeringName to set.
     * @return This builder for chaining.
     */
    public Builder setPeeringName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peeringName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The peering name in the customer VPC used by this cluster.
     * </pre>
     *
     * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeeringName() {
      peeringName_ = getDefaultInstance().getPeeringName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The peering name in the customer VPC used by this cluster.
     * </pre>
     *
     * <code>string peering_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for peeringName to set.
     * @return This builder for chaining.
     */
    public Builder setPeeringNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peeringName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
        masterGlobalAccessConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig,
            com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.Builder,
            com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfigOrBuilder>
        masterGlobalAccessConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     *
     * @return Whether the masterGlobalAccessConfig field is set.
     */
    public boolean hasMasterGlobalAccessConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     *
     * @return The masterGlobalAccessConfig.
     */
    public com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
        getMasterGlobalAccessConfig() {
      if (masterGlobalAccessConfigBuilder_ == null) {
        return masterGlobalAccessConfig_ == null
            ? com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
                .getDefaultInstance()
            : masterGlobalAccessConfig_;
      } else {
        return masterGlobalAccessConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    public Builder setMasterGlobalAccessConfig(
        com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig value) {
      if (masterGlobalAccessConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        masterGlobalAccessConfig_ = value;
      } else {
        masterGlobalAccessConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    public Builder setMasterGlobalAccessConfig(
        com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.Builder
            builderForValue) {
      if (masterGlobalAccessConfigBuilder_ == null) {
        masterGlobalAccessConfig_ = builderForValue.build();
      } else {
        masterGlobalAccessConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    public Builder mergeMasterGlobalAccessConfig(
        com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig value) {
      if (masterGlobalAccessConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && masterGlobalAccessConfig_ != null
            && masterGlobalAccessConfig_
                != com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
                    .getDefaultInstance()) {
          getMasterGlobalAccessConfigBuilder().mergeFrom(value);
        } else {
          masterGlobalAccessConfig_ = value;
        }
      } else {
        masterGlobalAccessConfigBuilder_.mergeFrom(value);
      }
      if (masterGlobalAccessConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    public Builder clearMasterGlobalAccessConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      masterGlobalAccessConfig_ = null;
      if (masterGlobalAccessConfigBuilder_ != null) {
        masterGlobalAccessConfigBuilder_.dispose();
        masterGlobalAccessConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    public com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.Builder
        getMasterGlobalAccessConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getMasterGlobalAccessConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    public com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfigOrBuilder
        getMasterGlobalAccessConfigOrBuilder() {
      if (masterGlobalAccessConfigBuilder_ != null) {
        return masterGlobalAccessConfigBuilder_.getMessageOrBuilder();
      } else {
        return masterGlobalAccessConfig_ == null
            ? com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig
                .getDefaultInstance()
            : masterGlobalAccessConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls master global access settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig master_global_access_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig,
            com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.Builder,
            com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfigOrBuilder>
        getMasterGlobalAccessConfigFieldBuilder() {
      if (masterGlobalAccessConfigBuilder_ == null) {
        masterGlobalAccessConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig,
                com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfig.Builder,
                com.google.container.v1beta1.PrivateClusterMasterGlobalAccessConfigOrBuilder>(
                getMasterGlobalAccessConfig(), getParentForChildren(), isClean());
        masterGlobalAccessConfig_ = null;
      }
      return masterGlobalAccessConfigBuilder_;
    }

    private java.lang.Object privateEndpointSubnetwork_ = "";
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 10;</code>
     *
     * @return The privateEndpointSubnetwork.
     */
    public java.lang.String getPrivateEndpointSubnetwork() {
      java.lang.Object ref = privateEndpointSubnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateEndpointSubnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 10;</code>
     *
     * @return The bytes for privateEndpointSubnetwork.
     */
    public com.google.protobuf.ByteString getPrivateEndpointSubnetworkBytes() {
      java.lang.Object ref = privateEndpointSubnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateEndpointSubnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 10;</code>
     *
     * @param value The privateEndpointSubnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateEndpointSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateEndpointSubnetwork_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateEndpointSubnetwork() {
      privateEndpointSubnetwork_ = getDefaultInstance().getPrivateEndpointSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Subnet to provision the master's private endpoint during cluster creation.
     * Specified in projects/&#42;&#47;regions/&#42;&#47;subnetworks/&#42; format.
     * </pre>
     *
     * <code>string private_endpoint_subnetwork = 10;</code>
     *
     * @param value The bytes for privateEndpointSubnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateEndpointSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateEndpointSubnetwork_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.PrivateClusterConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.PrivateClusterConfig)
  private static final com.google.container.v1beta1.PrivateClusterConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.PrivateClusterConfig();
  }

  public static com.google.container.v1beta1.PrivateClusterConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrivateClusterConfig> PARSER =
      new com.google.protobuf.AbstractParser<PrivateClusterConfig>() {
        @java.lang.Override
        public PrivateClusterConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PrivateClusterConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrivateClusterConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.PrivateClusterConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
