/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Kubernetes Engine service configuration.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.ServerConfig}
 */
public final class ServerConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.ServerConfig)
    ServerConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServerConfig.newBuilder() to construct.
  private ServerConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServerConfig() {
    defaultClusterVersion_ = "";
    validNodeVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    defaultImageType_ = "";
    validImageTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    validMasterVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    channels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServerConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_ServerConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 10:
        return internalGetWindowsVersionMaps();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_ServerConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.ServerConfig.class,
            com.google.container.v1beta1.ServerConfig.Builder.class);
  }

  public interface ReleaseChannelConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.ServerConfig.ReleaseChannelConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The release channel this configuration applies to.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
     *
     * @return The enum numeric value on the wire for channel.
     */
    int getChannelValue();
    /**
     *
     *
     * <pre>
     * The release channel this configuration applies to.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
     *
     * @return The channel.
     */
    com.google.container.v1beta1.ReleaseChannel.Channel getChannel();

    /**
     *
     *
     * <pre>
     * The default version for newly created clusters on the channel.
     * </pre>
     *
     * <code>string default_version = 2;</code>
     *
     * @return The defaultVersion.
     */
    java.lang.String getDefaultVersion();
    /**
     *
     *
     * <pre>
     * The default version for newly created clusters on the channel.
     * </pre>
     *
     * <code>string default_version = 2;</code>
     *
     * @return The bytes for defaultVersion.
     */
    com.google.protobuf.ByteString getDefaultVersionBytes();

    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion>
        getAvailableVersionsList();
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
        getAvailableVersions(int index);
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    int getAvailableVersionsCount();
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    java.util.List<
            ? extends
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                    .AvailableVersionOrBuilder>
        getAvailableVersionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersionOrBuilder
        getAvailableVersionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @return A list containing the validVersions.
     */
    java.util.List<java.lang.String> getValidVersionsList();
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @return The count of validVersions.
     */
    int getValidVersionsCount();
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The validVersions at the given index.
     */
    java.lang.String getValidVersions(int index);
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the validVersions at the given index.
     */
    com.google.protobuf.ByteString getValidVersionsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * ReleaseChannelConfig exposes configuration for a release channel.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.ServerConfig.ReleaseChannelConfig}
   */
  public static final class ReleaseChannelConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.ServerConfig.ReleaseChannelConfig)
      ReleaseChannelConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReleaseChannelConfig.newBuilder() to construct.
    private ReleaseChannelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReleaseChannelConfig() {
      channel_ = 0;
      defaultVersion_ = "";
      availableVersions_ = java.util.Collections.emptyList();
      validVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReleaseChannelConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.class,
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder.class);
    }

    @java.lang.Deprecated
    public interface AvailableVersionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Kubernetes version.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The version.
       */
      java.lang.String getVersion();
      /**
       *
       *
       * <pre>
       * Kubernetes version.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The bytes for version.
       */
      com.google.protobuf.ByteString getVersionBytes();

      /**
       *
       *
       * <pre>
       * Reason for availability.
       * </pre>
       *
       * <code>string reason = 2;</code>
       *
       * @return The reason.
       */
      java.lang.String getReason();
      /**
       *
       *
       * <pre>
       * Reason for availability.
       * </pre>
       *
       * <code>string reason = 2;</code>
       *
       * @return The bytes for reason.
       */
      com.google.protobuf.ByteString getReasonBytes();
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * </pre>
     *
     * Protobuf type {@code
     * google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion}
     */
    @java.lang.Deprecated
    public static final class AvailableVersion extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)
        AvailableVersionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AvailableVersion.newBuilder() to construct.
      private AvailableVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AvailableVersion() {
        version_ = "";
        reason_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AvailableVersion();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_AvailableVersion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_AvailableVersion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                    .class,
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                    .Builder.class);
      }

      public static final int VERSION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * Kubernetes version.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The version.
       */
      @java.lang.Override
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Kubernetes version.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The bytes for version.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REASON_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * Reason for availability.
       * </pre>
       *
       * <code>string reason = 2;</code>
       *
       * @return The reason.
       */
      @java.lang.Override
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          reason_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Reason for availability.
       * </pre>
       *
       * <code>string reason = 2;</code>
       *
       * @return The bytes for reason.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, reason_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, reason_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)) {
          return super.equals(obj);
        }
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion other =
            (com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion) obj;

        if (!getVersion().equals(other.getVersion())) return false;
        if (!getReason().equals(other.getReason())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReason().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * </pre>
       *
       * Protobuf type {@code
       * google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.container.v1beta1.ClusterServiceProto
              .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_AvailableVersion_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.container.v1beta1.ClusterServiceProto
              .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_AvailableVersion_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                      .class,
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                      .Builder.class);
        }

        // Construct using
        // com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          version_ = "";
          reason_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.container.v1beta1.ClusterServiceProto
              .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_AvailableVersion_descriptor;
        }

        @java.lang.Override
        public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
            getDefaultInstanceForType() {
          return com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
            build() {
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
            buildPartial() {
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion result =
              new com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.version_ = version_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.reason_ = reason_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion) {
            return mergeFrom(
                (com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion other) {
          if (other
              == com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                  .getDefaultInstance()) return this;
          if (!other.getVersion().isEmpty()) {
            version_ = other.version_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getReason().isEmpty()) {
            reason_ = other.reason_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    version_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    reason_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object version_ = "";
        /**
         *
         *
         * <pre>
         * Kubernetes version.
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return The version.
         */
        public java.lang.String getVersion() {
          java.lang.Object ref = version_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            version_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Kubernetes version.
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return The bytes for version.
         */
        public com.google.protobuf.ByteString getVersionBytes() {
          java.lang.Object ref = version_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            version_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Kubernetes version.
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @param value The version to set.
         * @return This builder for chaining.
         */
        public Builder setVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          version_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Kubernetes version.
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearVersion() {
          version_ = getDefaultInstance().getVersion();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Kubernetes version.
         * </pre>
         *
         * <code>string version = 1;</code>
         *
         * @param value The bytes for version to set.
         * @return This builder for chaining.
         */
        public Builder setVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          version_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object reason_ = "";
        /**
         *
         *
         * <pre>
         * Reason for availability.
         * </pre>
         *
         * <code>string reason = 2;</code>
         *
         * @return The reason.
         */
        public java.lang.String getReason() {
          java.lang.Object ref = reason_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            reason_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Reason for availability.
         * </pre>
         *
         * <code>string reason = 2;</code>
         *
         * @return The bytes for reason.
         */
        public com.google.protobuf.ByteString getReasonBytes() {
          java.lang.Object ref = reason_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            reason_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Reason for availability.
         * </pre>
         *
         * <code>string reason = 2;</code>
         *
         * @param value The reason to set.
         * @return This builder for chaining.
         */
        public Builder setReason(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          reason_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Reason for availability.
         * </pre>
         *
         * <code>string reason = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReason() {
          reason_ = getDefaultInstance().getReason();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Reason for availability.
         * </pre>
         *
         * <code>string reason = 2;</code>
         *
         * @param value The bytes for reason to set.
         * @return This builder for chaining.
         */
        public Builder setReasonBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          reason_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)
      }

      // @@protoc_insertion_point(class_scope:google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion)
      private static final com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
              .AvailableVersion
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion();
      }

      public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AvailableVersion> PARSER =
          new com.google.protobuf.AbstractParser<AvailableVersion>() {
            @java.lang.Override
            public AvailableVersion parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AvailableVersion> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AvailableVersion> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CHANNEL_FIELD_NUMBER = 1;
    private int channel_ = 0;
    /**
     *
     *
     * <pre>
     * The release channel this configuration applies to.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
     *
     * @return The enum numeric value on the wire for channel.
     */
    @java.lang.Override
    public int getChannelValue() {
      return channel_;
    }
    /**
     *
     *
     * <pre>
     * The release channel this configuration applies to.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
     *
     * @return The channel.
     */
    @java.lang.Override
    public com.google.container.v1beta1.ReleaseChannel.Channel getChannel() {
      com.google.container.v1beta1.ReleaseChannel.Channel result =
          com.google.container.v1beta1.ReleaseChannel.Channel.forNumber(channel_);
      return result == null
          ? com.google.container.v1beta1.ReleaseChannel.Channel.UNRECOGNIZED
          : result;
    }

    public static final int DEFAULT_VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object defaultVersion_ = "";
    /**
     *
     *
     * <pre>
     * The default version for newly created clusters on the channel.
     * </pre>
     *
     * <code>string default_version = 2;</code>
     *
     * @return The defaultVersion.
     */
    @java.lang.Override
    public java.lang.String getDefaultVersion() {
      java.lang.Object ref = defaultVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The default version for newly created clusters on the channel.
     * </pre>
     *
     * <code>string default_version = 2;</code>
     *
     * @return The bytes for defaultVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultVersionBytes() {
      java.lang.Object ref = defaultVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AVAILABLE_VERSIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion>
        availableVersions_;
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion>
        getAvailableVersionsList() {
      return availableVersions_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.List<
            ? extends
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                    .AvailableVersionOrBuilder>
        getAvailableVersionsOrBuilderList() {
      return availableVersions_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getAvailableVersionsCount() {
      return availableVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
        getAvailableVersions(int index) {
      return availableVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated.
     * This field has been deprecated and replaced with the valid_versions
     * field.
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersionOrBuilder
        getAvailableVersionsOrBuilder(int index) {
      return availableVersions_.get(index);
    }

    public static final int VALID_VERSIONS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList validVersions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @return A list containing the validVersions.
     */
    public com.google.protobuf.ProtocolStringList getValidVersionsList() {
      return validVersions_;
    }
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @return The count of validVersions.
     */
    public int getValidVersionsCount() {
      return validVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The validVersions at the given index.
     */
    public java.lang.String getValidVersions(int index) {
      return validVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid versions for the channel.
     * </pre>
     *
     * <code>repeated string valid_versions = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the validVersions at the given index.
     */
    public com.google.protobuf.ByteString getValidVersionsBytes(int index) {
      return validVersions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (channel_ != com.google.container.v1beta1.ReleaseChannel.Channel.UNSPECIFIED.getNumber()) {
        output.writeEnum(1, channel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, defaultVersion_);
      }
      for (int i = 0; i < availableVersions_.size(); i++) {
        output.writeMessage(3, availableVersions_.get(i));
      }
      for (int i = 0; i < validVersions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, validVersions_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (channel_ != com.google.container.v1beta1.ReleaseChannel.Channel.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, channel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, defaultVersion_);
      }
      for (int i = 0; i < availableVersions_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, availableVersions_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < validVersions_.size(); i++) {
          dataSize += computeStringSizeNoTag(validVersions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getValidVersionsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig other =
          (com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig) obj;

      if (channel_ != other.channel_) return false;
      if (!getDefaultVersion().equals(other.getDefaultVersion())) return false;
      if (!getAvailableVersionsList().equals(other.getAvailableVersionsList())) return false;
      if (!getValidVersionsList().equals(other.getValidVersionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + channel_;
      hash = (37 * hash) + DEFAULT_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultVersion().hashCode();
      if (getAvailableVersionsCount() > 0) {
        hash = (37 * hash) + AVAILABLE_VERSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableVersionsList().hashCode();
      }
      if (getValidVersionsCount() > 0) {
        hash = (37 * hash) + VALID_VERSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getValidVersionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReleaseChannelConfig exposes configuration for a release channel.
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.ServerConfig.ReleaseChannelConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.ServerConfig.ReleaseChannelConfig)
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.class,
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder.class);
      }

      // Construct using com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        channel_ = 0;
        defaultVersion_ = "";
        if (availableVersionsBuilder_ == null) {
          availableVersions_ = java.util.Collections.emptyList();
        } else {
          availableVersions_ = null;
          availableVersionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        validVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_ServerConfig_ReleaseChannelConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
          getDefaultInstanceForType() {
        return com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig build() {
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig buildPartial() {
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig result =
            new com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig result) {
        if (availableVersionsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            availableVersions_ = java.util.Collections.unmodifiableList(availableVersions_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.availableVersions_ = availableVersions_;
        } else {
          result.availableVersions_ = availableVersionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.channel_ = channel_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.defaultVersion_ = defaultVersion_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          validVersions_.makeImmutable();
          result.validVersions_ = validVersions_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig) {
          return mergeFrom((com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig other) {
        if (other
            == com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.getDefaultInstance())
          return this;
        if (other.channel_ != 0) {
          setChannelValue(other.getChannelValue());
        }
        if (!other.getDefaultVersion().isEmpty()) {
          defaultVersion_ = other.defaultVersion_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (availableVersionsBuilder_ == null) {
          if (!other.availableVersions_.isEmpty()) {
            if (availableVersions_.isEmpty()) {
              availableVersions_ = other.availableVersions_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureAvailableVersionsIsMutable();
              availableVersions_.addAll(other.availableVersions_);
            }
            onChanged();
          }
        } else {
          if (!other.availableVersions_.isEmpty()) {
            if (availableVersionsBuilder_.isEmpty()) {
              availableVersionsBuilder_.dispose();
              availableVersionsBuilder_ = null;
              availableVersions_ = other.availableVersions_;
              bitField0_ = (bitField0_ & ~0x00000004);
              availableVersionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAvailableVersionsFieldBuilder()
                      : null;
            } else {
              availableVersionsBuilder_.addAllMessages(other.availableVersions_);
            }
          }
        }
        if (!other.validVersions_.isEmpty()) {
          if (validVersions_.isEmpty()) {
            validVersions_ = other.validVersions_;
            bitField0_ |= 0x00000008;
          } else {
            ensureValidVersionsIsMutable();
            validVersions_.addAll(other.validVersions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  channel_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  defaultVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                      m =
                          input.readMessage(
                              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                                  .AvailableVersion.parser(),
                              extensionRegistry);
                  if (availableVersionsBuilder_ == null) {
                    ensureAvailableVersionsIsMutable();
                    availableVersions_.add(m);
                  } else {
                    availableVersionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureValidVersionsIsMutable();
                  validVersions_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int channel_ = 0;
      /**
       *
       *
       * <pre>
       * The release channel this configuration applies to.
       * </pre>
       *
       * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
       *
       * @return The enum numeric value on the wire for channel.
       */
      @java.lang.Override
      public int getChannelValue() {
        return channel_;
      }
      /**
       *
       *
       * <pre>
       * The release channel this configuration applies to.
       * </pre>
       *
       * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
       *
       * @param value The enum numeric value on the wire for channel to set.
       * @return This builder for chaining.
       */
      public Builder setChannelValue(int value) {
        channel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The release channel this configuration applies to.
       * </pre>
       *
       * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
       *
       * @return The channel.
       */
      @java.lang.Override
      public com.google.container.v1beta1.ReleaseChannel.Channel getChannel() {
        com.google.container.v1beta1.ReleaseChannel.Channel result =
            com.google.container.v1beta1.ReleaseChannel.Channel.forNumber(channel_);
        return result == null
            ? com.google.container.v1beta1.ReleaseChannel.Channel.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The release channel this configuration applies to.
       * </pre>
       *
       * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
       *
       * @param value The channel to set.
       * @return This builder for chaining.
       */
      public Builder setChannel(com.google.container.v1beta1.ReleaseChannel.Channel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The release channel this configuration applies to.
       * </pre>
       *
       * <code>.google.container.v1beta1.ReleaseChannel.Channel channel = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearChannel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        channel_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object defaultVersion_ = "";
      /**
       *
       *
       * <pre>
       * The default version for newly created clusters on the channel.
       * </pre>
       *
       * <code>string default_version = 2;</code>
       *
       * @return The defaultVersion.
       */
      public java.lang.String getDefaultVersion() {
        java.lang.Object ref = defaultVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The default version for newly created clusters on the channel.
       * </pre>
       *
       * <code>string default_version = 2;</code>
       *
       * @return The bytes for defaultVersion.
       */
      public com.google.protobuf.ByteString getDefaultVersionBytes() {
        java.lang.Object ref = defaultVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The default version for newly created clusters on the channel.
       * </pre>
       *
       * <code>string default_version = 2;</code>
       *
       * @param value The defaultVersion to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default version for newly created clusters on the channel.
       * </pre>
       *
       * <code>string default_version = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultVersion() {
        defaultVersion_ = getDefaultInstance().getDefaultVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The default version for newly created clusters on the channel.
       * </pre>
       *
       * <code>string default_version = 2;</code>
       *
       * @param value The bytes for defaultVersion to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        defaultVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion>
          availableVersions_ = java.util.Collections.emptyList();

      private void ensureAvailableVersionsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          availableVersions_ =
              new java.util.ArrayList<
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion>(
                  availableVersions_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion,
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                  .Builder,
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                  .AvailableVersionOrBuilder>
          availableVersionsBuilder_;

      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion>
          getAvailableVersionsList() {
        if (availableVersionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(availableVersions_);
        } else {
          return availableVersionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public int getAvailableVersionsCount() {
        if (availableVersionsBuilder_ == null) {
          return availableVersions_.size();
        } else {
          return availableVersionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
          getAvailableVersions(int index) {
        if (availableVersionsBuilder_ == null) {
          return availableVersions_.get(index);
        } else {
          return availableVersionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setAvailableVersions(
          int index,
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion value) {
        if (availableVersionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAvailableVersionsIsMutable();
          availableVersions_.set(index, value);
          onChanged();
        } else {
          availableVersionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder setAvailableVersions(
          int index,
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.Builder
              builderForValue) {
        if (availableVersionsBuilder_ == null) {
          ensureAvailableVersionsIsMutable();
          availableVersions_.set(index, builderForValue.build());
          onChanged();
        } else {
          availableVersionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAvailableVersions(
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion value) {
        if (availableVersionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAvailableVersionsIsMutable();
          availableVersions_.add(value);
          onChanged();
        } else {
          availableVersionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAvailableVersions(
          int index,
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion value) {
        if (availableVersionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAvailableVersionsIsMutable();
          availableVersions_.add(index, value);
          onChanged();
        } else {
          availableVersionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAvailableVersions(
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.Builder
              builderForValue) {
        if (availableVersionsBuilder_ == null) {
          ensureAvailableVersionsIsMutable();
          availableVersions_.add(builderForValue.build());
          onChanged();
        } else {
          availableVersionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAvailableVersions(
          int index,
          com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.Builder
              builderForValue) {
        if (availableVersionsBuilder_ == null) {
          ensureAvailableVersionsIsMutable();
          availableVersions_.add(index, builderForValue.build());
          onChanged();
        } else {
          availableVersionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder addAllAvailableVersions(
          java.lang.Iterable<
                  ? extends
                      com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                          .AvailableVersion>
              values) {
        if (availableVersionsBuilder_ == null) {
          ensureAvailableVersionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableVersions_);
          onChanged();
        } else {
          availableVersionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder clearAvailableVersions() {
        if (availableVersionsBuilder_ == null) {
          availableVersions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          availableVersionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public Builder removeAvailableVersions(int index) {
        if (availableVersionsBuilder_ == null) {
          ensureAvailableVersionsIsMutable();
          availableVersions_.remove(index);
          onChanged();
        } else {
          availableVersionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.Builder
          getAvailableVersionsBuilder(int index) {
        return getAvailableVersionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
              .AvailableVersionOrBuilder
          getAvailableVersionsOrBuilder(int index) {
        if (availableVersionsBuilder_ == null) {
          return availableVersions_.get(index);
        } else {
          return availableVersionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<
              ? extends
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                      .AvailableVersionOrBuilder>
          getAvailableVersionsOrBuilderList() {
        if (availableVersionsBuilder_ != null) {
          return availableVersionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(availableVersions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.Builder
          addAvailableVersionsBuilder() {
        return getAvailableVersionsFieldBuilder()
            .addBuilder(
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion.Builder
          addAvailableVersionsBuilder(int index) {
        return getAvailableVersionsFieldBuilder()
            .addBuilder(
                index,
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Deprecated.
       * This field has been deprecated and replaced with the valid_versions
       * field.
       * </pre>
       *
       * <code>
       * repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion available_versions = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      public java.util.List<
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                  .Builder>
          getAvailableVersionsBuilderList() {
        return getAvailableVersionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion,
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                  .Builder,
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                  .AvailableVersionOrBuilder>
          getAvailableVersionsFieldBuilder() {
        if (availableVersionsBuilder_ == null) {
          availableVersionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion,
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.AvailableVersion
                      .Builder,
                  com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
                      .AvailableVersionOrBuilder>(
                  availableVersions_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          availableVersions_ = null;
        }
        return availableVersionsBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList validVersions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureValidVersionsIsMutable() {
        if (!validVersions_.isModifiable()) {
          validVersions_ = new com.google.protobuf.LazyStringArrayList(validVersions_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @return A list containing the validVersions.
       */
      public com.google.protobuf.ProtocolStringList getValidVersionsList() {
        validVersions_.makeImmutable();
        return validVersions_;
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @return The count of validVersions.
       */
      public int getValidVersionsCount() {
        return validVersions_.size();
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The validVersions at the given index.
       */
      public java.lang.String getValidVersions(int index) {
        return validVersions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the validVersions at the given index.
       */
      public com.google.protobuf.ByteString getValidVersionsBytes(int index) {
        return validVersions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The validVersions to set.
       * @return This builder for chaining.
       */
      public Builder setValidVersions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValidVersionsIsMutable();
        validVersions_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @param value The validVersions to add.
       * @return This builder for chaining.
       */
      public Builder addValidVersions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureValidVersionsIsMutable();
        validVersions_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @param values The validVersions to add.
       * @return This builder for chaining.
       */
      public Builder addAllValidVersions(java.lang.Iterable<java.lang.String> values) {
        ensureValidVersionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, validVersions_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValidVersions() {
        validVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of valid versions for the channel.
       * </pre>
       *
       * <code>repeated string valid_versions = 4;</code>
       *
       * @param value The bytes of the validVersions to add.
       * @return This builder for chaining.
       */
      public Builder addValidVersionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureValidVersionsIsMutable();
        validVersions_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.ServerConfig.ReleaseChannelConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.ServerConfig.ReleaseChannelConfig)
    private static final com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig();
    }

    public static com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReleaseChannelConfig> PARSER =
        new com.google.protobuf.AbstractParser<ReleaseChannelConfig>() {
          @java.lang.Override
          public ReleaseChannelConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReleaseChannelConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReleaseChannelConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DEFAULT_CLUSTER_VERSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultClusterVersion_ = "";
  /**
   *
   *
   * <pre>
   * Version of Kubernetes the service deploys by default.
   * </pre>
   *
   * <code>string default_cluster_version = 1;</code>
   *
   * @return The defaultClusterVersion.
   */
  @java.lang.Override
  public java.lang.String getDefaultClusterVersion() {
    java.lang.Object ref = defaultClusterVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultClusterVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Version of Kubernetes the service deploys by default.
   * </pre>
   *
   * <code>string default_cluster_version = 1;</code>
   *
   * @return The bytes for defaultClusterVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultClusterVersionBytes() {
    java.lang.Object ref = defaultClusterVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultClusterVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALID_NODE_VERSIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList validNodeVersions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of valid node upgrade target versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_node_versions = 3;</code>
   *
   * @return A list containing the validNodeVersions.
   */
  public com.google.protobuf.ProtocolStringList getValidNodeVersionsList() {
    return validNodeVersions_;
  }
  /**
   *
   *
   * <pre>
   * List of valid node upgrade target versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_node_versions = 3;</code>
   *
   * @return The count of validNodeVersions.
   */
  public int getValidNodeVersionsCount() {
    return validNodeVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of valid node upgrade target versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_node_versions = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The validNodeVersions at the given index.
   */
  public java.lang.String getValidNodeVersions(int index) {
    return validNodeVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of valid node upgrade target versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_node_versions = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the validNodeVersions at the given index.
   */
  public com.google.protobuf.ByteString getValidNodeVersionsBytes(int index) {
    return validNodeVersions_.getByteString(index);
  }

  public static final int DEFAULT_IMAGE_TYPE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultImageType_ = "";
  /**
   *
   *
   * <pre>
   * Default image type.
   * </pre>
   *
   * <code>string default_image_type = 4;</code>
   *
   * @return The defaultImageType.
   */
  @java.lang.Override
  public java.lang.String getDefaultImageType() {
    java.lang.Object ref = defaultImageType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultImageType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Default image type.
   * </pre>
   *
   * <code>string default_image_type = 4;</code>
   *
   * @return The bytes for defaultImageType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultImageTypeBytes() {
    java.lang.Object ref = defaultImageType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultImageType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALID_IMAGE_TYPES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList validImageTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of valid image types.
   * </pre>
   *
   * <code>repeated string valid_image_types = 5;</code>
   *
   * @return A list containing the validImageTypes.
   */
  public com.google.protobuf.ProtocolStringList getValidImageTypesList() {
    return validImageTypes_;
  }
  /**
   *
   *
   * <pre>
   * List of valid image types.
   * </pre>
   *
   * <code>repeated string valid_image_types = 5;</code>
   *
   * @return The count of validImageTypes.
   */
  public int getValidImageTypesCount() {
    return validImageTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * List of valid image types.
   * </pre>
   *
   * <code>repeated string valid_image_types = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The validImageTypes at the given index.
   */
  public java.lang.String getValidImageTypes(int index) {
    return validImageTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of valid image types.
   * </pre>
   *
   * <code>repeated string valid_image_types = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the validImageTypes at the given index.
   */
  public com.google.protobuf.ByteString getValidImageTypesBytes(int index) {
    return validImageTypes_.getByteString(index);
  }

  public static final int VALID_MASTER_VERSIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList validMasterVersions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of valid master versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_master_versions = 6;</code>
   *
   * @return A list containing the validMasterVersions.
   */
  public com.google.protobuf.ProtocolStringList getValidMasterVersionsList() {
    return validMasterVersions_;
  }
  /**
   *
   *
   * <pre>
   * List of valid master versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_master_versions = 6;</code>
   *
   * @return The count of validMasterVersions.
   */
  public int getValidMasterVersionsCount() {
    return validMasterVersions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of valid master versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_master_versions = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The validMasterVersions at the given index.
   */
  public java.lang.String getValidMasterVersions(int index) {
    return validMasterVersions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of valid master versions, in descending order.
   * </pre>
   *
   * <code>repeated string valid_master_versions = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the validMasterVersions at the given index.
   */
  public com.google.protobuf.ByteString getValidMasterVersionsBytes(int index) {
    return validMasterVersions_.getByteString(index);
  }

  public static final int CHANNELS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig> channels_;
  /**
   *
   *
   * <pre>
   * List of release channel configurations.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig>
      getChannelsList() {
    return channels_;
  }
  /**
   *
   *
   * <pre>
   * List of release channel configurations.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder>
      getChannelsOrBuilderList() {
    return channels_;
  }
  /**
   *
   *
   * <pre>
   * List of release channel configurations.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;</code>
   */
  @java.lang.Override
  public int getChannelsCount() {
    return channels_.size();
  }
  /**
   *
   *
   * <pre>
   * List of release channel configurations.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig getChannels(int index) {
    return channels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of release channel configurations.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder
      getChannelsOrBuilder(int index) {
    return channels_.get(index);
  }

  public static final int WINDOWS_VERSION_MAPS_FIELD_NUMBER = 10;

  private static final class WindowsVersionMapsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.container.v1beta1.WindowsVersions>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.container.v1beta1.WindowsVersions>newDefaultInstance(
                    com.google.container.v1beta1.ClusterServiceProto
                        .internal_static_google_container_v1beta1_ServerConfig_WindowsVersionMapsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.container.v1beta1.WindowsVersions.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.container.v1beta1.WindowsVersions>
      windowsVersionMaps_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.container.v1beta1.WindowsVersions>
      internalGetWindowsVersionMaps() {
    if (windowsVersionMaps_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          WindowsVersionMapsDefaultEntryHolder.defaultEntry);
    }
    return windowsVersionMaps_;
  }

  public int getWindowsVersionMapsCount() {
    return internalGetWindowsVersionMaps().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Maps of Kubernetes version and supported Windows server versions.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
   * </code>
   */
  @java.lang.Override
  public boolean containsWindowsVersionMaps(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetWindowsVersionMaps().getMap().containsKey(key);
  }
  /** Use {@link #getWindowsVersionMapsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions>
      getWindowsVersionMaps() {
    return getWindowsVersionMapsMap();
  }
  /**
   *
   *
   * <pre>
   * Maps of Kubernetes version and supported Windows server versions.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions>
      getWindowsVersionMapsMap() {
    return internalGetWindowsVersionMaps().getMap();
  }
  /**
   *
   *
   * <pre>
   * Maps of Kubernetes version and supported Windows server versions.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.container.v1beta1.WindowsVersions getWindowsVersionMapsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.container.v1beta1.WindowsVersions defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions> map =
        internalGetWindowsVersionMaps().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Maps of Kubernetes version and supported Windows server versions.
   * </pre>
   *
   * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.WindowsVersions getWindowsVersionMapsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions> map =
        internalGetWindowsVersionMaps().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultClusterVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultClusterVersion_);
    }
    for (int i = 0; i < validNodeVersions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, validNodeVersions_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultImageType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, defaultImageType_);
    }
    for (int i = 0; i < validImageTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, validImageTypes_.getRaw(i));
    }
    for (int i = 0; i < validMasterVersions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, validMasterVersions_.getRaw(i));
    }
    for (int i = 0; i < channels_.size(); i++) {
      output.writeMessage(9, channels_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetWindowsVersionMaps(),
        WindowsVersionMapsDefaultEntryHolder.defaultEntry,
        10);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultClusterVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultClusterVersion_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < validNodeVersions_.size(); i++) {
        dataSize += computeStringSizeNoTag(validNodeVersions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getValidNodeVersionsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultImageType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, defaultImageType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < validImageTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(validImageTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getValidImageTypesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < validMasterVersions_.size(); i++) {
        dataSize += computeStringSizeNoTag(validMasterVersions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getValidMasterVersionsList().size();
    }
    for (int i = 0; i < channels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, channels_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.container.v1beta1.WindowsVersions> entry :
        internalGetWindowsVersionMaps().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.container.v1beta1.WindowsVersions>
          windowsVersionMaps__ =
              WindowsVersionMapsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, windowsVersionMaps__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.ServerConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.ServerConfig other =
        (com.google.container.v1beta1.ServerConfig) obj;

    if (!getDefaultClusterVersion().equals(other.getDefaultClusterVersion())) return false;
    if (!getValidNodeVersionsList().equals(other.getValidNodeVersionsList())) return false;
    if (!getDefaultImageType().equals(other.getDefaultImageType())) return false;
    if (!getValidImageTypesList().equals(other.getValidImageTypesList())) return false;
    if (!getValidMasterVersionsList().equals(other.getValidMasterVersionsList())) return false;
    if (!getChannelsList().equals(other.getChannelsList())) return false;
    if (!internalGetWindowsVersionMaps().equals(other.internalGetWindowsVersionMaps()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DEFAULT_CLUSTER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultClusterVersion().hashCode();
    if (getValidNodeVersionsCount() > 0) {
      hash = (37 * hash) + VALID_NODE_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getValidNodeVersionsList().hashCode();
    }
    hash = (37 * hash) + DEFAULT_IMAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultImageType().hashCode();
    if (getValidImageTypesCount() > 0) {
      hash = (37 * hash) + VALID_IMAGE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getValidImageTypesList().hashCode();
    }
    if (getValidMasterVersionsCount() > 0) {
      hash = (37 * hash) + VALID_MASTER_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getValidMasterVersionsList().hashCode();
    }
    if (getChannelsCount() > 0) {
      hash = (37 * hash) + CHANNELS_FIELD_NUMBER;
      hash = (53 * hash) + getChannelsList().hashCode();
    }
    if (!internalGetWindowsVersionMaps().getMap().isEmpty()) {
      hash = (37 * hash) + WINDOWS_VERSION_MAPS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetWindowsVersionMaps().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.ServerConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ServerConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ServerConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.ServerConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes Engine service configuration.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.ServerConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.ServerConfig)
      com.google.container.v1beta1.ServerConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ServerConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetWindowsVersionMaps();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableWindowsVersionMaps();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ServerConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.ServerConfig.class,
              com.google.container.v1beta1.ServerConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.ServerConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      defaultClusterVersion_ = "";
      validNodeVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      defaultImageType_ = "";
      validImageTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      validMasterVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (channelsBuilder_ == null) {
        channels_ = java.util.Collections.emptyList();
      } else {
        channels_ = null;
        channelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableWindowsVersionMaps().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ServerConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ServerConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.ServerConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.ServerConfig build() {
      com.google.container.v1beta1.ServerConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ServerConfig buildPartial() {
      com.google.container.v1beta1.ServerConfig result =
          new com.google.container.v1beta1.ServerConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1beta1.ServerConfig result) {
      if (channelsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          channels_ = java.util.Collections.unmodifiableList(channels_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.channels_ = channels_;
      } else {
        result.channels_ = channelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1beta1.ServerConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.defaultClusterVersion_ = defaultClusterVersion_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        validNodeVersions_.makeImmutable();
        result.validNodeVersions_ = validNodeVersions_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultImageType_ = defaultImageType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        validImageTypes_.makeImmutable();
        result.validImageTypes_ = validImageTypes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        validMasterVersions_.makeImmutable();
        result.validMasterVersions_ = validMasterVersions_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.windowsVersionMaps_ =
            internalGetWindowsVersionMaps()
                .build(WindowsVersionMapsDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.ServerConfig) {
        return mergeFrom((com.google.container.v1beta1.ServerConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.ServerConfig other) {
      if (other == com.google.container.v1beta1.ServerConfig.getDefaultInstance()) return this;
      if (!other.getDefaultClusterVersion().isEmpty()) {
        defaultClusterVersion_ = other.defaultClusterVersion_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.validNodeVersions_.isEmpty()) {
        if (validNodeVersions_.isEmpty()) {
          validNodeVersions_ = other.validNodeVersions_;
          bitField0_ |= 0x00000002;
        } else {
          ensureValidNodeVersionsIsMutable();
          validNodeVersions_.addAll(other.validNodeVersions_);
        }
        onChanged();
      }
      if (!other.getDefaultImageType().isEmpty()) {
        defaultImageType_ = other.defaultImageType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.validImageTypes_.isEmpty()) {
        if (validImageTypes_.isEmpty()) {
          validImageTypes_ = other.validImageTypes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureValidImageTypesIsMutable();
          validImageTypes_.addAll(other.validImageTypes_);
        }
        onChanged();
      }
      if (!other.validMasterVersions_.isEmpty()) {
        if (validMasterVersions_.isEmpty()) {
          validMasterVersions_ = other.validMasterVersions_;
          bitField0_ |= 0x00000010;
        } else {
          ensureValidMasterVersionsIsMutable();
          validMasterVersions_.addAll(other.validMasterVersions_);
        }
        onChanged();
      }
      if (channelsBuilder_ == null) {
        if (!other.channels_.isEmpty()) {
          if (channels_.isEmpty()) {
            channels_ = other.channels_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureChannelsIsMutable();
            channels_.addAll(other.channels_);
          }
          onChanged();
        }
      } else {
        if (!other.channels_.isEmpty()) {
          if (channelsBuilder_.isEmpty()) {
            channelsBuilder_.dispose();
            channelsBuilder_ = null;
            channels_ = other.channels_;
            bitField0_ = (bitField0_ & ~0x00000020);
            channelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChannelsFieldBuilder()
                    : null;
          } else {
            channelsBuilder_.addAllMessages(other.channels_);
          }
        }
      }
      internalGetMutableWindowsVersionMaps().mergeFrom(other.internalGetWindowsVersionMaps());
      bitField0_ |= 0x00000040;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                defaultClusterVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureValidNodeVersionsIsMutable();
                validNodeVersions_.add(s);
                break;
              } // case 26
            case 34:
              {
                defaultImageType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureValidImageTypesIsMutable();
                validImageTypes_.add(s);
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureValidMasterVersionsIsMutable();
                validMasterVersions_.add(s);
                break;
              } // case 50
            case 74:
              {
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig m =
                    input.readMessage(
                        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.parser(),
                        extensionRegistry);
                if (channelsBuilder_ == null) {
                  ensureChannelsIsMutable();
                  channels_.add(m);
                } else {
                  channelsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.container.v1beta1.WindowsVersions>
                    windowsVersionMaps__ =
                        input.readMessage(
                            WindowsVersionMapsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableWindowsVersionMaps()
                    .ensureBuilderMap()
                    .put(windowsVersionMaps__.getKey(), windowsVersionMaps__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object defaultClusterVersion_ = "";
    /**
     *
     *
     * <pre>
     * Version of Kubernetes the service deploys by default.
     * </pre>
     *
     * <code>string default_cluster_version = 1;</code>
     *
     * @return The defaultClusterVersion.
     */
    public java.lang.String getDefaultClusterVersion() {
      java.lang.Object ref = defaultClusterVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultClusterVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Version of Kubernetes the service deploys by default.
     * </pre>
     *
     * <code>string default_cluster_version = 1;</code>
     *
     * @return The bytes for defaultClusterVersion.
     */
    public com.google.protobuf.ByteString getDefaultClusterVersionBytes() {
      java.lang.Object ref = defaultClusterVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultClusterVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Version of Kubernetes the service deploys by default.
     * </pre>
     *
     * <code>string default_cluster_version = 1;</code>
     *
     * @param value The defaultClusterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultClusterVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultClusterVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version of Kubernetes the service deploys by default.
     * </pre>
     *
     * <code>string default_cluster_version = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultClusterVersion() {
      defaultClusterVersion_ = getDefaultInstance().getDefaultClusterVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version of Kubernetes the service deploys by default.
     * </pre>
     *
     * <code>string default_cluster_version = 1;</code>
     *
     * @param value The bytes for defaultClusterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultClusterVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultClusterVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList validNodeVersions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureValidNodeVersionsIsMutable() {
      if (!validNodeVersions_.isModifiable()) {
        validNodeVersions_ = new com.google.protobuf.LazyStringArrayList(validNodeVersions_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @return A list containing the validNodeVersions.
     */
    public com.google.protobuf.ProtocolStringList getValidNodeVersionsList() {
      validNodeVersions_.makeImmutable();
      return validNodeVersions_;
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @return The count of validNodeVersions.
     */
    public int getValidNodeVersionsCount() {
      return validNodeVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The validNodeVersions at the given index.
     */
    public java.lang.String getValidNodeVersions(int index) {
      return validNodeVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the validNodeVersions at the given index.
     */
    public com.google.protobuf.ByteString getValidNodeVersionsBytes(int index) {
      return validNodeVersions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The validNodeVersions to set.
     * @return This builder for chaining.
     */
    public Builder setValidNodeVersions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValidNodeVersionsIsMutable();
      validNodeVersions_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @param value The validNodeVersions to add.
     * @return This builder for chaining.
     */
    public Builder addValidNodeVersions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValidNodeVersionsIsMutable();
      validNodeVersions_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @param values The validNodeVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAllValidNodeVersions(java.lang.Iterable<java.lang.String> values) {
      ensureValidNodeVersionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, validNodeVersions_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidNodeVersions() {
      validNodeVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid node upgrade target versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_node_versions = 3;</code>
     *
     * @param value The bytes of the validNodeVersions to add.
     * @return This builder for chaining.
     */
    public Builder addValidNodeVersionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureValidNodeVersionsIsMutable();
      validNodeVersions_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object defaultImageType_ = "";
    /**
     *
     *
     * <pre>
     * Default image type.
     * </pre>
     *
     * <code>string default_image_type = 4;</code>
     *
     * @return The defaultImageType.
     */
    public java.lang.String getDefaultImageType() {
      java.lang.Object ref = defaultImageType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultImageType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Default image type.
     * </pre>
     *
     * <code>string default_image_type = 4;</code>
     *
     * @return The bytes for defaultImageType.
     */
    public com.google.protobuf.ByteString getDefaultImageTypeBytes() {
      java.lang.Object ref = defaultImageType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultImageType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Default image type.
     * </pre>
     *
     * <code>string default_image_type = 4;</code>
     *
     * @param value The defaultImageType to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultImageType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultImageType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default image type.
     * </pre>
     *
     * <code>string default_image_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultImageType() {
      defaultImageType_ = getDefaultInstance().getDefaultImageType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default image type.
     * </pre>
     *
     * <code>string default_image_type = 4;</code>
     *
     * @param value The bytes for defaultImageType to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultImageTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultImageType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList validImageTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureValidImageTypesIsMutable() {
      if (!validImageTypes_.isModifiable()) {
        validImageTypes_ = new com.google.protobuf.LazyStringArrayList(validImageTypes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @return A list containing the validImageTypes.
     */
    public com.google.protobuf.ProtocolStringList getValidImageTypesList() {
      validImageTypes_.makeImmutable();
      return validImageTypes_;
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @return The count of validImageTypes.
     */
    public int getValidImageTypesCount() {
      return validImageTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The validImageTypes at the given index.
     */
    public java.lang.String getValidImageTypes(int index) {
      return validImageTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the validImageTypes at the given index.
     */
    public com.google.protobuf.ByteString getValidImageTypesBytes(int index) {
      return validImageTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The validImageTypes to set.
     * @return This builder for chaining.
     */
    public Builder setValidImageTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValidImageTypesIsMutable();
      validImageTypes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @param value The validImageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addValidImageTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValidImageTypesIsMutable();
      validImageTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @param values The validImageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllValidImageTypes(java.lang.Iterable<java.lang.String> values) {
      ensureValidImageTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, validImageTypes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidImageTypes() {
      validImageTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid image types.
     * </pre>
     *
     * <code>repeated string valid_image_types = 5;</code>
     *
     * @param value The bytes of the validImageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addValidImageTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureValidImageTypesIsMutable();
      validImageTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList validMasterVersions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureValidMasterVersionsIsMutable() {
      if (!validMasterVersions_.isModifiable()) {
        validMasterVersions_ = new com.google.protobuf.LazyStringArrayList(validMasterVersions_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @return A list containing the validMasterVersions.
     */
    public com.google.protobuf.ProtocolStringList getValidMasterVersionsList() {
      validMasterVersions_.makeImmutable();
      return validMasterVersions_;
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @return The count of validMasterVersions.
     */
    public int getValidMasterVersionsCount() {
      return validMasterVersions_.size();
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The validMasterVersions at the given index.
     */
    public java.lang.String getValidMasterVersions(int index) {
      return validMasterVersions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the validMasterVersions at the given index.
     */
    public com.google.protobuf.ByteString getValidMasterVersionsBytes(int index) {
      return validMasterVersions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The validMasterVersions to set.
     * @return This builder for chaining.
     */
    public Builder setValidMasterVersions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValidMasterVersionsIsMutable();
      validMasterVersions_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @param value The validMasterVersions to add.
     * @return This builder for chaining.
     */
    public Builder addValidMasterVersions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValidMasterVersionsIsMutable();
      validMasterVersions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @param values The validMasterVersions to add.
     * @return This builder for chaining.
     */
    public Builder addAllValidMasterVersions(java.lang.Iterable<java.lang.String> values) {
      ensureValidMasterVersionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, validMasterVersions_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidMasterVersions() {
      validMasterVersions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of valid master versions, in descending order.
     * </pre>
     *
     * <code>repeated string valid_master_versions = 6;</code>
     *
     * @param value The bytes of the validMasterVersions to add.
     * @return This builder for chaining.
     */
    public Builder addValidMasterVersionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureValidMasterVersionsIsMutable();
      validMasterVersions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig>
        channels_ = java.util.Collections.emptyList();

    private void ensureChannelsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        channels_ =
            new java.util.ArrayList<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig>(
                channels_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig,
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder,
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder>
        channelsBuilder_;

    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public java.util.List<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig>
        getChannelsList() {
      if (channelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(channels_);
      } else {
        return channelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public int getChannelsCount() {
      if (channelsBuilder_ == null) {
        return channels_.size();
      } else {
        return channelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig getChannels(int index) {
      if (channelsBuilder_ == null) {
        return channels_.get(index);
      } else {
        return channelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder setChannels(
        int index, com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig value) {
      if (channelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelsIsMutable();
        channels_.set(index, value);
        onChanged();
      } else {
        channelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder setChannels(
        int index,
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder builderForValue) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.set(index, builderForValue.build());
        onChanged();
      } else {
        channelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder addChannels(
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig value) {
      if (channelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelsIsMutable();
        channels_.add(value);
        onChanged();
      } else {
        channelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder addChannels(
        int index, com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig value) {
      if (channelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelsIsMutable();
        channels_.add(index, value);
        onChanged();
      } else {
        channelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder addChannels(
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder builderForValue) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.add(builderForValue.build());
        onChanged();
      } else {
        channelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder addChannels(
        int index,
        com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder builderForValue) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.add(index, builderForValue.build());
        onChanged();
      } else {
        channelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder addAllChannels(
        java.lang.Iterable<? extends com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig>
            values) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, channels_);
        onChanged();
      } else {
        channelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder clearChannels() {
      if (channelsBuilder_ == null) {
        channels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        channelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public Builder removeChannels(int index) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.remove(index);
        onChanged();
      } else {
        channelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder
        getChannelsBuilder(int index) {
      return getChannelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder
        getChannelsOrBuilder(int index) {
      if (channelsBuilder_ == null) {
        return channels_.get(index);
      } else {
        return channelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public java.util.List<
            ? extends com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder>
        getChannelsOrBuilderList() {
      if (channelsBuilder_ != null) {
        return channelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(channels_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder
        addChannelsBuilder() {
      return getChannelsFieldBuilder()
          .addBuilder(
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder
        addChannelsBuilder(int index) {
      return getChannelsFieldBuilder()
          .addBuilder(
              index,
              com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of release channel configurations.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ServerConfig.ReleaseChannelConfig channels = 9;
     * </code>
     */
    public java.util.List<com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder>
        getChannelsBuilderList() {
      return getChannelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig,
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder,
            com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder>
        getChannelsFieldBuilder() {
      if (channelsBuilder_ == null) {
        channelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig,
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfig.Builder,
                com.google.container.v1beta1.ServerConfig.ReleaseChannelConfigOrBuilder>(
                channels_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        channels_ = null;
      }
      return channelsBuilder_;
    }

    private static final class WindowsVersionMapsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.container.v1beta1.WindowsVersionsOrBuilder,
            com.google.container.v1beta1.WindowsVersions> {
      @java.lang.Override
      public com.google.container.v1beta1.WindowsVersions build(
          com.google.container.v1beta1.WindowsVersionsOrBuilder val) {
        if (val instanceof com.google.container.v1beta1.WindowsVersions) {
          return (com.google.container.v1beta1.WindowsVersions) val;
        }
        return ((com.google.container.v1beta1.WindowsVersions.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.container.v1beta1.WindowsVersions>
          defaultEntry() {
        return WindowsVersionMapsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final WindowsVersionMapsConverter windowsVersionMapsConverter =
        new WindowsVersionMapsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.container.v1beta1.WindowsVersionsOrBuilder,
            com.google.container.v1beta1.WindowsVersions,
            com.google.container.v1beta1.WindowsVersions.Builder>
        windowsVersionMaps_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.container.v1beta1.WindowsVersionsOrBuilder,
            com.google.container.v1beta1.WindowsVersions,
            com.google.container.v1beta1.WindowsVersions.Builder>
        internalGetWindowsVersionMaps() {
      if (windowsVersionMaps_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(windowsVersionMapsConverter);
      }
      return windowsVersionMaps_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.container.v1beta1.WindowsVersionsOrBuilder,
            com.google.container.v1beta1.WindowsVersions,
            com.google.container.v1beta1.WindowsVersions.Builder>
        internalGetMutableWindowsVersionMaps() {
      if (windowsVersionMaps_ == null) {
        windowsVersionMaps_ =
            new com.google.protobuf.MapFieldBuilder<>(windowsVersionMapsConverter);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return windowsVersionMaps_;
    }

    public int getWindowsVersionMapsCount() {
      return internalGetWindowsVersionMaps().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    @java.lang.Override
    public boolean containsWindowsVersionMaps(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetWindowsVersionMaps().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getWindowsVersionMapsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions>
        getWindowsVersionMaps() {
      return getWindowsVersionMapsMap();
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions>
        getWindowsVersionMapsMap() {
      return internalGetWindowsVersionMaps().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.container.v1beta1.WindowsVersions
        getWindowsVersionMapsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.container.v1beta1.WindowsVersions defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersionsOrBuilder> map =
          internalGetMutableWindowsVersionMaps().ensureBuilderMap();
      return map.containsKey(key) ? windowsVersionMapsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.container.v1beta1.WindowsVersions getWindowsVersionMapsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersionsOrBuilder> map =
          internalGetMutableWindowsVersionMaps().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return windowsVersionMapsConverter.build(map.get(key));
    }

    public Builder clearWindowsVersionMaps() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableWindowsVersionMaps().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    public Builder removeWindowsVersionMaps(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableWindowsVersionMaps().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions>
        getMutableWindowsVersionMaps() {
      bitField0_ |= 0x00000040;
      return internalGetMutableWindowsVersionMaps().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    public Builder putWindowsVersionMaps(
        java.lang.String key, com.google.container.v1beta1.WindowsVersions value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableWindowsVersionMaps().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    public Builder putAllWindowsVersionMaps(
        java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersions> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.container.v1beta1.WindowsVersions> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableWindowsVersionMaps().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maps of Kubernetes version and supported Windows server versions.
     * </pre>
     *
     * <code>map&lt;string, .google.container.v1beta1.WindowsVersions&gt; windows_version_maps = 10;
     * </code>
     */
    public com.google.container.v1beta1.WindowsVersions.Builder
        putWindowsVersionMapsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.container.v1beta1.WindowsVersionsOrBuilder>
          builderMap = internalGetMutableWindowsVersionMaps().ensureBuilderMap();
      com.google.container.v1beta1.WindowsVersionsOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.container.v1beta1.WindowsVersions.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.container.v1beta1.WindowsVersions) {
        entry = ((com.google.container.v1beta1.WindowsVersions) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.container.v1beta1.WindowsVersions.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.ServerConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.ServerConfig)
  private static final com.google.container.v1beta1.ServerConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.ServerConfig();
  }

  public static com.google.container.v1beta1.ServerConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServerConfig> PARSER =
      new com.google.protobuf.AbstractParser<ServerConfig>() {
        @java.lang.Override
        public ServerConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServerConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServerConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.ServerConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
