/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * SetNetworkPolicyRequest enables/disables network policy for a cluster.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.SetNetworkPolicyRequest}
 */
public final class SetNetworkPolicyRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.SetNetworkPolicyRequest)
    SetNetworkPolicyRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetNetworkPolicyRequest.newBuilder() to construct.
  private SetNetworkPolicyRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetNetworkPolicyRequest() {
    projectId_ = "";
    zone_ = "";
    clusterId_ = "";
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetNetworkPolicyRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_SetNetworkPolicyRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_SetNetworkPolicyRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.SetNetworkPolicyRequest.class,
            com.google.container.v1beta1.SetNetworkPolicyRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Required. Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=4969
   * @return The projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Deprecated. The Google Developers Console [project ID or project
   * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=4969
   * @return The bytes for projectId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Required. Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
   *
   * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=4976
   * @return The zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Deprecated. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field has been deprecated and replaced by the name
   * field.
   * </pre>
   *
   * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
   *
   * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=4976
   * @return The bytes for zone.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clusterId_ = "";
  /**
   *
   *
   * <pre>
   * Required. Deprecated. The name of the cluster.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=4980
   * @return The clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getClusterId() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clusterId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Deprecated. The name of the cluster.
   * This field has been deprecated and replaced by the name field.
   * </pre>
   *
   * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=4980
   * @return The bytes for clusterId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getClusterIdBytes() {
    java.lang.Object ref = clusterId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clusterId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_POLICY_FIELD_NUMBER = 4;
  private com.google.container.v1beta1.NetworkPolicy networkPolicy_;
  /**
   *
   *
   * <pre>
   * Required. Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the networkPolicy field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The networkPolicy.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkPolicy getNetworkPolicy() {
    return networkPolicy_ == null
        ? com.google.container.v1beta1.NetworkPolicy.getDefaultInstance()
        : networkPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkPolicyOrBuilder getNetworkPolicyOrBuilder() {
    return networkPolicy_ == null
        ? com.google.container.v1beta1.NetworkPolicy.getDefaultInstance()
        : networkPolicy_;
  }

  public static final int NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster name) of the cluster to set networking
   * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name (project, location, cluster name) of the cluster to set networking
   * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
   * </pre>
   *
   * <code>string name = 6;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clusterId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getNetworkPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clusterId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNetworkPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.SetNetworkPolicyRequest)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.SetNetworkPolicyRequest other =
        (com.google.container.v1beta1.SetNetworkPolicyRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (!getClusterId().equals(other.getClusterId())) return false;
    if (hasNetworkPolicy() != other.hasNetworkPolicy()) return false;
    if (hasNetworkPolicy()) {
      if (!getNetworkPolicy().equals(other.getNetworkPolicy())) return false;
    }
    if (!getName().equals(other.getName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getClusterId().hashCode();
    if (hasNetworkPolicy()) {
      hash = (37 * hash) + NETWORK_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPolicy().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.SetNetworkPolicyRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SetNetworkPolicyRequest enables/disables network policy for a cluster.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.SetNetworkPolicyRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.SetNetworkPolicyRequest)
      com.google.container.v1beta1.SetNetworkPolicyRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_SetNetworkPolicyRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_SetNetworkPolicyRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.SetNetworkPolicyRequest.class,
              com.google.container.v1beta1.SetNetworkPolicyRequest.Builder.class);
    }

    // Construct using com.google.container.v1beta1.SetNetworkPolicyRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNetworkPolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      zone_ = "";
      clusterId_ = "";
      networkPolicy_ = null;
      if (networkPolicyBuilder_ != null) {
        networkPolicyBuilder_.dispose();
        networkPolicyBuilder_ = null;
      }
      name_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_SetNetworkPolicyRequest_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.SetNetworkPolicyRequest getDefaultInstanceForType() {
      return com.google.container.v1beta1.SetNetworkPolicyRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.SetNetworkPolicyRequest build() {
      com.google.container.v1beta1.SetNetworkPolicyRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.SetNetworkPolicyRequest buildPartial() {
      com.google.container.v1beta1.SetNetworkPolicyRequest result =
          new com.google.container.v1beta1.SetNetworkPolicyRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.SetNetworkPolicyRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clusterId_ = clusterId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.networkPolicy_ =
            networkPolicyBuilder_ == null ? networkPolicy_ : networkPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.SetNetworkPolicyRequest) {
        return mergeFrom((com.google.container.v1beta1.SetNetworkPolicyRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.SetNetworkPolicyRequest other) {
      if (other == com.google.container.v1beta1.SetNetworkPolicyRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClusterId().isEmpty()) {
        clusterId_ = other.clusterId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasNetworkPolicy()) {
        mergeNetworkPolicy(other.getNetworkPolicy());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                clusterId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNetworkPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4969
     * @return The projectId.
     */
    @java.lang.Deprecated
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4969
     * @return The bytes for projectId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4969
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4969
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The Google Developers Console [project ID or project
     * number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string project_id = 1 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.project_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4969
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4976
     * @return The zone.
     */
    @java.lang.Deprecated
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4976
     * @return The bytes for zone.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4976
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4976
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the Google Compute Engine
     * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster resides. This field has been deprecated and replaced by the name
     * field.
     * </pre>
     *
     * <code>string zone = 2 [deprecated = true, (.google.api.field_behavior) = REQUIRED];</code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.zone is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4976
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clusterId_ = "";
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the cluster.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4980
     * @return The clusterId.
     */
    @java.lang.Deprecated
    public java.lang.String getClusterId() {
      java.lang.Object ref = clusterId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the cluster.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4980
     * @return The bytes for clusterId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getClusterIdBytes() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the cluster.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4980
     * @param value The clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the cluster.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4980
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearClusterId() {
      clusterId_ = getDefaultInstance().getClusterId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Deprecated. The name of the cluster.
     * This field has been deprecated and replaced by the name field.
     * </pre>
     *
     * <code>string cluster_id = 3 [deprecated = true, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @deprecated google.container.v1beta1.SetNetworkPolicyRequest.cluster_id is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=4980
     * @param value The bytes for clusterId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setClusterIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clusterId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NetworkPolicy networkPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkPolicy,
            com.google.container.v1beta1.NetworkPolicy.Builder,
            com.google.container.v1beta1.NetworkPolicyOrBuilder>
        networkPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the networkPolicy field is set.
     */
    public boolean hasNetworkPolicy() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The networkPolicy.
     */
    public com.google.container.v1beta1.NetworkPolicy getNetworkPolicy() {
      if (networkPolicyBuilder_ == null) {
        return networkPolicy_ == null
            ? com.google.container.v1beta1.NetworkPolicy.getDefaultInstance()
            : networkPolicy_;
      } else {
        return networkPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNetworkPolicy(com.google.container.v1beta1.NetworkPolicy value) {
      if (networkPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPolicy_ = value;
      } else {
        networkPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNetworkPolicy(
        com.google.container.v1beta1.NetworkPolicy.Builder builderForValue) {
      if (networkPolicyBuilder_ == null) {
        networkPolicy_ = builderForValue.build();
      } else {
        networkPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeNetworkPolicy(com.google.container.v1beta1.NetworkPolicy value) {
      if (networkPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && networkPolicy_ != null
            && networkPolicy_ != com.google.container.v1beta1.NetworkPolicy.getDefaultInstance()) {
          getNetworkPolicyBuilder().mergeFrom(value);
        } else {
          networkPolicy_ = value;
        }
      } else {
        networkPolicyBuilder_.mergeFrom(value);
      }
      if (networkPolicy_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearNetworkPolicy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      networkPolicy_ = null;
      if (networkPolicyBuilder_ != null) {
        networkPolicyBuilder_.dispose();
        networkPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.container.v1beta1.NetworkPolicy.Builder getNetworkPolicyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNetworkPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.container.v1beta1.NetworkPolicyOrBuilder getNetworkPolicyOrBuilder() {
      if (networkPolicyBuilder_ != null) {
        return networkPolicyBuilder_.getMessageOrBuilder();
      } else {
        return networkPolicy_ == null
            ? com.google.container.v1beta1.NetworkPolicy.getDefaultInstance()
            : networkPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration options for the NetworkPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkPolicy network_policy = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkPolicy,
            com.google.container.v1beta1.NetworkPolicy.Builder,
            com.google.container.v1beta1.NetworkPolicyOrBuilder>
        getNetworkPolicyFieldBuilder() {
      if (networkPolicyBuilder_ == null) {
        networkPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NetworkPolicy,
                com.google.container.v1beta1.NetworkPolicy.Builder,
                com.google.container.v1beta1.NetworkPolicyOrBuilder>(
                getNetworkPolicy(), getParentForChildren(), isClean());
        networkPolicy_ = null;
      }
      return networkPolicyBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster name) of the cluster to set networking
     * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster name) of the cluster to set networking
     * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster name) of the cluster to set networking
     * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster name) of the cluster to set networking
     * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (project, location, cluster name) of the cluster to set networking
     * policy. Specified in the format `projects/&#42;&#47;locations/&#42;&#47;clusters/&#42;`.
     * </pre>
     *
     * <code>string name = 6;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.SetNetworkPolicyRequest)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.SetNetworkPolicyRequest)
  private static final com.google.container.v1beta1.SetNetworkPolicyRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.SetNetworkPolicyRequest();
  }

  public static com.google.container.v1beta1.SetNetworkPolicyRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetNetworkPolicyRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetNetworkPolicyRequest>() {
        @java.lang.Override
        public SetNetworkPolicyRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetNetworkPolicyRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetNetworkPolicyRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.SetNetworkPolicyRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
