/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.4
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * UpgradeEvent is a notification sent to customers by the cluster server when
 * a resource is upgrading.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.UpgradeEvent}
 */
public final class UpgradeEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.UpgradeEvent)
    UpgradeEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpgradeEvent.newBuilder() to construct.
  private UpgradeEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpgradeEvent() {
    resourceType_ = 0;
    operation_ = "";
    currentVersion_ = "";
    targetVersion_ = "";
    resource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpgradeEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_UpgradeEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_UpgradeEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.UpgradeEvent.class,
            com.google.container.v1beta1.UpgradeEvent.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_TYPE_FIELD_NUMBER = 1;
  private int resourceType_ = 0;
  /**
   *
   *
   * <pre>
   * The resource type that is upgrading.
   * </pre>
   *
   * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  @java.lang.Override
  public int getResourceTypeValue() {
    return resourceType_;
  }
  /**
   *
   *
   * <pre>
   * The resource type that is upgrading.
   * </pre>
   *
   * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public com.google.container.v1beta1.UpgradeResourceType getResourceType() {
    com.google.container.v1beta1.UpgradeResourceType result =
        com.google.container.v1beta1.UpgradeResourceType.forNumber(resourceType_);
    return result == null ? com.google.container.v1beta1.UpgradeResourceType.UNRECOGNIZED : result;
  }

  public static final int OPERATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operation_ = "";
  /**
   *
   *
   * <pre>
   * The operation associated with this upgrade.
   * </pre>
   *
   * <code>string operation = 2;</code>
   *
   * @return The operation.
   */
  @java.lang.Override
  public java.lang.String getOperation() {
    java.lang.Object ref = operation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The operation associated with this upgrade.
   * </pre>
   *
   * <code>string operation = 2;</code>
   *
   * @return The bytes for operation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationBytes() {
    java.lang.Object ref = operation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp operationStartTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
   *
   * @return Whether the operationStartTime field is set.
   */
  @java.lang.Override
  public boolean hasOperationStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
   *
   * @return The operationStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getOperationStartTime() {
    return operationStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : operationStartTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getOperationStartTimeOrBuilder() {
    return operationStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : operationStartTime_;
  }

  public static final int CURRENT_VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentVersion_ = "";
  /**
   *
   *
   * <pre>
   * The current version before the upgrade.
   * </pre>
   *
   * <code>string current_version = 4;</code>
   *
   * @return The currentVersion.
   */
  @java.lang.Override
  public java.lang.String getCurrentVersion() {
    java.lang.Object ref = currentVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current version before the upgrade.
   * </pre>
   *
   * <code>string current_version = 4;</code>
   *
   * @return The bytes for currentVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentVersionBytes() {
    java.lang.Object ref = currentVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetVersion_ = "";
  /**
   *
   *
   * <pre>
   * The target version for the upgrade.
   * </pre>
   *
   * <code>string target_version = 5;</code>
   *
   * @return The targetVersion.
   */
  @java.lang.Override
  public java.lang.String getTargetVersion() {
    java.lang.Object ref = targetVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target version for the upgrade.
   * </pre>
   *
   * <code>string target_version = 5;</code>
   *
   * @return The bytes for targetVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetVersionBytes() {
    java.lang.Object ref = targetVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resource_ = "";
  /**
   *
   *
   * <pre>
   * Optional relative path to the resource. For example in node pool upgrades,
   * the relative path of the node pool.
   * </pre>
   *
   * <code>string resource = 6;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public java.lang.String getResource() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional relative path to the resource. For example in node pool upgrades,
   * the relative path of the node pool.
   * </pre>
   *
   * <code>string resource = 6;</code>
   *
   * @return The bytes for resource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceBytes() {
    java.lang.Object ref = resource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resourceType_
        != com.google.container.v1beta1.UpgradeResourceType.UPGRADE_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, resourceType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, operation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getOperationStartTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, currentVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, targetVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, resource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resourceType_
        != com.google.container.v1beta1.UpgradeResourceType.UPGRADE_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, resourceType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, operation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOperationStartTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, currentVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, targetVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, resource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.UpgradeEvent)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.UpgradeEvent other =
        (com.google.container.v1beta1.UpgradeEvent) obj;

    if (resourceType_ != other.resourceType_) return false;
    if (!getOperation().equals(other.getOperation())) return false;
    if (hasOperationStartTime() != other.hasOperationStartTime()) return false;
    if (hasOperationStartTime()) {
      if (!getOperationStartTime().equals(other.getOperationStartTime())) return false;
    }
    if (!getCurrentVersion().equals(other.getCurrentVersion())) return false;
    if (!getTargetVersion().equals(other.getTargetVersion())) return false;
    if (!getResource().equals(other.getResource())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + resourceType_;
    hash = (37 * hash) + OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getOperation().hashCode();
    if (hasOperationStartTime()) {
      hash = (37 * hash) + OPERATION_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getOperationStartTime().hashCode();
    }
    hash = (37 * hash) + CURRENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentVersion().hashCode();
    hash = (37 * hash) + TARGET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getTargetVersion().hashCode();
    hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getResource().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.UpgradeEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.UpgradeEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * UpgradeEvent is a notification sent to customers by the cluster server when
   * a resource is upgrading.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.UpgradeEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.UpgradeEvent)
      com.google.container.v1beta1.UpgradeEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_UpgradeEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_UpgradeEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.UpgradeEvent.class,
              com.google.container.v1beta1.UpgradeEvent.Builder.class);
    }

    // Construct using com.google.container.v1beta1.UpgradeEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOperationStartTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceType_ = 0;
      operation_ = "";
      operationStartTime_ = null;
      if (operationStartTimeBuilder_ != null) {
        operationStartTimeBuilder_.dispose();
        operationStartTimeBuilder_ = null;
      }
      currentVersion_ = "";
      targetVersion_ = "";
      resource_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_UpgradeEvent_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.UpgradeEvent getDefaultInstanceForType() {
      return com.google.container.v1beta1.UpgradeEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.UpgradeEvent build() {
      com.google.container.v1beta1.UpgradeEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.UpgradeEvent buildPartial() {
      com.google.container.v1beta1.UpgradeEvent result =
          new com.google.container.v1beta1.UpgradeEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.UpgradeEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceType_ = resourceType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.operation_ = operation_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationStartTime_ =
            operationStartTimeBuilder_ == null
                ? operationStartTime_
                : operationStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.currentVersion_ = currentVersion_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.targetVersion_ = targetVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.resource_ = resource_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.UpgradeEvent) {
        return mergeFrom((com.google.container.v1beta1.UpgradeEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.UpgradeEvent other) {
      if (other == com.google.container.v1beta1.UpgradeEvent.getDefaultInstance()) return this;
      if (other.resourceType_ != 0) {
        setResourceTypeValue(other.getResourceTypeValue());
      }
      if (!other.getOperation().isEmpty()) {
        operation_ = other.operation_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasOperationStartTime()) {
        mergeOperationStartTime(other.getOperationStartTime());
      }
      if (!other.getCurrentVersion().isEmpty()) {
        currentVersion_ = other.currentVersion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getTargetVersion().isEmpty()) {
        targetVersion_ = other.targetVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getResource().isEmpty()) {
        resource_ = other.resource_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                resourceType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                operation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getOperationStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                currentVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                targetVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                resource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int resourceType_ = 0;
    /**
     *
     *
     * <pre>
     * The resource type that is upgrading.
     * </pre>
     *
     * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }
    /**
     *
     *
     * <pre>
     * The resource type that is upgrading.
     * </pre>
     *
     * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeValue(int value) {
      resourceType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type that is upgrading.
     * </pre>
     *
     * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.container.v1beta1.UpgradeResourceType getResourceType() {
      com.google.container.v1beta1.UpgradeResourceType result =
          com.google.container.v1beta1.UpgradeResourceType.forNumber(resourceType_);
      return result == null
          ? com.google.container.v1beta1.UpgradeResourceType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The resource type that is upgrading.
     * </pre>
     *
     * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(com.google.container.v1beta1.UpgradeResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      resourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource type that is upgrading.
     * </pre>
     *
     * <code>.google.container.v1beta1.UpgradeResourceType resource_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      resourceType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object operation_ = "";
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The operation.
     */
    public java.lang.String getOperation() {
      java.lang.Object ref = operation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return The bytes for operation.
     */
    public com.google.protobuf.ByteString getOperationBytes() {
      java.lang.Object ref = operation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @param value The operation to set.
     * @return This builder for chaining.
     */
    public Builder setOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperation() {
      operation_ = getDefaultInstance().getOperation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation associated with this upgrade.
     * </pre>
     *
     * <code>string operation = 2;</code>
     *
     * @param value The bytes for operation to set.
     * @return This builder for chaining.
     */
    public Builder setOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp operationStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        operationStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     *
     * @return Whether the operationStartTime field is set.
     */
    public boolean hasOperationStartTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     *
     * @return The operationStartTime.
     */
    public com.google.protobuf.Timestamp getOperationStartTime() {
      if (operationStartTimeBuilder_ == null) {
        return operationStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : operationStartTime_;
      } else {
        return operationStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    public Builder setOperationStartTime(com.google.protobuf.Timestamp value) {
      if (operationStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operationStartTime_ = value;
      } else {
        operationStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    public Builder setOperationStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (operationStartTimeBuilder_ == null) {
        operationStartTime_ = builderForValue.build();
      } else {
        operationStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    public Builder mergeOperationStartTime(com.google.protobuf.Timestamp value) {
      if (operationStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && operationStartTime_ != null
            && operationStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getOperationStartTimeBuilder().mergeFrom(value);
        } else {
          operationStartTime_ = value;
        }
      } else {
        operationStartTimeBuilder_.mergeFrom(value);
      }
      if (operationStartTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    public Builder clearOperationStartTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operationStartTime_ = null;
      if (operationStartTimeBuilder_ != null) {
        operationStartTimeBuilder_.dispose();
        operationStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getOperationStartTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOperationStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getOperationStartTimeOrBuilder() {
      if (operationStartTimeBuilder_ != null) {
        return operationStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return operationStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : operationStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp operation_start_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getOperationStartTimeFieldBuilder() {
      if (operationStartTimeBuilder_ == null) {
        operationStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getOperationStartTime(), getParentForChildren(), isClean());
        operationStartTime_ = null;
      }
      return operationStartTimeBuilder_;
    }

    private java.lang.Object currentVersion_ = "";
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 4;</code>
     *
     * @return The currentVersion.
     */
    public java.lang.String getCurrentVersion() {
      java.lang.Object ref = currentVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 4;</code>
     *
     * @return The bytes for currentVersion.
     */
    public com.google.protobuf.ByteString getCurrentVersionBytes() {
      java.lang.Object ref = currentVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 4;</code>
     *
     * @param value The currentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentVersion() {
      currentVersion_ = getDefaultInstance().getCurrentVersion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current version before the upgrade.
     * </pre>
     *
     * <code>string current_version = 4;</code>
     *
     * @param value The bytes for currentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object targetVersion_ = "";
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 5;</code>
     *
     * @return The targetVersion.
     */
    public java.lang.String getTargetVersion() {
      java.lang.Object ref = targetVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 5;</code>
     *
     * @return The bytes for targetVersion.
     */
    public com.google.protobuf.ByteString getTargetVersionBytes() {
      java.lang.Object ref = targetVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 5;</code>
     *
     * @param value The targetVersion to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetVersion() {
      targetVersion_ = getDefaultInstance().getTargetVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target version for the upgrade.
     * </pre>
     *
     * <code>string target_version = 5;</code>
     *
     * @param value The bytes for targetVersion to set.
     * @return This builder for chaining.
     */
    public Builder setTargetVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object resource_ = "";
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 6;</code>
     *
     * @return The resource.
     */
    public java.lang.String getResource() {
      java.lang.Object ref = resource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 6;</code>
     *
     * @return The bytes for resource.
     */
    public com.google.protobuf.ByteString getResourceBytes() {
      java.lang.Object ref = resource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 6;</code>
     *
     * @param value The resource to set.
     * @return This builder for chaining.
     */
    public Builder setResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resource_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResource() {
      resource_ = getDefaultInstance().getResource();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional relative path to the resource. For example in node pool upgrades,
     * the relative path of the node pool.
     * </pre>
     *
     * <code>string resource = 6;</code>
     *
     * @param value The bytes for resource to set.
     * @return This builder for chaining.
     */
    public Builder setResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resource_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.UpgradeEvent)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.UpgradeEvent)
  private static final com.google.container.v1beta1.UpgradeEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.UpgradeEvent();
  }

  public static com.google.container.v1beta1.UpgradeEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpgradeEvent> PARSER =
      new com.google.protobuf.AbstractParser<UpgradeEvent>() {
        @java.lang.Override
        public UpgradeEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpgradeEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpgradeEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.UpgradeEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
