/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for the addons that can be automatically spun up in the
 * cluster, enabling additional functionality.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.AddonsConfig}
 */
public final class AddonsConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.AddonsConfig)
    AddonsConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AddonsConfig.newBuilder() to construct.
  private AddonsConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AddonsConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AddonsConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_AddonsConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_AddonsConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.AddonsConfig.class,
            com.google.container.v1beta1.AddonsConfig.Builder.class);
  }

  private int bitField0_;
  public static final int HTTP_LOAD_BALANCING_FIELD_NUMBER = 1;
  private com.google.container.v1beta1.HttpLoadBalancing httpLoadBalancing_;
  /**
   *
   *
   * <pre>
   * Configuration for the HTTP (L7) load balancing controller addon, which
   * makes it easy to set up HTTP load balancers for services in a cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
   *
   * @return Whether the httpLoadBalancing field is set.
   */
  @java.lang.Override
  public boolean hasHttpLoadBalancing() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the HTTP (L7) load balancing controller addon, which
   * makes it easy to set up HTTP load balancers for services in a cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
   *
   * @return The httpLoadBalancing.
   */
  @java.lang.Override
  public com.google.container.v1beta1.HttpLoadBalancing getHttpLoadBalancing() {
    return httpLoadBalancing_ == null
        ? com.google.container.v1beta1.HttpLoadBalancing.getDefaultInstance()
        : httpLoadBalancing_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the HTTP (L7) load balancing controller addon, which
   * makes it easy to set up HTTP load balancers for services in a cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.HttpLoadBalancingOrBuilder getHttpLoadBalancingOrBuilder() {
    return httpLoadBalancing_ == null
        ? com.google.container.v1beta1.HttpLoadBalancing.getDefaultInstance()
        : httpLoadBalancing_;
  }

  public static final int HORIZONTAL_POD_AUTOSCALING_FIELD_NUMBER = 2;
  private com.google.container.v1beta1.HorizontalPodAutoscaling horizontalPodAutoscaling_;
  /**
   *
   *
   * <pre>
   * Configuration for the horizontal pod autoscaling feature, which
   * increases or decreases the number of replica pods a replication controller
   * has based on the resource usage of the existing pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;</code>
   *
   * @return Whether the horizontalPodAutoscaling field is set.
   */
  @java.lang.Override
  public boolean hasHorizontalPodAutoscaling() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the horizontal pod autoscaling feature, which
   * increases or decreases the number of replica pods a replication controller
   * has based on the resource usage of the existing pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;</code>
   *
   * @return The horizontalPodAutoscaling.
   */
  @java.lang.Override
  public com.google.container.v1beta1.HorizontalPodAutoscaling getHorizontalPodAutoscaling() {
    return horizontalPodAutoscaling_ == null
        ? com.google.container.v1beta1.HorizontalPodAutoscaling.getDefaultInstance()
        : horizontalPodAutoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the horizontal pod autoscaling feature, which
   * increases or decreases the number of replica pods a replication controller
   * has based on the resource usage of the existing pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.HorizontalPodAutoscalingOrBuilder
      getHorizontalPodAutoscalingOrBuilder() {
    return horizontalPodAutoscaling_ == null
        ? com.google.container.v1beta1.HorizontalPodAutoscaling.getDefaultInstance()
        : horizontalPodAutoscaling_;
  }

  public static final int KUBERNETES_DASHBOARD_FIELD_NUMBER = 3;
  private com.google.container.v1beta1.KubernetesDashboard kubernetesDashboard_;
  /**
   *
   *
   * <pre>
   * Configuration for the Kubernetes Dashboard.
   * This addon is deprecated, and will be disabled in 1.15. It is recommended
   * to use the Cloud Console to manage and monitor your Kubernetes clusters,
   * workloads and applications. For more information, see:
   * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.AddonsConfig.kubernetes_dashboard is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=1406
   * @return Whether the kubernetesDashboard field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasKubernetesDashboard() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Kubernetes Dashboard.
   * This addon is deprecated, and will be disabled in 1.15. It is recommended
   * to use the Cloud Console to manage and monitor your Kubernetes clusters,
   * workloads and applications. For more information, see:
   * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.AddonsConfig.kubernetes_dashboard is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=1406
   * @return The kubernetesDashboard.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.KubernetesDashboard getKubernetesDashboard() {
    return kubernetesDashboard_ == null
        ? com.google.container.v1beta1.KubernetesDashboard.getDefaultInstance()
        : kubernetesDashboard_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Kubernetes Dashboard.
   * This addon is deprecated, and will be disabled in 1.15. It is recommended
   * to use the Cloud Console to manage and monitor your Kubernetes clusters,
   * workloads and applications. For more information, see:
   * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.KubernetesDashboardOrBuilder
      getKubernetesDashboardOrBuilder() {
    return kubernetesDashboard_ == null
        ? com.google.container.v1beta1.KubernetesDashboard.getDefaultInstance()
        : kubernetesDashboard_;
  }

  public static final int NETWORK_POLICY_CONFIG_FIELD_NUMBER = 4;
  private com.google.container.v1beta1.NetworkPolicyConfig networkPolicyConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for NetworkPolicy. This only tracks whether the addon
   * is enabled or not on the Master, it does not track whether network policy
   * is enabled for the nodes.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
   *
   * @return Whether the networkPolicyConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPolicyConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for NetworkPolicy. This only tracks whether the addon
   * is enabled or not on the Master, it does not track whether network policy
   * is enabled for the nodes.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
   *
   * @return The networkPolicyConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkPolicyConfig getNetworkPolicyConfig() {
    return networkPolicyConfig_ == null
        ? com.google.container.v1beta1.NetworkPolicyConfig.getDefaultInstance()
        : networkPolicyConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for NetworkPolicy. This only tracks whether the addon
   * is enabled or not on the Master, it does not track whether network policy
   * is enabled for the nodes.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkPolicyConfigOrBuilder
      getNetworkPolicyConfigOrBuilder() {
    return networkPolicyConfig_ == null
        ? com.google.container.v1beta1.NetworkPolicyConfig.getDefaultInstance()
        : networkPolicyConfig_;
  }

  public static final int ISTIO_CONFIG_FIELD_NUMBER = 5;
  private com.google.container.v1beta1.IstioConfig istioConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for Istio, an open platform to connect, manage, and secure
   * microservices.
   * </pre>
   *
   * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.AddonsConfig.istio_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=1415
   * @return Whether the istioConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasIstioConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Istio, an open platform to connect, manage, and secure
   * microservices.
   * </pre>
   *
   * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.AddonsConfig.istio_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=1415
   * @return The istioConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.IstioConfig getIstioConfig() {
    return istioConfig_ == null
        ? com.google.container.v1beta1.IstioConfig.getDefaultInstance()
        : istioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for Istio, an open platform to connect, manage, and secure
   * microservices.
   * </pre>
   *
   * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.IstioConfigOrBuilder getIstioConfigOrBuilder() {
    return istioConfig_ == null
        ? com.google.container.v1beta1.IstioConfig.getDefaultInstance()
        : istioConfig_;
  }

  public static final int CLOUD_RUN_CONFIG_FIELD_NUMBER = 7;
  private com.google.container.v1beta1.CloudRunConfig cloudRunConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
   * enabled in order to enable Cloud Run addon. This option can only be enabled
   * at cluster creation time.
   * </pre>
   *
   * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
   *
   * @return Whether the cloudRunConfig field is set.
   */
  @java.lang.Override
  public boolean hasCloudRunConfig() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
   * enabled in order to enable Cloud Run addon. This option can only be enabled
   * at cluster creation time.
   * </pre>
   *
   * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
   *
   * @return The cloudRunConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.CloudRunConfig getCloudRunConfig() {
    return cloudRunConfig_ == null
        ? com.google.container.v1beta1.CloudRunConfig.getDefaultInstance()
        : cloudRunConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
   * enabled in order to enable Cloud Run addon. This option can only be enabled
   * at cluster creation time.
   * </pre>
   *
   * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.CloudRunConfigOrBuilder getCloudRunConfigOrBuilder() {
    return cloudRunConfig_ == null
        ? com.google.container.v1beta1.CloudRunConfig.getDefaultInstance()
        : cloudRunConfig_;
  }

  public static final int DNS_CACHE_CONFIG_FIELD_NUMBER = 8;
  private com.google.container.v1beta1.DnsCacheConfig dnsCacheConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
   * </pre>
   *
   * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
   *
   * @return Whether the dnsCacheConfig field is set.
   */
  @java.lang.Override
  public boolean hasDnsCacheConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
   * </pre>
   *
   * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
   *
   * @return The dnsCacheConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DnsCacheConfig getDnsCacheConfig() {
    return dnsCacheConfig_ == null
        ? com.google.container.v1beta1.DnsCacheConfig.getDefaultInstance()
        : dnsCacheConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
   * </pre>
   *
   * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.DnsCacheConfigOrBuilder getDnsCacheConfigOrBuilder() {
    return dnsCacheConfig_ == null
        ? com.google.container.v1beta1.DnsCacheConfig.getDefaultInstance()
        : dnsCacheConfig_;
  }

  public static final int CONFIG_CONNECTOR_CONFIG_FIELD_NUMBER = 10;
  private com.google.container.v1beta1.ConfigConnectorConfig configConnectorConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the ConfigConnector add-on, a Kubernetes
   * extension to manage hosted GCP services through the Kubernetes API
   * </pre>
   *
   * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
   *
   * @return Whether the configConnectorConfig field is set.
   */
  @java.lang.Override
  public boolean hasConfigConnectorConfig() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the ConfigConnector add-on, a Kubernetes
   * extension to manage hosted GCP services through the Kubernetes API
   * </pre>
   *
   * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
   *
   * @return The configConnectorConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ConfigConnectorConfig getConfigConnectorConfig() {
    return configConnectorConfig_ == null
        ? com.google.container.v1beta1.ConfigConnectorConfig.getDefaultInstance()
        : configConnectorConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the ConfigConnector add-on, a Kubernetes
   * extension to manage hosted GCP services through the Kubernetes API
   * </pre>
   *
   * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ConfigConnectorConfigOrBuilder
      getConfigConnectorConfigOrBuilder() {
    return configConnectorConfig_ == null
        ? com.google.container.v1beta1.ConfigConnectorConfig.getDefaultInstance()
        : configConnectorConfig_;
  }

  public static final int GCE_PERSISTENT_DISK_CSI_DRIVER_CONFIG_FIELD_NUMBER = 11;
  private com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig
      gcePersistentDiskCsiDriverConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the Compute Engine Persistent Disk CSI driver.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
   * </code>
   *
   * @return Whether the gcePersistentDiskCsiDriverConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcePersistentDiskCsiDriverConfig() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Compute Engine Persistent Disk CSI driver.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
   * </code>
   *
   * @return The gcePersistentDiskCsiDriverConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig
      getGcePersistentDiskCsiDriverConfig() {
    return gcePersistentDiskCsiDriverConfig_ == null
        ? com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.getDefaultInstance()
        : gcePersistentDiskCsiDriverConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Compute Engine Persistent Disk CSI driver.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcePersistentDiskCsiDriverConfigOrBuilder
      getGcePersistentDiskCsiDriverConfigOrBuilder() {
    return gcePersistentDiskCsiDriverConfig_ == null
        ? com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.getDefaultInstance()
        : gcePersistentDiskCsiDriverConfig_;
  }

  public static final int KALM_CONFIG_FIELD_NUMBER = 12;
  private com.google.container.v1beta1.KalmConfig kalmConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the KALM addon, which manages the lifecycle of k8s
   * applications.
   * </pre>
   *
   * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.AddonsConfig.kalm_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=1434
   * @return Whether the kalmConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasKalmConfig() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the KALM addon, which manages the lifecycle of k8s
   * applications.
   * </pre>
   *
   * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.AddonsConfig.kalm_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=1434
   * @return The kalmConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.KalmConfig getKalmConfig() {
    return kalmConfig_ == null
        ? com.google.container.v1beta1.KalmConfig.getDefaultInstance()
        : kalmConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the KALM addon, which manages the lifecycle of k8s
   * applications.
   * </pre>
   *
   * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.KalmConfigOrBuilder getKalmConfigOrBuilder() {
    return kalmConfig_ == null
        ? com.google.container.v1beta1.KalmConfig.getDefaultInstance()
        : kalmConfig_;
  }

  public static final int GCP_FILESTORE_CSI_DRIVER_CONFIG_FIELD_NUMBER = 14;
  private com.google.container.v1beta1.GcpFilestoreCsiDriverConfig gcpFilestoreCsiDriverConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the GCP Filestore CSI driver.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
   * </code>
   *
   * @return Whether the gcpFilestoreCsiDriverConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcpFilestoreCsiDriverConfig() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the GCP Filestore CSI driver.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
   * </code>
   *
   * @return The gcpFilestoreCsiDriverConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcpFilestoreCsiDriverConfig getGcpFilestoreCsiDriverConfig() {
    return gcpFilestoreCsiDriverConfig_ == null
        ? com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.getDefaultInstance()
        : gcpFilestoreCsiDriverConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the GCP Filestore CSI driver.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcpFilestoreCsiDriverConfigOrBuilder
      getGcpFilestoreCsiDriverConfigOrBuilder() {
    return gcpFilestoreCsiDriverConfig_ == null
        ? com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.getDefaultInstance()
        : gcpFilestoreCsiDriverConfig_;
  }

  public static final int GKE_BACKUP_AGENT_CONFIG_FIELD_NUMBER = 16;
  private com.google.container.v1beta1.GkeBackupAgentConfig gkeBackupAgentConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the Backup for GKE agent addon.
   * </pre>
   *
   * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
   *
   * @return Whether the gkeBackupAgentConfig field is set.
   */
  @java.lang.Override
  public boolean hasGkeBackupAgentConfig() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Backup for GKE agent addon.
   * </pre>
   *
   * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
   *
   * @return The gkeBackupAgentConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GkeBackupAgentConfig getGkeBackupAgentConfig() {
    return gkeBackupAgentConfig_ == null
        ? com.google.container.v1beta1.GkeBackupAgentConfig.getDefaultInstance()
        : gkeBackupAgentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Backup for GKE agent addon.
   * </pre>
   *
   * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GkeBackupAgentConfigOrBuilder
      getGkeBackupAgentConfigOrBuilder() {
    return gkeBackupAgentConfig_ == null
        ? com.google.container.v1beta1.GkeBackupAgentConfig.getDefaultInstance()
        : gkeBackupAgentConfig_;
  }

  public static final int GCS_FUSE_CSI_DRIVER_CONFIG_FIELD_NUMBER = 17;
  private com.google.container.v1beta1.GcsFuseCsiDriverConfig gcsFuseCsiDriverConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the Cloud Storage Fuse CSI driver.
   * </pre>
   *
   * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;</code>
   *
   * @return Whether the gcsFuseCsiDriverConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcsFuseCsiDriverConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Cloud Storage Fuse CSI driver.
   * </pre>
   *
   * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;</code>
   *
   * @return The gcsFuseCsiDriverConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcsFuseCsiDriverConfig getGcsFuseCsiDriverConfig() {
    return gcsFuseCsiDriverConfig_ == null
        ? com.google.container.v1beta1.GcsFuseCsiDriverConfig.getDefaultInstance()
        : gcsFuseCsiDriverConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the Cloud Storage Fuse CSI driver.
   * </pre>
   *
   * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcsFuseCsiDriverConfigOrBuilder
      getGcsFuseCsiDriverConfigOrBuilder() {
    return gcsFuseCsiDriverConfig_ == null
        ? com.google.container.v1beta1.GcsFuseCsiDriverConfig.getDefaultInstance()
        : gcsFuseCsiDriverConfig_;
  }

  public static final int STATEFUL_HA_CONFIG_FIELD_NUMBER = 18;
  private com.google.container.v1beta1.StatefulHAConfig statefulHaConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the StatefulHA add-on.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the statefulHaConfig field is set.
   */
  @java.lang.Override
  public boolean hasStatefulHaConfig() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the StatefulHA add-on.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The statefulHaConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.StatefulHAConfig getStatefulHaConfig() {
    return statefulHaConfig_ == null
        ? com.google.container.v1beta1.StatefulHAConfig.getDefaultInstance()
        : statefulHaConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for the StatefulHA add-on.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.StatefulHAConfigOrBuilder getStatefulHaConfigOrBuilder() {
    return statefulHaConfig_ == null
        ? com.google.container.v1beta1.StatefulHAConfig.getDefaultInstance()
        : statefulHaConfig_;
  }

  public static final int RAY_OPERATOR_CONFIG_FIELD_NUMBER = 21;
  private com.google.container.v1beta1.RayOperatorConfig rayOperatorConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for Ray Operator addon.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rayOperatorConfig field is set.
   */
  @java.lang.Override
  public boolean hasRayOperatorConfig() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for Ray Operator addon.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rayOperatorConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.RayOperatorConfig getRayOperatorConfig() {
    return rayOperatorConfig_ == null
        ? com.google.container.v1beta1.RayOperatorConfig.getDefaultInstance()
        : rayOperatorConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for Ray Operator addon.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.RayOperatorConfigOrBuilder getRayOperatorConfigOrBuilder() {
    return rayOperatorConfig_ == null
        ? com.google.container.v1beta1.RayOperatorConfig.getDefaultInstance()
        : rayOperatorConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getHttpLoadBalancing());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getHorizontalPodAutoscaling());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getKubernetesDashboard());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getNetworkPolicyConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(5, getIstioConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(7, getCloudRunConfig());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(8, getDnsCacheConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(10, getConfigConnectorConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(11, getGcePersistentDiskCsiDriverConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(12, getKalmConfig());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(14, getGcpFilestoreCsiDriverConfig());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(16, getGkeBackupAgentConfig());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(17, getGcsFuseCsiDriverConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(18, getStatefulHaConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(21, getRayOperatorConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getHttpLoadBalancing());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getHorizontalPodAutoscaling());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getKubernetesDashboard());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNetworkPolicyConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getIstioConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCloudRunConfig());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDnsCacheConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, getConfigConnectorConfig());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, getGcePersistentDiskCsiDriverConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getKalmConfig());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, getGcpFilestoreCsiDriverConfig());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(16, getGkeBackupAgentConfig());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(17, getGcsFuseCsiDriverConfig());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getStatefulHaConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getRayOperatorConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.AddonsConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.AddonsConfig other =
        (com.google.container.v1beta1.AddonsConfig) obj;

    if (hasHttpLoadBalancing() != other.hasHttpLoadBalancing()) return false;
    if (hasHttpLoadBalancing()) {
      if (!getHttpLoadBalancing().equals(other.getHttpLoadBalancing())) return false;
    }
    if (hasHorizontalPodAutoscaling() != other.hasHorizontalPodAutoscaling()) return false;
    if (hasHorizontalPodAutoscaling()) {
      if (!getHorizontalPodAutoscaling().equals(other.getHorizontalPodAutoscaling())) return false;
    }
    if (hasKubernetesDashboard() != other.hasKubernetesDashboard()) return false;
    if (hasKubernetesDashboard()) {
      if (!getKubernetesDashboard().equals(other.getKubernetesDashboard())) return false;
    }
    if (hasNetworkPolicyConfig() != other.hasNetworkPolicyConfig()) return false;
    if (hasNetworkPolicyConfig()) {
      if (!getNetworkPolicyConfig().equals(other.getNetworkPolicyConfig())) return false;
    }
    if (hasIstioConfig() != other.hasIstioConfig()) return false;
    if (hasIstioConfig()) {
      if (!getIstioConfig().equals(other.getIstioConfig())) return false;
    }
    if (hasCloudRunConfig() != other.hasCloudRunConfig()) return false;
    if (hasCloudRunConfig()) {
      if (!getCloudRunConfig().equals(other.getCloudRunConfig())) return false;
    }
    if (hasDnsCacheConfig() != other.hasDnsCacheConfig()) return false;
    if (hasDnsCacheConfig()) {
      if (!getDnsCacheConfig().equals(other.getDnsCacheConfig())) return false;
    }
    if (hasConfigConnectorConfig() != other.hasConfigConnectorConfig()) return false;
    if (hasConfigConnectorConfig()) {
      if (!getConfigConnectorConfig().equals(other.getConfigConnectorConfig())) return false;
    }
    if (hasGcePersistentDiskCsiDriverConfig() != other.hasGcePersistentDiskCsiDriverConfig())
      return false;
    if (hasGcePersistentDiskCsiDriverConfig()) {
      if (!getGcePersistentDiskCsiDriverConfig()
          .equals(other.getGcePersistentDiskCsiDriverConfig())) return false;
    }
    if (hasKalmConfig() != other.hasKalmConfig()) return false;
    if (hasKalmConfig()) {
      if (!getKalmConfig().equals(other.getKalmConfig())) return false;
    }
    if (hasGcpFilestoreCsiDriverConfig() != other.hasGcpFilestoreCsiDriverConfig()) return false;
    if (hasGcpFilestoreCsiDriverConfig()) {
      if (!getGcpFilestoreCsiDriverConfig().equals(other.getGcpFilestoreCsiDriverConfig()))
        return false;
    }
    if (hasGkeBackupAgentConfig() != other.hasGkeBackupAgentConfig()) return false;
    if (hasGkeBackupAgentConfig()) {
      if (!getGkeBackupAgentConfig().equals(other.getGkeBackupAgentConfig())) return false;
    }
    if (hasGcsFuseCsiDriverConfig() != other.hasGcsFuseCsiDriverConfig()) return false;
    if (hasGcsFuseCsiDriverConfig()) {
      if (!getGcsFuseCsiDriverConfig().equals(other.getGcsFuseCsiDriverConfig())) return false;
    }
    if (hasStatefulHaConfig() != other.hasStatefulHaConfig()) return false;
    if (hasStatefulHaConfig()) {
      if (!getStatefulHaConfig().equals(other.getStatefulHaConfig())) return false;
    }
    if (hasRayOperatorConfig() != other.hasRayOperatorConfig()) return false;
    if (hasRayOperatorConfig()) {
      if (!getRayOperatorConfig().equals(other.getRayOperatorConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasHttpLoadBalancing()) {
      hash = (37 * hash) + HTTP_LOAD_BALANCING_FIELD_NUMBER;
      hash = (53 * hash) + getHttpLoadBalancing().hashCode();
    }
    if (hasHorizontalPodAutoscaling()) {
      hash = (37 * hash) + HORIZONTAL_POD_AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getHorizontalPodAutoscaling().hashCode();
    }
    if (hasKubernetesDashboard()) {
      hash = (37 * hash) + KUBERNETES_DASHBOARD_FIELD_NUMBER;
      hash = (53 * hash) + getKubernetesDashboard().hashCode();
    }
    if (hasNetworkPolicyConfig()) {
      hash = (37 * hash) + NETWORK_POLICY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPolicyConfig().hashCode();
    }
    if (hasIstioConfig()) {
      hash = (37 * hash) + ISTIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIstioConfig().hashCode();
    }
    if (hasCloudRunConfig()) {
      hash = (37 * hash) + CLOUD_RUN_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCloudRunConfig().hashCode();
    }
    if (hasDnsCacheConfig()) {
      hash = (37 * hash) + DNS_CACHE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDnsCacheConfig().hashCode();
    }
    if (hasConfigConnectorConfig()) {
      hash = (37 * hash) + CONFIG_CONNECTOR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfigConnectorConfig().hashCode();
    }
    if (hasGcePersistentDiskCsiDriverConfig()) {
      hash = (37 * hash) + GCE_PERSISTENT_DISK_CSI_DRIVER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGcePersistentDiskCsiDriverConfig().hashCode();
    }
    if (hasKalmConfig()) {
      hash = (37 * hash) + KALM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getKalmConfig().hashCode();
    }
    if (hasGcpFilestoreCsiDriverConfig()) {
      hash = (37 * hash) + GCP_FILESTORE_CSI_DRIVER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGcpFilestoreCsiDriverConfig().hashCode();
    }
    if (hasGkeBackupAgentConfig()) {
      hash = (37 * hash) + GKE_BACKUP_AGENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGkeBackupAgentConfig().hashCode();
    }
    if (hasGcsFuseCsiDriverConfig()) {
      hash = (37 * hash) + GCS_FUSE_CSI_DRIVER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGcsFuseCsiDriverConfig().hashCode();
    }
    if (hasStatefulHaConfig()) {
      hash = (37 * hash) + STATEFUL_HA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getStatefulHaConfig().hashCode();
    }
    if (hasRayOperatorConfig()) {
      hash = (37 * hash) + RAY_OPERATOR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRayOperatorConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.AddonsConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.AddonsConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.AddonsConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.AddonsConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the addons that can be automatically spun up in the
   * cluster, enabling additional functionality.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.AddonsConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.AddonsConfig)
      com.google.container.v1beta1.AddonsConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_AddonsConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_AddonsConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.AddonsConfig.class,
              com.google.container.v1beta1.AddonsConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.AddonsConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHttpLoadBalancingFieldBuilder();
        getHorizontalPodAutoscalingFieldBuilder();
        getKubernetesDashboardFieldBuilder();
        getNetworkPolicyConfigFieldBuilder();
        getIstioConfigFieldBuilder();
        getCloudRunConfigFieldBuilder();
        getDnsCacheConfigFieldBuilder();
        getConfigConnectorConfigFieldBuilder();
        getGcePersistentDiskCsiDriverConfigFieldBuilder();
        getKalmConfigFieldBuilder();
        getGcpFilestoreCsiDriverConfigFieldBuilder();
        getGkeBackupAgentConfigFieldBuilder();
        getGcsFuseCsiDriverConfigFieldBuilder();
        getStatefulHaConfigFieldBuilder();
        getRayOperatorConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      httpLoadBalancing_ = null;
      if (httpLoadBalancingBuilder_ != null) {
        httpLoadBalancingBuilder_.dispose();
        httpLoadBalancingBuilder_ = null;
      }
      horizontalPodAutoscaling_ = null;
      if (horizontalPodAutoscalingBuilder_ != null) {
        horizontalPodAutoscalingBuilder_.dispose();
        horizontalPodAutoscalingBuilder_ = null;
      }
      kubernetesDashboard_ = null;
      if (kubernetesDashboardBuilder_ != null) {
        kubernetesDashboardBuilder_.dispose();
        kubernetesDashboardBuilder_ = null;
      }
      networkPolicyConfig_ = null;
      if (networkPolicyConfigBuilder_ != null) {
        networkPolicyConfigBuilder_.dispose();
        networkPolicyConfigBuilder_ = null;
      }
      istioConfig_ = null;
      if (istioConfigBuilder_ != null) {
        istioConfigBuilder_.dispose();
        istioConfigBuilder_ = null;
      }
      cloudRunConfig_ = null;
      if (cloudRunConfigBuilder_ != null) {
        cloudRunConfigBuilder_.dispose();
        cloudRunConfigBuilder_ = null;
      }
      dnsCacheConfig_ = null;
      if (dnsCacheConfigBuilder_ != null) {
        dnsCacheConfigBuilder_.dispose();
        dnsCacheConfigBuilder_ = null;
      }
      configConnectorConfig_ = null;
      if (configConnectorConfigBuilder_ != null) {
        configConnectorConfigBuilder_.dispose();
        configConnectorConfigBuilder_ = null;
      }
      gcePersistentDiskCsiDriverConfig_ = null;
      if (gcePersistentDiskCsiDriverConfigBuilder_ != null) {
        gcePersistentDiskCsiDriverConfigBuilder_.dispose();
        gcePersistentDiskCsiDriverConfigBuilder_ = null;
      }
      kalmConfig_ = null;
      if (kalmConfigBuilder_ != null) {
        kalmConfigBuilder_.dispose();
        kalmConfigBuilder_ = null;
      }
      gcpFilestoreCsiDriverConfig_ = null;
      if (gcpFilestoreCsiDriverConfigBuilder_ != null) {
        gcpFilestoreCsiDriverConfigBuilder_.dispose();
        gcpFilestoreCsiDriverConfigBuilder_ = null;
      }
      gkeBackupAgentConfig_ = null;
      if (gkeBackupAgentConfigBuilder_ != null) {
        gkeBackupAgentConfigBuilder_.dispose();
        gkeBackupAgentConfigBuilder_ = null;
      }
      gcsFuseCsiDriverConfig_ = null;
      if (gcsFuseCsiDriverConfigBuilder_ != null) {
        gcsFuseCsiDriverConfigBuilder_.dispose();
        gcsFuseCsiDriverConfigBuilder_ = null;
      }
      statefulHaConfig_ = null;
      if (statefulHaConfigBuilder_ != null) {
        statefulHaConfigBuilder_.dispose();
        statefulHaConfigBuilder_ = null;
      }
      rayOperatorConfig_ = null;
      if (rayOperatorConfigBuilder_ != null) {
        rayOperatorConfigBuilder_.dispose();
        rayOperatorConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_AddonsConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.AddonsConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.AddonsConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.AddonsConfig build() {
      com.google.container.v1beta1.AddonsConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.AddonsConfig buildPartial() {
      com.google.container.v1beta1.AddonsConfig result =
          new com.google.container.v1beta1.AddonsConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.AddonsConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.httpLoadBalancing_ =
            httpLoadBalancingBuilder_ == null
                ? httpLoadBalancing_
                : httpLoadBalancingBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.horizontalPodAutoscaling_ =
            horizontalPodAutoscalingBuilder_ == null
                ? horizontalPodAutoscaling_
                : horizontalPodAutoscalingBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kubernetesDashboard_ =
            kubernetesDashboardBuilder_ == null
                ? kubernetesDashboard_
                : kubernetesDashboardBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.networkPolicyConfig_ =
            networkPolicyConfigBuilder_ == null
                ? networkPolicyConfig_
                : networkPolicyConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.istioConfig_ =
            istioConfigBuilder_ == null ? istioConfig_ : istioConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cloudRunConfig_ =
            cloudRunConfigBuilder_ == null ? cloudRunConfig_ : cloudRunConfigBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.dnsCacheConfig_ =
            dnsCacheConfigBuilder_ == null ? dnsCacheConfig_ : dnsCacheConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.configConnectorConfig_ =
            configConnectorConfigBuilder_ == null
                ? configConnectorConfig_
                : configConnectorConfigBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.gcePersistentDiskCsiDriverConfig_ =
            gcePersistentDiskCsiDriverConfigBuilder_ == null
                ? gcePersistentDiskCsiDriverConfig_
                : gcePersistentDiskCsiDriverConfigBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kalmConfig_ = kalmConfigBuilder_ == null ? kalmConfig_ : kalmConfigBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.gcpFilestoreCsiDriverConfig_ =
            gcpFilestoreCsiDriverConfigBuilder_ == null
                ? gcpFilestoreCsiDriverConfig_
                : gcpFilestoreCsiDriverConfigBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.gkeBackupAgentConfig_ =
            gkeBackupAgentConfigBuilder_ == null
                ? gkeBackupAgentConfig_
                : gkeBackupAgentConfigBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.gcsFuseCsiDriverConfig_ =
            gcsFuseCsiDriverConfigBuilder_ == null
                ? gcsFuseCsiDriverConfig_
                : gcsFuseCsiDriverConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.statefulHaConfig_ =
            statefulHaConfigBuilder_ == null ? statefulHaConfig_ : statefulHaConfigBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.rayOperatorConfig_ =
            rayOperatorConfigBuilder_ == null
                ? rayOperatorConfig_
                : rayOperatorConfigBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.AddonsConfig) {
        return mergeFrom((com.google.container.v1beta1.AddonsConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.AddonsConfig other) {
      if (other == com.google.container.v1beta1.AddonsConfig.getDefaultInstance()) return this;
      if (other.hasHttpLoadBalancing()) {
        mergeHttpLoadBalancing(other.getHttpLoadBalancing());
      }
      if (other.hasHorizontalPodAutoscaling()) {
        mergeHorizontalPodAutoscaling(other.getHorizontalPodAutoscaling());
      }
      if (other.hasKubernetesDashboard()) {
        mergeKubernetesDashboard(other.getKubernetesDashboard());
      }
      if (other.hasNetworkPolicyConfig()) {
        mergeNetworkPolicyConfig(other.getNetworkPolicyConfig());
      }
      if (other.hasIstioConfig()) {
        mergeIstioConfig(other.getIstioConfig());
      }
      if (other.hasCloudRunConfig()) {
        mergeCloudRunConfig(other.getCloudRunConfig());
      }
      if (other.hasDnsCacheConfig()) {
        mergeDnsCacheConfig(other.getDnsCacheConfig());
      }
      if (other.hasConfigConnectorConfig()) {
        mergeConfigConnectorConfig(other.getConfigConnectorConfig());
      }
      if (other.hasGcePersistentDiskCsiDriverConfig()) {
        mergeGcePersistentDiskCsiDriverConfig(other.getGcePersistentDiskCsiDriverConfig());
      }
      if (other.hasKalmConfig()) {
        mergeKalmConfig(other.getKalmConfig());
      }
      if (other.hasGcpFilestoreCsiDriverConfig()) {
        mergeGcpFilestoreCsiDriverConfig(other.getGcpFilestoreCsiDriverConfig());
      }
      if (other.hasGkeBackupAgentConfig()) {
        mergeGkeBackupAgentConfig(other.getGkeBackupAgentConfig());
      }
      if (other.hasGcsFuseCsiDriverConfig()) {
        mergeGcsFuseCsiDriverConfig(other.getGcsFuseCsiDriverConfig());
      }
      if (other.hasStatefulHaConfig()) {
        mergeStatefulHaConfig(other.getStatefulHaConfig());
      }
      if (other.hasRayOperatorConfig()) {
        mergeRayOperatorConfig(other.getRayOperatorConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getHttpLoadBalancingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getHorizontalPodAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getKubernetesDashboardFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getNetworkPolicyConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getIstioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getCloudRunConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDnsCacheConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(
                    getConfigConnectorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getGcePersistentDiskCsiDriverConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getKalmConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            case 114:
              {
                input.readMessage(
                    getGcpFilestoreCsiDriverConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            case 130:
              {
                input.readMessage(
                    getGkeBackupAgentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getGcsFuseCsiDriverConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getStatefulHaConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 146
            case 170:
              {
                input.readMessage(
                    getRayOperatorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 170
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.container.v1beta1.HttpLoadBalancing httpLoadBalancing_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.HttpLoadBalancing,
            com.google.container.v1beta1.HttpLoadBalancing.Builder,
            com.google.container.v1beta1.HttpLoadBalancingOrBuilder>
        httpLoadBalancingBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     *
     * @return Whether the httpLoadBalancing field is set.
     */
    public boolean hasHttpLoadBalancing() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     *
     * @return The httpLoadBalancing.
     */
    public com.google.container.v1beta1.HttpLoadBalancing getHttpLoadBalancing() {
      if (httpLoadBalancingBuilder_ == null) {
        return httpLoadBalancing_ == null
            ? com.google.container.v1beta1.HttpLoadBalancing.getDefaultInstance()
            : httpLoadBalancing_;
      } else {
        return httpLoadBalancingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    public Builder setHttpLoadBalancing(com.google.container.v1beta1.HttpLoadBalancing value) {
      if (httpLoadBalancingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        httpLoadBalancing_ = value;
      } else {
        httpLoadBalancingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    public Builder setHttpLoadBalancing(
        com.google.container.v1beta1.HttpLoadBalancing.Builder builderForValue) {
      if (httpLoadBalancingBuilder_ == null) {
        httpLoadBalancing_ = builderForValue.build();
      } else {
        httpLoadBalancingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    public Builder mergeHttpLoadBalancing(com.google.container.v1beta1.HttpLoadBalancing value) {
      if (httpLoadBalancingBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && httpLoadBalancing_ != null
            && httpLoadBalancing_
                != com.google.container.v1beta1.HttpLoadBalancing.getDefaultInstance()) {
          getHttpLoadBalancingBuilder().mergeFrom(value);
        } else {
          httpLoadBalancing_ = value;
        }
      } else {
        httpLoadBalancingBuilder_.mergeFrom(value);
      }
      if (httpLoadBalancing_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    public Builder clearHttpLoadBalancing() {
      bitField0_ = (bitField0_ & ~0x00000001);
      httpLoadBalancing_ = null;
      if (httpLoadBalancingBuilder_ != null) {
        httpLoadBalancingBuilder_.dispose();
        httpLoadBalancingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    public com.google.container.v1beta1.HttpLoadBalancing.Builder getHttpLoadBalancingBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getHttpLoadBalancingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    public com.google.container.v1beta1.HttpLoadBalancingOrBuilder getHttpLoadBalancingOrBuilder() {
      if (httpLoadBalancingBuilder_ != null) {
        return httpLoadBalancingBuilder_.getMessageOrBuilder();
      } else {
        return httpLoadBalancing_ == null
            ? com.google.container.v1beta1.HttpLoadBalancing.getDefaultInstance()
            : httpLoadBalancing_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the HTTP (L7) load balancing controller addon, which
     * makes it easy to set up HTTP load balancers for services in a cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.HttpLoadBalancing http_load_balancing = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.HttpLoadBalancing,
            com.google.container.v1beta1.HttpLoadBalancing.Builder,
            com.google.container.v1beta1.HttpLoadBalancingOrBuilder>
        getHttpLoadBalancingFieldBuilder() {
      if (httpLoadBalancingBuilder_ == null) {
        httpLoadBalancingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.HttpLoadBalancing,
                com.google.container.v1beta1.HttpLoadBalancing.Builder,
                com.google.container.v1beta1.HttpLoadBalancingOrBuilder>(
                getHttpLoadBalancing(), getParentForChildren(), isClean());
        httpLoadBalancing_ = null;
      }
      return httpLoadBalancingBuilder_;
    }

    private com.google.container.v1beta1.HorizontalPodAutoscaling horizontalPodAutoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.HorizontalPodAutoscaling,
            com.google.container.v1beta1.HorizontalPodAutoscaling.Builder,
            com.google.container.v1beta1.HorizontalPodAutoscalingOrBuilder>
        horizontalPodAutoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     *
     * @return Whether the horizontalPodAutoscaling field is set.
     */
    public boolean hasHorizontalPodAutoscaling() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     *
     * @return The horizontalPodAutoscaling.
     */
    public com.google.container.v1beta1.HorizontalPodAutoscaling getHorizontalPodAutoscaling() {
      if (horizontalPodAutoscalingBuilder_ == null) {
        return horizontalPodAutoscaling_ == null
            ? com.google.container.v1beta1.HorizontalPodAutoscaling.getDefaultInstance()
            : horizontalPodAutoscaling_;
      } else {
        return horizontalPodAutoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    public Builder setHorizontalPodAutoscaling(
        com.google.container.v1beta1.HorizontalPodAutoscaling value) {
      if (horizontalPodAutoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        horizontalPodAutoscaling_ = value;
      } else {
        horizontalPodAutoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    public Builder setHorizontalPodAutoscaling(
        com.google.container.v1beta1.HorizontalPodAutoscaling.Builder builderForValue) {
      if (horizontalPodAutoscalingBuilder_ == null) {
        horizontalPodAutoscaling_ = builderForValue.build();
      } else {
        horizontalPodAutoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    public Builder mergeHorizontalPodAutoscaling(
        com.google.container.v1beta1.HorizontalPodAutoscaling value) {
      if (horizontalPodAutoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && horizontalPodAutoscaling_ != null
            && horizontalPodAutoscaling_
                != com.google.container.v1beta1.HorizontalPodAutoscaling.getDefaultInstance()) {
          getHorizontalPodAutoscalingBuilder().mergeFrom(value);
        } else {
          horizontalPodAutoscaling_ = value;
        }
      } else {
        horizontalPodAutoscalingBuilder_.mergeFrom(value);
      }
      if (horizontalPodAutoscaling_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    public Builder clearHorizontalPodAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00000002);
      horizontalPodAutoscaling_ = null;
      if (horizontalPodAutoscalingBuilder_ != null) {
        horizontalPodAutoscalingBuilder_.dispose();
        horizontalPodAutoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    public com.google.container.v1beta1.HorizontalPodAutoscaling.Builder
        getHorizontalPodAutoscalingBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getHorizontalPodAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    public com.google.container.v1beta1.HorizontalPodAutoscalingOrBuilder
        getHorizontalPodAutoscalingOrBuilder() {
      if (horizontalPodAutoscalingBuilder_ != null) {
        return horizontalPodAutoscalingBuilder_.getMessageOrBuilder();
      } else {
        return horizontalPodAutoscaling_ == null
            ? com.google.container.v1beta1.HorizontalPodAutoscaling.getDefaultInstance()
            : horizontalPodAutoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the horizontal pod autoscaling feature, which
     * increases or decreases the number of replica pods a replication controller
     * has based on the resource usage of the existing pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.HorizontalPodAutoscaling horizontal_pod_autoscaling = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.HorizontalPodAutoscaling,
            com.google.container.v1beta1.HorizontalPodAutoscaling.Builder,
            com.google.container.v1beta1.HorizontalPodAutoscalingOrBuilder>
        getHorizontalPodAutoscalingFieldBuilder() {
      if (horizontalPodAutoscalingBuilder_ == null) {
        horizontalPodAutoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.HorizontalPodAutoscaling,
                com.google.container.v1beta1.HorizontalPodAutoscaling.Builder,
                com.google.container.v1beta1.HorizontalPodAutoscalingOrBuilder>(
                getHorizontalPodAutoscaling(), getParentForChildren(), isClean());
        horizontalPodAutoscaling_ = null;
      }
      return horizontalPodAutoscalingBuilder_;
    }

    private com.google.container.v1beta1.KubernetesDashboard kubernetesDashboard_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.KubernetesDashboard,
            com.google.container.v1beta1.KubernetesDashboard.Builder,
            com.google.container.v1beta1.KubernetesDashboardOrBuilder>
        kubernetesDashboardBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1beta1.AddonsConfig.kubernetes_dashboard is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=1406
     * @return Whether the kubernetesDashboard field is set.
     */
    @java.lang.Deprecated
    public boolean hasKubernetesDashboard() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1beta1.AddonsConfig.kubernetes_dashboard is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=1406
     * @return The kubernetesDashboard.
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.KubernetesDashboard getKubernetesDashboard() {
      if (kubernetesDashboardBuilder_ == null) {
        return kubernetesDashboard_ == null
            ? com.google.container.v1beta1.KubernetesDashboard.getDefaultInstance()
            : kubernetesDashboard_;
      } else {
        return kubernetesDashboardBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setKubernetesDashboard(com.google.container.v1beta1.KubernetesDashboard value) {
      if (kubernetesDashboardBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kubernetesDashboard_ = value;
      } else {
        kubernetesDashboardBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setKubernetesDashboard(
        com.google.container.v1beta1.KubernetesDashboard.Builder builderForValue) {
      if (kubernetesDashboardBuilder_ == null) {
        kubernetesDashboard_ = builderForValue.build();
      } else {
        kubernetesDashboardBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeKubernetesDashboard(
        com.google.container.v1beta1.KubernetesDashboard value) {
      if (kubernetesDashboardBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && kubernetesDashboard_ != null
            && kubernetesDashboard_
                != com.google.container.v1beta1.KubernetesDashboard.getDefaultInstance()) {
          getKubernetesDashboardBuilder().mergeFrom(value);
        } else {
          kubernetesDashboard_ = value;
        }
      } else {
        kubernetesDashboardBuilder_.mergeFrom(value);
      }
      if (kubernetesDashboard_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearKubernetesDashboard() {
      bitField0_ = (bitField0_ & ~0x00000004);
      kubernetesDashboard_ = null;
      if (kubernetesDashboardBuilder_ != null) {
        kubernetesDashboardBuilder_.dispose();
        kubernetesDashboardBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.KubernetesDashboard.Builder
        getKubernetesDashboardBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getKubernetesDashboardFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.KubernetesDashboardOrBuilder
        getKubernetesDashboardOrBuilder() {
      if (kubernetesDashboardBuilder_ != null) {
        return kubernetesDashboardBuilder_.getMessageOrBuilder();
      } else {
        return kubernetesDashboard_ == null
            ? com.google.container.v1beta1.KubernetesDashboard.getDefaultInstance()
            : kubernetesDashboard_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Kubernetes Dashboard.
     * This addon is deprecated, and will be disabled in 1.15. It is recommended
     * to use the Cloud Console to manage and monitor your Kubernetes clusters,
     * workloads and applications. For more information, see:
     * https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.KubernetesDashboard kubernetes_dashboard = 3 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.KubernetesDashboard,
            com.google.container.v1beta1.KubernetesDashboard.Builder,
            com.google.container.v1beta1.KubernetesDashboardOrBuilder>
        getKubernetesDashboardFieldBuilder() {
      if (kubernetesDashboardBuilder_ == null) {
        kubernetesDashboardBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.KubernetesDashboard,
                com.google.container.v1beta1.KubernetesDashboard.Builder,
                com.google.container.v1beta1.KubernetesDashboardOrBuilder>(
                getKubernetesDashboard(), getParentForChildren(), isClean());
        kubernetesDashboard_ = null;
      }
      return kubernetesDashboardBuilder_;
    }

    private com.google.container.v1beta1.NetworkPolicyConfig networkPolicyConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkPolicyConfig,
            com.google.container.v1beta1.NetworkPolicyConfig.Builder,
            com.google.container.v1beta1.NetworkPolicyConfigOrBuilder>
        networkPolicyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     *
     * @return Whether the networkPolicyConfig field is set.
     */
    public boolean hasNetworkPolicyConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     *
     * @return The networkPolicyConfig.
     */
    public com.google.container.v1beta1.NetworkPolicyConfig getNetworkPolicyConfig() {
      if (networkPolicyConfigBuilder_ == null) {
        return networkPolicyConfig_ == null
            ? com.google.container.v1beta1.NetworkPolicyConfig.getDefaultInstance()
            : networkPolicyConfig_;
      } else {
        return networkPolicyConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    public Builder setNetworkPolicyConfig(com.google.container.v1beta1.NetworkPolicyConfig value) {
      if (networkPolicyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPolicyConfig_ = value;
      } else {
        networkPolicyConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    public Builder setNetworkPolicyConfig(
        com.google.container.v1beta1.NetworkPolicyConfig.Builder builderForValue) {
      if (networkPolicyConfigBuilder_ == null) {
        networkPolicyConfig_ = builderForValue.build();
      } else {
        networkPolicyConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    public Builder mergeNetworkPolicyConfig(
        com.google.container.v1beta1.NetworkPolicyConfig value) {
      if (networkPolicyConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && networkPolicyConfig_ != null
            && networkPolicyConfig_
                != com.google.container.v1beta1.NetworkPolicyConfig.getDefaultInstance()) {
          getNetworkPolicyConfigBuilder().mergeFrom(value);
        } else {
          networkPolicyConfig_ = value;
        }
      } else {
        networkPolicyConfigBuilder_.mergeFrom(value);
      }
      if (networkPolicyConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    public Builder clearNetworkPolicyConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      networkPolicyConfig_ = null;
      if (networkPolicyConfigBuilder_ != null) {
        networkPolicyConfigBuilder_.dispose();
        networkPolicyConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    public com.google.container.v1beta1.NetworkPolicyConfig.Builder
        getNetworkPolicyConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNetworkPolicyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    public com.google.container.v1beta1.NetworkPolicyConfigOrBuilder
        getNetworkPolicyConfigOrBuilder() {
      if (networkPolicyConfigBuilder_ != null) {
        return networkPolicyConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkPolicyConfig_ == null
            ? com.google.container.v1beta1.NetworkPolicyConfig.getDefaultInstance()
            : networkPolicyConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for NetworkPolicy. This only tracks whether the addon
     * is enabled or not on the Master, it does not track whether network policy
     * is enabled for the nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkPolicyConfig network_policy_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkPolicyConfig,
            com.google.container.v1beta1.NetworkPolicyConfig.Builder,
            com.google.container.v1beta1.NetworkPolicyConfigOrBuilder>
        getNetworkPolicyConfigFieldBuilder() {
      if (networkPolicyConfigBuilder_ == null) {
        networkPolicyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NetworkPolicyConfig,
                com.google.container.v1beta1.NetworkPolicyConfig.Builder,
                com.google.container.v1beta1.NetworkPolicyConfigOrBuilder>(
                getNetworkPolicyConfig(), getParentForChildren(), isClean());
        networkPolicyConfig_ = null;
      }
      return networkPolicyConfigBuilder_;
    }

    private com.google.container.v1beta1.IstioConfig istioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.IstioConfig,
            com.google.container.v1beta1.IstioConfig.Builder,
            com.google.container.v1beta1.IstioConfigOrBuilder>
        istioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AddonsConfig.istio_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=1415
     * @return Whether the istioConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasIstioConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AddonsConfig.istio_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=1415
     * @return The istioConfig.
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.IstioConfig getIstioConfig() {
      if (istioConfigBuilder_ == null) {
        return istioConfig_ == null
            ? com.google.container.v1beta1.IstioConfig.getDefaultInstance()
            : istioConfig_;
      } else {
        return istioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setIstioConfig(com.google.container.v1beta1.IstioConfig value) {
      if (istioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        istioConfig_ = value;
      } else {
        istioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setIstioConfig(
        com.google.container.v1beta1.IstioConfig.Builder builderForValue) {
      if (istioConfigBuilder_ == null) {
        istioConfig_ = builderForValue.build();
      } else {
        istioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeIstioConfig(com.google.container.v1beta1.IstioConfig value) {
      if (istioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && istioConfig_ != null
            && istioConfig_ != com.google.container.v1beta1.IstioConfig.getDefaultInstance()) {
          getIstioConfigBuilder().mergeFrom(value);
        } else {
          istioConfig_ = value;
        }
      } else {
        istioConfigBuilder_.mergeFrom(value);
      }
      if (istioConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearIstioConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      istioConfig_ = null;
      if (istioConfigBuilder_ != null) {
        istioConfigBuilder_.dispose();
        istioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.IstioConfig.Builder getIstioConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getIstioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.IstioConfigOrBuilder getIstioConfigOrBuilder() {
      if (istioConfigBuilder_ != null) {
        return istioConfigBuilder_.getMessageOrBuilder();
      } else {
        return istioConfig_ == null
            ? com.google.container.v1beta1.IstioConfig.getDefaultInstance()
            : istioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Istio, an open platform to connect, manage, and secure
     * microservices.
     * </pre>
     *
     * <code>.google.container.v1beta1.IstioConfig istio_config = 5 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.IstioConfig,
            com.google.container.v1beta1.IstioConfig.Builder,
            com.google.container.v1beta1.IstioConfigOrBuilder>
        getIstioConfigFieldBuilder() {
      if (istioConfigBuilder_ == null) {
        istioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.IstioConfig,
                com.google.container.v1beta1.IstioConfig.Builder,
                com.google.container.v1beta1.IstioConfigOrBuilder>(
                getIstioConfig(), getParentForChildren(), isClean());
        istioConfig_ = null;
      }
      return istioConfigBuilder_;
    }

    private com.google.container.v1beta1.CloudRunConfig cloudRunConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.CloudRunConfig,
            com.google.container.v1beta1.CloudRunConfig.Builder,
            com.google.container.v1beta1.CloudRunConfigOrBuilder>
        cloudRunConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     *
     * @return Whether the cloudRunConfig field is set.
     */
    public boolean hasCloudRunConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     *
     * @return The cloudRunConfig.
     */
    public com.google.container.v1beta1.CloudRunConfig getCloudRunConfig() {
      if (cloudRunConfigBuilder_ == null) {
        return cloudRunConfig_ == null
            ? com.google.container.v1beta1.CloudRunConfig.getDefaultInstance()
            : cloudRunConfig_;
      } else {
        return cloudRunConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    public Builder setCloudRunConfig(com.google.container.v1beta1.CloudRunConfig value) {
      if (cloudRunConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudRunConfig_ = value;
      } else {
        cloudRunConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    public Builder setCloudRunConfig(
        com.google.container.v1beta1.CloudRunConfig.Builder builderForValue) {
      if (cloudRunConfigBuilder_ == null) {
        cloudRunConfig_ = builderForValue.build();
      } else {
        cloudRunConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    public Builder mergeCloudRunConfig(com.google.container.v1beta1.CloudRunConfig value) {
      if (cloudRunConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && cloudRunConfig_ != null
            && cloudRunConfig_
                != com.google.container.v1beta1.CloudRunConfig.getDefaultInstance()) {
          getCloudRunConfigBuilder().mergeFrom(value);
        } else {
          cloudRunConfig_ = value;
        }
      } else {
        cloudRunConfigBuilder_.mergeFrom(value);
      }
      if (cloudRunConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    public Builder clearCloudRunConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      cloudRunConfig_ = null;
      if (cloudRunConfigBuilder_ != null) {
        cloudRunConfigBuilder_.dispose();
        cloudRunConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    public com.google.container.v1beta1.CloudRunConfig.Builder getCloudRunConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCloudRunConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    public com.google.container.v1beta1.CloudRunConfigOrBuilder getCloudRunConfigOrBuilder() {
      if (cloudRunConfigBuilder_ != null) {
        return cloudRunConfigBuilder_.getMessageOrBuilder();
      } else {
        return cloudRunConfig_ == null
            ? com.google.container.v1beta1.CloudRunConfig.getDefaultInstance()
            : cloudRunConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Run addon. The `IstioConfig` addon must be
     * enabled in order to enable Cloud Run addon. This option can only be enabled
     * at cluster creation time.
     * </pre>
     *
     * <code>.google.container.v1beta1.CloudRunConfig cloud_run_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.CloudRunConfig,
            com.google.container.v1beta1.CloudRunConfig.Builder,
            com.google.container.v1beta1.CloudRunConfigOrBuilder>
        getCloudRunConfigFieldBuilder() {
      if (cloudRunConfigBuilder_ == null) {
        cloudRunConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.CloudRunConfig,
                com.google.container.v1beta1.CloudRunConfig.Builder,
                com.google.container.v1beta1.CloudRunConfigOrBuilder>(
                getCloudRunConfig(), getParentForChildren(), isClean());
        cloudRunConfig_ = null;
      }
      return cloudRunConfigBuilder_;
    }

    private com.google.container.v1beta1.DnsCacheConfig dnsCacheConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DnsCacheConfig,
            com.google.container.v1beta1.DnsCacheConfig.Builder,
            com.google.container.v1beta1.DnsCacheConfigOrBuilder>
        dnsCacheConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     *
     * @return Whether the dnsCacheConfig field is set.
     */
    public boolean hasDnsCacheConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     *
     * @return The dnsCacheConfig.
     */
    public com.google.container.v1beta1.DnsCacheConfig getDnsCacheConfig() {
      if (dnsCacheConfigBuilder_ == null) {
        return dnsCacheConfig_ == null
            ? com.google.container.v1beta1.DnsCacheConfig.getDefaultInstance()
            : dnsCacheConfig_;
      } else {
        return dnsCacheConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    public Builder setDnsCacheConfig(com.google.container.v1beta1.DnsCacheConfig value) {
      if (dnsCacheConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsCacheConfig_ = value;
      } else {
        dnsCacheConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    public Builder setDnsCacheConfig(
        com.google.container.v1beta1.DnsCacheConfig.Builder builderForValue) {
      if (dnsCacheConfigBuilder_ == null) {
        dnsCacheConfig_ = builderForValue.build();
      } else {
        dnsCacheConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    public Builder mergeDnsCacheConfig(com.google.container.v1beta1.DnsCacheConfig value) {
      if (dnsCacheConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && dnsCacheConfig_ != null
            && dnsCacheConfig_
                != com.google.container.v1beta1.DnsCacheConfig.getDefaultInstance()) {
          getDnsCacheConfigBuilder().mergeFrom(value);
        } else {
          dnsCacheConfig_ = value;
        }
      } else {
        dnsCacheConfigBuilder_.mergeFrom(value);
      }
      if (dnsCacheConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    public Builder clearDnsCacheConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      dnsCacheConfig_ = null;
      if (dnsCacheConfigBuilder_ != null) {
        dnsCacheConfigBuilder_.dispose();
        dnsCacheConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    public com.google.container.v1beta1.DnsCacheConfig.Builder getDnsCacheConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getDnsCacheConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    public com.google.container.v1beta1.DnsCacheConfigOrBuilder getDnsCacheConfigOrBuilder() {
      if (dnsCacheConfigBuilder_ != null) {
        return dnsCacheConfigBuilder_.getMessageOrBuilder();
      } else {
        return dnsCacheConfig_ == null
            ? com.google.container.v1beta1.DnsCacheConfig.getDefaultInstance()
            : dnsCacheConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for NodeLocalDNS, a dns cache running on cluster nodes
     * </pre>
     *
     * <code>.google.container.v1beta1.DnsCacheConfig dns_cache_config = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DnsCacheConfig,
            com.google.container.v1beta1.DnsCacheConfig.Builder,
            com.google.container.v1beta1.DnsCacheConfigOrBuilder>
        getDnsCacheConfigFieldBuilder() {
      if (dnsCacheConfigBuilder_ == null) {
        dnsCacheConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.DnsCacheConfig,
                com.google.container.v1beta1.DnsCacheConfig.Builder,
                com.google.container.v1beta1.DnsCacheConfigOrBuilder>(
                getDnsCacheConfig(), getParentForChildren(), isClean());
        dnsCacheConfig_ = null;
      }
      return dnsCacheConfigBuilder_;
    }

    private com.google.container.v1beta1.ConfigConnectorConfig configConnectorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ConfigConnectorConfig,
            com.google.container.v1beta1.ConfigConnectorConfig.Builder,
            com.google.container.v1beta1.ConfigConnectorConfigOrBuilder>
        configConnectorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     *
     * @return Whether the configConnectorConfig field is set.
     */
    public boolean hasConfigConnectorConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     *
     * @return The configConnectorConfig.
     */
    public com.google.container.v1beta1.ConfigConnectorConfig getConfigConnectorConfig() {
      if (configConnectorConfigBuilder_ == null) {
        return configConnectorConfig_ == null
            ? com.google.container.v1beta1.ConfigConnectorConfig.getDefaultInstance()
            : configConnectorConfig_;
      } else {
        return configConnectorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    public Builder setConfigConnectorConfig(
        com.google.container.v1beta1.ConfigConnectorConfig value) {
      if (configConnectorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configConnectorConfig_ = value;
      } else {
        configConnectorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    public Builder setConfigConnectorConfig(
        com.google.container.v1beta1.ConfigConnectorConfig.Builder builderForValue) {
      if (configConnectorConfigBuilder_ == null) {
        configConnectorConfig_ = builderForValue.build();
      } else {
        configConnectorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    public Builder mergeConfigConnectorConfig(
        com.google.container.v1beta1.ConfigConnectorConfig value) {
      if (configConnectorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && configConnectorConfig_ != null
            && configConnectorConfig_
                != com.google.container.v1beta1.ConfigConnectorConfig.getDefaultInstance()) {
          getConfigConnectorConfigBuilder().mergeFrom(value);
        } else {
          configConnectorConfig_ = value;
        }
      } else {
        configConnectorConfigBuilder_.mergeFrom(value);
      }
      if (configConnectorConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    public Builder clearConfigConnectorConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      configConnectorConfig_ = null;
      if (configConnectorConfigBuilder_ != null) {
        configConnectorConfigBuilder_.dispose();
        configConnectorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    public com.google.container.v1beta1.ConfigConnectorConfig.Builder
        getConfigConnectorConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getConfigConnectorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    public com.google.container.v1beta1.ConfigConnectorConfigOrBuilder
        getConfigConnectorConfigOrBuilder() {
      if (configConnectorConfigBuilder_ != null) {
        return configConnectorConfigBuilder_.getMessageOrBuilder();
      } else {
        return configConnectorConfig_ == null
            ? com.google.container.v1beta1.ConfigConnectorConfig.getDefaultInstance()
            : configConnectorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the ConfigConnector add-on, a Kubernetes
     * extension to manage hosted GCP services through the Kubernetes API
     * </pre>
     *
     * <code>.google.container.v1beta1.ConfigConnectorConfig config_connector_config = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ConfigConnectorConfig,
            com.google.container.v1beta1.ConfigConnectorConfig.Builder,
            com.google.container.v1beta1.ConfigConnectorConfigOrBuilder>
        getConfigConnectorConfigFieldBuilder() {
      if (configConnectorConfigBuilder_ == null) {
        configConnectorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ConfigConnectorConfig,
                com.google.container.v1beta1.ConfigConnectorConfig.Builder,
                com.google.container.v1beta1.ConfigConnectorConfigOrBuilder>(
                getConfigConnectorConfig(), getParentForChildren(), isClean());
        configConnectorConfig_ = null;
      }
      return configConnectorConfigBuilder_;
    }

    private com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig
        gcePersistentDiskCsiDriverConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig,
            com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.Builder,
            com.google.container.v1beta1.GcePersistentDiskCsiDriverConfigOrBuilder>
        gcePersistentDiskCsiDriverConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     *
     * @return Whether the gcePersistentDiskCsiDriverConfig field is set.
     */
    public boolean hasGcePersistentDiskCsiDriverConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     *
     * @return The gcePersistentDiskCsiDriverConfig.
     */
    public com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig
        getGcePersistentDiskCsiDriverConfig() {
      if (gcePersistentDiskCsiDriverConfigBuilder_ == null) {
        return gcePersistentDiskCsiDriverConfig_ == null
            ? com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.getDefaultInstance()
            : gcePersistentDiskCsiDriverConfig_;
      } else {
        return gcePersistentDiskCsiDriverConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    public Builder setGcePersistentDiskCsiDriverConfig(
        com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig value) {
      if (gcePersistentDiskCsiDriverConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcePersistentDiskCsiDriverConfig_ = value;
      } else {
        gcePersistentDiskCsiDriverConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    public Builder setGcePersistentDiskCsiDriverConfig(
        com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.Builder builderForValue) {
      if (gcePersistentDiskCsiDriverConfigBuilder_ == null) {
        gcePersistentDiskCsiDriverConfig_ = builderForValue.build();
      } else {
        gcePersistentDiskCsiDriverConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    public Builder mergeGcePersistentDiskCsiDriverConfig(
        com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig value) {
      if (gcePersistentDiskCsiDriverConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && gcePersistentDiskCsiDriverConfig_ != null
            && gcePersistentDiskCsiDriverConfig_
                != com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig
                    .getDefaultInstance()) {
          getGcePersistentDiskCsiDriverConfigBuilder().mergeFrom(value);
        } else {
          gcePersistentDiskCsiDriverConfig_ = value;
        }
      } else {
        gcePersistentDiskCsiDriverConfigBuilder_.mergeFrom(value);
      }
      if (gcePersistentDiskCsiDriverConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    public Builder clearGcePersistentDiskCsiDriverConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      gcePersistentDiskCsiDriverConfig_ = null;
      if (gcePersistentDiskCsiDriverConfigBuilder_ != null) {
        gcePersistentDiskCsiDriverConfigBuilder_.dispose();
        gcePersistentDiskCsiDriverConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    public com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.Builder
        getGcePersistentDiskCsiDriverConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getGcePersistentDiskCsiDriverConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    public com.google.container.v1beta1.GcePersistentDiskCsiDriverConfigOrBuilder
        getGcePersistentDiskCsiDriverConfigOrBuilder() {
      if (gcePersistentDiskCsiDriverConfigBuilder_ != null) {
        return gcePersistentDiskCsiDriverConfigBuilder_.getMessageOrBuilder();
      } else {
        return gcePersistentDiskCsiDriverConfig_ == null
            ? com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.getDefaultInstance()
            : gcePersistentDiskCsiDriverConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Compute Engine Persistent Disk CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcePersistentDiskCsiDriverConfig gce_persistent_disk_csi_driver_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig,
            com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.Builder,
            com.google.container.v1beta1.GcePersistentDiskCsiDriverConfigOrBuilder>
        getGcePersistentDiskCsiDriverConfigFieldBuilder() {
      if (gcePersistentDiskCsiDriverConfigBuilder_ == null) {
        gcePersistentDiskCsiDriverConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig,
                com.google.container.v1beta1.GcePersistentDiskCsiDriverConfig.Builder,
                com.google.container.v1beta1.GcePersistentDiskCsiDriverConfigOrBuilder>(
                getGcePersistentDiskCsiDriverConfig(), getParentForChildren(), isClean());
        gcePersistentDiskCsiDriverConfig_ = null;
      }
      return gcePersistentDiskCsiDriverConfigBuilder_;
    }

    private com.google.container.v1beta1.KalmConfig kalmConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.KalmConfig,
            com.google.container.v1beta1.KalmConfig.Builder,
            com.google.container.v1beta1.KalmConfigOrBuilder>
        kalmConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AddonsConfig.kalm_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=1434
     * @return Whether the kalmConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasKalmConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AddonsConfig.kalm_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=1434
     * @return The kalmConfig.
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.KalmConfig getKalmConfig() {
      if (kalmConfigBuilder_ == null) {
        return kalmConfig_ == null
            ? com.google.container.v1beta1.KalmConfig.getDefaultInstance()
            : kalmConfig_;
      } else {
        return kalmConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setKalmConfig(com.google.container.v1beta1.KalmConfig value) {
      if (kalmConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kalmConfig_ = value;
      } else {
        kalmConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setKalmConfig(com.google.container.v1beta1.KalmConfig.Builder builderForValue) {
      if (kalmConfigBuilder_ == null) {
        kalmConfig_ = builderForValue.build();
      } else {
        kalmConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeKalmConfig(com.google.container.v1beta1.KalmConfig value) {
      if (kalmConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && kalmConfig_ != null
            && kalmConfig_ != com.google.container.v1beta1.KalmConfig.getDefaultInstance()) {
          getKalmConfigBuilder().mergeFrom(value);
        } else {
          kalmConfig_ = value;
        }
      } else {
        kalmConfigBuilder_.mergeFrom(value);
      }
      if (kalmConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearKalmConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      kalmConfig_ = null;
      if (kalmConfigBuilder_ != null) {
        kalmConfigBuilder_.dispose();
        kalmConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.KalmConfig.Builder getKalmConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getKalmConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.KalmConfigOrBuilder getKalmConfigOrBuilder() {
      if (kalmConfigBuilder_ != null) {
        return kalmConfigBuilder_.getMessageOrBuilder();
      } else {
        return kalmConfig_ == null
            ? com.google.container.v1beta1.KalmConfig.getDefaultInstance()
            : kalmConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the KALM addon, which manages the lifecycle of k8s
     * applications.
     * </pre>
     *
     * <code>.google.container.v1beta1.KalmConfig kalm_config = 12 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.KalmConfig,
            com.google.container.v1beta1.KalmConfig.Builder,
            com.google.container.v1beta1.KalmConfigOrBuilder>
        getKalmConfigFieldBuilder() {
      if (kalmConfigBuilder_ == null) {
        kalmConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.KalmConfig,
                com.google.container.v1beta1.KalmConfig.Builder,
                com.google.container.v1beta1.KalmConfigOrBuilder>(
                getKalmConfig(), getParentForChildren(), isClean());
        kalmConfig_ = null;
      }
      return kalmConfigBuilder_;
    }

    private com.google.container.v1beta1.GcpFilestoreCsiDriverConfig gcpFilestoreCsiDriverConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcpFilestoreCsiDriverConfig,
            com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.Builder,
            com.google.container.v1beta1.GcpFilestoreCsiDriverConfigOrBuilder>
        gcpFilestoreCsiDriverConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     *
     * @return Whether the gcpFilestoreCsiDriverConfig field is set.
     */
    public boolean hasGcpFilestoreCsiDriverConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     *
     * @return The gcpFilestoreCsiDriverConfig.
     */
    public com.google.container.v1beta1.GcpFilestoreCsiDriverConfig
        getGcpFilestoreCsiDriverConfig() {
      if (gcpFilestoreCsiDriverConfigBuilder_ == null) {
        return gcpFilestoreCsiDriverConfig_ == null
            ? com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.getDefaultInstance()
            : gcpFilestoreCsiDriverConfig_;
      } else {
        return gcpFilestoreCsiDriverConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    public Builder setGcpFilestoreCsiDriverConfig(
        com.google.container.v1beta1.GcpFilestoreCsiDriverConfig value) {
      if (gcpFilestoreCsiDriverConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpFilestoreCsiDriverConfig_ = value;
      } else {
        gcpFilestoreCsiDriverConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    public Builder setGcpFilestoreCsiDriverConfig(
        com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.Builder builderForValue) {
      if (gcpFilestoreCsiDriverConfigBuilder_ == null) {
        gcpFilestoreCsiDriverConfig_ = builderForValue.build();
      } else {
        gcpFilestoreCsiDriverConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    public Builder mergeGcpFilestoreCsiDriverConfig(
        com.google.container.v1beta1.GcpFilestoreCsiDriverConfig value) {
      if (gcpFilestoreCsiDriverConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && gcpFilestoreCsiDriverConfig_ != null
            && gcpFilestoreCsiDriverConfig_
                != com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.getDefaultInstance()) {
          getGcpFilestoreCsiDriverConfigBuilder().mergeFrom(value);
        } else {
          gcpFilestoreCsiDriverConfig_ = value;
        }
      } else {
        gcpFilestoreCsiDriverConfigBuilder_.mergeFrom(value);
      }
      if (gcpFilestoreCsiDriverConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    public Builder clearGcpFilestoreCsiDriverConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      gcpFilestoreCsiDriverConfig_ = null;
      if (gcpFilestoreCsiDriverConfigBuilder_ != null) {
        gcpFilestoreCsiDriverConfigBuilder_.dispose();
        gcpFilestoreCsiDriverConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    public com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.Builder
        getGcpFilestoreCsiDriverConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getGcpFilestoreCsiDriverConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    public com.google.container.v1beta1.GcpFilestoreCsiDriverConfigOrBuilder
        getGcpFilestoreCsiDriverConfigOrBuilder() {
      if (gcpFilestoreCsiDriverConfigBuilder_ != null) {
        return gcpFilestoreCsiDriverConfigBuilder_.getMessageOrBuilder();
      } else {
        return gcpFilestoreCsiDriverConfig_ == null
            ? com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.getDefaultInstance()
            : gcpFilestoreCsiDriverConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the GCP Filestore CSI driver.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.GcpFilestoreCsiDriverConfig gcp_filestore_csi_driver_config = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcpFilestoreCsiDriverConfig,
            com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.Builder,
            com.google.container.v1beta1.GcpFilestoreCsiDriverConfigOrBuilder>
        getGcpFilestoreCsiDriverConfigFieldBuilder() {
      if (gcpFilestoreCsiDriverConfigBuilder_ == null) {
        gcpFilestoreCsiDriverConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GcpFilestoreCsiDriverConfig,
                com.google.container.v1beta1.GcpFilestoreCsiDriverConfig.Builder,
                com.google.container.v1beta1.GcpFilestoreCsiDriverConfigOrBuilder>(
                getGcpFilestoreCsiDriverConfig(), getParentForChildren(), isClean());
        gcpFilestoreCsiDriverConfig_ = null;
      }
      return gcpFilestoreCsiDriverConfigBuilder_;
    }

    private com.google.container.v1beta1.GkeBackupAgentConfig gkeBackupAgentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GkeBackupAgentConfig,
            com.google.container.v1beta1.GkeBackupAgentConfig.Builder,
            com.google.container.v1beta1.GkeBackupAgentConfigOrBuilder>
        gkeBackupAgentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     *
     * @return Whether the gkeBackupAgentConfig field is set.
     */
    public boolean hasGkeBackupAgentConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     *
     * @return The gkeBackupAgentConfig.
     */
    public com.google.container.v1beta1.GkeBackupAgentConfig getGkeBackupAgentConfig() {
      if (gkeBackupAgentConfigBuilder_ == null) {
        return gkeBackupAgentConfig_ == null
            ? com.google.container.v1beta1.GkeBackupAgentConfig.getDefaultInstance()
            : gkeBackupAgentConfig_;
      } else {
        return gkeBackupAgentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    public Builder setGkeBackupAgentConfig(
        com.google.container.v1beta1.GkeBackupAgentConfig value) {
      if (gkeBackupAgentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gkeBackupAgentConfig_ = value;
      } else {
        gkeBackupAgentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    public Builder setGkeBackupAgentConfig(
        com.google.container.v1beta1.GkeBackupAgentConfig.Builder builderForValue) {
      if (gkeBackupAgentConfigBuilder_ == null) {
        gkeBackupAgentConfig_ = builderForValue.build();
      } else {
        gkeBackupAgentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    public Builder mergeGkeBackupAgentConfig(
        com.google.container.v1beta1.GkeBackupAgentConfig value) {
      if (gkeBackupAgentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && gkeBackupAgentConfig_ != null
            && gkeBackupAgentConfig_
                != com.google.container.v1beta1.GkeBackupAgentConfig.getDefaultInstance()) {
          getGkeBackupAgentConfigBuilder().mergeFrom(value);
        } else {
          gkeBackupAgentConfig_ = value;
        }
      } else {
        gkeBackupAgentConfigBuilder_.mergeFrom(value);
      }
      if (gkeBackupAgentConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    public Builder clearGkeBackupAgentConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      gkeBackupAgentConfig_ = null;
      if (gkeBackupAgentConfigBuilder_ != null) {
        gkeBackupAgentConfigBuilder_.dispose();
        gkeBackupAgentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    public com.google.container.v1beta1.GkeBackupAgentConfig.Builder
        getGkeBackupAgentConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getGkeBackupAgentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    public com.google.container.v1beta1.GkeBackupAgentConfigOrBuilder
        getGkeBackupAgentConfigOrBuilder() {
      if (gkeBackupAgentConfigBuilder_ != null) {
        return gkeBackupAgentConfigBuilder_.getMessageOrBuilder();
      } else {
        return gkeBackupAgentConfig_ == null
            ? com.google.container.v1beta1.GkeBackupAgentConfig.getDefaultInstance()
            : gkeBackupAgentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Backup for GKE agent addon.
     * </pre>
     *
     * <code>.google.container.v1beta1.GkeBackupAgentConfig gke_backup_agent_config = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GkeBackupAgentConfig,
            com.google.container.v1beta1.GkeBackupAgentConfig.Builder,
            com.google.container.v1beta1.GkeBackupAgentConfigOrBuilder>
        getGkeBackupAgentConfigFieldBuilder() {
      if (gkeBackupAgentConfigBuilder_ == null) {
        gkeBackupAgentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GkeBackupAgentConfig,
                com.google.container.v1beta1.GkeBackupAgentConfig.Builder,
                com.google.container.v1beta1.GkeBackupAgentConfigOrBuilder>(
                getGkeBackupAgentConfig(), getParentForChildren(), isClean());
        gkeBackupAgentConfig_ = null;
      }
      return gkeBackupAgentConfigBuilder_;
    }

    private com.google.container.v1beta1.GcsFuseCsiDriverConfig gcsFuseCsiDriverConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcsFuseCsiDriverConfig,
            com.google.container.v1beta1.GcsFuseCsiDriverConfig.Builder,
            com.google.container.v1beta1.GcsFuseCsiDriverConfigOrBuilder>
        gcsFuseCsiDriverConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     *
     * @return Whether the gcsFuseCsiDriverConfig field is set.
     */
    public boolean hasGcsFuseCsiDriverConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     *
     * @return The gcsFuseCsiDriverConfig.
     */
    public com.google.container.v1beta1.GcsFuseCsiDriverConfig getGcsFuseCsiDriverConfig() {
      if (gcsFuseCsiDriverConfigBuilder_ == null) {
        return gcsFuseCsiDriverConfig_ == null
            ? com.google.container.v1beta1.GcsFuseCsiDriverConfig.getDefaultInstance()
            : gcsFuseCsiDriverConfig_;
      } else {
        return gcsFuseCsiDriverConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    public Builder setGcsFuseCsiDriverConfig(
        com.google.container.v1beta1.GcsFuseCsiDriverConfig value) {
      if (gcsFuseCsiDriverConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsFuseCsiDriverConfig_ = value;
      } else {
        gcsFuseCsiDriverConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    public Builder setGcsFuseCsiDriverConfig(
        com.google.container.v1beta1.GcsFuseCsiDriverConfig.Builder builderForValue) {
      if (gcsFuseCsiDriverConfigBuilder_ == null) {
        gcsFuseCsiDriverConfig_ = builderForValue.build();
      } else {
        gcsFuseCsiDriverConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    public Builder mergeGcsFuseCsiDriverConfig(
        com.google.container.v1beta1.GcsFuseCsiDriverConfig value) {
      if (gcsFuseCsiDriverConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && gcsFuseCsiDriverConfig_ != null
            && gcsFuseCsiDriverConfig_
                != com.google.container.v1beta1.GcsFuseCsiDriverConfig.getDefaultInstance()) {
          getGcsFuseCsiDriverConfigBuilder().mergeFrom(value);
        } else {
          gcsFuseCsiDriverConfig_ = value;
        }
      } else {
        gcsFuseCsiDriverConfigBuilder_.mergeFrom(value);
      }
      if (gcsFuseCsiDriverConfig_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    public Builder clearGcsFuseCsiDriverConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      gcsFuseCsiDriverConfig_ = null;
      if (gcsFuseCsiDriverConfigBuilder_ != null) {
        gcsFuseCsiDriverConfigBuilder_.dispose();
        gcsFuseCsiDriverConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    public com.google.container.v1beta1.GcsFuseCsiDriverConfig.Builder
        getGcsFuseCsiDriverConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getGcsFuseCsiDriverConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    public com.google.container.v1beta1.GcsFuseCsiDriverConfigOrBuilder
        getGcsFuseCsiDriverConfigOrBuilder() {
      if (gcsFuseCsiDriverConfigBuilder_ != null) {
        return gcsFuseCsiDriverConfigBuilder_.getMessageOrBuilder();
      } else {
        return gcsFuseCsiDriverConfig_ == null
            ? com.google.container.v1beta1.GcsFuseCsiDriverConfig.getDefaultInstance()
            : gcsFuseCsiDriverConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the Cloud Storage Fuse CSI driver.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcsFuseCsiDriverConfig gcs_fuse_csi_driver_config = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcsFuseCsiDriverConfig,
            com.google.container.v1beta1.GcsFuseCsiDriverConfig.Builder,
            com.google.container.v1beta1.GcsFuseCsiDriverConfigOrBuilder>
        getGcsFuseCsiDriverConfigFieldBuilder() {
      if (gcsFuseCsiDriverConfigBuilder_ == null) {
        gcsFuseCsiDriverConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GcsFuseCsiDriverConfig,
                com.google.container.v1beta1.GcsFuseCsiDriverConfig.Builder,
                com.google.container.v1beta1.GcsFuseCsiDriverConfigOrBuilder>(
                getGcsFuseCsiDriverConfig(), getParentForChildren(), isClean());
        gcsFuseCsiDriverConfig_ = null;
      }
      return gcsFuseCsiDriverConfigBuilder_;
    }

    private com.google.container.v1beta1.StatefulHAConfig statefulHaConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.StatefulHAConfig,
            com.google.container.v1beta1.StatefulHAConfig.Builder,
            com.google.container.v1beta1.StatefulHAConfigOrBuilder>
        statefulHaConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the statefulHaConfig field is set.
     */
    public boolean hasStatefulHaConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The statefulHaConfig.
     */
    public com.google.container.v1beta1.StatefulHAConfig getStatefulHaConfig() {
      if (statefulHaConfigBuilder_ == null) {
        return statefulHaConfig_ == null
            ? com.google.container.v1beta1.StatefulHAConfig.getDefaultInstance()
            : statefulHaConfig_;
      } else {
        return statefulHaConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStatefulHaConfig(com.google.container.v1beta1.StatefulHAConfig value) {
      if (statefulHaConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statefulHaConfig_ = value;
      } else {
        statefulHaConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStatefulHaConfig(
        com.google.container.v1beta1.StatefulHAConfig.Builder builderForValue) {
      if (statefulHaConfigBuilder_ == null) {
        statefulHaConfig_ = builderForValue.build();
      } else {
        statefulHaConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeStatefulHaConfig(com.google.container.v1beta1.StatefulHAConfig value) {
      if (statefulHaConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && statefulHaConfig_ != null
            && statefulHaConfig_
                != com.google.container.v1beta1.StatefulHAConfig.getDefaultInstance()) {
          getStatefulHaConfigBuilder().mergeFrom(value);
        } else {
          statefulHaConfig_ = value;
        }
      } else {
        statefulHaConfigBuilder_.mergeFrom(value);
      }
      if (statefulHaConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearStatefulHaConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      statefulHaConfig_ = null;
      if (statefulHaConfigBuilder_ != null) {
        statefulHaConfigBuilder_.dispose();
        statefulHaConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.container.v1beta1.StatefulHAConfig.Builder getStatefulHaConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getStatefulHaConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.container.v1beta1.StatefulHAConfigOrBuilder getStatefulHaConfigOrBuilder() {
      if (statefulHaConfigBuilder_ != null) {
        return statefulHaConfigBuilder_.getMessageOrBuilder();
      } else {
        return statefulHaConfig_ == null
            ? com.google.container.v1beta1.StatefulHAConfig.getDefaultInstance()
            : statefulHaConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for the StatefulHA add-on.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.StatefulHAConfig stateful_ha_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.StatefulHAConfig,
            com.google.container.v1beta1.StatefulHAConfig.Builder,
            com.google.container.v1beta1.StatefulHAConfigOrBuilder>
        getStatefulHaConfigFieldBuilder() {
      if (statefulHaConfigBuilder_ == null) {
        statefulHaConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.StatefulHAConfig,
                com.google.container.v1beta1.StatefulHAConfig.Builder,
                com.google.container.v1beta1.StatefulHAConfigOrBuilder>(
                getStatefulHaConfig(), getParentForChildren(), isClean());
        statefulHaConfig_ = null;
      }
      return statefulHaConfigBuilder_;
    }

    private com.google.container.v1beta1.RayOperatorConfig rayOperatorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.RayOperatorConfig,
            com.google.container.v1beta1.RayOperatorConfig.Builder,
            com.google.container.v1beta1.RayOperatorConfigOrBuilder>
        rayOperatorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rayOperatorConfig field is set.
     */
    public boolean hasRayOperatorConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rayOperatorConfig.
     */
    public com.google.container.v1beta1.RayOperatorConfig getRayOperatorConfig() {
      if (rayOperatorConfigBuilder_ == null) {
        return rayOperatorConfig_ == null
            ? com.google.container.v1beta1.RayOperatorConfig.getDefaultInstance()
            : rayOperatorConfig_;
      } else {
        return rayOperatorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRayOperatorConfig(com.google.container.v1beta1.RayOperatorConfig value) {
      if (rayOperatorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rayOperatorConfig_ = value;
      } else {
        rayOperatorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRayOperatorConfig(
        com.google.container.v1beta1.RayOperatorConfig.Builder builderForValue) {
      if (rayOperatorConfigBuilder_ == null) {
        rayOperatorConfig_ = builderForValue.build();
      } else {
        rayOperatorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRayOperatorConfig(com.google.container.v1beta1.RayOperatorConfig value) {
      if (rayOperatorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && rayOperatorConfig_ != null
            && rayOperatorConfig_
                != com.google.container.v1beta1.RayOperatorConfig.getDefaultInstance()) {
          getRayOperatorConfigBuilder().mergeFrom(value);
        } else {
          rayOperatorConfig_ = value;
        }
      } else {
        rayOperatorConfigBuilder_.mergeFrom(value);
      }
      if (rayOperatorConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRayOperatorConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      rayOperatorConfig_ = null;
      if (rayOperatorConfigBuilder_ != null) {
        rayOperatorConfigBuilder_.dispose();
        rayOperatorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.container.v1beta1.RayOperatorConfig.Builder getRayOperatorConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getRayOperatorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.container.v1beta1.RayOperatorConfigOrBuilder getRayOperatorConfigOrBuilder() {
      if (rayOperatorConfigBuilder_ != null) {
        return rayOperatorConfigBuilder_.getMessageOrBuilder();
      } else {
        return rayOperatorConfig_ == null
            ? com.google.container.v1beta1.RayOperatorConfig.getDefaultInstance()
            : rayOperatorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for Ray Operator addon.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.RayOperatorConfig ray_operator_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.RayOperatorConfig,
            com.google.container.v1beta1.RayOperatorConfig.Builder,
            com.google.container.v1beta1.RayOperatorConfigOrBuilder>
        getRayOperatorConfigFieldBuilder() {
      if (rayOperatorConfigBuilder_ == null) {
        rayOperatorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.RayOperatorConfig,
                com.google.container.v1beta1.RayOperatorConfig.Builder,
                com.google.container.v1beta1.RayOperatorConfigOrBuilder>(
                getRayOperatorConfig(), getParentForChildren(), isClean());
        rayOperatorConfig_ = null;
      }
      return rayOperatorConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.AddonsConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.AddonsConfig)
  private static final com.google.container.v1beta1.AddonsConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.AddonsConfig();
  }

  public static com.google.container.v1beta1.AddonsConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AddonsConfig> PARSER =
      new com.google.protobuf.AbstractParser<AddonsConfig>() {
        @java.lang.Override
        public AddonsConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AddonsConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AddonsConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.AddonsConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
