/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * AutoprovisioningNodePoolDefaults contains defaults for a node pool created
 * by NAP.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.AutoprovisioningNodePoolDefaults}
 */
public final class AutoprovisioningNodePoolDefaults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.AutoprovisioningNodePoolDefaults)
    AutoprovisioningNodePoolDefaultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutoprovisioningNodePoolDefaults.newBuilder() to construct.
  private AutoprovisioningNodePoolDefaults(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutoprovisioningNodePoolDefaults() {
    oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccount_ = "";
    minCpuPlatform_ = "";
    diskType_ = "";
    bootDiskKmsKey_ = "";
    imageType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutoprovisioningNodePoolDefaults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_AutoprovisioningNodePoolDefaults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_AutoprovisioningNodePoolDefaults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.class,
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder.class);
  }

  private int bitField0_;
  public static final int OAUTH_SCOPES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList oauthScopes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 1;</code>
   *
   * @return A list containing the oauthScopes.
   */
  public com.google.protobuf.ProtocolStringList getOauthScopesList() {
    return oauthScopes_;
  }
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 1;</code>
   *
   * @return The count of oauthScopes.
   */
  public int getOauthScopesCount() {
    return oauthScopes_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The oauthScopes at the given index.
   */
  public java.lang.String getOauthScopes(int index) {
    return oauthScopes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of Google API scopes to be made available on all of the
   * node VMs under the "default" service account.
   *
   * The following scopes are recommended, but not required, and by default are
   * not included:
   *
   * * `https://www.googleapis.com/auth/compute` is required for mounting
   * persistent storage on your nodes.
   * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
   * communicating with **gcr.io**
   * (the [Google Container
   * Registry](https://cloud.google.com/container-registry/)).
   *
   * If unspecified, no scopes are added, unless Cloud Logging or Cloud
   * Monitoring are enabled, in which case their required scopes will be added.
   * </pre>
   *
   * <code>repeated string oauth_scopes = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the oauthScopes at the given index.
   */
  public com.google.protobuf.ByteString getOauthScopesBytes(int index) {
    return oauthScopes_.getByteString(index);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * The Google Cloud Platform Service Account to be used by the node VMs.
   * Specify the email address of the Service Account; otherwise, if no Service
   * Account is specified, the "default" service account is used.
   * </pre>
   *
   * <code>string service_account = 2;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Platform Service Account to be used by the node VMs.
   * Specify the email address of the Service Account; otherwise, if no Service
   * Account is specified, the "default" service account is used.
   * </pre>
   *
   * <code>string service_account = 2;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPGRADE_SETTINGS_FIELD_NUMBER = 3;
  private com.google.container.v1beta1.NodePool.UpgradeSettings upgradeSettings_;
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
   *
   * @return Whether the upgradeSettings field is set.
   */
  @java.lang.Override
  public boolean hasUpgradeSettings() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
   *
   * @return The upgradeSettings.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodePool.UpgradeSettings getUpgradeSettings() {
    return upgradeSettings_ == null
        ? com.google.container.v1beta1.NodePool.UpgradeSettings.getDefaultInstance()
        : upgradeSettings_;
  }
  /**
   *
   *
   * <pre>
   * Upgrade settings control disruption and speed of the upgrade.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodePool.UpgradeSettingsOrBuilder
      getUpgradeSettingsOrBuilder() {
    return upgradeSettings_ == null
        ? com.google.container.v1beta1.NodePool.UpgradeSettings.getDefaultInstance()
        : upgradeSettings_;
  }

  public static final int MANAGEMENT_FIELD_NUMBER = 4;
  private com.google.container.v1beta1.NodeManagement management_;
  /**
   *
   *
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
   *
   * @return Whether the management field is set.
   */
  @java.lang.Override
  public boolean hasManagement() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
   *
   * @return The management.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeManagement getManagement() {
    return management_ == null
        ? com.google.container.v1beta1.NodeManagement.getDefaultInstance()
        : management_;
  }
  /**
   *
   *
   * <pre>
   * NodeManagement configuration for this NodePool.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeManagementOrBuilder getManagementOrBuilder() {
    return management_ == null
        ? com.google.container.v1beta1.NodeManagement.getDefaultInstance()
        : management_;
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minCpuPlatform_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. Minimum CPU platform to be used for NAP created node pools.
   * The instance may be scheduled on the specified or newer CPU platform.
   * Applicable values are the friendly names of CPU platforms, such as
   * minCpuPlatform: Intel Haswell or
   * minCpuPlatform: Intel Sandy Bridge. For more
   * information, read [how to specify min CPU
   * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
   * This field is deprecated, min_cpu_platform should be specified using
   * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
   * To unset the min cpu platform field pass "automatic"
   * as field value.
   * </pre>
   *
   * <code>string min_cpu_platform = 5 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
   *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Minimum CPU platform to be used for NAP created node pools.
   * The instance may be scheduled on the specified or newer CPU platform.
   * Applicable values are the friendly names of CPU platforms, such as
   * minCpuPlatform: Intel Haswell or
   * minCpuPlatform: Intel Sandy Bridge. For more
   * information, read [how to specify min CPU
   * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
   * This field is deprecated, min_cpu_platform should be specified using
   * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
   * To unset the min cpu platform field pass "automatic"
   * as field value.
   * </pre>
   *
   * <code>string min_cpu_platform = 5 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
   *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 6;
  private int diskSizeGb_ = 0;
  /**
   *
   *
   * <pre>
   * Size of the disk attached to each node, specified in GB.
   * The smallest allowed disk size is 10GB.
   *
   * If unspecified, the default disk size is 100GB.
   * </pre>
   *
   * <code>int32 disk_size_gb = 6;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public int getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int DISK_TYPE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskType_ = "";
  /**
   *
   *
   * <pre>
   * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
   * 'pd-balanced')
   *
   * If unspecified, the default disk type is 'pd-standard'
   * </pre>
   *
   * <code>string disk_type = 7;</code>
   *
   * @return The diskType.
   */
  @java.lang.Override
  public java.lang.String getDiskType() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
   * 'pd-balanced')
   *
   * If unspecified, the default disk type is 'pd-standard'
   * </pre>
   *
   * <code>string disk_type = 7;</code>
   *
   * @return The bytes for diskType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskTypeBytes() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 8;
  private com.google.container.v1beta1.ShieldedInstanceConfig shieldedInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Shielded Instance options.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Shielded Instance options.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
   *
   * @return The shieldedInstanceConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig_ == null
        ? com.google.container.v1beta1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Shielded Instance options.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder() {
    return shieldedInstanceConfig_ == null
        ? com.google.container.v1beta1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  public static final int BOOT_DISK_KMS_KEY_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bootDiskKmsKey_ = "";
  /**
   *
   *
   * <pre>
   *
   * The Customer Managed Encryption Key used to encrypt the boot disk attached
   * to each node in the node pool. This should be of the form
   * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
   * For more information about protecting resources with Cloud KMS Keys please
   * see:
   * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
   * </pre>
   *
   * <code>string boot_disk_kms_key = 9;</code>
   *
   * @return The bootDiskKmsKey.
   */
  @java.lang.Override
  public java.lang.String getBootDiskKmsKey() {
    java.lang.Object ref = bootDiskKmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bootDiskKmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   *
   * The Customer Managed Encryption Key used to encrypt the boot disk attached
   * to each node in the node pool. This should be of the form
   * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
   * For more information about protecting resources with Cloud KMS Keys please
   * see:
   * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
   * </pre>
   *
   * <code>string boot_disk_kms_key = 9;</code>
   *
   * @return The bytes for bootDiskKmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBootDiskKmsKeyBytes() {
    java.lang.Object ref = bootDiskKmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bootDiskKmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_TYPE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageType_ = "";
  /**
   *
   *
   * <pre>
   * The image type to use for NAP created node. Please see
   * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
   * available image types.
   * </pre>
   *
   * <code>string image_type = 10;</code>
   *
   * @return The imageType.
   */
  @java.lang.Override
  public java.lang.String getImageType() {
    java.lang.Object ref = imageType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The image type to use for NAP created node. Please see
   * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
   * available image types.
   * </pre>
   *
   * <code>string image_type = 10;</code>
   *
   * @return The bytes for imageType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageTypeBytes() {
    java.lang.Object ref = imageType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSECURE_KUBELET_READONLY_PORT_ENABLED_FIELD_NUMBER = 13;
  private boolean insecureKubeletReadonlyPortEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Enable or disable Kubelet read only port.
   * </pre>
   *
   * <code>optional bool insecure_kubelet_readonly_port_enabled = 13;</code>
   *
   * @return Whether the insecureKubeletReadonlyPortEnabled field is set.
   */
  @java.lang.Override
  public boolean hasInsecureKubeletReadonlyPortEnabled() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable or disable Kubelet read only port.
   * </pre>
   *
   * <code>optional bool insecure_kubelet_readonly_port_enabled = 13;</code>
   *
   * @return The insecureKubeletReadonlyPortEnabled.
   */
  @java.lang.Override
  public boolean getInsecureKubeletReadonlyPortEnabled() {
    return insecureKubeletReadonlyPortEnabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < oauthScopes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, oauthScopes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceAccount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getUpgradeSettings());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getManagement());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, minCpuPlatform_);
    }
    if (diskSizeGb_ != 0) {
      output.writeInt32(6, diskSizeGb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, diskType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getShieldedInstanceConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootDiskKmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, bootDiskKmsKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, imageType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(13, insecureKubeletReadonlyPortEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < oauthScopes_.size(); i++) {
        dataSize += computeStringSizeNoTag(oauthScopes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOauthScopesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceAccount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpgradeSettings());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getManagement());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, minCpuPlatform_);
    }
    if (diskSizeGb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, diskSizeGb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, diskType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getShieldedInstanceConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootDiskKmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, bootDiskKmsKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, imageType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              13, insecureKubeletReadonlyPortEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.AutoprovisioningNodePoolDefaults)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.AutoprovisioningNodePoolDefaults other =
        (com.google.container.v1beta1.AutoprovisioningNodePoolDefaults) obj;

    if (!getOauthScopesList().equals(other.getOauthScopesList())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (hasUpgradeSettings() != other.hasUpgradeSettings()) return false;
    if (hasUpgradeSettings()) {
      if (!getUpgradeSettings().equals(other.getUpgradeSettings())) return false;
    }
    if (hasManagement() != other.hasManagement()) return false;
    if (hasManagement()) {
      if (!getManagement().equals(other.getManagement())) return false;
    }
    if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    if (!getDiskType().equals(other.getDiskType())) return false;
    if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
    if (hasShieldedInstanceConfig()) {
      if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
    }
    if (!getBootDiskKmsKey().equals(other.getBootDiskKmsKey())) return false;
    if (!getImageType().equals(other.getImageType())) return false;
    if (hasInsecureKubeletReadonlyPortEnabled() != other.hasInsecureKubeletReadonlyPortEnabled())
      return false;
    if (hasInsecureKubeletReadonlyPortEnabled()) {
      if (getInsecureKubeletReadonlyPortEnabled() != other.getInsecureKubeletReadonlyPortEnabled())
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getOauthScopesCount() > 0) {
      hash = (37 * hash) + OAUTH_SCOPES_FIELD_NUMBER;
      hash = (53 * hash) + getOauthScopesList().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (hasUpgradeSettings()) {
      hash = (37 * hash) + UPGRADE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getUpgradeSettings().hashCode();
    }
    if (hasManagement()) {
      hash = (37 * hash) + MANAGEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getManagement().hashCode();
    }
    hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
    hash = (53 * hash) + getMinCpuPlatform().hashCode();
    hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + getDiskSizeGb();
    hash = (37 * hash) + DISK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDiskType().hashCode();
    if (hasShieldedInstanceConfig()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
    }
    hash = (37 * hash) + BOOT_DISK_KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getBootDiskKmsKey().hashCode();
    hash = (37 * hash) + IMAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getImageType().hashCode();
    if (hasInsecureKubeletReadonlyPortEnabled()) {
      hash = (37 * hash) + INSECURE_KUBELET_READONLY_PORT_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getInsecureKubeletReadonlyPortEnabled());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.container.v1beta1.AutoprovisioningNodePoolDefaults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AutoprovisioningNodePoolDefaults contains defaults for a node pool created
   * by NAP.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.AutoprovisioningNodePoolDefaults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.AutoprovisioningNodePoolDefaults)
      com.google.container.v1beta1.AutoprovisioningNodePoolDefaultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_AutoprovisioningNodePoolDefaults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_AutoprovisioningNodePoolDefaults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.class,
              com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder.class);
    }

    // Construct using com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpgradeSettingsFieldBuilder();
        getManagementFieldBuilder();
        getShieldedInstanceConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      serviceAccount_ = "";
      upgradeSettings_ = null;
      if (upgradeSettingsBuilder_ != null) {
        upgradeSettingsBuilder_.dispose();
        upgradeSettingsBuilder_ = null;
      }
      management_ = null;
      if (managementBuilder_ != null) {
        managementBuilder_.dispose();
        managementBuilder_ = null;
      }
      minCpuPlatform_ = "";
      diskSizeGb_ = 0;
      diskType_ = "";
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      bootDiskKmsKey_ = "";
      imageType_ = "";
      insecureKubeletReadonlyPortEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_AutoprovisioningNodePoolDefaults_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
        getDefaultInstanceForType() {
      return com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults build() {
      com.google.container.v1beta1.AutoprovisioningNodePoolDefaults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults buildPartial() {
      com.google.container.v1beta1.AutoprovisioningNodePoolDefaults result =
          new com.google.container.v1beta1.AutoprovisioningNodePoolDefaults(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.container.v1beta1.AutoprovisioningNodePoolDefaults result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        oauthScopes_.makeImmutable();
        result.oauthScopes_ = oauthScopes_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.upgradeSettings_ =
            upgradeSettingsBuilder_ == null ? upgradeSettings_ : upgradeSettingsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.management_ = managementBuilder_ == null ? management_ : managementBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.minCpuPlatform_ = minCpuPlatform_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.diskType_ = diskType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.shieldedInstanceConfig_ =
            shieldedInstanceConfigBuilder_ == null
                ? shieldedInstanceConfig_
                : shieldedInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.bootDiskKmsKey_ = bootDiskKmsKey_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.imageType_ = imageType_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.insecureKubeletReadonlyPortEnabled_ = insecureKubeletReadonlyPortEnabled_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.AutoprovisioningNodePoolDefaults) {
        return mergeFrom((com.google.container.v1beta1.AutoprovisioningNodePoolDefaults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.AutoprovisioningNodePoolDefaults other) {
      if (other
          == com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.getDefaultInstance())
        return this;
      if (!other.oauthScopes_.isEmpty()) {
        if (oauthScopes_.isEmpty()) {
          oauthScopes_ = other.oauthScopes_;
          bitField0_ |= 0x00000001;
        } else {
          ensureOauthScopesIsMutable();
          oauthScopes_.addAll(other.oauthScopes_);
        }
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasUpgradeSettings()) {
        mergeUpgradeSettings(other.getUpgradeSettings());
      }
      if (other.hasManagement()) {
        mergeManagement(other.getManagement());
      }
      if (!other.getMinCpuPlatform().isEmpty()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getDiskSizeGb() != 0) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (!other.getDiskType().isEmpty()) {
        diskType_ = other.diskType_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasShieldedInstanceConfig()) {
        mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
      }
      if (!other.getBootDiskKmsKey().isEmpty()) {
        bootDiskKmsKey_ = other.bootDiskKmsKey_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getImageType().isEmpty()) {
        imageType_ = other.imageType_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasInsecureKubeletReadonlyPortEnabled()) {
        setInsecureKubeletReadonlyPortEnabled(other.getInsecureKubeletReadonlyPortEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureOauthScopesIsMutable();
                oauthScopes_.add(s);
                break;
              } // case 10
            case 18:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpgradeSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getManagementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                diskSizeGb_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                diskType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                bootDiskKmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                imageType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 104:
              {
                insecureKubeletReadonlyPortEnabled_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 104
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList oauthScopes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureOauthScopesIsMutable() {
      if (!oauthScopes_.isModifiable()) {
        oauthScopes_ = new com.google.protobuf.LazyStringArrayList(oauthScopes_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @return A list containing the oauthScopes.
     */
    public com.google.protobuf.ProtocolStringList getOauthScopesList() {
      oauthScopes_.makeImmutable();
      return oauthScopes_;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @return The count of oauthScopes.
     */
    public int getOauthScopesCount() {
      return oauthScopes_.size();
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The oauthScopes at the given index.
     */
    public java.lang.String getOauthScopes(int index) {
      return oauthScopes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the oauthScopes at the given index.
     */
    public com.google.protobuf.ByteString getOauthScopesBytes(int index) {
      return oauthScopes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The oauthScopes to set.
     * @return This builder for chaining.
     */
    public Builder setOauthScopes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOauthScopesIsMutable();
      oauthScopes_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @param value The oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addOauthScopes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOauthScopesIsMutable();
      oauthScopes_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @param values The oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addAllOauthScopes(java.lang.Iterable<java.lang.String> values) {
      ensureOauthScopesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, oauthScopes_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOauthScopes() {
      oauthScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of Google API scopes to be made available on all of the
     * node VMs under the "default" service account.
     *
     * The following scopes are recommended, but not required, and by default are
     * not included:
     *
     * * `https://www.googleapis.com/auth/compute` is required for mounting
     * persistent storage on your nodes.
     * * `https://www.googleapis.com/auth/devstorage.read_only` is required for
     * communicating with **gcr.io**
     * (the [Google Container
     * Registry](https://cloud.google.com/container-registry/)).
     *
     * If unspecified, no scopes are added, unless Cloud Logging or Cloud
     * Monitoring are enabled, in which case their required scopes will be added.
     * </pre>
     *
     * <code>repeated string oauth_scopes = 1;</code>
     *
     * @param value The bytes of the oauthScopes to add.
     * @return This builder for chaining.
     */
    public Builder addOauthScopesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureOauthScopesIsMutable();
      oauthScopes_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Platform Service Account to be used by the node VMs.
     * Specify the email address of the Service Account; otherwise, if no Service
     * Account is specified, the "default" service account is used.
     * </pre>
     *
     * <code>string service_account = 2;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NodePool.UpgradeSettings upgradeSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodePool.UpgradeSettings,
            com.google.container.v1beta1.NodePool.UpgradeSettings.Builder,
            com.google.container.v1beta1.NodePool.UpgradeSettingsOrBuilder>
        upgradeSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     *
     * @return Whether the upgradeSettings field is set.
     */
    public boolean hasUpgradeSettings() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     *
     * @return The upgradeSettings.
     */
    public com.google.container.v1beta1.NodePool.UpgradeSettings getUpgradeSettings() {
      if (upgradeSettingsBuilder_ == null) {
        return upgradeSettings_ == null
            ? com.google.container.v1beta1.NodePool.UpgradeSettings.getDefaultInstance()
            : upgradeSettings_;
      } else {
        return upgradeSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    public Builder setUpgradeSettings(com.google.container.v1beta1.NodePool.UpgradeSettings value) {
      if (upgradeSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upgradeSettings_ = value;
      } else {
        upgradeSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    public Builder setUpgradeSettings(
        com.google.container.v1beta1.NodePool.UpgradeSettings.Builder builderForValue) {
      if (upgradeSettingsBuilder_ == null) {
        upgradeSettings_ = builderForValue.build();
      } else {
        upgradeSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    public Builder mergeUpgradeSettings(
        com.google.container.v1beta1.NodePool.UpgradeSettings value) {
      if (upgradeSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && upgradeSettings_ != null
            && upgradeSettings_
                != com.google.container.v1beta1.NodePool.UpgradeSettings.getDefaultInstance()) {
          getUpgradeSettingsBuilder().mergeFrom(value);
        } else {
          upgradeSettings_ = value;
        }
      } else {
        upgradeSettingsBuilder_.mergeFrom(value);
      }
      if (upgradeSettings_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    public Builder clearUpgradeSettings() {
      bitField0_ = (bitField0_ & ~0x00000004);
      upgradeSettings_ = null;
      if (upgradeSettingsBuilder_ != null) {
        upgradeSettingsBuilder_.dispose();
        upgradeSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    public com.google.container.v1beta1.NodePool.UpgradeSettings.Builder
        getUpgradeSettingsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpgradeSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    public com.google.container.v1beta1.NodePool.UpgradeSettingsOrBuilder
        getUpgradeSettingsOrBuilder() {
      if (upgradeSettingsBuilder_ != null) {
        return upgradeSettingsBuilder_.getMessageOrBuilder();
      } else {
        return upgradeSettings_ == null
            ? com.google.container.v1beta1.NodePool.UpgradeSettings.getDefaultInstance()
            : upgradeSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Upgrade settings control disruption and speed of the upgrade.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePool.UpgradeSettings upgrade_settings = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodePool.UpgradeSettings,
            com.google.container.v1beta1.NodePool.UpgradeSettings.Builder,
            com.google.container.v1beta1.NodePool.UpgradeSettingsOrBuilder>
        getUpgradeSettingsFieldBuilder() {
      if (upgradeSettingsBuilder_ == null) {
        upgradeSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodePool.UpgradeSettings,
                com.google.container.v1beta1.NodePool.UpgradeSettings.Builder,
                com.google.container.v1beta1.NodePool.UpgradeSettingsOrBuilder>(
                getUpgradeSettings(), getParentForChildren(), isClean());
        upgradeSettings_ = null;
      }
      return upgradeSettingsBuilder_;
    }

    private com.google.container.v1beta1.NodeManagement management_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeManagement,
            com.google.container.v1beta1.NodeManagement.Builder,
            com.google.container.v1beta1.NodeManagementOrBuilder>
        managementBuilder_;
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     *
     * @return Whether the management field is set.
     */
    public boolean hasManagement() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     *
     * @return The management.
     */
    public com.google.container.v1beta1.NodeManagement getManagement() {
      if (managementBuilder_ == null) {
        return management_ == null
            ? com.google.container.v1beta1.NodeManagement.getDefaultInstance()
            : management_;
      } else {
        return managementBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    public Builder setManagement(com.google.container.v1beta1.NodeManagement value) {
      if (managementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        management_ = value;
      } else {
        managementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    public Builder setManagement(
        com.google.container.v1beta1.NodeManagement.Builder builderForValue) {
      if (managementBuilder_ == null) {
        management_ = builderForValue.build();
      } else {
        managementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    public Builder mergeManagement(com.google.container.v1beta1.NodeManagement value) {
      if (managementBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && management_ != null
            && management_ != com.google.container.v1beta1.NodeManagement.getDefaultInstance()) {
          getManagementBuilder().mergeFrom(value);
        } else {
          management_ = value;
        }
      } else {
        managementBuilder_.mergeFrom(value);
      }
      if (management_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    public Builder clearManagement() {
      bitField0_ = (bitField0_ & ~0x00000008);
      management_ = null;
      if (managementBuilder_ != null) {
        managementBuilder_.dispose();
        managementBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    public com.google.container.v1beta1.NodeManagement.Builder getManagementBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getManagementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    public com.google.container.v1beta1.NodeManagementOrBuilder getManagementOrBuilder() {
      if (managementBuilder_ != null) {
        return managementBuilder_.getMessageOrBuilder();
      } else {
        return management_ == null
            ? com.google.container.v1beta1.NodeManagement.getDefaultInstance()
            : management_;
      }
    }
    /**
     *
     *
     * <pre>
     * NodeManagement configuration for this NodePool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeManagement management = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeManagement,
            com.google.container.v1beta1.NodeManagement.Builder,
            com.google.container.v1beta1.NodeManagementOrBuilder>
        getManagementFieldBuilder() {
      if (managementBuilder_ == null) {
        managementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodeManagement,
                com.google.container.v1beta1.NodeManagement.Builder,
                com.google.container.v1beta1.NodeManagementOrBuilder>(
                getManagement(), getParentForChildren(), isClean());
        management_ = null;
      }
      return managementBuilder_;
    }

    private java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. Minimum CPU platform to be used for NAP created node pools.
     * The instance may be scheduled on the specified or newer CPU platform.
     * Applicable values are the friendly names of CPU platforms, such as
     * minCpuPlatform: Intel Haswell or
     * minCpuPlatform: Intel Sandy Bridge. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
     * This field is deprecated, min_cpu_platform should be specified using
     * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
     * To unset the min cpu platform field pass "automatic"
     * as field value.
     * </pre>
     *
     * <code>string min_cpu_platform = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
     *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
     * @return The minCpuPlatform.
     */
    @java.lang.Deprecated
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Minimum CPU platform to be used for NAP created node pools.
     * The instance may be scheduled on the specified or newer CPU platform.
     * Applicable values are the friendly names of CPU platforms, such as
     * minCpuPlatform: Intel Haswell or
     * minCpuPlatform: Intel Sandy Bridge. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
     * This field is deprecated, min_cpu_platform should be specified using
     * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
     * To unset the min cpu platform field pass "automatic"
     * as field value.
     * </pre>
     *
     * <code>string min_cpu_platform = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
     *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
     * @return The bytes for minCpuPlatform.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Minimum CPU platform to be used for NAP created node pools.
     * The instance may be scheduled on the specified or newer CPU platform.
     * Applicable values are the friendly names of CPU platforms, such as
     * minCpuPlatform: Intel Haswell or
     * minCpuPlatform: Intel Sandy Bridge. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
     * This field is deprecated, min_cpu_platform should be specified using
     * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
     * To unset the min cpu platform field pass "automatic"
     * as field value.
     * </pre>
     *
     * <code>string min_cpu_platform = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
     *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Minimum CPU platform to be used for NAP created node pools.
     * The instance may be scheduled on the specified or newer CPU platform.
     * Applicable values are the friendly names of CPU platforms, such as
     * minCpuPlatform: Intel Haswell or
     * minCpuPlatform: Intel Sandy Bridge. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
     * This field is deprecated, min_cpu_platform should be specified using
     * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
     * To unset the min cpu platform field pass "automatic"
     * as field value.
     * </pre>
     *
     * <code>string min_cpu_platform = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
     *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearMinCpuPlatform() {
      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Minimum CPU platform to be used for NAP created node pools.
     * The instance may be scheduled on the specified or newer CPU platform.
     * Applicable values are the friendly names of CPU platforms, such as
     * minCpuPlatform: Intel Haswell or
     * minCpuPlatform: Intel Sandy Bridge. For more
     * information, read [how to specify min CPU
     * platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
     * This field is deprecated, min_cpu_platform should be specified using
     * `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
     * To unset the min cpu platform field pass "automatic"
     * as field value.
     * </pre>
     *
     * <code>string min_cpu_platform = 5 [deprecated = true];</code>
     *
     * @deprecated google.container.v1beta1.AutoprovisioningNodePoolDefaults.min_cpu_platform is
     *     deprecated. See google/container/v1beta1/cluster_service.proto;l=4620
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     *
     * If unspecified, the default disk size is 100GB.
     * </pre>
     *
     * <code>int32 disk_size_gb = 6;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public int getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     *
     * If unspecified, the default disk size is 100GB.
     * </pre>
     *
     * <code>int32 disk_size_gb = 6;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(int value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Size of the disk attached to each node, specified in GB.
     * The smallest allowed disk size is 10GB.
     *
     * If unspecified, the default disk size is 100GB.
     * </pre>
     *
     * <code>int32 disk_size_gb = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000020);
      diskSizeGb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object diskType_ = "";
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 7;</code>
     *
     * @return The diskType.
     */
    public java.lang.String getDiskType() {
      java.lang.Object ref = diskType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 7;</code>
     *
     * @return The bytes for diskType.
     */
    public com.google.protobuf.ByteString getDiskTypeBytes() {
      java.lang.Object ref = diskType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 7;</code>
     *
     * @param value The diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskType() {
      diskType_ = getDefaultInstance().getDiskType();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
     * 'pd-balanced')
     *
     * If unspecified, the default disk type is 'pd-standard'
     * </pre>
     *
     * <code>string disk_type = 7;</code>
     *
     * @param value The bytes for diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.ShieldedInstanceConfig shieldedInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ShieldedInstanceConfig,
            com.google.container.v1beta1.ShieldedInstanceConfig.Builder,
            com.google.container.v1beta1.ShieldedInstanceConfigOrBuilder>
        shieldedInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     *
     * @return Whether the shieldedInstanceConfig field is set.
     */
    public boolean hasShieldedInstanceConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     *
     * @return The shieldedInstanceConfig.
     */
    public com.google.container.v1beta1.ShieldedInstanceConfig getShieldedInstanceConfig() {
      if (shieldedInstanceConfigBuilder_ == null) {
        return shieldedInstanceConfig_ == null
            ? com.google.container.v1beta1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      } else {
        return shieldedInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.container.v1beta1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceConfig_ = value;
      } else {
        shieldedInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.container.v1beta1.ShieldedInstanceConfig.Builder builderForValue) {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfig_ = builderForValue.build();
      } else {
        shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    public Builder mergeShieldedInstanceConfig(
        com.google.container.v1beta1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && shieldedInstanceConfig_ != null
            && shieldedInstanceConfig_
                != com.google.container.v1beta1.ShieldedInstanceConfig.getDefaultInstance()) {
          getShieldedInstanceConfigBuilder().mergeFrom(value);
        } else {
          shieldedInstanceConfig_ = value;
        }
      } else {
        shieldedInstanceConfigBuilder_.mergeFrom(value);
      }
      if (shieldedInstanceConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    public Builder clearShieldedInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    public com.google.container.v1beta1.ShieldedInstanceConfig.Builder
        getShieldedInstanceConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getShieldedInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    public com.google.container.v1beta1.ShieldedInstanceConfigOrBuilder
        getShieldedInstanceConfigOrBuilder() {
      if (shieldedInstanceConfigBuilder_ != null) {
        return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceConfig_ == null
            ? com.google.container.v1beta1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Shielded Instance options.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedInstanceConfig shielded_instance_config = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ShieldedInstanceConfig,
            com.google.container.v1beta1.ShieldedInstanceConfig.Builder,
            com.google.container.v1beta1.ShieldedInstanceConfigOrBuilder>
        getShieldedInstanceConfigFieldBuilder() {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ShieldedInstanceConfig,
                com.google.container.v1beta1.ShieldedInstanceConfig.Builder,
                com.google.container.v1beta1.ShieldedInstanceConfigOrBuilder>(
                getShieldedInstanceConfig(), getParentForChildren(), isClean());
        shieldedInstanceConfig_ = null;
      }
      return shieldedInstanceConfigBuilder_;
    }

    private java.lang.Object bootDiskKmsKey_ = "";
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 9;</code>
     *
     * @return The bootDiskKmsKey.
     */
    public java.lang.String getBootDiskKmsKey() {
      java.lang.Object ref = bootDiskKmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bootDiskKmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 9;</code>
     *
     * @return The bytes for bootDiskKmsKey.
     */
    public com.google.protobuf.ByteString getBootDiskKmsKeyBytes() {
      java.lang.Object ref = bootDiskKmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bootDiskKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 9;</code>
     *
     * @param value The bootDiskKmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bootDiskKmsKey_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBootDiskKmsKey() {
      bootDiskKmsKey_ = getDefaultInstance().getBootDiskKmsKey();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * The Customer Managed Encryption Key used to encrypt the boot disk attached
     * to each node in the node pool. This should be of the form
     * projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
     * For more information about protecting resources with Cloud KMS Keys please
     * see:
     * https://cloud.google.com/compute/docs/disks/customer-managed-encryption
     * </pre>
     *
     * <code>string boot_disk_kms_key = 9;</code>
     *
     * @param value The bytes for bootDiskKmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bootDiskKmsKey_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object imageType_ = "";
    /**
     *
     *
     * <pre>
     * The image type to use for NAP created node. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 10;</code>
     *
     * @return The imageType.
     */
    public java.lang.String getImageType() {
      java.lang.Object ref = imageType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The image type to use for NAP created node. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 10;</code>
     *
     * @return The bytes for imageType.
     */
    public com.google.protobuf.ByteString getImageTypeBytes() {
      java.lang.Object ref = imageType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The image type to use for NAP created node. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 10;</code>
     *
     * @param value The imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image type to use for NAP created node. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageType() {
      imageType_ = getDefaultInstance().getImageType();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image type to use for NAP created node. Please see
     * https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
     * available image types.
     * </pre>
     *
     * <code>string image_type = 10;</code>
     *
     * @param value The bytes for imageType to set.
     * @return This builder for chaining.
     */
    public Builder setImageTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean insecureKubeletReadonlyPortEnabled_;
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 13;</code>
     *
     * @return Whether the insecureKubeletReadonlyPortEnabled field is set.
     */
    @java.lang.Override
    public boolean hasInsecureKubeletReadonlyPortEnabled() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 13;</code>
     *
     * @return The insecureKubeletReadonlyPortEnabled.
     */
    @java.lang.Override
    public boolean getInsecureKubeletReadonlyPortEnabled() {
      return insecureKubeletReadonlyPortEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 13;</code>
     *
     * @param value The insecureKubeletReadonlyPortEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setInsecureKubeletReadonlyPortEnabled(boolean value) {

      insecureKubeletReadonlyPortEnabled_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInsecureKubeletReadonlyPortEnabled() {
      bitField0_ = (bitField0_ & ~0x00000400);
      insecureKubeletReadonlyPortEnabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.AutoprovisioningNodePoolDefaults)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.AutoprovisioningNodePoolDefaults)
  private static final com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.AutoprovisioningNodePoolDefaults();
  }

  public static com.google.container.v1beta1.AutoprovisioningNodePoolDefaults getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutoprovisioningNodePoolDefaults> PARSER =
      new com.google.protobuf.AbstractParser<AutoprovisioningNodePoolDefaults>() {
        @java.lang.Override
        public AutoprovisioningNodePoolDefaults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutoprovisioningNodePoolDefaults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutoprovisioningNodePoolDefaults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
