/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * ClusterAutoscaling contains global, per-cluster information
 * required by Cluster Autoscaler to automatically adjust
 * the size of the cluster and create/delete
 * node pools based on the current needs.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.ClusterAutoscaling}
 */
public final class ClusterAutoscaling extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.ClusterAutoscaling)
    ClusterAutoscalingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterAutoscaling.newBuilder() to construct.
  private ClusterAutoscaling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterAutoscaling() {
    resourceLimits_ = java.util.Collections.emptyList();
    autoscalingProfile_ = 0;
    autoprovisioningLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterAutoscaling();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_ClusterAutoscaling_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_ClusterAutoscaling_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.ClusterAutoscaling.class,
            com.google.container.v1beta1.ClusterAutoscaling.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines possible options for autoscaling_profile field.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile}
   */
  public enum AutoscalingProfile implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No change to autoscaling configuration.
     * </pre>
     *
     * <code>PROFILE_UNSPECIFIED = 0;</code>
     */
    PROFILE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Prioritize optimizing utilization of resources.
     * </pre>
     *
     * <code>OPTIMIZE_UTILIZATION = 1;</code>
     */
    OPTIMIZE_UTILIZATION(1),
    /**
     *
     *
     * <pre>
     * Use default (balanced) autoscaling configuration.
     * </pre>
     *
     * <code>BALANCED = 2;</code>
     */
    BALANCED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No change to autoscaling configuration.
     * </pre>
     *
     * <code>PROFILE_UNSPECIFIED = 0;</code>
     */
    public static final int PROFILE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Prioritize optimizing utilization of resources.
     * </pre>
     *
     * <code>OPTIMIZE_UTILIZATION = 1;</code>
     */
    public static final int OPTIMIZE_UTILIZATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use default (balanced) autoscaling configuration.
     * </pre>
     *
     * <code>BALANCED = 2;</code>
     */
    public static final int BALANCED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AutoscalingProfile valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AutoscalingProfile forNumber(int value) {
      switch (value) {
        case 0:
          return PROFILE_UNSPECIFIED;
        case 1:
          return OPTIMIZE_UTILIZATION;
        case 2:
          return BALANCED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AutoscalingProfile>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AutoscalingProfile>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AutoscalingProfile>() {
              public AutoscalingProfile findValueByNumber(int number) {
                return AutoscalingProfile.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterAutoscaling.getDescriptor().getEnumTypes().get(0);
    }

    private static final AutoscalingProfile[] VALUES = values();

    public static AutoscalingProfile valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AutoscalingProfile(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile)
  }

  private int bitField0_;
  public static final int ENABLE_NODE_AUTOPROVISIONING_FIELD_NUMBER = 1;
  private boolean enableNodeAutoprovisioning_ = false;
  /**
   *
   *
   * <pre>
   * Enables automatic node pool creation and deletion.
   * </pre>
   *
   * <code>bool enable_node_autoprovisioning = 1;</code>
   *
   * @return The enableNodeAutoprovisioning.
   */
  @java.lang.Override
  public boolean getEnableNodeAutoprovisioning() {
    return enableNodeAutoprovisioning_;
  }

  public static final int RESOURCE_LIMITS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1beta1.ResourceLimit> resourceLimits_;
  /**
   *
   *
   * <pre>
   * Contains global constraints regarding minimum and maximum
   * amount of resources in the cluster.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1beta1.ResourceLimit> getResourceLimitsList() {
    return resourceLimits_;
  }
  /**
   *
   *
   * <pre>
   * Contains global constraints regarding minimum and maximum
   * amount of resources in the cluster.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1beta1.ResourceLimitOrBuilder>
      getResourceLimitsOrBuilderList() {
    return resourceLimits_;
  }
  /**
   *
   *
   * <pre>
   * Contains global constraints regarding minimum and maximum
   * amount of resources in the cluster.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
   */
  @java.lang.Override
  public int getResourceLimitsCount() {
    return resourceLimits_.size();
  }
  /**
   *
   *
   * <pre>
   * Contains global constraints regarding minimum and maximum
   * amount of resources in the cluster.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ResourceLimit getResourceLimits(int index) {
    return resourceLimits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Contains global constraints regarding minimum and maximum
   * amount of resources in the cluster.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ResourceLimitOrBuilder getResourceLimitsOrBuilder(int index) {
    return resourceLimits_.get(index);
  }

  public static final int AUTOSCALING_PROFILE_FIELD_NUMBER = 3;
  private int autoscalingProfile_ = 0;
  /**
   *
   *
   * <pre>
   * Defines autoscaling behaviour.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for autoscalingProfile.
   */
  @java.lang.Override
  public int getAutoscalingProfileValue() {
    return autoscalingProfile_;
  }
  /**
   *
   *
   * <pre>
   * Defines autoscaling behaviour.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
   * </code>
   *
   * @return The autoscalingProfile.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile
      getAutoscalingProfile() {
    com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile result =
        com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile.forNumber(
            autoscalingProfile_);
    return result == null
        ? com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile.UNRECOGNIZED
        : result;
  }

  public static final int AUTOPROVISIONING_NODE_POOL_DEFAULTS_FIELD_NUMBER = 4;
  private com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
      autoprovisioningNodePoolDefaults_;
  /**
   *
   *
   * <pre>
   * AutoprovisioningNodePoolDefaults contains defaults for a node pool
   * created by NAP.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
   * </code>
   *
   * @return Whether the autoprovisioningNodePoolDefaults field is set.
   */
  @java.lang.Override
  public boolean hasAutoprovisioningNodePoolDefaults() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * AutoprovisioningNodePoolDefaults contains defaults for a node pool
   * created by NAP.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
   * </code>
   *
   * @return The autoprovisioningNodePoolDefaults.
   */
  @java.lang.Override
  public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
      getAutoprovisioningNodePoolDefaults() {
    return autoprovisioningNodePoolDefaults_ == null
        ? com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.getDefaultInstance()
        : autoprovisioningNodePoolDefaults_;
  }
  /**
   *
   *
   * <pre>
   * AutoprovisioningNodePoolDefaults contains defaults for a node pool
   * created by NAP.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AutoprovisioningNodePoolDefaultsOrBuilder
      getAutoprovisioningNodePoolDefaultsOrBuilder() {
    return autoprovisioningNodePoolDefaults_ == null
        ? com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.getDefaultInstance()
        : autoprovisioningNodePoolDefaults_;
  }

  public static final int AUTOPROVISIONING_LOCATIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList autoprovisioningLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes can be created by NAP.
   * </pre>
   *
   * <code>repeated string autoprovisioning_locations = 5;</code>
   *
   * @return A list containing the autoprovisioningLocations.
   */
  public com.google.protobuf.ProtocolStringList getAutoprovisioningLocationsList() {
    return autoprovisioningLocations_;
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes can be created by NAP.
   * </pre>
   *
   * <code>repeated string autoprovisioning_locations = 5;</code>
   *
   * @return The count of autoprovisioningLocations.
   */
  public int getAutoprovisioningLocationsCount() {
    return autoprovisioningLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes can be created by NAP.
   * </pre>
   *
   * <code>repeated string autoprovisioning_locations = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The autoprovisioningLocations at the given index.
   */
  public java.lang.String getAutoprovisioningLocations(int index) {
    return autoprovisioningLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * NodePool's nodes can be created by NAP.
   * </pre>
   *
   * <code>repeated string autoprovisioning_locations = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the autoprovisioningLocations at the given index.
   */
  public com.google.protobuf.ByteString getAutoprovisioningLocationsBytes(int index) {
    return autoprovisioningLocations_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enableNodeAutoprovisioning_ != false) {
      output.writeBool(1, enableNodeAutoprovisioning_);
    }
    for (int i = 0; i < resourceLimits_.size(); i++) {
      output.writeMessage(2, resourceLimits_.get(i));
    }
    if (autoscalingProfile_
        != com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile.PROFILE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, autoscalingProfile_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getAutoprovisioningNodePoolDefaults());
    }
    for (int i = 0; i < autoprovisioningLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, autoprovisioningLocations_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enableNodeAutoprovisioning_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enableNodeAutoprovisioning_);
    }
    for (int i = 0; i < resourceLimits_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, resourceLimits_.get(i));
    }
    if (autoscalingProfile_
        != com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile.PROFILE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, autoscalingProfile_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getAutoprovisioningNodePoolDefaults());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < autoprovisioningLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(autoprovisioningLocations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAutoprovisioningLocationsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.ClusterAutoscaling)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.ClusterAutoscaling other =
        (com.google.container.v1beta1.ClusterAutoscaling) obj;

    if (getEnableNodeAutoprovisioning() != other.getEnableNodeAutoprovisioning()) return false;
    if (!getResourceLimitsList().equals(other.getResourceLimitsList())) return false;
    if (autoscalingProfile_ != other.autoscalingProfile_) return false;
    if (hasAutoprovisioningNodePoolDefaults() != other.hasAutoprovisioningNodePoolDefaults())
      return false;
    if (hasAutoprovisioningNodePoolDefaults()) {
      if (!getAutoprovisioningNodePoolDefaults()
          .equals(other.getAutoprovisioningNodePoolDefaults())) return false;
    }
    if (!getAutoprovisioningLocationsList().equals(other.getAutoprovisioningLocationsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLE_NODE_AUTOPROVISIONING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableNodeAutoprovisioning());
    if (getResourceLimitsCount() > 0) {
      hash = (37 * hash) + RESOURCE_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceLimitsList().hashCode();
    }
    hash = (37 * hash) + AUTOSCALING_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + autoscalingProfile_;
    if (hasAutoprovisioningNodePoolDefaults()) {
      hash = (37 * hash) + AUTOPROVISIONING_NODE_POOL_DEFAULTS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoprovisioningNodePoolDefaults().hashCode();
    }
    if (getAutoprovisioningLocationsCount() > 0) {
      hash = (37 * hash) + AUTOPROVISIONING_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoprovisioningLocationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ClusterAutoscaling parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.ClusterAutoscaling prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ClusterAutoscaling contains global, per-cluster information
   * required by Cluster Autoscaler to automatically adjust
   * the size of the cluster and create/delete
   * node pools based on the current needs.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.ClusterAutoscaling}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.ClusterAutoscaling)
      com.google.container.v1beta1.ClusterAutoscalingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ClusterAutoscaling_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ClusterAutoscaling_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.ClusterAutoscaling.class,
              com.google.container.v1beta1.ClusterAutoscaling.Builder.class);
    }

    // Construct using com.google.container.v1beta1.ClusterAutoscaling.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceLimitsFieldBuilder();
        getAutoprovisioningNodePoolDefaultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enableNodeAutoprovisioning_ = false;
      if (resourceLimitsBuilder_ == null) {
        resourceLimits_ = java.util.Collections.emptyList();
      } else {
        resourceLimits_ = null;
        resourceLimitsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      autoscalingProfile_ = 0;
      autoprovisioningNodePoolDefaults_ = null;
      if (autoprovisioningNodePoolDefaultsBuilder_ != null) {
        autoprovisioningNodePoolDefaultsBuilder_.dispose();
        autoprovisioningNodePoolDefaultsBuilder_ = null;
      }
      autoprovisioningLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ClusterAutoscaling_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ClusterAutoscaling getDefaultInstanceForType() {
      return com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.ClusterAutoscaling build() {
      com.google.container.v1beta1.ClusterAutoscaling result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ClusterAutoscaling buildPartial() {
      com.google.container.v1beta1.ClusterAutoscaling result =
          new com.google.container.v1beta1.ClusterAutoscaling(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.container.v1beta1.ClusterAutoscaling result) {
      if (resourceLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          resourceLimits_ = java.util.Collections.unmodifiableList(resourceLimits_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.resourceLimits_ = resourceLimits_;
      } else {
        result.resourceLimits_ = resourceLimitsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1beta1.ClusterAutoscaling result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enableNodeAutoprovisioning_ = enableNodeAutoprovisioning_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.autoscalingProfile_ = autoscalingProfile_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.autoprovisioningNodePoolDefaults_ =
            autoprovisioningNodePoolDefaultsBuilder_ == null
                ? autoprovisioningNodePoolDefaults_
                : autoprovisioningNodePoolDefaultsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        autoprovisioningLocations_.makeImmutable();
        result.autoprovisioningLocations_ = autoprovisioningLocations_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.ClusterAutoscaling) {
        return mergeFrom((com.google.container.v1beta1.ClusterAutoscaling) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.ClusterAutoscaling other) {
      if (other == com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance())
        return this;
      if (other.getEnableNodeAutoprovisioning() != false) {
        setEnableNodeAutoprovisioning(other.getEnableNodeAutoprovisioning());
      }
      if (resourceLimitsBuilder_ == null) {
        if (!other.resourceLimits_.isEmpty()) {
          if (resourceLimits_.isEmpty()) {
            resourceLimits_ = other.resourceLimits_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureResourceLimitsIsMutable();
            resourceLimits_.addAll(other.resourceLimits_);
          }
          onChanged();
        }
      } else {
        if (!other.resourceLimits_.isEmpty()) {
          if (resourceLimitsBuilder_.isEmpty()) {
            resourceLimitsBuilder_.dispose();
            resourceLimitsBuilder_ = null;
            resourceLimits_ = other.resourceLimits_;
            bitField0_ = (bitField0_ & ~0x00000002);
            resourceLimitsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourceLimitsFieldBuilder()
                    : null;
          } else {
            resourceLimitsBuilder_.addAllMessages(other.resourceLimits_);
          }
        }
      }
      if (other.autoscalingProfile_ != 0) {
        setAutoscalingProfileValue(other.getAutoscalingProfileValue());
      }
      if (other.hasAutoprovisioningNodePoolDefaults()) {
        mergeAutoprovisioningNodePoolDefaults(other.getAutoprovisioningNodePoolDefaults());
      }
      if (!other.autoprovisioningLocations_.isEmpty()) {
        if (autoprovisioningLocations_.isEmpty()) {
          autoprovisioningLocations_ = other.autoprovisioningLocations_;
          bitField0_ |= 0x00000010;
        } else {
          ensureAutoprovisioningLocationsIsMutable();
          autoprovisioningLocations_.addAll(other.autoprovisioningLocations_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enableNodeAutoprovisioning_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.container.v1beta1.ResourceLimit m =
                    input.readMessage(
                        com.google.container.v1beta1.ResourceLimit.parser(), extensionRegistry);
                if (resourceLimitsBuilder_ == null) {
                  ensureResourceLimitsIsMutable();
                  resourceLimits_.add(m);
                } else {
                  resourceLimitsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                autoscalingProfile_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getAutoprovisioningNodePoolDefaultsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAutoprovisioningLocationsIsMutable();
                autoprovisioningLocations_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enableNodeAutoprovisioning_;
    /**
     *
     *
     * <pre>
     * Enables automatic node pool creation and deletion.
     * </pre>
     *
     * <code>bool enable_node_autoprovisioning = 1;</code>
     *
     * @return The enableNodeAutoprovisioning.
     */
    @java.lang.Override
    public boolean getEnableNodeAutoprovisioning() {
      return enableNodeAutoprovisioning_;
    }
    /**
     *
     *
     * <pre>
     * Enables automatic node pool creation and deletion.
     * </pre>
     *
     * <code>bool enable_node_autoprovisioning = 1;</code>
     *
     * @param value The enableNodeAutoprovisioning to set.
     * @return This builder for chaining.
     */
    public Builder setEnableNodeAutoprovisioning(boolean value) {

      enableNodeAutoprovisioning_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables automatic node pool creation and deletion.
     * </pre>
     *
     * <code>bool enable_node_autoprovisioning = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableNodeAutoprovisioning() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enableNodeAutoprovisioning_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1beta1.ResourceLimit> resourceLimits_ =
        java.util.Collections.emptyList();

    private void ensureResourceLimitsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        resourceLimits_ =
            new java.util.ArrayList<com.google.container.v1beta1.ResourceLimit>(resourceLimits_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.ResourceLimit,
            com.google.container.v1beta1.ResourceLimit.Builder,
            com.google.container.v1beta1.ResourceLimitOrBuilder>
        resourceLimitsBuilder_;

    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public java.util.List<com.google.container.v1beta1.ResourceLimit> getResourceLimitsList() {
      if (resourceLimitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resourceLimits_);
      } else {
        return resourceLimitsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public int getResourceLimitsCount() {
      if (resourceLimitsBuilder_ == null) {
        return resourceLimits_.size();
      } else {
        return resourceLimitsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public com.google.container.v1beta1.ResourceLimit getResourceLimits(int index) {
      if (resourceLimitsBuilder_ == null) {
        return resourceLimits_.get(index);
      } else {
        return resourceLimitsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder setResourceLimits(int index, com.google.container.v1beta1.ResourceLimit value) {
      if (resourceLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceLimitsIsMutable();
        resourceLimits_.set(index, value);
        onChanged();
      } else {
        resourceLimitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder setResourceLimits(
        int index, com.google.container.v1beta1.ResourceLimit.Builder builderForValue) {
      if (resourceLimitsBuilder_ == null) {
        ensureResourceLimitsIsMutable();
        resourceLimits_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourceLimitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder addResourceLimits(com.google.container.v1beta1.ResourceLimit value) {
      if (resourceLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceLimitsIsMutable();
        resourceLimits_.add(value);
        onChanged();
      } else {
        resourceLimitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder addResourceLimits(int index, com.google.container.v1beta1.ResourceLimit value) {
      if (resourceLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceLimitsIsMutable();
        resourceLimits_.add(index, value);
        onChanged();
      } else {
        resourceLimitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder addResourceLimits(
        com.google.container.v1beta1.ResourceLimit.Builder builderForValue) {
      if (resourceLimitsBuilder_ == null) {
        ensureResourceLimitsIsMutable();
        resourceLimits_.add(builderForValue.build());
        onChanged();
      } else {
        resourceLimitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder addResourceLimits(
        int index, com.google.container.v1beta1.ResourceLimit.Builder builderForValue) {
      if (resourceLimitsBuilder_ == null) {
        ensureResourceLimitsIsMutable();
        resourceLimits_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourceLimitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder addAllResourceLimits(
        java.lang.Iterable<? extends com.google.container.v1beta1.ResourceLimit> values) {
      if (resourceLimitsBuilder_ == null) {
        ensureResourceLimitsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceLimits_);
        onChanged();
      } else {
        resourceLimitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder clearResourceLimits() {
      if (resourceLimitsBuilder_ == null) {
        resourceLimits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        resourceLimitsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public Builder removeResourceLimits(int index) {
      if (resourceLimitsBuilder_ == null) {
        ensureResourceLimitsIsMutable();
        resourceLimits_.remove(index);
        onChanged();
      } else {
        resourceLimitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public com.google.container.v1beta1.ResourceLimit.Builder getResourceLimitsBuilder(int index) {
      return getResourceLimitsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public com.google.container.v1beta1.ResourceLimitOrBuilder getResourceLimitsOrBuilder(
        int index) {
      if (resourceLimitsBuilder_ == null) {
        return resourceLimits_.get(index);
      } else {
        return resourceLimitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public java.util.List<? extends com.google.container.v1beta1.ResourceLimitOrBuilder>
        getResourceLimitsOrBuilderList() {
      if (resourceLimitsBuilder_ != null) {
        return resourceLimitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resourceLimits_);
      }
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public com.google.container.v1beta1.ResourceLimit.Builder addResourceLimitsBuilder() {
      return getResourceLimitsFieldBuilder()
          .addBuilder(com.google.container.v1beta1.ResourceLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public com.google.container.v1beta1.ResourceLimit.Builder addResourceLimitsBuilder(int index) {
      return getResourceLimitsFieldBuilder()
          .addBuilder(index, com.google.container.v1beta1.ResourceLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Contains global constraints regarding minimum and maximum
     * amount of resources in the cluster.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.ResourceLimit resource_limits = 2;</code>
     */
    public java.util.List<com.google.container.v1beta1.ResourceLimit.Builder>
        getResourceLimitsBuilderList() {
      return getResourceLimitsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.ResourceLimit,
            com.google.container.v1beta1.ResourceLimit.Builder,
            com.google.container.v1beta1.ResourceLimitOrBuilder>
        getResourceLimitsFieldBuilder() {
      if (resourceLimitsBuilder_ == null) {
        resourceLimitsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1beta1.ResourceLimit,
                com.google.container.v1beta1.ResourceLimit.Builder,
                com.google.container.v1beta1.ResourceLimitOrBuilder>(
                resourceLimits_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        resourceLimits_ = null;
      }
      return resourceLimitsBuilder_;
    }

    private int autoscalingProfile_ = 0;
    /**
     *
     *
     * <pre>
     * Defines autoscaling behaviour.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for autoscalingProfile.
     */
    @java.lang.Override
    public int getAutoscalingProfileValue() {
      return autoscalingProfile_;
    }
    /**
     *
     *
     * <pre>
     * Defines autoscaling behaviour.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for autoscalingProfile to set.
     * @return This builder for chaining.
     */
    public Builder setAutoscalingProfileValue(int value) {
      autoscalingProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines autoscaling behaviour.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
     * </code>
     *
     * @return The autoscalingProfile.
     */
    @java.lang.Override
    public com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile
        getAutoscalingProfile() {
      com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile result =
          com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile.forNumber(
              autoscalingProfile_);
      return result == null
          ? com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Defines autoscaling behaviour.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
     * </code>
     *
     * @param value The autoscalingProfile to set.
     * @return This builder for chaining.
     */
    public Builder setAutoscalingProfile(
        com.google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      autoscalingProfile_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines autoscaling behaviour.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ClusterAutoscaling.AutoscalingProfile autoscaling_profile = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoscalingProfile() {
      bitField0_ = (bitField0_ & ~0x00000004);
      autoscalingProfile_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
        autoprovisioningNodePoolDefaults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaults,
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder,
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaultsOrBuilder>
        autoprovisioningNodePoolDefaultsBuilder_;
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     *
     * @return Whether the autoprovisioningNodePoolDefaults field is set.
     */
    public boolean hasAutoprovisioningNodePoolDefaults() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     *
     * @return The autoprovisioningNodePoolDefaults.
     */
    public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
        getAutoprovisioningNodePoolDefaults() {
      if (autoprovisioningNodePoolDefaultsBuilder_ == null) {
        return autoprovisioningNodePoolDefaults_ == null
            ? com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.getDefaultInstance()
            : autoprovisioningNodePoolDefaults_;
      } else {
        return autoprovisioningNodePoolDefaultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    public Builder setAutoprovisioningNodePoolDefaults(
        com.google.container.v1beta1.AutoprovisioningNodePoolDefaults value) {
      if (autoprovisioningNodePoolDefaultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoprovisioningNodePoolDefaults_ = value;
      } else {
        autoprovisioningNodePoolDefaultsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    public Builder setAutoprovisioningNodePoolDefaults(
        com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder builderForValue) {
      if (autoprovisioningNodePoolDefaultsBuilder_ == null) {
        autoprovisioningNodePoolDefaults_ = builderForValue.build();
      } else {
        autoprovisioningNodePoolDefaultsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    public Builder mergeAutoprovisioningNodePoolDefaults(
        com.google.container.v1beta1.AutoprovisioningNodePoolDefaults value) {
      if (autoprovisioningNodePoolDefaultsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && autoprovisioningNodePoolDefaults_ != null
            && autoprovisioningNodePoolDefaults_
                != com.google.container.v1beta1.AutoprovisioningNodePoolDefaults
                    .getDefaultInstance()) {
          getAutoprovisioningNodePoolDefaultsBuilder().mergeFrom(value);
        } else {
          autoprovisioningNodePoolDefaults_ = value;
        }
      } else {
        autoprovisioningNodePoolDefaultsBuilder_.mergeFrom(value);
      }
      if (autoprovisioningNodePoolDefaults_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    public Builder clearAutoprovisioningNodePoolDefaults() {
      bitField0_ = (bitField0_ & ~0x00000008);
      autoprovisioningNodePoolDefaults_ = null;
      if (autoprovisioningNodePoolDefaultsBuilder_ != null) {
        autoprovisioningNodePoolDefaultsBuilder_.dispose();
        autoprovisioningNodePoolDefaultsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    public com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder
        getAutoprovisioningNodePoolDefaultsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAutoprovisioningNodePoolDefaultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    public com.google.container.v1beta1.AutoprovisioningNodePoolDefaultsOrBuilder
        getAutoprovisioningNodePoolDefaultsOrBuilder() {
      if (autoprovisioningNodePoolDefaultsBuilder_ != null) {
        return autoprovisioningNodePoolDefaultsBuilder_.getMessageOrBuilder();
      } else {
        return autoprovisioningNodePoolDefaults_ == null
            ? com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.getDefaultInstance()
            : autoprovisioningNodePoolDefaults_;
      }
    }
    /**
     *
     *
     * <pre>
     * AutoprovisioningNodePoolDefaults contains defaults for a node pool
     * created by NAP.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AutoprovisioningNodePoolDefaults autoprovisioning_node_pool_defaults = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaults,
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder,
            com.google.container.v1beta1.AutoprovisioningNodePoolDefaultsOrBuilder>
        getAutoprovisioningNodePoolDefaultsFieldBuilder() {
      if (autoprovisioningNodePoolDefaultsBuilder_ == null) {
        autoprovisioningNodePoolDefaultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.AutoprovisioningNodePoolDefaults,
                com.google.container.v1beta1.AutoprovisioningNodePoolDefaults.Builder,
                com.google.container.v1beta1.AutoprovisioningNodePoolDefaultsOrBuilder>(
                getAutoprovisioningNodePoolDefaults(), getParentForChildren(), isClean());
        autoprovisioningNodePoolDefaults_ = null;
      }
      return autoprovisioningNodePoolDefaultsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList autoprovisioningLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAutoprovisioningLocationsIsMutable() {
      if (!autoprovisioningLocations_.isModifiable()) {
        autoprovisioningLocations_ =
            new com.google.protobuf.LazyStringArrayList(autoprovisioningLocations_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @return A list containing the autoprovisioningLocations.
     */
    public com.google.protobuf.ProtocolStringList getAutoprovisioningLocationsList() {
      autoprovisioningLocations_.makeImmutable();
      return autoprovisioningLocations_;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @return The count of autoprovisioningLocations.
     */
    public int getAutoprovisioningLocationsCount() {
      return autoprovisioningLocations_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The autoprovisioningLocations at the given index.
     */
    public java.lang.String getAutoprovisioningLocations(int index) {
      return autoprovisioningLocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the autoprovisioningLocations at the given index.
     */
    public com.google.protobuf.ByteString getAutoprovisioningLocationsBytes(int index) {
      return autoprovisioningLocations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The autoprovisioningLocations to set.
     * @return This builder for chaining.
     */
    public Builder setAutoprovisioningLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAutoprovisioningLocationsIsMutable();
      autoprovisioningLocations_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @param value The autoprovisioningLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAutoprovisioningLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAutoprovisioningLocationsIsMutable();
      autoprovisioningLocations_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @param values The autoprovisioningLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllAutoprovisioningLocations(java.lang.Iterable<java.lang.String> values) {
      ensureAutoprovisioningLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, autoprovisioningLocations_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoprovisioningLocations() {
      autoprovisioningLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * NodePool's nodes can be created by NAP.
     * </pre>
     *
     * <code>repeated string autoprovisioning_locations = 5;</code>
     *
     * @param value The bytes of the autoprovisioningLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAutoprovisioningLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAutoprovisioningLocationsIsMutable();
      autoprovisioningLocations_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.ClusterAutoscaling)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.ClusterAutoscaling)
  private static final com.google.container.v1beta1.ClusterAutoscaling DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.ClusterAutoscaling();
  }

  public static com.google.container.v1beta1.ClusterAutoscaling getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterAutoscaling> PARSER =
      new com.google.protobuf.AbstractParser<ClusterAutoscaling>() {
        @java.lang.Override
        public ClusterAutoscaling parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClusterAutoscaling> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterAutoscaling> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.ClusterAutoscaling getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
