/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

public interface ClusterOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.container.v1beta1.Cluster)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name of this cluster. The name must be unique within this project
   * and location (e.g. zone or region), and can be up to 40 characters with
   * the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only.
   * * Must start with a letter.
   * * Must end with a number or a letter.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The name of this cluster. The name must be unique within this project
   * and location (e.g. zone or region), and can be up to 40 characters with
   * the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only.
   * * Must start with a letter.
   * * Must end with a number or a letter.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * An optional description of this cluster.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * An optional description of this cluster.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * The number of nodes to create in this cluster. You must ensure that your
   * Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
   * is sufficient for this number of instances. You must also have available
   * firewall and routes quota.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "node_config") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   *
   * This field is deprecated, use node_pool.initial_node_count instead.
   * </pre>
   *
   * <code>int32 initial_node_count = 3 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.initial_node_count is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2027
   * @return The initialNodeCount.
   */
  @java.lang.Deprecated
  int getInitialNodeCount();

  /**
   *
   *
   * <pre>
   * Parameters used in creating the cluster's nodes.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "initial_node_count") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   * For responses, this field will be populated with the node configuration of
   * the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used.
   * This field is deprecated, use node_pool.config instead.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeConfig node_config = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.node_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2040
   * @return Whether the nodeConfig field is set.
   */
  @java.lang.Deprecated
  boolean hasNodeConfig();
  /**
   *
   *
   * <pre>
   * Parameters used in creating the cluster's nodes.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "initial_node_count") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   * For responses, this field will be populated with the node configuration of
   * the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used.
   * This field is deprecated, use node_pool.config instead.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeConfig node_config = 4 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.node_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2040
   * @return The nodeConfig.
   */
  @java.lang.Deprecated
  com.google.container.v1beta1.NodeConfig getNodeConfig();
  /**
   *
   *
   * <pre>
   * Parameters used in creating the cluster's nodes.
   * For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the
   * "initial_node_count") will be used to create a "NodePool" object with an
   * auto-generated name. Do not use this and a node_pool at the same time.
   * For responses, this field will be populated with the node configuration of
   * the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used.
   * This field is deprecated, use node_pool.config instead.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeConfig node_config = 4 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  com.google.container.v1beta1.NodeConfigOrBuilder getNodeConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * If unspecified, the defaults are used:
   * For clusters before v1.12, if master_auth is unspecified, `username` will
   * be set to "admin", a random password will be generated, and a client
   * certificate will be issued.
   * </pre>
   *
   * <code>.google.container.v1beta1.MasterAuth master_auth = 5;</code>
   *
   * @return Whether the masterAuth field is set.
   */
  boolean hasMasterAuth();
  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * If unspecified, the defaults are used:
   * For clusters before v1.12, if master_auth is unspecified, `username` will
   * be set to "admin", a random password will be generated, and a client
   * certificate will be issued.
   * </pre>
   *
   * <code>.google.container.v1beta1.MasterAuth master_auth = 5;</code>
   *
   * @return The masterAuth.
   */
  com.google.container.v1beta1.MasterAuth getMasterAuth();
  /**
   *
   *
   * <pre>
   * The authentication information for accessing the master endpoint.
   * If unspecified, the defaults are used:
   * For clusters before v1.12, if master_auth is unspecified, `username` will
   * be set to "admin", a random password will be generated, and a client
   * certificate will be issued.
   * </pre>
   *
   * <code>.google.container.v1beta1.MasterAuth master_auth = 5;</code>
   */
  com.google.container.v1beta1.MasterAuthOrBuilder getMasterAuthOrBuilder();

  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string logging_service = 6;</code>
   *
   * @return The loggingService.
   */
  java.lang.String getLoggingService();
  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string logging_service = 6;</code>
   *
   * @return The bytes for loggingService.
   */
  com.google.protobuf.ByteString getLoggingServiceBytes();

  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string monitoring_service = 7;</code>
   *
   * @return The monitoringService.
   */
  java.lang.String getMonitoringService();
  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string monitoring_service = 7;</code>
   *
   * @return The bytes for monitoringService.
   */
  com.google.protobuf.ByteString getMonitoringServiceBytes();

  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default`
   * network will be used. On output this shows the network ID instead of the
   * name.
   * </pre>
   *
   * <code>string network = 8;</code>
   *
   * @return The network.
   */
  java.lang.String getNetwork();
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default`
   * network will be used. On output this shows the network ID instead of the
   * name.
   * </pre>
   *
   * <code>string network = 8;</code>
   *
   * @return The bytes for network.
   */
  com.google.protobuf.ByteString getNetworkBytes();

  /**
   *
   *
   * <pre>
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`). Leave blank to have
   * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr = 9;</code>
   *
   * @return The clusterIpv4Cidr.
   */
  java.lang.String getClusterIpv4Cidr();
  /**
   *
   *
   * <pre>
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`). Leave blank to have
   * one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
   * </pre>
   *
   * <code>string cluster_ipv4_cidr = 9;</code>
   *
   * @return The bytes for clusterIpv4Cidr.
   */
  com.google.protobuf.ByteString getClusterIpv4CidrBytes();

  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.AddonsConfig addons_config = 10;</code>
   *
   * @return Whether the addonsConfig field is set.
   */
  boolean hasAddonsConfig();
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.AddonsConfig addons_config = 10;</code>
   *
   * @return The addonsConfig.
   */
  com.google.container.v1beta1.AddonsConfig getAddonsConfig();
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.AddonsConfig addons_config = 10;</code>
   */
  com.google.container.v1beta1.AddonsConfigOrBuilder getAddonsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
   * the cluster is connected. On output this shows the subnetwork ID instead of
   * the name.
   * </pre>
   *
   * <code>string subnetwork = 11;</code>
   *
   * @return The subnetwork.
   */
  java.lang.String getSubnetwork();
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
   * the cluster is connected. On output this shows the subnetwork ID instead of
   * the name.
   * </pre>
   *
   * <code>string subnetwork = 11;</code>
   *
   * @return The bytes for subnetwork.
   */
  com.google.protobuf.ByteString getSubnetworkBytes();

  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
   */
  java.util.List<com.google.container.v1beta1.NodePool> getNodePoolsList();
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
   */
  com.google.container.v1beta1.NodePool getNodePools(int index);
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
   */
  int getNodePoolsCount();
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
   */
  java.util.List<? extends com.google.container.v1beta1.NodePoolOrBuilder>
      getNodePoolsOrBuilderList();
  /**
   *
   *
   * <pre>
   * The node pools associated with this cluster.
   * This field should not be set if "node_config" or "initial_node_count" are
   * specified.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.NodePool node_pools = 12;</code>
   */
  com.google.container.v1beta1.NodePoolOrBuilder getNodePoolsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return A list containing the locations.
   */
  java.util.List<java.lang.String> getLocationsList();
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @return The count of locations.
   */
  int getLocationsCount();
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  java.lang.String getLocations(int index);
  /**
   *
   *
   * <pre>
   * The list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This field provides a default value if
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * are not specified during node pool creation.
   *
   * Warning: changing cluster locations will update the
   * [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
   * of all node pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string locations = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  com.google.protobuf.ByteString getLocationsBytes(int index);

  /**
   *
   *
   * <pre>
   * Kubernetes alpha features are enabled on this cluster. This includes alpha
   * API groups (e.g. v1beta1) and features that may not be production ready in
   * the kubernetes version of the master and nodes.
   * The cluster has no SLA for uptime and master/node upgrades are disabled.
   * Alpha enabled clusters are automatically deleted thirty days after
   * creation.
   * </pre>
   *
   * <code>bool enable_kubernetes_alpha = 14;</code>
   *
   * @return The enableKubernetesAlpha.
   */
  boolean getEnableKubernetesAlpha();

  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis.
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
   *
   * @return Whether the enableK8sBetaApis field is set.
   */
  boolean hasEnableK8SBetaApis();
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis.
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
   *
   * @return The enableK8sBetaApis.
   */
  com.google.container.v1beta1.K8sBetaAPIConfig getEnableK8SBetaApis();
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis.
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 143;</code>
   */
  com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder getEnableK8SBetaApisOrBuilder();

  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  int getResourceLabelsCount();
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  boolean containsResourceLabels(java.lang.String key);
  /** Use {@link #getResourceLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getResourceLabels();
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getResourceLabelsMap();
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  /* nullable */
  java.lang.String getResourceLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * The resource labels for the cluster to use to annotate any related
   * Google Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_labels = 15;</code>
   */
  java.lang.String getResourceLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * The fingerprint of the set of labels for this cluster.
   * </pre>
   *
   * <code>string label_fingerprint = 16;</code>
   *
   * @return The labelFingerprint.
   */
  java.lang.String getLabelFingerprint();
  /**
   *
   *
   * <pre>
   * The fingerprint of the set of labels for this cluster.
   * </pre>
   *
   * <code>string label_fingerprint = 16;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  com.google.protobuf.ByteString getLabelFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Configuration for the legacy ABAC authorization mode.
   * </pre>
   *
   * <code>.google.container.v1beta1.LegacyAbac legacy_abac = 18;</code>
   *
   * @return Whether the legacyAbac field is set.
   */
  boolean hasLegacyAbac();
  /**
   *
   *
   * <pre>
   * Configuration for the legacy ABAC authorization mode.
   * </pre>
   *
   * <code>.google.container.v1beta1.LegacyAbac legacy_abac = 18;</code>
   *
   * @return The legacyAbac.
   */
  com.google.container.v1beta1.LegacyAbac getLegacyAbac();
  /**
   *
   *
   * <pre>
   * Configuration for the legacy ABAC authorization mode.
   * </pre>
   *
   * <code>.google.container.v1beta1.LegacyAbac legacy_abac = 18;</code>
   */
  com.google.container.v1beta1.LegacyAbacOrBuilder getLegacyAbacOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkPolicy network_policy = 19;</code>
   *
   * @return Whether the networkPolicy field is set.
   */
  boolean hasNetworkPolicy();
  /**
   *
   *
   * <pre>
   * Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkPolicy network_policy = 19;</code>
   *
   * @return The networkPolicy.
   */
  com.google.container.v1beta1.NetworkPolicy getNetworkPolicy();
  /**
   *
   *
   * <pre>
   * Configuration options for the NetworkPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkPolicy network_policy = 19;</code>
   */
  com.google.container.v1beta1.NetworkPolicyOrBuilder getNetworkPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for cluster IP allocation.
   * </pre>
   *
   * <code>.google.container.v1beta1.IPAllocationPolicy ip_allocation_policy = 20;</code>
   *
   * @return Whether the ipAllocationPolicy field is set.
   */
  boolean hasIpAllocationPolicy();
  /**
   *
   *
   * <pre>
   * Configuration for cluster IP allocation.
   * </pre>
   *
   * <code>.google.container.v1beta1.IPAllocationPolicy ip_allocation_policy = 20;</code>
   *
   * @return The ipAllocationPolicy.
   */
  com.google.container.v1beta1.IPAllocationPolicy getIpAllocationPolicy();
  /**
   *
   *
   * <pre>
   * Configuration for cluster IP allocation.
   * </pre>
   *
   * <code>.google.container.v1beta1.IPAllocationPolicy ip_allocation_policy = 20;</code>
   */
  com.google.container.v1beta1.IPAllocationPolicyOrBuilder getIpAllocationPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * The configuration options for master authorized networks feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;
   * </code>
   *
   * @return Whether the masterAuthorizedNetworksConfig field is set.
   */
  boolean hasMasterAuthorizedNetworksConfig();
  /**
   *
   *
   * <pre>
   * The configuration options for master authorized networks feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;
   * </code>
   *
   * @return The masterAuthorizedNetworksConfig.
   */
  com.google.container.v1beta1.MasterAuthorizedNetworksConfig getMasterAuthorizedNetworksConfig();
  /**
   *
   *
   * <pre>
   * The configuration options for master authorized networks feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.MasterAuthorizedNetworksConfig master_authorized_networks_config = 22;
   * </code>
   */
  com.google.container.v1beta1.MasterAuthorizedNetworksConfigOrBuilder
      getMasterAuthorizedNetworksConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configure the maintenance policy for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.MaintenancePolicy maintenance_policy = 23;</code>
   *
   * @return Whether the maintenancePolicy field is set.
   */
  boolean hasMaintenancePolicy();
  /**
   *
   *
   * <pre>
   * Configure the maintenance policy for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.MaintenancePolicy maintenance_policy = 23;</code>
   *
   * @return The maintenancePolicy.
   */
  com.google.container.v1beta1.MaintenancePolicy getMaintenancePolicy();
  /**
   *
   *
   * <pre>
   * Configure the maintenance policy for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.MaintenancePolicy maintenance_policy = 23;</code>
   */
  com.google.container.v1beta1.MaintenancePolicyOrBuilder getMaintenancePolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for Binary Authorization.
   * </pre>
   *
   * <code>.google.container.v1beta1.BinaryAuthorization binary_authorization = 24;</code>
   *
   * @return Whether the binaryAuthorization field is set.
   */
  boolean hasBinaryAuthorization();
  /**
   *
   *
   * <pre>
   * Configuration for Binary Authorization.
   * </pre>
   *
   * <code>.google.container.v1beta1.BinaryAuthorization binary_authorization = 24;</code>
   *
   * @return The binaryAuthorization.
   */
  com.google.container.v1beta1.BinaryAuthorization getBinaryAuthorization();
  /**
   *
   *
   * <pre>
   * Configuration for Binary Authorization.
   * </pre>
   *
   * <code>.google.container.v1beta1.BinaryAuthorization binary_authorization = 24;</code>
   */
  com.google.container.v1beta1.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for the PodSecurityPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.PodSecurityPolicyConfig pod_security_policy_config = 25;</code>
   *
   * @return Whether the podSecurityPolicyConfig field is set.
   */
  boolean hasPodSecurityPolicyConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the PodSecurityPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.PodSecurityPolicyConfig pod_security_policy_config = 25;</code>
   *
   * @return The podSecurityPolicyConfig.
   */
  com.google.container.v1beta1.PodSecurityPolicyConfig getPodSecurityPolicyConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the PodSecurityPolicy feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.PodSecurityPolicyConfig pod_security_policy_config = 25;</code>
   */
  com.google.container.v1beta1.PodSecurityPolicyConfigOrBuilder
      getPodSecurityPolicyConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling autoscaling = 26;</code>
   *
   * @return Whether the autoscaling field is set.
   */
  boolean hasAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling autoscaling = 26;</code>
   *
   * @return The autoscaling.
   */
  com.google.container.v1beta1.ClusterAutoscaling getAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling autoscaling = 26;</code>
   */
  com.google.container.v1beta1.ClusterAutoscalingOrBuilder getAutoscalingOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for cluster networking.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkConfig network_config = 27;</code>
   *
   * @return Whether the networkConfig field is set.
   */
  boolean hasNetworkConfig();
  /**
   *
   *
   * <pre>
   * Configuration for cluster networking.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkConfig network_config = 27;</code>
   *
   * @return The networkConfig.
   */
  com.google.container.v1beta1.NetworkConfig getNetworkConfig();
  /**
   *
   *
   * <pre>
   * Configuration for cluster networking.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkConfig network_config = 27;</code>
   */
  com.google.container.v1beta1.NetworkConfigOrBuilder getNetworkConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * If this is a private cluster setup. Private clusters are clusters that, by
   * default have no external IP addresses on the nodes and where nodes and the
   * master communicate over private IP addresses.
   * This field is deprecated, use private_cluster_config.enable_private_nodes
   * instead.
   * </pre>
   *
   * <code>bool private_cluster = 28 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.private_cluster is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2165
   * @return The privateCluster.
   */
  @java.lang.Deprecated
  boolean getPrivateCluster();

  /**
   *
   *
   * <pre>
   * The IP prefix in CIDR notation to use for the hosted master network.
   * This prefix will be used for assigning private IP addresses to the
   * master or set of masters, as well as the ILB VIP.
   * This field is deprecated, use
   * private_cluster_config.master_ipv4_cidr_block instead.
   * </pre>
   *
   * <code>string master_ipv4_cidr_block = 29 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.master_ipv4_cidr_block is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2172
   * @return The masterIpv4CidrBlock.
   */
  @java.lang.Deprecated
  java.lang.String getMasterIpv4CidrBlock();
  /**
   *
   *
   * <pre>
   * The IP prefix in CIDR notation to use for the hosted master network.
   * This prefix will be used for assigning private IP addresses to the
   * master or set of masters, as well as the ILB VIP.
   * This field is deprecated, use
   * private_cluster_config.master_ipv4_cidr_block instead.
   * </pre>
   *
   * <code>string master_ipv4_cidr_block = 29 [deprecated = true];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.master_ipv4_cidr_block is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2172
   * @return The bytes for masterIpv4CidrBlock.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getMasterIpv4CidrBlockBytes();

  /**
   *
   *
   * <pre>
   * The default constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool of this cluster. Only honored
   * if cluster created with IP Alias support.
   * </pre>
   *
   * <code>.google.container.v1beta1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
   *
   * @return Whether the defaultMaxPodsConstraint field is set.
   */
  boolean hasDefaultMaxPodsConstraint();
  /**
   *
   *
   * <pre>
   * The default constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool of this cluster. Only honored
   * if cluster created with IP Alias support.
   * </pre>
   *
   * <code>.google.container.v1beta1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
   *
   * @return The defaultMaxPodsConstraint.
   */
  com.google.container.v1beta1.MaxPodsConstraint getDefaultMaxPodsConstraint();
  /**
   *
   *
   * <pre>
   * The default constraint on the maximum number of pods that can be run
   * simultaneously on a node in the node pool of this cluster. Only honored
   * if cluster created with IP Alias support.
   * </pre>
   *
   * <code>.google.container.v1beta1.MaxPodsConstraint default_max_pods_constraint = 30;</code>
   */
  com.google.container.v1beta1.MaxPodsConstraintOrBuilder getDefaultMaxPodsConstraintOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for exporting resource usages. Resource usage export is
   * disabled when this config unspecified.
   * </pre>
   *
   * <code>.google.container.v1beta1.ResourceUsageExportConfig resource_usage_export_config = 33;
   * </code>
   *
   * @return Whether the resourceUsageExportConfig field is set.
   */
  boolean hasResourceUsageExportConfig();
  /**
   *
   *
   * <pre>
   * Configuration for exporting resource usages. Resource usage export is
   * disabled when this config unspecified.
   * </pre>
   *
   * <code>.google.container.v1beta1.ResourceUsageExportConfig resource_usage_export_config = 33;
   * </code>
   *
   * @return The resourceUsageExportConfig.
   */
  com.google.container.v1beta1.ResourceUsageExportConfig getResourceUsageExportConfig();
  /**
   *
   *
   * <pre>
   * Configuration for exporting resource usages. Resource usage export is
   * disabled when this config unspecified.
   * </pre>
   *
   * <code>.google.container.v1beta1.ResourceUsageExportConfig resource_usage_export_config = 33;
   * </code>
   */
  com.google.container.v1beta1.ResourceUsageExportConfigOrBuilder
      getResourceUsageExportConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration controlling RBAC group membership information.
   * </pre>
   *
   * <code>.google.container.v1beta1.AuthenticatorGroupsConfig authenticator_groups_config = 34;
   * </code>
   *
   * @return Whether the authenticatorGroupsConfig field is set.
   */
  boolean hasAuthenticatorGroupsConfig();
  /**
   *
   *
   * <pre>
   * Configuration controlling RBAC group membership information.
   * </pre>
   *
   * <code>.google.container.v1beta1.AuthenticatorGroupsConfig authenticator_groups_config = 34;
   * </code>
   *
   * @return The authenticatorGroupsConfig.
   */
  com.google.container.v1beta1.AuthenticatorGroupsConfig getAuthenticatorGroupsConfig();
  /**
   *
   *
   * <pre>
   * Configuration controlling RBAC group membership information.
   * </pre>
   *
   * <code>.google.container.v1beta1.AuthenticatorGroupsConfig authenticator_groups_config = 34;
   * </code>
   */
  com.google.container.v1beta1.AuthenticatorGroupsConfigOrBuilder
      getAuthenticatorGroupsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for private cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37;</code>
   *
   * @return Whether the privateClusterConfig field is set.
   */
  boolean hasPrivateClusterConfig();
  /**
   *
   *
   * <pre>
   * Configuration for private cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37;</code>
   *
   * @return The privateClusterConfig.
   */
  com.google.container.v1beta1.PrivateClusterConfig getPrivateClusterConfig();
  /**
   *
   *
   * <pre>
   * Configuration for private cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37;</code>
   */
  com.google.container.v1beta1.PrivateClusterConfigOrBuilder getPrivateClusterConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
   *
   * @return Whether the verticalPodAutoscaling field is set.
   */
  boolean hasVerticalPodAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
   *
   * @return The verticalPodAutoscaling.
   */
  com.google.container.v1beta1.VerticalPodAutoscaling getVerticalPodAutoscaling();
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.VerticalPodAutoscaling vertical_pod_autoscaling = 39;</code>
   */
  com.google.container.v1beta1.VerticalPodAutoscalingOrBuilder getVerticalPodAutoscalingOrBuilder();

  /**
   *
   *
   * <pre>
   * Shielded Nodes configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedNodes shielded_nodes = 40;</code>
   *
   * @return Whether the shieldedNodes field is set.
   */
  boolean hasShieldedNodes();
  /**
   *
   *
   * <pre>
   * Shielded Nodes configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedNodes shielded_nodes = 40;</code>
   *
   * @return The shieldedNodes.
   */
  com.google.container.v1beta1.ShieldedNodes getShieldedNodes();
  /**
   *
   *
   * <pre>
   * Shielded Nodes configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedNodes shielded_nodes = 40;</code>
   */
  com.google.container.v1beta1.ShieldedNodesOrBuilder getShieldedNodesOrBuilder();

  /**
   *
   *
   * <pre>
   * Release channel configuration. If left unspecified on cluster creation and
   * a version is specified, the cluster is enrolled in the most mature release
   * channel where the version is available (first checking STABLE, then
   * REGULAR, and finally RAPID). Otherwise, if no release channel
   * configuration and no version is specified, the cluster is enrolled in the
   * REGULAR channel with its default version.
   * </pre>
   *
   * <code>.google.container.v1beta1.ReleaseChannel release_channel = 41;</code>
   *
   * @return Whether the releaseChannel field is set.
   */
  boolean hasReleaseChannel();
  /**
   *
   *
   * <pre>
   * Release channel configuration. If left unspecified on cluster creation and
   * a version is specified, the cluster is enrolled in the most mature release
   * channel where the version is available (first checking STABLE, then
   * REGULAR, and finally RAPID). Otherwise, if no release channel
   * configuration and no version is specified, the cluster is enrolled in the
   * REGULAR channel with its default version.
   * </pre>
   *
   * <code>.google.container.v1beta1.ReleaseChannel release_channel = 41;</code>
   *
   * @return The releaseChannel.
   */
  com.google.container.v1beta1.ReleaseChannel getReleaseChannel();
  /**
   *
   *
   * <pre>
   * Release channel configuration. If left unspecified on cluster creation and
   * a version is specified, the cluster is enrolled in the most mature release
   * channel where the version is available (first checking STABLE, then
   * REGULAR, and finally RAPID). Otherwise, if no release channel
   * configuration and no version is specified, the cluster is enrolled in the
   * REGULAR channel with its default version.
   * </pre>
   *
   * <code>.google.container.v1beta1.ReleaseChannel release_channel = 41;</code>
   */
  com.google.container.v1beta1.ReleaseChannelOrBuilder getReleaseChannelOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM
   * policies.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadIdentityConfig workload_identity_config = 43;</code>
   *
   * @return Whether the workloadIdentityConfig field is set.
   */
  boolean hasWorkloadIdentityConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM
   * policies.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadIdentityConfig workload_identity_config = 43;</code>
   *
   * @return The workloadIdentityConfig.
   */
  com.google.container.v1beta1.WorkloadIdentityConfig getWorkloadIdentityConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM
   * policies.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadIdentityConfig workload_identity_config = 43;</code>
   */
  com.google.container.v1beta1.WorkloadIdentityConfigOrBuilder getWorkloadIdentityConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadCertificates workload_certificates = 52;</code>
   *
   * @return Whether the workloadCertificates field is set.
   */
  boolean hasWorkloadCertificates();
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadCertificates workload_certificates = 52;</code>
   *
   * @return The workloadCertificates.
   */
  com.google.container.v1beta1.WorkloadCertificates getWorkloadCertificates();
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadCertificates workload_certificates = 52;</code>
   */
  com.google.container.v1beta1.WorkloadCertificatesOrBuilder getWorkloadCertificatesOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.MeshCertificates mesh_certificates = 67;</code>
   *
   * @return Whether the meshCertificates field is set.
   */
  boolean hasMeshCertificates();
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.MeshCertificates mesh_certificates = 67;</code>
   *
   * @return The meshCertificates.
   */
  com.google.container.v1beta1.MeshCertificates getMeshCertificates();
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.MeshCertificates mesh_certificates = 67;</code>
   */
  com.google.container.v1beta1.MeshCertificatesOrBuilder getMeshCertificatesOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for direct-path (via ALTS) with workload identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadALTSConfig workload_alts_config = 53;</code>
   *
   * @return Whether the workloadAltsConfig field is set.
   */
  boolean hasWorkloadAltsConfig();
  /**
   *
   *
   * <pre>
   * Configuration for direct-path (via ALTS) with workload identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadALTSConfig workload_alts_config = 53;</code>
   *
   * @return The workloadAltsConfig.
   */
  com.google.container.v1beta1.WorkloadALTSConfig getWorkloadAltsConfig();
  /**
   *
   *
   * <pre>
   * Configuration for direct-path (via ALTS) with workload identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadALTSConfig workload_alts_config = 53;</code>
   */
  com.google.container.v1beta1.WorkloadALTSConfigOrBuilder getWorkloadAltsConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.CostManagementConfig cost_management_config = 45;</code>
   *
   * @return Whether the costManagementConfig field is set.
   */
  boolean hasCostManagementConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.CostManagementConfig cost_management_config = 45;</code>
   *
   * @return The costManagementConfig.
   */
  com.google.container.v1beta1.CostManagementConfig getCostManagementConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.CostManagementConfig cost_management_config = 45;</code>
   */
  com.google.container.v1beta1.CostManagementConfigOrBuilder getCostManagementConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Telemetry integration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterTelemetry cluster_telemetry = 46;</code>
   *
   * @return Whether the clusterTelemetry field is set.
   */
  boolean hasClusterTelemetry();
  /**
   *
   *
   * <pre>
   * Telemetry integration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterTelemetry cluster_telemetry = 46;</code>
   *
   * @return The clusterTelemetry.
   */
  com.google.container.v1beta1.ClusterTelemetry getClusterTelemetry();
  /**
   *
   *
   * <pre>
   * Telemetry integration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterTelemetry cluster_telemetry = 46;</code>
   */
  com.google.container.v1beta1.ClusterTelemetryOrBuilder getClusterTelemetryOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for Cloud TPU support;
   * </pre>
   *
   * <code>.google.container.v1beta1.TpuConfig tpu_config = 47;</code>
   *
   * @return Whether the tpuConfig field is set.
   */
  boolean hasTpuConfig();
  /**
   *
   *
   * <pre>
   * Configuration for Cloud TPU support;
   * </pre>
   *
   * <code>.google.container.v1beta1.TpuConfig tpu_config = 47;</code>
   *
   * @return The tpuConfig.
   */
  com.google.container.v1beta1.TpuConfig getTpuConfig();
  /**
   *
   *
   * <pre>
   * Configuration for Cloud TPU support;
   * </pre>
   *
   * <code>.google.container.v1beta1.TpuConfig tpu_config = 47;</code>
   */
  com.google.container.v1beta1.TpuConfigOrBuilder getTpuConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Notification configuration of the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig notification_config = 49;</code>
   *
   * @return Whether the notificationConfig field is set.
   */
  boolean hasNotificationConfig();
  /**
   *
   *
   * <pre>
   * Notification configuration of the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig notification_config = 49;</code>
   *
   * @return The notificationConfig.
   */
  com.google.container.v1beta1.NotificationConfig getNotificationConfig();
  /**
   *
   *
   * <pre>
   * Notification configuration of the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig notification_config = 49;</code>
   */
  com.google.container.v1beta1.NotificationConfigOrBuilder getNotificationConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration of Confidential Nodes.
   * All the nodes in the cluster will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1beta1.ConfidentialNodes confidential_nodes = 50;</code>
   *
   * @return Whether the confidentialNodes field is set.
   */
  boolean hasConfidentialNodes();
  /**
   *
   *
   * <pre>
   * Configuration of Confidential Nodes.
   * All the nodes in the cluster will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1beta1.ConfidentialNodes confidential_nodes = 50;</code>
   *
   * @return The confidentialNodes.
   */
  com.google.container.v1beta1.ConfidentialNodes getConfidentialNodes();
  /**
   *
   *
   * <pre>
   * Configuration of Confidential Nodes.
   * All the nodes in the cluster will be Confidential VM once enabled.
   * </pre>
   *
   * <code>.google.container.v1beta1.ConfidentialNodes confidential_nodes = 50;</code>
   */
  com.google.container.v1beta1.ConfidentialNodesOrBuilder getConfidentialNodesOrBuilder();

  /**
   *
   *
   * <pre>
   * Configuration for Identity Service component.
   * </pre>
   *
   * <code>.google.container.v1beta1.IdentityServiceConfig identity_service_config = 54;</code>
   *
   * @return Whether the identityServiceConfig field is set.
   */
  boolean hasIdentityServiceConfig();
  /**
   *
   *
   * <pre>
   * Configuration for Identity Service component.
   * </pre>
   *
   * <code>.google.container.v1beta1.IdentityServiceConfig identity_service_config = 54;</code>
   *
   * @return The identityServiceConfig.
   */
  com.google.container.v1beta1.IdentityServiceConfig getIdentityServiceConfig();
  /**
   *
   *
   * <pre>
   * Configuration for Identity Service component.
   * </pre>
   *
   * <code>.google.container.v1beta1.IdentityServiceConfig identity_service_config = 54;</code>
   */
  com.google.container.v1beta1.IdentityServiceConfigOrBuilder getIdentityServiceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();
  /**
   *
   *
   * <pre>
   * Output only. Server-defined URL for the resource.
   * </pre>
   *
   * <code>string self_link = 100 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field is deprecated, use location instead.
   * </pre>
   *
   * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.zone is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2243
   * @return The zone.
   */
  @java.lang.Deprecated
  java.lang.String getZone();
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster resides. This field is deprecated, use location instead.
   * </pre>
   *
   * <code>string zone = 101 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @deprecated google.container.v1beta1.Cluster.zone is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2243
   * @return The bytes for zone.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getZoneBytes();

  /**
   *
   *
   * <pre>
   * Output only. The IP address of this cluster's master endpoint.
   * The endpoint can be accessed from the internet at
   * `https://username:password&#64;endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and
   * password information.
   * </pre>
   *
   * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The endpoint.
   */
  java.lang.String getEndpoint();
  /**
   *
   *
   * <pre>
   * Output only. The IP address of this cluster's master endpoint.
   * The endpoint can be accessed from the internet at
   * `https://username:password&#64;endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and
   * password information.
   * </pre>
   *
   * <code>string endpoint = 102 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for endpoint.
   */
  com.google.protobuf.ByteString getEndpointBytes();

  /**
   *
   *
   * <pre>
   * The initial Kubernetes version for this cluster.  Valid versions are those
   * found in validMasterVersions returned by getServerConfig.  The version can
   * be upgraded over time; such upgrades are reflected in
   * currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "","-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string initial_cluster_version = 103;</code>
   *
   * @return The initialClusterVersion.
   */
  java.lang.String getInitialClusterVersion();
  /**
   *
   *
   * <pre>
   * The initial Kubernetes version for this cluster.  Valid versions are those
   * found in validMasterVersions returned by getServerConfig.  The version can
   * be upgraded over time; such upgrades are reflected in
   * currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "","-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string initial_cluster_version = 103;</code>
   *
   * @return The bytes for initialClusterVersion.
   */
  com.google.protobuf.ByteString getInitialClusterVersionBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current software version of the master endpoint.
   * </pre>
   *
   * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The currentMasterVersion.
   */
  java.lang.String getCurrentMasterVersion();
  /**
   *
   *
   * <pre>
   * Output only. The current software version of the master endpoint.
   * </pre>
   *
   * <code>string current_master_version = 104 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for currentMasterVersion.
   */
  com.google.protobuf.ByteString getCurrentMasterVersionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Deprecated, use
   * [NodePool.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools)
   * instead. The current version of the node software components.
   * If they are currently at multiple versions because they're in the process
   * of being upgraded, this reflects the minimum version of all nodes.
   * </pre>
   *
   * <code>
   * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.current_node_version is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2278
   * @return The currentNodeVersion.
   */
  @java.lang.Deprecated
  java.lang.String getCurrentNodeVersion();
  /**
   *
   *
   * <pre>
   * Output only. Deprecated, use
   * [NodePool.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools)
   * instead. The current version of the node software components.
   * If they are currently at multiple versions because they're in the process
   * of being upgraded, this reflects the minimum version of all nodes.
   * </pre>
   *
   * <code>
   * string current_node_version = 105 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.current_node_version is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2278
   * @return The bytes for currentNodeVersion.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getCurrentNodeVersionBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The createTime.
   */
  java.lang.String getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string create_time = 106 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for createTime.
   */
  com.google.protobuf.ByteString getCreateTimeBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current status of this cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  int getStatusValue();
  /**
   *
   *
   * <pre>
   * Output only. The current status of this cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.Cluster.Status status = 107 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  com.google.container.v1beta1.Cluster.Status getStatus();

  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use conditions instead.
   * Additional information about the current status of this
   * cluster, if available.
   * </pre>
   *
   * <code>
   * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.status_message is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2291
   * @return The statusMessage.
   */
  @java.lang.Deprecated
  java.lang.String getStatusMessage();
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use conditions instead.
   * Additional information about the current status of this
   * cluster, if available.
   * </pre>
   *
   * <code>
   * string status_message = 108 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.status_message is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2291
   * @return The bytes for statusMessage.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getStatusMessageBytes();

  /**
   *
   *
   * <pre>
   * Output only. The size of the address space on each node for hosting
   * containers. This is provisioned from within the `container_ipv4_cidr`
   * range. This field will only be set when cluster is in route-based network
   * mode.
   * </pre>
   *
   * <code>int32 node_ipv4_cidr_size = 109 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The nodeIpv4CidrSize.
   */
  int getNodeIpv4CidrSize();

  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Kubernetes services in
   * this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`). Service addresses are
   * typically put in the last `/16` from the container CIDR.
   * </pre>
   *
   * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The servicesIpv4Cidr.
   */
  java.lang.String getServicesIpv4Cidr();
  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Kubernetes services in
   * this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`). Service addresses are
   * typically put in the last `/16` from the container CIDR.
   * </pre>
   *
   * <code>string services_ipv4_cidr = 110 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for servicesIpv4Cidr.
   */
  com.google.protobuf.ByteString getServicesIpv4CidrBytes();

  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2308
   * @return A list containing the instanceGroupUrls.
   */
  @java.lang.Deprecated
  java.util.List<java.lang.String> getInstanceGroupUrlsList();
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2308
   * @return The count of instanceGroupUrls.
   */
  @java.lang.Deprecated
  int getInstanceGroupUrlsCount();
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2308
   * @param index The index of the element to return.
   * @return The instanceGroupUrls at the given index.
   */
  @java.lang.Deprecated
  java.lang.String getInstanceGroupUrls(int index);
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use node_pools.instance_group_urls.
   * </pre>
   *
   * <code>
   * repeated string instance_group_urls = 111 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.instance_group_urls is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2308
   * @param index The index of the value to return.
   * @return The bytes of the instanceGroupUrls at the given index.
   */
  @java.lang.Deprecated
  com.google.protobuf.ByteString getInstanceGroupUrlsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The number of nodes currently in the cluster. Deprecated.
   * Call Kubernetes API directly to retrieve node information.
   * </pre>
   *
   * <code>
   * int32 current_node_count = 112 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.current_node_count is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2313
   * @return The currentNodeCount.
   */
  @java.lang.Deprecated
  int getCurrentNodeCount();

  /**
   *
   *
   * <pre>
   * Output only. The time the cluster will be automatically
   * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The expireTime.
   */
  java.lang.String getExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the cluster will be automatically
   * deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * </pre>
   *
   * <code>string expire_time = 113 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for expireTime.
   */
  com.google.protobuf.ByteString getExpireTimeBytes();

  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * or
   * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * in which the cluster resides.
   * </pre>
   *
   * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The location.
   */
  java.lang.String getLocation();
  /**
   *
   *
   * <pre>
   * Output only. The name of the Google Compute Engine
   * [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * or
   * [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
   * in which the cluster resides.
   * </pre>
   *
   * <code>string location = 114 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for location.
   */
  com.google.protobuf.ByteString getLocationBytes();

  /**
   *
   *
   * <pre>
   * Enable the ability to use Cloud TPUs in this cluster.
   * This field is deprecated, use tpu_config.enabled instead.
   * </pre>
   *
   * <code>bool enable_tpu = 115;</code>
   *
   * @return The enableTpu.
   */
  boolean getEnableTpu();

  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`).
   * </pre>
   *
   * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tpuIpv4CidrBlock.
   */
  java.lang.String getTpuIpv4CidrBlock();
  /**
   *
   *
   * <pre>
   * Output only. The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `1.2.3.4/29`).
   * </pre>
   *
   * <code>string tpu_ipv4_cidr_block = 116 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for tpuIpv4CidrBlock.
   */
  com.google.protobuf.ByteString getTpuIpv4CidrBlockBytes();

  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatabaseEncryption database_encryption = 38;</code>
   *
   * @return Whether the databaseEncryption field is set.
   */
  boolean hasDatabaseEncryption();
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatabaseEncryption database_encryption = 38;</code>
   *
   * @return The databaseEncryption.
   */
  com.google.container.v1beta1.DatabaseEncryption getDatabaseEncryption();
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatabaseEncryption database_encryption = 38;</code>
   */
  com.google.container.v1beta1.DatabaseEncryptionOrBuilder getDatabaseEncryptionOrBuilder();

  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.StatusCondition conditions = 118;</code>
   */
  java.util.List<com.google.container.v1beta1.StatusCondition> getConditionsList();
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.StatusCondition conditions = 118;</code>
   */
  com.google.container.v1beta1.StatusCondition getConditions(int index);
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.StatusCondition conditions = 118;</code>
   */
  int getConditionsCount();
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.StatusCondition conditions = 118;</code>
   */
  java.util.List<? extends com.google.container.v1beta1.StatusConditionOrBuilder>
      getConditionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Which conditions caused the current cluster state.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.StatusCondition conditions = 118;</code>
   */
  com.google.container.v1beta1.StatusConditionOrBuilder getConditionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Configuration for master components.
   * </pre>
   *
   * <code>.google.container.v1beta1.Master master = 124;</code>
   *
   * @return Whether the master field is set.
   */
  boolean hasMaster();
  /**
   *
   *
   * <pre>
   * Configuration for master components.
   * </pre>
   *
   * <code>.google.container.v1beta1.Master master = 124;</code>
   *
   * @return The master.
   */
  com.google.container.v1beta1.Master getMaster();
  /**
   *
   *
   * <pre>
   * Configuration for master components.
   * </pre>
   *
   * <code>.google.container.v1beta1.Master master = 124;</code>
   */
  com.google.container.v1beta1.MasterOrBuilder getMasterOrBuilder();

  /**
   *
   *
   * <pre>
   * Autopilot configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Autopilot autopilot = 128;</code>
   *
   * @return Whether the autopilot field is set.
   */
  boolean hasAutopilot();
  /**
   *
   *
   * <pre>
   * Autopilot configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Autopilot autopilot = 128;</code>
   *
   * @return The autopilot.
   */
  com.google.container.v1beta1.Autopilot getAutopilot();
  /**
   *
   *
   * <pre>
   * Autopilot configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Autopilot autopilot = 128;</code>
   */
  com.google.container.v1beta1.AutopilotOrBuilder getAutopilotOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Unique id for the cluster.
   * </pre>
   *
   * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  java.lang.String getId();
  /**
   *
   *
   * <pre>
   * Output only. Unique id for the cluster.
   * </pre>
   *
   * <code>string id = 129 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Default NodePool settings for the entire cluster. These settings are
   * overridden if specified on the specific NodePool object.
   * </pre>
   *
   * <code>optional .google.container.v1beta1.NodePoolDefaults node_pool_defaults = 131;</code>
   *
   * @return Whether the nodePoolDefaults field is set.
   */
  boolean hasNodePoolDefaults();
  /**
   *
   *
   * <pre>
   * Default NodePool settings for the entire cluster. These settings are
   * overridden if specified on the specific NodePool object.
   * </pre>
   *
   * <code>optional .google.container.v1beta1.NodePoolDefaults node_pool_defaults = 131;</code>
   *
   * @return The nodePoolDefaults.
   */
  com.google.container.v1beta1.NodePoolDefaults getNodePoolDefaults();
  /**
   *
   *
   * <pre>
   * Default NodePool settings for the entire cluster. These settings are
   * overridden if specified on the specific NodePool object.
   * </pre>
   *
   * <code>optional .google.container.v1beta1.NodePoolDefaults node_pool_defaults = 131;</code>
   */
  com.google.container.v1beta1.NodePoolDefaultsOrBuilder getNodePoolDefaultsOrBuilder();

  /**
   *
   *
   * <pre>
   * Logging configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.LoggingConfig logging_config = 132;</code>
   *
   * @return Whether the loggingConfig field is set.
   */
  boolean hasLoggingConfig();
  /**
   *
   *
   * <pre>
   * Logging configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.LoggingConfig logging_config = 132;</code>
   *
   * @return The loggingConfig.
   */
  com.google.container.v1beta1.LoggingConfig getLoggingConfig();
  /**
   *
   *
   * <pre>
   * Logging configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.LoggingConfig logging_config = 132;</code>
   */
  com.google.container.v1beta1.LoggingConfigOrBuilder getLoggingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Monitoring configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.MonitoringConfig monitoring_config = 133;</code>
   *
   * @return Whether the monitoringConfig field is set.
   */
  boolean hasMonitoringConfig();
  /**
   *
   *
   * <pre>
   * Monitoring configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.MonitoringConfig monitoring_config = 133;</code>
   *
   * @return The monitoringConfig.
   */
  com.google.container.v1beta1.MonitoringConfig getMonitoringConfig();
  /**
   *
   *
   * <pre>
   * Monitoring configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.MonitoringConfig monitoring_config = 133;</code>
   */
  com.google.container.v1beta1.MonitoringConfigOrBuilder getMonitoringConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Node pool configs that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
   *
   * @return Whether the nodePoolAutoConfig field is set.
   */
  boolean hasNodePoolAutoConfig();
  /**
   *
   *
   * <pre>
   * Node pool configs that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
   *
   * @return The nodePoolAutoConfig.
   */
  com.google.container.v1beta1.NodePoolAutoConfig getNodePoolAutoConfig();
  /**
   *
   *
   * <pre>
   * Node pool configs that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolAutoConfig node_pool_auto_config = 136;</code>
   */
  com.google.container.v1beta1.NodePoolAutoConfigOrBuilder getNodePoolAutoConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Deprecated: Use SecurityPostureConfig instead.
   * Enable/Disable Protect API features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.ProtectConfig protect_config = 137 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.protect_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2367
   * @return Whether the protectConfig field is set.
   */
  @java.lang.Deprecated
  boolean hasProtectConfig();
  /**
   *
   *
   * <pre>
   * Deprecated: Use SecurityPostureConfig instead.
   * Enable/Disable Protect API features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.ProtectConfig protect_config = 137 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.Cluster.protect_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2367
   * @return The protectConfig.
   */
  @java.lang.Deprecated
  com.google.container.v1beta1.ProtectConfig getProtectConfig();
  /**
   *
   *
   * <pre>
   * Deprecated: Use SecurityPostureConfig instead.
   * Enable/Disable Protect API features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.ProtectConfig protect_config = 137 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.container.v1beta1.ProtectConfigOrBuilder getProtectConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of cluster
   * fields, and may be sent on update requests to ensure the client has an
   * up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 139;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of cluster
   * fields, and may be sent on update requests to ensure the client has an
   * up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 139;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Fleet information for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Fleet fleet = 140;</code>
   *
   * @return Whether the fleet field is set.
   */
  boolean hasFleet();
  /**
   *
   *
   * <pre>
   * Fleet information for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Fleet fleet = 140;</code>
   *
   * @return The fleet.
   */
  com.google.container.v1beta1.Fleet getFleet();
  /**
   *
   *
   * <pre>
   * Fleet information for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Fleet fleet = 140;</code>
   */
  com.google.container.v1beta1.FleetOrBuilder getFleetOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecurityPostureConfig security_posture_config = 145;</code>
   *
   * @return Whether the securityPostureConfig field is set.
   */
  boolean hasSecurityPostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecurityPostureConfig security_posture_config = 145;</code>
   *
   * @return The securityPostureConfig.
   */
  com.google.container.v1beta1.SecurityPostureConfig getSecurityPostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecurityPostureConfig security_posture_config = 145;</code>
   */
  com.google.container.v1beta1.SecurityPostureConfigOrBuilder getSecurityPostureConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * GKE Enterprise Configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.EnterpriseConfig enterprise_config = 149;</code>
   *
   * @return Whether the enterpriseConfig field is set.
   */
  boolean hasEnterpriseConfig();
  /**
   *
   *
   * <pre>
   * GKE Enterprise Configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.EnterpriseConfig enterprise_config = 149;</code>
   *
   * @return The enterpriseConfig.
   */
  com.google.container.v1beta1.EnterpriseConfig getEnterpriseConfig();
  /**
   *
   *
   * <pre>
   * GKE Enterprise Configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.EnterpriseConfig enterprise_config = 149;</code>
   */
  com.google.container.v1beta1.EnterpriseConfigOrBuilder getEnterpriseConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Secret CSI driver configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecretManagerConfig secret_manager_config = 150;</code>
   *
   * @return Whether the secretManagerConfig field is set.
   */
  boolean hasSecretManagerConfig();
  /**
   *
   *
   * <pre>
   * Secret CSI driver configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecretManagerConfig secret_manager_config = 150;</code>
   *
   * @return The secretManagerConfig.
   */
  com.google.container.v1beta1.SecretManagerConfig getSecretManagerConfig();
  /**
   *
   *
   * <pre>
   * Secret CSI driver configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecretManagerConfig secret_manager_config = 150;</code>
   */
  com.google.container.v1beta1.SecretManagerConfigOrBuilder getSecretManagerConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.CompliancePostureConfig compliance_posture_config = 151;</code>
   *
   * @return Whether the compliancePostureConfig field is set.
   */
  boolean hasCompliancePostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.CompliancePostureConfig compliance_posture_config = 151;</code>
   *
   * @return The compliancePostureConfig.
   */
  com.google.container.v1beta1.CompliancePostureConfig getCompliancePostureConfig();
  /**
   *
   *
   * <pre>
   * Enable/Disable Compliance Posture features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.CompliancePostureConfig compliance_posture_config = 151;</code>
   */
  com.google.container.v1beta1.CompliancePostureConfigOrBuilder
      getCompliancePostureConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  boolean hasSatisfiesPzs();
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 152 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  boolean hasSatisfiesPzi();
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 153 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  boolean getSatisfiesPzi();
}
