/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * ClusterUpdate describes an update to the cluster. Exactly one update can
 * be applied to a cluster with each request, so at most one field can be
 * provided.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.ClusterUpdate}
 */
public final class ClusterUpdate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.ClusterUpdate)
    ClusterUpdateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClusterUpdate.newBuilder() to construct.
  private ClusterUpdate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClusterUpdate() {
    desiredNodeVersion_ = "";
    desiredMonitoringService_ = "";
    desiredNodePoolId_ = "";
    desiredImageType_ = "";
    desiredLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    desiredLoggingService_ = "";
    desiredDatapathProvider_ = 0;
    desiredPrivateIpv6GoogleAccess_ = 0;
    desiredMasterVersion_ = "";
    etag_ = "";
    desiredStackType_ = 0;
    desiredInTransitEncryptionConfig_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClusterUpdate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_ClusterUpdate_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_ClusterUpdate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.ClusterUpdate.class,
            com.google.container.v1beta1.ClusterUpdate.Builder.class);
  }

  private int bitField0_;
  private int bitField1_;
  public static final int DESIRED_NODE_VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object desiredNodeVersion_ = "";
  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the nodes to (typically an
   * upgrade).
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the Kubernetes master version
   * </pre>
   *
   * <code>string desired_node_version = 4;</code>
   *
   * @return The desiredNodeVersion.
   */
  @java.lang.Override
  public java.lang.String getDesiredNodeVersion() {
    java.lang.Object ref = desiredNodeVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      desiredNodeVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the nodes to (typically an
   * upgrade).
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the Kubernetes master version
   * </pre>
   *
   * <code>string desired_node_version = 4;</code>
   *
   * @return The bytes for desiredNodeVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDesiredNodeVersionBytes() {
    java.lang.Object ref = desiredNodeVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      desiredNodeVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_MONITORING_SERVICE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object desiredMonitoringService_ = "";
  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_monitoring_service = 5;</code>
   *
   * @return The desiredMonitoringService.
   */
  @java.lang.Override
  public java.lang.String getDesiredMonitoringService() {
    java.lang.Object ref = desiredMonitoringService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      desiredMonitoringService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The monitoring service the cluster should use to write metrics.
   * Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
   * service with a Kubernetes-native resource model
   * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   *   longer available as of GKE 1.15).
   * * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_monitoring_service = 5;</code>
   *
   * @return The bytes for desiredMonitoringService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDesiredMonitoringServiceBytes() {
    java.lang.Object ref = desiredMonitoringService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      desiredMonitoringService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_ADDONS_CONFIG_FIELD_NUMBER = 6;
  private com.google.container.v1beta1.AddonsConfig desiredAddonsConfig_;
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
   *
   * @return Whether the desiredAddonsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredAddonsConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
   *
   * @return The desiredAddonsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.AddonsConfig getDesiredAddonsConfig() {
    return desiredAddonsConfig_ == null
        ? com.google.container.v1beta1.AddonsConfig.getDefaultInstance()
        : desiredAddonsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configurations for the various addons available to run in the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AddonsConfigOrBuilder getDesiredAddonsConfigOrBuilder() {
    return desiredAddonsConfig_ == null
        ? com.google.container.v1beta1.AddonsConfig.getDefaultInstance()
        : desiredAddonsConfig_;
  }

  public static final int DESIRED_NODE_POOL_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object desiredNodePoolId_ = "";
  /**
   *
   *
   * <pre>
   * The node pool to be upgraded. This field is mandatory if
   * "desired_node_version", "desired_image_family",
   * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
   * is specified and there is more than one node pool on the cluster.
   * </pre>
   *
   * <code>string desired_node_pool_id = 7;</code>
   *
   * @return The desiredNodePoolId.
   */
  @java.lang.Override
  public java.lang.String getDesiredNodePoolId() {
    java.lang.Object ref = desiredNodePoolId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      desiredNodePoolId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The node pool to be upgraded. This field is mandatory if
   * "desired_node_version", "desired_image_family",
   * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
   * is specified and there is more than one node pool on the cluster.
   * </pre>
   *
   * <code>string desired_node_pool_id = 7;</code>
   *
   * @return The bytes for desiredNodePoolId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDesiredNodePoolIdBytes() {
    java.lang.Object ref = desiredNodePoolId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      desiredNodePoolId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_IMAGE_TYPE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object desiredImageType_ = "";
  /**
   *
   *
   * <pre>
   * The desired image type for the node pool.
   * NOTE: Set the "desired_node_pool" field as well.
   * </pre>
   *
   * <code>string desired_image_type = 8;</code>
   *
   * @return The desiredImageType.
   */
  @java.lang.Override
  public java.lang.String getDesiredImageType() {
    java.lang.Object ref = desiredImageType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      desiredImageType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The desired image type for the node pool.
   * NOTE: Set the "desired_node_pool" field as well.
   * </pre>
   *
   * <code>string desired_image_type = 8;</code>
   *
   * @return The bytes for desiredImageType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDesiredImageTypeBytes() {
    java.lang.Object ref = desiredImageType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      desiredImageType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_NODE_POOL_AUTOSCALING_FIELD_NUMBER = 9;
  private com.google.container.v1beta1.NodePoolAutoscaling desiredNodePoolAutoscaling_;
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for the node pool specified in
   * desired_node_pool_id. If there is only one pool in the
   * cluster and desired_node_pool_id is not provided then
   * the change applies to that single node pool.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
   *
   * @return Whether the desiredNodePoolAutoscaling field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNodePoolAutoscaling() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for the node pool specified in
   * desired_node_pool_id. If there is only one pool in the
   * cluster and desired_node_pool_id is not provided then
   * the change applies to that single node pool.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
   *
   * @return The desiredNodePoolAutoscaling.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodePoolAutoscaling getDesiredNodePoolAutoscaling() {
    return desiredNodePoolAutoscaling_ == null
        ? com.google.container.v1beta1.NodePoolAutoscaling.getDefaultInstance()
        : desiredNodePoolAutoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Autoscaler configuration for the node pool specified in
   * desired_node_pool_id. If there is only one pool in the
   * cluster and desired_node_pool_id is not provided then
   * the change applies to that single node pool.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodePoolAutoscalingOrBuilder
      getDesiredNodePoolAutoscalingOrBuilder() {
    return desiredNodePoolAutoscaling_ == null
        ? com.google.container.v1beta1.NodePoolAutoscaling.getDefaultInstance()
        : desiredNodePoolAutoscaling_;
  }

  public static final int DESIRED_LOCATIONS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList desiredLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @return A list containing the desiredLocations.
   */
  public com.google.protobuf.ProtocolStringList getDesiredLocationsList() {
    return desiredLocations_;
  }
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @return The count of desiredLocations.
   */
  public int getDesiredLocationsCount() {
    return desiredLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The desiredLocations at the given index.
   */
  public java.lang.String getDesiredLocations(int index) {
    return desiredLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The desired list of Google Compute Engine
   * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
   * cluster's nodes should be located.
   *
   * This list must always include the cluster's primary zone.
   *
   * Warning: changing cluster locations will update the locations of all node
   * pools and will result in nodes being added and/or removed.
   * </pre>
   *
   * <code>repeated string desired_locations = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the desiredLocations at the given index.
   */
  public com.google.protobuf.ByteString getDesiredLocationsBytes(int index) {
    return desiredLocations_.getByteString(index);
  }

  public static final int DESIRED_MASTER_AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER = 12;
  private com.google.container.v1beta1.MasterAuthorizedNetworksConfig
      desiredMasterAuthorizedNetworksConfig_;
  /**
   *
   *
   * <pre>
   * The desired configuration options for master authorized networks feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
   * </code>
   *
   * @return Whether the desiredMasterAuthorizedNetworksConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredMasterAuthorizedNetworksConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired configuration options for master authorized networks feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
   * </code>
   *
   * @return The desiredMasterAuthorizedNetworksConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.MasterAuthorizedNetworksConfig
      getDesiredMasterAuthorizedNetworksConfig() {
    return desiredMasterAuthorizedNetworksConfig_ == null
        ? com.google.container.v1beta1.MasterAuthorizedNetworksConfig.getDefaultInstance()
        : desiredMasterAuthorizedNetworksConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired configuration options for master authorized networks feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.MasterAuthorizedNetworksConfigOrBuilder
      getDesiredMasterAuthorizedNetworksConfigOrBuilder() {
    return desiredMasterAuthorizedNetworksConfig_ == null
        ? com.google.container.v1beta1.MasterAuthorizedNetworksConfig.getDefaultInstance()
        : desiredMasterAuthorizedNetworksConfig_;
  }

  public static final int DESIRED_POD_SECURITY_POLICY_CONFIG_FIELD_NUMBER = 14;
  private com.google.container.v1beta1.PodSecurityPolicyConfig desiredPodSecurityPolicyConfig_;
  /**
   *
   *
   * <pre>
   * The desired configuration options for the PodSecurityPolicy feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
   * </code>
   *
   * @return Whether the desiredPodSecurityPolicyConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredPodSecurityPolicyConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired configuration options for the PodSecurityPolicy feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
   * </code>
   *
   * @return The desiredPodSecurityPolicyConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.PodSecurityPolicyConfig getDesiredPodSecurityPolicyConfig() {
    return desiredPodSecurityPolicyConfig_ == null
        ? com.google.container.v1beta1.PodSecurityPolicyConfig.getDefaultInstance()
        : desiredPodSecurityPolicyConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired configuration options for the PodSecurityPolicy feature.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.PodSecurityPolicyConfigOrBuilder
      getDesiredPodSecurityPolicyConfigOrBuilder() {
    return desiredPodSecurityPolicyConfig_ == null
        ? com.google.container.v1beta1.PodSecurityPolicyConfig.getDefaultInstance()
        : desiredPodSecurityPolicyConfig_;
  }

  public static final int DESIRED_CLUSTER_AUTOSCALING_FIELD_NUMBER = 15;
  private com.google.container.v1beta1.ClusterAutoscaling desiredClusterAutoscaling_;
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
   *
   * @return Whether the desiredClusterAutoscaling field is set.
   */
  @java.lang.Override
  public boolean hasDesiredClusterAutoscaling() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
   *
   * @return The desiredClusterAutoscaling.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ClusterAutoscaling getDesiredClusterAutoscaling() {
    return desiredClusterAutoscaling_ == null
        ? com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance()
        : desiredClusterAutoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Cluster-level autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ClusterAutoscalingOrBuilder
      getDesiredClusterAutoscalingOrBuilder() {
    return desiredClusterAutoscaling_ == null
        ? com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance()
        : desiredClusterAutoscaling_;
  }

  public static final int DESIRED_BINARY_AUTHORIZATION_FIELD_NUMBER = 16;
  private com.google.container.v1beta1.BinaryAuthorization desiredBinaryAuthorization_;
  /**
   *
   *
   * <pre>
   * The desired configuration options for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
   *
   * @return Whether the desiredBinaryAuthorization field is set.
   */
  @java.lang.Override
  public boolean hasDesiredBinaryAuthorization() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired configuration options for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
   *
   * @return The desiredBinaryAuthorization.
   */
  @java.lang.Override
  public com.google.container.v1beta1.BinaryAuthorization getDesiredBinaryAuthorization() {
    return desiredBinaryAuthorization_ == null
        ? com.google.container.v1beta1.BinaryAuthorization.getDefaultInstance()
        : desiredBinaryAuthorization_;
  }
  /**
   *
   *
   * <pre>
   * The desired configuration options for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.BinaryAuthorizationOrBuilder
      getDesiredBinaryAuthorizationOrBuilder() {
    return desiredBinaryAuthorization_ == null
        ? com.google.container.v1beta1.BinaryAuthorization.getDefaultInstance()
        : desiredBinaryAuthorization_;
  }

  public static final int DESIRED_LOGGING_SERVICE_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object desiredLoggingService_ = "";
  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_logging_service = 19;</code>
   *
   * @return The desiredLoggingService.
   */
  @java.lang.Override
  public java.lang.String getDesiredLoggingService() {
    java.lang.Object ref = desiredLoggingService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      desiredLoggingService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The logging service the cluster should use to write logs.
   * Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging
   * service with a Kubernetes-native resource model
   * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   *   available as of GKE 1.15).
   * * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be
   * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
   * </pre>
   *
   * <code>string desired_logging_service = 19;</code>
   *
   * @return The bytes for desiredLoggingService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDesiredLoggingServiceBytes() {
    java.lang.Object ref = desiredLoggingService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      desiredLoggingService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_RESOURCE_USAGE_EXPORT_CONFIG_FIELD_NUMBER = 21;
  private com.google.container.v1beta1.ResourceUsageExportConfig desiredResourceUsageExportConfig_;
  /**
   *
   *
   * <pre>
   * The desired configuration for exporting resource usage.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
   * </code>
   *
   * @return Whether the desiredResourceUsageExportConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredResourceUsageExportConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired configuration for exporting resource usage.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
   * </code>
   *
   * @return The desiredResourceUsageExportConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ResourceUsageExportConfig
      getDesiredResourceUsageExportConfig() {
    return desiredResourceUsageExportConfig_ == null
        ? com.google.container.v1beta1.ResourceUsageExportConfig.getDefaultInstance()
        : desiredResourceUsageExportConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired configuration for exporting resource usage.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ResourceUsageExportConfigOrBuilder
      getDesiredResourceUsageExportConfigOrBuilder() {
    return desiredResourceUsageExportConfig_ == null
        ? com.google.container.v1beta1.ResourceUsageExportConfig.getDefaultInstance()
        : desiredResourceUsageExportConfig_;
  }

  public static final int DESIRED_VERTICAL_POD_AUTOSCALING_FIELD_NUMBER = 22;
  private com.google.container.v1beta1.VerticalPodAutoscaling desiredVerticalPodAutoscaling_;
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
   * </code>
   *
   * @return Whether the desiredVerticalPodAutoscaling field is set.
   */
  @java.lang.Override
  public boolean hasDesiredVerticalPodAutoscaling() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
   * </code>
   *
   * @return The desiredVerticalPodAutoscaling.
   */
  @java.lang.Override
  public com.google.container.v1beta1.VerticalPodAutoscaling getDesiredVerticalPodAutoscaling() {
    return desiredVerticalPodAutoscaling_ == null
        ? com.google.container.v1beta1.VerticalPodAutoscaling.getDefaultInstance()
        : desiredVerticalPodAutoscaling_;
  }
  /**
   *
   *
   * <pre>
   * Cluster-level Vertical Pod Autoscaling configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.VerticalPodAutoscalingOrBuilder
      getDesiredVerticalPodAutoscalingOrBuilder() {
    return desiredVerticalPodAutoscaling_ == null
        ? com.google.container.v1beta1.VerticalPodAutoscaling.getDefaultInstance()
        : desiredVerticalPodAutoscaling_;
  }

  public static final int DESIRED_PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER = 25;
  private com.google.container.v1beta1.PrivateClusterConfig desiredPrivateClusterConfig_;
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. master_global_access_config is
   * the only field that can be changed via this field.
   * See also
   * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
   * for modifying other fields within
   * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
   * </code>
   *
   * @return Whether the desiredPrivateClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredPrivateClusterConfig() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. master_global_access_config is
   * the only field that can be changed via this field.
   * See also
   * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
   * for modifying other fields within
   * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
   * </code>
   *
   * @return The desiredPrivateClusterConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.PrivateClusterConfig getDesiredPrivateClusterConfig() {
    return desiredPrivateClusterConfig_ == null
        ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
        : desiredPrivateClusterConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. master_global_access_config is
   * the only field that can be changed via this field.
   * See also
   * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
   * for modifying other fields within
   * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
   * </pre>
   *
   * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.PrivateClusterConfigOrBuilder
      getDesiredPrivateClusterConfigOrBuilder() {
    return desiredPrivateClusterConfig_ == null
        ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
        : desiredPrivateClusterConfig_;
  }

  public static final int DESIRED_INTRA_NODE_VISIBILITY_CONFIG_FIELD_NUMBER = 26;
  private com.google.container.v1beta1.IntraNodeVisibilityConfig desiredIntraNodeVisibilityConfig_;
  /**
   *
   *
   * <pre>
   * The desired config of Intra-node visibility.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
   * </code>
   *
   * @return Whether the desiredIntraNodeVisibilityConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredIntraNodeVisibilityConfig() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired config of Intra-node visibility.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
   * </code>
   *
   * @return The desiredIntraNodeVisibilityConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.IntraNodeVisibilityConfig
      getDesiredIntraNodeVisibilityConfig() {
    return desiredIntraNodeVisibilityConfig_ == null
        ? com.google.container.v1beta1.IntraNodeVisibilityConfig.getDefaultInstance()
        : desiredIntraNodeVisibilityConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired config of Intra-node visibility.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.IntraNodeVisibilityConfigOrBuilder
      getDesiredIntraNodeVisibilityConfigOrBuilder() {
    return desiredIntraNodeVisibilityConfig_ == null
        ? com.google.container.v1beta1.IntraNodeVisibilityConfig.getDefaultInstance()
        : desiredIntraNodeVisibilityConfig_;
  }

  public static final int DESIRED_DEFAULT_SNAT_STATUS_FIELD_NUMBER = 28;
  private com.google.container.v1beta1.DefaultSnatStatus desiredDefaultSnatStatus_;
  /**
   *
   *
   * <pre>
   * The desired status of whether to disable default sNAT for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
   *
   * @return Whether the desiredDefaultSnatStatus field is set.
   */
  @java.lang.Override
  public boolean hasDesiredDefaultSnatStatus() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired status of whether to disable default sNAT for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
   *
   * @return The desiredDefaultSnatStatus.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DefaultSnatStatus getDesiredDefaultSnatStatus() {
    return desiredDefaultSnatStatus_ == null
        ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
        : desiredDefaultSnatStatus_;
  }
  /**
   *
   *
   * <pre>
   * The desired status of whether to disable default sNAT for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.DefaultSnatStatusOrBuilder
      getDesiredDefaultSnatStatusOrBuilder() {
    return desiredDefaultSnatStatus_ == null
        ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
        : desiredDefaultSnatStatus_;
  }

  public static final int DESIRED_CLUSTER_TELEMETRY_FIELD_NUMBER = 30;
  private com.google.container.v1beta1.ClusterTelemetry desiredClusterTelemetry_;
  /**
   *
   *
   * <pre>
   * The desired telemetry integration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
   *
   * @return Whether the desiredClusterTelemetry field is set.
   */
  @java.lang.Override
  public boolean hasDesiredClusterTelemetry() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired telemetry integration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
   *
   * @return The desiredClusterTelemetry.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ClusterTelemetry getDesiredClusterTelemetry() {
    return desiredClusterTelemetry_ == null
        ? com.google.container.v1beta1.ClusterTelemetry.getDefaultInstance()
        : desiredClusterTelemetry_;
  }
  /**
   *
   *
   * <pre>
   * The desired telemetry integration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ClusterTelemetryOrBuilder
      getDesiredClusterTelemetryOrBuilder() {
    return desiredClusterTelemetry_ == null
        ? com.google.container.v1beta1.ClusterTelemetry.getDefaultInstance()
        : desiredClusterTelemetry_;
  }

  public static final int DESIRED_RELEASE_CHANNEL_FIELD_NUMBER = 31;
  private com.google.container.v1beta1.ReleaseChannel desiredReleaseChannel_;
  /**
   *
   *
   * <pre>
   * The desired release channel configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
   *
   * @return Whether the desiredReleaseChannel field is set.
   */
  @java.lang.Override
  public boolean hasDesiredReleaseChannel() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired release channel configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
   *
   * @return The desiredReleaseChannel.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ReleaseChannel getDesiredReleaseChannel() {
    return desiredReleaseChannel_ == null
        ? com.google.container.v1beta1.ReleaseChannel.getDefaultInstance()
        : desiredReleaseChannel_;
  }
  /**
   *
   *
   * <pre>
   * The desired release channel configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ReleaseChannelOrBuilder getDesiredReleaseChannelOrBuilder() {
    return desiredReleaseChannel_ == null
        ? com.google.container.v1beta1.ReleaseChannel.getDefaultInstance()
        : desiredReleaseChannel_;
  }

  public static final int PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER = 37;
  private com.google.container.v1beta1.PrivateClusterConfig privateClusterConfig_;
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. Has no effect. Use
   * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.ClusterUpdate.private_cluster_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2681
   * @return Whether the privateClusterConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasPrivateClusterConfig() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. Has no effect. Use
   * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.ClusterUpdate.private_cluster_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2681
   * @return The privateClusterConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.PrivateClusterConfig getPrivateClusterConfig() {
    return privateClusterConfig_ == null
        ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
        : privateClusterConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired private cluster configuration. Has no effect. Use
   * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
   * instead.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.PrivateClusterConfigOrBuilder
      getPrivateClusterConfigOrBuilder() {
    return privateClusterConfig_ == null
        ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
        : privateClusterConfig_;
  }

  public static final int DESIRED_TPU_CONFIG_FIELD_NUMBER = 38;
  private com.google.container.v1beta1.TpuConfig desiredTpuConfig_;
  /**
   *
   *
   * <pre>
   * The desired Cloud TPU configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
   *
   * @return Whether the desiredTpuConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredTpuConfig() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired Cloud TPU configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
   *
   * @return The desiredTpuConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.TpuConfig getDesiredTpuConfig() {
    return desiredTpuConfig_ == null
        ? com.google.container.v1beta1.TpuConfig.getDefaultInstance()
        : desiredTpuConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired Cloud TPU configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.TpuConfigOrBuilder getDesiredTpuConfigOrBuilder() {
    return desiredTpuConfig_ == null
        ? com.google.container.v1beta1.TpuConfig.getDefaultInstance()
        : desiredTpuConfig_;
  }

  public static final int DESIRED_L4ILB_SUBSETTING_CONFIG_FIELD_NUMBER = 39;
  private com.google.container.v1beta1.ILBSubsettingConfig desiredL4IlbSubsettingConfig_;
  /**
   *
   *
   * <pre>
   * The desired L4 Internal Load Balancer Subsetting configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
   * </code>
   *
   * @return Whether the desiredL4ilbSubsettingConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredL4IlbSubsettingConfig() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired L4 Internal Load Balancer Subsetting configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
   * </code>
   *
   * @return The desiredL4ilbSubsettingConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ILBSubsettingConfig getDesiredL4IlbSubsettingConfig() {
    return desiredL4IlbSubsettingConfig_ == null
        ? com.google.container.v1beta1.ILBSubsettingConfig.getDefaultInstance()
        : desiredL4IlbSubsettingConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired L4 Internal Load Balancer Subsetting configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ILBSubsettingConfigOrBuilder
      getDesiredL4IlbSubsettingConfigOrBuilder() {
    return desiredL4IlbSubsettingConfig_ == null
        ? com.google.container.v1beta1.ILBSubsettingConfig.getDefaultInstance()
        : desiredL4IlbSubsettingConfig_;
  }

  public static final int DESIRED_DATAPATH_PROVIDER_FIELD_NUMBER = 50;
  private int desiredDatapathProvider_ = 0;
  /**
   *
   *
   * <pre>
   * The desired datapath provider for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
   *
   * @return The enum numeric value on the wire for desiredDatapathProvider.
   */
  @java.lang.Override
  public int getDesiredDatapathProviderValue() {
    return desiredDatapathProvider_;
  }
  /**
   *
   *
   * <pre>
   * The desired datapath provider for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
   *
   * @return The desiredDatapathProvider.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DatapathProvider getDesiredDatapathProvider() {
    com.google.container.v1beta1.DatapathProvider result =
        com.google.container.v1beta1.DatapathProvider.forNumber(desiredDatapathProvider_);
    return result == null ? com.google.container.v1beta1.DatapathProvider.UNRECOGNIZED : result;
  }

  public static final int DESIRED_PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER = 51;
  private int desiredPrivateIpv6GoogleAccess_ = 0;
  /**
   *
   *
   * <pre>
   * The desired state of IPv6 connectivity to Google Services.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
   * </code>
   *
   * @return The enum numeric value on the wire for desiredPrivateIpv6GoogleAccess.
   */
  @java.lang.Override
  public int getDesiredPrivateIpv6GoogleAccessValue() {
    return desiredPrivateIpv6GoogleAccess_;
  }
  /**
   *
   *
   * <pre>
   * The desired state of IPv6 connectivity to Google Services.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
   * </code>
   *
   * @return The desiredPrivateIpv6GoogleAccess.
   */
  @java.lang.Override
  public com.google.container.v1beta1.PrivateIPv6GoogleAccess getDesiredPrivateIpv6GoogleAccess() {
    com.google.container.v1beta1.PrivateIPv6GoogleAccess result =
        com.google.container.v1beta1.PrivateIPv6GoogleAccess.forNumber(
            desiredPrivateIpv6GoogleAccess_);
    return result == null
        ? com.google.container.v1beta1.PrivateIPv6GoogleAccess.UNRECOGNIZED
        : result;
  }

  public static final int DESIRED_NOTIFICATION_CONFIG_FIELD_NUMBER = 55;
  private com.google.container.v1beta1.NotificationConfig desiredNotificationConfig_;
  /**
   *
   *
   * <pre>
   * The desired notification configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
   *
   * @return Whether the desiredNotificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNotificationConfig() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired notification configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
   *
   * @return The desiredNotificationConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NotificationConfig getDesiredNotificationConfig() {
    return desiredNotificationConfig_ == null
        ? com.google.container.v1beta1.NotificationConfig.getDefaultInstance()
        : desiredNotificationConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired notification configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NotificationConfigOrBuilder
      getDesiredNotificationConfigOrBuilder() {
    return desiredNotificationConfig_ == null
        ? com.google.container.v1beta1.NotificationConfig.getDefaultInstance()
        : desiredNotificationConfig_;
  }

  public static final int DESIRED_MASTER_VERSION_FIELD_NUMBER = 100;

  @SuppressWarnings("serial")
  private volatile java.lang.Object desiredMasterVersion_ = "";
  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the master to. The only valid value is the
   * latest supported version.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string desired_master_version = 100;</code>
   *
   * @return The desiredMasterVersion.
   */
  @java.lang.Override
  public java.lang.String getDesiredMasterVersion() {
    java.lang.Object ref = desiredMasterVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      desiredMasterVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Kubernetes version to change the master to. The only valid value is the
   * latest supported version.
   *
   * Users may specify either explicit versions offered by
   * Kubernetes Engine or version aliases, which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version
   * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
   * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
   * - "1.X.Y-gke.N": picks an explicit Kubernetes version
   * - "-": picks the default Kubernetes version
   * </pre>
   *
   * <code>string desired_master_version = 100;</code>
   *
   * @return The bytes for desiredMasterVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDesiredMasterVersionBytes() {
    java.lang.Object ref = desiredMasterVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      desiredMasterVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_GCFS_CONFIG_FIELD_NUMBER = 109;
  private com.google.container.v1beta1.GcfsConfig desiredGcfsConfig_;
  /**
   *
   *
   * <pre>
   * The desired GCFS config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
   *
   * @return Whether the desiredGcfsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredGcfsConfig() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired GCFS config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
   *
   * @return The desiredGcfsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcfsConfig getDesiredGcfsConfig() {
    return desiredGcfsConfig_ == null
        ? com.google.container.v1beta1.GcfsConfig.getDefaultInstance()
        : desiredGcfsConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired GCFS config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GcfsConfigOrBuilder getDesiredGcfsConfigOrBuilder() {
    return desiredGcfsConfig_ == null
        ? com.google.container.v1beta1.GcfsConfig.getDefaultInstance()
        : desiredGcfsConfig_;
  }

  public static final int DESIRED_DATABASE_ENCRYPTION_FIELD_NUMBER = 46;
  private com.google.container.v1beta1.DatabaseEncryption desiredDatabaseEncryption_;
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
   *
   * @return Whether the desiredDatabaseEncryption field is set.
   */
  @java.lang.Override
  public boolean hasDesiredDatabaseEncryption() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
   *
   * @return The desiredDatabaseEncryption.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DatabaseEncryption getDesiredDatabaseEncryption() {
    return desiredDatabaseEncryption_ == null
        ? com.google.container.v1beta1.DatabaseEncryption.getDefaultInstance()
        : desiredDatabaseEncryption_;
  }
  /**
   *
   *
   * <pre>
   * Configuration of etcd encryption.
   * </pre>
   *
   * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.DatabaseEncryptionOrBuilder
      getDesiredDatabaseEncryptionOrBuilder() {
    return desiredDatabaseEncryption_ == null
        ? com.google.container.v1beta1.DatabaseEncryption.getDefaultInstance()
        : desiredDatabaseEncryption_;
  }

  public static final int DESIRED_WORKLOAD_IDENTITY_CONFIG_FIELD_NUMBER = 47;
  private com.google.container.v1beta1.WorkloadIdentityConfig desiredWorkloadIdentityConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for Workload Identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
   * </code>
   *
   * @return Whether the desiredWorkloadIdentityConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredWorkloadIdentityConfig() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Workload Identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
   * </code>
   *
   * @return The desiredWorkloadIdentityConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadIdentityConfig getDesiredWorkloadIdentityConfig() {
    return desiredWorkloadIdentityConfig_ == null
        ? com.google.container.v1beta1.WorkloadIdentityConfig.getDefaultInstance()
        : desiredWorkloadIdentityConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for Workload Identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadIdentityConfigOrBuilder
      getDesiredWorkloadIdentityConfigOrBuilder() {
    return desiredWorkloadIdentityConfig_ == null
        ? com.google.container.v1beta1.WorkloadIdentityConfig.getDefaultInstance()
        : desiredWorkloadIdentityConfig_;
  }

  public static final int DESIRED_WORKLOAD_CERTIFICATES_FIELD_NUMBER = 61;
  private com.google.container.v1beta1.WorkloadCertificates desiredWorkloadCertificates_;
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;</code>
   *
   * @return Whether the desiredWorkloadCertificates field is set.
   */
  @java.lang.Override
  public boolean hasDesiredWorkloadCertificates() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;</code>
   *
   * @return The desiredWorkloadCertificates.
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadCertificates getDesiredWorkloadCertificates() {
    return desiredWorkloadCertificates_ == null
        ? com.google.container.v1beta1.WorkloadCertificates.getDefaultInstance()
        : desiredWorkloadCertificates_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadCertificatesOrBuilder
      getDesiredWorkloadCertificatesOrBuilder() {
    return desiredWorkloadCertificates_ == null
        ? com.google.container.v1beta1.WorkloadCertificates.getDefaultInstance()
        : desiredWorkloadCertificates_;
  }

  public static final int DESIRED_MESH_CERTIFICATES_FIELD_NUMBER = 67;
  private com.google.container.v1beta1.MeshCertificates desiredMeshCertificates_;
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
   *
   * @return Whether the desiredMeshCertificates field is set.
   */
  @java.lang.Override
  public boolean hasDesiredMeshCertificates() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
   *
   * @return The desiredMeshCertificates.
   */
  @java.lang.Override
  public com.google.container.v1beta1.MeshCertificates getDesiredMeshCertificates() {
    return desiredMeshCertificates_ == null
        ? com.google.container.v1beta1.MeshCertificates.getDefaultInstance()
        : desiredMeshCertificates_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for issuance of mTLS keys and certificates to Kubernetes
   * pods.
   * </pre>
   *
   * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.MeshCertificatesOrBuilder
      getDesiredMeshCertificatesOrBuilder() {
    return desiredMeshCertificates_ == null
        ? com.google.container.v1beta1.MeshCertificates.getDefaultInstance()
        : desiredMeshCertificates_;
  }

  public static final int DESIRED_WORKLOAD_ALTS_CONFIG_FIELD_NUMBER = 62;
  private com.google.container.v1beta1.WorkloadALTSConfig desiredWorkloadAltsConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for direct-path (via ALTS) with workload identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
   *
   * @return Whether the desiredWorkloadAltsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredWorkloadAltsConfig() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for direct-path (via ALTS) with workload identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
   *
   * @return The desiredWorkloadAltsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadALTSConfig getDesiredWorkloadAltsConfig() {
    return desiredWorkloadAltsConfig_ == null
        ? com.google.container.v1beta1.WorkloadALTSConfig.getDefaultInstance()
        : desiredWorkloadAltsConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for direct-path (via ALTS) with workload identity.
   * </pre>
   *
   * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadALTSConfigOrBuilder
      getDesiredWorkloadAltsConfigOrBuilder() {
    return desiredWorkloadAltsConfig_ == null
        ? com.google.container.v1beta1.WorkloadALTSConfig.getDefaultInstance()
        : desiredWorkloadAltsConfig_;
  }

  public static final int DESIRED_SHIELDED_NODES_FIELD_NUMBER = 48;
  private com.google.container.v1beta1.ShieldedNodes desiredShieldedNodes_;
  /**
   *
   *
   * <pre>
   * Configuration for Shielded Nodes.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
   *
   * @return Whether the desiredShieldedNodes field is set.
   */
  @java.lang.Override
  public boolean hasDesiredShieldedNodes() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Shielded Nodes.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
   *
   * @return The desiredShieldedNodes.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ShieldedNodes getDesiredShieldedNodes() {
    return desiredShieldedNodes_ == null
        ? com.google.container.v1beta1.ShieldedNodes.getDefaultInstance()
        : desiredShieldedNodes_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for Shielded Nodes.
   * </pre>
   *
   * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ShieldedNodesOrBuilder getDesiredShieldedNodesOrBuilder() {
    return desiredShieldedNodes_ == null
        ? com.google.container.v1beta1.ShieldedNodes.getDefaultInstance()
        : desiredShieldedNodes_;
  }

  public static final int DESIRED_COST_MANAGEMENT_CONFIG_FIELD_NUMBER = 49;
  private com.google.container.v1beta1.CostManagementConfig desiredCostManagementConfig_;
  /**
   *
   *
   * <pre>
   * The desired configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
   * </code>
   *
   * @return Whether the desiredCostManagementConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredCostManagementConfig() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
   * </code>
   *
   * @return The desiredCostManagementConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.CostManagementConfig getDesiredCostManagementConfig() {
    return desiredCostManagementConfig_ == null
        ? com.google.container.v1beta1.CostManagementConfig.getDefaultInstance()
        : desiredCostManagementConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired configuration for the fine-grained cost management feature.
   * </pre>
   *
   * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.CostManagementConfigOrBuilder
      getDesiredCostManagementConfigOrBuilder() {
    return desiredCostManagementConfig_ == null
        ? com.google.container.v1beta1.CostManagementConfig.getDefaultInstance()
        : desiredCostManagementConfig_;
  }

  public static final int DESIRED_MASTER_FIELD_NUMBER = 52;
  private com.google.container.v1beta1.Master desiredMaster_;
  /**
   *
   *
   * <pre>
   * Configuration for master components.
   * </pre>
   *
   * <code>.google.container.v1beta1.Master desired_master = 52;</code>
   *
   * @return Whether the desiredMaster field is set.
   */
  @java.lang.Override
  public boolean hasDesiredMaster() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for master components.
   * </pre>
   *
   * <code>.google.container.v1beta1.Master desired_master = 52;</code>
   *
   * @return The desiredMaster.
   */
  @java.lang.Override
  public com.google.container.v1beta1.Master getDesiredMaster() {
    return desiredMaster_ == null
        ? com.google.container.v1beta1.Master.getDefaultInstance()
        : desiredMaster_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for master components.
   * </pre>
   *
   * <code>.google.container.v1beta1.Master desired_master = 52;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.MasterOrBuilder getDesiredMasterOrBuilder() {
    return desiredMaster_ == null
        ? com.google.container.v1beta1.Master.getDefaultInstance()
        : desiredMaster_;
  }

  public static final int DESIRED_DNS_CONFIG_FIELD_NUMBER = 53;
  private com.google.container.v1beta1.DNSConfig desiredDnsConfig_;
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
   *
   * @return Whether the desiredDnsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredDnsConfig() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
   *
   * @return The desiredDnsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.DNSConfig getDesiredDnsConfig() {
    return desiredDnsConfig_ == null
        ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
        : desiredDnsConfig_;
  }
  /**
   *
   *
   * <pre>
   * DNSConfig contains clusterDNS config for this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.DNSConfigOrBuilder getDesiredDnsConfigOrBuilder() {
    return desiredDnsConfig_ == null
        ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
        : desiredDnsConfig_;
  }

  public static final int DESIRED_SERVICE_EXTERNAL_IPS_CONFIG_FIELD_NUMBER = 60;
  private com.google.container.v1beta1.ServiceExternalIPsConfig desiredServiceExternalIpsConfig_;
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies the config for the use of Services with
   * ExternalIPs field.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
   * </code>
   *
   * @return Whether the desiredServiceExternalIpsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredServiceExternalIpsConfig() {
    return ((bitField0_ & 0x08000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies the config for the use of Services with
   * ExternalIPs field.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
   * </code>
   *
   * @return The desiredServiceExternalIpsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ServiceExternalIPsConfig
      getDesiredServiceExternalIpsConfig() {
    return desiredServiceExternalIpsConfig_ == null
        ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
        : desiredServiceExternalIpsConfig_;
  }
  /**
   *
   *
   * <pre>
   * ServiceExternalIPsConfig specifies the config for the use of Services with
   * ExternalIPs field.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder
      getDesiredServiceExternalIpsConfigOrBuilder() {
    return desiredServiceExternalIpsConfig_ == null
        ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
        : desiredServiceExternalIpsConfig_;
  }

  public static final int DESIRED_AUTHENTICATOR_GROUPS_CONFIG_FIELD_NUMBER = 63;
  private com.google.container.v1beta1.AuthenticatorGroupsConfig desiredAuthenticatorGroupsConfig_;
  /**
   *
   *
   * <pre>
   * AuthenticatorGroupsConfig specifies the config for the cluster security
   * groups settings.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
   * </code>
   *
   * @return Whether the desiredAuthenticatorGroupsConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredAuthenticatorGroupsConfig() {
    return ((bitField0_ & 0x10000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * AuthenticatorGroupsConfig specifies the config for the cluster security
   * groups settings.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
   * </code>
   *
   * @return The desiredAuthenticatorGroupsConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.AuthenticatorGroupsConfig
      getDesiredAuthenticatorGroupsConfig() {
    return desiredAuthenticatorGroupsConfig_ == null
        ? com.google.container.v1beta1.AuthenticatorGroupsConfig.getDefaultInstance()
        : desiredAuthenticatorGroupsConfig_;
  }
  /**
   *
   *
   * <pre>
   * AuthenticatorGroupsConfig specifies the config for the cluster security
   * groups settings.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AuthenticatorGroupsConfigOrBuilder
      getDesiredAuthenticatorGroupsConfigOrBuilder() {
    return desiredAuthenticatorGroupsConfig_ == null
        ? com.google.container.v1beta1.AuthenticatorGroupsConfig.getDefaultInstance()
        : desiredAuthenticatorGroupsConfig_;
  }

  public static final int DESIRED_LOGGING_CONFIG_FIELD_NUMBER = 64;
  private com.google.container.v1beta1.LoggingConfig desiredLoggingConfig_;
  /**
   *
   *
   * <pre>
   * The desired logging configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
   *
   * @return Whether the desiredLoggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredLoggingConfig() {
    return ((bitField0_ & 0x20000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired logging configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
   *
   * @return The desiredLoggingConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.LoggingConfig getDesiredLoggingConfig() {
    return desiredLoggingConfig_ == null
        ? com.google.container.v1beta1.LoggingConfig.getDefaultInstance()
        : desiredLoggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired logging configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.LoggingConfigOrBuilder getDesiredLoggingConfigOrBuilder() {
    return desiredLoggingConfig_ == null
        ? com.google.container.v1beta1.LoggingConfig.getDefaultInstance()
        : desiredLoggingConfig_;
  }

  public static final int DESIRED_MONITORING_CONFIG_FIELD_NUMBER = 65;
  private com.google.container.v1beta1.MonitoringConfig desiredMonitoringConfig_;
  /**
   *
   *
   * <pre>
   * The desired monitoring configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
   *
   * @return Whether the desiredMonitoringConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredMonitoringConfig() {
    return ((bitField0_ & 0x40000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired monitoring configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
   *
   * @return The desiredMonitoringConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.MonitoringConfig getDesiredMonitoringConfig() {
    return desiredMonitoringConfig_ == null
        ? com.google.container.v1beta1.MonitoringConfig.getDefaultInstance()
        : desiredMonitoringConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired monitoring configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.MonitoringConfigOrBuilder
      getDesiredMonitoringConfigOrBuilder() {
    return desiredMonitoringConfig_ == null
        ? com.google.container.v1beta1.MonitoringConfig.getDefaultInstance()
        : desiredMonitoringConfig_;
  }

  public static final int DESIRED_IDENTITY_SERVICE_CONFIG_FIELD_NUMBER = 66;
  private com.google.container.v1beta1.IdentityServiceConfig desiredIdentityServiceConfig_;
  /**
   *
   *
   * <pre>
   * The desired Identity Service component configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
   * </code>
   *
   * @return Whether the desiredIdentityServiceConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredIdentityServiceConfig() {
    return ((bitField0_ & 0x80000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired Identity Service component configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
   * </code>
   *
   * @return The desiredIdentityServiceConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.IdentityServiceConfig getDesiredIdentityServiceConfig() {
    return desiredIdentityServiceConfig_ == null
        ? com.google.container.v1beta1.IdentityServiceConfig.getDefaultInstance()
        : desiredIdentityServiceConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired Identity Service component configuration.
   * </pre>
   *
   * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.IdentityServiceConfigOrBuilder
      getDesiredIdentityServiceConfigOrBuilder() {
    return desiredIdentityServiceConfig_ == null
        ? com.google.container.v1beta1.IdentityServiceConfig.getDefaultInstance()
        : desiredIdentityServiceConfig_;
  }

  public static final int DESIRED_ENABLE_PRIVATE_ENDPOINT_FIELD_NUMBER = 71;
  private boolean desiredEnablePrivateEndpoint_ = false;
  /**
   *
   *
   * <pre>
   * Enable/Disable private endpoint for the cluster's master.
   * </pre>
   *
   * <code>optional bool desired_enable_private_endpoint = 71;</code>
   *
   * @return Whether the desiredEnablePrivateEndpoint field is set.
   */
  @java.lang.Override
  public boolean hasDesiredEnablePrivateEndpoint() {
    return ((bitField1_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable private endpoint for the cluster's master.
   * </pre>
   *
   * <code>optional bool desired_enable_private_endpoint = 71;</code>
   *
   * @return The desiredEnablePrivateEndpoint.
   */
  @java.lang.Override
  public boolean getDesiredEnablePrivateEndpoint() {
    return desiredEnablePrivateEndpoint_;
  }

  public static final int DESIRED_NODE_POOL_AUTO_CONFIG_NETWORK_TAGS_FIELD_NUMBER = 110;
  private com.google.container.v1beta1.NetworkTags desiredNodePoolAutoConfigNetworkTags_;
  /**
   *
   *
   * <pre>
   * The desired network tags that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
   * </code>
   *
   * @return Whether the desiredNodePoolAutoConfigNetworkTags field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNodePoolAutoConfigNetworkTags() {
    return ((bitField1_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired network tags that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
   * </code>
   *
   * @return The desiredNodePoolAutoConfigNetworkTags.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkTags getDesiredNodePoolAutoConfigNetworkTags() {
    return desiredNodePoolAutoConfigNetworkTags_ == null
        ? com.google.container.v1beta1.NetworkTags.getDefaultInstance()
        : desiredNodePoolAutoConfigNetworkTags_;
  }
  /**
   *
   *
   * <pre>
   * The desired network tags that apply to all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkTagsOrBuilder
      getDesiredNodePoolAutoConfigNetworkTagsOrBuilder() {
    return desiredNodePoolAutoConfigNetworkTags_ == null
        ? com.google.container.v1beta1.NetworkTags.getDefaultInstance()
        : desiredNodePoolAutoConfigNetworkTags_;
  }

  public static final int DESIRED_PROTECT_CONFIG_FIELD_NUMBER = 112;
  private com.google.container.v1beta1.ProtectConfig desiredProtectConfig_;
  /**
   *
   *
   * <pre>
   * Deprecated: Use DesiredSecurityPostureConfig instead.
   * Enable/Disable Protect API features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.ClusterUpdate.desired_protect_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2769
   * @return Whether the desiredProtectConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDesiredProtectConfig() {
    return ((bitField1_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use DesiredSecurityPostureConfig instead.
   * Enable/Disable Protect API features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
   * </code>
   *
   * @deprecated google.container.v1beta1.ClusterUpdate.desired_protect_config is deprecated. See
   *     google/container/v1beta1/cluster_service.proto;l=2769
   * @return The desiredProtectConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.ProtectConfig getDesiredProtectConfig() {
    return desiredProtectConfig_ == null
        ? com.google.container.v1beta1.ProtectConfig.getDefaultInstance()
        : desiredProtectConfig_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Use DesiredSecurityPostureConfig instead.
   * Enable/Disable Protect API features for the cluster.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.container.v1beta1.ProtectConfigOrBuilder getDesiredProtectConfigOrBuilder() {
    return desiredProtectConfig_ == null
        ? com.google.container.v1beta1.ProtectConfig.getDefaultInstance()
        : desiredProtectConfig_;
  }

  public static final int DESIRED_GATEWAY_API_CONFIG_FIELD_NUMBER = 114;
  private com.google.container.v1beta1.GatewayAPIConfig desiredGatewayApiConfig_;
  /**
   *
   *
   * <pre>
   * The desired config of Gateway API on this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
   *
   * @return Whether the desiredGatewayApiConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredGatewayApiConfig() {
    return ((bitField1_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired config of Gateway API on this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
   *
   * @return The desiredGatewayApiConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.GatewayAPIConfig getDesiredGatewayApiConfig() {
    return desiredGatewayApiConfig_ == null
        ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
        : desiredGatewayApiConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired config of Gateway API on this cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.GatewayAPIConfigOrBuilder
      getDesiredGatewayApiConfigOrBuilder() {
    return desiredGatewayApiConfig_ == null
        ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
        : desiredGatewayApiConfig_;
  }

  public static final int ETAG_FIELD_NUMBER = 115;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The current etag of the cluster.
   * If an etag is provided and does not match the current etag of the cluster,
   * update will be blocked and an ABORTED error will be returned.
   * </pre>
   *
   * <code>string etag = 115;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The current etag of the cluster.
   * If an etag is provided and does not match the current etag of the cluster,
   * update will be blocked and an ABORTED error will be returned.
   * </pre>
   *
   * <code>string etag = 115;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESIRED_NODE_POOL_LOGGING_CONFIG_FIELD_NUMBER = 116;
  private com.google.container.v1beta1.NodePoolLoggingConfig desiredNodePoolLoggingConfig_;
  /**
   *
   *
   * <pre>
   * The desired node pool logging configuration defaults for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
   * </code>
   *
   * @return Whether the desiredNodePoolLoggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNodePoolLoggingConfig() {
    return ((bitField1_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired node pool logging configuration defaults for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
   * </code>
   *
   * @return The desiredNodePoolLoggingConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodePoolLoggingConfig getDesiredNodePoolLoggingConfig() {
    return desiredNodePoolLoggingConfig_ == null
        ? com.google.container.v1beta1.NodePoolLoggingConfig.getDefaultInstance()
        : desiredNodePoolLoggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired node pool logging configuration defaults for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodePoolLoggingConfigOrBuilder
      getDesiredNodePoolLoggingConfigOrBuilder() {
    return desiredNodePoolLoggingConfig_ == null
        ? com.google.container.v1beta1.NodePoolLoggingConfig.getDefaultInstance()
        : desiredNodePoolLoggingConfig_;
  }

  public static final int DESIRED_FLEET_FIELD_NUMBER = 117;
  private com.google.container.v1beta1.Fleet desiredFleet_;
  /**
   *
   *
   * <pre>
   * The desired fleet configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
   *
   * @return Whether the desiredFleet field is set.
   */
  @java.lang.Override
  public boolean hasDesiredFleet() {
    return ((bitField1_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired fleet configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
   *
   * @return The desiredFleet.
   */
  @java.lang.Override
  public com.google.container.v1beta1.Fleet getDesiredFleet() {
    return desiredFleet_ == null
        ? com.google.container.v1beta1.Fleet.getDefaultInstance()
        : desiredFleet_;
  }
  /**
   *
   *
   * <pre>
   * The desired fleet configuration for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.FleetOrBuilder getDesiredFleetOrBuilder() {
    return desiredFleet_ == null
        ? com.google.container.v1beta1.Fleet.getDefaultInstance()
        : desiredFleet_;
  }

  public static final int DESIRED_STACK_TYPE_FIELD_NUMBER = 119;
  private int desiredStackType_ = 0;
  /**
   *
   *
   * <pre>
   * The desired stack type of the cluster.
   * If a stack type is provided and does not match the current stack type of
   * the cluster, update will attempt to change the stack type to the new type.
   * </pre>
   *
   * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
   *
   * @return The enum numeric value on the wire for desiredStackType.
   */
  @java.lang.Override
  public int getDesiredStackTypeValue() {
    return desiredStackType_;
  }
  /**
   *
   *
   * <pre>
   * The desired stack type of the cluster.
   * If a stack type is provided and does not match the current stack type of
   * the cluster, update will attempt to change the stack type to the new type.
   * </pre>
   *
   * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
   *
   * @return The desiredStackType.
   */
  @java.lang.Override
  public com.google.container.v1beta1.StackType getDesiredStackType() {
    com.google.container.v1beta1.StackType result =
        com.google.container.v1beta1.StackType.forNumber(desiredStackType_);
    return result == null ? com.google.container.v1beta1.StackType.UNRECOGNIZED : result;
  }

  public static final int ADDITIONAL_POD_RANGES_CONFIG_FIELD_NUMBER = 120;
  private com.google.container.v1beta1.AdditionalPodRangesConfig additionalPodRangesConfig_;
  /**
   *
   *
   * <pre>
   * The additional pod ranges to be added to the cluster. These pod ranges
   * can be used by node pools to allocate pod IPs.
   * </pre>
   *
   * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
   * </code>
   *
   * @return Whether the additionalPodRangesConfig field is set.
   */
  @java.lang.Override
  public boolean hasAdditionalPodRangesConfig() {
    return ((bitField1_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The additional pod ranges to be added to the cluster. These pod ranges
   * can be used by node pools to allocate pod IPs.
   * </pre>
   *
   * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
   * </code>
   *
   * @return The additionalPodRangesConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalPodRangesConfig getAdditionalPodRangesConfig() {
    return additionalPodRangesConfig_ == null
        ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
        : additionalPodRangesConfig_;
  }
  /**
   *
   *
   * <pre>
   * The additional pod ranges to be added to the cluster. These pod ranges
   * can be used by node pools to allocate pod IPs.
   * </pre>
   *
   * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder
      getAdditionalPodRangesConfigOrBuilder() {
    return additionalPodRangesConfig_ == null
        ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
        : additionalPodRangesConfig_;
  }

  public static final int REMOVED_ADDITIONAL_POD_RANGES_CONFIG_FIELD_NUMBER = 121;
  private com.google.container.v1beta1.AdditionalPodRangesConfig removedAdditionalPodRangesConfig_;
  /**
   *
   *
   * <pre>
   * The additional pod ranges that are to be removed from the cluster.
   * The pod ranges specified here must have been specified earlier in the
   * 'additional_pod_ranges_config' argument.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
   * </code>
   *
   * @return Whether the removedAdditionalPodRangesConfig field is set.
   */
  @java.lang.Override
  public boolean hasRemovedAdditionalPodRangesConfig() {
    return ((bitField1_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The additional pod ranges that are to be removed from the cluster.
   * The pod ranges specified here must have been specified earlier in the
   * 'additional_pod_ranges_config' argument.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
   * </code>
   *
   * @return The removedAdditionalPodRangesConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalPodRangesConfig
      getRemovedAdditionalPodRangesConfig() {
    return removedAdditionalPodRangesConfig_ == null
        ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
        : removedAdditionalPodRangesConfig_;
  }
  /**
   *
   *
   * <pre>
   * The additional pod ranges that are to be removed from the cluster.
   * The pod ranges specified here must have been specified earlier in the
   * 'additional_pod_ranges_config' argument.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder
      getRemovedAdditionalPodRangesConfigOrBuilder() {
    return removedAdditionalPodRangesConfig_ == null
        ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
        : removedAdditionalPodRangesConfig_;
  }

  public static final int ENABLE_K8S_BETA_APIS_FIELD_NUMBER = 122;
  private com.google.container.v1beta1.K8sBetaAPIConfig enableK8SBetaApis_;
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
   *
   * @return Whether the enableK8sBetaApis field is set.
   */
  @java.lang.Override
  public boolean hasEnableK8SBetaApis() {
    return ((bitField1_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
   *
   * @return The enableK8sBetaApis.
   */
  @java.lang.Override
  public com.google.container.v1beta1.K8sBetaAPIConfig getEnableK8SBetaApis() {
    return enableK8SBetaApis_ == null
        ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
        : enableK8SBetaApis_;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes open source beta apis enabled on the cluster. Only beta apis
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder getEnableK8SBetaApisOrBuilder() {
    return enableK8SBetaApis_ == null
        ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
        : enableK8SBetaApis_;
  }

  public static final int DESIRED_SECURITY_POSTURE_CONFIG_FIELD_NUMBER = 124;
  private com.google.container.v1beta1.SecurityPostureConfig desiredSecurityPostureConfig_;
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
   * </code>
   *
   * @return Whether the desiredSecurityPostureConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredSecurityPostureConfig() {
    return ((bitField1_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
   * </code>
   *
   * @return The desiredSecurityPostureConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.SecurityPostureConfig getDesiredSecurityPostureConfig() {
    return desiredSecurityPostureConfig_ == null
        ? com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance()
        : desiredSecurityPostureConfig_;
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Security Posture API features for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.SecurityPostureConfigOrBuilder
      getDesiredSecurityPostureConfigOrBuilder() {
    return desiredSecurityPostureConfig_ == null
        ? com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance()
        : desiredSecurityPostureConfig_;
  }

  public static final int DESIRED_NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER = 125;
  private com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
      desiredNetworkPerformanceConfig_;
  /**
   *
   *
   * <pre>
   * The desired network performance config.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
   * </code>
   *
   * @return Whether the desiredNetworkPerformanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNetworkPerformanceConfig() {
    return ((bitField1_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired network performance config.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
   * </code>
   *
   * @return The desiredNetworkPerformanceConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
      getDesiredNetworkPerformanceConfig() {
    return desiredNetworkPerformanceConfig_ == null
        ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
            .getDefaultInstance()
        : desiredNetworkPerformanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired network performance config.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder
      getDesiredNetworkPerformanceConfigOrBuilder() {
    return desiredNetworkPerformanceConfig_ == null
        ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
            .getDefaultInstance()
        : desiredNetworkPerformanceConfig_;
  }

  public static final int DESIRED_ENABLE_FQDN_NETWORK_POLICY_FIELD_NUMBER = 126;
  private boolean desiredEnableFqdnNetworkPolicy_ = false;
  /**
   *
   *
   * <pre>
   * Enable/Disable FQDN Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
   *
   * @return Whether the desiredEnableFqdnNetworkPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDesiredEnableFqdnNetworkPolicy() {
    return ((bitField1_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable FQDN Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
   *
   * @return The desiredEnableFqdnNetworkPolicy.
   */
  @java.lang.Override
  public boolean getDesiredEnableFqdnNetworkPolicy() {
    return desiredEnableFqdnNetworkPolicy_;
  }

  public static final int DESIRED_AUTOPILOT_WORKLOAD_POLICY_CONFIG_FIELD_NUMBER = 128;
  private com.google.container.v1beta1.WorkloadPolicyConfig desiredAutopilotWorkloadPolicyConfig_;
  /**
   *
   *
   * <pre>
   * The desired workload policy configuration for the autopilot cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
   * </code>
   *
   * @return Whether the desiredAutopilotWorkloadPolicyConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredAutopilotWorkloadPolicyConfig() {
    return ((bitField1_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired workload policy configuration for the autopilot cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
   * </code>
   *
   * @return The desiredAutopilotWorkloadPolicyConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadPolicyConfig
      getDesiredAutopilotWorkloadPolicyConfig() {
    return desiredAutopilotWorkloadPolicyConfig_ == null
        ? com.google.container.v1beta1.WorkloadPolicyConfig.getDefaultInstance()
        : desiredAutopilotWorkloadPolicyConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired workload policy configuration for the autopilot cluster.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.WorkloadPolicyConfigOrBuilder
      getDesiredAutopilotWorkloadPolicyConfigOrBuilder() {
    return desiredAutopilotWorkloadPolicyConfig_ == null
        ? com.google.container.v1beta1.WorkloadPolicyConfig.getDefaultInstance()
        : desiredAutopilotWorkloadPolicyConfig_;
  }

  public static final int DESIRED_K8S_BETA_APIS_FIELD_NUMBER = 131;
  private com.google.container.v1beta1.K8sBetaAPIConfig desiredK8SBetaApis_;
  /**
   *
   *
   * <pre>
   * Beta APIs enabled for cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
   *
   * @return Whether the desiredK8sBetaApis field is set.
   */
  @java.lang.Override
  public boolean hasDesiredK8SBetaApis() {
    return ((bitField1_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Beta APIs enabled for cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
   *
   * @return The desiredK8sBetaApis.
   */
  @java.lang.Override
  public com.google.container.v1beta1.K8sBetaAPIConfig getDesiredK8SBetaApis() {
    return desiredK8SBetaApis_ == null
        ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
        : desiredK8SBetaApis_;
  }
  /**
   *
   *
   * <pre>
   * Beta APIs enabled for cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder getDesiredK8SBetaApisOrBuilder() {
    return desiredK8SBetaApis_ == null
        ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
        : desiredK8SBetaApis_;
  }

  public static final int DESIRED_HOST_MAINTENANCE_POLICY_FIELD_NUMBER = 132;
  private com.google.container.v1beta1.HostMaintenancePolicy desiredHostMaintenancePolicy_;
  /**
   *
   *
   * <pre>
   * HostMaintenancePolicy contains the desired maintenance policy for the
   * Google Compute Engine hosts.
   * </pre>
   *
   * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
   * </code>
   *
   * @return Whether the desiredHostMaintenancePolicy field is set.
   */
  @java.lang.Override
  public boolean hasDesiredHostMaintenancePolicy() {
    return ((bitField1_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * HostMaintenancePolicy contains the desired maintenance policy for the
   * Google Compute Engine hosts.
   * </pre>
   *
   * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
   * </code>
   *
   * @return The desiredHostMaintenancePolicy.
   */
  @java.lang.Override
  public com.google.container.v1beta1.HostMaintenancePolicy getDesiredHostMaintenancePolicy() {
    return desiredHostMaintenancePolicy_ == null
        ? com.google.container.v1beta1.HostMaintenancePolicy.getDefaultInstance()
        : desiredHostMaintenancePolicy_;
  }
  /**
   *
   *
   * <pre>
   * HostMaintenancePolicy contains the desired maintenance policy for the
   * Google Compute Engine hosts.
   * </pre>
   *
   * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.HostMaintenancePolicyOrBuilder
      getDesiredHostMaintenancePolicyOrBuilder() {
    return desiredHostMaintenancePolicy_ == null
        ? com.google.container.v1beta1.HostMaintenancePolicy.getDefaultInstance()
        : desiredHostMaintenancePolicy_;
  }

  public static final int DESIRED_CONTAINERD_CONFIG_FIELD_NUMBER = 134;
  private com.google.container.v1beta1.ContainerdConfig desiredContainerdConfig_;
  /**
   *
   *
   * <pre>
   * The desired containerd config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
   *
   * @return Whether the desiredContainerdConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredContainerdConfig() {
    return ((bitField1_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired containerd config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
   *
   * @return The desiredContainerdConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ContainerdConfig getDesiredContainerdConfig() {
    return desiredContainerdConfig_ == null
        ? com.google.container.v1beta1.ContainerdConfig.getDefaultInstance()
        : desiredContainerdConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired containerd config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ContainerdConfigOrBuilder
      getDesiredContainerdConfigOrBuilder() {
    return desiredContainerdConfig_ == null
        ? com.google.container.v1beta1.ContainerdConfig.getDefaultInstance()
        : desiredContainerdConfig_;
  }

  public static final int DESIRED_ENABLE_MULTI_NETWORKING_FIELD_NUMBER = 135;
  private boolean desiredEnableMultiNetworking_ = false;
  /**
   *
   *
   * <pre>
   * Enable/Disable Multi-Networking for the cluster
   * </pre>
   *
   * <code>optional bool desired_enable_multi_networking = 135;</code>
   *
   * @return Whether the desiredEnableMultiNetworking field is set.
   */
  @java.lang.Override
  public boolean hasDesiredEnableMultiNetworking() {
    return ((bitField1_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Multi-Networking for the cluster
   * </pre>
   *
   * <code>optional bool desired_enable_multi_networking = 135;</code>
   *
   * @return The desiredEnableMultiNetworking.
   */
  @java.lang.Override
  public boolean getDesiredEnableMultiNetworking() {
    return desiredEnableMultiNetworking_;
  }

  public static final int DESIRED_NODE_POOL_AUTO_CONFIG_RESOURCE_MANAGER_TAGS_FIELD_NUMBER = 136;
  private com.google.container.v1beta1.ResourceManagerTags
      desiredNodePoolAutoConfigResourceManagerTags_;
  /**
   *
   *
   * <pre>
   * The desired resource manager tags that apply to all auto-provisioned node
   * pools in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
   * </code>
   *
   * @return Whether the desiredNodePoolAutoConfigResourceManagerTags field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNodePoolAutoConfigResourceManagerTags() {
    return ((bitField1_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired resource manager tags that apply to all auto-provisioned node
   * pools in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
   * </code>
   *
   * @return The desiredNodePoolAutoConfigResourceManagerTags.
   */
  @java.lang.Override
  public com.google.container.v1beta1.ResourceManagerTags
      getDesiredNodePoolAutoConfigResourceManagerTags() {
    return desiredNodePoolAutoConfigResourceManagerTags_ == null
        ? com.google.container.v1beta1.ResourceManagerTags.getDefaultInstance()
        : desiredNodePoolAutoConfigResourceManagerTags_;
  }
  /**
   *
   *
   * <pre>
   * The desired resource manager tags that apply to all auto-provisioned node
   * pools in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.ResourceManagerTagsOrBuilder
      getDesiredNodePoolAutoConfigResourceManagerTagsOrBuilder() {
    return desiredNodePoolAutoConfigResourceManagerTags_ == null
        ? com.google.container.v1beta1.ResourceManagerTags.getDefaultInstance()
        : desiredNodePoolAutoConfigResourceManagerTags_;
  }

  public static final int DESIRED_IN_TRANSIT_ENCRYPTION_CONFIG_FIELD_NUMBER = 137;
  private int desiredInTransitEncryptionConfig_ = 0;
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * Now named inter-node transparent encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
   * </code>
   *
   * @return Whether the desiredInTransitEncryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredInTransitEncryptionConfig() {
    return ((bitField1_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * Now named inter-node transparent encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
   * </code>
   *
   * @return The enum numeric value on the wire for desiredInTransitEncryptionConfig.
   */
  @java.lang.Override
  public int getDesiredInTransitEncryptionConfigValue() {
    return desiredInTransitEncryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Specify the details of in-transit encryption.
   * Now named inter-node transparent encryption.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
   * </code>
   *
   * @return The desiredInTransitEncryptionConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.InTransitEncryptionConfig
      getDesiredInTransitEncryptionConfig() {
    com.google.container.v1beta1.InTransitEncryptionConfig result =
        com.google.container.v1beta1.InTransitEncryptionConfig.forNumber(
            desiredInTransitEncryptionConfig_);
    return result == null
        ? com.google.container.v1beta1.InTransitEncryptionConfig.UNRECOGNIZED
        : result;
  }

  public static final int DESIRED_ENABLE_CILIUM_CLUSTERWIDE_NETWORK_POLICY_FIELD_NUMBER = 138;
  private boolean desiredEnableCiliumClusterwideNetworkPolicy_ = false;
  /**
   *
   *
   * <pre>
   * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
   *
   * @return Whether the desiredEnableCiliumClusterwideNetworkPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDesiredEnableCiliumClusterwideNetworkPolicy() {
    return ((bitField1_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
   * </pre>
   *
   * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
   *
   * @return The desiredEnableCiliumClusterwideNetworkPolicy.
   */
  @java.lang.Override
  public boolean getDesiredEnableCiliumClusterwideNetworkPolicy() {
    return desiredEnableCiliumClusterwideNetworkPolicy_;
  }

  public static final int DESIRED_SECRET_MANAGER_CONFIG_FIELD_NUMBER = 139;
  private com.google.container.v1beta1.SecretManagerConfig desiredSecretManagerConfig_;
  /**
   *
   *
   * <pre>
   * Enable/Disable Secret Manager Config.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
   * </code>
   *
   * @return Whether the desiredSecretManagerConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredSecretManagerConfig() {
    return ((bitField1_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Secret Manager Config.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
   * </code>
   *
   * @return The desiredSecretManagerConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.SecretManagerConfig getDesiredSecretManagerConfig() {
    return desiredSecretManagerConfig_ == null
        ? com.google.container.v1beta1.SecretManagerConfig.getDefaultInstance()
        : desiredSecretManagerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Enable/Disable Secret Manager Config.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.SecretManagerConfigOrBuilder
      getDesiredSecretManagerConfigOrBuilder() {
    return desiredSecretManagerConfig_ == null
        ? com.google.container.v1beta1.SecretManagerConfig.getDefaultInstance()
        : desiredSecretManagerConfig_;
  }

  public static final int DESIRED_NODE_KUBELET_CONFIG_FIELD_NUMBER = 141;
  private com.google.container.v1beta1.NodeKubeletConfig desiredNodeKubeletConfig_;
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
   *
   * @return Whether the desiredNodeKubeletConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNodeKubeletConfig() {
    return ((bitField1_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
   *
   * @return The desiredNodeKubeletConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeKubeletConfig getDesiredNodeKubeletConfig() {
    return desiredNodeKubeletConfig_ == null
        ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
        : desiredNodeKubeletConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for the cluster.
   * </pre>
   *
   * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeKubeletConfigOrBuilder
      getDesiredNodeKubeletConfigOrBuilder() {
    return desiredNodeKubeletConfig_ == null
        ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
        : desiredNodeKubeletConfig_;
  }

  public static final int DESIRED_NODE_POOL_AUTO_CONFIG_KUBELET_CONFIG_FIELD_NUMBER = 142;
  private com.google.container.v1beta1.NodeKubeletConfig desiredNodePoolAutoConfigKubeletConfig_;
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
   * </code>
   *
   * @return Whether the desiredNodePoolAutoConfigKubeletConfig field is set.
   */
  @java.lang.Override
  public boolean hasDesiredNodePoolAutoConfigKubeletConfig() {
    return ((bitField1_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
   * </code>
   *
   * @return The desiredNodePoolAutoConfigKubeletConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeKubeletConfig
      getDesiredNodePoolAutoConfigKubeletConfig() {
    return desiredNodePoolAutoConfigKubeletConfig_ == null
        ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
        : desiredNodePoolAutoConfigKubeletConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired node kubelet config for all auto-provisioned node pools
   * in autopilot clusters and node auto-provisioning enabled clusters.
   * </pre>
   *
   * <code>
   * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeKubeletConfigOrBuilder
      getDesiredNodePoolAutoConfigKubeletConfigOrBuilder() {
    return desiredNodePoolAutoConfigKubeletConfig_ == null
        ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
        : desiredNodePoolAutoConfigKubeletConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredNodeVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, desiredNodeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredMonitoringService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, desiredMonitoringService_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getDesiredAddonsConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredNodePoolId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, desiredNodePoolId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredImageType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, desiredImageType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getDesiredNodePoolAutoscaling());
    }
    for (int i = 0; i < desiredLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, desiredLocations_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getDesiredMasterAuthorizedNetworksConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getDesiredPodSecurityPolicyConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(15, getDesiredClusterAutoscaling());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(16, getDesiredBinaryAuthorization());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredLoggingService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, desiredLoggingService_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(21, getDesiredResourceUsageExportConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(22, getDesiredVerticalPodAutoscaling());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(25, getDesiredPrivateClusterConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(26, getDesiredIntraNodeVisibilityConfig());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(28, getDesiredDefaultSnatStatus());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(30, getDesiredClusterTelemetry());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(31, getDesiredReleaseChannel());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(37, getPrivateClusterConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(38, getDesiredTpuConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(39, getDesiredL4IlbSubsettingConfig());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      output.writeMessage(46, getDesiredDatabaseEncryption());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeMessage(47, getDesiredWorkloadIdentityConfig());
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      output.writeMessage(48, getDesiredShieldedNodes());
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      output.writeMessage(49, getDesiredCostManagementConfig());
    }
    if (desiredDatapathProvider_
        != com.google.container.v1beta1.DatapathProvider.DATAPATH_PROVIDER_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(50, desiredDatapathProvider_);
    }
    if (desiredPrivateIpv6GoogleAccess_
        != com.google.container.v1beta1.PrivateIPv6GoogleAccess
            .PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(51, desiredPrivateIpv6GoogleAccess_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      output.writeMessage(52, getDesiredMaster());
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      output.writeMessage(53, getDesiredDnsConfig());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeMessage(55, getDesiredNotificationConfig());
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      output.writeMessage(60, getDesiredServiceExternalIpsConfig());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      output.writeMessage(61, getDesiredWorkloadCertificates());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      output.writeMessage(62, getDesiredWorkloadAltsConfig());
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      output.writeMessage(63, getDesiredAuthenticatorGroupsConfig());
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      output.writeMessage(64, getDesiredLoggingConfig());
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      output.writeMessage(65, getDesiredMonitoringConfig());
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      output.writeMessage(66, getDesiredIdentityServiceConfig());
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      output.writeMessage(67, getDesiredMeshCertificates());
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      output.writeBool(71, desiredEnablePrivateEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredMasterVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, desiredMasterVersion_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(109, getDesiredGcfsConfig());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      output.writeMessage(110, getDesiredNodePoolAutoConfigNetworkTags());
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      output.writeMessage(112, getDesiredProtectConfig());
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      output.writeMessage(114, getDesiredGatewayApiConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 115, etag_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      output.writeMessage(116, getDesiredNodePoolLoggingConfig());
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      output.writeMessage(117, getDesiredFleet());
    }
    if (desiredStackType_
        != com.google.container.v1beta1.StackType.STACK_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(119, desiredStackType_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      output.writeMessage(120, getAdditionalPodRangesConfig());
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      output.writeMessage(121, getRemovedAdditionalPodRangesConfig());
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      output.writeMessage(122, getEnableK8SBetaApis());
    }
    if (((bitField1_ & 0x00000200) != 0)) {
      output.writeMessage(124, getDesiredSecurityPostureConfig());
    }
    if (((bitField1_ & 0x00000400) != 0)) {
      output.writeMessage(125, getDesiredNetworkPerformanceConfig());
    }
    if (((bitField1_ & 0x00000800) != 0)) {
      output.writeBool(126, desiredEnableFqdnNetworkPolicy_);
    }
    if (((bitField1_ & 0x00001000) != 0)) {
      output.writeMessage(128, getDesiredAutopilotWorkloadPolicyConfig());
    }
    if (((bitField1_ & 0x00002000) != 0)) {
      output.writeMessage(131, getDesiredK8SBetaApis());
    }
    if (((bitField1_ & 0x00004000) != 0)) {
      output.writeMessage(132, getDesiredHostMaintenancePolicy());
    }
    if (((bitField1_ & 0x00008000) != 0)) {
      output.writeMessage(134, getDesiredContainerdConfig());
    }
    if (((bitField1_ & 0x00010000) != 0)) {
      output.writeBool(135, desiredEnableMultiNetworking_);
    }
    if (((bitField1_ & 0x00020000) != 0)) {
      output.writeMessage(136, getDesiredNodePoolAutoConfigResourceManagerTags());
    }
    if (((bitField1_ & 0x00040000) != 0)) {
      output.writeEnum(137, desiredInTransitEncryptionConfig_);
    }
    if (((bitField1_ & 0x00080000) != 0)) {
      output.writeBool(138, desiredEnableCiliumClusterwideNetworkPolicy_);
    }
    if (((bitField1_ & 0x00100000) != 0)) {
      output.writeMessage(139, getDesiredSecretManagerConfig());
    }
    if (((bitField1_ & 0x00200000) != 0)) {
      output.writeMessage(141, getDesiredNodeKubeletConfig());
    }
    if (((bitField1_ & 0x00400000) != 0)) {
      output.writeMessage(142, getDesiredNodePoolAutoConfigKubeletConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredNodeVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, desiredNodeVersion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredMonitoringService_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(5, desiredMonitoringService_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDesiredAddonsConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredNodePoolId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, desiredNodePoolId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredImageType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, desiredImageType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getDesiredNodePoolAutoscaling());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < desiredLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(desiredLocations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDesiredLocationsList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, getDesiredMasterAuthorizedNetworksConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, getDesiredPodSecurityPolicyConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, getDesiredClusterAutoscaling());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, getDesiredBinaryAuthorization());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredLoggingService_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, desiredLoggingService_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, getDesiredResourceUsageExportConfig());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, getDesiredVerticalPodAutoscaling());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25, getDesiredPrivateClusterConfig());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26, getDesiredIntraNodeVisibilityConfig());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, getDesiredDefaultSnatStatus());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              30, getDesiredClusterTelemetry());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(31, getDesiredReleaseChannel());
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(37, getPrivateClusterConfig());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getDesiredTpuConfig());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              39, getDesiredL4IlbSubsettingConfig());
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              46, getDesiredDatabaseEncryption());
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              47, getDesiredWorkloadIdentityConfig());
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(48, getDesiredShieldedNodes());
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              49, getDesiredCostManagementConfig());
    }
    if (desiredDatapathProvider_
        != com.google.container.v1beta1.DatapathProvider.DATAPATH_PROVIDER_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(50, desiredDatapathProvider_);
    }
    if (desiredPrivateIpv6GoogleAccess_
        != com.google.container.v1beta1.PrivateIPv6GoogleAccess
            .PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              51, desiredPrivateIpv6GoogleAccess_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(52, getDesiredMaster());
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(53, getDesiredDnsConfig());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              55, getDesiredNotificationConfig());
    }
    if (((bitField0_ & 0x08000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              60, getDesiredServiceExternalIpsConfig());
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              61, getDesiredWorkloadCertificates());
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              62, getDesiredWorkloadAltsConfig());
    }
    if (((bitField0_ & 0x10000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              63, getDesiredAuthenticatorGroupsConfig());
    }
    if (((bitField0_ & 0x20000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(64, getDesiredLoggingConfig());
    }
    if (((bitField0_ & 0x40000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              65, getDesiredMonitoringConfig());
    }
    if (((bitField0_ & 0x80000000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              66, getDesiredIdentityServiceConfig());
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              67, getDesiredMeshCertificates());
    }
    if (((bitField1_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(71, desiredEnablePrivateEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(desiredMasterVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, desiredMasterVersion_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(109, getDesiredGcfsConfig());
    }
    if (((bitField1_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              110, getDesiredNodePoolAutoConfigNetworkTags());
    }
    if (((bitField1_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(112, getDesiredProtectConfig());
    }
    if (((bitField1_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              114, getDesiredGatewayApiConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(115, etag_);
    }
    if (((bitField1_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              116, getDesiredNodePoolLoggingConfig());
    }
    if (((bitField1_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(117, getDesiredFleet());
    }
    if (desiredStackType_
        != com.google.container.v1beta1.StackType.STACK_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(119, desiredStackType_);
    }
    if (((bitField1_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              120, getAdditionalPodRangesConfig());
    }
    if (((bitField1_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              121, getRemovedAdditionalPodRangesConfig());
    }
    if (((bitField1_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(122, getEnableK8SBetaApis());
    }
    if (((bitField1_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              124, getDesiredSecurityPostureConfig());
    }
    if (((bitField1_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              125, getDesiredNetworkPerformanceConfig());
    }
    if (((bitField1_ & 0x00000800) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              126, desiredEnableFqdnNetworkPolicy_);
    }
    if (((bitField1_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              128, getDesiredAutopilotWorkloadPolicyConfig());
    }
    if (((bitField1_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(131, getDesiredK8SBetaApis());
    }
    if (((bitField1_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              132, getDesiredHostMaintenancePolicy());
    }
    if (((bitField1_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              134, getDesiredContainerdConfig());
    }
    if (((bitField1_ & 0x00010000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(135, desiredEnableMultiNetworking_);
    }
    if (((bitField1_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              136, getDesiredNodePoolAutoConfigResourceManagerTags());
    }
    if (((bitField1_ & 0x00040000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              137, desiredInTransitEncryptionConfig_);
    }
    if (((bitField1_ & 0x00080000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              138, desiredEnableCiliumClusterwideNetworkPolicy_);
    }
    if (((bitField1_ & 0x00100000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              139, getDesiredSecretManagerConfig());
    }
    if (((bitField1_ & 0x00200000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              141, getDesiredNodeKubeletConfig());
    }
    if (((bitField1_ & 0x00400000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              142, getDesiredNodePoolAutoConfigKubeletConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.ClusterUpdate)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.ClusterUpdate other =
        (com.google.container.v1beta1.ClusterUpdate) obj;

    if (!getDesiredNodeVersion().equals(other.getDesiredNodeVersion())) return false;
    if (!getDesiredMonitoringService().equals(other.getDesiredMonitoringService())) return false;
    if (hasDesiredAddonsConfig() != other.hasDesiredAddonsConfig()) return false;
    if (hasDesiredAddonsConfig()) {
      if (!getDesiredAddonsConfig().equals(other.getDesiredAddonsConfig())) return false;
    }
    if (!getDesiredNodePoolId().equals(other.getDesiredNodePoolId())) return false;
    if (!getDesiredImageType().equals(other.getDesiredImageType())) return false;
    if (hasDesiredNodePoolAutoscaling() != other.hasDesiredNodePoolAutoscaling()) return false;
    if (hasDesiredNodePoolAutoscaling()) {
      if (!getDesiredNodePoolAutoscaling().equals(other.getDesiredNodePoolAutoscaling()))
        return false;
    }
    if (!getDesiredLocationsList().equals(other.getDesiredLocationsList())) return false;
    if (hasDesiredMasterAuthorizedNetworksConfig()
        != other.hasDesiredMasterAuthorizedNetworksConfig()) return false;
    if (hasDesiredMasterAuthorizedNetworksConfig()) {
      if (!getDesiredMasterAuthorizedNetworksConfig()
          .equals(other.getDesiredMasterAuthorizedNetworksConfig())) return false;
    }
    if (hasDesiredPodSecurityPolicyConfig() != other.hasDesiredPodSecurityPolicyConfig())
      return false;
    if (hasDesiredPodSecurityPolicyConfig()) {
      if (!getDesiredPodSecurityPolicyConfig().equals(other.getDesiredPodSecurityPolicyConfig()))
        return false;
    }
    if (hasDesiredClusterAutoscaling() != other.hasDesiredClusterAutoscaling()) return false;
    if (hasDesiredClusterAutoscaling()) {
      if (!getDesiredClusterAutoscaling().equals(other.getDesiredClusterAutoscaling()))
        return false;
    }
    if (hasDesiredBinaryAuthorization() != other.hasDesiredBinaryAuthorization()) return false;
    if (hasDesiredBinaryAuthorization()) {
      if (!getDesiredBinaryAuthorization().equals(other.getDesiredBinaryAuthorization()))
        return false;
    }
    if (!getDesiredLoggingService().equals(other.getDesiredLoggingService())) return false;
    if (hasDesiredResourceUsageExportConfig() != other.hasDesiredResourceUsageExportConfig())
      return false;
    if (hasDesiredResourceUsageExportConfig()) {
      if (!getDesiredResourceUsageExportConfig()
          .equals(other.getDesiredResourceUsageExportConfig())) return false;
    }
    if (hasDesiredVerticalPodAutoscaling() != other.hasDesiredVerticalPodAutoscaling())
      return false;
    if (hasDesiredVerticalPodAutoscaling()) {
      if (!getDesiredVerticalPodAutoscaling().equals(other.getDesiredVerticalPodAutoscaling()))
        return false;
    }
    if (hasDesiredPrivateClusterConfig() != other.hasDesiredPrivateClusterConfig()) return false;
    if (hasDesiredPrivateClusterConfig()) {
      if (!getDesiredPrivateClusterConfig().equals(other.getDesiredPrivateClusterConfig()))
        return false;
    }
    if (hasDesiredIntraNodeVisibilityConfig() != other.hasDesiredIntraNodeVisibilityConfig())
      return false;
    if (hasDesiredIntraNodeVisibilityConfig()) {
      if (!getDesiredIntraNodeVisibilityConfig()
          .equals(other.getDesiredIntraNodeVisibilityConfig())) return false;
    }
    if (hasDesiredDefaultSnatStatus() != other.hasDesiredDefaultSnatStatus()) return false;
    if (hasDesiredDefaultSnatStatus()) {
      if (!getDesiredDefaultSnatStatus().equals(other.getDesiredDefaultSnatStatus())) return false;
    }
    if (hasDesiredClusterTelemetry() != other.hasDesiredClusterTelemetry()) return false;
    if (hasDesiredClusterTelemetry()) {
      if (!getDesiredClusterTelemetry().equals(other.getDesiredClusterTelemetry())) return false;
    }
    if (hasDesiredReleaseChannel() != other.hasDesiredReleaseChannel()) return false;
    if (hasDesiredReleaseChannel()) {
      if (!getDesiredReleaseChannel().equals(other.getDesiredReleaseChannel())) return false;
    }
    if (hasPrivateClusterConfig() != other.hasPrivateClusterConfig()) return false;
    if (hasPrivateClusterConfig()) {
      if (!getPrivateClusterConfig().equals(other.getPrivateClusterConfig())) return false;
    }
    if (hasDesiredTpuConfig() != other.hasDesiredTpuConfig()) return false;
    if (hasDesiredTpuConfig()) {
      if (!getDesiredTpuConfig().equals(other.getDesiredTpuConfig())) return false;
    }
    if (hasDesiredL4IlbSubsettingConfig() != other.hasDesiredL4IlbSubsettingConfig()) return false;
    if (hasDesiredL4IlbSubsettingConfig()) {
      if (!getDesiredL4IlbSubsettingConfig().equals(other.getDesiredL4IlbSubsettingConfig()))
        return false;
    }
    if (desiredDatapathProvider_ != other.desiredDatapathProvider_) return false;
    if (desiredPrivateIpv6GoogleAccess_ != other.desiredPrivateIpv6GoogleAccess_) return false;
    if (hasDesiredNotificationConfig() != other.hasDesiredNotificationConfig()) return false;
    if (hasDesiredNotificationConfig()) {
      if (!getDesiredNotificationConfig().equals(other.getDesiredNotificationConfig()))
        return false;
    }
    if (!getDesiredMasterVersion().equals(other.getDesiredMasterVersion())) return false;
    if (hasDesiredGcfsConfig() != other.hasDesiredGcfsConfig()) return false;
    if (hasDesiredGcfsConfig()) {
      if (!getDesiredGcfsConfig().equals(other.getDesiredGcfsConfig())) return false;
    }
    if (hasDesiredDatabaseEncryption() != other.hasDesiredDatabaseEncryption()) return false;
    if (hasDesiredDatabaseEncryption()) {
      if (!getDesiredDatabaseEncryption().equals(other.getDesiredDatabaseEncryption()))
        return false;
    }
    if (hasDesiredWorkloadIdentityConfig() != other.hasDesiredWorkloadIdentityConfig())
      return false;
    if (hasDesiredWorkloadIdentityConfig()) {
      if (!getDesiredWorkloadIdentityConfig().equals(other.getDesiredWorkloadIdentityConfig()))
        return false;
    }
    if (hasDesiredWorkloadCertificates() != other.hasDesiredWorkloadCertificates()) return false;
    if (hasDesiredWorkloadCertificates()) {
      if (!getDesiredWorkloadCertificates().equals(other.getDesiredWorkloadCertificates()))
        return false;
    }
    if (hasDesiredMeshCertificates() != other.hasDesiredMeshCertificates()) return false;
    if (hasDesiredMeshCertificates()) {
      if (!getDesiredMeshCertificates().equals(other.getDesiredMeshCertificates())) return false;
    }
    if (hasDesiredWorkloadAltsConfig() != other.hasDesiredWorkloadAltsConfig()) return false;
    if (hasDesiredWorkloadAltsConfig()) {
      if (!getDesiredWorkloadAltsConfig().equals(other.getDesiredWorkloadAltsConfig()))
        return false;
    }
    if (hasDesiredShieldedNodes() != other.hasDesiredShieldedNodes()) return false;
    if (hasDesiredShieldedNodes()) {
      if (!getDesiredShieldedNodes().equals(other.getDesiredShieldedNodes())) return false;
    }
    if (hasDesiredCostManagementConfig() != other.hasDesiredCostManagementConfig()) return false;
    if (hasDesiredCostManagementConfig()) {
      if (!getDesiredCostManagementConfig().equals(other.getDesiredCostManagementConfig()))
        return false;
    }
    if (hasDesiredMaster() != other.hasDesiredMaster()) return false;
    if (hasDesiredMaster()) {
      if (!getDesiredMaster().equals(other.getDesiredMaster())) return false;
    }
    if (hasDesiredDnsConfig() != other.hasDesiredDnsConfig()) return false;
    if (hasDesiredDnsConfig()) {
      if (!getDesiredDnsConfig().equals(other.getDesiredDnsConfig())) return false;
    }
    if (hasDesiredServiceExternalIpsConfig() != other.hasDesiredServiceExternalIpsConfig())
      return false;
    if (hasDesiredServiceExternalIpsConfig()) {
      if (!getDesiredServiceExternalIpsConfig().equals(other.getDesiredServiceExternalIpsConfig()))
        return false;
    }
    if (hasDesiredAuthenticatorGroupsConfig() != other.hasDesiredAuthenticatorGroupsConfig())
      return false;
    if (hasDesiredAuthenticatorGroupsConfig()) {
      if (!getDesiredAuthenticatorGroupsConfig()
          .equals(other.getDesiredAuthenticatorGroupsConfig())) return false;
    }
    if (hasDesiredLoggingConfig() != other.hasDesiredLoggingConfig()) return false;
    if (hasDesiredLoggingConfig()) {
      if (!getDesiredLoggingConfig().equals(other.getDesiredLoggingConfig())) return false;
    }
    if (hasDesiredMonitoringConfig() != other.hasDesiredMonitoringConfig()) return false;
    if (hasDesiredMonitoringConfig()) {
      if (!getDesiredMonitoringConfig().equals(other.getDesiredMonitoringConfig())) return false;
    }
    if (hasDesiredIdentityServiceConfig() != other.hasDesiredIdentityServiceConfig()) return false;
    if (hasDesiredIdentityServiceConfig()) {
      if (!getDesiredIdentityServiceConfig().equals(other.getDesiredIdentityServiceConfig()))
        return false;
    }
    if (hasDesiredEnablePrivateEndpoint() != other.hasDesiredEnablePrivateEndpoint()) return false;
    if (hasDesiredEnablePrivateEndpoint()) {
      if (getDesiredEnablePrivateEndpoint() != other.getDesiredEnablePrivateEndpoint())
        return false;
    }
    if (hasDesiredNodePoolAutoConfigNetworkTags()
        != other.hasDesiredNodePoolAutoConfigNetworkTags()) return false;
    if (hasDesiredNodePoolAutoConfigNetworkTags()) {
      if (!getDesiredNodePoolAutoConfigNetworkTags()
          .equals(other.getDesiredNodePoolAutoConfigNetworkTags())) return false;
    }
    if (hasDesiredProtectConfig() != other.hasDesiredProtectConfig()) return false;
    if (hasDesiredProtectConfig()) {
      if (!getDesiredProtectConfig().equals(other.getDesiredProtectConfig())) return false;
    }
    if (hasDesiredGatewayApiConfig() != other.hasDesiredGatewayApiConfig()) return false;
    if (hasDesiredGatewayApiConfig()) {
      if (!getDesiredGatewayApiConfig().equals(other.getDesiredGatewayApiConfig())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasDesiredNodePoolLoggingConfig() != other.hasDesiredNodePoolLoggingConfig()) return false;
    if (hasDesiredNodePoolLoggingConfig()) {
      if (!getDesiredNodePoolLoggingConfig().equals(other.getDesiredNodePoolLoggingConfig()))
        return false;
    }
    if (hasDesiredFleet() != other.hasDesiredFleet()) return false;
    if (hasDesiredFleet()) {
      if (!getDesiredFleet().equals(other.getDesiredFleet())) return false;
    }
    if (desiredStackType_ != other.desiredStackType_) return false;
    if (hasAdditionalPodRangesConfig() != other.hasAdditionalPodRangesConfig()) return false;
    if (hasAdditionalPodRangesConfig()) {
      if (!getAdditionalPodRangesConfig().equals(other.getAdditionalPodRangesConfig()))
        return false;
    }
    if (hasRemovedAdditionalPodRangesConfig() != other.hasRemovedAdditionalPodRangesConfig())
      return false;
    if (hasRemovedAdditionalPodRangesConfig()) {
      if (!getRemovedAdditionalPodRangesConfig()
          .equals(other.getRemovedAdditionalPodRangesConfig())) return false;
    }
    if (hasEnableK8SBetaApis() != other.hasEnableK8SBetaApis()) return false;
    if (hasEnableK8SBetaApis()) {
      if (!getEnableK8SBetaApis().equals(other.getEnableK8SBetaApis())) return false;
    }
    if (hasDesiredSecurityPostureConfig() != other.hasDesiredSecurityPostureConfig()) return false;
    if (hasDesiredSecurityPostureConfig()) {
      if (!getDesiredSecurityPostureConfig().equals(other.getDesiredSecurityPostureConfig()))
        return false;
    }
    if (hasDesiredNetworkPerformanceConfig() != other.hasDesiredNetworkPerformanceConfig())
      return false;
    if (hasDesiredNetworkPerformanceConfig()) {
      if (!getDesiredNetworkPerformanceConfig().equals(other.getDesiredNetworkPerformanceConfig()))
        return false;
    }
    if (hasDesiredEnableFqdnNetworkPolicy() != other.hasDesiredEnableFqdnNetworkPolicy())
      return false;
    if (hasDesiredEnableFqdnNetworkPolicy()) {
      if (getDesiredEnableFqdnNetworkPolicy() != other.getDesiredEnableFqdnNetworkPolicy())
        return false;
    }
    if (hasDesiredAutopilotWorkloadPolicyConfig()
        != other.hasDesiredAutopilotWorkloadPolicyConfig()) return false;
    if (hasDesiredAutopilotWorkloadPolicyConfig()) {
      if (!getDesiredAutopilotWorkloadPolicyConfig()
          .equals(other.getDesiredAutopilotWorkloadPolicyConfig())) return false;
    }
    if (hasDesiredK8SBetaApis() != other.hasDesiredK8SBetaApis()) return false;
    if (hasDesiredK8SBetaApis()) {
      if (!getDesiredK8SBetaApis().equals(other.getDesiredK8SBetaApis())) return false;
    }
    if (hasDesiredHostMaintenancePolicy() != other.hasDesiredHostMaintenancePolicy()) return false;
    if (hasDesiredHostMaintenancePolicy()) {
      if (!getDesiredHostMaintenancePolicy().equals(other.getDesiredHostMaintenancePolicy()))
        return false;
    }
    if (hasDesiredContainerdConfig() != other.hasDesiredContainerdConfig()) return false;
    if (hasDesiredContainerdConfig()) {
      if (!getDesiredContainerdConfig().equals(other.getDesiredContainerdConfig())) return false;
    }
    if (hasDesiredEnableMultiNetworking() != other.hasDesiredEnableMultiNetworking()) return false;
    if (hasDesiredEnableMultiNetworking()) {
      if (getDesiredEnableMultiNetworking() != other.getDesiredEnableMultiNetworking())
        return false;
    }
    if (hasDesiredNodePoolAutoConfigResourceManagerTags()
        != other.hasDesiredNodePoolAutoConfigResourceManagerTags()) return false;
    if (hasDesiredNodePoolAutoConfigResourceManagerTags()) {
      if (!getDesiredNodePoolAutoConfigResourceManagerTags()
          .equals(other.getDesiredNodePoolAutoConfigResourceManagerTags())) return false;
    }
    if (hasDesiredInTransitEncryptionConfig() != other.hasDesiredInTransitEncryptionConfig())
      return false;
    if (hasDesiredInTransitEncryptionConfig()) {
      if (desiredInTransitEncryptionConfig_ != other.desiredInTransitEncryptionConfig_)
        return false;
    }
    if (hasDesiredEnableCiliumClusterwideNetworkPolicy()
        != other.hasDesiredEnableCiliumClusterwideNetworkPolicy()) return false;
    if (hasDesiredEnableCiliumClusterwideNetworkPolicy()) {
      if (getDesiredEnableCiliumClusterwideNetworkPolicy()
          != other.getDesiredEnableCiliumClusterwideNetworkPolicy()) return false;
    }
    if (hasDesiredSecretManagerConfig() != other.hasDesiredSecretManagerConfig()) return false;
    if (hasDesiredSecretManagerConfig()) {
      if (!getDesiredSecretManagerConfig().equals(other.getDesiredSecretManagerConfig()))
        return false;
    }
    if (hasDesiredNodeKubeletConfig() != other.hasDesiredNodeKubeletConfig()) return false;
    if (hasDesiredNodeKubeletConfig()) {
      if (!getDesiredNodeKubeletConfig().equals(other.getDesiredNodeKubeletConfig())) return false;
    }
    if (hasDesiredNodePoolAutoConfigKubeletConfig()
        != other.hasDesiredNodePoolAutoConfigKubeletConfig()) return false;
    if (hasDesiredNodePoolAutoConfigKubeletConfig()) {
      if (!getDesiredNodePoolAutoConfigKubeletConfig()
          .equals(other.getDesiredNodePoolAutoConfigKubeletConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESIRED_NODE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getDesiredNodeVersion().hashCode();
    hash = (37 * hash) + DESIRED_MONITORING_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getDesiredMonitoringService().hashCode();
    if (hasDesiredAddonsConfig()) {
      hash = (37 * hash) + DESIRED_ADDONS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredAddonsConfig().hashCode();
    }
    hash = (37 * hash) + DESIRED_NODE_POOL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDesiredNodePoolId().hashCode();
    hash = (37 * hash) + DESIRED_IMAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDesiredImageType().hashCode();
    if (hasDesiredNodePoolAutoscaling()) {
      hash = (37 * hash) + DESIRED_NODE_POOL_AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNodePoolAutoscaling().hashCode();
    }
    if (getDesiredLocationsCount() > 0) {
      hash = (37 * hash) + DESIRED_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredLocationsList().hashCode();
    }
    if (hasDesiredMasterAuthorizedNetworksConfig()) {
      hash = (37 * hash) + DESIRED_MASTER_AUTHORIZED_NETWORKS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredMasterAuthorizedNetworksConfig().hashCode();
    }
    if (hasDesiredPodSecurityPolicyConfig()) {
      hash = (37 * hash) + DESIRED_POD_SECURITY_POLICY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredPodSecurityPolicyConfig().hashCode();
    }
    if (hasDesiredClusterAutoscaling()) {
      hash = (37 * hash) + DESIRED_CLUSTER_AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredClusterAutoscaling().hashCode();
    }
    if (hasDesiredBinaryAuthorization()) {
      hash = (37 * hash) + DESIRED_BINARY_AUTHORIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredBinaryAuthorization().hashCode();
    }
    hash = (37 * hash) + DESIRED_LOGGING_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getDesiredLoggingService().hashCode();
    if (hasDesiredResourceUsageExportConfig()) {
      hash = (37 * hash) + DESIRED_RESOURCE_USAGE_EXPORT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredResourceUsageExportConfig().hashCode();
    }
    if (hasDesiredVerticalPodAutoscaling()) {
      hash = (37 * hash) + DESIRED_VERTICAL_POD_AUTOSCALING_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredVerticalPodAutoscaling().hashCode();
    }
    if (hasDesiredPrivateClusterConfig()) {
      hash = (37 * hash) + DESIRED_PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredPrivateClusterConfig().hashCode();
    }
    if (hasDesiredIntraNodeVisibilityConfig()) {
      hash = (37 * hash) + DESIRED_INTRA_NODE_VISIBILITY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredIntraNodeVisibilityConfig().hashCode();
    }
    if (hasDesiredDefaultSnatStatus()) {
      hash = (37 * hash) + DESIRED_DEFAULT_SNAT_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredDefaultSnatStatus().hashCode();
    }
    if (hasDesiredClusterTelemetry()) {
      hash = (37 * hash) + DESIRED_CLUSTER_TELEMETRY_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredClusterTelemetry().hashCode();
    }
    if (hasDesiredReleaseChannel()) {
      hash = (37 * hash) + DESIRED_RELEASE_CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredReleaseChannel().hashCode();
    }
    if (hasPrivateClusterConfig()) {
      hash = (37 * hash) + PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateClusterConfig().hashCode();
    }
    if (hasDesiredTpuConfig()) {
      hash = (37 * hash) + DESIRED_TPU_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredTpuConfig().hashCode();
    }
    if (hasDesiredL4IlbSubsettingConfig()) {
      hash = (37 * hash) + DESIRED_L4ILB_SUBSETTING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredL4IlbSubsettingConfig().hashCode();
    }
    hash = (37 * hash) + DESIRED_DATAPATH_PROVIDER_FIELD_NUMBER;
    hash = (53 * hash) + desiredDatapathProvider_;
    hash = (37 * hash) + DESIRED_PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + desiredPrivateIpv6GoogleAccess_;
    if (hasDesiredNotificationConfig()) {
      hash = (37 * hash) + DESIRED_NOTIFICATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNotificationConfig().hashCode();
    }
    hash = (37 * hash) + DESIRED_MASTER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getDesiredMasterVersion().hashCode();
    if (hasDesiredGcfsConfig()) {
      hash = (37 * hash) + DESIRED_GCFS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredGcfsConfig().hashCode();
    }
    if (hasDesiredDatabaseEncryption()) {
      hash = (37 * hash) + DESIRED_DATABASE_ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredDatabaseEncryption().hashCode();
    }
    if (hasDesiredWorkloadIdentityConfig()) {
      hash = (37 * hash) + DESIRED_WORKLOAD_IDENTITY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredWorkloadIdentityConfig().hashCode();
    }
    if (hasDesiredWorkloadCertificates()) {
      hash = (37 * hash) + DESIRED_WORKLOAD_CERTIFICATES_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredWorkloadCertificates().hashCode();
    }
    if (hasDesiredMeshCertificates()) {
      hash = (37 * hash) + DESIRED_MESH_CERTIFICATES_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredMeshCertificates().hashCode();
    }
    if (hasDesiredWorkloadAltsConfig()) {
      hash = (37 * hash) + DESIRED_WORKLOAD_ALTS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredWorkloadAltsConfig().hashCode();
    }
    if (hasDesiredShieldedNodes()) {
      hash = (37 * hash) + DESIRED_SHIELDED_NODES_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredShieldedNodes().hashCode();
    }
    if (hasDesiredCostManagementConfig()) {
      hash = (37 * hash) + DESIRED_COST_MANAGEMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredCostManagementConfig().hashCode();
    }
    if (hasDesiredMaster()) {
      hash = (37 * hash) + DESIRED_MASTER_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredMaster().hashCode();
    }
    if (hasDesiredDnsConfig()) {
      hash = (37 * hash) + DESIRED_DNS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredDnsConfig().hashCode();
    }
    if (hasDesiredServiceExternalIpsConfig()) {
      hash = (37 * hash) + DESIRED_SERVICE_EXTERNAL_IPS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredServiceExternalIpsConfig().hashCode();
    }
    if (hasDesiredAuthenticatorGroupsConfig()) {
      hash = (37 * hash) + DESIRED_AUTHENTICATOR_GROUPS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredAuthenticatorGroupsConfig().hashCode();
    }
    if (hasDesiredLoggingConfig()) {
      hash = (37 * hash) + DESIRED_LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredLoggingConfig().hashCode();
    }
    if (hasDesiredMonitoringConfig()) {
      hash = (37 * hash) + DESIRED_MONITORING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredMonitoringConfig().hashCode();
    }
    if (hasDesiredIdentityServiceConfig()) {
      hash = (37 * hash) + DESIRED_IDENTITY_SERVICE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredIdentityServiceConfig().hashCode();
    }
    if (hasDesiredEnablePrivateEndpoint()) {
      hash = (37 * hash) + DESIRED_ENABLE_PRIVATE_ENDPOINT_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDesiredEnablePrivateEndpoint());
    }
    if (hasDesiredNodePoolAutoConfigNetworkTags()) {
      hash = (37 * hash) + DESIRED_NODE_POOL_AUTO_CONFIG_NETWORK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNodePoolAutoConfigNetworkTags().hashCode();
    }
    if (hasDesiredProtectConfig()) {
      hash = (37 * hash) + DESIRED_PROTECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredProtectConfig().hashCode();
    }
    if (hasDesiredGatewayApiConfig()) {
      hash = (37 * hash) + DESIRED_GATEWAY_API_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredGatewayApiConfig().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasDesiredNodePoolLoggingConfig()) {
      hash = (37 * hash) + DESIRED_NODE_POOL_LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNodePoolLoggingConfig().hashCode();
    }
    if (hasDesiredFleet()) {
      hash = (37 * hash) + DESIRED_FLEET_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredFleet().hashCode();
    }
    hash = (37 * hash) + DESIRED_STACK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + desiredStackType_;
    if (hasAdditionalPodRangesConfig()) {
      hash = (37 * hash) + ADDITIONAL_POD_RANGES_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalPodRangesConfig().hashCode();
    }
    if (hasRemovedAdditionalPodRangesConfig()) {
      hash = (37 * hash) + REMOVED_ADDITIONAL_POD_RANGES_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRemovedAdditionalPodRangesConfig().hashCode();
    }
    if (hasEnableK8SBetaApis()) {
      hash = (37 * hash) + ENABLE_K8S_BETA_APIS_FIELD_NUMBER;
      hash = (53 * hash) + getEnableK8SBetaApis().hashCode();
    }
    if (hasDesiredSecurityPostureConfig()) {
      hash = (37 * hash) + DESIRED_SECURITY_POSTURE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredSecurityPostureConfig().hashCode();
    }
    if (hasDesiredNetworkPerformanceConfig()) {
      hash = (37 * hash) + DESIRED_NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNetworkPerformanceConfig().hashCode();
    }
    if (hasDesiredEnableFqdnNetworkPolicy()) {
      hash = (37 * hash) + DESIRED_ENABLE_FQDN_NETWORK_POLICY_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getDesiredEnableFqdnNetworkPolicy());
    }
    if (hasDesiredAutopilotWorkloadPolicyConfig()) {
      hash = (37 * hash) + DESIRED_AUTOPILOT_WORKLOAD_POLICY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredAutopilotWorkloadPolicyConfig().hashCode();
    }
    if (hasDesiredK8SBetaApis()) {
      hash = (37 * hash) + DESIRED_K8S_BETA_APIS_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredK8SBetaApis().hashCode();
    }
    if (hasDesiredHostMaintenancePolicy()) {
      hash = (37 * hash) + DESIRED_HOST_MAINTENANCE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredHostMaintenancePolicy().hashCode();
    }
    if (hasDesiredContainerdConfig()) {
      hash = (37 * hash) + DESIRED_CONTAINERD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredContainerdConfig().hashCode();
    }
    if (hasDesiredEnableMultiNetworking()) {
      hash = (37 * hash) + DESIRED_ENABLE_MULTI_NETWORKING_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDesiredEnableMultiNetworking());
    }
    if (hasDesiredNodePoolAutoConfigResourceManagerTags()) {
      hash = (37 * hash) + DESIRED_NODE_POOL_AUTO_CONFIG_RESOURCE_MANAGER_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNodePoolAutoConfigResourceManagerTags().hashCode();
    }
    if (hasDesiredInTransitEncryptionConfig()) {
      hash = (37 * hash) + DESIRED_IN_TRANSIT_ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + desiredInTransitEncryptionConfig_;
    }
    if (hasDesiredEnableCiliumClusterwideNetworkPolicy()) {
      hash = (37 * hash) + DESIRED_ENABLE_CILIUM_CLUSTERWIDE_NETWORK_POLICY_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(
                  getDesiredEnableCiliumClusterwideNetworkPolicy());
    }
    if (hasDesiredSecretManagerConfig()) {
      hash = (37 * hash) + DESIRED_SECRET_MANAGER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredSecretManagerConfig().hashCode();
    }
    if (hasDesiredNodeKubeletConfig()) {
      hash = (37 * hash) + DESIRED_NODE_KUBELET_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNodeKubeletConfig().hashCode();
    }
    if (hasDesiredNodePoolAutoConfigKubeletConfig()) {
      hash = (37 * hash) + DESIRED_NODE_POOL_AUTO_CONFIG_KUBELET_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDesiredNodePoolAutoConfigKubeletConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.ClusterUpdate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.ClusterUpdate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ClusterUpdate describes an update to the cluster. Exactly one update can
   * be applied to a cluster with each request, so at most one field can be
   * provided.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.ClusterUpdate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.ClusterUpdate)
      com.google.container.v1beta1.ClusterUpdateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ClusterUpdate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ClusterUpdate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.ClusterUpdate.class,
              com.google.container.v1beta1.ClusterUpdate.Builder.class);
    }

    // Construct using com.google.container.v1beta1.ClusterUpdate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDesiredAddonsConfigFieldBuilder();
        getDesiredNodePoolAutoscalingFieldBuilder();
        getDesiredMasterAuthorizedNetworksConfigFieldBuilder();
        getDesiredPodSecurityPolicyConfigFieldBuilder();
        getDesiredClusterAutoscalingFieldBuilder();
        getDesiredBinaryAuthorizationFieldBuilder();
        getDesiredResourceUsageExportConfigFieldBuilder();
        getDesiredVerticalPodAutoscalingFieldBuilder();
        getDesiredPrivateClusterConfigFieldBuilder();
        getDesiredIntraNodeVisibilityConfigFieldBuilder();
        getDesiredDefaultSnatStatusFieldBuilder();
        getDesiredClusterTelemetryFieldBuilder();
        getDesiredReleaseChannelFieldBuilder();
        getPrivateClusterConfigFieldBuilder();
        getDesiredTpuConfigFieldBuilder();
        getDesiredL4IlbSubsettingConfigFieldBuilder();
        getDesiredNotificationConfigFieldBuilder();
        getDesiredGcfsConfigFieldBuilder();
        getDesiredDatabaseEncryptionFieldBuilder();
        getDesiredWorkloadIdentityConfigFieldBuilder();
        getDesiredWorkloadCertificatesFieldBuilder();
        getDesiredMeshCertificatesFieldBuilder();
        getDesiredWorkloadAltsConfigFieldBuilder();
        getDesiredShieldedNodesFieldBuilder();
        getDesiredCostManagementConfigFieldBuilder();
        getDesiredMasterFieldBuilder();
        getDesiredDnsConfigFieldBuilder();
        getDesiredServiceExternalIpsConfigFieldBuilder();
        getDesiredAuthenticatorGroupsConfigFieldBuilder();
        getDesiredLoggingConfigFieldBuilder();
        getDesiredMonitoringConfigFieldBuilder();
        getDesiredIdentityServiceConfigFieldBuilder();
        getDesiredNodePoolAutoConfigNetworkTagsFieldBuilder();
        getDesiredProtectConfigFieldBuilder();
        getDesiredGatewayApiConfigFieldBuilder();
        getDesiredNodePoolLoggingConfigFieldBuilder();
        getDesiredFleetFieldBuilder();
        getAdditionalPodRangesConfigFieldBuilder();
        getRemovedAdditionalPodRangesConfigFieldBuilder();
        getEnableK8SBetaApisFieldBuilder();
        getDesiredSecurityPostureConfigFieldBuilder();
        getDesiredNetworkPerformanceConfigFieldBuilder();
        getDesiredAutopilotWorkloadPolicyConfigFieldBuilder();
        getDesiredK8SBetaApisFieldBuilder();
        getDesiredHostMaintenancePolicyFieldBuilder();
        getDesiredContainerdConfigFieldBuilder();
        getDesiredNodePoolAutoConfigResourceManagerTagsFieldBuilder();
        getDesiredSecretManagerConfigFieldBuilder();
        getDesiredNodeKubeletConfigFieldBuilder();
        getDesiredNodePoolAutoConfigKubeletConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      bitField2_ = 0;
      desiredNodeVersion_ = "";
      desiredMonitoringService_ = "";
      desiredAddonsConfig_ = null;
      if (desiredAddonsConfigBuilder_ != null) {
        desiredAddonsConfigBuilder_.dispose();
        desiredAddonsConfigBuilder_ = null;
      }
      desiredNodePoolId_ = "";
      desiredImageType_ = "";
      desiredNodePoolAutoscaling_ = null;
      if (desiredNodePoolAutoscalingBuilder_ != null) {
        desiredNodePoolAutoscalingBuilder_.dispose();
        desiredNodePoolAutoscalingBuilder_ = null;
      }
      desiredLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      desiredMasterAuthorizedNetworksConfig_ = null;
      if (desiredMasterAuthorizedNetworksConfigBuilder_ != null) {
        desiredMasterAuthorizedNetworksConfigBuilder_.dispose();
        desiredMasterAuthorizedNetworksConfigBuilder_ = null;
      }
      desiredPodSecurityPolicyConfig_ = null;
      if (desiredPodSecurityPolicyConfigBuilder_ != null) {
        desiredPodSecurityPolicyConfigBuilder_.dispose();
        desiredPodSecurityPolicyConfigBuilder_ = null;
      }
      desiredClusterAutoscaling_ = null;
      if (desiredClusterAutoscalingBuilder_ != null) {
        desiredClusterAutoscalingBuilder_.dispose();
        desiredClusterAutoscalingBuilder_ = null;
      }
      desiredBinaryAuthorization_ = null;
      if (desiredBinaryAuthorizationBuilder_ != null) {
        desiredBinaryAuthorizationBuilder_.dispose();
        desiredBinaryAuthorizationBuilder_ = null;
      }
      desiredLoggingService_ = "";
      desiredResourceUsageExportConfig_ = null;
      if (desiredResourceUsageExportConfigBuilder_ != null) {
        desiredResourceUsageExportConfigBuilder_.dispose();
        desiredResourceUsageExportConfigBuilder_ = null;
      }
      desiredVerticalPodAutoscaling_ = null;
      if (desiredVerticalPodAutoscalingBuilder_ != null) {
        desiredVerticalPodAutoscalingBuilder_.dispose();
        desiredVerticalPodAutoscalingBuilder_ = null;
      }
      desiredPrivateClusterConfig_ = null;
      if (desiredPrivateClusterConfigBuilder_ != null) {
        desiredPrivateClusterConfigBuilder_.dispose();
        desiredPrivateClusterConfigBuilder_ = null;
      }
      desiredIntraNodeVisibilityConfig_ = null;
      if (desiredIntraNodeVisibilityConfigBuilder_ != null) {
        desiredIntraNodeVisibilityConfigBuilder_.dispose();
        desiredIntraNodeVisibilityConfigBuilder_ = null;
      }
      desiredDefaultSnatStatus_ = null;
      if (desiredDefaultSnatStatusBuilder_ != null) {
        desiredDefaultSnatStatusBuilder_.dispose();
        desiredDefaultSnatStatusBuilder_ = null;
      }
      desiredClusterTelemetry_ = null;
      if (desiredClusterTelemetryBuilder_ != null) {
        desiredClusterTelemetryBuilder_.dispose();
        desiredClusterTelemetryBuilder_ = null;
      }
      desiredReleaseChannel_ = null;
      if (desiredReleaseChannelBuilder_ != null) {
        desiredReleaseChannelBuilder_.dispose();
        desiredReleaseChannelBuilder_ = null;
      }
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      desiredTpuConfig_ = null;
      if (desiredTpuConfigBuilder_ != null) {
        desiredTpuConfigBuilder_.dispose();
        desiredTpuConfigBuilder_ = null;
      }
      desiredL4IlbSubsettingConfig_ = null;
      if (desiredL4IlbSubsettingConfigBuilder_ != null) {
        desiredL4IlbSubsettingConfigBuilder_.dispose();
        desiredL4IlbSubsettingConfigBuilder_ = null;
      }
      desiredDatapathProvider_ = 0;
      desiredPrivateIpv6GoogleAccess_ = 0;
      desiredNotificationConfig_ = null;
      if (desiredNotificationConfigBuilder_ != null) {
        desiredNotificationConfigBuilder_.dispose();
        desiredNotificationConfigBuilder_ = null;
      }
      desiredMasterVersion_ = "";
      desiredGcfsConfig_ = null;
      if (desiredGcfsConfigBuilder_ != null) {
        desiredGcfsConfigBuilder_.dispose();
        desiredGcfsConfigBuilder_ = null;
      }
      desiredDatabaseEncryption_ = null;
      if (desiredDatabaseEncryptionBuilder_ != null) {
        desiredDatabaseEncryptionBuilder_.dispose();
        desiredDatabaseEncryptionBuilder_ = null;
      }
      desiredWorkloadIdentityConfig_ = null;
      if (desiredWorkloadIdentityConfigBuilder_ != null) {
        desiredWorkloadIdentityConfigBuilder_.dispose();
        desiredWorkloadIdentityConfigBuilder_ = null;
      }
      desiredWorkloadCertificates_ = null;
      if (desiredWorkloadCertificatesBuilder_ != null) {
        desiredWorkloadCertificatesBuilder_.dispose();
        desiredWorkloadCertificatesBuilder_ = null;
      }
      desiredMeshCertificates_ = null;
      if (desiredMeshCertificatesBuilder_ != null) {
        desiredMeshCertificatesBuilder_.dispose();
        desiredMeshCertificatesBuilder_ = null;
      }
      desiredWorkloadAltsConfig_ = null;
      if (desiredWorkloadAltsConfigBuilder_ != null) {
        desiredWorkloadAltsConfigBuilder_.dispose();
        desiredWorkloadAltsConfigBuilder_ = null;
      }
      desiredShieldedNodes_ = null;
      if (desiredShieldedNodesBuilder_ != null) {
        desiredShieldedNodesBuilder_.dispose();
        desiredShieldedNodesBuilder_ = null;
      }
      desiredCostManagementConfig_ = null;
      if (desiredCostManagementConfigBuilder_ != null) {
        desiredCostManagementConfigBuilder_.dispose();
        desiredCostManagementConfigBuilder_ = null;
      }
      desiredMaster_ = null;
      if (desiredMasterBuilder_ != null) {
        desiredMasterBuilder_.dispose();
        desiredMasterBuilder_ = null;
      }
      desiredDnsConfig_ = null;
      if (desiredDnsConfigBuilder_ != null) {
        desiredDnsConfigBuilder_.dispose();
        desiredDnsConfigBuilder_ = null;
      }
      desiredServiceExternalIpsConfig_ = null;
      if (desiredServiceExternalIpsConfigBuilder_ != null) {
        desiredServiceExternalIpsConfigBuilder_.dispose();
        desiredServiceExternalIpsConfigBuilder_ = null;
      }
      desiredAuthenticatorGroupsConfig_ = null;
      if (desiredAuthenticatorGroupsConfigBuilder_ != null) {
        desiredAuthenticatorGroupsConfigBuilder_.dispose();
        desiredAuthenticatorGroupsConfigBuilder_ = null;
      }
      desiredLoggingConfig_ = null;
      if (desiredLoggingConfigBuilder_ != null) {
        desiredLoggingConfigBuilder_.dispose();
        desiredLoggingConfigBuilder_ = null;
      }
      desiredMonitoringConfig_ = null;
      if (desiredMonitoringConfigBuilder_ != null) {
        desiredMonitoringConfigBuilder_.dispose();
        desiredMonitoringConfigBuilder_ = null;
      }
      desiredIdentityServiceConfig_ = null;
      if (desiredIdentityServiceConfigBuilder_ != null) {
        desiredIdentityServiceConfigBuilder_.dispose();
        desiredIdentityServiceConfigBuilder_ = null;
      }
      desiredEnablePrivateEndpoint_ = false;
      desiredNodePoolAutoConfigNetworkTags_ = null;
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ != null) {
        desiredNodePoolAutoConfigNetworkTagsBuilder_.dispose();
        desiredNodePoolAutoConfigNetworkTagsBuilder_ = null;
      }
      desiredProtectConfig_ = null;
      if (desiredProtectConfigBuilder_ != null) {
        desiredProtectConfigBuilder_.dispose();
        desiredProtectConfigBuilder_ = null;
      }
      desiredGatewayApiConfig_ = null;
      if (desiredGatewayApiConfigBuilder_ != null) {
        desiredGatewayApiConfigBuilder_.dispose();
        desiredGatewayApiConfigBuilder_ = null;
      }
      etag_ = "";
      desiredNodePoolLoggingConfig_ = null;
      if (desiredNodePoolLoggingConfigBuilder_ != null) {
        desiredNodePoolLoggingConfigBuilder_.dispose();
        desiredNodePoolLoggingConfigBuilder_ = null;
      }
      desiredFleet_ = null;
      if (desiredFleetBuilder_ != null) {
        desiredFleetBuilder_.dispose();
        desiredFleetBuilder_ = null;
      }
      desiredStackType_ = 0;
      additionalPodRangesConfig_ = null;
      if (additionalPodRangesConfigBuilder_ != null) {
        additionalPodRangesConfigBuilder_.dispose();
        additionalPodRangesConfigBuilder_ = null;
      }
      removedAdditionalPodRangesConfig_ = null;
      if (removedAdditionalPodRangesConfigBuilder_ != null) {
        removedAdditionalPodRangesConfigBuilder_.dispose();
        removedAdditionalPodRangesConfigBuilder_ = null;
      }
      enableK8SBetaApis_ = null;
      if (enableK8SBetaApisBuilder_ != null) {
        enableK8SBetaApisBuilder_.dispose();
        enableK8SBetaApisBuilder_ = null;
      }
      desiredSecurityPostureConfig_ = null;
      if (desiredSecurityPostureConfigBuilder_ != null) {
        desiredSecurityPostureConfigBuilder_.dispose();
        desiredSecurityPostureConfigBuilder_ = null;
      }
      desiredNetworkPerformanceConfig_ = null;
      if (desiredNetworkPerformanceConfigBuilder_ != null) {
        desiredNetworkPerformanceConfigBuilder_.dispose();
        desiredNetworkPerformanceConfigBuilder_ = null;
      }
      desiredEnableFqdnNetworkPolicy_ = false;
      desiredAutopilotWorkloadPolicyConfig_ = null;
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ != null) {
        desiredAutopilotWorkloadPolicyConfigBuilder_.dispose();
        desiredAutopilotWorkloadPolicyConfigBuilder_ = null;
      }
      desiredK8SBetaApis_ = null;
      if (desiredK8SBetaApisBuilder_ != null) {
        desiredK8SBetaApisBuilder_.dispose();
        desiredK8SBetaApisBuilder_ = null;
      }
      desiredHostMaintenancePolicy_ = null;
      if (desiredHostMaintenancePolicyBuilder_ != null) {
        desiredHostMaintenancePolicyBuilder_.dispose();
        desiredHostMaintenancePolicyBuilder_ = null;
      }
      desiredContainerdConfig_ = null;
      if (desiredContainerdConfigBuilder_ != null) {
        desiredContainerdConfigBuilder_.dispose();
        desiredContainerdConfigBuilder_ = null;
      }
      desiredEnableMultiNetworking_ = false;
      desiredNodePoolAutoConfigResourceManagerTags_ = null;
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ != null) {
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_.dispose();
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_ = null;
      }
      desiredInTransitEncryptionConfig_ = 0;
      desiredEnableCiliumClusterwideNetworkPolicy_ = false;
      desiredSecretManagerConfig_ = null;
      if (desiredSecretManagerConfigBuilder_ != null) {
        desiredSecretManagerConfigBuilder_.dispose();
        desiredSecretManagerConfigBuilder_ = null;
      }
      desiredNodeKubeletConfig_ = null;
      if (desiredNodeKubeletConfigBuilder_ != null) {
        desiredNodeKubeletConfigBuilder_.dispose();
        desiredNodeKubeletConfigBuilder_ = null;
      }
      desiredNodePoolAutoConfigKubeletConfig_ = null;
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ != null) {
        desiredNodePoolAutoConfigKubeletConfigBuilder_.dispose();
        desiredNodePoolAutoConfigKubeletConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_ClusterUpdate_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ClusterUpdate getDefaultInstanceForType() {
      return com.google.container.v1beta1.ClusterUpdate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.ClusterUpdate build() {
      com.google.container.v1beta1.ClusterUpdate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.ClusterUpdate buildPartial() {
      com.google.container.v1beta1.ClusterUpdate result =
          new com.google.container.v1beta1.ClusterUpdate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      if (bitField2_ != 0) {
        buildPartial2(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.ClusterUpdate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.desiredNodeVersion_ = desiredNodeVersion_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.desiredMonitoringService_ = desiredMonitoringService_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.desiredAddonsConfig_ =
            desiredAddonsConfigBuilder_ == null
                ? desiredAddonsConfig_
                : desiredAddonsConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.desiredNodePoolId_ = desiredNodePoolId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.desiredImageType_ = desiredImageType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.desiredNodePoolAutoscaling_ =
            desiredNodePoolAutoscalingBuilder_ == null
                ? desiredNodePoolAutoscaling_
                : desiredNodePoolAutoscalingBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        desiredLocations_.makeImmutable();
        result.desiredLocations_ = desiredLocations_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.desiredMasterAuthorizedNetworksConfig_ =
            desiredMasterAuthorizedNetworksConfigBuilder_ == null
                ? desiredMasterAuthorizedNetworksConfig_
                : desiredMasterAuthorizedNetworksConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.desiredPodSecurityPolicyConfig_ =
            desiredPodSecurityPolicyConfigBuilder_ == null
                ? desiredPodSecurityPolicyConfig_
                : desiredPodSecurityPolicyConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.desiredClusterAutoscaling_ =
            desiredClusterAutoscalingBuilder_ == null
                ? desiredClusterAutoscaling_
                : desiredClusterAutoscalingBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.desiredBinaryAuthorization_ =
            desiredBinaryAuthorizationBuilder_ == null
                ? desiredBinaryAuthorization_
                : desiredBinaryAuthorizationBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.desiredLoggingService_ = desiredLoggingService_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.desiredResourceUsageExportConfig_ =
            desiredResourceUsageExportConfigBuilder_ == null
                ? desiredResourceUsageExportConfig_
                : desiredResourceUsageExportConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.desiredVerticalPodAutoscaling_ =
            desiredVerticalPodAutoscalingBuilder_ == null
                ? desiredVerticalPodAutoscaling_
                : desiredVerticalPodAutoscalingBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.desiredPrivateClusterConfig_ =
            desiredPrivateClusterConfigBuilder_ == null
                ? desiredPrivateClusterConfig_
                : desiredPrivateClusterConfigBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.desiredIntraNodeVisibilityConfig_ =
            desiredIntraNodeVisibilityConfigBuilder_ == null
                ? desiredIntraNodeVisibilityConfig_
                : desiredIntraNodeVisibilityConfigBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.desiredDefaultSnatStatus_ =
            desiredDefaultSnatStatusBuilder_ == null
                ? desiredDefaultSnatStatus_
                : desiredDefaultSnatStatusBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.desiredClusterTelemetry_ =
            desiredClusterTelemetryBuilder_ == null
                ? desiredClusterTelemetry_
                : desiredClusterTelemetryBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.desiredReleaseChannel_ =
            desiredReleaseChannelBuilder_ == null
                ? desiredReleaseChannel_
                : desiredReleaseChannelBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.privateClusterConfig_ =
            privateClusterConfigBuilder_ == null
                ? privateClusterConfig_
                : privateClusterConfigBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.desiredTpuConfig_ =
            desiredTpuConfigBuilder_ == null ? desiredTpuConfig_ : desiredTpuConfigBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.desiredL4IlbSubsettingConfig_ =
            desiredL4IlbSubsettingConfigBuilder_ == null
                ? desiredL4IlbSubsettingConfig_
                : desiredL4IlbSubsettingConfigBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.desiredDatapathProvider_ = desiredDatapathProvider_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.desiredPrivateIpv6GoogleAccess_ = desiredPrivateIpv6GoogleAccess_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.desiredNotificationConfig_ =
            desiredNotificationConfigBuilder_ == null
                ? desiredNotificationConfig_
                : desiredNotificationConfigBuilder_.build();
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.desiredMasterVersion_ = desiredMasterVersion_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.desiredGcfsConfig_ =
            desiredGcfsConfigBuilder_ == null
                ? desiredGcfsConfig_
                : desiredGcfsConfigBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.desiredDatabaseEncryption_ =
            desiredDatabaseEncryptionBuilder_ == null
                ? desiredDatabaseEncryption_
                : desiredDatabaseEncryptionBuilder_.build();
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.desiredWorkloadIdentityConfig_ =
            desiredWorkloadIdentityConfigBuilder_ == null
                ? desiredWorkloadIdentityConfig_
                : desiredWorkloadIdentityConfigBuilder_.build();
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.desiredWorkloadCertificates_ =
            desiredWorkloadCertificatesBuilder_ == null
                ? desiredWorkloadCertificates_
                : desiredWorkloadCertificatesBuilder_.build();
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.desiredMeshCertificates_ =
            desiredMeshCertificatesBuilder_ == null
                ? desiredMeshCertificates_
                : desiredMeshCertificatesBuilder_.build();
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.desiredWorkloadAltsConfig_ =
            desiredWorkloadAltsConfigBuilder_ == null
                ? desiredWorkloadAltsConfig_
                : desiredWorkloadAltsConfigBuilder_.build();
        to_bitField0_ |= 0x00400000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.container.v1beta1.ClusterUpdate result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.desiredShieldedNodes_ =
            desiredShieldedNodesBuilder_ == null
                ? desiredShieldedNodes_
                : desiredShieldedNodesBuilder_.build();
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField1_ & 0x00000002) != 0)) {
        result.desiredCostManagementConfig_ =
            desiredCostManagementConfigBuilder_ == null
                ? desiredCostManagementConfig_
                : desiredCostManagementConfigBuilder_.build();
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField1_ & 0x00000004) != 0)) {
        result.desiredMaster_ =
            desiredMasterBuilder_ == null ? desiredMaster_ : desiredMasterBuilder_.build();
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField1_ & 0x00000008) != 0)) {
        result.desiredDnsConfig_ =
            desiredDnsConfigBuilder_ == null ? desiredDnsConfig_ : desiredDnsConfigBuilder_.build();
        to_bitField0_ |= 0x04000000;
      }
      if (((from_bitField1_ & 0x00000010) != 0)) {
        result.desiredServiceExternalIpsConfig_ =
            desiredServiceExternalIpsConfigBuilder_ == null
                ? desiredServiceExternalIpsConfig_
                : desiredServiceExternalIpsConfigBuilder_.build();
        to_bitField0_ |= 0x08000000;
      }
      if (((from_bitField1_ & 0x00000020) != 0)) {
        result.desiredAuthenticatorGroupsConfig_ =
            desiredAuthenticatorGroupsConfigBuilder_ == null
                ? desiredAuthenticatorGroupsConfig_
                : desiredAuthenticatorGroupsConfigBuilder_.build();
        to_bitField0_ |= 0x10000000;
      }
      if (((from_bitField1_ & 0x00000040) != 0)) {
        result.desiredLoggingConfig_ =
            desiredLoggingConfigBuilder_ == null
                ? desiredLoggingConfig_
                : desiredLoggingConfigBuilder_.build();
        to_bitField0_ |= 0x20000000;
      }
      if (((from_bitField1_ & 0x00000080) != 0)) {
        result.desiredMonitoringConfig_ =
            desiredMonitoringConfigBuilder_ == null
                ? desiredMonitoringConfig_
                : desiredMonitoringConfigBuilder_.build();
        to_bitField0_ |= 0x40000000;
      }
      if (((from_bitField1_ & 0x00000100) != 0)) {
        result.desiredIdentityServiceConfig_ =
            desiredIdentityServiceConfigBuilder_ == null
                ? desiredIdentityServiceConfig_
                : desiredIdentityServiceConfigBuilder_.build();
        to_bitField0_ |= 0x80000000;
      }
      int to_bitField1_ = 0;
      if (((from_bitField1_ & 0x00000200) != 0)) {
        result.desiredEnablePrivateEndpoint_ = desiredEnablePrivateEndpoint_;
        to_bitField1_ |= 0x00000001;
      }
      if (((from_bitField1_ & 0x00000400) != 0)) {
        result.desiredNodePoolAutoConfigNetworkTags_ =
            desiredNodePoolAutoConfigNetworkTagsBuilder_ == null
                ? desiredNodePoolAutoConfigNetworkTags_
                : desiredNodePoolAutoConfigNetworkTagsBuilder_.build();
        to_bitField1_ |= 0x00000002;
      }
      if (((from_bitField1_ & 0x00000800) != 0)) {
        result.desiredProtectConfig_ =
            desiredProtectConfigBuilder_ == null
                ? desiredProtectConfig_
                : desiredProtectConfigBuilder_.build();
        to_bitField1_ |= 0x00000004;
      }
      if (((from_bitField1_ & 0x00001000) != 0)) {
        result.desiredGatewayApiConfig_ =
            desiredGatewayApiConfigBuilder_ == null
                ? desiredGatewayApiConfig_
                : desiredGatewayApiConfigBuilder_.build();
        to_bitField1_ |= 0x00000008;
      }
      if (((from_bitField1_ & 0x00002000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField1_ & 0x00004000) != 0)) {
        result.desiredNodePoolLoggingConfig_ =
            desiredNodePoolLoggingConfigBuilder_ == null
                ? desiredNodePoolLoggingConfig_
                : desiredNodePoolLoggingConfigBuilder_.build();
        to_bitField1_ |= 0x00000010;
      }
      if (((from_bitField1_ & 0x00008000) != 0)) {
        result.desiredFleet_ =
            desiredFleetBuilder_ == null ? desiredFleet_ : desiredFleetBuilder_.build();
        to_bitField1_ |= 0x00000020;
      }
      if (((from_bitField1_ & 0x00010000) != 0)) {
        result.desiredStackType_ = desiredStackType_;
      }
      if (((from_bitField1_ & 0x00020000) != 0)) {
        result.additionalPodRangesConfig_ =
            additionalPodRangesConfigBuilder_ == null
                ? additionalPodRangesConfig_
                : additionalPodRangesConfigBuilder_.build();
        to_bitField1_ |= 0x00000040;
      }
      if (((from_bitField1_ & 0x00040000) != 0)) {
        result.removedAdditionalPodRangesConfig_ =
            removedAdditionalPodRangesConfigBuilder_ == null
                ? removedAdditionalPodRangesConfig_
                : removedAdditionalPodRangesConfigBuilder_.build();
        to_bitField1_ |= 0x00000080;
      }
      if (((from_bitField1_ & 0x00080000) != 0)) {
        result.enableK8SBetaApis_ =
            enableK8SBetaApisBuilder_ == null
                ? enableK8SBetaApis_
                : enableK8SBetaApisBuilder_.build();
        to_bitField1_ |= 0x00000100;
      }
      if (((from_bitField1_ & 0x00100000) != 0)) {
        result.desiredSecurityPostureConfig_ =
            desiredSecurityPostureConfigBuilder_ == null
                ? desiredSecurityPostureConfig_
                : desiredSecurityPostureConfigBuilder_.build();
        to_bitField1_ |= 0x00000200;
      }
      if (((from_bitField1_ & 0x00200000) != 0)) {
        result.desiredNetworkPerformanceConfig_ =
            desiredNetworkPerformanceConfigBuilder_ == null
                ? desiredNetworkPerformanceConfig_
                : desiredNetworkPerformanceConfigBuilder_.build();
        to_bitField1_ |= 0x00000400;
      }
      if (((from_bitField1_ & 0x00400000) != 0)) {
        result.desiredEnableFqdnNetworkPolicy_ = desiredEnableFqdnNetworkPolicy_;
        to_bitField1_ |= 0x00000800;
      }
      if (((from_bitField1_ & 0x00800000) != 0)) {
        result.desiredAutopilotWorkloadPolicyConfig_ =
            desiredAutopilotWorkloadPolicyConfigBuilder_ == null
                ? desiredAutopilotWorkloadPolicyConfig_
                : desiredAutopilotWorkloadPolicyConfigBuilder_.build();
        to_bitField1_ |= 0x00001000;
      }
      if (((from_bitField1_ & 0x01000000) != 0)) {
        result.desiredK8SBetaApis_ =
            desiredK8SBetaApisBuilder_ == null
                ? desiredK8SBetaApis_
                : desiredK8SBetaApisBuilder_.build();
        to_bitField1_ |= 0x00002000;
      }
      if (((from_bitField1_ & 0x02000000) != 0)) {
        result.desiredHostMaintenancePolicy_ =
            desiredHostMaintenancePolicyBuilder_ == null
                ? desiredHostMaintenancePolicy_
                : desiredHostMaintenancePolicyBuilder_.build();
        to_bitField1_ |= 0x00004000;
      }
      if (((from_bitField1_ & 0x04000000) != 0)) {
        result.desiredContainerdConfig_ =
            desiredContainerdConfigBuilder_ == null
                ? desiredContainerdConfig_
                : desiredContainerdConfigBuilder_.build();
        to_bitField1_ |= 0x00008000;
      }
      if (((from_bitField1_ & 0x08000000) != 0)) {
        result.desiredEnableMultiNetworking_ = desiredEnableMultiNetworking_;
        to_bitField1_ |= 0x00010000;
      }
      if (((from_bitField1_ & 0x10000000) != 0)) {
        result.desiredNodePoolAutoConfigResourceManagerTags_ =
            desiredNodePoolAutoConfigResourceManagerTagsBuilder_ == null
                ? desiredNodePoolAutoConfigResourceManagerTags_
                : desiredNodePoolAutoConfigResourceManagerTagsBuilder_.build();
        to_bitField1_ |= 0x00020000;
      }
      if (((from_bitField1_ & 0x20000000) != 0)) {
        result.desiredInTransitEncryptionConfig_ = desiredInTransitEncryptionConfig_;
        to_bitField1_ |= 0x00040000;
      }
      if (((from_bitField1_ & 0x40000000) != 0)) {
        result.desiredEnableCiliumClusterwideNetworkPolicy_ =
            desiredEnableCiliumClusterwideNetworkPolicy_;
        to_bitField1_ |= 0x00080000;
      }
      if (((from_bitField1_ & 0x80000000) != 0)) {
        result.desiredSecretManagerConfig_ =
            desiredSecretManagerConfigBuilder_ == null
                ? desiredSecretManagerConfig_
                : desiredSecretManagerConfigBuilder_.build();
        to_bitField1_ |= 0x00100000;
      }
      result.bitField0_ |= to_bitField0_;
      result.bitField1_ |= to_bitField1_;
    }

    private void buildPartial2(com.google.container.v1beta1.ClusterUpdate result) {
      int from_bitField2_ = bitField2_;
      int to_bitField1_ = 0;
      if (((from_bitField2_ & 0x00000001) != 0)) {
        result.desiredNodeKubeletConfig_ =
            desiredNodeKubeletConfigBuilder_ == null
                ? desiredNodeKubeletConfig_
                : desiredNodeKubeletConfigBuilder_.build();
        to_bitField1_ |= 0x00200000;
      }
      if (((from_bitField2_ & 0x00000002) != 0)) {
        result.desiredNodePoolAutoConfigKubeletConfig_ =
            desiredNodePoolAutoConfigKubeletConfigBuilder_ == null
                ? desiredNodePoolAutoConfigKubeletConfig_
                : desiredNodePoolAutoConfigKubeletConfigBuilder_.build();
        to_bitField1_ |= 0x00400000;
      }
      result.bitField1_ |= to_bitField1_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.ClusterUpdate) {
        return mergeFrom((com.google.container.v1beta1.ClusterUpdate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.ClusterUpdate other) {
      if (other == com.google.container.v1beta1.ClusterUpdate.getDefaultInstance()) return this;
      if (!other.getDesiredNodeVersion().isEmpty()) {
        desiredNodeVersion_ = other.desiredNodeVersion_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDesiredMonitoringService().isEmpty()) {
        desiredMonitoringService_ = other.desiredMonitoringService_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDesiredAddonsConfig()) {
        mergeDesiredAddonsConfig(other.getDesiredAddonsConfig());
      }
      if (!other.getDesiredNodePoolId().isEmpty()) {
        desiredNodePoolId_ = other.desiredNodePoolId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDesiredImageType().isEmpty()) {
        desiredImageType_ = other.desiredImageType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDesiredNodePoolAutoscaling()) {
        mergeDesiredNodePoolAutoscaling(other.getDesiredNodePoolAutoscaling());
      }
      if (!other.desiredLocations_.isEmpty()) {
        if (desiredLocations_.isEmpty()) {
          desiredLocations_ = other.desiredLocations_;
          bitField0_ |= 0x00000040;
        } else {
          ensureDesiredLocationsIsMutable();
          desiredLocations_.addAll(other.desiredLocations_);
        }
        onChanged();
      }
      if (other.hasDesiredMasterAuthorizedNetworksConfig()) {
        mergeDesiredMasterAuthorizedNetworksConfig(
            other.getDesiredMasterAuthorizedNetworksConfig());
      }
      if (other.hasDesiredPodSecurityPolicyConfig()) {
        mergeDesiredPodSecurityPolicyConfig(other.getDesiredPodSecurityPolicyConfig());
      }
      if (other.hasDesiredClusterAutoscaling()) {
        mergeDesiredClusterAutoscaling(other.getDesiredClusterAutoscaling());
      }
      if (other.hasDesiredBinaryAuthorization()) {
        mergeDesiredBinaryAuthorization(other.getDesiredBinaryAuthorization());
      }
      if (!other.getDesiredLoggingService().isEmpty()) {
        desiredLoggingService_ = other.desiredLoggingService_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasDesiredResourceUsageExportConfig()) {
        mergeDesiredResourceUsageExportConfig(other.getDesiredResourceUsageExportConfig());
      }
      if (other.hasDesiredVerticalPodAutoscaling()) {
        mergeDesiredVerticalPodAutoscaling(other.getDesiredVerticalPodAutoscaling());
      }
      if (other.hasDesiredPrivateClusterConfig()) {
        mergeDesiredPrivateClusterConfig(other.getDesiredPrivateClusterConfig());
      }
      if (other.hasDesiredIntraNodeVisibilityConfig()) {
        mergeDesiredIntraNodeVisibilityConfig(other.getDesiredIntraNodeVisibilityConfig());
      }
      if (other.hasDesiredDefaultSnatStatus()) {
        mergeDesiredDefaultSnatStatus(other.getDesiredDefaultSnatStatus());
      }
      if (other.hasDesiredClusterTelemetry()) {
        mergeDesiredClusterTelemetry(other.getDesiredClusterTelemetry());
      }
      if (other.hasDesiredReleaseChannel()) {
        mergeDesiredReleaseChannel(other.getDesiredReleaseChannel());
      }
      if (other.hasPrivateClusterConfig()) {
        mergePrivateClusterConfig(other.getPrivateClusterConfig());
      }
      if (other.hasDesiredTpuConfig()) {
        mergeDesiredTpuConfig(other.getDesiredTpuConfig());
      }
      if (other.hasDesiredL4IlbSubsettingConfig()) {
        mergeDesiredL4IlbSubsettingConfig(other.getDesiredL4IlbSubsettingConfig());
      }
      if (other.desiredDatapathProvider_ != 0) {
        setDesiredDatapathProviderValue(other.getDesiredDatapathProviderValue());
      }
      if (other.desiredPrivateIpv6GoogleAccess_ != 0) {
        setDesiredPrivateIpv6GoogleAccessValue(other.getDesiredPrivateIpv6GoogleAccessValue());
      }
      if (other.hasDesiredNotificationConfig()) {
        mergeDesiredNotificationConfig(other.getDesiredNotificationConfig());
      }
      if (!other.getDesiredMasterVersion().isEmpty()) {
        desiredMasterVersion_ = other.desiredMasterVersion_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (other.hasDesiredGcfsConfig()) {
        mergeDesiredGcfsConfig(other.getDesiredGcfsConfig());
      }
      if (other.hasDesiredDatabaseEncryption()) {
        mergeDesiredDatabaseEncryption(other.getDesiredDatabaseEncryption());
      }
      if (other.hasDesiredWorkloadIdentityConfig()) {
        mergeDesiredWorkloadIdentityConfig(other.getDesiredWorkloadIdentityConfig());
      }
      if (other.hasDesiredWorkloadCertificates()) {
        mergeDesiredWorkloadCertificates(other.getDesiredWorkloadCertificates());
      }
      if (other.hasDesiredMeshCertificates()) {
        mergeDesiredMeshCertificates(other.getDesiredMeshCertificates());
      }
      if (other.hasDesiredWorkloadAltsConfig()) {
        mergeDesiredWorkloadAltsConfig(other.getDesiredWorkloadAltsConfig());
      }
      if (other.hasDesiredShieldedNodes()) {
        mergeDesiredShieldedNodes(other.getDesiredShieldedNodes());
      }
      if (other.hasDesiredCostManagementConfig()) {
        mergeDesiredCostManagementConfig(other.getDesiredCostManagementConfig());
      }
      if (other.hasDesiredMaster()) {
        mergeDesiredMaster(other.getDesiredMaster());
      }
      if (other.hasDesiredDnsConfig()) {
        mergeDesiredDnsConfig(other.getDesiredDnsConfig());
      }
      if (other.hasDesiredServiceExternalIpsConfig()) {
        mergeDesiredServiceExternalIpsConfig(other.getDesiredServiceExternalIpsConfig());
      }
      if (other.hasDesiredAuthenticatorGroupsConfig()) {
        mergeDesiredAuthenticatorGroupsConfig(other.getDesiredAuthenticatorGroupsConfig());
      }
      if (other.hasDesiredLoggingConfig()) {
        mergeDesiredLoggingConfig(other.getDesiredLoggingConfig());
      }
      if (other.hasDesiredMonitoringConfig()) {
        mergeDesiredMonitoringConfig(other.getDesiredMonitoringConfig());
      }
      if (other.hasDesiredIdentityServiceConfig()) {
        mergeDesiredIdentityServiceConfig(other.getDesiredIdentityServiceConfig());
      }
      if (other.hasDesiredEnablePrivateEndpoint()) {
        setDesiredEnablePrivateEndpoint(other.getDesiredEnablePrivateEndpoint());
      }
      if (other.hasDesiredNodePoolAutoConfigNetworkTags()) {
        mergeDesiredNodePoolAutoConfigNetworkTags(other.getDesiredNodePoolAutoConfigNetworkTags());
      }
      if (other.hasDesiredProtectConfig()) {
        mergeDesiredProtectConfig(other.getDesiredProtectConfig());
      }
      if (other.hasDesiredGatewayApiConfig()) {
        mergeDesiredGatewayApiConfig(other.getDesiredGatewayApiConfig());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField1_ |= 0x00002000;
        onChanged();
      }
      if (other.hasDesiredNodePoolLoggingConfig()) {
        mergeDesiredNodePoolLoggingConfig(other.getDesiredNodePoolLoggingConfig());
      }
      if (other.hasDesiredFleet()) {
        mergeDesiredFleet(other.getDesiredFleet());
      }
      if (other.desiredStackType_ != 0) {
        setDesiredStackTypeValue(other.getDesiredStackTypeValue());
      }
      if (other.hasAdditionalPodRangesConfig()) {
        mergeAdditionalPodRangesConfig(other.getAdditionalPodRangesConfig());
      }
      if (other.hasRemovedAdditionalPodRangesConfig()) {
        mergeRemovedAdditionalPodRangesConfig(other.getRemovedAdditionalPodRangesConfig());
      }
      if (other.hasEnableK8SBetaApis()) {
        mergeEnableK8SBetaApis(other.getEnableK8SBetaApis());
      }
      if (other.hasDesiredSecurityPostureConfig()) {
        mergeDesiredSecurityPostureConfig(other.getDesiredSecurityPostureConfig());
      }
      if (other.hasDesiredNetworkPerformanceConfig()) {
        mergeDesiredNetworkPerformanceConfig(other.getDesiredNetworkPerformanceConfig());
      }
      if (other.hasDesiredEnableFqdnNetworkPolicy()) {
        setDesiredEnableFqdnNetworkPolicy(other.getDesiredEnableFqdnNetworkPolicy());
      }
      if (other.hasDesiredAutopilotWorkloadPolicyConfig()) {
        mergeDesiredAutopilotWorkloadPolicyConfig(other.getDesiredAutopilotWorkloadPolicyConfig());
      }
      if (other.hasDesiredK8SBetaApis()) {
        mergeDesiredK8SBetaApis(other.getDesiredK8SBetaApis());
      }
      if (other.hasDesiredHostMaintenancePolicy()) {
        mergeDesiredHostMaintenancePolicy(other.getDesiredHostMaintenancePolicy());
      }
      if (other.hasDesiredContainerdConfig()) {
        mergeDesiredContainerdConfig(other.getDesiredContainerdConfig());
      }
      if (other.hasDesiredEnableMultiNetworking()) {
        setDesiredEnableMultiNetworking(other.getDesiredEnableMultiNetworking());
      }
      if (other.hasDesiredNodePoolAutoConfigResourceManagerTags()) {
        mergeDesiredNodePoolAutoConfigResourceManagerTags(
            other.getDesiredNodePoolAutoConfigResourceManagerTags());
      }
      if (other.hasDesiredInTransitEncryptionConfig()) {
        setDesiredInTransitEncryptionConfig(other.getDesiredInTransitEncryptionConfig());
      }
      if (other.hasDesiredEnableCiliumClusterwideNetworkPolicy()) {
        setDesiredEnableCiliumClusterwideNetworkPolicy(
            other.getDesiredEnableCiliumClusterwideNetworkPolicy());
      }
      if (other.hasDesiredSecretManagerConfig()) {
        mergeDesiredSecretManagerConfig(other.getDesiredSecretManagerConfig());
      }
      if (other.hasDesiredNodeKubeletConfig()) {
        mergeDesiredNodeKubeletConfig(other.getDesiredNodeKubeletConfig());
      }
      if (other.hasDesiredNodePoolAutoConfigKubeletConfig()) {
        mergeDesiredNodePoolAutoConfigKubeletConfig(
            other.getDesiredNodePoolAutoConfigKubeletConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 34:
              {
                desiredNodeVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 34
            case 42:
              {
                desiredMonitoringService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDesiredAddonsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                desiredNodePoolId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                desiredImageType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getDesiredNodePoolAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDesiredLocationsIsMutable();
                desiredLocations_.add(s);
                break;
              } // case 82
            case 98:
              {
                input.readMessage(
                    getDesiredMasterAuthorizedNetworksConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 98
            case 114:
              {
                input.readMessage(
                    getDesiredPodSecurityPolicyConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getDesiredClusterAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(
                    getDesiredBinaryAuthorizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            case 154:
              {
                desiredLoggingService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 154
            case 170:
              {
                input.readMessage(
                    getDesiredResourceUsageExportConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getDesiredVerticalPodAutoscalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 178
            case 202:
              {
                input.readMessage(
                    getDesiredPrivateClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(
                    getDesiredIntraNodeVisibilityConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 210
            case 226:
              {
                input.readMessage(
                    getDesiredDefaultSnatStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 226
            case 242:
              {
                input.readMessage(
                    getDesiredClusterTelemetryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(
                    getDesiredReleaseChannelFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 250
            case 298:
              {
                input.readMessage(
                    getPrivateClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 298
            case 306:
              {
                input.readMessage(
                    getDesiredTpuConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 306
            case 314:
              {
                input.readMessage(
                    getDesiredL4IlbSubsettingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 314
            case 370:
              {
                input.readMessage(
                    getDesiredDatabaseEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 370
            case 378:
              {
                input.readMessage(
                    getDesiredWorkloadIdentityConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 378
            case 386:
              {
                input.readMessage(
                    getDesiredShieldedNodesFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000001;
                break;
              } // case 386
            case 394:
              {
                input.readMessage(
                    getDesiredCostManagementConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000002;
                break;
              } // case 394
            case 400:
              {
                desiredDatapathProvider_ = input.readEnum();
                bitField0_ |= 0x00400000;
                break;
              } // case 400
            case 408:
              {
                desiredPrivateIpv6GoogleAccess_ = input.readEnum();
                bitField0_ |= 0x00800000;
                break;
              } // case 408
            case 418:
              {
                input.readMessage(getDesiredMasterFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000004;
                break;
              } // case 418
            case 426:
              {
                input.readMessage(
                    getDesiredDnsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000008;
                break;
              } // case 426
            case 442:
              {
                input.readMessage(
                    getDesiredNotificationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 442
            case 482:
              {
                input.readMessage(
                    getDesiredServiceExternalIpsConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000010;
                break;
              } // case 482
            case 490:
              {
                input.readMessage(
                    getDesiredWorkloadCertificatesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 490
            case 498:
              {
                input.readMessage(
                    getDesiredWorkloadAltsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 498
            case 506:
              {
                input.readMessage(
                    getDesiredAuthenticatorGroupsConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000020;
                break;
              } // case 506
            case 514:
              {
                input.readMessage(
                    getDesiredLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000040;
                break;
              } // case 514
            case 522:
              {
                input.readMessage(
                    getDesiredMonitoringConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000080;
                break;
              } // case 522
            case 530:
              {
                input.readMessage(
                    getDesiredIdentityServiceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000100;
                break;
              } // case 530
            case 538:
              {
                input.readMessage(
                    getDesiredMeshCertificatesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 538
            case 568:
              {
                desiredEnablePrivateEndpoint_ = input.readBool();
                bitField1_ |= 0x00000200;
                break;
              } // case 568
            case 802:
              {
                desiredMasterVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 802
            case 874:
              {
                input.readMessage(
                    getDesiredGcfsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 874
            case 882:
              {
                input.readMessage(
                    getDesiredNodePoolAutoConfigNetworkTagsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00000400;
                break;
              } // case 882
            case 898:
              {
                input.readMessage(
                    getDesiredProtectConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000800;
                break;
              } // case 898
            case 914:
              {
                input.readMessage(
                    getDesiredGatewayApiConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00001000;
                break;
              } // case 914
            case 922:
              {
                etag_ = input.readStringRequireUtf8();
                bitField1_ |= 0x00002000;
                break;
              } // case 922
            case 930:
              {
                input.readMessage(
                    getDesiredNodePoolLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00004000;
                break;
              } // case 930
            case 938:
              {
                input.readMessage(getDesiredFleetFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00008000;
                break;
              } // case 938
            case 952:
              {
                desiredStackType_ = input.readEnum();
                bitField1_ |= 0x00010000;
                break;
              } // case 952
            case 962:
              {
                input.readMessage(
                    getAdditionalPodRangesConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00020000;
                break;
              } // case 962
            case 970:
              {
                input.readMessage(
                    getRemovedAdditionalPodRangesConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00040000;
                break;
              } // case 970
            case 978:
              {
                input.readMessage(
                    getEnableK8SBetaApisFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00080000;
                break;
              } // case 978
            case 994:
              {
                input.readMessage(
                    getDesiredSecurityPostureConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00100000;
                break;
              } // case 994
            case 1002:
              {
                input.readMessage(
                    getDesiredNetworkPerformanceConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00200000;
                break;
              } // case 1002
            case 1008:
              {
                desiredEnableFqdnNetworkPolicy_ = input.readBool();
                bitField1_ |= 0x00400000;
                break;
              } // case 1008
            case 1026:
              {
                input.readMessage(
                    getDesiredAutopilotWorkloadPolicyConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x00800000;
                break;
              } // case 1026
            case 1050:
              {
                input.readMessage(
                    getDesiredK8SBetaApisFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x01000000;
                break;
              } // case 1050
            case 1058:
              {
                input.readMessage(
                    getDesiredHostMaintenancePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x02000000;
                break;
              } // case 1058
            case 1074:
              {
                input.readMessage(
                    getDesiredContainerdConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x04000000;
                break;
              } // case 1074
            case 1080:
              {
                desiredEnableMultiNetworking_ = input.readBool();
                bitField1_ |= 0x08000000;
                break;
              } // case 1080
            case 1090:
              {
                input.readMessage(
                    getDesiredNodePoolAutoConfigResourceManagerTagsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField1_ |= 0x10000000;
                break;
              } // case 1090
            case 1096:
              {
                desiredInTransitEncryptionConfig_ = input.readEnum();
                bitField1_ |= 0x20000000;
                break;
              } // case 1096
            case 1104:
              {
                desiredEnableCiliumClusterwideNetworkPolicy_ = input.readBool();
                bitField1_ |= 0x40000000;
                break;
              } // case 1104
            case 1114:
              {
                input.readMessage(
                    getDesiredSecretManagerConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x80000000;
                break;
              } // case 1114
            case 1130:
              {
                input.readMessage(
                    getDesiredNodeKubeletConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField2_ |= 0x00000001;
                break;
              } // case 1130
            case 1138:
              {
                input.readMessage(
                    getDesiredNodePoolAutoConfigKubeletConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField2_ |= 0x00000002;
                break;
              } // case 1138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;
    private int bitField2_;

    private java.lang.Object desiredNodeVersion_ = "";
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string desired_node_version = 4;</code>
     *
     * @return The desiredNodeVersion.
     */
    public java.lang.String getDesiredNodeVersion() {
      java.lang.Object ref = desiredNodeVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        desiredNodeVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string desired_node_version = 4;</code>
     *
     * @return The bytes for desiredNodeVersion.
     */
    public com.google.protobuf.ByteString getDesiredNodeVersionBytes() {
      java.lang.Object ref = desiredNodeVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        desiredNodeVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string desired_node_version = 4;</code>
     *
     * @param value The desiredNodeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredNodeVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      desiredNodeVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string desired_node_version = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredNodeVersion() {
      desiredNodeVersion_ = getDefaultInstance().getDesiredNodeVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     * </pre>
     *
     * <code>string desired_node_version = 4;</code>
     *
     * @param value The bytes for desiredNodeVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredNodeVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      desiredNodeVersion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object desiredMonitoringService_ = "";
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_monitoring_service = 5;</code>
     *
     * @return The desiredMonitoringService.
     */
    public java.lang.String getDesiredMonitoringService() {
      java.lang.Object ref = desiredMonitoringService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        desiredMonitoringService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_monitoring_service = 5;</code>
     *
     * @return The bytes for desiredMonitoringService.
     */
    public com.google.protobuf.ByteString getDesiredMonitoringServiceBytes() {
      java.lang.Object ref = desiredMonitoringService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        desiredMonitoringService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_monitoring_service = 5;</code>
     *
     * @param value The desiredMonitoringService to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredMonitoringService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      desiredMonitoringService_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_monitoring_service = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredMonitoringService() {
      desiredMonitoringService_ = getDefaultInstance().getDesiredMonitoringService();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     *
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     *
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_monitoring_service = 5;</code>
     *
     * @param value The bytes for desiredMonitoringService to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredMonitoringServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      desiredMonitoringService_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.AddonsConfig desiredAddonsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AddonsConfig,
            com.google.container.v1beta1.AddonsConfig.Builder,
            com.google.container.v1beta1.AddonsConfigOrBuilder>
        desiredAddonsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     *
     * @return Whether the desiredAddonsConfig field is set.
     */
    public boolean hasDesiredAddonsConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     *
     * @return The desiredAddonsConfig.
     */
    public com.google.container.v1beta1.AddonsConfig getDesiredAddonsConfig() {
      if (desiredAddonsConfigBuilder_ == null) {
        return desiredAddonsConfig_ == null
            ? com.google.container.v1beta1.AddonsConfig.getDefaultInstance()
            : desiredAddonsConfig_;
      } else {
        return desiredAddonsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    public Builder setDesiredAddonsConfig(com.google.container.v1beta1.AddonsConfig value) {
      if (desiredAddonsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredAddonsConfig_ = value;
      } else {
        desiredAddonsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    public Builder setDesiredAddonsConfig(
        com.google.container.v1beta1.AddonsConfig.Builder builderForValue) {
      if (desiredAddonsConfigBuilder_ == null) {
        desiredAddonsConfig_ = builderForValue.build();
      } else {
        desiredAddonsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    public Builder mergeDesiredAddonsConfig(com.google.container.v1beta1.AddonsConfig value) {
      if (desiredAddonsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && desiredAddonsConfig_ != null
            && desiredAddonsConfig_
                != com.google.container.v1beta1.AddonsConfig.getDefaultInstance()) {
          getDesiredAddonsConfigBuilder().mergeFrom(value);
        } else {
          desiredAddonsConfig_ = value;
        }
      } else {
        desiredAddonsConfigBuilder_.mergeFrom(value);
      }
      if (desiredAddonsConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    public Builder clearDesiredAddonsConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      desiredAddonsConfig_ = null;
      if (desiredAddonsConfigBuilder_ != null) {
        desiredAddonsConfigBuilder_.dispose();
        desiredAddonsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    public com.google.container.v1beta1.AddonsConfig.Builder getDesiredAddonsConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDesiredAddonsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    public com.google.container.v1beta1.AddonsConfigOrBuilder getDesiredAddonsConfigOrBuilder() {
      if (desiredAddonsConfigBuilder_ != null) {
        return desiredAddonsConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredAddonsConfig_ == null
            ? com.google.container.v1beta1.AddonsConfig.getDefaultInstance()
            : desiredAddonsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for the various addons available to run in the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.AddonsConfig desired_addons_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AddonsConfig,
            com.google.container.v1beta1.AddonsConfig.Builder,
            com.google.container.v1beta1.AddonsConfigOrBuilder>
        getDesiredAddonsConfigFieldBuilder() {
      if (desiredAddonsConfigBuilder_ == null) {
        desiredAddonsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.AddonsConfig,
                com.google.container.v1beta1.AddonsConfig.Builder,
                com.google.container.v1beta1.AddonsConfigOrBuilder>(
                getDesiredAddonsConfig(), getParentForChildren(), isClean());
        desiredAddonsConfig_ = null;
      }
      return desiredAddonsConfigBuilder_;
    }

    private java.lang.Object desiredNodePoolId_ = "";
    /**
     *
     *
     * <pre>
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family",
     * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
     * is specified and there is more than one node pool on the cluster.
     * </pre>
     *
     * <code>string desired_node_pool_id = 7;</code>
     *
     * @return The desiredNodePoolId.
     */
    public java.lang.String getDesiredNodePoolId() {
      java.lang.Object ref = desiredNodePoolId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        desiredNodePoolId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family",
     * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
     * is specified and there is more than one node pool on the cluster.
     * </pre>
     *
     * <code>string desired_node_pool_id = 7;</code>
     *
     * @return The bytes for desiredNodePoolId.
     */
    public com.google.protobuf.ByteString getDesiredNodePoolIdBytes() {
      java.lang.Object ref = desiredNodePoolId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        desiredNodePoolId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family",
     * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
     * is specified and there is more than one node pool on the cluster.
     * </pre>
     *
     * <code>string desired_node_pool_id = 7;</code>
     *
     * @param value The desiredNodePoolId to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredNodePoolId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      desiredNodePoolId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family",
     * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
     * is specified and there is more than one node pool on the cluster.
     * </pre>
     *
     * <code>string desired_node_pool_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredNodePoolId() {
      desiredNodePoolId_ = getDefaultInstance().getDesiredNodePoolId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family",
     * "desired_node_pool_autoscaling", or "desired_workload_metadata_config"
     * is specified and there is more than one node pool on the cluster.
     * </pre>
     *
     * <code>string desired_node_pool_id = 7;</code>
     *
     * @param value The bytes for desiredNodePoolId to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredNodePoolIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      desiredNodePoolId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object desiredImageType_ = "";
    /**
     *
     *
     * <pre>
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     * </pre>
     *
     * <code>string desired_image_type = 8;</code>
     *
     * @return The desiredImageType.
     */
    public java.lang.String getDesiredImageType() {
      java.lang.Object ref = desiredImageType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        desiredImageType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     * </pre>
     *
     * <code>string desired_image_type = 8;</code>
     *
     * @return The bytes for desiredImageType.
     */
    public com.google.protobuf.ByteString getDesiredImageTypeBytes() {
      java.lang.Object ref = desiredImageType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        desiredImageType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     * </pre>
     *
     * <code>string desired_image_type = 8;</code>
     *
     * @param value The desiredImageType to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredImageType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      desiredImageType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     * </pre>
     *
     * <code>string desired_image_type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredImageType() {
      desiredImageType_ = getDefaultInstance().getDesiredImageType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     * </pre>
     *
     * <code>string desired_image_type = 8;</code>
     *
     * @param value The bytes for desiredImageType to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredImageTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      desiredImageType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NodePoolAutoscaling desiredNodePoolAutoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodePoolAutoscaling,
            com.google.container.v1beta1.NodePoolAutoscaling.Builder,
            com.google.container.v1beta1.NodePoolAutoscalingOrBuilder>
        desiredNodePoolAutoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     *
     * @return Whether the desiredNodePoolAutoscaling field is set.
     */
    public boolean hasDesiredNodePoolAutoscaling() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     *
     * @return The desiredNodePoolAutoscaling.
     */
    public com.google.container.v1beta1.NodePoolAutoscaling getDesiredNodePoolAutoscaling() {
      if (desiredNodePoolAutoscalingBuilder_ == null) {
        return desiredNodePoolAutoscaling_ == null
            ? com.google.container.v1beta1.NodePoolAutoscaling.getDefaultInstance()
            : desiredNodePoolAutoscaling_;
      } else {
        return desiredNodePoolAutoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    public Builder setDesiredNodePoolAutoscaling(
        com.google.container.v1beta1.NodePoolAutoscaling value) {
      if (desiredNodePoolAutoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNodePoolAutoscaling_ = value;
      } else {
        desiredNodePoolAutoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    public Builder setDesiredNodePoolAutoscaling(
        com.google.container.v1beta1.NodePoolAutoscaling.Builder builderForValue) {
      if (desiredNodePoolAutoscalingBuilder_ == null) {
        desiredNodePoolAutoscaling_ = builderForValue.build();
      } else {
        desiredNodePoolAutoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    public Builder mergeDesiredNodePoolAutoscaling(
        com.google.container.v1beta1.NodePoolAutoscaling value) {
      if (desiredNodePoolAutoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && desiredNodePoolAutoscaling_ != null
            && desiredNodePoolAutoscaling_
                != com.google.container.v1beta1.NodePoolAutoscaling.getDefaultInstance()) {
          getDesiredNodePoolAutoscalingBuilder().mergeFrom(value);
        } else {
          desiredNodePoolAutoscaling_ = value;
        }
      } else {
        desiredNodePoolAutoscalingBuilder_.mergeFrom(value);
      }
      if (desiredNodePoolAutoscaling_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    public Builder clearDesiredNodePoolAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00000020);
      desiredNodePoolAutoscaling_ = null;
      if (desiredNodePoolAutoscalingBuilder_ != null) {
        desiredNodePoolAutoscalingBuilder_.dispose();
        desiredNodePoolAutoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    public com.google.container.v1beta1.NodePoolAutoscaling.Builder
        getDesiredNodePoolAutoscalingBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDesiredNodePoolAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    public com.google.container.v1beta1.NodePoolAutoscalingOrBuilder
        getDesiredNodePoolAutoscalingOrBuilder() {
      if (desiredNodePoolAutoscalingBuilder_ != null) {
        return desiredNodePoolAutoscalingBuilder_.getMessageOrBuilder();
      } else {
        return desiredNodePoolAutoscaling_ == null
            ? com.google.container.v1beta1.NodePoolAutoscaling.getDefaultInstance()
            : desiredNodePoolAutoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodePoolAutoscaling,
            com.google.container.v1beta1.NodePoolAutoscaling.Builder,
            com.google.container.v1beta1.NodePoolAutoscalingOrBuilder>
        getDesiredNodePoolAutoscalingFieldBuilder() {
      if (desiredNodePoolAutoscalingBuilder_ == null) {
        desiredNodePoolAutoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodePoolAutoscaling,
                com.google.container.v1beta1.NodePoolAutoscaling.Builder,
                com.google.container.v1beta1.NodePoolAutoscalingOrBuilder>(
                getDesiredNodePoolAutoscaling(), getParentForChildren(), isClean());
        desiredNodePoolAutoscaling_ = null;
      }
      return desiredNodePoolAutoscalingBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList desiredLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDesiredLocationsIsMutable() {
      if (!desiredLocations_.isModifiable()) {
        desiredLocations_ = new com.google.protobuf.LazyStringArrayList(desiredLocations_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @return A list containing the desiredLocations.
     */
    public com.google.protobuf.ProtocolStringList getDesiredLocationsList() {
      desiredLocations_.makeImmutable();
      return desiredLocations_;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @return The count of desiredLocations.
     */
    public int getDesiredLocationsCount() {
      return desiredLocations_.size();
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The desiredLocations at the given index.
     */
    public java.lang.String getDesiredLocations(int index) {
      return desiredLocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the desiredLocations at the given index.
     */
    public com.google.protobuf.ByteString getDesiredLocationsBytes(int index) {
      return desiredLocations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The desiredLocations to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDesiredLocationsIsMutable();
      desiredLocations_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @param value The desiredLocations to add.
     * @return This builder for chaining.
     */
    public Builder addDesiredLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDesiredLocationsIsMutable();
      desiredLocations_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @param values The desiredLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllDesiredLocations(java.lang.Iterable<java.lang.String> values) {
      ensureDesiredLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, desiredLocations_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredLocations() {
      desiredLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     *
     * This list must always include the cluster's primary zone.
     *
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     * </pre>
     *
     * <code>repeated string desired_locations = 10;</code>
     *
     * @param value The bytes of the desiredLocations to add.
     * @return This builder for chaining.
     */
    public Builder addDesiredLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDesiredLocationsIsMutable();
      desiredLocations_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.MasterAuthorizedNetworksConfig
        desiredMasterAuthorizedNetworksConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.MasterAuthorizedNetworksConfig,
            com.google.container.v1beta1.MasterAuthorizedNetworksConfig.Builder,
            com.google.container.v1beta1.MasterAuthorizedNetworksConfigOrBuilder>
        desiredMasterAuthorizedNetworksConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     *
     * @return Whether the desiredMasterAuthorizedNetworksConfig field is set.
     */
    public boolean hasDesiredMasterAuthorizedNetworksConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     *
     * @return The desiredMasterAuthorizedNetworksConfig.
     */
    public com.google.container.v1beta1.MasterAuthorizedNetworksConfig
        getDesiredMasterAuthorizedNetworksConfig() {
      if (desiredMasterAuthorizedNetworksConfigBuilder_ == null) {
        return desiredMasterAuthorizedNetworksConfig_ == null
            ? com.google.container.v1beta1.MasterAuthorizedNetworksConfig.getDefaultInstance()
            : desiredMasterAuthorizedNetworksConfig_;
      } else {
        return desiredMasterAuthorizedNetworksConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    public Builder setDesiredMasterAuthorizedNetworksConfig(
        com.google.container.v1beta1.MasterAuthorizedNetworksConfig value) {
      if (desiredMasterAuthorizedNetworksConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredMasterAuthorizedNetworksConfig_ = value;
      } else {
        desiredMasterAuthorizedNetworksConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    public Builder setDesiredMasterAuthorizedNetworksConfig(
        com.google.container.v1beta1.MasterAuthorizedNetworksConfig.Builder builderForValue) {
      if (desiredMasterAuthorizedNetworksConfigBuilder_ == null) {
        desiredMasterAuthorizedNetworksConfig_ = builderForValue.build();
      } else {
        desiredMasterAuthorizedNetworksConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    public Builder mergeDesiredMasterAuthorizedNetworksConfig(
        com.google.container.v1beta1.MasterAuthorizedNetworksConfig value) {
      if (desiredMasterAuthorizedNetworksConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && desiredMasterAuthorizedNetworksConfig_ != null
            && desiredMasterAuthorizedNetworksConfig_
                != com.google.container.v1beta1.MasterAuthorizedNetworksConfig
                    .getDefaultInstance()) {
          getDesiredMasterAuthorizedNetworksConfigBuilder().mergeFrom(value);
        } else {
          desiredMasterAuthorizedNetworksConfig_ = value;
        }
      } else {
        desiredMasterAuthorizedNetworksConfigBuilder_.mergeFrom(value);
      }
      if (desiredMasterAuthorizedNetworksConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    public Builder clearDesiredMasterAuthorizedNetworksConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      desiredMasterAuthorizedNetworksConfig_ = null;
      if (desiredMasterAuthorizedNetworksConfigBuilder_ != null) {
        desiredMasterAuthorizedNetworksConfigBuilder_.dispose();
        desiredMasterAuthorizedNetworksConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    public com.google.container.v1beta1.MasterAuthorizedNetworksConfig.Builder
        getDesiredMasterAuthorizedNetworksConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDesiredMasterAuthorizedNetworksConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    public com.google.container.v1beta1.MasterAuthorizedNetworksConfigOrBuilder
        getDesiredMasterAuthorizedNetworksConfigOrBuilder() {
      if (desiredMasterAuthorizedNetworksConfigBuilder_ != null) {
        return desiredMasterAuthorizedNetworksConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredMasterAuthorizedNetworksConfig_ == null
            ? com.google.container.v1beta1.MasterAuthorizedNetworksConfig.getDefaultInstance()
            : desiredMasterAuthorizedNetworksConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for master authorized networks feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.MasterAuthorizedNetworksConfig,
            com.google.container.v1beta1.MasterAuthorizedNetworksConfig.Builder,
            com.google.container.v1beta1.MasterAuthorizedNetworksConfigOrBuilder>
        getDesiredMasterAuthorizedNetworksConfigFieldBuilder() {
      if (desiredMasterAuthorizedNetworksConfigBuilder_ == null) {
        desiredMasterAuthorizedNetworksConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.MasterAuthorizedNetworksConfig,
                com.google.container.v1beta1.MasterAuthorizedNetworksConfig.Builder,
                com.google.container.v1beta1.MasterAuthorizedNetworksConfigOrBuilder>(
                getDesiredMasterAuthorizedNetworksConfig(), getParentForChildren(), isClean());
        desiredMasterAuthorizedNetworksConfig_ = null;
      }
      return desiredMasterAuthorizedNetworksConfigBuilder_;
    }

    private com.google.container.v1beta1.PodSecurityPolicyConfig desiredPodSecurityPolicyConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PodSecurityPolicyConfig,
            com.google.container.v1beta1.PodSecurityPolicyConfig.Builder,
            com.google.container.v1beta1.PodSecurityPolicyConfigOrBuilder>
        desiredPodSecurityPolicyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     *
     * @return Whether the desiredPodSecurityPolicyConfig field is set.
     */
    public boolean hasDesiredPodSecurityPolicyConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     *
     * @return The desiredPodSecurityPolicyConfig.
     */
    public com.google.container.v1beta1.PodSecurityPolicyConfig
        getDesiredPodSecurityPolicyConfig() {
      if (desiredPodSecurityPolicyConfigBuilder_ == null) {
        return desiredPodSecurityPolicyConfig_ == null
            ? com.google.container.v1beta1.PodSecurityPolicyConfig.getDefaultInstance()
            : desiredPodSecurityPolicyConfig_;
      } else {
        return desiredPodSecurityPolicyConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    public Builder setDesiredPodSecurityPolicyConfig(
        com.google.container.v1beta1.PodSecurityPolicyConfig value) {
      if (desiredPodSecurityPolicyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredPodSecurityPolicyConfig_ = value;
      } else {
        desiredPodSecurityPolicyConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    public Builder setDesiredPodSecurityPolicyConfig(
        com.google.container.v1beta1.PodSecurityPolicyConfig.Builder builderForValue) {
      if (desiredPodSecurityPolicyConfigBuilder_ == null) {
        desiredPodSecurityPolicyConfig_ = builderForValue.build();
      } else {
        desiredPodSecurityPolicyConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    public Builder mergeDesiredPodSecurityPolicyConfig(
        com.google.container.v1beta1.PodSecurityPolicyConfig value) {
      if (desiredPodSecurityPolicyConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && desiredPodSecurityPolicyConfig_ != null
            && desiredPodSecurityPolicyConfig_
                != com.google.container.v1beta1.PodSecurityPolicyConfig.getDefaultInstance()) {
          getDesiredPodSecurityPolicyConfigBuilder().mergeFrom(value);
        } else {
          desiredPodSecurityPolicyConfig_ = value;
        }
      } else {
        desiredPodSecurityPolicyConfigBuilder_.mergeFrom(value);
      }
      if (desiredPodSecurityPolicyConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    public Builder clearDesiredPodSecurityPolicyConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      desiredPodSecurityPolicyConfig_ = null;
      if (desiredPodSecurityPolicyConfigBuilder_ != null) {
        desiredPodSecurityPolicyConfigBuilder_.dispose();
        desiredPodSecurityPolicyConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    public com.google.container.v1beta1.PodSecurityPolicyConfig.Builder
        getDesiredPodSecurityPolicyConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDesiredPodSecurityPolicyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    public com.google.container.v1beta1.PodSecurityPolicyConfigOrBuilder
        getDesiredPodSecurityPolicyConfigOrBuilder() {
      if (desiredPodSecurityPolicyConfigBuilder_ != null) {
        return desiredPodSecurityPolicyConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredPodSecurityPolicyConfig_ == null
            ? com.google.container.v1beta1.PodSecurityPolicyConfig.getDefaultInstance()
            : desiredPodSecurityPolicyConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the PodSecurityPolicy feature.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodSecurityPolicyConfig desired_pod_security_policy_config = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PodSecurityPolicyConfig,
            com.google.container.v1beta1.PodSecurityPolicyConfig.Builder,
            com.google.container.v1beta1.PodSecurityPolicyConfigOrBuilder>
        getDesiredPodSecurityPolicyConfigFieldBuilder() {
      if (desiredPodSecurityPolicyConfigBuilder_ == null) {
        desiredPodSecurityPolicyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.PodSecurityPolicyConfig,
                com.google.container.v1beta1.PodSecurityPolicyConfig.Builder,
                com.google.container.v1beta1.PodSecurityPolicyConfigOrBuilder>(
                getDesiredPodSecurityPolicyConfig(), getParentForChildren(), isClean());
        desiredPodSecurityPolicyConfig_ = null;
      }
      return desiredPodSecurityPolicyConfigBuilder_;
    }

    private com.google.container.v1beta1.ClusterAutoscaling desiredClusterAutoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ClusterAutoscaling,
            com.google.container.v1beta1.ClusterAutoscaling.Builder,
            com.google.container.v1beta1.ClusterAutoscalingOrBuilder>
        desiredClusterAutoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     *
     * @return Whether the desiredClusterAutoscaling field is set.
     */
    public boolean hasDesiredClusterAutoscaling() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     *
     * @return The desiredClusterAutoscaling.
     */
    public com.google.container.v1beta1.ClusterAutoscaling getDesiredClusterAutoscaling() {
      if (desiredClusterAutoscalingBuilder_ == null) {
        return desiredClusterAutoscaling_ == null
            ? com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance()
            : desiredClusterAutoscaling_;
      } else {
        return desiredClusterAutoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    public Builder setDesiredClusterAutoscaling(
        com.google.container.v1beta1.ClusterAutoscaling value) {
      if (desiredClusterAutoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredClusterAutoscaling_ = value;
      } else {
        desiredClusterAutoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    public Builder setDesiredClusterAutoscaling(
        com.google.container.v1beta1.ClusterAutoscaling.Builder builderForValue) {
      if (desiredClusterAutoscalingBuilder_ == null) {
        desiredClusterAutoscaling_ = builderForValue.build();
      } else {
        desiredClusterAutoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    public Builder mergeDesiredClusterAutoscaling(
        com.google.container.v1beta1.ClusterAutoscaling value) {
      if (desiredClusterAutoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && desiredClusterAutoscaling_ != null
            && desiredClusterAutoscaling_
                != com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance()) {
          getDesiredClusterAutoscalingBuilder().mergeFrom(value);
        } else {
          desiredClusterAutoscaling_ = value;
        }
      } else {
        desiredClusterAutoscalingBuilder_.mergeFrom(value);
      }
      if (desiredClusterAutoscaling_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    public Builder clearDesiredClusterAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00000200);
      desiredClusterAutoscaling_ = null;
      if (desiredClusterAutoscalingBuilder_ != null) {
        desiredClusterAutoscalingBuilder_.dispose();
        desiredClusterAutoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    public com.google.container.v1beta1.ClusterAutoscaling.Builder
        getDesiredClusterAutoscalingBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDesiredClusterAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    public com.google.container.v1beta1.ClusterAutoscalingOrBuilder
        getDesiredClusterAutoscalingOrBuilder() {
      if (desiredClusterAutoscalingBuilder_ != null) {
        return desiredClusterAutoscalingBuilder_.getMessageOrBuilder();
      } else {
        return desiredClusterAutoscaling_ == null
            ? com.google.container.v1beta1.ClusterAutoscaling.getDefaultInstance()
            : desiredClusterAutoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ClusterAutoscaling,
            com.google.container.v1beta1.ClusterAutoscaling.Builder,
            com.google.container.v1beta1.ClusterAutoscalingOrBuilder>
        getDesiredClusterAutoscalingFieldBuilder() {
      if (desiredClusterAutoscalingBuilder_ == null) {
        desiredClusterAutoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ClusterAutoscaling,
                com.google.container.v1beta1.ClusterAutoscaling.Builder,
                com.google.container.v1beta1.ClusterAutoscalingOrBuilder>(
                getDesiredClusterAutoscaling(), getParentForChildren(), isClean());
        desiredClusterAutoscaling_ = null;
      }
      return desiredClusterAutoscalingBuilder_;
    }

    private com.google.container.v1beta1.BinaryAuthorization desiredBinaryAuthorization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.BinaryAuthorization,
            com.google.container.v1beta1.BinaryAuthorization.Builder,
            com.google.container.v1beta1.BinaryAuthorizationOrBuilder>
        desiredBinaryAuthorizationBuilder_;
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     *
     * @return Whether the desiredBinaryAuthorization field is set.
     */
    public boolean hasDesiredBinaryAuthorization() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     *
     * @return The desiredBinaryAuthorization.
     */
    public com.google.container.v1beta1.BinaryAuthorization getDesiredBinaryAuthorization() {
      if (desiredBinaryAuthorizationBuilder_ == null) {
        return desiredBinaryAuthorization_ == null
            ? com.google.container.v1beta1.BinaryAuthorization.getDefaultInstance()
            : desiredBinaryAuthorization_;
      } else {
        return desiredBinaryAuthorizationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    public Builder setDesiredBinaryAuthorization(
        com.google.container.v1beta1.BinaryAuthorization value) {
      if (desiredBinaryAuthorizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredBinaryAuthorization_ = value;
      } else {
        desiredBinaryAuthorizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    public Builder setDesiredBinaryAuthorization(
        com.google.container.v1beta1.BinaryAuthorization.Builder builderForValue) {
      if (desiredBinaryAuthorizationBuilder_ == null) {
        desiredBinaryAuthorization_ = builderForValue.build();
      } else {
        desiredBinaryAuthorizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    public Builder mergeDesiredBinaryAuthorization(
        com.google.container.v1beta1.BinaryAuthorization value) {
      if (desiredBinaryAuthorizationBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && desiredBinaryAuthorization_ != null
            && desiredBinaryAuthorization_
                != com.google.container.v1beta1.BinaryAuthorization.getDefaultInstance()) {
          getDesiredBinaryAuthorizationBuilder().mergeFrom(value);
        } else {
          desiredBinaryAuthorization_ = value;
        }
      } else {
        desiredBinaryAuthorizationBuilder_.mergeFrom(value);
      }
      if (desiredBinaryAuthorization_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    public Builder clearDesiredBinaryAuthorization() {
      bitField0_ = (bitField0_ & ~0x00000400);
      desiredBinaryAuthorization_ = null;
      if (desiredBinaryAuthorizationBuilder_ != null) {
        desiredBinaryAuthorizationBuilder_.dispose();
        desiredBinaryAuthorizationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    public com.google.container.v1beta1.BinaryAuthorization.Builder
        getDesiredBinaryAuthorizationBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getDesiredBinaryAuthorizationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    public com.google.container.v1beta1.BinaryAuthorizationOrBuilder
        getDesiredBinaryAuthorizationOrBuilder() {
      if (desiredBinaryAuthorizationBuilder_ != null) {
        return desiredBinaryAuthorizationBuilder_.getMessageOrBuilder();
      } else {
        return desiredBinaryAuthorization_ == null
            ? com.google.container.v1beta1.BinaryAuthorization.getDefaultInstance()
            : desiredBinaryAuthorization_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration options for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.BinaryAuthorization,
            com.google.container.v1beta1.BinaryAuthorization.Builder,
            com.google.container.v1beta1.BinaryAuthorizationOrBuilder>
        getDesiredBinaryAuthorizationFieldBuilder() {
      if (desiredBinaryAuthorizationBuilder_ == null) {
        desiredBinaryAuthorizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.BinaryAuthorization,
                com.google.container.v1beta1.BinaryAuthorization.Builder,
                com.google.container.v1beta1.BinaryAuthorizationOrBuilder>(
                getDesiredBinaryAuthorization(), getParentForChildren(), isClean());
        desiredBinaryAuthorization_ = null;
      }
      return desiredBinaryAuthorizationBuilder_;
    }

    private java.lang.Object desiredLoggingService_ = "";
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_logging_service = 19;</code>
     *
     * @return The desiredLoggingService.
     */
    public java.lang.String getDesiredLoggingService() {
      java.lang.Object ref = desiredLoggingService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        desiredLoggingService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_logging_service = 19;</code>
     *
     * @return The bytes for desiredLoggingService.
     */
    public com.google.protobuf.ByteString getDesiredLoggingServiceBytes() {
      java.lang.Object ref = desiredLoggingService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        desiredLoggingService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_logging_service = 19;</code>
     *
     * @param value The desiredLoggingService to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredLoggingService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      desiredLoggingService_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_logging_service = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredLoggingService() {
      desiredLoggingService_ = getDefaultInstance().getDesiredLoggingService();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The logging service the cluster should use to write logs.
     * Currently available options:
     *
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     *
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     * </pre>
     *
     * <code>string desired_logging_service = 19;</code>
     *
     * @param value The bytes for desiredLoggingService to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredLoggingServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      desiredLoggingService_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.ResourceUsageExportConfig
        desiredResourceUsageExportConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ResourceUsageExportConfig,
            com.google.container.v1beta1.ResourceUsageExportConfig.Builder,
            com.google.container.v1beta1.ResourceUsageExportConfigOrBuilder>
        desiredResourceUsageExportConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     *
     * @return Whether the desiredResourceUsageExportConfig field is set.
     */
    public boolean hasDesiredResourceUsageExportConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     *
     * @return The desiredResourceUsageExportConfig.
     */
    public com.google.container.v1beta1.ResourceUsageExportConfig
        getDesiredResourceUsageExportConfig() {
      if (desiredResourceUsageExportConfigBuilder_ == null) {
        return desiredResourceUsageExportConfig_ == null
            ? com.google.container.v1beta1.ResourceUsageExportConfig.getDefaultInstance()
            : desiredResourceUsageExportConfig_;
      } else {
        return desiredResourceUsageExportConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    public Builder setDesiredResourceUsageExportConfig(
        com.google.container.v1beta1.ResourceUsageExportConfig value) {
      if (desiredResourceUsageExportConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredResourceUsageExportConfig_ = value;
      } else {
        desiredResourceUsageExportConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    public Builder setDesiredResourceUsageExportConfig(
        com.google.container.v1beta1.ResourceUsageExportConfig.Builder builderForValue) {
      if (desiredResourceUsageExportConfigBuilder_ == null) {
        desiredResourceUsageExportConfig_ = builderForValue.build();
      } else {
        desiredResourceUsageExportConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    public Builder mergeDesiredResourceUsageExportConfig(
        com.google.container.v1beta1.ResourceUsageExportConfig value) {
      if (desiredResourceUsageExportConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && desiredResourceUsageExportConfig_ != null
            && desiredResourceUsageExportConfig_
                != com.google.container.v1beta1.ResourceUsageExportConfig.getDefaultInstance()) {
          getDesiredResourceUsageExportConfigBuilder().mergeFrom(value);
        } else {
          desiredResourceUsageExportConfig_ = value;
        }
      } else {
        desiredResourceUsageExportConfigBuilder_.mergeFrom(value);
      }
      if (desiredResourceUsageExportConfig_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    public Builder clearDesiredResourceUsageExportConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      desiredResourceUsageExportConfig_ = null;
      if (desiredResourceUsageExportConfigBuilder_ != null) {
        desiredResourceUsageExportConfigBuilder_.dispose();
        desiredResourceUsageExportConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    public com.google.container.v1beta1.ResourceUsageExportConfig.Builder
        getDesiredResourceUsageExportConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getDesiredResourceUsageExportConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    public com.google.container.v1beta1.ResourceUsageExportConfigOrBuilder
        getDesiredResourceUsageExportConfigOrBuilder() {
      if (desiredResourceUsageExportConfigBuilder_ != null) {
        return desiredResourceUsageExportConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredResourceUsageExportConfig_ == null
            ? com.google.container.v1beta1.ResourceUsageExportConfig.getDefaultInstance()
            : desiredResourceUsageExportConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for exporting resource usage.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ResourceUsageExportConfig,
            com.google.container.v1beta1.ResourceUsageExportConfig.Builder,
            com.google.container.v1beta1.ResourceUsageExportConfigOrBuilder>
        getDesiredResourceUsageExportConfigFieldBuilder() {
      if (desiredResourceUsageExportConfigBuilder_ == null) {
        desiredResourceUsageExportConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ResourceUsageExportConfig,
                com.google.container.v1beta1.ResourceUsageExportConfig.Builder,
                com.google.container.v1beta1.ResourceUsageExportConfigOrBuilder>(
                getDesiredResourceUsageExportConfig(), getParentForChildren(), isClean());
        desiredResourceUsageExportConfig_ = null;
      }
      return desiredResourceUsageExportConfigBuilder_;
    }

    private com.google.container.v1beta1.VerticalPodAutoscaling desiredVerticalPodAutoscaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.VerticalPodAutoscaling,
            com.google.container.v1beta1.VerticalPodAutoscaling.Builder,
            com.google.container.v1beta1.VerticalPodAutoscalingOrBuilder>
        desiredVerticalPodAutoscalingBuilder_;
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     *
     * @return Whether the desiredVerticalPodAutoscaling field is set.
     */
    public boolean hasDesiredVerticalPodAutoscaling() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     *
     * @return The desiredVerticalPodAutoscaling.
     */
    public com.google.container.v1beta1.VerticalPodAutoscaling getDesiredVerticalPodAutoscaling() {
      if (desiredVerticalPodAutoscalingBuilder_ == null) {
        return desiredVerticalPodAutoscaling_ == null
            ? com.google.container.v1beta1.VerticalPodAutoscaling.getDefaultInstance()
            : desiredVerticalPodAutoscaling_;
      } else {
        return desiredVerticalPodAutoscalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    public Builder setDesiredVerticalPodAutoscaling(
        com.google.container.v1beta1.VerticalPodAutoscaling value) {
      if (desiredVerticalPodAutoscalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredVerticalPodAutoscaling_ = value;
      } else {
        desiredVerticalPodAutoscalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    public Builder setDesiredVerticalPodAutoscaling(
        com.google.container.v1beta1.VerticalPodAutoscaling.Builder builderForValue) {
      if (desiredVerticalPodAutoscalingBuilder_ == null) {
        desiredVerticalPodAutoscaling_ = builderForValue.build();
      } else {
        desiredVerticalPodAutoscalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    public Builder mergeDesiredVerticalPodAutoscaling(
        com.google.container.v1beta1.VerticalPodAutoscaling value) {
      if (desiredVerticalPodAutoscalingBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && desiredVerticalPodAutoscaling_ != null
            && desiredVerticalPodAutoscaling_
                != com.google.container.v1beta1.VerticalPodAutoscaling.getDefaultInstance()) {
          getDesiredVerticalPodAutoscalingBuilder().mergeFrom(value);
        } else {
          desiredVerticalPodAutoscaling_ = value;
        }
      } else {
        desiredVerticalPodAutoscalingBuilder_.mergeFrom(value);
      }
      if (desiredVerticalPodAutoscaling_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    public Builder clearDesiredVerticalPodAutoscaling() {
      bitField0_ = (bitField0_ & ~0x00002000);
      desiredVerticalPodAutoscaling_ = null;
      if (desiredVerticalPodAutoscalingBuilder_ != null) {
        desiredVerticalPodAutoscalingBuilder_.dispose();
        desiredVerticalPodAutoscalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    public com.google.container.v1beta1.VerticalPodAutoscaling.Builder
        getDesiredVerticalPodAutoscalingBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getDesiredVerticalPodAutoscalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    public com.google.container.v1beta1.VerticalPodAutoscalingOrBuilder
        getDesiredVerticalPodAutoscalingOrBuilder() {
      if (desiredVerticalPodAutoscalingBuilder_ != null) {
        return desiredVerticalPodAutoscalingBuilder_.getMessageOrBuilder();
      } else {
        return desiredVerticalPodAutoscaling_ == null
            ? com.google.container.v1beta1.VerticalPodAutoscaling.getDefaultInstance()
            : desiredVerticalPodAutoscaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Cluster-level Vertical Pod Autoscaling configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.VerticalPodAutoscaling,
            com.google.container.v1beta1.VerticalPodAutoscaling.Builder,
            com.google.container.v1beta1.VerticalPodAutoscalingOrBuilder>
        getDesiredVerticalPodAutoscalingFieldBuilder() {
      if (desiredVerticalPodAutoscalingBuilder_ == null) {
        desiredVerticalPodAutoscalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.VerticalPodAutoscaling,
                com.google.container.v1beta1.VerticalPodAutoscaling.Builder,
                com.google.container.v1beta1.VerticalPodAutoscalingOrBuilder>(
                getDesiredVerticalPodAutoscaling(), getParentForChildren(), isClean());
        desiredVerticalPodAutoscaling_ = null;
      }
      return desiredVerticalPodAutoscalingBuilder_;
    }

    private com.google.container.v1beta1.PrivateClusterConfig desiredPrivateClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PrivateClusterConfig,
            com.google.container.v1beta1.PrivateClusterConfig.Builder,
            com.google.container.v1beta1.PrivateClusterConfigOrBuilder>
        desiredPrivateClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     *
     * @return Whether the desiredPrivateClusterConfig field is set.
     */
    public boolean hasDesiredPrivateClusterConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     *
     * @return The desiredPrivateClusterConfig.
     */
    public com.google.container.v1beta1.PrivateClusterConfig getDesiredPrivateClusterConfig() {
      if (desiredPrivateClusterConfigBuilder_ == null) {
        return desiredPrivateClusterConfig_ == null
            ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
            : desiredPrivateClusterConfig_;
      } else {
        return desiredPrivateClusterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    public Builder setDesiredPrivateClusterConfig(
        com.google.container.v1beta1.PrivateClusterConfig value) {
      if (desiredPrivateClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredPrivateClusterConfig_ = value;
      } else {
        desiredPrivateClusterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    public Builder setDesiredPrivateClusterConfig(
        com.google.container.v1beta1.PrivateClusterConfig.Builder builderForValue) {
      if (desiredPrivateClusterConfigBuilder_ == null) {
        desiredPrivateClusterConfig_ = builderForValue.build();
      } else {
        desiredPrivateClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    public Builder mergeDesiredPrivateClusterConfig(
        com.google.container.v1beta1.PrivateClusterConfig value) {
      if (desiredPrivateClusterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && desiredPrivateClusterConfig_ != null
            && desiredPrivateClusterConfig_
                != com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()) {
          getDesiredPrivateClusterConfigBuilder().mergeFrom(value);
        } else {
          desiredPrivateClusterConfig_ = value;
        }
      } else {
        desiredPrivateClusterConfigBuilder_.mergeFrom(value);
      }
      if (desiredPrivateClusterConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    public Builder clearDesiredPrivateClusterConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      desiredPrivateClusterConfig_ = null;
      if (desiredPrivateClusterConfigBuilder_ != null) {
        desiredPrivateClusterConfigBuilder_.dispose();
        desiredPrivateClusterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    public com.google.container.v1beta1.PrivateClusterConfig.Builder
        getDesiredPrivateClusterConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getDesiredPrivateClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    public com.google.container.v1beta1.PrivateClusterConfigOrBuilder
        getDesiredPrivateClusterConfigOrBuilder() {
      if (desiredPrivateClusterConfigBuilder_ != null) {
        return desiredPrivateClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredPrivateClusterConfig_ == null
            ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
            : desiredPrivateClusterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. master_global_access_config is
     * the only field that can be changed via this field.
     * See also
     * [ClusterUpdate.desired_enable_private_endpoint][google.container.v1beta1.ClusterUpdate.desired_enable_private_endpoint]
     * for modifying other fields within
     * [PrivateClusterConfig][google.container.v1beta1.PrivateClusterConfig].
     * </pre>
     *
     * <code>.google.container.v1beta1.PrivateClusterConfig desired_private_cluster_config = 25;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PrivateClusterConfig,
            com.google.container.v1beta1.PrivateClusterConfig.Builder,
            com.google.container.v1beta1.PrivateClusterConfigOrBuilder>
        getDesiredPrivateClusterConfigFieldBuilder() {
      if (desiredPrivateClusterConfigBuilder_ == null) {
        desiredPrivateClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.PrivateClusterConfig,
                com.google.container.v1beta1.PrivateClusterConfig.Builder,
                com.google.container.v1beta1.PrivateClusterConfigOrBuilder>(
                getDesiredPrivateClusterConfig(), getParentForChildren(), isClean());
        desiredPrivateClusterConfig_ = null;
      }
      return desiredPrivateClusterConfigBuilder_;
    }

    private com.google.container.v1beta1.IntraNodeVisibilityConfig
        desiredIntraNodeVisibilityConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.IntraNodeVisibilityConfig,
            com.google.container.v1beta1.IntraNodeVisibilityConfig.Builder,
            com.google.container.v1beta1.IntraNodeVisibilityConfigOrBuilder>
        desiredIntraNodeVisibilityConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     *
     * @return Whether the desiredIntraNodeVisibilityConfig field is set.
     */
    public boolean hasDesiredIntraNodeVisibilityConfig() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     *
     * @return The desiredIntraNodeVisibilityConfig.
     */
    public com.google.container.v1beta1.IntraNodeVisibilityConfig
        getDesiredIntraNodeVisibilityConfig() {
      if (desiredIntraNodeVisibilityConfigBuilder_ == null) {
        return desiredIntraNodeVisibilityConfig_ == null
            ? com.google.container.v1beta1.IntraNodeVisibilityConfig.getDefaultInstance()
            : desiredIntraNodeVisibilityConfig_;
      } else {
        return desiredIntraNodeVisibilityConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    public Builder setDesiredIntraNodeVisibilityConfig(
        com.google.container.v1beta1.IntraNodeVisibilityConfig value) {
      if (desiredIntraNodeVisibilityConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredIntraNodeVisibilityConfig_ = value;
      } else {
        desiredIntraNodeVisibilityConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    public Builder setDesiredIntraNodeVisibilityConfig(
        com.google.container.v1beta1.IntraNodeVisibilityConfig.Builder builderForValue) {
      if (desiredIntraNodeVisibilityConfigBuilder_ == null) {
        desiredIntraNodeVisibilityConfig_ = builderForValue.build();
      } else {
        desiredIntraNodeVisibilityConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    public Builder mergeDesiredIntraNodeVisibilityConfig(
        com.google.container.v1beta1.IntraNodeVisibilityConfig value) {
      if (desiredIntraNodeVisibilityConfigBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && desiredIntraNodeVisibilityConfig_ != null
            && desiredIntraNodeVisibilityConfig_
                != com.google.container.v1beta1.IntraNodeVisibilityConfig.getDefaultInstance()) {
          getDesiredIntraNodeVisibilityConfigBuilder().mergeFrom(value);
        } else {
          desiredIntraNodeVisibilityConfig_ = value;
        }
      } else {
        desiredIntraNodeVisibilityConfigBuilder_.mergeFrom(value);
      }
      if (desiredIntraNodeVisibilityConfig_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    public Builder clearDesiredIntraNodeVisibilityConfig() {
      bitField0_ = (bitField0_ & ~0x00008000);
      desiredIntraNodeVisibilityConfig_ = null;
      if (desiredIntraNodeVisibilityConfigBuilder_ != null) {
        desiredIntraNodeVisibilityConfigBuilder_.dispose();
        desiredIntraNodeVisibilityConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    public com.google.container.v1beta1.IntraNodeVisibilityConfig.Builder
        getDesiredIntraNodeVisibilityConfigBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getDesiredIntraNodeVisibilityConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    public com.google.container.v1beta1.IntraNodeVisibilityConfigOrBuilder
        getDesiredIntraNodeVisibilityConfigOrBuilder() {
      if (desiredIntraNodeVisibilityConfigBuilder_ != null) {
        return desiredIntraNodeVisibilityConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredIntraNodeVisibilityConfig_ == null
            ? com.google.container.v1beta1.IntraNodeVisibilityConfig.getDefaultInstance()
            : desiredIntraNodeVisibilityConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired config of Intra-node visibility.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.IntraNodeVisibilityConfig,
            com.google.container.v1beta1.IntraNodeVisibilityConfig.Builder,
            com.google.container.v1beta1.IntraNodeVisibilityConfigOrBuilder>
        getDesiredIntraNodeVisibilityConfigFieldBuilder() {
      if (desiredIntraNodeVisibilityConfigBuilder_ == null) {
        desiredIntraNodeVisibilityConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.IntraNodeVisibilityConfig,
                com.google.container.v1beta1.IntraNodeVisibilityConfig.Builder,
                com.google.container.v1beta1.IntraNodeVisibilityConfigOrBuilder>(
                getDesiredIntraNodeVisibilityConfig(), getParentForChildren(), isClean());
        desiredIntraNodeVisibilityConfig_ = null;
      }
      return desiredIntraNodeVisibilityConfigBuilder_;
    }

    private com.google.container.v1beta1.DefaultSnatStatus desiredDefaultSnatStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DefaultSnatStatus,
            com.google.container.v1beta1.DefaultSnatStatus.Builder,
            com.google.container.v1beta1.DefaultSnatStatusOrBuilder>
        desiredDefaultSnatStatusBuilder_;
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     *
     * @return Whether the desiredDefaultSnatStatus field is set.
     */
    public boolean hasDesiredDefaultSnatStatus() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     *
     * @return The desiredDefaultSnatStatus.
     */
    public com.google.container.v1beta1.DefaultSnatStatus getDesiredDefaultSnatStatus() {
      if (desiredDefaultSnatStatusBuilder_ == null) {
        return desiredDefaultSnatStatus_ == null
            ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
            : desiredDefaultSnatStatus_;
      } else {
        return desiredDefaultSnatStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    public Builder setDesiredDefaultSnatStatus(
        com.google.container.v1beta1.DefaultSnatStatus value) {
      if (desiredDefaultSnatStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredDefaultSnatStatus_ = value;
      } else {
        desiredDefaultSnatStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    public Builder setDesiredDefaultSnatStatus(
        com.google.container.v1beta1.DefaultSnatStatus.Builder builderForValue) {
      if (desiredDefaultSnatStatusBuilder_ == null) {
        desiredDefaultSnatStatus_ = builderForValue.build();
      } else {
        desiredDefaultSnatStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    public Builder mergeDesiredDefaultSnatStatus(
        com.google.container.v1beta1.DefaultSnatStatus value) {
      if (desiredDefaultSnatStatusBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && desiredDefaultSnatStatus_ != null
            && desiredDefaultSnatStatus_
                != com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()) {
          getDesiredDefaultSnatStatusBuilder().mergeFrom(value);
        } else {
          desiredDefaultSnatStatus_ = value;
        }
      } else {
        desiredDefaultSnatStatusBuilder_.mergeFrom(value);
      }
      if (desiredDefaultSnatStatus_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    public Builder clearDesiredDefaultSnatStatus() {
      bitField0_ = (bitField0_ & ~0x00010000);
      desiredDefaultSnatStatus_ = null;
      if (desiredDefaultSnatStatusBuilder_ != null) {
        desiredDefaultSnatStatusBuilder_.dispose();
        desiredDefaultSnatStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    public com.google.container.v1beta1.DefaultSnatStatus.Builder
        getDesiredDefaultSnatStatusBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getDesiredDefaultSnatStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    public com.google.container.v1beta1.DefaultSnatStatusOrBuilder
        getDesiredDefaultSnatStatusOrBuilder() {
      if (desiredDefaultSnatStatusBuilder_ != null) {
        return desiredDefaultSnatStatusBuilder_.getMessageOrBuilder();
      } else {
        return desiredDefaultSnatStatus_ == null
            ? com.google.container.v1beta1.DefaultSnatStatus.getDefaultInstance()
            : desiredDefaultSnatStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired status of whether to disable default sNAT for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DefaultSnatStatus,
            com.google.container.v1beta1.DefaultSnatStatus.Builder,
            com.google.container.v1beta1.DefaultSnatStatusOrBuilder>
        getDesiredDefaultSnatStatusFieldBuilder() {
      if (desiredDefaultSnatStatusBuilder_ == null) {
        desiredDefaultSnatStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.DefaultSnatStatus,
                com.google.container.v1beta1.DefaultSnatStatus.Builder,
                com.google.container.v1beta1.DefaultSnatStatusOrBuilder>(
                getDesiredDefaultSnatStatus(), getParentForChildren(), isClean());
        desiredDefaultSnatStatus_ = null;
      }
      return desiredDefaultSnatStatusBuilder_;
    }

    private com.google.container.v1beta1.ClusterTelemetry desiredClusterTelemetry_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ClusterTelemetry,
            com.google.container.v1beta1.ClusterTelemetry.Builder,
            com.google.container.v1beta1.ClusterTelemetryOrBuilder>
        desiredClusterTelemetryBuilder_;
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     *
     * @return Whether the desiredClusterTelemetry field is set.
     */
    public boolean hasDesiredClusterTelemetry() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     *
     * @return The desiredClusterTelemetry.
     */
    public com.google.container.v1beta1.ClusterTelemetry getDesiredClusterTelemetry() {
      if (desiredClusterTelemetryBuilder_ == null) {
        return desiredClusterTelemetry_ == null
            ? com.google.container.v1beta1.ClusterTelemetry.getDefaultInstance()
            : desiredClusterTelemetry_;
      } else {
        return desiredClusterTelemetryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    public Builder setDesiredClusterTelemetry(com.google.container.v1beta1.ClusterTelemetry value) {
      if (desiredClusterTelemetryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredClusterTelemetry_ = value;
      } else {
        desiredClusterTelemetryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    public Builder setDesiredClusterTelemetry(
        com.google.container.v1beta1.ClusterTelemetry.Builder builderForValue) {
      if (desiredClusterTelemetryBuilder_ == null) {
        desiredClusterTelemetry_ = builderForValue.build();
      } else {
        desiredClusterTelemetryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    public Builder mergeDesiredClusterTelemetry(
        com.google.container.v1beta1.ClusterTelemetry value) {
      if (desiredClusterTelemetryBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && desiredClusterTelemetry_ != null
            && desiredClusterTelemetry_
                != com.google.container.v1beta1.ClusterTelemetry.getDefaultInstance()) {
          getDesiredClusterTelemetryBuilder().mergeFrom(value);
        } else {
          desiredClusterTelemetry_ = value;
        }
      } else {
        desiredClusterTelemetryBuilder_.mergeFrom(value);
      }
      if (desiredClusterTelemetry_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    public Builder clearDesiredClusterTelemetry() {
      bitField0_ = (bitField0_ & ~0x00020000);
      desiredClusterTelemetry_ = null;
      if (desiredClusterTelemetryBuilder_ != null) {
        desiredClusterTelemetryBuilder_.dispose();
        desiredClusterTelemetryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    public com.google.container.v1beta1.ClusterTelemetry.Builder
        getDesiredClusterTelemetryBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getDesiredClusterTelemetryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    public com.google.container.v1beta1.ClusterTelemetryOrBuilder
        getDesiredClusterTelemetryOrBuilder() {
      if (desiredClusterTelemetryBuilder_ != null) {
        return desiredClusterTelemetryBuilder_.getMessageOrBuilder();
      } else {
        return desiredClusterTelemetry_ == null
            ? com.google.container.v1beta1.ClusterTelemetry.getDefaultInstance()
            : desiredClusterTelemetry_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired telemetry integration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ClusterTelemetry desired_cluster_telemetry = 30;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ClusterTelemetry,
            com.google.container.v1beta1.ClusterTelemetry.Builder,
            com.google.container.v1beta1.ClusterTelemetryOrBuilder>
        getDesiredClusterTelemetryFieldBuilder() {
      if (desiredClusterTelemetryBuilder_ == null) {
        desiredClusterTelemetryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ClusterTelemetry,
                com.google.container.v1beta1.ClusterTelemetry.Builder,
                com.google.container.v1beta1.ClusterTelemetryOrBuilder>(
                getDesiredClusterTelemetry(), getParentForChildren(), isClean());
        desiredClusterTelemetry_ = null;
      }
      return desiredClusterTelemetryBuilder_;
    }

    private com.google.container.v1beta1.ReleaseChannel desiredReleaseChannel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ReleaseChannel,
            com.google.container.v1beta1.ReleaseChannel.Builder,
            com.google.container.v1beta1.ReleaseChannelOrBuilder>
        desiredReleaseChannelBuilder_;
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     *
     * @return Whether the desiredReleaseChannel field is set.
     */
    public boolean hasDesiredReleaseChannel() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     *
     * @return The desiredReleaseChannel.
     */
    public com.google.container.v1beta1.ReleaseChannel getDesiredReleaseChannel() {
      if (desiredReleaseChannelBuilder_ == null) {
        return desiredReleaseChannel_ == null
            ? com.google.container.v1beta1.ReleaseChannel.getDefaultInstance()
            : desiredReleaseChannel_;
      } else {
        return desiredReleaseChannelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    public Builder setDesiredReleaseChannel(com.google.container.v1beta1.ReleaseChannel value) {
      if (desiredReleaseChannelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredReleaseChannel_ = value;
      } else {
        desiredReleaseChannelBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    public Builder setDesiredReleaseChannel(
        com.google.container.v1beta1.ReleaseChannel.Builder builderForValue) {
      if (desiredReleaseChannelBuilder_ == null) {
        desiredReleaseChannel_ = builderForValue.build();
      } else {
        desiredReleaseChannelBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    public Builder mergeDesiredReleaseChannel(com.google.container.v1beta1.ReleaseChannel value) {
      if (desiredReleaseChannelBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && desiredReleaseChannel_ != null
            && desiredReleaseChannel_
                != com.google.container.v1beta1.ReleaseChannel.getDefaultInstance()) {
          getDesiredReleaseChannelBuilder().mergeFrom(value);
        } else {
          desiredReleaseChannel_ = value;
        }
      } else {
        desiredReleaseChannelBuilder_.mergeFrom(value);
      }
      if (desiredReleaseChannel_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    public Builder clearDesiredReleaseChannel() {
      bitField0_ = (bitField0_ & ~0x00040000);
      desiredReleaseChannel_ = null;
      if (desiredReleaseChannelBuilder_ != null) {
        desiredReleaseChannelBuilder_.dispose();
        desiredReleaseChannelBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    public com.google.container.v1beta1.ReleaseChannel.Builder getDesiredReleaseChannelBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getDesiredReleaseChannelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    public com.google.container.v1beta1.ReleaseChannelOrBuilder
        getDesiredReleaseChannelOrBuilder() {
      if (desiredReleaseChannelBuilder_ != null) {
        return desiredReleaseChannelBuilder_.getMessageOrBuilder();
      } else {
        return desiredReleaseChannel_ == null
            ? com.google.container.v1beta1.ReleaseChannel.getDefaultInstance()
            : desiredReleaseChannel_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired release channel configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ReleaseChannel desired_release_channel = 31;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ReleaseChannel,
            com.google.container.v1beta1.ReleaseChannel.Builder,
            com.google.container.v1beta1.ReleaseChannelOrBuilder>
        getDesiredReleaseChannelFieldBuilder() {
      if (desiredReleaseChannelBuilder_ == null) {
        desiredReleaseChannelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ReleaseChannel,
                com.google.container.v1beta1.ReleaseChannel.Builder,
                com.google.container.v1beta1.ReleaseChannelOrBuilder>(
                getDesiredReleaseChannel(), getParentForChildren(), isClean());
        desiredReleaseChannel_ = null;
      }
      return desiredReleaseChannelBuilder_;
    }

    private com.google.container.v1beta1.PrivateClusterConfig privateClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PrivateClusterConfig,
            com.google.container.v1beta1.PrivateClusterConfig.Builder,
            com.google.container.v1beta1.PrivateClusterConfigOrBuilder>
        privateClusterConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1beta1.ClusterUpdate.private_cluster_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=2681
     * @return Whether the privateClusterConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasPrivateClusterConfig() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1beta1.ClusterUpdate.private_cluster_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=2681
     * @return The privateClusterConfig.
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.PrivateClusterConfig getPrivateClusterConfig() {
      if (privateClusterConfigBuilder_ == null) {
        return privateClusterConfig_ == null
            ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
            : privateClusterConfig_;
      } else {
        return privateClusterConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setPrivateClusterConfig(
        com.google.container.v1beta1.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateClusterConfig_ = value;
      } else {
        privateClusterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setPrivateClusterConfig(
        com.google.container.v1beta1.PrivateClusterConfig.Builder builderForValue) {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfig_ = builderForValue.build();
      } else {
        privateClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergePrivateClusterConfig(
        com.google.container.v1beta1.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && privateClusterConfig_ != null
            && privateClusterConfig_
                != com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()) {
          getPrivateClusterConfigBuilder().mergeFrom(value);
        } else {
          privateClusterConfig_ = value;
        }
      } else {
        privateClusterConfigBuilder_.mergeFrom(value);
      }
      if (privateClusterConfig_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearPrivateClusterConfig() {
      bitField0_ = (bitField0_ & ~0x00080000);
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.PrivateClusterConfig.Builder
        getPrivateClusterConfigBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getPrivateClusterConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.PrivateClusterConfigOrBuilder
        getPrivateClusterConfigOrBuilder() {
      if (privateClusterConfigBuilder_ != null) {
        return privateClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateClusterConfig_ == null
            ? com.google.container.v1beta1.PrivateClusterConfig.getDefaultInstance()
            : privateClusterConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired private cluster configuration. Has no effect. Use
     * [desired_private_cluster_config][google.container.v1beta1.ClusterUpdate.desired_private_cluster_config]
     * instead.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateClusterConfig private_cluster_config = 37 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PrivateClusterConfig,
            com.google.container.v1beta1.PrivateClusterConfig.Builder,
            com.google.container.v1beta1.PrivateClusterConfigOrBuilder>
        getPrivateClusterConfigFieldBuilder() {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.PrivateClusterConfig,
                com.google.container.v1beta1.PrivateClusterConfig.Builder,
                com.google.container.v1beta1.PrivateClusterConfigOrBuilder>(
                getPrivateClusterConfig(), getParentForChildren(), isClean());
        privateClusterConfig_ = null;
      }
      return privateClusterConfigBuilder_;
    }

    private com.google.container.v1beta1.TpuConfig desiredTpuConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.TpuConfig,
            com.google.container.v1beta1.TpuConfig.Builder,
            com.google.container.v1beta1.TpuConfigOrBuilder>
        desiredTpuConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     *
     * @return Whether the desiredTpuConfig field is set.
     */
    public boolean hasDesiredTpuConfig() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     *
     * @return The desiredTpuConfig.
     */
    public com.google.container.v1beta1.TpuConfig getDesiredTpuConfig() {
      if (desiredTpuConfigBuilder_ == null) {
        return desiredTpuConfig_ == null
            ? com.google.container.v1beta1.TpuConfig.getDefaultInstance()
            : desiredTpuConfig_;
      } else {
        return desiredTpuConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    public Builder setDesiredTpuConfig(com.google.container.v1beta1.TpuConfig value) {
      if (desiredTpuConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredTpuConfig_ = value;
      } else {
        desiredTpuConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    public Builder setDesiredTpuConfig(
        com.google.container.v1beta1.TpuConfig.Builder builderForValue) {
      if (desiredTpuConfigBuilder_ == null) {
        desiredTpuConfig_ = builderForValue.build();
      } else {
        desiredTpuConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    public Builder mergeDesiredTpuConfig(com.google.container.v1beta1.TpuConfig value) {
      if (desiredTpuConfigBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && desiredTpuConfig_ != null
            && desiredTpuConfig_ != com.google.container.v1beta1.TpuConfig.getDefaultInstance()) {
          getDesiredTpuConfigBuilder().mergeFrom(value);
        } else {
          desiredTpuConfig_ = value;
        }
      } else {
        desiredTpuConfigBuilder_.mergeFrom(value);
      }
      if (desiredTpuConfig_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    public Builder clearDesiredTpuConfig() {
      bitField0_ = (bitField0_ & ~0x00100000);
      desiredTpuConfig_ = null;
      if (desiredTpuConfigBuilder_ != null) {
        desiredTpuConfigBuilder_.dispose();
        desiredTpuConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    public com.google.container.v1beta1.TpuConfig.Builder getDesiredTpuConfigBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getDesiredTpuConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    public com.google.container.v1beta1.TpuConfigOrBuilder getDesiredTpuConfigOrBuilder() {
      if (desiredTpuConfigBuilder_ != null) {
        return desiredTpuConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredTpuConfig_ == null
            ? com.google.container.v1beta1.TpuConfig.getDefaultInstance()
            : desiredTpuConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired Cloud TPU configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.TpuConfig desired_tpu_config = 38;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.TpuConfig,
            com.google.container.v1beta1.TpuConfig.Builder,
            com.google.container.v1beta1.TpuConfigOrBuilder>
        getDesiredTpuConfigFieldBuilder() {
      if (desiredTpuConfigBuilder_ == null) {
        desiredTpuConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.TpuConfig,
                com.google.container.v1beta1.TpuConfig.Builder,
                com.google.container.v1beta1.TpuConfigOrBuilder>(
                getDesiredTpuConfig(), getParentForChildren(), isClean());
        desiredTpuConfig_ = null;
      }
      return desiredTpuConfigBuilder_;
    }

    private com.google.container.v1beta1.ILBSubsettingConfig desiredL4IlbSubsettingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ILBSubsettingConfig,
            com.google.container.v1beta1.ILBSubsettingConfig.Builder,
            com.google.container.v1beta1.ILBSubsettingConfigOrBuilder>
        desiredL4IlbSubsettingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     *
     * @return Whether the desiredL4ilbSubsettingConfig field is set.
     */
    public boolean hasDesiredL4IlbSubsettingConfig() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     *
     * @return The desiredL4ilbSubsettingConfig.
     */
    public com.google.container.v1beta1.ILBSubsettingConfig getDesiredL4IlbSubsettingConfig() {
      if (desiredL4IlbSubsettingConfigBuilder_ == null) {
        return desiredL4IlbSubsettingConfig_ == null
            ? com.google.container.v1beta1.ILBSubsettingConfig.getDefaultInstance()
            : desiredL4IlbSubsettingConfig_;
      } else {
        return desiredL4IlbSubsettingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    public Builder setDesiredL4IlbSubsettingConfig(
        com.google.container.v1beta1.ILBSubsettingConfig value) {
      if (desiredL4IlbSubsettingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredL4IlbSubsettingConfig_ = value;
      } else {
        desiredL4IlbSubsettingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    public Builder setDesiredL4IlbSubsettingConfig(
        com.google.container.v1beta1.ILBSubsettingConfig.Builder builderForValue) {
      if (desiredL4IlbSubsettingConfigBuilder_ == null) {
        desiredL4IlbSubsettingConfig_ = builderForValue.build();
      } else {
        desiredL4IlbSubsettingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    public Builder mergeDesiredL4IlbSubsettingConfig(
        com.google.container.v1beta1.ILBSubsettingConfig value) {
      if (desiredL4IlbSubsettingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && desiredL4IlbSubsettingConfig_ != null
            && desiredL4IlbSubsettingConfig_
                != com.google.container.v1beta1.ILBSubsettingConfig.getDefaultInstance()) {
          getDesiredL4IlbSubsettingConfigBuilder().mergeFrom(value);
        } else {
          desiredL4IlbSubsettingConfig_ = value;
        }
      } else {
        desiredL4IlbSubsettingConfigBuilder_.mergeFrom(value);
      }
      if (desiredL4IlbSubsettingConfig_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    public Builder clearDesiredL4IlbSubsettingConfig() {
      bitField0_ = (bitField0_ & ~0x00200000);
      desiredL4IlbSubsettingConfig_ = null;
      if (desiredL4IlbSubsettingConfigBuilder_ != null) {
        desiredL4IlbSubsettingConfigBuilder_.dispose();
        desiredL4IlbSubsettingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    public com.google.container.v1beta1.ILBSubsettingConfig.Builder
        getDesiredL4IlbSubsettingConfigBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getDesiredL4IlbSubsettingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    public com.google.container.v1beta1.ILBSubsettingConfigOrBuilder
        getDesiredL4IlbSubsettingConfigOrBuilder() {
      if (desiredL4IlbSubsettingConfigBuilder_ != null) {
        return desiredL4IlbSubsettingConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredL4IlbSubsettingConfig_ == null
            ? com.google.container.v1beta1.ILBSubsettingConfig.getDefaultInstance()
            : desiredL4IlbSubsettingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired L4 Internal Load Balancer Subsetting configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.ILBSubsettingConfig desired_l4ilb_subsetting_config = 39;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ILBSubsettingConfig,
            com.google.container.v1beta1.ILBSubsettingConfig.Builder,
            com.google.container.v1beta1.ILBSubsettingConfigOrBuilder>
        getDesiredL4IlbSubsettingConfigFieldBuilder() {
      if (desiredL4IlbSubsettingConfigBuilder_ == null) {
        desiredL4IlbSubsettingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ILBSubsettingConfig,
                com.google.container.v1beta1.ILBSubsettingConfig.Builder,
                com.google.container.v1beta1.ILBSubsettingConfigOrBuilder>(
                getDesiredL4IlbSubsettingConfig(), getParentForChildren(), isClean());
        desiredL4IlbSubsettingConfig_ = null;
      }
      return desiredL4IlbSubsettingConfigBuilder_;
    }

    private int desiredDatapathProvider_ = 0;
    /**
     *
     *
     * <pre>
     * The desired datapath provider for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
     *
     * @return The enum numeric value on the wire for desiredDatapathProvider.
     */
    @java.lang.Override
    public int getDesiredDatapathProviderValue() {
      return desiredDatapathProvider_;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
     *
     * @param value The enum numeric value on the wire for desiredDatapathProvider to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredDatapathProviderValue(int value) {
      desiredDatapathProvider_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
     *
     * @return The desiredDatapathProvider.
     */
    @java.lang.Override
    public com.google.container.v1beta1.DatapathProvider getDesiredDatapathProvider() {
      com.google.container.v1beta1.DatapathProvider result =
          com.google.container.v1beta1.DatapathProvider.forNumber(desiredDatapathProvider_);
      return result == null ? com.google.container.v1beta1.DatapathProvider.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
     *
     * @param value The desiredDatapathProvider to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredDatapathProvider(com.google.container.v1beta1.DatapathProvider value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00400000;
      desiredDatapathProvider_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired datapath provider for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatapathProvider desired_datapath_provider = 50;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredDatapathProvider() {
      bitField0_ = (bitField0_ & ~0x00400000);
      desiredDatapathProvider_ = 0;
      onChanged();
      return this;
    }

    private int desiredPrivateIpv6GoogleAccess_ = 0;
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
     * </code>
     *
     * @return The enum numeric value on the wire for desiredPrivateIpv6GoogleAccess.
     */
    @java.lang.Override
    public int getDesiredPrivateIpv6GoogleAccessValue() {
      return desiredPrivateIpv6GoogleAccess_;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
     * </code>
     *
     * @param value The enum numeric value on the wire for desiredPrivateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredPrivateIpv6GoogleAccessValue(int value) {
      desiredPrivateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
     * </code>
     *
     * @return The desiredPrivateIpv6GoogleAccess.
     */
    @java.lang.Override
    public com.google.container.v1beta1.PrivateIPv6GoogleAccess
        getDesiredPrivateIpv6GoogleAccess() {
      com.google.container.v1beta1.PrivateIPv6GoogleAccess result =
          com.google.container.v1beta1.PrivateIPv6GoogleAccess.forNumber(
              desiredPrivateIpv6GoogleAccess_);
      return result == null
          ? com.google.container.v1beta1.PrivateIPv6GoogleAccess.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
     * </code>
     *
     * @param value The desiredPrivateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredPrivateIpv6GoogleAccess(
        com.google.container.v1beta1.PrivateIPv6GoogleAccess value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00800000;
      desiredPrivateIpv6GoogleAccess_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired state of IPv6 connectivity to Google Services.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PrivateIPv6GoogleAccess desired_private_ipv6_google_access = 51;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredPrivateIpv6GoogleAccess() {
      bitField0_ = (bitField0_ & ~0x00800000);
      desiredPrivateIpv6GoogleAccess_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NotificationConfig desiredNotificationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NotificationConfig,
            com.google.container.v1beta1.NotificationConfig.Builder,
            com.google.container.v1beta1.NotificationConfigOrBuilder>
        desiredNotificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     *
     * @return Whether the desiredNotificationConfig field is set.
     */
    public boolean hasDesiredNotificationConfig() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     *
     * @return The desiredNotificationConfig.
     */
    public com.google.container.v1beta1.NotificationConfig getDesiredNotificationConfig() {
      if (desiredNotificationConfigBuilder_ == null) {
        return desiredNotificationConfig_ == null
            ? com.google.container.v1beta1.NotificationConfig.getDefaultInstance()
            : desiredNotificationConfig_;
      } else {
        return desiredNotificationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    public Builder setDesiredNotificationConfig(
        com.google.container.v1beta1.NotificationConfig value) {
      if (desiredNotificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNotificationConfig_ = value;
      } else {
        desiredNotificationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    public Builder setDesiredNotificationConfig(
        com.google.container.v1beta1.NotificationConfig.Builder builderForValue) {
      if (desiredNotificationConfigBuilder_ == null) {
        desiredNotificationConfig_ = builderForValue.build();
      } else {
        desiredNotificationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    public Builder mergeDesiredNotificationConfig(
        com.google.container.v1beta1.NotificationConfig value) {
      if (desiredNotificationConfigBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && desiredNotificationConfig_ != null
            && desiredNotificationConfig_
                != com.google.container.v1beta1.NotificationConfig.getDefaultInstance()) {
          getDesiredNotificationConfigBuilder().mergeFrom(value);
        } else {
          desiredNotificationConfig_ = value;
        }
      } else {
        desiredNotificationConfigBuilder_.mergeFrom(value);
      }
      if (desiredNotificationConfig_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    public Builder clearDesiredNotificationConfig() {
      bitField0_ = (bitField0_ & ~0x01000000);
      desiredNotificationConfig_ = null;
      if (desiredNotificationConfigBuilder_ != null) {
        desiredNotificationConfigBuilder_.dispose();
        desiredNotificationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    public com.google.container.v1beta1.NotificationConfig.Builder
        getDesiredNotificationConfigBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getDesiredNotificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    public com.google.container.v1beta1.NotificationConfigOrBuilder
        getDesiredNotificationConfigOrBuilder() {
      if (desiredNotificationConfigBuilder_ != null) {
        return desiredNotificationConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredNotificationConfig_ == null
            ? com.google.container.v1beta1.NotificationConfig.getDefaultInstance()
            : desiredNotificationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired notification configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig desired_notification_config = 55;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NotificationConfig,
            com.google.container.v1beta1.NotificationConfig.Builder,
            com.google.container.v1beta1.NotificationConfigOrBuilder>
        getDesiredNotificationConfigFieldBuilder() {
      if (desiredNotificationConfigBuilder_ == null) {
        desiredNotificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NotificationConfig,
                com.google.container.v1beta1.NotificationConfig.Builder,
                com.google.container.v1beta1.NotificationConfigOrBuilder>(
                getDesiredNotificationConfig(), getParentForChildren(), isClean());
        desiredNotificationConfig_ = null;
      }
      return desiredNotificationConfigBuilder_;
    }

    private java.lang.Object desiredMasterVersion_ = "";
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the master to. The only valid value is the
     * latest supported version.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string desired_master_version = 100;</code>
     *
     * @return The desiredMasterVersion.
     */
    public java.lang.String getDesiredMasterVersion() {
      java.lang.Object ref = desiredMasterVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        desiredMasterVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the master to. The only valid value is the
     * latest supported version.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string desired_master_version = 100;</code>
     *
     * @return The bytes for desiredMasterVersion.
     */
    public com.google.protobuf.ByteString getDesiredMasterVersionBytes() {
      java.lang.Object ref = desiredMasterVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        desiredMasterVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the master to. The only valid value is the
     * latest supported version.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string desired_master_version = 100;</code>
     *
     * @param value The desiredMasterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredMasterVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      desiredMasterVersion_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the master to. The only valid value is the
     * latest supported version.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string desired_master_version = 100;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredMasterVersion() {
      desiredMasterVersion_ = getDefaultInstance().getDesiredMasterVersion();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Kubernetes version to change the master to. The only valid value is the
     * latest supported version.
     *
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     *
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     * </pre>
     *
     * <code>string desired_master_version = 100;</code>
     *
     * @param value The bytes for desiredMasterVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredMasterVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      desiredMasterVersion_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.GcfsConfig desiredGcfsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcfsConfig,
            com.google.container.v1beta1.GcfsConfig.Builder,
            com.google.container.v1beta1.GcfsConfigOrBuilder>
        desiredGcfsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     *
     * @return Whether the desiredGcfsConfig field is set.
     */
    public boolean hasDesiredGcfsConfig() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     *
     * @return The desiredGcfsConfig.
     */
    public com.google.container.v1beta1.GcfsConfig getDesiredGcfsConfig() {
      if (desiredGcfsConfigBuilder_ == null) {
        return desiredGcfsConfig_ == null
            ? com.google.container.v1beta1.GcfsConfig.getDefaultInstance()
            : desiredGcfsConfig_;
      } else {
        return desiredGcfsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    public Builder setDesiredGcfsConfig(com.google.container.v1beta1.GcfsConfig value) {
      if (desiredGcfsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredGcfsConfig_ = value;
      } else {
        desiredGcfsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    public Builder setDesiredGcfsConfig(
        com.google.container.v1beta1.GcfsConfig.Builder builderForValue) {
      if (desiredGcfsConfigBuilder_ == null) {
        desiredGcfsConfig_ = builderForValue.build();
      } else {
        desiredGcfsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    public Builder mergeDesiredGcfsConfig(com.google.container.v1beta1.GcfsConfig value) {
      if (desiredGcfsConfigBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && desiredGcfsConfig_ != null
            && desiredGcfsConfig_ != com.google.container.v1beta1.GcfsConfig.getDefaultInstance()) {
          getDesiredGcfsConfigBuilder().mergeFrom(value);
        } else {
          desiredGcfsConfig_ = value;
        }
      } else {
        desiredGcfsConfigBuilder_.mergeFrom(value);
      }
      if (desiredGcfsConfig_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    public Builder clearDesiredGcfsConfig() {
      bitField0_ = (bitField0_ & ~0x04000000);
      desiredGcfsConfig_ = null;
      if (desiredGcfsConfigBuilder_ != null) {
        desiredGcfsConfigBuilder_.dispose();
        desiredGcfsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    public com.google.container.v1beta1.GcfsConfig.Builder getDesiredGcfsConfigBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getDesiredGcfsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    public com.google.container.v1beta1.GcfsConfigOrBuilder getDesiredGcfsConfigOrBuilder() {
      if (desiredGcfsConfigBuilder_ != null) {
        return desiredGcfsConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredGcfsConfig_ == null
            ? com.google.container.v1beta1.GcfsConfig.getDefaultInstance()
            : desiredGcfsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired GCFS config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GcfsConfig desired_gcfs_config = 109;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GcfsConfig,
            com.google.container.v1beta1.GcfsConfig.Builder,
            com.google.container.v1beta1.GcfsConfigOrBuilder>
        getDesiredGcfsConfigFieldBuilder() {
      if (desiredGcfsConfigBuilder_ == null) {
        desiredGcfsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GcfsConfig,
                com.google.container.v1beta1.GcfsConfig.Builder,
                com.google.container.v1beta1.GcfsConfigOrBuilder>(
                getDesiredGcfsConfig(), getParentForChildren(), isClean());
        desiredGcfsConfig_ = null;
      }
      return desiredGcfsConfigBuilder_;
    }

    private com.google.container.v1beta1.DatabaseEncryption desiredDatabaseEncryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DatabaseEncryption,
            com.google.container.v1beta1.DatabaseEncryption.Builder,
            com.google.container.v1beta1.DatabaseEncryptionOrBuilder>
        desiredDatabaseEncryptionBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     *
     * @return Whether the desiredDatabaseEncryption field is set.
     */
    public boolean hasDesiredDatabaseEncryption() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     *
     * @return The desiredDatabaseEncryption.
     */
    public com.google.container.v1beta1.DatabaseEncryption getDesiredDatabaseEncryption() {
      if (desiredDatabaseEncryptionBuilder_ == null) {
        return desiredDatabaseEncryption_ == null
            ? com.google.container.v1beta1.DatabaseEncryption.getDefaultInstance()
            : desiredDatabaseEncryption_;
      } else {
        return desiredDatabaseEncryptionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    public Builder setDesiredDatabaseEncryption(
        com.google.container.v1beta1.DatabaseEncryption value) {
      if (desiredDatabaseEncryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredDatabaseEncryption_ = value;
      } else {
        desiredDatabaseEncryptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    public Builder setDesiredDatabaseEncryption(
        com.google.container.v1beta1.DatabaseEncryption.Builder builderForValue) {
      if (desiredDatabaseEncryptionBuilder_ == null) {
        desiredDatabaseEncryption_ = builderForValue.build();
      } else {
        desiredDatabaseEncryptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    public Builder mergeDesiredDatabaseEncryption(
        com.google.container.v1beta1.DatabaseEncryption value) {
      if (desiredDatabaseEncryptionBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && desiredDatabaseEncryption_ != null
            && desiredDatabaseEncryption_
                != com.google.container.v1beta1.DatabaseEncryption.getDefaultInstance()) {
          getDesiredDatabaseEncryptionBuilder().mergeFrom(value);
        } else {
          desiredDatabaseEncryption_ = value;
        }
      } else {
        desiredDatabaseEncryptionBuilder_.mergeFrom(value);
      }
      if (desiredDatabaseEncryption_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    public Builder clearDesiredDatabaseEncryption() {
      bitField0_ = (bitField0_ & ~0x08000000);
      desiredDatabaseEncryption_ = null;
      if (desiredDatabaseEncryptionBuilder_ != null) {
        desiredDatabaseEncryptionBuilder_.dispose();
        desiredDatabaseEncryptionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    public com.google.container.v1beta1.DatabaseEncryption.Builder
        getDesiredDatabaseEncryptionBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getDesiredDatabaseEncryptionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    public com.google.container.v1beta1.DatabaseEncryptionOrBuilder
        getDesiredDatabaseEncryptionOrBuilder() {
      if (desiredDatabaseEncryptionBuilder_ != null) {
        return desiredDatabaseEncryptionBuilder_.getMessageOrBuilder();
      } else {
        return desiredDatabaseEncryption_ == null
            ? com.google.container.v1beta1.DatabaseEncryption.getDefaultInstance()
            : desiredDatabaseEncryption_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of etcd encryption.
     * </pre>
     *
     * <code>.google.container.v1beta1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DatabaseEncryption,
            com.google.container.v1beta1.DatabaseEncryption.Builder,
            com.google.container.v1beta1.DatabaseEncryptionOrBuilder>
        getDesiredDatabaseEncryptionFieldBuilder() {
      if (desiredDatabaseEncryptionBuilder_ == null) {
        desiredDatabaseEncryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.DatabaseEncryption,
                com.google.container.v1beta1.DatabaseEncryption.Builder,
                com.google.container.v1beta1.DatabaseEncryptionOrBuilder>(
                getDesiredDatabaseEncryption(), getParentForChildren(), isClean());
        desiredDatabaseEncryption_ = null;
      }
      return desiredDatabaseEncryptionBuilder_;
    }

    private com.google.container.v1beta1.WorkloadIdentityConfig desiredWorkloadIdentityConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadIdentityConfig,
            com.google.container.v1beta1.WorkloadIdentityConfig.Builder,
            com.google.container.v1beta1.WorkloadIdentityConfigOrBuilder>
        desiredWorkloadIdentityConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     *
     * @return Whether the desiredWorkloadIdentityConfig field is set.
     */
    public boolean hasDesiredWorkloadIdentityConfig() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     *
     * @return The desiredWorkloadIdentityConfig.
     */
    public com.google.container.v1beta1.WorkloadIdentityConfig getDesiredWorkloadIdentityConfig() {
      if (desiredWorkloadIdentityConfigBuilder_ == null) {
        return desiredWorkloadIdentityConfig_ == null
            ? com.google.container.v1beta1.WorkloadIdentityConfig.getDefaultInstance()
            : desiredWorkloadIdentityConfig_;
      } else {
        return desiredWorkloadIdentityConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    public Builder setDesiredWorkloadIdentityConfig(
        com.google.container.v1beta1.WorkloadIdentityConfig value) {
      if (desiredWorkloadIdentityConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredWorkloadIdentityConfig_ = value;
      } else {
        desiredWorkloadIdentityConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    public Builder setDesiredWorkloadIdentityConfig(
        com.google.container.v1beta1.WorkloadIdentityConfig.Builder builderForValue) {
      if (desiredWorkloadIdentityConfigBuilder_ == null) {
        desiredWorkloadIdentityConfig_ = builderForValue.build();
      } else {
        desiredWorkloadIdentityConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    public Builder mergeDesiredWorkloadIdentityConfig(
        com.google.container.v1beta1.WorkloadIdentityConfig value) {
      if (desiredWorkloadIdentityConfigBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && desiredWorkloadIdentityConfig_ != null
            && desiredWorkloadIdentityConfig_
                != com.google.container.v1beta1.WorkloadIdentityConfig.getDefaultInstance()) {
          getDesiredWorkloadIdentityConfigBuilder().mergeFrom(value);
        } else {
          desiredWorkloadIdentityConfig_ = value;
        }
      } else {
        desiredWorkloadIdentityConfigBuilder_.mergeFrom(value);
      }
      if (desiredWorkloadIdentityConfig_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    public Builder clearDesiredWorkloadIdentityConfig() {
      bitField0_ = (bitField0_ & ~0x10000000);
      desiredWorkloadIdentityConfig_ = null;
      if (desiredWorkloadIdentityConfigBuilder_ != null) {
        desiredWorkloadIdentityConfigBuilder_.dispose();
        desiredWorkloadIdentityConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    public com.google.container.v1beta1.WorkloadIdentityConfig.Builder
        getDesiredWorkloadIdentityConfigBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getDesiredWorkloadIdentityConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    public com.google.container.v1beta1.WorkloadIdentityConfigOrBuilder
        getDesiredWorkloadIdentityConfigOrBuilder() {
      if (desiredWorkloadIdentityConfigBuilder_ != null) {
        return desiredWorkloadIdentityConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredWorkloadIdentityConfig_ == null
            ? com.google.container.v1beta1.WorkloadIdentityConfig.getDefaultInstance()
            : desiredWorkloadIdentityConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Workload Identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadIdentityConfig desired_workload_identity_config = 47;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadIdentityConfig,
            com.google.container.v1beta1.WorkloadIdentityConfig.Builder,
            com.google.container.v1beta1.WorkloadIdentityConfigOrBuilder>
        getDesiredWorkloadIdentityConfigFieldBuilder() {
      if (desiredWorkloadIdentityConfigBuilder_ == null) {
        desiredWorkloadIdentityConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.WorkloadIdentityConfig,
                com.google.container.v1beta1.WorkloadIdentityConfig.Builder,
                com.google.container.v1beta1.WorkloadIdentityConfigOrBuilder>(
                getDesiredWorkloadIdentityConfig(), getParentForChildren(), isClean());
        desiredWorkloadIdentityConfig_ = null;
      }
      return desiredWorkloadIdentityConfigBuilder_;
    }

    private com.google.container.v1beta1.WorkloadCertificates desiredWorkloadCertificates_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadCertificates,
            com.google.container.v1beta1.WorkloadCertificates.Builder,
            com.google.container.v1beta1.WorkloadCertificatesOrBuilder>
        desiredWorkloadCertificatesBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     *
     * @return Whether the desiredWorkloadCertificates field is set.
     */
    public boolean hasDesiredWorkloadCertificates() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     *
     * @return The desiredWorkloadCertificates.
     */
    public com.google.container.v1beta1.WorkloadCertificates getDesiredWorkloadCertificates() {
      if (desiredWorkloadCertificatesBuilder_ == null) {
        return desiredWorkloadCertificates_ == null
            ? com.google.container.v1beta1.WorkloadCertificates.getDefaultInstance()
            : desiredWorkloadCertificates_;
      } else {
        return desiredWorkloadCertificatesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    public Builder setDesiredWorkloadCertificates(
        com.google.container.v1beta1.WorkloadCertificates value) {
      if (desiredWorkloadCertificatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredWorkloadCertificates_ = value;
      } else {
        desiredWorkloadCertificatesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    public Builder setDesiredWorkloadCertificates(
        com.google.container.v1beta1.WorkloadCertificates.Builder builderForValue) {
      if (desiredWorkloadCertificatesBuilder_ == null) {
        desiredWorkloadCertificates_ = builderForValue.build();
      } else {
        desiredWorkloadCertificatesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    public Builder mergeDesiredWorkloadCertificates(
        com.google.container.v1beta1.WorkloadCertificates value) {
      if (desiredWorkloadCertificatesBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && desiredWorkloadCertificates_ != null
            && desiredWorkloadCertificates_
                != com.google.container.v1beta1.WorkloadCertificates.getDefaultInstance()) {
          getDesiredWorkloadCertificatesBuilder().mergeFrom(value);
        } else {
          desiredWorkloadCertificates_ = value;
        }
      } else {
        desiredWorkloadCertificatesBuilder_.mergeFrom(value);
      }
      if (desiredWorkloadCertificates_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    public Builder clearDesiredWorkloadCertificates() {
      bitField0_ = (bitField0_ & ~0x20000000);
      desiredWorkloadCertificates_ = null;
      if (desiredWorkloadCertificatesBuilder_ != null) {
        desiredWorkloadCertificatesBuilder_.dispose();
        desiredWorkloadCertificatesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    public com.google.container.v1beta1.WorkloadCertificates.Builder
        getDesiredWorkloadCertificatesBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getDesiredWorkloadCertificatesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    public com.google.container.v1beta1.WorkloadCertificatesOrBuilder
        getDesiredWorkloadCertificatesOrBuilder() {
      if (desiredWorkloadCertificatesBuilder_ != null) {
        return desiredWorkloadCertificatesBuilder_.getMessageOrBuilder();
      } else {
        return desiredWorkloadCertificates_ == null
            ? com.google.container.v1beta1.WorkloadCertificates.getDefaultInstance()
            : desiredWorkloadCertificates_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadCertificates desired_workload_certificates = 61;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadCertificates,
            com.google.container.v1beta1.WorkloadCertificates.Builder,
            com.google.container.v1beta1.WorkloadCertificatesOrBuilder>
        getDesiredWorkloadCertificatesFieldBuilder() {
      if (desiredWorkloadCertificatesBuilder_ == null) {
        desiredWorkloadCertificatesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.WorkloadCertificates,
                com.google.container.v1beta1.WorkloadCertificates.Builder,
                com.google.container.v1beta1.WorkloadCertificatesOrBuilder>(
                getDesiredWorkloadCertificates(), getParentForChildren(), isClean());
        desiredWorkloadCertificates_ = null;
      }
      return desiredWorkloadCertificatesBuilder_;
    }

    private com.google.container.v1beta1.MeshCertificates desiredMeshCertificates_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.MeshCertificates,
            com.google.container.v1beta1.MeshCertificates.Builder,
            com.google.container.v1beta1.MeshCertificatesOrBuilder>
        desiredMeshCertificatesBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     *
     * @return Whether the desiredMeshCertificates field is set.
     */
    public boolean hasDesiredMeshCertificates() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     *
     * @return The desiredMeshCertificates.
     */
    public com.google.container.v1beta1.MeshCertificates getDesiredMeshCertificates() {
      if (desiredMeshCertificatesBuilder_ == null) {
        return desiredMeshCertificates_ == null
            ? com.google.container.v1beta1.MeshCertificates.getDefaultInstance()
            : desiredMeshCertificates_;
      } else {
        return desiredMeshCertificatesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    public Builder setDesiredMeshCertificates(com.google.container.v1beta1.MeshCertificates value) {
      if (desiredMeshCertificatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredMeshCertificates_ = value;
      } else {
        desiredMeshCertificatesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    public Builder setDesiredMeshCertificates(
        com.google.container.v1beta1.MeshCertificates.Builder builderForValue) {
      if (desiredMeshCertificatesBuilder_ == null) {
        desiredMeshCertificates_ = builderForValue.build();
      } else {
        desiredMeshCertificatesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    public Builder mergeDesiredMeshCertificates(
        com.google.container.v1beta1.MeshCertificates value) {
      if (desiredMeshCertificatesBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && desiredMeshCertificates_ != null
            && desiredMeshCertificates_
                != com.google.container.v1beta1.MeshCertificates.getDefaultInstance()) {
          getDesiredMeshCertificatesBuilder().mergeFrom(value);
        } else {
          desiredMeshCertificates_ = value;
        }
      } else {
        desiredMeshCertificatesBuilder_.mergeFrom(value);
      }
      if (desiredMeshCertificates_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    public Builder clearDesiredMeshCertificates() {
      bitField0_ = (bitField0_ & ~0x40000000);
      desiredMeshCertificates_ = null;
      if (desiredMeshCertificatesBuilder_ != null) {
        desiredMeshCertificatesBuilder_.dispose();
        desiredMeshCertificatesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    public com.google.container.v1beta1.MeshCertificates.Builder
        getDesiredMeshCertificatesBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getDesiredMeshCertificatesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    public com.google.container.v1beta1.MeshCertificatesOrBuilder
        getDesiredMeshCertificatesOrBuilder() {
      if (desiredMeshCertificatesBuilder_ != null) {
        return desiredMeshCertificatesBuilder_.getMessageOrBuilder();
      } else {
        return desiredMeshCertificates_ == null
            ? com.google.container.v1beta1.MeshCertificates.getDefaultInstance()
            : desiredMeshCertificates_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for issuance of mTLS keys and certificates to Kubernetes
     * pods.
     * </pre>
     *
     * <code>.google.container.v1beta1.MeshCertificates desired_mesh_certificates = 67;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.MeshCertificates,
            com.google.container.v1beta1.MeshCertificates.Builder,
            com.google.container.v1beta1.MeshCertificatesOrBuilder>
        getDesiredMeshCertificatesFieldBuilder() {
      if (desiredMeshCertificatesBuilder_ == null) {
        desiredMeshCertificatesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.MeshCertificates,
                com.google.container.v1beta1.MeshCertificates.Builder,
                com.google.container.v1beta1.MeshCertificatesOrBuilder>(
                getDesiredMeshCertificates(), getParentForChildren(), isClean());
        desiredMeshCertificates_ = null;
      }
      return desiredMeshCertificatesBuilder_;
    }

    private com.google.container.v1beta1.WorkloadALTSConfig desiredWorkloadAltsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadALTSConfig,
            com.google.container.v1beta1.WorkloadALTSConfig.Builder,
            com.google.container.v1beta1.WorkloadALTSConfigOrBuilder>
        desiredWorkloadAltsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     *
     * @return Whether the desiredWorkloadAltsConfig field is set.
     */
    public boolean hasDesiredWorkloadAltsConfig() {
      return ((bitField0_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     *
     * @return The desiredWorkloadAltsConfig.
     */
    public com.google.container.v1beta1.WorkloadALTSConfig getDesiredWorkloadAltsConfig() {
      if (desiredWorkloadAltsConfigBuilder_ == null) {
        return desiredWorkloadAltsConfig_ == null
            ? com.google.container.v1beta1.WorkloadALTSConfig.getDefaultInstance()
            : desiredWorkloadAltsConfig_;
      } else {
        return desiredWorkloadAltsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    public Builder setDesiredWorkloadAltsConfig(
        com.google.container.v1beta1.WorkloadALTSConfig value) {
      if (desiredWorkloadAltsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredWorkloadAltsConfig_ = value;
      } else {
        desiredWorkloadAltsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    public Builder setDesiredWorkloadAltsConfig(
        com.google.container.v1beta1.WorkloadALTSConfig.Builder builderForValue) {
      if (desiredWorkloadAltsConfigBuilder_ == null) {
        desiredWorkloadAltsConfig_ = builderForValue.build();
      } else {
        desiredWorkloadAltsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    public Builder mergeDesiredWorkloadAltsConfig(
        com.google.container.v1beta1.WorkloadALTSConfig value) {
      if (desiredWorkloadAltsConfigBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && desiredWorkloadAltsConfig_ != null
            && desiredWorkloadAltsConfig_
                != com.google.container.v1beta1.WorkloadALTSConfig.getDefaultInstance()) {
          getDesiredWorkloadAltsConfigBuilder().mergeFrom(value);
        } else {
          desiredWorkloadAltsConfig_ = value;
        }
      } else {
        desiredWorkloadAltsConfigBuilder_.mergeFrom(value);
      }
      if (desiredWorkloadAltsConfig_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    public Builder clearDesiredWorkloadAltsConfig() {
      bitField0_ = (bitField0_ & ~0x80000000);
      desiredWorkloadAltsConfig_ = null;
      if (desiredWorkloadAltsConfigBuilder_ != null) {
        desiredWorkloadAltsConfigBuilder_.dispose();
        desiredWorkloadAltsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    public com.google.container.v1beta1.WorkloadALTSConfig.Builder
        getDesiredWorkloadAltsConfigBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getDesiredWorkloadAltsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    public com.google.container.v1beta1.WorkloadALTSConfigOrBuilder
        getDesiredWorkloadAltsConfigOrBuilder() {
      if (desiredWorkloadAltsConfigBuilder_ != null) {
        return desiredWorkloadAltsConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredWorkloadAltsConfig_ == null
            ? com.google.container.v1beta1.WorkloadALTSConfig.getDefaultInstance()
            : desiredWorkloadAltsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for direct-path (via ALTS) with workload identity.
     * </pre>
     *
     * <code>.google.container.v1beta1.WorkloadALTSConfig desired_workload_alts_config = 62;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadALTSConfig,
            com.google.container.v1beta1.WorkloadALTSConfig.Builder,
            com.google.container.v1beta1.WorkloadALTSConfigOrBuilder>
        getDesiredWorkloadAltsConfigFieldBuilder() {
      if (desiredWorkloadAltsConfigBuilder_ == null) {
        desiredWorkloadAltsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.WorkloadALTSConfig,
                com.google.container.v1beta1.WorkloadALTSConfig.Builder,
                com.google.container.v1beta1.WorkloadALTSConfigOrBuilder>(
                getDesiredWorkloadAltsConfig(), getParentForChildren(), isClean());
        desiredWorkloadAltsConfig_ = null;
      }
      return desiredWorkloadAltsConfigBuilder_;
    }

    private com.google.container.v1beta1.ShieldedNodes desiredShieldedNodes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ShieldedNodes,
            com.google.container.v1beta1.ShieldedNodes.Builder,
            com.google.container.v1beta1.ShieldedNodesOrBuilder>
        desiredShieldedNodesBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     *
     * @return Whether the desiredShieldedNodes field is set.
     */
    public boolean hasDesiredShieldedNodes() {
      return ((bitField1_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     *
     * @return The desiredShieldedNodes.
     */
    public com.google.container.v1beta1.ShieldedNodes getDesiredShieldedNodes() {
      if (desiredShieldedNodesBuilder_ == null) {
        return desiredShieldedNodes_ == null
            ? com.google.container.v1beta1.ShieldedNodes.getDefaultInstance()
            : desiredShieldedNodes_;
      } else {
        return desiredShieldedNodesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    public Builder setDesiredShieldedNodes(com.google.container.v1beta1.ShieldedNodes value) {
      if (desiredShieldedNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredShieldedNodes_ = value;
      } else {
        desiredShieldedNodesBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    public Builder setDesiredShieldedNodes(
        com.google.container.v1beta1.ShieldedNodes.Builder builderForValue) {
      if (desiredShieldedNodesBuilder_ == null) {
        desiredShieldedNodes_ = builderForValue.build();
      } else {
        desiredShieldedNodesBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    public Builder mergeDesiredShieldedNodes(com.google.container.v1beta1.ShieldedNodes value) {
      if (desiredShieldedNodesBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)
            && desiredShieldedNodes_ != null
            && desiredShieldedNodes_
                != com.google.container.v1beta1.ShieldedNodes.getDefaultInstance()) {
          getDesiredShieldedNodesBuilder().mergeFrom(value);
        } else {
          desiredShieldedNodes_ = value;
        }
      } else {
        desiredShieldedNodesBuilder_.mergeFrom(value);
      }
      if (desiredShieldedNodes_ != null) {
        bitField1_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    public Builder clearDesiredShieldedNodes() {
      bitField1_ = (bitField1_ & ~0x00000001);
      desiredShieldedNodes_ = null;
      if (desiredShieldedNodesBuilder_ != null) {
        desiredShieldedNodesBuilder_.dispose();
        desiredShieldedNodesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    public com.google.container.v1beta1.ShieldedNodes.Builder getDesiredShieldedNodesBuilder() {
      bitField1_ |= 0x00000001;
      onChanged();
      return getDesiredShieldedNodesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    public com.google.container.v1beta1.ShieldedNodesOrBuilder getDesiredShieldedNodesOrBuilder() {
      if (desiredShieldedNodesBuilder_ != null) {
        return desiredShieldedNodesBuilder_.getMessageOrBuilder();
      } else {
        return desiredShieldedNodes_ == null
            ? com.google.container.v1beta1.ShieldedNodes.getDefaultInstance()
            : desiredShieldedNodes_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for Shielded Nodes.
     * </pre>
     *
     * <code>.google.container.v1beta1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ShieldedNodes,
            com.google.container.v1beta1.ShieldedNodes.Builder,
            com.google.container.v1beta1.ShieldedNodesOrBuilder>
        getDesiredShieldedNodesFieldBuilder() {
      if (desiredShieldedNodesBuilder_ == null) {
        desiredShieldedNodesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ShieldedNodes,
                com.google.container.v1beta1.ShieldedNodes.Builder,
                com.google.container.v1beta1.ShieldedNodesOrBuilder>(
                getDesiredShieldedNodes(), getParentForChildren(), isClean());
        desiredShieldedNodes_ = null;
      }
      return desiredShieldedNodesBuilder_;
    }

    private com.google.container.v1beta1.CostManagementConfig desiredCostManagementConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.CostManagementConfig,
            com.google.container.v1beta1.CostManagementConfig.Builder,
            com.google.container.v1beta1.CostManagementConfigOrBuilder>
        desiredCostManagementConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     *
     * @return Whether the desiredCostManagementConfig field is set.
     */
    public boolean hasDesiredCostManagementConfig() {
      return ((bitField1_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     *
     * @return The desiredCostManagementConfig.
     */
    public com.google.container.v1beta1.CostManagementConfig getDesiredCostManagementConfig() {
      if (desiredCostManagementConfigBuilder_ == null) {
        return desiredCostManagementConfig_ == null
            ? com.google.container.v1beta1.CostManagementConfig.getDefaultInstance()
            : desiredCostManagementConfig_;
      } else {
        return desiredCostManagementConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    public Builder setDesiredCostManagementConfig(
        com.google.container.v1beta1.CostManagementConfig value) {
      if (desiredCostManagementConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredCostManagementConfig_ = value;
      } else {
        desiredCostManagementConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    public Builder setDesiredCostManagementConfig(
        com.google.container.v1beta1.CostManagementConfig.Builder builderForValue) {
      if (desiredCostManagementConfigBuilder_ == null) {
        desiredCostManagementConfig_ = builderForValue.build();
      } else {
        desiredCostManagementConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    public Builder mergeDesiredCostManagementConfig(
        com.google.container.v1beta1.CostManagementConfig value) {
      if (desiredCostManagementConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000002) != 0)
            && desiredCostManagementConfig_ != null
            && desiredCostManagementConfig_
                != com.google.container.v1beta1.CostManagementConfig.getDefaultInstance()) {
          getDesiredCostManagementConfigBuilder().mergeFrom(value);
        } else {
          desiredCostManagementConfig_ = value;
        }
      } else {
        desiredCostManagementConfigBuilder_.mergeFrom(value);
      }
      if (desiredCostManagementConfig_ != null) {
        bitField1_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    public Builder clearDesiredCostManagementConfig() {
      bitField1_ = (bitField1_ & ~0x00000002);
      desiredCostManagementConfig_ = null;
      if (desiredCostManagementConfigBuilder_ != null) {
        desiredCostManagementConfigBuilder_.dispose();
        desiredCostManagementConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    public com.google.container.v1beta1.CostManagementConfig.Builder
        getDesiredCostManagementConfigBuilder() {
      bitField1_ |= 0x00000002;
      onChanged();
      return getDesiredCostManagementConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    public com.google.container.v1beta1.CostManagementConfigOrBuilder
        getDesiredCostManagementConfigOrBuilder() {
      if (desiredCostManagementConfigBuilder_ != null) {
        return desiredCostManagementConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredCostManagementConfig_ == null
            ? com.google.container.v1beta1.CostManagementConfig.getDefaultInstance()
            : desiredCostManagementConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired configuration for the fine-grained cost management feature.
     * </pre>
     *
     * <code>.google.container.v1beta1.CostManagementConfig desired_cost_management_config = 49;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.CostManagementConfig,
            com.google.container.v1beta1.CostManagementConfig.Builder,
            com.google.container.v1beta1.CostManagementConfigOrBuilder>
        getDesiredCostManagementConfigFieldBuilder() {
      if (desiredCostManagementConfigBuilder_ == null) {
        desiredCostManagementConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.CostManagementConfig,
                com.google.container.v1beta1.CostManagementConfig.Builder,
                com.google.container.v1beta1.CostManagementConfigOrBuilder>(
                getDesiredCostManagementConfig(), getParentForChildren(), isClean());
        desiredCostManagementConfig_ = null;
      }
      return desiredCostManagementConfigBuilder_;
    }

    private com.google.container.v1beta1.Master desiredMaster_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.Master,
            com.google.container.v1beta1.Master.Builder,
            com.google.container.v1beta1.MasterOrBuilder>
        desiredMasterBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     *
     * @return Whether the desiredMaster field is set.
     */
    public boolean hasDesiredMaster() {
      return ((bitField1_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     *
     * @return The desiredMaster.
     */
    public com.google.container.v1beta1.Master getDesiredMaster() {
      if (desiredMasterBuilder_ == null) {
        return desiredMaster_ == null
            ? com.google.container.v1beta1.Master.getDefaultInstance()
            : desiredMaster_;
      } else {
        return desiredMasterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    public Builder setDesiredMaster(com.google.container.v1beta1.Master value) {
      if (desiredMasterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredMaster_ = value;
      } else {
        desiredMasterBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    public Builder setDesiredMaster(com.google.container.v1beta1.Master.Builder builderForValue) {
      if (desiredMasterBuilder_ == null) {
        desiredMaster_ = builderForValue.build();
      } else {
        desiredMasterBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    public Builder mergeDesiredMaster(com.google.container.v1beta1.Master value) {
      if (desiredMasterBuilder_ == null) {
        if (((bitField1_ & 0x00000004) != 0)
            && desiredMaster_ != null
            && desiredMaster_ != com.google.container.v1beta1.Master.getDefaultInstance()) {
          getDesiredMasterBuilder().mergeFrom(value);
        } else {
          desiredMaster_ = value;
        }
      } else {
        desiredMasterBuilder_.mergeFrom(value);
      }
      if (desiredMaster_ != null) {
        bitField1_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    public Builder clearDesiredMaster() {
      bitField1_ = (bitField1_ & ~0x00000004);
      desiredMaster_ = null;
      if (desiredMasterBuilder_ != null) {
        desiredMasterBuilder_.dispose();
        desiredMasterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    public com.google.container.v1beta1.Master.Builder getDesiredMasterBuilder() {
      bitField1_ |= 0x00000004;
      onChanged();
      return getDesiredMasterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    public com.google.container.v1beta1.MasterOrBuilder getDesiredMasterOrBuilder() {
      if (desiredMasterBuilder_ != null) {
        return desiredMasterBuilder_.getMessageOrBuilder();
      } else {
        return desiredMaster_ == null
            ? com.google.container.v1beta1.Master.getDefaultInstance()
            : desiredMaster_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for master components.
     * </pre>
     *
     * <code>.google.container.v1beta1.Master desired_master = 52;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.Master,
            com.google.container.v1beta1.Master.Builder,
            com.google.container.v1beta1.MasterOrBuilder>
        getDesiredMasterFieldBuilder() {
      if (desiredMasterBuilder_ == null) {
        desiredMasterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.Master,
                com.google.container.v1beta1.Master.Builder,
                com.google.container.v1beta1.MasterOrBuilder>(
                getDesiredMaster(), getParentForChildren(), isClean());
        desiredMaster_ = null;
      }
      return desiredMasterBuilder_;
    }

    private com.google.container.v1beta1.DNSConfig desiredDnsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DNSConfig,
            com.google.container.v1beta1.DNSConfig.Builder,
            com.google.container.v1beta1.DNSConfigOrBuilder>
        desiredDnsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     *
     * @return Whether the desiredDnsConfig field is set.
     */
    public boolean hasDesiredDnsConfig() {
      return ((bitField1_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     *
     * @return The desiredDnsConfig.
     */
    public com.google.container.v1beta1.DNSConfig getDesiredDnsConfig() {
      if (desiredDnsConfigBuilder_ == null) {
        return desiredDnsConfig_ == null
            ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
            : desiredDnsConfig_;
      } else {
        return desiredDnsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    public Builder setDesiredDnsConfig(com.google.container.v1beta1.DNSConfig value) {
      if (desiredDnsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredDnsConfig_ = value;
      } else {
        desiredDnsConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    public Builder setDesiredDnsConfig(
        com.google.container.v1beta1.DNSConfig.Builder builderForValue) {
      if (desiredDnsConfigBuilder_ == null) {
        desiredDnsConfig_ = builderForValue.build();
      } else {
        desiredDnsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    public Builder mergeDesiredDnsConfig(com.google.container.v1beta1.DNSConfig value) {
      if (desiredDnsConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000008) != 0)
            && desiredDnsConfig_ != null
            && desiredDnsConfig_ != com.google.container.v1beta1.DNSConfig.getDefaultInstance()) {
          getDesiredDnsConfigBuilder().mergeFrom(value);
        } else {
          desiredDnsConfig_ = value;
        }
      } else {
        desiredDnsConfigBuilder_.mergeFrom(value);
      }
      if (desiredDnsConfig_ != null) {
        bitField1_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    public Builder clearDesiredDnsConfig() {
      bitField1_ = (bitField1_ & ~0x00000008);
      desiredDnsConfig_ = null;
      if (desiredDnsConfigBuilder_ != null) {
        desiredDnsConfigBuilder_.dispose();
        desiredDnsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    public com.google.container.v1beta1.DNSConfig.Builder getDesiredDnsConfigBuilder() {
      bitField1_ |= 0x00000008;
      onChanged();
      return getDesiredDnsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    public com.google.container.v1beta1.DNSConfigOrBuilder getDesiredDnsConfigOrBuilder() {
      if (desiredDnsConfigBuilder_ != null) {
        return desiredDnsConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredDnsConfig_ == null
            ? com.google.container.v1beta1.DNSConfig.getDefaultInstance()
            : desiredDnsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * DNSConfig contains clusterDNS config for this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.DNSConfig desired_dns_config = 53;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.DNSConfig,
            com.google.container.v1beta1.DNSConfig.Builder,
            com.google.container.v1beta1.DNSConfigOrBuilder>
        getDesiredDnsConfigFieldBuilder() {
      if (desiredDnsConfigBuilder_ == null) {
        desiredDnsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.DNSConfig,
                com.google.container.v1beta1.DNSConfig.Builder,
                com.google.container.v1beta1.DNSConfigOrBuilder>(
                getDesiredDnsConfig(), getParentForChildren(), isClean());
        desiredDnsConfig_ = null;
      }
      return desiredDnsConfigBuilder_;
    }

    private com.google.container.v1beta1.ServiceExternalIPsConfig desiredServiceExternalIpsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ServiceExternalIPsConfig,
            com.google.container.v1beta1.ServiceExternalIPsConfig.Builder,
            com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder>
        desiredServiceExternalIpsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     *
     * @return Whether the desiredServiceExternalIpsConfig field is set.
     */
    public boolean hasDesiredServiceExternalIpsConfig() {
      return ((bitField1_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     *
     * @return The desiredServiceExternalIpsConfig.
     */
    public com.google.container.v1beta1.ServiceExternalIPsConfig
        getDesiredServiceExternalIpsConfig() {
      if (desiredServiceExternalIpsConfigBuilder_ == null) {
        return desiredServiceExternalIpsConfig_ == null
            ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
            : desiredServiceExternalIpsConfig_;
      } else {
        return desiredServiceExternalIpsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    public Builder setDesiredServiceExternalIpsConfig(
        com.google.container.v1beta1.ServiceExternalIPsConfig value) {
      if (desiredServiceExternalIpsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredServiceExternalIpsConfig_ = value;
      } else {
        desiredServiceExternalIpsConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    public Builder setDesiredServiceExternalIpsConfig(
        com.google.container.v1beta1.ServiceExternalIPsConfig.Builder builderForValue) {
      if (desiredServiceExternalIpsConfigBuilder_ == null) {
        desiredServiceExternalIpsConfig_ = builderForValue.build();
      } else {
        desiredServiceExternalIpsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    public Builder mergeDesiredServiceExternalIpsConfig(
        com.google.container.v1beta1.ServiceExternalIPsConfig value) {
      if (desiredServiceExternalIpsConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000010) != 0)
            && desiredServiceExternalIpsConfig_ != null
            && desiredServiceExternalIpsConfig_
                != com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()) {
          getDesiredServiceExternalIpsConfigBuilder().mergeFrom(value);
        } else {
          desiredServiceExternalIpsConfig_ = value;
        }
      } else {
        desiredServiceExternalIpsConfigBuilder_.mergeFrom(value);
      }
      if (desiredServiceExternalIpsConfig_ != null) {
        bitField1_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    public Builder clearDesiredServiceExternalIpsConfig() {
      bitField1_ = (bitField1_ & ~0x00000010);
      desiredServiceExternalIpsConfig_ = null;
      if (desiredServiceExternalIpsConfigBuilder_ != null) {
        desiredServiceExternalIpsConfigBuilder_.dispose();
        desiredServiceExternalIpsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    public com.google.container.v1beta1.ServiceExternalIPsConfig.Builder
        getDesiredServiceExternalIpsConfigBuilder() {
      bitField1_ |= 0x00000010;
      onChanged();
      return getDesiredServiceExternalIpsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    public com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder
        getDesiredServiceExternalIpsConfigOrBuilder() {
      if (desiredServiceExternalIpsConfigBuilder_ != null) {
        return desiredServiceExternalIpsConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredServiceExternalIpsConfig_ == null
            ? com.google.container.v1beta1.ServiceExternalIPsConfig.getDefaultInstance()
            : desiredServiceExternalIpsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * ServiceExternalIPsConfig specifies the config for the use of Services with
     * ExternalIPs field.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ServiceExternalIPsConfig desired_service_external_ips_config = 60;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ServiceExternalIPsConfig,
            com.google.container.v1beta1.ServiceExternalIPsConfig.Builder,
            com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder>
        getDesiredServiceExternalIpsConfigFieldBuilder() {
      if (desiredServiceExternalIpsConfigBuilder_ == null) {
        desiredServiceExternalIpsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ServiceExternalIPsConfig,
                com.google.container.v1beta1.ServiceExternalIPsConfig.Builder,
                com.google.container.v1beta1.ServiceExternalIPsConfigOrBuilder>(
                getDesiredServiceExternalIpsConfig(), getParentForChildren(), isClean());
        desiredServiceExternalIpsConfig_ = null;
      }
      return desiredServiceExternalIpsConfigBuilder_;
    }

    private com.google.container.v1beta1.AuthenticatorGroupsConfig
        desiredAuthenticatorGroupsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AuthenticatorGroupsConfig,
            com.google.container.v1beta1.AuthenticatorGroupsConfig.Builder,
            com.google.container.v1beta1.AuthenticatorGroupsConfigOrBuilder>
        desiredAuthenticatorGroupsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     *
     * @return Whether the desiredAuthenticatorGroupsConfig field is set.
     */
    public boolean hasDesiredAuthenticatorGroupsConfig() {
      return ((bitField1_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     *
     * @return The desiredAuthenticatorGroupsConfig.
     */
    public com.google.container.v1beta1.AuthenticatorGroupsConfig
        getDesiredAuthenticatorGroupsConfig() {
      if (desiredAuthenticatorGroupsConfigBuilder_ == null) {
        return desiredAuthenticatorGroupsConfig_ == null
            ? com.google.container.v1beta1.AuthenticatorGroupsConfig.getDefaultInstance()
            : desiredAuthenticatorGroupsConfig_;
      } else {
        return desiredAuthenticatorGroupsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    public Builder setDesiredAuthenticatorGroupsConfig(
        com.google.container.v1beta1.AuthenticatorGroupsConfig value) {
      if (desiredAuthenticatorGroupsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredAuthenticatorGroupsConfig_ = value;
      } else {
        desiredAuthenticatorGroupsConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    public Builder setDesiredAuthenticatorGroupsConfig(
        com.google.container.v1beta1.AuthenticatorGroupsConfig.Builder builderForValue) {
      if (desiredAuthenticatorGroupsConfigBuilder_ == null) {
        desiredAuthenticatorGroupsConfig_ = builderForValue.build();
      } else {
        desiredAuthenticatorGroupsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    public Builder mergeDesiredAuthenticatorGroupsConfig(
        com.google.container.v1beta1.AuthenticatorGroupsConfig value) {
      if (desiredAuthenticatorGroupsConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000020) != 0)
            && desiredAuthenticatorGroupsConfig_ != null
            && desiredAuthenticatorGroupsConfig_
                != com.google.container.v1beta1.AuthenticatorGroupsConfig.getDefaultInstance()) {
          getDesiredAuthenticatorGroupsConfigBuilder().mergeFrom(value);
        } else {
          desiredAuthenticatorGroupsConfig_ = value;
        }
      } else {
        desiredAuthenticatorGroupsConfigBuilder_.mergeFrom(value);
      }
      if (desiredAuthenticatorGroupsConfig_ != null) {
        bitField1_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    public Builder clearDesiredAuthenticatorGroupsConfig() {
      bitField1_ = (bitField1_ & ~0x00000020);
      desiredAuthenticatorGroupsConfig_ = null;
      if (desiredAuthenticatorGroupsConfigBuilder_ != null) {
        desiredAuthenticatorGroupsConfigBuilder_.dispose();
        desiredAuthenticatorGroupsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    public com.google.container.v1beta1.AuthenticatorGroupsConfig.Builder
        getDesiredAuthenticatorGroupsConfigBuilder() {
      bitField1_ |= 0x00000020;
      onChanged();
      return getDesiredAuthenticatorGroupsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    public com.google.container.v1beta1.AuthenticatorGroupsConfigOrBuilder
        getDesiredAuthenticatorGroupsConfigOrBuilder() {
      if (desiredAuthenticatorGroupsConfigBuilder_ != null) {
        return desiredAuthenticatorGroupsConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredAuthenticatorGroupsConfig_ == null
            ? com.google.container.v1beta1.AuthenticatorGroupsConfig.getDefaultInstance()
            : desiredAuthenticatorGroupsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * AuthenticatorGroupsConfig specifies the config for the cluster security
     * groups settings.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AuthenticatorGroupsConfig,
            com.google.container.v1beta1.AuthenticatorGroupsConfig.Builder,
            com.google.container.v1beta1.AuthenticatorGroupsConfigOrBuilder>
        getDesiredAuthenticatorGroupsConfigFieldBuilder() {
      if (desiredAuthenticatorGroupsConfigBuilder_ == null) {
        desiredAuthenticatorGroupsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.AuthenticatorGroupsConfig,
                com.google.container.v1beta1.AuthenticatorGroupsConfig.Builder,
                com.google.container.v1beta1.AuthenticatorGroupsConfigOrBuilder>(
                getDesiredAuthenticatorGroupsConfig(), getParentForChildren(), isClean());
        desiredAuthenticatorGroupsConfig_ = null;
      }
      return desiredAuthenticatorGroupsConfigBuilder_;
    }

    private com.google.container.v1beta1.LoggingConfig desiredLoggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.LoggingConfig,
            com.google.container.v1beta1.LoggingConfig.Builder,
            com.google.container.v1beta1.LoggingConfigOrBuilder>
        desiredLoggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     *
     * @return Whether the desiredLoggingConfig field is set.
     */
    public boolean hasDesiredLoggingConfig() {
      return ((bitField1_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     *
     * @return The desiredLoggingConfig.
     */
    public com.google.container.v1beta1.LoggingConfig getDesiredLoggingConfig() {
      if (desiredLoggingConfigBuilder_ == null) {
        return desiredLoggingConfig_ == null
            ? com.google.container.v1beta1.LoggingConfig.getDefaultInstance()
            : desiredLoggingConfig_;
      } else {
        return desiredLoggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    public Builder setDesiredLoggingConfig(com.google.container.v1beta1.LoggingConfig value) {
      if (desiredLoggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredLoggingConfig_ = value;
      } else {
        desiredLoggingConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    public Builder setDesiredLoggingConfig(
        com.google.container.v1beta1.LoggingConfig.Builder builderForValue) {
      if (desiredLoggingConfigBuilder_ == null) {
        desiredLoggingConfig_ = builderForValue.build();
      } else {
        desiredLoggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    public Builder mergeDesiredLoggingConfig(com.google.container.v1beta1.LoggingConfig value) {
      if (desiredLoggingConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000040) != 0)
            && desiredLoggingConfig_ != null
            && desiredLoggingConfig_
                != com.google.container.v1beta1.LoggingConfig.getDefaultInstance()) {
          getDesiredLoggingConfigBuilder().mergeFrom(value);
        } else {
          desiredLoggingConfig_ = value;
        }
      } else {
        desiredLoggingConfigBuilder_.mergeFrom(value);
      }
      if (desiredLoggingConfig_ != null) {
        bitField1_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    public Builder clearDesiredLoggingConfig() {
      bitField1_ = (bitField1_ & ~0x00000040);
      desiredLoggingConfig_ = null;
      if (desiredLoggingConfigBuilder_ != null) {
        desiredLoggingConfigBuilder_.dispose();
        desiredLoggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    public com.google.container.v1beta1.LoggingConfig.Builder getDesiredLoggingConfigBuilder() {
      bitField1_ |= 0x00000040;
      onChanged();
      return getDesiredLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    public com.google.container.v1beta1.LoggingConfigOrBuilder getDesiredLoggingConfigOrBuilder() {
      if (desiredLoggingConfigBuilder_ != null) {
        return desiredLoggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredLoggingConfig_ == null
            ? com.google.container.v1beta1.LoggingConfig.getDefaultInstance()
            : desiredLoggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired logging configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.LoggingConfig desired_logging_config = 64;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.LoggingConfig,
            com.google.container.v1beta1.LoggingConfig.Builder,
            com.google.container.v1beta1.LoggingConfigOrBuilder>
        getDesiredLoggingConfigFieldBuilder() {
      if (desiredLoggingConfigBuilder_ == null) {
        desiredLoggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.LoggingConfig,
                com.google.container.v1beta1.LoggingConfig.Builder,
                com.google.container.v1beta1.LoggingConfigOrBuilder>(
                getDesiredLoggingConfig(), getParentForChildren(), isClean());
        desiredLoggingConfig_ = null;
      }
      return desiredLoggingConfigBuilder_;
    }

    private com.google.container.v1beta1.MonitoringConfig desiredMonitoringConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.MonitoringConfig,
            com.google.container.v1beta1.MonitoringConfig.Builder,
            com.google.container.v1beta1.MonitoringConfigOrBuilder>
        desiredMonitoringConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     *
     * @return Whether the desiredMonitoringConfig field is set.
     */
    public boolean hasDesiredMonitoringConfig() {
      return ((bitField1_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     *
     * @return The desiredMonitoringConfig.
     */
    public com.google.container.v1beta1.MonitoringConfig getDesiredMonitoringConfig() {
      if (desiredMonitoringConfigBuilder_ == null) {
        return desiredMonitoringConfig_ == null
            ? com.google.container.v1beta1.MonitoringConfig.getDefaultInstance()
            : desiredMonitoringConfig_;
      } else {
        return desiredMonitoringConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    public Builder setDesiredMonitoringConfig(com.google.container.v1beta1.MonitoringConfig value) {
      if (desiredMonitoringConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredMonitoringConfig_ = value;
      } else {
        desiredMonitoringConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    public Builder setDesiredMonitoringConfig(
        com.google.container.v1beta1.MonitoringConfig.Builder builderForValue) {
      if (desiredMonitoringConfigBuilder_ == null) {
        desiredMonitoringConfig_ = builderForValue.build();
      } else {
        desiredMonitoringConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    public Builder mergeDesiredMonitoringConfig(
        com.google.container.v1beta1.MonitoringConfig value) {
      if (desiredMonitoringConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000080) != 0)
            && desiredMonitoringConfig_ != null
            && desiredMonitoringConfig_
                != com.google.container.v1beta1.MonitoringConfig.getDefaultInstance()) {
          getDesiredMonitoringConfigBuilder().mergeFrom(value);
        } else {
          desiredMonitoringConfig_ = value;
        }
      } else {
        desiredMonitoringConfigBuilder_.mergeFrom(value);
      }
      if (desiredMonitoringConfig_ != null) {
        bitField1_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    public Builder clearDesiredMonitoringConfig() {
      bitField1_ = (bitField1_ & ~0x00000080);
      desiredMonitoringConfig_ = null;
      if (desiredMonitoringConfigBuilder_ != null) {
        desiredMonitoringConfigBuilder_.dispose();
        desiredMonitoringConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    public com.google.container.v1beta1.MonitoringConfig.Builder
        getDesiredMonitoringConfigBuilder() {
      bitField1_ |= 0x00000080;
      onChanged();
      return getDesiredMonitoringConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    public com.google.container.v1beta1.MonitoringConfigOrBuilder
        getDesiredMonitoringConfigOrBuilder() {
      if (desiredMonitoringConfigBuilder_ != null) {
        return desiredMonitoringConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredMonitoringConfig_ == null
            ? com.google.container.v1beta1.MonitoringConfig.getDefaultInstance()
            : desiredMonitoringConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired monitoring configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.MonitoringConfig desired_monitoring_config = 65;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.MonitoringConfig,
            com.google.container.v1beta1.MonitoringConfig.Builder,
            com.google.container.v1beta1.MonitoringConfigOrBuilder>
        getDesiredMonitoringConfigFieldBuilder() {
      if (desiredMonitoringConfigBuilder_ == null) {
        desiredMonitoringConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.MonitoringConfig,
                com.google.container.v1beta1.MonitoringConfig.Builder,
                com.google.container.v1beta1.MonitoringConfigOrBuilder>(
                getDesiredMonitoringConfig(), getParentForChildren(), isClean());
        desiredMonitoringConfig_ = null;
      }
      return desiredMonitoringConfigBuilder_;
    }

    private com.google.container.v1beta1.IdentityServiceConfig desiredIdentityServiceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.IdentityServiceConfig,
            com.google.container.v1beta1.IdentityServiceConfig.Builder,
            com.google.container.v1beta1.IdentityServiceConfigOrBuilder>
        desiredIdentityServiceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     *
     * @return Whether the desiredIdentityServiceConfig field is set.
     */
    public boolean hasDesiredIdentityServiceConfig() {
      return ((bitField1_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     *
     * @return The desiredIdentityServiceConfig.
     */
    public com.google.container.v1beta1.IdentityServiceConfig getDesiredIdentityServiceConfig() {
      if (desiredIdentityServiceConfigBuilder_ == null) {
        return desiredIdentityServiceConfig_ == null
            ? com.google.container.v1beta1.IdentityServiceConfig.getDefaultInstance()
            : desiredIdentityServiceConfig_;
      } else {
        return desiredIdentityServiceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    public Builder setDesiredIdentityServiceConfig(
        com.google.container.v1beta1.IdentityServiceConfig value) {
      if (desiredIdentityServiceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredIdentityServiceConfig_ = value;
      } else {
        desiredIdentityServiceConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    public Builder setDesiredIdentityServiceConfig(
        com.google.container.v1beta1.IdentityServiceConfig.Builder builderForValue) {
      if (desiredIdentityServiceConfigBuilder_ == null) {
        desiredIdentityServiceConfig_ = builderForValue.build();
      } else {
        desiredIdentityServiceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    public Builder mergeDesiredIdentityServiceConfig(
        com.google.container.v1beta1.IdentityServiceConfig value) {
      if (desiredIdentityServiceConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000100) != 0)
            && desiredIdentityServiceConfig_ != null
            && desiredIdentityServiceConfig_
                != com.google.container.v1beta1.IdentityServiceConfig.getDefaultInstance()) {
          getDesiredIdentityServiceConfigBuilder().mergeFrom(value);
        } else {
          desiredIdentityServiceConfig_ = value;
        }
      } else {
        desiredIdentityServiceConfigBuilder_.mergeFrom(value);
      }
      if (desiredIdentityServiceConfig_ != null) {
        bitField1_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    public Builder clearDesiredIdentityServiceConfig() {
      bitField1_ = (bitField1_ & ~0x00000100);
      desiredIdentityServiceConfig_ = null;
      if (desiredIdentityServiceConfigBuilder_ != null) {
        desiredIdentityServiceConfigBuilder_.dispose();
        desiredIdentityServiceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    public com.google.container.v1beta1.IdentityServiceConfig.Builder
        getDesiredIdentityServiceConfigBuilder() {
      bitField1_ |= 0x00000100;
      onChanged();
      return getDesiredIdentityServiceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    public com.google.container.v1beta1.IdentityServiceConfigOrBuilder
        getDesiredIdentityServiceConfigOrBuilder() {
      if (desiredIdentityServiceConfigBuilder_ != null) {
        return desiredIdentityServiceConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredIdentityServiceConfig_ == null
            ? com.google.container.v1beta1.IdentityServiceConfig.getDefaultInstance()
            : desiredIdentityServiceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired Identity Service component configuration.
     * </pre>
     *
     * <code>.google.container.v1beta1.IdentityServiceConfig desired_identity_service_config = 66;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.IdentityServiceConfig,
            com.google.container.v1beta1.IdentityServiceConfig.Builder,
            com.google.container.v1beta1.IdentityServiceConfigOrBuilder>
        getDesiredIdentityServiceConfigFieldBuilder() {
      if (desiredIdentityServiceConfigBuilder_ == null) {
        desiredIdentityServiceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.IdentityServiceConfig,
                com.google.container.v1beta1.IdentityServiceConfig.Builder,
                com.google.container.v1beta1.IdentityServiceConfigOrBuilder>(
                getDesiredIdentityServiceConfig(), getParentForChildren(), isClean());
        desiredIdentityServiceConfig_ = null;
      }
      return desiredIdentityServiceConfigBuilder_;
    }

    private boolean desiredEnablePrivateEndpoint_;
    /**
     *
     *
     * <pre>
     * Enable/Disable private endpoint for the cluster's master.
     * </pre>
     *
     * <code>optional bool desired_enable_private_endpoint = 71;</code>
     *
     * @return Whether the desiredEnablePrivateEndpoint field is set.
     */
    @java.lang.Override
    public boolean hasDesiredEnablePrivateEndpoint() {
      return ((bitField1_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable private endpoint for the cluster's master.
     * </pre>
     *
     * <code>optional bool desired_enable_private_endpoint = 71;</code>
     *
     * @return The desiredEnablePrivateEndpoint.
     */
    @java.lang.Override
    public boolean getDesiredEnablePrivateEndpoint() {
      return desiredEnablePrivateEndpoint_;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable private endpoint for the cluster's master.
     * </pre>
     *
     * <code>optional bool desired_enable_private_endpoint = 71;</code>
     *
     * @param value The desiredEnablePrivateEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredEnablePrivateEndpoint(boolean value) {

      desiredEnablePrivateEndpoint_ = value;
      bitField1_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable private endpoint for the cluster's master.
     * </pre>
     *
     * <code>optional bool desired_enable_private_endpoint = 71;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredEnablePrivateEndpoint() {
      bitField1_ = (bitField1_ & ~0x00000200);
      desiredEnablePrivateEndpoint_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NetworkTags desiredNodePoolAutoConfigNetworkTags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkTags,
            com.google.container.v1beta1.NetworkTags.Builder,
            com.google.container.v1beta1.NetworkTagsOrBuilder>
        desiredNodePoolAutoConfigNetworkTagsBuilder_;
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     *
     * @return Whether the desiredNodePoolAutoConfigNetworkTags field is set.
     */
    public boolean hasDesiredNodePoolAutoConfigNetworkTags() {
      return ((bitField1_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     *
     * @return The desiredNodePoolAutoConfigNetworkTags.
     */
    public com.google.container.v1beta1.NetworkTags getDesiredNodePoolAutoConfigNetworkTags() {
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ == null) {
        return desiredNodePoolAutoConfigNetworkTags_ == null
            ? com.google.container.v1beta1.NetworkTags.getDefaultInstance()
            : desiredNodePoolAutoConfigNetworkTags_;
      } else {
        return desiredNodePoolAutoConfigNetworkTagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    public Builder setDesiredNodePoolAutoConfigNetworkTags(
        com.google.container.v1beta1.NetworkTags value) {
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNodePoolAutoConfigNetworkTags_ = value;
      } else {
        desiredNodePoolAutoConfigNetworkTagsBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    public Builder setDesiredNodePoolAutoConfigNetworkTags(
        com.google.container.v1beta1.NetworkTags.Builder builderForValue) {
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ == null) {
        desiredNodePoolAutoConfigNetworkTags_ = builderForValue.build();
      } else {
        desiredNodePoolAutoConfigNetworkTagsBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    public Builder mergeDesiredNodePoolAutoConfigNetworkTags(
        com.google.container.v1beta1.NetworkTags value) {
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ == null) {
        if (((bitField1_ & 0x00000400) != 0)
            && desiredNodePoolAutoConfigNetworkTags_ != null
            && desiredNodePoolAutoConfigNetworkTags_
                != com.google.container.v1beta1.NetworkTags.getDefaultInstance()) {
          getDesiredNodePoolAutoConfigNetworkTagsBuilder().mergeFrom(value);
        } else {
          desiredNodePoolAutoConfigNetworkTags_ = value;
        }
      } else {
        desiredNodePoolAutoConfigNetworkTagsBuilder_.mergeFrom(value);
      }
      if (desiredNodePoolAutoConfigNetworkTags_ != null) {
        bitField1_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    public Builder clearDesiredNodePoolAutoConfigNetworkTags() {
      bitField1_ = (bitField1_ & ~0x00000400);
      desiredNodePoolAutoConfigNetworkTags_ = null;
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ != null) {
        desiredNodePoolAutoConfigNetworkTagsBuilder_.dispose();
        desiredNodePoolAutoConfigNetworkTagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    public com.google.container.v1beta1.NetworkTags.Builder
        getDesiredNodePoolAutoConfigNetworkTagsBuilder() {
      bitField1_ |= 0x00000400;
      onChanged();
      return getDesiredNodePoolAutoConfigNetworkTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    public com.google.container.v1beta1.NetworkTagsOrBuilder
        getDesiredNodePoolAutoConfigNetworkTagsOrBuilder() {
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ != null) {
        return desiredNodePoolAutoConfigNetworkTagsBuilder_.getMessageOrBuilder();
      } else {
        return desiredNodePoolAutoConfigNetworkTags_ == null
            ? com.google.container.v1beta1.NetworkTags.getDefaultInstance()
            : desiredNodePoolAutoConfigNetworkTags_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired network tags that apply to all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>.google.container.v1beta1.NetworkTags desired_node_pool_auto_config_network_tags = 110;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkTags,
            com.google.container.v1beta1.NetworkTags.Builder,
            com.google.container.v1beta1.NetworkTagsOrBuilder>
        getDesiredNodePoolAutoConfigNetworkTagsFieldBuilder() {
      if (desiredNodePoolAutoConfigNetworkTagsBuilder_ == null) {
        desiredNodePoolAutoConfigNetworkTagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NetworkTags,
                com.google.container.v1beta1.NetworkTags.Builder,
                com.google.container.v1beta1.NetworkTagsOrBuilder>(
                getDesiredNodePoolAutoConfigNetworkTags(), getParentForChildren(), isClean());
        desiredNodePoolAutoConfigNetworkTags_ = null;
      }
      return desiredNodePoolAutoConfigNetworkTagsBuilder_;
    }

    private com.google.container.v1beta1.ProtectConfig desiredProtectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ProtectConfig,
            com.google.container.v1beta1.ProtectConfig.Builder,
            com.google.container.v1beta1.ProtectConfigOrBuilder>
        desiredProtectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1beta1.ClusterUpdate.desired_protect_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=2769
     * @return Whether the desiredProtectConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasDesiredProtectConfig() {
      return ((bitField1_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     *
     * @deprecated google.container.v1beta1.ClusterUpdate.desired_protect_config is deprecated. See
     *     google/container/v1beta1/cluster_service.proto;l=2769
     * @return The desiredProtectConfig.
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.ProtectConfig getDesiredProtectConfig() {
      if (desiredProtectConfigBuilder_ == null) {
        return desiredProtectConfig_ == null
            ? com.google.container.v1beta1.ProtectConfig.getDefaultInstance()
            : desiredProtectConfig_;
      } else {
        return desiredProtectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDesiredProtectConfig(com.google.container.v1beta1.ProtectConfig value) {
      if (desiredProtectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredProtectConfig_ = value;
      } else {
        desiredProtectConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDesiredProtectConfig(
        com.google.container.v1beta1.ProtectConfig.Builder builderForValue) {
      if (desiredProtectConfigBuilder_ == null) {
        desiredProtectConfig_ = builderForValue.build();
      } else {
        desiredProtectConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeDesiredProtectConfig(com.google.container.v1beta1.ProtectConfig value) {
      if (desiredProtectConfigBuilder_ == null) {
        if (((bitField1_ & 0x00000800) != 0)
            && desiredProtectConfig_ != null
            && desiredProtectConfig_
                != com.google.container.v1beta1.ProtectConfig.getDefaultInstance()) {
          getDesiredProtectConfigBuilder().mergeFrom(value);
        } else {
          desiredProtectConfig_ = value;
        }
      } else {
        desiredProtectConfigBuilder_.mergeFrom(value);
      }
      if (desiredProtectConfig_ != null) {
        bitField1_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearDesiredProtectConfig() {
      bitField1_ = (bitField1_ & ~0x00000800);
      desiredProtectConfig_ = null;
      if (desiredProtectConfigBuilder_ != null) {
        desiredProtectConfigBuilder_.dispose();
        desiredProtectConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.ProtectConfig.Builder getDesiredProtectConfigBuilder() {
      bitField1_ |= 0x00000800;
      onChanged();
      return getDesiredProtectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.container.v1beta1.ProtectConfigOrBuilder getDesiredProtectConfigOrBuilder() {
      if (desiredProtectConfigBuilder_ != null) {
        return desiredProtectConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredProtectConfig_ == null
            ? com.google.container.v1beta1.ProtectConfig.getDefaultInstance()
            : desiredProtectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Use DesiredSecurityPostureConfig instead.
     * Enable/Disable Protect API features for the cluster.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.ProtectConfig desired_protect_config = 112 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ProtectConfig,
            com.google.container.v1beta1.ProtectConfig.Builder,
            com.google.container.v1beta1.ProtectConfigOrBuilder>
        getDesiredProtectConfigFieldBuilder() {
      if (desiredProtectConfigBuilder_ == null) {
        desiredProtectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ProtectConfig,
                com.google.container.v1beta1.ProtectConfig.Builder,
                com.google.container.v1beta1.ProtectConfigOrBuilder>(
                getDesiredProtectConfig(), getParentForChildren(), isClean());
        desiredProtectConfig_ = null;
      }
      return desiredProtectConfigBuilder_;
    }

    private com.google.container.v1beta1.GatewayAPIConfig desiredGatewayApiConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GatewayAPIConfig,
            com.google.container.v1beta1.GatewayAPIConfig.Builder,
            com.google.container.v1beta1.GatewayAPIConfigOrBuilder>
        desiredGatewayApiConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     *
     * @return Whether the desiredGatewayApiConfig field is set.
     */
    public boolean hasDesiredGatewayApiConfig() {
      return ((bitField1_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     *
     * @return The desiredGatewayApiConfig.
     */
    public com.google.container.v1beta1.GatewayAPIConfig getDesiredGatewayApiConfig() {
      if (desiredGatewayApiConfigBuilder_ == null) {
        return desiredGatewayApiConfig_ == null
            ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
            : desiredGatewayApiConfig_;
      } else {
        return desiredGatewayApiConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    public Builder setDesiredGatewayApiConfig(com.google.container.v1beta1.GatewayAPIConfig value) {
      if (desiredGatewayApiConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredGatewayApiConfig_ = value;
      } else {
        desiredGatewayApiConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    public Builder setDesiredGatewayApiConfig(
        com.google.container.v1beta1.GatewayAPIConfig.Builder builderForValue) {
      if (desiredGatewayApiConfigBuilder_ == null) {
        desiredGatewayApiConfig_ = builderForValue.build();
      } else {
        desiredGatewayApiConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    public Builder mergeDesiredGatewayApiConfig(
        com.google.container.v1beta1.GatewayAPIConfig value) {
      if (desiredGatewayApiConfigBuilder_ == null) {
        if (((bitField1_ & 0x00001000) != 0)
            && desiredGatewayApiConfig_ != null
            && desiredGatewayApiConfig_
                != com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()) {
          getDesiredGatewayApiConfigBuilder().mergeFrom(value);
        } else {
          desiredGatewayApiConfig_ = value;
        }
      } else {
        desiredGatewayApiConfigBuilder_.mergeFrom(value);
      }
      if (desiredGatewayApiConfig_ != null) {
        bitField1_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    public Builder clearDesiredGatewayApiConfig() {
      bitField1_ = (bitField1_ & ~0x00001000);
      desiredGatewayApiConfig_ = null;
      if (desiredGatewayApiConfigBuilder_ != null) {
        desiredGatewayApiConfigBuilder_.dispose();
        desiredGatewayApiConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    public com.google.container.v1beta1.GatewayAPIConfig.Builder
        getDesiredGatewayApiConfigBuilder() {
      bitField1_ |= 0x00001000;
      onChanged();
      return getDesiredGatewayApiConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    public com.google.container.v1beta1.GatewayAPIConfigOrBuilder
        getDesiredGatewayApiConfigOrBuilder() {
      if (desiredGatewayApiConfigBuilder_ != null) {
        return desiredGatewayApiConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredGatewayApiConfig_ == null
            ? com.google.container.v1beta1.GatewayAPIConfig.getDefaultInstance()
            : desiredGatewayApiConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired config of Gateway API on this cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.GatewayAPIConfig desired_gateway_api_config = 114;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.GatewayAPIConfig,
            com.google.container.v1beta1.GatewayAPIConfig.Builder,
            com.google.container.v1beta1.GatewayAPIConfigOrBuilder>
        getDesiredGatewayApiConfigFieldBuilder() {
      if (desiredGatewayApiConfigBuilder_ == null) {
        desiredGatewayApiConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.GatewayAPIConfig,
                com.google.container.v1beta1.GatewayAPIConfig.Builder,
                com.google.container.v1beta1.GatewayAPIConfigOrBuilder>(
                getDesiredGatewayApiConfig(), getParentForChildren(), isClean());
        desiredGatewayApiConfig_ = null;
      }
      return desiredGatewayApiConfigBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 115;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 115;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 115;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField1_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 115;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField1_ = (bitField1_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current etag of the cluster.
     * If an etag is provided and does not match the current etag of the cluster,
     * update will be blocked and an ABORTED error will be returned.
     * </pre>
     *
     * <code>string etag = 115;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField1_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NodePoolLoggingConfig desiredNodePoolLoggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodePoolLoggingConfig,
            com.google.container.v1beta1.NodePoolLoggingConfig.Builder,
            com.google.container.v1beta1.NodePoolLoggingConfigOrBuilder>
        desiredNodePoolLoggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     *
     * @return Whether the desiredNodePoolLoggingConfig field is set.
     */
    public boolean hasDesiredNodePoolLoggingConfig() {
      return ((bitField1_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     *
     * @return The desiredNodePoolLoggingConfig.
     */
    public com.google.container.v1beta1.NodePoolLoggingConfig getDesiredNodePoolLoggingConfig() {
      if (desiredNodePoolLoggingConfigBuilder_ == null) {
        return desiredNodePoolLoggingConfig_ == null
            ? com.google.container.v1beta1.NodePoolLoggingConfig.getDefaultInstance()
            : desiredNodePoolLoggingConfig_;
      } else {
        return desiredNodePoolLoggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    public Builder setDesiredNodePoolLoggingConfig(
        com.google.container.v1beta1.NodePoolLoggingConfig value) {
      if (desiredNodePoolLoggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNodePoolLoggingConfig_ = value;
      } else {
        desiredNodePoolLoggingConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    public Builder setDesiredNodePoolLoggingConfig(
        com.google.container.v1beta1.NodePoolLoggingConfig.Builder builderForValue) {
      if (desiredNodePoolLoggingConfigBuilder_ == null) {
        desiredNodePoolLoggingConfig_ = builderForValue.build();
      } else {
        desiredNodePoolLoggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    public Builder mergeDesiredNodePoolLoggingConfig(
        com.google.container.v1beta1.NodePoolLoggingConfig value) {
      if (desiredNodePoolLoggingConfigBuilder_ == null) {
        if (((bitField1_ & 0x00004000) != 0)
            && desiredNodePoolLoggingConfig_ != null
            && desiredNodePoolLoggingConfig_
                != com.google.container.v1beta1.NodePoolLoggingConfig.getDefaultInstance()) {
          getDesiredNodePoolLoggingConfigBuilder().mergeFrom(value);
        } else {
          desiredNodePoolLoggingConfig_ = value;
        }
      } else {
        desiredNodePoolLoggingConfigBuilder_.mergeFrom(value);
      }
      if (desiredNodePoolLoggingConfig_ != null) {
        bitField1_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    public Builder clearDesiredNodePoolLoggingConfig() {
      bitField1_ = (bitField1_ & ~0x00004000);
      desiredNodePoolLoggingConfig_ = null;
      if (desiredNodePoolLoggingConfigBuilder_ != null) {
        desiredNodePoolLoggingConfigBuilder_.dispose();
        desiredNodePoolLoggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    public com.google.container.v1beta1.NodePoolLoggingConfig.Builder
        getDesiredNodePoolLoggingConfigBuilder() {
      bitField1_ |= 0x00004000;
      onChanged();
      return getDesiredNodePoolLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    public com.google.container.v1beta1.NodePoolLoggingConfigOrBuilder
        getDesiredNodePoolLoggingConfigOrBuilder() {
      if (desiredNodePoolLoggingConfigBuilder_ != null) {
        return desiredNodePoolLoggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredNodePoolLoggingConfig_ == null
            ? com.google.container.v1beta1.NodePoolLoggingConfig.getDefaultInstance()
            : desiredNodePoolLoggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node pool logging configuration defaults for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodePoolLoggingConfig desired_node_pool_logging_config = 116;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodePoolLoggingConfig,
            com.google.container.v1beta1.NodePoolLoggingConfig.Builder,
            com.google.container.v1beta1.NodePoolLoggingConfigOrBuilder>
        getDesiredNodePoolLoggingConfigFieldBuilder() {
      if (desiredNodePoolLoggingConfigBuilder_ == null) {
        desiredNodePoolLoggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodePoolLoggingConfig,
                com.google.container.v1beta1.NodePoolLoggingConfig.Builder,
                com.google.container.v1beta1.NodePoolLoggingConfigOrBuilder>(
                getDesiredNodePoolLoggingConfig(), getParentForChildren(), isClean());
        desiredNodePoolLoggingConfig_ = null;
      }
      return desiredNodePoolLoggingConfigBuilder_;
    }

    private com.google.container.v1beta1.Fleet desiredFleet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.Fleet,
            com.google.container.v1beta1.Fleet.Builder,
            com.google.container.v1beta1.FleetOrBuilder>
        desiredFleetBuilder_;
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     *
     * @return Whether the desiredFleet field is set.
     */
    public boolean hasDesiredFleet() {
      return ((bitField1_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     *
     * @return The desiredFleet.
     */
    public com.google.container.v1beta1.Fleet getDesiredFleet() {
      if (desiredFleetBuilder_ == null) {
        return desiredFleet_ == null
            ? com.google.container.v1beta1.Fleet.getDefaultInstance()
            : desiredFleet_;
      } else {
        return desiredFleetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    public Builder setDesiredFleet(com.google.container.v1beta1.Fleet value) {
      if (desiredFleetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredFleet_ = value;
      } else {
        desiredFleetBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    public Builder setDesiredFleet(com.google.container.v1beta1.Fleet.Builder builderForValue) {
      if (desiredFleetBuilder_ == null) {
        desiredFleet_ = builderForValue.build();
      } else {
        desiredFleetBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    public Builder mergeDesiredFleet(com.google.container.v1beta1.Fleet value) {
      if (desiredFleetBuilder_ == null) {
        if (((bitField1_ & 0x00008000) != 0)
            && desiredFleet_ != null
            && desiredFleet_ != com.google.container.v1beta1.Fleet.getDefaultInstance()) {
          getDesiredFleetBuilder().mergeFrom(value);
        } else {
          desiredFleet_ = value;
        }
      } else {
        desiredFleetBuilder_.mergeFrom(value);
      }
      if (desiredFleet_ != null) {
        bitField1_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    public Builder clearDesiredFleet() {
      bitField1_ = (bitField1_ & ~0x00008000);
      desiredFleet_ = null;
      if (desiredFleetBuilder_ != null) {
        desiredFleetBuilder_.dispose();
        desiredFleetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    public com.google.container.v1beta1.Fleet.Builder getDesiredFleetBuilder() {
      bitField1_ |= 0x00008000;
      onChanged();
      return getDesiredFleetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    public com.google.container.v1beta1.FleetOrBuilder getDesiredFleetOrBuilder() {
      if (desiredFleetBuilder_ != null) {
        return desiredFleetBuilder_.getMessageOrBuilder();
      } else {
        return desiredFleet_ == null
            ? com.google.container.v1beta1.Fleet.getDefaultInstance()
            : desiredFleet_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired fleet configuration for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.Fleet desired_fleet = 117;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.Fleet,
            com.google.container.v1beta1.Fleet.Builder,
            com.google.container.v1beta1.FleetOrBuilder>
        getDesiredFleetFieldBuilder() {
      if (desiredFleetBuilder_ == null) {
        desiredFleetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.Fleet,
                com.google.container.v1beta1.Fleet.Builder,
                com.google.container.v1beta1.FleetOrBuilder>(
                getDesiredFleet(), getParentForChildren(), isClean());
        desiredFleet_ = null;
      }
      return desiredFleetBuilder_;
    }

    private int desiredStackType_ = 0;
    /**
     *
     *
     * <pre>
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     * </pre>
     *
     * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
     *
     * @return The enum numeric value on the wire for desiredStackType.
     */
    @java.lang.Override
    public int getDesiredStackTypeValue() {
      return desiredStackType_;
    }
    /**
     *
     *
     * <pre>
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     * </pre>
     *
     * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
     *
     * @param value The enum numeric value on the wire for desiredStackType to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredStackTypeValue(int value) {
      desiredStackType_ = value;
      bitField1_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     * </pre>
     *
     * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
     *
     * @return The desiredStackType.
     */
    @java.lang.Override
    public com.google.container.v1beta1.StackType getDesiredStackType() {
      com.google.container.v1beta1.StackType result =
          com.google.container.v1beta1.StackType.forNumber(desiredStackType_);
      return result == null ? com.google.container.v1beta1.StackType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     * </pre>
     *
     * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
     *
     * @param value The desiredStackType to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredStackType(com.google.container.v1beta1.StackType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField1_ |= 0x00010000;
      desiredStackType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired stack type of the cluster.
     * If a stack type is provided and does not match the current stack type of
     * the cluster, update will attempt to change the stack type to the new type.
     * </pre>
     *
     * <code>.google.container.v1beta1.StackType desired_stack_type = 119;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredStackType() {
      bitField1_ = (bitField1_ & ~0x00010000);
      desiredStackType_ = 0;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.AdditionalPodRangesConfig additionalPodRangesConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AdditionalPodRangesConfig,
            com.google.container.v1beta1.AdditionalPodRangesConfig.Builder,
            com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder>
        additionalPodRangesConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     *
     * @return Whether the additionalPodRangesConfig field is set.
     */
    public boolean hasAdditionalPodRangesConfig() {
      return ((bitField1_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     *
     * @return The additionalPodRangesConfig.
     */
    public com.google.container.v1beta1.AdditionalPodRangesConfig getAdditionalPodRangesConfig() {
      if (additionalPodRangesConfigBuilder_ == null) {
        return additionalPodRangesConfig_ == null
            ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
            : additionalPodRangesConfig_;
      } else {
        return additionalPodRangesConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    public Builder setAdditionalPodRangesConfig(
        com.google.container.v1beta1.AdditionalPodRangesConfig value) {
      if (additionalPodRangesConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        additionalPodRangesConfig_ = value;
      } else {
        additionalPodRangesConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    public Builder setAdditionalPodRangesConfig(
        com.google.container.v1beta1.AdditionalPodRangesConfig.Builder builderForValue) {
      if (additionalPodRangesConfigBuilder_ == null) {
        additionalPodRangesConfig_ = builderForValue.build();
      } else {
        additionalPodRangesConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    public Builder mergeAdditionalPodRangesConfig(
        com.google.container.v1beta1.AdditionalPodRangesConfig value) {
      if (additionalPodRangesConfigBuilder_ == null) {
        if (((bitField1_ & 0x00020000) != 0)
            && additionalPodRangesConfig_ != null
            && additionalPodRangesConfig_
                != com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()) {
          getAdditionalPodRangesConfigBuilder().mergeFrom(value);
        } else {
          additionalPodRangesConfig_ = value;
        }
      } else {
        additionalPodRangesConfigBuilder_.mergeFrom(value);
      }
      if (additionalPodRangesConfig_ != null) {
        bitField1_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    public Builder clearAdditionalPodRangesConfig() {
      bitField1_ = (bitField1_ & ~0x00020000);
      additionalPodRangesConfig_ = null;
      if (additionalPodRangesConfigBuilder_ != null) {
        additionalPodRangesConfigBuilder_.dispose();
        additionalPodRangesConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodRangesConfig.Builder
        getAdditionalPodRangesConfigBuilder() {
      bitField1_ |= 0x00020000;
      onChanged();
      return getAdditionalPodRangesConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder
        getAdditionalPodRangesConfigOrBuilder() {
      if (additionalPodRangesConfigBuilder_ != null) {
        return additionalPodRangesConfigBuilder_.getMessageOrBuilder();
      } else {
        return additionalPodRangesConfig_ == null
            ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
            : additionalPodRangesConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges to be added to the cluster. These pod ranges
     * can be used by node pools to allocate pod IPs.
     * </pre>
     *
     * <code>.google.container.v1beta1.AdditionalPodRangesConfig additional_pod_ranges_config = 120;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AdditionalPodRangesConfig,
            com.google.container.v1beta1.AdditionalPodRangesConfig.Builder,
            com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder>
        getAdditionalPodRangesConfigFieldBuilder() {
      if (additionalPodRangesConfigBuilder_ == null) {
        additionalPodRangesConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.AdditionalPodRangesConfig,
                com.google.container.v1beta1.AdditionalPodRangesConfig.Builder,
                com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder>(
                getAdditionalPodRangesConfig(), getParentForChildren(), isClean());
        additionalPodRangesConfig_ = null;
      }
      return additionalPodRangesConfigBuilder_;
    }

    private com.google.container.v1beta1.AdditionalPodRangesConfig
        removedAdditionalPodRangesConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AdditionalPodRangesConfig,
            com.google.container.v1beta1.AdditionalPodRangesConfig.Builder,
            com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder>
        removedAdditionalPodRangesConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     *
     * @return Whether the removedAdditionalPodRangesConfig field is set.
     */
    public boolean hasRemovedAdditionalPodRangesConfig() {
      return ((bitField1_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     *
     * @return The removedAdditionalPodRangesConfig.
     */
    public com.google.container.v1beta1.AdditionalPodRangesConfig
        getRemovedAdditionalPodRangesConfig() {
      if (removedAdditionalPodRangesConfigBuilder_ == null) {
        return removedAdditionalPodRangesConfig_ == null
            ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
            : removedAdditionalPodRangesConfig_;
      } else {
        return removedAdditionalPodRangesConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    public Builder setRemovedAdditionalPodRangesConfig(
        com.google.container.v1beta1.AdditionalPodRangesConfig value) {
      if (removedAdditionalPodRangesConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        removedAdditionalPodRangesConfig_ = value;
      } else {
        removedAdditionalPodRangesConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    public Builder setRemovedAdditionalPodRangesConfig(
        com.google.container.v1beta1.AdditionalPodRangesConfig.Builder builderForValue) {
      if (removedAdditionalPodRangesConfigBuilder_ == null) {
        removedAdditionalPodRangesConfig_ = builderForValue.build();
      } else {
        removedAdditionalPodRangesConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    public Builder mergeRemovedAdditionalPodRangesConfig(
        com.google.container.v1beta1.AdditionalPodRangesConfig value) {
      if (removedAdditionalPodRangesConfigBuilder_ == null) {
        if (((bitField1_ & 0x00040000) != 0)
            && removedAdditionalPodRangesConfig_ != null
            && removedAdditionalPodRangesConfig_
                != com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()) {
          getRemovedAdditionalPodRangesConfigBuilder().mergeFrom(value);
        } else {
          removedAdditionalPodRangesConfig_ = value;
        }
      } else {
        removedAdditionalPodRangesConfigBuilder_.mergeFrom(value);
      }
      if (removedAdditionalPodRangesConfig_ != null) {
        bitField1_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    public Builder clearRemovedAdditionalPodRangesConfig() {
      bitField1_ = (bitField1_ & ~0x00040000);
      removedAdditionalPodRangesConfig_ = null;
      if (removedAdditionalPodRangesConfigBuilder_ != null) {
        removedAdditionalPodRangesConfigBuilder_.dispose();
        removedAdditionalPodRangesConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodRangesConfig.Builder
        getRemovedAdditionalPodRangesConfigBuilder() {
      bitField1_ |= 0x00040000;
      onChanged();
      return getRemovedAdditionalPodRangesConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder
        getRemovedAdditionalPodRangesConfigOrBuilder() {
      if (removedAdditionalPodRangesConfigBuilder_ != null) {
        return removedAdditionalPodRangesConfigBuilder_.getMessageOrBuilder();
      } else {
        return removedAdditionalPodRangesConfig_ == null
            ? com.google.container.v1beta1.AdditionalPodRangesConfig.getDefaultInstance()
            : removedAdditionalPodRangesConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The additional pod ranges that are to be removed from the cluster.
     * The pod ranges specified here must have been specified earlier in the
     * 'additional_pod_ranges_config' argument.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.AdditionalPodRangesConfig removed_additional_pod_ranges_config = 121;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.AdditionalPodRangesConfig,
            com.google.container.v1beta1.AdditionalPodRangesConfig.Builder,
            com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder>
        getRemovedAdditionalPodRangesConfigFieldBuilder() {
      if (removedAdditionalPodRangesConfigBuilder_ == null) {
        removedAdditionalPodRangesConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.AdditionalPodRangesConfig,
                com.google.container.v1beta1.AdditionalPodRangesConfig.Builder,
                com.google.container.v1beta1.AdditionalPodRangesConfigOrBuilder>(
                getRemovedAdditionalPodRangesConfig(), getParentForChildren(), isClean());
        removedAdditionalPodRangesConfig_ = null;
      }
      return removedAdditionalPodRangesConfigBuilder_;
    }

    private com.google.container.v1beta1.K8sBetaAPIConfig enableK8SBetaApis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.K8sBetaAPIConfig,
            com.google.container.v1beta1.K8sBetaAPIConfig.Builder,
            com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder>
        enableK8SBetaApisBuilder_;
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     *
     * @return Whether the enableK8sBetaApis field is set.
     */
    public boolean hasEnableK8SBetaApis() {
      return ((bitField1_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     *
     * @return The enableK8sBetaApis.
     */
    public com.google.container.v1beta1.K8sBetaAPIConfig getEnableK8SBetaApis() {
      if (enableK8SBetaApisBuilder_ == null) {
        return enableK8SBetaApis_ == null
            ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
            : enableK8SBetaApis_;
      } else {
        return enableK8SBetaApisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    public Builder setEnableK8SBetaApis(com.google.container.v1beta1.K8sBetaAPIConfig value) {
      if (enableK8SBetaApisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enableK8SBetaApis_ = value;
      } else {
        enableK8SBetaApisBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    public Builder setEnableK8SBetaApis(
        com.google.container.v1beta1.K8sBetaAPIConfig.Builder builderForValue) {
      if (enableK8SBetaApisBuilder_ == null) {
        enableK8SBetaApis_ = builderForValue.build();
      } else {
        enableK8SBetaApisBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    public Builder mergeEnableK8SBetaApis(com.google.container.v1beta1.K8sBetaAPIConfig value) {
      if (enableK8SBetaApisBuilder_ == null) {
        if (((bitField1_ & 0x00080000) != 0)
            && enableK8SBetaApis_ != null
            && enableK8SBetaApis_
                != com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()) {
          getEnableK8SBetaApisBuilder().mergeFrom(value);
        } else {
          enableK8SBetaApis_ = value;
        }
      } else {
        enableK8SBetaApisBuilder_.mergeFrom(value);
      }
      if (enableK8SBetaApis_ != null) {
        bitField1_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    public Builder clearEnableK8SBetaApis() {
      bitField1_ = (bitField1_ & ~0x00080000);
      enableK8SBetaApis_ = null;
      if (enableK8SBetaApisBuilder_ != null) {
        enableK8SBetaApisBuilder_.dispose();
        enableK8SBetaApisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    public com.google.container.v1beta1.K8sBetaAPIConfig.Builder getEnableK8SBetaApisBuilder() {
      bitField1_ |= 0x00080000;
      onChanged();
      return getEnableK8SBetaApisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    public com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder getEnableK8SBetaApisOrBuilder() {
      if (enableK8SBetaApisBuilder_ != null) {
        return enableK8SBetaApisBuilder_.getMessageOrBuilder();
      } else {
        return enableK8SBetaApis_ == null
            ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
            : enableK8SBetaApis_;
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes open source beta apis enabled on the cluster. Only beta apis
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig enable_k8s_beta_apis = 122;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.K8sBetaAPIConfig,
            com.google.container.v1beta1.K8sBetaAPIConfig.Builder,
            com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder>
        getEnableK8SBetaApisFieldBuilder() {
      if (enableK8SBetaApisBuilder_ == null) {
        enableK8SBetaApisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.K8sBetaAPIConfig,
                com.google.container.v1beta1.K8sBetaAPIConfig.Builder,
                com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder>(
                getEnableK8SBetaApis(), getParentForChildren(), isClean());
        enableK8SBetaApis_ = null;
      }
      return enableK8SBetaApisBuilder_;
    }

    private com.google.container.v1beta1.SecurityPostureConfig desiredSecurityPostureConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.SecurityPostureConfig,
            com.google.container.v1beta1.SecurityPostureConfig.Builder,
            com.google.container.v1beta1.SecurityPostureConfigOrBuilder>
        desiredSecurityPostureConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     *
     * @return Whether the desiredSecurityPostureConfig field is set.
     */
    public boolean hasDesiredSecurityPostureConfig() {
      return ((bitField1_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     *
     * @return The desiredSecurityPostureConfig.
     */
    public com.google.container.v1beta1.SecurityPostureConfig getDesiredSecurityPostureConfig() {
      if (desiredSecurityPostureConfigBuilder_ == null) {
        return desiredSecurityPostureConfig_ == null
            ? com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance()
            : desiredSecurityPostureConfig_;
      } else {
        return desiredSecurityPostureConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    public Builder setDesiredSecurityPostureConfig(
        com.google.container.v1beta1.SecurityPostureConfig value) {
      if (desiredSecurityPostureConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredSecurityPostureConfig_ = value;
      } else {
        desiredSecurityPostureConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    public Builder setDesiredSecurityPostureConfig(
        com.google.container.v1beta1.SecurityPostureConfig.Builder builderForValue) {
      if (desiredSecurityPostureConfigBuilder_ == null) {
        desiredSecurityPostureConfig_ = builderForValue.build();
      } else {
        desiredSecurityPostureConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    public Builder mergeDesiredSecurityPostureConfig(
        com.google.container.v1beta1.SecurityPostureConfig value) {
      if (desiredSecurityPostureConfigBuilder_ == null) {
        if (((bitField1_ & 0x00100000) != 0)
            && desiredSecurityPostureConfig_ != null
            && desiredSecurityPostureConfig_
                != com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance()) {
          getDesiredSecurityPostureConfigBuilder().mergeFrom(value);
        } else {
          desiredSecurityPostureConfig_ = value;
        }
      } else {
        desiredSecurityPostureConfigBuilder_.mergeFrom(value);
      }
      if (desiredSecurityPostureConfig_ != null) {
        bitField1_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    public Builder clearDesiredSecurityPostureConfig() {
      bitField1_ = (bitField1_ & ~0x00100000);
      desiredSecurityPostureConfig_ = null;
      if (desiredSecurityPostureConfigBuilder_ != null) {
        desiredSecurityPostureConfigBuilder_.dispose();
        desiredSecurityPostureConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    public com.google.container.v1beta1.SecurityPostureConfig.Builder
        getDesiredSecurityPostureConfigBuilder() {
      bitField1_ |= 0x00100000;
      onChanged();
      return getDesiredSecurityPostureConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    public com.google.container.v1beta1.SecurityPostureConfigOrBuilder
        getDesiredSecurityPostureConfigOrBuilder() {
      if (desiredSecurityPostureConfigBuilder_ != null) {
        return desiredSecurityPostureConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredSecurityPostureConfig_ == null
            ? com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance()
            : desiredSecurityPostureConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Security Posture API features for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.SecurityPostureConfig desired_security_posture_config = 124;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.SecurityPostureConfig,
            com.google.container.v1beta1.SecurityPostureConfig.Builder,
            com.google.container.v1beta1.SecurityPostureConfigOrBuilder>
        getDesiredSecurityPostureConfigFieldBuilder() {
      if (desiredSecurityPostureConfigBuilder_ == null) {
        desiredSecurityPostureConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.SecurityPostureConfig,
                com.google.container.v1beta1.SecurityPostureConfig.Builder,
                com.google.container.v1beta1.SecurityPostureConfigOrBuilder>(
                getDesiredSecurityPostureConfig(), getParentForChildren(), isClean());
        desiredSecurityPostureConfig_ = null;
      }
      return desiredSecurityPostureConfigBuilder_;
    }

    private com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        desiredNetworkPerformanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder>
        desiredNetworkPerformanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     *
     * @return Whether the desiredNetworkPerformanceConfig field is set.
     */
    public boolean hasDesiredNetworkPerformanceConfig() {
      return ((bitField1_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     *
     * @return The desiredNetworkPerformanceConfig.
     */
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
        getDesiredNetworkPerformanceConfig() {
      if (desiredNetworkPerformanceConfigBuilder_ == null) {
        return desiredNetworkPerformanceConfig_ == null
            ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                .getDefaultInstance()
            : desiredNetworkPerformanceConfig_;
      } else {
        return desiredNetworkPerformanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    public Builder setDesiredNetworkPerformanceConfig(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig value) {
      if (desiredNetworkPerformanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNetworkPerformanceConfig_ = value;
      } else {
        desiredNetworkPerformanceConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    public Builder setDesiredNetworkPerformanceConfig(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder
            builderForValue) {
      if (desiredNetworkPerformanceConfigBuilder_ == null) {
        desiredNetworkPerformanceConfig_ = builderForValue.build();
      } else {
        desiredNetworkPerformanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    public Builder mergeDesiredNetworkPerformanceConfig(
        com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig value) {
      if (desiredNetworkPerformanceConfigBuilder_ == null) {
        if (((bitField1_ & 0x00200000) != 0)
            && desiredNetworkPerformanceConfig_ != null
            && desiredNetworkPerformanceConfig_
                != com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                    .getDefaultInstance()) {
          getDesiredNetworkPerformanceConfigBuilder().mergeFrom(value);
        } else {
          desiredNetworkPerformanceConfig_ = value;
        }
      } else {
        desiredNetworkPerformanceConfigBuilder_.mergeFrom(value);
      }
      if (desiredNetworkPerformanceConfig_ != null) {
        bitField1_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    public Builder clearDesiredNetworkPerformanceConfig() {
      bitField1_ = (bitField1_ & ~0x00200000);
      desiredNetworkPerformanceConfig_ = null;
      if (desiredNetworkPerformanceConfigBuilder_ != null) {
        desiredNetworkPerformanceConfigBuilder_.dispose();
        desiredNetworkPerformanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder
        getDesiredNetworkPerformanceConfigBuilder() {
      bitField1_ |= 0x00200000;
      onChanged();
      return getDesiredNetworkPerformanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    public com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder
        getDesiredNetworkPerformanceConfigOrBuilder() {
      if (desiredNetworkPerformanceConfigBuilder_ != null) {
        return desiredNetworkPerformanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredNetworkPerformanceConfig_ == null
            ? com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig
                .getDefaultInstance()
            : desiredNetworkPerformanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired network performance config.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig desired_network_performance_config = 125;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder,
            com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfigOrBuilder>
        getDesiredNetworkPerformanceConfigFieldBuilder() {
      if (desiredNetworkPerformanceConfigBuilder_ == null) {
        desiredNetworkPerformanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig,
                com.google.container.v1beta1.NetworkConfig.ClusterNetworkPerformanceConfig.Builder,
                com.google.container.v1beta1.NetworkConfig
                    .ClusterNetworkPerformanceConfigOrBuilder>(
                getDesiredNetworkPerformanceConfig(), getParentForChildren(), isClean());
        desiredNetworkPerformanceConfig_ = null;
      }
      return desiredNetworkPerformanceConfigBuilder_;
    }

    private boolean desiredEnableFqdnNetworkPolicy_;
    /**
     *
     *
     * <pre>
     * Enable/Disable FQDN Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     *
     * @return Whether the desiredEnableFqdnNetworkPolicy field is set.
     */
    @java.lang.Override
    public boolean hasDesiredEnableFqdnNetworkPolicy() {
      return ((bitField1_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable FQDN Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     *
     * @return The desiredEnableFqdnNetworkPolicy.
     */
    @java.lang.Override
    public boolean getDesiredEnableFqdnNetworkPolicy() {
      return desiredEnableFqdnNetworkPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable FQDN Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     *
     * @param value The desiredEnableFqdnNetworkPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredEnableFqdnNetworkPolicy(boolean value) {

      desiredEnableFqdnNetworkPolicy_ = value;
      bitField1_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable FQDN Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_fqdn_network_policy = 126;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredEnableFqdnNetworkPolicy() {
      bitField1_ = (bitField1_ & ~0x00400000);
      desiredEnableFqdnNetworkPolicy_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.WorkloadPolicyConfig desiredAutopilotWorkloadPolicyConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadPolicyConfig,
            com.google.container.v1beta1.WorkloadPolicyConfig.Builder,
            com.google.container.v1beta1.WorkloadPolicyConfigOrBuilder>
        desiredAutopilotWorkloadPolicyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     *
     * @return Whether the desiredAutopilotWorkloadPolicyConfig field is set.
     */
    public boolean hasDesiredAutopilotWorkloadPolicyConfig() {
      return ((bitField1_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     *
     * @return The desiredAutopilotWorkloadPolicyConfig.
     */
    public com.google.container.v1beta1.WorkloadPolicyConfig
        getDesiredAutopilotWorkloadPolicyConfig() {
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ == null) {
        return desiredAutopilotWorkloadPolicyConfig_ == null
            ? com.google.container.v1beta1.WorkloadPolicyConfig.getDefaultInstance()
            : desiredAutopilotWorkloadPolicyConfig_;
      } else {
        return desiredAutopilotWorkloadPolicyConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    public Builder setDesiredAutopilotWorkloadPolicyConfig(
        com.google.container.v1beta1.WorkloadPolicyConfig value) {
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredAutopilotWorkloadPolicyConfig_ = value;
      } else {
        desiredAutopilotWorkloadPolicyConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    public Builder setDesiredAutopilotWorkloadPolicyConfig(
        com.google.container.v1beta1.WorkloadPolicyConfig.Builder builderForValue) {
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ == null) {
        desiredAutopilotWorkloadPolicyConfig_ = builderForValue.build();
      } else {
        desiredAutopilotWorkloadPolicyConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    public Builder mergeDesiredAutopilotWorkloadPolicyConfig(
        com.google.container.v1beta1.WorkloadPolicyConfig value) {
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ == null) {
        if (((bitField1_ & 0x00800000) != 0)
            && desiredAutopilotWorkloadPolicyConfig_ != null
            && desiredAutopilotWorkloadPolicyConfig_
                != com.google.container.v1beta1.WorkloadPolicyConfig.getDefaultInstance()) {
          getDesiredAutopilotWorkloadPolicyConfigBuilder().mergeFrom(value);
        } else {
          desiredAutopilotWorkloadPolicyConfig_ = value;
        }
      } else {
        desiredAutopilotWorkloadPolicyConfigBuilder_.mergeFrom(value);
      }
      if (desiredAutopilotWorkloadPolicyConfig_ != null) {
        bitField1_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    public Builder clearDesiredAutopilotWorkloadPolicyConfig() {
      bitField1_ = (bitField1_ & ~0x00800000);
      desiredAutopilotWorkloadPolicyConfig_ = null;
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ != null) {
        desiredAutopilotWorkloadPolicyConfigBuilder_.dispose();
        desiredAutopilotWorkloadPolicyConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    public com.google.container.v1beta1.WorkloadPolicyConfig.Builder
        getDesiredAutopilotWorkloadPolicyConfigBuilder() {
      bitField1_ |= 0x00800000;
      onChanged();
      return getDesiredAutopilotWorkloadPolicyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    public com.google.container.v1beta1.WorkloadPolicyConfigOrBuilder
        getDesiredAutopilotWorkloadPolicyConfigOrBuilder() {
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ != null) {
        return desiredAutopilotWorkloadPolicyConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredAutopilotWorkloadPolicyConfig_ == null
            ? com.google.container.v1beta1.WorkloadPolicyConfig.getDefaultInstance()
            : desiredAutopilotWorkloadPolicyConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired workload policy configuration for the autopilot cluster.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.WorkloadPolicyConfig desired_autopilot_workload_policy_config = 128;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.WorkloadPolicyConfig,
            com.google.container.v1beta1.WorkloadPolicyConfig.Builder,
            com.google.container.v1beta1.WorkloadPolicyConfigOrBuilder>
        getDesiredAutopilotWorkloadPolicyConfigFieldBuilder() {
      if (desiredAutopilotWorkloadPolicyConfigBuilder_ == null) {
        desiredAutopilotWorkloadPolicyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.WorkloadPolicyConfig,
                com.google.container.v1beta1.WorkloadPolicyConfig.Builder,
                com.google.container.v1beta1.WorkloadPolicyConfigOrBuilder>(
                getDesiredAutopilotWorkloadPolicyConfig(), getParentForChildren(), isClean());
        desiredAutopilotWorkloadPolicyConfig_ = null;
      }
      return desiredAutopilotWorkloadPolicyConfigBuilder_;
    }

    private com.google.container.v1beta1.K8sBetaAPIConfig desiredK8SBetaApis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.K8sBetaAPIConfig,
            com.google.container.v1beta1.K8sBetaAPIConfig.Builder,
            com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder>
        desiredK8SBetaApisBuilder_;
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     *
     * @return Whether the desiredK8sBetaApis field is set.
     */
    public boolean hasDesiredK8SBetaApis() {
      return ((bitField1_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     *
     * @return The desiredK8sBetaApis.
     */
    public com.google.container.v1beta1.K8sBetaAPIConfig getDesiredK8SBetaApis() {
      if (desiredK8SBetaApisBuilder_ == null) {
        return desiredK8SBetaApis_ == null
            ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
            : desiredK8SBetaApis_;
      } else {
        return desiredK8SBetaApisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    public Builder setDesiredK8SBetaApis(com.google.container.v1beta1.K8sBetaAPIConfig value) {
      if (desiredK8SBetaApisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredK8SBetaApis_ = value;
      } else {
        desiredK8SBetaApisBuilder_.setMessage(value);
      }
      bitField1_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    public Builder setDesiredK8SBetaApis(
        com.google.container.v1beta1.K8sBetaAPIConfig.Builder builderForValue) {
      if (desiredK8SBetaApisBuilder_ == null) {
        desiredK8SBetaApis_ = builderForValue.build();
      } else {
        desiredK8SBetaApisBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    public Builder mergeDesiredK8SBetaApis(com.google.container.v1beta1.K8sBetaAPIConfig value) {
      if (desiredK8SBetaApisBuilder_ == null) {
        if (((bitField1_ & 0x01000000) != 0)
            && desiredK8SBetaApis_ != null
            && desiredK8SBetaApis_
                != com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()) {
          getDesiredK8SBetaApisBuilder().mergeFrom(value);
        } else {
          desiredK8SBetaApis_ = value;
        }
      } else {
        desiredK8SBetaApisBuilder_.mergeFrom(value);
      }
      if (desiredK8SBetaApis_ != null) {
        bitField1_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    public Builder clearDesiredK8SBetaApis() {
      bitField1_ = (bitField1_ & ~0x01000000);
      desiredK8SBetaApis_ = null;
      if (desiredK8SBetaApisBuilder_ != null) {
        desiredK8SBetaApisBuilder_.dispose();
        desiredK8SBetaApisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    public com.google.container.v1beta1.K8sBetaAPIConfig.Builder getDesiredK8SBetaApisBuilder() {
      bitField1_ |= 0x01000000;
      onChanged();
      return getDesiredK8SBetaApisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    public com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder getDesiredK8SBetaApisOrBuilder() {
      if (desiredK8SBetaApisBuilder_ != null) {
        return desiredK8SBetaApisBuilder_.getMessageOrBuilder();
      } else {
        return desiredK8SBetaApis_ == null
            ? com.google.container.v1beta1.K8sBetaAPIConfig.getDefaultInstance()
            : desiredK8SBetaApis_;
      }
    }
    /**
     *
     *
     * <pre>
     * Beta APIs enabled for cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.K8sBetaAPIConfig desired_k8s_beta_apis = 131;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.K8sBetaAPIConfig,
            com.google.container.v1beta1.K8sBetaAPIConfig.Builder,
            com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder>
        getDesiredK8SBetaApisFieldBuilder() {
      if (desiredK8SBetaApisBuilder_ == null) {
        desiredK8SBetaApisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.K8sBetaAPIConfig,
                com.google.container.v1beta1.K8sBetaAPIConfig.Builder,
                com.google.container.v1beta1.K8sBetaAPIConfigOrBuilder>(
                getDesiredK8SBetaApis(), getParentForChildren(), isClean());
        desiredK8SBetaApis_ = null;
      }
      return desiredK8SBetaApisBuilder_;
    }

    private com.google.container.v1beta1.HostMaintenancePolicy desiredHostMaintenancePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.HostMaintenancePolicy,
            com.google.container.v1beta1.HostMaintenancePolicy.Builder,
            com.google.container.v1beta1.HostMaintenancePolicyOrBuilder>
        desiredHostMaintenancePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     *
     * @return Whether the desiredHostMaintenancePolicy field is set.
     */
    public boolean hasDesiredHostMaintenancePolicy() {
      return ((bitField1_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     *
     * @return The desiredHostMaintenancePolicy.
     */
    public com.google.container.v1beta1.HostMaintenancePolicy getDesiredHostMaintenancePolicy() {
      if (desiredHostMaintenancePolicyBuilder_ == null) {
        return desiredHostMaintenancePolicy_ == null
            ? com.google.container.v1beta1.HostMaintenancePolicy.getDefaultInstance()
            : desiredHostMaintenancePolicy_;
      } else {
        return desiredHostMaintenancePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    public Builder setDesiredHostMaintenancePolicy(
        com.google.container.v1beta1.HostMaintenancePolicy value) {
      if (desiredHostMaintenancePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredHostMaintenancePolicy_ = value;
      } else {
        desiredHostMaintenancePolicyBuilder_.setMessage(value);
      }
      bitField1_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    public Builder setDesiredHostMaintenancePolicy(
        com.google.container.v1beta1.HostMaintenancePolicy.Builder builderForValue) {
      if (desiredHostMaintenancePolicyBuilder_ == null) {
        desiredHostMaintenancePolicy_ = builderForValue.build();
      } else {
        desiredHostMaintenancePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    public Builder mergeDesiredHostMaintenancePolicy(
        com.google.container.v1beta1.HostMaintenancePolicy value) {
      if (desiredHostMaintenancePolicyBuilder_ == null) {
        if (((bitField1_ & 0x02000000) != 0)
            && desiredHostMaintenancePolicy_ != null
            && desiredHostMaintenancePolicy_
                != com.google.container.v1beta1.HostMaintenancePolicy.getDefaultInstance()) {
          getDesiredHostMaintenancePolicyBuilder().mergeFrom(value);
        } else {
          desiredHostMaintenancePolicy_ = value;
        }
      } else {
        desiredHostMaintenancePolicyBuilder_.mergeFrom(value);
      }
      if (desiredHostMaintenancePolicy_ != null) {
        bitField1_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    public Builder clearDesiredHostMaintenancePolicy() {
      bitField1_ = (bitField1_ & ~0x02000000);
      desiredHostMaintenancePolicy_ = null;
      if (desiredHostMaintenancePolicyBuilder_ != null) {
        desiredHostMaintenancePolicyBuilder_.dispose();
        desiredHostMaintenancePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    public com.google.container.v1beta1.HostMaintenancePolicy.Builder
        getDesiredHostMaintenancePolicyBuilder() {
      bitField1_ |= 0x02000000;
      onChanged();
      return getDesiredHostMaintenancePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    public com.google.container.v1beta1.HostMaintenancePolicyOrBuilder
        getDesiredHostMaintenancePolicyOrBuilder() {
      if (desiredHostMaintenancePolicyBuilder_ != null) {
        return desiredHostMaintenancePolicyBuilder_.getMessageOrBuilder();
      } else {
        return desiredHostMaintenancePolicy_ == null
            ? com.google.container.v1beta1.HostMaintenancePolicy.getDefaultInstance()
            : desiredHostMaintenancePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * HostMaintenancePolicy contains the desired maintenance policy for the
     * Google Compute Engine hosts.
     * </pre>
     *
     * <code>.google.container.v1beta1.HostMaintenancePolicy desired_host_maintenance_policy = 132;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.HostMaintenancePolicy,
            com.google.container.v1beta1.HostMaintenancePolicy.Builder,
            com.google.container.v1beta1.HostMaintenancePolicyOrBuilder>
        getDesiredHostMaintenancePolicyFieldBuilder() {
      if (desiredHostMaintenancePolicyBuilder_ == null) {
        desiredHostMaintenancePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.HostMaintenancePolicy,
                com.google.container.v1beta1.HostMaintenancePolicy.Builder,
                com.google.container.v1beta1.HostMaintenancePolicyOrBuilder>(
                getDesiredHostMaintenancePolicy(), getParentForChildren(), isClean());
        desiredHostMaintenancePolicy_ = null;
      }
      return desiredHostMaintenancePolicyBuilder_;
    }

    private com.google.container.v1beta1.ContainerdConfig desiredContainerdConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ContainerdConfig,
            com.google.container.v1beta1.ContainerdConfig.Builder,
            com.google.container.v1beta1.ContainerdConfigOrBuilder>
        desiredContainerdConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     *
     * @return Whether the desiredContainerdConfig field is set.
     */
    public boolean hasDesiredContainerdConfig() {
      return ((bitField1_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     *
     * @return The desiredContainerdConfig.
     */
    public com.google.container.v1beta1.ContainerdConfig getDesiredContainerdConfig() {
      if (desiredContainerdConfigBuilder_ == null) {
        return desiredContainerdConfig_ == null
            ? com.google.container.v1beta1.ContainerdConfig.getDefaultInstance()
            : desiredContainerdConfig_;
      } else {
        return desiredContainerdConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    public Builder setDesiredContainerdConfig(com.google.container.v1beta1.ContainerdConfig value) {
      if (desiredContainerdConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredContainerdConfig_ = value;
      } else {
        desiredContainerdConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    public Builder setDesiredContainerdConfig(
        com.google.container.v1beta1.ContainerdConfig.Builder builderForValue) {
      if (desiredContainerdConfigBuilder_ == null) {
        desiredContainerdConfig_ = builderForValue.build();
      } else {
        desiredContainerdConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    public Builder mergeDesiredContainerdConfig(
        com.google.container.v1beta1.ContainerdConfig value) {
      if (desiredContainerdConfigBuilder_ == null) {
        if (((bitField1_ & 0x04000000) != 0)
            && desiredContainerdConfig_ != null
            && desiredContainerdConfig_
                != com.google.container.v1beta1.ContainerdConfig.getDefaultInstance()) {
          getDesiredContainerdConfigBuilder().mergeFrom(value);
        } else {
          desiredContainerdConfig_ = value;
        }
      } else {
        desiredContainerdConfigBuilder_.mergeFrom(value);
      }
      if (desiredContainerdConfig_ != null) {
        bitField1_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    public Builder clearDesiredContainerdConfig() {
      bitField1_ = (bitField1_ & ~0x04000000);
      desiredContainerdConfig_ = null;
      if (desiredContainerdConfigBuilder_ != null) {
        desiredContainerdConfigBuilder_.dispose();
        desiredContainerdConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    public com.google.container.v1beta1.ContainerdConfig.Builder
        getDesiredContainerdConfigBuilder() {
      bitField1_ |= 0x04000000;
      onChanged();
      return getDesiredContainerdConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    public com.google.container.v1beta1.ContainerdConfigOrBuilder
        getDesiredContainerdConfigOrBuilder() {
      if (desiredContainerdConfigBuilder_ != null) {
        return desiredContainerdConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredContainerdConfig_ == null
            ? com.google.container.v1beta1.ContainerdConfig.getDefaultInstance()
            : desiredContainerdConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired containerd config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.ContainerdConfig desired_containerd_config = 134;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ContainerdConfig,
            com.google.container.v1beta1.ContainerdConfig.Builder,
            com.google.container.v1beta1.ContainerdConfigOrBuilder>
        getDesiredContainerdConfigFieldBuilder() {
      if (desiredContainerdConfigBuilder_ == null) {
        desiredContainerdConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ContainerdConfig,
                com.google.container.v1beta1.ContainerdConfig.Builder,
                com.google.container.v1beta1.ContainerdConfigOrBuilder>(
                getDesiredContainerdConfig(), getParentForChildren(), isClean());
        desiredContainerdConfig_ = null;
      }
      return desiredContainerdConfigBuilder_;
    }

    private boolean desiredEnableMultiNetworking_;
    /**
     *
     *
     * <pre>
     * Enable/Disable Multi-Networking for the cluster
     * </pre>
     *
     * <code>optional bool desired_enable_multi_networking = 135;</code>
     *
     * @return Whether the desiredEnableMultiNetworking field is set.
     */
    @java.lang.Override
    public boolean hasDesiredEnableMultiNetworking() {
      return ((bitField1_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Multi-Networking for the cluster
     * </pre>
     *
     * <code>optional bool desired_enable_multi_networking = 135;</code>
     *
     * @return The desiredEnableMultiNetworking.
     */
    @java.lang.Override
    public boolean getDesiredEnableMultiNetworking() {
      return desiredEnableMultiNetworking_;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Multi-Networking for the cluster
     * </pre>
     *
     * <code>optional bool desired_enable_multi_networking = 135;</code>
     *
     * @param value The desiredEnableMultiNetworking to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredEnableMultiNetworking(boolean value) {

      desiredEnableMultiNetworking_ = value;
      bitField1_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Multi-Networking for the cluster
     * </pre>
     *
     * <code>optional bool desired_enable_multi_networking = 135;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredEnableMultiNetworking() {
      bitField1_ = (bitField1_ & ~0x08000000);
      desiredEnableMultiNetworking_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.ResourceManagerTags
        desiredNodePoolAutoConfigResourceManagerTags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ResourceManagerTags,
            com.google.container.v1beta1.ResourceManagerTags.Builder,
            com.google.container.v1beta1.ResourceManagerTagsOrBuilder>
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_;
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     *
     * @return Whether the desiredNodePoolAutoConfigResourceManagerTags field is set.
     */
    public boolean hasDesiredNodePoolAutoConfigResourceManagerTags() {
      return ((bitField1_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     *
     * @return The desiredNodePoolAutoConfigResourceManagerTags.
     */
    public com.google.container.v1beta1.ResourceManagerTags
        getDesiredNodePoolAutoConfigResourceManagerTags() {
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ == null) {
        return desiredNodePoolAutoConfigResourceManagerTags_ == null
            ? com.google.container.v1beta1.ResourceManagerTags.getDefaultInstance()
            : desiredNodePoolAutoConfigResourceManagerTags_;
      } else {
        return desiredNodePoolAutoConfigResourceManagerTagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    public Builder setDesiredNodePoolAutoConfigResourceManagerTags(
        com.google.container.v1beta1.ResourceManagerTags value) {
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNodePoolAutoConfigResourceManagerTags_ = value;
      } else {
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_.setMessage(value);
      }
      bitField1_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    public Builder setDesiredNodePoolAutoConfigResourceManagerTags(
        com.google.container.v1beta1.ResourceManagerTags.Builder builderForValue) {
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ == null) {
        desiredNodePoolAutoConfigResourceManagerTags_ = builderForValue.build();
      } else {
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    public Builder mergeDesiredNodePoolAutoConfigResourceManagerTags(
        com.google.container.v1beta1.ResourceManagerTags value) {
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ == null) {
        if (((bitField1_ & 0x10000000) != 0)
            && desiredNodePoolAutoConfigResourceManagerTags_ != null
            && desiredNodePoolAutoConfigResourceManagerTags_
                != com.google.container.v1beta1.ResourceManagerTags.getDefaultInstance()) {
          getDesiredNodePoolAutoConfigResourceManagerTagsBuilder().mergeFrom(value);
        } else {
          desiredNodePoolAutoConfigResourceManagerTags_ = value;
        }
      } else {
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_.mergeFrom(value);
      }
      if (desiredNodePoolAutoConfigResourceManagerTags_ != null) {
        bitField1_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    public Builder clearDesiredNodePoolAutoConfigResourceManagerTags() {
      bitField1_ = (bitField1_ & ~0x10000000);
      desiredNodePoolAutoConfigResourceManagerTags_ = null;
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ != null) {
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_.dispose();
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    public com.google.container.v1beta1.ResourceManagerTags.Builder
        getDesiredNodePoolAutoConfigResourceManagerTagsBuilder() {
      bitField1_ |= 0x10000000;
      onChanged();
      return getDesiredNodePoolAutoConfigResourceManagerTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    public com.google.container.v1beta1.ResourceManagerTagsOrBuilder
        getDesiredNodePoolAutoConfigResourceManagerTagsOrBuilder() {
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ != null) {
        return desiredNodePoolAutoConfigResourceManagerTagsBuilder_.getMessageOrBuilder();
      } else {
        return desiredNodePoolAutoConfigResourceManagerTags_ == null
            ? com.google.container.v1beta1.ResourceManagerTags.getDefaultInstance()
            : desiredNodePoolAutoConfigResourceManagerTags_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired resource manager tags that apply to all auto-provisioned node
     * pools in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.ResourceManagerTags desired_node_pool_auto_config_resource_manager_tags = 136;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.ResourceManagerTags,
            com.google.container.v1beta1.ResourceManagerTags.Builder,
            com.google.container.v1beta1.ResourceManagerTagsOrBuilder>
        getDesiredNodePoolAutoConfigResourceManagerTagsFieldBuilder() {
      if (desiredNodePoolAutoConfigResourceManagerTagsBuilder_ == null) {
        desiredNodePoolAutoConfigResourceManagerTagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.ResourceManagerTags,
                com.google.container.v1beta1.ResourceManagerTags.Builder,
                com.google.container.v1beta1.ResourceManagerTagsOrBuilder>(
                getDesiredNodePoolAutoConfigResourceManagerTags(),
                getParentForChildren(),
                isClean());
        desiredNodePoolAutoConfigResourceManagerTags_ = null;
      }
      return desiredNodePoolAutoConfigResourceManagerTagsBuilder_;
    }

    private int desiredInTransitEncryptionConfig_ = 0;
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * Now named inter-node transparent encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
     * </code>
     *
     * @return Whether the desiredInTransitEncryptionConfig field is set.
     */
    @java.lang.Override
    public boolean hasDesiredInTransitEncryptionConfig() {
      return ((bitField1_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * Now named inter-node transparent encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
     * </code>
     *
     * @return The enum numeric value on the wire for desiredInTransitEncryptionConfig.
     */
    @java.lang.Override
    public int getDesiredInTransitEncryptionConfigValue() {
      return desiredInTransitEncryptionConfig_;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * Now named inter-node transparent encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
     * </code>
     *
     * @param value The enum numeric value on the wire for desiredInTransitEncryptionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredInTransitEncryptionConfigValue(int value) {
      desiredInTransitEncryptionConfig_ = value;
      bitField1_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * Now named inter-node transparent encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
     * </code>
     *
     * @return The desiredInTransitEncryptionConfig.
     */
    @java.lang.Override
    public com.google.container.v1beta1.InTransitEncryptionConfig
        getDesiredInTransitEncryptionConfig() {
      com.google.container.v1beta1.InTransitEncryptionConfig result =
          com.google.container.v1beta1.InTransitEncryptionConfig.forNumber(
              desiredInTransitEncryptionConfig_);
      return result == null
          ? com.google.container.v1beta1.InTransitEncryptionConfig.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * Now named inter-node transparent encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
     * </code>
     *
     * @param value The desiredInTransitEncryptionConfig to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredInTransitEncryptionConfig(
        com.google.container.v1beta1.InTransitEncryptionConfig value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField1_ |= 0x20000000;
      desiredInTransitEncryptionConfig_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the details of in-transit encryption.
     * Now named inter-node transparent encryption.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.InTransitEncryptionConfig desired_in_transit_encryption_config = 137;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredInTransitEncryptionConfig() {
      bitField1_ = (bitField1_ & ~0x20000000);
      desiredInTransitEncryptionConfig_ = 0;
      onChanged();
      return this;
    }

    private boolean desiredEnableCiliumClusterwideNetworkPolicy_;
    /**
     *
     *
     * <pre>
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     *
     * @return Whether the desiredEnableCiliumClusterwideNetworkPolicy field is set.
     */
    @java.lang.Override
    public boolean hasDesiredEnableCiliumClusterwideNetworkPolicy() {
      return ((bitField1_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     *
     * @return The desiredEnableCiliumClusterwideNetworkPolicy.
     */
    @java.lang.Override
    public boolean getDesiredEnableCiliumClusterwideNetworkPolicy() {
      return desiredEnableCiliumClusterwideNetworkPolicy_;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     *
     * @param value The desiredEnableCiliumClusterwideNetworkPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setDesiredEnableCiliumClusterwideNetworkPolicy(boolean value) {

      desiredEnableCiliumClusterwideNetworkPolicy_ = value;
      bitField1_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Cilium Clusterwide Network Policy for the cluster.
     * </pre>
     *
     * <code>optional bool desired_enable_cilium_clusterwide_network_policy = 138;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDesiredEnableCiliumClusterwideNetworkPolicy() {
      bitField1_ = (bitField1_ & ~0x40000000);
      desiredEnableCiliumClusterwideNetworkPolicy_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.SecretManagerConfig desiredSecretManagerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.SecretManagerConfig,
            com.google.container.v1beta1.SecretManagerConfig.Builder,
            com.google.container.v1beta1.SecretManagerConfigOrBuilder>
        desiredSecretManagerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     *
     * @return Whether the desiredSecretManagerConfig field is set.
     */
    public boolean hasDesiredSecretManagerConfig() {
      return ((bitField1_ & 0x80000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     *
     * @return The desiredSecretManagerConfig.
     */
    public com.google.container.v1beta1.SecretManagerConfig getDesiredSecretManagerConfig() {
      if (desiredSecretManagerConfigBuilder_ == null) {
        return desiredSecretManagerConfig_ == null
            ? com.google.container.v1beta1.SecretManagerConfig.getDefaultInstance()
            : desiredSecretManagerConfig_;
      } else {
        return desiredSecretManagerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    public Builder setDesiredSecretManagerConfig(
        com.google.container.v1beta1.SecretManagerConfig value) {
      if (desiredSecretManagerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredSecretManagerConfig_ = value;
      } else {
        desiredSecretManagerConfigBuilder_.setMessage(value);
      }
      bitField1_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    public Builder setDesiredSecretManagerConfig(
        com.google.container.v1beta1.SecretManagerConfig.Builder builderForValue) {
      if (desiredSecretManagerConfigBuilder_ == null) {
        desiredSecretManagerConfig_ = builderForValue.build();
      } else {
        desiredSecretManagerConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    public Builder mergeDesiredSecretManagerConfig(
        com.google.container.v1beta1.SecretManagerConfig value) {
      if (desiredSecretManagerConfigBuilder_ == null) {
        if (((bitField1_ & 0x80000000) != 0)
            && desiredSecretManagerConfig_ != null
            && desiredSecretManagerConfig_
                != com.google.container.v1beta1.SecretManagerConfig.getDefaultInstance()) {
          getDesiredSecretManagerConfigBuilder().mergeFrom(value);
        } else {
          desiredSecretManagerConfig_ = value;
        }
      } else {
        desiredSecretManagerConfigBuilder_.mergeFrom(value);
      }
      if (desiredSecretManagerConfig_ != null) {
        bitField1_ |= 0x80000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    public Builder clearDesiredSecretManagerConfig() {
      bitField1_ = (bitField1_ & ~0x80000000);
      desiredSecretManagerConfig_ = null;
      if (desiredSecretManagerConfigBuilder_ != null) {
        desiredSecretManagerConfigBuilder_.dispose();
        desiredSecretManagerConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    public com.google.container.v1beta1.SecretManagerConfig.Builder
        getDesiredSecretManagerConfigBuilder() {
      bitField1_ |= 0x80000000;
      onChanged();
      return getDesiredSecretManagerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    public com.google.container.v1beta1.SecretManagerConfigOrBuilder
        getDesiredSecretManagerConfigOrBuilder() {
      if (desiredSecretManagerConfigBuilder_ != null) {
        return desiredSecretManagerConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredSecretManagerConfig_ == null
            ? com.google.container.v1beta1.SecretManagerConfig.getDefaultInstance()
            : desiredSecretManagerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable/Disable Secret Manager Config.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecretManagerConfig desired_secret_manager_config = 139;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.SecretManagerConfig,
            com.google.container.v1beta1.SecretManagerConfig.Builder,
            com.google.container.v1beta1.SecretManagerConfigOrBuilder>
        getDesiredSecretManagerConfigFieldBuilder() {
      if (desiredSecretManagerConfigBuilder_ == null) {
        desiredSecretManagerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.SecretManagerConfig,
                com.google.container.v1beta1.SecretManagerConfig.Builder,
                com.google.container.v1beta1.SecretManagerConfigOrBuilder>(
                getDesiredSecretManagerConfig(), getParentForChildren(), isClean());
        desiredSecretManagerConfig_ = null;
      }
      return desiredSecretManagerConfigBuilder_;
    }

    private com.google.container.v1beta1.NodeKubeletConfig desiredNodeKubeletConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeKubeletConfig,
            com.google.container.v1beta1.NodeKubeletConfig.Builder,
            com.google.container.v1beta1.NodeKubeletConfigOrBuilder>
        desiredNodeKubeletConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     *
     * @return Whether the desiredNodeKubeletConfig field is set.
     */
    public boolean hasDesiredNodeKubeletConfig() {
      return ((bitField2_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     *
     * @return The desiredNodeKubeletConfig.
     */
    public com.google.container.v1beta1.NodeKubeletConfig getDesiredNodeKubeletConfig() {
      if (desiredNodeKubeletConfigBuilder_ == null) {
        return desiredNodeKubeletConfig_ == null
            ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
            : desiredNodeKubeletConfig_;
      } else {
        return desiredNodeKubeletConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    public Builder setDesiredNodeKubeletConfig(
        com.google.container.v1beta1.NodeKubeletConfig value) {
      if (desiredNodeKubeletConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNodeKubeletConfig_ = value;
      } else {
        desiredNodeKubeletConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    public Builder setDesiredNodeKubeletConfig(
        com.google.container.v1beta1.NodeKubeletConfig.Builder builderForValue) {
      if (desiredNodeKubeletConfigBuilder_ == null) {
        desiredNodeKubeletConfig_ = builderForValue.build();
      } else {
        desiredNodeKubeletConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    public Builder mergeDesiredNodeKubeletConfig(
        com.google.container.v1beta1.NodeKubeletConfig value) {
      if (desiredNodeKubeletConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000001) != 0)
            && desiredNodeKubeletConfig_ != null
            && desiredNodeKubeletConfig_
                != com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()) {
          getDesiredNodeKubeletConfigBuilder().mergeFrom(value);
        } else {
          desiredNodeKubeletConfig_ = value;
        }
      } else {
        desiredNodeKubeletConfigBuilder_.mergeFrom(value);
      }
      if (desiredNodeKubeletConfig_ != null) {
        bitField2_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    public Builder clearDesiredNodeKubeletConfig() {
      bitField2_ = (bitField2_ & ~0x00000001);
      desiredNodeKubeletConfig_ = null;
      if (desiredNodeKubeletConfigBuilder_ != null) {
        desiredNodeKubeletConfigBuilder_.dispose();
        desiredNodeKubeletConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    public com.google.container.v1beta1.NodeKubeletConfig.Builder
        getDesiredNodeKubeletConfigBuilder() {
      bitField2_ |= 0x00000001;
      onChanged();
      return getDesiredNodeKubeletConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    public com.google.container.v1beta1.NodeKubeletConfigOrBuilder
        getDesiredNodeKubeletConfigOrBuilder() {
      if (desiredNodeKubeletConfigBuilder_ != null) {
        return desiredNodeKubeletConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredNodeKubeletConfig_ == null
            ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
            : desiredNodeKubeletConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for the cluster.
     * </pre>
     *
     * <code>.google.container.v1beta1.NodeKubeletConfig desired_node_kubelet_config = 141;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeKubeletConfig,
            com.google.container.v1beta1.NodeKubeletConfig.Builder,
            com.google.container.v1beta1.NodeKubeletConfigOrBuilder>
        getDesiredNodeKubeletConfigFieldBuilder() {
      if (desiredNodeKubeletConfigBuilder_ == null) {
        desiredNodeKubeletConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodeKubeletConfig,
                com.google.container.v1beta1.NodeKubeletConfig.Builder,
                com.google.container.v1beta1.NodeKubeletConfigOrBuilder>(
                getDesiredNodeKubeletConfig(), getParentForChildren(), isClean());
        desiredNodeKubeletConfig_ = null;
      }
      return desiredNodeKubeletConfigBuilder_;
    }

    private com.google.container.v1beta1.NodeKubeletConfig desiredNodePoolAutoConfigKubeletConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeKubeletConfig,
            com.google.container.v1beta1.NodeKubeletConfig.Builder,
            com.google.container.v1beta1.NodeKubeletConfigOrBuilder>
        desiredNodePoolAutoConfigKubeletConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     *
     * @return Whether the desiredNodePoolAutoConfigKubeletConfig field is set.
     */
    public boolean hasDesiredNodePoolAutoConfigKubeletConfig() {
      return ((bitField2_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     *
     * @return The desiredNodePoolAutoConfigKubeletConfig.
     */
    public com.google.container.v1beta1.NodeKubeletConfig
        getDesiredNodePoolAutoConfigKubeletConfig() {
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ == null) {
        return desiredNodePoolAutoConfigKubeletConfig_ == null
            ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
            : desiredNodePoolAutoConfigKubeletConfig_;
      } else {
        return desiredNodePoolAutoConfigKubeletConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    public Builder setDesiredNodePoolAutoConfigKubeletConfig(
        com.google.container.v1beta1.NodeKubeletConfig value) {
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        desiredNodePoolAutoConfigKubeletConfig_ = value;
      } else {
        desiredNodePoolAutoConfigKubeletConfigBuilder_.setMessage(value);
      }
      bitField2_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    public Builder setDesiredNodePoolAutoConfigKubeletConfig(
        com.google.container.v1beta1.NodeKubeletConfig.Builder builderForValue) {
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ == null) {
        desiredNodePoolAutoConfigKubeletConfig_ = builderForValue.build();
      } else {
        desiredNodePoolAutoConfigKubeletConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField2_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    public Builder mergeDesiredNodePoolAutoConfigKubeletConfig(
        com.google.container.v1beta1.NodeKubeletConfig value) {
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ == null) {
        if (((bitField2_ & 0x00000002) != 0)
            && desiredNodePoolAutoConfigKubeletConfig_ != null
            && desiredNodePoolAutoConfigKubeletConfig_
                != com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()) {
          getDesiredNodePoolAutoConfigKubeletConfigBuilder().mergeFrom(value);
        } else {
          desiredNodePoolAutoConfigKubeletConfig_ = value;
        }
      } else {
        desiredNodePoolAutoConfigKubeletConfigBuilder_.mergeFrom(value);
      }
      if (desiredNodePoolAutoConfigKubeletConfig_ != null) {
        bitField2_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    public Builder clearDesiredNodePoolAutoConfigKubeletConfig() {
      bitField2_ = (bitField2_ & ~0x00000002);
      desiredNodePoolAutoConfigKubeletConfig_ = null;
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ != null) {
        desiredNodePoolAutoConfigKubeletConfigBuilder_.dispose();
        desiredNodePoolAutoConfigKubeletConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    public com.google.container.v1beta1.NodeKubeletConfig.Builder
        getDesiredNodePoolAutoConfigKubeletConfigBuilder() {
      bitField2_ |= 0x00000002;
      onChanged();
      return getDesiredNodePoolAutoConfigKubeletConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    public com.google.container.v1beta1.NodeKubeletConfigOrBuilder
        getDesiredNodePoolAutoConfigKubeletConfigOrBuilder() {
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ != null) {
        return desiredNodePoolAutoConfigKubeletConfigBuilder_.getMessageOrBuilder();
      } else {
        return desiredNodePoolAutoConfigKubeletConfig_ == null
            ? com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()
            : desiredNodePoolAutoConfigKubeletConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired node kubelet config for all auto-provisioned node pools
     * in autopilot clusters and node auto-provisioning enabled clusters.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.NodeKubeletConfig desired_node_pool_auto_config_kubelet_config = 142;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeKubeletConfig,
            com.google.container.v1beta1.NodeKubeletConfig.Builder,
            com.google.container.v1beta1.NodeKubeletConfigOrBuilder>
        getDesiredNodePoolAutoConfigKubeletConfigFieldBuilder() {
      if (desiredNodePoolAutoConfigKubeletConfigBuilder_ == null) {
        desiredNodePoolAutoConfigKubeletConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodeKubeletConfig,
                com.google.container.v1beta1.NodeKubeletConfig.Builder,
                com.google.container.v1beta1.NodeKubeletConfigOrBuilder>(
                getDesiredNodePoolAutoConfigKubeletConfig(), getParentForChildren(), isClean());
        desiredNodePoolAutoConfigKubeletConfig_ = null;
      }
      return desiredNodePoolAutoConfigKubeletConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.ClusterUpdate)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.ClusterUpdate)
  private static final com.google.container.v1beta1.ClusterUpdate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.ClusterUpdate();
  }

  public static com.google.container.v1beta1.ClusterUpdate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClusterUpdate> PARSER =
      new com.google.protobuf.AbstractParser<ClusterUpdate>() {
        @java.lang.Override
        public ClusterUpdate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClusterUpdate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClusterUpdate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.ClusterUpdate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
