/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Node kubelet configs.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.NodeKubeletConfig}
 */
public final class NodeKubeletConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.NodeKubeletConfig)
    NodeKubeletConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeKubeletConfig.newBuilder() to construct.
  private NodeKubeletConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeKubeletConfig() {
    cpuManagerPolicy_ = "";
    cpuCfsQuotaPeriod_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeKubeletConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NodeKubeletConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NodeKubeletConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.NodeKubeletConfig.class,
            com.google.container.v1beta1.NodeKubeletConfig.Builder.class);
  }

  private int bitField0_;
  public static final int CPU_MANAGER_POLICY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cpuManagerPolicy_ = "";
  /**
   *
   *
   * <pre>
   * Control the CPU management policy on the node.
   * See
   * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
   *
   * The following values are allowed.
   * * "none": the default, which represents the existing scheduling behavior.
   * * "static": allows pods with certain resource characteristics to be granted
   * increased CPU affinity and exclusivity on the node.
   * The default value is 'none' if unspecified.
   * </pre>
   *
   * <code>string cpu_manager_policy = 1;</code>
   *
   * @return The cpuManagerPolicy.
   */
  @java.lang.Override
  public java.lang.String getCpuManagerPolicy() {
    java.lang.Object ref = cpuManagerPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuManagerPolicy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Control the CPU management policy on the node.
   * See
   * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
   *
   * The following values are allowed.
   * * "none": the default, which represents the existing scheduling behavior.
   * * "static": allows pods with certain resource characteristics to be granted
   * increased CPU affinity and exclusivity on the node.
   * The default value is 'none' if unspecified.
   * </pre>
   *
   * <code>string cpu_manager_policy = 1;</code>
   *
   * @return The bytes for cpuManagerPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuManagerPolicyBytes() {
    java.lang.Object ref = cpuManagerPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuManagerPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CPU_CFS_QUOTA_FIELD_NUMBER = 2;
  private com.google.protobuf.BoolValue cpuCfsQuota_;
  /**
   *
   *
   * <pre>
   * Enable CPU CFS quota enforcement for containers that specify CPU limits.
   *
   * This option is enabled by default which makes kubelet use CFS quota
   * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
   * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
   * all.
   *
   * Disable this option to mitigate CPU throttling problems while still having
   * your pods to be in Guaranteed QoS class by specifying the CPU limits.
   *
   * The default value is 'true' if unspecified.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
   *
   * @return Whether the cpuCfsQuota field is set.
   */
  @java.lang.Override
  public boolean hasCpuCfsQuota() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable CPU CFS quota enforcement for containers that specify CPU limits.
   *
   * This option is enabled by default which makes kubelet use CFS quota
   * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
   * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
   * all.
   *
   * Disable this option to mitigate CPU throttling problems while still having
   * your pods to be in Guaranteed QoS class by specifying the CPU limits.
   *
   * The default value is 'true' if unspecified.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
   *
   * @return The cpuCfsQuota.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getCpuCfsQuota() {
    return cpuCfsQuota_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : cpuCfsQuota_;
  }
  /**
   *
   *
   * <pre>
   * Enable CPU CFS quota enforcement for containers that specify CPU limits.
   *
   * This option is enabled by default which makes kubelet use CFS quota
   * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
   * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
   * all.
   *
   * Disable this option to mitigate CPU throttling problems while still having
   * your pods to be in Guaranteed QoS class by specifying the CPU limits.
   *
   * The default value is 'true' if unspecified.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getCpuCfsQuotaOrBuilder() {
    return cpuCfsQuota_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : cpuCfsQuota_;
  }

  public static final int CPU_CFS_QUOTA_PERIOD_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cpuCfsQuotaPeriod_ = "";
  /**
   *
   *
   * <pre>
   * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
   *
   * The string must be a sequence of decimal numbers, each with optional
   * fraction and a unit suffix, such as "300ms".
   * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
   * The value must be a positive duration.
   * </pre>
   *
   * <code>string cpu_cfs_quota_period = 3;</code>
   *
   * @return The cpuCfsQuotaPeriod.
   */
  @java.lang.Override
  public java.lang.String getCpuCfsQuotaPeriod() {
    java.lang.Object ref = cpuCfsQuotaPeriod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuCfsQuotaPeriod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
   *
   * The string must be a sequence of decimal numbers, each with optional
   * fraction and a unit suffix, such as "300ms".
   * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
   * The value must be a positive duration.
   * </pre>
   *
   * <code>string cpu_cfs_quota_period = 3;</code>
   *
   * @return The bytes for cpuCfsQuotaPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuCfsQuotaPeriodBytes() {
    java.lang.Object ref = cpuCfsQuotaPeriod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuCfsQuotaPeriod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POD_PIDS_LIMIT_FIELD_NUMBER = 4;
  private long podPidsLimit_ = 0L;
  /**
   *
   *
   * <pre>
   * Set the Pod PID limits. See
   * https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
   *
   * Controls the maximum number of processes allowed to run in a pod. The value
   * must be greater than or equal to 1024 and less than 4194304.
   * </pre>
   *
   * <code>int64 pod_pids_limit = 4;</code>
   *
   * @return The podPidsLimit.
   */
  @java.lang.Override
  public long getPodPidsLimit() {
    return podPidsLimit_;
  }

  public static final int INSECURE_KUBELET_READONLY_PORT_ENABLED_FIELD_NUMBER = 7;
  private boolean insecureKubeletReadonlyPortEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Enable or disable Kubelet read only port.
   * </pre>
   *
   * <code>optional bool insecure_kubelet_readonly_port_enabled = 7;</code>
   *
   * @return Whether the insecureKubeletReadonlyPortEnabled field is set.
   */
  @java.lang.Override
  public boolean hasInsecureKubeletReadonlyPortEnabled() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enable or disable Kubelet read only port.
   * </pre>
   *
   * <code>optional bool insecure_kubelet_readonly_port_enabled = 7;</code>
   *
   * @return The insecureKubeletReadonlyPortEnabled.
   */
  @java.lang.Override
  public boolean getInsecureKubeletReadonlyPortEnabled() {
    return insecureKubeletReadonlyPortEnabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuManagerPolicy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cpuManagerPolicy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCpuCfsQuota());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuCfsQuotaPeriod_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, cpuCfsQuotaPeriod_);
    }
    if (podPidsLimit_ != 0L) {
      output.writeInt64(4, podPidsLimit_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(7, insecureKubeletReadonlyPortEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuManagerPolicy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cpuManagerPolicy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCpuCfsQuota());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuCfsQuotaPeriod_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, cpuCfsQuotaPeriod_);
    }
    if (podPidsLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, podPidsLimit_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              7, insecureKubeletReadonlyPortEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.NodeKubeletConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.NodeKubeletConfig other =
        (com.google.container.v1beta1.NodeKubeletConfig) obj;

    if (!getCpuManagerPolicy().equals(other.getCpuManagerPolicy())) return false;
    if (hasCpuCfsQuota() != other.hasCpuCfsQuota()) return false;
    if (hasCpuCfsQuota()) {
      if (!getCpuCfsQuota().equals(other.getCpuCfsQuota())) return false;
    }
    if (!getCpuCfsQuotaPeriod().equals(other.getCpuCfsQuotaPeriod())) return false;
    if (getPodPidsLimit() != other.getPodPidsLimit()) return false;
    if (hasInsecureKubeletReadonlyPortEnabled() != other.hasInsecureKubeletReadonlyPortEnabled())
      return false;
    if (hasInsecureKubeletReadonlyPortEnabled()) {
      if (getInsecureKubeletReadonlyPortEnabled() != other.getInsecureKubeletReadonlyPortEnabled())
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CPU_MANAGER_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + getCpuManagerPolicy().hashCode();
    if (hasCpuCfsQuota()) {
      hash = (37 * hash) + CPU_CFS_QUOTA_FIELD_NUMBER;
      hash = (53 * hash) + getCpuCfsQuota().hashCode();
    }
    hash = (37 * hash) + CPU_CFS_QUOTA_PERIOD_FIELD_NUMBER;
    hash = (53 * hash) + getCpuCfsQuotaPeriod().hashCode();
    hash = (37 * hash) + POD_PIDS_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPodPidsLimit());
    if (hasInsecureKubeletReadonlyPortEnabled()) {
      hash = (37 * hash) + INSECURE_KUBELET_READONLY_PORT_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getInsecureKubeletReadonlyPortEnabled());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NodeKubeletConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.NodeKubeletConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Node kubelet configs.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NodeKubeletConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NodeKubeletConfig)
      com.google.container.v1beta1.NodeKubeletConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeKubeletConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeKubeletConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NodeKubeletConfig.class,
              com.google.container.v1beta1.NodeKubeletConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.NodeKubeletConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCpuCfsQuotaFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      cpuManagerPolicy_ = "";
      cpuCfsQuota_ = null;
      if (cpuCfsQuotaBuilder_ != null) {
        cpuCfsQuotaBuilder_.dispose();
        cpuCfsQuotaBuilder_ = null;
      }
      cpuCfsQuotaPeriod_ = "";
      podPidsLimit_ = 0L;
      insecureKubeletReadonlyPortEnabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeKubeletConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeKubeletConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeKubeletConfig build() {
      com.google.container.v1beta1.NodeKubeletConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeKubeletConfig buildPartial() {
      com.google.container.v1beta1.NodeKubeletConfig result =
          new com.google.container.v1beta1.NodeKubeletConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.NodeKubeletConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.cpuManagerPolicy_ = cpuManagerPolicy_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cpuCfsQuota_ =
            cpuCfsQuotaBuilder_ == null ? cpuCfsQuota_ : cpuCfsQuotaBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cpuCfsQuotaPeriod_ = cpuCfsQuotaPeriod_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.podPidsLimit_ = podPidsLimit_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.insecureKubeletReadonlyPortEnabled_ = insecureKubeletReadonlyPortEnabled_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.NodeKubeletConfig) {
        return mergeFrom((com.google.container.v1beta1.NodeKubeletConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.NodeKubeletConfig other) {
      if (other == com.google.container.v1beta1.NodeKubeletConfig.getDefaultInstance()) return this;
      if (!other.getCpuManagerPolicy().isEmpty()) {
        cpuManagerPolicy_ = other.cpuManagerPolicy_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCpuCfsQuota()) {
        mergeCpuCfsQuota(other.getCpuCfsQuota());
      }
      if (!other.getCpuCfsQuotaPeriod().isEmpty()) {
        cpuCfsQuotaPeriod_ = other.cpuCfsQuotaPeriod_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getPodPidsLimit() != 0L) {
        setPodPidsLimit(other.getPodPidsLimit());
      }
      if (other.hasInsecureKubeletReadonlyPortEnabled()) {
        setInsecureKubeletReadonlyPortEnabled(other.getInsecureKubeletReadonlyPortEnabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                cpuManagerPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCpuCfsQuotaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                cpuCfsQuotaPeriod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                podPidsLimit_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 56:
              {
                insecureKubeletReadonlyPortEnabled_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object cpuManagerPolicy_ = "";
    /**
     *
     *
     * <pre>
     * Control the CPU management policy on the node.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
     *
     * The following values are allowed.
     * * "none": the default, which represents the existing scheduling behavior.
     * * "static": allows pods with certain resource characteristics to be granted
     * increased CPU affinity and exclusivity on the node.
     * The default value is 'none' if unspecified.
     * </pre>
     *
     * <code>string cpu_manager_policy = 1;</code>
     *
     * @return The cpuManagerPolicy.
     */
    public java.lang.String getCpuManagerPolicy() {
      java.lang.Object ref = cpuManagerPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuManagerPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Control the CPU management policy on the node.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
     *
     * The following values are allowed.
     * * "none": the default, which represents the existing scheduling behavior.
     * * "static": allows pods with certain resource characteristics to be granted
     * increased CPU affinity and exclusivity on the node.
     * The default value is 'none' if unspecified.
     * </pre>
     *
     * <code>string cpu_manager_policy = 1;</code>
     *
     * @return The bytes for cpuManagerPolicy.
     */
    public com.google.protobuf.ByteString getCpuManagerPolicyBytes() {
      java.lang.Object ref = cpuManagerPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuManagerPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Control the CPU management policy on the node.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
     *
     * The following values are allowed.
     * * "none": the default, which represents the existing scheduling behavior.
     * * "static": allows pods with certain resource characteristics to be granted
     * increased CPU affinity and exclusivity on the node.
     * The default value is 'none' if unspecified.
     * </pre>
     *
     * <code>string cpu_manager_policy = 1;</code>
     *
     * @param value The cpuManagerPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setCpuManagerPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cpuManagerPolicy_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Control the CPU management policy on the node.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
     *
     * The following values are allowed.
     * * "none": the default, which represents the existing scheduling behavior.
     * * "static": allows pods with certain resource characteristics to be granted
     * increased CPU affinity and exclusivity on the node.
     * The default value is 'none' if unspecified.
     * </pre>
     *
     * <code>string cpu_manager_policy = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuManagerPolicy() {
      cpuManagerPolicy_ = getDefaultInstance().getCpuManagerPolicy();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Control the CPU management policy on the node.
     * See
     * https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
     *
     * The following values are allowed.
     * * "none": the default, which represents the existing scheduling behavior.
     * * "static": allows pods with certain resource characteristics to be granted
     * increased CPU affinity and exclusivity on the node.
     * The default value is 'none' if unspecified.
     * </pre>
     *
     * <code>string cpu_manager_policy = 1;</code>
     *
     * @param value The bytes for cpuManagerPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setCpuManagerPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cpuManagerPolicy_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue cpuCfsQuota_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        cpuCfsQuotaBuilder_;
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     *
     * @return Whether the cpuCfsQuota field is set.
     */
    public boolean hasCpuCfsQuota() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     *
     * @return The cpuCfsQuota.
     */
    public com.google.protobuf.BoolValue getCpuCfsQuota() {
      if (cpuCfsQuotaBuilder_ == null) {
        return cpuCfsQuota_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : cpuCfsQuota_;
      } else {
        return cpuCfsQuotaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    public Builder setCpuCfsQuota(com.google.protobuf.BoolValue value) {
      if (cpuCfsQuotaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cpuCfsQuota_ = value;
      } else {
        cpuCfsQuotaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    public Builder setCpuCfsQuota(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (cpuCfsQuotaBuilder_ == null) {
        cpuCfsQuota_ = builderForValue.build();
      } else {
        cpuCfsQuotaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    public Builder mergeCpuCfsQuota(com.google.protobuf.BoolValue value) {
      if (cpuCfsQuotaBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && cpuCfsQuota_ != null
            && cpuCfsQuota_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getCpuCfsQuotaBuilder().mergeFrom(value);
        } else {
          cpuCfsQuota_ = value;
        }
      } else {
        cpuCfsQuotaBuilder_.mergeFrom(value);
      }
      if (cpuCfsQuota_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    public Builder clearCpuCfsQuota() {
      bitField0_ = (bitField0_ & ~0x00000002);
      cpuCfsQuota_ = null;
      if (cpuCfsQuotaBuilder_ != null) {
        cpuCfsQuotaBuilder_.dispose();
        cpuCfsQuotaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    public com.google.protobuf.BoolValue.Builder getCpuCfsQuotaBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCpuCfsQuotaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getCpuCfsQuotaOrBuilder() {
      if (cpuCfsQuotaBuilder_ != null) {
        return cpuCfsQuotaBuilder_.getMessageOrBuilder();
      } else {
        return cpuCfsQuota_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : cpuCfsQuota_;
      }
    }
    /**
     *
     *
     * <pre>
     * Enable CPU CFS quota enforcement for containers that specify CPU limits.
     *
     * This option is enabled by default which makes kubelet use CFS quota
     * (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
     * enforce container CPU limits. Otherwise, CPU limits will not be enforced at
     * all.
     *
     * Disable this option to mitigate CPU throttling problems while still having
     * your pods to be in Guaranteed QoS class by specifying the CPU limits.
     *
     * The default value is 'true' if unspecified.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue cpu_cfs_quota = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getCpuCfsQuotaFieldBuilder() {
      if (cpuCfsQuotaBuilder_ == null) {
        cpuCfsQuotaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getCpuCfsQuota(), getParentForChildren(), isClean());
        cpuCfsQuota_ = null;
      }
      return cpuCfsQuotaBuilder_;
    }

    private java.lang.Object cpuCfsQuotaPeriod_ = "";
    /**
     *
     *
     * <pre>
     * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
     *
     * The string must be a sequence of decimal numbers, each with optional
     * fraction and a unit suffix, such as "300ms".
     * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
     * The value must be a positive duration.
     * </pre>
     *
     * <code>string cpu_cfs_quota_period = 3;</code>
     *
     * @return The cpuCfsQuotaPeriod.
     */
    public java.lang.String getCpuCfsQuotaPeriod() {
      java.lang.Object ref = cpuCfsQuotaPeriod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuCfsQuotaPeriod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
     *
     * The string must be a sequence of decimal numbers, each with optional
     * fraction and a unit suffix, such as "300ms".
     * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
     * The value must be a positive duration.
     * </pre>
     *
     * <code>string cpu_cfs_quota_period = 3;</code>
     *
     * @return The bytes for cpuCfsQuotaPeriod.
     */
    public com.google.protobuf.ByteString getCpuCfsQuotaPeriodBytes() {
      java.lang.Object ref = cpuCfsQuotaPeriod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuCfsQuotaPeriod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
     *
     * The string must be a sequence of decimal numbers, each with optional
     * fraction and a unit suffix, such as "300ms".
     * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
     * The value must be a positive duration.
     * </pre>
     *
     * <code>string cpu_cfs_quota_period = 3;</code>
     *
     * @param value The cpuCfsQuotaPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setCpuCfsQuotaPeriod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cpuCfsQuotaPeriod_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
     *
     * The string must be a sequence of decimal numbers, each with optional
     * fraction and a unit suffix, such as "300ms".
     * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
     * The value must be a positive duration.
     * </pre>
     *
     * <code>string cpu_cfs_quota_period = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuCfsQuotaPeriod() {
      cpuCfsQuotaPeriod_ = getDefaultInstance().getCpuCfsQuotaPeriod();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
     *
     * The string must be a sequence of decimal numbers, each with optional
     * fraction and a unit suffix, such as "300ms".
     * Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
     * The value must be a positive duration.
     * </pre>
     *
     * <code>string cpu_cfs_quota_period = 3;</code>
     *
     * @param value The bytes for cpuCfsQuotaPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setCpuCfsQuotaPeriodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cpuCfsQuotaPeriod_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long podPidsLimit_;
    /**
     *
     *
     * <pre>
     * Set the Pod PID limits. See
     * https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
     *
     * Controls the maximum number of processes allowed to run in a pod. The value
     * must be greater than or equal to 1024 and less than 4194304.
     * </pre>
     *
     * <code>int64 pod_pids_limit = 4;</code>
     *
     * @return The podPidsLimit.
     */
    @java.lang.Override
    public long getPodPidsLimit() {
      return podPidsLimit_;
    }
    /**
     *
     *
     * <pre>
     * Set the Pod PID limits. See
     * https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
     *
     * Controls the maximum number of processes allowed to run in a pod. The value
     * must be greater than or equal to 1024 and less than 4194304.
     * </pre>
     *
     * <code>int64 pod_pids_limit = 4;</code>
     *
     * @param value The podPidsLimit to set.
     * @return This builder for chaining.
     */
    public Builder setPodPidsLimit(long value) {

      podPidsLimit_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set the Pod PID limits. See
     * https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
     *
     * Controls the maximum number of processes allowed to run in a pod. The value
     * must be greater than or equal to 1024 and less than 4194304.
     * </pre>
     *
     * <code>int64 pod_pids_limit = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPodPidsLimit() {
      bitField0_ = (bitField0_ & ~0x00000008);
      podPidsLimit_ = 0L;
      onChanged();
      return this;
    }

    private boolean insecureKubeletReadonlyPortEnabled_;
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 7;</code>
     *
     * @return Whether the insecureKubeletReadonlyPortEnabled field is set.
     */
    @java.lang.Override
    public boolean hasInsecureKubeletReadonlyPortEnabled() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 7;</code>
     *
     * @return The insecureKubeletReadonlyPortEnabled.
     */
    @java.lang.Override
    public boolean getInsecureKubeletReadonlyPortEnabled() {
      return insecureKubeletReadonlyPortEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 7;</code>
     *
     * @param value The insecureKubeletReadonlyPortEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setInsecureKubeletReadonlyPortEnabled(boolean value) {

      insecureKubeletReadonlyPortEnabled_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable or disable Kubelet read only port.
     * </pre>
     *
     * <code>optional bool insecure_kubelet_readonly_port_enabled = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInsecureKubeletReadonlyPortEnabled() {
      bitField0_ = (bitField0_ & ~0x00000010);
      insecureKubeletReadonlyPortEnabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NodeKubeletConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.NodeKubeletConfig)
  private static final com.google.container.v1beta1.NodeKubeletConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.NodeKubeletConfig();
  }

  public static com.google.container.v1beta1.NodeKubeletConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeKubeletConfig> PARSER =
      new com.google.protobuf.AbstractParser<NodeKubeletConfig>() {
        @java.lang.Override
        public NodeKubeletConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeKubeletConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeKubeletConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.NodeKubeletConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
