/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Parameters for node pool-level network config.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.NodeNetworkConfig}
 */
public final class NodeNetworkConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.NodeNetworkConfig)
    NodeNetworkConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NodeNetworkConfig.newBuilder() to construct.
  private NodeNetworkConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NodeNetworkConfig() {
    podRange_ = "";
    podIpv4CidrBlock_ = "";
    additionalNodeNetworkConfigs_ = java.util.Collections.emptyList();
    additionalPodNetworkConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NodeNetworkConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NodeNetworkConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NodeNetworkConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.NodeNetworkConfig.class,
            com.google.container.v1beta1.NodeNetworkConfig.Builder.class);
  }

  public interface NetworkPerformanceConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return Whether the totalEgressBandwidthTier field is set.
     */
    boolean hasTotalEgressBandwidthTier();
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for totalEgressBandwidthTier.
     */
    int getTotalEgressBandwidthTierValue();
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The totalEgressBandwidthTier.
     */
    com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
        getTotalEgressBandwidthTier();

    /**
     *
     *
     * <pre>
     * Specifies the network bandwidth tier for the NodePool for traffic to
     * external/public IP addresses.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
     * </code>
     *
     * @return Whether the externalIpEgressBandwidthTier field is set.
     */
    boolean hasExternalIpEgressBandwidthTier();
    /**
     *
     *
     * <pre>
     * Specifies the network bandwidth tier for the NodePool for traffic to
     * external/public IP addresses.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for externalIpEgressBandwidthTier.
     */
    int getExternalIpEgressBandwidthTierValue();
    /**
     *
     *
     * <pre>
     * Specifies the network bandwidth tier for the NodePool for traffic to
     * external/public IP addresses.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
     * </code>
     *
     * @return The externalIpEgressBandwidthTier.
     */
    com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
        getExternalIpEgressBandwidthTier();
  }
  /**
   *
   *
   * <pre>
   * Configuration of all network bandwidth tiers
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig}
   */
  public static final class NetworkPerformanceConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig)
      NetworkPerformanceConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkPerformanceConfig.newBuilder() to construct.
    private NetworkPerformanceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPerformanceConfig() {
      totalEgressBandwidthTier_ = 0;
      externalIpEgressBandwidthTier_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NetworkPerformanceConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeNetworkConfig_NetworkPerformanceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeNetworkConfig_NetworkPerformanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.class,
              com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Node network tier
     * </pre>
     *
     * Protobuf enum {@code
     * google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier}
     */
    public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value
       * </pre>
       *
       * <code>TIER_UNSPECIFIED = 0;</code>
       */
      TIER_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Higher bandwidth, actual values based on VM size.
       * </pre>
       *
       * <code>TIER_1 = 1;</code>
       */
      TIER_1(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value
       * </pre>
       *
       * <code>TIER_UNSPECIFIED = 0;</code>
       */
      public static final int TIER_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Higher bandwidth, actual values based on VM size.
       * </pre>
       *
       * <code>TIER_1 = 1;</code>
       */
      public static final int TIER_1_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Tier valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Tier forNumber(int value) {
        switch (value) {
          case 0:
            return TIER_UNSPECIFIED;
          case 1:
            return TIER_1;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
            public Tier findValueByNumber(int number) {
              return Tier.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Tier[] VALUES = values();

      public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Tier(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier)
    }

    private int bitField0_;
    public static final int TOTAL_EGRESS_BANDWIDTH_TIER_FIELD_NUMBER = 1;
    private int totalEgressBandwidthTier_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return Whether the totalEgressBandwidthTier field is set.
     */
    @java.lang.Override
    public boolean hasTotalEgressBandwidthTier() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for totalEgressBandwidthTier.
     */
    @java.lang.Override
    public int getTotalEgressBandwidthTierValue() {
      return totalEgressBandwidthTier_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the total network bandwidth tier for the NodePool.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
     * </code>
     *
     * @return The totalEgressBandwidthTier.
     */
    @java.lang.Override
    public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
        getTotalEgressBandwidthTier() {
      com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier result =
          com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier.forNumber(
              totalEgressBandwidthTier_);
      return result == null
          ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
              .UNRECOGNIZED
          : result;
    }

    public static final int EXTERNAL_IP_EGRESS_BANDWIDTH_TIER_FIELD_NUMBER = 2;
    private int externalIpEgressBandwidthTier_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the network bandwidth tier for the NodePool for traffic to
     * external/public IP addresses.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
     * </code>
     *
     * @return Whether the externalIpEgressBandwidthTier field is set.
     */
    @java.lang.Override
    public boolean hasExternalIpEgressBandwidthTier() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the network bandwidth tier for the NodePool for traffic to
     * external/public IP addresses.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for externalIpEgressBandwidthTier.
     */
    @java.lang.Override
    public int getExternalIpEgressBandwidthTierValue() {
      return externalIpEgressBandwidthTier_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the network bandwidth tier for the NodePool for traffic to
     * external/public IP addresses.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
     * </code>
     *
     * @return The externalIpEgressBandwidthTier.
     */
    @java.lang.Override
    public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
        getExternalIpEgressBandwidthTier() {
      com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier result =
          com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier.forNumber(
              externalIpEgressBandwidthTier_);
      return result == null
          ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, totalEgressBandwidthTier_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(2, externalIpEgressBandwidthTier_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, totalEgressBandwidthTier_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(
                2, externalIpEgressBandwidthTier_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig other =
          (com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig) obj;

      if (hasTotalEgressBandwidthTier() != other.hasTotalEgressBandwidthTier()) return false;
      if (hasTotalEgressBandwidthTier()) {
        if (totalEgressBandwidthTier_ != other.totalEgressBandwidthTier_) return false;
      }
      if (hasExternalIpEgressBandwidthTier() != other.hasExternalIpEgressBandwidthTier())
        return false;
      if (hasExternalIpEgressBandwidthTier()) {
        if (externalIpEgressBandwidthTier_ != other.externalIpEgressBandwidthTier_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTotalEgressBandwidthTier()) {
        hash = (37 * hash) + TOTAL_EGRESS_BANDWIDTH_TIER_FIELD_NUMBER;
        hash = (53 * hash) + totalEgressBandwidthTier_;
      }
      if (hasExternalIpEgressBandwidthTier()) {
        hash = (37 * hash) + EXTERNAL_IP_EGRESS_BANDWIDTH_TIER_FIELD_NUMBER;
        hash = (53 * hash) + externalIpEgressBandwidthTier_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of all network bandwidth tiers
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig)
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NodeNetworkConfig_NetworkPerformanceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NodeNetworkConfig_NetworkPerformanceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.class,
                com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        totalEgressBandwidthTier_ = 0;
        externalIpEgressBandwidthTier_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NodeNetworkConfig_NetworkPerformanceConfig_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
          getDefaultInstanceForType() {
        return com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig build() {
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
          buildPartial() {
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig result =
            new com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.totalEgressBandwidthTier_ = totalEgressBandwidthTier_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.externalIpEgressBandwidthTier_ = externalIpEgressBandwidthTier_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig) {
          return mergeFrom(
              (com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig other) {
        if (other
            == com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
                .getDefaultInstance()) return this;
        if (other.hasTotalEgressBandwidthTier()) {
          setTotalEgressBandwidthTier(other.getTotalEgressBandwidthTier());
        }
        if (other.hasExternalIpEgressBandwidthTier()) {
          setExternalIpEgressBandwidthTier(other.getExternalIpEgressBandwidthTier());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  totalEgressBandwidthTier_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  externalIpEgressBandwidthTier_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int totalEgressBandwidthTier_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return Whether the totalEgressBandwidthTier field is set.
       */
      @java.lang.Override
      public boolean hasTotalEgressBandwidthTier() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for totalEgressBandwidthTier.
       */
      @java.lang.Override
      public int getTotalEgressBandwidthTierValue() {
        return totalEgressBandwidthTier_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for totalEgressBandwidthTier to set.
       * @return This builder for chaining.
       */
      public Builder setTotalEgressBandwidthTierValue(int value) {
        totalEgressBandwidthTier_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return The totalEgressBandwidthTier.
       */
      @java.lang.Override
      public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
          getTotalEgressBandwidthTier() {
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier result =
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier.forNumber(
                totalEgressBandwidthTier_);
        return result == null
            ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @param value The totalEgressBandwidthTier to set.
       * @return This builder for chaining.
       */
      public Builder setTotalEgressBandwidthTier(
          com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        totalEgressBandwidthTier_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the total network bandwidth tier for the NodePool.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier total_egress_bandwidth_tier = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalEgressBandwidthTier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        totalEgressBandwidthTier_ = 0;
        onChanged();
        return this;
      }

      private int externalIpEgressBandwidthTier_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the network bandwidth tier for the NodePool for traffic to
       * external/public IP addresses.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
       * </code>
       *
       * @return Whether the externalIpEgressBandwidthTier field is set.
       */
      @java.lang.Override
      public boolean hasExternalIpEgressBandwidthTier() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Specifies the network bandwidth tier for the NodePool for traffic to
       * external/public IP addresses.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for externalIpEgressBandwidthTier.
       */
      @java.lang.Override
      public int getExternalIpEgressBandwidthTierValue() {
        return externalIpEgressBandwidthTier_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network bandwidth tier for the NodePool for traffic to
       * external/public IP addresses.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for externalIpEgressBandwidthTier to set.
       * @return This builder for chaining.
       */
      public Builder setExternalIpEgressBandwidthTierValue(int value) {
        externalIpEgressBandwidthTier_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network bandwidth tier for the NodePool for traffic to
       * external/public IP addresses.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
       * </code>
       *
       * @return The externalIpEgressBandwidthTier.
       */
      @java.lang.Override
      public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
          getExternalIpEgressBandwidthTier() {
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier result =
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier.forNumber(
                externalIpEgressBandwidthTier_);
        return result == null
            ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network bandwidth tier for the NodePool for traffic to
       * external/public IP addresses.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
       * </code>
       *
       * @param value The externalIpEgressBandwidthTier to set.
       * @return This builder for chaining.
       */
      public Builder setExternalIpEgressBandwidthTier(
          com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        externalIpEgressBandwidthTier_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network bandwidth tier for the NodePool for traffic to
       * external/public IP addresses.
       * </pre>
       *
       * <code>
       * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Tier external_ip_egress_bandwidth_tier = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExternalIpEgressBandwidthTier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        externalIpEgressBandwidthTier_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig)
    private static final com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig();
    }

    public static com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NetworkPerformanceConfig> PARSER =
        new com.google.protobuf.AbstractParser<NetworkPerformanceConfig>() {
          @java.lang.Override
          public NetworkPerformanceConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NetworkPerformanceConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkPerformanceConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CREATE_POD_RANGE_FIELD_NUMBER = 4;
  private boolean createPodRange_ = false;
  /**
   *
   *
   * <pre>
   * Input only. Whether to create a new range for pod IPs in this node pool.
   * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
   * are not specified.
   *
   * If neither `create_pod_range` or `pod_range` are specified, the
   * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
   * used.
   *
   * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
   *
   * This field cannot be changed after the node pool has been created.
   * </pre>
   *
   * <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The createPodRange.
   */
  @java.lang.Override
  public boolean getCreatePodRange() {
    return createPodRange_;
  }

  public static final int POD_RANGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object podRange_ = "";
  /**
   *
   *
   * <pre>
   * The ID of the secondary range for pod IPs.
   * If `create_pod_range` is true, this ID is used for the new range.
   * If `create_pod_range` is false, uses an existing secondary range with this
   * ID.
   *
   * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
   *
   * This field cannot be changed after the node pool has been created.
   * </pre>
   *
   * <code>string pod_range = 5;</code>
   *
   * @return The podRange.
   */
  @java.lang.Override
  public java.lang.String getPodRange() {
    java.lang.Object ref = podRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      podRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the secondary range for pod IPs.
   * If `create_pod_range` is true, this ID is used for the new range.
   * If `create_pod_range` is false, uses an existing secondary range with this
   * ID.
   *
   * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
   *
   * This field cannot be changed after the node pool has been created.
   * </pre>
   *
   * <code>string pod_range = 5;</code>
   *
   * @return The bytes for podRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPodRangeBytes() {
    java.lang.Object ref = podRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      podRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POD_IPV4_CIDR_BLOCK_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object podIpv4CidrBlock_ = "";
  /**
   *
   *
   * <pre>
   * The IP address range for pod IPs in this node pool.
   *
   * Only applicable if `create_pod_range` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
   *
   * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
   *
   * This field cannot be changed after the node pool has been created.
   * </pre>
   *
   * <code>string pod_ipv4_cidr_block = 6;</code>
   *
   * @return The podIpv4CidrBlock.
   */
  @java.lang.Override
  public java.lang.String getPodIpv4CidrBlock() {
    java.lang.Object ref = podIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      podIpv4CidrBlock_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP address range for pod IPs in this node pool.
   *
   * Only applicable if `create_pod_range` is true.
   *
   * Set to blank to have a range chosen with the default size.
   *
   * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
   * netmask.
   *
   * Set to a
   * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
   * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
   *
   * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
   *
   * This field cannot be changed after the node pool has been created.
   * </pre>
   *
   * <code>string pod_ipv4_cidr_block = 6;</code>
   *
   * @return The bytes for podIpv4CidrBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPodIpv4CidrBlockBytes() {
    java.lang.Object ref = podIpv4CidrBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      podIpv4CidrBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_PRIVATE_NODES_FIELD_NUMBER = 9;
  private boolean enablePrivateNodes_ = false;
  /**
   *
   *
   * <pre>
   * Whether nodes have internal IP addresses only.
   * If enable_private_nodes is not specified, then the value is derived from
   * [cluster.privateClusterConfig.enablePrivateNodes][google.container.v1beta1.PrivateClusterConfig.enablePrivateNodes]
   * </pre>
   *
   * <code>optional bool enable_private_nodes = 9;</code>
   *
   * @return Whether the enablePrivateNodes field is set.
   */
  @java.lang.Override
  public boolean hasEnablePrivateNodes() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether nodes have internal IP addresses only.
   * If enable_private_nodes is not specified, then the value is derived from
   * [cluster.privateClusterConfig.enablePrivateNodes][google.container.v1beta1.PrivateClusterConfig.enablePrivateNodes]
   * </pre>
   *
   * <code>optional bool enable_private_nodes = 9;</code>
   *
   * @return The enablePrivateNodes.
   */
  @java.lang.Override
  public boolean getEnablePrivateNodes() {
    return enablePrivateNodes_;
  }

  public static final int NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER = 11;
  private com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
      networkPerformanceConfig_;
  /**
   *
   *
   * <pre>
   * Network bandwidth tier configuration.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
   * </code>
   *
   * @return Whether the networkPerformanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPerformanceConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Network bandwidth tier configuration.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
   * </code>
   *
   * @return The networkPerformanceConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
      getNetworkPerformanceConfig() {
    return networkPerformanceConfig_ == null
        ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
            .getDefaultInstance()
        : networkPerformanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Network bandwidth tier configuration.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfigOrBuilder
      getNetworkPerformanceConfigOrBuilder() {
    return networkPerformanceConfig_ == null
        ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
            .getDefaultInstance()
        : networkPerformanceConfig_;
  }

  public static final int POD_CIDR_OVERPROVISION_CONFIG_FIELD_NUMBER = 13;
  private com.google.container.v1beta1.PodCIDROverprovisionConfig podCidrOverprovisionConfig_;
  /**
   *
   *
   * <pre>
   * [PRIVATE FIELD]
   * Pod CIDR size overprovisioning config for the nodepool.
   *
   * Pod CIDR size per node depends on max_pods_per_node. By default, the value
   * of max_pods_per_node is rounded off to next power of 2 and we then double
   * that to get the size of pod CIDR block per node.
   * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
   *
   * This config can disable the doubling of IPs (we still round off to next
   * power of 2)
   * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
   * overprovisioning is disabled.
   * </pre>
   *
   * <code>.google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
   * </code>
   *
   * @return Whether the podCidrOverprovisionConfig field is set.
   */
  @java.lang.Override
  public boolean hasPodCidrOverprovisionConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [PRIVATE FIELD]
   * Pod CIDR size overprovisioning config for the nodepool.
   *
   * Pod CIDR size per node depends on max_pods_per_node. By default, the value
   * of max_pods_per_node is rounded off to next power of 2 and we then double
   * that to get the size of pod CIDR block per node.
   * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
   *
   * This config can disable the doubling of IPs (we still round off to next
   * power of 2)
   * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
   * overprovisioning is disabled.
   * </pre>
   *
   * <code>.google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
   * </code>
   *
   * @return The podCidrOverprovisionConfig.
   */
  @java.lang.Override
  public com.google.container.v1beta1.PodCIDROverprovisionConfig getPodCidrOverprovisionConfig() {
    return podCidrOverprovisionConfig_ == null
        ? com.google.container.v1beta1.PodCIDROverprovisionConfig.getDefaultInstance()
        : podCidrOverprovisionConfig_;
  }
  /**
   *
   *
   * <pre>
   * [PRIVATE FIELD]
   * Pod CIDR size overprovisioning config for the nodepool.
   *
   * Pod CIDR size per node depends on max_pods_per_node. By default, the value
   * of max_pods_per_node is rounded off to next power of 2 and we then double
   * that to get the size of pod CIDR block per node.
   * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
   *
   * This config can disable the doubling of IPs (we still round off to next
   * power of 2)
   * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
   * overprovisioning is disabled.
   * </pre>
   *
   * <code>.google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.PodCIDROverprovisionConfigOrBuilder
      getPodCidrOverprovisionConfigOrBuilder() {
    return podCidrOverprovisionConfig_ == null
        ? com.google.container.v1beta1.PodCIDROverprovisionConfig.getDefaultInstance()
        : podCidrOverprovisionConfig_;
  }

  public static final int ADDITIONAL_NODE_NETWORK_CONFIGS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1beta1.AdditionalNodeNetworkConfig>
      additionalNodeNetworkConfigs_;
  /**
   *
   *
   * <pre>
   * We specify the additional node networks for this node pool using this list.
   * Each node network corresponds to an additional interface
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1beta1.AdditionalNodeNetworkConfig>
      getAdditionalNodeNetworkConfigsList() {
    return additionalNodeNetworkConfigs_;
  }
  /**
   *
   *
   * <pre>
   * We specify the additional node networks for this node pool using this list.
   * Each node network corresponds to an additional interface
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder>
      getAdditionalNodeNetworkConfigsOrBuilderList() {
    return additionalNodeNetworkConfigs_;
  }
  /**
   *
   *
   * <pre>
   * We specify the additional node networks for this node pool using this list.
   * Each node network corresponds to an additional interface
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
   * </code>
   */
  @java.lang.Override
  public int getAdditionalNodeNetworkConfigsCount() {
    return additionalNodeNetworkConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * We specify the additional node networks for this node pool using this list.
   * Each node network corresponds to an additional interface
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalNodeNetworkConfig getAdditionalNodeNetworkConfigs(
      int index) {
    return additionalNodeNetworkConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * We specify the additional node networks for this node pool using this list.
   * Each node network corresponds to an additional interface
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder
      getAdditionalNodeNetworkConfigsOrBuilder(int index) {
    return additionalNodeNetworkConfigs_.get(index);
  }

  public static final int ADDITIONAL_POD_NETWORK_CONFIGS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1beta1.AdditionalPodNetworkConfig>
      additionalPodNetworkConfigs_;
  /**
   *
   *
   * <pre>
   * We specify the additional pod networks for this node pool using this list.
   * Each pod network corresponds to an additional alias IP range for the node
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1beta1.AdditionalPodNetworkConfig>
      getAdditionalPodNetworkConfigsList() {
    return additionalPodNetworkConfigs_;
  }
  /**
   *
   *
   * <pre>
   * We specify the additional pod networks for this node pool using this list.
   * Each pod network corresponds to an additional alias IP range for the node
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder>
      getAdditionalPodNetworkConfigsOrBuilderList() {
    return additionalPodNetworkConfigs_;
  }
  /**
   *
   *
   * <pre>
   * We specify the additional pod networks for this node pool using this list.
   * Each pod network corresponds to an additional alias IP range for the node
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
   * </code>
   */
  @java.lang.Override
  public int getAdditionalPodNetworkConfigsCount() {
    return additionalPodNetworkConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * We specify the additional pod networks for this node pool using this list.
   * Each pod network corresponds to an additional alias IP range for the node
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalPodNetworkConfig getAdditionalPodNetworkConfigs(
      int index) {
    return additionalPodNetworkConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * We specify the additional pod networks for this node pool using this list.
   * Each pod network corresponds to an additional alias IP range for the node
   * </pre>
   *
   * <code>
   * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder
      getAdditionalPodNetworkConfigsOrBuilder(int index) {
    return additionalPodNetworkConfigs_.get(index);
  }

  public static final int POD_IPV4_RANGE_UTILIZATION_FIELD_NUMBER = 16;
  private double podIpv4RangeUtilization_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The utilization of the IPv4 range for the pod.
   * The ratio is Usage/[Total number of IPs in the secondary range],
   * Usage=numNodes*numZones*podIPsPerNode.
   * </pre>
   *
   * <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The podIpv4RangeUtilization.
   */
  @java.lang.Override
  public double getPodIpv4RangeUtilization() {
    return podIpv4RangeUtilization_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createPodRange_ != false) {
      output.writeBool(4, createPodRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(podRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, podRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(podIpv4CidrBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, podIpv4CidrBlock_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(9, enablePrivateNodes_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getPodCidrOverprovisionConfig());
    }
    for (int i = 0; i < additionalNodeNetworkConfigs_.size(); i++) {
      output.writeMessage(14, additionalNodeNetworkConfigs_.get(i));
    }
    for (int i = 0; i < additionalPodNetworkConfigs_.size(); i++) {
      output.writeMessage(15, additionalPodNetworkConfigs_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(podIpv4RangeUtilization_) != 0) {
      output.writeDouble(16, podIpv4RangeUtilization_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createPodRange_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, createPodRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(podRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, podRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(podIpv4CidrBlock_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, podIpv4CidrBlock_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, enablePrivateNodes_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, getPodCidrOverprovisionConfig());
    }
    for (int i = 0; i < additionalNodeNetworkConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, additionalNodeNetworkConfigs_.get(i));
    }
    for (int i = 0; i < additionalPodNetworkConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, additionalPodNetworkConfigs_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(podIpv4RangeUtilization_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(16, podIpv4RangeUtilization_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.NodeNetworkConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.NodeNetworkConfig other =
        (com.google.container.v1beta1.NodeNetworkConfig) obj;

    if (getCreatePodRange() != other.getCreatePodRange()) return false;
    if (!getPodRange().equals(other.getPodRange())) return false;
    if (!getPodIpv4CidrBlock().equals(other.getPodIpv4CidrBlock())) return false;
    if (hasEnablePrivateNodes() != other.hasEnablePrivateNodes()) return false;
    if (hasEnablePrivateNodes()) {
      if (getEnablePrivateNodes() != other.getEnablePrivateNodes()) return false;
    }
    if (hasNetworkPerformanceConfig() != other.hasNetworkPerformanceConfig()) return false;
    if (hasNetworkPerformanceConfig()) {
      if (!getNetworkPerformanceConfig().equals(other.getNetworkPerformanceConfig())) return false;
    }
    if (hasPodCidrOverprovisionConfig() != other.hasPodCidrOverprovisionConfig()) return false;
    if (hasPodCidrOverprovisionConfig()) {
      if (!getPodCidrOverprovisionConfig().equals(other.getPodCidrOverprovisionConfig()))
        return false;
    }
    if (!getAdditionalNodeNetworkConfigsList().equals(other.getAdditionalNodeNetworkConfigsList()))
      return false;
    if (!getAdditionalPodNetworkConfigsList().equals(other.getAdditionalPodNetworkConfigsList()))
      return false;
    if (java.lang.Double.doubleToLongBits(getPodIpv4RangeUtilization())
        != java.lang.Double.doubleToLongBits(other.getPodIpv4RangeUtilization())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CREATE_POD_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCreatePodRange());
    hash = (37 * hash) + POD_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getPodRange().hashCode();
    hash = (37 * hash) + POD_IPV4_CIDR_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getPodIpv4CidrBlock().hashCode();
    if (hasEnablePrivateNodes()) {
      hash = (37 * hash) + ENABLE_PRIVATE_NODES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateNodes());
    }
    if (hasNetworkPerformanceConfig()) {
      hash = (37 * hash) + NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPerformanceConfig().hashCode();
    }
    if (hasPodCidrOverprovisionConfig()) {
      hash = (37 * hash) + POD_CIDR_OVERPROVISION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPodCidrOverprovisionConfig().hashCode();
    }
    if (getAdditionalNodeNetworkConfigsCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_NODE_NETWORK_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalNodeNetworkConfigsList().hashCode();
    }
    if (getAdditionalPodNetworkConfigsCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_POD_NETWORK_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalPodNetworkConfigsList().hashCode();
    }
    hash = (37 * hash) + POD_IPV4_RANGE_UTILIZATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getPodIpv4RangeUtilization()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NodeNetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.NodeNetworkConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters for node pool-level network config.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NodeNetworkConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NodeNetworkConfig)
      com.google.container.v1beta1.NodeNetworkConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeNetworkConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeNetworkConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NodeNetworkConfig.class,
              com.google.container.v1beta1.NodeNetworkConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.NodeNetworkConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNetworkPerformanceConfigFieldBuilder();
        getPodCidrOverprovisionConfigFieldBuilder();
        getAdditionalNodeNetworkConfigsFieldBuilder();
        getAdditionalPodNetworkConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createPodRange_ = false;
      podRange_ = "";
      podIpv4CidrBlock_ = "";
      enablePrivateNodes_ = false;
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      podCidrOverprovisionConfig_ = null;
      if (podCidrOverprovisionConfigBuilder_ != null) {
        podCidrOverprovisionConfigBuilder_.dispose();
        podCidrOverprovisionConfigBuilder_ = null;
      }
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        additionalNodeNetworkConfigs_ = java.util.Collections.emptyList();
      } else {
        additionalNodeNetworkConfigs_ = null;
        additionalNodeNetworkConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (additionalPodNetworkConfigsBuilder_ == null) {
        additionalPodNetworkConfigs_ = java.util.Collections.emptyList();
      } else {
        additionalPodNetworkConfigs_ = null;
        additionalPodNetworkConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      podIpv4RangeUtilization_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NodeNetworkConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeNetworkConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.NodeNetworkConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeNetworkConfig build() {
      com.google.container.v1beta1.NodeNetworkConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NodeNetworkConfig buildPartial() {
      com.google.container.v1beta1.NodeNetworkConfig result =
          new com.google.container.v1beta1.NodeNetworkConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1beta1.NodeNetworkConfig result) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          additionalNodeNetworkConfigs_ =
              java.util.Collections.unmodifiableList(additionalNodeNetworkConfigs_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.additionalNodeNetworkConfigs_ = additionalNodeNetworkConfigs_;
      } else {
        result.additionalNodeNetworkConfigs_ = additionalNodeNetworkConfigsBuilder_.build();
      }
      if (additionalPodNetworkConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          additionalPodNetworkConfigs_ =
              java.util.Collections.unmodifiableList(additionalPodNetworkConfigs_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.additionalPodNetworkConfigs_ = additionalPodNetworkConfigs_;
      } else {
        result.additionalPodNetworkConfigs_ = additionalPodNetworkConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1beta1.NodeNetworkConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createPodRange_ = createPodRange_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.podRange_ = podRange_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.podIpv4CidrBlock_ = podIpv4CidrBlock_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enablePrivateNodes_ = enablePrivateNodes_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.networkPerformanceConfig_ =
            networkPerformanceConfigBuilder_ == null
                ? networkPerformanceConfig_
                : networkPerformanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.podCidrOverprovisionConfig_ =
            podCidrOverprovisionConfigBuilder_ == null
                ? podCidrOverprovisionConfig_
                : podCidrOverprovisionConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.podIpv4RangeUtilization_ = podIpv4RangeUtilization_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.NodeNetworkConfig) {
        return mergeFrom((com.google.container.v1beta1.NodeNetworkConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.NodeNetworkConfig other) {
      if (other == com.google.container.v1beta1.NodeNetworkConfig.getDefaultInstance()) return this;
      if (other.getCreatePodRange() != false) {
        setCreatePodRange(other.getCreatePodRange());
      }
      if (!other.getPodRange().isEmpty()) {
        podRange_ = other.podRange_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getPodIpv4CidrBlock().isEmpty()) {
        podIpv4CidrBlock_ = other.podIpv4CidrBlock_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasEnablePrivateNodes()) {
        setEnablePrivateNodes(other.getEnablePrivateNodes());
      }
      if (other.hasNetworkPerformanceConfig()) {
        mergeNetworkPerformanceConfig(other.getNetworkPerformanceConfig());
      }
      if (other.hasPodCidrOverprovisionConfig()) {
        mergePodCidrOverprovisionConfig(other.getPodCidrOverprovisionConfig());
      }
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        if (!other.additionalNodeNetworkConfigs_.isEmpty()) {
          if (additionalNodeNetworkConfigs_.isEmpty()) {
            additionalNodeNetworkConfigs_ = other.additionalNodeNetworkConfigs_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureAdditionalNodeNetworkConfigsIsMutable();
            additionalNodeNetworkConfigs_.addAll(other.additionalNodeNetworkConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.additionalNodeNetworkConfigs_.isEmpty()) {
          if (additionalNodeNetworkConfigsBuilder_.isEmpty()) {
            additionalNodeNetworkConfigsBuilder_.dispose();
            additionalNodeNetworkConfigsBuilder_ = null;
            additionalNodeNetworkConfigs_ = other.additionalNodeNetworkConfigs_;
            bitField0_ = (bitField0_ & ~0x00000040);
            additionalNodeNetworkConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdditionalNodeNetworkConfigsFieldBuilder()
                    : null;
          } else {
            additionalNodeNetworkConfigsBuilder_.addAllMessages(
                other.additionalNodeNetworkConfigs_);
          }
        }
      }
      if (additionalPodNetworkConfigsBuilder_ == null) {
        if (!other.additionalPodNetworkConfigs_.isEmpty()) {
          if (additionalPodNetworkConfigs_.isEmpty()) {
            additionalPodNetworkConfigs_ = other.additionalPodNetworkConfigs_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureAdditionalPodNetworkConfigsIsMutable();
            additionalPodNetworkConfigs_.addAll(other.additionalPodNetworkConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.additionalPodNetworkConfigs_.isEmpty()) {
          if (additionalPodNetworkConfigsBuilder_.isEmpty()) {
            additionalPodNetworkConfigsBuilder_.dispose();
            additionalPodNetworkConfigsBuilder_ = null;
            additionalPodNetworkConfigs_ = other.additionalPodNetworkConfigs_;
            bitField0_ = (bitField0_ & ~0x00000080);
            additionalPodNetworkConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdditionalPodNetworkConfigsFieldBuilder()
                    : null;
          } else {
            additionalPodNetworkConfigsBuilder_.addAllMessages(other.additionalPodNetworkConfigs_);
          }
        }
      }
      if (other.getPodIpv4RangeUtilization() != 0D) {
        setPodIpv4RangeUtilization(other.getPodIpv4RangeUtilization());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 32:
              {
                createPodRange_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 32
            case 42:
              {
                podRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 42
            case 50:
              {
                podIpv4CidrBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 72:
              {
                enablePrivateNodes_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 72
            case 90:
              {
                input.readMessage(
                    getNetworkPerformanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(
                    getPodCidrOverprovisionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 106
            case 114:
              {
                com.google.container.v1beta1.AdditionalNodeNetworkConfig m =
                    input.readMessage(
                        com.google.container.v1beta1.AdditionalNodeNetworkConfig.parser(),
                        extensionRegistry);
                if (additionalNodeNetworkConfigsBuilder_ == null) {
                  ensureAdditionalNodeNetworkConfigsIsMutable();
                  additionalNodeNetworkConfigs_.add(m);
                } else {
                  additionalNodeNetworkConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                com.google.container.v1beta1.AdditionalPodNetworkConfig m =
                    input.readMessage(
                        com.google.container.v1beta1.AdditionalPodNetworkConfig.parser(),
                        extensionRegistry);
                if (additionalPodNetworkConfigsBuilder_ == null) {
                  ensureAdditionalPodNetworkConfigsIsMutable();
                  additionalPodNetworkConfigs_.add(m);
                } else {
                  additionalPodNetworkConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 129:
              {
                podIpv4RangeUtilization_ = input.readDouble();
                bitField0_ |= 0x00000100;
                break;
              } // case 129
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean createPodRange_;
    /**
     *
     *
     * <pre>
     * Input only. Whether to create a new range for pod IPs in this node pool.
     * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     * are not specified.
     *
     * If neither `create_pod_range` or `pod_range` are specified, the
     * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     * used.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The createPodRange.
     */
    @java.lang.Override
    public boolean getCreatePodRange() {
      return createPodRange_;
    }
    /**
     *
     *
     * <pre>
     * Input only. Whether to create a new range for pod IPs in this node pool.
     * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     * are not specified.
     *
     * If neither `create_pod_range` or `pod_range` are specified, the
     * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     * used.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The createPodRange to set.
     * @return This builder for chaining.
     */
    public Builder setCreatePodRange(boolean value) {

      createPodRange_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Whether to create a new range for pod IPs in this node pool.
     * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     * are not specified.
     *
     * If neither `create_pod_range` or `pod_range` are specified, the
     * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     * used.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreatePodRange() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createPodRange_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object podRange_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_range = 5;</code>
     *
     * @return The podRange.
     */
    public java.lang.String getPodRange() {
      java.lang.Object ref = podRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        podRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_range = 5;</code>
     *
     * @return The bytes for podRange.
     */
    public com.google.protobuf.ByteString getPodRangeBytes() {
      java.lang.Object ref = podRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        podRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_range = 5;</code>
     *
     * @param value The podRange to set.
     * @return This builder for chaining.
     */
    public Builder setPodRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      podRange_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_range = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPodRange() {
      podRange_ = getDefaultInstance().getPodRange();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_range = 5;</code>
     *
     * @param value The bytes for podRange to set.
     * @return This builder for chaining.
     */
    public Builder setPodRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      podRange_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object podIpv4CidrBlock_ = "";
    /**
     *
     *
     * <pre>
     * The IP address range for pod IPs in this node pool.
     *
     * Only applicable if `create_pod_range` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_ipv4_cidr_block = 6;</code>
     *
     * @return The podIpv4CidrBlock.
     */
    public java.lang.String getPodIpv4CidrBlock() {
      java.lang.Object ref = podIpv4CidrBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        podIpv4CidrBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range for pod IPs in this node pool.
     *
     * Only applicable if `create_pod_range` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_ipv4_cidr_block = 6;</code>
     *
     * @return The bytes for podIpv4CidrBlock.
     */
    public com.google.protobuf.ByteString getPodIpv4CidrBlockBytes() {
      java.lang.Object ref = podIpv4CidrBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        podIpv4CidrBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP address range for pod IPs in this node pool.
     *
     * Only applicable if `create_pod_range` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_ipv4_cidr_block = 6;</code>
     *
     * @param value The podIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setPodIpv4CidrBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      podIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range for pod IPs in this node pool.
     *
     * Only applicable if `create_pod_range` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_ipv4_cidr_block = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPodIpv4CidrBlock() {
      podIpv4CidrBlock_ = getDefaultInstance().getPodIpv4CidrBlock();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP address range for pod IPs in this node pool.
     *
     * Only applicable if `create_pod_range` is true.
     *
     * Set to blank to have a range chosen with the default size.
     *
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     *
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     *
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *
     * This field cannot be changed after the node pool has been created.
     * </pre>
     *
     * <code>string pod_ipv4_cidr_block = 6;</code>
     *
     * @param value The bytes for podIpv4CidrBlock to set.
     * @return This builder for chaining.
     */
    public Builder setPodIpv4CidrBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      podIpv4CidrBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean enablePrivateNodes_;
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [cluster.privateClusterConfig.enablePrivateNodes][google.container.v1beta1.PrivateClusterConfig.enablePrivateNodes]
     * </pre>
     *
     * <code>optional bool enable_private_nodes = 9;</code>
     *
     * @return Whether the enablePrivateNodes field is set.
     */
    @java.lang.Override
    public boolean hasEnablePrivateNodes() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [cluster.privateClusterConfig.enablePrivateNodes][google.container.v1beta1.PrivateClusterConfig.enablePrivateNodes]
     * </pre>
     *
     * <code>optional bool enable_private_nodes = 9;</code>
     *
     * @return The enablePrivateNodes.
     */
    @java.lang.Override
    public boolean getEnablePrivateNodes() {
      return enablePrivateNodes_;
    }
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [cluster.privateClusterConfig.enablePrivateNodes][google.container.v1beta1.PrivateClusterConfig.enablePrivateNodes]
     * </pre>
     *
     * <code>optional bool enable_private_nodes = 9;</code>
     *
     * @param value The enablePrivateNodes to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePrivateNodes(boolean value) {

      enablePrivateNodes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [cluster.privateClusterConfig.enablePrivateNodes][google.container.v1beta1.PrivateClusterConfig.enablePrivateNodes]
     * </pre>
     *
     * <code>optional bool enable_private_nodes = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePrivateNodes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enablePrivateNodes_ = false;
      onChanged();
      return this;
    }

    private com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        networkPerformanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig,
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder,
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfigOrBuilder>
        networkPerformanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     *
     * @return Whether the networkPerformanceConfig field is set.
     */
    public boolean hasNetworkPerformanceConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     *
     * @return The networkPerformanceConfig.
     */
    public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
        getNetworkPerformanceConfig() {
      if (networkPerformanceConfigBuilder_ == null) {
        return networkPerformanceConfig_ == null
            ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
                .getDefaultInstance()
            : networkPerformanceConfig_;
      } else {
        return networkPerformanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPerformanceConfig_ = value;
      } else {
        networkPerformanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder
            builderForValue) {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfig_ = builderForValue.build();
      } else {
        networkPerformanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    public Builder mergeNetworkPerformanceConfig(
        com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && networkPerformanceConfig_ != null
            && networkPerformanceConfig_
                != com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
                    .getDefaultInstance()) {
          getNetworkPerformanceConfigBuilder().mergeFrom(value);
        } else {
          networkPerformanceConfig_ = value;
        }
      } else {
        networkPerformanceConfigBuilder_.mergeFrom(value);
      }
      if (networkPerformanceConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    public Builder clearNetworkPerformanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder
        getNetworkPerformanceConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getNetworkPerformanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    public com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfigOrBuilder
        getNetworkPerformanceConfigOrBuilder() {
      if (networkPerformanceConfigBuilder_ != null) {
        return networkPerformanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkPerformanceConfig_ == null
            ? com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig
                .getDefaultInstance()
            : networkPerformanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Network bandwidth tier configuration.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig,
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder,
            com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfigOrBuilder>
        getNetworkPerformanceConfigFieldBuilder() {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig,
                com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfig.Builder,
                com.google.container.v1beta1.NodeNetworkConfig.NetworkPerformanceConfigOrBuilder>(
                getNetworkPerformanceConfig(), getParentForChildren(), isClean());
        networkPerformanceConfig_ = null;
      }
      return networkPerformanceConfigBuilder_;
    }

    private com.google.container.v1beta1.PodCIDROverprovisionConfig podCidrOverprovisionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PodCIDROverprovisionConfig,
            com.google.container.v1beta1.PodCIDROverprovisionConfig.Builder,
            com.google.container.v1beta1.PodCIDROverprovisionConfigOrBuilder>
        podCidrOverprovisionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     *
     * @return Whether the podCidrOverprovisionConfig field is set.
     */
    public boolean hasPodCidrOverprovisionConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     *
     * @return The podCidrOverprovisionConfig.
     */
    public com.google.container.v1beta1.PodCIDROverprovisionConfig getPodCidrOverprovisionConfig() {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        return podCidrOverprovisionConfig_ == null
            ? com.google.container.v1beta1.PodCIDROverprovisionConfig.getDefaultInstance()
            : podCidrOverprovisionConfig_;
      } else {
        return podCidrOverprovisionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    public Builder setPodCidrOverprovisionConfig(
        com.google.container.v1beta1.PodCIDROverprovisionConfig value) {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        podCidrOverprovisionConfig_ = value;
      } else {
        podCidrOverprovisionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    public Builder setPodCidrOverprovisionConfig(
        com.google.container.v1beta1.PodCIDROverprovisionConfig.Builder builderForValue) {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        podCidrOverprovisionConfig_ = builderForValue.build();
      } else {
        podCidrOverprovisionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    public Builder mergePodCidrOverprovisionConfig(
        com.google.container.v1beta1.PodCIDROverprovisionConfig value) {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && podCidrOverprovisionConfig_ != null
            && podCidrOverprovisionConfig_
                != com.google.container.v1beta1.PodCIDROverprovisionConfig.getDefaultInstance()) {
          getPodCidrOverprovisionConfigBuilder().mergeFrom(value);
        } else {
          podCidrOverprovisionConfig_ = value;
        }
      } else {
        podCidrOverprovisionConfigBuilder_.mergeFrom(value);
      }
      if (podCidrOverprovisionConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    public Builder clearPodCidrOverprovisionConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      podCidrOverprovisionConfig_ = null;
      if (podCidrOverprovisionConfigBuilder_ != null) {
        podCidrOverprovisionConfigBuilder_.dispose();
        podCidrOverprovisionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    public com.google.container.v1beta1.PodCIDROverprovisionConfig.Builder
        getPodCidrOverprovisionConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPodCidrOverprovisionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    public com.google.container.v1beta1.PodCIDROverprovisionConfigOrBuilder
        getPodCidrOverprovisionConfigOrBuilder() {
      if (podCidrOverprovisionConfigBuilder_ != null) {
        return podCidrOverprovisionConfigBuilder_.getMessageOrBuilder();
      } else {
        return podCidrOverprovisionConfig_ == null
            ? com.google.container.v1beta1.PodCIDROverprovisionConfig.getDefaultInstance()
            : podCidrOverprovisionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     *
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     * </pre>
     *
     * <code>
     * .google.container.v1beta1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.PodCIDROverprovisionConfig,
            com.google.container.v1beta1.PodCIDROverprovisionConfig.Builder,
            com.google.container.v1beta1.PodCIDROverprovisionConfigOrBuilder>
        getPodCidrOverprovisionConfigFieldBuilder() {
      if (podCidrOverprovisionConfigBuilder_ == null) {
        podCidrOverprovisionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.PodCIDROverprovisionConfig,
                com.google.container.v1beta1.PodCIDROverprovisionConfig.Builder,
                com.google.container.v1beta1.PodCIDROverprovisionConfigOrBuilder>(
                getPodCidrOverprovisionConfig(), getParentForChildren(), isClean());
        podCidrOverprovisionConfig_ = null;
      }
      return podCidrOverprovisionConfigBuilder_;
    }

    private java.util.List<com.google.container.v1beta1.AdditionalNodeNetworkConfig>
        additionalNodeNetworkConfigs_ = java.util.Collections.emptyList();

    private void ensureAdditionalNodeNetworkConfigsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        additionalNodeNetworkConfigs_ =
            new java.util.ArrayList<com.google.container.v1beta1.AdditionalNodeNetworkConfig>(
                additionalNodeNetworkConfigs_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.AdditionalNodeNetworkConfig,
            com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder,
            com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder>
        additionalNodeNetworkConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public java.util.List<com.google.container.v1beta1.AdditionalNodeNetworkConfig>
        getAdditionalNodeNetworkConfigsList() {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(additionalNodeNetworkConfigs_);
      } else {
        return additionalNodeNetworkConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public int getAdditionalNodeNetworkConfigsCount() {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        return additionalNodeNetworkConfigs_.size();
      } else {
        return additionalNodeNetworkConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalNodeNetworkConfig getAdditionalNodeNetworkConfigs(
        int index) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        return additionalNodeNetworkConfigs_.get(index);
      } else {
        return additionalNodeNetworkConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder setAdditionalNodeNetworkConfigs(
        int index, com.google.container.v1beta1.AdditionalNodeNetworkConfig value) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.set(index, value);
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder setAdditionalNodeNetworkConfigs(
        int index,
        com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder builderForValue) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder addAdditionalNodeNetworkConfigs(
        com.google.container.v1beta1.AdditionalNodeNetworkConfig value) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.add(value);
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder addAdditionalNodeNetworkConfigs(
        int index, com.google.container.v1beta1.AdditionalNodeNetworkConfig value) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.add(index, value);
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder addAdditionalNodeNetworkConfigs(
        com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder builderForValue) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder addAdditionalNodeNetworkConfigs(
        int index,
        com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder builderForValue) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder addAllAdditionalNodeNetworkConfigs(
        java.lang.Iterable<? extends com.google.container.v1beta1.AdditionalNodeNetworkConfig>
            values) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        ensureAdditionalNodeNetworkConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, additionalNodeNetworkConfigs_);
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder clearAdditionalNodeNetworkConfigs() {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        additionalNodeNetworkConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public Builder removeAdditionalNodeNetworkConfigs(int index) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        ensureAdditionalNodeNetworkConfigsIsMutable();
        additionalNodeNetworkConfigs_.remove(index);
        onChanged();
      } else {
        additionalNodeNetworkConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder
        getAdditionalNodeNetworkConfigsBuilder(int index) {
      return getAdditionalNodeNetworkConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder
        getAdditionalNodeNetworkConfigsOrBuilder(int index) {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        return additionalNodeNetworkConfigs_.get(index);
      } else {
        return additionalNodeNetworkConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public java.util.List<
            ? extends com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder>
        getAdditionalNodeNetworkConfigsOrBuilderList() {
      if (additionalNodeNetworkConfigsBuilder_ != null) {
        return additionalNodeNetworkConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(additionalNodeNetworkConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder
        addAdditionalNodeNetworkConfigsBuilder() {
      return getAdditionalNodeNetworkConfigsFieldBuilder()
          .addBuilder(
              com.google.container.v1beta1.AdditionalNodeNetworkConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder
        addAdditionalNodeNetworkConfigsBuilder(int index) {
      return getAdditionalNodeNetworkConfigsFieldBuilder()
          .addBuilder(
              index, com.google.container.v1beta1.AdditionalNodeNetworkConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;
     * </code>
     */
    public java.util.List<com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder>
        getAdditionalNodeNetworkConfigsBuilderList() {
      return getAdditionalNodeNetworkConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.AdditionalNodeNetworkConfig,
            com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder,
            com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder>
        getAdditionalNodeNetworkConfigsFieldBuilder() {
      if (additionalNodeNetworkConfigsBuilder_ == null) {
        additionalNodeNetworkConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1beta1.AdditionalNodeNetworkConfig,
                com.google.container.v1beta1.AdditionalNodeNetworkConfig.Builder,
                com.google.container.v1beta1.AdditionalNodeNetworkConfigOrBuilder>(
                additionalNodeNetworkConfigs_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        additionalNodeNetworkConfigs_ = null;
      }
      return additionalNodeNetworkConfigsBuilder_;
    }

    private java.util.List<com.google.container.v1beta1.AdditionalPodNetworkConfig>
        additionalPodNetworkConfigs_ = java.util.Collections.emptyList();

    private void ensureAdditionalPodNetworkConfigsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        additionalPodNetworkConfigs_ =
            new java.util.ArrayList<com.google.container.v1beta1.AdditionalPodNetworkConfig>(
                additionalPodNetworkConfigs_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.AdditionalPodNetworkConfig,
            com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder,
            com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder>
        additionalPodNetworkConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public java.util.List<com.google.container.v1beta1.AdditionalPodNetworkConfig>
        getAdditionalPodNetworkConfigsList() {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(additionalPodNetworkConfigs_);
      } else {
        return additionalPodNetworkConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public int getAdditionalPodNetworkConfigsCount() {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        return additionalPodNetworkConfigs_.size();
      } else {
        return additionalPodNetworkConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodNetworkConfig getAdditionalPodNetworkConfigs(
        int index) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        return additionalPodNetworkConfigs_.get(index);
      } else {
        return additionalPodNetworkConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder setAdditionalPodNetworkConfigs(
        int index, com.google.container.v1beta1.AdditionalPodNetworkConfig value) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.set(index, value);
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder setAdditionalPodNetworkConfigs(
        int index,
        com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder builderForValue) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder addAdditionalPodNetworkConfigs(
        com.google.container.v1beta1.AdditionalPodNetworkConfig value) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.add(value);
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder addAdditionalPodNetworkConfigs(
        int index, com.google.container.v1beta1.AdditionalPodNetworkConfig value) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.add(index, value);
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder addAdditionalPodNetworkConfigs(
        com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder builderForValue) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder addAdditionalPodNetworkConfigs(
        int index,
        com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder builderForValue) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder addAllAdditionalPodNetworkConfigs(
        java.lang.Iterable<? extends com.google.container.v1beta1.AdditionalPodNetworkConfig>
            values) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        ensureAdditionalPodNetworkConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, additionalPodNetworkConfigs_);
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder clearAdditionalPodNetworkConfigs() {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        additionalPodNetworkConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public Builder removeAdditionalPodNetworkConfigs(int index) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        ensureAdditionalPodNetworkConfigsIsMutable();
        additionalPodNetworkConfigs_.remove(index);
        onChanged();
      } else {
        additionalPodNetworkConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder
        getAdditionalPodNetworkConfigsBuilder(int index) {
      return getAdditionalPodNetworkConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder
        getAdditionalPodNetworkConfigsOrBuilder(int index) {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        return additionalPodNetworkConfigs_.get(index);
      } else {
        return additionalPodNetworkConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public java.util.List<
            ? extends com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder>
        getAdditionalPodNetworkConfigsOrBuilderList() {
      if (additionalPodNetworkConfigsBuilder_ != null) {
        return additionalPodNetworkConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(additionalPodNetworkConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder
        addAdditionalPodNetworkConfigsBuilder() {
      return getAdditionalPodNetworkConfigsFieldBuilder()
          .addBuilder(com.google.container.v1beta1.AdditionalPodNetworkConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder
        addAdditionalPodNetworkConfigsBuilder(int index) {
      return getAdditionalPodNetworkConfigsFieldBuilder()
          .addBuilder(
              index, com.google.container.v1beta1.AdditionalPodNetworkConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     * </pre>
     *
     * <code>
     * repeated .google.container.v1beta1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;
     * </code>
     */
    public java.util.List<com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder>
        getAdditionalPodNetworkConfigsBuilderList() {
      return getAdditionalPodNetworkConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.AdditionalPodNetworkConfig,
            com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder,
            com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder>
        getAdditionalPodNetworkConfigsFieldBuilder() {
      if (additionalPodNetworkConfigsBuilder_ == null) {
        additionalPodNetworkConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1beta1.AdditionalPodNetworkConfig,
                com.google.container.v1beta1.AdditionalPodNetworkConfig.Builder,
                com.google.container.v1beta1.AdditionalPodNetworkConfigOrBuilder>(
                additionalPodNetworkConfigs_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        additionalPodNetworkConfigs_ = null;
      }
      return additionalPodNetworkConfigsBuilder_;
    }

    private double podIpv4RangeUtilization_;
    /**
     *
     *
     * <pre>
     * Output only. The utilization of the IPv4 range for the pod.
     * The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     * </pre>
     *
     * <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The podIpv4RangeUtilization.
     */
    @java.lang.Override
    public double getPodIpv4RangeUtilization() {
      return podIpv4RangeUtilization_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The utilization of the IPv4 range for the pod.
     * The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     * </pre>
     *
     * <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The podIpv4RangeUtilization to set.
     * @return This builder for chaining.
     */
    public Builder setPodIpv4RangeUtilization(double value) {

      podIpv4RangeUtilization_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The utilization of the IPv4 range for the pod.
     * The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     * </pre>
     *
     * <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPodIpv4RangeUtilization() {
      bitField0_ = (bitField0_ & ~0x00000100);
      podIpv4RangeUtilization_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NodeNetworkConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.NodeNetworkConfig)
  private static final com.google.container.v1beta1.NodeNetworkConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.NodeNetworkConfig();
  }

  public static com.google.container.v1beta1.NodeNetworkConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NodeNetworkConfig> PARSER =
      new com.google.protobuf.AbstractParser<NodeNetworkConfig>() {
        @java.lang.Override
        public NodeNetworkConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NodeNetworkConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NodeNetworkConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.NodeNetworkConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
