/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * NotificationConfig is the configuration of notifications.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.NotificationConfig}
 */
public final class NotificationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.NotificationConfig)
    NotificationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationConfig.newBuilder() to construct.
  private NotificationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotificationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NotificationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_NotificationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.NotificationConfig.class,
            com.google.container.v1beta1.NotificationConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of notifications currently supported. Can be used to filter what
   * notifications are sent.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1beta1.NotificationConfig.EventType}
   */
  public enum EventType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set, will be ignored.
     * </pre>
     *
     * <code>EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    EVENT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Corresponds with UpgradeAvailableEvent.
     * </pre>
     *
     * <code>UPGRADE_AVAILABLE_EVENT = 1;</code>
     */
    UPGRADE_AVAILABLE_EVENT(1),
    /**
     *
     *
     * <pre>
     * Corresponds with UpgradeEvent.
     * </pre>
     *
     * <code>UPGRADE_EVENT = 2;</code>
     */
    UPGRADE_EVENT(2),
    /**
     *
     *
     * <pre>
     * Corresponds with SecurityBulletinEvent.
     * </pre>
     *
     * <code>SECURITY_BULLETIN_EVENT = 3;</code>
     */
    SECURITY_BULLETIN_EVENT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set, will be ignored.
     * </pre>
     *
     * <code>EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int EVENT_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Corresponds with UpgradeAvailableEvent.
     * </pre>
     *
     * <code>UPGRADE_AVAILABLE_EVENT = 1;</code>
     */
    public static final int UPGRADE_AVAILABLE_EVENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Corresponds with UpgradeEvent.
     * </pre>
     *
     * <code>UPGRADE_EVENT = 2;</code>
     */
    public static final int UPGRADE_EVENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Corresponds with SecurityBulletinEvent.
     * </pre>
     *
     * <code>SECURITY_BULLETIN_EVENT = 3;</code>
     */
    public static final int SECURITY_BULLETIN_EVENT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EventType forNumber(int value) {
      switch (value) {
        case 0:
          return EVENT_TYPE_UNSPECIFIED;
        case 1:
          return UPGRADE_AVAILABLE_EVENT;
        case 2:
          return UPGRADE_EVENT;
        case 3:
          return SECURITY_BULLETIN_EVENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EventType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EventType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EventType>() {
          public EventType findValueByNumber(int number) {
            return EventType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1beta1.NotificationConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final EventType[] VALUES = values();

    public static EventType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1beta1.NotificationConfig.EventType)
  }

  public interface PubSubOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.NotificationConfig.PubSub)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enable notifications for Pub/Sub.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * The desired Pub/Sub topic to which notifications will be
     * sent by GKE. Format is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();
    /**
     *
     *
     * <pre>
     * The desired Pub/Sub topic to which notifications will be
     * sent by GKE. Format is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();

    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If no filter is
     * specified, or if a filter is specified with no event types, all event
     * types will be sent
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
     *
     * @return Whether the filter field is set.
     */
    boolean hasFilter();
    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If no filter is
     * specified, or if a filter is specified with no event types, all event
     * types will be sent
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
     *
     * @return The filter.
     */
    com.google.container.v1beta1.NotificationConfig.Filter getFilter();
    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If no filter is
     * specified, or if a filter is specified with no event types, all event
     * types will be sent
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
     */
    com.google.container.v1beta1.NotificationConfig.FilterOrBuilder getFilterOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub specific notification config.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NotificationConfig.PubSub}
   */
  public static final class PubSub extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.NotificationConfig.PubSub)
      PubSubOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PubSub.newBuilder() to construct.
    private PubSub(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubSub() {
      topic_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubSub();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_PubSub_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_PubSub_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NotificationConfig.PubSub.class,
              com.google.container.v1beta1.NotificationConfig.PubSub.Builder.class);
    }

    private int bitField0_;
    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * Enable notifications for Pub/Sub.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int TOPIC_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * The desired Pub/Sub topic to which notifications will be
     * sent by GKE. Format is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired Pub/Sub topic to which notifications will be
     * sent by GKE. Format is `projects/{project}/topics/{topic}`.
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_FIELD_NUMBER = 3;
    private com.google.container.v1beta1.NotificationConfig.Filter filter_;
    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If no filter is
     * specified, or if a filter is specified with no event types, all event
     * types will be sent
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
     *
     * @return Whether the filter field is set.
     */
    @java.lang.Override
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If no filter is
     * specified, or if a filter is specified with no event types, all event
     * types will be sent
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig.Filter getFilter() {
      return filter_ == null
          ? com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance()
          : filter_;
    }
    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If no filter is
     * specified, or if a filter is specified with no event types, all event
     * types will be sent
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
     */
    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig.FilterOrBuilder getFilterOrBuilder() {
      return filter_ == null
          ? com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance()
          : filter_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, topic_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getFilter());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, topic_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFilter());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1beta1.NotificationConfig.PubSub)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.NotificationConfig.PubSub other =
          (com.google.container.v1beta1.NotificationConfig.PubSub) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getTopic().equals(other.getTopic())) return false;
      if (hasFilter() != other.hasFilter()) return false;
      if (hasFilter()) {
        if (!getFilter().equals(other.getFilter())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      if (hasFilter()) {
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.NotificationConfig.PubSub prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub specific notification config.
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.NotificationConfig.PubSub}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NotificationConfig.PubSub)
        com.google.container.v1beta1.NotificationConfig.PubSubOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NotificationConfig_PubSub_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NotificationConfig_PubSub_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.NotificationConfig.PubSub.class,
                com.google.container.v1beta1.NotificationConfig.PubSub.Builder.class);
      }

      // Construct using com.google.container.v1beta1.NotificationConfig.PubSub.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFilterFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        topic_ = "";
        filter_ = null;
        if (filterBuilder_ != null) {
          filterBuilder_.dispose();
          filterBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NotificationConfig_PubSub_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NotificationConfig.PubSub getDefaultInstanceForType() {
        return com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.NotificationConfig.PubSub build() {
        com.google.container.v1beta1.NotificationConfig.PubSub result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NotificationConfig.PubSub buildPartial() {
        com.google.container.v1beta1.NotificationConfig.PubSub result =
            new com.google.container.v1beta1.NotificationConfig.PubSub(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1beta1.NotificationConfig.PubSub result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.topic_ = topic_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1beta1.NotificationConfig.PubSub) {
          return mergeFrom((com.google.container.v1beta1.NotificationConfig.PubSub) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1beta1.NotificationConfig.PubSub other) {
        if (other == com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance())
          return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasFilter()) {
          mergeFilter(other.getFilter());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  topic_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Enable notifications for Pub/Sub.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Enable notifications for Pub/Sub.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable notifications for Pub/Sub.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object topic_ = "";
      /**
       *
       *
       * <pre>
       * The desired Pub/Sub topic to which notifications will be
       * sent by GKE. Format is `projects/{project}/topics/{topic}`.
       * </pre>
       *
       * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The desired Pub/Sub topic to which notifications will be
       * sent by GKE. Format is `projects/{project}/topics/{topic}`.
       * </pre>
       *
       * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The desired Pub/Sub topic to which notifications will be
       * sent by GKE. Format is `projects/{project}/topics/{topic}`.
       * </pre>
       *
       * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topic_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The desired Pub/Sub topic to which notifications will be
       * sent by GKE. Format is `projects/{project}/topics/{topic}`.
       * </pre>
       *
       * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {
        topic_ = getDefaultInstance().getTopic();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The desired Pub/Sub topic to which notifications will be
       * sent by GKE. Format is `projects/{project}/topics/{topic}`.
       * </pre>
       *
       * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topic_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.container.v1beta1.NotificationConfig.Filter filter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1beta1.NotificationConfig.Filter,
              com.google.container.v1beta1.NotificationConfig.Filter.Builder,
              com.google.container.v1beta1.NotificationConfig.FilterOrBuilder>
          filterBuilder_;
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       *
       * @return Whether the filter field is set.
       */
      public boolean hasFilter() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       *
       * @return The filter.
       */
      public com.google.container.v1beta1.NotificationConfig.Filter getFilter() {
        if (filterBuilder_ == null) {
          return filter_ == null
              ? com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance()
              : filter_;
        } else {
          return filterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      public Builder setFilter(com.google.container.v1beta1.NotificationConfig.Filter value) {
        if (filterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
        } else {
          filterBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      public Builder setFilter(
          com.google.container.v1beta1.NotificationConfig.Filter.Builder builderForValue) {
        if (filterBuilder_ == null) {
          filter_ = builderForValue.build();
        } else {
          filterBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      public Builder mergeFilter(com.google.container.v1beta1.NotificationConfig.Filter value) {
        if (filterBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && filter_ != null
              && filter_
                  != com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance()) {
            getFilterBuilder().mergeFrom(value);
          } else {
            filter_ = value;
          }
        } else {
          filterBuilder_.mergeFrom(value);
        }
        if (filter_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      public Builder clearFilter() {
        bitField0_ = (bitField0_ & ~0x00000004);
        filter_ = null;
        if (filterBuilder_ != null) {
          filterBuilder_.dispose();
          filterBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      public com.google.container.v1beta1.NotificationConfig.Filter.Builder getFilterBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      public com.google.container.v1beta1.NotificationConfig.FilterOrBuilder getFilterOrBuilder() {
        if (filterBuilder_ != null) {
          return filterBuilder_.getMessageOrBuilder();
        } else {
          return filter_ == null
              ? com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance()
              : filter_;
        }
      }
      /**
       *
       *
       * <pre>
       * Allows filtering to one or more specific event types. If no filter is
       * specified, or if a filter is specified with no event types, all event
       * types will be sent
       * </pre>
       *
       * <code>.google.container.v1beta1.NotificationConfig.Filter filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.container.v1beta1.NotificationConfig.Filter,
              com.google.container.v1beta1.NotificationConfig.Filter.Builder,
              com.google.container.v1beta1.NotificationConfig.FilterOrBuilder>
          getFilterFieldBuilder() {
        if (filterBuilder_ == null) {
          filterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.container.v1beta1.NotificationConfig.Filter,
                  com.google.container.v1beta1.NotificationConfig.Filter.Builder,
                  com.google.container.v1beta1.NotificationConfig.FilterOrBuilder>(
                  getFilter(), getParentForChildren(), isClean());
          filter_ = null;
        }
        return filterBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NotificationConfig.PubSub)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.NotificationConfig.PubSub)
    private static final com.google.container.v1beta1.NotificationConfig.PubSub DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1beta1.NotificationConfig.PubSub();
    }

    public static com.google.container.v1beta1.NotificationConfig.PubSub getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubSub> PARSER =
        new com.google.protobuf.AbstractParser<PubSub>() {
          @java.lang.Override
          public PubSub parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubSub> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubSub> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig.PubSub getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.NotificationConfig.Filter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @return A list containing the eventType.
     */
    java.util.List<com.google.container.v1beta1.NotificationConfig.EventType> getEventTypeList();
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @return The count of eventType.
     */
    int getEventTypeCount();
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The eventType at the given index.
     */
    com.google.container.v1beta1.NotificationConfig.EventType getEventType(int index);
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for eventType.
     */
    java.util.List<java.lang.Integer> getEventTypeValueList();
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of eventType at the given index.
     */
    int getEventTypeValue(int index);
  }
  /**
   *
   *
   * <pre>
   * Allows filtering to one or more specific event types. If event types are
   * present, those and only those event types will be transmitted to the
   * cluster. Other types will be skipped. If no filter is specified, or no
   * event types are present, all event types will be sent
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NotificationConfig.Filter}
   */
  public static final class Filter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.NotificationConfig.Filter)
      FilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Filter.newBuilder() to construct.
    private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Filter() {
      eventType_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Filter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NotificationConfig.Filter.class,
              com.google.container.v1beta1.NotificationConfig.Filter.Builder.class);
    }

    public static final int EVENT_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> eventType_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.container.v1beta1.NotificationConfig.EventType>
        eventType_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.container.v1beta1.NotificationConfig.EventType>() {
              public com.google.container.v1beta1.NotificationConfig.EventType convert(
                  java.lang.Integer from) {
                com.google.container.v1beta1.NotificationConfig.EventType result =
                    com.google.container.v1beta1.NotificationConfig.EventType.forNumber(from);
                return result == null
                    ? com.google.container.v1beta1.NotificationConfig.EventType.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @return A list containing the eventType.
     */
    @java.lang.Override
    public java.util.List<com.google.container.v1beta1.NotificationConfig.EventType>
        getEventTypeList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.container.v1beta1.NotificationConfig.EventType>(
          eventType_, eventType_converter_);
    }
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @return The count of eventType.
     */
    @java.lang.Override
    public int getEventTypeCount() {
      return eventType_.size();
    }
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The eventType at the given index.
     */
    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig.EventType getEventType(int index) {
      return eventType_converter_.convert(eventType_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for eventType.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getEventTypeValueList() {
      return eventType_;
    }
    /**
     *
     *
     * <pre>
     * Event types to allowlist.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of eventType at the given index.
     */
    @java.lang.Override
    public int getEventTypeValue(int index) {
      return eventType_.get(index);
    }

    private int eventTypeMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getEventTypeList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(eventTypeMemoizedSerializedSize);
      }
      for (int i = 0; i < eventType_.size(); i++) {
        output.writeEnumNoTag(eventType_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < eventType_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(eventType_.get(i));
        }
        size += dataSize;
        if (!getEventTypeList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        eventTypeMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1beta1.NotificationConfig.Filter)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.NotificationConfig.Filter other =
          (com.google.container.v1beta1.NotificationConfig.Filter) obj;

      if (!eventType_.equals(other.eventType_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEventTypeCount() > 0) {
        hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + eventType_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.NotificationConfig.Filter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Allows filtering to one or more specific event types. If event types are
     * present, those and only those event types will be transmitted to the
     * cluster. Other types will be skipped. If no filter is specified, or no
     * event types are present, all event types will be sent
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.NotificationConfig.Filter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NotificationConfig.Filter)
        com.google.container.v1beta1.NotificationConfig.FilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NotificationConfig_Filter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NotificationConfig_Filter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.NotificationConfig.Filter.class,
                com.google.container.v1beta1.NotificationConfig.Filter.Builder.class);
      }

      // Construct using com.google.container.v1beta1.NotificationConfig.Filter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        eventType_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_NotificationConfig_Filter_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NotificationConfig.Filter getDefaultInstanceForType() {
        return com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.NotificationConfig.Filter build() {
        com.google.container.v1beta1.NotificationConfig.Filter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.NotificationConfig.Filter buildPartial() {
        com.google.container.v1beta1.NotificationConfig.Filter result =
            new com.google.container.v1beta1.NotificationConfig.Filter(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.container.v1beta1.NotificationConfig.Filter result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          eventType_ = java.util.Collections.unmodifiableList(eventType_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.eventType_ = eventType_;
      }

      private void buildPartial0(com.google.container.v1beta1.NotificationConfig.Filter result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1beta1.NotificationConfig.Filter) {
          return mergeFrom((com.google.container.v1beta1.NotificationConfig.Filter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1beta1.NotificationConfig.Filter other) {
        if (other == com.google.container.v1beta1.NotificationConfig.Filter.getDefaultInstance())
          return this;
        if (!other.eventType_.isEmpty()) {
          if (eventType_.isEmpty()) {
            eventType_ = other.eventType_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEventTypeIsMutable();
            eventType_.addAll(other.eventType_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int tmpRaw = input.readEnum();
                  ensureEventTypeIsMutable();
                  eventType_.add(tmpRaw);
                  break;
                } // case 8
              case 10:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureEventTypeIsMutable();
                    eventType_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<java.lang.Integer> eventType_ = java.util.Collections.emptyList();

      private void ensureEventTypeIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          eventType_ = new java.util.ArrayList<java.lang.Integer>(eventType_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @return A list containing the eventType.
       */
      public java.util.List<com.google.container.v1beta1.NotificationConfig.EventType>
          getEventTypeList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.container.v1beta1.NotificationConfig.EventType>(
            eventType_, eventType_converter_);
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @return The count of eventType.
       */
      public int getEventTypeCount() {
        return eventType_.size();
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The eventType at the given index.
       */
      public com.google.container.v1beta1.NotificationConfig.EventType getEventType(int index) {
        return eventType_converter_.convert(eventType_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The eventType to set.
       * @return This builder for chaining.
       */
      public Builder setEventType(
          int index, com.google.container.v1beta1.NotificationConfig.EventType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventTypeIsMutable();
        eventType_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param value The eventType to add.
       * @return This builder for chaining.
       */
      public Builder addEventType(com.google.container.v1beta1.NotificationConfig.EventType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventTypeIsMutable();
        eventType_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param values The eventType to add.
       * @return This builder for chaining.
       */
      public Builder addAllEventType(
          java.lang.Iterable<? extends com.google.container.v1beta1.NotificationConfig.EventType>
              values) {
        ensureEventTypeIsMutable();
        for (com.google.container.v1beta1.NotificationConfig.EventType value : values) {
          eventType_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEventType() {
        eventType_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for eventType.
       */
      public java.util.List<java.lang.Integer> getEventTypeValueList() {
        return java.util.Collections.unmodifiableList(eventType_);
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of eventType at the given index.
       */
      public int getEventTypeValue(int index) {
        return eventType_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for eventType to set.
       * @return This builder for chaining.
       */
      public Builder setEventTypeValue(int index, int value) {
        ensureEventTypeIsMutable();
        eventType_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for eventType to add.
       * @return This builder for chaining.
       */
      public Builder addEventTypeValue(int value) {
        ensureEventTypeIsMutable();
        eventType_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Event types to allowlist.
       * </pre>
       *
       * <code>repeated .google.container.v1beta1.NotificationConfig.EventType event_type = 1;
       * </code>
       *
       * @param values The enum numeric values on the wire for eventType to add.
       * @return This builder for chaining.
       */
      public Builder addAllEventTypeValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureEventTypeIsMutable();
        for (int value : values) {
          eventType_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NotificationConfig.Filter)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.NotificationConfig.Filter)
    private static final com.google.container.v1beta1.NotificationConfig.Filter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1beta1.NotificationConfig.Filter();
    }

    public static com.google.container.v1beta1.NotificationConfig.Filter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Filter> PARSER =
        new com.google.protobuf.AbstractParser<Filter>() {
          @java.lang.Override
          public Filter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Filter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Filter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig.Filter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PUBSUB_FIELD_NUMBER = 1;
  private com.google.container.v1beta1.NotificationConfig.PubSub pubsub_;
  /**
   *
   *
   * <pre>
   * Notification config for Pub/Sub.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
   *
   * @return Whether the pubsub field is set.
   */
  @java.lang.Override
  public boolean hasPubsub() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Notification config for Pub/Sub.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
   *
   * @return The pubsub.
   */
  @java.lang.Override
  public com.google.container.v1beta1.NotificationConfig.PubSub getPubsub() {
    return pubsub_ == null
        ? com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance()
        : pubsub_;
  }
  /**
   *
   *
   * <pre>
   * Notification config for Pub/Sub.
   * </pre>
   *
   * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.NotificationConfig.PubSubOrBuilder getPubsubOrBuilder() {
    return pubsub_ == null
        ? com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance()
        : pubsub_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getPubsub());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPubsub());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.NotificationConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.NotificationConfig other =
        (com.google.container.v1beta1.NotificationConfig) obj;

    if (hasPubsub() != other.hasPubsub()) return false;
    if (hasPubsub()) {
      if (!getPubsub().equals(other.getPubsub())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPubsub()) {
      hash = (37 * hash) + PUBSUB_FIELD_NUMBER;
      hash = (53 * hash) + getPubsub().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NotificationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NotificationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.NotificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.NotificationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * NotificationConfig is the configuration of notifications.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.NotificationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.NotificationConfig)
      com.google.container.v1beta1.NotificationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.NotificationConfig.class,
              com.google.container.v1beta1.NotificationConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.NotificationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPubsubFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      pubsub_ = null;
      if (pubsubBuilder_ != null) {
        pubsubBuilder_.dispose();
        pubsubBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_NotificationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.NotificationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig build() {
      com.google.container.v1beta1.NotificationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.NotificationConfig buildPartial() {
      com.google.container.v1beta1.NotificationConfig result =
          new com.google.container.v1beta1.NotificationConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.NotificationConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.pubsub_ = pubsubBuilder_ == null ? pubsub_ : pubsubBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.NotificationConfig) {
        return mergeFrom((com.google.container.v1beta1.NotificationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.NotificationConfig other) {
      if (other == com.google.container.v1beta1.NotificationConfig.getDefaultInstance())
        return this;
      if (other.hasPubsub()) {
        mergePubsub(other.getPubsub());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPubsubFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.container.v1beta1.NotificationConfig.PubSub pubsub_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NotificationConfig.PubSub,
            com.google.container.v1beta1.NotificationConfig.PubSub.Builder,
            com.google.container.v1beta1.NotificationConfig.PubSubOrBuilder>
        pubsubBuilder_;
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     *
     * @return Whether the pubsub field is set.
     */
    public boolean hasPubsub() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     *
     * @return The pubsub.
     */
    public com.google.container.v1beta1.NotificationConfig.PubSub getPubsub() {
      if (pubsubBuilder_ == null) {
        return pubsub_ == null
            ? com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance()
            : pubsub_;
      } else {
        return pubsubBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    public Builder setPubsub(com.google.container.v1beta1.NotificationConfig.PubSub value) {
      if (pubsubBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pubsub_ = value;
      } else {
        pubsubBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    public Builder setPubsub(
        com.google.container.v1beta1.NotificationConfig.PubSub.Builder builderForValue) {
      if (pubsubBuilder_ == null) {
        pubsub_ = builderForValue.build();
      } else {
        pubsubBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    public Builder mergePubsub(com.google.container.v1beta1.NotificationConfig.PubSub value) {
      if (pubsubBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && pubsub_ != null
            && pubsub_
                != com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance()) {
          getPubsubBuilder().mergeFrom(value);
        } else {
          pubsub_ = value;
        }
      } else {
        pubsubBuilder_.mergeFrom(value);
      }
      if (pubsub_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    public Builder clearPubsub() {
      bitField0_ = (bitField0_ & ~0x00000001);
      pubsub_ = null;
      if (pubsubBuilder_ != null) {
        pubsubBuilder_.dispose();
        pubsubBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    public com.google.container.v1beta1.NotificationConfig.PubSub.Builder getPubsubBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPubsubFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    public com.google.container.v1beta1.NotificationConfig.PubSubOrBuilder getPubsubOrBuilder() {
      if (pubsubBuilder_ != null) {
        return pubsubBuilder_.getMessageOrBuilder();
      } else {
        return pubsub_ == null
            ? com.google.container.v1beta1.NotificationConfig.PubSub.getDefaultInstance()
            : pubsub_;
      }
    }
    /**
     *
     *
     * <pre>
     * Notification config for Pub/Sub.
     * </pre>
     *
     * <code>.google.container.v1beta1.NotificationConfig.PubSub pubsub = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.container.v1beta1.NotificationConfig.PubSub,
            com.google.container.v1beta1.NotificationConfig.PubSub.Builder,
            com.google.container.v1beta1.NotificationConfig.PubSubOrBuilder>
        getPubsubFieldBuilder() {
      if (pubsubBuilder_ == null) {
        pubsubBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.container.v1beta1.NotificationConfig.PubSub,
                com.google.container.v1beta1.NotificationConfig.PubSub.Builder,
                com.google.container.v1beta1.NotificationConfig.PubSubOrBuilder>(
                getPubsub(), getParentForChildren(), isClean());
        pubsub_ = null;
      }
      return pubsubBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.NotificationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.NotificationConfig)
  private static final com.google.container.v1beta1.NotificationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.NotificationConfig();
  }

  public static com.google.container.v1beta1.NotificationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationConfig> PARSER =
      new com.google.protobuf.AbstractParser<NotificationConfig>() {
        @java.lang.Override
        public NotificationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotificationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.NotificationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
