/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * Information about operation (or operation stage) progress.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.OperationProgress}
 */
public final class OperationProgress extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.OperationProgress)
    OperationProgressOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationProgress.newBuilder() to construct.
  private OperationProgress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationProgress() {
    name_ = "";
    status_ = 0;
    metrics_ = java.util.Collections.emptyList();
    stages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationProgress();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_OperationProgress_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_OperationProgress_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.OperationProgress.class,
            com.google.container.v1beta1.OperationProgress.Builder.class);
  }

  public interface MetricOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.container.v1beta1.OperationProgress.Metric)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Metric name, e.g., "nodes total", "percent done".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Metric name, e.g., "nodes total", "percent done".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * For metrics with integer value.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return Whether the intValue field is set.
     */
    boolean hasIntValue();
    /**
     *
     *
     * <pre>
     * For metrics with integer value.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return The intValue.
     */
    long getIntValue();

    /**
     *
     *
     * <pre>
     * For metrics with floating point value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    boolean hasDoubleValue();
    /**
     *
     *
     * <pre>
     * For metrics with floating point value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return The doubleValue.
     */
    double getDoubleValue();

    /**
     *
     *
     * <pre>
     * For metrics with custom values (ratios, visual progress, etc.).
     * </pre>
     *
     * <code>string string_value = 4;</code>
     *
     * @return Whether the stringValue field is set.
     */
    boolean hasStringValue();
    /**
     *
     *
     * <pre>
     * For metrics with custom values (ratios, visual progress, etc.).
     * </pre>
     *
     * <code>string string_value = 4;</code>
     *
     * @return The stringValue.
     */
    java.lang.String getStringValue();
    /**
     *
     *
     * <pre>
     * For metrics with custom values (ratios, visual progress, etc.).
     * </pre>
     *
     * <code>string string_value = 4;</code>
     *
     * @return The bytes for stringValue.
     */
    com.google.protobuf.ByteString getStringValueBytes();

    com.google.container.v1beta1.OperationProgress.Metric.ValueCase getValueCase();
  }
  /**
   *
   *
   * <pre>
   * Progress metric is (string, int|float|string) pair.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.OperationProgress.Metric}
   */
  public static final class Metric extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.container.v1beta1.OperationProgress.Metric)
      MetricOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metric.newBuilder() to construct.
    private Metric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metric() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metric();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_OperationProgress_Metric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_OperationProgress_Metric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.OperationProgress.Metric.class,
              com.google.container.v1beta1.OperationProgress.Metric.Builder.class);
    }

    private int valueCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INT_VALUE(2),
      DOUBLE_VALUE(3),
      STRING_VALUE(4),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 2:
            return INT_VALUE;
          case 3:
            return DOUBLE_VALUE;
          case 4:
            return STRING_VALUE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Metric name, e.g., "nodes total", "percent done".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric name, e.g., "nodes total", "percent done".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INT_VALUE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * For metrics with integer value.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return Whether the intValue field is set.
     */
    @java.lang.Override
    public boolean hasIntValue() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * For metrics with integer value.
     * </pre>
     *
     * <code>int64 int_value = 2;</code>
     *
     * @return The intValue.
     */
    @java.lang.Override
    public long getIntValue() {
      if (valueCase_ == 2) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }

    public static final int DOUBLE_VALUE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * For metrics with floating point value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    @java.lang.Override
    public boolean hasDoubleValue() {
      return valueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * For metrics with floating point value.
     * </pre>
     *
     * <code>double double_value = 3;</code>
     *
     * @return The doubleValue.
     */
    @java.lang.Override
    public double getDoubleValue() {
      if (valueCase_ == 3) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }

    public static final int STRING_VALUE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * For metrics with custom values (ratios, visual progress, etc.).
     * </pre>
     *
     * <code>string string_value = 4;</code>
     *
     * @return Whether the stringValue field is set.
     */
    public boolean hasStringValue() {
      return valueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * For metrics with custom values (ratios, visual progress, etc.).
     * </pre>
     *
     * <code>string string_value = 4;</code>
     *
     * @return The stringValue.
     */
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (valueCase_ == 4) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 4) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * For metrics with custom values (ratios, visual progress, etc.).
     * </pre>
     *
     * <code>string string_value = 4;</code>
     *
     * @return The bytes for stringValue.
     */
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 4) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueCase_ == 4) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (valueCase_ == 2) {
        output.writeInt64(2, (long) ((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        output.writeDouble(3, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 4) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (valueCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                2, (long) ((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                3, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 4) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.container.v1beta1.OperationProgress.Metric)) {
        return super.equals(obj);
      }
      com.google.container.v1beta1.OperationProgress.Metric other =
          (com.google.container.v1beta1.OperationProgress.Metric) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 2:
          if (getIntValue() != other.getIntValue()) return false;
          break;
        case 3:
          if (java.lang.Double.doubleToLongBits(getDoubleValue())
              != java.lang.Double.doubleToLongBits(other.getDoubleValue())) return false;
          break;
        case 4:
          if (!getStringValue().equals(other.getStringValue())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      switch (valueCase_) {
        case 2:
          hash = (37 * hash) + INT_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIntValue());
          break;
        case 3:
          hash = (37 * hash) + DOUBLE_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDoubleValue()));
          break;
        case 4:
          hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getStringValue().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.container.v1beta1.OperationProgress.Metric parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.container.v1beta1.OperationProgress.Metric prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Progress metric is (string, int|float|string) pair.
     * </pre>
     *
     * Protobuf type {@code google.container.v1beta1.OperationProgress.Metric}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.container.v1beta1.OperationProgress.Metric)
        com.google.container.v1beta1.OperationProgress.MetricOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_OperationProgress_Metric_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_OperationProgress_Metric_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.container.v1beta1.OperationProgress.Metric.class,
                com.google.container.v1beta1.OperationProgress.Metric.Builder.class);
      }

      // Construct using com.google.container.v1beta1.OperationProgress.Metric.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.container.v1beta1.ClusterServiceProto
            .internal_static_google_container_v1beta1_OperationProgress_Metric_descriptor;
      }

      @java.lang.Override
      public com.google.container.v1beta1.OperationProgress.Metric getDefaultInstanceForType() {
        return com.google.container.v1beta1.OperationProgress.Metric.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.container.v1beta1.OperationProgress.Metric build() {
        com.google.container.v1beta1.OperationProgress.Metric result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.container.v1beta1.OperationProgress.Metric buildPartial() {
        com.google.container.v1beta1.OperationProgress.Metric result =
            new com.google.container.v1beta1.OperationProgress.Metric(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.container.v1beta1.OperationProgress.Metric result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      private void buildPartialOneofs(
          com.google.container.v1beta1.OperationProgress.Metric result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.container.v1beta1.OperationProgress.Metric) {
          return mergeFrom((com.google.container.v1beta1.OperationProgress.Metric) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.container.v1beta1.OperationProgress.Metric other) {
        if (other == com.google.container.v1beta1.OperationProgress.Metric.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        switch (other.getValueCase()) {
          case INT_VALUE:
            {
              setIntValue(other.getIntValue());
              break;
            }
          case DOUBLE_VALUE:
            {
              setDoubleValue(other.getDoubleValue());
              break;
            }
          case STRING_VALUE:
            {
              valueCase_ = 4;
              value_ = other.value_;
              onChanged();
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  value_ = input.readInt64();
                  valueCase_ = 2;
                  break;
                } // case 16
              case 25:
                {
                  value_ = input.readDouble();
                  valueCase_ = 3;
                  break;
                } // case 25
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  valueCase_ = 4;
                  value_ = s;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Metric name, e.g., "nodes total", "percent done".
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Metric name, e.g., "nodes total", "percent done".
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Metric name, e.g., "nodes total", "percent done".
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Metric name, e.g., "nodes total", "percent done".
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Metric name, e.g., "nodes total", "percent done".
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * For metrics with integer value.
       * </pre>
       *
       * <code>int64 int_value = 2;</code>
       *
       * @return Whether the intValue field is set.
       */
      public boolean hasIntValue() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * For metrics with integer value.
       * </pre>
       *
       * <code>int64 int_value = 2;</code>
       *
       * @return The intValue.
       */
      public long getIntValue() {
        if (valueCase_ == 2) {
          return (java.lang.Long) value_;
        }
        return 0L;
      }
      /**
       *
       *
       * <pre>
       * For metrics with integer value.
       * </pre>
       *
       * <code>int64 int_value = 2;</code>
       *
       * @param value The intValue to set.
       * @return This builder for chaining.
       */
      public Builder setIntValue(long value) {

        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For metrics with integer value.
       * </pre>
       *
       * <code>int64 int_value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIntValue() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * For metrics with floating point value.
       * </pre>
       *
       * <code>double double_value = 3;</code>
       *
       * @return Whether the doubleValue field is set.
       */
      public boolean hasDoubleValue() {
        return valueCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * For metrics with floating point value.
       * </pre>
       *
       * <code>double double_value = 3;</code>
       *
       * @return The doubleValue.
       */
      public double getDoubleValue() {
        if (valueCase_ == 3) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * For metrics with floating point value.
       * </pre>
       *
       * <code>double double_value = 3;</code>
       *
       * @param value The doubleValue to set.
       * @return This builder for chaining.
       */
      public Builder setDoubleValue(double value) {

        valueCase_ = 3;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For metrics with floating point value.
       * </pre>
       *
       * <code>double double_value = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDoubleValue() {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * For metrics with custom values (ratios, visual progress, etc.).
       * </pre>
       *
       * <code>string string_value = 4;</code>
       *
       * @return Whether the stringValue field is set.
       */
      @java.lang.Override
      public boolean hasStringValue() {
        return valueCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * For metrics with custom values (ratios, visual progress, etc.).
       * </pre>
       *
       * <code>string string_value = 4;</code>
       *
       * @return The stringValue.
       */
      @java.lang.Override
      public java.lang.String getStringValue() {
        java.lang.Object ref = "";
        if (valueCase_ == 4) {
          ref = value_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (valueCase_ == 4) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * For metrics with custom values (ratios, visual progress, etc.).
       * </pre>
       *
       * <code>string string_value = 4;</code>
       *
       * @return The bytes for stringValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getStringValueBytes() {
        java.lang.Object ref = "";
        if (valueCase_ == 4) {
          ref = value_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (valueCase_ == 4) {
            value_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * For metrics with custom values (ratios, visual progress, etc.).
       * </pre>
       *
       * <code>string string_value = 4;</code>
       *
       * @param value The stringValue to set.
       * @return This builder for chaining.
       */
      public Builder setStringValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * For metrics with custom values (ratios, visual progress, etc.).
       * </pre>
       *
       * <code>string string_value = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStringValue() {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * For metrics with custom values (ratios, visual progress, etc.).
       * </pre>
       *
       * <code>string string_value = 4;</code>
       *
       * @param value The bytes for stringValue to set.
       * @return This builder for chaining.
       */
      public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.container.v1beta1.OperationProgress.Metric)
    }

    // @@protoc_insertion_point(class_scope:google.container.v1beta1.OperationProgress.Metric)
    private static final com.google.container.v1beta1.OperationProgress.Metric DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.container.v1beta1.OperationProgress.Metric();
    }

    public static com.google.container.v1beta1.OperationProgress.Metric getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metric> PARSER =
        new com.google.protobuf.AbstractParser<Metric>() {
          @java.lang.Override
          public Metric parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metric> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metric> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.container.v1beta1.OperationProgress.Metric getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * A non-parameterized string describing an operation stage.
   * Unset for single-stage operations.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A non-parameterized string describing an operation stage.
   * Unset for single-stage operations.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 2;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Status of an operation stage.
   * Unset for single-stage operations.
   * </pre>
   *
   * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Status of an operation stage.
   * Unset for single-stage operations.
   * </pre>
   *
   * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.container.v1beta1.Operation.Status getStatus() {
    com.google.container.v1beta1.Operation.Status result =
        com.google.container.v1beta1.Operation.Status.forNumber(status_);
    return result == null ? com.google.container.v1beta1.Operation.Status.UNRECOGNIZED : result;
  }

  public static final int METRICS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1beta1.OperationProgress.Metric> metrics_;
  /**
   *
   *
   * <pre>
   * Progress metric bundle, for example:
   *   metrics: [{name: "nodes done",     int_value: 15},
   *             {name: "nodes total",    int_value: 32}]
   * or
   *   metrics: [{name: "progress",       double_value: 0.56},
   *             {name: "progress scale", double_value: 1.0}]
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1beta1.OperationProgress.Metric> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Progress metric bundle, for example:
   *   metrics: [{name: "nodes done",     int_value: 15},
   *             {name: "nodes total",    int_value: 32}]
   * or
   *   metrics: [{name: "progress",       double_value: 0.56},
   *             {name: "progress scale", double_value: 1.0}]
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1beta1.OperationProgress.MetricOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Progress metric bundle, for example:
   *   metrics: [{name: "nodes done",     int_value: 15},
   *             {name: "nodes total",    int_value: 32}]
   * or
   *   metrics: [{name: "progress",       double_value: 0.56},
   *             {name: "progress scale", double_value: 1.0}]
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Progress metric bundle, for example:
   *   metrics: [{name: "nodes done",     int_value: 15},
   *             {name: "nodes total",    int_value: 32}]
   * or
   *   metrics: [{name: "progress",       double_value: 0.56},
   *             {name: "progress scale", double_value: 1.0}]
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.OperationProgress.Metric getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Progress metric bundle, for example:
   *   metrics: [{name: "nodes done",     int_value: 15},
   *             {name: "nodes total",    int_value: 32}]
   * or
   *   metrics: [{name: "progress",       double_value: 0.56},
   *             {name: "progress scale", double_value: 1.0}]
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.OperationProgress.MetricOrBuilder getMetricsOrBuilder(
      int index) {
    return metrics_.get(index);
  }

  public static final int STAGES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.container.v1beta1.OperationProgress> stages_;
  /**
   *
   *
   * <pre>
   * Substages of an operation or a stage.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.container.v1beta1.OperationProgress> getStagesList() {
    return stages_;
  }
  /**
   *
   *
   * <pre>
   * Substages of an operation or a stage.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.container.v1beta1.OperationProgressOrBuilder>
      getStagesOrBuilderList() {
    return stages_;
  }
  /**
   *
   *
   * <pre>
   * Substages of an operation or a stage.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
   */
  @java.lang.Override
  public int getStagesCount() {
    return stages_.size();
  }
  /**
   *
   *
   * <pre>
   * Substages of an operation or a stage.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.OperationProgress getStages(int index) {
    return stages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Substages of an operation or a stage.
   * </pre>
   *
   * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
   */
  @java.lang.Override
  public com.google.container.v1beta1.OperationProgressOrBuilder getStagesOrBuilder(int index) {
    return stages_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (status_ != com.google.container.v1beta1.Operation.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, status_);
    }
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(3, metrics_.get(i));
    }
    for (int i = 0; i < stages_.size(); i++) {
      output.writeMessage(4, stages_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (status_ != com.google.container.v1beta1.Operation.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, status_);
    }
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metrics_.get(i));
    }
    for (int i = 0; i < stages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, stages_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.OperationProgress)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.OperationProgress other =
        (com.google.container.v1beta1.OperationProgress) obj;

    if (!getName().equals(other.getName())) return false;
    if (status_ != other.status_) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getStagesList().equals(other.getStagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (getStagesCount() > 0) {
      hash = (37 * hash) + STAGES_FIELD_NUMBER;
      hash = (53 * hash) + getStagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.OperationProgress parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.OperationProgress parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.OperationProgress parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.OperationProgress prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about operation (or operation stage) progress.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.OperationProgress}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.OperationProgress)
      com.google.container.v1beta1.OperationProgressOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_OperationProgress_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_OperationProgress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.OperationProgress.class,
              com.google.container.v1beta1.OperationProgress.Builder.class);
    }

    // Construct using com.google.container.v1beta1.OperationProgress.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      status_ = 0;
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (stagesBuilder_ == null) {
        stages_ = java.util.Collections.emptyList();
      } else {
        stages_ = null;
        stagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_OperationProgress_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.OperationProgress getDefaultInstanceForType() {
      return com.google.container.v1beta1.OperationProgress.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.OperationProgress build() {
      com.google.container.v1beta1.OperationProgress result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.OperationProgress buildPartial() {
      com.google.container.v1beta1.OperationProgress result =
          new com.google.container.v1beta1.OperationProgress(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.container.v1beta1.OperationProgress result) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (stagesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          stages_ = java.util.Collections.unmodifiableList(stages_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.stages_ = stages_;
      } else {
        result.stages_ = stagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.container.v1beta1.OperationProgress result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.status_ = status_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.OperationProgress) {
        return mergeFrom((com.google.container.v1beta1.OperationProgress) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.OperationProgress other) {
      if (other == com.google.container.v1beta1.OperationProgress.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000004);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (stagesBuilder_ == null) {
        if (!other.stages_.isEmpty()) {
          if (stages_.isEmpty()) {
            stages_ = other.stages_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureStagesIsMutable();
            stages_.addAll(other.stages_);
          }
          onChanged();
        }
      } else {
        if (!other.stages_.isEmpty()) {
          if (stagesBuilder_.isEmpty()) {
            stagesBuilder_.dispose();
            stagesBuilder_ = null;
            stages_ = other.stages_;
            bitField0_ = (bitField0_ & ~0x00000008);
            stagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStagesFieldBuilder()
                    : null;
          } else {
            stagesBuilder_.addAllMessages(other.stages_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.container.v1beta1.OperationProgress.Metric m =
                    input.readMessage(
                        com.google.container.v1beta1.OperationProgress.Metric.parser(),
                        extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.container.v1beta1.OperationProgress m =
                    input.readMessage(
                        com.google.container.v1beta1.OperationProgress.parser(), extensionRegistry);
                if (stagesBuilder_ == null) {
                  ensureStagesIsMutable();
                  stages_.add(m);
                } else {
                  stagesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A non-parameterized string describing an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A non-parameterized string describing an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A non-parameterized string describing an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A non-parameterized string describing an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A non-parameterized string describing an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Status of an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Status of an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.container.v1beta1.Operation.Status getStatus() {
      com.google.container.v1beta1.Operation.Status result =
          com.google.container.v1beta1.Operation.Status.forNumber(status_);
      return result == null ? com.google.container.v1beta1.Operation.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Status of an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.container.v1beta1.Operation.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of an operation stage.
     * Unset for single-stage operations.
     * </pre>
     *
     * <code>.google.container.v1beta1.Operation.Status status = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000002);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.container.v1beta1.OperationProgress.Metric> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.container.v1beta1.OperationProgress.Metric>(
                metrics_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.OperationProgress.Metric,
            com.google.container.v1beta1.OperationProgress.Metric.Builder,
            com.google.container.v1beta1.OperationProgress.MetricOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public java.util.List<com.google.container.v1beta1.OperationProgress.Metric> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Metric getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder setMetrics(
        int index, com.google.container.v1beta1.OperationProgress.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder setMetrics(
        int index, com.google.container.v1beta1.OperationProgress.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder addMetrics(com.google.container.v1beta1.OperationProgress.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder addMetrics(
        int index, com.google.container.v1beta1.OperationProgress.Metric value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder addMetrics(
        com.google.container.v1beta1.OperationProgress.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder addMetrics(
        int index, com.google.container.v1beta1.OperationProgress.Metric.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.container.v1beta1.OperationProgress.Metric>
            values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Metric.Builder getMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public com.google.container.v1beta1.OperationProgress.MetricOrBuilder getMetricsOrBuilder(
        int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public java.util.List<? extends com.google.container.v1beta1.OperationProgress.MetricOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Metric.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.container.v1beta1.OperationProgress.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Metric.Builder addMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder()
          .addBuilder(
              index, com.google.container.v1beta1.OperationProgress.Metric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Progress metric bundle, for example:
     *   metrics: [{name: "nodes done",     int_value: 15},
     *             {name: "nodes total",    int_value: 32}]
     * or
     *   metrics: [{name: "progress",       double_value: 0.56},
     *             {name: "progress scale", double_value: 1.0}]
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress.Metric metrics = 3;</code>
     */
    public java.util.List<com.google.container.v1beta1.OperationProgress.Metric.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.OperationProgress.Metric,
            com.google.container.v1beta1.OperationProgress.Metric.Builder,
            com.google.container.v1beta1.OperationProgress.MetricOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1beta1.OperationProgress.Metric,
                com.google.container.v1beta1.OperationProgress.Metric.Builder,
                com.google.container.v1beta1.OperationProgress.MetricOrBuilder>(
                metrics_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private java.util.List<com.google.container.v1beta1.OperationProgress> stages_ =
        java.util.Collections.emptyList();

    private void ensureStagesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        stages_ = new java.util.ArrayList<com.google.container.v1beta1.OperationProgress>(stages_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.OperationProgress,
            com.google.container.v1beta1.OperationProgress.Builder,
            com.google.container.v1beta1.OperationProgressOrBuilder>
        stagesBuilder_;

    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public java.util.List<com.google.container.v1beta1.OperationProgress> getStagesList() {
      if (stagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stages_);
      } else {
        return stagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public int getStagesCount() {
      if (stagesBuilder_ == null) {
        return stages_.size();
      } else {
        return stagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public com.google.container.v1beta1.OperationProgress getStages(int index) {
      if (stagesBuilder_ == null) {
        return stages_.get(index);
      } else {
        return stagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder setStages(int index, com.google.container.v1beta1.OperationProgress value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.set(index, value);
        onChanged();
      } else {
        stagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder setStages(
        int index, com.google.container.v1beta1.OperationProgress.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.set(index, builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder addStages(com.google.container.v1beta1.OperationProgress value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.add(value);
        onChanged();
      } else {
        stagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder addStages(int index, com.google.container.v1beta1.OperationProgress value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.add(index, value);
        onChanged();
      } else {
        stagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder addStages(
        com.google.container.v1beta1.OperationProgress.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.add(builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder addStages(
        int index, com.google.container.v1beta1.OperationProgress.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.add(index, builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder addAllStages(
        java.lang.Iterable<? extends com.google.container.v1beta1.OperationProgress> values) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stages_);
        onChanged();
      } else {
        stagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder clearStages() {
      if (stagesBuilder_ == null) {
        stages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        stagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public Builder removeStages(int index) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.remove(index);
        onChanged();
      } else {
        stagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Builder getStagesBuilder(int index) {
      return getStagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public com.google.container.v1beta1.OperationProgressOrBuilder getStagesOrBuilder(int index) {
      if (stagesBuilder_ == null) {
        return stages_.get(index);
      } else {
        return stagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public java.util.List<? extends com.google.container.v1beta1.OperationProgressOrBuilder>
        getStagesOrBuilderList() {
      if (stagesBuilder_ != null) {
        return stagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Builder addStagesBuilder() {
      return getStagesFieldBuilder()
          .addBuilder(com.google.container.v1beta1.OperationProgress.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public com.google.container.v1beta1.OperationProgress.Builder addStagesBuilder(int index) {
      return getStagesFieldBuilder()
          .addBuilder(index, com.google.container.v1beta1.OperationProgress.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Substages of an operation or a stage.
     * </pre>
     *
     * <code>repeated .google.container.v1beta1.OperationProgress stages = 4;</code>
     */
    public java.util.List<com.google.container.v1beta1.OperationProgress.Builder>
        getStagesBuilderList() {
      return getStagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.container.v1beta1.OperationProgress,
            com.google.container.v1beta1.OperationProgress.Builder,
            com.google.container.v1beta1.OperationProgressOrBuilder>
        getStagesFieldBuilder() {
      if (stagesBuilder_ == null) {
        stagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.container.v1beta1.OperationProgress,
                com.google.container.v1beta1.OperationProgress.Builder,
                com.google.container.v1beta1.OperationProgressOrBuilder>(
                stages_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        stages_ = null;
      }
      return stagesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.OperationProgress)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.OperationProgress)
  private static final com.google.container.v1beta1.OperationProgress DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.OperationProgress();
  }

  public static com.google.container.v1beta1.OperationProgress getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationProgress> PARSER =
      new com.google.protobuf.AbstractParser<OperationProgress>() {
        @java.lang.Override
        public OperationProgress parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationProgress> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationProgress> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.OperationProgress getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
