/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/container/v1beta1/cluster_service.proto

// Protobuf Java Version: 3.25.5
package com.google.container.v1beta1;

/**
 *
 *
 * <pre>
 * SecurityPostureConfig defines the flags needed to enable/disable features for
 * the Security Posture API.
 * </pre>
 *
 * Protobuf type {@code google.container.v1beta1.SecurityPostureConfig}
 */
public final class SecurityPostureConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.container.v1beta1.SecurityPostureConfig)
    SecurityPostureConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecurityPostureConfig.newBuilder() to construct.
  private SecurityPostureConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPostureConfig() {
    mode_ = 0;
    vulnerabilityMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPostureConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_SecurityPostureConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.container.v1beta1.ClusterServiceProto
        .internal_static_google_container_v1beta1_SecurityPostureConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.container.v1beta1.SecurityPostureConfig.class,
            com.google.container.v1beta1.SecurityPostureConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Mode defines enablement mode for GKE Security posture features.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1beta1.SecurityPostureConfig.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value not specified.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Disables Security Posture features on the cluster.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    DISABLED(1),
    /**
     *
     *
     * <pre>
     * Applies Security Posture features on the cluster.
     * </pre>
     *
     * <code>BASIC = 2;</code>
     */
    BASIC(2),
    /**
     *
     *
     * <pre>
     * Applies the Security Posture off cluster Enterprise level features.
     * </pre>
     *
     * <code>ENTERPRISE = 3;</code>
     */
    ENTERPRISE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value not specified.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Disables Security Posture features on the cluster.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    public static final int DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Applies Security Posture features on the cluster.
     * </pre>
     *
     * <code>BASIC = 2;</code>
     */
    public static final int BASIC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Applies the Security Posture off cluster Enterprise level features.
     * </pre>
     *
     * <code>ENTERPRISE = 3;</code>
     */
    public static final int ENTERPRISE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return DISABLED;
        case 2:
          return BASIC;
        case 3:
          return ENTERPRISE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1beta1.SecurityPostureConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1beta1.SecurityPostureConfig.Mode)
  }

  /**
   *
   *
   * <pre>
   * VulnerabilityMode defines enablement mode for vulnerability scanning.
   * </pre>
   *
   * Protobuf enum {@code google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode}
   */
  public enum VulnerabilityMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value not specified.
     * </pre>
     *
     * <code>VULNERABILITY_MODE_UNSPECIFIED = 0;</code>
     */
    VULNERABILITY_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Disables vulnerability scanning on the cluster.
     * </pre>
     *
     * <code>VULNERABILITY_DISABLED = 1;</code>
     */
    VULNERABILITY_DISABLED(1),
    /**
     *
     *
     * <pre>
     * Applies basic vulnerability scanning on the cluster.
     * </pre>
     *
     * <code>VULNERABILITY_BASIC = 2;</code>
     */
    VULNERABILITY_BASIC(2),
    /**
     *
     *
     * <pre>
     * Applies the Security Posture's vulnerability on cluster Enterprise level
     * features.
     * </pre>
     *
     * <code>VULNERABILITY_ENTERPRISE = 3;</code>
     */
    VULNERABILITY_ENTERPRISE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value not specified.
     * </pre>
     *
     * <code>VULNERABILITY_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int VULNERABILITY_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Disables vulnerability scanning on the cluster.
     * </pre>
     *
     * <code>VULNERABILITY_DISABLED = 1;</code>
     */
    public static final int VULNERABILITY_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Applies basic vulnerability scanning on the cluster.
     * </pre>
     *
     * <code>VULNERABILITY_BASIC = 2;</code>
     */
    public static final int VULNERABILITY_BASIC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Applies the Security Posture's vulnerability on cluster Enterprise level
     * features.
     * </pre>
     *
     * <code>VULNERABILITY_ENTERPRISE = 3;</code>
     */
    public static final int VULNERABILITY_ENTERPRISE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VulnerabilityMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VulnerabilityMode forNumber(int value) {
      switch (value) {
        case 0:
          return VULNERABILITY_MODE_UNSPECIFIED;
        case 1:
          return VULNERABILITY_DISABLED;
        case 2:
          return VULNERABILITY_BASIC;
        case 3:
          return VULNERABILITY_ENTERPRISE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VulnerabilityMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VulnerabilityMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VulnerabilityMode>() {
              public VulnerabilityMode findValueByNumber(int number) {
                return VulnerabilityMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.container.v1beta1.SecurityPostureConfig.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final VulnerabilityMode[] VALUES = values();

    public static VulnerabilityMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VulnerabilityMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode)
  }

  private int bitField0_;
  public static final int MODE_FIELD_NUMBER = 1;
  private int mode_ = 0;
  /**
   *
   *
   * <pre>
   * Sets which mode to use for Security Posture features.
   * </pre>
   *
   * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
   *
   * @return Whether the mode field is set.
   */
  @java.lang.Override
  public boolean hasMode() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Sets which mode to use for Security Posture features.
   * </pre>
   *
   * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override
  public int getModeValue() {
    return mode_;
  }
  /**
   *
   *
   * <pre>
   * Sets which mode to use for Security Posture features.
   * </pre>
   *
   * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public com.google.container.v1beta1.SecurityPostureConfig.Mode getMode() {
    com.google.container.v1beta1.SecurityPostureConfig.Mode result =
        com.google.container.v1beta1.SecurityPostureConfig.Mode.forNumber(mode_);
    return result == null
        ? com.google.container.v1beta1.SecurityPostureConfig.Mode.UNRECOGNIZED
        : result;
  }

  public static final int VULNERABILITY_MODE_FIELD_NUMBER = 2;
  private int vulnerabilityMode_ = 0;
  /**
   *
   *
   * <pre>
   * Sets which mode to use for vulnerability scanning.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
   * </code>
   *
   * @return Whether the vulnerabilityMode field is set.
   */
  @java.lang.Override
  public boolean hasVulnerabilityMode() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Sets which mode to use for vulnerability scanning.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for vulnerabilityMode.
   */
  @java.lang.Override
  public int getVulnerabilityModeValue() {
    return vulnerabilityMode_;
  }
  /**
   *
   *
   * <pre>
   * Sets which mode to use for vulnerability scanning.
   * </pre>
   *
   * <code>
   * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
   * </code>
   *
   * @return The vulnerabilityMode.
   */
  @java.lang.Override
  public com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode
      getVulnerabilityMode() {
    com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode result =
        com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode.forNumber(
            vulnerabilityMode_);
    return result == null
        ? com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(1, mode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeEnum(2, vulnerabilityMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, vulnerabilityMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.container.v1beta1.SecurityPostureConfig)) {
      return super.equals(obj);
    }
    com.google.container.v1beta1.SecurityPostureConfig other =
        (com.google.container.v1beta1.SecurityPostureConfig) obj;

    if (hasMode() != other.hasMode()) return false;
    if (hasMode()) {
      if (mode_ != other.mode_) return false;
    }
    if (hasVulnerabilityMode() != other.hasVulnerabilityMode()) return false;
    if (hasVulnerabilityMode()) {
      if (vulnerabilityMode_ != other.vulnerabilityMode_) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMode()) {
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
    }
    if (hasVulnerabilityMode()) {
      hash = (37 * hash) + VULNERABILITY_MODE_FIELD_NUMBER;
      hash = (53 * hash) + vulnerabilityMode_;
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.container.v1beta1.SecurityPostureConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.container.v1beta1.SecurityPostureConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SecurityPostureConfig defines the flags needed to enable/disable features for
   * the Security Posture API.
   * </pre>
   *
   * Protobuf type {@code google.container.v1beta1.SecurityPostureConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.container.v1beta1.SecurityPostureConfig)
      com.google.container.v1beta1.SecurityPostureConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_SecurityPostureConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_SecurityPostureConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.container.v1beta1.SecurityPostureConfig.class,
              com.google.container.v1beta1.SecurityPostureConfig.Builder.class);
    }

    // Construct using com.google.container.v1beta1.SecurityPostureConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mode_ = 0;
      vulnerabilityMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.container.v1beta1.ClusterServiceProto
          .internal_static_google_container_v1beta1_SecurityPostureConfig_descriptor;
    }

    @java.lang.Override
    public com.google.container.v1beta1.SecurityPostureConfig getDefaultInstanceForType() {
      return com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.container.v1beta1.SecurityPostureConfig build() {
      com.google.container.v1beta1.SecurityPostureConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.container.v1beta1.SecurityPostureConfig buildPartial() {
      com.google.container.v1beta1.SecurityPostureConfig result =
          new com.google.container.v1beta1.SecurityPostureConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.container.v1beta1.SecurityPostureConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mode_ = mode_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.vulnerabilityMode_ = vulnerabilityMode_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.container.v1beta1.SecurityPostureConfig) {
        return mergeFrom((com.google.container.v1beta1.SecurityPostureConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.container.v1beta1.SecurityPostureConfig other) {
      if (other == com.google.container.v1beta1.SecurityPostureConfig.getDefaultInstance())
        return this;
      if (other.hasMode()) {
        setMode(other.getMode());
      }
      if (other.hasVulnerabilityMode()) {
        setVulnerabilityMode(other.getVulnerabilityMode());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                mode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                vulnerabilityMode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Sets which mode to use for Security Posture features.
     * </pre>
     *
     * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
     *
     * @return Whether the mode field is set.
     */
    @java.lang.Override
    public boolean hasMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for Security Posture features.
     * </pre>
     *
     * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for Security Posture features.
     * </pre>
     *
     * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
     *
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {
      mode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for Security Posture features.
     * </pre>
     *
     * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.container.v1beta1.SecurityPostureConfig.Mode getMode() {
      com.google.container.v1beta1.SecurityPostureConfig.Mode result =
          com.google.container.v1beta1.SecurityPostureConfig.Mode.forNumber(mode_);
      return result == null
          ? com.google.container.v1beta1.SecurityPostureConfig.Mode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for Security Posture features.
     * </pre>
     *
     * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.google.container.v1beta1.SecurityPostureConfig.Mode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      mode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for Security Posture features.
     * </pre>
     *
     * <code>optional .google.container.v1beta1.SecurityPostureConfig.Mode mode = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      mode_ = 0;
      onChanged();
      return this;
    }

    private int vulnerabilityMode_ = 0;
    /**
     *
     *
     * <pre>
     * Sets which mode to use for vulnerability scanning.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
     * </code>
     *
     * @return Whether the vulnerabilityMode field is set.
     */
    @java.lang.Override
    public boolean hasVulnerabilityMode() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for vulnerability scanning.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for vulnerabilityMode.
     */
    @java.lang.Override
    public int getVulnerabilityModeValue() {
      return vulnerabilityMode_;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for vulnerability scanning.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for vulnerabilityMode to set.
     * @return This builder for chaining.
     */
    public Builder setVulnerabilityModeValue(int value) {
      vulnerabilityMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for vulnerability scanning.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
     * </code>
     *
     * @return The vulnerabilityMode.
     */
    @java.lang.Override
    public com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode
        getVulnerabilityMode() {
      com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode result =
          com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode.forNumber(
              vulnerabilityMode_);
      return result == null
          ? com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for vulnerability scanning.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
     * </code>
     *
     * @param value The vulnerabilityMode to set.
     * @return This builder for chaining.
     */
    public Builder setVulnerabilityMode(
        com.google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      vulnerabilityMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets which mode to use for vulnerability scanning.
     * </pre>
     *
     * <code>
     * optional .google.container.v1beta1.SecurityPostureConfig.VulnerabilityMode vulnerability_mode = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVulnerabilityMode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      vulnerabilityMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.container.v1beta1.SecurityPostureConfig)
  }

  // @@protoc_insertion_point(class_scope:google.container.v1beta1.SecurityPostureConfig)
  private static final com.google.container.v1beta1.SecurityPostureConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.container.v1beta1.SecurityPostureConfig();
  }

  public static com.google.container.v1beta1.SecurityPostureConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPostureConfig> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPostureConfig>() {
        @java.lang.Override
        public SecurityPostureConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPostureConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPostureConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.container.v1beta1.SecurityPostureConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
