/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datafusion/v1beta1/v1beta1.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datafusion.v1beta1;

/**
 *
 *
 * <pre>
 * Represents a Data Fusion instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datafusion.v1beta1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datafusion.v1beta1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    description_ = "";
    type_ = 0;
    state_ = 0;
    stateMessage_ = "";
    serviceEndpoint_ = "";
    zone_ = "";
    version_ = "";
    serviceAccount_ = "";
    displayName_ = "";
    availableVersion_ = java.util.Collections.emptyList();
    apiEndpoint_ = "";
    gcsBucket_ = "";
    accelerators_ = java.util.Collections.emptyList();
    p4ServiceAccount_ = "";
    tenantProjectId_ = "";
    dataprocServiceAccount_ = "";
    disabledReason_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datafusion.v1beta1.V1Beta1
        .internal_static_google_cloud_datafusion_v1beta1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      case 9:
        return internalGetOptions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datafusion.v1beta1.V1Beta1
        .internal_static_google_cloud_datafusion_v1beta1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datafusion.v1beta1.Instance.class,
            com.google.cloud.datafusion.v1beta1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the type of Data Fusion instance. Each type is configured with
   * the default settings for processing and memory.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datafusion.v1beta1.Instance.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No type specified. The instance creation will fail.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Basic Data Fusion instance. In Basic type, the user will be able to
     * create data pipelines using point and click UI. However, there are
     * certain limitations, such as fewer number of concurrent pipelines, no
     * support for streaming pipelines, etc.
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    BASIC(1),
    /**
     *
     *
     * <pre>
     * Enterprise Data Fusion instance. In Enterprise type, the user will have
     * all features available, such as support for streaming pipelines,
     * unlimited number of concurrent pipelines, etc.
     * </pre>
     *
     * <code>ENTERPRISE = 2;</code>
     */
    ENTERPRISE(2),
    /**
     *
     *
     * <pre>
     * Developer Data Fusion instance. In Developer type, the user will have all
     * features available but with restrictive capabilities. This is to help
     * enterprises design and develop their data ingestion and integration
     * pipelines at low cost.
     * </pre>
     *
     * <code>DEVELOPER = 3;</code>
     */
    DEVELOPER(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No type specified. The instance creation will fail.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Basic Data Fusion instance. In Basic type, the user will be able to
     * create data pipelines using point and click UI. However, there are
     * certain limitations, such as fewer number of concurrent pipelines, no
     * support for streaming pipelines, etc.
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    public static final int BASIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Enterprise Data Fusion instance. In Enterprise type, the user will have
     * all features available, such as support for streaming pipelines,
     * unlimited number of concurrent pipelines, etc.
     * </pre>
     *
     * <code>ENTERPRISE = 2;</code>
     */
    public static final int ENTERPRISE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Developer Data Fusion instance. In Developer type, the user will have all
     * features available but with restrictive capabilities. This is to help
     * enterprises design and develop their data ingestion and integration
     * pipelines at low cost.
     * </pre>
     *
     * <code>DEVELOPER = 3;</code>
     */
    public static final int DEVELOPER_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return BASIC;
        case 2:
          return ENTERPRISE;
        case 3:
          return DEVELOPER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datafusion.v1beta1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datafusion.v1beta1.Instance.Type)
  }

  /**
   *
   *
   * <pre>
   * Represents the state of a Data Fusion instance
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datafusion.v1beta1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Instance does not have a state yet
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Instance is being created
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Instance is running and ready for requests
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * Instance creation failed
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * Instance is being deleted
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * Instance is being upgraded
     * </pre>
     *
     * <code>UPGRADING = 5;</code>
     */
    UPGRADING(5),
    /**
     *
     *
     * <pre>
     * Instance is being restarted
     * </pre>
     *
     * <code>RESTARTING = 6;</code>
     */
    RESTARTING(6),
    /**
     *
     *
     * <pre>
     * Instance is being updated on customer request
     * </pre>
     *
     * <code>UPDATING = 7;</code>
     */
    UPDATING(7),
    /**
     *
     *
     * <pre>
     * Instance is being auto-updated
     * </pre>
     *
     * <code>AUTO_UPDATING = 8;</code>
     */
    AUTO_UPDATING(8),
    /**
     *
     *
     * <pre>
     * Instance is being auto-upgraded
     * </pre>
     *
     * <code>AUTO_UPGRADING = 9;</code>
     */
    AUTO_UPGRADING(9),
    /**
     *
     *
     * <pre>
     * Instance is disabled
     * </pre>
     *
     * <code>DISABLED = 10;</code>
     */
    DISABLED(10),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Instance does not have a state yet
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Instance is being created
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Instance is running and ready for requests
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Instance creation failed
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Instance is being deleted
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Instance is being upgraded
     * </pre>
     *
     * <code>UPGRADING = 5;</code>
     */
    public static final int UPGRADING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Instance is being restarted
     * </pre>
     *
     * <code>RESTARTING = 6;</code>
     */
    public static final int RESTARTING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Instance is being updated on customer request
     * </pre>
     *
     * <code>UPDATING = 7;</code>
     */
    public static final int UPDATING_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Instance is being auto-updated
     * </pre>
     *
     * <code>AUTO_UPDATING = 8;</code>
     */
    public static final int AUTO_UPDATING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Instance is being auto-upgraded
     * </pre>
     *
     * <code>AUTO_UPGRADING = 9;</code>
     */
    public static final int AUTO_UPGRADING_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Instance is disabled
     * </pre>
     *
     * <code>DISABLED = 10;</code>
     */
    public static final int DISABLED_VALUE = 10;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return RUNNING;
        case 3:
          return FAILED;
        case 4:
          return DELETING;
        case 5:
          return UPGRADING;
        case 6:
          return RESTARTING;
        case 7:
          return UPDATING;
        case 8:
          return AUTO_UPDATING;
        case 9:
          return AUTO_UPGRADING;
        case 10:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datafusion.v1beta1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datafusion.v1beta1.Instance.State)
  }

  /**
   *
   *
   * <pre>
   * The reason for disabling the instance if the state is DISABLED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datafusion.v1beta1.Instance.DisabledReason}
   */
  public enum DisabledReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This is an unknown reason for disabling.
     * </pre>
     *
     * <code>DISABLED_REASON_UNSPECIFIED = 0;</code>
     */
    DISABLED_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The KMS key used by the instance is either revoked or denied access to
     * </pre>
     *
     * <code>KMS_KEY_ISSUE = 1;</code>
     */
    KMS_KEY_ISSUE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This is an unknown reason for disabling.
     * </pre>
     *
     * <code>DISABLED_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int DISABLED_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The KMS key used by the instance is either revoked or denied access to
     * </pre>
     *
     * <code>KMS_KEY_ISSUE = 1;</code>
     */
    public static final int KMS_KEY_ISSUE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DisabledReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DisabledReason forNumber(int value) {
      switch (value) {
        case 0:
          return DISABLED_REASON_UNSPECIFIED;
        case 1:
          return KMS_KEY_ISSUE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DisabledReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DisabledReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DisabledReason>() {
          public DisabledReason findValueByNumber(int number) {
            return DisabledReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datafusion.v1beta1.Instance.getDescriptor().getEnumTypes().get(2);
    }

    private static final DisabledReason[] VALUES = values();

    public static DisabledReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DisabledReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datafusion.v1beta1.Instance.DisabledReason)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of this instance is in the form of
   * projects/{project}/locations/{location}/instances/{instance}.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of this instance is in the form of
   * projects/{project}/locations/{location}/instances/{instance}.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A description of this instance.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of this instance.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Instance type.
   * </pre>
   *
   * <code>
   * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Required. Instance type.
   * </pre>
   *
   * <code>
   * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.Instance.Type getType() {
    com.google.cloud.datafusion.v1beta1.Instance.Type result =
        com.google.cloud.datafusion.v1beta1.Instance.Type.forNumber(type_);
    return result == null ? com.google.cloud.datafusion.v1beta1.Instance.Type.UNRECOGNIZED : result;
  }

  public static final int ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER = 4;
  private boolean enableStackdriverLogging_ = false;
  /**
   *
   *
   * <pre>
   * Option to enable Stackdriver Logging.
   * </pre>
   *
   * <code>bool enable_stackdriver_logging = 4;</code>
   *
   * @return The enableStackdriverLogging.
   */
  @java.lang.Override
  public boolean getEnableStackdriverLogging() {
    return enableStackdriverLogging_;
  }

  public static final int ENABLE_STACKDRIVER_MONITORING_FIELD_NUMBER = 5;
  private boolean enableStackdriverMonitoring_ = false;
  /**
   *
   *
   * <pre>
   * Option to enable Stackdriver Monitoring.
   * </pre>
   *
   * <code>bool enable_stackdriver_monitoring = 5;</code>
   *
   * @return The enableStackdriverMonitoring.
   */
  @java.lang.Override
  public boolean getEnableStackdriverMonitoring() {
    return enableStackdriverMonitoring_;
  }

  public static final int PRIVATE_INSTANCE_FIELD_NUMBER = 6;
  private boolean privateInstance_ = false;
  /**
   *
   *
   * <pre>
   * Specifies whether the Data Fusion instance should be private. If set to
   * true, all Data Fusion nodes will have private IP addresses and will not be
   * able to access the public internet.
   * </pre>
   *
   * <code>bool private_instance = 6;</code>
   *
   * @return The privateInstance.
   */
  @java.lang.Override
  public boolean getPrivateInstance() {
    return privateInstance_;
  }

  public static final int NETWORK_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.datafusion.v1beta1.NetworkConfig networkConfig_;
  /**
   *
   *
   * <pre>
   * Network configuration options. These are required when a private Data
   * Fusion instance is to be created.
   * </pre>
   *
   * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
   *
   * @return Whether the networkConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Network configuration options. These are required when a private Data
   * Fusion instance is to be created.
   * </pre>
   *
   * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
   *
   * @return The networkConfig.
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.NetworkConfig getNetworkConfig() {
    return networkConfig_ == null
        ? com.google.cloud.datafusion.v1beta1.NetworkConfig.getDefaultInstance()
        : networkConfig_;
  }
  /**
   *
   *
   * <pre>
   * Network configuration options. These are required when a private Data
   * Fusion instance is to be created.
   * </pre>
   *
   * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.NetworkConfigOrBuilder getNetworkConfigOrBuilder() {
    return networkConfig_ == null
        ? com.google.cloud.datafusion.v1beta1.NetworkConfig.getDefaultInstance()
        : networkConfig_;
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datafusion.v1beta1.V1Beta1
                .internal_static_google_cloud_datafusion_v1beta1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for instance to use to annotate any related underlying
   * resources such as Compute Engine VMs. The character '=' is not allowed to
   * be used within the labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for instance to use to annotate any related underlying
   * resources such as Compute Engine VMs. The character '=' is not allowed to
   * be used within the labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for instance to use to annotate any related underlying
   * resources such as Compute Engine VMs. The character '=' is not allowed to
   * be used within the labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for instance to use to annotate any related underlying
   * resources such as Compute Engine VMs. The character '=' is not allowed to
   * be used within the labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OPTIONS_FIELD_NUMBER = 9;

  private static final class OptionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datafusion.v1beta1.V1Beta1
                .internal_static_google_cloud_datafusion_v1beta1_Instance_OptionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> options_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetOptions() {
    if (options_ == null) {
      return com.google.protobuf.MapField.emptyMapField(OptionsDefaultEntryHolder.defaultEntry);
    }
    return options_;
  }

  public int getOptionsCount() {
    return internalGetOptions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Map of additional options used to configure the behavior of
   * Data Fusion instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; options = 9;</code>
   */
  @java.lang.Override
  public boolean containsOptions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetOptions().getMap().containsKey(key);
  }
  /** Use {@link #getOptionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getOptions() {
    return getOptionsMap();
  }
  /**
   *
   *
   * <pre>
   * Map of additional options used to configure the behavior of
   * Data Fusion instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; options = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getOptionsMap() {
    return internalGetOptions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Map of additional options used to configure the behavior of
   * Data Fusion instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; options = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getOptionsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetOptions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Map of additional options used to configure the behavior of
   * Data Fusion instance.
   * </pre>
   *
   * <code>map&lt;string, string&gt; options = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getOptionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetOptions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 12;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of this Data Fusion instance.
   * </pre>
   *
   * <code>
   * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of this Data Fusion instance.
   * </pre>
   *
   * <code>
   * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.Instance.State getState() {
    com.google.cloud.datafusion.v1beta1.Instance.State result =
        com.google.cloud.datafusion.v1beta1.Instance.State.forNumber(state_);
    return result == null
        ? com.google.cloud.datafusion.v1beta1.Instance.State.UNRECOGNIZED
        : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of this Data
   * Fusion instance if available.
   * </pre>
   *
   * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of this Data
   * Fusion instance if available.
   * </pre>
   *
   * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ENDPOINT_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Endpoint on which the Data Fusion UI is accessible.
   * </pre>
   *
   * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serviceEndpoint.
   */
  @java.lang.Override
  public java.lang.String getServiceEndpoint() {
    java.lang.Object ref = serviceEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Endpoint on which the Data Fusion UI is accessible.
   * </pre>
   *
   * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serviceEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceEndpointBytes() {
    java.lang.Object ref = serviceEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * Name of the zone in which the Data Fusion instance will be created. Only
   * DEVELOPER instances use this field.
   * </pre>
   *
   * <code>string zone = 15;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the zone in which the Data Fusion instance will be created. Only
   * DEVELOPER instances use this field.
   * </pre>
   *
   * <code>string zone = 15;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Current version of Data Fusion.
   * </pre>
   *
   * <code>string version = 16;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Current version of Data Fusion.
   * </pre>
   *
   * <code>string version = 16;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
   * </pre>
   *
   * <code>
   * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
   *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
   * @return The serviceAccount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
   * </pre>
   *
   * <code>
   * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
   *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name for an instance.
   * </pre>
   *
   * <code>string display_name = 18;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name for an instance.
   * </pre>
   *
   * <code>string display_name = 18;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABLE_VERSION_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datafusion.v1beta1.Version> availableVersion_;
  /**
   *
   *
   * <pre>
   * Available versions that the instance can be upgraded to using
   * UpdateInstanceRequest.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datafusion.v1beta1.Version> getAvailableVersionList() {
    return availableVersion_;
  }
  /**
   *
   *
   * <pre>
   * Available versions that the instance can be upgraded to using
   * UpdateInstanceRequest.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datafusion.v1beta1.VersionOrBuilder>
      getAvailableVersionOrBuilderList() {
    return availableVersion_;
  }
  /**
   *
   *
   * <pre>
   * Available versions that the instance can be upgraded to using
   * UpdateInstanceRequest.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
   */
  @java.lang.Override
  public int getAvailableVersionCount() {
    return availableVersion_.size();
  }
  /**
   *
   *
   * <pre>
   * Available versions that the instance can be upgraded to using
   * UpdateInstanceRequest.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.Version getAvailableVersion(int index) {
    return availableVersion_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Available versions that the instance can be upgraded to using
   * UpdateInstanceRequest.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.VersionOrBuilder getAvailableVersionOrBuilder(
      int index) {
    return availableVersion_.get(index);
  }

  public static final int API_ENDPOINT_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object apiEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Endpoint on which the REST APIs is accessible.
   * </pre>
   *
   * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The apiEndpoint.
   */
  @java.lang.Override
  public java.lang.String getApiEndpoint() {
    java.lang.Object ref = apiEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      apiEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Endpoint on which the REST APIs is accessible.
   * </pre>
   *
   * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for apiEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApiEndpointBytes() {
    java.lang.Object ref = apiEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      apiEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_BUCKET_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gcsBucket_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
   * </pre>
   *
   * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The gcsBucket.
   */
  @java.lang.Override
  public java.lang.String getGcsBucket() {
    java.lang.Object ref = gcsBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gcsBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
   * </pre>
   *
   * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for gcsBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGcsBucketBytes() {
    java.lang.Object ref = gcsBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gcsBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCELERATORS_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datafusion.v1beta1.Accelerator> accelerators_;
  /**
   *
   *
   * <pre>
   * List of accelerators enabled for this CDF instance.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datafusion.v1beta1.Accelerator> getAcceleratorsList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * List of accelerators enabled for this CDF instance.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * List of accelerators enabled for this CDF instance.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
   */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * List of accelerators enabled for this CDF instance.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.Accelerator getAccelerators(int index) {
    return accelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of accelerators enabled for this CDF instance.
   * </pre>
   *
   * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder getAcceleratorsOrBuilder(
      int index) {
    return accelerators_.get(index);
  }

  public static final int P4_SERVICE_ACCOUNT_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private volatile java.lang.Object p4ServiceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Output only. P4 service account for the customer project.
   * </pre>
   *
   * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The p4ServiceAccount.
   */
  @java.lang.Override
  public java.lang.String getP4ServiceAccount() {
    java.lang.Object ref = p4ServiceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      p4ServiceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. P4 service account for the customer project.
   * </pre>
   *
   * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for p4ServiceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getP4ServiceAccountBytes() {
    java.lang.Object ref = p4ServiceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      p4ServiceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TENANT_PROJECT_ID_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tenantProjectId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the tenant project.
   * </pre>
   *
   * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tenantProjectId.
   */
  @java.lang.Override
  public java.lang.String getTenantProjectId() {
    java.lang.Object ref = tenantProjectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tenantProjectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the tenant project.
   * </pre>
   *
   * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for tenantProjectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTenantProjectIdBytes() {
    java.lang.Object ref = tenantProjectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tenantProjectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATAPROC_SERVICE_ACCOUNT_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataprocServiceAccount_ = "";
  /**
   *
   *
   * <pre>
   * User-managed service account to set on Dataproc when Cloud Data Fusion
   * creates Dataproc to run data processing pipelines.
   *
   * This allows users to have fine-grained access control on Dataproc's
   * accesses to cloud resources.
   * </pre>
   *
   * <code>string dataproc_service_account = 25;</code>
   *
   * @return The dataprocServiceAccount.
   */
  @java.lang.Override
  public java.lang.String getDataprocServiceAccount() {
    java.lang.Object ref = dataprocServiceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataprocServiceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-managed service account to set on Dataproc when Cloud Data Fusion
   * creates Dataproc to run data processing pipelines.
   *
   * This allows users to have fine-grained access control on Dataproc's
   * accesses to cloud resources.
   * </pre>
   *
   * <code>string dataproc_service_account = 25;</code>
   *
   * @return The bytes for dataprocServiceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataprocServiceAccountBytes() {
    java.lang.Object ref = dataprocServiceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataprocServiceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_RBAC_FIELD_NUMBER = 26;
  private boolean enableRbac_ = false;
  /**
   *
   *
   * <pre>
   * Option to enable granular role-based access control.
   * </pre>
   *
   * <code>bool enable_rbac = 26;</code>
   *
   * @return The enableRbac.
   */
  @java.lang.Override
  public boolean getEnableRbac() {
    return enableRbac_;
  }

  public static final int CRYPTO_KEY_CONFIG_FIELD_NUMBER = 27;
  private com.google.cloud.datafusion.v1beta1.CryptoKeyConfig cryptoKeyConfig_;
  /**
   *
   *
   * <pre>
   * The crypto key configuration. This field is used by the Customer-Managed
   * Encryption Keys (CMEK) feature.
   * </pre>
   *
   * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
   *
   * @return Whether the cryptoKeyConfig field is set.
   */
  @java.lang.Override
  public boolean hasCryptoKeyConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The crypto key configuration. This field is used by the Customer-Managed
   * Encryption Keys (CMEK) feature.
   * </pre>
   *
   * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
   *
   * @return The cryptoKeyConfig.
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.CryptoKeyConfig getCryptoKeyConfig() {
    return cryptoKeyConfig_ == null
        ? com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.getDefaultInstance()
        : cryptoKeyConfig_;
  }
  /**
   *
   *
   * <pre>
   * The crypto key configuration. This field is used by the Customer-Managed
   * Encryption Keys (CMEK) feature.
   * </pre>
   *
   * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.CryptoKeyConfigOrBuilder
      getCryptoKeyConfigOrBuilder() {
    return cryptoKeyConfig_ == null
        ? com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.getDefaultInstance()
        : cryptoKeyConfig_;
  }

  public static final int DISABLED_REASON_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> disabledReason_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>
      disabledReason_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>() {
            public com.google.cloud.datafusion.v1beta1.Instance.DisabledReason convert(
                java.lang.Integer from) {
              com.google.cloud.datafusion.v1beta1.Instance.DisabledReason result =
                  com.google.cloud.datafusion.v1beta1.Instance.DisabledReason.forNumber(from);
              return result == null
                  ? com.google.cloud.datafusion.v1beta1.Instance.DisabledReason.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. If the instance state is DISABLED, the reason for disabling the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the disabledReason.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>
      getDisabledReasonList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>(
        disabledReason_, disabledReason_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. If the instance state is DISABLED, the reason for disabling the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of disabledReason.
   */
  @java.lang.Override
  public int getDisabledReasonCount() {
    return disabledReason_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. If the instance state is DISABLED, the reason for disabling the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The disabledReason at the given index.
   */
  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.Instance.DisabledReason getDisabledReason(int index) {
    return disabledReason_converter_.convert(disabledReason_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. If the instance state is DISABLED, the reason for disabling the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for disabledReason.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getDisabledReasonValueList() {
    return disabledReason_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If the instance state is DISABLED, the reason for disabling the instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of disabledReason at the given index.
   */
  @java.lang.Override
  public int getDisabledReasonValue(int index) {
    return disabledReason_.get(index);
  }

  private int disabledReasonMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (type_ != com.google.cloud.datafusion.v1beta1.Instance.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (enableStackdriverLogging_ != false) {
      output.writeBool(4, enableStackdriverLogging_);
    }
    if (enableStackdriverMonitoring_ != false) {
      output.writeBool(5, enableStackdriverMonitoring_);
    }
    if (privateInstance_ != false) {
      output.writeBool(6, privateInstance_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getNetworkConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetOptions(), OptionsDefaultEntryHolder.defaultEntry, 9);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getUpdateTime());
    }
    if (state_
        != com.google.cloud.datafusion.v1beta1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, serviceEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, displayName_);
    }
    for (int i = 0; i < availableVersion_.size(); i++) {
      output.writeMessage(19, availableVersion_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, apiEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, gcsBucket_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(22, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(p4ServiceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, p4ServiceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenantProjectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, tenantProjectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataprocServiceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, dataprocServiceAccount_);
    }
    if (enableRbac_ != false) {
      output.writeBool(26, enableRbac_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(27, getCryptoKeyConfig());
    }
    if (getDisabledReasonList().size() > 0) {
      output.writeUInt32NoTag(226);
      output.writeUInt32NoTag(disabledReasonMemoizedSerializedSize);
    }
    for (int i = 0; i < disabledReason_.size(); i++) {
      output.writeEnumNoTag(disabledReason_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (type_ != com.google.cloud.datafusion.v1beta1.Instance.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    if (enableStackdriverLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enableStackdriverLogging_);
    }
    if (enableStackdriverMonitoring_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableStackdriverMonitoring_);
    }
    if (privateInstance_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, privateInstance_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNetworkConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetOptions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> options__ =
          OptionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, options__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    if (state_
        != com.google.cloud.datafusion.v1beta1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, stateMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, serviceEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, displayName_);
    }
    for (int i = 0; i < availableVersion_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, availableVersion_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, apiEndpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, gcsBucket_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, accelerators_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(p4ServiceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(23, p4ServiceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenantProjectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, tenantProjectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataprocServiceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, dataprocServiceAccount_);
    }
    if (enableRbac_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(26, enableRbac_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getCryptoKeyConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < disabledReason_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(disabledReason_.get(i));
      }
      size += dataSize;
      if (!getDisabledReasonList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      disabledReasonMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datafusion.v1beta1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.datafusion.v1beta1.Instance other =
        (com.google.cloud.datafusion.v1beta1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (type_ != other.type_) return false;
    if (getEnableStackdriverLogging() != other.getEnableStackdriverLogging()) return false;
    if (getEnableStackdriverMonitoring() != other.getEnableStackdriverMonitoring()) return false;
    if (getPrivateInstance() != other.getPrivateInstance()) return false;
    if (hasNetworkConfig() != other.hasNetworkConfig()) return false;
    if (hasNetworkConfig()) {
      if (!getNetworkConfig().equals(other.getNetworkConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetOptions().equals(other.internalGetOptions())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (!getServiceEndpoint().equals(other.getServiceEndpoint())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getAvailableVersionList().equals(other.getAvailableVersionList())) return false;
    if (!getApiEndpoint().equals(other.getApiEndpoint())) return false;
    if (!getGcsBucket().equals(other.getGcsBucket())) return false;
    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (!getP4ServiceAccount().equals(other.getP4ServiceAccount())) return false;
    if (!getTenantProjectId().equals(other.getTenantProjectId())) return false;
    if (!getDataprocServiceAccount().equals(other.getDataprocServiceAccount())) return false;
    if (getEnableRbac() != other.getEnableRbac()) return false;
    if (hasCryptoKeyConfig() != other.hasCryptoKeyConfig()) return false;
    if (hasCryptoKeyConfig()) {
      if (!getCryptoKeyConfig().equals(other.getCryptoKeyConfig())) return false;
    }
    if (!disabledReason_.equals(other.disabledReason_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverLogging());
    hash = (37 * hash) + ENABLE_STACKDRIVER_MONITORING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverMonitoring());
    hash = (37 * hash) + PRIVATE_INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPrivateInstance());
    if (hasNetworkConfig()) {
      hash = (37 * hash) + NETWORK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetOptions().getMap().isEmpty()) {
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetOptions().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    hash = (37 * hash) + SERVICE_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceEndpoint().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getAvailableVersionCount() > 0) {
      hash = (37 * hash) + AVAILABLE_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableVersionList().hashCode();
    }
    hash = (37 * hash) + API_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getApiEndpoint().hashCode();
    hash = (37 * hash) + GCS_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getGcsBucket().hashCode();
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    hash = (37 * hash) + P4_SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getP4ServiceAccount().hashCode();
    hash = (37 * hash) + TENANT_PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTenantProjectId().hashCode();
    hash = (37 * hash) + DATAPROC_SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getDataprocServiceAccount().hashCode();
    hash = (37 * hash) + ENABLE_RBAC_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableRbac());
    if (hasCryptoKeyConfig()) {
      hash = (37 * hash) + CRYPTO_KEY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCryptoKeyConfig().hashCode();
    }
    if (getDisabledReasonCount() > 0) {
      hash = (37 * hash) + DISABLED_REASON_FIELD_NUMBER;
      hash = (53 * hash) + disabledReason_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datafusion.v1beta1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datafusion.v1beta1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Data Fusion instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datafusion.v1beta1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datafusion.v1beta1.Instance)
      com.google.cloud.datafusion.v1beta1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datafusion.v1beta1.V1Beta1
          .internal_static_google_cloud_datafusion_v1beta1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        case 9:
          return internalGetOptions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        case 9:
          return internalGetMutableOptions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datafusion.v1beta1.V1Beta1
          .internal_static_google_cloud_datafusion_v1beta1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datafusion.v1beta1.Instance.class,
              com.google.cloud.datafusion.v1beta1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.datafusion.v1beta1.Instance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNetworkConfigFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getAvailableVersionFieldBuilder();
        getAcceleratorsFieldBuilder();
        getCryptoKeyConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      type_ = 0;
      enableStackdriverLogging_ = false;
      enableStackdriverMonitoring_ = false;
      privateInstance_ = false;
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      internalGetMutableOptions().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      state_ = 0;
      stateMessage_ = "";
      serviceEndpoint_ = "";
      zone_ = "";
      version_ = "";
      serviceAccount_ = "";
      displayName_ = "";
      if (availableVersionBuilder_ == null) {
        availableVersion_ = java.util.Collections.emptyList();
      } else {
        availableVersion_ = null;
        availableVersionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00040000);
      apiEndpoint_ = "";
      gcsBucket_ = "";
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      p4ServiceAccount_ = "";
      tenantProjectId_ = "";
      dataprocServiceAccount_ = "";
      enableRbac_ = false;
      cryptoKeyConfig_ = null;
      if (cryptoKeyConfigBuilder_ != null) {
        cryptoKeyConfigBuilder_.dispose();
        cryptoKeyConfigBuilder_ = null;
      }
      disabledReason_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x08000000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datafusion.v1beta1.V1Beta1
          .internal_static_google_cloud_datafusion_v1beta1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datafusion.v1beta1.Instance getDefaultInstanceForType() {
      return com.google.cloud.datafusion.v1beta1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datafusion.v1beta1.Instance build() {
      com.google.cloud.datafusion.v1beta1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datafusion.v1beta1.Instance buildPartial() {
      com.google.cloud.datafusion.v1beta1.Instance result =
          new com.google.cloud.datafusion.v1beta1.Instance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datafusion.v1beta1.Instance result) {
      if (availableVersionBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)) {
          availableVersion_ = java.util.Collections.unmodifiableList(availableVersion_);
          bitField0_ = (bitField0_ & ~0x00040000);
        }
        result.availableVersion_ = availableVersion_;
      } else {
        result.availableVersion_ = availableVersionBuilder_.build();
      }
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
      if (((bitField0_ & 0x08000000) != 0)) {
        disabledReason_ = java.util.Collections.unmodifiableList(disabledReason_);
        bitField0_ = (bitField0_ & ~0x08000000);
      }
      result.disabledReason_ = disabledReason_;
    }

    private void buildPartial0(com.google.cloud.datafusion.v1beta1.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enableStackdriverLogging_ = enableStackdriverLogging_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableStackdriverMonitoring_ = enableStackdriverMonitoring_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.privateInstance_ = privateInstance_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.networkConfig_ =
            networkConfigBuilder_ == null ? networkConfig_ : networkConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.options_ = internalGetOptions();
        result.options_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.stateMessage_ = stateMessage_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.serviceEndpoint_ = serviceEndpoint_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.zone_ = zone_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.apiEndpoint_ = apiEndpoint_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.gcsBucket_ = gcsBucket_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.p4ServiceAccount_ = p4ServiceAccount_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.tenantProjectId_ = tenantProjectId_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.dataprocServiceAccount_ = dataprocServiceAccount_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.enableRbac_ = enableRbac_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.cryptoKeyConfig_ =
            cryptoKeyConfigBuilder_ == null ? cryptoKeyConfig_ : cryptoKeyConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datafusion.v1beta1.Instance) {
        return mergeFrom((com.google.cloud.datafusion.v1beta1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datafusion.v1beta1.Instance other) {
      if (other == com.google.cloud.datafusion.v1beta1.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getEnableStackdriverLogging() != false) {
        setEnableStackdriverLogging(other.getEnableStackdriverLogging());
      }
      if (other.getEnableStackdriverMonitoring() != false) {
        setEnableStackdriverMonitoring(other.getEnableStackdriverMonitoring());
      }
      if (other.getPrivateInstance() != false) {
        setPrivateInstance(other.getPrivateInstance());
      }
      if (other.hasNetworkConfig()) {
        mergeNetworkConfig(other.getNetworkConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      internalGetMutableOptions().mergeFrom(other.internalGetOptions());
      bitField0_ |= 0x00000100;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getServiceEndpoint().isEmpty()) {
        serviceEndpoint_ = other.serviceEndpoint_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (availableVersionBuilder_ == null) {
        if (!other.availableVersion_.isEmpty()) {
          if (availableVersion_.isEmpty()) {
            availableVersion_ = other.availableVersion_;
            bitField0_ = (bitField0_ & ~0x00040000);
          } else {
            ensureAvailableVersionIsMutable();
            availableVersion_.addAll(other.availableVersion_);
          }
          onChanged();
        }
      } else {
        if (!other.availableVersion_.isEmpty()) {
          if (availableVersionBuilder_.isEmpty()) {
            availableVersionBuilder_.dispose();
            availableVersionBuilder_ = null;
            availableVersion_ = other.availableVersion_;
            bitField0_ = (bitField0_ & ~0x00040000);
            availableVersionBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAvailableVersionFieldBuilder()
                    : null;
          } else {
            availableVersionBuilder_.addAllMessages(other.availableVersion_);
          }
        }
      }
      if (!other.getApiEndpoint().isEmpty()) {
        apiEndpoint_ = other.apiEndpoint_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (!other.getGcsBucket().isEmpty()) {
        gcsBucket_ = other.gcsBucket_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00200000);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (!other.getP4ServiceAccount().isEmpty()) {
        p4ServiceAccount_ = other.p4ServiceAccount_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (!other.getTenantProjectId().isEmpty()) {
        tenantProjectId_ = other.tenantProjectId_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (!other.getDataprocServiceAccount().isEmpty()) {
        dataprocServiceAccount_ = other.dataprocServiceAccount_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.getEnableRbac() != false) {
        setEnableRbac(other.getEnableRbac());
      }
      if (other.hasCryptoKeyConfig()) {
        mergeCryptoKeyConfig(other.getCryptoKeyConfig());
      }
      if (!other.disabledReason_.isEmpty()) {
        if (disabledReason_.isEmpty()) {
          disabledReason_ = other.disabledReason_;
          bitField0_ = (bitField0_ & ~0x08000000);
        } else {
          ensureDisabledReasonIsMutable();
          disabledReason_.addAll(other.disabledReason_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                enableStackdriverLogging_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                enableStackdriverMonitoring_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                privateInstance_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getNetworkConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> options__ =
                    input.readMessage(
                        OptionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableOptions()
                    .getMutableMap()
                    .put(options__.getKey(), options__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 96:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 106:
              {
                stateMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                serviceEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 146:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 154:
              {
                com.google.cloud.datafusion.v1beta1.Version m =
                    input.readMessage(
                        com.google.cloud.datafusion.v1beta1.Version.parser(), extensionRegistry);
                if (availableVersionBuilder_ == null) {
                  ensureAvailableVersionIsMutable();
                  availableVersion_.add(m);
                } else {
                  availableVersionBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 162:
              {
                apiEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 162
            case 170:
              {
                gcsBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 170
            case 178:
              {
                com.google.cloud.datafusion.v1beta1.Accelerator m =
                    input.readMessage(
                        com.google.cloud.datafusion.v1beta1.Accelerator.parser(),
                        extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case 178
            case 186:
              {
                p4ServiceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 186
            case 194:
              {
                tenantProjectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 194
            case 202:
              {
                dataprocServiceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 202
            case 208:
              {
                enableRbac_ = input.readBool();
                bitField0_ |= 0x02000000;
                break;
              } // case 208
            case 218:
              {
                input.readMessage(getCryptoKeyConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 218
            case 224:
              {
                int tmpRaw = input.readEnum();
                ensureDisabledReasonIsMutable();
                disabledReason_.add(tmpRaw);
                break;
              } // case 224
            case 226:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureDisabledReasonIsMutable();
                  disabledReason_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of this instance is in the form of
     * projects/{project}/locations/{location}/instances/{instance}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this instance is in the form of
     * projects/{project}/locations/{location}/instances/{instance}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this instance is in the form of
     * projects/{project}/locations/{location}/instances/{instance}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this instance is in the form of
     * projects/{project}/locations/{location}/instances/{instance}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this instance is in the form of
     * projects/{project}/locations/{location}/instances/{instance}.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of this instance.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of this instance.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of this instance.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of this instance.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of this instance.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Instance type.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. Instance type.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Instance type.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.datafusion.v1beta1.Instance.Type getType() {
      com.google.cloud.datafusion.v1beta1.Instance.Type result =
          com.google.cloud.datafusion.v1beta1.Instance.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.datafusion.v1beta1.Instance.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Instance type.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.datafusion.v1beta1.Instance.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Instance type.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.Type type = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    private boolean enableStackdriverLogging_;
    /**
     *
     *
     * <pre>
     * Option to enable Stackdriver Logging.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 4;</code>
     *
     * @return The enableStackdriverLogging.
     */
    @java.lang.Override
    public boolean getEnableStackdriverLogging() {
      return enableStackdriverLogging_;
    }
    /**
     *
     *
     * <pre>
     * Option to enable Stackdriver Logging.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 4;</code>
     *
     * @param value The enableStackdriverLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableStackdriverLogging(boolean value) {

      enableStackdriverLogging_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to enable Stackdriver Logging.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableStackdriverLogging() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enableStackdriverLogging_ = false;
      onChanged();
      return this;
    }

    private boolean enableStackdriverMonitoring_;
    /**
     *
     *
     * <pre>
     * Option to enable Stackdriver Monitoring.
     * </pre>
     *
     * <code>bool enable_stackdriver_monitoring = 5;</code>
     *
     * @return The enableStackdriverMonitoring.
     */
    @java.lang.Override
    public boolean getEnableStackdriverMonitoring() {
      return enableStackdriverMonitoring_;
    }
    /**
     *
     *
     * <pre>
     * Option to enable Stackdriver Monitoring.
     * </pre>
     *
     * <code>bool enable_stackdriver_monitoring = 5;</code>
     *
     * @param value The enableStackdriverMonitoring to set.
     * @return This builder for chaining.
     */
    public Builder setEnableStackdriverMonitoring(boolean value) {

      enableStackdriverMonitoring_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to enable Stackdriver Monitoring.
     * </pre>
     *
     * <code>bool enable_stackdriver_monitoring = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableStackdriverMonitoring() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableStackdriverMonitoring_ = false;
      onChanged();
      return this;
    }

    private boolean privateInstance_;
    /**
     *
     *
     * <pre>
     * Specifies whether the Data Fusion instance should be private. If set to
     * true, all Data Fusion nodes will have private IP addresses and will not be
     * able to access the public internet.
     * </pre>
     *
     * <code>bool private_instance = 6;</code>
     *
     * @return The privateInstance.
     */
    @java.lang.Override
    public boolean getPrivateInstance() {
      return privateInstance_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the Data Fusion instance should be private. If set to
     * true, all Data Fusion nodes will have private IP addresses and will not be
     * able to access the public internet.
     * </pre>
     *
     * <code>bool private_instance = 6;</code>
     *
     * @param value The privateInstance to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateInstance(boolean value) {

      privateInstance_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the Data Fusion instance should be private. If set to
     * true, all Data Fusion nodes will have private IP addresses and will not be
     * able to access the public internet.
     * </pre>
     *
     * <code>bool private_instance = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateInstance() {
      bitField0_ = (bitField0_ & ~0x00000020);
      privateInstance_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.datafusion.v1beta1.NetworkConfig networkConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.NetworkConfig,
            com.google.cloud.datafusion.v1beta1.NetworkConfig.Builder,
            com.google.cloud.datafusion.v1beta1.NetworkConfigOrBuilder>
        networkConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     *
     * @return Whether the networkConfig field is set.
     */
    public boolean hasNetworkConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     *
     * @return The networkConfig.
     */
    public com.google.cloud.datafusion.v1beta1.NetworkConfig getNetworkConfig() {
      if (networkConfigBuilder_ == null) {
        return networkConfig_ == null
            ? com.google.cloud.datafusion.v1beta1.NetworkConfig.getDefaultInstance()
            : networkConfig_;
      } else {
        return networkConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    public Builder setNetworkConfig(com.google.cloud.datafusion.v1beta1.NetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkConfig_ = value;
      } else {
        networkConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    public Builder setNetworkConfig(
        com.google.cloud.datafusion.v1beta1.NetworkConfig.Builder builderForValue) {
      if (networkConfigBuilder_ == null) {
        networkConfig_ = builderForValue.build();
      } else {
        networkConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    public Builder mergeNetworkConfig(com.google.cloud.datafusion.v1beta1.NetworkConfig value) {
      if (networkConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && networkConfig_ != null
            && networkConfig_
                != com.google.cloud.datafusion.v1beta1.NetworkConfig.getDefaultInstance()) {
          getNetworkConfigBuilder().mergeFrom(value);
        } else {
          networkConfig_ = value;
        }
      } else {
        networkConfigBuilder_.mergeFrom(value);
      }
      if (networkConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    public Builder clearNetworkConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      networkConfig_ = null;
      if (networkConfigBuilder_ != null) {
        networkConfigBuilder_.dispose();
        networkConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    public com.google.cloud.datafusion.v1beta1.NetworkConfig.Builder getNetworkConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getNetworkConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    public com.google.cloud.datafusion.v1beta1.NetworkConfigOrBuilder getNetworkConfigOrBuilder() {
      if (networkConfigBuilder_ != null) {
        return networkConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkConfig_ == null
            ? com.google.cloud.datafusion.v1beta1.NetworkConfig.getDefaultInstance()
            : networkConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Network configuration options. These are required when a private Data
     * Fusion instance is to be created.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.NetworkConfig network_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.NetworkConfig,
            com.google.cloud.datafusion.v1beta1.NetworkConfig.Builder,
            com.google.cloud.datafusion.v1beta1.NetworkConfigOrBuilder>
        getNetworkConfigFieldBuilder() {
      if (networkConfigBuilder_ == null) {
        networkConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datafusion.v1beta1.NetworkConfig,
                com.google.cloud.datafusion.v1beta1.NetworkConfig.Builder,
                com.google.cloud.datafusion.v1beta1.NetworkConfigOrBuilder>(
                getNetworkConfig(), getParentForChildren(), isClean());
        networkConfig_ = null;
      }
      return networkConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for instance to use to annotate any related underlying
     * resources such as Compute Engine VMs. The character '=' is not allowed to
     * be used within the labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> options_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetOptions() {
      if (options_ == null) {
        return com.google.protobuf.MapField.emptyMapField(OptionsDefaultEntryHolder.defaultEntry);
      }
      return options_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableOptions() {
      if (options_ == null) {
        options_ = com.google.protobuf.MapField.newMapField(OptionsDefaultEntryHolder.defaultEntry);
      }
      if (!options_.isMutable()) {
        options_ = options_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return options_;
    }

    public int getOptionsCount() {
      return internalGetOptions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    @java.lang.Override
    public boolean containsOptions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetOptions().getMap().containsKey(key);
    }
    /** Use {@link #getOptionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getOptions() {
      return getOptionsMap();
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getOptionsMap() {
      return internalGetOptions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getOptionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetOptions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getOptionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetOptions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearOptions() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableOptions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    public Builder removeOptions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableOptions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableOptions() {
      bitField0_ |= 0x00000100;
      return internalGetMutableOptions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    public Builder putOptions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableOptions().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map of additional options used to configure the behavior of
     * Data Fusion instance.
     * </pre>
     *
     * <code>map&lt;string, string&gt; options = 9;</code>
     */
    public Builder putAllOptions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableOptions().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of this Data Fusion instance.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this Data Fusion instance.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this Data Fusion instance.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.datafusion.v1beta1.Instance.State getState() {
      com.google.cloud.datafusion.v1beta1.Instance.State result =
          com.google.cloud.datafusion.v1beta1.Instance.State.forNumber(state_);
      return result == null
          ? com.google.cloud.datafusion.v1beta1.Instance.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this Data Fusion instance.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.datafusion.v1beta1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this Data Fusion instance.
     * </pre>
     *
     * <code>
     * .google.cloud.datafusion.v1beta1.Instance.State state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000800);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of this Data
     * Fusion instance if available.
     * </pre>
     *
     * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of this Data
     * Fusion instance if available.
     * </pre>
     *
     * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of this Data
     * Fusion instance if available.
     * </pre>
     *
     * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateMessage_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of this Data
     * Fusion instance if available.
     * </pre>
     *
     * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {
      stateMessage_ = getDefaultInstance().getStateMessage();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of this Data
     * Fusion instance if available.
     * </pre>
     *
     * <code>string state_message = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateMessage_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object serviceEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the Data Fusion UI is accessible.
     * </pre>
     *
     * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceEndpoint.
     */
    public java.lang.String getServiceEndpoint() {
      java.lang.Object ref = serviceEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the Data Fusion UI is accessible.
     * </pre>
     *
     * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceEndpoint.
     */
    public com.google.protobuf.ByteString getServiceEndpointBytes() {
      java.lang.Object ref = serviceEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the Data Fusion UI is accessible.
     * </pre>
     *
     * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serviceEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setServiceEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceEndpoint_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the Data Fusion UI is accessible.
     * </pre>
     *
     * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceEndpoint() {
      serviceEndpoint_ = getDefaultInstance().getServiceEndpoint();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the Data Fusion UI is accessible.
     * </pre>
     *
     * <code>string service_endpoint = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serviceEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setServiceEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceEndpoint_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Name of the zone in which the Data Fusion instance will be created. Only
     * DEVELOPER instances use this field.
     * </pre>
     *
     * <code>string zone = 15;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the zone in which the Data Fusion instance will be created. Only
     * DEVELOPER instances use this field.
     * </pre>
     *
     * <code>string zone = 15;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the zone in which the Data Fusion instance will be created. Only
     * DEVELOPER instances use this field.
     * </pre>
     *
     * <code>string zone = 15;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the zone in which the Data Fusion instance will be created. Only
     * DEVELOPER instances use this field.
     * </pre>
     *
     * <code>string zone = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the zone in which the Data Fusion instance will be created. Only
     * DEVELOPER instances use this field.
     * </pre>
     *
     * <code>string zone = 15;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Current version of Data Fusion.
     * </pre>
     *
     * <code>string version = 16;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Current version of Data Fusion.
     * </pre>
     *
     * <code>string version = 16;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Current version of Data Fusion.
     * </pre>
     *
     * <code>string version = 16;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current version of Data Fusion.
     * </pre>
     *
     * <code>string version = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Current version of Data Fusion.
     * </pre>
     *
     * <code>string version = 16;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
     * </pre>
     *
     * <code>
     * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
     *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
     * @return The serviceAccount.
     */
    @java.lang.Deprecated
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
     * </pre>
     *
     * <code>
     * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
     *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
     * @return The bytes for serviceAccount.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
     * </pre>
     *
     * <code>
     * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
     *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
     * </pre>
     *
     * <code>
     * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
     *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Deprecated. Use tenant_project_id instead to extract the tenant project ID.
     * </pre>
     *
     * <code>
     * string service_account = 17 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.datafusion.v1beta1.Instance.service_account is deprecated. See
     *     google/cloud/datafusion/v1beta1/v1beta1.proto;l=392
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name for an instance.
     * </pre>
     *
     * <code>string display_name = 18;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name for an instance.
     * </pre>
     *
     * <code>string display_name = 18;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name for an instance.
     * </pre>
     *
     * <code>string display_name = 18;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name for an instance.
     * </pre>
     *
     * <code>string display_name = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name for an instance.
     * </pre>
     *
     * <code>string display_name = 18;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datafusion.v1beta1.Version> availableVersion_ =
        java.util.Collections.emptyList();

    private void ensureAvailableVersionIsMutable() {
      if (!((bitField0_ & 0x00040000) != 0)) {
        availableVersion_ =
            new java.util.ArrayList<com.google.cloud.datafusion.v1beta1.Version>(availableVersion_);
        bitField0_ |= 0x00040000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.Version,
            com.google.cloud.datafusion.v1beta1.Version.Builder,
            com.google.cloud.datafusion.v1beta1.VersionOrBuilder>
        availableVersionBuilder_;

    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public java.util.List<com.google.cloud.datafusion.v1beta1.Version> getAvailableVersionList() {
      if (availableVersionBuilder_ == null) {
        return java.util.Collections.unmodifiableList(availableVersion_);
      } else {
        return availableVersionBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public int getAvailableVersionCount() {
      if (availableVersionBuilder_ == null) {
        return availableVersion_.size();
      } else {
        return availableVersionBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Version getAvailableVersion(int index) {
      if (availableVersionBuilder_ == null) {
        return availableVersion_.get(index);
      } else {
        return availableVersionBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder setAvailableVersion(
        int index, com.google.cloud.datafusion.v1beta1.Version value) {
      if (availableVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableVersionIsMutable();
        availableVersion_.set(index, value);
        onChanged();
      } else {
        availableVersionBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder setAvailableVersion(
        int index, com.google.cloud.datafusion.v1beta1.Version.Builder builderForValue) {
      if (availableVersionBuilder_ == null) {
        ensureAvailableVersionIsMutable();
        availableVersion_.set(index, builderForValue.build());
        onChanged();
      } else {
        availableVersionBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder addAvailableVersion(com.google.cloud.datafusion.v1beta1.Version value) {
      if (availableVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableVersionIsMutable();
        availableVersion_.add(value);
        onChanged();
      } else {
        availableVersionBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder addAvailableVersion(
        int index, com.google.cloud.datafusion.v1beta1.Version value) {
      if (availableVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableVersionIsMutable();
        availableVersion_.add(index, value);
        onChanged();
      } else {
        availableVersionBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder addAvailableVersion(
        com.google.cloud.datafusion.v1beta1.Version.Builder builderForValue) {
      if (availableVersionBuilder_ == null) {
        ensureAvailableVersionIsMutable();
        availableVersion_.add(builderForValue.build());
        onChanged();
      } else {
        availableVersionBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder addAvailableVersion(
        int index, com.google.cloud.datafusion.v1beta1.Version.Builder builderForValue) {
      if (availableVersionBuilder_ == null) {
        ensureAvailableVersionIsMutable();
        availableVersion_.add(index, builderForValue.build());
        onChanged();
      } else {
        availableVersionBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder addAllAvailableVersion(
        java.lang.Iterable<? extends com.google.cloud.datafusion.v1beta1.Version> values) {
      if (availableVersionBuilder_ == null) {
        ensureAvailableVersionIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableVersion_);
        onChanged();
      } else {
        availableVersionBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder clearAvailableVersion() {
      if (availableVersionBuilder_ == null) {
        availableVersion_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00040000);
        onChanged();
      } else {
        availableVersionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public Builder removeAvailableVersion(int index) {
      if (availableVersionBuilder_ == null) {
        ensureAvailableVersionIsMutable();
        availableVersion_.remove(index);
        onChanged();
      } else {
        availableVersionBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Version.Builder getAvailableVersionBuilder(
        int index) {
      return getAvailableVersionFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public com.google.cloud.datafusion.v1beta1.VersionOrBuilder getAvailableVersionOrBuilder(
        int index) {
      if (availableVersionBuilder_ == null) {
        return availableVersion_.get(index);
      } else {
        return availableVersionBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public java.util.List<? extends com.google.cloud.datafusion.v1beta1.VersionOrBuilder>
        getAvailableVersionOrBuilderList() {
      if (availableVersionBuilder_ != null) {
        return availableVersionBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(availableVersion_);
      }
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Version.Builder addAvailableVersionBuilder() {
      return getAvailableVersionFieldBuilder()
          .addBuilder(com.google.cloud.datafusion.v1beta1.Version.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Version.Builder addAvailableVersionBuilder(
        int index) {
      return getAvailableVersionFieldBuilder()
          .addBuilder(index, com.google.cloud.datafusion.v1beta1.Version.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Available versions that the instance can be upgraded to using
     * UpdateInstanceRequest.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Version available_version = 19;</code>
     */
    public java.util.List<com.google.cloud.datafusion.v1beta1.Version.Builder>
        getAvailableVersionBuilderList() {
      return getAvailableVersionFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.Version,
            com.google.cloud.datafusion.v1beta1.Version.Builder,
            com.google.cloud.datafusion.v1beta1.VersionOrBuilder>
        getAvailableVersionFieldBuilder() {
      if (availableVersionBuilder_ == null) {
        availableVersionBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datafusion.v1beta1.Version,
                com.google.cloud.datafusion.v1beta1.Version.Builder,
                com.google.cloud.datafusion.v1beta1.VersionOrBuilder>(
                availableVersion_,
                ((bitField0_ & 0x00040000) != 0),
                getParentForChildren(),
                isClean());
        availableVersion_ = null;
      }
      return availableVersionBuilder_;
    }

    private java.lang.Object apiEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the REST APIs is accessible.
     * </pre>
     *
     * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The apiEndpoint.
     */
    public java.lang.String getApiEndpoint() {
      java.lang.Object ref = apiEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        apiEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the REST APIs is accessible.
     * </pre>
     *
     * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for apiEndpoint.
     */
    public com.google.protobuf.ByteString getApiEndpointBytes() {
      java.lang.Object ref = apiEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        apiEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the REST APIs is accessible.
     * </pre>
     *
     * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The apiEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setApiEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      apiEndpoint_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the REST APIs is accessible.
     * </pre>
     *
     * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiEndpoint() {
      apiEndpoint_ = getDefaultInstance().getApiEndpoint();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint on which the REST APIs is accessible.
     * </pre>
     *
     * <code>string api_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for apiEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setApiEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      apiEndpoint_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private java.lang.Object gcsBucket_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
     * </pre>
     *
     * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gcsBucket.
     */
    public java.lang.String getGcsBucket() {
      java.lang.Object ref = gcsBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
     * </pre>
     *
     * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gcsBucket.
     */
    public com.google.protobuf.ByteString getGcsBucketBytes() {
      java.lang.Object ref = gcsBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
     * </pre>
     *
     * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The gcsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setGcsBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gcsBucket_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
     * </pre>
     *
     * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcsBucket() {
      gcsBucket_ = getDefaultInstance().getGcsBucket();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Cloud Storage bucket generated by Data Fusion in the customer project.
     * </pre>
     *
     * <code>string gcs_bucket = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for gcsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setGcsBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gcsBucket_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datafusion.v1beta1.Accelerator> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.cloud.datafusion.v1beta1.Accelerator>(accelerators_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.Accelerator,
            com.google.cloud.datafusion.v1beta1.Accelerator.Builder,
            com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder>
        acceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public java.util.List<com.google.cloud.datafusion.v1beta1.Accelerator> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Accelerator getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.datafusion.v1beta1.Accelerator value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.datafusion.v1beta1.Accelerator.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder addAccelerators(com.google.cloud.datafusion.v1beta1.Accelerator value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.datafusion.v1beta1.Accelerator value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder addAccelerators(
        com.google.cloud.datafusion.v1beta1.Accelerator.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.datafusion.v1beta1.Accelerator.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.cloud.datafusion.v1beta1.Accelerator> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Accelerator.Builder getAcceleratorsBuilder(
        int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder getAcceleratorsOrBuilder(
        int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public java.util.List<? extends com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Accelerator.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.datafusion.v1beta1.Accelerator.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public com.google.cloud.datafusion.v1beta1.Accelerator.Builder addAcceleratorsBuilder(
        int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.datafusion.v1beta1.Accelerator.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of accelerators enabled for this CDF instance.
     * </pre>
     *
     * <code>repeated .google.cloud.datafusion.v1beta1.Accelerator accelerators = 22;</code>
     */
    public java.util.List<com.google.cloud.datafusion.v1beta1.Accelerator.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.Accelerator,
            com.google.cloud.datafusion.v1beta1.Accelerator.Builder,
            com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datafusion.v1beta1.Accelerator,
                com.google.cloud.datafusion.v1beta1.Accelerator.Builder,
                com.google.cloud.datafusion.v1beta1.AcceleratorOrBuilder>(
                accelerators_, ((bitField0_ & 0x00200000) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private java.lang.Object p4ServiceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Output only. P4 service account for the customer project.
     * </pre>
     *
     * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The p4ServiceAccount.
     */
    public java.lang.String getP4ServiceAccount() {
      java.lang.Object ref = p4ServiceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        p4ServiceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. P4 service account for the customer project.
     * </pre>
     *
     * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for p4ServiceAccount.
     */
    public com.google.protobuf.ByteString getP4ServiceAccountBytes() {
      java.lang.Object ref = p4ServiceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        p4ServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. P4 service account for the customer project.
     * </pre>
     *
     * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The p4ServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setP4ServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      p4ServiceAccount_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. P4 service account for the customer project.
     * </pre>
     *
     * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearP4ServiceAccount() {
      p4ServiceAccount_ = getDefaultInstance().getP4ServiceAccount();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. P4 service account for the customer project.
     * </pre>
     *
     * <code>string p4_service_account = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for p4ServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setP4ServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      p4ServiceAccount_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object tenantProjectId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the tenant project.
     * </pre>
     *
     * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tenantProjectId.
     */
    public java.lang.String getTenantProjectId() {
      java.lang.Object ref = tenantProjectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tenantProjectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the tenant project.
     * </pre>
     *
     * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for tenantProjectId.
     */
    public com.google.protobuf.ByteString getTenantProjectIdBytes() {
      java.lang.Object ref = tenantProjectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tenantProjectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the tenant project.
     * </pre>
     *
     * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tenantProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setTenantProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tenantProjectId_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the tenant project.
     * </pre>
     *
     * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTenantProjectId() {
      tenantProjectId_ = getDefaultInstance().getTenantProjectId();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the tenant project.
     * </pre>
     *
     * <code>string tenant_project_id = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for tenantProjectId to set.
     * @return This builder for chaining.
     */
    public Builder setTenantProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tenantProjectId_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object dataprocServiceAccount_ = "";
    /**
     *
     *
     * <pre>
     * User-managed service account to set on Dataproc when Cloud Data Fusion
     * creates Dataproc to run data processing pipelines.
     *
     * This allows users to have fine-grained access control on Dataproc's
     * accesses to cloud resources.
     * </pre>
     *
     * <code>string dataproc_service_account = 25;</code>
     *
     * @return The dataprocServiceAccount.
     */
    public java.lang.String getDataprocServiceAccount() {
      java.lang.Object ref = dataprocServiceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataprocServiceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-managed service account to set on Dataproc when Cloud Data Fusion
     * creates Dataproc to run data processing pipelines.
     *
     * This allows users to have fine-grained access control on Dataproc's
     * accesses to cloud resources.
     * </pre>
     *
     * <code>string dataproc_service_account = 25;</code>
     *
     * @return The bytes for dataprocServiceAccount.
     */
    public com.google.protobuf.ByteString getDataprocServiceAccountBytes() {
      java.lang.Object ref = dataprocServiceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataprocServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-managed service account to set on Dataproc when Cloud Data Fusion
     * creates Dataproc to run data processing pipelines.
     *
     * This allows users to have fine-grained access control on Dataproc's
     * accesses to cloud resources.
     * </pre>
     *
     * <code>string dataproc_service_account = 25;</code>
     *
     * @param value The dataprocServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setDataprocServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataprocServiceAccount_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-managed service account to set on Dataproc when Cloud Data Fusion
     * creates Dataproc to run data processing pipelines.
     *
     * This allows users to have fine-grained access control on Dataproc's
     * accesses to cloud resources.
     * </pre>
     *
     * <code>string dataproc_service_account = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataprocServiceAccount() {
      dataprocServiceAccount_ = getDefaultInstance().getDataprocServiceAccount();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-managed service account to set on Dataproc when Cloud Data Fusion
     * creates Dataproc to run data processing pipelines.
     *
     * This allows users to have fine-grained access control on Dataproc's
     * accesses to cloud resources.
     * </pre>
     *
     * <code>string dataproc_service_account = 25;</code>
     *
     * @param value The bytes for dataprocServiceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setDataprocServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataprocServiceAccount_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private boolean enableRbac_;
    /**
     *
     *
     * <pre>
     * Option to enable granular role-based access control.
     * </pre>
     *
     * <code>bool enable_rbac = 26;</code>
     *
     * @return The enableRbac.
     */
    @java.lang.Override
    public boolean getEnableRbac() {
      return enableRbac_;
    }
    /**
     *
     *
     * <pre>
     * Option to enable granular role-based access control.
     * </pre>
     *
     * <code>bool enable_rbac = 26;</code>
     *
     * @param value The enableRbac to set.
     * @return This builder for chaining.
     */
    public Builder setEnableRbac(boolean value) {

      enableRbac_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to enable granular role-based access control.
     * </pre>
     *
     * <code>bool enable_rbac = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableRbac() {
      bitField0_ = (bitField0_ & ~0x02000000);
      enableRbac_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.datafusion.v1beta1.CryptoKeyConfig cryptoKeyConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.CryptoKeyConfig,
            com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.Builder,
            com.google.cloud.datafusion.v1beta1.CryptoKeyConfigOrBuilder>
        cryptoKeyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     *
     * @return Whether the cryptoKeyConfig field is set.
     */
    public boolean hasCryptoKeyConfig() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     *
     * @return The cryptoKeyConfig.
     */
    public com.google.cloud.datafusion.v1beta1.CryptoKeyConfig getCryptoKeyConfig() {
      if (cryptoKeyConfigBuilder_ == null) {
        return cryptoKeyConfig_ == null
            ? com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.getDefaultInstance()
            : cryptoKeyConfig_;
      } else {
        return cryptoKeyConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    public Builder setCryptoKeyConfig(com.google.cloud.datafusion.v1beta1.CryptoKeyConfig value) {
      if (cryptoKeyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cryptoKeyConfig_ = value;
      } else {
        cryptoKeyConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    public Builder setCryptoKeyConfig(
        com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.Builder builderForValue) {
      if (cryptoKeyConfigBuilder_ == null) {
        cryptoKeyConfig_ = builderForValue.build();
      } else {
        cryptoKeyConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    public Builder mergeCryptoKeyConfig(com.google.cloud.datafusion.v1beta1.CryptoKeyConfig value) {
      if (cryptoKeyConfigBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && cryptoKeyConfig_ != null
            && cryptoKeyConfig_
                != com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.getDefaultInstance()) {
          getCryptoKeyConfigBuilder().mergeFrom(value);
        } else {
          cryptoKeyConfig_ = value;
        }
      } else {
        cryptoKeyConfigBuilder_.mergeFrom(value);
      }
      if (cryptoKeyConfig_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    public Builder clearCryptoKeyConfig() {
      bitField0_ = (bitField0_ & ~0x04000000);
      cryptoKeyConfig_ = null;
      if (cryptoKeyConfigBuilder_ != null) {
        cryptoKeyConfigBuilder_.dispose();
        cryptoKeyConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    public com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.Builder getCryptoKeyConfigBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getCryptoKeyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    public com.google.cloud.datafusion.v1beta1.CryptoKeyConfigOrBuilder
        getCryptoKeyConfigOrBuilder() {
      if (cryptoKeyConfigBuilder_ != null) {
        return cryptoKeyConfigBuilder_.getMessageOrBuilder();
      } else {
        return cryptoKeyConfig_ == null
            ? com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.getDefaultInstance()
            : cryptoKeyConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The crypto key configuration. This field is used by the Customer-Managed
     * Encryption Keys (CMEK) feature.
     * </pre>
     *
     * <code>.google.cloud.datafusion.v1beta1.CryptoKeyConfig crypto_key_config = 27;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datafusion.v1beta1.CryptoKeyConfig,
            com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.Builder,
            com.google.cloud.datafusion.v1beta1.CryptoKeyConfigOrBuilder>
        getCryptoKeyConfigFieldBuilder() {
      if (cryptoKeyConfigBuilder_ == null) {
        cryptoKeyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datafusion.v1beta1.CryptoKeyConfig,
                com.google.cloud.datafusion.v1beta1.CryptoKeyConfig.Builder,
                com.google.cloud.datafusion.v1beta1.CryptoKeyConfigOrBuilder>(
                getCryptoKeyConfig(), getParentForChildren(), isClean());
        cryptoKeyConfig_ = null;
      }
      return cryptoKeyConfigBuilder_;
    }

    private java.util.List<java.lang.Integer> disabledReason_ = java.util.Collections.emptyList();

    private void ensureDisabledReasonIsMutable() {
      if (!((bitField0_ & 0x08000000) != 0)) {
        disabledReason_ = new java.util.ArrayList<java.lang.Integer>(disabledReason_);
        bitField0_ |= 0x08000000;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the disabledReason.
     */
    public java.util.List<com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>
        getDisabledReasonList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>(
          disabledReason_, disabledReason_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of disabledReason.
     */
    public int getDisabledReasonCount() {
      return disabledReason_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The disabledReason at the given index.
     */
    public com.google.cloud.datafusion.v1beta1.Instance.DisabledReason getDisabledReason(
        int index) {
      return disabledReason_converter_.convert(disabledReason_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The disabledReason to set.
     * @return This builder for chaining.
     */
    public Builder setDisabledReason(
        int index, com.google.cloud.datafusion.v1beta1.Instance.DisabledReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDisabledReasonIsMutable();
      disabledReason_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The disabledReason to add.
     * @return This builder for chaining.
     */
    public Builder addDisabledReason(
        com.google.cloud.datafusion.v1beta1.Instance.DisabledReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDisabledReasonIsMutable();
      disabledReason_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The disabledReason to add.
     * @return This builder for chaining.
     */
    public Builder addAllDisabledReason(
        java.lang.Iterable<? extends com.google.cloud.datafusion.v1beta1.Instance.DisabledReason>
            values) {
      ensureDisabledReasonIsMutable();
      for (com.google.cloud.datafusion.v1beta1.Instance.DisabledReason value : values) {
        disabledReason_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabledReason() {
      disabledReason_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for disabledReason.
     */
    public java.util.List<java.lang.Integer> getDisabledReasonValueList() {
      return java.util.Collections.unmodifiableList(disabledReason_);
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of disabledReason at the given index.
     */
    public int getDisabledReasonValue(int index) {
      return disabledReason_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for disabledReason to set.
     * @return This builder for chaining.
     */
    public Builder setDisabledReasonValue(int index, int value) {
      ensureDisabledReasonIsMutable();
      disabledReason_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for disabledReason to add.
     * @return This builder for chaining.
     */
    public Builder addDisabledReasonValue(int value) {
      ensureDisabledReasonIsMutable();
      disabledReason_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the instance state is DISABLED, the reason for disabling the instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datafusion.v1beta1.Instance.DisabledReason disabled_reason = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for disabledReason to add.
     * @return This builder for chaining.
     */
    public Builder addAllDisabledReasonValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureDisabledReasonIsMutable();
      for (int value : values) {
        disabledReason_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datafusion.v1beta1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datafusion.v1beta1.Instance)
  private static final com.google.cloud.datafusion.v1beta1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datafusion.v1beta1.Instance();
  }

  public static com.google.cloud.datafusion.v1beta1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datafusion.v1beta1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
