/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/dataplex_spec.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Entry specification for a Dataplex table.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.DataplexTableSpec}
 */
public final class DataplexTableSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.DataplexTableSpec)
    DataplexTableSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataplexTableSpec.newBuilder() to construct.
  private DataplexTableSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataplexTableSpec() {
    externalTables_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataplexTableSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.DataplexSpecProto
        .internal_static_google_cloud_datacatalog_v1_DataplexTableSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.DataplexSpecProto
        .internal_static_google_cloud_datacatalog_v1_DataplexTableSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.DataplexTableSpec.class,
            com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder.class);
  }

  public static final int EXTERNAL_TABLES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.DataplexExternalTable> externalTables_;
  /**
   *
   *
   * <pre>
   * List of external tables registered by Dataplex in other systems based on
   * the same underlying data.
   * External tables allow to query this data in those systems.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.DataplexExternalTable>
      getExternalTablesList() {
    return externalTables_;
  }
  /**
   *
   *
   * <pre>
   * List of external tables registered by Dataplex in other systems based on
   * the same underlying data.
   * External tables allow to query this data in those systems.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder>
      getExternalTablesOrBuilderList() {
    return externalTables_;
  }
  /**
   *
   *
   * <pre>
   * List of external tables registered by Dataplex in other systems based on
   * the same underlying data.
   * External tables allow to query this data in those systems.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
   */
  @java.lang.Override
  public int getExternalTablesCount() {
    return externalTables_.size();
  }
  /**
   *
   *
   * <pre>
   * List of external tables registered by Dataplex in other systems based on
   * the same underlying data.
   * External tables allow to query this data in those systems.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexExternalTable getExternalTables(int index) {
    return externalTables_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of external tables registered by Dataplex in other systems based on
   * the same underlying data.
   * External tables allow to query this data in those systems.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder getExternalTablesOrBuilder(
      int index) {
    return externalTables_.get(index);
  }

  public static final int DATAPLEX_SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.datacatalog.v1.DataplexSpec dataplexSpec_;
  /**
   *
   *
   * <pre>
   * Common Dataplex fields.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
   *
   * @return Whether the dataplexSpec field is set.
   */
  @java.lang.Override
  public boolean hasDataplexSpec() {
    return dataplexSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Common Dataplex fields.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
   *
   * @return The dataplexSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexSpec getDataplexSpec() {
    return dataplexSpec_ == null
        ? com.google.cloud.datacatalog.v1.DataplexSpec.getDefaultInstance()
        : dataplexSpec_;
  }
  /**
   *
   *
   * <pre>
   * Common Dataplex fields.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexSpecOrBuilder getDataplexSpecOrBuilder() {
    return dataplexSpec_ == null
        ? com.google.cloud.datacatalog.v1.DataplexSpec.getDefaultInstance()
        : dataplexSpec_;
  }

  public static final int USER_MANAGED_FIELD_NUMBER = 3;
  private boolean userManaged_ = false;
  /**
   *
   *
   * <pre>
   * Indicates if the table schema is managed by the user or not.
   * </pre>
   *
   * <code>bool user_managed = 3;</code>
   *
   * @return The userManaged.
   */
  @java.lang.Override
  public boolean getUserManaged() {
    return userManaged_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < externalTables_.size(); i++) {
      output.writeMessage(1, externalTables_.get(i));
    }
    if (dataplexSpec_ != null) {
      output.writeMessage(2, getDataplexSpec());
    }
    if (userManaged_ != false) {
      output.writeBool(3, userManaged_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < externalTables_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, externalTables_.get(i));
    }
    if (dataplexSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDataplexSpec());
    }
    if (userManaged_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, userManaged_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.DataplexTableSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.DataplexTableSpec other =
        (com.google.cloud.datacatalog.v1.DataplexTableSpec) obj;

    if (!getExternalTablesList().equals(other.getExternalTablesList())) return false;
    if (hasDataplexSpec() != other.hasDataplexSpec()) return false;
    if (hasDataplexSpec()) {
      if (!getDataplexSpec().equals(other.getDataplexSpec())) return false;
    }
    if (getUserManaged() != other.getUserManaged()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getExternalTablesCount() > 0) {
      hash = (37 * hash) + EXTERNAL_TABLES_FIELD_NUMBER;
      hash = (53 * hash) + getExternalTablesList().hashCode();
    }
    if (hasDataplexSpec()) {
      hash = (37 * hash) + DATAPLEX_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDataplexSpec().hashCode();
    }
    hash = (37 * hash) + USER_MANAGED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUserManaged());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.DataplexTableSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Entry specification for a Dataplex table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.DataplexTableSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.DataplexTableSpec)
      com.google.cloud.datacatalog.v1.DataplexTableSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.DataplexSpecProto
          .internal_static_google_cloud_datacatalog_v1_DataplexTableSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.DataplexSpecProto
          .internal_static_google_cloud_datacatalog_v1_DataplexTableSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.DataplexTableSpec.class,
              com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.DataplexTableSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (externalTablesBuilder_ == null) {
        externalTables_ = java.util.Collections.emptyList();
      } else {
        externalTables_ = null;
        externalTablesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      dataplexSpec_ = null;
      if (dataplexSpecBuilder_ != null) {
        dataplexSpecBuilder_.dispose();
        dataplexSpecBuilder_ = null;
      }
      userManaged_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.DataplexSpecProto
          .internal_static_google_cloud_datacatalog_v1_DataplexTableSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DataplexTableSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DataplexTableSpec build() {
      com.google.cloud.datacatalog.v1.DataplexTableSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DataplexTableSpec buildPartial() {
      com.google.cloud.datacatalog.v1.DataplexTableSpec result =
          new com.google.cloud.datacatalog.v1.DataplexTableSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1.DataplexTableSpec result) {
      if (externalTablesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          externalTables_ = java.util.Collections.unmodifiableList(externalTables_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.externalTables_ = externalTables_;
      } else {
        result.externalTables_ = externalTablesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.DataplexTableSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataplexSpec_ =
            dataplexSpecBuilder_ == null ? dataplexSpec_ : dataplexSpecBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.userManaged_ = userManaged_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.DataplexTableSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.DataplexTableSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.DataplexTableSpec other) {
      if (other == com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance())
        return this;
      if (externalTablesBuilder_ == null) {
        if (!other.externalTables_.isEmpty()) {
          if (externalTables_.isEmpty()) {
            externalTables_ = other.externalTables_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureExternalTablesIsMutable();
            externalTables_.addAll(other.externalTables_);
          }
          onChanged();
        }
      } else {
        if (!other.externalTables_.isEmpty()) {
          if (externalTablesBuilder_.isEmpty()) {
            externalTablesBuilder_.dispose();
            externalTablesBuilder_ = null;
            externalTables_ = other.externalTables_;
            bitField0_ = (bitField0_ & ~0x00000001);
            externalTablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExternalTablesFieldBuilder()
                    : null;
          } else {
            externalTablesBuilder_.addAllMessages(other.externalTables_);
          }
        }
      }
      if (other.hasDataplexSpec()) {
        mergeDataplexSpec(other.getDataplexSpec());
      }
      if (other.getUserManaged() != false) {
        setUserManaged(other.getUserManaged());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.datacatalog.v1.DataplexExternalTable m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.DataplexExternalTable.parser(),
                        extensionRegistry);
                if (externalTablesBuilder_ == null) {
                  ensureExternalTablesIsMutable();
                  externalTables_.add(m);
                } else {
                  externalTablesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDataplexSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                userManaged_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.datacatalog.v1.DataplexExternalTable> externalTables_ =
        java.util.Collections.emptyList();

    private void ensureExternalTablesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        externalTables_ =
            new java.util.ArrayList<com.google.cloud.datacatalog.v1.DataplexExternalTable>(
                externalTables_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataplexExternalTable,
            com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder,
            com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder>
        externalTablesBuilder_;

    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.DataplexExternalTable>
        getExternalTablesList() {
      if (externalTablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(externalTables_);
      } else {
        return externalTablesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public int getExternalTablesCount() {
      if (externalTablesBuilder_ == null) {
        return externalTables_.size();
      } else {
        return externalTablesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexExternalTable getExternalTables(int index) {
      if (externalTablesBuilder_ == null) {
        return externalTables_.get(index);
      } else {
        return externalTablesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder setExternalTables(
        int index, com.google.cloud.datacatalog.v1.DataplexExternalTable value) {
      if (externalTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExternalTablesIsMutable();
        externalTables_.set(index, value);
        onChanged();
      } else {
        externalTablesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder setExternalTables(
        int index, com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder builderForValue) {
      if (externalTablesBuilder_ == null) {
        ensureExternalTablesIsMutable();
        externalTables_.set(index, builderForValue.build());
        onChanged();
      } else {
        externalTablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder addExternalTables(com.google.cloud.datacatalog.v1.DataplexExternalTable value) {
      if (externalTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExternalTablesIsMutable();
        externalTables_.add(value);
        onChanged();
      } else {
        externalTablesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder addExternalTables(
        int index, com.google.cloud.datacatalog.v1.DataplexExternalTable value) {
      if (externalTablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExternalTablesIsMutable();
        externalTables_.add(index, value);
        onChanged();
      } else {
        externalTablesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder addExternalTables(
        com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder builderForValue) {
      if (externalTablesBuilder_ == null) {
        ensureExternalTablesIsMutable();
        externalTables_.add(builderForValue.build());
        onChanged();
      } else {
        externalTablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder addExternalTables(
        int index, com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder builderForValue) {
      if (externalTablesBuilder_ == null) {
        ensureExternalTablesIsMutable();
        externalTables_.add(index, builderForValue.build());
        onChanged();
      } else {
        externalTablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder addAllExternalTables(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.DataplexExternalTable>
            values) {
      if (externalTablesBuilder_ == null) {
        ensureExternalTablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, externalTables_);
        onChanged();
      } else {
        externalTablesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder clearExternalTables() {
      if (externalTablesBuilder_ == null) {
        externalTables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        externalTablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public Builder removeExternalTables(int index) {
      if (externalTablesBuilder_ == null) {
        ensureExternalTablesIsMutable();
        externalTables_.remove(index);
        onChanged();
      } else {
        externalTablesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder getExternalTablesBuilder(
        int index) {
      return getExternalTablesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder
        getExternalTablesOrBuilder(int index) {
      if (externalTablesBuilder_ == null) {
        return externalTables_.get(index);
      } else {
        return externalTablesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder>
        getExternalTablesOrBuilderList() {
      if (externalTablesBuilder_ != null) {
        return externalTablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(externalTables_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder
        addExternalTablesBuilder() {
      return getExternalTablesFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.DataplexExternalTable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder addExternalTablesBuilder(
        int index) {
      return getExternalTablesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datacatalog.v1.DataplexExternalTable.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of external tables registered by Dataplex in other systems based on
     * the same underlying data.
     * External tables allow to query this data in those systems.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.DataplexExternalTable external_tables = 1;</code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder>
        getExternalTablesBuilderList() {
      return getExternalTablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataplexExternalTable,
            com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder,
            com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder>
        getExternalTablesFieldBuilder() {
      if (externalTablesBuilder_ == null) {
        externalTablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DataplexExternalTable,
                com.google.cloud.datacatalog.v1.DataplexExternalTable.Builder,
                com.google.cloud.datacatalog.v1.DataplexExternalTableOrBuilder>(
                externalTables_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        externalTables_ = null;
      }
      return externalTablesBuilder_;
    }

    private com.google.cloud.datacatalog.v1.DataplexSpec dataplexSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataplexSpec,
            com.google.cloud.datacatalog.v1.DataplexSpec.Builder,
            com.google.cloud.datacatalog.v1.DataplexSpecOrBuilder>
        dataplexSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     *
     * @return Whether the dataplexSpec field is set.
     */
    public boolean hasDataplexSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     *
     * @return The dataplexSpec.
     */
    public com.google.cloud.datacatalog.v1.DataplexSpec getDataplexSpec() {
      if (dataplexSpecBuilder_ == null) {
        return dataplexSpec_ == null
            ? com.google.cloud.datacatalog.v1.DataplexSpec.getDefaultInstance()
            : dataplexSpec_;
      } else {
        return dataplexSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    public Builder setDataplexSpec(com.google.cloud.datacatalog.v1.DataplexSpec value) {
      if (dataplexSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataplexSpec_ = value;
      } else {
        dataplexSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    public Builder setDataplexSpec(
        com.google.cloud.datacatalog.v1.DataplexSpec.Builder builderForValue) {
      if (dataplexSpecBuilder_ == null) {
        dataplexSpec_ = builderForValue.build();
      } else {
        dataplexSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    public Builder mergeDataplexSpec(com.google.cloud.datacatalog.v1.DataplexSpec value) {
      if (dataplexSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dataplexSpec_ != null
            && dataplexSpec_ != com.google.cloud.datacatalog.v1.DataplexSpec.getDefaultInstance()) {
          getDataplexSpecBuilder().mergeFrom(value);
        } else {
          dataplexSpec_ = value;
        }
      } else {
        dataplexSpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    public Builder clearDataplexSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dataplexSpec_ = null;
      if (dataplexSpecBuilder_ != null) {
        dataplexSpecBuilder_.dispose();
        dataplexSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexSpec.Builder getDataplexSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDataplexSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    public com.google.cloud.datacatalog.v1.DataplexSpecOrBuilder getDataplexSpecOrBuilder() {
      if (dataplexSpecBuilder_ != null) {
        return dataplexSpecBuilder_.getMessageOrBuilder();
      } else {
        return dataplexSpec_ == null
            ? com.google.cloud.datacatalog.v1.DataplexSpec.getDefaultInstance()
            : dataplexSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Common Dataplex fields.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataplexSpec dataplex_spec = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataplexSpec,
            com.google.cloud.datacatalog.v1.DataplexSpec.Builder,
            com.google.cloud.datacatalog.v1.DataplexSpecOrBuilder>
        getDataplexSpecFieldBuilder() {
      if (dataplexSpecBuilder_ == null) {
        dataplexSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DataplexSpec,
                com.google.cloud.datacatalog.v1.DataplexSpec.Builder,
                com.google.cloud.datacatalog.v1.DataplexSpecOrBuilder>(
                getDataplexSpec(), getParentForChildren(), isClean());
        dataplexSpec_ = null;
      }
      return dataplexSpecBuilder_;
    }

    private boolean userManaged_;
    /**
     *
     *
     * <pre>
     * Indicates if the table schema is managed by the user or not.
     * </pre>
     *
     * <code>bool user_managed = 3;</code>
     *
     * @return The userManaged.
     */
    @java.lang.Override
    public boolean getUserManaged() {
      return userManaged_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if the table schema is managed by the user or not.
     * </pre>
     *
     * <code>bool user_managed = 3;</code>
     *
     * @param value The userManaged to set.
     * @return This builder for chaining.
     */
    public Builder setUserManaged(boolean value) {

      userManaged_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if the table schema is managed by the user or not.
     * </pre>
     *
     * <code>bool user_managed = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserManaged() {
      bitField0_ = (bitField0_ & ~0x00000004);
      userManaged_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.DataplexTableSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.DataplexTableSpec)
  private static final com.google.cloud.datacatalog.v1.DataplexTableSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.DataplexTableSpec();
  }

  public static com.google.cloud.datacatalog.v1.DataplexTableSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataplexTableSpec> PARSER =
      new com.google.protobuf.AbstractParser<DataplexTableSpec>() {
        @java.lang.Override
        public DataplexTableSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataplexTableSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataplexTableSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexTableSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
