/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Entry metadata.
 * A Data Catalog entry represents another resource in Google
 * Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
 * outside of it. You can use the `linked_resource` field
 * in the entry resource to refer to the original resource ID of the source
 * system.
 * An entry resource contains resource details, for example, its schema.
 * Additionally, you can attach flexible metadata to an entry in the form of a
 * [Tag][google.cloud.datacatalog.v1.Tag].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.Entry}
 */
public final class Entry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.Entry)
    EntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Entry.newBuilder() to construct.
  private Entry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Entry() {
    name_ = "";
    linkedResource_ = "";
    fullyQualifiedName_ = "";
    displayName_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Entry();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_Entry_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 14:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_Entry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.Entry.class,
            com.google.cloud.datacatalog.v1.Entry.Builder.class);
  }

  private int entryTypeCase_ = 0;
  private java.lang.Object entryType_;

  public enum EntryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TYPE(2),
    USER_SPECIFIED_TYPE(16),
    ENTRYTYPE_NOT_SET(0);
    private final int value;

    private EntryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static EntryTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return TYPE;
        case 16:
          return USER_SPECIFIED_TYPE;
        case 0:
          return ENTRYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EntryTypeCase getEntryTypeCase() {
    return EntryTypeCase.forNumber(entryTypeCase_);
  }

  private int systemCase_ = 0;
  private java.lang.Object system_;

  public enum SystemCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTEGRATED_SYSTEM(17),
    USER_SPECIFIED_SYSTEM(18),
    SYSTEM_NOT_SET(0);
    private final int value;

    private SystemCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SystemCase valueOf(int value) {
      return forNumber(value);
    }

    public static SystemCase forNumber(int value) {
      switch (value) {
        case 17:
          return INTEGRATED_SYSTEM;
        case 18:
          return USER_SPECIFIED_SYSTEM;
        case 0:
          return SYSTEM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SystemCase getSystemCase() {
    return SystemCase.forNumber(systemCase_);
  }

  private int systemSpecCase_ = 0;
  private java.lang.Object systemSpec_;

  public enum SystemSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SQL_DATABASE_SYSTEM_SPEC(39),
    LOOKER_SYSTEM_SPEC(40),
    SYSTEMSPEC_NOT_SET(0);
    private final int value;

    private SystemSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SystemSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SystemSpecCase forNumber(int value) {
      switch (value) {
        case 39:
          return SQL_DATABASE_SYSTEM_SPEC;
        case 40:
          return LOOKER_SYSTEM_SPEC;
        case 0:
          return SYSTEMSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SystemSpecCase getSystemSpecCase() {
    return SystemSpecCase.forNumber(systemSpecCase_);
  }

  private int typeSpecCase_ = 0;
  private java.lang.Object typeSpec_;

  public enum TypeSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_FILESET_SPEC(6),
    BIGQUERY_TABLE_SPEC(12),
    BIGQUERY_DATE_SHARDED_SPEC(15),
    TYPESPEC_NOT_SET(0);
    private final int value;

    private TypeSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeSpecCase forNumber(int value) {
      switch (value) {
        case 6:
          return GCS_FILESET_SPEC;
        case 12:
          return BIGQUERY_TABLE_SPEC;
        case 15:
          return BIGQUERY_DATE_SHARDED_SPEC;
        case 0:
          return TYPESPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeSpecCase getTypeSpecCase() {
    return TypeSpecCase.forNumber(typeSpecCase_);
  }

  private int specCase_ = 0;
  private java.lang.Object spec_;

  public enum SpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATABASE_TABLE_SPEC(24),
    DATA_SOURCE_CONNECTION_SPEC(27),
    ROUTINE_SPEC(28),
    FILESET_SPEC(33),
    SPEC_NOT_SET(0);
    private final int value;

    private SpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpecCase forNumber(int value) {
      switch (value) {
        case 24:
          return DATABASE_TABLE_SPEC;
        case 27:
          return DATA_SOURCE_CONNECTION_SPEC;
        case 28:
          return ROUTINE_SPEC;
        case 33:
          return FILESET_SPEC;
        case 0:
          return SPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SpecCase getSpecCase() {
    return SpecCase.forNumber(specCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of an entry in URL format.
   * Note: The entry itself and its child resources might not be
   * stored in the location specified in its name.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of an entry in URL format.
   * Note: The entry itself and its child resources might not be
   * stored in the location specified in its name.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_RESOURCE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkedResource_ = "";
  /**
   *
   *
   * <pre>
   * The resource this metadata entry refers to.
   * For Google Cloud Platform resources, `linked_resource` is the
   * [Full Resource Name]
   * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
   * For example, the `linked_resource` for a table resource from BigQuery is:
   * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
   * Output only when the entry is one of the types in the `EntryType` enum.
   * For entries with a `user_specified_type`, this field is optional and
   * defaults to an empty string.
   * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
   * and hashes (#).
   * The maximum size is 200 bytes when encoded in UTF-8.
   * </pre>
   *
   * <code>string linked_resource = 9;</code>
   *
   * @return The linkedResource.
   */
  @java.lang.Override
  public java.lang.String getLinkedResource() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource this metadata entry refers to.
   * For Google Cloud Platform resources, `linked_resource` is the
   * [Full Resource Name]
   * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
   * For example, the `linked_resource` for a table resource from BigQuery is:
   * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
   * Output only when the entry is one of the types in the `EntryType` enum.
   * For entries with a `user_specified_type`, this field is optional and
   * defaults to an empty string.
   * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
   * and hashes (#).
   * The maximum size is 200 bytes when encoded in UTF-8.
   * </pre>
   *
   * <code>string linked_resource = 9;</code>
   *
   * @return The bytes for linkedResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkedResourceBytes() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULLY_QUALIFIED_NAME_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullyQualifiedName_ = "";
  /**
   *
   *
   * <pre>
   * Fully qualified name (FQN) of the resource. Set automatically for entries
   * representing resources from synced systems. Settable only during creation
   * and read-only afterwards. Can be used for search and lookup of the entries.
   * FQNs take two forms:
   * * For non-regionalized resources:
   *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   * * For regionalized resources:
   *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   * Example for a DPMS table:
   * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
   * </pre>
   *
   * <code>string fully_qualified_name = 29;</code>
   *
   * @return The fullyQualifiedName.
   */
  @java.lang.Override
  public java.lang.String getFullyQualifiedName() {
    java.lang.Object ref = fullyQualifiedName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullyQualifiedName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fully qualified name (FQN) of the resource. Set automatically for entries
   * representing resources from synced systems. Settable only during creation
   * and read-only afterwards. Can be used for search and lookup of the entries.
   * FQNs take two forms:
   * * For non-regionalized resources:
   *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   * * For regionalized resources:
   *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   * Example for a DPMS table:
   * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
   * </pre>
   *
   * <code>string fully_qualified_name = 29;</code>
   *
   * @return The bytes for fullyQualifiedName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullyQualifiedNameBytes() {
    java.lang.Object ref = fullyQualifiedName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullyQualifiedName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The type of the entry.
   * Only used for entries with types listed in the `EntryType` enum.
   * Currently, only `FILESET` enum value is allowed. All other entries
   * created in Data Catalog must use the `user_specified_type`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
   *
   * @return Whether the type field is set.
   */
  public boolean hasType() {
    return entryTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The type of the entry.
   * Only used for entries with types listed in the `EntryType` enum.
   * Currently, only `FILESET` enum value is allowed. All other entries
   * created in Data Catalog must use the `user_specified_type`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  public int getTypeValue() {
    if (entryTypeCase_ == 2) {
      return (java.lang.Integer) entryType_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * The type of the entry.
   * Only used for entries with types listed in the `EntryType` enum.
   * Currently, only `FILESET` enum value is allowed. All other entries
   * created in Data Catalog must use the `user_specified_type`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
   *
   * @return The type.
   */
  public com.google.cloud.datacatalog.v1.EntryType getType() {
    if (entryTypeCase_ == 2) {
      com.google.cloud.datacatalog.v1.EntryType result =
          com.google.cloud.datacatalog.v1.EntryType.forNumber((java.lang.Integer) entryType_);
      return result == null ? com.google.cloud.datacatalog.v1.EntryType.UNRECOGNIZED : result;
    }
    return com.google.cloud.datacatalog.v1.EntryType.ENTRY_TYPE_UNSPECIFIED;
  }

  public static final int USER_SPECIFIED_TYPE_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Custom entry type that doesn't match any of the values allowed for input
   * and listed in the `EntryType` enum.
   * When creating an entry, first check the type values in the enum.
   * If there are no appropriate types for the new entry,
   * provide a custom value, for example, `my_special_type`.
   * The `user_specified_type` string has the following limitations:
   * * Is case insensitive.
   * * Must begin with a letter or underscore.
   * * Can only contain letters, numbers, and underscores.
   * * Must be at least 1 character and at most 64 characters long.
   * </pre>
   *
   * <code>string user_specified_type = 16;</code>
   *
   * @return Whether the userSpecifiedType field is set.
   */
  public boolean hasUserSpecifiedType() {
    return entryTypeCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Custom entry type that doesn't match any of the values allowed for input
   * and listed in the `EntryType` enum.
   * When creating an entry, first check the type values in the enum.
   * If there are no appropriate types for the new entry,
   * provide a custom value, for example, `my_special_type`.
   * The `user_specified_type` string has the following limitations:
   * * Is case insensitive.
   * * Must begin with a letter or underscore.
   * * Can only contain letters, numbers, and underscores.
   * * Must be at least 1 character and at most 64 characters long.
   * </pre>
   *
   * <code>string user_specified_type = 16;</code>
   *
   * @return The userSpecifiedType.
   */
  public java.lang.String getUserSpecifiedType() {
    java.lang.Object ref = "";
    if (entryTypeCase_ == 16) {
      ref = entryType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (entryTypeCase_ == 16) {
        entryType_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Custom entry type that doesn't match any of the values allowed for input
   * and listed in the `EntryType` enum.
   * When creating an entry, first check the type values in the enum.
   * If there are no appropriate types for the new entry,
   * provide a custom value, for example, `my_special_type`.
   * The `user_specified_type` string has the following limitations:
   * * Is case insensitive.
   * * Must begin with a letter or underscore.
   * * Can only contain letters, numbers, and underscores.
   * * Must be at least 1 character and at most 64 characters long.
   * </pre>
   *
   * <code>string user_specified_type = 16;</code>
   *
   * @return The bytes for userSpecifiedType.
   */
  public com.google.protobuf.ByteString getUserSpecifiedTypeBytes() {
    java.lang.Object ref = "";
    if (entryTypeCase_ == 16) {
      ref = entryType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (entryTypeCase_ == 16) {
        entryType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTEGRATED_SYSTEM_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Output only. Indicates the entry's source system that Data Catalog
   * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the integratedSystem field is set.
   */
  public boolean hasIntegratedSystem() {
    return systemCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Output only. Indicates the entry's source system that Data Catalog
   * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for integratedSystem.
   */
  public int getIntegratedSystemValue() {
    if (systemCase_ == 17) {
      return (java.lang.Integer) system_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Output only. Indicates the entry's source system that Data Catalog
   * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The integratedSystem.
   */
  public com.google.cloud.datacatalog.v1.IntegratedSystem getIntegratedSystem() {
    if (systemCase_ == 17) {
      com.google.cloud.datacatalog.v1.IntegratedSystem result =
          com.google.cloud.datacatalog.v1.IntegratedSystem.forNumber((java.lang.Integer) system_);
      return result == null
          ? com.google.cloud.datacatalog.v1.IntegratedSystem.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.datacatalog.v1.IntegratedSystem.INTEGRATED_SYSTEM_UNSPECIFIED;
  }

  public static final int USER_SPECIFIED_SYSTEM_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Indicates the entry's source system that Data Catalog doesn't
   * automatically integrate with.
   * The `user_specified_system` string has the following limitations:
   * * Is case insensitive.
   * * Must begin with a letter or underscore.
   * * Can only contain letters, numbers, and underscores.
   * * Must be at least 1 character and at most 64 characters long.
   * </pre>
   *
   * <code>string user_specified_system = 18;</code>
   *
   * @return Whether the userSpecifiedSystem field is set.
   */
  public boolean hasUserSpecifiedSystem() {
    return systemCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Indicates the entry's source system that Data Catalog doesn't
   * automatically integrate with.
   * The `user_specified_system` string has the following limitations:
   * * Is case insensitive.
   * * Must begin with a letter or underscore.
   * * Can only contain letters, numbers, and underscores.
   * * Must be at least 1 character and at most 64 characters long.
   * </pre>
   *
   * <code>string user_specified_system = 18;</code>
   *
   * @return The userSpecifiedSystem.
   */
  public java.lang.String getUserSpecifiedSystem() {
    java.lang.Object ref = "";
    if (systemCase_ == 18) {
      ref = system_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (systemCase_ == 18) {
        system_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Indicates the entry's source system that Data Catalog doesn't
   * automatically integrate with.
   * The `user_specified_system` string has the following limitations:
   * * Is case insensitive.
   * * Must begin with a letter or underscore.
   * * Can only contain letters, numbers, and underscores.
   * * Must be at least 1 character and at most 64 characters long.
   * </pre>
   *
   * <code>string user_specified_system = 18;</code>
   *
   * @return The bytes for userSpecifiedSystem.
   */
  public com.google.protobuf.ByteString getUserSpecifiedSystemBytes() {
    java.lang.Object ref = "";
    if (systemCase_ == 18) {
      ref = system_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (systemCase_ == 18) {
        system_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SQL_DATABASE_SYSTEM_SPEC_FIELD_NUMBER = 39;
  /**
   *
   *
   * <pre>
   * Specification that applies to a relational database system. Only settable
   * when `user_specified_system` is equal to `SQL_DATABASE`
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;</code>
   *
   * @return Whether the sqlDatabaseSystemSpec field is set.
   */
  @java.lang.Override
  public boolean hasSqlDatabaseSystemSpec() {
    return systemSpecCase_ == 39;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a relational database system. Only settable
   * when `user_specified_system` is equal to `SQL_DATABASE`
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;</code>
   *
   * @return The sqlDatabaseSystemSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec getSqlDatabaseSystemSpec() {
    if (systemSpecCase_ == 39) {
      return (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a relational database system. Only settable
   * when `user_specified_system` is equal to `SQL_DATABASE`
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpecOrBuilder
      getSqlDatabaseSystemSpecOrBuilder() {
    if (systemSpecCase_ == 39) {
      return (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance();
  }

  public static final int LOOKER_SYSTEM_SPEC_FIELD_NUMBER = 40;
  /**
   *
   *
   * <pre>
   * Specification that applies to Looker sysstem. Only settable when
   * `user_specified_system` is equal to `LOOKER`
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
   *
   * @return Whether the lookerSystemSpec field is set.
   */
  @java.lang.Override
  public boolean hasLookerSystemSpec() {
    return systemSpecCase_ == 40;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to Looker sysstem. Only settable when
   * `user_specified_system` is equal to `LOOKER`
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
   *
   * @return The lookerSystemSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.LookerSystemSpec getLookerSystemSpec() {
    if (systemSpecCase_ == 40) {
      return (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to Looker sysstem. Only settable when
   * `user_specified_system` is equal to `LOOKER`
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.LookerSystemSpecOrBuilder getLookerSystemSpecOrBuilder() {
    if (systemSpecCase_ == 40) {
      return (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
  }

  public static final int GCS_FILESET_SPEC_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Specification that applies to a Cloud Storage fileset. Valid only
   * for entries with the `FILESET` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
   *
   * @return Whether the gcsFilesetSpec field is set.
   */
  @java.lang.Override
  public boolean hasGcsFilesetSpec() {
    return typeSpecCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a Cloud Storage fileset. Valid only
   * for entries with the `FILESET` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
   *
   * @return The gcsFilesetSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.GcsFilesetSpec getGcsFilesetSpec() {
    if (typeSpecCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a Cloud Storage fileset. Valid only
   * for entries with the `FILESET` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.GcsFilesetSpecOrBuilder getGcsFilesetSpecOrBuilder() {
    if (typeSpecCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance();
  }

  public static final int BIGQUERY_TABLE_SPEC_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Output only. Specification that applies to a BigQuery table. Valid only
   * for entries with the `TABLE` type.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the bigqueryTableSpec field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryTableSpec() {
    return typeSpecCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Output only. Specification that applies to a BigQuery table. Valid only
   * for entries with the `TABLE` type.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bigqueryTableSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BigQueryTableSpec getBigqueryTableSpec() {
    if (typeSpecCase_ == 12) {
      return (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Specification that applies to a BigQuery table. Valid only
   * for entries with the `TABLE` type.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BigQueryTableSpecOrBuilder
      getBigqueryTableSpecOrBuilder() {
    if (typeSpecCase_ == 12) {
      return (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance();
  }

  public static final int BIGQUERY_DATE_SHARDED_SPEC_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Output only. Specification for a group of BigQuery tables with
   * the `[prefix]YYYYMMDD` name pattern.
   * For more information, see [Introduction to partitioned tables]
   * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the bigqueryDateShardedSpec field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDateShardedSpec() {
    return typeSpecCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Output only. Specification for a group of BigQuery tables with
   * the `[prefix]YYYYMMDD` name pattern.
   * For more information, see [Introduction to partitioned tables]
   * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bigqueryDateShardedSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec getBigqueryDateShardedSpec() {
    if (typeSpecCase_ == 15) {
      return (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Specification for a group of BigQuery tables with
   * the `[prefix]YYYYMMDD` name pattern.
   * For more information, see [Introduction to partitioned tables]
   * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BigQueryDateShardedSpecOrBuilder
      getBigqueryDateShardedSpecOrBuilder() {
    if (typeSpecCase_ == 15) {
      return (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance();
  }

  public static final int DATABASE_TABLE_SPEC_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * Specification that applies to a table resource. Valid only
   * for entries with the `TABLE` or `EXPLORE` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
   *
   * @return Whether the databaseTableSpec field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseTableSpec() {
    return specCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a table resource. Valid only
   * for entries with the `TABLE` or `EXPLORE` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
   *
   * @return The databaseTableSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DatabaseTableSpec getDatabaseTableSpec() {
    if (specCase_ == 24) {
      return (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a table resource. Valid only
   * for entries with the `TABLE` or `EXPLORE` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DatabaseTableSpecOrBuilder
      getDatabaseTableSpecOrBuilder() {
    if (specCase_ == 24) {
      return (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
  }

  public static final int DATA_SOURCE_CONNECTION_SPEC_FIELD_NUMBER = 27;
  /**
   *
   *
   * <pre>
   * Specification that applies to a data source connection. Valid only
   * for entries with the `DATA_SOURCE_CONNECTION` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
   * </code>
   *
   * @return Whether the dataSourceConnectionSpec field is set.
   */
  @java.lang.Override
  public boolean hasDataSourceConnectionSpec() {
    return specCase_ == 27;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a data source connection. Valid only
   * for entries with the `DATA_SOURCE_CONNECTION` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
   * </code>
   *
   * @return The dataSourceConnectionSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataSourceConnectionSpec getDataSourceConnectionSpec() {
    if (specCase_ == 27) {
      return (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a data source connection. Valid only
   * for entries with the `DATA_SOURCE_CONNECTION` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataSourceConnectionSpecOrBuilder
      getDataSourceConnectionSpecOrBuilder() {
    if (specCase_ == 27) {
      return (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance();
  }

  public static final int ROUTINE_SPEC_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Specification that applies to a user-defined function or procedure. Valid
   * only for entries with the `ROUTINE` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
   *
   * @return Whether the routineSpec field is set.
   */
  @java.lang.Override
  public boolean hasRoutineSpec() {
    return specCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a user-defined function or procedure. Valid
   * only for entries with the `ROUTINE` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
   *
   * @return The routineSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.RoutineSpec getRoutineSpec() {
    if (specCase_ == 28) {
      return (com.google.cloud.datacatalog.v1.RoutineSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a user-defined function or procedure. Valid
   * only for entries with the `ROUTINE` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.RoutineSpecOrBuilder getRoutineSpecOrBuilder() {
    if (specCase_ == 28) {
      return (com.google.cloud.datacatalog.v1.RoutineSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
  }

  public static final int FILESET_SPEC_FIELD_NUMBER = 33;
  /**
   *
   *
   * <pre>
   * Specification that applies to a fileset resource. Valid only
   * for entries with the `FILESET` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
   *
   * @return Whether the filesetSpec field is set.
   */
  @java.lang.Override
  public boolean hasFilesetSpec() {
    return specCase_ == 33;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a fileset resource. Valid only
   * for entries with the `FILESET` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
   *
   * @return The filesetSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.FilesetSpec getFilesetSpec() {
    if (specCase_ == 33) {
      return (com.google.cloud.datacatalog.v1.FilesetSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a fileset resource. Valid only
   * for entries with the `FILESET` type.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.FilesetSpecOrBuilder getFilesetSpecOrBuilder() {
    if (specCase_ == 33) {
      return (com.google.cloud.datacatalog.v1.FilesetSpec) spec_;
    }
    return com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance();
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name of an entry.
   * The maximum size is 500 bytes when encoded in UTF-8.
   * Default value is an empty string.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name of an entry.
   * The maximum size is 500 bytes when encoded in UTF-8.
   * Default value is an empty string.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Entry description that can consist of several sentences or paragraphs
   * that describe entry contents.
   * The description must not contain Unicode non-characters as well as C0
   * and C1 control codes except tabs (HT), new lines (LF), carriage returns
   * (CR), and page breaks (FF).
   * The maximum size is 2000 bytes when encoded in UTF-8.
   * Default value is an empty string.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Entry description that can consist of several sentences or paragraphs
   * that describe entry contents.
   * The description must not contain Unicode non-characters as well as C0
   * and C1 control codes except tabs (HT), new lines (LF), carriage returns
   * (CR), and page breaks (FF).
   * The maximum size is 2000 bytes when encoded in UTF-8.
   * Default value is an empty string.
   * </pre>
   *
   * <code>string description = 4;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUSINESS_CONTEXT_FIELD_NUMBER = 37;
  private com.google.cloud.datacatalog.v1.BusinessContext businessContext_;
  /**
   *
   *
   * <pre>
   * Business Context of the entry. Not supported for BigQuery datasets
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
   *
   * @return Whether the businessContext field is set.
   */
  @java.lang.Override
  public boolean hasBusinessContext() {
    return businessContext_ != null;
  }
  /**
   *
   *
   * <pre>
   * Business Context of the entry. Not supported for BigQuery datasets
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
   *
   * @return The businessContext.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BusinessContext getBusinessContext() {
    return businessContext_ == null
        ? com.google.cloud.datacatalog.v1.BusinessContext.getDefaultInstance()
        : businessContext_;
  }
  /**
   *
   *
   * <pre>
   * Business Context of the entry. Not supported for BigQuery datasets
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BusinessContextOrBuilder getBusinessContextOrBuilder() {
    return businessContext_ == null
        ? com.google.cloud.datacatalog.v1.BusinessContext.getDefaultInstance()
        : businessContext_;
  }

  public static final int SCHEMA_FIELD_NUMBER = 5;
  private com.google.cloud.datacatalog.v1.Schema schema_;
  /**
   *
   *
   * <pre>
   * Schema of the entry. An entry might not have any schema attached to it.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
   *
   * @return Whether the schema field is set.
   */
  @java.lang.Override
  public boolean hasSchema() {
    return schema_ != null;
  }
  /**
   *
   *
   * <pre>
   * Schema of the entry. An entry might not have any schema attached to it.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
   *
   * @return The schema.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Schema getSchema() {
    return schema_ == null ? com.google.cloud.datacatalog.v1.Schema.getDefaultInstance() : schema_;
  }
  /**
   *
   *
   * <pre>
   * Schema of the entry. An entry might not have any schema attached to it.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SchemaOrBuilder getSchemaOrBuilder() {
    return schema_ == null ? com.google.cloud.datacatalog.v1.Schema.getDefaultInstance() : schema_;
  }

  public static final int SOURCE_SYSTEM_TIMESTAMPS_FIELD_NUMBER = 7;
  private com.google.cloud.datacatalog.v1.SystemTimestamps sourceSystemTimestamps_;
  /**
   *
   *
   * <pre>
   * Timestamps from the underlying resource, not from the Data Catalog
   * entry.
   * Output only when the entry has a system listed in the `IntegratedSystem`
   * enum. For entries with `user_specified_system`, this field is optional
   * and defaults to an empty timestamp.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
   *
   * @return Whether the sourceSystemTimestamps field is set.
   */
  @java.lang.Override
  public boolean hasSourceSystemTimestamps() {
    return sourceSystemTimestamps_ != null;
  }
  /**
   *
   *
   * <pre>
   * Timestamps from the underlying resource, not from the Data Catalog
   * entry.
   * Output only when the entry has a system listed in the `IntegratedSystem`
   * enum. For entries with `user_specified_system`, this field is optional
   * and defaults to an empty timestamp.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
   *
   * @return The sourceSystemTimestamps.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SystemTimestamps getSourceSystemTimestamps() {
    return sourceSystemTimestamps_ == null
        ? com.google.cloud.datacatalog.v1.SystemTimestamps.getDefaultInstance()
        : sourceSystemTimestamps_;
  }
  /**
   *
   *
   * <pre>
   * Timestamps from the underlying resource, not from the Data Catalog
   * entry.
   * Output only when the entry has a system listed in the `IntegratedSystem`
   * enum. For entries with `user_specified_system`, this field is optional
   * and defaults to an empty timestamp.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SystemTimestampsOrBuilder
      getSourceSystemTimestampsOrBuilder() {
    return sourceSystemTimestamps_ == null
        ? com.google.cloud.datacatalog.v1.SystemTimestamps.getDefaultInstance()
        : sourceSystemTimestamps_;
  }

  public static final int USAGE_SIGNAL_FIELD_NUMBER = 13;
  private com.google.cloud.datacatalog.v1.UsageSignal usageSignal_;
  /**
   *
   *
   * <pre>
   * Resource usage statistics.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
   *
   * @return Whether the usageSignal field is set.
   */
  @java.lang.Override
  public boolean hasUsageSignal() {
    return usageSignal_ != null;
  }
  /**
   *
   *
   * <pre>
   * Resource usage statistics.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
   *
   * @return The usageSignal.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.UsageSignal getUsageSignal() {
    return usageSignal_ == null
        ? com.google.cloud.datacatalog.v1.UsageSignal.getDefaultInstance()
        : usageSignal_;
  }
  /**
   *
   *
   * <pre>
   * Resource usage statistics.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.UsageSignalOrBuilder getUsageSignalOrBuilder() {
    return usageSignal_ == null
        ? com.google.cloud.datacatalog.v1.UsageSignal.getDefaultInstance()
        : usageSignal_;
  }

  public static final int LABELS_FIELD_NUMBER = 14;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datacatalog.v1.Datacatalog
                .internal_static_google_cloud_datacatalog_v1_Entry_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Cloud labels attached to the entry.
   * In Data Catalog, you can create and modify labels attached only to custom
   * entries. Synced entries have unmodifiable labels that come from the source
   * system.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Cloud labels attached to the entry.
   * In Data Catalog, you can create and modify labels attached only to custom
   * entries. Synced entries have unmodifiable labels that come from the source
   * system.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Cloud labels attached to the entry.
   * In Data Catalog, you can create and modify labels attached only to custom
   * entries. Synced entries have unmodifiable labels that come from the source
   * system.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Cloud labels attached to the entry.
   * In Data Catalog, you can create and modify labels attached only to custom
   * entries. Synced entries have unmodifiable labels that come from the source
   * system.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 14;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DATA_SOURCE_FIELD_NUMBER = 20;
  private com.google.cloud.datacatalog.v1.DataSource dataSource_;
  /**
   *
   *
   * <pre>
   * Output only. Physical location of the entry.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataSource field is set.
   */
  @java.lang.Override
  public boolean hasDataSource() {
    return dataSource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Physical location of the entry.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataSource.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataSource getDataSource() {
    return dataSource_ == null
        ? com.google.cloud.datacatalog.v1.DataSource.getDefaultInstance()
        : dataSource_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Physical location of the entry.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataSourceOrBuilder getDataSourceOrBuilder() {
    return dataSource_ == null
        ? com.google.cloud.datacatalog.v1.DataSource.getDefaultInstance()
        : dataSource_;
  }

  public static final int PERSONAL_DETAILS_FIELD_NUMBER = 26;
  private com.google.cloud.datacatalog.v1.PersonalDetails personalDetails_;
  /**
   *
   *
   * <pre>
   * Output only. Additional information related to the entry. Private to the
   * current user.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the personalDetails field is set.
   */
  @java.lang.Override
  public boolean hasPersonalDetails() {
    return personalDetails_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information related to the entry. Private to the
   * current user.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The personalDetails.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PersonalDetails getPersonalDetails() {
    return personalDetails_ == null
        ? com.google.cloud.datacatalog.v1.PersonalDetails.getDefaultInstance()
        : personalDetails_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information related to the entry. Private to the
   * current user.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.PersonalDetailsOrBuilder getPersonalDetailsOrBuilder() {
    return personalDetails_ == null
        ? com.google.cloud.datacatalog.v1.PersonalDetails.getDefaultInstance()
        : personalDetails_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (entryTypeCase_ == 2) {
      output.writeEnum(2, ((java.lang.Integer) entryType_));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    if (schema_ != null) {
      output.writeMessage(5, getSchema());
    }
    if (typeSpecCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_);
    }
    if (sourceSystemTimestamps_ != null) {
      output.writeMessage(7, getSourceSystemTimestamps());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, linkedResource_);
    }
    if (typeSpecCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_);
    }
    if (usageSignal_ != null) {
      output.writeMessage(13, getUsageSignal());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 14);
    if (typeSpecCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_);
    }
    if (entryTypeCase_ == 16) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, entryType_);
    }
    if (systemCase_ == 17) {
      output.writeEnum(17, ((java.lang.Integer) system_));
    }
    if (systemCase_ == 18) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, system_);
    }
    if (dataSource_ != null) {
      output.writeMessage(20, getDataSource());
    }
    if (specCase_ == 24) {
      output.writeMessage(24, (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_);
    }
    if (personalDetails_ != null) {
      output.writeMessage(26, getPersonalDetails());
    }
    if (specCase_ == 27) {
      output.writeMessage(27, (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_);
    }
    if (specCase_ == 28) {
      output.writeMessage(28, (com.google.cloud.datacatalog.v1.RoutineSpec) spec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullyQualifiedName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, fullyQualifiedName_);
    }
    if (specCase_ == 33) {
      output.writeMessage(33, (com.google.cloud.datacatalog.v1.FilesetSpec) spec_);
    }
    if (businessContext_ != null) {
      output.writeMessage(37, getBusinessContext());
    }
    if (systemSpecCase_ == 39) {
      output.writeMessage(39, (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_);
    }
    if (systemSpecCase_ == 40) {
      output.writeMessage(40, (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (entryTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              2, ((java.lang.Integer) entryType_));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    if (schema_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSchema());
    }
    if (typeSpecCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_);
    }
    if (sourceSystemTimestamps_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSourceSystemTimestamps());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, linkedResource_);
    }
    if (typeSpecCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_);
    }
    if (usageSignal_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getUsageSignal());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, labels__);
    }
    if (typeSpecCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_);
    }
    if (entryTypeCase_ == 16) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, entryType_);
    }
    if (systemCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(17, ((java.lang.Integer) system_));
    }
    if (systemCase_ == 18) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, system_);
    }
    if (dataSource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getDataSource());
    }
    if (specCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_);
    }
    if (personalDetails_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getPersonalDetails());
    }
    if (specCase_ == 27) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              27, (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_);
    }
    if (specCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.cloud.datacatalog.v1.RoutineSpec) spec_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullyQualifiedName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(29, fullyQualifiedName_);
    }
    if (specCase_ == 33) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              33, (com.google.cloud.datacatalog.v1.FilesetSpec) spec_);
    }
    if (businessContext_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(37, getBusinessContext());
    }
    if (systemSpecCase_ == 39) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              39, (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_);
    }
    if (systemSpecCase_ == 40) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              40, (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.Entry)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.Entry other = (com.google.cloud.datacatalog.v1.Entry) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLinkedResource().equals(other.getLinkedResource())) return false;
    if (!getFullyQualifiedName().equals(other.getFullyQualifiedName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasBusinessContext() != other.hasBusinessContext()) return false;
    if (hasBusinessContext()) {
      if (!getBusinessContext().equals(other.getBusinessContext())) return false;
    }
    if (hasSchema() != other.hasSchema()) return false;
    if (hasSchema()) {
      if (!getSchema().equals(other.getSchema())) return false;
    }
    if (hasSourceSystemTimestamps() != other.hasSourceSystemTimestamps()) return false;
    if (hasSourceSystemTimestamps()) {
      if (!getSourceSystemTimestamps().equals(other.getSourceSystemTimestamps())) return false;
    }
    if (hasUsageSignal() != other.hasUsageSignal()) return false;
    if (hasUsageSignal()) {
      if (!getUsageSignal().equals(other.getUsageSignal())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasDataSource() != other.hasDataSource()) return false;
    if (hasDataSource()) {
      if (!getDataSource().equals(other.getDataSource())) return false;
    }
    if (hasPersonalDetails() != other.hasPersonalDetails()) return false;
    if (hasPersonalDetails()) {
      if (!getPersonalDetails().equals(other.getPersonalDetails())) return false;
    }
    if (!getEntryTypeCase().equals(other.getEntryTypeCase())) return false;
    switch (entryTypeCase_) {
      case 2:
        if (getTypeValue() != other.getTypeValue()) return false;
        break;
      case 16:
        if (!getUserSpecifiedType().equals(other.getUserSpecifiedType())) return false;
        break;
      case 0:
      default:
    }
    if (!getSystemCase().equals(other.getSystemCase())) return false;
    switch (systemCase_) {
      case 17:
        if (getIntegratedSystemValue() != other.getIntegratedSystemValue()) return false;
        break;
      case 18:
        if (!getUserSpecifiedSystem().equals(other.getUserSpecifiedSystem())) return false;
        break;
      case 0:
      default:
    }
    if (!getSystemSpecCase().equals(other.getSystemSpecCase())) return false;
    switch (systemSpecCase_) {
      case 39:
        if (!getSqlDatabaseSystemSpec().equals(other.getSqlDatabaseSystemSpec())) return false;
        break;
      case 40:
        if (!getLookerSystemSpec().equals(other.getLookerSystemSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getTypeSpecCase().equals(other.getTypeSpecCase())) return false;
    switch (typeSpecCase_) {
      case 6:
        if (!getGcsFilesetSpec().equals(other.getGcsFilesetSpec())) return false;
        break;
      case 12:
        if (!getBigqueryTableSpec().equals(other.getBigqueryTableSpec())) return false;
        break;
      case 15:
        if (!getBigqueryDateShardedSpec().equals(other.getBigqueryDateShardedSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getSpecCase().equals(other.getSpecCase())) return false;
    switch (specCase_) {
      case 24:
        if (!getDatabaseTableSpec().equals(other.getDatabaseTableSpec())) return false;
        break;
      case 27:
        if (!getDataSourceConnectionSpec().equals(other.getDataSourceConnectionSpec()))
          return false;
        break;
      case 28:
        if (!getRoutineSpec().equals(other.getRoutineSpec())) return false;
        break;
      case 33:
        if (!getFilesetSpec().equals(other.getFilesetSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LINKED_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getLinkedResource().hashCode();
    hash = (37 * hash) + FULLY_QUALIFIED_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFullyQualifiedName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasBusinessContext()) {
      hash = (37 * hash) + BUSINESS_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getBusinessContext().hashCode();
    }
    if (hasSchema()) {
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
    }
    if (hasSourceSystemTimestamps()) {
      hash = (37 * hash) + SOURCE_SYSTEM_TIMESTAMPS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSystemTimestamps().hashCode();
    }
    if (hasUsageSignal()) {
      hash = (37 * hash) + USAGE_SIGNAL_FIELD_NUMBER;
      hash = (53 * hash) + getUsageSignal().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasDataSource()) {
      hash = (37 * hash) + DATA_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getDataSource().hashCode();
    }
    if (hasPersonalDetails()) {
      hash = (37 * hash) + PERSONAL_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getPersonalDetails().hashCode();
    }
    switch (entryTypeCase_) {
      case 2:
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getTypeValue();
        break;
      case 16:
        hash = (37 * hash) + USER_SPECIFIED_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getUserSpecifiedType().hashCode();
        break;
      case 0:
      default:
    }
    switch (systemCase_) {
      case 17:
        hash = (37 * hash) + INTEGRATED_SYSTEM_FIELD_NUMBER;
        hash = (53 * hash) + getIntegratedSystemValue();
        break;
      case 18:
        hash = (37 * hash) + USER_SPECIFIED_SYSTEM_FIELD_NUMBER;
        hash = (53 * hash) + getUserSpecifiedSystem().hashCode();
        break;
      case 0:
      default:
    }
    switch (systemSpecCase_) {
      case 39:
        hash = (37 * hash) + SQL_DATABASE_SYSTEM_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSqlDatabaseSystemSpec().hashCode();
        break;
      case 40:
        hash = (37 * hash) + LOOKER_SYSTEM_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getLookerSystemSpec().hashCode();
        break;
      case 0:
      default:
    }
    switch (typeSpecCase_) {
      case 6:
        hash = (37 * hash) + GCS_FILESET_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getGcsFilesetSpec().hashCode();
        break;
      case 12:
        hash = (37 * hash) + BIGQUERY_TABLE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryTableSpec().hashCode();
        break;
      case 15:
        hash = (37 * hash) + BIGQUERY_DATE_SHARDED_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDateShardedSpec().hashCode();
        break;
      case 0:
      default:
    }
    switch (specCase_) {
      case 24:
        hash = (37 * hash) + DATABASE_TABLE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getDatabaseTableSpec().hashCode();
        break;
      case 27:
        hash = (37 * hash) + DATA_SOURCE_CONNECTION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getDataSourceConnectionSpec().hashCode();
        break;
      case 28:
        hash = (37 * hash) + ROUTINE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getRoutineSpec().hashCode();
        break;
      case 33:
        hash = (37 * hash) + FILESET_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getFilesetSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.Entry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.Entry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Entry metadata.
   * A Data Catalog entry represents another resource in Google
   * Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
   * outside of it. You can use the `linked_resource` field
   * in the entry resource to refer to the original resource ID of the source
   * system.
   * An entry resource contains resource details, for example, its schema.
   * Additionally, you can attach flexible metadata to an entry in the form of a
   * [Tag][google.cloud.datacatalog.v1.Tag].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.Entry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.Entry)
      com.google.cloud.datacatalog.v1.EntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_Entry_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 14:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 14:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_Entry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.Entry.class,
              com.google.cloud.datacatalog.v1.Entry.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.Entry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      linkedResource_ = "";
      fullyQualifiedName_ = "";
      if (sqlDatabaseSystemSpecBuilder_ != null) {
        sqlDatabaseSystemSpecBuilder_.clear();
      }
      if (lookerSystemSpecBuilder_ != null) {
        lookerSystemSpecBuilder_.clear();
      }
      if (gcsFilesetSpecBuilder_ != null) {
        gcsFilesetSpecBuilder_.clear();
      }
      if (bigqueryTableSpecBuilder_ != null) {
        bigqueryTableSpecBuilder_.clear();
      }
      if (bigqueryDateShardedSpecBuilder_ != null) {
        bigqueryDateShardedSpecBuilder_.clear();
      }
      if (databaseTableSpecBuilder_ != null) {
        databaseTableSpecBuilder_.clear();
      }
      if (dataSourceConnectionSpecBuilder_ != null) {
        dataSourceConnectionSpecBuilder_.clear();
      }
      if (routineSpecBuilder_ != null) {
        routineSpecBuilder_.clear();
      }
      if (filesetSpecBuilder_ != null) {
        filesetSpecBuilder_.clear();
      }
      displayName_ = "";
      description_ = "";
      businessContext_ = null;
      if (businessContextBuilder_ != null) {
        businessContextBuilder_.dispose();
        businessContextBuilder_ = null;
      }
      schema_ = null;
      if (schemaBuilder_ != null) {
        schemaBuilder_.dispose();
        schemaBuilder_ = null;
      }
      sourceSystemTimestamps_ = null;
      if (sourceSystemTimestampsBuilder_ != null) {
        sourceSystemTimestampsBuilder_.dispose();
        sourceSystemTimestampsBuilder_ = null;
      }
      usageSignal_ = null;
      if (usageSignalBuilder_ != null) {
        usageSignalBuilder_.dispose();
        usageSignalBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      dataSource_ = null;
      if (dataSourceBuilder_ != null) {
        dataSourceBuilder_.dispose();
        dataSourceBuilder_ = null;
      }
      personalDetails_ = null;
      if (personalDetailsBuilder_ != null) {
        personalDetailsBuilder_.dispose();
        personalDetailsBuilder_ = null;
      }
      entryTypeCase_ = 0;
      entryType_ = null;
      systemCase_ = 0;
      system_ = null;
      systemSpecCase_ = 0;
      systemSpec_ = null;
      typeSpecCase_ = 0;
      typeSpec_ = null;
      specCase_ = 0;
      spec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_Entry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.Entry getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.Entry build() {
      com.google.cloud.datacatalog.v1.Entry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.Entry buildPartial() {
      com.google.cloud.datacatalog.v1.Entry result =
          new com.google.cloud.datacatalog.v1.Entry(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.Entry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.linkedResource_ = linkedResource_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fullyQualifiedName_ = fullyQualifiedName_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.businessContext_ =
            businessContextBuilder_ == null ? businessContext_ : businessContextBuilder_.build();
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.schema_ = schemaBuilder_ == null ? schema_ : schemaBuilder_.build();
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.sourceSystemTimestamps_ =
            sourceSystemTimestampsBuilder_ == null
                ? sourceSystemTimestamps_
                : sourceSystemTimestampsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.usageSignal_ =
            usageSignalBuilder_ == null ? usageSignal_ : usageSignalBuilder_.build();
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.dataSource_ = dataSourceBuilder_ == null ? dataSource_ : dataSourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.personalDetails_ =
            personalDetailsBuilder_ == null ? personalDetails_ : personalDetailsBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.Entry result) {
      result.entryTypeCase_ = entryTypeCase_;
      result.entryType_ = this.entryType_;
      result.systemCase_ = systemCase_;
      result.system_ = this.system_;
      result.systemSpecCase_ = systemSpecCase_;
      result.systemSpec_ = this.systemSpec_;
      if (systemSpecCase_ == 39 && sqlDatabaseSystemSpecBuilder_ != null) {
        result.systemSpec_ = sqlDatabaseSystemSpecBuilder_.build();
      }
      if (systemSpecCase_ == 40 && lookerSystemSpecBuilder_ != null) {
        result.systemSpec_ = lookerSystemSpecBuilder_.build();
      }
      result.typeSpecCase_ = typeSpecCase_;
      result.typeSpec_ = this.typeSpec_;
      if (typeSpecCase_ == 6 && gcsFilesetSpecBuilder_ != null) {
        result.typeSpec_ = gcsFilesetSpecBuilder_.build();
      }
      if (typeSpecCase_ == 12 && bigqueryTableSpecBuilder_ != null) {
        result.typeSpec_ = bigqueryTableSpecBuilder_.build();
      }
      if (typeSpecCase_ == 15 && bigqueryDateShardedSpecBuilder_ != null) {
        result.typeSpec_ = bigqueryDateShardedSpecBuilder_.build();
      }
      result.specCase_ = specCase_;
      result.spec_ = this.spec_;
      if (specCase_ == 24 && databaseTableSpecBuilder_ != null) {
        result.spec_ = databaseTableSpecBuilder_.build();
      }
      if (specCase_ == 27 && dataSourceConnectionSpecBuilder_ != null) {
        result.spec_ = dataSourceConnectionSpecBuilder_.build();
      }
      if (specCase_ == 28 && routineSpecBuilder_ != null) {
        result.spec_ = routineSpecBuilder_.build();
      }
      if (specCase_ == 33 && filesetSpecBuilder_ != null) {
        result.spec_ = filesetSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.Entry) {
        return mergeFrom((com.google.cloud.datacatalog.v1.Entry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.Entry other) {
      if (other == com.google.cloud.datacatalog.v1.Entry.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLinkedResource().isEmpty()) {
        linkedResource_ = other.linkedResource_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFullyQualifiedName().isEmpty()) {
        fullyQualifiedName_ = other.fullyQualifiedName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasBusinessContext()) {
        mergeBusinessContext(other.getBusinessContext());
      }
      if (other.hasSchema()) {
        mergeSchema(other.getSchema());
      }
      if (other.hasSourceSystemTimestamps()) {
        mergeSourceSystemTimestamps(other.getSourceSystemTimestamps());
      }
      if (other.hasUsageSignal()) {
        mergeUsageSignal(other.getUsageSignal());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00400000;
      if (other.hasDataSource()) {
        mergeDataSource(other.getDataSource());
      }
      if (other.hasPersonalDetails()) {
        mergePersonalDetails(other.getPersonalDetails());
      }
      switch (other.getEntryTypeCase()) {
        case TYPE:
          {
            setTypeValue(other.getTypeValue());
            break;
          }
        case USER_SPECIFIED_TYPE:
          {
            entryTypeCase_ = 16;
            entryType_ = other.entryType_;
            onChanged();
            break;
          }
        case ENTRYTYPE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getSystemCase()) {
        case INTEGRATED_SYSTEM:
          {
            setIntegratedSystemValue(other.getIntegratedSystemValue());
            break;
          }
        case USER_SPECIFIED_SYSTEM:
          {
            systemCase_ = 18;
            system_ = other.system_;
            onChanged();
            break;
          }
        case SYSTEM_NOT_SET:
          {
            break;
          }
      }
      switch (other.getSystemSpecCase()) {
        case SQL_DATABASE_SYSTEM_SPEC:
          {
            mergeSqlDatabaseSystemSpec(other.getSqlDatabaseSystemSpec());
            break;
          }
        case LOOKER_SYSTEM_SPEC:
          {
            mergeLookerSystemSpec(other.getLookerSystemSpec());
            break;
          }
        case SYSTEMSPEC_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTypeSpecCase()) {
        case GCS_FILESET_SPEC:
          {
            mergeGcsFilesetSpec(other.getGcsFilesetSpec());
            break;
          }
        case BIGQUERY_TABLE_SPEC:
          {
            mergeBigqueryTableSpec(other.getBigqueryTableSpec());
            break;
          }
        case BIGQUERY_DATE_SHARDED_SPEC:
          {
            mergeBigqueryDateShardedSpec(other.getBigqueryDateShardedSpec());
            break;
          }
        case TYPESPEC_NOT_SET:
          {
            break;
          }
      }
      switch (other.getSpecCase()) {
        case DATABASE_TABLE_SPEC:
          {
            mergeDatabaseTableSpec(other.getDatabaseTableSpec());
            break;
          }
        case DATA_SOURCE_CONNECTION_SPEC:
          {
            mergeDataSourceConnectionSpec(other.getDataSourceConnectionSpec());
            break;
          }
        case ROUTINE_SPEC:
          {
            mergeRoutineSpec(other.getRoutineSpec());
            break;
          }
        case FILESET_SPEC:
          {
            mergeFilesetSpec(other.getFilesetSpec());
            break;
          }
        case SPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int rawValue = input.readEnum();
                entryTypeCase_ = 2;
                entryType_ = rawValue;
                break;
              } // case 16
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 26
            case 34:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getGcsFilesetSpecFieldBuilder().getBuilder(), extensionRegistry);
                typeSpecCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getSourceSystemTimestampsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 58
            case 74:
              {
                linkedResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 74
            case 98:
              {
                input.readMessage(
                    getBigqueryTableSpecFieldBuilder().getBuilder(), extensionRegistry);
                typeSpecCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getUsageSignalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 106
            case 114:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00400000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getBigqueryDateShardedSpecFieldBuilder().getBuilder(), extensionRegistry);
                typeSpecCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                entryTypeCase_ = 16;
                entryType_ = s;
                break;
              } // case 130
            case 136:
              {
                int rawValue = input.readEnum();
                systemCase_ = 17;
                system_ = rawValue;
                break;
              } // case 136
            case 146:
              {
                java.lang.String s = input.readStringRequireUtf8();
                systemCase_ = 18;
                system_ = s;
                break;
              } // case 146
            case 162:
              {
                input.readMessage(getDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 162
            case 194:
              {
                input.readMessage(
                    getDatabaseTableSpecFieldBuilder().getBuilder(), extensionRegistry);
                specCase_ = 24;
                break;
              } // case 194
            case 210:
              {
                input.readMessage(getPersonalDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(
                    getDataSourceConnectionSpecFieldBuilder().getBuilder(), extensionRegistry);
                specCase_ = 27;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getRoutineSpecFieldBuilder().getBuilder(), extensionRegistry);
                specCase_ = 28;
                break;
              } // case 226
            case 234:
              {
                fullyQualifiedName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 234
            case 266:
              {
                input.readMessage(getFilesetSpecFieldBuilder().getBuilder(), extensionRegistry);
                specCase_ = 33;
                break;
              } // case 266
            case 298:
              {
                input.readMessage(getBusinessContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 298
            case 314:
              {
                input.readMessage(
                    getSqlDatabaseSystemSpecFieldBuilder().getBuilder(), extensionRegistry);
                systemSpecCase_ = 39;
                break;
              } // case 314
            case 322:
              {
                input.readMessage(
                    getLookerSystemSpecFieldBuilder().getBuilder(), extensionRegistry);
                systemSpecCase_ = 40;
                break;
              } // case 322
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int entryTypeCase_ = 0;
    private java.lang.Object entryType_;

    public EntryTypeCase getEntryTypeCase() {
      return EntryTypeCase.forNumber(entryTypeCase_);
    }

    public Builder clearEntryType() {
      entryTypeCase_ = 0;
      entryType_ = null;
      onChanged();
      return this;
    }

    private int systemCase_ = 0;
    private java.lang.Object system_;

    public SystemCase getSystemCase() {
      return SystemCase.forNumber(systemCase_);
    }

    public Builder clearSystem() {
      systemCase_ = 0;
      system_ = null;
      onChanged();
      return this;
    }

    private int systemSpecCase_ = 0;
    private java.lang.Object systemSpec_;

    public SystemSpecCase getSystemSpecCase() {
      return SystemSpecCase.forNumber(systemSpecCase_);
    }

    public Builder clearSystemSpec() {
      systemSpecCase_ = 0;
      systemSpec_ = null;
      onChanged();
      return this;
    }

    private int typeSpecCase_ = 0;
    private java.lang.Object typeSpec_;

    public TypeSpecCase getTypeSpecCase() {
      return TypeSpecCase.forNumber(typeSpecCase_);
    }

    public Builder clearTypeSpec() {
      typeSpecCase_ = 0;
      typeSpec_ = null;
      onChanged();
      return this;
    }

    private int specCase_ = 0;
    private java.lang.Object spec_;

    public SpecCase getSpecCase() {
      return SpecCase.forNumber(specCase_);
    }

    public Builder clearSpec() {
      specCase_ = 0;
      spec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object linkedResource_ = "";
    /**
     *
     *
     * <pre>
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     *
     * @return The linkedResource.
     */
    public java.lang.String getLinkedResource() {
      java.lang.Object ref = linkedResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     *
     * @return The bytes for linkedResource.
     */
    public com.google.protobuf.ByteString getLinkedResourceBytes() {
      java.lang.Object ref = linkedResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     *
     * @param value The linkedResource to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkedResource_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedResource() {
      linkedResource_ = getDefaultInstance().getLinkedResource();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     *
     * @param value The bytes for linkedResource to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkedResource_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object fullyQualifiedName_ = "";
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     * </pre>
     *
     * <code>string fully_qualified_name = 29;</code>
     *
     * @return The fullyQualifiedName.
     */
    public java.lang.String getFullyQualifiedName() {
      java.lang.Object ref = fullyQualifiedName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullyQualifiedName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     * </pre>
     *
     * <code>string fully_qualified_name = 29;</code>
     *
     * @return The bytes for fullyQualifiedName.
     */
    public com.google.protobuf.ByteString getFullyQualifiedNameBytes() {
      java.lang.Object ref = fullyQualifiedName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullyQualifiedName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     * </pre>
     *
     * <code>string fully_qualified_name = 29;</code>
     *
     * @param value The fullyQualifiedName to set.
     * @return This builder for chaining.
     */
    public Builder setFullyQualifiedName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullyQualifiedName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     * </pre>
     *
     * <code>string fully_qualified_name = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullyQualifiedName() {
      fullyQualifiedName_ = getDefaultInstance().getFullyQualifiedName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     * </pre>
     *
     * <code>string fully_qualified_name = 29;</code>
     *
     * @param value The bytes for fullyQualifiedName to set.
     * @return This builder for chaining.
     */
    public Builder setFullyQualifiedNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullyQualifiedName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     *
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return entryTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      if (entryTypeCase_ == 2) {
        return ((java.lang.Integer) entryType_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      entryTypeCase_ = 2;
      entryType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.EntryType getType() {
      if (entryTypeCase_ == 2) {
        com.google.cloud.datacatalog.v1.EntryType result =
            com.google.cloud.datacatalog.v1.EntryType.forNumber((java.lang.Integer) entryType_);
        return result == null ? com.google.cloud.datacatalog.v1.EntryType.UNRECOGNIZED : result;
      }
      return com.google.cloud.datacatalog.v1.EntryType.ENTRY_TYPE_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.datacatalog.v1.EntryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entryTypeCase_ = 2;
      entryType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      if (entryTypeCase_ == 2) {
        entryTypeCase_ = 0;
        entryType_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_type = 16;</code>
     *
     * @return Whether the userSpecifiedType field is set.
     */
    @java.lang.Override
    public boolean hasUserSpecifiedType() {
      return entryTypeCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_type = 16;</code>
     *
     * @return The userSpecifiedType.
     */
    @java.lang.Override
    public java.lang.String getUserSpecifiedType() {
      java.lang.Object ref = "";
      if (entryTypeCase_ == 16) {
        ref = entryType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (entryTypeCase_ == 16) {
          entryType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_type = 16;</code>
     *
     * @return The bytes for userSpecifiedType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserSpecifiedTypeBytes() {
      java.lang.Object ref = "";
      if (entryTypeCase_ == 16) {
        ref = entryType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (entryTypeCase_ == 16) {
          entryType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_type = 16;</code>
     *
     * @param value The userSpecifiedType to set.
     * @return This builder for chaining.
     */
    public Builder setUserSpecifiedType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entryTypeCase_ = 16;
      entryType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_type = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserSpecifiedType() {
      if (entryTypeCase_ == 16) {
        entryTypeCase_ = 0;
        entryType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_type = 16;</code>
     *
     * @param value The bytes for userSpecifiedType to set.
     * @return This builder for chaining.
     */
    public Builder setUserSpecifiedTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entryTypeCase_ = 16;
      entryType_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the integratedSystem field is set.
     */
    @java.lang.Override
    public boolean hasIntegratedSystem() {
      return systemCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for integratedSystem.
     */
    @java.lang.Override
    public int getIntegratedSystemValue() {
      if (systemCase_ == 17) {
        return ((java.lang.Integer) system_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for integratedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setIntegratedSystemValue(int value) {
      systemCase_ = 17;
      system_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The integratedSystem.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.IntegratedSystem getIntegratedSystem() {
      if (systemCase_ == 17) {
        com.google.cloud.datacatalog.v1.IntegratedSystem result =
            com.google.cloud.datacatalog.v1.IntegratedSystem.forNumber((java.lang.Integer) system_);
        return result == null
            ? com.google.cloud.datacatalog.v1.IntegratedSystem.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.datacatalog.v1.IntegratedSystem.INTEGRATED_SYSTEM_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The integratedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setIntegratedSystem(com.google.cloud.datacatalog.v1.IntegratedSystem value) {
      if (value == null) {
        throw new NullPointerException();
      }
      systemCase_ = 17;
      system_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntegratedSystem() {
      if (systemCase_ == 17) {
        systemCase_ = 0;
        system_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_system = 18;</code>
     *
     * @return Whether the userSpecifiedSystem field is set.
     */
    @java.lang.Override
    public boolean hasUserSpecifiedSystem() {
      return systemCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_system = 18;</code>
     *
     * @return The userSpecifiedSystem.
     */
    @java.lang.Override
    public java.lang.String getUserSpecifiedSystem() {
      java.lang.Object ref = "";
      if (systemCase_ == 18) {
        ref = system_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (systemCase_ == 18) {
          system_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_system = 18;</code>
     *
     * @return The bytes for userSpecifiedSystem.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserSpecifiedSystemBytes() {
      java.lang.Object ref = "";
      if (systemCase_ == 18) {
        ref = system_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (systemCase_ == 18) {
          system_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_system = 18;</code>
     *
     * @param value The userSpecifiedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setUserSpecifiedSystem(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      systemCase_ = 18;
      system_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_system = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserSpecifiedSystem() {
      if (systemCase_ == 18) {
        systemCase_ = 0;
        system_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     * </pre>
     *
     * <code>string user_specified_system = 18;</code>
     *
     * @param value The bytes for userSpecifiedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setUserSpecifiedSystemBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      systemCase_ = 18;
      system_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec,
            com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.Builder,
            com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpecOrBuilder>
        sqlDatabaseSystemSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     *
     * @return Whether the sqlDatabaseSystemSpec field is set.
     */
    @java.lang.Override
    public boolean hasSqlDatabaseSystemSpec() {
      return systemSpecCase_ == 39;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     *
     * @return The sqlDatabaseSystemSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec getSqlDatabaseSystemSpec() {
      if (sqlDatabaseSystemSpecBuilder_ == null) {
        if (systemSpecCase_ == 39) {
          return (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance();
      } else {
        if (systemSpecCase_ == 39) {
          return sqlDatabaseSystemSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    public Builder setSqlDatabaseSystemSpec(
        com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec value) {
      if (sqlDatabaseSystemSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemSpec_ = value;
        onChanged();
      } else {
        sqlDatabaseSystemSpecBuilder_.setMessage(value);
      }
      systemSpecCase_ = 39;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    public Builder setSqlDatabaseSystemSpec(
        com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.Builder builderForValue) {
      if (sqlDatabaseSystemSpecBuilder_ == null) {
        systemSpec_ = builderForValue.build();
        onChanged();
      } else {
        sqlDatabaseSystemSpecBuilder_.setMessage(builderForValue.build());
      }
      systemSpecCase_ = 39;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    public Builder mergeSqlDatabaseSystemSpec(
        com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec value) {
      if (sqlDatabaseSystemSpecBuilder_ == null) {
        if (systemSpecCase_ == 39
            && systemSpec_
                != com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance()) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          systemSpec_ = value;
        }
        onChanged();
      } else {
        if (systemSpecCase_ == 39) {
          sqlDatabaseSystemSpecBuilder_.mergeFrom(value);
        } else {
          sqlDatabaseSystemSpecBuilder_.setMessage(value);
        }
      }
      systemSpecCase_ = 39;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    public Builder clearSqlDatabaseSystemSpec() {
      if (sqlDatabaseSystemSpecBuilder_ == null) {
        if (systemSpecCase_ == 39) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
          onChanged();
        }
      } else {
        if (systemSpecCase_ == 39) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
        }
        sqlDatabaseSystemSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.Builder
        getSqlDatabaseSystemSpecBuilder() {
      return getSqlDatabaseSystemSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpecOrBuilder
        getSqlDatabaseSystemSpecOrBuilder() {
      if ((systemSpecCase_ == 39) && (sqlDatabaseSystemSpecBuilder_ != null)) {
        return sqlDatabaseSystemSpecBuilder_.getMessageOrBuilder();
      } else {
        if (systemSpecCase_ == 39) {
          return (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec,
            com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.Builder,
            com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpecOrBuilder>
        getSqlDatabaseSystemSpecFieldBuilder() {
      if (sqlDatabaseSystemSpecBuilder_ == null) {
        if (!(systemSpecCase_ == 39)) {
          systemSpec_ = com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.getDefaultInstance();
        }
        sqlDatabaseSystemSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec,
                com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec.Builder,
                com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec) systemSpec_,
                getParentForChildren(),
                isClean());
        systemSpec_ = null;
      }
      systemSpecCase_ = 39;
      onChanged();
      return sqlDatabaseSystemSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.LookerSystemSpec,
            com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder,
            com.google.cloud.datacatalog.v1.LookerSystemSpecOrBuilder>
        lookerSystemSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     *
     * @return Whether the lookerSystemSpec field is set.
     */
    @java.lang.Override
    public boolean hasLookerSystemSpec() {
      return systemSpecCase_ == 40;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     *
     * @return The lookerSystemSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.LookerSystemSpec getLookerSystemSpec() {
      if (lookerSystemSpecBuilder_ == null) {
        if (systemSpecCase_ == 40) {
          return (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
      } else {
        if (systemSpecCase_ == 40) {
          return lookerSystemSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    public Builder setLookerSystemSpec(com.google.cloud.datacatalog.v1.LookerSystemSpec value) {
      if (lookerSystemSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemSpec_ = value;
        onChanged();
      } else {
        lookerSystemSpecBuilder_.setMessage(value);
      }
      systemSpecCase_ = 40;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    public Builder setLookerSystemSpec(
        com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder builderForValue) {
      if (lookerSystemSpecBuilder_ == null) {
        systemSpec_ = builderForValue.build();
        onChanged();
      } else {
        lookerSystemSpecBuilder_.setMessage(builderForValue.build());
      }
      systemSpecCase_ = 40;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    public Builder mergeLookerSystemSpec(com.google.cloud.datacatalog.v1.LookerSystemSpec value) {
      if (lookerSystemSpecBuilder_ == null) {
        if (systemSpecCase_ == 40
            && systemSpec_
                != com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance()) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.LookerSystemSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          systemSpec_ = value;
        }
        onChanged();
      } else {
        if (systemSpecCase_ == 40) {
          lookerSystemSpecBuilder_.mergeFrom(value);
        } else {
          lookerSystemSpecBuilder_.setMessage(value);
        }
      }
      systemSpecCase_ = 40;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    public Builder clearLookerSystemSpec() {
      if (lookerSystemSpecBuilder_ == null) {
        if (systemSpecCase_ == 40) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
          onChanged();
        }
      } else {
        if (systemSpecCase_ == 40) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
        }
        lookerSystemSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    public com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder getLookerSystemSpecBuilder() {
      return getLookerSystemSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.LookerSystemSpecOrBuilder
        getLookerSystemSpecOrBuilder() {
      if ((systemSpecCase_ == 40) && (lookerSystemSpecBuilder_ != null)) {
        return lookerSystemSpecBuilder_.getMessageOrBuilder();
      } else {
        if (systemSpecCase_ == 40) {
          return (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.LookerSystemSpec,
            com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder,
            com.google.cloud.datacatalog.v1.LookerSystemSpecOrBuilder>
        getLookerSystemSpecFieldBuilder() {
      if (lookerSystemSpecBuilder_ == null) {
        if (!(systemSpecCase_ == 40)) {
          systemSpec_ = com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
        }
        lookerSystemSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.LookerSystemSpec,
                com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder,
                com.google.cloud.datacatalog.v1.LookerSystemSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.LookerSystemSpec) systemSpec_,
                getParentForChildren(),
                isClean());
        systemSpec_ = null;
      }
      systemSpecCase_ = 40;
      onChanged();
      return lookerSystemSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.GcsFilesetSpec,
            com.google.cloud.datacatalog.v1.GcsFilesetSpec.Builder,
            com.google.cloud.datacatalog.v1.GcsFilesetSpecOrBuilder>
        gcsFilesetSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     *
     * @return Whether the gcsFilesetSpec field is set.
     */
    @java.lang.Override
    public boolean hasGcsFilesetSpec() {
      return typeSpecCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     *
     * @return The gcsFilesetSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.GcsFilesetSpec getGcsFilesetSpec() {
      if (gcsFilesetSpecBuilder_ == null) {
        if (typeSpecCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 6) {
          return gcsFilesetSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder setGcsFilesetSpec(com.google.cloud.datacatalog.v1.GcsFilesetSpec value) {
      if (gcsFilesetSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        gcsFilesetSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder setGcsFilesetSpec(
        com.google.cloud.datacatalog.v1.GcsFilesetSpec.Builder builderForValue) {
      if (gcsFilesetSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        gcsFilesetSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder mergeGcsFilesetSpec(com.google.cloud.datacatalog.v1.GcsFilesetSpec value) {
      if (gcsFilesetSpecBuilder_ == null) {
        if (typeSpecCase_ == 6
            && typeSpec_ != com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.v1.GcsFilesetSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 6) {
          gcsFilesetSpecBuilder_.mergeFrom(value);
        } else {
          gcsFilesetSpecBuilder_.setMessage(value);
        }
      }
      typeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder clearGcsFilesetSpec() {
      if (gcsFilesetSpecBuilder_ == null) {
        if (typeSpecCase_ == 6) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 6) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        gcsFilesetSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public com.google.cloud.datacatalog.v1.GcsFilesetSpec.Builder getGcsFilesetSpecBuilder() {
      return getGcsFilesetSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.GcsFilesetSpecOrBuilder getGcsFilesetSpecOrBuilder() {
      if ((typeSpecCase_ == 6) && (gcsFilesetSpecBuilder_ != null)) {
        return gcsFilesetSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.GcsFilesetSpec,
            com.google.cloud.datacatalog.v1.GcsFilesetSpec.Builder,
            com.google.cloud.datacatalog.v1.GcsFilesetSpecOrBuilder>
        getGcsFilesetSpecFieldBuilder() {
      if (gcsFilesetSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 6)) {
          typeSpec_ = com.google.cloud.datacatalog.v1.GcsFilesetSpec.getDefaultInstance();
        }
        gcsFilesetSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.GcsFilesetSpec,
                com.google.cloud.datacatalog.v1.GcsFilesetSpec.Builder,
                com.google.cloud.datacatalog.v1.GcsFilesetSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.GcsFilesetSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 6;
      onChanged();
      return gcsFilesetSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BigQueryTableSpec,
            com.google.cloud.datacatalog.v1.BigQueryTableSpec.Builder,
            com.google.cloud.datacatalog.v1.BigQueryTableSpecOrBuilder>
        bigqueryTableSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the bigqueryTableSpec field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryTableSpec() {
      return typeSpecCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bigqueryTableSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.BigQueryTableSpec getBigqueryTableSpec() {
      if (bigqueryTableSpecBuilder_ == null) {
        if (typeSpecCase_ == 12) {
          return (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 12) {
          return bigqueryTableSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryTableSpec(com.google.cloud.datacatalog.v1.BigQueryTableSpec value) {
      if (bigqueryTableSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        bigqueryTableSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryTableSpec(
        com.google.cloud.datacatalog.v1.BigQueryTableSpec.Builder builderForValue) {
      if (bigqueryTableSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryTableSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeBigqueryTableSpec(com.google.cloud.datacatalog.v1.BigQueryTableSpec value) {
      if (bigqueryTableSpecBuilder_ == null) {
        if (typeSpecCase_ == 12
            && typeSpec_
                != com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.v1.BigQueryTableSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 12) {
          bigqueryTableSpecBuilder_.mergeFrom(value);
        } else {
          bigqueryTableSpecBuilder_.setMessage(value);
        }
      }
      typeSpecCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBigqueryTableSpec() {
      if (bigqueryTableSpecBuilder_ == null) {
        if (typeSpecCase_ == 12) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 12) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        bigqueryTableSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.BigQueryTableSpec.Builder getBigqueryTableSpecBuilder() {
      return getBigqueryTableSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.BigQueryTableSpecOrBuilder
        getBigqueryTableSpecOrBuilder() {
      if ((typeSpecCase_ == 12) && (bigqueryTableSpecBuilder_ != null)) {
        return bigqueryTableSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 12) {
          return (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BigQueryTableSpec,
            com.google.cloud.datacatalog.v1.BigQueryTableSpec.Builder,
            com.google.cloud.datacatalog.v1.BigQueryTableSpecOrBuilder>
        getBigqueryTableSpecFieldBuilder() {
      if (bigqueryTableSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 12)) {
          typeSpec_ = com.google.cloud.datacatalog.v1.BigQueryTableSpec.getDefaultInstance();
        }
        bigqueryTableSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.BigQueryTableSpec,
                com.google.cloud.datacatalog.v1.BigQueryTableSpec.Builder,
                com.google.cloud.datacatalog.v1.BigQueryTableSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.BigQueryTableSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 12;
      onChanged();
      return bigqueryTableSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec,
            com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.Builder,
            com.google.cloud.datacatalog.v1.BigQueryDateShardedSpecOrBuilder>
        bigqueryDateShardedSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the bigqueryDateShardedSpec field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDateShardedSpec() {
      return typeSpecCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bigqueryDateShardedSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec getBigqueryDateShardedSpec() {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (typeSpecCase_ == 15) {
          return (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 15) {
          return bigqueryDateShardedSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryDateShardedSpec(
        com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec value) {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        bigqueryDateShardedSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBigqueryDateShardedSpec(
        com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.Builder builderForValue) {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDateShardedSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeBigqueryDateShardedSpec(
        com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec value) {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (typeSpecCase_ == 15
            && typeSpec_
                != com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 15) {
          bigqueryDateShardedSpecBuilder_.mergeFrom(value);
        } else {
          bigqueryDateShardedSpecBuilder_.setMessage(value);
        }
      }
      typeSpecCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBigqueryDateShardedSpec() {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (typeSpecCase_ == 15) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 15) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        bigqueryDateShardedSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.Builder
        getBigqueryDateShardedSpecBuilder() {
      return getBigqueryDateShardedSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.BigQueryDateShardedSpecOrBuilder
        getBigqueryDateShardedSpecOrBuilder() {
      if ((typeSpecCase_ == 15) && (bigqueryDateShardedSpecBuilder_ != null)) {
        return bigqueryDateShardedSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 15) {
          return (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec,
            com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.Builder,
            com.google.cloud.datacatalog.v1.BigQueryDateShardedSpecOrBuilder>
        getBigqueryDateShardedSpecFieldBuilder() {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 15)) {
          typeSpec_ = com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.getDefaultInstance();
        }
        bigqueryDateShardedSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec,
                com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec.Builder,
                com.google.cloud.datacatalog.v1.BigQueryDateShardedSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.BigQueryDateShardedSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 15;
      onChanged();
      return bigqueryDateShardedSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DatabaseTableSpec,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder,
            com.google.cloud.datacatalog.v1.DatabaseTableSpecOrBuilder>
        databaseTableSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     *
     * @return Whether the databaseTableSpec field is set.
     */
    @java.lang.Override
    public boolean hasDatabaseTableSpec() {
      return specCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     *
     * @return The databaseTableSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec getDatabaseTableSpec() {
      if (databaseTableSpecBuilder_ == null) {
        if (specCase_ == 24) {
          return (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
      } else {
        if (specCase_ == 24) {
          return databaseTableSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    public Builder setDatabaseTableSpec(com.google.cloud.datacatalog.v1.DatabaseTableSpec value) {
      if (databaseTableSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
        onChanged();
      } else {
        databaseTableSpecBuilder_.setMessage(value);
      }
      specCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    public Builder setDatabaseTableSpec(
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder builderForValue) {
      if (databaseTableSpecBuilder_ == null) {
        spec_ = builderForValue.build();
        onChanged();
      } else {
        databaseTableSpecBuilder_.setMessage(builderForValue.build());
      }
      specCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    public Builder mergeDatabaseTableSpec(com.google.cloud.datacatalog.v1.DatabaseTableSpec value) {
      if (databaseTableSpecBuilder_ == null) {
        if (specCase_ == 24
            && spec_ != com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance()) {
          spec_ =
              com.google.cloud.datacatalog.v1.DatabaseTableSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          spec_ = value;
        }
        onChanged();
      } else {
        if (specCase_ == 24) {
          databaseTableSpecBuilder_.mergeFrom(value);
        } else {
          databaseTableSpecBuilder_.setMessage(value);
        }
      }
      specCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    public Builder clearDatabaseTableSpec() {
      if (databaseTableSpecBuilder_ == null) {
        if (specCase_ == 24) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
      } else {
        if (specCase_ == 24) {
          specCase_ = 0;
          spec_ = null;
        }
        databaseTableSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder getDatabaseTableSpecBuilder() {
      return getDatabaseTableSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpecOrBuilder
        getDatabaseTableSpecOrBuilder() {
      if ((specCase_ == 24) && (databaseTableSpecBuilder_ != null)) {
        return databaseTableSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specCase_ == 24) {
          return (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DatabaseTableSpec,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder,
            com.google.cloud.datacatalog.v1.DatabaseTableSpecOrBuilder>
        getDatabaseTableSpecFieldBuilder() {
      if (databaseTableSpecBuilder_ == null) {
        if (!(specCase_ == 24)) {
          spec_ = com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
        }
        databaseTableSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DatabaseTableSpec,
                com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder,
                com.google.cloud.datacatalog.v1.DatabaseTableSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.DatabaseTableSpec) spec_,
                getParentForChildren(),
                isClean());
        spec_ = null;
      }
      specCase_ = 24;
      onChanged();
      return databaseTableSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataSourceConnectionSpec,
            com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.Builder,
            com.google.cloud.datacatalog.v1.DataSourceConnectionSpecOrBuilder>
        dataSourceConnectionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     *
     * @return Whether the dataSourceConnectionSpec field is set.
     */
    @java.lang.Override
    public boolean hasDataSourceConnectionSpec() {
      return specCase_ == 27;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     *
     * @return The dataSourceConnectionSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DataSourceConnectionSpec getDataSourceConnectionSpec() {
      if (dataSourceConnectionSpecBuilder_ == null) {
        if (specCase_ == 27) {
          return (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance();
      } else {
        if (specCase_ == 27) {
          return dataSourceConnectionSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    public Builder setDataSourceConnectionSpec(
        com.google.cloud.datacatalog.v1.DataSourceConnectionSpec value) {
      if (dataSourceConnectionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
        onChanged();
      } else {
        dataSourceConnectionSpecBuilder_.setMessage(value);
      }
      specCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    public Builder setDataSourceConnectionSpec(
        com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.Builder builderForValue) {
      if (dataSourceConnectionSpecBuilder_ == null) {
        spec_ = builderForValue.build();
        onChanged();
      } else {
        dataSourceConnectionSpecBuilder_.setMessage(builderForValue.build());
      }
      specCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    public Builder mergeDataSourceConnectionSpec(
        com.google.cloud.datacatalog.v1.DataSourceConnectionSpec value) {
      if (dataSourceConnectionSpecBuilder_ == null) {
        if (specCase_ == 27
            && spec_
                != com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance()) {
          spec_ =
              com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          spec_ = value;
        }
        onChanged();
      } else {
        if (specCase_ == 27) {
          dataSourceConnectionSpecBuilder_.mergeFrom(value);
        } else {
          dataSourceConnectionSpecBuilder_.setMessage(value);
        }
      }
      specCase_ = 27;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    public Builder clearDataSourceConnectionSpec() {
      if (dataSourceConnectionSpecBuilder_ == null) {
        if (specCase_ == 27) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
      } else {
        if (specCase_ == 27) {
          specCase_ = 0;
          spec_ = null;
        }
        dataSourceConnectionSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.Builder
        getDataSourceConnectionSpecBuilder() {
      return getDataSourceConnectionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DataSourceConnectionSpecOrBuilder
        getDataSourceConnectionSpecOrBuilder() {
      if ((specCase_ == 27) && (dataSourceConnectionSpecBuilder_ != null)) {
        return dataSourceConnectionSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specCase_ == 27) {
          return (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataSourceConnectionSpec,
            com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.Builder,
            com.google.cloud.datacatalog.v1.DataSourceConnectionSpecOrBuilder>
        getDataSourceConnectionSpecFieldBuilder() {
      if (dataSourceConnectionSpecBuilder_ == null) {
        if (!(specCase_ == 27)) {
          spec_ = com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.getDefaultInstance();
        }
        dataSourceConnectionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DataSourceConnectionSpec,
                com.google.cloud.datacatalog.v1.DataSourceConnectionSpec.Builder,
                com.google.cloud.datacatalog.v1.DataSourceConnectionSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.DataSourceConnectionSpec) spec_,
                getParentForChildren(),
                isClean());
        spec_ = null;
      }
      specCase_ = 27;
      onChanged();
      return dataSourceConnectionSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.RoutineSpec,
            com.google.cloud.datacatalog.v1.RoutineSpec.Builder,
            com.google.cloud.datacatalog.v1.RoutineSpecOrBuilder>
        routineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     *
     * @return Whether the routineSpec field is set.
     */
    @java.lang.Override
    public boolean hasRoutineSpec() {
      return specCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     *
     * @return The routineSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec getRoutineSpec() {
      if (routineSpecBuilder_ == null) {
        if (specCase_ == 28) {
          return (com.google.cloud.datacatalog.v1.RoutineSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
      } else {
        if (specCase_ == 28) {
          return routineSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    public Builder setRoutineSpec(com.google.cloud.datacatalog.v1.RoutineSpec value) {
      if (routineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
        onChanged();
      } else {
        routineSpecBuilder_.setMessage(value);
      }
      specCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    public Builder setRoutineSpec(
        com.google.cloud.datacatalog.v1.RoutineSpec.Builder builderForValue) {
      if (routineSpecBuilder_ == null) {
        spec_ = builderForValue.build();
        onChanged();
      } else {
        routineSpecBuilder_.setMessage(builderForValue.build());
      }
      specCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    public Builder mergeRoutineSpec(com.google.cloud.datacatalog.v1.RoutineSpec value) {
      if (routineSpecBuilder_ == null) {
        if (specCase_ == 28
            && spec_ != com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance()) {
          spec_ =
              com.google.cloud.datacatalog.v1.RoutineSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.RoutineSpec) spec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          spec_ = value;
        }
        onChanged();
      } else {
        if (specCase_ == 28) {
          routineSpecBuilder_.mergeFrom(value);
        } else {
          routineSpecBuilder_.setMessage(value);
        }
      }
      specCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    public Builder clearRoutineSpec() {
      if (routineSpecBuilder_ == null) {
        if (specCase_ == 28) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
      } else {
        if (specCase_ == 28) {
          specCase_ = 0;
          spec_ = null;
        }
        routineSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    public com.google.cloud.datacatalog.v1.RoutineSpec.Builder getRoutineSpecBuilder() {
      return getRoutineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpecOrBuilder getRoutineSpecOrBuilder() {
      if ((specCase_ == 28) && (routineSpecBuilder_ != null)) {
        return routineSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specCase_ == 28) {
          return (com.google.cloud.datacatalog.v1.RoutineSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.RoutineSpec,
            com.google.cloud.datacatalog.v1.RoutineSpec.Builder,
            com.google.cloud.datacatalog.v1.RoutineSpecOrBuilder>
        getRoutineSpecFieldBuilder() {
      if (routineSpecBuilder_ == null) {
        if (!(specCase_ == 28)) {
          spec_ = com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
        }
        routineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.RoutineSpec,
                com.google.cloud.datacatalog.v1.RoutineSpec.Builder,
                com.google.cloud.datacatalog.v1.RoutineSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.RoutineSpec) spec_,
                getParentForChildren(),
                isClean());
        spec_ = null;
      }
      specCase_ = 28;
      onChanged();
      return routineSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.FilesetSpec,
            com.google.cloud.datacatalog.v1.FilesetSpec.Builder,
            com.google.cloud.datacatalog.v1.FilesetSpecOrBuilder>
        filesetSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     *
     * @return Whether the filesetSpec field is set.
     */
    @java.lang.Override
    public boolean hasFilesetSpec() {
      return specCase_ == 33;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     *
     * @return The filesetSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.FilesetSpec getFilesetSpec() {
      if (filesetSpecBuilder_ == null) {
        if (specCase_ == 33) {
          return (com.google.cloud.datacatalog.v1.FilesetSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance();
      } else {
        if (specCase_ == 33) {
          return filesetSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    public Builder setFilesetSpec(com.google.cloud.datacatalog.v1.FilesetSpec value) {
      if (filesetSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spec_ = value;
        onChanged();
      } else {
        filesetSpecBuilder_.setMessage(value);
      }
      specCase_ = 33;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    public Builder setFilesetSpec(
        com.google.cloud.datacatalog.v1.FilesetSpec.Builder builderForValue) {
      if (filesetSpecBuilder_ == null) {
        spec_ = builderForValue.build();
        onChanged();
      } else {
        filesetSpecBuilder_.setMessage(builderForValue.build());
      }
      specCase_ = 33;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    public Builder mergeFilesetSpec(com.google.cloud.datacatalog.v1.FilesetSpec value) {
      if (filesetSpecBuilder_ == null) {
        if (specCase_ == 33
            && spec_ != com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance()) {
          spec_ =
              com.google.cloud.datacatalog.v1.FilesetSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.FilesetSpec) spec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          spec_ = value;
        }
        onChanged();
      } else {
        if (specCase_ == 33) {
          filesetSpecBuilder_.mergeFrom(value);
        } else {
          filesetSpecBuilder_.setMessage(value);
        }
      }
      specCase_ = 33;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    public Builder clearFilesetSpec() {
      if (filesetSpecBuilder_ == null) {
        if (specCase_ == 33) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
      } else {
        if (specCase_ == 33) {
          specCase_ = 0;
          spec_ = null;
        }
        filesetSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    public com.google.cloud.datacatalog.v1.FilesetSpec.Builder getFilesetSpecBuilder() {
      return getFilesetSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.FilesetSpecOrBuilder getFilesetSpecOrBuilder() {
      if ((specCase_ == 33) && (filesetSpecBuilder_ != null)) {
        return filesetSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specCase_ == 33) {
          return (com.google.cloud.datacatalog.v1.FilesetSpec) spec_;
        }
        return com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.FilesetSpec,
            com.google.cloud.datacatalog.v1.FilesetSpec.Builder,
            com.google.cloud.datacatalog.v1.FilesetSpecOrBuilder>
        getFilesetSpecFieldBuilder() {
      if (filesetSpecBuilder_ == null) {
        if (!(specCase_ == 33)) {
          spec_ = com.google.cloud.datacatalog.v1.FilesetSpec.getDefaultInstance();
        }
        filesetSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.FilesetSpec,
                com.google.cloud.datacatalog.v1.FilesetSpec.Builder,
                com.google.cloud.datacatalog.v1.FilesetSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.FilesetSpec) spec_,
                getParentForChildren(),
                isClean());
        spec_ = null;
      }
      specCase_ = 33;
      onChanged();
      return filesetSpecBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.cloud.datacatalog.v1.BusinessContext businessContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BusinessContext,
            com.google.cloud.datacatalog.v1.BusinessContext.Builder,
            com.google.cloud.datacatalog.v1.BusinessContextOrBuilder>
        businessContextBuilder_;
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     *
     * @return Whether the businessContext field is set.
     */
    public boolean hasBusinessContext() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     *
     * @return The businessContext.
     */
    public com.google.cloud.datacatalog.v1.BusinessContext getBusinessContext() {
      if (businessContextBuilder_ == null) {
        return businessContext_ == null
            ? com.google.cloud.datacatalog.v1.BusinessContext.getDefaultInstance()
            : businessContext_;
      } else {
        return businessContextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    public Builder setBusinessContext(com.google.cloud.datacatalog.v1.BusinessContext value) {
      if (businessContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        businessContext_ = value;
      } else {
        businessContextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    public Builder setBusinessContext(
        com.google.cloud.datacatalog.v1.BusinessContext.Builder builderForValue) {
      if (businessContextBuilder_ == null) {
        businessContext_ = builderForValue.build();
      } else {
        businessContextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    public Builder mergeBusinessContext(com.google.cloud.datacatalog.v1.BusinessContext value) {
      if (businessContextBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && businessContext_ != null
            && businessContext_
                != com.google.cloud.datacatalog.v1.BusinessContext.getDefaultInstance()) {
          getBusinessContextBuilder().mergeFrom(value);
        } else {
          businessContext_ = value;
        }
      } else {
        businessContextBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    public Builder clearBusinessContext() {
      bitField0_ = (bitField0_ & ~0x00040000);
      businessContext_ = null;
      if (businessContextBuilder_ != null) {
        businessContextBuilder_.dispose();
        businessContextBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    public com.google.cloud.datacatalog.v1.BusinessContext.Builder getBusinessContextBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getBusinessContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    public com.google.cloud.datacatalog.v1.BusinessContextOrBuilder getBusinessContextOrBuilder() {
      if (businessContextBuilder_ != null) {
        return businessContextBuilder_.getMessageOrBuilder();
      } else {
        return businessContext_ == null
            ? com.google.cloud.datacatalog.v1.BusinessContext.getDefaultInstance()
            : businessContext_;
      }
    }
    /**
     *
     *
     * <pre>
     * Business Context of the entry. Not supported for BigQuery datasets
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BusinessContext,
            com.google.cloud.datacatalog.v1.BusinessContext.Builder,
            com.google.cloud.datacatalog.v1.BusinessContextOrBuilder>
        getBusinessContextFieldBuilder() {
      if (businessContextBuilder_ == null) {
        businessContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.BusinessContext,
                com.google.cloud.datacatalog.v1.BusinessContext.Builder,
                com.google.cloud.datacatalog.v1.BusinessContextOrBuilder>(
                getBusinessContext(), getParentForChildren(), isClean());
        businessContext_ = null;
      }
      return businessContextBuilder_;
    }

    private com.google.cloud.datacatalog.v1.Schema schema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Schema,
            com.google.cloud.datacatalog.v1.Schema.Builder,
            com.google.cloud.datacatalog.v1.SchemaOrBuilder>
        schemaBuilder_;
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     *
     * @return Whether the schema field is set.
     */
    public boolean hasSchema() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     *
     * @return The schema.
     */
    public com.google.cloud.datacatalog.v1.Schema getSchema() {
      if (schemaBuilder_ == null) {
        return schema_ == null
            ? com.google.cloud.datacatalog.v1.Schema.getDefaultInstance()
            : schema_;
      } else {
        return schemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    public Builder setSchema(com.google.cloud.datacatalog.v1.Schema value) {
      if (schemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
      } else {
        schemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    public Builder setSchema(com.google.cloud.datacatalog.v1.Schema.Builder builderForValue) {
      if (schemaBuilder_ == null) {
        schema_ = builderForValue.build();
      } else {
        schemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    public Builder mergeSchema(com.google.cloud.datacatalog.v1.Schema value) {
      if (schemaBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && schema_ != null
            && schema_ != com.google.cloud.datacatalog.v1.Schema.getDefaultInstance()) {
          getSchemaBuilder().mergeFrom(value);
        } else {
          schema_ = value;
        }
      } else {
        schemaBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    public Builder clearSchema() {
      bitField0_ = (bitField0_ & ~0x00080000);
      schema_ = null;
      if (schemaBuilder_ != null) {
        schemaBuilder_.dispose();
        schemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    public com.google.cloud.datacatalog.v1.Schema.Builder getSchemaBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    public com.google.cloud.datacatalog.v1.SchemaOrBuilder getSchemaOrBuilder() {
      if (schemaBuilder_ != null) {
        return schemaBuilder_.getMessageOrBuilder();
      } else {
        return schema_ == null
            ? com.google.cloud.datacatalog.v1.Schema.getDefaultInstance()
            : schema_;
      }
    }
    /**
     *
     *
     * <pre>
     * Schema of the entry. An entry might not have any schema attached to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Schema,
            com.google.cloud.datacatalog.v1.Schema.Builder,
            com.google.cloud.datacatalog.v1.SchemaOrBuilder>
        getSchemaFieldBuilder() {
      if (schemaBuilder_ == null) {
        schemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.Schema,
                com.google.cloud.datacatalog.v1.Schema.Builder,
                com.google.cloud.datacatalog.v1.SchemaOrBuilder>(
                getSchema(), getParentForChildren(), isClean());
        schema_ = null;
      }
      return schemaBuilder_;
    }

    private com.google.cloud.datacatalog.v1.SystemTimestamps sourceSystemTimestamps_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.SystemTimestamps,
            com.google.cloud.datacatalog.v1.SystemTimestamps.Builder,
            com.google.cloud.datacatalog.v1.SystemTimestampsOrBuilder>
        sourceSystemTimestampsBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     *
     * @return Whether the sourceSystemTimestamps field is set.
     */
    public boolean hasSourceSystemTimestamps() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     *
     * @return The sourceSystemTimestamps.
     */
    public com.google.cloud.datacatalog.v1.SystemTimestamps getSourceSystemTimestamps() {
      if (sourceSystemTimestampsBuilder_ == null) {
        return sourceSystemTimestamps_ == null
            ? com.google.cloud.datacatalog.v1.SystemTimestamps.getDefaultInstance()
            : sourceSystemTimestamps_;
      } else {
        return sourceSystemTimestampsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder setSourceSystemTimestamps(
        com.google.cloud.datacatalog.v1.SystemTimestamps value) {
      if (sourceSystemTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceSystemTimestamps_ = value;
      } else {
        sourceSystemTimestampsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder setSourceSystemTimestamps(
        com.google.cloud.datacatalog.v1.SystemTimestamps.Builder builderForValue) {
      if (sourceSystemTimestampsBuilder_ == null) {
        sourceSystemTimestamps_ = builderForValue.build();
      } else {
        sourceSystemTimestampsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder mergeSourceSystemTimestamps(
        com.google.cloud.datacatalog.v1.SystemTimestamps value) {
      if (sourceSystemTimestampsBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && sourceSystemTimestamps_ != null
            && sourceSystemTimestamps_
                != com.google.cloud.datacatalog.v1.SystemTimestamps.getDefaultInstance()) {
          getSourceSystemTimestampsBuilder().mergeFrom(value);
        } else {
          sourceSystemTimestamps_ = value;
        }
      } else {
        sourceSystemTimestampsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder clearSourceSystemTimestamps() {
      bitField0_ = (bitField0_ & ~0x00100000);
      sourceSystemTimestamps_ = null;
      if (sourceSystemTimestampsBuilder_ != null) {
        sourceSystemTimestampsBuilder_.dispose();
        sourceSystemTimestampsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public com.google.cloud.datacatalog.v1.SystemTimestamps.Builder
        getSourceSystemTimestampsBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getSourceSystemTimestampsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public com.google.cloud.datacatalog.v1.SystemTimestampsOrBuilder
        getSourceSystemTimestampsOrBuilder() {
      if (sourceSystemTimestampsBuilder_ != null) {
        return sourceSystemTimestampsBuilder_.getMessageOrBuilder();
      } else {
        return sourceSystemTimestamps_ == null
            ? com.google.cloud.datacatalog.v1.SystemTimestamps.getDefaultInstance()
            : sourceSystemTimestamps_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.SystemTimestamps,
            com.google.cloud.datacatalog.v1.SystemTimestamps.Builder,
            com.google.cloud.datacatalog.v1.SystemTimestampsOrBuilder>
        getSourceSystemTimestampsFieldBuilder() {
      if (sourceSystemTimestampsBuilder_ == null) {
        sourceSystemTimestampsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.SystemTimestamps,
                com.google.cloud.datacatalog.v1.SystemTimestamps.Builder,
                com.google.cloud.datacatalog.v1.SystemTimestampsOrBuilder>(
                getSourceSystemTimestamps(), getParentForChildren(), isClean());
        sourceSystemTimestamps_ = null;
      }
      return sourceSystemTimestampsBuilder_;
    }

    private com.google.cloud.datacatalog.v1.UsageSignal usageSignal_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.UsageSignal,
            com.google.cloud.datacatalog.v1.UsageSignal.Builder,
            com.google.cloud.datacatalog.v1.UsageSignalOrBuilder>
        usageSignalBuilder_;
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     *
     * @return Whether the usageSignal field is set.
     */
    public boolean hasUsageSignal() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     *
     * @return The usageSignal.
     */
    public com.google.cloud.datacatalog.v1.UsageSignal getUsageSignal() {
      if (usageSignalBuilder_ == null) {
        return usageSignal_ == null
            ? com.google.cloud.datacatalog.v1.UsageSignal.getDefaultInstance()
            : usageSignal_;
      } else {
        return usageSignalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    public Builder setUsageSignal(com.google.cloud.datacatalog.v1.UsageSignal value) {
      if (usageSignalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usageSignal_ = value;
      } else {
        usageSignalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    public Builder setUsageSignal(
        com.google.cloud.datacatalog.v1.UsageSignal.Builder builderForValue) {
      if (usageSignalBuilder_ == null) {
        usageSignal_ = builderForValue.build();
      } else {
        usageSignalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    public Builder mergeUsageSignal(com.google.cloud.datacatalog.v1.UsageSignal value) {
      if (usageSignalBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && usageSignal_ != null
            && usageSignal_ != com.google.cloud.datacatalog.v1.UsageSignal.getDefaultInstance()) {
          getUsageSignalBuilder().mergeFrom(value);
        } else {
          usageSignal_ = value;
        }
      } else {
        usageSignalBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    public Builder clearUsageSignal() {
      bitField0_ = (bitField0_ & ~0x00200000);
      usageSignal_ = null;
      if (usageSignalBuilder_ != null) {
        usageSignalBuilder_.dispose();
        usageSignalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    public com.google.cloud.datacatalog.v1.UsageSignal.Builder getUsageSignalBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getUsageSignalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    public com.google.cloud.datacatalog.v1.UsageSignalOrBuilder getUsageSignalOrBuilder() {
      if (usageSignalBuilder_ != null) {
        return usageSignalBuilder_.getMessageOrBuilder();
      } else {
        return usageSignal_ == null
            ? com.google.cloud.datacatalog.v1.UsageSignal.getDefaultInstance()
            : usageSignal_;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource usage statistics.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.UsageSignal,
            com.google.cloud.datacatalog.v1.UsageSignal.Builder,
            com.google.cloud.datacatalog.v1.UsageSignalOrBuilder>
        getUsageSignalFieldBuilder() {
      if (usageSignalBuilder_ == null) {
        usageSignalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.UsageSignal,
                com.google.cloud.datacatalog.v1.UsageSignal.Builder,
                com.google.cloud.datacatalog.v1.UsageSignalOrBuilder>(
                getUsageSignal(), getParentForChildren(), isClean());
        usageSignal_ = null;
      }
      return usageSignalBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00400000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00400000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00400000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 14;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00400000;
      return this;
    }

    private com.google.cloud.datacatalog.v1.DataSource dataSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataSource,
            com.google.cloud.datacatalog.v1.DataSource.Builder,
            com.google.cloud.datacatalog.v1.DataSourceOrBuilder>
        dataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataSource field is set.
     */
    public boolean hasDataSource() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataSource.
     */
    public com.google.cloud.datacatalog.v1.DataSource getDataSource() {
      if (dataSourceBuilder_ == null) {
        return dataSource_ == null
            ? com.google.cloud.datacatalog.v1.DataSource.getDefaultInstance()
            : dataSource_;
      } else {
        return dataSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataSource(com.google.cloud.datacatalog.v1.DataSource value) {
      if (dataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSource_ = value;
      } else {
        dataSourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataSource(
        com.google.cloud.datacatalog.v1.DataSource.Builder builderForValue) {
      if (dataSourceBuilder_ == null) {
        dataSource_ = builderForValue.build();
      } else {
        dataSourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataSource(com.google.cloud.datacatalog.v1.DataSource value) {
      if (dataSourceBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && dataSource_ != null
            && dataSource_ != com.google.cloud.datacatalog.v1.DataSource.getDefaultInstance()) {
          getDataSourceBuilder().mergeFrom(value);
        } else {
          dataSource_ = value;
        }
      } else {
        dataSourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataSource() {
      bitField0_ = (bitField0_ & ~0x00800000);
      dataSource_ = null;
      if (dataSourceBuilder_ != null) {
        dataSourceBuilder_.dispose();
        dataSourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DataSource.Builder getDataSourceBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DataSourceOrBuilder getDataSourceOrBuilder() {
      if (dataSourceBuilder_ != null) {
        return dataSourceBuilder_.getMessageOrBuilder();
      } else {
        return dataSource_ == null
            ? com.google.cloud.datacatalog.v1.DataSource.getDefaultInstance()
            : dataSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Physical location of the entry.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataSource,
            com.google.cloud.datacatalog.v1.DataSource.Builder,
            com.google.cloud.datacatalog.v1.DataSourceOrBuilder>
        getDataSourceFieldBuilder() {
      if (dataSourceBuilder_ == null) {
        dataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DataSource,
                com.google.cloud.datacatalog.v1.DataSource.Builder,
                com.google.cloud.datacatalog.v1.DataSourceOrBuilder>(
                getDataSource(), getParentForChildren(), isClean());
        dataSource_ = null;
      }
      return dataSourceBuilder_;
    }

    private com.google.cloud.datacatalog.v1.PersonalDetails personalDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PersonalDetails,
            com.google.cloud.datacatalog.v1.PersonalDetails.Builder,
            com.google.cloud.datacatalog.v1.PersonalDetailsOrBuilder>
        personalDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the personalDetails field is set.
     */
    public boolean hasPersonalDetails() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The personalDetails.
     */
    public com.google.cloud.datacatalog.v1.PersonalDetails getPersonalDetails() {
      if (personalDetailsBuilder_ == null) {
        return personalDetails_ == null
            ? com.google.cloud.datacatalog.v1.PersonalDetails.getDefaultInstance()
            : personalDetails_;
      } else {
        return personalDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPersonalDetails(com.google.cloud.datacatalog.v1.PersonalDetails value) {
      if (personalDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        personalDetails_ = value;
      } else {
        personalDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPersonalDetails(
        com.google.cloud.datacatalog.v1.PersonalDetails.Builder builderForValue) {
      if (personalDetailsBuilder_ == null) {
        personalDetails_ = builderForValue.build();
      } else {
        personalDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePersonalDetails(com.google.cloud.datacatalog.v1.PersonalDetails value) {
      if (personalDetailsBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && personalDetails_ != null
            && personalDetails_
                != com.google.cloud.datacatalog.v1.PersonalDetails.getDefaultInstance()) {
          getPersonalDetailsBuilder().mergeFrom(value);
        } else {
          personalDetails_ = value;
        }
      } else {
        personalDetailsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPersonalDetails() {
      bitField0_ = (bitField0_ & ~0x01000000);
      personalDetails_ = null;
      if (personalDetailsBuilder_ != null) {
        personalDetailsBuilder_.dispose();
        personalDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.PersonalDetails.Builder getPersonalDetailsBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getPersonalDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.PersonalDetailsOrBuilder getPersonalDetailsOrBuilder() {
      if (personalDetailsBuilder_ != null) {
        return personalDetailsBuilder_.getMessageOrBuilder();
      } else {
        return personalDetails_ == null
            ? com.google.cloud.datacatalog.v1.PersonalDetails.getDefaultInstance()
            : personalDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information related to the entry. Private to the
     * current user.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.PersonalDetails,
            com.google.cloud.datacatalog.v1.PersonalDetails.Builder,
            com.google.cloud.datacatalog.v1.PersonalDetailsOrBuilder>
        getPersonalDetailsFieldBuilder() {
      if (personalDetailsBuilder_ == null) {
        personalDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.PersonalDetails,
                com.google.cloud.datacatalog.v1.PersonalDetails.Builder,
                com.google.cloud.datacatalog.v1.PersonalDetailsOrBuilder>(
                getPersonalDetails(), getParentForChildren(), isClean());
        personalDetails_ = null;
      }
      return personalDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.Entry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.Entry)
  private static final com.google.cloud.datacatalog.v1.Entry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.Entry();
  }

  public static com.google.cloud.datacatalog.v1.Entry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Entry> PARSER =
      new com.google.protobuf.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Entry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Entry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Entry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
